// ===========================================================================
//
// IRTC 'Gardens' - sundial.inc
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This file defines a sundial object. The construction of the object is
// controlled by the trace_sundial flag. Valid values for this flag are:
//
// Value   Effect
// ------ -------
//     0 - Don't define sundail
//     1 - Construct the sundial
//
// ===========================================================================

#if (trace_sundial > 0)
	#include "textures.inc"
	#include "metals.inc"

	//
	// Declare the mould that is taken from the basic block to create the
	// final sundial shape. We start at the bottom and work upwards.
	//
	// There are 15 individual parts to the mould.
	//

	#declare mould = difference
	{
		box
		{
			<-5, -10, -29>, <-35, 110, 29>
		}

		//
		// Part 1.
		//

		box
		{
			<0, 0, -30>, <-15, 10, 30>
		}

		//
		// Part 2.
		//

		box
		{
			<0, 10, -30>, <-12.5, 12, 30>
		}

		//
		// Part 3.
		//

		difference
		{
			box
			{
				<0, 12, -30>, <-12.5, 21, 30>
			}
			cylinder
			{
				<0, 0, -30>, <0, 0, 30>, 1
				scale <5, 9, 1>
				translate <-12.5, 21, 0>
			}
		}

		//
		// Part 4.
		//

		box
		{
			<0, 21, -30>, <-9, 24, 30>
		}

		//
		// Part 5.
		//

		union
		{
			box
			{
				<0, 24, -30>, <-8, 29, 30>
			}
			intersection
			{
				box
				{
					<100, 24, -30>, <-100, 29, 30>
				}
				cylinder
				{
					<0, 0, -30>, <0, 0, 30>, 1
					scale <3, 5, 1>
					translate <-8, 24, 0>
				}
			}
		}

		//
		// Part 6.
		//

		box
		{
			<0, 29, -30>, <-8, 30, 30>
		}

		//
		// Part 7.
		//

		union
		{
			box
			{
				<0, 30, -30>, <-8, 38, 30>
			}
			intersection
			{
				box
				{
					<100, 30, -30>, <-100, 38, 30>
				}
				cylinder
				{
					<0, 0, -30>, <0, 0, 30>, 1
					scale <7, 8, 1>
					translate <-8, 38, 0>
				}
			}
		}

		//
		// Part 8.
		//

		box
		{
			<0, 38, -30>, <-13, 40, 30>
		}

		//
		// Part 9.
		//

		difference
		{
			box
			{
				<0, 40, -30>, <-13, 80, 30>
			}
			cylinder
			{
				<0, 0, -30>, <0, 0, 30>, 1
				scale <6, 40, 1>
				translate <-13, 80, 0>
			}
		}

		//
		// Part 10.
		//

		box
		{
			<0, 80, -30>, <-9, 81, 30>
		}

		//
		// Part 11.
		//

		union
		{
			box
			{
				<0, 81, -30>, <-9, 85, 30>
			}
			cylinder
			{
				<-9, 83, -30>, <-9, 83, 30>, 2
			}
		}

		//
		// Part 12.
		//

		box
		{
			<0, 85, -30>, <-9, 89, 30>
		}

		//
		// Part 13.
		//

		box
		{
			<0, 89, -30>, <-10, 90, 30>
		}

		//
		// Part 14.
		//

		box
		{
			<0, 90, -30>, <-13, 92, 30>
		}

		//
		// Part 15.
		//

		box
		{
			<0, 92, -30>, <-15, 100, 30>
		}
	}

	#declare sundial_base = difference
	{
		box
		{
			<-20,0,-20>,<20,100,20>
		}

		object {mould}
		object {mould rotate y*90}
		object {mould rotate y*180}
		object {mould rotate y*270}

		texture
		{
			Headstone_texture
			normal
			{
				granite
			}
		}
	}

	//
	// Now we need to work on the face of the sundial. This is basically
	// a disk with some appropriate markings to show hours and half hours
	// and a gnomon to cast the shadow.
	//

	#declare line_thickness = 0.35;
	#declare ystart = 0;
	#declare yend = 1;
	#declare inner_ring_rad = 2.5;
	#declare mid_ring_rad = 8.5;
	#declare outer_ring_rad = 10;
	#declare latitude = 51;

	#declare inner_ring = difference
	{
		cylinder
		{
			<0, 0, 0>, <0, 1, 0>, inner_ring_rad + line_thickness
		}
		cylinder
		{
			<0, -1, 0>, <0, 2, 0>, inner_ring_rad
		}
	}

	#declare middle_ring = difference
	{
		difference
		{
			cylinder
			{
				<0, 0, 0>, <0, 1, 0>, mid_ring_rad + line_thickness
			}
			cylinder
			{
				<0, -1, 0>, <0, 2, 0>, mid_ring_rad
			}
		}
		box
		{
			<-50, -10, -50>, <50, 10, 0>
		}
	}

	#declare outer_ring = difference
	{
		cylinder
		{
			<0, 0, 0>, <0, 1, 0>, outer_ring_rad + line_thickness
		}
		cylinder
		{
			<0, -1, 0>, <0, 2, 0>, outer_ring_rad
		}
	}

	#declare six_oclock_line = box
	{
		<-outer_ring_rad, 0, -(line_thickness / 2)>,
		<outer_ring_rad, 1, line_thickness / 2>
	}

	#declare twelve_oclock_line = box
	{
		<-(line_thickness / 2), 0, 0>,
		<line_thickness / 2, 1, outer_ring_rad>
	}

	#declare hour_lines = difference
	{
		union
		{
			#local line_no = 0;

			#while (line_no < 5)
				#local t_angle = (line_no + 1) * 15;
				#local line_angle = degrees (atan2 ((tan (radians (t_angle)) * sin (radians (latitude))), 1));

				box
				{
					<-(line_thickness / 2), 0, 0>,
					<line_thickness / 2, 1, outer_ring_rad>
					rotate y*line_angle
				}

				box
				{
					<-(line_thickness / 2), 0, 0>,
					<line_thickness / 2, 1, outer_ring_rad>
					rotate y*-line_angle
				}

				#local line_no = line_no + 1;
			#end
		}
		cylinder
		{
			<0, -1, 0>, <0, 2, 0>, inner_ring_rad
		}
	}

	#declare half_hour_lines = difference
	{
		union
		{
			#local line_no = 0;

			#while (line_no < 6)
				#local t_angle = (line_no * 15) + 7.5;
				#local line_angle = degrees (atan2 ((tan (radians (t_angle)) * sin (radians (latitude))), 1));

				box
				{
					<-(line_thickness / 2), 0, 0>,
					<line_thickness / 2, 1, outer_ring_rad>
					rotate y*line_angle
				}

				box
				{
					<-(line_thickness / 2), 0, 0>,
					<line_thickness / 2, 1, outer_ring_rad>
					rotate y*-line_angle
				}

				#local line_no = line_no + 1;
			#end
		}
		cylinder
		{
			<0, -1, 0>, <0, 2, 0>, mid_ring_rad
		}
	}

	#declare sundial_marks = union
	{
		object
		{
			inner_ring
		}
		object
		{
			middle_ring
		}
		object
		{
			outer_ring
		}
		object
		{
			six_oclock_line
		}
		object
		{
			twelve_oclock_line
		}
		object
		{
			hour_lines
		}
		object
		{
			half_hour_lines
		}
	}

	#declare Time_0600 = "VI"  // x = 1.025
	#declare Time_0700 = "VII" // x = 1.355
	#declare Time_0800 = "IIX" // x = 1.355
	#declare Time_0900 = "IX"  // x = 1.019
	#declare Time_1000 = "X"   // x = 0.71
	#declare Time_1100 = "XI"  // x = 1.019
	#declare Time_1200 = "XII" // x = 1.355
	#declare Time_1300 = "I"   // x = 0.285
	#declare Time_1400 = "II"  // x = 0.62
	#declare Time_1500 = "III" // x = 0.95
	#declare Time_1600 = "IV"  // x = 1.025
	#declare Time_1700 = "V"   // x = 0.71
	#declare Time_1800 = "VI"  // x = 1.025

	//
	// We apply the marks by first removing the shapes from the dial, then
	// adding the shapes back...
	//

	#local zout = 10.75;
	#local letter_scale = 2.5;
	#local line_angle = degrees (atan2 ((tan (radians (45)) * sin (radians (latitude))), 1));

	#declare raw_sundial_disk = difference
	{
		union
		{
			cylinder
			{
				<0, -1, 0>, <0, 0, 0>, 12.9
			}
			cylinder
			{
				<0, -1, 0>, <0, -0.1, 0>, 13
			}
			torus
			{
				12.9, 0.1 translate <0, -0.1, 0>
			}
		}

		object
		{
			sundial_marks
			translate <0, -0.2, 0>
		}

		text
		{
			ttf "Times.ttf" Time_1200 0.4, 0
			translate <-(1.355/2),0,-0.2>
			rotate x*90
			scale <letter_scale,1,letter_scale>
			translate <0, 0, zout>
			rotate y*0
		}

		text
		{
			ttf "Times.ttf" Time_0600 0.4, 0
			translate <-(1.025/2),0,-0.2>
			rotate x*90
			scale <letter_scale,1,letter_scale>
			translate <0, 0, zout>
			rotate y*90
		}

		text
		{
			ttf "Times.ttf" Time_1800 0.4, 0
			translate <-(1.025/2),0,-0.2>
			rotate x*90
			scale <letter_scale,1,letter_scale>
			translate <0, 0, zout>
			rotate y*-90
		}

		text
		{
			ttf "Times.ttf" Time_0900 0.4, 0
			translate <-(1.019/2),0,-0.2>
			rotate x*90
			scale <letter_scale,1,letter_scale>
			translate <0, 0, zout>
			rotate y*-line_angle
		}

		text
		{
			ttf "Times.ttf" Time_1500 0.4, 0
			translate <-(0.95/2),0,-0.2>
			rotate x*90
			scale <letter_scale,1,letter_scale>
			translate <0, 0, zout>
			rotate y*line_angle
		}

		texture
		{
			pigment
			{
				granite
				color_map
				{
					[0.0 rgb <.6,.5,.3>]
					[0.5 rgb <.4,.2,.2>]
					[1.0 rgb <.5,.3,.1>]
				}
				scale .25
				turbulence .5
			}
			finish
			{
				phong .5
				phong_size 20
			}
			normal
			{
				bumps 1
				scale .005
			}
			scale 2
		}
	} // end of diff

	#declare sundial_disk = union
	{
		object
		{
			raw_sundial_disk
		}
		object
		{
			sundial_marks
			scale <1, 0.2, 1>
			translate <0, -0.19, 0>
			texture
			{
				pigment
				{
					P_Silver1 //P_Chrome3
				}
				finish
				{
					F_MetalB //F_MetalC
				}
			}
		}

		text
		{
			ttf "Times.ttf" Time_1200 0.4, 0
			translate <-(1.355/2),0,0.01>
			rotate x*90
			scale <letter_scale,1,letter_scale>
			translate <0, 0, zout>
			rotate y*0
			texture
			{
				pigment
				{
					P_Silver1 //P_Chrome3
				}
				finish
				{
					F_MetalB //F_MetalC
				}
			}
		}

		text
		{
			ttf "Times.ttf" Time_0600 0.4, 0
			translate <-(1.025/2),0,0.01>
			rotate x*90
			scale <letter_scale,1,letter_scale>
			translate <0, 0, zout>
			rotate y*90
			texture
			{
				pigment
				{
					P_Silver1 //P_Chrome3
				}
				finish
				{
					F_MetalB //F_MetalC
				}
			}
		}

		text
		{
			ttf "Times.ttf" Time_1800 0.4, 0
			translate <-(1.025/2),0,0.01>
			rotate x*90
			scale <letter_scale,1,letter_scale>
			translate <0, 0, zout>
			rotate y*-90
			texture
			{
				pigment
				{
					P_Silver1 //P_Chrome3
				}
				finish
				{
					F_MetalB //F_MetalC
				}
			}
		}

		text
		{
			ttf "Times.ttf" Time_0900 0.4, 0
			translate <-(1.019/2),0,0.01>
			rotate x*90
			scale <letter_scale,1,letter_scale>
			translate <0, 0, zout>
			rotate y*-line_angle
			texture
			{
				pigment
				{
					P_Silver1 //P_Chrome3
				}
				finish
				{
					F_MetalB //F_MetalC
				}
			}
		}

		text
		{
			ttf "Times.ttf" Time_1500 0.4, 0
			translate <-(0.95/2),0,0.01>
			rotate x*90
			scale <letter_scale,1,letter_scale>
			translate <0, 0, zout>
			rotate y*line_angle
			texture
			{
				pigment
				{
					P_Silver1 //P_Chrome3
				}
				finish
				{
					F_MetalB //F_MetalC
				}
			}
		}

	} // end of union

	#declare gnomon = difference
	{
		union
		{
			box
			{
				<-0.5, -2, -0.5>, <0.5, 10, 0.5>
			}

			difference
			{
				#declare clip_box = box
				{
					<-1, 0, 0>, <1, 20, -10>
					rotate x*20
					translate <0, 0, -0.5>
				}

				box
				{
					<-0.5, 0, -0.5>, <0.5, 5, 0.5>
				}
				object
				{
					clip_box
				}
				object
				{
					clip_box
					rotate y*90
				}
				object
				{
					clip_box
					rotate y*180
				}
				object
				{
					clip_box
					rotate y*270
				}

				translate <0, 10, 0>
			}

			rotate x*latitude
		}
		box
		{
			<-50, -50, -50>, <50, 0, 50>
		}
		texture
		{
			T_Gold_2C
		}
	}

	#declare sundial_top = union
	{
		object
		{
			sundial_disk
			translate <0, 101, 0>
		}
		object
		{
			gnomon
			translate <0, 101, 0>
		}
	}

	#declare sundial = union
	{
		object
		{
			sundial_base
		}
		object
		{
			sundial_top
			rotate y*-125
		}
	}
#end

