//
// Concrete garden: entry for the irtc, november-december 1999
// (c) 1999 by J. Berger
//
// clouds
#include "enter"

#ifndef (CLOUDS_INC)
  #declare CLOUDS_INC = 1 ;
  
  #include "metrics.inc"
  #include "bw.inc"
  #include "colors.inc"

  #declare Clouds = box {
    <-10*km, 200*m, -10*km>, <10*km, 230*m, 10*km>
    pigment { rgbf 1 }
    hollow
    interior {
      media {
	scattering { 3, rgb 1/4096 }
	density {
	  bozo
	  color_map {
	    /*[ 0.0 rgb 1.0 ]
	    [ 0.2 rgb 1.0 ]
	    [ 0.2 rgb 0.0 ]
	    [ 0.8 rgb 0.0 ]
	    [ 0.8 rgb 1.0 ]
	    [ 1.0 rgb 1.0 ]*/
	    [ 0.00 rgb 1.0 ]
	    [ 0.50 rgb 0.9 ]
	    [ 0.55 rgb 0.0 ]
	    [ 1.00 rgb 0.0 ]
	  }
	  warp { turbulence 1.5 lambda 3 omega 0.6 }
	  scale 256*m/2
	}
	method 3
	intervals 1
	samples 15, 5000
	//aa_level 5
	jitter 0
      }
    }
  }
  
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    background { color bwcol (Blue/2+White/2) }
    camera {
      location <0, 1, -40>*m
      look_at  <0, 1, 0>*m
      angle 40
    }
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, 1000>*m
      color rgb 1/4
    }
    plane {
      y, 0
      pigment { color rgb <0, 1, 0> }
    }
    object {
      Clouds
    }
  #end
#end

#include "leave"
