//
// Concrete garden: entry for the irtc, november-december 1999
// (c) 1999 by J. Berger
//
// houses
#include "enter"

#ifndef (HOUSE1_INC)
  #declare HOUSE1_INC = 1 ;
  
  #include "metrics.inc"
  #include "bw.inc"
  #include "jbgtext.inc"
  #include "mwindow.pov"
  
  #local TTaggedWall = texture {
    material_map {
      gif "logo.gif"
      once
      texture {
	TConcrete
	scale 2*m
	translate 80*cm*z+50*cm*y
	rotate 90*y
	scale <1/1024, 1/300, 1>*1024/12/m
      }
      texture { 
	pigment { color Black }
	normal  { 
	  average
	  normal_map {
	    [ 0.5 bumps 1*cm scale 2*cm ]
	    [ 1.0 granite 0.05 scale 0.5*0.4*2*m ]
	  }
	}
	finish  { specular 1 roughness 0.01 }
	scale <1/1024, 1/300, 1>*1024/12/m
      }
      texture {
	pigment {
	  bozo
	  pigment_map {
	    [ 0.0 bozo color_map { [ 0.0 color bwcol (Green) ] [ 1.0 color bwcol (Red) ] } scale 0.5 ]
	    [ 0.5 bozo color_map { [ 0.0 color bwcol (Blue) ] [ 1.0 color bwcol (Green) ] } scale 0.5 ]
 	    [ 1.0 bozo color_map { [ 0.0 color bwcol (Red) ] [ 1.0 color bwcol (Blue) ] } scale 0.5 ]
	  }
	  sine_wave
	  scale 1*m
	}
	normal  { 
	  average
	  normal_map {
	    [ 0.5 bumps 1*cm scale 2*cm ]
	    [ 1.0 granite 0.05 scale 0.5*0.4*2*m ]
	  }
	}
	finish  { specular 1 roughness 0.01 }
	scale <1/1024, 1/300, 1>*1024/12/m
      }
    }
    scale <1024, 300, 1>/1024*12*m
    rotate -90*y
    translate -80*cm*z-50*cm*y
  }
  #declare House1 = union {
    difference {
      box { -<13, 1, 13>*m, <13, 13, 13>*m }
      box { -<12.5, 2, 12>*m, <12.5, 12.5, 12.5>*m texture { TInside } }
							    // side windows
      box { <11, 0.7, -0.5>*m, <14, 2.1, 0.5>*m translate 2.5*m*y }
      box { <11, 0.7, -0.5>*m, <14, 2.1, 0.5>*m translate 5*m*y }
      box { <11, 0.7, -0.5>*m, <14, 2.1, 0.5>*m translate 7.5*m*y }
      box { <11, 0.7, -0.5>*m, <14, 2.1, 0.5>*m translate 10*m*y }
      
                                                            // front windows
      #local i=0 ;
      #while (i<5)
        #local j=0 ;    
        #while (j<8)
          box { <-11.75+j*3, 0.7+i*2.5, 11>*m, <-9.25+j*3, 2.1+i*2.5, 14>*m }
          #local j = j + 1 ;
        #end
      #local i = i + 1 ;
      #end
    }
    box {						    // roof
      <-13.1, 12.9, -13.1>*m, <13.1, 13.2, 13.1>*m
      texture { TPaint }
    }
    
    union {
      #local i = 1 ;					    // floors
      #while (i<5)
	box {
	  -<12.7, 0.1, 12.7>*m, <12.7, 0, 12.7>*m
	  translate 2.5*m*i*y
	}
	#local i = i + 1 ;
      #end
							    // inside walls
      box { <9, -1, -12.7>*m, <9.5, 12.7, 12.7>*m }
      texture { TInside }
    }
							    // side windows
    #local i = 1 ;
    #while (i<5)
      object { 
        mWindow (1, 0.5*m, 1.4*m, 10*cm, 4*cm, 1*cm, 0, 0, 0, 0, 0, 1, 1, txtFen1, txtFen2, txtVit1)
        bounded_by { box { <-0.5, 0, 0>*m, <0.5, 1.4, 0.1>*m } }
        translate <0, 0.7+2.5*i, 12.6>*m
        rotate 90*y
      }
    #local i = i+1 ;
    #end 
                                                            // front windows
    #local mySeed = seed (1234) ;
    #local xL = 1.25*m ;
    #local yL = 1.4*m ;
    #local i=0 ;
    #while (i<5)
      union {
	#local j=0 ;    
	#while (j<8)
	  union {
	    object { mWindow (3,xL,yL,4*cm,10*cm,4*cm,1*cm,0,0,rand(mySeed)/2,0,0.5,0.1,txtFen1,txtFen2,txtVit1) translate 20*cm*z } 
	    object { mBalcony (1,xL+10*cm,yL/3,20*cm,2*cm,10*cm,5*cm,5,txtBalcon1) }
	    object { mWindowCase (4,    xL, yL, 10*cm, 15*cm, 10*cm,   10*cm, 0,     0,     10*cm,   10*cm,   TGrayStone, TSlate) }
	    //                    type, xF, yF, zF,    eF,    zRelief, eF2,   yToit, eToit, yBalcon, zBalcon, ... 
	    bounded_by { box { <-xL-15*cm, -10*cm, -22*cm> <xL+15*cm, yL+10*cm, 30*cm> } }
	    translate <-11.75+j*3+xL/m, 0.7+i*2.5, -13>*m                                                                          
	    rotate 180*y
	  }
	  #local j = j + 1 ;
	#end
	bounded_by { box { <-11.9, 0.6+i*2.5, 13.22>*m, <11.9, 2.2+i*2.5, 12.7>*m } }
      }
    #local i = i + 1 ;
    #end
                                           
    box {						    // top cabin
      <8, 12.5, 2>*m, <12, 15, 6>*m
      texture { TConcrete scale 2*m }
    }
    box {
      <7.9, 14.9, 1.9>*m, <12.1, 15.2, 6.1>*m
      texture { TPaint }
    }
							    // gutter
    union {
      union {
	cylinder { 50*cm*y, 13*y*m, 5*cm }
	#local i = 1 ;
	#while (i<13)
	  torus {
	    5*cm, 1*cm
	    translate i*m*y
	  }
	  #local i = i + 1 ;
	#end
	texture { TGutter }
      }
      difference {
	cylinder { -30*cm*y, 0, 5*cm }
	cylinder { -31*cm*y, 1*cm*y, 4.8*cm }
	texture { TGutter }
	translate 5*cm*x
	rotate 45*z
	translate <-5, 50, 0>*cm
      }
      translate 13.06*m*x+8*m*z
    }
    texture {
      radial
      texture_map {
	[ 0.25 TTaggedWall ]
	[ 0.25 TPaint ]
      }
      phase 0.25/2
    }
  }
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    background { color bwcol (Blue/2+White/2) }
    camera {
      location <0, 6, -40>*m
      look_at  <0, 6, 0>*m
      angle 40
      rotate -120*y
      translate -8*m*z-15*m*x
    }
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, 1000>*m
      color rgb 1/4
    }
    plane {
      y, 0
      pigment { color rgb <0, 1, 0> }
    }
    object {
      House1
    }
  #end
#end

#include "leave"