//
// Concrete garden: entry for the irtc, november-december 1999
// (c) 1999 by J. Berger
//
// houses
#include "enter"

#ifndef (HOUSE2_INC)
  #declare HOUSE2_INC = 1 ;
  
  #include "metrics.inc"
  #include "bw.inc"
  #include "jbgtext.inc"
  #include "mwindow.pov"
  
  #declare House2 = union {
    difference {
      box { -<11, 1, 7.5>*m, <11, 7.5, 7.5>*m }
      box { -<10.7, 2, 7.2>*m, <10.7, 7.3, 7.2>*m texture { TInside } }
      
							    // front windows
      #local i=0 ;
      #while (i<3)
        #local j=0 ;    
        #while (j<10)
          box { <-10.2+j*2.1, 0.7+i*2.5, -8>*m, <-8.8+j*2.1, 2.1+i*2.5, -7>*m }
          #local j = j + 1 ;
        #end
      #local i = i + 1 ;
      #end

      #local i=0 ;					    // side windows
      #while (i<3)
        #local j=0 ;    
        #while (j<7)
          box { <10, 0.7+i*2.5, -6.7+j*2>*m, <12, 2.1+i*2.5, -5.3+j*2>*m }
          #local j = j + 1 ;
        #end
      #local i = i + 1 ;
      #end
    }
    
    difference {
      union {
	mesh2 {						    // roof
	  vertex_vectors {
	    10,
	    <-11.2, 7.5, -7.7>*m, <-11.2, 7.5, 7.7>*m,	    // top of wall
	    <11.2, 7.5, -7.7>*m, <11.2, 7.5, 7.7>*m,
	    <-10, 10, -6.5>*m, <-10, 10, 6.5>*m,	    // top of top floor
	    <10, 10, -6.5>*m, <10, 10, 6.5>*m,
	    <-6, 12, 0>*m, <6, 12, 0>*m			    // very top
	  }
	  face_indices {
	    16,
	    <0, 1, 4>, <1, 4, 5>,			    // left top floor
	    <2, 3, 6>, <3, 6, 7>,			    // right top floor
	    <0, 2, 4>, <2, 4, 6>,			    // front top floor
	    <1, 3, 5>, <3, 5, 7>,			    // back top floor
	    <4, 5, 8>, <6, 7, 9>,			    // attic sides
	    <4, 6, 8>, <6, 8, 9>,			    // front attic
	    <5, 7, 8>, <7, 8, 9>,			    // back attic
	    <0, 1, 2>, <1, 2, 3>			    // ceiling
	  }
	}
	cylinder { <-11.2, 7.5, -7.7>*m, <-10, 10, -6.5>*m, 3*cm }
	cylinder { <-11.2, 7.5, 7.7>*m, <-10, 10, 6.5>*m, 3*cm }
	cylinder { <11.2, 7.5, -7.7>*m, <10, 10, -6.5>*m, 3*cm }
	cylinder { <11.2, 7.5, 7.7>*m, <10, 10, 6.5>*m, 3*cm }
        texture { TSlate }
      }
      #local j = 0 ;
      #while (j < 5)  
        box { <-0.55, -0.05, -1>*m, <0.55, 1.45, 2>*m translate <-5.05+j*2.5, 8, -11>*m rotate -90*y }
      #local j = j+1 ;
      #end

      #local j = 0 ;
      #while (j < 8)  
        box { <-0.55, -0.05, -1>*m, <0.55, 1.45, 2>*m translate <-8.75+j*2.5, 8, -7.6>*m }
      #local j = j+1 ;
      #end
    }
    
    intersection {					    // gutters
      box { <-11.27, 7.43, -7.77>*m, <11.27, 7.5, -7.63>*m }
      cylinder { <-11.3, 7.5, -7.7>*m, <11.3, 7.5, -7.7>*m, 7*cm }
      plane { x+z, 0 translate <11.2, 0, -7.7>*m }
      texture { TGutter rotate 90*z }
    }
    intersection {
      box { <11.13, 7.43, -7.77>*m, <11.27, 7.5, 7.77>*m }
      cylinder { <11.2, 7.5, -7.8>*m, <11.2, 7.5, 7.8>*m, 7*cm }
      plane { -x-z, 0 translate <11.2, 0, -7.7>*m }
      texture { TGutter rotate 90*x }
    }
    union {
      cylinder { <20, 740-5/sqrt(2), -20>*cm, <20, 750, -20>*cm, 5*cm }
      cylinder { <5, 50, -5>*cm, <5, 725+5/sqrt(2), -5>*cm, 5*cm }
      #local i = 1 ;
      #while (i<7.25)
	torus {
	  5*cm, 1*cm
	  translate <5, i*100, -5>*cm
	}
	#local i = i + 1 ;
      #end
      texture { TGutter }
      translate <11, 0, -7.5>*m
    }
    cylinder {
      <25-5/sqrt(2), 740-5/sqrt(2), -25+5/sqrt(2)>*cm,
      <10-5/sqrt(2), 725+5/sqrt(2), -10+5/sqrt(2)>*cm,
      5*cm
      texture { TGutter rotate -45*z rotate 45*y }
      translate <11, 0, -7.5>*m
    }
    difference {
      cylinder { -30*cm*y, 0, 5*cm }
      cylinder { -31*cm*y, 1*cm*y, 4.8*cm }
      texture { TGutter }
      translate 5*cm*x
      rotate 45*z
      translate <-5, 50, 0>*cm
      rotate 45*y
      translate <11.05, 0, -7.55>*m
    }
    
    union {						    // floors
      #local i = 1 ;
      #while (i < 3)
	box { -<10.8, 0.1, 7.3>*m, <10.8, 0.0, 7.3>*m translate 2.5*m*i*y }
	#local i = i + 1 ;
      #end
      texture { TInside }
    }
                                                            //  front windows
    #local mySeed = seed (1234) ;
    #local xL = 0.7*m ;
    #local yL = 1.4*m ;
    #local i=0 ;
    #while (i<3)
      union {
	#local j=0 ;
	#while (j<10)
	  union {
	    #if (rand(mySeed)>=0.15)
	      object { mWindow (2,xL,yL,4*cm,5*cm,4*cm,1*cm,1,2,rand(mySeed)*80,rand(mySeed)*80,20*cm,2*cm,txtFen1,txtFen2,txtVit1) translate 40*cm*z } 
	      object { mShutter (4,    xL,  yL, 2*cm, 4*cm, 20,  45,     90-10*rand(mySeed), 90-10*rand(mySeed), 10*cm, 1*cm,  mySeed, 0.5*cm, txtV1) } 
	      //                 type, xV1, yV, zV,   eV,   nlV, tetalV, tetaVG,            tetaVD,              yGond, rGond, rd,     sRd,  textVolet
	    #else
	      object { mShutter (4,    xL,  yL, 2*cm, 4*cm, 20,  45,     5*rand(mySeed), 5*rand(mySeed), 10*cm, 1*cm,  mySeed, 0.5*cm, txtV1) } 
	      //                 type, xV1, yV, zV,   eV,   nlV, tetalV, tetaVG,         tetaVD,         yGond, rGond, rd,     sRd,    textVolet
	    #end
	    object { mBalcony (2,xL,yL/4,10*cm,2*cm,12*cm,0,3,txtBalcon1) translate 1*cm*z }
	    object { mWindowCase (3,    xL, yL, 10*cm, 20*cm, 10*cm,   20*cm, 0,     0,     30*cm,   13*cm,   TGrayStone, TSlate) translate -10*cm*z }
	    //                    type, xF, yF, zF,    eF,    zRelief, eF2,   yToit, eToit, yBalcon, zBalcon, ... 
	    bounded_by { box { <-xL-20*cm, -10*cm, -22*cm> <xL+20*cm, yL+20*cm, 30*cm> } }
	    translate <-10.2+j*2.1+xL/m, 0.7+i*2.5, -7.5>*m
	  }
	  #local j = j+1 ;
	#end
	bounded_by { box { <-10.4, 0.6+i*2.5, -7.72>*m, <10.3, 2.3+i*2.5, -7.2>*m } }
      }
      #local i = i+1 ;
    #end
                                                            //  side windows
    #local xL = 0.7*m ;
    #local yL = 1.4*m ;
    #local i=0 ;
    #while (i<3)
      union {
	#local j=0 ;
	#while (j<7)
	  union {
	    #if (rand(mySeed)>=0.15)
	      object { mWindow (2,xL,yL,4*cm,5*cm,4*cm,1*cm,1,2,rand(mySeed)*80,rand(mySeed)*80,20*cm,2*cm,txtFen1,txtFen2,txtVit1) translate 40*cm*z } 
	      object { mShutter (4,    xL,  yL, 2*cm, 4*cm, 20,  45,     90-10*rand(mySeed), 90-10*rand(mySeed), 10*cm, 1*cm,  mySeed, 0.5*cm, txtV1) } 
	      //                 type, xV1, yV, zV,   eV,   nlV, tetalV, tetaVG,            tetaVD,              yGond, rGond, rd,     sRd,  textVolet
	    #else
	      object { mShutter (4,    xL,  yL, 2*cm, 4*cm, 20,  45,     5*rand(mySeed), 5*rand(mySeed), 10*cm, 1*cm,  mySeed, 0.5*cm, txtV1) } 
	      //                 type, xV1, yV, zV,   eV,   nlV, tetalV, tetaVG,         tetaVD,         yGond, rGond, rd,     sRd,    textVolet
	    #end
	    object { mBalcony (2,xL,yL/4,10*cm,2*cm,12*cm,0,3,txtBalcon1) translate 1*cm*z }
	    object { mWindowCase (3,    xL, yL, 10*cm, 20*cm, 5*cm,   20*cm, 0,     0,     30*cm,   13*cm,   TGrayStone, TSlate) translate -10*cm*z }
	    //                    type, xF, yF, zF,    eF,    zRelief, eF2,   yToit, eToit, yBalcon, zBalcon, ... 
	    bounded_by { box { <-xL-20*cm, -10*cm, -22*cm> <xL+20*cm, yL+20*cm, 30*cm> } }
	    translate <-6.75+j*2+xL/m, 0.7+i*2.5, -11>*m
	    rotate -90*y
	  }
	  #local j = j+1 ;
	#end
	bounded_by { box { <11.22, 0.6+i*2.5, -6.95>*m, <10.7, 2.3+i*2.5, 6.85>*m } }
      }
      #local i = i+1 ;
    #end   
                                                            // roof windows
    #local xL = 0.5*m ;
    #local yL = 1.4*m ;
    #local j=0 ;
    #while (j<5)
      union {
        #if (rand(mySeed)>=0.15)
          object { mWindow (2,xL,yL,4*cm,5*cm,4*cm,1*cm,1,2,rand(mySeed)*80,rand(mySeed)*80,20*cm,2*cm,txtFen1,txtFen2,txtVit1) translate 40*cm*z } 
	  object { mShutter (4,    xL,  yL, 2*cm, 4*cm, 20,  45,     90-10*rand(mySeed), 90-10*rand(mySeed), 10*cm, 1*cm,  mySeed, 0.5*cm, txtV1) } 
	  //                 type, xV1, yV, zV,   eV,   nlV, tetalV, tetaVG,            tetaVD,              yGond, rGond, rd,     sRd,  textVolet
	#else
	  object { mShutter (4,    xL,  yL, 2*cm, 4*cm, 20,  45,     5*rand(mySeed), 5*rand(mySeed), 10*cm, 1*cm,  mySeed, 0.5*cm, txtV1) } 
	  //                 type, xV1, yV, zV,   eV,   nlV, tetalV, tetaVG,         tetaVD,         yGond, rGond, rd,     sRd,    textVolet
	#end
	object { mBalcony (2,xL,yL/4,10*cm,2*cm,12*cm,0,3,txtBalcon1) translate 1*cm*z }
	object { mWindowCase (7,    xL, yL, 1.2*m, 20*cm, 2*cm,    8*cm, 40*cm, 3*cm,  30*cm,   13*cm, TPeelPaint, TSlate) translate 10*cm*z }
        //                    type, xF, yF, zF,    eF,    zRelief, eF2,  yToit, eToit, yBalcon, zBalcon, ...                
        translate <-5.05+j*2.5, 8, -11.1>*m
        rotate -90*y
      }
      #local j = j+1 ;
    #end
    #local xL = 0.5*m ;
    #local yL = 1.4*m ;
    #local j=0 ;
    #while (j<8)
      union {
        #if (rand(mySeed)>=0.15)
          object { mWindow (2,xL,yL,4*cm,5*cm,4*cm,1*cm,1,2,rand(mySeed)*80,rand(mySeed)*80,20*cm,2*cm,txtFen1,txtFen2,txtVit1) translate 40*cm*z } 
	  object { mShutter (4,    xL,  yL, 2*cm, 4*cm, 20,  45,     90-10*rand(mySeed), 90-10*rand(mySeed), 10*cm, 1*cm,  mySeed, 0.5*cm, txtV1) } 
	  //                 type, xV1, yV, zV,   eV,   nlV, tetalV, tetaVG,            tetaVD,              yGond, rGond, rd,     sRd,  textVolet
	#else
	  object { mShutter (4,    xL,  yL, 2*cm, 4*cm, 20,  45,     5*rand(mySeed), 5*rand(mySeed), 10*cm, 1*cm,  mySeed, 0.5*cm, txtV1) } 
	  //                 type, xV1, yV, zV,   eV,   nlV, tetalV, tetaVG,         tetaVD,         yGond, rGond, rd,     sRd,    textVolet
	#end
	object { mBalcony (2,xL,yL/4,10*cm,2*cm,12*cm,0,3,txtBalcon1) translate 1*cm*z }
	object { mWindowCase (7,    xL, yL, 1.2*m, 20*cm, 2*cm,    8*cm, 40*cm, 3*cm,  30*cm,   13*cm, TPeelPaint, TSlate) translate 10*cm*z }
        //                    type, xF, yF, zF,    eF,    zRelief, eF2,  yToit, eToit, yBalcon, zBalcon, ...                
        translate <-8.75+j*2.5, 8, -7.6>*m
      }
      #local j = j+1 ;
    #end
    
    texture { TPeelPaint translate -50*cm*x }
  }
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    background { color bwcol (Blue/2+White/2) }
    camera {
      location <0, 5, -40>*m
      look_at  <0, 5, 0>*m
      angle 40
      rotate -90*y
    }
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, 1000>*m
      color rgb 1/4
    }
    plane {
      y, 0
      pigment { color rgb <0, 1, 0> }
    }
    object {
      House2
    }
  #end
#end

#include "leave"