//
// Concrete garden: entry for the irtc, november-december 1999
// (c) 1999 by J. Berger
//
// textures
#include "enter"

#ifndef (JBGTEXT_INC)
  #declare JBGTEXT_INC = 1 ;
  
  #include "bw.inc"
  #include "colors.inc"
  
  #declare TConcrete = texture {
    pigment {
      average
      pigment_map {
        [ 1.0 gradient y
              color_map {
                [ 0.000 color rgb 0.80 ]
                [ 0.875 color rgb 0.70 ]
                [ 1.000 color rgb 0.40 ]
              }
              turbulence 0.1 ]
        [ 1.0 gradient y
              color_map {
                [ 0.000 color rgb 0.80 ]
                [ 0.875 color rgb 0.70 ]
                [ 1.000 color rgb 0.40 ]
              }
              turbulence 0.1
              translate 0.5 ]
      }      
    }
    normal { granite 0.05 scale 0.5 }
    finish { specular 0.1 roughness 4 brilliance 0.8 }
    scale 0.4
  } 
  texture {
    pigment {
      gradient y
      pigment_map {
        [ 0.0 color rgb 0 transmit 1 ]
        [ 0.1 color rgb 0 transmit 1 ]
        [ 1.0 bozo
              color_map {
                [ 0.0 color rgb 0 transmit 1.00 ]
                [ 0.6 color rgb 0 transmit 1.00 ]
                [ 0.9 color rgb 0 transmit 0.75 ]
                [ 1.0 color rgb 0 transmit 0.50 ]
              }
              frequency 1.1
              scale <0.1, 1.0, 0.1> ]
      }
      turbulence 0.1
    }
    normal { granite 0.05 scale 0.5 }
    finish { specular 0.1 roughness 4 brilliance 0.8 }
    scale 0.4
  }
  texture {
    pigment {
      gradient y
      pigment_map {
        [ 0.0 color rgb 0 transmit 1 ]
        [ 0.1 color rgb 0 transmit 1 ]
        [ 1.0 bozo
              color_map {
                [ 0.0 color rgb 0 transmit 1.00 ]
                [ 0.6 color rgb 0 transmit 1.00 ]
                [ 0.9 color rgb 0 transmit 0.75 ]
                [ 1.0 color rgb 0 transmit 0.50 ]
              }
              frequency 1.1
              scale <0.1, 1.0, 0.1> ]
      } 
      turbulence 0.1
      translate 0.5
    }
    normal { granite 0.05 scale 0.5 }
    finish { specular 0.1 roughness 4 brilliance 0.8 }
    scale 0.4
  } // end TConcrete

  #local NBasicPeel = normal {
    granite 0.3
    slope_map {
      [ 0.00 <0.00,0>]
      [ 0.10 <0.10,0>]
      [ 0.15 <0.70,0>]
      [ 0.20 <0.75,0>]
      [ 0.21 <1.00,0>]
      [ 0.25 <0.80,0>]
      [ 0.70 <0.40,0>]
      [ 1.00 <0.70,0>]
    }
  }
  
  #declare TPeelPaint = texture {
    pigment {
      granite
      color_map{
        /*[ 0.10 rgb <0.75, 0.7, 0.5> ]
        [ 0.18 rgb <0.85, 0.8, 0.6> ]
        [ 0.20 rgb <0.75, 0.7, 0.5> ]
        [ 0.21 rgb <1.0, 1.0, 1.0> ]
        [ 1.00 rgb <0.8, 0.8, 0.8> ]*/
        [ 0.10 color bwcol (<0.50, 0.50, 0.40>) ]
        [ 0.18 color bwcol (<0.75, 0.75, 0.70>) ]
        [ 0.20 color bwcol (<0.75, 0.75, 0.70>) ]
        [ 0.21 color bwcol (<0.90, 0.79, 0.70>) ]
        [ 1.00 color bwcol (<0.90, 0.79, 0.70>) ]
      }
    }
    normal { NBasicPeel } 
    finish { specular 0.1 roughness 1 brilliance 0.9 }
    scale 6*m
  } 
  
  #declare TPaint = texture { 
    pigment { 
      crackle
      scale 0.6
      color_map {
        [ 0.00 rgb 0.85 ]
        [ 0.03 color bwcol(<0.9, 0.9, 0.7>) ]
      }
      turbulence 0.1
    }
    finish { specular 0.1 roughness 1 brilliance 0.9 }
    normal {
      average
      normal_map {
        [ 1.0 
          crackle -2.0
          scale 0.6
          slope_map {
            [ 0.00 <1.0, 0.0> ]
            [ 0.03 <1.0,-0.5> ]
            [ 0.05 <0.0,-0.0> ]
            [ 1.00 <0.0, 0.0> ]
          }
          turbulence 0.1
        ]
        [ 1.0
          granite 0.2
          scale 0.5
        ]
      } 
    }
    scale 1*m
  } 
  
  #declare TGrayStone = texture {
    pigment {
      crackle
      color_map {
        [ 0.00 rgb 0.2 ]
        [ 0.02 rgb 0.2 ]
        [ 0.05 rgb 0.6 ]
        [ 1.00 rgb 0.6 ]
      }                
      turbulence 0.1
    }
    normal {
      crackle 2.0
      slope_map {
        [ 0.00 <0.00, 0.0> ]
        [ 0.03 <0.00, 0.0> ]
        [ 0.03 <0.03, 1.0> ]
        [ 1.00 <1.00, 1.0> ]
      }
      turbulence 0.1
    }
    finish { specular 0.3 roughness 0.1 brilliance 0.9 } 
    scale 5*cm
  }
  
  #declare TSlate = texture {
    pigment { color bwcol(DarkSlateGray) }
    normal { bumps 0.5 scale <1, 20, 1>*cm }
    finish { specular 0.1 roughness 0.5 }
  }
  
  #declare txtFen1 = texture { // window frame
    pigment {
      granite
      color_map {
	[ 0.18 color bwcol (<0.90, 0.79, 0.72>) ]
	[ 0.20 color bwcol (ForestGreen*0.3) ]
	[ 0.21 color bwcol (ForestGreen) ]
      }
    }
    normal { NBasicPeel }
    finish { specular 0.1 roughness 1 brilliance 0.9 }
    scale 2*cm
  }
  #declare txtFen2 = texture { 
    pigment { White }
    normal {
      granite 0.2
      slope_map {
	[ 0.00 <0.7, 0> ]
	[ 0.25 <0.8, 0> ]
	[ 0.70 <0.4, 0> ]
	[ 1.00 <0.7, 0> ]
      }
    }
    finish { specular 0.1 roughness 1 brilliance 0.9 }
    scale 2*cm
  }	    // window frame
  #declare txtVit1 = texture{				    // window glass
    pigment { color bwcol (<0.8, 0.9, 0.85>) filter 0.85 }
    normal { bumps 0.004 scale 1*cm }
    finish {
      specular 1
      roughness 0.001
      reflection 0.25
      ambient 0
      diffuse 0
    }
  }
  
  #declare TInside = texture {
    pigment { color bwcol (<0.8, 0.8, 0.6>) }
    normal { bumps 0.1 scale <1, 100, 1>*cm }
    finish { specular 0.1 roughness 0.001 ambient 0 }
  }
  
  #declare txtBalcon1 = texture { 
    pigment {
      granite
      color_map {
	[ 0.18 color bwcol (<0.72, 0.37, 0.12>) ]
	[ 0.20 color bwcol (ForestGreen*0.2) ]
	[ 0.21 color bwcol (ForestGreen*0.6) ]
      }
    }
    normal { NBasicPeel }
    finish { specular 0.1 roughness 1 brilliance 0.9 }
    scale 2*cm
  }	// balcony bars
  #declare txtV1 = texture { 
    pigment {
      granite
      color_map {
	[ 0.18 color bwcol (<0.90, 0.79, 0.72>) ]	
	[ 0.20 color bwcol (SkyBlue*0.5) ]
	[ 0.21 color bwcol (SkyBlue) ]
      }
    }
    normal { NBasicPeel }
    scale 6*cm
  }
  #declare txtV2 = texture {
    pigment { color bwcol (<1,0.8,0.5>) }
    normal  { 
      average
      normal_map {
	[ 0.5 bumps 0.1 scale 3*cm ]
	[ 1.0 
	  quilted 1.0 control0 1 control1 0
	  slope_map {
	    [ 0.0 <0.0,-1.0> ]
	    [ 1.0 <1.0, 0.0> ]
	  }
	  scale 5*cm
	]
      }
    }
    //finish { specular 0.1 roughness 1 brilliance 0.9 }
  }	    // shutters
  
  #declare PRust = pigment { color bwcol (<0.72, 0.37, 0.12>*0.75) }
  #declare NRust = normal  { granite 1 turbulence 0.2 scale 5*mm }
  #declare FRust = finish  { specular 0.1 roughness 0.001 brilliance 0.8 }
  #declare NLampMain = normal {
    granite 0.3
    slope_map {
      [ 0.00 <0.00,0>]
      [ 0.05 <0.10,0>]
      [ 0.10 <0.70,0>]
      [ 0.15 <0.75,0>]
      [ 0.16 <1.00,0>]
      [ 0.20 <0.80,0>]
      [ 0.70 <0.60,0>]
      [ 1.00 <0.70,0>]
    }
  }
  
  #declare TStreetLamp = texture {
    granite
    texture_map {
      [ 0.13
	pigment { PRust scale 1/(1*m) }
	normal {
	  average
	  normal_map {
	    [ 1.0 NRust scale 1/(1*m) ]
	    [ 1.0 NLampMain ]
	  }
	}
	finish { FRust }
      ]
      //[ 0.20 ]
      [ 0.16 
	pigment { color bwcol (<0.07, 0.33, 0.22>/3) }
	normal  { NLampMain }
	finish { specular 0.05 roughness 1 brilliance 0.9 }
      ]
    }
    scale 1*m
  }

  #declare TGrid = texture {
    granite
    texture_map {
      [ 0.13
	pigment { PRust scale 1/(1*m) }
	normal {
	  average
	  normal_map {
	    [ 1.0 NRust scale 1/(1*m) ]
	    [ 1.0 NLampMain ]
	  }
	}
	finish { FRust }
      ]
      [ 0.16 
	pigment { color bwcol (<0.02, 0.06, 0.09>) }
	normal  { NLampMain scale 1*m }
	finish { specular 0.05 roughness 1 brilliance 0.9 }
      ]
    }
    //warp { reset_children }
    scale 1*m
  }

  #declare TWhitePanel = texture {
    pigment {
      granite
      color_map {
	[ 0.15 color bwcol (<0.737, 0.518, 0.392>) ]
	[ 0.18 color rgb 0.9                       ]
      }
    }
    normal {
      granite 0.3
      slope_map {
	[ 0.00 <0.00,0>]
	[ 0.05 <0.10,0>]
	[ 0.10 <0.70,0>]
	[ 0.15 <0.75,0>]
	[ 0.16 <1.00,0>]
	[ 0.20 <0.80,0>]
	[ 0.70 <0.60,0>]
	[ 1.00 <0.70,0>]
      }
    }
    finish { specular 0.1 }
    scale <2*cm, 1*m, 2*cm>*5
  }
  #declare TBlackPanel = texture {
    pigment {
      granite
      color_map {
	[ 0.15 color bwcol (<0.737, 0.518, 0.392>) ]
	[ 0.18 color rgb 0.0                       ]
      }
    }
    normal {
      granite 0.3
      slope_map {
	[ 0.00 <0.00,0>]
	[ 0.05 <0.10,0>]
	[ 0.10 <0.70,0>]
	[ 0.15 <0.75,0>]
	[ 0.16 <1.00,0>]
	[ 0.20 <0.80,0>]
	[ 0.70 <0.60,0>]
	[ 1.00 <0.70,0>]
      }
    }
    finish { specular 0.1 }
    scale <2*cm, 1*m, 2*cm>*5
  }
  #declare TPanel = texture {
    boxed
    texture_map {
      [ 0.86 TWhitePanel ]
      [ 0.86 TBlackPanel ]
      [ 0.90 TBlackPanel ]
      [ 0.90 TWhitePanel ]
    }
    scale <2.6, 2.4, 2.6>*m
    warp { reset_children }
    translate 2.2*m*y+1*m*x
    rotate 10*z
    translate -1*m*x+1*m*y
    rotate 110*y
  }
  
  #declare TRing = texture {
    pigment { PRust }
    normal  { NRust }
    finish  { FRust }
  }

  #declare TGutter = texture {
    pigment { color rgb 0.658824 }
    finish {
      reflection 0.05
      brilliance 8
      specular 0.8
      roughness 0.1
    }
    normal { dents 0.5 }
    scale 2*cm
  }
  texture {
    pigment {
      bozo
      color_map {
	[ 0.3 color rgb 1             ]
	[ 0.3 color rgbt <0, 0, 0, 1> ]
      }
    }
    normal {
      bozo 0.5
    }
    finish { specular 0.01 }
    scale <1*cm, 2*m, 1*cm>/2
  }
  texture {
    pigment {
      dents
      color_map {
	[ 0.1 color rgbt 0.5          ]
	[ 0.1 color rgbt <0, 0, 0, 1> ]
      }
      turbulence 0.1
    }
    scale 10*cm
  }
    
#end

#include "leave"
