//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//Simple leaves - try the height_field leaves below for better looking;

 
#declare URBLATT=
sphere
{
	<0.5,0,0>,0.5
}

//Leaf with a tip
#declare LINDENBLATT=
sphere
{
	<0.8,0,-0.5>,1
	clipped_by
	{ 
		sphere
		{
			<0.8,0,0.5>,1
		}
	}
	scale <.6,.6,1>
}

//Bent leaf; a palmleaf for example
#declare PALMBLATT=
torus
{
	0.4,0.1
	rotate <90,0,0>
	clipped_by
	{
		sphere
		{
			<0,-.025,0>,0.51
			inverse
		}	
	}
	scale <1,1,15>
	translate <.5,0,0>
}

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//HEIGHT_FIELD LEAVES, much more realistic and beautiful than the other leaves here;
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
#declare HF_BODY= //This isn't a leaf already, only the body the following leaves are build with;
height_field
{
	tga "HF_LEAF.tga"
	smooth
	translate <0,0,-0.5>
}

//Universal rounded leaftype, good for palmleaves and of course normal leaves
#declare HF_LEAF1=
object
{
	HF_BODY	
	clipped_by
	{
		cylinder
		{
			<0.5,-1,0>,<0.5,2,0>,.5
			scale <.9,.975,.975>
		}
	} 
	scale 1.1
}   

//Like HF_LEAF1 but with a tip;
#declare HF_LEAF2=
object
{
	HF_BODY
	scale <1,1,.51>
	clipped_by
	{ 
		cylinder
		{
			<0,-1,0>,<0,2,0>,.6
			translate <0.5,0,.35>
			scale <1,1,1>
		} 
		cylinder
		{
			<0,-1,0>,<0,2,0>,.6
			translate <0.5,0,-.35>
			scale <1,1,1>
		}
	}   
	scale <1,1,2>
}                

//Leaf with five tips; like ivy;
#declare HF_LEAF3= 
union
{
#declare A=0;
#while (A<201)
object
{
	HF_LEAF2
	scale <1,1,.5>
	scale <sin(pi/4+(pi*A/400)),1,sin(pi/4+(pi*A/400))>
	rotate <0,-100+A,0>
}               
#declare A=A+50;
#end
}                  

//This leaf is built with several small leaves;
#declare HF_LEAF4= 
union
{
#declare A=0;
#while (A<201)
object
{
	HF_LEAF1 
	scale <.5/(sin(pi/4+pi*A/400)*sin(pi/4+pi*A/400)),.5,.2>
	rotate <0,-110+A*1.1,0>
	translate <.8-sin(pi/2+pi*A/200)*sin(pi/2+pi*A/200)*.8,sin(pi*A/100)*sin(pi*A/100),0>
}               
#declare A=A+20;
#end
scale <.75,1,.65>
} 

//Universal blossom, like an orchid but with five blossomleaves;
#declare HF_BLOS1= 
union
{
#declare A=0;
#while (A<360)
	object
	{
		HF_BODY	
		clipped_by
		{
			cylinder
			{
				<0.4,-1,0>,<0.4,2,0>,.4
				translate <0,0,0>			
			}
		}
		scale <.85,1,.5>
		rotate <0,A,0>
	}               
	#declare A=A+72;
	#end
	rotate <0,0,-90>
}      




//XXXXXXXXXXXXXXXXXXXXX E I N S T E L L U N G E N - S E T T I N G S XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//LEAF
#declare LEAF_TYPE=URBLATT//Name of leaf, you find in TOMLEAF.inc: Simple URBLATT,LINDENBLATT,PALMBLATT or take better HF-leaves - or - create your own
#declare LEAF_LENGTH=8;//Length of leaf (I recommend, you imagine a tree with real dimensions, in cm);
#declare LEAF_BREADTH=6;//Width of leaf (I recommend, you imagine a tree with real dimensions, in cm);
#declare LEAF_THICKNESS=0.5;//Height of leaf (in cm; normally a leaf is very thin; but at leaves like a palmleaf it means the height of arch; 
#declare MAX_LEAF_TILT=15;//Tilt of leaf (in degree; this is the amplitude, I have build in a scope);
#declare MAX_LEAF_TURN=15;//Turn of leaf (in degree; this is the amplitude, I have build in a scope);
#declare MAX_LEAF_INCLINATION=15;//Inclination of leaf (in degree; this is the amplitude, I have build in a scope);
//BLOSSOM
#declare BLOSSOM=HF_BLOS1//Name of blossom;
#declare MAX_BLOSSOM_LENGTH=7;//Length of blossom
#declare MAX_BLOSSOM_WIDTH=10;//Width of blossom
//#declare BLOSSOM_COLOR=<1,0,0>;//Color of blossom
//BUNCH
#declare BUNCH_MAJOR_RADIUS=5;//Inner radius of bunches in cm; distance of the innermost leaf of a bunch from the twig
#declare BUNCH_MINOR_RADIUS=5;//Outer radius of bunches in cm; distance of the innermost leaf from the outermost leaf of a bunch
#declare HORIZONTAL_BUNCH_FUNNEL=120;//Horizontal opening of bunch in degree
#declare VERTICAL_BUNCH_FUNNEL=120;//Vertical opening of bunch in degree
#declare HORIZONTAL_BUNCH_INCLINATION=100;//Horizontal inclination of whole bunch from twig alignment in degree;
#declare VERTICAL_BUNCH_INCLINATION=100;//Vertical inclination of whole bunch from twig alignment in degree;
#declare HORIZONTAL_BUNCH_INCLINATION_SCOPE=30;//Scope of horizontal inclination in degree 
#declare VERTICAL_BUNCH_INCLINATION_SCOPE=30;//Scope of vertical inclination in degree
#declare BUNCH_TURN_SWITCH=1;//To turn on (1) or turn off (0) the rotation of the bunch around the twig 
#declare BUNCH_ALTERNATE_SWITCH=1;//Here you can decide if bunches should alternate reciprocal at the twig (1=yes;0=no)
#declare BUNCH_INCLINATION_SWITCH=1;//To align (1) or not (0) the bunch with the twig to the end of the twig; horizontal... 
#declare VERTICAL_BUNCH_INCLINTION_SWITCH=1;//...and vertical 
#declare BUNCH_TAPER_OFF_AT_BRANCH=0.0;//Adjustment to decrease the size of the outer bunches/twigs at the branch
#declare BUNCH_TAPER_OFF_AT_TREE=0.0;//Adjustment to decrease the size of the bunches at the top of the tree
#declare BUNCH_DEFORM=<1,1,1>;//Simple scale of the whole bunch
//TWIG
#declare BUNCH_START_AT_BRANCH=15;//Distance from the branch to the first bunch at the twig
#declare TWIG_LENGTH=25;//The length of the twig;
#declare TWIG_STRENGTH=1.75;//Fullness of twig; 0=no twig; decrease this value for saving parsingtime or increase it if the twig falls in pieces 
#declare TWIG_THICKNESS_CHANGE=.1;//Use this factor to change the thickness of the twig, that normally(1) depends on the thickness of the branch
#declare HORIZONTAL_TWIG_INCLINATION=60;//Horizontal inclination of twig with bunches to the branch in degree
#declare VERTICAL_TWIG_INCLINATION=60;//Vertical inclination of twig with bunches to the branch in degree
#declare HORIZONTAL_TWIG_INCLINATION_SCOPE=20;//Scope of horizontal inclination in degree  
#declare VERTICAL_TWIG_INCLINATION_SCOPE=20;//Scope of vertical inclination in degree
#declare TWIG_INCLINATION_SWITCH=1;//To align(1) or not(0) the twig/bunches with the branch to the end of the branch horizontal...
#declare VERTICAL_TWIG_INCLINATION_SWITCH=1;//...and vertical 
#declare TWIG_TURN_SWITCH=0;//To turn on (1) or turn off (0) the rotation of the twig around its longitudinal axis
#declare TWIG_ALTERNATE_SWITCH=1;//here you can decide if twigs should alternate reciprocal at the branch (1=yes;0=no) and don't turn aroung the branch
#declare TWIG_CURVE_ADJUSTMENT=.5;//Here you can reduce (or increase) the curves of the twig which normally(1) depends on the curves of the branch
//BRANCH
#declare TWIG_START_AT_BRANCH=10;//Distance from the first/innermost twig at the branch to the trunk
#declare TWIG_RANGE_AT_BRANCH=5;//Distance from the innermost to the outermost twig at the branch
#declare BRANCH_THICKNESS_CHANGE=1;//Factor for changing the thickness of the branch that normally(1) depends on the thickness of the trunk 
#declare BRANCH_STRENGTH=1.75;//decrease this strength of branch to save parsingtime or increase it if the branch falls in pieces; 
#declare BRANCH_BEND=10;//Width of the outer bend of the branch
#declare BRANCH_BEND_FREQUENCY=3;//Frequency of the outer bend of the branch
#declare HORIZONTAL_BRANCH_BEND_SWITCH=1;//switch on (1) or off (0) the horizontal outer bend 
#declare BRANCH_CURVE=2;//Width of the inner bend that fit into the outer bend of the branch
#declare BRANCH_CURVE_FREQUENCY=3;//Frequency of the inner bend of the branch 
#declare HORIZONTAL_BRANCH_CURVE_SWITCH=0;//switch on (1) or off (0) the horizontal inner bend 
#declare BRANCH_LONGITUDINAL_CURVE=1;//To adjust the curves along the longitudinal axis of the branch; 0=no inner bend in longitudinal direction; 1=equal to lateral direction
#declare BRANCH_SNAG=3;//Width of the innermost bend (knots, gnarled) of the branch - fit into inner bend
#declare BRANCH_SNAG_FREQUENCY=3;//Frequency of the innermost bend
#declare BRANCH_REDUCTION=0.0;//This reduces the length of branches towards the top of the trunk (1=highest branch is 0 cm)(0=same length of highest and lowest branch) 
#declare BRANCH_TAPER_OFF=1;//Adjustment, how fast the thickness of the branch goes to 0 towards its end
#declare BRANCH_END=0;//If you want that the branch ends at the outermost twig than set to 0; if you set it to 1, the branch ends one twiglength after the last twig 
#declare BRANCH_TURN_SWITCH=0;//Switch on (1) or off (0) the turn of the branches around its longitudinal axis
#declare BRANCH_ALTERNATE_SWITCH=1;//Here you decide, that branches alternate reciprocal at the trunk and don't turn around the trunk
#declare BRANCH_SPIRAL=10;//Additional spiral in the branch (in degree: 360 = turn around once) 
#declare BRANCH_INCLINATION=75;//Inclination of the lowest branch to the trunk (upwards the branches will align with the trunk automatically)
//TRUNK
#declare BRANCH_START_AT_TRUNK=1;//Distance from the ground to the first/lowest branch at the trunk
#declare BRANCH_RANGE_AT_TRUNK=2;//Distance from the first/lowest to the last/highest branch at the trunk
#declare TRUNK_RADIUS=5;//Radius of the trunkthickness
#declare TRUNK_STRENGTH=1;//Strength of the trunk; you can increase the value if the trunk falls in pieces to close the line
#declare TRUNK_BEND_X=0;//Width of bend in x-direction
#declare TRUNK_BEND_Z=0;//Width of bend in z-direction
#declare TRUNK_BEND_X_FREQUENCY=0;//Frequency of x-bend
#declare TRUNK_BEND_Z_FREQUENCY=0;//Frequency of z-bend
#declare TRUNK_CURVE=0;//Width of inner bend (fit into bend) of the trunk
#declare TRUNK_CURVE_FREQUENCY=0;//Frequency of inner bend
#declare TRUNK_SNAG=0;//Width of innermost bend of the trunk (fit into the inner bend)
#declare TRUNK_SNAG_FREQUENCY=0;//Frequency of the innermost bend
#declare TRUNK_SPIRAL=0;//Additional spiral of the trunk in degrees (360 = turn around once)
#declare TRUNK_TAPER_OFF=1;//How fast the thickness of the trunk decreases towards the top of the tree (1=no thickness at top of tree; 0=same thickness at bottom and top)
#declare TRUNK_LENGTHENING=0;//To make the trunk longer(cm); 0 means that the trunk ends at the highest branch;
#declare TRUNK_COLOR_1=<0.1,0.1,0.0>;//First color of the bark representing its "valleys"; value lower than 0 for more deep and width
#declare TRUNK_COLOR_2=<0.50,0.45,0.0>;//Second color of the bark representing its "ridges" and seems to be the color of the trunk 
#declare TRUNK_SCAR_WIDTH=1;//Width of grain of bark(cm)  
#declare TRUNK_SCAR_HEIGHT=1;//Height of grain of bark(cm)
#declare BARK_DEPTH=1;//Depth of gnarled bark (it's a value for normal{})
#declare PALM_TRUNK=0.4;//Makes a trunk with more heavy, regular knots, like a trunk of a palm (look at palm.inc) - it could be better
//ROOT
#declare ROOT_THICKNESS_CHANGE=1.25;//Change the thickness of the root that normally depends on the thickness of the trunk;
#declare ROOT_STRENGTH=.5;//Fullness of the roots; decrease this value to save parsingtime or increase it if the root falls in piesces; 
#declare ROOT_TURN_SWITCH=1;//Switch on (1) or off (0) the turn around the root around its longitudinal axis
#declare ROOT_LENGTH=0;//Length of the root
#declare ROOT_INCLINATION=0;//The inclination of the uppermost root to the trunk in degree; starts(0) at horizontale, increase downwards;
#declare ROOT_BEND=0;//Width of the bend of the root 
#declare ROOT_BEND_FREQUENCY=0;//Frequency of the bend
#declare ROOT_SNAG=0;//Width of the inner bend of the root 
#declare ROOT_SNAG_FREQUENCY=0;//Frequency of the inner bend
#declare ROOT_START_AT_TRUNK=0;//Height(cm) of the uppermost root at the trunk
//TREE
#if (!QuickBush)
  #declare BRANCHES_QUANTITY=8; //The quantity of all branches at the tree
  #declare TWIG_QUANTITY=8; //The quantity of all twigs at the tree (the quantity of twigs at the branch is ZWEIGZAHL/ASTZAHL)
  #declare BUNCHES_QUANTITY=32;//The quantity of all bunches at the tree (the quantity of bunches at the twig is STAUDENZAHL/ZWEIGZAHL)
  #declare LEAVES_QUANTITY=512; //The quantity of all leaves at the tree
  #declare ROOTS_QUANTITY=0; //The quantity of all roots at the tree
  #declare BLOSSOM_QUANTITY=32;
#else
  #declare BRANCHES_QUANTITY=2;
  #declare TWIG_QUANTITY=2;
  #declare BUNCHES_QUANTITY=4;
  #declare LEAVES_QUANTITY=16;
  #declare ROOTS_QUANTITY=0; //The quantity of all roots at the tree
  #declare BLOSSOM_QUANTITY=4;
#end
//#declare BRANCH_GAME=1917.3797;//Each value results in a new variation/arrangement of the equal branches and twigs/bunches - play with it! 
#declare ROOT_GAME=13;//The same for the roots

//COLOR OF THE FOLIAGE
#declare FOLIAGE_BASE_COLOR_1=<0.1,0.3,0>;//First color of the lower leaves
#declare FOLIAGE_BASE_COLOR_2=<0.1,0.4,0>;//Second color of the lower leaves
#declare FOLIAGE_TOP_COLOR_1=<0.1,0.3,0>;//First color of the upper leaves
#declare FOLIAGE_TOP_COLOR_2=<0.1,.4,0>;//Second color of the upper leaves
#declare FOLIAGE_COLOR_TURBULENCE=.5;//Turbulence of these colors
#declare FOLIAGE_COLOR_TRANSITION=0.5;//Where the changing of these colors should start in vertical direction; it's relative to the height of the tree (0.5 = height_of_tree/2)
#declare FOLIAGE_COLOR_TRANSITION_TURBULENCE=.5;//Turbulence in this changing of colors
#declare FOLIAGE_GLOSS=1.00;//If you want glossy leaves, set the value higher than 0 (like phong)

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

//english to german
#declare BLATT=LEAF_TYPE
#declare MAX_BLATTLAENGE=LEAF_LENGTH;
#declare MAX_BLATTBREITE=LEAF_BREADTH; 
#declare MAX_BLATTHOEHE=LEAF_THICKNESS;
#declare MAX_BLATTKIPPE=MAX_LEAF_TILT;
#declare MAX_BLATTDREH=MAX_LEAF_TURN;
#declare MAX_BLATTNEIGE=MAX_LEAF_INCLINATION; 
#declare BLUETE=BLOSSOM
#declare MAX_BLUETENLAENGE=MAX_BLOSSOM_LENGTH;
#declare MAX_BLUETENBREITE=MAX_BLOSSOM_WIDTH;
#declare BLUETENFARBE=BLOSSOM_COLOR;
#declare STAUDEN_MAJOR_RADIUS=BUNCH_MAJOR_RADIUS;
#declare STAUDEN_MINOR_RADIUS=BUNCH_MINOR_RADIUS;
#declare HORIZ_STAUDEN_TRICHTER=HORIZONTAL_BUNCH_FUNNEL;
#declare VERTIK_STAUDEN_TRICHTER=VERTICAL_BUNCH_FUNNEL;
#declare HORIZ_STAUDENNEIGUNG=HORIZONTAL_BUNCH_INCLINATION;
#declare VERTIK_STAUDENNEIGUNG=VERTICAL_BUNCH_INCLINATION;
#declare HORIZ_STAUDENNEIGUNGSSPIEL=HORIZONTAL_BUNCH_INCLINATION_SCOPE;
#declare VERTIK_STAUDENNEIGUNGSSPIEL=VERTICAL_BUNCH_INCLINATION_SCOPE;
#declare STAUDENDREHSCHALTER=BUNCH_TURN_SWITCH;
#declare STAUDENWECHSELSCHALTER=BUNCH_ALTERNATE_SWITCH;
#declare STAUDENNEIGUNGSSCHALTER=BUNCH_INCLINATION_SWITCH;
#declare VERTIK_STAUDENNEIGUNGSSCHALTER=VERTICAL_BUNCH_INCLINTION_SWITCH;
#declare STAUDENVERJUENGUNG_AM_AST=BUNCH_TAPER_OFF_AT_BRANCH;
#declare STAUDENVERJUENGUNG_AM_BAUM=BUNCH_TAPER_OFF_AT_TREE;
#declare STAUDEN_VERFORMUNG=BUNCH_DEFORM;
#declare STAUDENANSATZ=BUNCH_START_AT_BRANCH;
#declare ZWEIGLAENGE=TWIG_LENGTH;
#declare ZWEIGBLENDE=TWIG_STRENGTH;
#declare ZWEIGSTAERKE=TWIG_THICKNESS_CHANGE;
#declare HORIZ_ZWEIGNEIGUNG=HORIZONTAL_TWIG_INCLINATION;
#declare VERTIK_ZWEIGNEIGUNG=VERTICAL_TWIG_INCLINATION;
#declare HORIZ_ZWEIGNEIGUNGSSPIEL=HORIZONTAL_TWIG_INCLINATION_SCOPE;
#declare VERTIK_ZWEIGNEIGUNGSSPIEL=VERTICAL_TWIG_INCLINATION_SCOPE;
#declare ZWEIGNEIGUNGSSCHALTER=TWIG_INCLINATION_SWITCH;
#declare VERTIK_ZWEIGNEIGUNGSSCHALTER=VERTICAL_TWIG_INCLINATION_SWITCH;
#declare ZWEIGDREHSCHALTER=TWIG_TURN_SWITCH;
#declare ZWEIGWECHSELSCHALTER=TWIG_ALTERNATE_SWITCH;
#declare ZWEIG_KURVENAUSGLEICH=TWIG_CURVE_ADJUSTMENT;
#declare ZWEIGANSATZ=TWIG_START_AT_BRANCH;
#declare ZWEIGBEREICH=TWIG_RANGE_AT_BRANCH;
#declare ASTSTAERKE=BRANCH_THICKNESS_CHANGE;
#declare ASTBLENDE=BRANCH_STRENGTH;
#declare ASTBIEGUNG=BRANCH_BEND; 
#declare ASTBIEGUNGSFREQUENZ=BRANCH_BEND_FREQUENCY;
#declare HORIZ_ASTBIEGUNGSSCHALTER=HORIZONTAL_BRANCH_BEND_SWITCH;
#declare ASTWINDUNG=BRANCH_CURVE;
#declare ASTWINDUNGSFREQUENZ=BRANCH_CURVE_FREQUENCY;
#declare HORIZ_ASTWINDUNGSSCHALTER=HORIZONTAL_BRANCH_CURVE_SWITCH;
#declare AST_LAENGS_WINDUNG=BRANCH_LONGITUDINAL_CURVE;
#declare ASTKNORRE=BRANCH_SNAG;
#declare ASTKNORRENFREQUENZ=BRANCH_SNAG_FREQUENCY; 
#declare ASTVERKUERZUNG_AM_BAUM=BRANCH_REDUCTION;
#declare ASTVERJUENGUNG=BRANCH_TAPER_OFF;
#declare ASTENDUNG=BRANCH_END;
#declare ASTDREHSCHALTER=BRANCH_TURN_SWITCH; 
#declare ASTWECHSELSCHALTER=BRANCH_ALTERNATE_SWITCH;
#declare ASTSPIRALE=BRANCH_SPIRAL;
#declare ASTNEIGUNG=BRANCH_INCLINATION; 
#declare ASTANSATZ=BRANCH_START_AT_TRUNK; 
#declare ASTBEREICH=BRANCH_RANGE_AT_TRUNK;
#declare STAMMRADIUS=TRUNK_RADIUS;
#declare STAMMBLENDE=TRUNK_STRENGTH;
#declare STAMMBIEGUNG_X=TRUNK_BEND_X;
#declare STAMMBIEGUNG_Z=TRUNK_BEND_Z;
#declare ST_BIEGUNGSFREQUENZ_X=TRUNK_BEND_X_FREQUENCY;
#declare ST_BIEGUNGSFREQUENZ_Z=TRUNK_BEND_Z_FREQUENCY;
#declare STAMMWINDUNG=TRUNK_CURVE;
#declare STAMMWINDUNGSFREQUENZ=TRUNK_CURVE_FREQUENCY;
#declare STAMMKNORRE=TRUNK_SNAG;
#declare STAMMKNORRENFREQUENZ=TRUNK_SNAG_FREQUENCY;
#declare STAMMSPIRALE=TRUNK_SPIRAL;
#declare STAMMVERJUENGUNG=TRUNK_TAPER_OFF;
#declare STAMMVERLAENGERUNG=TRUNK_LENGTHENING;
#declare STAMM_FARBE_1=TRUNK_COLOR_1;
#declare STAMM_FARBE_2=TRUNK_COLOR_2;
#declare MASERUNG_WEITE=TRUNK_SCAR_WIDTH;
#declare MASERUNG_HOEHE=TRUNK_SCAR_HEIGHT;
#declare RINDENTIEFE=BARK_DEPTH;
#declare PALMSTAMM=PALM_TRUNK;
#declare WURZELSTAERKE=ROOT_THICKNESS_CHANGE;
#declare WURZELBLENDE=ROOT_STRENGTH;
#declare WURZELDREHSCHALTER=ROOT_TURN_SWITCH;
#declare WURZELLAENGE=ROOT_LENGTH;
#declare WURZELNEIGUNG=ROOT_INCLINATION;
#declare WURZELBIEGUNG=ROOT_BEND;
#declare WURZELBIEGUNGSFREQUENZ=ROOT_BEND_FREQUENCY;
#declare WURZELKNORRE=ROOT_SNAG;
#declare WURZELKNORRENFREQUENZ=ROOT_SNAG_FREQUENCY;
#declare WURZELANSATZ=ROOT_START_AT_TRUNK;
#declare ASTZAHL=BRANCHES_QUANTITY;
#declare ZWEIGZAHL=TWIG_QUANTITY;
#declare STAUDENZAHL=BUNCHES_QUANTITY;
#declare BLATTZAHL=LEAVES_QUANTITY;
#declare BLUETENZAHL=BLOSSOM_QUANTITY;
#declare WURZELZAHL=ROOTS_QUANTITY;
#declare AST_SPIEL=BRANCH_GAME;
#declare WURZEL_SPIEL=ROOT_GAME;
#declare BASIS_FARBE_1=FOLIAGE_BASE_COLOR_1;
#declare BASIS_FARBE_2=FOLIAGE_BASE_COLOR_2;
#declare KRONEN_FARBE_1=FOLIAGE_TOP_COLOR_1;
#declare KRONEN_FARBE_2=FOLIAGE_TOP_COLOR_2;
#declare VERWIRBELUNG=FOLIAGE_COLOR_TURBULENCE;
#declare UEBERGANG_BASIS_KRONE=FOLIAGE_COLOR_TRANSITION; 
#declare UEBERGANG_TURBULENZ=FOLIAGE_COLOR_TRANSITION_TURBULENCE;
#declare GLANZ=FOLIAGE_GLOSS;

#declare M_BL=MAX_BLATTLAENGE+0.000001;
#declare M_BH=MAX_BLATTHOEHE+0.000001; 
#declare M_BB=MAX_BLATTBREITE+0.000001;
#declare M_BN_X=MAX_BLATTKIPPE;
#declare M_BN_Y=MAX_BLATTDREH;
#declare M_BN_Z=MAX_BLATTNEIGE;
#declare M_BL_L=MAX_BLUETENLAENGE+0.000001;
#declare M_BL_B=MAX_BLUETENBREITE+0.000001;
#declare BL_F=BLUETENFARBE;
#declare S_MA_R=STAUDEN_MAJOR_RADIUS+0.000001;
#declare S_MI_R=STAUDEN_MINOR_RADIUS+0.000001;
#declare V_S_T=VERTIK_STAUDEN_TRICHTER; 
#declare H_S_T=HORIZ_STAUDEN_TRICHTER;
#declare BL_Z=BLUETENZAHL;
#declare BZ=BLATTZAHL;  
#declare SZ=STAUDENZAHL+1;
#declare ZWZ=ZWEIGZAHL+1;
#declare ZWEIGLAENGE=ZWEIGLAENGE+2;
#declare S_VJ_A=STAUDENVERJUENGUNG_AM_AST;
#declare S_VJ_B=STAUDENVERJUENGUNG_AM_BAUM;
#declare S_W_S=STAUDENWECHSELSCHALTER;
#declare S_VF=STAUDEN_VERFORMUNG;
#declare S_A=STAUDENANSATZ+0.000001;
#declare Z_A=ZWEIGANSATZ+0.000001; 
#declare Z_B=ZWEIGBEREICH+0.000001;
#declare H_S_N=HORIZ_STAUDENNEIGUNG; 
#declare V_S_N=VERTIK_STAUDENNEIGUNG;
#declare H_S_N_SP=HORIZ_STAUDENNEIGUNGSSPIEL; 
#declare V_S_N_SP=VERTIK_STAUDENNEIGUNGSSPIEL;
#declare S_NEIG=STAUDENNEIGUNGSSCHALTER;
#declare V_S_NEIG=VERTIK_STAUDENNEIGUNGSSCHALTER;
#declare S_DREH=STAUDENDREHSCHALTER;
#declare H_ZW_N=HORIZ_ZWEIGNEIGUNG; 
#declare V_ZW_N=VERTIK_ZWEIGNEIGUNG;
#declare H_ZW_N_SP=HORIZ_ZWEIGNEIGUNGSSPIEL; 
#declare V_ZW_N_SP=VERTIK_ZWEIGNEIGUNGSSPIEL;
#declare ZW_NEIG=ZWEIGNEIGUNGSSCHALTER;
#declare V_ZW_NEIG=VERTIK_ZWEIGNEIGUNGSSCHALTER;
#declare ZW_W_S=ZWEIGWECHSELSCHALTER;   
#declare ZW_DREH=ZWEIGDREHSCHALTER;
#declare AA=ASTANSATZ;
#declare AB=ASTBEREICH*((ASTZAHL+1)/ASTZAHL);
#declare BG_X=STAMMBIEGUNG_X;
#declare BG_Z=STAMMBIEGUNG_Z;
#declare FZ_X=ST_BIEGUNGSFREQUENZ_X; 
#declare FZ_Z=ST_BIEGUNGSFREQUENZ_Z;
#declare SW=STAMMWINDUNG;
#declare SWFZ=STAMMWINDUNGSFREQUENZ;
#declare KK=STAMMKNORRE;
#declare SKKFZ=STAMMKNORRENFREQUENZ;
#declare S_VL=STAMMVERLAENGERUNG;
#declare AW=ASTWINDUNG;
#declare A_KK=ASTKNORRE; 
#declare A_BG=ASTBIEGUNG;
#declare ABFZ=ASTBIEGUNGSFREQUENZ; 
#declare H_ABG_S=HORIZ_ASTBIEGUNGSSCHALTER;
#declare AKKFZ=ASTKNORRENFREQUENZ;
#declare AWFZ=ASTWINDUNGSFREQUENZ;
#declare ZW_L=ZWEIGLAENGE+S_MA_R+S_MI_R+0.01;
#declare AST_L=(Z_A+Z_B+ZW_L); 
#declare AST_ST=ASTSTAERKE;
#declare AST_VK=ASTVERKUERZUNG_AM_BAUM; 
#declare AST_VJ=ASTVERJUENGUNG; 
#declare AST_DREH=ASTDREHSCHALTER;
#declare A_W_S=ASTWECHSELSCHALTER;
#declare BH=(AA+AB+AST_L);
#declare B_F_1=BASIS_FARBE_1; 
#declare B_F_2=BASIS_FARBE_2;
#declare K_F_1=KRONEN_FARBE_1;  
#declare K_F_2=KRONEN_FARBE_2; 
#declare UE_B_K=UEBERGANG_BASIS_KRONE;
#declare UE_T=UEBERGANG_TURBULENZ;
#declare ST_F_1=STAMM_FARBE_1;
#declare ST_F_2=STAMM_FARBE_2;  
#declare ST_VJ=STAMMVERJUENGUNG;
#declare WA=WURZELANSATZ;
#declare W_BG=WURZELBIEGUNG; 
#declare WBFZ=WURZELBIEGUNGSFREQUENZ;
#declare W_KK=WURZELKNORRE;  
#declare WKKFZ=WURZELKNORRENFREQUENZ;
#declare W_ST=WURZELSTAERKE;  
#declare W_L=WURZELLAENGE+0.000001;
#declare W_DREH=WURZELDREHSCHALTER;
#declare ZW_VST=ZWEIGSTAERKE; 
#declare AST_E=ASTENDUNG;
#declare H_AW_S=HORIZ_ASTWINDUNGSSCHALTER; 
#declare A_L_W=AST_LAENGS_WINDUNG;
#declare ZW_K_A=ZWEIG_KURVENAUSGLEICH;


//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Persistence of Vision 3.1 Include File   XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// File: TOMTREE.inc                        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Desc: BAUMGENERATOR FR POVRAY           XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Date: 23.09.1999                         XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Auth: AUST                               XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
#declare TREE=		
union
{
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX L A U B XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  
	//STAUDENFORMUNG
	#declare STAUDE =
	union
	{ 
		#declare A=1;
		#while (A<100*BZ)// *BZ/SZ)
			object
			{
				BLATT
				scale <M_BL*(sin(A*511.73378)+4)/4,M_BH*(sin(A*331.16643)+4)/4,M_BB*(sin(A*117.99095)+4)/4>
				rotate <M_BN_X*sin(237.1111*A),0,M_BN_Z*(1+sin(719.31906*A))/2>
				rotate <0,M_BN_Y*sin(317.17754*A),0>
				translate <S_MA_R+(S_MI_R*(1+sin(578.92279*A))/2),0,0>
				rotate <0,0,V_S_T/2*sin(177.7391*A)>
				rotate <0,H_S_T/2*sin(211.3783*A),0>
			}
		#declare A=A+100*SZ;//BZ*SZ;
		#end
	}
	#declare A=1;
	#while (A<BH+2) 
		#declare B=1;
		#while (B<100)
			#declare C=1;
			#while (C<ZWEIGLAENGE)
				object
				{
					STAUDE
					//STAUDENSTELLUNG
					rotate <0,0,V_S_N_SP*sin(391.77*C*C)>+<0,0,(V_S_N-(V_S_N*C/ZWEIGLAENGE*V_S_NEIG))>
					rotate <0,H_S_N_SP*sin(437.77*C*C),0>+<0,(H_S_N-(H_S_N*C/ZWEIGLAENGE*S_NEIG)),0>*<0,(1-S_W_S)+S_W_S*sin((C/(ZWEIGLAENGE/(SZ/ZWZ))-1/(ZWEIGLAENGE/(SZ/ZWZ)))*pi-pi/2),0>
					rotate <1234*sin(1.77*C),0,0>*S_DREH
					rotate <1234*sin(1.77*A),0,0>*S_DREH
					scale 1/(1-B/100*AST_VK)
					scale S_VF*(1.01-S_VJ_B*B/100)			    
					rotate <0,0,90>
					translate <A_KK*sin(.05*AKKFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/7.31),A_KK*sin(.05*AKKFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/3.71),A_KK*sin(.05*AKKFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/9.17)>*((BH-(ZWEIGLAENGE*(BH/ZW_L)))/BH)*(ZW_L/BH)*ZW_K_A
					translate <AW*sin(.3*AWFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/17.3),AW*sin(.3*AWFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/21.1),AW*sin(.3*AWFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/33.9)>*((BH-(ZWEIGLAENGE*(BH/ZW_L)))/BH)*(ZW_L/BH)*ZW_K_A
					translate <A_BG*(sin(pi/2*ABFZ*2*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/BH-pi/2)+1),((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L)),1*A_BG*(sin(pi/2*ABFZ*2*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/BH-pi/2)+1)>*(ZW_L/BH)*<ZW_K_A,1,ZW_K_A> 
					rotate <0,1234*sin(1.77*A),0>*ZW_DREH
					rotate <0,0,-90>
					scale (1.01-S_VJ_A*A/BH)*BH/AST_L
					rotate <0,0,V_ZW_N_SP*sin(391.77*A*A)>+<0,0,(V_ZW_N-(V_ZW_N*A/BH*V_ZW_NEIG))>
					rotate <0,H_ZW_N_SP*sin(437.77*A*A),0>+<0,(H_ZW_N-(H_ZW_N*A/BH*ZW_NEIG)),0>*(ZW_W_S*sin((A/(BH/ZWZ*ASTZAHL)-1/(BH/ZWZ*ASTZAHL))*pi-pi/2))			
					rotate <1456*cos(AST_SPIEL*71.19/A)*(1-ZW_W_S),0,0>
					rotate <0,0,90>
					rotate <0,1234*sin(1.77*B),0>*(1-ZW_W_S)
		      rotate <0,-1234*sin(1.77*B),0>*AST_DREH// *(ZW_DREH+1)
		      //FUEHRUNG AM AST
					translate <A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/7.31),A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/3.71),A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/9.17)>*(BH-(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)))/BH
		  		translate <AW*sin(.3*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/17.3),AW*sin(.3*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/21.1),AW*sin(.3*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/33.9)>*((BH-(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)))/BH)*<1,A_L_W,H_AW_S>
					translate <A_BG*(sin(pi/2*ABFZ*3*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH-pi/2)+1),(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)),A_BG*(sin(pi/2*ABFZ*3*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH-pi/2)+1)>*<-1,1,H_ABG_S>
		      rotate <0,ASTSPIRALE*sin((Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH*(pi/2)),0>
					rotate <0,1234*sin(1.77*B),0>*AST_DREH
		      //STELLUNG ALS AST
					rotate <0,0,-90>					
					scale <AST_L/BH,AST_L/BH,AST_L/BH>*(1-B/100*AST_VK)			 
					rotate <0,0,ASTNEIGUNG+((B*B/100)*((90-ASTNEIGUNG)/100))>
					rotate <0,1456*cos(AST_SPIEL*71.19/B)*(1-A_W_S)+90*A_W_S*sin((B/(100/ASTZAHL)-1/(100/ASTZAHL))*pi-pi/2)+90,0>
		      //FUEHRUNG AM STAMM
					translate <KK*sin(.05*SKKFZ*(AA+(B*AB/100))/7.31),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/3.71),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/9.17)>*((BH-(AA+(B*AB/100)))/BH)
					translate <SW*sin(.2*SWFZ*(AA+(B*AB/100))/17.3),SW*sin(.2*SWFZ*(AA+(B*AB/100))/21.1),SW*sin(.2*SWFZ*(AA+(B*AB/100))/33.9)>*((BH-(AA+(B*AB/100)))/BH)			
					translate <BG_X*sin(5.371*FZ_X*1.5*(AA+(B*AB/100))/BH),(AA+(B*AB/100)),BG_Z*sin(5.937*FZ_Z*1.5*(AA+(B*AB/100))/BH)>
					rotate <0,STAMMSPIRALE*sin((AA+(B*AB/100))/(BH*3/5)),0>					
				}
			#declare C=C+ZWEIGLAENGE/SZ*ZWZ;
			#end
		#declare B=B+100/ASTZAHL;
		#end
	#declare A=A+BH/ZWZ*ASTZAHL;
	#end
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX B L U E T E N XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  
	//BLUETENSTAUDENFORMUNG
	#declare B_STAUDE =
	union
	{ 
		#declare A=1;
		#while (A<100*BL_Z)// *BL_Z/SZ)
			object
			{
				BLUETE
				scale <M_BL_L*(sin(A*511.777)+4)/4,M_BL_B*(sin(A*331.111)+4)/4,M_BL_B*(sin(A*117.999)+4)/4>
				rotate <M_BN_X*sin(237.111*A),0,M_BN_Z*(1+sin(719.333*A))/2>
				rotate <0,M_BN_Y*sin(317.111*A),0>
				translate <S_MA_R+(S_MI_R),0,0>
				rotate <0,0,V_S_T/2*sin(177.7391*A)>
				rotate <0,H_S_T/2*sin(211.3783*A),0>
				pigment{color rgb BL_F}
				finish{diffuse 1 ambient .4}
			}
		#declare A=A+100*SZ;//BL_Z*SZ;
		#end
	}
	#declare A=1;
	#while (A<BH+2) 
		#declare B=1;
		#while (B<100)
			#declare C=1;
			#while (C<ZWEIGLAENGE)
				object
				{
					B_STAUDE
					//STAUDENSTELLUNG
					rotate <0,0,V_S_N_SP*sin(391.77*C*C)>+<0,0,(V_S_N-(V_S_N*C/ZWEIGLAENGE*V_S_NEIG))>
					rotate <0,H_S_N_SP*sin(437.77*C*C),0>+<0,(H_S_N-(H_S_N*C/ZWEIGLAENGE*S_NEIG)),0>
					rotate <1234*sin(1.77*C),0,0>*S_DREH
					rotate <1234*sin(1.77*A),0,0>*S_DREH
					scale 1/(1-B/100*AST_VK)
					scale S_VF*(1.01-S_VJ_B*B/100)			    
					rotate <0,0,90>
					translate <A_KK*sin(.05*AKKFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/7.31),A_KK*sin(.05*AKKFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/3.71),A_KK*sin(.05*AKKFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/9.17)>*((BH-(ZWEIGLAENGE*(BH/ZW_L)))/BH)*(ZW_L/BH)*ZW_K_A
					translate <AW*sin(.3*AWFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/17.3),AW*sin(.3*AWFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/21.1),AW*sin(.3*AWFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/33.9)>*((BH-(ZWEIGLAENGE*(BH/ZW_L)))/BH)*(ZW_L/BH)*ZW_K_A 
					translate <A_BG*(sin(pi/2*ABFZ*2*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/BH-pi/2)+1),((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L)),A_BG*(sin(pi/2*ABFZ*2*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/BH-pi/2)+1)>*(ZW_L/BH)*<ZW_K_A,1,ZW_K_A> 
					rotate <0,1234*sin(1.77*A),0>*ZW_DREH
					rotate <0,0,-90>
					scale (1.01-S_VJ_A*A/BH)*BH/AST_L
					rotate <0,0,V_ZW_N_SP*sin(391.77*A*A)>+<0,0,(V_ZW_N-(V_ZW_N*A/BH*V_ZW_NEIG))>
					rotate <0,H_ZW_N_SP*sin(437.77*A*A),0>+<0,(H_ZW_N-(H_ZW_N*A/BH*ZW_NEIG)),0>*(ZW_W_S*sin((A/(BH/ZWZ*ASTZAHL)-1/(BH/ZWZ*ASTZAHL))*pi-pi/2))
					rotate <1456*cos(AST_SPIEL*71.19/A)*(1-ZW_W_S),0,0>			
					rotate <0,0,90>
					rotate <0,1234*sin(1.77*B),0>*(1-ZW_W_S)
		      rotate <0,-1234*sin(1.77*B),0>*AST_DREH// *(ZW_DREH+1)
		      //FUEHRUNG AM AST
					translate <A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/7.31),A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/3.71),A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/9.17)>*(BH-(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)))/BH
		  		translate <AW*sin(.3*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/17.3),AW*sin(.3*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/21.1),AW*sin(.3*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/33.9)>*((BH-(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)))/BH)*<1,A_L_W,H_AW_S>
					translate <A_BG*(sin(pi/2*ABFZ*3*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH-pi/2)+1),(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)),A_BG*(sin(pi/2*ABFZ*3*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH-pi/2)+1)>*<-1,1,H_ABG_S>
		      rotate <0,ASTSPIRALE*sin((Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH*(pi/2)),0>
					rotate <0,1234*sin(1.77*B),0>*AST_DREH
		      //STELLUNG ALS AST
					rotate <0,0,-90>					
					scale <AST_L/BH,AST_L/BH,AST_L/BH>*(1-B/100*AST_VK)			 
					rotate <0,0,ASTNEIGUNG+((B*B/100)*((90-ASTNEIGUNG)/100))>
					rotate <0,1456*cos(AST_SPIEL*71.19/B)*(1-A_W_S)+90*A_W_S*sin((B/(100/ASTZAHL)-1/(100/ASTZAHL))*pi-pi/2)+90,0>
		      //FUEHRUNG AM STAMM
					translate <KK*sin(.05*SKKFZ*(AA+(B*AB/100))/7.31),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/3.71),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/9.17)>*((BH-(AA+(B*AB/100)))/BH)
					translate <SW*sin(.2*SWFZ*(AA+(B*AB/100))/17.3),SW*sin(.2*SWFZ*(AA+(B*AB/100))/21.1),SW*sin(.2*SWFZ*(AA+(B*AB/100))/33.9)>*((BH-(AA+(B*AB/100)))/BH)			
					translate <BG_X*sin(5.371*FZ_X*1.5*(AA+(B*AB/100))/BH),(AA+(B*AB/100)),BG_Z*sin(5.937*FZ_Z*1.5*(AA+(B*AB/100))/BH)>
					rotate <0,STAMMSPIRALE*sin((AA+(B*AB/100))/(BH*3/5)),0>					
				}
			#declare C=C+ZWEIGLAENGE/SZ*ZWZ;
			#end
		#declare B=B+100/ASTZAHL;
		#end
	#declare A=A+BH/ZWZ*ASTZAHL;
	#end
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX H O L Z XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  
  blob
	{
		threshold STAMMRADIUS*3
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX S T A M M XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		#declare A=1;
		#while (A<(AA+((ASTZAHL-1)/ASTZAHL)*AB+S_VL))
			sphere
			{
				<0,0,0>,STAMMRADIUS*5,STAMMRADIUS*10
				scale STAMMRADIUS/90
				scale (BH-A*ST_VJ)/BH//(BH-A*ST_VJ/(AST_ST*BH/(AA+AB)))/BH
				scale 1-(A/(AA+AB))*(1-AST_ST)
				
				#if (A>AA)
 					scale (1-(A-AA)/AB*AST_VK)
				#else
          scale 1
				#end
        				
				scale (<2-1,.6-1,3-1>*PALMSTAMM+1)			
				rotate <5*sin(17.7*A),12347.3*sin(1.77*A),0>*PALMSTAMM								
        //STAMMFORMUNG
				translate <KK*sin(.05*SKKFZ*A/7.31),KK*sin(.05*SKKFZ*A/3.71),KK*sin(.05*SKKFZ*A/9.17)>*((BH-A)/BH)
				translate <SW*sin(.2*SWFZ*A/17.3),SW*sin(.2*SWFZ*A/21.1),SW*sin(.2*SWFZ*A/33.9)>*((BH-A)/BH)
				translate <BG_X*sin(5.371*FZ_X*1.5*A/BH),A,BG_Z*sin(5.937*FZ_Z*1.5*A/BH)>
				rotate <0,STAMMSPIRALE*sin(A/(BH*3/5)),0>				
			}			
    #declare A=A+BH/(STAMMBLENDE+0.1)/200;
		#end
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX A E S T E XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		#declare A=1;
		#while (A<(Z_A+Z_B+AST_E*ZW_L)/(Z_A+Z_B+ZW_L)*BH)		
			#declare B=1;
			#while (B<100)
				sphere
				{
					<0,0,0>,STAMMRADIUS*5,STAMMRADIUS*10 
					scale STAMMRADIUS/90
					scale (BH-A*AST_VJ)/BH					
					scale (BH-((AA+((ASTZAHL-1)/ASTZAHL)*AB)*(B/100))*ST_VJ)/BH//(BH-((AA+AB)*(B/100))*ST_VJ)/BH 
					scale 1-(A/BH)*(1-ZW_VST)
					
					scale 1-S_VJ_A*(A/BH)
					
					scale (BH-AA*ST_VJ)/BH					
					scale 1/(AST_L/BH)
					scale AST_ST
					//ASTFORMUNG					
					translate <A_KK*sin(.05*AKKFZ*A/7.31),A_KK*sin(.05*AKKFZ*A/3.71),A_KK*sin(.05*AKKFZ*A/9.17)>*((BH-A)/BH)
					translate <AW*sin(.3*AWFZ*A/17.3),AW*sin(.3*AWFZ*A/21.1),AW*sin(.3*AWFZ*A/33.9)>*((BH-A)/BH)*<1,A_L_W,H_AW_S>
					translate <A_BG*(sin(pi/2*ABFZ*3*A/BH-pi/2)+1),A,A_BG*(sin(pi/2*ABFZ*3*A/BH-pi/2)+1)>*<-1,1,H_ABG_S>
					rotate <0,ASTSPIRALE*sin(A/BH*(pi/2)),0>
					rotate <0,1234*sin(1.77*B),0>*AST_DREH
					//ASTSTELLUNG
					rotate <0,0,-90>					
					scale (AST_L/BH)*(1-B/100*AST_VK) 					
					rotate <0,0,ASTNEIGUNG+((B*B/100)*((90-ASTNEIGUNG)/100))>
					rotate <0,1456*cos(AST_SPIEL*71.19/B)*(1-A_W_S)+90*A_W_S*sin((B/(100/ASTZAHL)-1/(100/ASTZAHL))*pi-pi/2)+90,0>
          //FUEHRUNG AM STAMM
					translate <KK*sin(.05*SKKFZ*(AA+(B*AB/100))/7.31),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/3.71),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/9.17)>*((BH-(AA+(B*AB/100)))/BH)
					translate <SW*sin(.2*SWFZ*(AA+(B*AB/100))/17.3),SW*sin(.2*SWFZ*(AA+(B*AB/100))/21.1),SW*sin(.2*SWFZ*(AA+(B*AB/100))/33.9)>*((BH-(AA+(B*AB/100)))/BH)					
					translate <BG_X*sin(5.371*FZ_X*1.5*(AA+(B*AB/100))/BH),(AA+(B*AB/100)),BG_Z*sin(5.937*FZ_Z*1.5*(AA+(B*AB/100))/BH)>
					rotate <0,STAMMSPIRALE*sin((AA+(B*AB/100))/(BH*3/5)),0>								
				}
			#declare B=B+100/ASTZAHL;
			#end
    #declare A=A+BH/(ASTBLENDE+0.1)/200;
		#end
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX Z W E I G E XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX		
		#declare A=1;
		#while (A<BH+2)
			#declare B=1;
			#while (B<100)
				#declare C=1;
				#while (C<BH)
					sphere
					{
						<0,0,0>,STAMMRADIUS*5,STAMMRADIUS*10
						scale STAMMRADIUS/90
						scale (BH-C*0.8)/BH					
						scale (BH-((AA+((ASTZAHL-1)/ASTZAHL)*AB)*(B/100))*ST_VJ)/BH
						scale (BH-AA*ST_VJ)/BH					
						scale (AST_L-(A/(BH+2))*(Z_A+Z_B)*AST_VJ)/AST_L//(AST_L-(A/(BH+2))*(Z_A+Z_B)*AST_VJ)/AST_L
						scale (AST_L-Z_A)/AST_L
						scale BH/AST_L
						scale AST_L/ZW_L
						scale ZW_VST*AST_ST
						//ZWEIGFORMUNG
						translate <A_KK*sin(.05*AKKFZ*C/7.31),A_KK*sin(.05*AKKFZ*C/3.71),A_KK*sin(.05*AKKFZ*C/9.17)>*((BH-C)/BH)*ZW_K_A
						translate <AW*sin(.3*AWFZ*C/17.3),1*AW*sin(.3*AWFZ*C/21.1),1*AW*sin(.3*AWFZ*C/33.9)>*((BH-C)/BH)*ZW_K_A
						translate <A_BG*(sin(pi/2*ABFZ*2*C/BH-pi/2)+1),C,1*A_BG*(sin(pi/2*ABFZ*2*C/BH-pi/2)+1)>*<ZW_K_A,1,ZW_K_A> 
	          //ANPASSUNG AN STAUDE
	          rotate <0,1234*sin(1.77*A),0>*ZW_DREH
						rotate <0,0,-90>
						scale ZW_L/BH	
						scale (1.01-S_VJ_A*A/BH)*BH/AST_L
						rotate <0,0,V_ZW_N_SP*sin(391.77*A*A)>+<0,0,(V_ZW_N-(V_ZW_N*A/BH*V_ZW_NEIG))>
						rotate <0,H_ZW_N_SP*sin(437.77*A*A),0>+<0,(H_ZW_N-(H_ZW_N*A/BH*ZW_NEIG)),0>*(ZW_W_S*sin((A/(BH/ZWZ*ASTZAHL)-1/(BH/ZWZ*ASTZAHL))*pi-pi/2))
						rotate <1456*cos(AST_SPIEL*71.19/A)*(1-ZW_W_S),0,0>			
						rotate <0,0,90>	
						rotate <0,1234*sin(1.77*B),0>*(1-ZW_W_S)					
			      rotate <0,-1234*sin(1.77*B),0>*AST_DREH// *(ZW_DREH+1)
			      //FUEHRUNG AM AST
						translate <A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/7.31),A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/3.71),A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/9.17)>*(BH-(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)))/BH	      
			  		translate <AW*sin(.3*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/17.3),AW*sin(.3*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/21.1),AW*sin(.3*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/33.9)>*((BH-(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)))/BH)*<1,A_L_W,H_AW_S>	
						translate <A_BG*(sin(pi/2*ABFZ*3*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH-pi/2)+1),(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)),A_BG*(sin(pi/2*ABFZ*3*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH-pi/2)+1)>*<-1,1,H_ABG_S>
						rotate <0,ASTSPIRALE*sin((Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH*(pi/2)),0>
						rotate <0,1234*sin(1.77*B),0>*AST_DREH
			      //STELLUNG ALS AST
						rotate <0,0,-90>					
						scale (AST_L/BH)*(1-B/100*AST_VK)			 
						rotate <0,0,ASTNEIGUNG+((B*B/100)*((90-ASTNEIGUNG)/100))>
						rotate <0,1456*cos(AST_SPIEL*71.19/B)*(1-A_W_S)+90*A_W_S*sin((B/(100/ASTZAHL)-1/(100/ASTZAHL))*pi-pi/2)+90,0>
	          //FUEHRUNG AM STAMM
						translate <KK*sin(.05*SKKFZ*(AA+(B*AB/100))/7.31),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/3.71),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/9.17)>*((BH-(AA+(B*AB/100)))/BH)
						translate <SW*sin(.2*SWFZ*(AA+(B*AB/100))/17.3),SW*sin(.2*SWFZ*(AA+(B*AB/100))/21.1),SW*sin(.2*SWFZ*(AA+(B*AB/100))/33.9)>*((BH-(AA+(B*AB/100)))/BH)			
						translate <BG_X*sin(5.371*FZ_X*1.5*(AA+(B*AB/100))/BH),(AA+(B*AB/100)),BG_Z*sin(5.937*FZ_Z*1.5*(AA+(B*AB/100))/BH)>
						rotate <0,STAMMSPIRALE*sin((AA+(B*AB/100))/(BH*3/5)),0>					
					}
				#declare C=C+BH/200/(ZWEIGBLENDE+0.000001);
				#end 
			#declare B=B+100/ASTZAHL;
			#end
		#declare A=A+BH/ZWZ*ASTZAHL;
		#end		
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX W U R Z E L N XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX		
		#declare A=1;
		#while (A<BH)		
			#declare B=1;
			#while (B<100)
				sphere
				{
					<0,0,0>,STAMMRADIUS*5,STAMMRADIUS*10
					scale (BH-A)/BH
					scale STAMMRADIUS/90
					scale W_ST 
					scale BH/W_L
					//WURZELFORMUNG
					translate <W_KK*sin(.1*WKKFZ*A/7.31),W_KK*sin(.1*WKKFZ*A/3.71),W_KK*sin(.1*WKKFZ*A/9.17)>*((BH-A)/BH)
					translate <W_BG*sin(5.371*WBFZ*A/BH),A,W_BG*sin(5.937*WBFZ*A/BH)> 
					rotate <0,1234.773*sin(1.77*B),0>*W_DREH
					//WURZELSTELLUNG
					rotate <0,0,-90>
					rotate <0,180,0>					
					scale W_L/BH 					
					rotate <0,0,WURZELNEIGUNG+((B*B/100)*((90-WURZELNEIGUNG)/100))>
					rotate <0,1456.371*sin(WURZEL_SPIEL*71.19/B)+180,0>
          //FUEHRUNG AM STAMM
					translate <KK*sin(.05*SKKFZ*(WA-(WA*B/100))/7.31),KK*sin(.05*SKKFZ*(WA-(WA*B/100))/3.71),KK*sin(.05*SKKFZ*(WA-(WA*B/100))/9.17)>*((BH-(WA-(WA*B/100)))/BH)
					translate <SW*sin(.2*SWFZ*(WA-(WA*B/100))/17.3),SW*sin(.2*SWFZ*(WA-(WA*B/100))/21.1),SW*sin(.2*SWFZ*(WA-(WA*B/100))/33.9)>*((BH-(WA-(WA*B/100)))/BH)				
					translate <BG_X*sin(5.371*FZ_X*1.5*(WA-(WA*B/100))/BH),(WA-(WA*B/100)),BG_Z*sin(5.937*FZ_Z*1.5*(WA-(WA*B/100))/BH)>
					rotate <0,STAMMSPIRALE*sin((WA-(WA*B/100))/(BH*3/5)),0>								
				}
			#declare B=B+100/(WURZELZAHL+1);
			#end
    #declare A=A+BH/150/(WURZELBLENDE+0.000001);
		#end		
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX T E X T U R E N XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		
		pigment
		{
			granite
			//turbulence <MASERUNG_WEITE,MASERUNG_HOEHE,MASERUNG_WEITE>
			color_map
			{  
				[0 color rgb ST_F_1]
				//[0.1 color rgb ST_F_1]
				[.4 color rgb ST_F_2]
				[.6 color rgb ST_F_2]
				//[0.9 color rgb ST_F_1]
				[1 color rgb ST_F_1]
			}
			scale <MASERUNG_WEITE,MASERUNG_HOEHE,MASERUNG_WEITE>*5
		}
		normal
		{
			granite RINDENTIEFE*20
			scale <MASERUNG_WEITE,MASERUNG_HOEHE,MASERUNG_WEITE>*5
			//turbulence <MASERUNG_WEITE,MASERUNG_HOEHE,MASERUNG_WEITE> 
		}	
		finish
		{
			specular .2
		}
		
		/*
		pigment
		{
			granite
			turbulence .0
			color_map
			{  
				[0 color rgb ST_F_1]
				[0.25 color rgb ST_F_1]
				[0.4 color rgb ST_F_2]
				[1 color rgb ST_F_2]
			}
			scale <5,5,5>*<MASERUNG_WEITE,MASERUNG_HOEHE,MASERUNG_WEITE>
			rotate <1,-1,1>
		}
		normal
		{
			granite RINDENTIEFE*10
			scale BH/20
			turbulence <0,0,0>*<MASERUNG_WEITE,MASERUNG_HOEHE,MASERUNG_WEITE> 
			rotate <90,0,0>
		}	
		finish
		{
			phong 0
		}
		*/
		
	}	
	#declare BOZO1 =
	pigment
	{
		bozo
		color_map
		{
			[0 color rgb B_F_1]
			[1 color rgb B_F_2]
		}
		scale BH/(250*(VERWIRBELUNG+.1)*BH)//S_MA_R/(VERWIRBELUNG*BH)
	}   
	#declare BOZO2 =
	pigment
	{
		bozo
		color_map
		{
			[0 color rgb K_F_1]
			[1 color rgb K_F_2]
		}
		scale BH/(250*(VERWIRBELUNG+.1)*BH)//S_MA_R/(VERWIRBELUNG*BH)
	}	
	texture
	{
		pigment
		{
			gradient y 
			cubic_wave 
			turbulence UE_T
			omega UE_T
			pigment_map
			{
				[0 BOZO2]
				[UE_B_K BOZO1]
				[1 BOZO2]
			}
			scale BH
		}
		finish
		{ 
			phong 0.4*GLANZ
			phong_size 50*GLANZ
		}
	}
	scale 1/(AA+((ASTZAHL-1)/ASTZAHL)*AB+(Z_A*(1-((ASTZAHL-1)/ASTZAHL)*AST_VK))+(Z_B*(1-((ASTZAHL-1)/ASTZAHL)*AST_VK))+(ZWEIGLAENGE*(1-S_VJ_A)*(1-((ASTZAHL-1)/ASTZAHL)*AST_VK))+(S_MA_R*(1-((ASTZAHL-1)/ASTZAHL)*S_VJ_B)*(1-S_VJ_A))+(S_MI_R*(1-((ASTZAHL-1)/ASTZAHL)*S_VJ_B)*(1-S_VJ_A))+(M_BL*(1-((ASTZAHL-1)/ASTZAHL)*S_VJ_B)*(1-S_VJ_A)))
} 
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX END
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX