// Persistence of Vision Ray Tracer Scene Description File
// File: mg_patio.pov
// Vers: 3.1g
// Desc: sky_sphere for  image group project
// Date: December 23, 1999
// Auth: Marjorie Diez de Graterol

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "patiotex.inc"//textures for this file 
//#include "sun.inc"

global_settings { assumed_gamma 2.2 }


sphere{0, 1000 // this value for use with sun.inc 0,101000 
no_shadow
pigment 
{
  bumps
  turbulence 0.3
  color_map 
  {
    [0.0, 0.25 color rgb <0.220,0.361,0.580>
              color rgb <0.271,0.435,0.627>]
    [0.25, 1.0 color rgb <0.271,0.435,0.627>
              color rgb <1.0, 1.0, 1.0>]
  }
    
	scale 55// this value for use with sun.inc 50000
	rotate x*20
				
}
	finish{ambient 0.4 diffuse 0.3} hollow no_shadow}
/*
//Increases rendering time in almost 22 hours with this machine
//It has been disabled. The scene will be inside a much reduced sphere, with a mapped texture
//see above
 
//main light -iluminacion principal
#declare sunpos = sunvector(1999,2,19, 14,30,6, 11.5,67.5);
light_source { 
		sunpos*100000 rgbf <0.99609, 0.90234, 0.36719, 0.5>*1.5 
		looks_like { 
			sphere { 
				0*x, 100000/214 
				pigment {color rgb <0.91797, 0.65234, 0.03906,>}
				finish {ambient 0.8 diffuse 0.2}  
			}
		}
	}
	
	*/

camera
{
  location  <0 , 2.5 ,-9.5>
  angle 60
  look_at   <6.0 , -2 , 10.0>   
  
  
}



//Luces
light_source { <-10.000, 10.000, -20.000> color rgb <0.812, 0.729, 0.973> }

//luz derivada de sunlight
light_source { <-10.000, 10.000, -20.000> color rgbf <0.99609, 0.90234, 0.36719, 0.5>}

                                                      
//secondary light- luz secundaria                     

light_source {
<20, 25, -10>  
color rgb <0.941,0.769,0.161> 
spotlight
point_at <0, 2, -1> 
radius 150
falloff 10
fade_distance 150
fade_power 100

} 


union{

// garden floor- piso del jardin
difference{
    box{
        <-6, -1, -10>  
        < 45,  -0.75,  15>  
  
        translate <0,-0.5,0>
        }
    box{
        <0, -2, -4>  
        < 39,  1.2,  9>  
  
        translate <0,-0.5,0>
        }
    texture{piso}
}


//soil box- caja de tierra
box{
  <0, -1, -4>  
  < 39,  -0.45,  9>  
  texture {tierratex}
  
  translate <0,-1,0>
}


#declare columna=
union{
     cone
        { 4*y,  0.35, -1*y, 0.55}

    union{
        torus
        { 0.35, 0.10  translate <0,4,0> }
        
        torus
        { 0.37, 0.10  translate <0,4.10,0> } 
        
        torus
        { 0.55, 0.15 scale <1,1.25,1> translate <0,-1,0> } 
        } 
    texture {superf}
}
 
//left - lateral izquierdo

object {columna translate <-0.80,-0.10,4>}  

//rear- atras
object {columna translate <-0.80,-0.10,9.5>} 
object {columna translate <5,-0.10,9.5>}
object {columna translate <12,-0.10,9.5>}

//front - primer plano 
object {columna translate <5,-0.10,-5.10>}



//back wall -pared de atrs
box
{
  <-6, -1, 15.5>  // one corner position <X1 Y1 Z1>
  < 45,  4,  15>  // other corner position <X2 Y2 Z2>
  texture {superf}//pigment{Red}
  translate <0,-0.5,0>}

//vigas//
//rear- posterior
box
{
  <-1, -1, 10>  
  < 30,  -0.5,  9>  
  texture{superf}
  translate <0,5.10,0>} 
  
//left- lateral izquierda  
box
{
  <-1, -1, 10>  
  < 0,  -0.5,  -10>  
  texture{superf}
  translate <-0.50,5.10,0>}  


  
  
  
  
//water spills and fountain  -manchas de agua y pila

#include "mancha.inc"  //modeled in sPatch
 

#include "mod.inc"
#declare fuente=
union{
        object{modulo translate <0,0,0>}
        object{modulo rotate <0,-90,0> translate <3,0,0>}
        object{modulo texture {agua2} rotate <0,-90,0> translate <3.001,0,0>}
        object{modulo rotate <0,-180,0> translate <1.5,0,3>}
       }                                                    



object{fuente scale <1,-0.50,1> translate <-1.8,-1,-1.50>}


union{
//water in fountain - agua dentro de la fuente
cylinder
{
  0*y,  0.08*y,  1.5
  texture{agua}
  interior {
  ior 1.33
  caustics 0.6}
  translate <-0.19,-0.30,1>//1.5
}

cylinder
{
  0*y,  0.08*y,  1.5
  texture{agua}
  interior {
  ior 1.33
  caustics 0.6}
  translate <-2,-0.30,-2>
}             

cylinder
{
  0*y,  0.08*y,  1.5
  texture{agua}
  interior {
  ior 1.33
  caustics 0.6} 
  translate <1.3,-0.30,-1.69>
}   
}
 

 
 
 //water container-perola con agua
 
 union{             
 
    object {perola  translate <-0.5,-1,-4>}//3.9>} 
 
 //agua de relleno
    object {perola scale <0.99,0.85,0.99>  texture{agua}  translate <-0.5,-1,-4>}//-3.9>} 
    }
 
//water spill- mancha de agua 
object {mancha translate <0,-1.3,-5.5>} 

//under scissors- debajo de la tijera
object {mancha translate <2.61,-1.24555,-5.70>}

//container for violets- envase de las violetas al frente
object {vertical scale 0.5 translate <3.9,-1.13,-6>} 

 
 

//violets- violetas  PlantStudio
#include "hojas7.inc" 

object{hojas7 scale 0.02 translate <3.9,-0.5,-6> }
 


//red little flowers -flores rojas pequenas//PlantStudio


#include "roja1.inc"  

object {gilia rotate 90*x translate <-1,5,-0.50>} 





//bush- arbustos //PlantStudio
 #include "chiflera.inc"    
 
 
 object{chiflera scale 0.045  translate <15,-1,5>}   
 
                                                                            
                                                                            
 
 //lattice -rejilla pared posterior  - object from SoftCad lite library
 
 #include "arriba.inc" 
 union{
    object {arriba translate <0.50,3.85,10>}  
    object {arriba translate <4.70,3.85,10>}
    object {arriba translate <9.40,3.85,10>}                                                                      
    }                                                                           

 //water plant -flor de agua sPatch
  
 #include "deagua1.inc"  
 
 object{deagua scale 0.40 translate <1,-0.335,-1.25>} 

 //left fence- reja lateral  sPatch
 #include "rejalat.inc"
 union{
    object{rejas rotate y*90 translate <-4,3,11.0>}
    object{rejas rotate y*90 translate <-4,3,6.0>}   
    object{rejas rotate y*90 translate <-4,3,1.0>} 
    }
 


 //garden hose -manguera sPatch
 #include "manguera2.inc" 
 
 object {manguera2 rotate -30*y translate <4,-1,-4.21>}  
 
 
 
 //Orchid flower- Orquidea sPatch
 
 #include "orquidea.inc"
 
 object{orquidea scale <0.10,0.15,0.10> rotate 45*y translate <3.8,2,-6>}
 
 //Orchid plant, leaves - hojas de la orquidea PlantStudio
 #include "orqhoj3.inc" 
 object{orqhoj3 scale 0.020 rotate <15,15,5> translate <3.8,1.90,-5.80>}


//Lilies leaves- Hojas de los Lirios  PlantStudio
#include "lily.inc"
union{
    object {lily scale <0.012,0.016,0.012>  translate <3.70,-1.20,6.20> }  //<0,2,0><3,-1,5>
    object {lily scale <0.013,0.017,0.013>  rotate 33*y translate <1.70,-1.20,6.20> }
    object {lily scale <0.014,0.018,0.014>  rotate 62*y translate <0.70,-1.20,6.20> }
                               
    object {lily scale <0.012,0.018,0.012>  translate <3.00,-1.20,6> }  //<0,2,0><3,-1,5>
    object {lily scale <0.013,0.016,0.013>  rotate 33*y translate <2.00,-1.20,6> }
    object {lily scale <0.014,0.017,0.014>  rotate 62*y translate <1.00,-1.20,6> }
    }

                                                                     

//tiger lily -flor de lirio modeled in sPatch
#include "tiger.inc"
object {tiger scale 0.15 rotate 20*y translate   <-0.5,-0.10,-3.9>}
object {tiger rotate <15,30,45> scale 0.15 translate <-0.90,-0.10,-3.9>}  

//flowers at the back- flores de atras -lirios- 
object {tiger scale 0.15 translate   <3,0.5,6>}
object {tiger scale 0.15 rotate 35*y rotate 15*z translate   <1.55,0.5,6.5>}






//rosa

      



 
#include "mg_rosa2.inc"  //modeled in sPatch- from First Encounters round 

//in "perola"

object {mg_rosa2 scale 0.12 //rotate 30*x 
rotate 30*y
translate <-0.75,-0.45,-3.80>}
//rose bush -rosal
#include "rosal.inc"

union{
    object {rosal scale <0.020, 0.018,0.020>  rotate 62*y translate <11,-1,3.5> } 
    object {rosal scale <0.020, 0.018,0.020>  rotate 30*y translate <11.002,-1,3.5> }  

//roses in bush- rosas en el rosal
    object {mg_rosa2 scale 0.12     rotate 30*y     translate <11,1.7,4.49>}   

//rose in upper fountain -rosa en la parte superior de la fuente

    object {mg_rosa2 scale 0.12 rotate 30*y translate <-1,0.10,0>}    

}


//scissors- tijeras object from 3Dcafe

#include "tijeras.inc"

object{tijeras scale <0.10,0.12,0.10> rotate 38*y translate <2.65,-1.18,-4.77>}





//chairs- sillas modeladas en sPatch

#include "silla2.inc" 

object{silla scale 0.50 rotate -30*y translate <2.50,-0.10,9>}
object{silla scale 0.50 rotate 120*y translate <0.95,-0.10,8>}//silla izquierda 


//a tree from "tomtree.inc" 
//leaves and trunk were modified

#include "ARBOL.inc"
#include "TOMTREE.inc"

object
    {  TREE scale <12,14,12>  translate <6,-1.75,0> }


//foliage- follaje PlantStudio 
#include "follaje5.inc" 

//inside fountain- dentro de la fuente
object {follaje5 scale 0.015 translate <-1,-0.60,0>}

//in groups- en grupos 
#declare follaje=
union{
    object {follaje5 scale 0.015 translate <5,-1.20,-1.20>}
    object {follaje5 scale 0.015 translate <5.50,-1.20,-1.20>}  
    object {follaje5 scale 0.015 translate <5.70,-1.20,-1.20>}

    }

object{follaje}
object{follaje translate -3.15*z}
object{follaje translate <0,0,4>}//4*z}//


//something similar to hammock -hamaca o chinchorro modeled in sPatch
#include "hamaca.inc"

object{hamaca scale <1.95,1.75,1.75> translate <8.5,1,9.5>}   


//stones -piedras modeled in sPatch 
#include "piedra.inc"
union{
    object{piedra scale 1.5 translate <2.70,-1.88,-3> }
    object{piedra scale 1.5 translate <0.70,-1.88,-3> }
    object{piedra scale 1.5 rotate 90*y translate <4.95,-1.90,-2.25> } 
    object{piedra scale 1.5 rotate 90*y translate <6.95,-1.90,-2.25> }
    object{piedra scale 1.5 rotate 45*y translate <5.70,-1.90,-0.95> }
    object{piedra scale 1.5 translate <4.70,-1.90,1.25> }
    object{piedra scale 1.5 rotate -90*y translate <5.25,-1.90,2.80> }
    object{piedra scale 1.5 rotate 45*y translate <6.95,-1.90,4.00> }    
    object{piedra scale 1.5 rotate 45*y translate <4.95,-1.90,5.25> }
    }



//upper fountain section- seccion superior de la fuente modeled in sPatch

    #include "ftesup.inc"

    object{ftesup scale 0.75 rotate 70*y translate <-1,-1,0>}

//water -agua  modeled in sPatch

    #include "ftesup2.inc" 

     object{ftesup2 scale 0.72 rotate 70*y translate <-1,-1,0>} 

 }
