// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio
#include "patiotex.inc"

#declare gilia = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <-0.005729, 0.4053, 0.008134>, 0.06007 }
		cylinder { <-0.005729, 0.4053, 0.008134>, <-0.01718, 0.8102, 0.02439>, 0.06007 }
		cylinder { <-0.01718, 0.8102, 0.02439>, <-0.03435, 1.2145, 0.04878>, 0.06007 }
		texture{chif1}}
	union { // internode
		cylinder { <-0.03435, 1.2145, 0.04878>, <-0.007278, 2.1328, 0.08923>, 0.1362 }
		cylinder { <-0.007278, 2.1328, 0.08923>, <0.08568, 3.04737, 0.1145>, 0.1362 }
		cylinder { <0.08568, 3.04737, 0.1145>, <0.244, 3.9531, 0.1247>, 0.1362 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.244, 3.9531, 0.1247>, <0.355, 4.1641, 0.1103>, 0.07584 }
			cylinder { <0.355, 4.1641, 0.1103>, <0.5246, 4.3296, 0.08042>, 0.07584 }
			cylinder { <0.5246, 4.3296, 0.08042>, <0.7358, 4.4327, 0.03793>, 0.07584 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.7358, 4.4327, 0.03793>, <0.824, 4.4781, 0.02283>, 0.07584 }
				cylinder { <0.824, 4.4781, 0.02283>, <0.9115, 4.5256, 0.0105>, 0.07584 }
				cylinder { <0.9115, 4.5256, 0.0105>, <0.9983, 4.575, 0.0009639>, 0.07584 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <0.9983, 4.575, 0.0009639>, <1.000893, 4.5763, 0.001459>, 0.0009203 }
				cylinder { <1.000893, 4.5763, 0.001459>, <1.003275, 4.5774, 0.002689>, 0.0009203 }
				cylinder { <1.003275, 4.5774, 0.002689>, <1.00533, 4.5782, 0.004565>, 0.0009203 }
				texture{chif1}}
			mesh { // leaf
				triangle { <1.00533, 4.5782, 0.004565>, <1.665, 4.7712, 0.5521>, <1.6309, 4.7462, 0.613> }
				triangle { <1.665, 4.7712, 0.5521>, <1.91, 4.5204, 0.6703>, <1.6309, 4.7462, 0.613> }
				triangle { <1.665, 4.7712, 0.5521>, <1.901, 4.5894, 0.5999>, <1.91, 4.5204, 0.6703> }
				triangle { <1.91, 4.5204, 0.6703>, <1.8099, 4.5565, 0.7138>, <1.6309, 4.7462, 0.613> }
				triangle { <1.6309, 4.7462, 0.613>, <1.3797, 4.6271, 0.3956>, <1.00533, 4.5782, 0.004565> }
				triangle { <1.00533, 4.5782, 0.004565>, <1.4581, 4.6612, 0.2949>, <1.665, 4.7712, 0.5521> }
				triangle { <1.4581, 4.6612, 0.2949>, <1.7377, 4.7069, 0.475>, <1.665, 4.7712, 0.5521> }
				triangle { <1.7377, 4.7069, 0.475>, <1.901, 4.5894, 0.5999>, <1.665, 4.7712, 0.5521> }
				triangle { <1.6309, 4.7462, 0.613>, <1.8099, 4.5565, 0.7138>, <1.6433, 4.6276, 0.6506> }
				triangle { <1.6433, 4.6276, 0.6506>, <1.3797, 4.6271, 0.3956>, <1.6309, 4.7462, 0.613> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <0.9983, 4.575, 0.0009639>, <1.000874, 4.5764, 0.0007582>, 0.0009203 }
				cylinder { <1.000874, 4.5764, 0.0007582>, <1.0034, 4.5778, 0.0006228>, 0.0009203 }
				cylinder { <1.0034, 4.5778, 0.0006228>, <1.005935, 4.5792, 0.0005576>, 0.0009203 }
				texture{chif1}}
			mesh { // leaf
				triangle { <1.005935, 4.5792, 0.0005576>, <1.8024, 4.9482, -0.04193>, <1.8145, 4.9466, 0.03119> }
				triangle { <1.8024, 4.9482, -0.04193>, <2.1167, 4.7535, -0.02881>, <1.8145, 4.9466, 0.03119> }
				triangle { <1.8024, 4.9482, -0.04193>, <2.05558, 4.7932, -0.0957>, <2.1167, 4.7535, -0.02881> }
				triangle { <2.1167, 4.7535, -0.02881>, <2.05376, 4.8034, 0.05337>, <1.8145, 4.9466, 0.03119> }
				triangle { <1.8145, 4.9466, 0.03119>, <1.5156, 4.7603, 0.05378>, <1.005935, 4.5792, 0.0005576> }
				triangle { <1.005935, 4.5792, 0.0005576>, <1.5146, 4.756, -0.07819>, <1.8024, 4.9482, -0.04193> }
				triangle { <1.5146, 4.756, -0.07819>, <1.8303, 4.8602, -0.1246>, <1.8024, 4.9482, -0.04193> }
				triangle { <1.8303, 4.8602, -0.1246>, <2.05558, 4.7932, -0.0957>, <1.8024, 4.9482, -0.04193> }
				triangle { <1.8145, 4.9466, 0.03119>, <2.05376, 4.8034, 0.05337>, <1.8701, 4.8488, 0.0858> }
				triangle { <1.8701, 4.8488, 0.0858>, <1.5156, 4.7603, 0.05378>, <1.8145, 4.9466, 0.03119> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <0.244, 3.9531, 0.1247>, <0.7958, 5.3018, 0.06845>, 0.216 }
		cylinder { <0.7958, 5.3018, 0.06845>, <1.6215, 6.4973, -0.0575>, 0.216 }
		cylinder { <1.6215, 6.4973, -0.0575>, <2.6809, 7.4814, -0.247>, 0.216 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.6809, 7.4814, -0.247>, <2.8063, 7.5389, -0.2724>, 0.04454 }
			cylinder { <2.8063, 7.5389, -0.2724>, <2.9425, 7.5534, -0.3024>, 0.04454 }
			cylinder { <2.9425, 7.5534, -0.3024>, <3.07594, 7.5234, -0.3341>, 0.04454 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <3.07594, 7.5234, -0.3341>, <3.1325, 7.5122, -0.346>, 0.04454 }
				cylinder { <3.1325, 7.5122, -0.346>, <3.1896, 7.5023, -0.3564>, 0.04454 }
				cylinder { <3.1896, 7.5023, -0.3564>, <3.2472, 7.4938, -0.3654>, 0.04454 }
				texture{chif1}}
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <2.6809, 7.4814, -0.247>, <2.9256, 7.7509, -0.3136>, 0.2056 }
			cylinder { <2.9256, 7.7509, -0.3136>, <3.1438, 8.03778, -0.3982>, 0.2056 }
			cylinder { <3.1438, 8.03778, -0.3982>, <3.3335, 8.339, -0.4998>, 0.2056 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <3.3335, 8.339, -0.4998>, <3.4926, 8.6517, -0.6176>, 0.2056 }
			cylinder { <3.4926, 8.6517, -0.6176>, <3.6198, 8.973, -0.7503>, 0.2056 }
			cylinder { <3.6198, 8.973, -0.7503>, <3.7138, 9.2997, -0.8967>, 0.2056 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <3.7138, 9.2997, -0.8967>, <3.8256, 9.6332, -1.01226>, 0.2056 }
			cylinder { <3.8256, 9.6332, -1.01226>, <3.9541, 9.9701, -1.0957>, 0.2056 }
			cylinder { <3.9541, 9.9701, -1.0957>, <4.09819, 10.3073, -1.1462>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.09819, 10.3073, -1.1462>, <4.3403, 10.8068, -1.1595>, 0.2056 }
				cylinder { <4.3403, 10.8068, -1.1595>, <4.6049, 11.2925, -1.1101>, 0.2056 }
				cylinder { <4.6049, 11.2925, -1.1101>, <4.8879, 11.7569, -0.9986>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <4.8879, 11.7569, -0.9986>, <6.2437, 13.4974, -0.609>, <6.1289, 13.5994, -0.8712> }
					triangle { <4.8879, 11.7569, -0.9986>, <5.6293, 12.669, -0.6238>, <6.2437, 13.4974, -0.609> }
					triangle { <6.1289, 13.5994, -0.8712>, <5.411, 12.9577, -0.8856>, <4.8879, 11.7569, -0.9986> }
					triangle { <5.6293, 12.669, -0.6238>, <6.528, 13.3394, -0.6724>, <6.2437, 13.4974, -0.609> }
					triangle { <6.528, 13.3394, -0.6724>, <6.9027, 13.3901, -1.06188>, <6.2437, 13.4974, -0.609> }
					triangle { <6.1289, 13.5994, -0.8712>, <6.2212, 13.7734, -1.1861>, <5.8937, 13.7922, -0.9485> }
					triangle { <5.8937, 13.7922, -0.9485>, <5.411, 12.9577, -0.8856>, <6.1289, 13.5994, -0.8712> }
					triangle { <6.9027, 13.3901, -1.06188>, <6.8347, 13.4887, -1.04225>, <6.399, 13.6345, -0.93> }
					triangle { <6.8347, 13.4887, -1.04225>, <6.8808, 13.4008, -1.5663>, <6.4358, 13.7994, -1.3236> }
					triangle { <6.399, 13.6345, -0.93>, <6.4358, 13.7994, -1.3236>, <6.2212, 13.7734, -1.1861> }
					triangle { <6.399, 13.6345, -0.93>, <6.8347, 13.4887, -1.04225>, <6.4358, 13.7994, -1.3236> }
					triangle { <6.2437, 13.4974, -0.609>, <6.9027, 13.3901, -1.06188>, <6.399, 13.6345, -0.93> }
					triangle { <6.1289, 13.5994, -0.8712>, <6.399, 13.6345, -0.93>, <6.2212, 13.7734, -1.1861> }
					triangle { <6.2437, 13.4974, -0.609>, <6.399, 13.6345, -0.93>, <6.1289, 13.5994, -0.8712> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.8879, 11.7569, -0.9986>, <6.06945, 13.6505, -0.8041>, <5.7965, 13.7727, -0.7493> }
					triangle { <4.8879, 11.7569, -0.9986>, <5.6697, 12.7013, -0.8607>, <6.06945, 13.6505, -0.8041> }
					triangle { <5.7965, 13.7727, -0.7493>, <5.3654, 12.9215, -0.619>, <4.8879, 11.7569, -0.9986> }
					triangle { <5.6697, 12.7013, -0.8607>, <6.1383, 13.6858, -1.1263>, <6.06945, 13.6505, -0.8041> }
					triangle { <6.1383, 13.6858, -1.1263>, <5.9912, 14.05089, -1.5001>, <6.06945, 13.6505, -0.8041> }
					triangle { <5.7965, 13.7727, -0.7493>, <5.5875, 14.07161, -0.8194>, <5.6337, 13.8406, -0.4899> }
					triangle { <5.6337, 13.8406, -0.4899>, <5.3654, 12.9215, -0.619>, <5.7965, 13.7727, -0.7493> }
					triangle { <5.9912, 14.05089, -1.5001>, <5.9847, 14.08906, -1.3851>, <5.8822, 13.9528, -0.944> }
					triangle { <5.9847, 14.08906, -1.3851>, <5.5453, 14.2348, -1.6501>, <5.5769, 14.2466, -1.006178> }
					triangle { <5.8822, 13.9528, -0.944>, <5.5769, 14.2466, -1.006178>, <5.5875, 14.07161, -0.8194> }
					triangle { <5.8822, 13.9528, -0.944>, <5.9847, 14.08906, -1.3851>, <5.5769, 14.2466, -1.006178> }
					triangle { <6.06945, 13.6505, -0.8041>, <5.9912, 14.05089, -1.5001>, <5.8822, 13.9528, -0.944> }
					triangle { <5.7965, 13.7727, -0.7493>, <5.8822, 13.9528, -0.944>, <5.5875, 14.07161, -0.8194> }
					triangle { <6.06945, 13.6505, -0.8041>, <5.8822, 13.9528, -0.944>, <5.7965, 13.7727, -0.7493> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.8879, 11.7569, -0.9986>, <5.8305, 13.7597, -0.6528>, <5.7561, 13.7046, -0.3632> }
					triangle { <4.8879, 11.7569, -0.9986>, <5.4881, 12.8338, -0.9516>, <5.8305, 13.7597, -0.6528> }
					triangle { <5.7561, 13.7046, -0.3632>, <5.5698, 12.7724, -0.5168>, <4.8879, 11.7569, -0.9986> }
					triangle { <5.4881, 12.8338, -0.9516>, <5.5895, 13.9399, -0.7914>, <5.8305, 13.7597, -0.6528> }
					triangle { <5.5895, 13.9399, -0.7914>, <5.2311, 14.2964, -0.5937>, <5.8305, 13.7597, -0.6528> }
					triangle { <5.7561, 13.7046, -0.3632>, <5.6231, 13.8667, -0.05671>, <5.9072, 13.5842, -0.116> }
					triangle { <5.9072, 13.5842, -0.116>, <5.5698, 12.7724, -0.5168>, <5.7561, 13.7046, -0.3632> }
					triangle { <5.2311, 14.2964, -0.5937>, <5.3313, 14.2812, -0.5269>, <5.6483, 13.9608, -0.3838> }
					triangle { <5.3313, 14.2812, -0.5269>, <4.9008, 14.2823, -0.2118>, <5.4743, 14.06948, -0.007843> }
					triangle { <5.6483, 13.9608, -0.3838>, <5.4743, 14.06948, -0.007843>, <5.6231, 13.8667, -0.05671> }
					triangle { <5.6483, 13.9608, -0.3838>, <5.3313, 14.2812, -0.5269>, <5.4743, 14.06948, -0.007843> }
					triangle { <5.8305, 13.7597, -0.6528>, <5.2311, 14.2964, -0.5937>, <5.6483, 13.9608, -0.3838> }
					triangle { <5.7561, 13.7046, -0.3632>, <5.6483, 13.9608, -0.3838>, <5.6231, 13.8667, -0.05671> }
					triangle { <5.8305, 13.7597, -0.6528>, <5.6483, 13.9608, -0.3838>, <5.7561, 13.7046, -0.3632> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.8879, 11.7569, -0.9986>, <5.855, 13.6752, -0.3626>, <6.06311, 13.4887, -0.2429> }
					triangle { <4.8879, 11.7569, -0.9986>, <5.3336, 12.8847, -0.7717>, <5.855, 13.6752, -0.3626> }
					triangle { <6.06311, 13.4887, -0.2429>, <5.7435, 12.7151, -0.7192>, <4.8879, 11.7569, -0.9986> }
					triangle { <5.3336, 12.8847, -0.7717>, <5.6348, 13.7529, -0.1275>, <5.855, 13.6752, -0.3626> }
					triangle { <5.6348, 13.7529, -0.1275>, <5.6658, 13.7898, 0.4131>, <5.855, 13.6752, -0.3626> }
					triangle { <6.06311, 13.4887, -0.2429>, <6.2792, 13.4401, 0.05509>, <6.3388, 13.3749, -0.3401> }
					triangle { <6.3388, 13.3749, -0.3401>, <5.7435, 12.7151, -0.7192>, <6.06311, 13.4887, -0.2429> }
					triangle { <5.6658, 13.7898, 0.4131>, <5.7713, 13.8015, 0.3542>, <6.01843, 13.6476, -0.01844> }
					triangle { <5.7713, 13.8015, 0.3542>, <5.832, 13.4781, 0.7741>, <6.2689, 13.5111, 0.301> }
					triangle { <6.01843, 13.6476, -0.01844>, <6.2689, 13.5111, 0.301>, <6.2792, 13.4401, 0.05509> }
					triangle { <6.01843, 13.6476, -0.01844>, <5.7713, 13.8015, 0.3542>, <6.2689, 13.5111, 0.301> }
					triangle { <5.855, 13.6752, -0.3626>, <5.6658, 13.7898, 0.4131>, <6.01843, 13.6476, -0.01844> }
					triangle { <6.06311, 13.4887, -0.2429>, <6.01843, 13.6476, -0.01844>, <6.2792, 13.4401, 0.05509> }
					triangle { <5.855, 13.6752, -0.3626>, <6.01843, 13.6476, -0.01844>, <6.06311, 13.4887, -0.2429> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.8879, 11.7569, -0.9986>, <6.1142, 13.5106, -0.3352>, <6.2969, 13.4227, -0.5617> }
					triangle { <4.8879, 11.7569, -0.9986>, <5.4222, 12.7813, -0.566>, <6.1142, 13.5106, -0.3352> }
					triangle { <6.2969, 13.4227, -0.5617>, <5.6439, 12.8314, -0.9506>, <4.8879, 11.7569, -0.9986> }
					triangle { <5.4222, 12.7813, -0.566>, <6.2237, 13.3761, -0.05282>, <6.1142, 13.5106, -0.3352> }
					triangle { <6.2237, 13.3761, -0.05282>, <6.7145, 13.2212, 0.1194>, <6.1142, 13.5106, -0.3352> }
					triangle { <6.2969, 13.4227, -0.5617>, <6.6544, 13.3815, -0.6534>, <6.3304, 13.5054, -0.8624> }
					triangle { <6.3304, 13.5054, -0.8624>, <5.6439, 12.8314, -0.9506>, <6.2969, 13.4227, -0.5617> }
					triangle { <6.7145, 13.2212, 0.1194>, <6.7145, 13.3043, 0.031>, <6.4893, 13.4429, -0.361> }
					triangle { <6.7145, 13.3043, 0.031>, <7.07426, 12.9251, -0.0756>, <6.8721, 13.3416, -0.5244> }
					triangle { <6.4893, 13.4429, -0.361>, <6.8721, 13.3416, -0.5244>, <6.6544, 13.3815, -0.6534> }
					triangle { <6.4893, 13.4429, -0.361>, <6.7145, 13.3043, 0.031>, <6.8721, 13.3416, -0.5244> }
					triangle { <6.1142, 13.5106, -0.3352>, <6.7145, 13.2212, 0.1194>, <6.4893, 13.4429, -0.361> }
					triangle { <6.2969, 13.4227, -0.5617>, <6.4893, 13.4429, -0.361>, <6.6544, 13.3815, -0.6534> }
					triangle { <6.1142, 13.5106, -0.3352>, <6.4893, 13.4429, -0.361>, <6.2969, 13.4227, -0.5617> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <4.09819, 10.3073, -1.1462>, <4.2506, 10.6339, -1.2305>, 0.2056 }
			cylinder { <4.2506, 10.6339, -1.2305>, <4.4101, 10.9468, -1.3477>, 0.2056 }
			cylinder { <4.4101, 10.9468, -1.3477>, <4.5751, 11.2428, -1.4966>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.5751, 11.2428, -1.4966>, <4.8294, 11.6494, -1.7764>, 0.2056 }
				cylinder { <4.8294, 11.6494, -1.7764>, <5.08678, 12.0125, -2.1084>, 0.2056 }
				cylinder { <5.08678, 12.0125, -2.1084>, <5.3433, 12.3265, -2.4877>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <5.3433, 12.3265, -2.4877>, <6.1418, 13.6308, -4.1163>, <6.1734, 13.8313, -3.8912> }
					triangle { <5.3433, 12.3265, -2.4877>, <5.814, 12.9035, -3.467>, <6.1418, 13.6308, -4.1163> }
					triangle { <6.1734, 13.8313, -3.8912>, <6.04035, 13.1786, -3.1995>, <5.3433, 12.3265, -2.4877> }
					triangle { <5.814, 12.9035, -3.467>, <5.8526, 13.6856, -4.2666>, <6.1418, 13.6308, -4.1163> }
					triangle { <5.8526, 13.6856, -4.2666>, <5.5475, 14.1276, -4.3336>, <6.1418, 13.6308, -4.1163> }
					triangle { <6.1734, 13.8313, -3.8912>, <6.1343, 14.1903, -3.8092>, <6.4083, 13.9137, -3.7018> }
					triangle { <6.4083, 13.9137, -3.7018>, <6.04035, 13.1786, -3.1995>, <6.1734, 13.8313, -3.8912> }
					triangle { <5.5475, 14.1276, -4.3336>, <5.6649, 14.1485, -4.3125>, <6.04049, 13.9953, -4.07199> }
					triangle { <5.6649, 14.1485, -4.3125>, <5.3662, 14.4752, -4.01745>, <5.9912, 14.3824, -3.8981> }
					triangle { <6.04049, 13.9953, -4.07199>, <5.9912, 14.3824, -3.8981>, <6.1343, 14.1903, -3.8092> }
					triangle { <6.04049, 13.9953, -4.07199>, <5.6649, 14.1485, -4.3125>, <5.9912, 14.3824, -3.8981> }
					triangle { <6.1418, 13.6308, -4.1163>, <5.5475, 14.1276, -4.3336>, <6.04049, 13.9953, -4.07199> }
					triangle { <6.1734, 13.8313, -3.8912>, <6.04049, 13.9953, -4.07199>, <6.1343, 14.1903, -3.8092> }
					triangle { <6.1418, 13.6308, -4.1163>, <6.04049, 13.9953, -4.07199>, <6.1734, 13.8313, -3.8912> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.3433, 12.3265, -2.4877>, <6.269, 13.7935, -3.8956>, <6.5216, 13.7272, -3.7418> }
					triangle { <5.3433, 12.3265, -2.4877>, <5.724, 13.1025, -3.3631>, <6.269, 13.7935, -3.8956> }
					triangle { <6.5216, 13.7272, -3.7418>, <6.1416, 12.9547, -3.3163>, <5.3433, 12.3265, -2.4877> }
					triangle { <5.724, 13.1025, -3.3631>, <6.1331, 14.06425, -3.7634>, <6.269, 13.7935, -3.8956> }
					triangle { <6.1331, 14.06425, -3.7634>, <6.3372, 14.4903, -3.4992>, <6.269, 13.7935, -3.8956> }
					triangle { <6.5216, 13.7272, -3.7418>, <6.8272, 13.8792, -3.5981>, <6.7587, 13.5275, -3.7845> }
					triangle { <6.7587, 13.5275, -3.7845>, <6.1416, 12.9547, -3.3163>, <6.5216, 13.7272, -3.7418> }
					triangle { <6.3372, 14.4903, -3.4992>, <6.4153, 14.4315, -3.5706>, <6.5384, 14.00428, -3.7278> }
					triangle { <6.4153, 14.4315, -3.5706>, <6.6429, 14.5381, -3.1018>, <6.8919, 14.1113, -3.5133> }
					triangle { <6.5384, 14.00428, -3.7278>, <6.8919, 14.1113, -3.5133>, <6.8272, 13.8792, -3.5981> }
					triangle { <6.5384, 14.00428, -3.7278>, <6.4153, 14.4315, -3.5706>, <6.8919, 14.1113, -3.5133> }
					triangle { <6.269, 13.7935, -3.8956>, <6.3372, 14.4903, -3.4992>, <6.5384, 14.00428, -3.7278> }
					triangle { <6.5216, 13.7272, -3.7418>, <6.5384, 14.00428, -3.7278>, <6.8272, 13.8792, -3.5981> }
					triangle { <6.269, 13.7935, -3.8956>, <6.5384, 14.00428, -3.7278>, <6.5216, 13.7272, -3.7418> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.3433, 12.3265, -2.4877>, <6.533, 13.6652, -3.8232>, <6.6436, 13.4031, -3.9277> }
					triangle { <5.3433, 12.3265, -2.4877>, <5.8806, 13.1778, -3.1949>, <6.533, 13.6652, -3.8232> }
					triangle { <6.6436, 13.4031, -3.9277>, <5.9654, 12.8701, -3.5056>, <5.3433, 12.3265, -2.4877> }
					triangle { <5.8806, 13.1778, -3.1949>, <6.7369, 13.7803, -3.59>, <6.533, 13.6652, -3.8232> }
					triangle { <6.7369, 13.7803, -3.59>, <7.2683, 13.7257, -3.5025>, <6.533, 13.6652, -3.8232> }
					triangle { <6.6436, 13.4031, -3.9277>, <6.9562, 13.2396, -4.04053>, <6.5737, 13.2154, -4.1681> }
					triangle { <6.5737, 13.2154, -4.1681>, <5.9654, 12.8701, -3.5056>, <6.6436, 13.4031, -3.9277> }
					triangle { <7.2683, 13.7257, -3.5025>, <7.2327, 13.708, -3.6168>, <6.8852, 13.533, -3.8833> }
					triangle { <7.2327, 13.708, -3.6168>, <7.5759, 13.328, -3.4725>, <7.2053, 13.2733, -3.9952> }
					triangle { <6.8852, 13.533, -3.8833>, <7.2053, 13.2733, -3.9952>, <6.9562, 13.2396, -4.04053> }
					triangle { <6.8852, 13.533, -3.8833>, <7.2327, 13.708, -3.6168>, <7.2053, 13.2733, -3.9952> }
					triangle { <6.533, 13.6652, -3.8232>, <7.2683, 13.7257, -3.5025>, <6.8852, 13.533, -3.8833> }
					triangle { <6.6436, 13.4031, -3.9277>, <6.8852, 13.533, -3.8833>, <6.9562, 13.2396, -4.04053> }
					triangle { <6.533, 13.6652, -3.8232>, <6.8852, 13.533, -3.8833>, <6.6436, 13.4031, -3.9277> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.3433, 12.3265, -2.4877>, <6.5714, 13.422, -3.9986>, <6.3718, 13.3038, -4.1937> }
					triangle { <5.3433, 12.3265, -2.4877>, <6.06893, 13.02601, -3.1932>, <6.5714, 13.422, -3.9986> }
					triangle { <6.3718, 13.3038, -4.1937>, <5.7536, 13.04087, -3.5075>, <5.3433, 12.3265, -2.4877> }
					triangle { <6.06893, 13.02601, -3.1932>, <6.8352, 13.2235, -3.9845>, <6.5714, 13.422, -3.9986> }
					triangle { <6.8352, 13.2235, -3.9845>, <7.0627, 12.8834, -4.3389>, <6.5714, 13.422, -3.9986> }
					triangle { <6.3718, 13.3038, -4.1937>, <6.3441, 13.1494, -4.5291>, <6.1072, 13.4058, -4.326> }
					triangle { <6.1072, 13.4058, -4.326>, <5.7536, 13.04087, -3.5075>, <6.3718, 13.3038, -4.1937> }
					triangle { <7.0627, 12.8834, -4.3389>, <6.995, 12.9711, -4.3876>, <6.6048, 13.2285, -4.3251> }
					triangle { <6.995, 12.9711, -4.3876>, <6.8845, 12.5059, -4.6208>, <6.5012, 13.01857, -4.6823> }
					triangle { <6.6048, 13.2285, -4.3251>, <6.5012, 13.01857, -4.6823>, <6.3441, 13.1494, -4.5291> }
					triangle { <6.6048, 13.2285, -4.3251>, <6.995, 12.9711, -4.3876>, <6.5012, 13.01857, -4.6823> }
					triangle { <6.5714, 13.422, -3.9986>, <7.0627, 12.8834, -4.3389>, <6.6048, 13.2285, -4.3251> }
					triangle { <6.3718, 13.3038, -4.1937>, <6.6048, 13.2285, -4.3251>, <6.3441, 13.1494, -4.5291> }
					triangle { <6.5714, 13.422, -3.9986>, <6.6048, 13.2285, -4.3251>, <6.3718, 13.3038, -4.1937> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.3433, 12.3265, -2.4877>, <6.326, 13.4004, -4.1825>, <6.07683, 13.5725, -4.1708> }
					triangle { <5.3433, 12.3265, -2.4877>, <6.02715, 12.8539, -3.3639>, <6.326, 13.4004, -4.1825> }
					triangle { <6.07683, 13.5725, -4.1708>, <5.8006, 13.2344, -3.3155>, <5.3433, 12.3265, -2.4877> }
					triangle { <6.02715, 12.8539, -3.3639>, <6.2805, 13.1641, -4.4089>, <6.326, 13.4004, -4.1825> }
					triangle { <6.2805, 13.1641, -4.4089>, <5.9831, 13.1355, -4.8603>, <6.326, 13.4004, -4.1825> }
					triangle { <6.07683, 13.5725, -4.1708>, <5.8285, 13.7459, -4.3841>, <6.00354, 13.8439, -4.03351> }
					triangle { <6.00354, 13.8439, -4.03351>, <5.8006, 13.2344, -3.3155>, <6.07683, 13.5725, -4.1708> }
					triangle { <5.9831, 13.1355, -4.8603>, <6.01144, 13.2475, -4.8241>, <6.07488, 13.5185, -4.4434> }
					triangle { <6.01144, 13.2475, -4.8241>, <5.4983, 13.2256, -4.9626>, <5.7395, 13.7143, -4.6214> }
					triangle { <6.07488, 13.5185, -4.4434>, <5.7395, 13.7143, -4.6214>, <5.8285, 13.7459, -4.3841> }
					triangle { <6.07488, 13.5185, -4.4434>, <6.01144, 13.2475, -4.8241>, <5.7395, 13.7143, -4.6214> }
					triangle { <6.326, 13.4004, -4.1825>, <5.9831, 13.1355, -4.8603>, <6.07488, 13.5185, -4.4434> }
					triangle { <6.07683, 13.5725, -4.1708>, <6.07488, 13.5185, -4.4434>, <5.8285, 13.7459, -4.3841> }
					triangle { <6.326, 13.4004, -4.1825>, <6.07488, 13.5185, -4.4434>, <6.07683, 13.5725, -4.1708> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <4.5751, 11.2428, -1.4966>, <4.7142, 11.5589, -1.6297>, 0.2056 }
			cylinder { <4.7142, 11.5589, -1.6297>, <4.8261, 11.8921, -1.7458>, 0.2056 }
			cylinder { <4.8261, 11.8921, -1.7458>, <4.9098, 12.2391, -1.8438>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.9098, 12.2391, -1.8438>, <4.9806, 12.7785, -1.9547>, 0.2056 }
				cylinder { <4.9806, 12.7785, -1.9547>, <4.9958, 13.3287, -2.02805>, 0.2056 }
				cylinder { <4.9958, 13.3287, -2.02805>, <4.9551, 13.8814, -2.06256>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <4.9551, 13.8814, -2.06256>, <4.8997, 16.1128, -1.967>, <5.1269, 16.09118, -2.1665> }
					triangle { <4.9551, 13.8814, -2.06256>, <4.768, 15.09272, -1.9562>, <4.8997, 16.1128, -1.967> }
					triangle { <5.1269, 16.09118, -2.1665>, <4.9706, 15.161, -2.347>, <4.9551, 13.8814, -2.06256> }
					triangle { <4.768, 15.09272, -1.9562>, <5.02812, 16.1412, -1.6638>, <4.8997, 16.1128, -1.967> }
					triangle { <5.02812, 16.1412, -1.6638>, <5.4939, 16.3428, -1.4757>, <4.8997, 16.1128, -1.967> }
					triangle { <5.1269, 16.09118, -2.1665>, <5.454, 16.2392, -2.2573>, <5.1466, 16.09906, -2.4786> }
					triangle { <5.1466, 16.09906, -2.4786>, <4.9706, 15.161, -2.347>, <5.1269, 16.09118, -2.1665> }
					triangle { <5.4939, 16.3428, -1.4757>, <5.4589, 16.3853, -1.5835>, <5.2476, 16.2667, -1.9881> }
					triangle { <5.4589, 16.3853, -1.5835>, <5.9775, 16.2674, -1.5943>, <5.6379, 16.3643, -2.1317> }
					triangle { <5.2476, 16.2667, -1.9881>, <5.6379, 16.3643, -2.1317>, <5.454, 16.2392, -2.2573> }
					triangle { <5.2476, 16.2667, -1.9881>, <5.4589, 16.3853, -1.5835>, <5.6379, 16.3643, -2.1317> }
					triangle { <4.8997, 16.1128, -1.967>, <5.4939, 16.3428, -1.4757>, <5.2476, 16.2667, -1.9881> }
					triangle { <5.1269, 16.09118, -2.1665>, <5.2476, 16.2667, -1.9881>, <5.454, 16.2392, -2.2573> }
					triangle { <4.8997, 16.1128, -1.967>, <5.2476, 16.2667, -1.9881>, <5.1269, 16.09118, -2.1665> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.9551, 13.8814, -2.06256>, <5.04794, 16.1072, -2.2304>, <4.9306, 16.05556, -2.5051> }
					triangle { <4.9551, 13.8814, -2.06256>, <5.007269, 15.1083, -1.9886>, <5.04794, 16.1072, -2.2304> }
					triangle { <4.9306, 16.05556, -2.5051>, <4.7015, 15.1434, -2.3107>, <4.9551, 13.8814, -2.06256> }
					triangle { <5.007269, 15.1083, -1.9886>, <5.3764, 16.1297, -2.2586>, <5.04794, 16.1072, -2.2304> }
					triangle { <5.3764, 16.1297, -2.2586>, <5.7043, 16.2843, -2.6605>, <5.04794, 16.1072, -2.2304> }
					triangle { <4.9306, 16.05556, -2.5051>, <4.9496, 16.1645, -2.8586>, <4.6409, 16.05274, -2.6233> }
					triangle { <4.6409, 16.05274, -2.6233>, <4.7015, 15.1434, -2.3107>, <4.9306, 16.05556, -2.5051> }
					triangle { <5.7043, 16.2843, -2.6605>, <5.5914, 16.3275, -2.6664>, <5.1396, 16.2217, -2.5821> }
					triangle { <5.5914, 16.3275, -2.6664>, <5.7447, 16.1534, -3.1452>, <5.1282, 16.2721, -3.006091> }
					triangle { <5.1396, 16.2217, -2.5821>, <5.1282, 16.2721, -3.006091>, <4.9496, 16.1645, -2.8586> }
					triangle { <5.1396, 16.2217, -2.5821>, <5.5914, 16.3275, -2.6664>, <5.1282, 16.2721, -3.006091> }
					triangle { <5.04794, 16.1072, -2.2304>, <5.7043, 16.2843, -2.6605>, <5.1396, 16.2217, -2.5821> }
					triangle { <4.9306, 16.05556, -2.5051>, <5.1396, 16.2217, -2.5821>, <4.9496, 16.1645, -2.8586> }
					triangle { <5.04794, 16.1072, -2.2304>, <5.1396, 16.2217, -2.5821>, <4.9306, 16.05556, -2.5051> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.9551, 13.8814, -2.06256>, <4.845, 16.07844, -2.4527>, <4.5469, 16.03237, -2.4233> }
					triangle { <4.9551, 13.8814, -2.06256>, <5.05264, 15.09687, -2.2259>, <4.845, 16.07844, -2.4527> }
					triangle { <4.5469, 16.03237, -2.4233>, <4.6505, 15.1563, -2.04377>, <4.9551, 13.8814, -2.06256> }
					triangle { <5.05264, 15.09687, -2.2259>, <4.9228, 16.06414, -2.7736>, <4.845, 16.07844, -2.4527> }
					triangle { <4.9228, 16.06414, -2.7736>, <4.6471, 16.171, -3.227>, <4.845, 16.07844, -2.4527> }
					triangle { <4.5469, 16.03237, -2.4233>, <4.2187, 16.1289, -2.5652>, <4.3429, 16.05797, -2.1875> }
					triangle { <4.3429, 16.05797, -2.1875>, <4.6505, 15.1563, -2.04377>, <4.5469, 16.03237, -2.4233> }
					triangle { <4.6471, 16.171, -3.227>, <4.606, 16.226, -3.1273>, <4.5417, 16.1725, -2.6632> }
					triangle { <4.606, 16.226, -3.1273>, <4.1992, 16.02329, -3.4036>, <4.1365, 16.2123, -2.7922> }
					triangle { <4.5417, 16.1725, -2.6632>, <4.1365, 16.2123, -2.7922>, <4.2187, 16.1289, -2.5652> }
					triangle { <4.5417, 16.1725, -2.6632>, <4.606, 16.226, -3.1273>, <4.1365, 16.2123, -2.7922> }
					triangle { <4.845, 16.07844, -2.4527>, <4.6471, 16.171, -3.227>, <4.5417, 16.1725, -2.6632> }
					triangle { <4.5469, 16.03237, -2.4233>, <4.5417, 16.1725, -2.6632>, <4.2187, 16.1289, -2.5652> }
					triangle { <4.845, 16.07844, -2.4527>, <4.5417, 16.1725, -2.6632>, <4.5469, 16.03237, -2.4233> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.9551, 13.8814, -2.06256>, <4.5696, 16.06588, -2.3287>, <4.5025, 16.05344, -2.03341> }
					triangle { <4.9551, 13.8814, -2.06256>, <4.8419, 15.07406, -2.3424>, <4.5696, 16.06588, -2.3287> }
					triangle { <4.5025, 16.05344, -2.03341>, <4.8875, 15.182, -1.9126>, <4.9551, 13.8814, -2.06256> }
					triangle { <4.8419, 15.07406, -2.3424>, <4.2899, 16.03444, -2.5018>, <4.5696, 16.06588, -2.3287> }
					triangle { <4.2899, 16.03444, -2.5018>, <3.7734, 16.1584, -2.3976>, <4.5696, 16.06588, -2.3287> }
					triangle { <4.5025, 16.05344, -2.03341>, <4.2646, 16.1813, -1.78>, <4.6616, 16.1075, -1.7695> }
					triangle { <4.6616, 16.1075, -1.7695>, <4.8875, 15.182, -1.9126>, <4.5025, 16.05344, -2.03341> }
					triangle { <3.7734, 16.1584, -2.3976>, <3.8554, 16.2203, -2.3335>, <4.2746, 16.1867, -2.1201> }
					triangle { <3.8554, 16.2203, -2.3335>, <3.4624, 16.05567, -2.01499>, <4.02403, 16.267, -1.7837> }
					triangle { <4.2746, 16.1867, -2.1201>, <4.02403, 16.267, -1.7837>, <4.2646, 16.1813, -1.78> }
					triangle { <4.2746, 16.1867, -2.1201>, <3.8554, 16.2203, -2.3335>, <4.02403, 16.267, -1.7837> }
					triangle { <4.5696, 16.06588, -2.3287>, <3.7734, 16.1584, -2.3976>, <4.2746, 16.1867, -2.1201> }
					triangle { <4.5025, 16.05344, -2.03341>, <4.2746, 16.1867, -2.1201>, <4.2646, 16.1813, -1.78> }
					triangle { <4.5696, 16.06588, -2.3287>, <4.2746, 16.1867, -2.1201>, <4.5025, 16.05344, -2.03341> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.9551, 13.8814, -2.06256>, <4.6039, 16.08743, -2.024>, <4.8664, 16.09033, -1.8723> }
					triangle { <4.9551, 13.8814, -2.06256>, <4.6634, 15.07146, -2.1732>, <4.6039, 16.08743, -2.024> }
					triangle { <4.8664, 16.09033, -1.8723>, <5.08839, 15.1849, -2.1029>, <4.9551, 13.8814, -2.06256> }
					triangle { <4.6634, 15.07146, -2.1732>, <4.356, 16.08278, -1.8056>, <4.6039, 16.08743, -2.024> }
					triangle { <4.356, 16.08278, -1.8056>, <4.3046, 16.2661, -1.2989>, <4.6039, 16.08743, -2.024> }
					triangle { <4.8664, 16.09033, -1.8723>, <5.03961, 16.2505, -1.5868>, <5.1658, 16.1333, -1.9521> }
					triangle { <5.1658, 16.1333, -1.9521>, <5.08839, 15.1849, -2.1029>, <4.8664, 16.09033, -1.8723> }
					triangle { <4.3046, 16.2661, -1.2989>, <4.3904, 16.3202, -1.365>, <4.7174, 16.2458, -1.6966> }
					triangle { <4.3904, 16.3202, -1.365>, <4.5781, 16.2088, -0.8799>, <4.9659, 16.3623, -1.3693> }
					triangle { <4.7174, 16.2458, -1.6966>, <4.9659, 16.3623, -1.3693>, <5.03961, 16.2505, -1.5868> }
					triangle { <4.7174, 16.2458, -1.6966>, <4.3904, 16.3202, -1.365>, <4.9659, 16.3623, -1.3693> }
					triangle { <4.6039, 16.08743, -2.024>, <4.3046, 16.2661, -1.2989>, <4.7174, 16.2458, -1.6966> }
					triangle { <4.8664, 16.09033, -1.8723>, <4.7174, 16.2458, -1.6966>, <5.03961, 16.2505, -1.5868> }
					triangle { <4.6039, 16.08743, -2.024>, <4.7174, 16.2458, -1.6966>, <4.8664, 16.09033, -1.8723> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <4.9098, 12.2391, -1.8438>, <5.0282, 12.5777, -1.9352>, 0.2056 }
			cylinder { <5.0282, 12.5777, -1.9352>, <5.1801, 12.9047, -2.01919>, 0.2056 }
			cylinder { <5.1801, 12.9047, -2.01919>, <5.3642, 13.2167, -2.09489>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <5.3642, 13.2167, -2.09489>, <5.6968, 13.6508, -2.1914>, 0.2056 }
				cylinder { <5.6968, 13.6508, -2.1914>, <6.08083, 14.04418, -2.2695>, 0.2056 }
				cylinder { <6.08083, 14.04418, -2.2695>, <6.5104, 14.3909, -2.328>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <6.5104, 14.3909, -2.328>, <8.2789, 15.6662, -2.7884>, <8.06853, 15.8769, -2.8405> }
					triangle { <6.5104, 14.3909, -2.328>, <7.5713, 14.9862, -2.4891>, <8.2789, 15.6662, -2.7884> }
					triangle { <8.06853, 15.8769, -2.8405>, <7.3659, 15.3751, -2.4258>, <6.5104, 14.3909, -2.328> }
					triangle { <7.5713, 14.9862, -2.4891>, <8.3564, 15.522, -3.07459>, <8.2789, 15.6662, -2.7884> }
					triangle { <8.3564, 15.522, -3.07459>, <8.3499, 15.6907, -3.5874>, <8.2789, 15.6662, -2.7884> }
					triangle { <8.06853, 15.8769, -2.8405>, <7.9803, 16.1537, -3.06872>, <7.9405, 16.1053, -2.6707> }
					triangle { <7.9405, 16.1053, -2.6707>, <7.3659, 15.3751, -2.4258>, <8.06853, 15.8769, -2.8405> }
					triangle { <8.3499, 15.6907, -3.5874>, <8.3572, 15.7781, -3.5044>, <8.2125, 15.9061, -3.07559> }
					triangle { <8.3572, 15.7781, -3.5044>, <8.001212, 15.9094, -3.8753>, <8.03298, 16.2125, -3.3109> }
					triangle { <8.2125, 15.9061, -3.07559>, <8.03298, 16.2125, -3.3109>, <7.9803, 16.1537, -3.06872> }
					triangle { <8.2125, 15.9061, -3.07559>, <8.3572, 15.7781, -3.5044>, <8.03298, 16.2125, -3.3109> }
					triangle { <8.2789, 15.6662, -2.7884>, <8.3499, 15.6907, -3.5874>, <8.2125, 15.9061, -3.07559> }
					triangle { <8.06853, 15.8769, -2.8405>, <8.2125, 15.9061, -3.07559>, <7.9803, 16.1537, -3.06872> }
					triangle { <8.2789, 15.6662, -2.7884>, <8.2125, 15.9061, -3.07559>, <8.06853, 15.8769, -2.8405> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.5104, 14.3909, -2.328>, <8.09527, 15.9012, -2.7444>, <8.005813, 16.01561, -2.4792> }
					triangle { <6.5104, 14.3909, -2.328>, <7.4497, 15.1085, -2.6578>, <8.09527, 15.9012, -2.7444> }
					triangle { <8.005813, 16.01561, -2.4792>, <7.5027, 15.2376, -2.236>, <6.5104, 14.3909, -2.328> }
					triangle { <7.4497, 15.1085, -2.6578>, <7.9354, 16.05849, -2.986>, <8.09527, 15.9012, -2.7444> }
					triangle { <7.9354, 16.05849, -2.986>, <7.7281, 16.555, -3.03031>, <8.09527, 15.9012, -2.7444> }
					triangle { <8.005813, 16.01561, -2.4792>, <7.9388, 16.3341, -2.3044>, <8.1028, 15.9863, -2.1841> }
					triangle { <8.1028, 15.9863, -2.1841>, <7.5027, 15.2376, -2.236>, <8.005813, 16.01561, -2.4792> }
					triangle { <7.7281, 16.555, -3.03031>, <7.8157, 16.5428, -2.948>, <7.9965, 16.2492, -2.6281> }
					triangle { <7.8157, 16.5428, -2.948>, <7.4151, 16.8259, -2.7456>, <7.8722, 16.5694, -2.3759> }
					triangle { <7.9965, 16.2492, -2.6281>, <7.8722, 16.5694, -2.3759>, <7.9388, 16.3341, -2.3044> }
					triangle { <7.9965, 16.2492, -2.6281>, <7.8157, 16.5428, -2.948>, <7.8722, 16.5694, -2.3759> }
					triangle { <8.09527, 15.9012, -2.7444>, <7.7281, 16.555, -3.03031>, <7.9965, 16.2492, -2.6281> }
					triangle { <8.005813, 16.01561, -2.4792>, <7.9965, 16.2492, -2.6281>, <7.9388, 16.3341, -2.3044> }
					triangle { <8.09527, 15.9012, -2.7444>, <7.9965, 16.2492, -2.6281>, <8.005813, 16.01561, -2.4792> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.5104, 14.3909, -2.328>, <8.08727, 15.961, -2.4489>, <8.2142, 15.7999, -2.2268> }
					triangle { <6.5104, 14.3909, -2.328>, <7.3237, 15.2829, -2.5488>, <8.08727, 15.961, -2.4489> }
					triangle { <8.2142, 15.7999, -2.2268>, <7.6444, 15.04134, -2.3586>, <6.5104, 14.3909, -2.328> }
					triangle { <7.3237, 15.2829, -2.5488>, <7.9095, 16.2038, -2.3144>, <8.08727, 15.961, -2.4489> }
					triangle { <7.9095, 16.2038, -2.3144>, <7.95, 16.479, -1.8517>, <8.08727, 15.961, -2.4489> }
					triangle { <8.2142, 15.7999, -2.2268>, <8.3971, 15.8332, -1.9076>, <8.4305, 15.5752, -2.2151> }
					triangle { <8.4305, 15.5752, -2.2151>, <7.6444, 15.04134, -2.3586>, <8.2142, 15.7999, -2.2268> }
					triangle { <7.95, 16.479, -1.8517>, <8.05236, 16.4281, -1.8905>, <8.2284, 16.04973, -2.1075> }
					triangle { <8.05236, 16.4281, -1.8905>, <7.993, 16.342, -1.3703>, <8.412, 16.01041, -1.725> }
					triangle { <8.2284, 16.04973, -2.1075>, <8.412, 16.01041, -1.725>, <8.3971, 15.8332, -1.9076> }
					triangle { <8.2284, 16.04973, -2.1075>, <8.05236, 16.4281, -1.8905>, <8.412, 16.01041, -1.725> }
					triangle { <8.08727, 15.961, -2.4489>, <7.95, 16.479, -1.8517>, <8.2284, 16.04973, -2.1075> }
					triangle { <8.2142, 15.7999, -2.2268>, <8.2284, 16.04973, -2.1075>, <8.3971, 15.8332, -1.9076> }
					triangle { <8.08727, 15.961, -2.4489>, <8.2284, 16.04973, -2.1075>, <8.2142, 15.7999, -2.2268> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.5104, 14.3909, -2.328>, <8.2659, 15.7634, -2.3076>, <8.4077, 15.5259, -2.4297> }
					triangle { <6.5104, 14.3909, -2.328>, <7.3663, 15.2702, -2.3117>, <8.2659, 15.7634, -2.3076> }
					triangle { <8.4077, 15.5259, -2.4297>, <7.5965, 15.05572, -2.6254>, <6.5104, 14.3909, -2.328> }
					triangle { <7.3663, 15.2702, -2.3117>, <8.3143, 15.7585, -1.9816>, <8.2659, 15.7634, -2.3076> }
					triangle { <8.3143, 15.7585, -1.9816>, <8.7109, 15.567, -1.6694>, <8.2659, 15.7634, -2.3076> }
					triangle { <8.4077, 15.5259, -2.4297>, <8.7261, 15.3387, -2.4229>, <8.4737, 15.4363, -2.7213> }
					triangle { <8.4737, 15.4363, -2.7213>, <7.5965, 15.05572, -2.6254>, <8.4077, 15.5259, -2.4297> }
					triangle { <8.7109, 15.567, -1.6694>, <8.7423, 15.5914, -1.7834>, <8.59, 15.5814, -2.2283> }
					triangle { <8.7423, 15.5914, -1.7834>, <8.9416, 15.1219, -1.6371>, <8.9114, 15.3028, -2.2517> }
					triangle { <8.59, 15.5814, -2.2283>, <8.9114, 15.3028, -2.2517>, <8.7261, 15.3387, -2.4229> }
					triangle { <8.59, 15.5814, -2.2283>, <8.7423, 15.5914, -1.7834>, <8.9114, 15.3028, -2.2517> }
					triangle { <8.2659, 15.7634, -2.3076>, <8.7109, 15.567, -1.6694>, <8.59, 15.5814, -2.2283> }
					triangle { <8.4077, 15.5259, -2.4297>, <8.59, 15.5814, -2.2283>, <8.7261, 15.3387, -2.4229> }
					triangle { <8.2659, 15.7634, -2.3076>, <8.59, 15.5814, -2.2283>, <8.4077, 15.5259, -2.4297> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.5104, 14.3909, -2.328>, <8.3862, 15.5785, -2.5206>, <8.3163, 15.5743, -2.8147> }
					triangle { <6.5104, 14.3909, -2.328>, <7.5216, 15.08407, -2.2742>, <8.3862, 15.5785, -2.5206> }
					triangle { <8.3163, 15.5743, -2.8147>, <7.4217, 15.2651, -2.6675>, <6.5104, 14.3909, -2.328> }
					triangle { <7.5216, 15.08407, -2.2742>, <8.5946, 15.3308, -2.4585>, <8.3862, 15.5785, -2.5206> }
					triangle { <8.5946, 15.3308, -2.4585>, <8.9619, 15.07251, -2.7583>, <8.3862, 15.5785, -2.5206> }
					triangle { <8.3163, 15.5743, -2.8147>, <8.4646, 15.5398, -3.1513>, <8.1663, 15.7689, -3.007138> }
					triangle { <8.1663, 15.7689, -3.007138>, <7.4217, 15.2651, -2.6675>, <8.3163, 15.5743, -2.8147> }
					triangle { <8.9619, 15.07251, -2.7583>, <8.9335, 15.1836, -2.7959>, <8.58, 15.4913, -2.8357> }
					triangle { <8.9335, 15.1836, -2.7959>, <8.9467, 14.8505, -3.2087>, <8.6736, 15.4296, -3.2467> }
					triangle { <8.58, 15.4913, -2.8357>, <8.6736, 15.4296, -3.2467>, <8.4646, 15.5398, -3.1513> }
					triangle { <8.58, 15.4913, -2.8357>, <8.9335, 15.1836, -2.7959>, <8.6736, 15.4296, -3.2467> }
					triangle { <8.3862, 15.5785, -2.5206>, <8.9619, 15.07251, -2.7583>, <8.58, 15.4913, -2.8357> }
					triangle { <8.3163, 15.5743, -2.8147>, <8.58, 15.4913, -2.8357>, <8.4646, 15.5398, -3.1513> }
					triangle { <8.3862, 15.5785, -2.5206>, <8.58, 15.4913, -2.8357>, <8.3163, 15.5743, -2.8147> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <2.6809, 7.4814, -0.247>, <2.9587, 7.7255, -0.2603>, 0.2056 }
			cylinder { <2.9587, 7.7255, -0.2603>, <3.2429, 7.9618, -0.2388>, 0.2056 }
			cylinder { <3.2429, 7.9618, -0.2388>, <3.5306, 8.1878, -0.1826>, 0.2056 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <3.5306, 8.1878, -0.1826>, <3.8318, 8.3686, -0.06582>, 0.2056 }
			cylinder { <3.8318, 8.3686, -0.06582>, <4.1479, 8.5415, 0.01885>, 0.2056 }
			cylinder { <4.1479, 8.5415, 0.01885>, <4.476, 8.7048, 0.0706>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.476, 8.7048, 0.0706>, <4.984, 8.9286, 0.08549>, 0.2056 }
				cylinder { <4.984, 8.9286, 0.08549>, <5.5001, 9.1277, 0.03741>, 0.2056 }
				cylinder { <5.5001, 9.1277, 0.03741>, <6.01659, 9.2991, -0.0729>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <6.01659, 9.2991, -0.0729>, <7.981, 10.1789, -0.6498>, <7.9853, 10.2682, -0.361> }
					triangle { <6.01659, 9.2991, -0.0729>, <7.09861, 9.6732, -0.5145>, <7.981, 10.1789, -0.6498> }
					triangle { <7.9853, 10.2682, -0.361>, <7.2621, 9.696, -0.102>, <6.01659, 9.2991, -0.0729> }
					triangle { <7.09861, 9.6732, -0.5145>, <7.8602, 10.4242, -0.8339>, <7.981, 10.1789, -0.6498> }
					triangle { <7.8602, 10.4242, -0.8339>, <7.8594, 10.9614, -0.7797>, <7.981, 10.1789, -0.6498> }
					triangle { <7.9853, 10.2682, -0.361>, <8.07607, 10.5522, -0.1428>, <8.1074, 10.153, -0.09793> }
					triangle { <8.1074, 10.153, -0.09793>, <7.2621, 9.696, -0.102>, <7.9853, 10.2682, -0.361> }
					triangle { <7.8594, 10.9614, -0.7797>, <7.9468, 10.9037, -0.7196>, <8.04537, 10.512, -0.4785> }
					triangle { <7.9468, 10.9037, -0.7196>, <7.7252, 11.2715, -0.408>, <8.0966, 10.8044, -0.1729> }
					triangle { <8.04537, 10.512, -0.4785>, <8.0966, 10.8044, -0.1729>, <8.07607, 10.5522, -0.1428> }
					triangle { <8.04537, 10.512, -0.4785>, <7.9468, 10.9037, -0.7196>, <8.0966, 10.8044, -0.1729> }
					triangle { <7.981, 10.1789, -0.6498>, <7.8594, 10.9614, -0.7797>, <8.04537, 10.512, -0.4785> }
					triangle { <7.9853, 10.2682, -0.361>, <8.04537, 10.512, -0.4785>, <8.07607, 10.5522, -0.1428> }
					triangle { <7.981, 10.1789, -0.6498>, <8.04537, 10.512, -0.4785>, <7.9853, 10.2682, -0.361> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.01659, 9.2991, -0.0729>, <8.04262, 10.1832, -0.3547>, <8.1291, 9.9498, -0.183> }
					triangle { <6.01659, 9.2991, -0.0729>, <7.0693, 9.8588, -0.3632>, <8.04262, 10.1832, -0.3547> }
					triangle { <8.1291, 9.9498, -0.183>, <7.2951, 9.4872, -0.2722>, <6.01659, 9.2991, -0.0729> }
					triangle { <7.0693, 9.8588, -0.3632>, <7.997, 10.4455, -0.1603>, <8.04262, 10.1832, -0.3547> }
					triangle { <7.997, 10.4455, -0.1603>, <8.2126, 10.5991, 0.3101>, <8.04262, 10.1832, -0.3547> }
					triangle { <8.1291, 9.9498, -0.183>, <8.3572, 9.8564, 0.09207>, <8.2392, 9.6638, -0.2415> }
					triangle { <8.2392, 9.6638, -0.2415>, <7.2951, 9.4872, -0.2722>, <8.1291, 9.9498, -0.183> }
					triangle { <8.2126, 10.5991, 0.3101>, <8.2795, 10.5223, 0.2454>, <8.258, 10.1516, -0.04324> }
					triangle { <8.2795, 10.5223, 0.2454>, <8.2722, 10.3715, 0.754>, <8.4681, 9.98, 0.2852> }
					triangle { <8.258, 10.1516, -0.04324>, <8.4681, 9.98, 0.2852>, <8.3572, 9.8564, 0.09207> }
					triangle { <8.258, 10.1516, -0.04324>, <8.2795, 10.5223, 0.2454>, <8.4681, 9.98, 0.2852> }
					triangle { <8.04262, 10.1832, -0.3547>, <8.2126, 10.5991, 0.3101>, <8.258, 10.1516, -0.04324> }
					triangle { <8.1291, 9.9498, -0.183>, <8.258, 10.1516, -0.04324>, <8.3572, 9.8564, 0.09207> }
					triangle { <8.04262, 10.1832, -0.3547>, <8.258, 10.1516, -0.04324>, <8.1291, 9.9498, -0.183> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.01659, 9.2991, -0.0729>, <8.1493, 9.9123, -0.2763>, <8.1663, 9.6657, -0.4504> }
					triangle { <6.01659, 9.2991, -0.0729>, <7.1394, 9.789, -0.1433>, <8.1493, 9.9123, -0.2763> }
					triangle { <8.1663, 9.6657, -0.4504>, <7.2161, 9.5658, -0.5197>, <6.01659, 9.2991, -0.0729> }
					triangle { <7.1394, 9.789, -0.1433>, <8.2414, 9.8315, 0.0296>, <8.1493, 9.9123, -0.2763> }
					triangle { <8.2414, 9.8315, 0.0296>, <8.5746, 9.4562, 0.2285>, <8.1493, 9.9123, -0.2763> }
					triangle { <8.1663, 9.6657, -0.4504>, <8.383, 9.3776, -0.5311>, <8.1461, 9.6123, -0.7572> }
					triangle { <8.1461, 9.6123, -0.7572>, <7.2161, 9.5658, -0.5197>, <8.1663, 9.6657, -0.4504> }
					triangle { <8.5746, 9.4562, 0.2285>, <8.595, 9.4876, 0.1137>, <8.3843, 9.6139, -0.2873> }
					triangle { <8.595, 9.4876, 0.1137>, <8.6148, 8.9596, 0.1633>, <8.5635, 9.2466, -0.4079> }
					triangle { <8.3843, 9.6139, -0.2873>, <8.5635, 9.2466, -0.4079>, <8.383, 9.3776, -0.5311> }
					triangle { <8.3843, 9.6139, -0.2873>, <8.595, 9.4876, 0.1137>, <8.5635, 9.2466, -0.4079> }
					triangle { <8.1493, 9.9123, -0.2763>, <8.5746, 9.4562, 0.2285>, <8.3843, 9.6139, -0.2873> }
					triangle { <8.1663, 9.6657, -0.4504>, <8.3843, 9.6139, -0.2873>, <8.383, 9.3776, -0.5311> }
					triangle { <8.1493, 9.9123, -0.2763>, <8.3843, 9.6139, -0.2873>, <8.1663, 9.6657, -0.4504> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.01659, 9.2991, -0.0729>, <8.1546, 9.738, -0.5223>, <8.04595, 9.8057, -0.7962> }
					triangle { <6.01659, 9.2991, -0.0729>, <7.2128, 9.5595, -0.1565>, <8.1546, 9.738, -0.5223> }
					triangle { <8.04595, 9.8057, -0.7962>, <7.1336, 9.8239, -0.5048>, <6.01659, 9.2991, -0.0729> }
					triangle { <7.2128, 9.5595, -0.1565>, <8.258, 9.425, -0.5247>, <8.1546, 9.738, -0.5223> }
					triangle { <8.258, 9.425, -0.5247>, <8.4486, 9.1014, -0.9126>, <8.1546, 9.738, -0.5223> }
					triangle { <8.04595, 9.8057, -0.7962>, <8.1181, 9.773, -1.1571>, <7.956, 10.06925, -0.9373> }
					triangle { <7.956, 10.06925, -0.9373>, <7.1336, 9.8239, -0.5048>, <8.04595, 9.8057, -0.7962> }
					triangle { <8.4486, 9.1014, -0.9126>, <8.4601, 9.2197, -0.9338>, <8.251, 9.637, -0.8758> }
					triangle { <8.4601, 9.2197, -0.9338>, <8.2827, 8.9739, -1.3693>, <8.2518, 9.6109, -1.301> }
					triangle { <8.251, 9.637, -0.8758>, <8.2518, 9.6109, -1.301>, <8.1181, 9.773, -1.1571> }
					triangle { <8.251, 9.637, -0.8758>, <8.4601, 9.2197, -0.9338>, <8.2518, 9.6109, -1.301> }
					triangle { <8.1546, 9.738, -0.5223>, <8.4486, 9.1014, -0.9126>, <8.251, 9.637, -0.8758> }
					triangle { <8.04595, 9.8057, -0.7962>, <8.251, 9.637, -0.8758>, <8.1181, 9.773, -1.1571> }
					triangle { <8.1546, 9.738, -0.5223>, <8.251, 9.637, -0.8758>, <8.04595, 9.8057, -0.7962> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.01659, 9.2991, -0.0729>, <8.04904, 9.9053, -0.7567>, <7.9324, 10.1837, -0.7401> }
					triangle { <6.01659, 9.2991, -0.0729>, <7.1871, 9.4869, -0.3895>, <8.04904, 9.9053, -0.7567> }
					triangle { <7.9324, 10.1837, -0.7401>, <7.1625, 9.9056, -0.2427>, <6.01659, 9.2991, -0.0729> }
					triangle { <7.1871, 9.4869, -0.3895>, <8.01886, 9.7968, -1.06651>, <8.04904, 9.9053, -0.7567> }
					triangle { <8.01886, 9.7968, -1.06651>, <7.9999, 10.04581, -1.5452>, <8.04904, 9.9053, -0.7567> }
					triangle { <7.9324, 10.1837, -0.7401>, <7.9254, 10.5099, -0.9134>, <7.9317, 10.4085, -0.5236> }
					triangle { <7.9317, 10.4085, -0.5236>, <7.1625, 9.9056, -0.2427>, <7.9324, 10.1837, -0.7401> }
					triangle { <7.9999, 10.04581, -1.5452>, <8.05352, 10.1081, -1.4567>, <8.03832, 10.2004, -0.9958> }
					triangle { <8.05352, 10.1081, -1.4567>, <7.7246, 10.4242, -1.7278>, <7.9589, 10.5881, -1.1536> }
					triangle { <8.03832, 10.2004, -0.9958>, <7.9589, 10.5881, -1.1536>, <7.9254, 10.5099, -0.9134> }
					triangle { <8.03832, 10.2004, -0.9958>, <8.05352, 10.1081, -1.4567>, <7.9589, 10.5881, -1.1536> }
					triangle { <8.04904, 9.9053, -0.7567>, <7.9999, 10.04581, -1.5452>, <8.03832, 10.2004, -0.9958> }
					triangle { <7.9324, 10.1837, -0.7401>, <8.03832, 10.2004, -0.9958>, <7.9254, 10.5099, -0.9134> }
					triangle { <8.04904, 9.9053, -0.7567>, <8.03832, 10.2004, -0.9958>, <7.9324, 10.1837, -0.7401> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <3.5306, 8.1878, -0.1826>, <3.7926, 8.4492, -0.1894>, 0.2056 }
			cylinder { <3.7926, 8.4492, -0.1894>, <4.04263, 8.721, -0.1635>, 0.2056 }
			cylinder { <4.04263, 8.721, -0.1635>, <4.2782, 9.000484, -0.1051>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.2782, 9.000484, -0.1051>, <4.5999, 9.4284, 0.04206>, 0.2056 }
				cylinder { <4.5999, 9.4284, 0.04206>, <4.8851, 9.8586, 0.2466>, 0.2056 }
				cylinder { <4.8851, 9.8586, 0.2466>, <5.1294, 10.2847, 0.5055>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <5.1294, 10.2847, 0.5055>, <6.2376, 11.8183, 1.6827>, <6.3915, 11.8533, 1.4248> }
					triangle { <5.1294, 10.2847, 0.5055>, <5.6057, 11.1346, 1.2516>, <6.2376, 11.8183, 1.6827> }
					triangle { <6.3915, 11.8533, 1.4248>, <5.7588, 11.3605, 0.901>, <5.1294, 10.2847, 0.5055> }
					triangle { <5.6057, 11.1346, 1.2516>, <6.4018, 11.6071, 1.8753>, <6.2376, 11.8183, 1.6827> }
					triangle { <6.4018, 11.6071, 1.8753>, <6.9243, 11.4797, 1.9231>, <6.2376, 11.8183, 1.6827> }
					triangle { <6.3915, 11.8533, 1.4248>, <6.7314, 11.9076, 1.2907>, <6.3697, 12.04733, 1.1813> }
					triangle { <6.3697, 12.04733, 1.1813>, <5.7588, 11.3605, 0.901>, <6.3915, 11.8533, 1.4248> }
					triangle { <6.9243, 11.4797, 1.9231>, <6.9019, 11.5885, 1.8756>, <6.6076, 11.8264, 1.5963> }
					triangle { <6.9019, 11.5885, 1.8756>, <7.2784, 11.3423, 1.5942>, <6.9679, 11.8573, 1.371> }
					triangle { <6.6076, 11.8264, 1.5963>, <6.9679, 11.8573, 1.371>, <6.7314, 11.9076, 1.2907> }
					triangle { <6.6076, 11.8264, 1.5963>, <6.9019, 11.5885, 1.8756>, <6.9679, 11.8573, 1.371> }
					triangle { <6.2376, 11.8183, 1.6827>, <6.9243, 11.4797, 1.9231>, <6.6076, 11.8264, 1.5963> }
					triangle { <6.3915, 11.8533, 1.4248>, <6.6076, 11.8264, 1.5963>, <6.7314, 11.9076, 1.2907> }
					triangle { <6.2376, 11.8183, 1.6827>, <6.6076, 11.8264, 1.5963>, <6.3915, 11.8533, 1.4248> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.1294, 10.2847, 0.5055>, <6.3242, 11.9304, 1.4165>, <6.1613, 12.1037, 1.2299> }
					triangle { <5.1294, 10.2847, 0.5055>, <5.8115, 11.08763, 1.1348>, <6.3242, 11.9304, 1.4165> }
					triangle { <6.1613, 12.1037, 1.2299>, <5.5273, 11.4134, 1.03244>, <5.1294, 10.2847, 0.5055> }
					triangle { <5.8115, 11.08763, 1.1348>, <6.6096, 11.8564, 1.269>, <6.3242, 11.9304, 1.4165> }
					triangle { <6.6096, 11.8564, 1.269>, <6.9113, 12.1092, 0.8995>, <6.3242, 11.9304, 1.4165> }
					triangle { <6.1613, 12.1037, 1.2299>, <6.1851, 12.3951, 1.004066>, <5.8989, 12.2702, 1.2587> }
					triangle { <5.8989, 12.2702, 1.2587>, <5.5273, 11.4134, 1.03244>, <6.1613, 12.1037, 1.2299> }
					triangle { <6.9113, 12.1092, 0.8995>, <6.8371, 12.1803, 0.9629>, <6.4126, 12.2007, 1.1644> }
					triangle { <6.8371, 12.1803, 0.9629>, <6.8125, 12.3061, 0.448>, <6.3711, 12.5047, 0.8688> }
					triangle { <6.4126, 12.2007, 1.1644>, <6.3711, 12.5047, 0.8688>, <6.1851, 12.3951, 1.004066> }
					triangle { <6.4126, 12.2007, 1.1644>, <6.8371, 12.1803, 0.9629>, <6.3711, 12.5047, 0.8688> }
					triangle { <6.3242, 11.9304, 1.4165>, <6.9113, 12.1092, 0.8995>, <6.4126, 12.2007, 1.1644> }
					triangle { <6.1613, 12.1037, 1.2299>, <6.4126, 12.2007, 1.1644>, <6.1851, 12.3951, 1.004066> }
					triangle { <6.3242, 11.9304, 1.4165>, <6.4126, 12.2007, 1.1644>, <6.1613, 12.1037, 1.2299> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.1294, 10.2847, 0.5055>, <6.1078, 12.1152, 1.3168>, <5.8362, 12.1618, 1.4411> }
					triangle { <5.1294, 10.2847, 0.5055>, <5.8117, 11.2128, 0.9286>, <6.1078, 12.1152, 1.3168> }
					triangle { <5.8362, 12.1618, 1.4411>, <5.527, 11.2726, 1.2644>, <5.1294, 10.2847, 0.5055> }
					triangle { <5.8117, 11.2128, 0.9286>, <6.1226, 12.2799, 1.03171>, <6.1078, 12.1152, 1.3168> }
					triangle { <6.1226, 12.2799, 1.03171>, <5.8827, 12.7286, 0.8509>, <6.1078, 12.1152, 1.3168> }
					triangle { <5.8362, 12.1618, 1.4411>, <5.5889, 12.4259, 1.5159>, <5.7089, 12.09944, 1.7191> }
					triangle { <5.7089, 12.09944, 1.7191>, <5.527, 11.2726, 1.2644>, <5.8362, 12.1618, 1.4411> }
					triangle { <5.8827, 12.7286, 0.8509>, <5.8897, 12.7187, 0.971>, <5.871, 12.4122, 1.3274> }
					triangle { <5.8897, 12.7187, 0.971>, <5.4044, 12.881, 0.8306>, <5.5313, 12.6534, 1.4166> }
					triangle { <5.871, 12.4122, 1.3274>, <5.5313, 12.6534, 1.4166>, <5.5889, 12.4259, 1.5159> }
					triangle { <5.871, 12.4122, 1.3274>, <5.8897, 12.7187, 0.971>, <5.5313, 12.6534, 1.4166> }
					triangle { <6.1078, 12.1152, 1.3168>, <5.8827, 12.7286, 0.8509>, <5.871, 12.4122, 1.3274> }
					triangle { <5.8362, 12.1618, 1.4411>, <5.871, 12.4122, 1.3274>, <5.5889, 12.4259, 1.5159> }
					triangle { <6.1078, 12.1152, 1.3168>, <5.871, 12.4122, 1.3274>, <5.8362, 12.1618, 1.4411> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.1294, 10.2847, 0.5055>, <5.8854, 12.119, 1.5204>, <5.8624, 11.9478, 1.7685> }
					triangle { <5.1294, 10.2847, 0.5055>, <5.6061, 11.3383, 0.916>, <5.8854, 12.119, 1.5204> }
					triangle { <5.8624, 11.9478, 1.7685>, <5.7583, 11.1314, 1.2785>, <5.1294, 10.2847, 0.5055> }
					triangle { <5.6061, 11.3383, 0.916>, <5.6093, 12.2963, 1.489>, <5.8854, 12.119, 1.5204> }
					triangle { <5.6093, 12.2963, 1.489>, <5.2504, 12.4877, 1.844>, <5.8854, 12.119, 1.5204> }
					triangle { <5.8624, 11.9478, 1.7685>, <5.7612, 11.9577, 2.1237>, <6.06049, 11.7692, 1.9307> }
					triangle { <6.06049, 11.7692, 1.9307>, <5.7583, 11.1314, 1.2785>, <5.8624, 11.9478, 1.7685> }
					triangle { <5.2504, 12.4877, 1.844>, <5.36, 12.4646, 1.8889>, <5.7262, 12.1706, 1.8616> }
					triangle { <5.36, 12.4646, 1.8889>, <4.9869, 12.278, 2.2168>, <5.6012, 12.09928, 2.2625> }
					triangle { <5.7262, 12.1706, 1.8616>, <5.6012, 12.09928, 2.2625>, <5.7612, 11.9577, 2.1237> }
					triangle { <5.7262, 12.1706, 1.8616>, <5.36, 12.4646, 1.8889>, <5.6012, 12.09928, 2.2625> }
					triangle { <5.8854, 12.119, 1.5204>, <5.2504, 12.4877, 1.844>, <5.7262, 12.1706, 1.8616> }
					triangle { <5.8624, 11.9478, 1.7685>, <5.7262, 12.1706, 1.8616>, <5.7612, 11.9577, 2.1237> }
					triangle { <5.8854, 12.119, 1.5204>, <5.7262, 12.1706, 1.8616>, <5.8624, 11.9478, 1.7685> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.1294, 10.2847, 0.5055>, <5.9668, 11.9327, 1.75>, <6.2108, 11.7543, 1.7583> }
					triangle { <5.1294, 10.2847, 0.5055>, <5.4769, 11.2893, 1.1187>, <5.9668, 11.9327, 1.75> }
					triangle { <6.2108, 11.7543, 1.7583>, <5.9037, 11.1865, 1.05059>, <5.1294, 10.2847, 0.5055> }
					triangle { <5.4769, 11.2893, 1.1187>, <5.7845, 11.8742, 2.01831>, <5.9668, 11.9327, 1.75> }
					triangle { <5.7845, 11.8742, 2.01831>, <5.9039, 11.7042, 2.5166>, <5.9668, 11.9327, 1.75> }
					triangle { <6.2108, 11.7543, 1.7583>, <6.478, 11.6325, 1.9825>, <6.475, 11.7366, 1.5933> }
					triangle { <6.475, 11.7366, 1.5933>, <5.9037, 11.1865, 1.05059>, <6.2108, 11.7543, 1.7583> }
					triangle { <5.9039, 11.7042, 2.5166>, <5.9951, 11.7556, 2.4564>, <6.1883, 11.8031, 2.03028> }
					triangle { <5.9951, 11.7556, 2.4564>, <6.1626, 11.3127, 2.696>, <6.5025, 11.5998, 2.2339> }
					triangle { <6.1883, 11.8031, 2.03028>, <6.5025, 11.5998, 2.2339>, <6.478, 11.6325, 1.9825> }
					triangle { <6.1883, 11.8031, 2.03028>, <5.9951, 11.7556, 2.4564>, <6.5025, 11.5998, 2.2339> }
					triangle { <5.9668, 11.9327, 1.75>, <5.9039, 11.7042, 2.5166>, <6.1883, 11.8031, 2.03028> }
					triangle { <6.2108, 11.7543, 1.7583>, <6.1883, 11.8031, 2.03028>, <6.478, 11.6325, 1.9825> }
					triangle { <5.9668, 11.9327, 1.75>, <6.1883, 11.8031, 2.03028>, <6.2108, 11.7543, 1.7583> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		}
	union { // internode
		cylinder { <0.244, 3.9531, 0.1247>, <0.4475, 7.03991, -0.02605>, 0.4589 }
		cylinder { <0.4475, 7.03991, -0.02605>, <0.3182, 10.1163, -0.3595>, 0.4589 }
		cylinder { <0.3182, 10.1163, -0.3595>, <-0.1419, 13.1361, -0.8708>, 0.4589 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1419, 13.1361, -0.8708>, <-0.5845, 14.00679, -1.1891>, 0.3262 }
			cylinder { <-0.5845, 14.00679, -1.1891>, <-1.2654, 14.6447, -1.6191>, 0.3262 }
			cylinder { <-1.2654, 14.6447, -1.6191>, <-2.1049, 14.9752, -2.1103>, 0.3262 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-2.1049, 14.9752, -2.1103>, <-2.4574, 15.114, -2.3167>, 0.3262 }
				cylinder { <-2.4574, 15.114, -2.3167>, <-2.81, 15.2529, -2.523>, 0.3262 }
				cylinder { <-2.81, 15.2529, -2.523>, <-3.1626, 15.3917, -2.7293>, 0.3262 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-3.1626, 15.3917, -2.7293>, <-3.1988, 15.4075, -2.7656>, 0.01702 }
				cylinder { <-3.1988, 15.4075, -2.7656>, <-3.2253, 15.4208, -2.8103>, 0.01702 }
				cylinder { <-3.2253, 15.4208, -2.8103>, <-3.2404, 15.4309, -2.8607>, 0.01702 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-3.2404, 15.4309, -2.8607>, <-4.4619, 15.8978, -6.4072>, <-4.1873, 15.8112, -6.5443> }
				triangle { <-4.4619, 15.8978, -6.4072>, <-4.956, 14.6946, -7.3238>, <-4.1873, 15.8112, -6.5443> }
				triangle { <-4.4619, 15.8978, -6.4072>, <-5.1173, 14.9924, -7.06605>, <-4.956, 14.6946, -7.3238> }
				triangle { <-4.956, 14.6946, -7.3238>, <-4.5124, 14.9048, -7.2649>, <-4.1873, 15.8112, -6.5443> }
				triangle { <-4.1873, 15.8112, -6.5443>, <-3.7208, 15.4391, -5.1487>, <-3.2404, 15.4309, -2.8607> }
				triangle { <-3.2404, 15.4309, -2.8607>, <-4.2505, 15.5389, -4.9699>, <-4.4619, 15.8978, -6.4072> }
				triangle { <-4.2505, 15.5389, -4.9699>, <-4.8697, 15.5819, -6.2733>, <-4.4619, 15.8978, -6.4072> }
				triangle { <-4.8697, 15.5819, -6.2733>, <-5.1173, 14.9924, -7.06605>, <-4.4619, 15.8978, -6.4072> }
				triangle { <-4.1873, 15.8112, -6.5443>, <-4.5124, 14.9048, -7.2649>, <-4.08949, 15.2993, -6.6762> }
				triangle { <-4.08949, 15.2993, -6.6762>, <-3.7208, 15.4391, -5.1487>, <-4.1873, 15.8112, -6.5443> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-3.1626, 15.3917, -2.7293>, <-3.2064, 15.409, -2.755>, 0.01702 }
				cylinder { <-3.2064, 15.409, -2.755>, <-3.2502, 15.4262, -2.7806>, 0.01702 }
				cylinder { <-3.2502, 15.4262, -2.7806>, <-3.294, 15.4435, -2.8062>, 0.01702 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-3.294, 15.4435, -2.8062>, <-6.4996, 16.3977, -4.5673>, <-6.3782, 16.3781, -4.8616> }
				triangle { <-6.4996, 16.3977, -4.5673>, <-7.4836, 15.3327, -5.2227>, <-6.3782, 16.3781, -4.8616> }
				triangle { <-6.4996, 16.3977, -4.5673>, <-7.4378, 15.5505, -4.86>, <-7.4836, 15.3327, -5.2227> }
				triangle { <-7.4836, 15.3327, -5.2227>, <-7.1027, 15.5882, -5.4072>, <-6.3782, 16.3781, -4.8616> }
				triangle { <-6.3782, 16.3781, -4.8616>, <-5.1303, 15.8175, -4.2041>, <-3.294, 15.4435, -2.8062> }
				triangle { <-3.294, 15.4435, -2.8062>, <-5.4204, 15.8062, -3.716>, <-6.4996, 16.3977, -4.5673> }
				triangle { <-5.4204, 15.8062, -3.716>, <-6.731, 16.00793, -4.2869>, <-6.4996, 16.3977, -4.5673> }
				triangle { <-6.731, 16.00793, -4.2869>, <-7.4378, 15.5505, -4.86>, <-6.4996, 16.3977, -4.5673> }
				triangle { <-6.3782, 16.3781, -4.8616>, <-7.1027, 15.5882, -5.4072>, <-6.395, 15.9194, -5.1415> }
				triangle { <-6.395, 15.9194, -5.1415>, <-5.1303, 15.8175, -4.2041>, <-6.3782, 16.3781, -4.8616> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-0.1419, 13.1361, -0.8708>, <-0.6433, 16.426, -1.4277>, 0.5 }
		cylinder { <-0.6433, 16.426, -1.4277>, <-1.1446, 19.716, -1.9847>, 0.5 }
		cylinder { <-1.1446, 19.716, -1.9847>, <-1.646, 23.00595, -2.5417>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.646, 23.00595, -2.5417>, <-2.2948, 24.3604, -3.01503>, 0.4999 }
			cylinder { <-2.2948, 24.3604, -3.01503>, <-3.2928, 25.3972, -3.6539>, 0.4999 }
			cylinder { <-3.2928, 25.3972, -3.6539>, <-4.5394, 26.01193, -4.394>, 0.4999 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-4.5394, 26.01193, -4.394>, <-5.04878, 26.2836, -4.7167>, 0.4999 }
				cylinder { <-5.04878, 26.2836, -4.7167>, <-5.5432, 26.5685, -5.0509>, 0.4999 }
				cylinder { <-5.5432, 26.5685, -5.0509>, <-6.02233, 26.8662, -5.3961>, 0.4999 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-6.02233, 26.8662, -5.3961>, <-6.09221, 26.9174, -5.4876>, 0.03999 }
				cylinder { <-6.09221, 26.9174, -5.4876>, <-6.1356, 26.9592, -5.5982>, 0.03999 }
				cylinder { <-6.1356, 26.9592, -5.5982>, <-6.1494, 26.9888, -5.7199>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-6.1494, 26.9888, -5.7199>, <-7.05028, 27.992, -11.3546>, <-6.6113, 27.8325, -11.4992> }
				triangle { <-7.05028, 27.992, -11.3546>, <-7.6985, 26.25, -12.9339>, <-6.6113, 27.8325, -11.4992> }
				triangle { <-7.05028, 27.992, -11.3546>, <-7.9735, 26.7135, -12.5663>, <-7.6985, 26.25, -12.9339> }
				triangle { <-7.6985, 26.25, -12.9339>, <-7.02114, 26.516, -12.7227>, <-6.6113, 27.8325, -11.4992> }
				triangle { <-6.6113, 27.8325, -11.4992>, <-6.299, 27.1517, -9.2966>, <-6.1494, 26.9888, -5.7199> }
				triangle { <-6.1494, 26.9888, -5.7199>, <-7.1317, 27.3599, -9.1512>, <-7.05028, 27.992, -11.3546> }
				triangle { <-7.1317, 27.3599, -9.1512>, <-7.7338, 27.5523, -11.2718>, <-7.05028, 27.992, -11.3546> }
				triangle { <-7.7338, 27.5523, -11.2718>, <-7.9735, 26.7135, -12.5663>, <-7.05028, 27.992, -11.3546> }
				triangle { <-6.6113, 27.8325, -11.4992>, <-7.02114, 26.516, -12.7227>, <-6.4873, 27.04427, -11.7049> }
				triangle { <-6.4873, 27.04427, -11.7049>, <-6.299, 27.1517, -9.2966>, <-6.6113, 27.8325, -11.4992> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-6.02233, 26.8662, -5.3961>, <-6.1118, 26.9226, -5.4645>, 0.03999 }
				cylinder { <-6.1118, 26.9226, -5.4645>, <-6.1997, 26.9786, -5.5353>, 0.03999 }
				cylinder { <-6.1997, 26.9786, -5.5353>, <-6.2857, 27.03424, -5.6087>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-6.2857, 27.03424, -5.6087>, <-10.4696, 29.2082, -8.9756>, <-10.21, 29.1865, -9.3893> }
				triangle { <-10.4696, 29.2082, -8.9756>, <-11.9288, 27.823, -10.3541>, <-10.21, 29.1865, -9.3893> }
				triangle { <-10.4696, 29.2082, -8.9756>, <-11.926, 28.1105, -9.7686>, <-11.9288, 27.823, -10.3541> }
				triangle { <-11.9288, 27.823, -10.3541>, <-11.268, 28.164, -10.4998>, <-10.21, 29.1865, -9.3893> }
				triangle { <-10.21, 29.1865, -9.3893>, <-8.6023, 28.05557, -8.1448>, <-6.2857, 27.03424, -5.6087> }
				triangle { <-6.2857, 27.03424, -5.6087>, <-9.1727, 28.04018, -7.4874>, <-10.4696, 29.2082, -8.9756> }
				triangle { <-9.1727, 28.04018, -7.4874>, <-10.9526, 28.628, -8.6635>, <-10.4696, 29.2082, -8.9756> }
				triangle { <-10.9526, 28.628, -8.6635>, <-11.926, 28.1105, -9.7686>, <-10.4696, 29.2082, -8.9756> }
				triangle { <-10.21, 29.1865, -9.3893>, <-11.268, 28.164, -10.4998>, <-10.2284, 28.5197, -9.8731> }
				triangle { <-10.2284, 28.5197, -9.8731>, <-8.6023, 28.05557, -8.1448>, <-10.21, 29.1865, -9.3893> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-1.646, 23.00595, -2.5417>, <-2.5695, 26.1564, -3.3196>, 0.4999 }
		cylinder { <-2.5695, 26.1564, -3.3196>, <-3.8951, 29.09958, -4.3017>, 0.4999 }
		cylinder { <-3.8951, 29.09958, -4.3017>, <-5.5942, 31.7715, -5.4667>, 0.4999 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-5.5942, 31.7715, -5.4667>, <-6.5538, 32.4975, -6.05795>, 0.4256 }
			cylinder { <-6.5538, 32.4975, -6.05795>, <-7.6856, 32.8027, -6.7083>, 0.4256 }
			cylinder { <-7.6856, 32.8027, -6.7083>, <-8.8574, 32.6517, -7.3418>, 0.4256 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-8.8574, 32.6517, -7.3418>, <-9.3496, 32.5882, -7.6079>, 0.4256 }
				cylinder { <-9.3496, 32.5882, -7.6079>, <-9.8417, 32.5248, -7.874>, 0.4256 }
				cylinder { <-9.8417, 32.5248, -7.874>, <-10.3339, 32.4614, -8.1401>, 0.4256 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-10.3339, 32.4614, -8.1401>, <-10.3991, 32.4496, -8.2029>, 0.02899 }
				cylinder { <-10.3991, 32.4496, -8.2029>, <-10.4449, 32.4373, -8.2809>, 0.02899 }
				cylinder { <-10.4449, 32.4373, -8.2809>, <-10.4681, 32.4253, -8.3684>, 0.02899 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-10.4681, 32.4253, -8.3684>, <-11.7821, 31.411, -13.01352>, <-11.3945, 31.4174, -13.165> }
				triangle { <-11.7821, 31.411, -13.01352>, <-11.6593, 29.5101, -13.8402>, <-11.3945, 31.4174, -13.165> }
				triangle { <-11.7821, 31.411, -13.01352>, <-12.03224, 29.8405, -13.595>, <-11.6593, 29.5101, -13.8402> }
				triangle { <-11.6593, 29.5101, -13.8402>, <-11.2424, 30.00226, -13.8264>, <-11.3945, 31.4174, -13.165> }
				triangle { <-11.3945, 31.4174, -13.165>, <-10.7982, 31.5892, -11.284>, <-10.4681, 32.4253, -8.3684> }
				triangle { <-10.4681, 32.4253, -8.3684>, <-11.5022, 31.4759, -11.08197>, <-11.7821, 31.411, -13.01352> }
				triangle { <-11.5022, 31.4759, -11.08197>, <-12.1231, 30.864, -12.7521>, <-11.7821, 31.411, -13.01352> }
				triangle { <-12.1231, 30.864, -12.7521>, <-12.03224, 29.8405, -13.595>, <-11.7821, 31.411, -13.01352> }
				triangle { <-11.3945, 31.4174, -13.165>, <-11.2424, 30.00226, -13.8264>, <-11.00183, 30.8365, -13.1893> }
				triangle { <-11.00183, 30.8365, -13.1893>, <-10.7982, 31.5892, -11.284>, <-11.3945, 31.4174, -13.165> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-10.3339, 32.4614, -8.1401>, <-10.4137, 32.4511, -8.1832>, 0.02899 }
				cylinder { <-10.4137, 32.4511, -8.1832>, <-10.4935, 32.4408, -8.2264>, 0.02899 }
				cylinder { <-10.4935, 32.4408, -8.2264>, <-10.5733, 32.4305, -8.2695>, 0.02899 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-10.5733, 32.4305, -8.2695>, <-14.8932, 31.5188, -10.4695>, <-14.7341, 31.4828, -10.8524> }
				triangle { <-14.8932, 31.5188, -10.4695>, <-15.5309, 29.6082, -10.9743>, <-14.7341, 31.4828, -10.8524> }
				triangle { <-14.8932, 31.5188, -10.4695>, <-15.5898, 29.9785, -10.5646>, <-15.5309, 29.6082, -10.9743> }
				triangle { <-15.5309, 29.6082, -10.9743>, <-15.2, 30.05357, -11.3034>, <-14.7341, 31.4828, -10.8524> }
				triangle { <-14.7341, 31.4828, -10.8524>, <-12.9564, 31.6076, -9.9877>, <-10.5733, 32.4305, -8.2695> }
				triangle { <-10.5733, 32.4305, -8.2695>, <-13.3049, 31.5713, -9.3346>, <-14.8932, 31.5188, -10.4695> }
				triangle { <-13.3049, 31.5713, -9.3346>, <-14.9772, 31.01349, -9.999>, <-14.8932, 31.5188, -10.4695> }
				triangle { <-14.9772, 31.01349, -9.999>, <-15.5898, 29.9785, -10.5646>, <-14.8932, 31.5188, -10.4695> }
				triangle { <-14.7341, 31.4828, -10.8524>, <-15.2, 30.05357, -11.3034>, <-14.5192, 30.8634, -11.1022> }
				triangle { <-14.5192, 30.8634, -11.1022>, <-12.9564, 31.6076, -9.9877>, <-14.7341, 31.4828, -10.8524> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-5.5942, 31.7715, -5.4667>, <-6.7221, 33.9462, -5.9009>, 0.3686 }
		cylinder { <-6.7221, 33.9462, -5.9009>, <-7.6816, 36.2416, -5.8936>, 0.3686 }
		cylinder { <-7.6816, 36.2416, -5.8936>, <-8.4359, 38.5696, -5.4451>, 0.3686 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.4359, 38.5696, -5.4451>, <-8.4655, 38.7478, -5.3539>, 0.06425 }
			cylinder { <-8.4655, 38.7478, -5.3539>, <-8.4602, 38.8969, -5.2171>, 0.06425 }
			cylinder { <-8.4602, 38.8969, -5.2171>, <-8.4206, 39.00184, -5.04869>, 0.06425 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-8.4206, 39.00184, -5.04869>, <-8.404, 39.04589, -4.9779>, 0.06425 }
				cylinder { <-8.404, 39.04589, -4.9779>, <-8.3874, 39.08994, -4.9071>, 0.06425 }
				cylinder { <-8.3874, 39.08994, -4.9071>, <-8.3707, 39.134, -4.8364>, 0.06425 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-8.3707, 39.134, -4.8364>, <-8.1867, 39.4796, -4.2031>, <-8.2385, 39.4624, -4.1719> }
				triangle { <-8.1867, 39.4796, -4.2031>, <-8.06034, 39.3317, -3.9574>, <-8.2385, 39.4624, -4.1719> }
				triangle { <-8.1867, 39.4796, -4.2031>, <-8.03633, 39.3763, -4.02417>, <-8.06034, 39.3317, -3.9574> }
				triangle { <-8.06034, 39.3317, -3.9574>, <-8.1527, 39.3512, -3.9811>, <-8.2385, 39.4624, -4.1719> }
				triangle { <-8.2385, 39.4624, -4.1719>, <-8.3019, 39.2923, -4.4094>, <-8.3707, 39.134, -4.8364> }
				triangle { <-8.3707, 39.134, -4.8364>, <-8.2006, 39.3183, -4.4494>, <-8.1867, 39.4796, -4.2031> }
				triangle { <-8.2006, 39.3183, -4.4494>, <-8.09574, 39.4276, -4.2088>, <-8.1867, 39.4796, -4.2031> }
				triangle { <-8.09574, 39.4276, -4.2088>, <-8.03633, 39.3763, -4.02417>, <-8.1867, 39.4796, -4.2031> }
				triangle { <-8.2385, 39.4624, -4.1719>, <-8.1527, 39.3512, -3.9811>, <-8.2417, 39.3729, -4.1154> }
				triangle { <-8.2417, 39.3729, -4.1154>, <-8.3019, 39.2923, -4.4094>, <-8.2385, 39.4624, -4.1719> }
				texture{chif1}}
			mesh { // leaf
				triangle { <-8.3707, 39.134, -4.8364>, <-8.1867, 39.4796, -4.2031>, <-8.2385, 39.4624, -4.1719> }
				triangle { <-8.1867, 39.4796, -4.2031>, <-8.06034, 39.3317, -3.9574>, <-8.2385, 39.4624, -4.1719> }
				triangle { <-8.1867, 39.4796, -4.2031>, <-8.03633, 39.3763, -4.02417>, <-8.06034, 39.3317, -3.9574> }
				triangle { <-8.06034, 39.3317, -3.9574>, <-8.1527, 39.3512, -3.9811>, <-8.2385, 39.4624, -4.1719> }
				triangle { <-8.2385, 39.4624, -4.1719>, <-8.3019, 39.2923, -4.4094>, <-8.3707, 39.134, -4.8364> }
				triangle { <-8.3707, 39.134, -4.8364>, <-8.2006, 39.3183, -4.4494>, <-8.1867, 39.4796, -4.2031> }
				triangle { <-8.2006, 39.3183, -4.4494>, <-8.09574, 39.4276, -4.2088>, <-8.1867, 39.4796, -4.2031> }
				triangle { <-8.09574, 39.4276, -4.2088>, <-8.03633, 39.3763, -4.02417>, <-8.1867, 39.4796, -4.2031> }
				triangle { <-8.2385, 39.4624, -4.1719>, <-8.1527, 39.3512, -3.9811>, <-8.2417, 39.3729, -4.1154> }
				triangle { <-8.2417, 39.3729, -4.1154>, <-8.3019, 39.2923, -4.4094>, <-8.2385, 39.4624, -4.1719> }
				texture{chif1}}
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <-8.4359, 38.5696, -5.4451>, <-8.5457, 38.9453, -5.4108>, 0.2183 }
			cylinder { <-8.5457, 38.9453, -5.4108>, <-8.6451, 39.3254, -5.4134>, 0.2183 }
			cylinder { <-8.6451, 39.3254, -5.4134>, <-8.7331, 39.7062, -5.4527>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <-8.7331, 39.7062, -5.4527>, <-8.8089, 40.08419, -5.5286>, 0.2183 }
			cylinder { <-8.8089, 40.08419, -5.5286>, <-8.8718, 40.4555, -5.6402>, 0.2183 }
			cylinder { <-8.8718, 40.4555, -5.6402>, <-8.9211, 40.8168, -5.7864>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <-8.9211, 40.8168, -5.7864>, <-9.00438, 41.1788, -5.9143>, 0.2183 }
			cylinder { <-9.00438, 41.1788, -5.9143>, <-9.1207, 41.5381, -6.02263>, 0.2183 }
			cylinder { <-9.1207, 41.5381, -6.02263>, <-9.269, 41.8912, -6.1103>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.269, 41.8912, -6.1103>, <-9.5483, 42.402, -6.2014>, 0.2183 }
				cylinder { <-9.5483, 42.402, -6.2014>, <-9.8804, 42.8863, -6.2507>, 0.2183 }
				cylinder { <-9.8804, 42.8863, -6.2507>, <-10.2601, 43.3369, -6.2575>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-10.2601, 43.3369, -6.2575>, <-11.6139, 45.12, -6.04993>, <-11.4254, 45.2418, -6.2565> }
					triangle { <-10.2601, 43.3369, -6.2575>, <-11.1204, 44.2108, -6.08667>, <-11.6139, 45.12, -6.04993> }
					triangle { <-11.4254, 45.2418, -6.2565>, <-11.01393, 44.3965, -6.4805>, <-10.2601, 43.3369, -6.2575> }
					triangle { <-11.1204, 44.2108, -6.08667>, <-11.5118, 45.2107, -5.7466>, <-11.6139, 45.12, -6.04993> }
					triangle { <-11.5118, 45.2107, -5.7466>, <-11.242, 45.6447, -5.558>, <-11.6139, 45.12, -6.04993> }
					triangle { <-11.4254, 45.2418, -6.2565>, <-11.2502, 45.5579, -6.3477>, <-11.4287, 45.2683, -6.5703> }
					triangle { <-11.4287, 45.2683, -6.5703>, <-11.01393, 44.3965, -6.4805>, <-11.4254, 45.2418, -6.2565> }
					triangle { <-11.242, 45.6447, -5.558>, <-11.3006, 45.6616, -5.6635>, <-11.422, 45.4513, -6.07125> }
					triangle { <-11.3006, 45.6616, -5.6635>, <-10.809, 45.8718, -5.6917>, <-11.1681, 45.7649, -6.2193> }
					triangle { <-11.422, 45.4513, -6.07125>, <-11.1681, 45.7649, -6.2193>, <-11.2502, 45.5579, -6.3477> }
					triangle { <-11.422, 45.4513, -6.07125>, <-11.3006, 45.6616, -5.6635>, <-11.1681, 45.7649, -6.2193> }
					triangle { <-11.6139, 45.12, -6.04993>, <-11.242, 45.6447, -5.558>, <-11.422, 45.4513, -6.07125> }
					triangle { <-11.4254, 45.2418, -6.2565>, <-11.422, 45.4513, -6.07125>, <-11.2502, 45.5579, -6.3477> }
					triangle { <-11.6139, 45.12, -6.04993>, <-11.422, 45.4513, -6.07125>, <-11.4254, 45.2418, -6.2565> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.2601, 43.3369, -6.2575>, <-11.5023, 45.21, -6.3182>, <-11.5804, 45.1061, -6.5942> }
					triangle { <-10.2601, 43.3369, -6.2575>, <-10.9362, 44.3655, -6.1237>, <-11.5023, 45.21, -6.3182> }
					triangle { <-11.5804, 45.1061, -6.5942>, <-11.2211, 44.2224, -6.4388>, <-10.2601, 43.3369, -6.2575> }
					triangle { <-10.9362, 44.3655, -6.1237>, <-11.2491, 45.4229, -6.3527>, <-11.5023, 45.21, -6.3182> }
					triangle { <-11.2491, 45.4229, -6.3527>, <-11.09175, 45.7533, -6.7562>, <-11.5023, 45.21, -6.3182> }
					triangle { <-11.5804, 45.1061, -6.5942>, <-11.6456, 45.2157, -6.9444>, <-11.8204, 44.9361, -6.7067> }
					triangle { <-11.8204, 44.9361, -6.7067>, <-11.2211, 44.2224, -6.4388>, <-11.5804, 45.1061, -6.5942> }
					triangle { <-11.09175, 45.7533, -6.7562>, <-11.2094, 45.722, -6.7576>, <-11.5114, 45.3669, -6.668> }
					triangle { <-11.2094, 45.722, -6.7576>, <-11.00453, 45.6835, -7.2507>, <-11.5703, 45.4128, -7.09134> }
					triangle { <-11.5114, 45.3669, -6.668>, <-11.5703, 45.4128, -7.09134>, <-11.6456, 45.2157, -6.9444> }
					triangle { <-11.5114, 45.3669, -6.668>, <-11.2094, 45.722, -6.7576>, <-11.5703, 45.4128, -7.09134> }
					triangle { <-11.5023, 45.21, -6.3182>, <-11.09175, 45.7533, -6.7562>, <-11.5114, 45.3669, -6.668> }
					triangle { <-11.5804, 45.1061, -6.5942>, <-11.5114, 45.3669, -6.668>, <-11.6456, 45.2157, -6.9444> }
					triangle { <-11.5023, 45.21, -6.3182>, <-11.5114, 45.3669, -6.668>, <-11.5804, 45.1061, -6.5942> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.2601, 43.3369, -6.2575>, <-11.6611, 45.07292, -6.5385>, <-11.8756, 44.8586, -6.5046> }
					triangle { <-10.2601, 43.3369, -6.2575>, <-10.9036, 44.3893, -6.3637>, <-11.6611, 45.07292, -6.5385> }
					triangle { <-11.8756, 44.8586, -6.5046>, <-11.2578, 44.1956, -6.1688>, <-10.2601, 43.3369, -6.2575> }
					triangle { <-10.9036, 44.3893, -6.3637>, <-11.6044, 45.1158, -6.8634>, <-11.6611, 45.07292, -6.5385> }
					triangle { <-11.6044, 45.1158, -6.8634>, <-11.9133, 45.05258, -7.3076>, <-11.6611, 45.07292, -6.5385> }
					triangle { <-11.8756, 44.8586, -6.5046>, <-12.2066, 44.7475, -6.6352>, <-12.04593, 44.7527, -6.2618> }
					triangle { <-12.04593, 44.7527, -6.2618>, <-11.2578, 44.1956, -6.1688>, <-11.8756, 44.8586, -6.5046> }
					triangle { <-11.9133, 45.05258, -7.3076>, <-11.9745, 45.07048, -7.2039>, <-11.9736, 44.9763, -6.7387> }
					triangle { <-11.9745, 45.07048, -7.2039>, <-12.1997, 44.6726, -7.4825>, <-12.3334, 44.7732, -6.8574> }
					triangle { <-11.9736, 44.9763, -6.7387>, <-12.3334, 44.7732, -6.8574>, <-12.2066, 44.7475, -6.6352> }
					triangle { <-11.9736, 44.9763, -6.7387>, <-11.9745, 45.07048, -7.2039>, <-12.3334, 44.7732, -6.8574> }
					triangle { <-11.6611, 45.07292, -6.5385>, <-11.9133, 45.05258, -7.3076>, <-11.9736, 44.9763, -6.7387> }
					triangle { <-11.8756, 44.8586, -6.5046>, <-11.9736, 44.9763, -6.7387>, <-12.2066, 44.7475, -6.6352> }
					triangle { <-11.6611, 45.07292, -6.5385>, <-11.9736, 44.9763, -6.7387>, <-11.8756, 44.8586, -6.5046> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.2601, 43.3369, -6.2575>, <-11.8724, 44.8968, -6.4084>, <-11.9059, 44.839, -6.1107> }
					triangle { <-10.2601, 43.3369, -6.2575>, <-11.06742, 44.2496, -6.4772>, <-11.8724, 44.8968, -6.4084> }
					triangle { <-11.9059, 44.839, -6.1107>, <-11.0736, 44.3528, -6.04109>, <-10.2601, 43.3369, -6.2575> }
					triangle { <-11.06742, 44.2496, -6.4772>, <-12.09002, 44.7108, -6.5777>, <-11.8724, 44.8968, -6.4084> }
					triangle { <-12.09002, 44.7108, -6.5777>, <-12.579, 44.5043, -6.4554>, <-11.8724, 44.8968, -6.4084> }
					triangle { <-11.9059, 44.839, -6.1107>, <-12.1632, 44.7961, -5.8445>, <-11.7957, 44.9699, -5.8464> }
					triangle { <-11.7957, 44.9699, -5.8464>, <-11.0736, 44.3528, -6.04109>, <-11.9059, 44.839, -6.1107> }
					triangle { <-12.579, 44.5043, -6.4554>, <-12.5456, 44.6014, -6.3897>, <-12.1742, 44.8156, -6.1863> }
					triangle { <-12.5456, 44.6014, -6.3897>, <-12.754, 44.2268, -6.06906>, <-12.4099, 44.7241, -5.8386> }
					triangle { <-12.1742, 44.8156, -6.1863>, <-12.4099, 44.7241, -5.8386>, <-12.1632, 44.7961, -5.8445> }
					triangle { <-12.1742, 44.8156, -6.1863>, <-12.5456, 44.6014, -6.3897>, <-12.4099, 44.7241, -5.8386> }
					triangle { <-11.8724, 44.8968, -6.4084>, <-12.579, 44.5043, -6.4554>, <-12.1742, 44.8156, -6.1863> }
					triangle { <-11.9059, 44.839, -6.1107>, <-12.1742, 44.8156, -6.1863>, <-12.1632, 44.7961, -5.8445> }
					triangle { <-11.8724, 44.8968, -6.4084>, <-12.1742, 44.8156, -6.1863>, <-11.9059, 44.839, -6.1107> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.2601, 43.3369, -6.2575>, <-11.8428, 44.9263, -6.1019>, <-11.6235, 45.07948, -5.9551> }
					triangle { <-10.2601, 43.3369, -6.2575>, <-11.2034, 44.1375, -6.3034>, <-11.8428, 44.9263, -6.1019> }
					triangle { <-11.6235, 45.07948, -5.9551>, <-10.9205, 44.4789, -6.2366>, <-10.2601, 43.3369, -6.2575> }
					triangle { <-11.2034, 44.1375, -6.3034>, <-12.03193, 44.7704, -5.8771>, <-11.8428, 44.9263, -6.1019> }
					triangle { <-12.03193, 44.7704, -5.8771>, <-12.1578, 44.8758, -5.3577>, <-11.8428, 44.9263, -6.1019> }
					triangle { <-11.6235, 45.07948, -5.9551>, <-11.5632, 45.3045, -5.6641>, <-11.4085, 45.2933, -6.03991> }
					triangle { <-11.4085, 45.2933, -6.03991>, <-10.9205, 44.4789, -6.2366>, <-11.6235, 45.07948, -5.9551> }
					triangle { <-12.1578, 44.8758, -5.3577>, <-12.1228, 44.9723, -5.4234>, <-11.8281, 45.1135, -5.7675> }
					triangle { <-12.1228, 44.9723, -5.4234>, <-11.8815, 44.9791, -4.9455>, <-11.6788, 45.3462, -5.4384> }
					triangle { <-11.8281, 45.1135, -5.7675>, <-11.6788, 45.3462, -5.4384>, <-11.5632, 45.3045, -5.6641> }
					triangle { <-11.8281, 45.1135, -5.7675>, <-12.1228, 44.9723, -5.4234>, <-11.6788, 45.3462, -5.4384> }
					triangle { <-11.8428, 44.9263, -6.1019>, <-12.1578, 44.8758, -5.3577>, <-11.8281, 45.1135, -5.7675> }
					triangle { <-11.6235, 45.07948, -5.9551>, <-11.8281, 45.1135, -5.7675>, <-11.5632, 45.3045, -5.6641> }
					triangle { <-11.8428, 44.9263, -6.1019>, <-11.8281, 45.1135, -5.7675>, <-11.6235, 45.07948, -5.9551> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-9.269, 41.8912, -6.1103>, <-9.3819, 42.2584, -6.1922>, 0.2183 }
			cylinder { <-9.3819, 42.2584, -6.1922>, <-9.4583, 42.6363, -6.2677>, 0.2183 }
			cylinder { <-9.4583, 42.6363, -6.2677>, <-9.4975, 43.02126, -6.336>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4975, 43.02126, -6.336>, <-9.4858, 43.6039, -6.4235>, 0.2183 }
				cylinder { <-9.4858, 43.6039, -6.4235>, <-9.4038, 44.183, -6.4947>, 0.2183 }
				cylinder { <-9.4038, 44.183, -6.4947>, <-9.2526, 44.75, -6.5487>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-9.2526, 44.75, -6.5487>, <-8.584, 46.8429, -6.9872>, <-8.8817, 46.8918, -7.02435> }
					triangle { <-9.2526, 44.75, -6.5487>, <-8.7464, 45.8642, -6.7045>, <-8.584, 46.8429, -6.9872> }
					triangle { <-8.8817, 46.8918, -7.02435>, <-9.1393, 46.05802, -6.6172>, <-9.2526, 44.75, -6.5487> }
					triangle { <-8.7464, 45.8642, -6.7045>, <-8.4496, 46.7789, -7.2832>, <-8.584, 46.8429, -6.9872> }
					triangle { <-8.4496, 46.7789, -7.2832>, <-8.5781, 46.9263, -7.7896>, <-8.584, 46.8429, -6.9872> }
					triangle { <-8.8817, 46.8918, -7.02435>, <-9.127, 47.07138, -7.2378>, <-9.1123, 46.9977, -6.8398> }
					triangle { <-9.1123, 46.9977, -6.8398>, <-9.1393, 46.05802, -6.6172>, <-8.8817, 46.8918, -7.02435> }
					triangle { <-8.5781, 46.9263, -7.7896>, <-8.6198, 46.9995, -7.7021>, <-8.7927, 47.00684, -7.262> }
					triangle { <-8.6198, 46.9995, -7.7021>, <-9.004249, 46.9065, -8.06014>, <-9.13, 47.1567, -7.4793> }
					triangle { <-8.7927, 47.00684, -7.262>, <-9.13, 47.1567, -7.4793>, <-9.127, 47.07138, -7.2378> }
					triangle { <-8.7927, 47.00684, -7.262>, <-8.6198, 46.9995, -7.7021>, <-9.13, 47.1567, -7.4793> }
					triangle { <-8.584, 46.8429, -6.9872>, <-8.5781, 46.9263, -7.7896>, <-8.7927, 47.00684, -7.262> }
					triangle { <-8.8817, 46.8918, -7.02435>, <-8.7927, 47.00684, -7.262>, <-9.127, 47.07138, -7.2378> }
					triangle { <-8.584, 46.8429, -6.9872>, <-8.7927, 47.00684, -7.262>, <-8.8817, 46.8918, -7.02435> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-9.2526, 44.75, -6.5487>, <-8.8697, 46.9247, -6.9273>, <-8.9974, 46.9579, -6.6534> }
					triangle { <-9.2526, 44.75, -6.5487>, <-8.9252, 45.8966, -6.8652>, <-8.8697, 46.9247, -6.9273> }
					triangle { <-8.9974, 46.9579, -6.6534>, <-8.9382, 46.02159, -6.4365>, <-9.2526, 44.75, -6.5487> }
					triangle { <-8.9252, 45.8966, -6.8652>, <-9.1036, 46.9651, -7.1585>, <-8.8697, 46.9247, -6.9273> }
					triangle { <-9.1036, 46.9651, -7.1585>, <-9.5664, 47.2483, -7.1738>, <-8.8697, 46.9247, -6.9273> }
					triangle { <-8.9974, 46.9579, -6.6534>, <-9.2309, 47.173, -6.4607>, <-8.8873, 46.9833, -6.3607> }
					triangle { <-8.8873, 46.9833, -6.3607>, <-8.9382, 46.02159, -6.4365>, <-8.9974, 46.9579, -6.6534> }
					triangle { <-9.5664, 47.2483, -7.1738>, <-9.4841, 47.2878, -7.09383>, <-9.1493, 47.1467, -6.7911> }
					triangle { <-9.4841, 47.2878, -7.09383>, <-9.9672, 47.2767, -6.8677>, <-9.4269, 47.3272, -6.5194> }
					triangle { <-9.1493, 47.1467, -6.7911>, <-9.4269, 47.3272, -6.5194>, <-9.2309, 47.173, -6.4607> }
					triangle { <-9.1493, 47.1467, -6.7911>, <-9.4841, 47.2878, -7.09383>, <-9.4269, 47.3272, -6.5194> }
					triangle { <-8.8697, 46.9247, -6.9273>, <-9.5664, 47.2483, -7.1738>, <-9.1493, 47.1467, -6.7911> }
					triangle { <-8.9974, 46.9579, -6.6534>, <-9.1493, 47.1467, -6.7911>, <-9.2309, 47.173, -6.4607> }
					triangle { <-8.8697, 46.9247, -6.9273>, <-9.1493, 47.1467, -6.7911>, <-8.9974, 46.9579, -6.6534> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-9.2526, 44.75, -6.5487>, <-8.8975, 46.9607, -6.6275>, <-8.689, 46.8984, -6.4153> }
					triangle { <-9.2526, 44.75, -6.5487>, <-9.1253, 45.9614, -6.7443>, <-8.8975, 46.9607, -6.6275> }
					triangle { <-8.689, 46.8984, -6.4153>, <-8.7131, 45.9486, -6.5725>, <-9.2526, 44.75, -6.5487> }
					triangle { <-9.1253, 45.9614, -6.7443>, <-9.1787, 47.05004, -6.4765>, <-8.8975, 46.9607, -6.6275> }
					triangle { <-9.1787, 47.05004, -6.4765>, <-9.2858, 47.2853, -5.9993>, <-8.8975, 46.9607, -6.6275> }
					triangle { <-8.689, 46.8984, -6.4153>, <-8.5447, 47.02473, -6.09725>, <-8.3803, 46.8426, -6.4195> }
					triangle { <-8.3803, 46.8426, -6.4195>, <-8.7131, 45.9486, -6.5725>, <-8.689, 46.8984, -6.4153> }
					triangle { <-9.2858, 47.2853, -5.9993>, <-9.1744, 47.3053, -6.04307>, <-8.8187, 47.1069, -6.2835> }
					triangle { <-9.1744, 47.3053, -6.04307>, <-9.1476, 47.1862, -5.5237>, <-8.6282, 47.1727, -5.9055> }
					triangle { <-8.8187, 47.1069, -6.2835>, <-8.6282, 47.1727, -5.9055>, <-8.5447, 47.02473, -6.09725> }
					triangle { <-8.8187, 47.1069, -6.2835>, <-9.1744, 47.3053, -6.04307>, <-8.6282, 47.1727, -5.9055> }
					triangle { <-8.8975, 46.9607, -6.6275>, <-9.2858, 47.2853, -5.9993>, <-8.8187, 47.1069, -6.2835> }
					triangle { <-8.689, 46.8984, -6.4153>, <-8.8187, 47.1069, -6.2835>, <-8.5447, 47.02473, -6.09725> }
					triangle { <-8.8975, 46.9607, -6.6275>, <-8.8187, 47.1069, -6.2835>, <-8.689, 46.8984, -6.4153> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-9.2526, 44.75, -6.5487>, <-8.6293, 46.9014, -6.4994>, <-8.3799, 46.7949, -6.6368> }
					triangle { <-9.2526, 44.75, -6.5487>, <-9.07198, 45.9697, -6.5079>, <-8.6293, 46.9014, -6.4994> }
					triangle { <-8.3799, 46.7949, -6.6368>, <-8.7731, 45.9393, -6.8385>, <-9.2526, 44.75, -6.5487> }
					triangle { <-9.07198, 45.9697, -6.5079>, <-8.5717, 46.9171, -6.1734>, <-8.6293, 46.9014, -6.4994> }
					triangle { <-8.5717, 46.9171, -6.1734>, <-8.1215, 46.9865, -5.8782>, <-8.6293, 46.9014, -6.4994> }
					triangle { <-8.3799, 46.7949, -6.6368>, <-8.01034, 46.83, -6.6462>, <-8.2872, 46.7687, -6.9354> }
					triangle { <-8.2872, 46.7687, -6.9354>, <-8.7731, 45.9393, -6.8385>, <-8.3799, 46.7949, -6.6368> }
					triangle { <-8.1215, 46.9865, -5.8782>, <-8.1157, 47.02792, -5.9922>, <-8.2547, 46.942, -6.436> }
					triangle { <-8.1157, 47.02792, -5.9922>, <-7.6705, 46.7592, -5.8729>, <-7.8303, 46.9053, -6.4803> }
					triangle { <-8.2547, 46.942, -6.436>, <-7.8303, 46.9053, -6.4803>, <-8.01034, 46.83, -6.6462> }
					triangle { <-8.2547, 46.942, -6.436>, <-8.1157, 47.02792, -5.9922>, <-7.8303, 46.9053, -6.4803> }
					triangle { <-8.6293, 46.9014, -6.4994>, <-8.1215, 46.9865, -5.8782>, <-8.2547, 46.942, -6.436> }
					triangle { <-8.3799, 46.7949, -6.6368>, <-8.2547, 46.942, -6.436>, <-8.01034, 46.83, -6.6462> }
					triangle { <-8.6293, 46.9014, -6.4994>, <-8.2547, 46.942, -6.436>, <-8.3799, 46.7949, -6.6368> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-9.2526, 44.75, -6.5487>, <-8.4326, 46.8275, -6.725>, <-8.5008, 46.7908, -7.01896> }
					triangle { <-9.2526, 44.75, -6.5487>, <-8.8343, 45.9088, -6.4829>, <-8.4326, 46.8275, -6.725> }
					triangle { <-8.5008, 46.7908, -7.01896>, <-9.04055, 46.00794, -6.8665>, <-9.2526, 44.75, -6.5487> }
					triangle { <-8.8343, 45.9088, -6.4829>, <-8.1144, 46.747, -6.6795>, <-8.4326, 46.8275, -6.725> }
					triangle { <-8.1144, 46.747, -6.6795>, <-7.6776, 46.7612, -7.00141>, <-8.4326, 46.8275, -6.725> }
					triangle { <-8.5008, 46.7908, -7.01896>, <-8.3756, 46.8592, -7.3618>, <-8.7464, 46.866, -7.1991> }
					triangle { <-8.7464, 46.866, -7.1991>, <-9.04055, 46.00794, -6.8665>, <-8.5008, 46.7908, -7.01896> }
					triangle { <-7.6776, 46.7612, -7.00141>, <-7.7677, 46.8361, -7.03309>, <-8.2384, 46.8792, -7.04994> }
					triangle { <-7.7677, 46.8361, -7.03309>, <-7.5805, 46.5838, -7.4642>, <-8.1451, 46.8953, -7.4676> }
					triangle { <-8.2384, 46.8792, -7.04994>, <-8.1451, 46.8953, -7.4676>, <-8.3756, 46.8592, -7.3618> }
					triangle { <-8.2384, 46.8792, -7.04994>, <-7.7677, 46.8361, -7.03309>, <-8.1451, 46.8953, -7.4676> }
					triangle { <-8.4326, 46.8275, -6.725>, <-7.6776, 46.7612, -7.00141>, <-8.2384, 46.8792, -7.04994> }
					triangle { <-8.5008, 46.7908, -7.01896>, <-8.2384, 46.8792, -7.04994>, <-8.3756, 46.8592, -7.3618> }
					triangle { <-8.4326, 46.8275, -6.725>, <-8.2384, 46.8792, -7.04994>, <-8.5008, 46.7908, -7.01896> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-9.4975, 43.02126, -6.336>, <-9.5587, 43.3966, -6.4345>, 0.2183 }
			cylinder { <-9.5587, 43.3966, -6.4345>, <-9.6412, 43.7588, -6.5622>, 0.2183 }
			cylinder { <-9.6412, 43.7588, -6.5622>, <-9.7444, 44.1044, -6.718>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.7444, 44.1044, -6.718>, <-9.9355, 44.5846, -7.001141>, 0.2183 }
				cylinder { <-9.9355, 44.5846, -7.001141>, <-10.1602, 45.01945, -7.3293>, 0.2183 }
				cylinder { <-10.1602, 45.01945, -7.3293>, <-10.4152, 45.4023, -7.6976>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-10.4152, 45.4023, -7.6976>, <-11.6025, 46.8188, -8.9637>, <-11.4445, 47.02987, -8.8122> }
					triangle { <-10.4152, 45.4023, -7.6976>, <-11.08938, 46.05396, -8.4994>, <-11.6025, 46.8188, -8.9637> }
					triangle { <-11.4445, 47.02987, -8.8122>, <-10.8083, 46.3988, -8.4596>, <-10.4152, 45.4023, -7.6976> }
					triangle { <-11.08938, 46.05396, -8.4994>, <-11.8926, 46.7734, -8.81>, <-11.6025, 46.8188, -8.9637> }
					triangle { <-11.8926, 46.7734, -8.81>, <-12.2068, 47.09543, -8.5063>, <-11.6025, 46.8188, -8.9637> }
					triangle { <-11.4445, 47.02987, -8.8122>, <-11.476, 47.363, -8.6512>, <-11.1811, 47.1906, -8.8688> }
					triangle { <-11.1811, 47.1906, -8.8688>, <-10.8083, 46.3988, -8.4596>, <-11.4445, 47.02987, -8.8122> }
					triangle { <-12.2068, 47.09543, -8.5063>, <-12.1311, 47.153, -8.5816>, <-11.6994, 47.136, -8.7739> }
					triangle { <-12.1311, 47.153, -8.5816>, <-12.1203, 47.3838, -8.1008>, <-11.6671, 47.4968, -8.5454> }
					triangle { <-11.6994, 47.136, -8.7739>, <-11.6671, 47.4968, -8.5454>, <-11.476, 47.363, -8.6512> }
					triangle { <-11.6994, 47.136, -8.7739>, <-12.1311, 47.153, -8.5816>, <-11.6671, 47.4968, -8.5454> }
					triangle { <-11.6025, 46.8188, -8.9637>, <-12.2068, 47.09543, -8.5063>, <-11.6994, 47.136, -8.7739> }
					triangle { <-11.4445, 47.02987, -8.8122>, <-11.6994, 47.136, -8.7739>, <-11.476, 47.363, -8.6512> }
					triangle { <-11.6025, 46.8188, -8.9637>, <-11.6994, 47.136, -8.7739>, <-11.4445, 47.02987, -8.8122> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.4152, 45.4023, -7.6976>, <-11.3886, 47.02369, -8.8987>, <-11.1128, 47.04678, -9.02433> }
					triangle { <-10.4152, 45.4023, -7.6976>, <-11.09566, 46.2198, -8.3226>, <-11.3886, 47.02369, -8.8987> }
					triangle { <-11.1128, 47.04678, -9.02433>, <-10.8012, 46.2122, -8.6585>, <-10.4152, 45.4023, -7.6976> }
					triangle { <-11.09566, 46.2198, -8.3226>, <-11.4118, 47.2447, -8.653>, <-11.3886, 47.02369, -8.8987> }
					triangle { <-11.4118, 47.2447, -8.653>, <-11.178, 47.7262, -8.5627>, <-11.3886, 47.02369, -8.8987> }
					triangle { <-11.1128, 47.04678, -9.02433>, <-10.8639, 47.2938, -9.1467>, <-10.9773, 46.9291, -9.2817> }
					triangle { <-10.9773, 46.9291, -9.2817>, <-10.8012, 46.2122, -8.6585>, <-11.1128, 47.04678, -9.02433> }
					triangle { <-11.178, 47.7262, -8.5627>, <-11.1819, 47.6914, -8.6789>, <-11.1521, 47.3163, -8.9653> }
					triangle { <-11.1819, 47.6914, -8.6789>, <-10.6988, 47.8857, -8.5629>, <-10.8099, 47.5388, -9.09505> }
					triangle { <-11.1521, 47.3163, -8.9653>, <-10.8099, 47.5388, -9.09505>, <-10.8639, 47.2938, -9.1467> }
					triangle { <-11.1521, 47.3163, -8.9653>, <-11.1819, 47.6914, -8.6789>, <-10.8099, 47.5388, -9.09505> }
					triangle { <-11.3886, 47.02369, -8.8987>, <-11.178, 47.7262, -8.5627>, <-11.1521, 47.3163, -8.9653> }
					triangle { <-11.1128, 47.04678, -9.02433>, <-11.1521, 47.3163, -8.9653>, <-10.8639, 47.2938, -9.1467> }
					triangle { <-11.3886, 47.02369, -8.8987>, <-11.1521, 47.3163, -8.9653>, <-11.1128, 47.04678, -9.02433> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.4152, 45.4023, -7.6976>, <-11.1599, 46.9876, -9.09452>, <-11.1295, 46.768, -9.3024> }
					triangle { <-10.4152, 45.4023, -7.6976>, <-10.89, 46.3482, -8.3314>, <-11.1599, 46.9876, -9.09452> }
					triangle { <-11.1295, 46.768, -9.3024>, <-11.03254, 46.06778, -8.6485>, <-10.4152, 45.4023, -7.6976> }
					triangle { <-10.89, 46.3482, -8.3314>, <-10.8844, 47.1717, -9.09393>, <-11.1599, 46.9876, -9.09452> }
					triangle { <-10.8844, 47.1717, -9.09393>, <-10.5157, 47.2903, -9.4742>, <-11.1599, 46.9876, -9.09452> }
					triangle { <-11.1295, 46.768, -9.3024>, <-11.01878, 46.7052, -9.6513>, <-11.3233, 46.5566, -9.4295> }
					triangle { <-11.3233, 46.5566, -9.4295>, <-11.03254, 46.06778, -8.6485>, <-11.1295, 46.768, -9.3024> }
					triangle { <-10.5157, 47.2903, -9.4742>, <-10.6246, 47.257, -9.5162>, <-10.9915, 46.9694, -9.4369> }
					triangle { <-10.6246, 47.257, -9.5162>, <-10.2401, 47.00965, -9.791>, <-10.8552, 46.8174, -9.8135> }
					triangle { <-10.9915, 46.9694, -9.4369>, <-10.8552, 46.8174, -9.8135>, <-11.01878, 46.7052, -9.6513> }
					triangle { <-10.9915, 46.9694, -9.4369>, <-10.6246, 47.257, -9.5162>, <-10.8552, 46.8174, -9.8135> }
					triangle { <-11.1599, 46.9876, -9.09452>, <-10.5157, 47.2903, -9.4742>, <-10.9915, 46.9694, -9.4369> }
					triangle { <-11.1295, 46.768, -9.3024>, <-10.9915, 46.9694, -9.4369>, <-11.01878, 46.7052, -9.6513> }
					triangle { <-11.1599, 46.9876, -9.09452>, <-10.9915, 46.9694, -9.4369>, <-11.1295, 46.768, -9.3024> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.4152, 45.4023, -7.6976>, <-11.2303, 46.7602, -9.2822>, <-11.4717, 46.5763, -9.2649> }
					triangle { <-10.4152, 45.4023, -7.6976>, <-10.7548, 46.2628, -8.5137>, <-11.2303, 46.7602, -9.2822> }
					triangle { <-11.4717, 46.5763, -9.2649>, <-11.1846, 46.1638, -8.4434>, <-10.4152, 45.4023, -7.6976> }
					triangle { <-10.7548, 46.2628, -8.5137>, <-11.03434, 46.6546, -9.5276>, <-11.2303, 46.7602, -9.2822> }
					triangle { <-11.03434, 46.6546, -9.5276>, <-11.129, 46.386, -9.9897>, <-11.2303, 46.7602, -9.2822> }
					triangle { <-11.4717, 46.5763, -9.2649>, <-11.7279, 46.4052, -9.4724>, <-11.7441, 46.5843, -9.1094> }
					triangle { <-11.7441, 46.5843, -9.1094>, <-11.1846, 46.1638, -8.4434>, <-11.4717, 46.5763, -9.2649> }
					triangle { <-11.129, 46.386, -9.9897>, <-11.2241, 46.446, -9.9442>, <-11.438, 46.5716, -9.5415> }
					triangle { <-11.2241, 46.446, -9.9442>, <-11.3738, 45.9581, -10.09943>, <-11.7408, 46.3229, -9.7146> }
					triangle { <-11.438, 46.5716, -9.5415>, <-11.7408, 46.3229, -9.7146>, <-11.7279, 46.4052, -9.4724> }
					triangle { <-11.438, 46.5716, -9.5415>, <-11.2241, 46.446, -9.9442>, <-11.7408, 46.3229, -9.7146> }
					triangle { <-11.2303, 46.7602, -9.2822>, <-11.129, 46.386, -9.9897>, <-11.438, 46.5716, -9.5415> }
					triangle { <-11.4717, 46.5763, -9.2649>, <-11.438, 46.5716, -9.5415>, <-11.7279, 46.4052, -9.4724> }
					triangle { <-11.2303, 46.7602, -9.2822>, <-11.438, 46.5716, -9.5415>, <-11.4717, 46.5763, -9.2649> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.4152, 45.4023, -7.6976>, <-11.508, 46.6543, -9.2001>, <-11.6694, 46.7405, -8.9574> }
					triangle { <-10.4152, 45.4023, -7.6976>, <-10.8798, 46.07826, -8.6191>, <-11.508, 46.6543, -9.2001> }
					triangle { <-11.6694, 46.7405, -8.9574>, <-11.04403, 46.3715, -8.3249>, <-10.4152, 45.4023, -7.6976> }
					triangle { <-10.8798, 46.07826, -8.6191>, <-11.6668, 46.4048, -9.3495>, <-11.508, 46.6543, -9.2001> }
					triangle { <-11.6668, 46.4048, -9.3495>, <-12.1899, 46.2637, -9.3825>, <-11.508, 46.6543, -9.2001> }
					triangle { <-11.6694, 46.7405, -8.9574>, <-12.01483, 46.8179, -8.8449>, <-11.6549, 46.9821, -8.7577> }
					triangle { <-11.6549, 46.9821, -8.7577>, <-11.04403, 46.3715, -8.3249>, <-11.6694, 46.7405, -8.9574> }
					triangle { <-12.1899, 46.2637, -9.3825>, <-12.1693, 46.3808, -9.3579>, <-11.8821, 46.6761, -9.1256> }
					triangle { <-12.1693, 46.3808, -9.3579>, <-12.5534, 46.1929, -9.03906>, <-12.2501, 46.7491, -8.9191> }
					triangle { <-11.8821, 46.6761, -9.1256>, <-12.2501, 46.7491, -8.9191>, <-12.01483, 46.8179, -8.8449> }
					triangle { <-11.8821, 46.6761, -9.1256>, <-12.1693, 46.3808, -9.3579>, <-12.2501, 46.7491, -8.9191> }
					triangle { <-11.508, 46.6543, -9.2001>, <-12.1899, 46.2637, -9.3825>, <-11.8821, 46.6761, -9.1256> }
					triangle { <-11.6694, 46.7405, -8.9574>, <-11.8821, 46.6761, -9.1256>, <-12.01483, 46.8179, -8.8449> }
					triangle { <-11.508, 46.6543, -9.2001>, <-11.8821, 46.6761, -9.1256>, <-11.6694, 46.7405, -8.9574> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-9.7444, 44.1044, -6.718>, <-9.8531, 44.4624, -6.8378>, 0.2183 }
			cylinder { <-9.8531, 44.4624, -6.8378>, <-9.9664, 44.8294, -6.9203>, 0.2183 }
			cylinder { <-9.9664, 44.8294, -6.9203>, <-10.08328, 45.2018, -6.9648>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.08328, 45.2018, -6.9648>, <-10.2626, 45.7632, -6.9595>, 0.2183 }
				cylinder { <-10.2626, 45.7632, -6.9595>, <-10.4434, 46.3187, -6.8821>, 0.2183 }
				cylinder { <-10.4434, 46.3187, -6.8821>, <-10.6229, 46.86, -6.7339>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-10.6229, 46.86, -6.7339>, <-11.0556, 48.9643, -6.1207>, <-11.09234, 49.00567, -6.4188> }
					triangle { <-10.6229, 46.86, -6.7339>, <-10.8973, 47.9558, -6.2466>, <-11.0556, 48.9643, -6.1207> }
					triangle { <-11.09234, 49.00567, -6.4188>, <-11.1229, 48.06602, -6.6145>, <-10.6229, 46.86, -6.7339> }
					triangle { <-10.8973, 47.9558, -6.2466>, <-10.7454, 49.04525, -6.04056>, <-11.0556, 48.9643, -6.1207> }
					triangle { <-10.7454, 49.04525, -6.04056>, <-10.386, 49.3907, -6.2514>, <-11.0556, 48.9643, -6.1207> }
					triangle { <-11.09234, 49.00567, -6.4188>, <-11.02339, 49.2442, -6.6936>, <-11.3384, 49.00503, -6.6119> }
					triangle { <-11.3384, 49.00503, -6.6119>, <-11.1229, 48.06602, -6.6145>, <-11.09234, 49.00567, -6.4188> }
					triangle { <-10.386, 49.3907, -6.2514>, <-10.5019, 49.4152, -6.2762>, <-10.9198, 49.2181, -6.3704> }
					triangle { <-10.5019, 49.4152, -6.2762>, <-10.2077, 49.4648, -6.7166>, <-10.8493, 49.4261, -6.7367> }
					triangle { <-10.9198, 49.2181, -6.3704>, <-10.8493, 49.4261, -6.7367>, <-11.02339, 49.2442, -6.6936> }
					triangle { <-10.9198, 49.2181, -6.3704>, <-10.5019, 49.4152, -6.2762>, <-10.8493, 49.4261, -6.7367> }
					triangle { <-11.0556, 48.9643, -6.1207>, <-10.386, 49.3907, -6.2514>, <-10.9198, 49.2181, -6.3704> }
					triangle { <-11.09234, 49.00567, -6.4188>, <-10.9198, 49.2181, -6.3704>, <-11.02339, 49.2442, -6.6936> }
					triangle { <-11.0556, 48.9643, -6.1207>, <-10.9198, 49.2181, -6.3704>, <-11.09234, 49.00567, -6.4188> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.6229, 46.86, -6.7339>, <-11.1903, 48.9933, -6.3898>, <-11.4662, 48.895, -6.4677> }
					triangle { <-10.6229, 46.86, -6.7339>, <-10.7991, 48.04387, -6.4493>, <-11.1903, 48.9933, -6.3898> }
					triangle { <-11.4662, 48.895, -6.4677>, <-11.2334, 47.9669, -6.3865>, <-10.6229, 46.86, -6.7339> }
					triangle { <-10.7991, 48.04387, -6.4493>, <-11.04235, 49.116, -6.6586>, <-11.1903, 48.9933, -6.3898> }
					triangle { <-11.04235, 49.116, -6.6586>, <-11.2284, 49.3468, -7.1115>, <-11.1903, 48.9933, -6.3898> }
					triangle { <-11.4662, 48.895, -6.4677>, <-11.7682, 48.9882, -6.6607>, <-11.7172, 48.7964, -6.3089> }
					triangle { <-11.7172, 48.7964, -6.3089>, <-11.2334, 47.9669, -6.3865>, <-11.4662, 48.895, -6.4677> }
					triangle { <-11.2284, 49.3468, -7.1115>, <-11.303, 49.3522, -7.01639>, <-11.453, 49.1145, -6.6377> }
					triangle { <-11.303, 49.3522, -7.01639>, <-11.5744, 49.2129, -7.4522>, <-11.8163, 49.1394, -6.8609> }
					triangle { <-11.453, 49.1145, -6.6377>, <-11.8163, 49.1394, -6.8609>, <-11.7682, 48.9882, -6.6607> }
					triangle { <-11.453, 49.1145, -6.6377>, <-11.303, 49.3522, -7.01639>, <-11.8163, 49.1394, -6.8609> }
					triangle { <-11.1903, 48.9933, -6.3898>, <-11.2284, 49.3468, -7.1115>, <-11.453, 49.1145, -6.6377> }
					triangle { <-11.4662, 48.895, -6.4677>, <-11.453, 49.1145, -6.6377>, <-11.7682, 48.9882, -6.6607> }
					triangle { <-11.1903, 48.9933, -6.3898>, <-11.453, 49.1145, -6.6377>, <-11.4662, 48.895, -6.4677> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.6229, 46.86, -6.7339>, <-11.4742, 48.8924, -6.3651>, <-11.5998, 48.7569, -6.1248> }
					triangle { <-10.6229, 46.86, -6.7339>, <-10.9662, 48.03632, -6.624>, <-11.4742, 48.8924, -6.3651> }
					triangle { <-11.5998, 48.7569, -6.1248>, <-11.04548, 47.9754, -6.1899>, <-10.6229, 46.86, -6.7339> }
					triangle { <-10.9662, 48.03632, -6.624>, <-11.6915, 48.8884, -6.614>, <-11.4742, 48.8924, -6.3651> }
					triangle { <-11.6915, 48.8884, -6.614>, <-12.2324, 48.883, -6.6338>, <-11.4742, 48.8924, -6.3651> }
					triangle { <-11.5998, 48.7569, -6.1248>, <-11.9121, 48.7394, -5.9266>, <-11.5219, 48.7282, -5.8232> }
					triangle { <-11.5219, 48.7282, -5.8232>, <-11.04548, 47.9754, -6.1899>, <-11.5998, 48.7569, -6.1248> }
					triangle { <-12.2324, 48.883, -6.6338>, <-12.1849, 48.927, -6.5315>, <-11.8287, 48.8773, -6.2264> }
					triangle { <-12.1849, 48.927, -6.5315>, <-12.5846, 48.5948, -6.4179>, <-12.1595, 48.7826, -5.9734> }
					triangle { <-11.8287, 48.8773, -6.2264>, <-12.1595, 48.7826, -5.9734>, <-11.9121, 48.7394, -5.9266> }
					triangle { <-11.8287, 48.8773, -6.2264>, <-12.1849, 48.927, -6.5315>, <-12.1595, 48.7826, -5.9734> }
					triangle { <-11.4742, 48.8924, -6.3651>, <-12.2324, 48.883, -6.6338>, <-11.8287, 48.8773, -6.2264> }
					triangle { <-11.5998, 48.7569, -6.1248>, <-11.8287, 48.8773, -6.2264>, <-11.9121, 48.7394, -5.9266> }
					triangle { <-11.4742, 48.8924, -6.3651>, <-11.8287, 48.8773, -6.2264>, <-11.5998, 48.7569, -6.1248> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.6229, 46.86, -6.7339>, <-11.5176, 48.8001, -6.08058>, <-11.3096, 48.7808, -5.8608> }
					triangle { <-10.6229, 46.86, -6.7339>, <-11.1692, 47.9435, -6.5309>, <-11.5176, 48.8001, -6.08058> }
					triangle { <-11.3096, 48.7808, -5.8608>, <-10.817, 48.07986, -6.2946>, <-10.6229, 46.86, -6.7339> }
					triangle { <-11.1692, 47.9435, -6.5309>, <-11.8019, 48.6749, -5.9678>, <-11.5176, 48.8001, -6.08058> }
					triangle { <-11.8019, 48.6749, -5.9678>, <-12.01993, 48.636, -5.4739>, <-11.5176, 48.8001, -6.08058> }
					triangle { <-11.3096, 48.7808, -5.8608>, <-11.2575, 48.8394, -5.4989>, <-11.02064, 48.8939, -5.8214> }
					triangle { <-11.02064, 48.8939, -5.8214>, <-10.817, 48.07986, -6.2946>, <-11.3096, 48.7808, -5.8608> }
					triangle { <-12.01993, 48.636, -5.4739>, <-11.9371, 48.7232, -5.4871>, <-11.5312, 48.8321, -5.7011> }
					triangle { <-11.9371, 48.7232, -5.4871>, <-11.8516, 48.4588, -5.03354>, <-11.4078, 48.8454, -5.2924> }
					triangle { <-11.5312, 48.8321, -5.7011>, <-11.4078, 48.8454, -5.2924>, <-11.2575, 48.8394, -5.4989> }
					triangle { <-11.5312, 48.8321, -5.7011>, <-11.9371, 48.7232, -5.4871>, <-11.4078, 48.8454, -5.2924> }
					triangle { <-11.5176, 48.8001, -6.08058>, <-12.01993, 48.636, -5.4739>, <-11.5312, 48.8321, -5.7011> }
					triangle { <-11.3096, 48.7808, -5.8608>, <-11.5312, 48.8321, -5.7011>, <-11.2575, 48.8394, -5.4989> }
					triangle { <-11.5176, 48.8001, -6.08058>, <-11.5312, 48.8321, -5.7011>, <-11.3096, 48.7808, -5.8608> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.6229, 46.86, -6.7339>, <-11.255, 48.8452, -5.9272>, <-10.9912, 48.9369, -6.0453> }
					triangle { <-10.6229, 46.86, -6.7339>, <-11.126, 47.893, -6.2941>, <-11.255, 48.8452, -5.9272> }
					triangle { <-10.9912, 48.9369, -6.0453>, <-10.8656, 48.1366, -6.561>, <-10.6229, 46.86, -6.7339> }
					triangle { <-11.126, 47.893, -6.2941>, <-11.2083, 48.7733, -5.6081>, <-11.255, 48.8452, -5.9272> }
					triangle { <-11.2083, 48.7733, -5.6081>, <-10.8615, 48.9544, -5.2341>, <-11.255, 48.8452, -5.9272> }
					triangle { <-10.9912, 48.9369, -6.0453>, <-10.6999, 49.1561, -5.98>, <-10.9055, 49.06764, -6.3163> }
					triangle { <-10.9055, 49.06764, -6.3163>, <-10.8656, 48.1366, -6.561>, <-10.9912, 48.9369, -6.0453> }
					triangle { <-10.8615, 48.9544, -5.2341>, <-10.8812, 49.02956, -5.3269>, <-10.961, 49.046, -5.7914> }
					triangle { <-10.8812, 49.02956, -5.3269>, <-10.3605, 49.00467, -5.2209>, <-10.5858, 49.2491, -5.7713> }
					triangle { <-10.961, 49.046, -5.7914>, <-10.5858, 49.2491, -5.7713>, <-10.6999, 49.1561, -5.98> }
					triangle { <-10.961, 49.046, -5.7914>, <-10.8812, 49.02956, -5.3269>, <-10.5858, 49.2491, -5.7713> }
					triangle { <-11.255, 48.8452, -5.9272>, <-10.8615, 48.9544, -5.2341>, <-10.961, 49.046, -5.7914> }
					triangle { <-10.9912, 48.9369, -6.0453>, <-10.961, 49.046, -5.7914>, <-10.6999, 49.1561, -5.98> }
					triangle { <-11.255, 48.8452, -5.9272>, <-10.961, 49.046, -5.7914>, <-10.9912, 48.9369, -6.0453> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-8.4359, 38.5696, -5.4451>, <-8.5849, 38.9219, -5.3553>, 0.2183 }
			cylinder { <-8.5849, 38.9219, -5.3553>, <-8.7623, 39.2554, -5.2474>, 0.2183 }
			cylinder { <-8.7623, 39.2554, -5.2474>, <-8.9664, 39.567, -5.1225>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <-8.9664, 39.567, -5.1225>, <-9.2036, 39.8253, -4.9455>, 0.2183 }
			cylinder { <-9.2036, 39.8253, -4.9455>, <-9.4091, 40.1031, -4.7585>, 0.2183 }
			cylinder { <-9.4091, 40.1031, -4.7585>, <-9.5808, 40.3976, -4.5632>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.5808, 40.3976, -4.5632>, <-9.7717, 40.8647, -4.2588>, 0.2183 }
				cylinder { <-9.7717, 40.8647, -4.2588>, <-9.893, 41.3501, -3.9475>, 0.2183 }
				cylinder { <-9.893, 41.3501, -3.9475>, <-9.9429, 41.8465, -3.634>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-9.9429, 41.8465, -3.634>, <-10.09981, 43.8551, -2.6684>, <-10.394, 43.7843, -2.6516> }
					triangle { <-9.9429, 41.8465, -3.634>, <-9.8674, 42.936, -3.06766>, <-10.09981, 43.8551, -2.6684> }
					triangle { <-10.394, 43.7843, -2.6516>, <-10.2528, 42.8572, -2.8587>, <-9.9429, 41.8465, -3.634> }
					triangle { <-9.8674, 42.936, -3.06766>, <-10.04968, 44.03313, -2.9423>, <-10.09981, 43.8551, -2.6684> }
					triangle { <-10.04968, 44.03313, -2.9423>, <-10.3637, 44.367, -3.2301>, <-10.09981, 43.8551, -2.6684> }
					triangle { <-10.394, 43.7843, -2.6516>, <-10.7337, 43.9269, -2.6891>, <-10.5773, 43.6577, -2.4319> }
					triangle { <-10.5773, 43.6577, -2.4319>, <-10.2528, 42.8572, -2.8587>, <-10.394, 43.7843, -2.6516> }
					triangle { <-10.3637, 44.367, -3.2301>, <-10.3965, 44.352, -3.1145>, <-10.4205, 44.0368, -2.7647> }
					triangle { <-10.3965, 44.352, -3.1145>, <-10.8241, 44.3243, -3.4297>, <-10.8355, 44.1216, -2.8195> }
					triangle { <-10.4205, 44.0368, -2.7647>, <-10.8355, 44.1216, -2.8195>, <-10.7337, 43.9269, -2.6891> }
					triangle { <-10.4205, 44.0368, -2.7647>, <-10.3965, 44.352, -3.1145>, <-10.8355, 44.1216, -2.8195> }
					triangle { <-10.09981, 43.8551, -2.6684>, <-10.3637, 44.367, -3.2301>, <-10.4205, 44.0368, -2.7647> }
					triangle { <-10.394, 43.7843, -2.6516>, <-10.4205, 44.0368, -2.7647>, <-10.7337, 43.9269, -2.6891> }
					triangle { <-10.09981, 43.8551, -2.6684>, <-10.4205, 44.0368, -2.7647>, <-10.394, 43.7843, -2.6516> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-9.9429, 41.8465, -3.634>, <-10.3635, 43.7581, -2.5569>, <-10.4051, 43.5737, -2.32> }
					triangle { <-9.9429, 41.8465, -3.634>, <-10.08716, 42.9733, -3.1615>, <-10.3635, 43.7581, -2.5569> }
					triangle { <-10.4051, 43.5737, -2.32>, <-10.00568, 42.8154, -2.7531>, <-9.9429, 41.8465, -3.634> }
					triangle { <-10.08716, 42.9733, -3.1615>, <-10.6568, 43.8173, -2.6972>, <-10.3635, 43.7581, -2.5569> }
					triangle { <-10.6568, 43.8173, -2.6972>, <-11.1632, 43.8297, -2.5066>, <-10.3635, 43.7581, -2.5569> }
					triangle { <-10.4051, 43.5737, -2.32>, <-10.6212, 43.5184, -2.0244>, <-10.2244, 43.474, -2.08487> }
					triangle { <-10.2244, 43.474, -2.08487>, <-10.00568, 42.8154, -2.7531>, <-10.4051, 43.5737, -2.32> }
					triangle { <-11.1632, 43.8297, -2.5066>, <-11.07655, 43.8476, -2.4241>, <-10.6404, 43.7199, -2.298> }
					triangle { <-11.07655, 43.8476, -2.4241>, <-11.4397, 43.5079, -2.2351>, <-10.8618, 43.5772, -1.9618> }
					triangle { <-10.6404, 43.7199, -2.298>, <-10.8618, 43.5772, -1.9618>, <-10.6212, 43.5184, -2.0244> }
					triangle { <-10.6404, 43.7199, -2.298>, <-11.07655, 43.8476, -2.4241>, <-10.8618, 43.5772, -1.9618> }
					triangle { <-10.3635, 43.7581, -2.5569>, <-11.1632, 43.8297, -2.5066>, <-10.6404, 43.7199, -2.298> }
					triangle { <-10.4051, 43.5737, -2.32>, <-10.6404, 43.7199, -2.298>, <-10.6212, 43.5184, -2.0244> }
					triangle { <-10.3635, 43.7581, -2.5569>, <-10.6404, 43.7199, -2.298>, <-10.4051, 43.5737, -2.32> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-9.9429, 41.8465, -3.634>, <-10.308, 43.6034, -2.3031>, <-10.03691, 43.5287, -2.1901> }
					triangle { <-9.9429, 41.8465, -3.634>, <-10.25, 42.8664, -3.01827>, <-10.308, 43.6034, -2.3031> }
					triangle { <-10.03691, 43.5287, -2.1901>, <-9.8224, 42.9356, -2.9143>, <-9.9429, 41.8465, -3.634> }
					triangle { <-10.25, 42.8664, -3.01827>, <-10.5422, 43.4625, -2.1173>, <-10.308, 43.6034, -2.3031> }
					triangle { <-10.5422, 43.4625, -2.1173>, <-10.5639, 43.3154, -1.5969>, <-10.308, 43.6034, -2.3031> }
					triangle { <-10.03691, 43.5287, -2.1901>, <-9.8478, 43.5006, -1.8729>, <-9.7432, 43.6226, -2.2435> }
					triangle { <-9.7432, 43.6226, -2.2435>, <-9.8224, 42.9356, -2.9143>, <-10.03691, 43.5287, -2.1901> }
					triangle { <-10.5639, 43.3154, -1.5969>, <-10.4827, 43.4013, -1.6229>, <-10.176, 43.547, -1.9502> }
					triangle { <-10.4827, 43.4013, -1.6229>, <-10.2649, 43.03703, -1.3023>, <-9.9089, 43.4622, -1.6279> }
					triangle { <-10.176, 43.547, -1.9502>, <-9.9089, 43.4622, -1.6279>, <-9.8478, 43.5006, -1.8729> }
					triangle { <-10.176, 43.547, -1.9502>, <-10.4827, 43.4013, -1.6229>, <-9.9089, 43.4622, -1.6279> }
					triangle { <-10.308, 43.6034, -2.3031>, <-10.5639, 43.3154, -1.5969>, <-10.176, 43.547, -1.9502> }
					triangle { <-10.03691, 43.5287, -2.1901>, <-10.176, 43.547, -1.9502>, <-9.8478, 43.5006, -1.8729> }
					triangle { <-10.308, 43.6034, -2.3031>, <-10.176, 43.547, -1.9502>, <-10.03691, 43.5287, -2.1901> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-9.9429, 41.8465, -3.634>, <-10.00955, 43.6034, -2.2555>, <-9.7948, 43.7111, -2.4403> }
					triangle { <-9.9429, 41.8465, -3.634>, <-10.1324, 42.7621, -2.8344>, <-10.00955, 43.6034, -2.2555> }
					triangle { <-9.7948, 43.7111, -2.4403>, <-9.9547, 43.05298, -3.1211>, <-9.9429, 41.8465, -3.634> }
					triangle { <-10.1324, 42.7621, -2.8344>, <-9.8631, 43.4558, -1.9985>, <-10.00955, 43.6034, -2.2555> }
					triangle { <-9.8631, 43.4558, -1.9985>, <-9.3883, 43.5301, -1.7496>, <-10.00955, 43.6034, -2.2555> }
					triangle { <-9.7948, 43.7111, -2.4403>, <-9.475, 43.8979, -2.4427>, <-9.7943, 43.8995, -2.6901> }
					triangle { <-9.7943, 43.8995, -2.6901>, <-9.9547, 43.05298, -3.1211>, <-9.7948, 43.7111, -2.4403> }
					triangle { <-9.3883, 43.5301, -1.7496>, <-9.4301, 43.6258, -1.8108>, <-9.6648, 43.7554, -2.1987> }
					triangle { <-9.4301, 43.6258, -1.8108>, <-8.9122, 43.5578, -1.9116>, <-9.2848, 43.9344, -2.2762> }
					triangle { <-9.6648, 43.7554, -2.1987>, <-9.2848, 43.9344, -2.2762>, <-9.475, 43.8979, -2.4427> }
					triangle { <-9.6648, 43.7554, -2.1987>, <-9.4301, 43.6258, -1.8108>, <-9.2848, 43.9344, -2.2762> }
					triangle { <-10.00955, 43.6034, -2.2555>, <-9.3883, 43.5301, -1.7496>, <-9.6648, 43.7554, -2.1987> }
					triangle { <-9.7948, 43.7111, -2.4403>, <-9.6648, 43.7554, -2.1987>, <-9.475, 43.8979, -2.4427> }
					triangle { <-10.00955, 43.6034, -2.2555>, <-9.6648, 43.7554, -2.1987>, <-9.7948, 43.7111, -2.4403> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-9.9429, 41.8465, -3.634>, <-9.8788, 43.7612, -2.4846>, <-10.01891, 43.8714, -2.7299> }
					triangle { <-9.9429, 41.8465, -3.634>, <-9.8924, 42.8058, -2.8654>, <-9.8788, 43.7612, -2.4846> }
					triangle { <-10.01891, 43.8714, -2.7299>, <-10.2247, 43.0038, -3.08631>, <-9.9429, 41.8465, -3.634> }
					triangle { <-9.8924, 42.8058, -2.8654>, <-9.5541, 43.8138, -2.5161>, <-9.8788, 43.7612, -2.4846> }
					triangle { <-9.5541, 43.8138, -2.5161>, <-9.2627, 44.1899, -2.7742>, <-9.8788, 43.7612, -2.4846> }
					triangle { <-10.01891, 43.8714, -2.7299>, <-10.03087, 44.1654, -2.9548>, <-10.3175, 43.9215, -2.8083> }
					triangle { <-10.3175, 43.9215, -2.8083>, <-10.2247, 43.0038, -3.08631>, <-10.01891, 43.8714, -2.7299> }
					triangle { <-9.2627, 44.1899, -2.7742>, <-9.376, 44.2223, -2.7465>, <-9.8182, 44.06265, -2.7097> }
					triangle { <-9.376, 44.2223, -2.7465>, <-9.2631, 44.3654, -3.2463>, <-9.8661, 44.3481, -3.02382> }
					triangle { <-9.8182, 44.06265, -2.7097>, <-9.8661, 44.3481, -3.02382>, <-10.03087, 44.1654, -2.9548> }
					triangle { <-9.8182, 44.06265, -2.7097>, <-9.376, 44.2223, -2.7465>, <-9.8661, 44.3481, -3.02382> }
					triangle { <-9.8788, 43.7612, -2.4846>, <-9.2627, 44.1899, -2.7742>, <-9.8182, 44.06265, -2.7097> }
					triangle { <-10.01891, 43.8714, -2.7299>, <-9.8182, 44.06265, -2.7097>, <-10.03087, 44.1654, -2.9548> }
					triangle { <-9.8788, 43.7612, -2.4846>, <-9.8182, 44.06265, -2.7097>, <-10.01891, 43.8714, -2.7299> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-8.9664, 39.567, -5.1225>, <-9.1286, 39.9184, -5.05493>, 0.2183 }
			cylinder { <-9.1286, 39.9184, -5.05493>, <-9.3247, 40.2536, -4.996>, 0.2183 }
			cylinder { <-9.3247, 40.2536, -4.996>, <-9.5528, 40.5696, -4.9465>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.5528, 40.5696, -4.9465>, <-9.9504, 41.00098, -4.8906>, 0.2183 }
				cylinder { <-9.9504, 41.00098, -4.8906>, <-10.3975, 41.3831, -4.8539>, 0.2183 }
				cylinder { <-10.3975, 41.3831, -4.8539>, <-10.8872, 41.7105, -4.8371>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-10.8872, 41.7105, -4.8371>, <-12.7891, 42.8449, -4.5422>, <-12.6009, 43.07763, -4.4941> }
					triangle { <-10.8872, 41.7105, -4.8371>, <-12.00688, 42.215, -4.7642>, <-12.7891, 42.8449, -4.5422> }
					triangle { <-12.6009, 43.07763, -4.4941>, <-11.8335, 42.6177, -4.8432>, <-10.8872, 41.7105, -4.8371> }
					triangle { <-12.00688, 42.215, -4.7642>, <-12.8683, 42.7114, -4.2505>, <-12.7891, 42.8449, -4.5422> }
					triangle { <-12.8683, 42.7114, -4.2505>, <-12.9039, 42.9111, -3.7487>, <-12.7891, 42.8449, -4.5422> }
					triangle { <-12.6009, 43.07763, -4.4941>, <-12.5497, 43.3754, -4.2799>, <-12.4848, 43.3068, -4.6726> }
					triangle { <-12.4848, 43.3068, -4.6726>, <-11.8335, 42.6177, -4.8432>, <-12.6009, 43.07763, -4.4941> }
					triangle { <-12.9039, 42.9111, -3.7487>, <-12.9146, 42.9925, -3.8376>, <-12.7594, 43.1075, -4.2678> }
					triangle { <-12.9146, 42.9925, -3.8376>, <-12.5908, 43.1787, -3.4589>, <-12.6201, 43.4437, -4.0441> }
					triangle { <-12.7594, 43.1075, -4.2678>, <-12.6201, 43.4437, -4.0441>, <-12.5497, 43.3754, -4.2799> }
					triangle { <-12.7594, 43.1075, -4.2678>, <-12.9146, 42.9925, -3.8376>, <-12.6201, 43.4437, -4.0441> }
					triangle { <-12.7891, 42.8449, -4.5422>, <-12.9039, 42.9111, -3.7487>, <-12.7594, 43.1075, -4.2678> }
					triangle { <-12.6009, 43.07763, -4.4941>, <-12.7594, 43.1075, -4.2678>, <-12.5497, 43.3754, -4.2799> }
					triangle { <-12.7891, 42.8449, -4.5422>, <-12.7594, 43.1075, -4.2678>, <-12.6009, 43.07763, -4.4941> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.8872, 41.7105, -4.8371>, <-12.6247, 43.09353, -4.5929>, <-12.5318, 43.1997, -4.8612> }
					triangle { <-10.8872, 41.7105, -4.8371>, <-11.9053, 42.3583, -4.5979>, <-12.6247, 43.09353, -4.5929> }
					triangle { <-12.5318, 43.1997, -4.8612>, <-11.9477, 42.4565, -5.03033>, <-10.8872, 41.7105, -4.8371> }
					triangle { <-11.9053, 42.3583, -4.5979>, <-12.492, 43.2796, -4.3542>, <-12.6247, 43.09353, -4.5929> }
					triangle { <-12.492, 43.2796, -4.3542>, <-12.3322, 43.7963, -4.3326>, <-12.6247, 43.09353, -4.5929> }
					triangle { <-12.5318, 43.1997, -4.8612>, <-12.4845, 43.5127, -5.05351>, <-12.6106, 43.1437, -5.1588> }
					triangle { <-12.6106, 43.1437, -5.1588>, <-11.9477, 42.4565, -5.03033>, <-12.5318, 43.1997, -4.8612> }
					triangle { <-12.3322, 43.7963, -4.3326>, <-12.4141, 43.7711, -4.4181>, <-12.5513, 43.4424, -4.7272> }
					triangle { <-12.4141, 43.7711, -4.4181>, <-12.02957, 44.07812, -4.6201>, <-12.4429, 43.7577, -4.9942> }
					triangle { <-12.5513, 43.4424, -4.7272>, <-12.4429, 43.7577, -4.9942>, <-12.4845, 43.5127, -5.05351> }
					triangle { <-12.5513, 43.4424, -4.7272>, <-12.4141, 43.7711, -4.4181>, <-12.4429, 43.7577, -4.9942> }
					triangle { <-12.6247, 43.09353, -4.5929>, <-12.3322, 43.7963, -4.3326>, <-12.5513, 43.4424, -4.7272> }
					triangle { <-12.5318, 43.1997, -4.8612>, <-12.5513, 43.4424, -4.7272>, <-12.4845, 43.5127, -5.05351> }
					triangle { <-12.6247, 43.09353, -4.5929>, <-12.5513, 43.4424, -4.7272>, <-12.5318, 43.1997, -4.8612> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.8872, 41.7105, -4.8371>, <-12.6066, 43.1359, -4.8917>, <-12.7072, 42.9502, -5.1091> }
					triangle { <-10.8872, 41.7105, -4.8371>, <-11.7896, 42.5372, -4.7123>, <-12.6066, 43.1359, -4.8917> }
					triangle { <-12.7072, 42.9502, -5.1091>, <-12.0779, 42.2552, -4.9016>, <-10.8872, 41.7105, -4.8371> }
					triangle { <-11.7896, 42.5372, -4.7123>, <-12.4441, 43.3862, -5.03368>, <-12.6066, 43.1359, -4.8917> }
					triangle { <-12.4441, 43.3862, -5.03368>, <-12.4849, 43.6287, -5.5158>, <-12.6066, 43.1359, -4.8917> }
					triangle { <-12.7072, 42.9502, -5.1091>, <-12.8758, 42.9471, -5.4389>, <-12.902, 42.7055, -5.1163> }
					triangle { <-12.902, 42.7055, -5.1163>, <-12.0779, 42.2552, -4.9016>, <-12.7072, 42.9502, -5.1091> }
					triangle { <-12.4849, 43.6287, -5.5158>, <-12.5845, 43.5708, -5.4785>, <-12.7375, 43.1906, -5.2453> }
					triangle { <-12.5845, 43.5708, -5.4785>, <-12.4904, 43.4591, -5.9901>, <-12.897, 43.1112, -5.6335> }
					triangle { <-12.7375, 43.1906, -5.2453>, <-12.897, 43.1112, -5.6335>, <-12.8758, 42.9471, -5.4389> }
					triangle { <-12.7375, 43.1906, -5.2453>, <-12.5845, 43.5708, -5.4785>, <-12.897, 43.1112, -5.6335> }
					triangle { <-12.6066, 43.1359, -4.8917>, <-12.4849, 43.6287, -5.5158>, <-12.7375, 43.1906, -5.2453> }
					triangle { <-12.7072, 42.9502, -5.1091>, <-12.7375, 43.1906, -5.2453>, <-12.8758, 42.9471, -5.4389> }
					triangle { <-12.6066, 43.1359, -4.8917>, <-12.7375, 43.1906, -5.2453>, <-12.7072, 42.9502, -5.1091> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.8872, 41.7105, -4.8371>, <-12.7597, 42.9139, -5.02846>, <-12.8862, 42.6715, -4.8975> }
					triangle { <-10.8872, 41.7105, -4.8371>, <-11.8186, 42.5062, -4.9504>, <-12.7597, 42.9139, -5.02846> }
					triangle { <-12.8862, 42.6715, -4.8975>, <-12.04535, 42.2901, -4.6337>, <-10.8872, 41.7105, -4.8371> }
					triangle { <-11.8186, 42.5062, -4.9504>, <-12.7904, 42.8849, -5.3562>, <-12.7597, 42.9139, -5.02846> }
					triangle { <-12.7904, 42.8849, -5.3562>, <-13.1524, 42.6384, -5.6742>, <-12.7597, 42.9139, -5.02846> }
					triangle { <-12.8862, 42.6715, -4.8975>, <-13.1865, 42.455, -4.9071>, <-12.9591, 42.5937, -4.6034> }
					triangle { <-12.9591, 42.5937, -4.6034>, <-12.04535, 42.2901, -4.6337>, <-12.8862, 42.6715, -4.8975> }
					triangle { <-13.1524, 42.6384, -5.6742>, <-13.1918, 42.6666, -5.5633>, <-13.06237, 42.6977, -5.1109> }
					triangle { <-13.1918, 42.6666, -5.5633>, <-13.3408, 42.1715, -5.6883>, <-13.3591, 42.3917, -5.08443> }
					triangle { <-13.06237, 42.6977, -5.1109>, <-13.3591, 42.3917, -5.08443>, <-13.1865, 42.455, -4.9071> }
					triangle { <-13.06237, 42.6977, -5.1109>, <-13.1918, 42.6666, -5.5633>, <-13.3591, 42.3917, -5.08443> }
					triangle { <-12.7597, 42.9139, -5.02846>, <-13.1524, 42.6384, -5.6742>, <-13.06237, 42.6977, -5.1109> }
					triangle { <-12.8862, 42.6715, -4.8975>, <-13.06237, 42.6977, -5.1109>, <-13.1865, 42.455, -4.9071> }
					triangle { <-12.7597, 42.9139, -5.02846>, <-13.06237, 42.6977, -5.1109>, <-12.8862, 42.6715, -4.8975> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-10.8872, 41.7105, -4.8371>, <-12.8742, 42.7314, -4.8092>, <-12.8195, 42.7515, -4.5117> }
					triangle { <-10.8872, 41.7105, -4.8371>, <-11.9548, 42.304, -4.983>, <-12.8742, 42.7314, -4.8092> }
					triangle { <-12.8195, 42.7515, -4.5117>, <-11.892, 42.5175, -4.5971>, <-10.8872, 41.7105, -4.8371> }
					triangle { <-11.9548, 42.304, -4.983>, <-13.05656, 42.4615, -4.8648>, <-12.8742, 42.7314, -4.8092> }
					triangle { <-13.05656, 42.4615, -4.8648>, <-13.4152, 42.1881, -4.5655>, <-12.8742, 42.7314, -4.8092> }
					triangle { <-12.8195, 42.7515, -4.5117>, <-12.9819, 42.7237, -4.18>, <-12.6974, 42.9709, -4.3251> }
					triangle { <-12.6974, 42.9709, -4.3251>, <-11.892, 42.5175, -4.5971>, <-12.8195, 42.7515, -4.5117> }
					triangle { <-13.4152, 42.1881, -4.5655>, <-13.3989, 42.3038, -4.5338>, <-13.0761, 42.6456, -4.4976> }
					triangle { <-13.3989, 42.3038, -4.5338>, <-13.4038, 41.9956, -4.1003>, <-13.1854, 42.6003, -4.08728> }
					triangle { <-13.0761, 42.6456, -4.4976>, <-13.1854, 42.6003, -4.08728>, <-12.9819, 42.7237, -4.18> }
					triangle { <-13.0761, 42.6456, -4.4976>, <-13.3989, 42.3038, -4.5338>, <-13.1854, 42.6003, -4.08728> }
					triangle { <-12.8742, 42.7314, -4.8092>, <-13.4152, 42.1881, -4.5655>, <-13.0761, 42.6456, -4.4976> }
					triangle { <-12.8195, 42.7515, -4.5117>, <-13.0761, 42.6456, -4.4976>, <-12.9819, 42.7237, -4.18> }
					triangle { <-12.8742, 42.7314, -4.8092>, <-13.0761, 42.6456, -4.4976>, <-12.8195, 42.7515, -4.5117> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		}
	union { // internode
		cylinder { <-1.646, 23.00595, -2.5417>, <-1.9012, 26.3675, -2.4004>, 0.5 }
		cylinder { <-1.9012, 26.3675, -2.4004>, <-1.8979, 29.6373, -1.5677>, 0.5 }
		cylinder { <-1.8979, 29.6373, -1.5677>, <-1.6363, 32.6566, -0.08414>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.6363, 32.6566, -0.08414>, <-1.3519, 33.778, 0.984>, 0.4999 }
			cylinder { <-1.3519, 33.778, 0.984>, <-0.9341, 34.4986, 2.3203>, 0.4999 }
			cylinder { <-0.9341, 34.4986, 2.3203>, <-0.4249, 34.7457, 3.7896>, 0.4999 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.4249, 34.7457, 3.7896>, <-0.2285, 34.864, 4.41>, 0.4999 }
				cylinder { <-0.2285, 34.864, 4.41>, <-0.04993, 34.9967, 5.03281>, 0.4999 }
				cylinder { <-0.04993, 34.9967, 5.03281>, <0.1107, 35.1436, 5.6572>, 0.4999 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <0.1107, 35.1436, 5.6572>, <0.1081, 35.1673, 5.7809>, 0.03999 }
				cylinder { <0.1081, 35.1673, 5.7809>, <0.07233, 35.1849, 5.9004>, 0.03999 }
				cylinder { <0.07233, 35.1849, 5.9004>, <0.006049, 35.1952, 6.007088>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <0.006049, 35.1952, 6.007088>, <-2.8942, 35.2644, 11.02217>, <-3.3322, 35.1809, 10.8217> }
				triangle { <-2.8942, 35.2644, 11.02217>, <-3.5571, 33.2395, 12.2091>, <-3.3322, 35.1809, 10.8217> }
				triangle { <-2.8942, 35.2644, 11.02217>, <-3.07613, 33.6801, 12.2104>, <-3.5571, 33.2395, 12.2091> }
				triangle { <-3.5571, 33.2395, 12.2091>, <-3.9134, 33.663, 11.6915>, <-3.3322, 35.1809, 10.8217> }
				triangle { <-3.3322, 35.1809, 10.8217>, <-2.1897, 34.8655, 8.8198>, <0.006049, 35.1952, 6.007088> }
				triangle { <0.006049, 35.1952, 6.007088>, <-1.4494, 34.916, 9.2751>, <-2.8942, 35.2644, 11.02217> }
				triangle { <-1.4494, 34.916, 9.2751>, <-2.3554, 34.7085, 11.2832>, <-2.8942, 35.2644, 11.02217> }
				triangle { <-2.3554, 34.7085, 11.2832>, <-3.07613, 33.6801, 12.2104>, <-2.8942, 35.2644, 11.02217> }
				triangle { <-3.3322, 35.1809, 10.8217>, <-3.9134, 33.663, 11.6915>, <-3.6179, 34.4149, 10.7182> }
				triangle { <-3.6179, 34.4149, 10.7182>, <-2.1897, 34.8655, 8.8198>, <-3.3322, 35.1809, 10.8217> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <0.1107, 35.1436, 5.6572>, <0.1384, 35.1713, 5.777>, 0.03999 }
				cylinder { <0.1384, 35.1713, 5.777>, <0.163, 35.1986, 5.8974>, 0.03999 }
				cylinder { <0.163, 35.1986, 5.8974>, <0.1847, 35.2256, 6.01861>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <0.1847, 35.2256, 6.01861>, <1.3287, 36.05002, 11.6381>, <0.8621, 36.02913, 11.7823> }
				triangle { <1.3287, 36.05002, 11.6381>, <1.4366, 34.2311, 13.2595>, <0.8621, 36.02913, 11.7823> }
				triangle { <1.3287, 36.05002, 11.6381>, <1.8358, 34.5856, 12.8845>, <1.4366, 34.2311, 13.2595> }
				triangle { <1.4366, 34.2311, 13.2595>, <0.8669, 34.6785, 13.03707>, <0.8621, 36.02913, 11.7823> }
				triangle { <0.8621, 36.02913, 11.7823>, <0.3686, 35.4191, 9.5921>, <0.1847, 35.2256, 6.01861> }
				triangle { <0.1847, 35.2256, 6.01861>, <1.2261, 35.3716, 9.4495>, <1.3287, 36.05002, 11.6381> }
				triangle { <1.2261, 35.3716, 9.4495>, <1.8541, 35.428, 11.5705>, <1.3287, 36.05002, 11.6381> }
				triangle { <1.8541, 35.428, 11.5705>, <1.8358, 34.5856, 12.8845>, <1.3287, 36.05002, 11.6381> }
				triangle { <0.8621, 36.02913, 11.7823>, <0.8669, 34.6785, 13.03707>, <0.5127, 35.3163, 12.00371> }
				triangle { <0.5127, 35.3163, 12.00371>, <0.3686, 35.4191, 9.5921>, <0.8621, 36.02913, 11.7823> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-1.6363, 32.6566, -0.08414>, <-1.05199, 35.1165, 2.1502>, 0.5 }
		cylinder { <-1.05199, 35.1165, 2.1502>, <-0.1953, 36.8054, 4.9429>, 0.5 }
		cylinder { <-0.1953, 36.8054, 4.9429>, <0.8597, 37.5777, 8.05346>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.8597, 37.5777, 8.05346>, <1.3498, 37.4208, 9.3682>, 0.4483 }
			cylinder { <1.3498, 37.4208, 9.3682>, <1.8312, 36.802, 10.5426>, 0.4483 }
			cylinder { <1.8312, 36.802, 10.5426>, <2.2475, 35.7938, 11.4391>, 0.4483 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.2475, 35.7938, 11.4391>, <2.4223, 35.3703, 11.8157>, 0.4483 }
				cylinder { <2.4223, 35.3703, 11.8157>, <2.5971, 34.9469, 12.1922>, 0.4483 }
				cylinder { <2.5971, 34.9469, 12.1922>, <2.772, 34.5234, 12.5688>, 0.4483 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <2.772, 34.5234, 12.5688>, <2.7755, 34.4514, 12.6399>, 0.03216 }
				cylinder { <2.7755, 34.4514, 12.6399>, <2.7523, 34.3849, 12.7127>, 0.03216 }
				cylinder { <2.7523, 34.3849, 12.7127>, <2.7042, 34.3288, 12.7819>, 0.03216 }
				texture{chif1}}
			mesh { // leaf
				triangle { <2.7042, 34.3288, 12.7819>, <0.2529, 31.1446, 16.07475>, <-0.1445, 31.3174, 16.00932> }
				triangle { <0.2529, 31.1446, 16.07475>, <-0.8574, 29.3756, 15.4262>, <-0.1445, 31.3174, 16.00932> }
				triangle { <0.2529, 31.1446, 16.07475>, <-0.3273, 29.5187, 15.6276>, <-0.8574, 29.3756, 15.4262> }
				triangle { <-0.8574, 29.3756, 15.4262>, <-1.04902, 30.01897, 15.5314>, <-0.1445, 31.3174, 16.00932> }
				triangle { <-0.1445, 31.3174, 16.00932>, <0.7433, 32.4482, 14.4977>, <2.7042, 34.3288, 12.7819> }
				triangle { <2.7042, 34.3288, 12.7819>, <1.3909, 32.02597, 14.6056>, <0.2529, 31.1446, 16.07475> }
				triangle { <1.3909, 32.02597, 14.6056>, <0.5643, 30.5949, 15.7038>, <0.2529, 31.1446, 16.07475> }
				triangle { <0.5643, 30.5949, 15.7038>, <-0.3273, 29.5187, 15.6276>, <0.2529, 31.1446, 16.07475> }
				triangle { <-0.1445, 31.3174, 16.00932>, <-1.04902, 30.01897, 15.5314>, <-0.5956, 31.05764, 15.4848> }
				triangle { <-0.5956, 31.05764, 15.4848>, <0.7433, 32.4482, 14.4977>, <-0.1445, 31.3174, 16.00932> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <2.772, 34.5234, 12.5688>, <2.8019, 34.4511, 12.6331>, 0.03216 }
				cylinder { <2.8019, 34.4511, 12.6331>, <2.8317, 34.3788, 12.6974>, 0.03216 }
				cylinder { <2.8317, 34.3788, 12.6974>, <2.8616, 34.3064, 12.7617>, 0.03216 }
				texture{chif1}}
			mesh { // leaf
				triangle { <2.8616, 34.3064, 12.7617>, <4.4068, 30.3469, 15.749>, <4.01288, 30.2751, 15.9275> }
				triangle { <4.4068, 30.3469, 15.749>, <4.09399, 28.2497, 15.2132>, <4.01288, 30.2751, 15.9275> }
				triangle { <4.4068, 30.3469, 15.749>, <4.5087, 28.6606, 15.1777>, <4.09399, 28.2497, 15.2132> }
				triangle { <4.09399, 28.2497, 15.2132>, <3.7196, 28.6871, 15.574>, <4.01288, 30.2751, 15.9275> }
				triangle { <4.01288, 30.2751, 15.9275>, <3.2902, 31.686, 14.5713>, <2.8616, 34.3064, 12.7617> }
				triangle { <2.8616, 34.3064, 12.7617>, <3.9977, 31.6848, 14.2416>, <4.4068, 30.3469, 15.749> }
				triangle { <3.9977, 31.6848, 14.2416>, <4.6773, 30.04959, 15.1366>, <4.4068, 30.3469, 15.749> }
				triangle { <4.6773, 30.04959, 15.1366>, <4.5087, 28.6606, 15.1777>, <4.4068, 30.3469, 15.749> }
				triangle { <4.01288, 30.2751, 15.9275>, <3.7196, 28.6871, 15.574>, <3.5318, 29.8047, 15.6219> }
				triangle { <3.5318, 29.8047, 15.6219>, <3.2902, 31.686, 14.5713>, <4.01288, 30.2751, 15.9275> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <0.8597, 37.5777, 8.05346>, <2.1919, 38.783, 10.8989>, 0.4986 }
		cylinder { <2.1919, 38.783, 10.8989>, <3.7647, 40.3878, 13.4039>, 0.4986 }
		cylinder { <3.7647, 40.3878, 13.4039>, <5.5318, 42.3448, 15.4947>, 0.4986 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <5.5318, 42.3448, 15.4947>, <6.2353, 43.213, 15.9085>, 0.3783 }
			cylinder { <6.2353, 43.213, 15.9085>, <6.9456, 44.1687, 15.9541>, 0.3783 }
			cylinder { <6.9456, 44.1687, 15.9541>, <7.5908, 45.1154, 15.6268>, 0.3783 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <7.5908, 45.1154, 15.6268>, <7.8747, 45.5075, 15.4996>, 0.3783 }
				cylinder { <7.8747, 45.5075, 15.4996>, <8.1711, 45.8935, 15.3829>, 0.3783 }
				cylinder { <8.1711, 45.8935, 15.3829>, <8.4797, 46.2729, 15.2766>, 0.3783 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <8.4797, 46.2729, 15.2766>, <8.5371, 46.3132, 15.2598>, 0.0229 }
				cylinder { <8.5371, 46.3132, 15.2598>, <8.6033, 46.3362, 15.2427>, 0.0229 }
				cylinder { <8.6033, 46.3362, 15.2427>, <8.6735, 46.3402, 15.2266>, 0.0229 }
				texture{chif1}}
			mesh { // leaf
				triangle { <8.6735, 46.3402, 15.2266>, <12.8507, 46.6172, 13.924>, <12.9221, 46.2562, 13.9619> }
				triangle { <12.8507, 46.6172, 13.924>, <13.4062, 46.196, 12.215>, <12.9221, 46.2562, 13.9619> }
				triangle { <12.8507, 46.6172, 13.924>, <13.2766, 46.5913, 12.4808>, <13.4062, 46.196, 12.215> }
				triangle { <13.4062, 46.196, 12.215>, <13.366, 45.8823, 12.6933>, <12.9221, 46.2562, 13.9619> }
				triangle { <12.9221, 46.2562, 13.9619>, <11.2021, 46.066, 14.2858>, <8.6735, 46.3402, 15.2266> }
				triangle { <8.6735, 46.3402, 15.2266>, <11.1285, 46.7001, 14.1232>, <12.8507, 46.6172, 13.924> }
				triangle { <11.1285, 46.7001, 14.1232>, <12.6349, 46.9055, 13.4214>, <12.8507, 46.6172, 13.924> }
				triangle { <12.6349, 46.9055, 13.4214>, <13.2766, 46.5913, 12.4808>, <12.8507, 46.6172, 13.924> }
				triangle { <12.9221, 46.2562, 13.9619>, <13.366, 45.8823, 12.6933>, <12.8367, 45.8569, 13.4906> }
				triangle { <12.8367, 45.8569, 13.4906>, <11.2021, 46.066, 14.2858>, <12.9221, 46.2562, 13.9619> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <8.4797, 46.2729, 15.2766>, <8.5255, 46.3265, 15.2611>, 0.0229 }
				cylinder { <8.5255, 46.3265, 15.2611>, <8.5725, 46.3788, 15.2455>, 0.0229 }
				cylinder { <8.5725, 46.3788, 15.2455>, <8.6209, 46.4299, 15.2296>, 0.0229 }
				texture{chif1}}
			mesh { // leaf
				triangle { <8.6209, 46.4299, 15.2296>, <11.4336, 49.5424, 13.955>, <11.7254, 49.3163, 13.9303> }
				triangle { <11.4336, 49.5424, 13.955>, <11.9218, 49.8033, 12.1943>, <11.7254, 49.3163, 13.9303> }
				triangle { <11.4336, 49.5424, 13.955>, <11.6, 49.9795, 12.5246>, <11.9218, 49.8033, 12.1943> }
				triangle { <11.9218, 49.8033, 12.1943>, <12.1512, 49.4853, 12.6127>, <11.7254, 49.3163, 13.9303> }
				triangle { <11.7254, 49.3163, 13.9303>, <10.5913, 48.00411, 14.2328>, <8.6209, 46.4299, 15.2296> }
				triangle { <8.6209, 46.4299, 15.2296>, <10.1064, 48.4469, 14.1811>, <11.4336, 49.5424, 13.955> }
				triangle { <10.1064, 48.4469, 14.1811>, <11.02496, 49.6761, 13.5108>, <11.4336, 49.5424, 13.955> }
				triangle { <11.02496, 49.6761, 13.5108>, <11.6, 49.9795, 12.5246>, <11.4336, 49.5424, 13.955> }
				triangle { <11.7254, 49.3163, 13.9303>, <12.1512, 49.4853, 12.6127>, <11.8635, 49.021, 13.3988> }
				triangle { <11.8635, 49.021, 13.3988>, <10.5913, 48.00411, 14.2328>, <11.7254, 49.3163, 13.9303> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <5.5318, 42.3448, 15.4947>, <6.2609, 43.3649, 16.7625>, 0.2642 }
		cylinder { <6.2609, 43.3649, 16.7625>, <6.767, 44.346, 18.1629>, 0.2642 }
		cylinder { <6.767, 44.346, 18.1629>, <7.0391, 45.2669, 19.6654>, 0.2642 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <7.0391, 45.2669, 19.6654>, <7.01632, 45.3228, 19.793>, 0.0448 }
			cylinder { <7.01632, 45.3228, 19.793>, <6.9518, 45.3551, 19.9143>, 0.0448 }
			cylinder { <6.9518, 45.3551, 19.9143>, <6.8533, 45.3601, 20.01519>, 0.0448 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <6.8533, 45.3601, 20.01519>, <6.8117, 45.3601, 20.05735>, 0.0448 }
				cylinder { <6.8117, 45.3601, 20.05735>, <6.7698, 45.3582, 20.09924>, 0.0448 }
				cylinder { <6.7698, 45.3582, 20.09924>, <6.7277, 45.3542, 20.1408>, 0.0448 }
				texture{chif1}}
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <7.0391, 45.2669, 19.6654>, <7.1259, 45.4592, 19.9968>, 0.2183 }
			cylinder { <7.1259, 45.4592, 19.9968>, <7.2392, 45.6399, 20.3267>, 0.2183 }
			cylinder { <7.2392, 45.6399, 20.3267>, <7.3783, 45.8079, 20.6535>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <7.3783, 45.8079, 20.6535>, <7.5425, 45.9625, 20.9752>, 0.2183 }
			cylinder { <7.5425, 45.9625, 20.9752>, <7.7309, 46.1027, 21.2901>, 0.2183 }
			cylinder { <7.7309, 46.1027, 21.2901>, <7.9424, 46.2277, 21.5967>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <7.9424, 46.2277, 21.5967>, <8.1427, 46.3791, 21.8988>, 0.2183 }
			cylinder { <8.1427, 46.3791, 21.8988>, <8.3308, 46.556, 22.1949>, 0.2183 }
			cylinder { <8.3308, 46.556, 22.1949>, <8.5055, 46.7574, 22.4835>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <8.5055, 46.7574, 22.4835>, <8.7313, 47.117, 22.8921>, 0.2183 }
				cylinder { <8.7313, 47.117, 22.8921>, <8.9173, 47.5288, 23.2703>, 0.2183 }
				cylinder { <8.9173, 47.5288, 23.2703>, <9.06084, 47.9866, 23.6125>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <9.06084, 47.9866, 23.6125>, <9.3831, 49.6922, 25.04167>, <9.5863, 49.5019, 25.1663> }
					triangle { <9.06084, 47.9866, 23.6125>, <9.1749, 49.0237, 24.2792>, <9.3831, 49.6922, 25.04167> }
					triangle { <9.5863, 49.5019, 25.1663>, <9.5829, 48.8955, 24.4138>, <9.06084, 47.9866, 23.6125> }
					triangle { <9.1749, 49.0237, 24.2792>, <9.09476, 49.6609, 25.2044>, <9.3831, 49.6922, 25.04167> }
					triangle { <9.09476, 49.6609, 25.2044>, <8.9679, 49.5196, 25.7149>, <9.3831, 49.6922, 25.04167> }
					triangle { <9.5863, 49.5019, 25.1663>, <9.7186, 49.3828, 25.4938>, <9.897, 49.46, 25.1368> }
					triangle { <9.897, 49.46, 25.1368>, <9.5829, 48.8955, 24.4138>, <9.5863, 49.5019, 25.1663> }
					triangle { <8.9679, 49.5196, 25.7149>, <9.08078, 49.5627, 25.6994>, <9.4485, 49.5713, 25.3996> }
					triangle { <9.08078, 49.5627, 25.6994>, <9.09269, 49.1265, 26.0097>, <9.6263, 49.3666, 25.7331> }
					triangle { <9.4485, 49.5713, 25.3996>, <9.6263, 49.3666, 25.7331>, <9.7186, 49.3828, 25.4938> }
					triangle { <9.4485, 49.5713, 25.3996>, <9.08078, 49.5627, 25.6994>, <9.6263, 49.3666, 25.7331> }
					triangle { <9.3831, 49.6922, 25.04167>, <8.9679, 49.5196, 25.7149>, <9.4485, 49.5713, 25.3996> }
					triangle { <9.5863, 49.5019, 25.1663>, <9.4485, 49.5713, 25.3996>, <9.7186, 49.3828, 25.4938> }
					triangle { <9.3831, 49.6922, 25.04167>, <9.4485, 49.5713, 25.3996>, <9.5863, 49.5019, 25.1663> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <9.06084, 47.9866, 23.6125>, <9.6489, 49.5597, 25.1074>, <9.9052, 49.5694, 24.9422> }
					triangle { <9.06084, 47.9866, 23.6125>, <9.2206, 48.8715, 24.4636>, <9.6489, 49.5597, 25.1074> }
					triangle { <9.9052, 49.5694, 24.9422>, <9.5315, 49.06671, 24.2063>, <9.06084, 47.9866, 23.6125> }
					triangle { <9.2206, 48.8715, 24.4636>, <9.6958, 49.3533, 25.3639>, <9.6489, 49.5597, 25.1074> }
					triangle { <9.6958, 49.3533, 25.3639>, <10.1366, 49.2041, 25.6471>, <9.6489, 49.5597, 25.1074> }
					triangle { <9.9052, 49.5694, 24.9422>, <10.2756, 49.5985, 24.9716>, <10.00838, 49.7483, 24.7045> }
					triangle { <10.00838, 49.7483, 24.7045>, <9.5315, 49.06671, 24.2063>, <9.9052, 49.5694, 24.9422> }
					triangle { <10.1366, 49.2041, 25.6471>, <10.1455, 49.3111, 25.5896>, <10.0219, 49.5444, 25.1952> }
					triangle { <10.1455, 49.3111, 25.5896>, <10.5925, 49.0261, 25.5152>, <10.4496, 49.5426, 25.1524> }
					triangle { <10.0219, 49.5444, 25.1952>, <10.4496, 49.5426, 25.1524>, <10.2756, 49.5985, 24.9716> }
					triangle { <10.0219, 49.5444, 25.1952>, <10.1455, 49.3111, 25.5896>, <10.4496, 49.5426, 25.1524> }
					triangle { <9.6489, 49.5597, 25.1074>, <10.1366, 49.2041, 25.6471>, <10.0219, 49.5444, 25.1952> }
					triangle { <9.9052, 49.5694, 24.9422>, <10.0219, 49.5444, 25.1952>, <10.2756, 49.5985, 24.9716> }
					triangle { <9.6489, 49.5597, 25.1074>, <10.0219, 49.5444, 25.1952>, <9.9052, 49.5694, 24.9422> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <9.06084, 47.9866, 23.6125>, <9.8539, 49.6495, 24.9013>, <9.8027, 49.8182, 24.6523> }
					triangle { <9.06084, 47.9866, 23.6125>, <9.4548, 48.8063, 24.4526>, <9.8539, 49.6495, 24.9013> }
					triangle { <9.8027, 49.8182, 24.6523>, <9.268, 49.14, 24.2187>, <9.06084, 47.9866, 23.6125> }
					triangle { <9.4548, 48.8063, 24.4526>, <10.1716, 49.5513, 24.8995>, <9.8539, 49.6495, 24.9013> }
					triangle { <10.1716, 49.5513, 24.8995>, <10.6271, 49.7652, 24.6908>, <9.8539, 49.6495, 24.9013> }
					triangle { <9.8027, 49.8182, 24.6523>, <9.9463, 50.0941, 24.4468>, <9.5655, 50.00005, 24.5534> }
					triangle { <9.5655, 50.00005, 24.5534>, <9.268, 49.14, 24.2187>, <9.8027, 49.8182, 24.6523> }
					triangle { <10.6271, 49.7652, 24.6908>, <10.5372, 49.8446, 24.7116>, <10.06586, 49.8993, 24.7019> }
					triangle { <10.5372, 49.8446, 24.7116>, <10.7536, 49.9358, 24.2305>, <10.1825, 50.186, 24.4036> }
					triangle { <10.06586, 49.8993, 24.7019>, <10.1825, 50.186, 24.4036>, <9.9463, 50.0941, 24.4468> }
					triangle { <10.06586, 49.8993, 24.7019>, <10.5372, 49.8446, 24.7116>, <10.1825, 50.186, 24.4036> }
					triangle { <9.8539, 49.6495, 24.9013>, <10.6271, 49.7652, 24.6908>, <10.06586, 49.8993, 24.7019> }
					triangle { <9.8027, 49.8182, 24.6523>, <10.06586, 49.8993, 24.7019>, <9.9463, 50.0941, 24.4468> }
					triangle { <9.8539, 49.6495, 24.9013>, <10.06586, 49.8993, 24.7019>, <9.8027, 49.8182, 24.6523> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <9.06084, 47.9866, 23.6125>, <9.7166, 49.8384, 24.7062>, <9.4196, 49.9068, 24.6945> }
					triangle { <9.06084, 47.9866, 23.6125>, <9.5561, 48.9176, 24.2613>, <9.7166, 49.8384, 24.7062> }
					triangle { <9.4196, 49.9068, 24.6945>, <9.154, 49.01488, 24.4339>, <9.06084, 47.9866, 23.6125> }
					triangle { <9.5561, 48.9176, 24.2613>, <9.8691, 49.9832, 24.4485>, <9.7166, 49.8384, 24.7062> }
					triangle { <9.8691, 49.9832, 24.4485>, <9.7662, 50.4327, 24.1586>, <9.7166, 49.8384, 24.7062> }
					triangle { <9.4196, 49.9068, 24.6945>, <9.1826, 50.1892, 24.6397>, <9.1763, 49.8697, 24.8909> }
					triangle { <9.1763, 49.8697, 24.8909>, <9.154, 49.01488, 24.4339>, <9.4196, 49.9068, 24.6945> }
					triangle { <9.7662, 50.4327, 24.1586>, <9.7182, 50.4309, 24.2706>, <9.52, 50.1489, 24.5968> }
					triangle { <9.7182, 50.4309, 24.2706>, <9.3549, 50.607, 23.919>, <9.1915, 50.4136, 24.5146> }
					triangle { <9.52, 50.1489, 24.5968>, <9.1915, 50.4136, 24.5146>, <9.1826, 50.1892, 24.6397> }
					triangle { <9.52, 50.1489, 24.5968>, <9.7182, 50.4309, 24.2706>, <9.1915, 50.4136, 24.5146> }
					triangle { <9.7166, 49.8384, 24.7062>, <9.7662, 50.4327, 24.1586>, <9.52, 50.1489, 24.5968> }
					triangle { <9.4196, 49.9068, 24.6945>, <9.52, 50.1489, 24.5968>, <9.1826, 50.1892, 24.6397> }
					triangle { <9.7166, 49.8384, 24.7062>, <9.52, 50.1489, 24.5968>, <9.4196, 49.9068, 24.6945> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <9.06084, 47.9866, 23.6125>, <9.4212, 49.8652, 24.7942>, <9.2838, 49.7084, 25.01696> }
					triangle { <9.06084, 47.9866, 23.6125>, <9.3805, 49.05397, 24.1525>, <9.4212, 49.8652, 24.7942> }
					triangle { <9.2838, 49.7084, 25.01696>, <9.3516, 48.8614, 24.5563>, <9.06084, 47.9866, 23.6125> }
					triangle { <9.3805, 49.05397, 24.1525>, <9.1935, 50.05201, 24.6398>, <9.4212, 49.8652, 24.7942> }
					triangle { <9.1935, 50.05201, 24.6398>, <8.7252, 50.2787, 24.8012>, <9.4212, 49.8652, 24.7942> }
					triangle { <9.2838, 49.7084, 25.01696>, <9.03979, 49.743, 25.2965>, <9.3843, 49.531, 25.2569> }
					triangle { <9.3843, 49.531, 25.2569>, <9.3516, 48.8614, 24.5563>, <9.2838, 49.7084, 25.01696> }
					triangle { <8.7252, 50.2787, 24.8012>, <8.8045, 50.2541, 24.8903>, <9.1328, 49.9431, 25.03454> }
					triangle { <8.8045, 50.2541, 24.8903>, <8.3129, 50.09938, 25.03518>, <8.8426, 49.8996, 25.3486> }
					triangle { <9.1328, 49.9431, 25.03454>, <8.8426, 49.8996, 25.3486>, <9.03979, 49.743, 25.2965> }
					triangle { <9.1328, 49.9431, 25.03454>, <8.8045, 50.2541, 24.8903>, <8.8426, 49.8996, 25.3486> }
					triangle { <9.4212, 49.8652, 24.7942>, <8.7252, 50.2787, 24.8012>, <9.1328, 49.9431, 25.03454> }
					triangle { <9.2838, 49.7084, 25.01696>, <9.1328, 49.9431, 25.03454>, <9.03979, 49.743, 25.2965> }
					triangle { <9.4212, 49.8652, 24.7942>, <9.1328, 49.9431, 25.03454>, <9.2838, 49.7084, 25.01696> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <8.5055, 46.7574, 22.4835>, <8.6753, 46.9361, 22.7893>, 0.2183 }
			cylinder { <8.6753, 46.9361, 22.7893>, <8.8391, 47.09139, 23.1109>, 0.2183 }
			cylinder { <8.8391, 47.09139, 23.1109>, <8.9962, 47.2222, 23.4464>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <8.9962, 47.2222, 23.4464>, <9.212, 47.3551, 23.9784>, 0.2183 }
				cylinder { <9.212, 47.3551, 23.9784>, <9.4048, 47.4227, 24.5311>, 0.2183 }
				cylinder { <9.4048, 47.4227, 24.5311>, <9.5717, 47.424, 25.09634>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <9.5717, 47.424, 25.09634>, <10.4092, 47.2869, 27.1697>, <10.4839, 47.5773, 27.12> }
					triangle { <9.5717, 47.424, 25.09634>, <9.9284, 47.2202, 26.2595>, <10.4092, 47.2869, 27.1697> }
					triangle { <10.4839, 47.5773, 27.12>, <9.9241, 47.6594, 26.3407>, <9.5717, 47.424, 25.09634> }
					triangle { <9.9284, 47.2202, 26.2595>, <10.6693, 47.0963, 27.0934>, <10.4092, 47.2869, 27.1697> }
					triangle { <10.6693, 47.0963, 27.0934>, <11.2055, 47.1802, 27.09677>, <10.4092, 47.2869, 27.1697> }
					triangle { <10.4839, 47.5773, 27.12>, <10.7543, 47.826, 27.1745>, <10.3504, 47.8535, 27.1857> }
					triangle { <10.3504, 47.8535, 27.1857>, <9.9241, 47.6594, 26.3407>, <10.4839, 47.5773, 27.12> }
					triangle { <11.2055, 47.1802, 27.09677>, <11.1412, 47.253, 27.1695>, <10.7322, 47.4871, 27.2088> }
					triangle { <11.1412, 47.253, 27.1695>, <11.5029, 47.5381, 26.9002>, <11.00812, 47.8148, 27.2075> }
					triangle { <10.7322, 47.4871, 27.2088>, <11.00812, 47.8148, 27.2075>, <10.7543, 47.826, 27.1745> }
					triangle { <10.7322, 47.4871, 27.2088>, <11.1412, 47.253, 27.1695>, <11.00812, 47.8148, 27.2075> }
					triangle { <10.4092, 47.2869, 27.1697>, <11.2055, 47.1802, 27.09677>, <10.7322, 47.4871, 27.2088> }
					triangle { <10.4839, 47.5773, 27.12>, <10.7322, 47.4871, 27.2088>, <10.7543, 47.826, 27.1745> }
					triangle { <10.4092, 47.2869, 27.1697>, <10.7322, 47.4871, 27.2088>, <10.4839, 47.5773, 27.12> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <9.5717, 47.424, 25.09634>, <10.3962, 47.5898, 27.1728>, <10.15, 47.7622, 27.2181> }
					triangle { <9.5717, 47.424, 25.09634>, <10.1081, 47.3741, 26.2061>, <10.3962, 47.5898, 27.1728> }
					triangle { <10.15, 47.7622, 27.2181>, <9.722, 47.4862, 26.4008>, <9.5717, 47.424, 25.09634> }
					triangle { <10.1081, 47.3741, 26.2061>, <10.6512, 47.7873, 27.09711>, <10.3962, 47.5898, 27.1728> }
					triangle { <10.6512, 47.7873, 27.09711>, <10.7731, 48.3013, 27.2217>, <10.3962, 47.5898, 27.1728> }
					triangle { <10.15, 47.7622, 27.2181>, <10.03361, 48.07206, 27.3867>, <9.8618, 47.7096, 27.3303> }
					triangle { <9.8618, 47.7096, 27.3303>, <9.722, 47.4862, 26.4008>, <10.15, 47.7622, 27.2181> }
					triangle { <10.7731, 48.3013, 27.2217>, <10.6969, 48.2461, 27.2983>, <10.3404, 47.9364, 27.3234> }
					triangle { <10.6969, 48.2461, 27.2983>, <10.5199, 48.737, 27.1875>, <10.1436, 48.2909, 27.4616> }
					triangle { <10.3404, 47.9364, 27.3234>, <10.1436, 48.2909, 27.4616>, <10.03361, 48.07206, 27.3867> }
					triangle { <10.3404, 47.9364, 27.3234>, <10.6969, 48.2461, 27.2983>, <10.1436, 48.2909, 27.4616> }
					triangle { <10.3962, 47.5898, 27.1728>, <10.7731, 48.3013, 27.2217>, <10.3404, 47.9364, 27.3234> }
					triangle { <10.15, 47.7622, 27.2181>, <10.3404, 47.9364, 27.3234>, <10.03361, 48.07206, 27.3867> }
					triangle { <10.3962, 47.5898, 27.1728>, <10.3404, 47.9364, 27.3234>, <10.15, 47.7622, 27.2181> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <9.5717, 47.424, 25.09634>, <10.1163, 47.6721, 27.2553>, <9.8771, 47.4897, 27.2993> }
					triangle { <9.5717, 47.424, 25.09634>, <10.02415, 47.6004, 26.2304>, <10.1163, 47.6721, 27.2553> }
					triangle { <9.8771, 47.4897, 27.2993>, <9.8164, 47.2317, 26.3735>, <9.5717, 47.424, 25.09634> }
					triangle { <10.02415, 47.6004, 26.2304>, <10.01624, 47.9866, 27.2841>, <10.1163, 47.6721, 27.2553> }
					triangle { <10.01624, 47.9866, 27.2841>, <9.6168, 48.2256, 27.5633>, <10.1163, 47.6721, 27.2553> }
					triangle { <9.8771, 47.4897, 27.2993>, <9.5839, 47.4358, 27.5209>, <9.8399, 47.1806, 27.338> }
					triangle { <9.8399, 47.1806, 27.338>, <9.8164, 47.2317, 26.3735>, <9.8771, 47.4897, 27.2993> }
					triangle { <9.6168, 48.2256, 27.5633>, <9.6534, 48.1184, 27.6067>, <9.8085, 47.6897, 27.481> }
					triangle { <9.6534, 48.1184, 27.6067>, <9.1204, 48.1408, 27.6021>, <9.4394, 47.5846, 27.6711> }
					triangle { <9.8085, 47.6897, 27.481>, <9.4394, 47.5846, 27.6711>, <9.5839, 47.4358, 27.5209> }
					triangle { <9.8085, 47.6897, 27.481>, <9.6534, 48.1184, 27.6067>, <9.4394, 47.5846, 27.6711> }
					triangle { <10.1163, 47.6721, 27.2553>, <9.6168, 48.2256, 27.5633>, <9.8085, 47.6897, 27.481> }
					triangle { <9.8771, 47.4897, 27.2993>, <9.8085, 47.6897, 27.481>, <9.5839, 47.4358, 27.5209> }
					triangle { <10.1163, 47.6721, 27.2553>, <9.8085, 47.6897, 27.481>, <9.8771, 47.4897, 27.2993> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <9.5717, 47.424, 25.09634>, <9.9537, 47.4208, 27.3038>, <10.03982, 47.1339, 27.2521> }
					triangle { <9.5717, 47.424, 25.09634>, <9.7918, 47.5883, 26.299>, <9.9537, 47.4208, 27.3038> }
					triangle { <10.03982, 47.1339, 27.2521>, <10.07781, 47.2452, 26.2963>, <9.5717, 47.424, 25.09634> }
					triangle { <9.7918, 47.5883, 26.299>, <9.6359, 47.4206, 27.3977>, <9.9537, 47.4208, 27.3038> }
					triangle { <9.6359, 47.4206, 27.3977>, <9.3237, 47.05705, 27.6526>, <9.9537, 47.4208, 27.3038> }
					triangle { <10.03982, 47.1339, 27.2521>, <10.02262, 46.7907, 27.3929>, <10.3147, 46.9927, 27.1983> }
					triangle { <10.3147, 46.9927, 27.1983>, <10.07781, 47.2452, 26.2963>, <10.03982, 47.1339, 27.2521> }
					triangle { <9.3237, 47.05705, 27.6526>, <9.4431, 47.04512, 27.6713>, <9.8667, 47.08565, 27.4652> }
					triangle { <9.4431, 47.04512, 27.6713>, <9.2253, 46.5677, 27.5749>, <9.8621, 46.6655, 27.5485> }
					triangle { <9.8667, 47.08565, 27.4652>, <9.8621, 46.6655, 27.5485>, <10.02262, 46.7907, 27.3929> }
					triangle { <9.8667, 47.08565, 27.4652>, <9.4431, 47.04512, 27.6713>, <9.8621, 46.6655, 27.5485> }
					triangle { <9.9537, 47.4208, 27.3038>, <9.3237, 47.05705, 27.6526>, <9.8667, 47.08565, 27.4652> }
					triangle { <10.03982, 47.1339, 27.2521>, <9.8667, 47.08565, 27.4652>, <10.02262, 46.7907, 27.3929> }
					triangle { <9.9537, 47.4208, 27.3038>, <9.8667, 47.08565, 27.4652>, <10.03982, 47.1339, 27.2521> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <9.5717, 47.424, 25.09634>, <10.1375, 47.1792, 27.2502>, <10.4205, 47.1888, 27.1396> }
					triangle { <9.5717, 47.424, 25.09634>, <9.7318, 47.3498, 26.3173>, <10.1375, 47.1792, 27.2502> }
					triangle { <10.4205, 47.1888, 27.1396>, <10.1453, 47.5135, 26.2758>, <9.5717, 47.424, 25.09634> }
					triangle { <9.7318, 47.3498, 26.3173>, <10.04567, 46.862, 27.278>, <10.1375, 47.1792, 27.2502> }
					triangle { <10.04567, 46.862, 27.278>, <10.3205, 46.4012, 27.3599>, <10.1375, 47.1792, 27.2502> }
					triangle { <10.4205, 47.1888, 27.1396>, <10.7568, 47.03552, 27.1756>, <10.635, 47.4148, 27.1027> }
					triangle { <10.635, 47.4148, 27.1027>, <10.1453, 47.5135, 26.2758>, <10.4205, 47.1888, 27.1396> }
					triangle { <10.3205, 46.4012, 27.3599>, <10.3765, 46.5022, 27.397>, <10.4462, 46.9585, 27.2944> }
					triangle { <10.3765, 46.5022, 27.397>, <10.72, 46.1897, 27.1345>, <10.8463, 46.8099, 27.2576> }
					triangle { <10.4462, 46.9585, 27.2944>, <10.8463, 46.8099, 27.2576>, <10.7568, 47.03552, 27.1756> }
					triangle { <10.4462, 46.9585, 27.2944>, <10.3765, 46.5022, 27.397>, <10.8463, 46.8099, 27.2576> }
					triangle { <10.1375, 47.1792, 27.2502>, <10.3205, 46.4012, 27.3599>, <10.4462, 46.9585, 27.2944> }
					triangle { <10.4205, 47.1888, 27.1396>, <10.4462, 46.9585, 27.2944>, <10.7568, 47.03552, 27.1756> }
					triangle { <10.1375, 47.1792, 27.2502>, <10.4462, 46.9585, 27.2944>, <10.4205, 47.1888, 27.1396> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <8.9962, 47.2222, 23.4464>, <9.1753, 47.3633, 23.7663>, 0.2183 }
			cylinder { <9.1753, 47.3633, 23.7663>, <9.3755, 47.5141, 24.06889>, 0.2183 }
			cylinder { <9.3755, 47.5141, 24.06889>, <9.5957, 47.6736, 24.3524>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5957, 47.6736, 24.3524>, <9.9718, 47.9319, 24.7253>, 0.2183 }
				cylinder { <9.9718, 47.9319, 24.7253>, <10.3882, 48.2053, 25.04019>, 0.2183 }
				cylinder { <10.3882, 48.2053, 25.04019>, <10.8386, 48.4898, 25.2921>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <10.8386, 48.4898, 25.2921>, <12.435, 49.7905, 26.1746>, <12.3049, 49.7102, 26.4374> }
					triangle { <10.8386, 48.4898, 25.2921>, <11.8013, 49.1804, 25.636>, <12.435, 49.7905, 26.1746> }
					triangle { <12.3049, 49.7102, 26.4374>, <11.79, 48.998, 26.04365>, <10.8386, 48.4898, 25.2921> }
					triangle { <11.8013, 49.1804, 25.636>, <12.3066, 50.08011, 26.07729>, <12.435, 49.7905, 26.1746> }
					triangle { <12.3066, 50.08011, 26.07729>, <12.09376, 50.5013, 26.3453>, <12.435, 49.7905, 26.1746> }
					triangle { <12.3049, 49.7102, 26.4374>, <12.2048, 49.8423, 26.7697>, <12.3598, 49.4874, 26.6513> }
					triangle { <12.3598, 49.4874, 26.6513>, <11.79, 48.998, 26.04365>, <12.3049, 49.7102, 26.4374> }
					triangle { <12.09376, 50.5013, 26.3453>, <12.1693, 50.4317, 26.4099>, <12.3109, 49.9857, 26.4787> }
					triangle { <12.1693, 50.4317, 26.4099>, <11.7344, 50.5437, 26.6977>, <12.1426, 50.07272, 26.8629> }
					triangle { <12.3109, 49.9857, 26.4787>, <12.1426, 50.07272, 26.8629>, <12.2048, 49.8423, 26.7697> }
					triangle { <12.3109, 49.9857, 26.4787>, <12.1693, 50.4317, 26.4099>, <12.1426, 50.07272, 26.8629> }
					triangle { <12.435, 49.7905, 26.1746>, <12.09376, 50.5013, 26.3453>, <12.3109, 49.9857, 26.4787> }
					triangle { <12.3049, 49.7102, 26.4374>, <12.3109, 49.9857, 26.4787>, <12.2048, 49.8423, 26.7697> }
					triangle { <12.435, 49.7905, 26.1746>, <12.3109, 49.9857, 26.4787>, <12.3049, 49.7102, 26.4374> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <10.8386, 48.4898, 25.2921>, <12.383, 49.6428, 26.4343>, <12.4817, 49.3656, 26.5104> }
					triangle { <10.8386, 48.4898, 25.2921>, <11.6557, 49.2507, 25.8168>, <12.383, 49.6428, 26.4343> }
					triangle { <12.4817, 49.3656, 26.5104>, <11.9538, 48.9188, 25.8402>, <10.8386, 48.4898, 25.2921> }
					triangle { <11.6557, 49.2507, 25.8168>, <12.1805, 49.7522, 26.6727>, <12.383, 49.6428, 26.4343> }
					triangle { <12.1805, 49.7522, 26.6727>, <12.147, 49.6548, 27.2056>, <12.383, 49.6428, 26.4343> }
					triangle { <12.4817, 49.3656, 26.5104>, <12.6168, 49.1681, 26.7944>, <12.701, 49.1713, 26.3982> }
					triangle { <12.701, 49.1713, 26.3982>, <11.9538, 48.9188, 25.8402>, <12.4817, 49.3656, 26.5104> }
					triangle { <12.147, 49.6548, 27.2056>, <12.2557, 49.634, 27.1559>, <12.4721, 49.4759, 26.7662> }
					triangle { <12.2557, 49.634, 27.1559>, <12.1243, 49.2322, 27.4813>, <12.6008, 49.1818, 27.04974> }
					triangle { <12.4721, 49.4759, 26.7662>, <12.6008, 49.1818, 27.04974>, <12.6168, 49.1681, 26.7944> }
					triangle { <12.4721, 49.4759, 26.7662>, <12.2557, 49.634, 27.1559>, <12.6008, 49.1818, 27.04974> }
					triangle { <12.383, 49.6428, 26.4343>, <12.147, 49.6548, 27.2056>, <12.4721, 49.4759, 26.7662> }
					triangle { <12.4817, 49.3656, 26.5104>, <12.4721, 49.4759, 26.7662>, <12.6168, 49.1681, 26.7944> }
					triangle { <12.383, 49.6428, 26.4343>, <12.4721, 49.4759, 26.7662>, <12.4817, 49.3656, 26.5104> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <10.8386, 48.4898, 25.2921>, <12.5457, 49.387, 26.4324>, <12.7105, 49.2763, 26.2022> }
					triangle { <10.8386, 48.4898, 25.2921>, <11.6644, 49.0825, 25.9913>, <12.5457, 49.387, 26.4324> }
					triangle { <12.7105, 49.2763, 26.2022>, <11.9441, 49.1081, 25.6439>, <10.8386, 48.4898, 25.2921> }
					triangle { <11.6644, 49.0825, 25.9913>, <12.547, 49.1661, 26.6793>, <12.5457, 49.387, 26.4324> }
					triangle { <12.547, 49.1661, 26.6793>, <12.9018, 48.7866, 26.8367>, <12.5457, 49.387, 26.4324> }
					triangle { <12.7105, 49.2763, 26.2022>, <13.0312, 49.1059, 26.124>, <12.8204, 49.3943, 25.9331> }
					triangle { <12.8204, 49.3943, 25.9331>, <11.9441, 49.1081, 25.6439>, <12.7105, 49.2763, 26.2022> }
					triangle { <12.9018, 48.7866, 26.8367>, <12.9487, 48.8774, 26.7714>, <12.8614, 49.1728, 26.4125> }
					triangle { <12.9487, 48.8774, 26.7714>, <13.1383, 48.4105, 26.5966>, <13.1919, 48.9527, 26.2517> }
					triangle { <12.8614, 49.1728, 26.4125>, <13.1919, 48.9527, 26.2517>, <13.0312, 49.1059, 26.124> }
					triangle { <12.8614, 49.1728, 26.4125>, <12.9487, 48.8774, 26.7714>, <13.1919, 48.9527, 26.2517> }
					triangle { <12.5457, 49.387, 26.4324>, <12.9018, 48.7866, 26.8367>, <12.8614, 49.1728, 26.4125> }
					triangle { <12.7105, 49.2763, 26.2022>, <12.8614, 49.1728, 26.4125>, <13.0312, 49.1059, 26.124> }
					triangle { <12.5457, 49.387, 26.4324>, <12.8614, 49.1728, 26.4125>, <12.7105, 49.2763, 26.2022> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <10.8386, 48.4898, 25.2921>, <12.6997, 49.3742, 26.1715>, <12.6773, 49.5648, 25.9358> }
					triangle { <10.8386, 48.4898, 25.2921>, <11.8154, 48.9066, 25.9199>, <12.6997, 49.3742, 26.1715> }
					triangle { <12.6773, 49.5648, 25.9358>, <11.7742, 49.306, 25.7242>, <10.8386, 48.4898, 25.2921> }
					triangle { <11.8154, 48.9066, 25.9199>, <12.903, 49.1262, 26.0881>, <12.6997, 49.3742, 26.1715> }
					triangle { <12.903, 49.1262, 26.0881>, <13.322, 49.08844, 25.745>, <12.6997, 49.3742, 26.1715> }
					triangle { <12.6773, 49.5648, 25.9358>, <12.8791, 49.7412, 25.6787>, <12.5541, 49.8503, 25.8944> }
					triangle { <12.5541, 49.8503, 25.8944>, <11.7742, 49.306, 25.7242>, <12.6773, 49.5648, 25.9358> }
					triangle { <13.322, 49.08844, 25.745>, <13.297, 49.2005, 25.7841>, <12.9445, 49.4925, 25.9031> }
					triangle { <13.297, 49.2005, 25.7841>, <13.3845, 49.2065, 25.2579>, <13.1045, 49.7, 25.5643> }
					triangle { <12.9445, 49.4925, 25.9031>, <13.1045, 49.7, 25.5643>, <12.8791, 49.7412, 25.6787> }
					triangle { <12.9445, 49.4925, 25.9031>, <13.297, 49.2005, 25.7841>, <13.1045, 49.7, 25.5643> }
					triangle { <12.6997, 49.3742, 26.1715>, <13.322, 49.08844, 25.745>, <12.9445, 49.4925, 25.9031> }
					triangle { <12.6773, 49.5648, 25.9358>, <12.9445, 49.4925, 25.9031>, <12.8791, 49.7412, 25.6787> }
					triangle { <12.6997, 49.3742, 26.1715>, <12.9445, 49.4925, 25.9031>, <12.6773, 49.5648, 25.9358> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <10.8386, 48.4898, 25.2921>, <12.6303, 49.6273, 26.00991>, <12.4228, 49.837, 26.08338> }
					triangle { <10.8386, 48.4898, 25.2921>, <11.9013, 48.968, 25.6971>, <12.6303, 49.6273, 26.00991> }
					triangle { <12.4228, 49.837, 26.08338>, <11.6776, 49.2369, 25.9749>, <10.8386, 48.4898, 25.2921> }
					triangle { <11.9013, 48.968, 25.6971>, <12.7522, 49.6996, 25.7103>, <12.6303, 49.6273, 26.00991> }
					triangle { <12.7522, 49.6996, 25.7103>, <12.815, 50.1641, 25.4367>, <12.6303, 49.6273, 26.00991> }
					triangle { <12.4228, 49.837, 26.08338>, <12.3606, 50.2032, 26.08383>, <12.2651, 49.9087, 26.3449> }
					triangle { <12.2651, 49.9087, 26.3449>, <11.6776, 49.2369, 25.9749>, <12.4228, 49.837, 26.08338> }
					triangle { <12.815, 50.1641, 25.4367>, <12.808, 50.1756, 25.5573>, <12.5991, 50.00252, 25.9446> }
					triangle { <12.808, 50.1756, 25.5573>, <12.5037, 50.5448, 25.3214>, <12.4462, 50.4026, 25.9477> }
					triangle { <12.5991, 50.00252, 25.9446>, <12.4462, 50.4026, 25.9477>, <12.3606, 50.2032, 26.08383> }
					triangle { <12.5991, 50.00252, 25.9446>, <12.808, 50.1756, 25.5573>, <12.4462, 50.4026, 25.9477> }
					triangle { <12.6303, 49.6273, 26.00991>, <12.815, 50.1641, 25.4367>, <12.5991, 50.00252, 25.9446> }
					triangle { <12.4228, 49.837, 26.08338>, <12.5991, 50.00252, 25.9446>, <12.3606, 50.2032, 26.08383> }
					triangle { <12.6303, 49.6273, 26.00991>, <12.5991, 50.00252, 25.9446>, <12.4228, 49.837, 26.08338> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <9.5957, 47.6736, 24.3524>, <9.7914, 47.8433, 24.6477>, 0.2183 }
			cylinder { <9.7914, 47.8433, 24.6477>, <9.9618, 48.0224, 24.9531>, 0.2183 }
			cylinder { <9.9618, 48.0224, 24.9531>, <10.1057, 48.2097, 25.267>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <10.1057, 48.2097, 25.267>, <10.2532, 48.5082, 25.7533>, 0.2183 }
				cylinder { <10.2532, 48.5082, 25.7533>, <10.3301, 48.8195, 26.2476>, 0.2183 }
				cylinder { <10.3301, 48.8195, 26.2476>, <10.3351, 49.1391, 26.7427>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <10.3351, 49.1391, 26.7427>, <10.2859, 50.1338, 28.7425>, <10.5876, 50.1252, 28.7143> }
					triangle { <10.3351, 49.1391, 26.7427>, <10.1535, 49.7341, 27.8041>, <10.2859, 50.1338, 28.7425> }
					triangle { <10.5876, 50.1252, 28.7143>, <10.5622, 49.9094, 27.7789>, <10.3351, 49.1391, 26.7427> }
					triangle { <10.1535, 49.7341, 27.8041>, <10.1885, 49.869, 28.9145>, <10.2859, 50.1338, 28.7425> }
					triangle { <10.1885, 49.869, 28.9145>, <10.4272, 49.5644, 29.293>, <10.2859, 50.1338, 28.7425> }
					triangle { <10.5876, 50.1252, 28.7143>, <10.8994, 50.0637, 28.9044>, <10.8045, 50.3265, 28.6128> }
					triangle { <10.8045, 50.3265, 28.6128>, <10.5622, 49.9094, 27.7789>, <10.5876, 50.1252, 28.7143> }
					triangle { <10.4272, 49.5644, 29.293>, <10.4712, 49.6765, 29.2816>, <10.5686, 50.01618, 28.9692> }
					triangle { <10.4712, 49.6765, 29.2816>, <10.8708, 49.3274, 29.3186>, <10.9614, 49.9299, 29.113> }
					triangle { <10.5686, 50.01618, 28.9692>, <10.9614, 49.9299, 29.113>, <10.8994, 50.0637, 28.9044> }
					triangle { <10.5686, 50.01618, 28.9692>, <10.4712, 49.6765, 29.2816>, <10.9614, 49.9299, 29.113> }
					triangle { <10.2859, 50.1338, 28.7425>, <10.4272, 49.5644, 29.293>, <10.5686, 50.01618, 28.9692> }
					triangle { <10.5876, 50.1252, 28.7143>, <10.5686, 50.01618, 28.9692>, <10.8994, 50.0637, 28.9044> }
					triangle { <10.2859, 50.1338, 28.7425>, <10.5686, 50.01618, 28.9692>, <10.5876, 50.1252, 28.7143> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <10.3351, 49.1391, 26.7427>, <10.569, 50.2215, 28.683>, <10.6558, 50.4501, 28.5039> }
					triangle { <10.3351, 49.1391, 26.7427>, <10.3572, 49.6236, 27.8733>, <10.569, 50.2215, 28.683> }
					triangle { <10.6558, 50.4501, 28.5039>, <10.3331, 50.0337, 27.701>, <10.3351, 49.1391, 26.7427> }
					triangle { <10.3572, 49.6236, 27.8733>, <10.8383, 50.05939, 28.785>, <10.569, 50.2215, 28.683> }
					triangle { <10.8383, 50.05939, 28.785>, <11.352, 50.2087, 28.8676>, <10.569, 50.2215, 28.683> }
					triangle { <10.6558, 50.4501, 28.5039>, <10.9014, 50.726, 28.4769>, <10.5112, 50.6967, 28.3769> }
					triangle { <10.5112, 50.6967, 28.3769>, <10.3331, 50.0337, 27.701>, <10.6558, 50.4501, 28.5039> }
					triangle { <11.352, 50.2087, 28.8676>, <11.2707, 50.2983, 28.872>, <10.8691, 50.4563, 28.682> }
					triangle { <11.2707, 50.2983, 28.872>, <11.6928, 50.4497, 28.5857>, <11.1356, 50.7703, 28.5687> }
					triangle { <10.8691, 50.4563, 28.682>, <11.1356, 50.7703, 28.5687>, <10.9014, 50.726, 28.4769> }
					triangle { <10.8691, 50.4563, 28.682>, <11.2707, 50.2983, 28.872>, <11.1356, 50.7703, 28.5687> }
					triangle { <10.569, 50.2215, 28.683>, <11.352, 50.2087, 28.8676>, <10.8691, 50.4563, 28.682> }
					triangle { <10.6558, 50.4501, 28.5039>, <10.8691, 50.4563, 28.682>, <10.9014, 50.726, 28.4769> }
					triangle { <10.569, 50.2215, 28.683>, <10.8691, 50.4563, 28.682>, <10.6558, 50.4501, 28.5039> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <10.3351, 49.1391, 26.7427>, <10.5573, 50.4754, 28.5193>, <10.3097, 50.6082, 28.4054> }
					triangle { <10.3351, 49.1391, 26.7427>, <10.5449, 49.7509, 27.7892>, <10.5573, 50.4754, 28.5193> }
					triangle { <10.3097, 50.6082, 28.4054>, <10.1219, 49.8905, 27.7956>, <10.3351, 49.1391, 26.7427> }
					triangle { <10.5449, 49.7509, 27.7892>, <10.8236, 50.6385, 28.4113>, <10.5573, 50.4754, 28.5193> }
					triangle { <10.8236, 50.6385, 28.4113>, <10.909, 51.152, 28.2632>, <10.5573, 50.4754, 28.5193> }
					triangle { <10.3097, 50.6082, 28.4054>, <10.1535, 50.9389, 28.3471>, <10.00239, 50.5808, 28.4569> }
					triangle { <10.00239, 50.5808, 28.4569>, <10.1219, 49.8905, 27.7956>, <10.3097, 50.6082, 28.4054> }
					triangle { <10.909, 51.152, 28.2632>, <10.8146, 51.1345, 28.3369>, <10.4643, 50.8364, 28.4408> }
					triangle { <10.8146, 51.1345, 28.3369>, <10.6779, 51.4634, 27.9417>, <10.2396, 51.1772, 28.3152> }
					triangle { <10.4643, 50.8364, 28.4408>, <10.2396, 51.1772, 28.3152>, <10.1535, 50.9389, 28.3471> }
					triangle { <10.4643, 50.8364, 28.4408>, <10.8146, 51.1345, 28.3369>, <10.2396, 51.1772, 28.3152> }
					triangle { <10.5573, 50.4754, 28.5193>, <10.909, 51.152, 28.2632>, <10.4643, 50.8364, 28.4408> }
					triangle { <10.3097, 50.6082, 28.4054>, <10.4643, 50.8364, 28.4408>, <10.1535, 50.9389, 28.3471> }
					triangle { <10.5573, 50.4754, 28.5193>, <10.4643, 50.8364, 28.4408>, <10.3097, 50.6082, 28.4054> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <10.3351, 49.1391, 26.7427>, <10.2667, 50.5469, 28.4761>, <10.02439, 50.3825, 28.554> }
					triangle { <10.3351, 49.1391, 26.7427>, <10.4589, 49.9412, 27.6673>, <10.2667, 50.5469, 28.4761> }
					triangle { <10.02439, 50.3825, 28.554>, <10.2186, 49.6763, 27.9328>, <10.3351, 49.1391, 26.7427> }
					triangle { <10.4589, 49.9412, 27.6673>, <10.1645, 50.8114, 28.3064>, <10.2667, 50.5469, 28.4761> }
					triangle { <10.1645, 50.8114, 28.3064>, <9.7063, 51.09955, 28.3094>, <10.2667, 50.5469, 28.4761> }
					triangle { <10.02439, 50.3825, 28.554>, <9.6823, 50.4101, 28.6932>, <9.9764, 50.1379, 28.7431> }
					triangle { <9.9764, 50.1379, 28.7431>, <10.2186, 49.6763, 27.9328>, <10.02439, 50.3825, 28.554> }
					triangle { <9.7063, 51.09955, 28.3094>, <9.7289, 51.03736, 28.4107>, <9.9099, 50.6347, 28.5766> }
					triangle { <9.7289, 51.03736, 28.4107>, <9.2193, 50.977, 28.2706>, <9.5033, 50.5922, 28.7004> }
					triangle { <9.9099, 50.6347, 28.5766>, <9.5033, 50.5922, 28.7004>, <9.6823, 50.4101, 28.6932> }
					triangle { <9.9099, 50.6347, 28.5766>, <9.7289, 51.03736, 28.4107>, <9.5033, 50.5922, 28.7004> }
					triangle { <10.2667, 50.5469, 28.4761>, <9.7063, 51.09955, 28.3094>, <9.9099, 50.6347, 28.5766> }
					triangle { <10.02439, 50.3825, 28.554>, <9.9099, 50.6347, 28.5766>, <9.6823, 50.4101, 28.6932> }
					triangle { <10.2667, 50.5469, 28.4761>, <9.9099, 50.6347, 28.5766>, <10.02439, 50.3825, 28.554> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <10.3351, 49.1391, 26.7427>, <10.09653, 50.3327, 28.6161>, <10.1987, 50.07953, 28.7478> }
					triangle { <10.3351, 49.1391, 26.7427>, <10.2134, 49.9307, 27.6766>, <10.09653, 50.3327, 28.6161> }
					triangle { <10.1987, 50.07953, 28.7478>, <10.4949, 49.6882, 27.9223>, <10.3351, 49.1391, 26.7427> }
					triangle { <10.2134, 49.9307, 27.6766>, <9.7661, 50.3287, 28.6221>, <10.09653, 50.3327, 28.6161> }
					triangle { <9.7661, 50.3287, 28.6221>, <9.404, 50.1035, 28.9554>, <10.09653, 50.3327, 28.6161> }
					triangle { <10.1987, 50.07953, 28.7478>, <10.1502, 49.861, 29.04294>, <10.4797, 49.9784, 28.8409> }
					triangle { <10.4797, 49.9784, 28.8409>, <10.4949, 49.6882, 27.9223>, <10.1987, 50.07953, 28.7478> }
					triangle { <9.404, 50.1035, 28.9554>, <9.5135, 50.1226, 29.00343>, <9.9753, 50.1201, 28.9082> }
					triangle { <9.5135, 50.1226, 29.00343>, <9.3403, 49.637, 29.1344>, <9.9562, 49.8096, 29.2009> }
					triangle { <9.9753, 50.1201, 28.9082>, <9.9562, 49.8096, 29.2009>, <10.1502, 49.861, 29.04294> }
					triangle { <9.9753, 50.1201, 28.9082>, <9.5135, 50.1226, 29.00343>, <9.9562, 49.8096, 29.2009> }
					triangle { <10.09653, 50.3327, 28.6161>, <9.404, 50.1035, 28.9554>, <9.9753, 50.1201, 28.9082> }
					triangle { <10.1987, 50.07953, 28.7478>, <9.9753, 50.1201, 28.9082>, <10.1502, 49.861, 29.04294> }
					triangle { <10.09653, 50.3327, 28.6161>, <9.9753, 50.1201, 28.9082>, <10.1987, 50.07953, 28.7478> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <7.0391, 45.2669, 19.6654>, <7.08493, 45.4919, 19.9842>, 0.2183 }
			cylinder { <7.08493, 45.4919, 19.9842>, <7.1164, 45.7377, 20.289>, 0.2183 }
			cylinder { <7.1164, 45.7377, 20.289>, <7.1333, 46.00311, 20.5782>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <7.1333, 46.00311, 20.5782>, <7.09569, 46.305, 20.8268>, 0.2183 }
			cylinder { <7.09569, 46.305, 20.8268>, <7.05229, 46.5877, 21.09614>, 0.2183 }
			cylinder { <7.05229, 46.5877, 21.09614>, <7.003379, 46.8496, 21.3848>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.003379, 46.8496, 21.3848>, <6.9171, 47.1859, 21.8609>, 0.2183 }
				cylinder { <6.9171, 47.1859, 21.8609>, <6.8192, 47.4606, 22.373>, 0.2183 }
				cylinder { <6.8192, 47.4606, 22.373>, <6.7113, 47.6696, 22.9133>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <6.7113, 47.6696, 22.9133>, <6.5464, 48.3996, 25.0184>, <6.5553, 48.6724, 24.8865> }
					triangle { <6.7113, 47.6696, 22.9133>, <6.5558, 47.9222, 24.1073>, <6.5464, 48.3996, 25.0184> }
					triangle { <6.5553, 48.6724, 24.8865>, <6.3999, 48.3266, 24.00422>, <6.7113, 47.6696, 22.9133> }
					triangle { <6.5558, 47.9222, 24.1073>, <6.8527, 48.3174, 25.1113>, <6.5464, 48.3996, 25.0184> }
					triangle { <6.8527, 48.3174, 25.1113>, <7.2868, 48.607, 25.2549>, <6.5464, 48.3996, 25.0184> }
					triangle { <6.5553, 48.6724, 24.8865>, <6.6962, 49.01286, 24.9237>, <6.3391, 48.8778, 24.792> }
					triangle { <6.3391, 48.8778, 24.792>, <6.3999, 48.3266, 24.00422>, <6.5553, 48.6724, 24.8865> }
					triangle { <7.2868, 48.607, 25.2549>, <7.1805, 48.6632, 25.2682>, <6.7519, 48.7147, 25.07831> }
					triangle { <7.1805, 48.6632, 25.2682>, <7.5328, 48.9918, 25.04274>, <6.9013, 49.1129, 25.03859> }
					triangle { <6.7519, 48.7147, 25.07831>, <6.9013, 49.1129, 25.03859>, <6.6962, 49.01286, 24.9237> }
					triangle { <6.7519, 48.7147, 25.07831>, <7.1805, 48.6632, 25.2682>, <6.9013, 49.1129, 25.03859> }
					triangle { <6.5464, 48.3996, 25.0184>, <7.2868, 48.607, 25.2549>, <6.7519, 48.7147, 25.07831> }
					triangle { <6.5553, 48.6724, 24.8865>, <6.7519, 48.7147, 25.07831>, <6.6962, 49.01286, 24.9237> }
					triangle { <6.5464, 48.3996, 25.0184>, <6.7519, 48.7147, 25.07831>, <6.5553, 48.6724, 24.8865> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.7113, 47.6696, 22.9133>, <6.4537, 48.6612, 24.8986>, <6.1778, 48.7253, 24.7906> }
					triangle { <6.7113, 47.6696, 22.9133>, <6.692, 48.1163, 24.05949>, <6.4537, 48.6612, 24.8986> }
					triangle { <6.1778, 48.7253, 24.7906>, <6.2466, 48.1083, 24.058>, <6.7113, 47.6696, 22.9133> }
					triangle { <6.692, 48.1163, 24.05949>, <6.6526, 48.9183, 24.839>, <6.4537, 48.6612, 24.8986> }
					triangle { <6.6526, 48.9183, 24.839>, <6.5656, 49.4497, 24.7849>, <6.4537, 48.6612, 24.8986> }
					triangle { <6.1778, 48.7253, 24.7906>, <5.9219, 48.9927, 24.7768>, <5.8961, 48.5914, 24.8142> }
					triangle { <5.8961, 48.5914, 24.8142>, <6.2466, 48.1083, 24.058>, <6.1778, 48.7253, 24.7906> }
					triangle { <6.5656, 49.4497, 24.7849>, <6.4812, 49.3897, 24.8476>, <6.2477, 48.9809, 24.8746> }
					triangle { <6.4812, 49.3897, 24.8476>, <6.2492, 49.7226, 24.5036>, <5.9248, 49.2477, 24.7913> }
					triangle { <6.2477, 48.9809, 24.8746>, <5.9248, 49.2477, 24.7913>, <5.9219, 48.9927, 24.7768> }
					triangle { <6.2477, 48.9809, 24.8746>, <6.4812, 49.3897, 24.8476>, <5.9248, 49.2477, 24.7913> }
					triangle { <6.4537, 48.6612, 24.8986>, <6.5656, 49.4497, 24.7849>, <6.2477, 48.9809, 24.8746> }
					triangle { <6.1778, 48.7253, 24.7906>, <6.2477, 48.9809, 24.8746>, <5.9219, 48.9927, 24.7768> }
					triangle { <6.4537, 48.6612, 24.8986>, <6.2477, 48.9809, 24.8746>, <6.1778, 48.7253, 24.7906> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.7113, 47.6696, 22.9133>, <6.1565, 48.6418, 24.8468>, <5.981, 48.3966, 24.8784> }
					triangle { <6.7113, 47.6696, 22.9133>, <6.5497, 48.2874, 23.9648>, <6.1565, 48.6418, 24.8468> }
					triangle { <5.981, 48.3966, 24.8784>, <6.4067, 47.9158, 24.1644>, <6.7113, 47.6696, 22.9133> }
					triangle { <6.5497, 48.2874, 23.9648>, <5.975, 48.8852, 24.7164>, <6.1565, 48.6418, 24.8468> }
					triangle { <5.975, 48.8852, 24.7164>, <5.4473, 49.00448, 24.7337>, <6.1565, 48.6418, 24.8468> }
					triangle { <5.981, 48.3966, 24.8784>, <5.6471, 48.2867, 24.9949>, <6.01404, 48.1197, 25.02024> }
					triangle { <6.01404, 48.1197, 25.02024>, <6.4067, 47.9158, 24.1644>, <5.981, 48.3966, 24.8784> }
					triangle { <5.4473, 49.00448, 24.7337>, <5.4878, 48.9356, 24.8247>, <5.7893, 48.59, 24.9342> }
					triangle { <5.4878, 48.9356, 24.8247>, <5.02886, 48.7405, 24.6396>, <5.4179, 48.3969, 25.01911> }
					triangle { <5.7893, 48.59, 24.9342>, <5.4179, 48.3969, 25.01911>, <5.6471, 48.2867, 24.9949> }
					triangle { <5.7893, 48.59, 24.9342>, <5.4878, 48.9356, 24.8247>, <5.4179, 48.3969, 25.01911> }
					triangle { <6.1565, 48.6418, 24.8468>, <5.4473, 49.00448, 24.7337>, <5.7893, 48.59, 24.9342> }
					triangle { <5.981, 48.3966, 24.8784>, <5.7893, 48.59, 24.9342>, <5.6471, 48.2867, 24.9949> }
					triangle { <6.1565, 48.6418, 24.8468>, <5.7893, 48.59, 24.9342>, <5.981, 48.3966, 24.8784> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.7113, 47.6696, 22.9133>, <6.06278, 48.3679, 24.9339>, <6.235, 48.1375, 25.02939> }
					triangle { <6.7113, 47.6696, 22.9133>, <6.3242, 48.2008, 23.9533>, <6.06278, 48.3679, 24.9339> }
					triangle { <6.235, 48.1375, 25.02939>, <6.6604, 48.01329, 24.1774>, <6.7113, 47.6696, 22.9133> }
					triangle { <6.3242, 48.2008, 23.9533>, <5.75, 48.2636, 24.9118>, <6.06278, 48.3679, 24.9339> }
					triangle { <5.75, 48.2636, 24.9118>, <5.467, 47.8823, 25.1716>, <6.06278, 48.3679, 24.9339> }
					triangle { <6.235, 48.1375, 25.02939>, <6.249, 47.8639, 25.2786>, <6.5309, 48.1103, 25.1271> }
					triangle { <6.5309, 48.1103, 25.1271>, <6.6604, 48.01329, 24.1774>, <6.235, 48.1375, 25.02939> }
					triangle { <5.467, 47.8823, 25.1716>, <5.5638, 47.9243, 25.231>, <6.005944, 48.07863, 25.1752> }
					triangle { <5.5638, 47.9243, 25.231>, <5.5468, 47.3936, 25.2639>, <6.07639, 47.7283, 25.4092> }
					triangle { <6.005944, 48.07863, 25.1752>, <6.07639, 47.7283, 25.4092>, <6.249, 47.8639, 25.2786> }
					triangle { <6.005944, 48.07863, 25.1752>, <5.5638, 47.9243, 25.231>, <6.07639, 47.7283, 25.4092> }
					triangle { <6.06278, 48.3679, 24.9339>, <5.467, 47.8823, 25.1716>, <6.005944, 48.07863, 25.1752> }
					triangle { <6.235, 48.1375, 25.02939>, <6.005944, 48.07863, 25.1752>, <6.249, 47.8639, 25.2786> }
					triangle { <6.06278, 48.3679, 24.9339>, <6.005944, 48.07863, 25.1752>, <6.235, 48.1375, 25.02939> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.7113, 47.6696, 22.9133>, <6.3073, 48.216, 25.04164>, <6.5953, 48.3105, 25.03448> }
					triangle { <6.7113, 47.6696, 22.9133>, <6.328, 47.9717, 24.04268>, <6.3073, 48.216, 25.04164> }
					triangle { <6.5953, 48.3105, 25.03448>, <6.6561, 48.271, 24.07692>, <6.7113, 47.6696, 22.9133> }
					triangle { <6.328, 47.9717, 24.04268>, <6.3005, 47.9074, 25.1596>, <6.3073, 48.216, 25.04164> }
					triangle { <6.3005, 47.9074, 25.1596>, <6.621, 47.6329, 25.4986>, <6.3073, 48.216, 25.04164> }
					triangle { <6.5953, 48.3105, 25.03448>, <6.9071, 48.3195, 25.234>, <6.7349, 48.5858, 24.984> }
					triangle { <6.7349, 48.5858, 24.984>, <6.6561, 48.271, 24.07692>, <6.5953, 48.3105, 25.03448> }
					triangle { <6.621, 47.6329, 25.4986>, <6.6257, 47.7534, 25.5092>, <6.6098, 48.1569, 25.2656> }
					triangle { <6.6257, 47.7534, 25.5092>, <7.1177, 47.5513, 25.5168>, <7.00701, 48.1775, 25.4214> }
					triangle { <6.6098, 48.1569, 25.2656>, <7.00701, 48.1775, 25.4214>, <6.9071, 48.3195, 25.234> }
					triangle { <6.6098, 48.1569, 25.2656>, <6.6257, 47.7534, 25.5092>, <7.00701, 48.1775, 25.4214> }
					triangle { <6.3073, 48.216, 25.04164>, <6.621, 47.6329, 25.4986>, <6.6098, 48.1569, 25.2656> }
					triangle { <6.5953, 48.3105, 25.03448>, <6.6098, 48.1569, 25.2656>, <6.9071, 48.3195, 25.234> }
					triangle { <6.3073, 48.216, 25.04164>, <6.6098, 48.1569, 25.2656>, <6.5953, 48.3105, 25.03448> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <7.1333, 46.00311, 20.5782>, <7.2042, 46.2216, 20.8969>, 0.2183 }
			cylinder { <7.2042, 46.2216, 20.8969>, <7.281, 46.4621, 21.1979>, 0.2183 }
			cylinder { <7.281, 46.4621, 21.1979>, <7.3633, 46.7234, 21.4795>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.3633, 46.7234, 21.4795>, <7.4991, 47.1625, 21.8484>, 0.2183 }
				cylinder { <7.4991, 47.1625, 21.8484>, <7.6451, 47.6419, 22.1583>, 0.2183 }
				cylinder { <7.6451, 47.6419, 22.1583>, <7.7992, 48.1547, 22.4045>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <7.7992, 48.1547, 22.4045>, <8.1396, 50.1745, 23.2964>, <8.1383, 50.02005, 23.5572> }
					triangle { <7.7992, 48.1547, 22.4045>, <8.04469, 49.3108, 22.746>, <8.1396, 50.1745, 23.2964> }
					triangle { <8.1383, 50.02005, 23.5572>, <8.2169, 49.1638, 23.1295>, <7.7992, 48.1547, 22.4045> }
					triangle { <8.04469, 49.3108, 22.746>, <7.8356, 50.292, 23.242>, <8.1396, 50.1745, 23.2964> }
					triangle { <7.8356, 50.292, 23.242>, <7.4291, 50.4348, 23.5696>, <8.1396, 50.1745, 23.2964> }
					triangle { <8.1383, 50.02005, 23.5572>, <8.02015, 50.03546, 23.9079>, <8.3597, 49.8954, 23.7399> }
					triangle { <8.3597, 49.8954, 23.7399>, <8.2169, 49.1638, 23.1295>, <8.1383, 50.02005, 23.5572> }
					triangle { <7.4291, 50.4348, 23.5696>, <7.5392, 50.4369, 23.6199>, <7.9571, 50.2185, 23.6279> }
					triangle { <7.5392, 50.4369, 23.6199>, <7.193, 50.2043, 23.9501>, <7.8289, 50.1528, 24.03011> }
					triangle { <7.9571, 50.2185, 23.6279>, <7.8289, 50.1528, 24.03011>, <8.02015, 50.03546, 23.9079> }
					triangle { <7.9571, 50.2185, 23.6279>, <7.5392, 50.4369, 23.6199>, <7.8289, 50.1528, 24.03011> }
					triangle { <8.1396, 50.1745, 23.2964>, <7.4291, 50.4348, 23.5696>, <7.9571, 50.2185, 23.6279> }
					triangle { <8.1383, 50.02005, 23.5572>, <7.9571, 50.2185, 23.6279>, <8.02015, 50.03546, 23.9079> }
					triangle { <8.1396, 50.1745, 23.2964>, <7.9571, 50.2185, 23.6279>, <8.1383, 50.02005, 23.5572> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <7.7992, 48.1547, 22.4045>, <8.2396, 50.02719, 23.5407>, <8.5113, 49.898, 23.5779> }
					triangle { <7.7992, 48.1547, 22.4045>, <7.9172, 49.2542, 22.9436>, <8.2396, 50.02719, 23.5407> }
					triangle { <8.5113, 49.898, 23.5779>, <8.3603, 49.2275, 22.9072>, <7.7992, 48.1547, 22.4045> }
					triangle { <7.9172, 49.2542, 22.9436>, <8.05267, 49.9569, 23.804>, <8.2396, 50.02719, 23.5407> }
					triangle { <8.05267, 49.9569, 23.804>, <8.1669, 49.8515, 24.3225>, <8.2396, 50.02719, 23.5407> }
					triangle { <8.5113, 49.898, 23.5779>, <8.781, 49.8459, 23.8264>, <8.7857, 49.9168, 23.4288> }
					triangle { <8.7857, 49.9168, 23.4288>, <8.3603, 49.2275, 22.9072>, <8.5113, 49.898, 23.5779> }
					triangle { <8.1669, 49.8515, 24.3225>, <8.2514, 49.9142, 24.2626>, <8.4619, 49.9632, 23.8435> }
					triangle { <8.2514, 49.9142, 24.2626>, <8.4802, 49.5295, 24.5501>, <8.7939, 49.8382, 24.08143> }
					triangle { <8.4619, 49.9632, 23.8435>, <8.7939, 49.8382, 24.08143>, <8.781, 49.8459, 23.8264> }
					triangle { <8.4619, 49.9632, 23.8435>, <8.2514, 49.9142, 24.2626>, <8.7939, 49.8382, 24.08143> }
					triangle { <8.2396, 50.02719, 23.5407>, <8.1669, 49.8515, 24.3225>, <8.4619, 49.9632, 23.8435> }
					triangle { <8.5113, 49.898, 23.5779>, <8.4619, 49.9632, 23.8435>, <8.781, 49.8459, 23.8264> }
					triangle { <8.2396, 50.02719, 23.5407>, <8.4619, 49.9632, 23.8435>, <8.5113, 49.898, 23.5779> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <7.7992, 48.1547, 22.4045>, <8.5313, 49.9599, 23.4982>, <8.6938, 50.00266, 23.2459> }
					triangle { <7.7992, 48.1547, 22.4045>, <8.06295, 49.1368, 23.09686>, <8.5313, 49.9599, 23.4982> }
					triangle { <8.6938, 50.00266, 23.2459>, <8.1964, 49.3595, 22.7349>, <7.7992, 48.1547, 22.4045> }
					triangle { <8.06295, 49.1368, 23.09686>, <8.718, 49.7984, 23.7178>, <8.5313, 49.9599, 23.4982> }
					triangle { <8.718, 49.7984, 23.7178>, <9.2518, 49.7744, 23.8043>, <8.5313, 49.9599, 23.4982> }
					triangle { <8.6938, 50.00266, 23.2459>, <9.02756, 50.1086, 23.1252>, <8.6539, 50.1698, 22.9845> }
					triangle { <8.6539, 50.1698, 22.9845>, <8.1964, 49.3595, 22.7349>, <8.6938, 50.00266, 23.2459> }
					triangle { <9.2518, 49.7744, 23.8043>, <9.2133, 49.8733, 23.7461>, <8.8997, 50.03004, 23.4306> }
					triangle { <9.2133, 49.8733, 23.7461>, <9.6474, 49.6795, 23.5074>, <9.2638, 50.1097, 23.2222> }
					triangle { <8.8997, 50.03004, 23.4306>, <9.2638, 50.1097, 23.2222>, <9.02756, 50.1086, 23.1252> }
					triangle { <8.8997, 50.03004, 23.4306>, <9.2133, 49.8733, 23.7461>, <9.2638, 50.1097, 23.2222> }
					triangle { <8.5313, 49.9599, 23.4982>, <9.2518, 49.7744, 23.8043>, <8.8997, 50.03004, 23.4306> }
					triangle { <8.6938, 50.00266, 23.2459>, <8.8997, 50.03004, 23.4306>, <9.02756, 50.1086, 23.1252> }
					triangle { <8.5313, 49.9599, 23.4982>, <8.8997, 50.03004, 23.4306>, <8.6938, 50.00266, 23.2459> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <7.7992, 48.1547, 22.4045>, <8.6143, 50.0652, 23.2272>, <8.4353, 50.1902, 23.01702> }
					triangle { <7.7992, 48.1547, 22.4045>, <8.2818, 49.1198, 22.9954>, <8.6143, 50.0652, 23.2272> }
					triangle { <8.4353, 50.1902, 23.01702>, <7.9502, 49.3787, 22.849>, <7.7992, 48.1547, 22.4045> }
					triangle { <8.2818, 49.1198, 22.9954>, <8.9184, 50.03407, 23.1018>, <8.6143, 50.0652, 23.2272> }
					triangle { <8.9184, 50.03407, 23.1018>, <9.1946, 50.3093, 22.7263>, <8.6143, 50.0652, 23.2272> }
					triangle { <8.4353, 50.1902, 23.01702>, <8.4213, 50.4629, 22.7667>, <8.1451, 50.3071, 23.01694> }
					triangle { <8.1451, 50.3071, 23.01694>, <7.9502, 49.3787, 22.849>, <8.4353, 50.1902, 23.01702> }
					triangle { <9.1946, 50.3093, 22.7263>, <9.1044, 50.3703, 22.7792>, <8.6694, 50.3271, 22.9561> }
					triangle { <9.1044, 50.3703, 22.7792>, <9.09253, 50.4486, 22.2532>, <8.5936, 50.5946, 22.6318> }
					triangle { <8.6694, 50.3271, 22.9561>, <8.5936, 50.5946, 22.6318>, <8.4213, 50.4629, 22.7667> }
					triangle { <8.6694, 50.3271, 22.9561>, <9.1044, 50.3703, 22.7792>, <8.5936, 50.5946, 22.6318> }
					triangle { <8.6143, 50.0652, 23.2272>, <9.1946, 50.3093, 22.7263>, <8.6694, 50.3271, 22.9561> }
					triangle { <8.4353, 50.1902, 23.01702>, <8.6694, 50.3271, 22.9561>, <8.4213, 50.4629, 22.7667> }
					triangle { <8.6143, 50.0652, 23.2272>, <8.6694, 50.3271, 22.9561>, <8.4353, 50.1902, 23.01702> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <7.7992, 48.1547, 22.4045>, <8.3686, 50.1998, 23.1006>, <8.08683, 50.2011, 23.2123> }
					triangle { <7.7992, 48.1547, 22.4045>, <8.2703, 49.2289, 22.7753>, <8.3686, 50.1998, 23.1006> }
					triangle { <8.08683, 50.2011, 23.2123>, <7.963, 49.2559, 23.09665>, <7.7992, 48.1547, 22.4045> }
					triangle { <8.2703, 49.2289, 22.7753>, <8.3649, 50.3437, 22.8032>, <8.3686, 50.1998, 23.1006> }
					triangle { <8.3649, 50.3437, 22.8032>, <8.05115, 50.7236, 22.5791>, <8.3686, 50.1998, 23.1006> }
					triangle { <8.08683, 50.2011, 23.2123>, <7.7893, 50.417, 23.2578>, <7.9605, 50.135, 23.4908> }
					triangle { <7.9605, 50.135, 23.4908>, <7.963, 49.2559, 23.09665>, <8.08683, 50.2011, 23.2123> }
					triangle { <8.05115, 50.7236, 22.5791>, <8.0542, 50.7239, 22.7>, <8.07808, 50.4453, 23.07988> }
					triangle { <8.0542, 50.7239, 22.7>, <7.5527, 50.7778, 22.5309>, <7.6934, 50.6216, 23.1386> }
					triangle { <8.07808, 50.4453, 23.07988>, <7.6934, 50.6216, 23.1386>, <7.7893, 50.417, 23.2578> }
					triangle { <8.07808, 50.4453, 23.07988>, <8.0542, 50.7239, 22.7>, <7.6934, 50.6216, 23.1386> }
					triangle { <8.3686, 50.1998, 23.1006>, <8.05115, 50.7236, 22.5791>, <8.07808, 50.4453, 23.07988> }
					triangle { <8.08683, 50.2011, 23.2123>, <8.07808, 50.4453, 23.07988>, <7.7893, 50.417, 23.2578> }
					triangle { <8.3686, 50.1998, 23.1006>, <8.07808, 50.4453, 23.07988>, <8.08683, 50.2011, 23.2123> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		}
	union { // internode
		cylinder { <-1.6363, 32.6566, -0.08414>, <-1.1612, 35.8517, 0.8907>, 0.5 }
		cylinder { <-1.1612, 35.8517, 0.8907>, <-0.4867, 39.1288, 1.3283>, 0.5 }
		cylinder { <-0.4867, 39.1288, 1.3283>, <0.3672, 42.3912, 1.2156>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.3672, 42.3912, 1.2156>, <0.896, 43.767, 0.6616>, 0.4999 }
			cylinder { <0.896, 43.767, 0.6616>, <1.4932, 44.8354, -0.329>, 0.4999 }
			cylinder { <1.4932, 44.8354, -0.329>, <2.08908, 45.4713, -1.6404>, 0.4999 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.08908, 45.4713, -1.6404>, <2.3393, 45.7385, -2.1913>, 0.4999 }
				cylinder { <2.3393, 45.7385, -2.1913>, <2.5895, 46.00561, -2.7421>, 0.4999 }
				cylinder { <2.5895, 46.00561, -2.7421>, <2.8398, 46.2727, -3.2929>, 0.4999 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <2.8398, 46.2727, -3.2929>, <2.9167, 46.314, -3.3837>, 0.03999 }
				cylinder { <2.9167, 46.314, -3.3837>, <3.01743, 46.3426, -3.4538>, 0.03999 }
				cylinder { <3.01743, 46.3426, -3.4538>, <3.1345, 46.3566, -3.4981>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <3.1345, 46.3566, -3.4981>, <8.4388, 46.6583, -5.8091>, <8.6659, 46.4554, -5.4266> }
				triangle { <8.4388, 46.6583, -5.8091>, <9.5357, 44.7646, -6.8859>, <8.6659, 46.4554, -5.4266> }
				triangle { <8.4388, 46.6583, -5.8091>, <9.1805, 45.2881, -7.04508>, <9.5357, 44.7646, -6.8859> }
				triangle { <9.5357, 44.7646, -6.8859>, <9.5439, 45.01545, -6.1709>, <8.6659, 46.4554, -5.4266> }
				triangle { <8.6659, 46.4554, -5.4266>, <6.541, 46.0542, -4.5685>, <3.1345, 46.3566, -3.4981> }
				triangle { <3.1345, 46.3566, -3.4981>, <6.2201, 46.3288, -5.3297>, <8.4388, 46.6583, -5.8091> }
				triangle { <6.2201, 46.3288, -5.3297>, <8.1231, 46.2748, -6.4577>, <8.4388, 46.6583, -5.8091> }
				triangle { <8.1231, 46.2748, -6.4577>, <9.1805, 45.2881, -7.04508>, <8.4388, 46.6583, -5.8091> }
				triangle { <8.6659, 46.4554, -5.4266>, <9.5439, 45.01545, -6.1709>, <8.7814, 45.6409, -5.3787> }
				triangle { <8.7814, 45.6409, -5.3787>, <6.541, 46.0542, -4.5685>, <8.6659, 46.4554, -5.4266> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <2.8398, 46.2727, -3.2929>, <2.8874, 46.3236, -3.3978>, 0.03999 }
				cylinder { <2.8874, 46.3236, -3.3978>, <2.9351, 46.3744, -3.5027>, 0.03999 }
				cylinder { <2.9351, 46.3744, -3.5027>, <2.9828, 46.4253, -3.6077>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <2.9828, 46.4253, -3.6077>, <5.04907, 48.3964, -8.6488>, <5.5187, 48.3166, -8.539> }
				triangle { <5.04907, 48.3964, -8.6488>, <5.7019, 46.9333, -10.4877>, <5.5187, 48.3166, -8.539> }
				triangle { <5.04907, 48.3964, -8.6488>, <5.1882, 47.2843, -10.2916>, <5.7019, 46.9333, -10.4877> }
				triangle { <5.7019, 46.9333, -10.4877>, <6.09405, 47.2252, -9.9088>, <5.5187, 48.3166, -8.539> }
				triangle { <5.5187, 48.3166, -8.539>, <4.7352, 47.2602, -6.6199>, <2.9828, 46.4253, -3.6077> }
				triangle { <2.9828, 46.4253, -3.6077>, <3.9316, 47.3448, -6.944>, <5.04907, 48.3964, -8.6488> }
				triangle { <3.9316, 47.3448, -6.944>, <4.5294, 47.8776, -9.006874>, <5.04907, 48.3964, -8.6488> }
				triangle { <4.5294, 47.8776, -9.006874>, <5.1882, 47.2843, -10.2916>, <5.04907, 48.3964, -8.6488> }
				triangle { <5.5187, 48.3166, -8.539>, <6.09405, 47.2252, -9.9088>, <5.886, 47.6012, -8.719> }
				triangle { <5.886, 47.6012, -8.719>, <4.7352, 47.2602, -6.6199>, <5.5187, 48.3166, -8.539> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <0.3672, 42.3912, 1.2156>, <0.6556, 45.746, 1.433>, 0.5 }
		cylinder { <0.6556, 45.746, 1.433>, <0.3672, 49.06437, 1.9723>, 0.5 }
		cylinder { <0.3672, 49.06437, 1.9723>, <-0.4868, 52.2186, 2.8126>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.4868, 52.2186, 2.8126>, <-1.2773, 53.4477, 3.3987>, 0.4999 }
			cylinder { <-1.2773, 53.4477, 3.3987>, <-2.38, 54.3098, 4.1196>, 0.4999 }
			cylinder { <-2.38, 54.3098, 4.1196>, <-3.6835, 54.7181, 4.9025>, 0.4999 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-3.6835, 54.7181, 4.9025>, <-4.231, 54.8895, 5.2314>, 0.4999 }
				cylinder { <-4.231, 54.8895, 5.2314>, <-4.7785, 55.06105, 5.5602>, 0.4999 }
				cylinder { <-4.7785, 55.06105, 5.5602>, <-5.326, 55.2325, 5.889>, 0.4999 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-5.326, 55.2325, 5.889>, <-5.443, 55.2672, 5.9203>, 0.03999 }
				cylinder { <-5.443, 55.2672, 5.9203>, <-5.5641, 55.3016, 5.9179>, 0.03999 }
				cylinder { <-5.5641, 55.3016, 5.9179>, <-5.6807, 55.3331, 5.8821>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-5.6807, 55.3331, 5.8821>, <-11.1706, 56.3711, 4.3513>, <-11.0901, 56.3378, 3.8704> }
				triangle { <-11.1706, 56.3711, 4.3513>, <-12.7448, 54.6084, 3.7495>, <-11.0901, 56.3378, 3.8704> }
				triangle { <-11.1706, 56.3711, 4.3513>, <-12.5746, 54.9653, 4.2682>, <-12.7448, 54.6084, 3.7495> }
				triangle { <-12.7448, 54.6084, 3.7495>, <-12.2703, 55.0277, 3.3334>, <-11.0901, 56.3378, 3.8704> }
				triangle { <-11.0901, 56.3378, 3.8704>, <-8.9416, 55.6432, 4.4299>, <-5.6807, 55.3331, 5.8821> }
				triangle { <-5.6807, 55.3331, 5.8821>, <-9.2025, 55.6224, 5.26>, <-11.1706, 56.3711, 4.3513> }
				triangle { <-9.2025, 55.6224, 5.26>, <-11.3742, 55.7669, 4.862>, <-11.1706, 56.3711, 4.3513> }
				triangle { <-11.3742, 55.7669, 4.862>, <-12.5746, 54.9653, 4.2682>, <-11.1706, 56.3711, 4.3513> }
				triangle { <-11.0901, 56.3378, 3.8704>, <-12.2703, 55.0277, 3.3334>, <-11.1614, 55.62, 3.472> }
				triangle { <-11.1614, 55.62, 3.472>, <-8.9416, 55.6432, 4.4299>, <-11.0901, 56.3378, 3.8704> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-5.326, 55.2325, 5.889>, <-5.4303, 55.2651, 5.9517>, 0.03999 }
				cylinder { <-5.4303, 55.2651, 5.9517>, <-5.5346, 55.2978, 6.01435>, 0.03999 }
				cylinder { <-5.5346, 55.2978, 6.01435>, <-5.6388, 55.3304, 6.07698>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-5.6388, 55.3304, 6.07698>, <-10.4921, 56.4012, 9.05342>, <-10.7714, 56.4744, 8.6589> }
				triangle { <-10.4921, 56.4012, 9.05342>, <-12.2327, 54.7316, 9.4143>, <-10.7714, 56.4744, 8.6589> }
				triangle { <-10.4921, 56.4012, 9.05342>, <-11.7115, 54.9785, 9.7191>, <-12.2327, 54.7316, 9.4143> }
				triangle { <-12.2327, 54.7316, 9.4143>, <-12.1343, 55.252, 8.8724>, <-10.7714, 56.4744, 8.6589> }
				triangle { <-10.7714, 56.4744, 8.6589>, <-8.9325, 55.7822, 7.4136>, <-5.6388, 55.3304, 6.07698> }
				triangle { <-5.6388, 55.3304, 6.07698>, <-8.5464, 55.5736, 8.1653>, <-10.4921, 56.4012, 9.05342> }
				triangle { <-8.5464, 55.5736, 8.1653>, <-10.3531, 55.6934, 9.4368>, <-10.4921, 56.4012, 9.05342> }
				triangle { <-10.3531, 55.6934, 9.4368>, <-11.7115, 54.9785, 9.7191>, <-10.4921, 56.4012, 9.05342> }
				triangle { <-10.7714, 56.4744, 8.6589>, <-12.1343, 55.252, 8.8724>, <-11.1801, 55.8547, 8.3014> }
				triangle { <-11.1801, 55.8547, 8.3014>, <-8.9325, 55.7822, 7.4136>, <-10.7714, 56.4744, 8.6589> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-0.4868, 52.2186, 2.8126>, <-1.2236, 53.7428, 3.4018>, 0.2656 }
		cylinder { <-1.2236, 53.7428, 3.4018>, <-2.2151, 55.05687, 4.1111>, 0.2656 }
		cylinder { <-2.2151, 55.05687, 4.1111>, <-3.4233, 56.1103, 4.9133>, 0.2656 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.4233, 56.1103, 4.9133>, <-3.5404, 56.1506, 4.9841>, 0.0453 }
			cylinder { <-3.5404, 56.1506, 4.9841>, <-3.6648, 56.1427, 5.05354>, 0.0453 }
			cylinder { <-3.6648, 56.1427, 5.05354>, <-3.782, 56.08762, 5.1134>, 0.0453 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-3.782, 56.08762, 5.1134>, <-3.8311, 56.06445, 5.1386>, 0.0453 }
				cylinder { <-3.8311, 56.06445, 5.1386>, <-3.8803, 56.04128, 5.1638>, 0.0453 }
				cylinder { <-3.8803, 56.04128, 5.1638>, <-3.9295, 56.01811, 5.1889>, 0.0453 }
				texture{chif1}}
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <-3.4233, 56.1103, 4.9133>, <-3.666, 56.3558, 5.1007>, 0.2183 }
			cylinder { <-3.666, 56.3558, 5.1007>, <-3.8854, 56.6147, 5.2987>, 0.2183 }
			cylinder { <-3.8854, 56.6147, 5.2987>, <-4.08022, 56.8855, 5.5062>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <-4.08022, 56.8855, 5.5062>, <-4.2493, 57.1668, 5.7221>, 0.2183 }
			cylinder { <-4.2493, 57.1668, 5.7221>, <-4.3919, 57.457, 5.9452>, 0.2183 }
			cylinder { <-4.3919, 57.457, 5.9452>, <-4.5073, 57.7546, 6.1743>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <-4.5073, 57.7546, 6.1743>, <-4.6425, 58.05846, 6.3835>, 0.2183 }
			cylinder { <-4.6425, 58.05846, 6.3835>, <-4.7971, 58.3668, 6.5715>, 0.2183 }
			cylinder { <-4.7971, 58.3668, 6.5715>, <-4.9701, 58.678, 6.7375>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-4.9701, 58.678, 6.7375>, <-5.2641, 59.1468, 6.9401>, 0.2183 }
				cylinder { <-5.2641, 59.1468, 6.9401>, <-5.59, 59.6129, 7.09456>, 0.2183 }
				cylinder { <-5.59, 59.6129, 7.09456>, <-5.9445, 60.07185, 7.1992>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-5.9445, 60.07185, 7.1992>, <-7.4752, 61.6488, 7.6739>, <-7.2956, 61.6991, 7.9154> }
					triangle { <-5.9445, 60.07185, 7.1992>, <-6.8259, 60.9357, 7.2977>, <-7.4752, 61.6488, 7.6739> }
					triangle { <-7.2956, 61.6991, 7.9154>, <-6.5601, 61.1805, 7.563>, <-5.9445, 60.07185, 7.1992> }
					triangle { <-6.8259, 60.9357, 7.2977>, <-7.7183, 61.4405, 7.764>, <-7.4752, 61.6488, 7.6739> }
					triangle { <-7.7183, 61.4405, 7.764>, <-7.9671, 61.3402, 8.2381>, <-7.4752, 61.6488, 7.6739> }
					triangle { <-7.2956, 61.6991, 7.9154>, <-7.3042, 61.7761, 8.28>, <-7.06103, 61.8993, 7.9785> }
					triangle { <-7.06103, 61.8993, 7.9785>, <-6.5601, 61.1805, 7.563>, <-7.2956, 61.6991, 7.9154> }
					triangle { <-7.9671, 61.3402, 8.2381>, <-7.9144, 61.4496, 8.2292>, <-7.5397, 61.6798, 8.05068> }
					triangle { <-7.9144, 61.4496, 8.2292>, <-7.7998, 61.2298, 8.7037>, <-7.4714, 61.7367, 8.4712> }
					triangle { <-7.5397, 61.6798, 8.05068>, <-7.4714, 61.7367, 8.4712>, <-7.3042, 61.7761, 8.28> }
					triangle { <-7.5397, 61.6798, 8.05068>, <-7.9144, 61.4496, 8.2292>, <-7.4714, 61.7367, 8.4712> }
					triangle { <-7.4752, 61.6488, 7.6739>, <-7.9671, 61.3402, 8.2381>, <-7.5397, 61.6798, 8.05068> }
					triangle { <-7.2956, 61.6991, 7.9154>, <-7.5397, 61.6798, 8.05068>, <-7.3042, 61.7761, 8.28> }
					triangle { <-7.4752, 61.6488, 7.6739>, <-7.5397, 61.6798, 8.05068>, <-7.2956, 61.6991, 7.9154> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-5.9445, 60.07185, 7.1992>, <-7.2617, 61.7732, 7.8515>, <-7.02468, 61.9433, 7.7625> }
					triangle { <-5.9445, 60.07185, 7.1992>, <-6.7978, 60.9028, 7.5372>, <-7.2617, 61.7732, 7.8515> }
					triangle { <-7.02468, 61.9433, 7.7625>, <-6.5918, 61.2176, 7.2935>, <-5.9445, 60.07185, 7.1992> }
					triangle { <-6.7978, 60.9028, 7.5372>, <-7.2362, 61.7183, 8.1785>, <-7.2617, 61.7732, 7.8515> }
					triangle { <-7.2362, 61.7183, 8.1785>, <-7.01115, 61.999, 8.5875>, <-7.2617, 61.7732, 7.8515> }
					triangle { <-7.02468, 61.9433, 7.7625>, <-6.8243, 62.2437, 7.8551>, <-6.9489, 62.09566, 7.4976> }
					triangle { <-6.9489, 62.09566, 7.4976>, <-6.5918, 61.2176, 7.2935>, <-7.02468, 61.9433, 7.7625> }
					triangle { <-7.01115, 61.999, 8.5875>, <-7.04112, 62.06494, 8.4895>, <-7.06229, 62.05668, 8.01552> }
					triangle { <-7.04112, 62.06494, 8.4895>, <-6.5528, 62.2031, 8.6602>, <-6.7716, 62.3679, 8.07394> }
					triangle { <-7.06229, 62.05668, 8.01552>, <-6.7716, 62.3679, 8.07394>, <-6.8243, 62.2437, 7.8551> }
					triangle { <-7.06229, 62.05668, 8.01552>, <-7.04112, 62.06494, 8.4895>, <-6.7716, 62.3679, 8.07394> }
					triangle { <-7.2617, 61.7732, 7.8515>, <-7.01115, 61.999, 8.5875>, <-7.06229, 62.05668, 8.01552> }
					triangle { <-7.02468, 61.9433, 7.7625>, <-7.06229, 62.05668, 8.01552>, <-6.8243, 62.2437, 7.8551> }
					triangle { <-7.2617, 61.7732, 7.8515>, <-7.06229, 62.05668, 8.01552>, <-7.02468, 61.9433, 7.7625> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-5.9445, 60.07185, 7.1992>, <-7.08451, 61.9497, 7.6783>, <-7.09389, 61.9783, 7.3747> }
					triangle { <-5.9445, 60.07185, 7.1992>, <-6.6063, 61.03405, 7.6104>, <-7.08451, 61.9497, 7.6783> }
					triangle { <-7.09389, 61.9783, 7.3747>, <-6.8072, 61.06998, 7.2112>, <-5.9445, 60.07185, 7.1992> }
					triangle { <-6.6063, 61.03405, 7.6104>, <-6.8254, 62.1236, 7.7933>, <-7.08451, 61.9497, 7.6783> }
					triangle { <-6.8254, 62.1236, 7.7933>, <-6.564, 62.5665, 7.6138>, <-7.08451, 61.9497, 7.6783> }
					triangle { <-7.09389, 61.9783, 7.3747>, <-7.06691, 62.2286, 7.09984>, <-7.3024, 61.9014, 7.1517> }
					triangle { <-7.3024, 61.9014, 7.1517>, <-6.8072, 61.06998, 7.2112>, <-7.09389, 61.9783, 7.3747> }
					triangle { <-6.564, 62.5665, 7.6138>, <-6.6784, 62.5539, 7.5739>, <-7.002101, 62.2353, 7.4361> }
					triangle { <-6.6784, 62.5539, 7.5739>, <-6.358, 62.6938, 7.1685>, <-6.9523, 62.457, 7.07122> }
					triangle { <-7.002101, 62.2353, 7.4361>, <-6.9523, 62.457, 7.07122>, <-7.06691, 62.2286, 7.09984> }
					triangle { <-7.002101, 62.2353, 7.4361>, <-6.6784, 62.5539, 7.5739>, <-6.9523, 62.457, 7.07122> }
					triangle { <-7.08451, 61.9497, 7.6783>, <-6.564, 62.5665, 7.6138>, <-7.002101, 62.2353, 7.4361> }
					triangle { <-7.09389, 61.9783, 7.3747>, <-7.002101, 62.2353, 7.4361>, <-7.06691, 62.2286, 7.09984> }
					triangle { <-7.08451, 61.9497, 7.6783>, <-7.002101, 62.2353, 7.4361>, <-7.09389, 61.9783, 7.3747> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-5.9445, 60.07185, 7.1992>, <-7.1867, 61.936, 7.392>, <-7.4083, 61.7561, 7.2842> }
					triangle { <-5.9445, 60.07185, 7.1992>, <-6.5143, 61.1493, 7.4167>, <-7.1867, 61.936, 7.392> }
					triangle { <-7.4083, 61.7561, 7.2842>, <-6.9107, 60.9403, 7.429>, <-5.9445, 60.07185, 7.1992> }
					triangle { <-6.5143, 61.1493, 7.4167>, <-7.04975, 62.09998, 7.1372>, <-7.1867, 61.936, 7.392> }
					triangle { <-7.04975, 62.09998, 7.1372>, <-7.2395, 62.2637, 6.6536>, <-7.1867, 61.936, 7.392> }
					triangle { <-7.4083, 61.7561, 7.2842>, <-7.6989, 61.7515, 7.05093>, <-7.6363, 61.5833, 7.4156> }
					triangle { <-7.6363, 61.5833, 7.4156>, <-6.9107, 60.9403, 7.429>, <-7.4083, 61.7561, 7.2842> }
					triangle { <-7.2395, 62.2637, 6.6536>, <-7.3242, 62.2454, 6.7392>, <-7.4417, 61.9705, 7.1078> }
					triangle { <-7.3242, 62.2454, 6.7392>, <-7.4828, 62.02853, 6.2762>, <-7.7656, 61.8816, 6.8394> }
					triangle { <-7.4417, 61.9705, 7.1078>, <-7.7656, 61.8816, 6.8394>, <-7.6989, 61.7515, 7.05093> }
					triangle { <-7.4417, 61.9705, 7.1078>, <-7.3242, 62.2454, 6.7392>, <-7.7656, 61.8816, 6.8394> }
					triangle { <-7.1867, 61.936, 7.392>, <-7.2395, 62.2637, 6.6536>, <-7.4417, 61.9705, 7.1078> }
					triangle { <-7.4083, 61.7561, 7.2842>, <-7.4417, 61.9705, 7.1078>, <-7.6989, 61.7515, 7.05093> }
					triangle { <-7.1867, 61.936, 7.392>, <-7.4417, 61.9705, 7.1078>, <-7.4083, 61.7561, 7.2842> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-5.9445, 60.07185, 7.1992>, <-7.4319, 61.7472, 7.3893>, <-7.5349, 61.5809, 7.6234> }
					triangle { <-5.9445, 60.07185, 7.1992>, <-6.6521, 61.08763, 7.2206>, <-7.4319, 61.7472, 7.3893> }
					triangle { <-7.5349, 61.5809, 7.6234>, <-6.7557, 61.00971, 7.6497>, <-5.9445, 60.07185, 7.1992> }
					triangle { <-6.6521, 61.08763, 7.2206>, <-7.6099, 61.6714, 7.1188>, <-7.4319, 61.7472, 7.3893> }
					triangle { <-7.6099, 61.6714, 7.1188>, <-8.1198, 61.4944, 7.04531>, <-7.4319, 61.7472, 7.3893> }
					triangle { <-7.5349, 61.5809, 7.6234>, <-7.8478, 61.4676, 7.7913>, <-7.4849, 61.582, 7.9343> }
					triangle { <-7.4849, 61.582, 7.9343>, <-6.7557, 61.00971, 7.6497>, <-7.5349, 61.5809, 7.6234> }
					triangle { <-8.1198, 61.4944, 7.04531>, <-8.09967, 61.5527, 7.1503>, <-7.779, 61.622, 7.4933> }
					triangle { <-8.09967, 61.5527, 7.1503>, <-8.3873, 61.11, 7.2393>, <-8.09124, 61.4297, 7.7178> }
					triangle { <-7.779, 61.622, 7.4933>, <-8.09124, 61.4297, 7.7178>, <-7.8478, 61.4676, 7.7913> }
					triangle { <-7.779, 61.622, 7.4933>, <-8.09967, 61.5527, 7.1503>, <-8.09124, 61.4297, 7.7178> }
					triangle { <-7.4319, 61.7472, 7.3893>, <-8.1198, 61.4944, 7.04531>, <-7.779, 61.622, 7.4933> }
					triangle { <-7.5349, 61.5809, 7.6234>, <-7.779, 61.622, 7.4933>, <-7.8478, 61.4676, 7.7913> }
					triangle { <-7.4319, 61.7472, 7.3893>, <-7.779, 61.622, 7.4933>, <-7.5349, 61.5809, 7.6234> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-4.9701, 58.678, 6.7375>, <-5.1418, 58.9752, 6.9286>, 0.2183 }
			cylinder { <-5.1418, 58.9752, 6.9286>, <-5.3115, 59.2566, 7.144>, 0.2183 }
			cylinder { <-5.3115, 59.2566, 7.144>, <-5.4781, 59.5207, 7.3823>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-5.4781, 59.5207, 7.3823>, <-5.7199, 59.8791, 7.7828>, 0.2183 }
				cylinder { <-5.7199, 59.8791, 7.7828>, <-5.9512, 60.1962, 8.2223>, 0.2183 }
				cylinder { <-5.9512, 60.1962, 8.2223>, <-6.1697, 60.4689, 8.6968>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-6.1697, 60.4689, 8.6968>, <-6.7556, 61.5651, 10.5608>, <-6.8496, 61.7766, 10.3637> }
					triangle { <-6.1697, 60.4689, 8.6968>, <-6.4932, 60.923, 9.7973>, <-6.7556, 61.5651, 10.5608> }
					triangle { <-6.8496, 61.7766, 10.3637>, <-6.7932, 61.1902, 9.602>, <-6.1697, 60.4689, 8.6968> }
					triangle { <-6.4932, 60.923, 9.7973>, <-6.4482, 61.641, 10.6587>, <-6.7556, 61.5651, 10.5608> }
					triangle { <-6.4482, 61.641, 10.6587>, <-6.1783, 62.1095, 10.7065>, <-6.7556, 61.5651, 10.5608> }
					triangle { <-6.8496, 61.7766, 10.3637>, <-6.8615, 62.1436, 10.308>, <-7.1246, 61.8458, 10.2294> }
					triangle { <-7.1246, 61.8458, 10.2294>, <-6.7932, 61.1902, 9.602>, <-6.8496, 61.7766, 10.3637> }
					triangle { <-6.1783, 62.1095, 10.7065>, <-6.2993, 62.1189, 10.7097>, <-6.6996, 61.9418, 10.5307> }
					triangle { <-6.2993, 62.1189, 10.7097>, <-6.09586, 62.497, 10.3932>, <-6.7222, 62.3442, 10.3854> }
					triangle { <-6.6996, 61.9418, 10.5307>, <-6.7222, 62.3442, 10.3854>, <-6.8615, 62.1436, 10.308> }
					triangle { <-6.6996, 61.9418, 10.5307>, <-6.2993, 62.1189, 10.7097>, <-6.7222, 62.3442, 10.3854> }
					triangle { <-6.7556, 61.5651, 10.5608>, <-6.1783, 62.1095, 10.7065>, <-6.6996, 61.9418, 10.5307> }
					triangle { <-6.8496, 61.7766, 10.3637>, <-6.6996, 61.9418, 10.5307>, <-6.8615, 62.1436, 10.308> }
					triangle { <-6.7556, 61.5651, 10.5608>, <-6.6996, 61.9418, 10.5307>, <-6.8496, 61.7766, 10.3637> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.1697, 60.4689, 8.6968>, <-6.9388, 61.7282, 10.3826>, <-7.21, 61.6451, 10.2733> }
					triangle { <-6.1697, 60.4689, 8.6968>, <-6.4443, 61.138, 9.6962>, <-6.9388, 61.7282, 10.3826> }
					triangle { <-7.21, 61.6451, 10.2733>, <-6.8482, 60.9483, 9.7156>, <-6.1697, 60.4689, 8.6968> }
					triangle { <-6.4443, 61.138, 9.6962>, <-6.8574, 62.02153, 10.2515>, <-6.9388, 61.7282, 10.3826> }
					triangle { <-6.8574, 62.02153, 10.2515>, <-7.1494, 62.4409, 10.06875>, <-6.9388, 61.7282, 10.3826> }
					triangle { <-7.21, 61.6451, 10.2733>, <-7.5517, 61.7726, 10.2033>, <-7.4147, 61.4175, 10.342> }
					triangle { <-7.4147, 61.4175, 10.342>, <-6.8482, 60.9483, 9.7156>, <-7.21, 61.6451, 10.2733> }
					triangle { <-7.1494, 62.4409, 10.06875>, <-7.2062, 62.369, 10.1482>, <-7.2554, 61.9197, 10.2874> }
					triangle { <-7.2062, 62.369, 10.1482>, <-7.531, 62.4824, 9.7405>, <-7.6536, 62.00216, 10.153> }
					triangle { <-7.2554, 61.9197, 10.2874>, <-7.6536, 62.00216, 10.153>, <-7.5517, 61.7726, 10.2033> }
					triangle { <-7.2554, 61.9197, 10.2874>, <-7.2062, 62.369, 10.1482>, <-7.6536, 62.00216, 10.153> }
					triangle { <-6.9388, 61.7282, 10.3826>, <-7.1494, 62.4409, 10.06875>, <-7.2554, 61.9197, 10.2874> }
					triangle { <-7.21, 61.6451, 10.2733>, <-7.2554, 61.9197, 10.2874>, <-7.5517, 61.7726, 10.2033> }
					triangle { <-6.9388, 61.7282, 10.3826>, <-7.2554, 61.9197, 10.2874>, <-7.21, 61.6451, 10.2733> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.1697, 60.4689, 8.6968>, <-7.1992, 61.5766, 10.3498>, <-7.2622, 61.2965, 10.4497> }
					triangle { <-6.1697, 60.4689, 8.6968>, <-6.6377, 61.2072, 9.5673>, <-7.1992, 61.5766, 10.3498> }
					triangle { <-7.2622, 61.2965, 10.4497>, <-6.6306, 60.8704, 9.8607>, <-6.1697, 60.4689, 8.6968> }
					triangle { <-6.6377, 61.2072, 9.5673>, <-7.4555, 61.6847, 10.1696>, <-7.1992, 61.5766, 10.3498> }
					triangle { <-7.4555, 61.6847, 10.1696>, <-7.9876, 61.578, 10.1787>, <-7.1992, 61.5766, 10.3498> }
					triangle { <-7.2622, 61.2965, 10.4497>, <-7.5305, 61.09173, 10.6045>, <-7.1289, 61.101, 10.6556> }
					triangle { <-7.1289, 61.101, 10.6556>, <-6.6306, 60.8704, 9.8607>, <-7.2622, 61.2965, 10.4497> }
					triangle { <-7.9876, 61.578, 10.1787>, <-7.9287, 61.5563, 10.2825>, <-7.5197, 61.4022, 10.4631> }
					triangle { <-7.9287, 61.5563, 10.2825>, <-8.2569, 61.1507, 10.1717>, <-7.7865, 61.1009, 10.6099> }
					triangle { <-7.5197, 61.4022, 10.4631>, <-7.7865, 61.1009, 10.6099>, <-7.5305, 61.09173, 10.6045> }
					triangle { <-7.5197, 61.4022, 10.4631>, <-7.9287, 61.5563, 10.2825>, <-7.7865, 61.1009, 10.6099> }
					triangle { <-7.1992, 61.5766, 10.3498>, <-7.9876, 61.578, 10.1787>, <-7.5197, 61.4022, 10.4631> }
					triangle { <-7.2622, 61.2965, 10.4497>, <-7.5197, 61.4022, 10.4631>, <-7.5305, 61.09173, 10.6045> }
					triangle { <-7.1992, 61.5766, 10.3498>, <-7.5197, 61.4022, 10.4631>, <-7.2622, 61.2965, 10.4497> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.1697, 60.4689, 8.6968>, <-7.1795, 61.3184, 10.5073>, <-6.9346, 61.2093, 10.6507> }
					triangle { <-6.1697, 60.4689, 8.6968>, <-6.8079, 61.03574, 9.5875>, <-7.1795, 61.3184, 10.5073> }
					triangle { <-6.9346, 61.2093, 10.6507>, <-6.4391, 61.06347, 9.8379>, <-6.1697, 60.4689, 8.6968> }
					triangle { <-6.8079, 61.03574, 9.5875>, <-7.4216, 61.09294, 10.5254>, <-7.1795, 61.3184, 10.5073> }
					triangle { <-7.4216, 61.09294, 10.5254>, <-7.5425, 60.7051, 10.8855>, <-7.1795, 61.3184, 10.5073> }
					triangle { <-6.9346, 61.2093, 10.6507>, <-6.8271, 61.03561, 10.9608>, <-6.6593, 61.3307, 10.7399> }
					triangle { <-6.6593, 61.3307, 10.7399>, <-6.4391, 61.06347, 9.8379>, <-6.9346, 61.2093, 10.6507> }
					triangle { <-7.5425, 60.7051, 10.8855>, <-7.475, 60.7964, 10.9284>, <-7.1297, 61.09972, 10.8167> }
					triangle { <-7.475, 60.7964, 10.9284>, <-7.2771, 60.3299, 11.09494>, <-6.9384, 60.8776, 11.1289> }
					triangle { <-7.1297, 61.09972, 10.8167>, <-6.9384, 60.8776, 11.1289>, <-6.8271, 61.03561, 10.9608> }
					triangle { <-7.1297, 61.09972, 10.8167>, <-7.475, 60.7964, 10.9284>, <-6.9384, 60.8776, 11.1289> }
					triangle { <-7.1795, 61.3184, 10.5073>, <-7.5425, 60.7051, 10.8855>, <-7.1297, 61.09972, 10.8167> }
					triangle { <-6.9346, 61.2093, 10.6507>, <-7.1297, 61.09972, 10.8167>, <-6.8271, 61.03561, 10.9608> }
					triangle { <-7.1795, 61.3184, 10.5073>, <-7.1297, 61.09972, 10.8167>, <-6.9346, 61.2093, 10.6507> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.1697, 60.4689, 8.6968>, <-6.9011, 61.3112, 10.6397>, <-6.6757, 61.5106, 10.5968> }
					triangle { <-6.1697, 60.4689, 8.6968>, <-6.7173, 60.8574, 9.7318>, <-6.9011, 61.3112, 10.6397> }
					triangle { <-6.6757, 61.5106, 10.5968>, <-6.5411, 61.264, 9.6756>, <-6.1697, 60.4689, 8.6968> }
					triangle { <-6.7173, 60.8574, 9.7318>, <-6.7897, 61.06557, 10.8322>, <-6.9011, 61.3112, 10.6397> }
					triangle { <-6.7897, 61.06557, 10.8322>, <-6.4074, 61.03866, 11.2166>, <-6.9011, 61.3112, 10.6397> }
					triangle { <-6.6757, 61.5106, 10.5968>, <-6.4073, 61.6955, 10.7748>, <-6.6566, 61.798, 10.4725> }
					triangle { <-6.6566, 61.798, 10.4725>, <-6.5411, 61.264, 9.6756>, <-6.6757, 61.5106, 10.5968> }
					triangle { <-6.4074, 61.03866, 11.2166>, <-6.4528, 61.1493, 11.1963>, <-6.6153, 61.4382, 10.859> }
					triangle { <-6.4528, 61.1493, 11.1963>, <-5.9213, 61.1745, 11.2339>, <-6.2707, 61.6575, 10.9881> }
					triangle { <-6.6153, 61.4382, 10.859>, <-6.2707, 61.6575, 10.9881>, <-6.4073, 61.6955, 10.7748> }
					triangle { <-6.6153, 61.4382, 10.859>, <-6.4528, 61.1493, 11.1963>, <-6.2707, 61.6575, 10.9881> }
					triangle { <-6.9011, 61.3112, 10.6397>, <-6.4074, 61.03866, 11.2166>, <-6.6153, 61.4382, 10.859> }
					triangle { <-6.6757, 61.5106, 10.5968>, <-6.6153, 61.4382, 10.859>, <-6.4073, 61.6955, 10.7748> }
					triangle { <-6.9011, 61.3112, 10.6397>, <-6.6153, 61.4382, 10.859>, <-6.6757, 61.5106, 10.5968> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-5.4781, 59.5207, 7.3823>, <-5.6295, 59.8052, 7.607>, 0.2183 }
			cylinder { <-5.6295, 59.8052, 7.607>, <-5.7647, 60.1086, 7.8167>, 0.2183 }
			cylinder { <-5.7647, 60.1086, 7.8167>, <-5.8831, 60.4292, 8.01054>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-5.8831, 60.4292, 8.01054>, <-6.02559, 60.9404, 8.2667>, 0.2183 }
				cylinder { <-6.02559, 60.9404, 8.2667>, <-6.1315, 61.4771, 8.4859>, 0.2183 }
				cylinder { <-6.1315, 61.4771, 8.4859>, <-6.1998, 62.03402, 8.6661>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-6.1998, 62.03402, 8.6661>, <-6.6181, 64.1815, 9.1482>, <-6.7858, 64.06133, 9.3714> }
					triangle { <-6.1998, 62.03402, 8.6661>, <-6.2891, 63.2507, 8.8492>, <-6.6181, 64.1815, 9.1482> }
					triangle { <-6.7858, 64.06133, 9.3714>, <-6.4082, 63.1808, 9.274>, <-6.1998, 62.03402, 8.6661> }
					triangle { <-6.2891, 63.2507, 8.8492>, <-6.815, 64.2413, 8.8885>, <-6.6181, 64.1815, 9.1482> }
					triangle { <-6.815, 64.2413, 8.8885>, <-7.3434, 64.3561, 8.8412>, <-6.6181, 64.1815, 9.1482> }
					triangle { <-6.7858, 64.06133, 9.3714>, <-7.1079, 64.1001, 9.5523>, <-6.7357, 63.9968, 9.6743> }
					triangle { <-6.7357, 63.9968, 9.6743>, <-6.4082, 63.1808, 9.274>, <-6.7858, 64.06133, 9.3714> }
					triangle { <-7.3434, 64.3561, 8.8412>, <-7.2942, 64.382, 8.9491>, <-6.9769, 64.2357, 9.2677> }
					triangle { <-7.2942, 64.382, 8.9491>, <-7.7638, 64.1381, 9.01689>, <-7.3372, 64.1996, 9.4965> }
					triangle { <-6.9769, 64.2357, 9.2677>, <-7.3372, 64.1996, 9.4965>, <-7.1079, 64.1001, 9.5523> }
					triangle { <-6.9769, 64.2357, 9.2677>, <-7.2942, 64.382, 8.9491>, <-7.3372, 64.1996, 9.4965> }
					triangle { <-6.6181, 64.1815, 9.1482>, <-7.3434, 64.3561, 8.8412>, <-6.9769, 64.2357, 9.2677> }
					triangle { <-6.7858, 64.06133, 9.3714>, <-6.9769, 64.2357, 9.2677>, <-7.1079, 64.1001, 9.5523> }
					triangle { <-6.6181, 64.1815, 9.1482>, <-6.9769, 64.2357, 9.2677>, <-6.7858, 64.06133, 9.3714> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.1998, 62.03402, 8.6661>, <-6.6991, 64.08263, 9.4231>, <-6.5145, 64.00404, 9.6514> }
					triangle { <-6.1998, 62.03402, 8.6661>, <-6.5136, 63.1987, 8.9248>, <-6.6991, 64.08263, 9.4231> }
					triangle { <-6.5145, 64.00404, 9.6514>, <-6.1556, 63.2393, 9.189>, <-6.1998, 62.03402, 8.6661> }
					triangle { <-6.5136, 63.1987, 8.9248>, <-7.01135, 64.01563, 9.5117>, <-6.6991, 64.08263, 9.4231> }
					triangle { <-7.01135, 64.01563, 9.5117>, <-7.2652, 63.9936, 9.991>, <-6.6991, 64.08263, 9.4231> }
					triangle { <-6.5145, 64.00404, 9.6514>, <-6.4747, 64.02657, 10.02007>, <-6.2103, 64.04851, 9.714> }
					triangle { <-6.2103, 64.04851, 9.714>, <-6.1556, 63.2393, 9.189>, <-6.5145, 64.00404, 9.6514> }
					triangle { <-7.2652, 63.9936, 9.991>, <-7.1646, 64.06154, 9.9887>, <-6.7304, 64.09254, 9.8037> }
					triangle { <-7.1646, 64.06154, 9.9887>, <-7.1679, 63.7554, 10.4256>, <-6.6339, 64.05214, 10.2191> }
					triangle { <-6.7304, 64.09254, 9.8037>, <-6.6339, 64.05214, 10.2191>, <-6.4747, 64.02657, 10.02007> }
					triangle { <-6.7304, 64.09254, 9.8037>, <-7.1646, 64.06154, 9.9887>, <-6.6339, 64.05214, 10.2191> }
					triangle { <-6.6991, 64.08263, 9.4231>, <-7.2652, 63.9936, 9.991>, <-6.7304, 64.09254, 9.8037> }
					triangle { <-6.5145, 64.00404, 9.6514>, <-6.7304, 64.09254, 9.8037>, <-6.4747, 64.02657, 10.02007> }
					triangle { <-6.6991, 64.08263, 9.4231>, <-6.7304, 64.09254, 9.8037>, <-6.5145, 64.00404, 9.6514> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.1998, 62.03402, 8.6661>, <-6.4491, 64.05837, 9.5929>, <-6.1615, 64.0957, 9.5021> }
					triangle { <-6.1998, 62.03402, 8.6661>, <-6.5011, 63.1255, 9.1557>, <-6.4491, 64.05837, 9.5929> }
					triangle { <-6.1615, 64.0957, 9.5021>, <-6.1697, 63.3216, 8.9292>, <-6.1998, 62.03402, 8.6661> }
					triangle { <-6.5011, 63.1255, 9.1557>, <-6.4481, 63.9564, 9.9082>, <-6.4491, 64.05837, 9.5929> }
					triangle { <-6.4481, 63.9564, 9.9082>, <-6.1037, 64.02937, 10.3214>, <-6.4491, 64.05837, 9.5929> }
					triangle { <-6.1615, 64.0957, 9.5021>, <-5.8351, 64.2388, 9.6067>, <-6.02489, 64.2216, 9.2493> }
					triangle { <-6.02489, 64.2216, 9.2493>, <-6.1697, 63.3216, 8.9292>, <-6.1615, 64.0957, 9.5021> }
					triangle { <-6.1037, 64.02937, 10.3214>, <-6.09804, 64.1131, 10.2338>, <-6.1306, 64.1782, 9.7665> }
					triangle { <-6.09804, 64.1131, 10.2338>, <-5.6058, 63.9636, 10.3749>, <-5.7221, 64.2896, 9.8309> }
					triangle { <-6.1306, 64.1782, 9.7665>, <-5.7221, 64.2896, 9.8309>, <-5.8351, 64.2388, 9.6067> }
					triangle { <-6.1306, 64.1782, 9.7665>, <-6.09804, 64.1131, 10.2338>, <-5.7221, 64.2896, 9.8309> }
					triangle { <-6.4491, 64.05837, 9.5929>, <-6.1037, 64.02937, 10.3214>, <-6.1306, 64.1782, 9.7665> }
					triangle { <-6.1615, 64.0957, 9.5021>, <-6.1306, 64.1782, 9.7665>, <-5.8351, 64.2388, 9.6067> }
					triangle { <-6.4491, 64.05837, 9.5929>, <-6.1306, 64.1782, 9.7665>, <-6.1615, 64.0957, 9.5021> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.1998, 62.03402, 8.6661>, <-6.2113, 64.142, 9.4246>, <-6.2113, 64.2104, 9.1284> }
					triangle { <-6.1998, 62.03402, 8.6661>, <-6.2687, 63.1316, 9.225>, <-6.2113, 64.142, 9.4246> }
					triangle { <-6.2113, 64.2104, 9.1284>, <-6.4311, 63.3147, 8.8513>, <-6.1998, 62.03402, 8.6661> }
					triangle { <-6.2687, 63.1316, 9.225>, <-5.8985, 64.1451, 9.5338>, <-6.2113, 64.142, 9.4246> }
					triangle { <-5.8985, 64.1451, 9.5338>, <-5.4532, 64.4141, 9.3789>, <-6.2113, 64.142, 9.4246> }
					triangle { <-6.2113, 64.2104, 9.1284>, <-6.06698, 64.4455, 8.8798>, <-6.4339, 64.2786, 8.9181> }
					triangle { <-6.4339, 64.2786, 8.9181>, <-6.4311, 63.3147, 8.8513>, <-6.2113, 64.2104, 9.1284> }
					triangle { <-5.4532, 64.4141, 9.3789>, <-5.5585, 64.466, 9.3479>, <-6.000774, 64.3751, 9.2071> }
					triangle { <-5.5585, 64.466, 9.3479>, <-5.2217, 64.4769, 8.9344>, <-5.8533, 64.5861, 8.8648> }
					triangle { <-6.000774, 64.3751, 9.2071>, <-5.8533, 64.5861, 8.8648>, <-6.06698, 64.4455, 8.8798> }
					triangle { <-6.000774, 64.3751, 9.2071>, <-5.5585, 64.466, 9.3479>, <-5.8533, 64.5861, 8.8648> }
					triangle { <-6.2113, 64.142, 9.4246>, <-5.4532, 64.4141, 9.3789>, <-6.000774, 64.3751, 9.2071> }
					triangle { <-6.2113, 64.2104, 9.1284>, <-6.000774, 64.3751, 9.2071>, <-6.06698, 64.4455, 8.8798> }
					triangle { <-6.2113, 64.142, 9.4246>, <-6.000774, 64.3751, 9.2071>, <-6.2113, 64.2104, 9.1284> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.1998, 62.03402, 8.6661>, <-6.3173, 64.2193, 9.1456>, <-6.603, 64.1889, 9.04645> }
					triangle { <-6.1998, 62.03402, 8.6661>, <-6.1357, 63.2102, 9.03274>, <-6.3173, 64.2193, 9.1456> }
					triangle { <-6.603, 64.1889, 9.04645>, <-6.5807, 63.2264, 9.06769>, <-6.1998, 62.03402, 8.6661> }
					triangle { <-6.1357, 63.2102, 9.03274>, <-6.1286, 64.3238, 8.894>, <-6.3173, 64.2193, 9.1456> }
					triangle { <-6.1286, 64.3238, 8.894>, <-6.231, 64.6191, 8.4502>, <-6.3173, 64.2193, 9.1456> }
					triangle { <-6.603, 64.1889, 9.04645>, <-6.8654, 64.3586, 8.8456>, <-6.8799, 64.1375, 9.1847> }
					triangle { <-6.8799, 64.1375, 9.1847>, <-6.5807, 63.2264, 9.06769>, <-6.603, 64.1889, 9.04645> }
					triangle { <-6.231, 64.6191, 8.4502>, <-6.309, 64.6347, 8.5419>, <-6.5317, 64.4112, 8.8942> }
					triangle { <-6.309, 64.6347, 8.5419>, <-6.5755, 64.5863, 8.08242>, <-6.8666, 64.5296, 8.655> }
					triangle { <-6.5317, 64.4112, 8.8942>, <-6.8666, 64.5296, 8.655>, <-6.8654, 64.3586, 8.8456> }
					triangle { <-6.5317, 64.4112, 8.8942>, <-6.309, 64.6347, 8.5419>, <-6.8666, 64.5296, 8.655> }
					triangle { <-6.3173, 64.2193, 9.1456>, <-6.231, 64.6191, 8.4502>, <-6.5317, 64.4112, 8.8942> }
					triangle { <-6.603, 64.1889, 9.04645>, <-6.5317, 64.4112, 8.8942>, <-6.8654, 64.3586, 8.8456> }
					triangle { <-6.3173, 64.2193, 9.1456>, <-6.5317, 64.4112, 8.8942>, <-6.603, 64.1889, 9.04645> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-5.8831, 60.4292, 8.01054>, <-6.02842, 60.7392, 8.2033>, 0.2183 }
			cylinder { <-6.02842, 60.7392, 8.2033>, <-6.1997, 61.03685, 8.394>, 0.2183 }
			cylinder { <-6.1997, 61.03685, 8.394>, <-6.3962, 61.3205, 8.5817>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-6.3962, 61.3205, 8.5817>, <-6.7388, 61.7146, 8.8548>, 0.2183 }
				cylinder { <-6.7388, 61.7146, 8.8548>, <-7.1259, 62.07359, 9.1168>, 0.2183 }
				cylinder { <-7.1259, 62.07359, 9.1168>, <-7.5537, 62.3938, 9.3651>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-7.5537, 62.3938, 9.3651>, <-9.1563, 63.4489, 10.5096>, <-8.942, 63.6604, 10.5449> }
					triangle { <-7.5537, 62.3938, 9.3651>, <-8.5435, 62.8809, 9.9096>, <-9.1563, 63.4489, 10.5096> }
					triangle { <-8.942, 63.6604, 10.5449>, <-8.3675, 63.2883, 9.8713>, <-7.5537, 62.3938, 9.3651> }
					triangle { <-8.5435, 62.8809, 9.9096>, <-9.1523, 63.2497, 10.7732>, <-9.1563, 63.4489, 10.5096> }
					triangle { <-9.1523, 63.2497, 10.7732>, <-9.01094, 63.3223, 11.2907>, <-9.1563, 63.4489, 10.5096> }
					triangle { <-8.942, 63.6604, 10.5449>, <-8.7994, 63.8966, 10.792>, <-8.867, 63.9244, 10.3947> }
					triangle { <-8.867, 63.9244, 10.3947>, <-8.3675, 63.2883, 9.8713>, <-8.942, 63.6604, 10.5449> }
					triangle { <-9.01094, 63.3223, 11.2907>, <-9.0414, 63.423, 11.2308>, <-9.01846, 63.6367, 10.8111> }
					triangle { <-9.0414, 63.423, 11.2308>, <-8.5998, 63.5074, 11.5152>, <-8.7861, 63.9067, 11.04691> }
					triangle { <-9.01846, 63.6367, 10.8111>, <-8.7861, 63.9067, 11.04691>, <-8.7994, 63.8966, 10.792> }
					triangle { <-9.01846, 63.6367, 10.8111>, <-9.0414, 63.423, 11.2308>, <-8.7861, 63.9067, 11.04691> }
					triangle { <-9.1563, 63.4489, 10.5096>, <-9.01094, 63.3223, 11.2907>, <-9.01846, 63.6367, 10.8111> }
					triangle { <-8.942, 63.6604, 10.5449>, <-9.01846, 63.6367, 10.8111>, <-8.7994, 63.8966, 10.792> }
					triangle { <-9.1563, 63.4489, 10.5096>, <-9.01846, 63.6367, 10.8111>, <-8.942, 63.6604, 10.5449> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-7.5537, 62.3938, 9.3651>, <-8.9939, 63.7001, 10.4655>, <-8.9802, 63.8669, 10.2127> }
					triangle { <-7.5537, 62.3938, 9.3651>, <-8.3825, 62.9782, 10.06167>, <-8.9939, 63.7001, 10.4655> }
					triangle { <-8.9802, 63.8669, 10.2127>, <-8.5487, 63.1788, 9.7003>, <-7.5537, 62.3938, 9.3651> }
					triangle { <-8.3825, 62.9782, 10.06167>, <-8.7769, 63.8209, 10.6834>, <-8.9939, 63.7001, 10.4655> }
					triangle { <-8.7769, 63.8209, 10.6834>, <-8.5718, 64.3147, 10.7675>, <-8.9939, 63.7001, 10.4655> }
					triangle { <-8.9802, 63.8669, 10.2127>, <-8.9669, 64.2164, 10.09118>, <-9.1527, 63.8858, 9.9524> }
					triangle { <-9.1527, 63.8858, 9.9524>, <-8.5487, 63.1788, 9.7003>, <-8.9802, 63.8669, 10.2127> }
					triangle { <-8.5718, 64.3147, 10.7675>, <-8.6782, 64.3121, 10.71>, <-8.9346, 64.07012, 10.3967> }
					triangle { <-8.6782, 64.3121, 10.71>, <-8.3496, 64.6536, 10.4684>, <-8.8866, 64.4391, 10.1871> }
					triangle { <-8.9346, 64.07012, 10.3967>, <-8.8866, 64.4391, 10.1871>, <-8.9669, 64.2164, 10.09118> }
					triangle { <-8.9346, 64.07012, 10.3967>, <-8.6782, 64.3121, 10.71>, <-8.8866, 64.4391, 10.1871> }
					triangle { <-8.9939, 63.7001, 10.4655>, <-8.5718, 64.3147, 10.7675>, <-8.9346, 64.07012, 10.3967> }
					triangle { <-8.9802, 63.8669, 10.2127>, <-8.9346, 64.07012, 10.3967>, <-8.9669, 64.2164, 10.09118> }
					triangle { <-8.9939, 63.7001, 10.4655>, <-8.9346, 64.07012, 10.3967>, <-8.9802, 63.8669, 10.2127> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-7.5537, 62.3938, 9.3651>, <-9.06629, 63.8134, 10.1947>, <-9.2462, 63.6873, 9.9859> }
					triangle { <-7.5537, 62.3938, 9.3651>, <-8.2925, 63.1779, 9.9592>, <-9.06629, 63.8134, 10.1947> }
					triangle { <-9.2462, 63.6873, 9.9859>, <-8.6499, 62.9541, 9.8156>, <-7.5537, 62.3938, 9.3651> }
					triangle { <-8.2925, 63.1779, 9.9592>, <-8.9341, 64.08844, 10.06783>, <-9.06629, 63.8134, 10.1947> }
					triangle { <-8.9341, 64.08844, 10.06783>, <-9.1011, 64.4411, 9.6927>, <-9.06629, 63.8134, 10.1947> }
					triangle { <-9.2462, 63.6873, 9.9859>, <-9.509, 63.7666, 9.7372>, <-9.4551, 63.4544, 9.9877> }
					triangle { <-9.4551, 63.4544, 9.9877>, <-8.6499, 62.9541, 9.8156>, <-9.2462, 63.6873, 9.9859> }
					triangle { <-9.1011, 64.4411, 9.6927>, <-9.1888, 64.3772, 9.7463>, <-9.2954, 63.9539, 9.9247> }
					triangle { <-9.1888, 64.3772, 9.7463>, <-9.2699, 64.3916, 9.2207>, <-9.5748, 63.9733, 9.6022> }
					triangle { <-9.2954, 63.9539, 9.9247>, <-9.5748, 63.9733, 9.6022>, <-9.509, 63.7666, 9.7372> }
					triangle { <-9.2954, 63.9539, 9.9247>, <-9.1888, 64.3772, 9.7463>, <-9.5748, 63.9733, 9.6022> }
					triangle { <-9.06629, 63.8134, 10.1947>, <-9.1011, 64.4411, 9.6927>, <-9.2954, 63.9539, 9.9247> }
					triangle { <-9.2462, 63.6873, 9.9859>, <-9.2954, 63.9539, 9.9247>, <-9.509, 63.7666, 9.7372> }
					triangle { <-9.06629, 63.8134, 10.1947>, <-9.2954, 63.9539, 9.9247>, <-9.2462, 63.6873, 9.9859> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-7.5537, 62.3938, 9.3651>, <-9.274, 63.6333, 10.069>, <-9.3749, 63.3682, 10.1758> }
					triangle { <-7.5537, 62.3938, 9.3651>, <-8.3971, 63.2059, 9.7429>, <-9.274, 63.6333, 10.069> }
					triangle { <-9.3749, 63.3682, 10.1758>, <-8.5323, 62.9226, 10.05896>, <-7.5537, 62.3938, 9.3651> }
					triangle { <-8.3971, 63.2059, 9.7429>, <-9.4081, 63.685, 9.7714>, <-9.274, 63.6333, 10.069> }
					triangle { <-9.4081, 63.685, 9.7714>, <-9.8723, 63.528, 9.5415>, <-9.274, 63.6333, 10.069> }
					triangle { <-9.3749, 63.3682, 10.1758>, <-9.6817, 63.1646, 10.216>, <-9.3591, 63.2224, 10.4521> }
					triangle { <-9.3591, 63.2224, 10.4521>, <-8.5323, 62.9226, 10.05896>, <-9.3749, 63.3682, 10.1758> }
					triangle { <-9.8723, 63.528, 9.5415>, <-9.8723, 63.529, 9.6625>, <-9.6057, 63.4477, 10.04301> }
					triangle { <-9.8723, 63.529, 9.6625>, <-10.09755, 63.08107, 9.4848>, <-9.9061, 63.1485, 10.09504> }
					triangle { <-9.6057, 63.4477, 10.04301>, <-9.9061, 63.1485, 10.09504>, <-9.6817, 63.1646, 10.216> }
					triangle { <-9.6057, 63.4477, 10.04301>, <-9.8723, 63.529, 9.6625>, <-9.9061, 63.1485, 10.09504> }
					triangle { <-9.274, 63.6333, 10.069>, <-9.8723, 63.528, 9.5415>, <-9.6057, 63.4477, 10.04301> }
					triangle { <-9.3749, 63.3682, 10.1758>, <-9.6057, 63.4477, 10.04301>, <-9.6817, 63.1646, 10.216> }
					triangle { <-9.274, 63.6333, 10.069>, <-9.6057, 63.4477, 10.04301>, <-9.3749, 63.3682, 10.1758> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-7.5537, 62.3938, 9.3651>, <-9.3305, 63.4046, 10.2665>, <-9.184, 63.3513, 10.5265> }
					triangle { <-7.5537, 62.3938, 9.3651>, <-8.5546, 63.01962, 9.7118>, <-9.3305, 63.4046, 10.2665> }
					triangle { <-9.184, 63.3513, 10.5265>, <-8.3551, 63.1322, 10.0939>, <-7.5537, 62.3938, 9.3651> }
					triangle { <-8.5546, 63.01962, 9.7118>, <-9.545, 63.1588, 10.2139>, <-9.3305, 63.4046, 10.2665> }
					triangle { <-9.545, 63.1588, 10.2139>, <-9.8157, 62.8261, 10.544>, <-9.3305, 63.4046, 10.2665> }
					triangle { <-9.184, 63.3513, 10.5265>, <-9.2365, 63.2461, 10.8777>, <-8.9902, 63.5173, 10.7075> }
					triangle { <-8.9902, 63.5173, 10.7075>, <-8.3551, 63.1322, 10.0939>, <-9.184, 63.3513, 10.5265> }
					triangle { <-9.8157, 62.8261, 10.544>, <-9.7798, 62.9303, 10.5939>, <-9.4319, 63.2487, 10.599> }
					triangle { <-9.7798, 62.9303, 10.5939>, <-9.6771, 62.5263, 10.9243>, <-9.4113, 63.1067, 11.00136> }
					triangle { <-9.4319, 63.2487, 10.599>, <-9.4113, 63.1067, 11.00136>, <-9.2365, 63.2461, 10.8777> }
					triangle { <-9.4319, 63.2487, 10.599>, <-9.7798, 62.9303, 10.5939>, <-9.4113, 63.1067, 11.00136> }
					triangle { <-9.3305, 63.4046, 10.2665>, <-9.8157, 62.8261, 10.544>, <-9.4319, 63.2487, 10.599> }
					triangle { <-9.184, 63.3513, 10.5265>, <-9.4319, 63.2487, 10.599>, <-9.2365, 63.2461, 10.8777> }
					triangle { <-9.3305, 63.4046, 10.2665>, <-9.4319, 63.2487, 10.599>, <-9.184, 63.3513, 10.5265> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-3.4233, 56.1103, 4.9133>, <-3.703, 56.3411, 5.06443>, 0.2183 }
			cylinder { <-3.703, 56.3411, 5.06443>, <-3.9962, 56.5706, 5.1898>, 0.2183 }
			cylinder { <-3.9962, 56.5706, 5.1898>, <-4.3012, 56.7975, 5.2891>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <-4.3012, 56.7975, 5.2891>, <-4.6383, 56.9961, 5.3239>, 0.2183 }
			cylinder { <-4.6383, 56.9961, 5.3239>, <-4.9786, 57.1827, 5.3849>, 0.2183 }
			cylinder { <-4.9786, 57.1827, 5.3849>, <-5.3202, 57.3562, 5.4716>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-5.3202, 57.3562, 5.4716>, <-5.831, 57.5882, 5.6522>, 0.2183 }
				cylinder { <-5.831, 57.5882, 5.6522>, <-6.3351, 57.7896, 5.8814>, 0.2183 }
				cylinder { <-6.3351, 57.7896, 5.8814>, <-6.8278, 57.9586, 6.157>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-6.8278, 57.9586, 6.157>, <-8.5468, 58.7632, 7.3355>, <-8.6146, 58.9015, 7.07451> }
					triangle { <-6.8278, 57.9586, 6.157>, <-7.7517, 58.2712, 6.9068>, <-8.5468, 58.7632, 7.3355> }
					triangle { <-8.6146, 58.9015, 7.07451>, <-8.007718, 58.3682, 6.5553>, <-6.8278, 57.9586, 6.157> }
					triangle { <-7.7517, 58.2712, 6.9068>, <-8.3708, 58.9712, 7.5225>, <-8.5468, 58.7632, 7.3355> }
					triangle { <-8.3708, 58.9712, 7.5225>, <-8.3508, 59.5109, 7.5584>, <-8.5468, 58.7632, 7.3355> }
					triangle { <-8.6146, 58.9015, 7.07451>, <-8.7377, 59.2213, 6.9341>, <-8.8029, 58.8357, 6.8334> }
					triangle { <-8.8029, 58.8357, 6.8334>, <-8.007718, 58.3682, 6.5553>, <-8.6146, 58.9015, 7.07451> }
					triangle { <-8.3508, 59.5109, 7.5584>, <-8.4535, 59.4659, 7.5128>, <-8.6302, 59.1229, 7.2417> }
					triangle { <-8.4535, 59.4659, 7.5128>, <-8.2904, 59.8791, 7.2201>, <-8.7353, 59.4655, 7.009358> }
					triangle { <-8.6302, 59.1229, 7.2417>, <-8.7353, 59.4655, 7.009358>, <-8.7377, 59.2213, 6.9341> }
					triangle { <-8.6302, 59.1229, 7.2417>, <-8.4535, 59.4659, 7.5128>, <-8.7353, 59.4655, 7.009358> }
					triangle { <-8.5468, 58.7632, 7.3355>, <-8.3508, 59.5109, 7.5584>, <-8.6302, 59.1229, 7.2417> }
					triangle { <-8.6146, 58.9015, 7.07451>, <-8.6302, 59.1229, 7.2417>, <-8.7377, 59.2213, 6.9341> }
					triangle { <-8.5468, 58.7632, 7.3355>, <-8.6302, 59.1229, 7.2417>, <-8.6146, 58.9015, 7.07451> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.8278, 57.9586, 6.157>, <-8.6768, 58.8197, 7.06857>, <-8.8158, 58.6207, 6.887> }
					triangle { <-6.8278, 57.9586, 6.157>, <-7.7482, 58.4801, 6.785>, <-8.6768, 58.8197, 7.06857> }
					triangle { <-8.8158, 58.6207, 6.887>, <-8.01171, 58.1331, 6.6923>, <-6.8278, 57.9586, 6.157> }
					triangle { <-7.7482, 58.4801, 6.785>, <-8.6631, 59.1116, 6.9141>, <-8.6768, 58.8197, 7.06857> }
					triangle { <-8.6631, 59.1116, 6.9141>, <-8.9756, 59.3487, 6.5412>, <-8.6768, 58.8197, 7.06857> }
					triangle { <-8.8158, 58.6207, 6.887>, <-9.1087, 58.5803, 6.664>, <-8.926, 58.3302, 6.9232> }
					triangle { <-8.926, 58.3302, 6.9232>, <-8.01171, 58.1331, 6.6923>, <-8.8158, 58.6207, 6.887> }
					triangle { <-8.9756, 59.3487, 6.5412>, <-9.0299, 59.263, 6.6071>, <-8.9623, 58.8464, 6.8177> }
					triangle { <-9.0299, 59.263, 6.6071>, <-9.1531, 59.2022, 6.09323>, <-9.2551, 58.7379, 6.5263> }
					triangle { <-8.9623, 58.8464, 6.8177>, <-9.2551, 58.7379, 6.5263>, <-9.1087, 58.5803, 6.664> }
					triangle { <-8.9623, 58.8464, 6.8177>, <-9.0299, 59.263, 6.6071>, <-9.2551, 58.7379, 6.5263> }
					triangle { <-8.6768, 58.8197, 7.06857>, <-8.9756, 59.3487, 6.5412>, <-8.9623, 58.8464, 6.8177> }
					triangle { <-8.8158, 58.6207, 6.887>, <-8.9623, 58.8464, 6.8177>, <-9.1087, 58.5803, 6.664> }
					triangle { <-8.6768, 58.8197, 7.06857>, <-8.9623, 58.8464, 6.8177>, <-8.8158, 58.6207, 6.887> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.8278, 57.9586, 6.157>, <-8.8154, 58.5678, 6.9752>, <-8.8052, 58.2944, 7.1059> }
					triangle { <-6.8278, 57.9586, 6.157>, <-7.873, 58.4506, 6.58>, <-8.8154, 58.5678, 6.9752> }
					triangle { <-8.8052, 58.2944, 7.1059>, <-7.8712, 58.1664, 6.923>, <-6.8278, 57.9586, 6.157> }
					triangle { <-7.873, 58.4506, 6.58>, <-8.9828, 58.5428, 6.6914>, <-8.8154, 58.5678, 6.9752> }
					triangle { <-8.9828, 58.5428, 6.6914>, <-9.3765, 58.2129, 6.521>, <-8.8154, 58.5678, 6.9752> }
					triangle { <-8.8052, 58.2944, 7.1059>, <-9.01395, 58.00009, 7.1891>, <-8.7157, 58.1881, 7.3862> }
					triangle { <-8.7157, 58.1881, 7.3862>, <-7.8712, 58.1664, 6.923>, <-8.8052, 58.2944, 7.1059> }
					triangle { <-9.3765, 58.2129, 6.521>, <-9.3671, 58.2243, 6.6411>, <-9.05919, 58.2756, 6.9945> }
					triangle { <-9.3671, 58.2243, 6.6411>, <-9.4298, 57.7121, 6.512>, <-9.2266, 57.8954, 7.09388> }
					triangle { <-9.05919, 58.2756, 6.9945>, <-9.2266, 57.8954, 7.09388>, <-9.01395, 58.00009, 7.1891> }
					triangle { <-9.05919, 58.2756, 6.9945>, <-9.3671, 58.2243, 6.6411>, <-9.2266, 57.8954, 7.09388> }
					triangle { <-8.8154, 58.5678, 6.9752>, <-9.3765, 58.2129, 6.521>, <-9.05919, 58.2756, 6.9945> }
					triangle { <-8.8052, 58.2944, 7.1059>, <-9.05919, 58.2756, 6.9945>, <-9.01395, 58.00009, 7.1891> }
					triangle { <-8.8154, 58.5678, 6.9752>, <-9.05919, 58.2756, 6.9945>, <-8.8052, 58.2944, 7.1059> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.8278, 57.9586, 6.157>, <-8.7724, 58.3531, 7.1837>, <-8.5974, 58.3705, 7.4306> }
					triangle { <-6.8278, 57.9586, 6.157>, <-7.9549, 58.2231, 6.5731>, <-8.7724, 58.3531, 7.1837> }
					triangle { <-8.5974, 58.3705, 7.4306>, <-7.7791, 58.4223, 6.9307>, <-6.8278, 57.9586, 6.157> }
					triangle { <-7.9549, 58.2231, 6.5731>, <-8.8911, 58.04569, 7.1601>, <-8.7724, 58.3531, 7.1837> }
					triangle { <-8.8911, 58.04569, 7.1601>, <-9.003304, 57.6624, 7.5255>, <-8.7724, 58.3531, 7.1837> }
					triangle { <-8.5974, 58.3705, 7.4306>, <-8.5834, 58.277, 7.7887>, <-8.4606, 58.6045, 7.5869> }
					triangle { <-8.4606, 58.6045, 7.5869>, <-7.7791, 58.4223, 6.9307>, <-8.5974, 58.3705, 7.4306> }
					triangle { <-9.003304, 57.6624, 7.5255>, <-9.002351, 57.7757, 7.5681>, <-8.7878, 58.1939, 7.5295> }
					triangle { <-9.002351, 57.7757, 7.5681>, <-8.7408, 57.4542, 7.9016>, <-8.6889, 58.09441, 7.9329> }
					triangle { <-8.7878, 58.1939, 7.5295>, <-8.6889, 58.09441, 7.9329>, <-8.5834, 58.277, 7.7887> }
					triangle { <-8.7878, 58.1939, 7.5295>, <-9.002351, 57.7757, 7.5681>, <-8.6889, 58.09441, 7.9329> }
					triangle { <-8.7724, 58.3531, 7.1837>, <-9.003304, 57.6624, 7.5255>, <-8.7878, 58.1939, 7.5295> }
					triangle { <-8.5974, 58.3705, 7.4306>, <-8.7878, 58.1939, 7.5295>, <-8.5834, 58.277, 7.7887> }
					triangle { <-8.7724, 58.3531, 7.1837>, <-8.7878, 58.1939, 7.5295>, <-8.5974, 58.3705, 7.4306> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.8278, 57.9586, 6.157>, <-8.6039, 58.4757, 7.4098>, <-8.4778, 58.7514, 7.4109> }
					triangle { <-6.8278, 57.9586, 6.157>, <-7.8788, 58.1106, 6.7781>, <-8.6039, 58.4757, 7.4098> }
					triangle { <-8.4778, 58.7514, 7.4109>, <-7.8647, 58.5489, 6.7001>, <-6.8278, 57.9586, 6.157> }
					triangle { <-7.8788, 58.1106, 6.7781>, <-8.5072, 58.3144, 7.6815>, <-8.6039, 58.4757, 7.4098> }
					triangle { <-8.5072, 58.3144, 7.6815>, <-8.3598, 58.4768, 8.1763>, <-8.6039, 58.4757, 7.4098> }
					triangle { <-8.4778, 58.7514, 7.4109>, <-8.4101, 59.04322, 7.6287>, <-8.5153, 59.01082, 7.2401> }
					triangle { <-8.5153, 59.01082, 7.2401>, <-7.8647, 58.5489, 6.7001>, <-8.4778, 58.7514, 7.4109> }
					triangle { <-8.3598, 58.4768, 8.1763>, <-8.4291, 58.5546, 8.1149>, <-8.5187, 58.7255, 7.6846> }
					triangle { <-8.4291, 58.5546, 8.1149>, <-8.02597, 58.8137, 8.3458>, <-8.3807, 59.0794, 7.8799> }
					triangle { <-8.5187, 58.7255, 7.6846>, <-8.3807, 59.0794, 7.8799>, <-8.4101, 59.04322, 7.6287> }
					triangle { <-8.5187, 58.7255, 7.6846>, <-8.4291, 58.5546, 8.1149>, <-8.3807, 59.0794, 7.8799> }
					triangle { <-8.6039, 58.4757, 7.4098>, <-8.3598, 58.4768, 8.1763>, <-8.5187, 58.7255, 7.6846> }
					triangle { <-8.4778, 58.7514, 7.4109>, <-8.5187, 58.7255, 7.6846>, <-8.4101, 59.04322, 7.6287> }
					triangle { <-8.6039, 58.4757, 7.4098>, <-8.5187, 58.7255, 7.6846>, <-8.4778, 58.7514, 7.4109> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-4.3012, 56.7975, 5.2891>, <-4.5621, 57.04395, 5.4487>, 0.2183 }
			cylinder { <-4.5621, 57.04395, 5.4487>, <-4.8232, 57.3048, 5.5834>, 0.2183 }
			cylinder { <-4.8232, 57.3048, 5.5834>, <-5.08297, 57.5787, 5.6922>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-5.08297, 57.5787, 5.6922>, <-5.4666, 58.01223, 5.8026>, 0.2183 }
				cylinder { <-5.4666, 58.01223, 5.8026>, <-5.8405, 58.4641, 5.8591>, 0.2183 }
				cylinder { <-5.8405, 58.4641, 5.8591>, <-6.2012, 58.9301, 5.861>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-6.2012, 58.9301, 5.861>, <-7.7376, 60.5477, 5.7414>, <-7.7732, 60.4863, 6.03615> }
					triangle { <-6.2012, 58.9301, 5.861>, <-6.9651, 59.8733, 5.6603>, <-7.7376, 60.5477, 5.7414> }
					triangle { <-7.7732, 60.4863, 6.03615>, <-6.9669, 59.968, 6.09559>, <-6.2012, 58.9301, 5.861> }
					triangle { <-6.9651, 59.8733, 5.6603>, <-7.9613, 60.3752, 5.57>, <-7.7376, 60.5477, 5.7414> }
					triangle { <-7.9613, 60.3752, 5.57>, <-8.4553, 60.1881, 5.6882>, <-7.7376, 60.5477, 5.7414> }
					triangle { <-7.7732, 60.4863, 6.03615>, <-8.0303, 60.4493, 6.3001>, <-7.6583, 60.6067, 6.301> }
					triangle { <-7.6583, 60.6067, 6.301>, <-6.9669, 59.968, 6.09559>, <-7.7732, 60.4863, 6.03615> }
					triangle { <-8.4553, 60.1881, 5.6882>, <-8.4181, 60.2818, 5.7552>, <-8.04053, 60.4754, 5.9609> }
					triangle { <-8.4181, 60.2818, 5.7552>, <-8.6404, 59.9127, 6.0672>, <-8.2782, 60.3879, 6.3048> }
					triangle { <-8.04053, 60.4754, 5.9609>, <-8.2782, 60.3879, 6.3048>, <-8.0303, 60.4493, 6.3001> }
					triangle { <-8.04053, 60.4754, 5.9609>, <-8.4181, 60.2818, 5.7552>, <-8.2782, 60.3879, 6.3048> }
					triangle { <-7.7376, 60.5477, 5.7414>, <-8.4553, 60.1881, 5.6882>, <-8.04053, 60.4754, 5.9609> }
					triangle { <-7.7732, 60.4863, 6.03615>, <-8.04053, 60.4754, 5.9609>, <-8.0303, 60.4493, 6.3001> }
					triangle { <-7.7376, 60.5477, 5.7414>, <-8.04053, 60.4754, 5.9609>, <-7.7732, 60.4863, 6.03615> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.2012, 58.9301, 5.861>, <-7.7103, 60.5675, 6.04188>, <-7.4892, 60.7054, 6.1966> }
					triangle { <-6.2012, 58.9301, 5.861>, <-7.104, 59.7651, 5.8261>, <-7.7103, 60.5675, 6.04188> }
					triangle { <-7.4892, 60.7054, 6.1966>, <-6.8106, 60.08984, 5.909>, <-6.2012, 58.9301, 5.861> }
					triangle { <-7.104, 59.7651, 5.8261>, <-7.9087, 60.4131, 6.2563>, <-7.7103, 60.5675, 6.04188> }
					triangle { <-7.9087, 60.4131, 6.2563>, <-8.03932, 60.5056, 6.7734>, <-7.7103, 60.5675, 6.04188> }
					triangle { <-7.4892, 60.7054, 6.1966>, <-7.4257, 60.9165, 6.4943>, <-7.2654, 60.9115, 6.1235> }
					triangle { <-7.2654, 60.9115, 6.1235>, <-6.8106, 60.08984, 5.909>, <-7.4892, 60.7054, 6.1966> }
					triangle { <-8.03932, 60.5056, 6.7734>, <-7.9993, 60.6021, 6.7121>, <-7.6945, 60.7415, 6.3804> }
					triangle { <-7.9993, 60.6021, 6.7121>, <-7.7686, 60.5829, 7.1911>, <-7.5431, 60.9552, 6.7178> }
					triangle { <-7.6945, 60.7415, 6.3804>, <-7.5431, 60.9552, 6.7178>, <-7.4257, 60.9165, 6.4943> }
					triangle { <-7.6945, 60.7415, 6.3804>, <-7.9993, 60.6021, 6.7121>, <-7.5431, 60.9552, 6.7178> }
					triangle { <-7.7103, 60.5675, 6.04188>, <-8.03932, 60.5056, 6.7734>, <-7.6945, 60.7415, 6.3804> }
					triangle { <-7.4892, 60.7054, 6.1966>, <-7.6945, 60.7415, 6.3804>, <-7.4257, 60.9165, 6.4943> }
					triangle { <-7.7103, 60.5675, 6.04188>, <-7.6945, 60.7415, 6.3804>, <-7.4892, 60.7054, 6.1966> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.2012, 58.9301, 5.861>, <-7.4762, 60.7484, 6.1041>, <-7.2802, 60.8684, 5.9064> }
					triangle { <-6.2012, 58.9301, 5.861>, <-7.02282, 59.8271, 6.04533>, <-7.4762, 60.7484, 6.1041> }
					triangle { <-7.2802, 60.8684, 5.9064>, <-6.902, 60.02012, 5.6624>, <-6.2012, 58.9301, 5.861> }
					triangle { <-7.02282, 59.8271, 6.04533>, <-7.3769, 60.8241, 6.4101>, <-7.4762, 60.7484, 6.1041> }
					triangle { <-7.3769, 60.8241, 6.4101>, <-7.09506, 61.2372, 6.6169>, <-7.4762, 60.7484, 6.1041> }
					triangle { <-7.2802, 60.8684, 5.9064>, <-7.09175, 61.1778, 5.8297>, <-7.2764, 60.9052, 5.5957> }
					triangle { <-7.2764, 60.9052, 5.5957>, <-6.902, 60.02012, 5.6624>, <-7.2802, 60.8684, 5.9064> }
					triangle { <-7.09506, 61.2372, 6.6169>, <-7.1505, 61.26, 6.5117>, <-7.2718, 61.06993, 6.09762> }
					triangle { <-7.1505, 61.26, 6.5117>, <-6.6534, 61.4491, 6.4995>, <-7.004221, 61.3755, 5.9657> }
					triangle { <-7.2718, 61.06993, 6.09762>, <-7.004221, 61.3755, 5.9657>, <-7.09175, 61.1778, 5.8297> }
					triangle { <-7.2718, 61.06993, 6.09762>, <-7.1505, 61.26, 6.5117>, <-7.004221, 61.3755, 5.9657> }
					triangle { <-7.4762, 60.7484, 6.1041>, <-7.09506, 61.2372, 6.6169>, <-7.2718, 61.06993, 6.09762> }
					triangle { <-7.2802, 60.8684, 5.9064>, <-7.2718, 61.06993, 6.09762>, <-7.09175, 61.1778, 5.8297> }
					triangle { <-7.4762, 60.7484, 6.1041>, <-7.2718, 61.06993, 6.09762>, <-7.2802, 60.8684, 5.9064> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.2012, 58.9301, 5.861>, <-7.3567, 60.8421, 5.8427>, <-7.4331, 60.7514, 5.5637> }
					triangle { <-6.2012, 58.9301, 5.861>, <-6.8329, 59.9742, 6.01708>, <-7.3567, 60.8421, 5.8427> }
					triangle { <-7.4331, 60.7514, 5.5637>, <-7.1156, 59.8546, 5.6942>, <-6.2012, 58.9301, 5.861> }
					triangle { <-6.8329, 59.9742, 6.01708>, <-7.09605, 61.04402, 5.8202>, <-7.3567, 60.8421, 5.8427> }
					triangle { <-7.09605, 61.04402, 5.8202>, <-6.9186, 61.3787, 5.4336>, <-7.3567, 60.8421, 5.8427> }
					triangle { <-7.4331, 60.7514, 5.5637>, <-7.4868, 60.8745, 5.2186>, <-7.6762, 60.5964, 5.4421> }
					triangle { <-7.6762, 60.5964, 5.4421>, <-7.1156, 59.8546, 5.6942>, <-7.4331, 60.7514, 5.5637> }
					triangle { <-6.9186, 61.3787, 5.4336>, <-7.03674, 61.3526, 5.4291>, <-7.3526, 61.00986, 5.5006> }
					triangle { <-7.03674, 61.3526, 5.4291>, <-6.8255, 61.3223, 4.9418>, <-7.4012, 61.07191, 5.08086> }
					triangle { <-7.3526, 61.00986, 5.5006>, <-7.4012, 61.07191, 5.08086>, <-7.4868, 60.8745, 5.2186> }
					triangle { <-7.3526, 61.00986, 5.5006>, <-7.03674, 61.3526, 5.4291>, <-7.4012, 61.07191, 5.08086> }
					triangle { <-7.3567, 60.8421, 5.8427>, <-6.9186, 61.3787, 5.4336>, <-7.3526, 61.00986, 5.5006> }
					triangle { <-7.4331, 60.7514, 5.5637>, <-7.3526, 61.00986, 5.5006>, <-7.4868, 60.8745, 5.2186> }
					triangle { <-7.3567, 60.8421, 5.8427>, <-7.3526, 61.00986, 5.5006>, <-7.4331, 60.7514, 5.5637> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-6.2012, 58.9301, 5.861>, <-7.5206, 60.7161, 5.6152>, <-7.7424, 60.5117, 5.6451> }
					triangle { <-6.2012, 58.9301, 5.861>, <-6.7967, 60.00323, 5.7755>, <-7.5206, 60.7161, 5.6152> }
					triangle { <-7.7424, 60.5117, 5.6451>, <-7.1563, 59.8219, 5.9659>, <-6.2012, 58.9301, 5.861> }
					triangle { <-6.7967, 60.00323, 5.7755>, <-7.4626, 60.7624, 5.2931>, <-7.5206, 60.7161, 5.6152> }
					triangle { <-7.4626, 60.7624, 5.2931>, <-7.772, 60.7205, 4.851>, <-7.5206, 60.7161, 5.6152> }
					triangle { <-7.7424, 60.5117, 5.6451>, <-8.07563, 60.4175, 5.5137>, <-7.9157, 60.4091, 5.8845> }
					triangle { <-7.9157, 60.4091, 5.8845>, <-7.1563, 59.8219, 5.9659>, <-7.7424, 60.5117, 5.6451> }
					triangle { <-7.772, 60.7205, 4.851>, <-7.832, 60.7389, 4.9545>, <-7.8348, 60.6369, 5.4149> }
					triangle { <-7.832, 60.7389, 4.9545>, <-8.07209, 60.3585, 4.6705>, <-8.2004, 60.4523, 5.2936> }
					triangle { <-7.8348, 60.6369, 5.4149>, <-8.2004, 60.4523, 5.2936>, <-8.07563, 60.4175, 5.5137> }
					triangle { <-7.8348, 60.6369, 5.4149>, <-7.832, 60.7389, 4.9545>, <-8.2004, 60.4523, 5.2936> }
					triangle { <-7.5206, 60.7161, 5.6152>, <-7.772, 60.7205, 4.851>, <-7.8348, 60.6369, 5.4149> }
					triangle { <-7.7424, 60.5117, 5.6451>, <-7.8348, 60.6369, 5.4149>, <-8.07563, 60.4175, 5.5137> }
					triangle { <-7.5206, 60.7161, 5.6152>, <-7.8348, 60.6369, 5.4149>, <-7.7424, 60.5117, 5.6451> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		}
	union { // internode
		cylinder { <-0.4868, 52.2186, 2.8126>, <-0.7011, 55.4354, 3.8087>, 0.5 }
		cylinder { <-0.7011, 55.4354, 3.8087>, <-0.2673, 58.5909, 4.9222>, 0.5 }
		cylinder { <-0.2673, 58.5909, 4.9222>, <0.7978, 61.5639, 6.1104>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.7978, 61.5639, 6.1104>, <1.7267, 62.6406, 6.6558>, 0.4836 }
			cylinder { <1.7267, 62.6406, 6.6558>, <2.9951, 63.3263, 7.1464>, 0.4836 }
			cylinder { <2.9951, 63.3263, 7.1464>, <4.4547, 63.5407, 7.525>, 0.4836 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <4.4547, 63.5407, 7.525>, <5.06773, 63.6307, 7.6841>, 0.4836 }
				cylinder { <5.06773, 63.6307, 7.6841>, <5.6807, 63.7207, 7.8431>, 0.4836 }
				cylinder { <5.6807, 63.7207, 7.8431>, <6.2937, 63.8108, 8.002135>, 0.4836 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <6.2937, 63.8108, 8.002135>, <6.3976, 63.8182, 8.05726>, 0.03742 }
				cylinder { <6.3976, 63.8182, 8.05726>, <6.4862, 63.8161, 8.1349>, 0.03742 }
				cylinder { <6.4862, 63.8161, 8.1349>, <6.5543, 63.8045, 8.2304>, 0.03742 }
				texture{chif1}}
			mesh { // leaf
				triangle { <6.5543, 63.8045, 8.2304>, <9.9566, 62.8994, 12.5903>, <9.618, 62.7339, 12.8758> }
				triangle { <9.9566, 62.8994, 12.5903>, <10.8337, 60.7757, 13.1249>, <9.618, 62.7339, 12.8758> }
				triangle { <9.9566, 62.8994, 12.5903>, <10.9994, 61.2983, 12.8126>, <10.8337, 60.7757, 13.1249> }
				triangle { <10.8337, 60.7757, 13.1249>, <10.2265, 61.124, 13.342>, <9.618, 62.7339, 12.8758> }
				triangle { <9.618, 62.7339, 12.8758>, <8.2632, 62.8217, 11.08139>, <6.5543, 63.8045, 8.2304> }
				triangle { <6.5543, 63.8045, 8.2304>, <8.9423, 63.00931, 10.6203>, <9.9566, 62.8994, 12.5903> }
				triangle { <8.9423, 63.00931, 10.6203>, <10.4065, 62.4844, 12.09059>, <9.9566, 62.8994, 12.5903> }
				triangle { <10.4065, 62.4844, 12.09059>, <10.9994, 61.2983, 12.8126>, <9.9566, 62.8994, 12.5903> }
				triangle { <9.618, 62.7339, 12.8758>, <10.2265, 61.124, 13.342>, <9.4434, 61.9567, 12.9058> }
				triangle { <9.4434, 61.9567, 12.9058>, <8.2632, 62.8217, 11.08139>, <9.618, 62.7339, 12.8758> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <6.2937, 63.8108, 8.002135>, <6.4067, 63.8274, 8.03143>, 0.03742 }
				cylinder { <6.4067, 63.8274, 8.03143>, <6.5196, 63.844, 8.06072>, 0.03742 }
				cylinder { <6.5196, 63.844, 8.06072>, <6.6325, 63.8606, 8.09002>, 0.03742 }
				texture{chif1}}
			mesh { // leaf
				triangle { <6.6325, 63.8606, 8.09002>, <12.09539, 64.2904, 9.2634>, <12.05499, 64.145, 9.7116> }
				triangle { <12.09539, 64.2904, 9.2634>, <13.566, 62.4458, 9.26>, <12.05499, 64.145, 9.7116> }
				triangle { <12.09539, 64.2904, 9.2634>, <13.3791, 62.9109, 8.8769>, <13.566, 62.4458, 9.26> }
				triangle { <13.566, 62.4458, 9.26>, <13.1651, 62.752, 9.7917>, <12.05499, 64.145, 9.7116> }
				triangle { <12.05499, 64.145, 9.7116>, <9.9051, 63.6973, 9.2204>, <6.6325, 63.8606, 8.09002> }
				triangle { <6.6325, 63.8606, 8.09002>, <10.08797, 63.8712, 8.4171>, <12.09539, 64.2904, 9.2634> }
				triangle { <10.08797, 63.8712, 8.4171>, <12.218, 63.8424, 8.6241>, <12.09539, 64.2904, 9.2634> }
				triangle { <12.218, 63.8424, 8.6241>, <13.3791, 62.9109, 8.8769>, <12.09539, 64.2904, 9.2634> }
				triangle { <12.05499, 64.145, 9.7116>, <13.1651, 62.752, 9.7917>, <12.1179, 63.3744, 9.9053> }
				triangle { <12.1179, 63.3744, 9.9053>, <9.9051, 63.6973, 9.2204>, <12.05499, 64.145, 9.7116> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <0.7978, 61.5639, 6.1104>, <1.303, 62.546, 6.5354>, 0.1753 }
		cylinder { <1.303, 62.546, 6.5354>, <1.9323, 63.4527, 6.9622>, 0.1753 }
		cylinder { <1.9323, 63.4527, 6.9622>, <2.6761, 64.2705, 7.3846>, 0.1753 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.6761, 64.2705, 7.3846>, <2.7928, 64.3298, 7.4285>, 0.04386 }
			cylinder { <2.7928, 64.3298, 7.4285>, <2.9259, 64.346, 7.4619>, 0.04386 }
			cylinder { <2.9259, 64.346, 7.4619>, <3.05967, 64.3173, 7.481>, 0.04386 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <3.05967, 64.3173, 7.481>, <3.1158, 64.3052, 7.489>, 0.04386 }
				cylinder { <3.1158, 64.3052, 7.489>, <3.172, 64.2932, 7.497>, 0.04386 }
				cylinder { <3.172, 64.2932, 7.497>, <3.2282, 64.2811, 7.505>, 0.04386 }
				texture{chif1}}
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <2.6761, 64.2705, 7.3846>, <2.8922, 64.5501, 7.4947>, 0.2056 }
			cylinder { <2.8922, 64.5501, 7.4947>, <3.08976, 64.8507, 7.5819>, 0.2056 }
			cylinder { <3.08976, 64.8507, 7.5819>, <3.2667, 65.1696, 7.6453>, 0.2056 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <3.2667, 65.1696, 7.6453>, <3.4215, 65.5036, 7.6842>, 0.2056 }
			cylinder { <3.4215, 65.5036, 7.6842>, <3.5526, 65.8495, 7.6983>, 0.2056 }
			cylinder { <3.5526, 65.8495, 7.6983>, <3.6587, 66.2039, 7.6875>, 0.2056 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <3.6587, 66.2039, 7.6875>, <3.7673, 66.5569, 7.7128>, 0.2056 }
			cylinder { <3.7673, 66.5569, 7.7128>, <3.8774, 66.905, 7.7742>, 0.2056 }
			cylinder { <3.8774, 66.905, 7.7742>, <3.9878, 67.2448, 7.8709>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.9878, 67.2448, 7.8709>, <4.1519, 67.7321, 8.08027>, 0.2056 }
				cylinder { <4.1519, 67.7321, 8.08027>, <4.3121, 68.1898, 8.3507>, 0.2056 }
				cylinder { <4.3121, 68.1898, 8.3507>, <4.4659, 68.6109, 8.6783>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <4.4659, 68.6109, 8.6783>, <5.3202, 70.1986, 10.00824>, <5.3125, 70.3651, 9.754> }
					triangle { <4.4659, 68.6109, 8.6783>, <4.871, 69.3984, 9.5373>, <5.3202, 70.1986, 10.00824> }
					triangle { <5.3125, 70.3651, 9.754>, <4.7473, 69.7439, 9.2827>, <4.4659, 68.6109, 8.6783> }
					triangle { <4.871, 69.3984, 9.5373>, <5.622, 70.06517, 10.03816>, <5.3202, 70.1986, 10.00824> }
					triangle { <5.622, 70.06517, 10.03816>, <6.115, 70.2195, 9.8715>, <5.3202, 70.1986, 10.00824> }
					triangle { <5.3125, 70.3651, 9.754>, <5.5051, 70.6164, 9.5598>, <5.109, 70.5695, 9.6306> }
					triangle { <5.109, 70.5695, 9.6306>, <4.7473, 69.7439, 9.2827>, <5.3125, 70.3651, 9.754> }
					triangle { <6.115, 70.2195, 9.8715>, <6.03372, 70.3089, 9.8824>, <5.5765, 70.4165, 9.8271> }
					triangle { <6.03372, 70.3089, 9.8824>, <6.3023, 70.3622, 9.4246>, <5.7524, 70.6793, 9.5382> }
					triangle { <5.5765, 70.4165, 9.8271>, <5.7524, 70.6793, 9.5382>, <5.5051, 70.6164, 9.5598> }
					triangle { <5.5765, 70.4165, 9.8271>, <6.03372, 70.3089, 9.8824>, <5.7524, 70.6793, 9.5382> }
					triangle { <5.3202, 70.1986, 10.00824>, <6.115, 70.2195, 9.8715>, <5.5765, 70.4165, 9.8271> }
					triangle { <5.3125, 70.3651, 9.754>, <5.5765, 70.4165, 9.8271>, <5.5051, 70.6164, 9.5598> }
					triangle { <5.3202, 70.1986, 10.00824>, <5.5765, 70.4165, 9.8271>, <5.3125, 70.3651, 9.754> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.4659, 68.6109, 8.6783>, <5.225, 70.3962, 9.7989>, <4.9414, 70.4975, 9.7579> }
					triangle { <4.4659, 68.6109, 8.6783>, <5.001549, 69.4921, 9.3556>, <5.225, 70.3962, 9.7989> }
					triangle { <4.9414, 70.4975, 9.7579>, <4.6005, 69.6385, 9.4871>, <4.4659, 68.6109, 8.6783> }
					triangle { <5.001549, 69.4921, 9.3556>, <5.416, 70.5155, 9.5558>, <5.225, 70.3962, 9.7989> }
					triangle { <5.416, 70.5155, 9.5558>, <5.3937, 70.9648, 9.252>, <5.225, 70.3962, 9.7989> }
					triangle { <4.9414, 70.4975, 9.7579>, <4.7457, 70.8026, 9.6769>, <4.6791, 70.4935, 9.93> }
					triangle { <4.6791, 70.4935, 9.93>, <4.6005, 69.6385, 9.4871>, <4.9414, 70.4975, 9.7579> }
					triangle { <5.3937, 70.9648, 9.252>, <5.3358, 70.9713, 9.3585>, <5.07757, 70.7231, 9.6672> }
					triangle { <5.3358, 70.9713, 9.3585>, <5.03108, 71.1781, 8.9726>, <4.7922, 71.02052, 9.5504> }
					triangle { <5.07757, 70.7231, 9.6672>, <4.7922, 71.02052, 9.5504>, <4.7457, 70.8026, 9.6769> }
					triangle { <5.07757, 70.7231, 9.6672>, <5.3358, 70.9713, 9.3585>, <4.7922, 71.02052, 9.5504> }
					triangle { <5.225, 70.3962, 9.7989>, <5.3937, 70.9648, 9.252>, <5.07757, 70.7231, 9.6672> }
					triangle { <4.9414, 70.4975, 9.7579>, <5.07757, 70.7231, 9.6672>, <4.7457, 70.8026, 9.6769> }
					triangle { <5.225, 70.3962, 9.7989>, <5.07757, 70.7231, 9.6672>, <4.9414, 70.4975, 9.7579> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.4659, 68.6109, 8.6783>, <4.9337, 70.4599, 9.8537>, <4.7536, 70.33, 10.06137> }
					triangle { <4.4659, 68.6109, 8.6783>, <4.8591, 69.6423, 9.2292>, <4.9337, 70.4599, 9.8537> }
					triangle { <4.7536, 70.33, 10.06137>, <4.7607, 69.4695, 9.6292>, <4.4659, 68.6109, 8.6783> }
					triangle { <4.8591, 69.6423, 9.2292>, <4.7518, 70.6683, 9.6713>, <4.9337, 70.4599, 9.8537> }
					triangle { <4.7518, 70.6683, 9.6713>, <4.3038, 70.9574, 9.7731>, <4.9337, 70.4599, 9.8537> }
					triangle { <4.7536, 70.33, 10.06137>, <4.4875, 70.4048, 10.3094>, <4.8024, 70.1501, 10.3136> }
					triangle { <4.8024, 70.1501, 10.3136>, <4.7607, 69.4695, 9.6292>, <4.7536, 70.33, 10.06137> }
					triangle { <4.3038, 70.9574, 9.7731>, <4.3685, 70.9259, 9.8708>, <4.6341, 70.5818, 10.05705> }
					triangle { <4.3685, 70.9259, 9.8708>, <3.8496, 70.8407, 9.9608>, <4.3087, 70.5863, 10.3355> }
					triangle { <4.6341, 70.5818, 10.05705>, <4.3087, 70.5863, 10.3355>, <4.4875, 70.4048, 10.3094> }
					triangle { <4.6341, 70.5818, 10.05705>, <4.3685, 70.9259, 9.8708>, <4.3087, 70.5863, 10.3355> }
					triangle { <4.9337, 70.4599, 9.8537>, <4.3038, 70.9574, 9.7731>, <4.6341, 70.5818, 10.05705> }
					triangle { <4.7536, 70.33, 10.06137>, <4.6341, 70.5818, 10.05705>, <4.4875, 70.4048, 10.3094> }
					triangle { <4.9337, 70.4599, 9.8537>, <4.6341, 70.5818, 10.05705>, <4.7536, 70.33, 10.06137> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.4659, 68.6109, 8.6783>, <4.8462, 70.3023, 10.09749>, <5.007059, 70.09261, 10.2477> }
					triangle { <4.4659, 68.6109, 8.6783>, <4.6393, 69.6429, 9.3317>, <4.8462, 70.3023, 10.09749> }
					triangle { <5.007059, 70.09261, 10.2477>, <5.008071, 69.4688, 9.514>, <4.4659, 68.6109, 8.6783> }
					triangle { <4.6393, 69.6429, 9.3317>, <4.541, 70.3136, 10.2261>, <4.8462, 70.3023, 10.09749> }
					triangle { <4.541, 70.3136, 10.2261>, <4.3413, 70.2074, 10.7195>, <4.8462, 70.3023, 10.09749> }
					triangle { <5.007059, 70.09261, 10.2477>, <5.08495, 69.9691, 10.5891>, <5.3098, 70.0106, 10.2548> }
					triangle { <5.3098, 70.0106, 10.2548>, <5.008071, 69.4688, 9.514>, <5.007059, 70.09261, 10.2477> }
					triangle { <4.3413, 70.2074, 10.7195>, <4.4595, 70.235, 10.7163>, <4.8549, 70.1865, 10.4614> }
					triangle { <4.4595, 70.235, 10.7163>, <4.3797, 69.8131, 11.03289>, <4.9656, 69.9728, 10.8158> }
					triangle { <4.8549, 70.1865, 10.4614>, <4.9656, 69.9728, 10.8158>, <5.08495, 69.9691, 10.5891> }
					triangle { <4.8549, 70.1865, 10.4614>, <4.4595, 70.235, 10.7163>, <4.9656, 69.9728, 10.8158> }
					triangle { <4.8462, 70.3023, 10.09749>, <4.3413, 70.2074, 10.7195>, <4.8549, 70.1865, 10.4614> }
					triangle { <5.007059, 70.09261, 10.2477>, <4.8549, 70.1865, 10.4614>, <5.08495, 69.9691, 10.5891> }
					triangle { <4.8462, 70.3023, 10.09749>, <4.8549, 70.1865, 10.4614>, <5.007059, 70.09261, 10.2477> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.4659, 68.6109, 8.6783>, <5.08869, 70.1383, 10.1944>, <5.3577, 70.1145, 10.05488> }
					triangle { <4.4659, 68.6109, 8.6783>, <4.6467, 69.4899, 9.5249>, <5.08869, 70.1383, 10.1944> }
					triangle { <5.3577, 70.1145, 10.05488>, <4.9996, 69.641, 9.2966>, <4.4659, 68.6109, 8.6783> }
					triangle { <4.6467, 69.4899, 9.5249>, <5.08704, 69.9353, 10.4562>, <5.08869, 70.1383, 10.1944> }
					triangle { <5.08704, 69.9353, 10.4562>, <5.4776, 69.7445, 10.7812>, <5.08869, 70.1383, 10.1944> }
					triangle { <5.3577, 70.1145, 10.05488>, <5.7233, 70.1018, 10.1189>, <5.5021, 70.2737, 9.8263> }
					triangle { <5.5021, 70.2737, 9.8263>, <4.9996, 69.641, 9.2966>, <5.3577, 70.1145, 10.05488> }
					triangle { <5.4776, 69.7445, 10.7812>, <5.5041, 69.8479, 10.7235>, <5.4461, 70.08287, 10.3172> }
					triangle { <5.5041, 69.8479, 10.7235>, <5.9184, 69.513, 10.6965>, <5.8713, 70.0312, 10.3156> }
					triangle { <5.4461, 70.08287, 10.3172>, <5.8713, 70.0312, 10.3156>, <5.7233, 70.1018, 10.1189> }
					triangle { <5.4461, 70.08287, 10.3172>, <5.5041, 69.8479, 10.7235>, <5.8713, 70.0312, 10.3156> }
					triangle { <5.08869, 70.1383, 10.1944>, <5.4776, 69.7445, 10.7812>, <5.4461, 70.08287, 10.3172> }
					triangle { <5.3577, 70.1145, 10.05488>, <5.4461, 70.08287, 10.3172>, <5.7233, 70.1018, 10.1189> }
					triangle { <5.08869, 70.1383, 10.1944>, <5.4461, 70.08287, 10.3172>, <5.3577, 70.1145, 10.05488> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <3.9878, 67.2448, 7.8709>, <4.1211, 67.5833, 7.9393>, 0.2056 }
			cylinder { <4.1211, 67.5833, 7.9393>, <4.2759, 67.9171, 7.9789>, 0.2056 }
			cylinder { <4.2759, 67.9171, 7.9789>, <4.4508, 68.2432, 7.9893>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.4508, 68.2432, 7.9893>, <4.7471, 68.7111, 7.9497>, 0.2056 }
				cylinder { <4.7471, 68.7111, 7.9497>, <5.07302, 69.1507, 7.8558>, 0.2056 }
				cylinder { <5.07302, 69.1507, 7.8558>, <5.4235, 69.5555, 7.7088>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <5.4235, 69.5555, 7.7088>, <6.6604, 71.2483, 6.937>, <6.5718, 71.3829, 7.1938> }
					triangle { <5.4235, 69.5555, 7.7088>, <6.1836, 70.3734, 7.1922>, <6.6604, 71.2483, 6.937> }
					triangle { <6.5718, 71.3829, 7.1938>, <6.2444, 70.5703, 7.5871>, <5.4235, 69.5555, 7.7088> }
					triangle { <6.1836, 70.3734, 7.1922>, <6.4548, 71.3384, 6.6945>, <6.6604, 71.2483, 6.937> }
					triangle { <6.4548, 71.3384, 6.6945>, <6.1539, 71.78, 6.6083>, <6.6604, 71.2483, 6.937> }
					triangle { <6.5718, 71.3829, 7.1938>, <6.4597, 71.7074, 7.3325>, <6.6959, 71.4145, 7.4793> }
					triangle { <6.6959, 71.4145, 7.4793>, <6.2444, 70.5703, 7.5871>, <6.5718, 71.3829, 7.1938> }
					triangle { <6.1539, 71.78, 6.6083>, <6.2486, 71.7956, 6.6821>, <6.5068, 71.5876, 7.01752> }
					triangle { <6.2486, 71.7956, 6.6821>, <5.818, 72.03084, 6.8874>, <6.3441, 71.9149, 7.2385> }
					triangle { <6.5068, 71.5876, 7.01752>, <6.3441, 71.9149, 7.2385>, <6.4597, 71.7074, 7.3325> }
					triangle { <6.5068, 71.5876, 7.01752>, <6.2486, 71.7956, 6.6821>, <6.3441, 71.9149, 7.2385> }
					triangle { <6.6604, 71.2483, 6.937>, <6.1539, 71.78, 6.6083>, <6.5068, 71.5876, 7.01752> }
					triangle { <6.5718, 71.3829, 7.1938>, <6.5068, 71.5876, 7.01752>, <6.4597, 71.7074, 7.3325> }
					triangle { <6.6604, 71.2483, 6.937>, <6.5068, 71.5876, 7.01752>, <6.5718, 71.3829, 7.1938> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.4235, 69.5555, 7.7088>, <6.6645, 71.3484, 7.2223>, <6.8371, 71.246, 7.4495> }
					triangle { <5.4235, 69.5555, 7.7088>, <6.03559, 70.5373, 7.2906>, <6.6645, 71.3484, 7.2223> }
					triangle { <6.8371, 71.246, 7.4495>, <6.411, 70.3858, 7.4764>, <5.4235, 69.5555, 7.7088> }
					triangle { <6.03559, 70.5373, 7.2906>, <6.4548, 71.5737, 7.3425>, <6.6645, 71.3484, 7.2223> }
					triangle { <6.4548, 71.5737, 7.3425>, <6.4789, 71.917, 7.7603>, <6.6645, 71.3484, 7.2223> }
					triangle { <6.8371, 71.246, 7.4495>, <7.03546, 71.3574, 7.7418>, <7.09277, 71.06654, 7.4675> }
					triangle { <7.09277, 71.06654, 7.4675>, <6.411, 70.3858, 7.4764>, <6.8371, 71.246, 7.4495> }
					triangle { <6.4789, 71.917, 7.7603>, <6.5859, 71.8796, 7.7178>, <6.8132, 71.5097, 7.5338> }
					triangle { <6.5859, 71.8796, 7.7178>, <6.585, 71.8611, 8.2495>, <7.03098, 71.5595, 7.8978> }
					triangle { <6.8132, 71.5097, 7.5338>, <7.03098, 71.5595, 7.8978>, <7.03546, 71.3574, 7.7418> }
					triangle { <6.8132, 71.5097, 7.5338>, <6.5859, 71.8796, 7.7178>, <7.03098, 71.5595, 7.8978> }
					triangle { <6.6645, 71.3484, 7.2223>, <6.4789, 71.917, 7.7603>, <6.8132, 71.5097, 7.5338> }
					triangle { <6.8371, 71.246, 7.4495>, <6.8132, 71.5097, 7.5338>, <7.03546, 71.3574, 7.7418> }
					triangle { <6.6645, 71.3484, 7.2223>, <6.8132, 71.5097, 7.5338>, <6.8371, 71.246, 7.4495> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.4235, 69.5555, 7.7088>, <6.8884, 71.2077, 7.3689>, <7.06287, 70.9831, 7.264> }
					triangle { <5.4235, 69.5555, 7.7088>, <6.0985, 70.567, 7.5223>, <6.8884, 71.2077, 7.3689> }
					triangle { <7.06287, 70.9831, 7.264>, <6.3402, 70.3524, 7.2158>, <5.4235, 69.5555, 7.7088> }
					triangle { <6.0985, 70.567, 7.5223>, <6.9624, 71.259, 7.6868>, <6.8884, 71.2077, 7.3689> }
					triangle { <6.9624, 71.259, 7.6868>, <7.4125, 71.1876, 7.9789>, <6.8884, 71.2077, 7.3689> }
					triangle { <7.06287, 70.9831, 7.264>, <7.4112, 70.8575, 7.2618>, <7.1215, 70.8647, 6.9804> }
					triangle { <7.1215, 70.8647, 6.9804>, <6.3402, 70.3524, 7.2158>, <7.06287, 70.9831, 7.264> }
					triangle { <7.4125, 71.1876, 7.9789>, <7.4297, 71.2003, 7.8597>, <7.2471, 71.0988, 7.437> }
					triangle { <7.4297, 71.2003, 7.8597>, <7.7256, 70.7986, 8.04419>, <7.6134, 70.8801, 7.4163> }
					triangle { <7.2471, 71.0988, 7.437>, <7.6134, 70.8801, 7.4163>, <7.4112, 70.8575, 7.2618> }
					triangle { <7.2471, 71.0988, 7.437>, <7.4297, 71.2003, 7.8597>, <7.6134, 70.8801, 7.4163> }
					triangle { <6.8884, 71.2077, 7.3689>, <7.4125, 71.1876, 7.9789>, <7.2471, 71.0988, 7.437> }
					triangle { <7.06287, 70.9831, 7.264>, <7.2471, 71.0988, 7.437>, <7.4112, 70.8575, 7.2618> }
					triangle { <6.8884, 71.2077, 7.3689>, <7.2471, 71.0988, 7.437>, <7.06287, 70.9831, 7.264> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.4235, 69.5555, 7.7088>, <7.02474, 71.01946, 7.1756>, <6.9392, 70.9551, 6.892> }
					triangle { <5.4235, 69.5555, 7.7088>, <6.286, 70.4216, 7.5692>, <7.02474, 71.01946, 7.1756> }
					triangle { <6.9392, 70.9551, 6.892>, <6.1293, 70.516, 7.163>, <5.4235, 69.5555, 7.7088> }
					triangle { <6.286, 70.4216, 7.5692>, <7.2809, 70.8263, 7.2548>, <7.02474, 71.01946, 7.1756> }
					triangle { <7.2809, 70.8263, 7.2548>, <7.6733, 70.5931, 6.964>, <7.02474, 71.01946, 7.1756> }
					triangle { <6.9392, 70.9551, 6.892>, <7.0713, 70.894, 6.5514>, <6.7427, 71.08613, 6.6867> }
					triangle { <6.7427, 71.08613, 6.6867>, <6.1293, 70.516, 7.163>, <6.9392, 70.9551, 6.892> }
					triangle { <7.6733, 70.5931, 6.964>, <7.6218, 70.69, 6.913>, <7.2128, 70.9188, 6.86> }
					triangle { <7.6218, 70.69, 6.913>, <7.6742, 70.3016, 6.5533>, <7.292, 70.8093, 6.4548> }
					triangle { <7.2128, 70.9188, 6.86>, <7.292, 70.8093, 6.4548>, <7.0713, 70.894, 6.5514> }
					triangle { <7.2128, 70.9188, 6.86>, <7.6218, 70.69, 6.913>, <7.292, 70.8093, 6.4548> }
					triangle { <7.02474, 71.01946, 7.1756>, <7.6733, 70.5931, 6.964>, <7.2128, 70.9188, 6.86> }
					triangle { <6.9392, 70.9551, 6.892>, <7.2128, 70.9188, 6.86>, <7.0713, 70.894, 6.5514> }
					triangle { <7.02474, 71.01946, 7.1756>, <7.2128, 70.9188, 6.86>, <6.9392, 70.9551, 6.892> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.4235, 69.5555, 7.7088>, <6.8817, 71.04495, 6.9047>, <6.6312, 71.2059, 6.848> }
					triangle { <5.4235, 69.5555, 7.7088>, <6.3394, 70.3001, 7.3621>, <6.8817, 71.04495, 6.9047> }
					triangle { <6.6312, 71.2059, 6.848>, <6.06923, 70.6527, 7.396>, <5.4235, 69.5555, 7.7088> }
					triangle { <6.3394, 70.3001, 7.3621>, <6.9624, 70.8761, 6.6323>, <6.8817, 71.04495, 6.9047> }
					triangle { <6.9624, 70.8761, 6.6323>, <6.8837, 70.9648, 6.1042>, <6.8817, 71.04495, 6.9047> }
					triangle { <6.6312, 71.2059, 6.848>, <6.4743, 71.4272, 6.5958>, <6.4757, 71.431, 6.9997> }
					triangle { <6.4757, 71.431, 6.9997>, <6.06923, 70.6527, 7.396>, <6.6312, 71.2059, 6.848> }
					triangle { <6.8837, 70.9648, 6.1042>, <6.8809, 71.06354, 6.1741>, <6.7484, 71.2255, 6.5968> }
					triangle { <6.8809, 71.06354, 6.1741>, <6.4774, 71.07472, 5.8276>, <6.4957, 71.4585, 6.3432> }
					triangle { <6.7484, 71.2255, 6.5968>, <6.4957, 71.4585, 6.3432>, <6.4743, 71.4272, 6.5958> }
					triangle { <6.7484, 71.2255, 6.5968>, <6.8809, 71.06354, 6.1741>, <6.4957, 71.4585, 6.3432> }
					triangle { <6.8817, 71.04495, 6.9047>, <6.8837, 70.9648, 6.1042>, <6.7484, 71.2255, 6.5968> }
					triangle { <6.6312, 71.2059, 6.848>, <6.7484, 71.2255, 6.5968>, <6.4743, 71.4272, 6.5958> }
					triangle { <6.8817, 71.04495, 6.9047>, <6.7484, 71.2255, 6.5968>, <6.6312, 71.2059, 6.848> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <4.4508, 68.2432, 7.9893>, <4.5934, 68.5844, 8.006979>, 0.2056 }
			cylinder { <4.5934, 68.5844, 8.006979>, <4.7024, 68.9372, 8.0318>, 0.2056 }
			cylinder { <4.7024, 68.9372, 8.0318>, <4.7767, 69.2985, 8.06354>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.7767, 69.2985, 8.06354>, <4.8218, 69.8486, 8.1234>, 0.2056 }
				cylinder { <4.8218, 69.8486, 8.1234>, <4.7997, 70.3988, 8.1948>, 0.2056 }
				cylinder { <4.7997, 70.3988, 8.1948>, <4.7108, 70.9408, 8.2765>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <4.7108, 70.9408, 8.2765>, <4.3536, 73.0681, 8.8581>, <4.6437, 73.1015, 8.7767> }
					triangle { <4.7108, 70.9408, 8.2765>, <4.3527, 72.08003, 8.5722>, <4.3536, 73.0681, 8.8581> }
					triangle { <4.6437, 73.1015, 8.7767>, <4.6888, 72.2502, 8.3344>, <4.7108, 70.9408, 8.2765> }
					triangle { <4.3527, 72.08003, 8.5722>, <4.3409, 73.01684, 9.1843>, <4.3536, 73.0681, 8.8581> }
					triangle { <4.3409, 73.01684, 9.1843>, <4.6596, 73.1657, 9.5957>, <4.3536, 73.0681, 8.8581> }
					triangle { <4.6437, 73.1015, 8.7767>, <4.9588, 73.2708, 8.8727>, <4.7894, 73.1913, 8.5148> }
					triangle { <4.7894, 73.1913, 8.5148>, <4.6888, 72.2502, 8.3344>, <4.6437, 73.1015, 8.7767> }
					triangle { <4.6596, 73.1657, 9.5957>, <4.6675, 73.2347, 9.4966>, <4.6579, 73.2249, 9.0253> }
					triangle { <4.6675, 73.2347, 9.4966>, <5.1543, 73.1279, 9.6826>, <5.0579, 73.36, 9.0907> }
					triangle { <4.6579, 73.2249, 9.0253>, <5.0579, 73.36, 9.0907>, <4.9588, 73.2708, 8.8727> }
					triangle { <4.6579, 73.2249, 9.0253>, <4.6675, 73.2347, 9.4966>, <5.0579, 73.36, 9.0907> }
					triangle { <4.3536, 73.0681, 8.8581>, <4.6596, 73.1657, 9.5957>, <4.6579, 73.2249, 9.0253> }
					triangle { <4.6437, 73.1015, 8.7767>, <4.6579, 73.2249, 9.0253>, <4.9588, 73.2708, 8.8727> }
					triangle { <4.3536, 73.0681, 8.8581>, <4.6579, 73.2249, 9.0253>, <4.6437, 73.1015, 8.7767> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.7108, 70.9408, 8.2765>, <4.5969, 73.1332, 8.6907>, <4.6106, 73.1545, 8.3887> }
					triangle { <4.7108, 70.9408, 8.2765>, <4.5802, 72.1055, 8.6504>, <4.5969, 73.1332, 8.6907> }
					triangle { <4.6106, 73.1545, 8.3887>, <4.4329, 72.2216, 8.2464>, <4.7108, 70.9408, 8.2765> }
					triangle { <4.5802, 72.1055, 8.6504>, <4.9024, 73.1649, 8.8127>, <4.5969, 73.1332, 8.6907> }
					triangle { <4.9024, 73.1649, 8.8127>, <5.3458, 73.4223, 8.6394>, <4.5969, 73.1332, 8.6907> }
					triangle { <4.6106, 73.1545, 8.3887>, <4.7606, 73.3527, 8.1141>, <4.3982, 73.1805, 8.1604> }
					triangle { <4.3982, 73.1805, 8.1604>, <4.4329, 72.2216, 8.2464>, <4.6106, 73.1545, 8.3887> }
					triangle { <5.3458, 73.4223, 8.6394>, <5.2411, 73.4646, 8.5957>, <4.8111, 73.3367, 8.4503> }
					triangle { <5.2411, 73.4646, 8.5957>, <5.5981, 73.4237, 8.2034>, <4.9698, 73.4968, 8.08754> }
					triangle { <4.8111, 73.3367, 8.4503>, <4.9698, 73.4968, 8.08754>, <4.7606, 73.3527, 8.1141> }
					triangle { <4.8111, 73.3367, 8.4503>, <5.2411, 73.4646, 8.5957>, <4.9698, 73.4968, 8.08754> }
					triangle { <4.5969, 73.1332, 8.6907>, <5.3458, 73.4223, 8.6394>, <4.8111, 73.3367, 8.4503> }
					triangle { <4.6106, 73.1545, 8.3887>, <4.8111, 73.3367, 8.4503>, <4.7606, 73.3527, 8.1141> }
					triangle { <4.5969, 73.1332, 8.6907>, <4.8111, 73.3367, 8.4503>, <4.6106, 73.1545, 8.3887> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.7108, 70.9408, 8.2765>, <4.509, 73.1621, 8.4029>, <4.2331, 73.1075, 8.2896> }
					triangle { <4.7108, 70.9408, 8.2765>, <4.7205, 72.1572, 8.4603>, <4.509, 73.1621, 8.4029> }
					triangle { <4.2331, 73.1075, 8.2896>, <4.2751, 72.1634, 8.4602>, <4.7108, 70.9408, 8.2765> }
					triangle { <4.7205, 72.1572, 8.4603>, <4.7133, 73.2333, 8.1532>, <4.509, 73.1621, 8.4029> }
					triangle { <4.7133, 73.2333, 8.1532>, <4.6388, 73.4534, 7.6644>, <4.509, 73.1621, 8.4029> }
					triangle { <4.2331, 73.1075, 8.2896>, <3.9839, 73.2354, 8.04743>, <3.9485, 73.06867, 8.4136> }
					triangle { <3.9485, 73.06867, 8.4136>, <4.2751, 72.1634, 8.4602>, <4.2331, 73.1075, 8.2896> }
					triangle { <4.6388, 73.4534, 7.6644>, <4.554, 73.48, 7.7465>, <4.3107, 73.3058, 8.111> }
					triangle { <4.554, 73.48, 7.7465>, <4.3251, 73.3537, 7.2832>, <3.9934, 73.3749, 7.8336> }
					triangle { <4.3107, 73.3058, 8.111>, <3.9934, 73.3749, 7.8336>, <3.9839, 73.2354, 8.04743> }
					triangle { <4.3107, 73.3058, 8.111>, <4.554, 73.48, 7.7465>, <3.9934, 73.3749, 7.8336> }
					triangle { <4.509, 73.1621, 8.4029>, <4.6388, 73.4534, 7.6644>, <4.3107, 73.3058, 8.111> }
					triangle { <4.2331, 73.1075, 8.2896>, <4.3107, 73.3058, 8.111>, <3.9839, 73.2354, 8.04743> }
					triangle { <4.509, 73.1621, 8.4029>, <4.3107, 73.3058, 8.111>, <4.2331, 73.1075, 8.2896> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.7108, 70.9408, 8.2765>, <4.2106, 73.1152, 8.3897>, <4.02957, 73.02508, 8.6155> }
					triangle { <4.7108, 70.9408, 8.2765>, <4.5811, 72.1641, 8.2628>, <4.2106, 73.1152, 8.3897> }
					triangle { <4.02957, 73.02508, 8.6155>, <4.4319, 72.1557, 8.6824>, <4.7108, 70.9408, 8.2765> }
					triangle { <4.5811, 72.1641, 8.2628>, <4.03336, 73.1281, 8.1112>, <4.2106, 73.1152, 8.3897> }
					triangle { <4.03336, 73.1281, 8.1112>, <3.5091, 73.2162, 8.009083>, <4.2106, 73.1152, 8.3897> }
					triangle { <4.02957, 73.02508, 8.6155>, <3.6948, 73.07996, 8.7641>, <4.05774, 73.00922, 8.9267> }
					triangle { <4.05774, 73.00922, 8.9267>, <4.4319, 72.1557, 8.6824>, <4.02957, 73.02508, 8.6155> }
					triangle { <3.5091, 73.2162, 8.009083>, <3.5492, 73.2597, 8.1146>, <3.8436, 73.1746, 8.4731> }
					triangle { <3.5492, 73.2597, 8.1146>, <3.08272, 73.01402, 8.185>, <3.4688, 73.1617, 8.6775> }
					triangle { <3.8436, 73.1746, 8.4731>, <3.4688, 73.1617, 8.6775>, <3.6948, 73.07996, 8.7641> }
					triangle { <3.8436, 73.1746, 8.4731>, <3.5492, 73.2597, 8.1146>, <3.4688, 73.1617, 8.6775> }
					triangle { <4.2106, 73.1152, 8.3897>, <3.5091, 73.2162, 8.009083>, <3.8436, 73.1746, 8.4731> }
					triangle { <4.02957, 73.02508, 8.6155>, <3.8436, 73.1746, 8.4731>, <3.6948, 73.07996, 8.7641> }
					triangle { <4.2106, 73.1152, 8.3897>, <3.8436, 73.1746, 8.4731>, <4.02957, 73.02508, 8.6155> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.7108, 70.9408, 8.2765>, <4.1132, 73.05622, 8.6753>, <4.2871, 73.02126, 8.9211> }
					triangle { <4.7108, 70.9408, 8.2765>, <4.3504, 72.1157, 8.333>, <4.1132, 73.05622, 8.6753> }
					triangle { <4.2871, 73.02126, 8.9211>, <4.6914, 72.2101, 8.6035>, <4.7108, 70.9408, 8.2765> }
					triangle { <4.3504, 72.1157, 8.333>, <3.7997, 72.9923, 8.758>, <4.1132, 73.05622, 8.6753> }
					triangle { <3.7997, 72.9923, 8.758>, <3.5221, 73.0357, 9.2207>, <4.1132, 73.05622, 8.6753> }
					triangle { <4.2871, 73.02126, 8.9211>, <4.3064, 73.1022, 9.2819>, <4.5852, 73.08616, 8.9902> }
					triangle { <4.5852, 73.08616, 8.9902>, <4.6914, 72.2101, 8.6035>, <4.2871, 73.02126, 8.9211> }
					triangle { <3.5221, 73.0357, 9.2207>, <3.6204, 73.1059, 9.2126>, <4.06147, 73.1239, 9.04666> }
					triangle { <3.6204, 73.1059, 9.2126>, <3.6029, 72.8724, 9.6903>, <4.1366, 73.1523, 9.4661> }
					triangle { <4.06147, 73.1239, 9.04666>, <4.1366, 73.1523, 9.4661>, <4.3064, 73.1022, 9.2819> }
					triangle { <4.06147, 73.1239, 9.04666>, <3.6204, 73.1059, 9.2126>, <4.1366, 73.1523, 9.4661> }
					triangle { <4.1132, 73.05622, 8.6753>, <3.5221, 73.0357, 9.2207>, <4.06147, 73.1239, 9.04666> }
					triangle { <4.2871, 73.02126, 8.9211>, <4.06147, 73.1239, 9.04666>, <4.3064, 73.1022, 9.2819> }
					triangle { <4.1132, 73.05622, 8.6753>, <4.06147, 73.1239, 9.04666>, <4.2871, 73.02126, 8.9211> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <4.7767, 69.2985, 8.06354>, <4.8807, 69.6501, 8.1139>, 0.2056 }
			cylinder { <4.8807, 69.6501, 8.1139>, <5.0134, 69.9888, 8.1825>, 0.2056 }
			cylinder { <5.0134, 69.9888, 8.1825>, <5.1734, 70.3113, 8.2687>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <5.1734, 70.3113, 8.2687>, <5.4614, 70.7581, 8.429>, 0.2056 }
				cylinder { <5.4614, 70.7581, 8.429>, <5.7931, 71.1613, 8.618>, 0.2056 }
				cylinder { <5.7931, 71.1613, 8.618>, <6.1636, 71.5147, 8.8328>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <6.1636, 71.5147, 8.8328>, <7.7973, 72.8803, 9.49>, <7.6035, 73.09566, 9.4035> }
					triangle { <6.1636, 71.5147, 8.8328>, <7.1164, 72.1399, 9.2877>, <7.7973, 72.8803, 9.49> }
					triangle { <7.6035, 73.09566, 9.4035>, <6.8581, 72.4968, 9.3456>, <6.1636, 71.5147, 8.8328> }
					triangle { <7.1164, 72.1399, 9.2877>, <8.002703, 72.817, 9.2401>, <7.7973, 72.8803, 9.49> }
					triangle { <8.002703, 72.817, 9.2401>, <8.1883, 73.1145, 8.8296>, <7.7973, 72.8803, 9.49> }
					triangle { <7.6035, 73.09566, 9.4035>, <7.5849, 73.4219, 9.2313>, <7.3904, 73.2703, 9.5499> }
					triangle { <7.3904, 73.2703, 9.5499>, <6.8581, 72.4968, 9.3456>, <7.6035, 73.09566, 9.4035> }
					triangle { <8.1883, 73.1145, 8.8296>, <8.1501, 73.1771, 8.9255>, <7.827, 73.1867, 9.2672> }
					triangle { <8.1501, 73.1771, 8.9255>, <7.9661, 73.3984, 8.4797>, <7.7254, 73.5427, 9.05647> }
					triangle { <7.827, 73.1867, 9.2672>, <7.7254, 73.5427, 9.05647>, <7.5849, 73.4219, 9.2313> }
					triangle { <7.827, 73.1867, 9.2672>, <8.1501, 73.1771, 8.9255>, <7.7254, 73.5427, 9.05647> }
					triangle { <7.7973, 72.8803, 9.49>, <8.1883, 73.1145, 8.8296>, <7.827, 73.1867, 9.2672> }
					triangle { <7.6035, 73.09566, 9.4035>, <7.827, 73.1867, 9.2672>, <7.5849, 73.4219, 9.2313> }
					triangle { <7.7973, 72.8803, 9.49>, <7.827, 73.1867, 9.2672>, <7.6035, 73.09566, 9.4035> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.1636, 71.5147, 8.8328>, <7.585, 73.09405, 9.5044>, <7.381, 73.1339, 9.724> }
					triangle { <6.1636, 71.5147, 8.8328>, <7.06164, 72.3012, 9.1169>, <7.585, 73.09405, 9.5044> }
					triangle { <7.381, 73.1339, 9.724>, <6.9198, 72.3153, 9.5378>, <6.1636, 71.5147, 8.8328> }
					triangle { <7.06164, 72.3012, 9.1169>, <7.5216, 73.3079, 9.2618>, <7.585, 73.09405, 9.5044> }
					triangle { <7.5216, 73.3079, 9.2618>, <7.2932, 73.797, 9.2503>, <7.585, 73.09405, 9.5044> }
					triangle { <7.381, 73.1339, 9.724>, <7.2102, 73.3947, 9.9221>, <7.3503, 73.02895, 10.01629> }
					triangle { <7.3503, 73.02895, 10.01629>, <6.9198, 72.3153, 9.5378>, <7.381, 73.1339, 9.724> }
					triangle { <7.2932, 73.797, 9.2503>, <7.3397, 73.7643, 9.3568>, <7.4061, 73.3984, 9.6448> }
					triangle { <7.3397, 73.7643, 9.3568>, <6.8606, 73.981, 9.4274>, <7.1513, 73.64, 9.8862> }
					triangle { <7.4061, 73.3984, 9.6448>, <7.1513, 73.64, 9.8862>, <7.2102, 73.3947, 9.9221> }
					triangle { <7.4061, 73.3984, 9.6448>, <7.3397, 73.7643, 9.3568>, <7.1513, 73.64, 9.8862> }
					triangle { <7.585, 73.09405, 9.5044>, <7.2932, 73.797, 9.2503>, <7.4061, 73.3984, 9.6448> }
					triangle { <7.381, 73.1339, 9.724>, <7.4061, 73.3984, 9.6448>, <7.2102, 73.3947, 9.9221> }
					triangle { <7.585, 73.09405, 9.5044>, <7.4061, 73.3984, 9.6448>, <7.381, 73.1339, 9.724> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.1636, 71.5147, 8.8328>, <7.4487, 73.07397, 9.7726>, <7.4909, 72.8612, 9.9832> }
					triangle { <6.1636, 71.5147, 8.8328>, <6.8819, 72.4399, 9.1987>, <7.4487, 73.07397, 9.7726> }
					triangle { <7.4909, 72.8612, 9.9832>, <7.122, 72.1593, 9.4458>, <6.1636, 71.5147, 8.8328> }
					triangle { <6.8819, 72.4399, 9.1987>, <7.2035, 73.2714, 9.8703>, <7.4487, 73.07397, 9.7726> }
					triangle { <7.2035, 73.2714, 9.8703>, <7.01599, 73.4157, 10.3556>, <7.4487, 73.07397, 9.7726> }
					triangle { <7.4909, 72.8612, 9.9832>, <7.5202, 72.8109, 10.348>, <7.7083, 72.643, 10.03384> }
					triangle { <7.7083, 72.643, 10.03384>, <7.122, 72.1593, 9.4458>, <7.4909, 72.8612, 9.9832> }
					triangle { <7.01599, 73.4157, 10.3556>, <7.1305, 73.3775, 10.3539>, <7.4245, 73.07097, 10.1519> }
					triangle { <7.1305, 73.3775, 10.3539>, <6.8725, 73.1573, 10.7619>, <7.437, 72.9339, 10.5551> }
					triangle { <7.4245, 73.07097, 10.1519>, <7.437, 72.9339, 10.5551>, <7.5202, 72.8109, 10.348> }
					triangle { <7.4245, 73.07097, 10.1519>, <7.1305, 73.3775, 10.3539>, <7.437, 72.9339, 10.5551> }
					triangle { <7.4487, 73.07397, 9.7726>, <7.01599, 73.4157, 10.3556>, <7.4245, 73.07097, 10.1519> }
					triangle { <7.4909, 72.8612, 9.9832>, <7.4245, 73.07097, 10.1519>, <7.5202, 72.8109, 10.348> }
					triangle { <7.4487, 73.07397, 9.7726>, <7.4245, 73.07097, 10.1519>, <7.4909, 72.8612, 9.9832> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.1636, 71.5147, 8.8328>, <7.5753, 72.8476, 9.9265>, <7.7823, 72.6517, 9.8254> }
					triangle { <6.1636, 71.5147, 8.8328>, <6.824, 72.3656, 9.4207>, <7.5753, 72.8476, 9.9265> }
					triangle { <7.7823, 72.6517, 9.8254>, <7.1871, 72.2429, 9.196>, <6.1636, 71.5147, 8.8328> }
					triangle { <6.824, 72.3656, 9.4207>, <7.485, 72.7576, 10.2304>, <7.5753, 72.8476, 9.9265> }
					triangle { <7.485, 72.7576, 10.2304>, <7.7372, 72.494, 10.6284>, <7.5753, 72.8476, 9.9265> }
					triangle { <7.7823, 72.6517, 9.8254>, <8.08941, 72.4719, 9.9244>, <7.973, 72.6424, 9.5785> }
					triangle { <7.973, 72.6424, 9.5785>, <7.1871, 72.2429, 9.196>, <7.7823, 72.6517, 9.8254> }
					triangle { <7.7372, 72.494, 10.6284>, <7.8096, 72.5477, 10.5481>, <7.857, 72.6538, 10.09236> }
					triangle { <7.8096, 72.5477, 10.5481>, <7.9855, 72.05792, 10.6515>, <8.1904, 72.3937, 10.1449> }
					triangle { <7.857, 72.6538, 10.09236>, <8.1904, 72.3937, 10.1449>, <8.08941, 72.4719, 9.9244> }
					triangle { <7.857, 72.6538, 10.09236>, <7.8096, 72.5477, 10.5481>, <8.1904, 72.3937, 10.1449> }
					triangle { <7.5753, 72.8476, 9.9265>, <7.7372, 72.494, 10.6284>, <7.857, 72.6538, 10.09236> }
					triangle { <7.7823, 72.6517, 9.8254>, <7.857, 72.6538, 10.09236>, <8.08941, 72.4719, 9.9244> }
					triangle { <7.5753, 72.8476, 9.9265>, <7.857, 72.6538, 10.09236>, <7.7823, 72.6517, 9.8254> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.1636, 71.5147, 8.8328>, <7.7941, 72.7262, 9.7492>, <7.8529, 72.7988, 9.4616> }
					triangle { <6.1636, 71.5147, 8.8328>, <6.9711, 72.1774, 9.4766>, <7.7941, 72.7262, 9.7492> }
					triangle { <7.8529, 72.7988, 9.4616>, <7.02162, 72.4546, 9.1331>, <6.1636, 71.5147, 8.8328> }
					triangle { <6.9711, 72.1774, 9.4766>, <7.9863, 72.4725, 9.835>, <7.7941, 72.7262, 9.7492> }
					triangle { <7.9863, 72.4725, 9.835>, <8.4727, 72.3051, 9.671>, <7.7941, 72.7262, 9.7492> }
					triangle { <7.8529, 72.7988, 9.4616>, <8.1299, 72.8552, 9.2238>, <7.7735, 73.036, 9.2749> }
					triangle { <7.7735, 73.036, 9.2749>, <7.02162, 72.4546, 9.1331>, <7.8529, 72.7988, 9.4616> }
					triangle { <8.4727, 72.3051, 9.671>, <8.4493, 72.422, 9.652>, <8.1096, 72.7264, 9.5373> }
					triangle { <8.4493, 72.422, 9.652>, <8.6716, 72.2091, 9.2197>, <8.3712, 72.7757, 9.2047> }
					triangle { <8.1096, 72.7264, 9.5373>, <8.3712, 72.7757, 9.2047>, <8.1299, 72.8552, 9.2238> }
					triangle { <8.1096, 72.7264, 9.5373>, <8.4493, 72.422, 9.652>, <8.3712, 72.7757, 9.2047> }
					triangle { <7.7941, 72.7262, 9.7492>, <8.4727, 72.3051, 9.671>, <8.1096, 72.7264, 9.5373> }
					triangle { <7.8529, 72.7988, 9.4616>, <8.1096, 72.7264, 9.5373>, <8.1299, 72.8552, 9.2238> }
					triangle { <7.7941, 72.7262, 9.7492>, <8.1096, 72.7264, 9.5373>, <7.8529, 72.7988, 9.4616> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <2.6761, 64.2705, 7.3846>, <2.9031, 64.5118, 7.5495>, 0.2056 }
			cylinder { <2.9031, 64.5118, 7.5495>, <3.1225, 64.7364, 7.7457>, 0.2056 }
			cylinder { <3.1225, 64.7364, 7.7457>, <3.3319, 64.9419, 7.9713>, 0.2056 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <3.3319, 64.9419, 7.9713>, <3.5338, 65.08818, 8.2449>, 0.2056 }
			cylinder { <3.5338, 65.08818, 8.2449>, <3.7636, 65.2353, 8.4951>, 0.2056 }
			cylinder { <3.7636, 65.2353, 8.4951>, <4.01888, 65.3819, 8.7196>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.01888, 65.3819, 8.7196>, <4.4444, 65.5979, 9.003307>, 0.2056 }
				cylinder { <4.4444, 65.5979, 9.003307>, <4.9063, 65.8068, 9.2298>, 0.2056 }
				cylinder { <4.9063, 65.8068, 9.2298>, <5.3976, 66.00541, 9.3957>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <5.3976, 66.00541, 9.3957>, <7.3038, 67.02169, 9.943>, <7.1778, 67.03194, 10.2176> }
					triangle { <5.3976, 66.00541, 9.3957>, <6.5119, 66.4911, 9.5633>, <7.3038, 67.02169, 9.943> }
					triangle { <7.1778, 67.03194, 10.2176>, <6.4866, 66.4059, 9.9986>, <5.3976, 66.00541, 9.3957> }
					triangle { <6.5119, 66.4911, 9.5633>, <7.2413, 67.3057, 9.7879>, <7.3038, 67.02169, 9.943> }
					triangle { <7.2413, 67.3057, 9.7879>, <7.1538, 67.8098, 9.9605>, <7.3038, 67.02169, 9.943> }
					triangle { <7.1778, 67.03194, 10.2176>, <7.1355, 67.2493, 10.5133>, <7.1932, 66.8526, 10.4726> }
					triangle { <7.1932, 66.8526, 10.4726>, <6.4866, 66.4059, 9.9986>, <7.1778, 67.03194, 10.2176> }
					triangle { <7.1538, 67.8098, 9.9605>, <7.2148, 67.739, 10.03702>, <7.2512, 67.2985, 10.198> }
					triangle { <7.2148, 67.739, 10.03702>, <6.8419, 68.0102, 10.2996>, <7.1362, 67.5006, 10.5549> }
					triangle { <7.2512, 67.2985, 10.198>, <7.1362, 67.5006, 10.5549>, <7.1355, 67.2493, 10.5133> }
					triangle { <7.2512, 67.2985, 10.198>, <7.2148, 67.739, 10.03702>, <7.1362, 67.5006, 10.5549> }
					triangle { <7.3038, 67.02169, 9.943>, <7.1538, 67.8098, 9.9605>, <7.2512, 67.2985, 10.198> }
					triangle { <7.1778, 67.03194, 10.2176>, <7.2512, 67.2985, 10.198>, <7.1355, 67.2493, 10.5133> }
					triangle { <7.3038, 67.02169, 9.943>, <7.2512, 67.2985, 10.198>, <7.1778, 67.03194, 10.2176> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.3976, 66.00541, 9.3957>, <7.237, 66.9487, 10.2279>, <7.2722, 66.6791, 10.3602> }
					triangle { <5.3976, 66.00541, 9.3957>, <6.4007, 66.6302, 9.726>, <7.237, 66.9487, 10.2279> }
					triangle { <7.2722, 66.6791, 10.3602>, <6.6117, 66.2495, 9.8155>, <5.3976, 66.00541, 9.3957> }
					triangle { <6.4007, 66.6302, 9.726>, <7.08419, 67.1504, 10.4391>, <7.237, 66.9487, 10.2279> }
					triangle { <7.08419, 67.1504, 10.4391>, <7.06608, 67.1766, 10.9781>, <7.237, 66.9487, 10.2279> }
					triangle { <7.2722, 66.6791, 10.3602>, <7.3758, 66.5185, 10.6763>, <7.4301, 66.4194, 10.2896> }
					triangle { <7.4301, 66.4194, 10.2896>, <6.6117, 66.2495, 9.8155>, <7.2722, 66.6791, 10.3602> }
					triangle { <7.06608, 67.1766, 10.9781>, <7.1625, 67.1201, 10.9324>, <7.3067, 66.838, 10.5847> }
					triangle { <7.1625, 67.1201, 10.9324>, <6.9639, 66.8408, 11.3376>, <7.3813, 66.5879, 10.9214> }
					triangle { <7.3067, 66.838, 10.5847>, <7.3813, 66.5879, 10.9214>, <7.3758, 66.5185, 10.6763> }
					triangle { <7.3067, 66.838, 10.5847>, <7.1625, 67.1201, 10.9324>, <7.3813, 66.5879, 10.9214> }
					triangle { <7.237, 66.9487, 10.2279>, <7.06608, 67.1766, 10.9781>, <7.3067, 66.838, 10.5847> }
					triangle { <7.2722, 66.6791, 10.3602>, <7.3067, 66.838, 10.5847>, <7.3758, 66.5185, 10.6763> }
					triangle { <7.237, 66.9487, 10.2279>, <7.3067, 66.838, 10.5847>, <7.2722, 66.6791, 10.3602> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.3976, 66.00541, 9.3957>, <7.3335, 66.6676, 10.2786>, <7.4504, 66.4756, 10.07647> }
					triangle { <5.3976, 66.00541, 9.3957>, <6.3817, 66.5055, 9.9317>, <7.3335, 66.6676, 10.2786> }
					triangle { <7.4504, 66.4756, 10.07647>, <6.6331, 66.3897, 9.5842>, <5.3976, 66.00541, 9.3957> }
					triangle { <6.3817, 66.5055, 9.9317>, <7.3001, 66.51, 10.5662>, <7.3335, 66.6676, 10.2786> }
					triangle { <7.3001, 66.51, 10.5662>, <7.5638, 66.09826, 10.7951>, <7.3335, 66.6676, 10.2786> }
					triangle { <7.4504, 66.4756, 10.07647>, <7.7139, 66.2206, 10.0319>, <7.5653, 66.5045, 9.7877> }
					triangle { <7.5653, 66.5045, 9.7877>, <6.6331, 66.3897, 9.5842>, <7.4504, 66.4756, 10.07647> }
					triangle { <7.5638, 66.09826, 10.7951>, <7.6258, 66.1588, 10.7111>, <7.5861, 66.3845, 10.3003> }
					triangle { <7.6258, 66.1588, 10.7111>, <7.6866, 65.6366, 10.6394>, <7.8417, 66.06333, 10.1863> }
					triangle { <7.5861, 66.3845, 10.3003>, <7.8417, 66.06333, 10.1863>, <7.7139, 66.2206, 10.0319> }
					triangle { <7.5861, 66.3845, 10.3003>, <7.6258, 66.1588, 10.7111>, <7.8417, 66.06333, 10.1863> }
					triangle { <7.3335, 66.6676, 10.2786>, <7.5638, 66.09826, 10.7951>, <7.5861, 66.3845, 10.3003> }
					triangle { <7.4504, 66.4756, 10.07647>, <7.5861, 66.3845, 10.3003>, <7.7139, 66.2206, 10.0319> }
					triangle { <7.3335, 66.6676, 10.2786>, <7.5861, 66.3845, 10.3003>, <7.4504, 66.4756, 10.07647> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.3976, 66.00541, 9.3957>, <7.4608, 66.5641, 10.02567>, <7.4677, 66.7006, 9.7559> }
					triangle { <5.3976, 66.00541, 9.3957>, <6.4809, 66.2882, 9.898>, <7.4608, 66.5641, 10.02567> }
					triangle { <7.4677, 66.7006, 9.7559>, <6.5215, 66.6342, 9.6221>, <5.3976, 66.00541, 9.3957> }
					triangle { <6.4809, 66.2882, 9.898>, <7.5927, 66.2636, 9.9948>, <7.4608, 66.5641, 10.02567> }
					triangle { <7.5927, 66.2636, 9.9948>, <7.9638, 66.05495, 9.6628>, <7.4608, 66.5641, 10.02567> }
					triangle { <7.4677, 66.7006, 9.7559>, <7.6857, 66.7645, 9.4646>, <7.4131, 66.9911, 9.6559> }
					triangle { <7.4131, 66.9911, 9.6559>, <6.5215, 66.6342, 9.6221>, <7.4677, 66.7006, 9.7559> }
					triangle { <7.9638, 66.05495, 9.6628>, <7.9688, 66.1747, 9.6769>, <7.7059, 66.5604, 9.7352> }
					triangle { <7.9688, 66.1747, 9.6769>, <8.01795, 66.05058, 9.1633>, <7.8854, 66.6469, 9.3586> }
					triangle { <7.7059, 66.5604, 9.7352>, <7.8854, 66.6469, 9.3586>, <7.6857, 66.7645, 9.4646> }
					triangle { <7.7059, 66.5604, 9.7352>, <7.9688, 66.1747, 9.6769>, <7.8854, 66.6469, 9.3586> }
					triangle { <7.4608, 66.5641, 10.02567>, <7.9638, 66.05495, 9.6628>, <7.7059, 66.5604, 9.7352> }
					triangle { <7.4677, 66.7006, 9.7559>, <7.7059, 66.5604, 9.7352>, <7.6857, 66.7645, 9.4646> }
					triangle { <7.4608, 66.5641, 10.02567>, <7.7059, 66.5604, 9.7352>, <7.4677, 66.7006, 9.7559> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.3976, 66.00541, 9.3957>, <7.4422, 66.7862, 9.815>, <7.2966, 67.04968, 9.8445> }
					triangle { <5.3976, 66.00541, 9.3957>, <6.5626, 66.2792, 9.6668>, <7.4422, 66.7862, 9.815> }
					triangle { <7.2966, 67.04968, 9.8445>, <6.4295, 66.6443, 9.8821>, <5.3976, 66.00541, 9.3957> }
					triangle { <6.5626, 66.2792, 9.6668>, <7.5558, 66.7628, 9.5065>, <7.4422, 66.7862, 9.815> }
					triangle { <7.5558, 66.7628, 9.5065>, <7.7066, 67.1287, 9.1392>, <7.4422, 66.7862, 9.815> }
					triangle { <7.2966, 67.04968, 9.8445>, <7.3228, 67.4098, 9.7667>, <7.1796, 67.2095, 10.08564> }
					triangle { <7.1796, 67.2095, 10.08564>, <6.4295, 66.6443, 9.8821>, <7.2966, 67.04968, 9.8445> }
					triangle { <7.7066, 67.1287, 9.1392>, <7.7109, 67.166, 9.2539>, <7.4958, 67.1338, 9.671> }
					triangle { <7.7109, 67.166, 9.2539>, <7.488, 67.5396, 8.9502>, <7.4427, 67.5487, 9.5899> }
					triangle { <7.4958, 67.1338, 9.671>, <7.4427, 67.5487, 9.5899>, <7.3228, 67.4098, 9.7667> }
					triangle { <7.4958, 67.1338, 9.671>, <7.7109, 67.166, 9.2539>, <7.4427, 67.5487, 9.5899> }
					triangle { <7.4422, 66.7862, 9.815>, <7.7066, 67.1287, 9.1392>, <7.4958, 67.1338, 9.671> }
					triangle { <7.2966, 67.04968, 9.8445>, <7.4958, 67.1338, 9.671>, <7.3228, 67.4098, 9.7667> }
					triangle { <7.4422, 66.7862, 9.815>, <7.4958, 67.1338, 9.671>, <7.2966, 67.04968, 9.8445> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <3.3319, 64.9419, 7.9713>, <3.5398, 65.1981, 8.1392>, 0.2056 }
			cylinder { <3.5398, 65.1981, 8.1392>, <3.7222, 65.4555, 8.3328>, 0.2056 }
			cylinder { <3.7222, 65.4555, 8.3328>, <3.8773, 65.7117, 8.5504>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.8773, 65.7117, 8.5504>, <4.05567, 66.08849, 8.9172>, 0.2056 }
				cylinder { <4.05567, 66.08849, 8.9172>, <4.177, 66.4521, 9.3189>, 0.2056 }
				cylinder { <4.177, 66.4521, 9.3189>, <4.2395, 66.7971, 9.7494>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <4.2395, 66.7971, 9.7494>, <4.5699, 67.9762, 11.6112>, <4.8111, 68.07905, 11.4606> }
					triangle { <4.2395, 66.7971, 9.7494>, <4.2595, 67.4248, 10.8036>, <4.5699, 67.9762, 11.6112> }
					triangle { <4.8111, 68.07905, 11.4606>, <4.5153, 67.7361, 10.6165>, <4.2395, 66.7971, 9.7494> }
					triangle { <4.2595, 67.4248, 10.8036>, <4.664, 67.7232, 11.8003>, <4.5699, 67.9762, 11.6112> }
					triangle { <4.664, 67.7232, 11.8003>, <5.1313, 67.5919, 12.03683>, <4.5699, 67.9762, 11.6112> }
					triangle { <4.8111, 68.07905, 11.4606>, <5.1669, 68.1693, 11.5025>, <4.8687, 68.33, 11.2843> }
					triangle { <4.8687, 68.33, 11.2843>, <4.5153, 67.7361, 10.6165>, <4.8111, 68.07905, 11.4606> }
					triangle { <5.1313, 67.5919, 12.03683>, <5.1176, 67.7091, 12.01129>, <4.9387, 68.00976, 11.6968> }
					triangle { <5.1176, 67.7091, 12.01129>, <5.6033, 67.5486, 11.8701>, <5.3533, 68.1016, 11.6625> }
					triangle { <4.9387, 68.00976, 11.6968>, <5.3533, 68.1016, 11.6625>, <5.1669, 68.1693, 11.5025> }
					triangle { <4.9387, 68.00976, 11.6968>, <5.1176, 67.7091, 12.01129>, <5.3533, 68.1016, 11.6625> }
					triangle { <4.5699, 67.9762, 11.6112>, <5.1313, 67.5919, 12.03683>, <4.9387, 68.00976, 11.6968> }
					triangle { <4.8111, 68.07905, 11.4606>, <4.9387, 68.00976, 11.6968>, <5.1669, 68.1693, 11.5025> }
					triangle { <4.5699, 67.9762, 11.6112>, <4.9387, 68.00976, 11.6968>, <4.8111, 68.07905, 11.4606> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.2395, 66.7971, 9.7494>, <4.7446, 68.155, 11.4425>, <4.6537, 68.37, 11.2503> }
					triangle { <4.2395, 66.7971, 9.7494>, <4.4991, 67.4118, 10.7792>, <4.7446, 68.155, 11.4425> }
					triangle { <4.6537, 68.37, 11.2503>, <4.2457, 67.7508, 10.644>, <4.2395, 66.7971, 9.7494> }
					triangle { <4.4991, 67.4118, 10.7792>, <5.07202, 68.1247, 11.4193>, <4.7446, 68.155, 11.4425> }
					triangle { <5.07202, 68.1247, 11.4193>, <5.4666, 68.4681, 11.2859>, <4.7446, 68.155, 11.4425> }
					triangle { <4.6537, 68.37, 11.2503>, <4.7335, 68.7106, 11.1317>, <4.385, 68.521, 11.2015> }
					triangle { <4.385, 68.521, 11.2015>, <4.2457, 67.7508, 10.644>, <4.6537, 68.37, 11.2503> }
					triangle { <5.4666, 68.4681, 11.2859>, <5.365, 68.5195, 11.3259>, <4.896, 68.4828, 11.3239> }
					triangle { <5.365, 68.5195, 11.3259>, <5.5403, 68.776, 10.8958>, <4.9442, 68.8534, 11.1194> }
					triangle { <4.896, 68.4828, 11.3239>, <4.9442, 68.8534, 11.1194>, <4.7335, 68.7106, 11.1317> }
					triangle { <4.896, 68.4828, 11.3239>, <5.365, 68.5195, 11.3259>, <4.9442, 68.8534, 11.1194> }
					triangle { <4.7446, 68.155, 11.4425>, <5.4666, 68.4681, 11.2859>, <4.896, 68.4828, 11.3239> }
					triangle { <4.6537, 68.37, 11.2503>, <4.896, 68.4828, 11.3239>, <4.7335, 68.7106, 11.1317> }
					triangle { <4.7446, 68.155, 11.4425>, <4.896, 68.4828, 11.3239>, <4.6537, 68.37, 11.2503> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.2395, 66.7971, 9.7494>, <4.5682, 68.3578, 11.3057>, <4.266, 68.3679, 11.3083> }
					triangle { <4.2395, 66.7971, 9.7494>, <4.5695, 67.5868, 10.6288>, <4.5682, 68.3578, 11.3057> }
					triangle { <4.266, 68.3679, 11.3083>, <4.1666, 67.5539, 10.8132>, <4.2395, 66.7971, 9.7494> }
					triangle { <4.5695, 67.5868, 10.6288>, <4.6795, 68.5918, 11.102>, <4.5682, 68.3578, 11.3057> }
					triangle { <4.6795, 68.5918, 11.102>, <4.4837, 69.07024, 10.9462>, <4.5682, 68.3578, 11.3057> }
					triangle { <4.266, 68.3679, 11.3083>, <3.9802, 68.601, 11.329>, <4.04384, 68.2336, 11.4814> }
					triangle { <4.04384, 68.2336, 11.4814>, <4.1666, 67.5539, 10.8132>, <4.266, 68.3679, 11.3083> }
					triangle { <4.4837, 69.07024, 10.9462>, <4.4416, 69.02917, 11.05171>, <4.3144, 68.6396, 11.2827> }
					triangle { <4.4416, 69.02917, 11.05171>, <4.04206, 69.2188, 10.7585>, <3.9419, 68.8461, 11.2709> }
					triangle { <4.3144, 68.6396, 11.2827>, <3.9419, 68.8461, 11.2709>, <3.9802, 68.601, 11.329> }
					triangle { <4.3144, 68.6396, 11.2827>, <4.4416, 69.02917, 11.05171>, <3.9419, 68.8461, 11.2709> }
					triangle { <4.5682, 68.3578, 11.3057>, <4.4837, 69.07024, 10.9462>, <4.3144, 68.6396, 11.2827> }
					triangle { <4.266, 68.3679, 11.3083>, <4.3144, 68.6396, 11.2827>, <3.9802, 68.601, 11.329> }
					triangle { <4.5682, 68.3578, 11.3057>, <4.3144, 68.6396, 11.2827>, <4.266, 68.3679, 11.3083> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.2395, 66.7971, 9.7494>, <4.2829, 68.3061, 11.3885>, <4.1802, 68.0756, 11.555> }
					triangle { <4.2395, 66.7971, 9.7494>, <4.3739, 67.7095, 10.5588>, <4.2829, 68.3061, 11.3885> }
					triangle { <4.1802, 68.0756, 11.555>, <4.3865, 67.4158, 10.8919>, <4.2395, 66.7971, 9.7494> }
					triangle { <4.3739, 67.7095, 10.5588>, <4.02537, 68.4833, 11.284>, <4.2829, 68.3061, 11.3885> }
					triangle { <4.02537, 68.4833, 11.284>, <3.5317, 68.5717, 11.484>, <4.2829, 68.3061, 11.3885> }
					triangle { <4.1802, 68.0756, 11.555>, <3.941, 67.991, 11.8235>, <4.3135, 67.8623, 11.7398> }
					triangle { <4.3135, 67.8623, 11.7398>, <4.3865, 67.4158, 10.8919>, <4.1802, 68.0756, 11.555> }
					triangle { <3.5317, 68.5717, 11.484>, <3.6149, 68.5385, 11.5649>, <3.9921, 68.265, 11.6297> }
					triangle { <3.6149, 68.5385, 11.5649>, <3.165, 68.2693, 11.6468>, <3.7222, 68.08977, 11.9089> }
					triangle { <3.9921, 68.265, 11.6297>, <3.7222, 68.08977, 11.9089>, <3.941, 67.991, 11.8235> }
					triangle { <3.9921, 68.265, 11.6297>, <3.6149, 68.5385, 11.5649>, <3.7222, 68.08977, 11.9089> }
					triangle { <4.2829, 68.3061, 11.3885>, <3.5317, 68.5717, 11.484>, <3.9921, 68.265, 11.6297> }
					triangle { <4.1802, 68.0756, 11.555>, <3.9921, 68.265, 11.6297>, <3.941, 67.991, 11.8235> }
					triangle { <4.2829, 68.3061, 11.3885>, <3.9921, 68.265, 11.6297>, <4.1802, 68.0756, 11.555> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.2395, 66.7971, 9.7494>, <4.284, 68.0668, 11.5802>, <4.5222, 67.8943, 11.6506> }
					triangle { <4.2395, 66.7971, 9.7494>, <4.1795, 67.6079, 10.6685>, <4.284, 68.0668, 11.5802> }
					triangle { <4.5222, 67.8943, 11.6506>, <4.6053, 67.5301, 10.7686>, <4.2395, 66.7971, 9.7494> }
					triangle { <4.1795, 67.6079, 10.6685>, <4.01565, 67.9383, 11.7221>, <4.284, 68.0668, 11.5802> }
					triangle { <4.01565, 67.9383, 11.7221>, <3.938, 67.6443, 12.1682>, <4.284, 68.0668, 11.5802> }
					triangle { <4.5222, 67.8943, 11.6506>, <4.6855, 67.7201, 11.9324>, <4.831, 67.9228, 11.6161> }
					triangle { <4.831, 67.9228, 11.6161>, <4.6053, 67.5301, 10.7686>, <4.5222, 67.8943, 11.6506> }
					triangle { <3.938, 67.6443, 12.1682>, <4.03905, 67.7104, 12.1669>, <4.3838, 67.8698, 11.8895> }
					triangle { <4.03905, 67.7104, 12.1669>, <4.1445, 67.2215, 12.3442>, <4.6077, 67.6226, 12.1546> }
					triangle { <4.3838, 67.8698, 11.8895>, <4.6077, 67.6226, 12.1546>, <4.6855, 67.7201, 11.9324> }
					triangle { <4.3838, 67.8698, 11.8895>, <4.03905, 67.7104, 12.1669>, <4.6077, 67.6226, 12.1546> }
					triangle { <4.284, 68.0668, 11.5802>, <3.938, 67.6443, 12.1682>, <4.3838, 67.8698, 11.8895> }
					triangle { <4.5222, 67.8943, 11.6506>, <4.3838, 67.8698, 11.8895>, <4.6855, 67.7201, 11.9324> }
					triangle { <4.284, 68.0668, 11.5802>, <4.3838, 67.8698, 11.8895>, <4.5222, 67.8943, 11.6506> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		}
	union { // internode
		cylinder { <0.7978, 61.5639, 6.1104>, <1.2736, 64.8714, 6.5768>, 0.4999 }
		cylinder { <1.2736, 64.8714, 6.5768>, <1.1189, 68.2289, 6.2813>, 0.4999 }
		cylinder { <1.1189, 68.2289, 6.2813>, <0.3472, 71.3471, 5.2493>, 0.4999 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.3472, 71.3471, 5.2493>, <-0.2107, 72.3414, 4.5441>, 0.4256 }
			cylinder { <-0.2107, 72.3414, 4.5441>, <-0.9547, 72.9748, 3.6262>, 0.4256 }
			cylinder { <-0.9547, 72.9748, 3.6262>, <-1.7978, 73.1733, 2.603>, 0.4256 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-1.7978, 73.1733, 2.603>, <-2.1519, 73.2566, 2.1732>, 0.4256 }
				cylinder { <-2.1519, 73.2566, 2.1732>, <-2.506, 73.34, 1.7434>, 0.4256 }
				cylinder { <-2.506, 73.34, 1.7434>, <-2.8601, 73.4233, 1.3137>, 0.4256 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-2.8601, 73.4233, 1.3137>, <-2.8967, 73.4358, 1.2309>, 0.02899 }
				cylinder { <-2.8967, 73.4358, 1.2309>, <-2.9098, 73.4464, 1.1412>, 0.02899 }
				cylinder { <-2.9098, 73.4464, 1.1412>, <-2.8985, 73.4544, 1.05099>, 0.02899 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-2.8985, 73.4544, 1.05099>, <-2.421, 73.5302, -3.858>, <-2.00743, 73.4839, -3.8567> }
				triangle { <-2.421, 73.5302, -3.858>, <-2.2216, 71.8123, -5.007346>, <-2.00743, 73.4839, -3.8567> }
				triangle { <-2.421, 73.5302, -3.858>, <-2.6168, 72.1646, -4.8397>, <-2.2216, 71.8123, -5.007346> }
				triangle { <-2.2216, 71.8123, -5.007346>, <-1.7857, 72.2005, -4.7325>, <-2.00743, 73.4839, -3.8567> }
				triangle { <-2.00743, 73.4839, -3.8567>, <-2.1715, 73.2098, -1.902>, <-2.8985, 73.4544, 1.05099> }
				triangle { <-2.8985, 73.4544, 1.05099>, <-2.9069, 73.2082, -1.9942>, <-2.421, 73.5302, -3.858> }
				triangle { <-2.9069, 73.2082, -1.9942>, <-2.9012, 73.02711, -3.8694>, <-2.421, 73.5302, -3.858> }
				triangle { <-2.9012, 73.02711, -3.8694>, <-2.6168, 72.1646, -4.8397>, <-2.421, 73.5302, -3.858> }
				triangle { <-2.00743, 73.4839, -3.8567>, <-1.7857, 72.2005, -4.7325>, <-1.7106, 72.8484, -3.8756> }
				triangle { <-1.7106, 72.8484, -3.8756>, <-2.1715, 73.2098, -1.902>, <-2.00743, 73.4839, -3.8567> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-2.8601, 73.4233, 1.3137>, <-2.9175, 73.4368, 1.244>, 0.02899 }
				cylinder { <-2.9175, 73.4368, 1.244>, <-2.9749, 73.4503, 1.1743>, 0.02899 }
				cylinder { <-2.9749, 73.4503, 1.1743>, <-3.03241, 73.4639, 1.1046>, 0.02899 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-3.03241, 73.4639, 1.1046>, <-6.2366, 73.8302, -2.6277>, <-5.9472, 73.8284, -2.9268> }
				triangle { <-6.2366, 73.8302, -2.6277>, <-6.858, 72.2017, -3.7564>, <-5.9472, 73.8284, -2.9268> }
				triangle { <-6.2366, 73.8302, -2.6277>, <-7.02531, 72.5012, -3.3196>, <-6.858, 72.2017, -3.7564> }
				triangle { <-6.858, 72.2017, -3.7564>, <-6.3733, 72.6204, -3.8337>, <-5.9472, 73.8284, -2.9268> }
				triangle { <-5.9472, 73.8284, -2.9268>, <-4.6436, 73.4431, -1.4861>, <-3.03241, 73.4639, 1.1046> }
				triangle { <-3.03241, 73.4639, 1.1046>, <-5.2197, 73.3674, -1.02613>, <-6.2366, 73.8302, -2.6277> }
				triangle { <-5.2197, 73.3674, -1.02613>, <-6.558, 73.2798, -2.3492>, <-6.2366, 73.8302, -2.6277> }
				triangle { <-6.558, 73.2798, -2.3492>, <-7.02531, 72.5012, -3.3196>, <-6.2366, 73.8302, -2.6277> }
				triangle { <-5.9472, 73.8284, -2.9268>, <-6.3733, 72.6204, -3.8337>, <-5.73, 73.23, -3.2217> }
				triangle { <-5.73, 73.23, -3.2217>, <-4.6436, 73.4431, -1.4861>, <-5.9472, 73.8284, -2.9268> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <0.3472, 71.3471, 5.2493>, <-0.2474, 73.7461, 4.9651>, 0.3686 }
		cylinder { <-0.2474, 73.7461, 4.9651>, <-0.8447, 76.1527, 5.1685>, 0.3686 }
		cylinder { <-0.8447, 76.1527, 5.1685>, <-1.4217, 78.4743, 5.8518>, 0.3686 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.4217, 78.4743, 5.8518>, <-1.4615, 78.6339, 5.9696>, 0.06425 }
			cylinder { <-1.4615, 78.6339, 5.9696>, <-1.4895, 78.7456, 6.136>, 0.06425 }
			cylinder { <-1.4895, 78.7456, 6.136>, <-1.5024, 78.7964, 6.3315>, 0.06425 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-1.5024, 78.7964, 6.3315>, <-1.5079, 78.8177, 6.4136>, 0.06425 }
				cylinder { <-1.5079, 78.8177, 6.4136>, <-1.5133, 78.839, 6.4957>, 0.06425 }
				cylinder { <-1.5133, 78.839, 6.4957>, <-1.5187, 78.8603, 6.5778>, 0.06425 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-1.5187, 78.8603, 6.5778>, <-1.5385, 78.9985, 7.3092>, <-1.5992, 78.9837, 7.3162> }
				triangle { <-1.5385, 78.9985, 7.3092>, <-1.5192, 78.7737, 7.5268>, <-1.5992, 78.9837, 7.3162> }
				triangle { <-1.5385, 78.9985, 7.3092>, <-1.4696, 78.8285, 7.4872>, <-1.5192, 78.7737, 7.5268> }
				triangle { <-1.5192, 78.7737, 7.5268>, <-1.5954, 78.8149, 7.4824>, <-1.5992, 78.9837, 7.3162> }
				triangle { <-1.5992, 78.9837, 7.3162>, <-1.59, 78.8923, 7.0317>, <-1.5187, 78.8603, 6.5778> }
				triangle { <-1.5187, 78.8603, 6.5778>, <-1.4794, 78.9087, 7.03477>, <-1.5385, 78.9985, 7.3092> }
				triangle { <-1.4794, 78.9087, 7.03477>, <-1.4561, 78.9339, 7.317>, <-1.5385, 78.9985, 7.3092> }
				triangle { <-1.4561, 78.9339, 7.317>, <-1.4696, 78.8285, 7.4872>, <-1.5385, 78.9985, 7.3092> }
				triangle { <-1.5992, 78.9837, 7.3162>, <-1.5954, 78.8149, 7.4824>, <-1.6297, 78.8851, 7.3398> }
				triangle { <-1.6297, 78.8851, 7.3398>, <-1.59, 78.8923, 7.0317>, <-1.5992, 78.9837, 7.3162> }
				texture{chif1}}
			mesh { // leaf
				triangle { <-1.5187, 78.8603, 6.5778>, <-1.5385, 78.9985, 7.3092>, <-1.5992, 78.9837, 7.3162> }
				triangle { <-1.5385, 78.9985, 7.3092>, <-1.5192, 78.7737, 7.5268>, <-1.5992, 78.9837, 7.3162> }
				triangle { <-1.5385, 78.9985, 7.3092>, <-1.4696, 78.8285, 7.4872>, <-1.5192, 78.7737, 7.5268> }
				triangle { <-1.5192, 78.7737, 7.5268>, <-1.5954, 78.8149, 7.4824>, <-1.5992, 78.9837, 7.3162> }
				triangle { <-1.5992, 78.9837, 7.3162>, <-1.59, 78.8923, 7.0317>, <-1.5187, 78.8603, 6.5778> }
				triangle { <-1.5187, 78.8603, 6.5778>, <-1.4794, 78.9087, 7.03477>, <-1.5385, 78.9985, 7.3092> }
				triangle { <-1.4794, 78.9087, 7.03477>, <-1.4561, 78.9339, 7.317>, <-1.5385, 78.9985, 7.3092> }
				triangle { <-1.4561, 78.9339, 7.317>, <-1.4696, 78.8285, 7.4872>, <-1.5385, 78.9985, 7.3092> }
				triangle { <-1.5992, 78.9837, 7.3162>, <-1.5954, 78.8149, 7.4824>, <-1.6297, 78.8851, 7.3398> }
				triangle { <-1.6297, 78.8851, 7.3398>, <-1.59, 78.8923, 7.0317>, <-1.5992, 78.9837, 7.3162> }
				texture{chif1}}
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <-1.4217, 78.4743, 5.8518>, <-1.4892, 78.853, 5.9317>, 0.2183 }
			cylinder { <-1.4892, 78.853, 5.9317>, <-1.5322, 79.2401, 5.983>, 0.2183 }
			cylinder { <-1.5322, 79.2401, 5.983>, <-1.5506, 79.6319, 6.005217>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <-1.5506, 79.6319, 6.005217>, <-1.544, 80.0247, 5.9979>, 0.2183 }
			cylinder { <-1.544, 80.0247, 5.9979>, <-1.5125, 80.4145, 5.9613>, 0.2183 }
			cylinder { <-1.5125, 80.4145, 5.9613>, <-1.4564, 80.7978, 5.8958>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <-1.4564, 80.7978, 5.8958>, <-1.4383, 81.1855, 5.835>, 0.2183 }
			cylinder { <-1.4383, 81.1855, 5.835>, <-1.4585, 81.574, 5.7797>, 0.2183 }
			cylinder { <-1.4585, 81.574, 5.7797>, <-1.5165, 81.9594, 5.7303>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.5165, 81.9594, 5.7303>, <-1.6736, 82.5239, 5.6683>, 0.2183 }
				cylinder { <-1.6736, 82.5239, 5.6683>, <-1.8983, 83.06655, 5.6194>, 0.2183 }
				cylinder { <-1.8983, 83.06655, 5.6194>, <-2.1872, 83.5789, 5.5842>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-2.1872, 83.5789, 5.5842>, <-3.2853, 85.5369, 5.7101>, <-3.01799, 85.6514, 5.618> }
					triangle { <-2.1872, 83.5789, 5.5842>, <-2.9319, 84.5665, 5.639>, <-3.2853, 85.5369, 5.7101> }
					triangle { <-3.01799, 85.6514, 5.618>, <-2.659, 84.791, 5.3632>, <-2.1872, 83.5789, 5.5842> }
					triangle { <-2.9319, 84.5665, 5.639>, <-3.2985, 85.5522, 6.04212>, <-3.2853, 85.5369, 5.7101> }
					triangle { <-3.2985, 85.5522, 6.04212>, <-3.07197, 85.8844, 6.4096>, <-3.2853, 85.5369, 5.7101> }
					triangle { <-3.01799, 85.6514, 5.618>, <-2.7837, 85.9364, 5.671>, <-2.8959, 85.7309, 5.3388> }
					triangle { <-2.8959, 85.7309, 5.3388>, <-2.659, 84.791, 5.3632>, <-3.01799, 85.6514, 5.618> }
					triangle { <-3.07197, 85.8844, 6.4096>, <-3.08248, 85.9305, 6.2973>, <-3.06104, 85.8213, 5.836> }
					triangle { <-3.08248, 85.9305, 6.2973>, <-2.5966, 86.03873, 6.4946>, <-2.7331, 86.09779, 5.8647> }
					triangle { <-3.06104, 85.8213, 5.836>, <-2.7331, 86.09779, 5.8647>, <-2.7837, 85.9364, 5.671> }
					triangle { <-3.06104, 85.8213, 5.836>, <-3.08248, 85.9305, 6.2973>, <-2.7331, 86.09779, 5.8647> }
					triangle { <-3.2853, 85.5369, 5.7101>, <-3.07197, 85.8844, 6.4096>, <-3.06104, 85.8213, 5.836> }
					triangle { <-3.01799, 85.6514, 5.618>, <-3.06104, 85.8213, 5.836>, <-2.7837, 85.9364, 5.671> }
					triangle { <-3.2853, 85.5369, 5.7101>, <-3.06104, 85.8213, 5.836>, <-3.01799, 85.6514, 5.618> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-2.1872, 83.5789, 5.5842>, <-3.06817, 85.6468, 5.5275>, <-3.04517, 85.6092, 5.2256> }
					triangle { <-2.1872, 83.5789, 5.5842>, <-2.7303, 84.6848, 5.7066>, <-3.06817, 85.6468, 5.5275> }
					triangle { <-3.04517, 85.6092, 5.2256>, <-2.8858, 84.6579, 5.287>, <-2.1872, 83.5789, 5.5842> }
					triangle { <-2.7303, 84.6848, 5.7066>, <-2.7973, 85.8069, 5.6354>, <-3.06817, 85.6468, 5.5275> }
					triangle { <-2.7973, 85.8069, 5.6354>, <-2.4564, 86.1623, 5.4027>, <-3.06817, 85.6468, 5.5275> }
					triangle { <-3.04517, 85.6092, 5.2256>, <-2.9554, 85.7875, 4.9109>, <-3.2416, 85.5127, 4.9993> }
					triangle { <-3.2416, 85.5127, 4.9993>, <-2.8858, 84.6579, 5.287>, <-3.04517, 85.6092, 5.2256> }
					triangle { <-2.4564, 86.1623, 5.4027>, <-2.5672, 86.1561, 5.3525>, <-2.9214, 85.8594, 5.2441> }
					triangle { <-2.5672, 86.1561, 5.3525>, <-2.1935, 86.1613, 4.9693>, <-2.8054, 85.9874, 4.8505> }
					triangle { <-2.9214, 85.8594, 5.2441>, <-2.8054, 85.9874, 4.8505>, <-2.9554, 85.7875, 4.9109> }
					triangle { <-2.9214, 85.8594, 5.2441>, <-2.5672, 86.1561, 5.3525>, <-2.8054, 85.9874, 4.8505> }
					triangle { <-3.06817, 85.6468, 5.5275>, <-2.4564, 86.1623, 5.4027>, <-2.9214, 85.8594, 5.2441> }
					triangle { <-3.04517, 85.6092, 5.2256>, <-2.9214, 85.8594, 5.2441>, <-2.9554, 85.7875, 4.9109> }
					triangle { <-3.06817, 85.6468, 5.5275>, <-2.9214, 85.8594, 5.2441>, <-3.04517, 85.6092, 5.2256> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-2.1872, 83.5789, 5.5842>, <-3.1446, 85.584, 5.2398>, <-3.38, 85.4148, 5.1447> }
					triangle { <-2.1872, 83.5789, 5.5842>, <-2.6044, 84.742, 5.5063>, <-3.1446, 85.584, 5.2398> }
					triangle { <-3.38, 85.4148, 5.1447>, <-3.02744, 84.5936, 5.5124>, <-2.1872, 83.5789, 5.5842> }
					triangle { <-2.6044, 84.742, 5.5063>, <-2.9614, 85.6691, 4.9755>, <-3.1446, 85.584, 5.2398> }
					triangle { <-2.9614, 85.6691, 4.9755>, <-3.07902, 85.7459, 4.4492>, <-3.1446, 85.584, 5.2398> }
					triangle { <-3.38, 85.4148, 5.1447>, <-3.6453, 85.3967, 4.8835>, <-3.6427, 85.3059, 5.2797> }
					triangle { <-3.6427, 85.3059, 5.2797>, <-3.02744, 84.5936, 5.5124>, <-3.38, 85.4148, 5.1447> }
					triangle { <-3.07902, 85.7459, 4.4492>, <-3.173, 85.7579, 4.5258>, <-3.3642, 85.5879, 4.9255> }
					triangle { <-3.173, 85.7579, 4.5258>, <-3.3194, 85.467, 4.1009>, <-3.6717, 85.4848, 4.6434> }
					triangle { <-3.3642, 85.5879, 4.9255>, <-3.6717, 85.4848, 4.6434>, <-3.6453, 85.3967, 4.8835> }
					triangle { <-3.3642, 85.5879, 4.9255>, <-3.173, 85.7579, 4.5258>, <-3.6717, 85.4848, 4.6434> }
					triangle { <-3.1446, 85.584, 5.2398>, <-3.07902, 85.7459, 4.4492>, <-3.3642, 85.5879, 4.9255> }
					triangle { <-3.38, 85.4148, 5.1447>, <-3.3642, 85.5879, 4.9255>, <-3.6453, 85.3967, 4.8835> }
					triangle { <-3.1446, 85.584, 5.2398>, <-3.3642, 85.5879, 4.9255>, <-3.38, 85.4148, 5.1447> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-2.1872, 83.5789, 5.5842>, <-3.4096, 85.4347, 5.2419>, <-3.5629, 85.3352, 5.4862> }
					triangle { <-2.1872, 83.5789, 5.5842>, <-2.7271, 84.6596, 5.3129>, <-3.4096, 85.4347, 5.2419> }
					triangle { <-3.5629, 85.3352, 5.4862>, <-2.8893, 84.6863, 5.73>, <-2.1872, 83.5789, 5.5842> }
					triangle { <-2.7271, 84.6596, 5.3129>, <-3.5656, 85.328, 4.9682>, <-3.4096, 85.4347, 5.2419> }
					triangle { <-3.5656, 85.328, 4.9682>, <-4.08512, 85.2067, 4.858>, <-3.4096, 85.4347, 5.2419> }
					triangle { <-3.5629, 85.3352, 5.4862>, <-3.9064, 85.3004, 5.6265>, <-3.5487, 85.3942, 5.7952> }
					triangle { <-3.5487, 85.3942, 5.7952>, <-2.8893, 84.6863, 5.73>, <-3.5629, 85.3352, 5.4862> }
					triangle { <-4.08512, 85.2067, 4.858>, <-4.06819, 85.2824, 4.9519>, <-3.7815, 85.3795, 5.3175> }
					triangle { <-4.06819, 85.2824, 4.9519>, <-4.429, 84.9087, 5.08139>, <-4.1429, 85.2798, 5.5278> }
					triangle { <-3.7815, 85.3795, 5.3175>, <-4.1429, 85.2798, 5.5278>, <-3.9064, 85.3004, 5.6265> }
					triangle { <-3.7815, 85.3795, 5.3175>, <-4.06819, 85.2824, 4.9519>, <-4.1429, 85.2798, 5.5278> }
					triangle { <-3.4096, 85.4347, 5.2419>, <-4.08512, 85.2067, 4.858>, <-3.7815, 85.3795, 5.3175> }
					triangle { <-3.5629, 85.3352, 5.4862>, <-3.7815, 85.3795, 5.3175>, <-3.9064, 85.3004, 5.6265> }
					triangle { <-3.4096, 85.4347, 5.2419>, <-3.7815, 85.3795, 5.3175>, <-3.5629, 85.3352, 5.4862> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-2.1872, 83.5789, 5.5842>, <-3.4979, 85.4051, 5.537>, <-3.3357, 85.4836, 5.7831> }
					triangle { <-2.1872, 83.5789, 5.5842>, <-2.9326, 84.5494, 5.3961>, <-3.4979, 85.4051, 5.537> }
					triangle { <-3.3357, 85.4836, 5.7831>, <-2.6582, 84.8102, 5.6363>, <-2.1872, 83.5789, 5.5842> }
					triangle { <-2.9326, 84.5494, 5.3961>, <-3.777, 85.2547, 5.6373>, <-3.4979, 85.4051, 5.537> }
					triangle { <-3.777, 85.2547, 5.6373>, <-4.0807, 85.2936, 6.08792>, <-3.4979, 85.4051, 5.537> }
					triangle { <-3.3357, 85.4836, 5.7831>, <-3.3659, 85.6391, 6.1206>, <-3.08026, 85.6609, 5.8322> }
					triangle { <-3.08026, 85.6609, 5.8322>, <-2.6582, 84.8102, 5.6363>, <-3.3357, 85.4836, 5.7831> }
					triangle { <-4.0807, 85.2936, 6.08792>, <-4.0114, 85.3907, 6.06337>, <-3.5913, 85.526, 5.8887> }
					triangle { <-4.0114, 85.3907, 6.06337>, <-3.9755, 85.2674, 6.5831>, <-3.554, 85.6644, 6.2939> }
					triangle { <-3.5913, 85.526, 5.8887>, <-3.554, 85.6644, 6.2939>, <-3.3659, 85.6391, 6.1206> }
					triangle { <-3.5913, 85.526, 5.8887>, <-4.0114, 85.3907, 6.06337>, <-3.554, 85.6644, 6.2939> }
					triangle { <-3.4979, 85.4051, 5.537>, <-4.0807, 85.2936, 6.08792>, <-3.5913, 85.526, 5.8887> }
					triangle { <-3.3357, 85.4836, 5.7831>, <-3.5913, 85.526, 5.8887>, <-3.3659, 85.6391, 6.1206> }
					triangle { <-3.4979, 85.4051, 5.537>, <-3.5913, 85.526, 5.8887>, <-3.3357, 85.4836, 5.7831> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-1.5165, 81.9594, 5.7303>, <-1.5427, 82.3503, 5.7019>, 0.2183 }
			cylinder { <-1.5427, 82.3503, 5.7019>, <-1.5369, 82.7431, 5.6947>, 0.2183 }
			cylinder { <-1.5369, 82.7431, 5.6947>, <-1.4989, 83.1338, 5.7089>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.4989, 83.1338, 5.7089>, <-1.3827, 83.7083, 5.7698>, 0.2183 }
				cylinder { <-1.3827, 83.7083, 5.7698>, <-1.209, 84.2625, 5.8694>, 0.2183 }
				cylinder { <-1.209, 84.2625, 5.8694>, <-0.9803, 84.7881, 6.006389>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.9803, 84.7881, 6.006389>, <0.05758, 86.7463, 6.3341>, <-0.1939, 86.8599, 6.2066> }
					triangle { <-0.9803, 84.7881, 6.006389>, <-0.3206, 85.7871, 6.3042>, <0.05758, 86.7463, 6.3341> }
					triangle { <-0.1939, 86.8599, 6.2066>, <-0.6895, 86.03851, 6.2897>, <-0.9803, 84.7881, 6.006389> }
					triangle { <-0.3206, 85.7871, 6.3042>, <0.2873, 86.7077, 6.09846>, <0.05758, 86.7463, 6.3341> }
					triangle { <0.2873, 86.7077, 6.09846>, <0.3845, 86.9619, 5.6287>, <0.05758, 86.7463, 6.3341> }
					triangle { <-0.1939, 86.8599, 6.2066>, <-0.313, 87.1188, 5.9685>, <-0.463, 86.9773, 6.3171> }
					triangle { <-0.463, 86.9773, 6.3171>, <-0.6895, 86.03851, 6.2897>, <-0.1939, 86.8599, 6.2066> }
					triangle { <0.3845, 86.9619, 5.6287>, <0.3216, 87.02606, 5.7103>, <-0.006199, 86.9932, 6.04962> }
					triangle { <0.3216, 87.02606, 5.7103>, <0.09793, 87.07481, 5.2285>, <-0.2116, 87.2428, 5.7686> }
					triangle { <-0.006199, 86.9932, 6.04962>, <-0.2116, 87.2428, 5.7686>, <-0.313, 87.1188, 5.9685> }
					triangle { <-0.006199, 86.9932, 6.04962>, <0.3216, 87.02606, 5.7103>, <-0.2116, 87.2428, 5.7686> }
					triangle { <0.05758, 86.7463, 6.3341>, <0.3845, 86.9619, 5.6287>, <-0.006199, 86.9932, 6.04962> }
					triangle { <-0.1939, 86.8599, 6.2066>, <-0.006199, 86.9932, 6.04962>, <-0.313, 87.1188, 5.9685> }
					triangle { <0.05758, 86.7463, 6.3341>, <-0.006199, 86.9932, 6.04962>, <-0.1939, 86.8599, 6.2066> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-0.9803, 84.7881, 6.006389>, <-0.2165, 86.8728, 6.3065>, <-0.4353, 86.884, 6.5172> }
					triangle { <-0.9803, 84.7881, 6.006389>, <-0.4176, 85.8817, 6.1031>, <-0.2165, 86.8728, 6.3065> }
					triangle { <-0.4353, 86.884, 6.5172>, <-0.5804, 85.932, 6.516>, <-0.9803, 84.7881, 6.006389> }
					triangle { <-0.4176, 85.8817, 6.1031>, <-0.3355, 86.9982, 6.02378>, <-0.2165, 86.8728, 6.3065> }
					triangle { <-0.3355, 86.9982, 6.02378>, <-0.7175, 87.3674, 5.9125>, <-0.2165, 86.8728, 6.3065> }
					triangle { <-0.4353, 86.884, 6.5172>, <-0.697, 87.1059, 6.6594>, <-0.4452, 86.8366, 6.8272> }
					triangle { <-0.4452, 86.8366, 6.8272>, <-0.5804, 85.932, 6.516>, <-0.4353, 86.884, 6.5172> }
					triangle { <-0.7175, 87.3674, 5.9125>, <-0.6685, 87.3753, 6.02331>, <-0.4974, 87.1202, 6.3828> }
					triangle { <-0.6685, 87.3753, 6.02331>, <-1.1988, 87.4237, 6.05481>, <-0.8342, 87.3042, 6.573> }
					triangle { <-0.4974, 87.1202, 6.3828>, <-0.8342, 87.3042, 6.573>, <-0.697, 87.1059, 6.6594> }
					triangle { <-0.4974, 87.1202, 6.3828>, <-0.6685, 87.3753, 6.02331>, <-0.8342, 87.3042, 6.573> }
					triangle { <-0.2165, 86.8728, 6.3065>, <-0.7175, 87.3674, 5.9125>, <-0.4974, 87.1202, 6.3828> }
					triangle { <-0.4353, 86.884, 6.5172>, <-0.4974, 87.1202, 6.3828>, <-0.697, 87.1059, 6.6594> }
					triangle { <-0.2165, 86.8728, 6.3065>, <-0.4974, 87.1202, 6.3828>, <-0.4353, 86.884, 6.5172> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-0.9803, 84.7881, 6.006389>, <-0.3538, 86.8621, 6.5766>, <-0.2533, 86.7239, 6.828> }
					triangle { <-0.9803, 84.7881, 6.006389>, <-0.6392, 85.9641, 6.157>, <-0.3538, 86.8621, 6.5766> }
					triangle { <-0.2533, 86.7239, 6.828>, <-0.331, 85.8394, 6.4553>, <-0.9803, 84.7881, 6.006389> }
					triangle { <-0.6392, 85.9641, 6.157>, <-0.6582, 86.9794, 6.6348>, <-0.3538, 86.8621, 6.5766> }
					triangle { <-0.6582, 86.9794, 6.6348>, <-0.9123, 87.147, 7.08426>, <-0.3538, 86.8621, 6.5766> }
					triangle { <-0.2533, 86.7239, 6.828>, <-0.2294, 86.7626, 7.1966>, <0.02339, 86.6085, 6.9202> }
					triangle { <0.02339, 86.6085, 6.9202>, <-0.331, 85.8394, 6.4553>, <-0.2533, 86.7239, 6.828> }
					triangle { <-0.9123, 87.147, 7.08426>, <-0.7911, 87.1511, 7.08869>, <-0.3973, 86.9288, 6.9502> }
					triangle { <-0.7911, 87.1511, 7.08869>, <-0.9828, 86.9427, 7.5407>, <-0.3618, 86.8897, 7.3753> }
					triangle { <-0.3973, 86.9288, 6.9502>, <-0.3618, 86.8897, 7.3753>, <-0.2294, 86.7626, 7.1966> }
					triangle { <-0.3973, 86.9288, 6.9502>, <-0.7911, 87.1511, 7.08869>, <-0.3618, 86.8897, 7.3753> }
					triangle { <-0.3538, 86.8621, 6.5766>, <-0.9123, 87.147, 7.08426>, <-0.3973, 86.9288, 6.9502> }
					triangle { <-0.2533, 86.7239, 6.828>, <-0.3973, 86.9288, 6.9502>, <-0.2294, 86.7626, 7.1966> }
					triangle { <-0.3538, 86.8621, 6.5766>, <-0.3973, 86.9288, 6.9502>, <-0.2533, 86.7239, 6.828> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-0.9803, 84.7881, 6.006389>, <-0.1657, 86.729, 6.7736>, <0.1022, 86.5993, 6.7123> }
					triangle { <-0.9803, 84.7881, 6.006389>, <-0.6813, 85.9212, 6.392>, <-0.1657, 86.729, 6.7736> }
					triangle { <0.1022, 86.5993, 6.7123>, <-0.2838, 85.8876, 6.191>, <-0.9803, 84.7881, 6.006389> }
					triangle { <-0.6813, 85.9212, 6.392>, <-0.2377, 86.6772, 7.09294>, <-0.1657, 86.729, 6.7736> }
					triangle { <-0.2377, 86.6772, 7.09294>, <0.06743, 86.6031, 7.5356>, <-0.1657, 86.729, 6.7736> }
					triangle { <0.1022, 86.5993, 6.7123>, <0.4478, 86.5601, 6.8426>, <0.2995, 86.606, 6.4685> }
					triangle { <0.2995, 86.606, 6.4685>, <-0.2838, 85.8876, 6.191>, <0.1022, 86.5993, 6.7123> }
					triangle { <0.06743, 86.6031, 7.5356>, <0.122, 86.6612, 7.4441>, <0.1567, 86.6818, 6.9729> }
					triangle { <0.122, 86.6612, 7.4441>, <0.4494, 86.2919, 7.6467>, <0.5571, 86.5683, 7.07417> }
					triangle { <0.1567, 86.6818, 6.9729>, <0.5571, 86.5683, 7.07417>, <0.4478, 86.5601, 6.8426> }
					triangle { <0.1567, 86.6818, 6.9729>, <0.122, 86.6612, 7.4441>, <0.5571, 86.5683, 7.07417> }
					triangle { <-0.1657, 86.729, 6.7736>, <0.06743, 86.6031, 7.5356>, <0.1567, 86.6818, 6.9729> }
					triangle { <0.1022, 86.5993, 6.7123>, <0.1567, 86.6818, 6.9729>, <0.4478, 86.5601, 6.8426> }
					triangle { <-0.1657, 86.729, 6.7736>, <0.1567, 86.6818, 6.9729>, <0.1022, 86.5993, 6.7123> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-0.9803, 84.7881, 6.006389>, <0.09231, 86.6563, 6.6215>, <0.1395, 86.6847, 6.3225> }
					triangle { <-0.9803, 84.7881, 6.006389>, <-0.4813, 85.8101, 6.4843>, <0.09231, 86.6563, 6.6215> }
					triangle { <0.1395, 86.6847, 6.3225>, <-0.5087, 86.0126, 6.08711>, <-0.9803, 84.7881, 6.006389> }
					triangle { <-0.4813, 85.8101, 6.4843>, <0.3554, 86.5067, 6.7564>, <0.09231, 86.6563, 6.6215> }
					triangle { <0.3554, 86.5067, 6.7564>, <0.881, 86.487, 6.6225>, <0.09231, 86.6563, 6.6215> }
					triangle { <0.1395, 86.6847, 6.3225>, <0.3953, 86.7836, 6.07222>, <-0.005668, 86.8374, 6.09014> }
					triangle { <-0.005668, 86.8374, 6.09014>, <-0.5087, 86.0126, 6.08711>, <0.1395, 86.6847, 6.3225> }
					triangle { <0.881, 86.487, 6.6225>, <0.8201, 86.5827, 6.5794>, <0.4021, 86.7222, 6.4079> }
					triangle { <0.8201, 86.5827, 6.5794>, <1.1274, 86.3748, 6.1961>, <0.6513, 86.7899, 6.0662> }
					triangle { <0.4021, 86.7222, 6.4079>, <0.6513, 86.7899, 6.0662>, <0.3953, 86.7836, 6.07222> }
					triangle { <0.4021, 86.7222, 6.4079>, <0.8201, 86.5827, 6.5794>, <0.6513, 86.7899, 6.0662> }
					triangle { <0.09231, 86.6563, 6.6215>, <0.881, 86.487, 6.6225>, <0.4021, 86.7222, 6.4079> }
					triangle { <0.1395, 86.6847, 6.3225>, <0.4021, 86.7222, 6.4079>, <0.3953, 86.7836, 6.07222> }
					triangle { <0.09231, 86.6563, 6.6215>, <0.4021, 86.7222, 6.4079>, <0.1395, 86.6847, 6.3225> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-1.4989, 83.1338, 5.7089>, <-1.4705, 83.525, 5.6857>, 0.2183 }
			cylinder { <-1.4705, 83.525, 5.6857>, <-1.4518, 83.9127, 5.6253>, 0.2183 }
			cylinder { <-1.4518, 83.9127, 5.6253>, <-1.4431, 84.2933, 5.5284>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.4431, 84.2933, 5.5284>, <-1.4489, 84.8432, 5.3166>, 0.2183 }
				cylinder { <-1.4489, 84.8432, 5.3166>, <-1.4734, 85.3637, 5.04145>, 0.2183 }
				cylinder { <-1.4734, 85.3637, 5.04145>, <-1.5163, 85.8471, 4.707>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-1.5163, 85.8471, 4.707>, <-1.9356, 87.6681, 3.4713>, <-1.8241, 87.814, 3.7135> }
					triangle { <-1.5163, 85.8471, 4.707>, <-1.7409, 86.7479, 3.8946>, <-1.9356, 87.6681, 3.4713> }
					triangle { <-1.8241, 87.814, 3.7135>, <-1.4573, 87.0171, 4.1105>, <-1.5163, 85.8471, 4.707> }
					triangle { <-1.7409, 86.7479, 3.8946>, <-2.2657, 87.6568, 3.4973>, <-1.9356, 87.6681, 3.4713> }
					triangle { <-2.2657, 87.6568, 3.4973>, <-2.6311, 87.9792, 3.7366>, <-1.9356, 87.6681, 3.4713> }
					triangle { <-1.8241, 87.814, 3.7135>, <-1.8744, 88.1144, 3.9261>, <-1.5418, 87.9255, 3.7929> }
					triangle { <-1.5418, 87.9255, 3.7929>, <-1.4573, 87.0171, 4.1105>, <-1.8241, 87.814, 3.7135> }
					triangle { <-2.6311, 87.9792, 3.7366>, <-2.5256, 88.03234, 3.7086>, <-2.05875, 87.9614, 3.683> }
					triangle { <-2.5256, 88.03234, 3.7086>, <-2.6739, 88.1711, 4.2018>, <-2.07362, 88.2641, 3.9856> }
					triangle { <-2.05875, 87.9614, 3.683>, <-2.07362, 88.2641, 3.9856>, <-1.8744, 88.1144, 3.9261> }
					triangle { <-2.05875, 87.9614, 3.683>, <-2.5256, 88.03234, 3.7086>, <-2.07362, 88.2641, 3.9856> }
					triangle { <-1.9356, 87.6681, 3.4713>, <-2.6311, 87.9792, 3.7366>, <-2.05875, 87.9614, 3.683> }
					triangle { <-1.8241, 87.814, 3.7135>, <-2.05875, 87.9614, 3.683>, <-1.8744, 88.1144, 3.9261> }
					triangle { <-1.9356, 87.6681, 3.4713>, <-2.05875, 87.9614, 3.683>, <-1.8241, 87.814, 3.7135> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-1.5163, 85.8471, 4.707>, <-1.7403, 87.8115, 3.6535>, <-1.4367, 87.7994, 3.6426> }
					triangle { <-1.5163, 85.8471, 4.707>, <-1.7949, 86.8791, 4.09133>, <-1.7403, 87.8115, 3.6535> }
					triangle { <-1.4367, 87.7994, 3.6426>, <-1.3966, 86.8694, 3.8893>, <-1.5163, 85.8471, 4.707> }
					triangle { <-1.7949, 86.8791, 4.09133>, <-1.8296, 87.9876, 3.9196>, <-1.7403, 87.8115, 3.6535> }
					triangle { <-1.8296, 87.9876, 3.9196>, <-1.592, 88.3895, 4.1964>, <-1.7403, 87.8115, 3.6535> }
					triangle { <-1.4367, 87.7994, 3.6426>, <-1.1316, 88.00828, 3.6773>, <-1.2276, 87.7023, 3.4299> }
					triangle { <-1.2276, 87.7023, 3.4299>, <-1.3966, 86.8694, 3.8893>, <-1.4367, 87.7994, 3.6426> }
					triangle { <-1.592, 88.3895, 4.1964>, <-1.5547, 88.3765, 4.08164>, <-1.4625, 88.05733, 3.7451> }
					triangle { <-1.5547, 88.3765, 4.08164>, <-1.1345, 88.4467, 4.4027>, <-1.07224, 88.2249, 3.8005> }
					triangle { <-1.4625, 88.05733, 3.7451>, <-1.07224, 88.2249, 3.8005>, <-1.1316, 88.00828, 3.6773> }
					triangle { <-1.4625, 88.05733, 3.7451>, <-1.5547, 88.3765, 4.08164>, <-1.07224, 88.2249, 3.8005> }
					triangle { <-1.7403, 87.8115, 3.6535>, <-1.592, 88.3895, 4.1964>, <-1.4625, 88.05733, 3.7451> }
					triangle { <-1.4367, 87.7994, 3.6426>, <-1.4625, 88.05733, 3.7451>, <-1.1316, 88.00828, 3.6773> }
					triangle { <-1.7403, 87.8115, 3.6535>, <-1.4625, 88.05733, 3.7451>, <-1.4367, 87.7994, 3.6426> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-1.5163, 85.8471, 4.707>, <-1.4598, 87.7638, 3.5486>, <-1.3783, 87.5812, 3.3197> }
					triangle { <-1.5163, 85.8471, 4.707>, <-1.5879, 86.963, 4.1859>, <-1.4598, 87.7638, 3.5486> }
					triangle { <-1.3783, 87.5812, 3.3197>, <-1.6294, 86.7751, 3.7828>, <-1.5163, 85.8471, 4.707> }
					triangle { <-1.5879, 86.963, 4.1859>, <-1.1857, 87.8856, 3.6895>, <-1.4598, 87.7638, 3.5486> }
					triangle { <-1.1857, 87.8856, 3.6895>, <-0.6868, 87.9902, 3.503>, <-1.4598, 87.7638, 3.5486> }
					triangle { <-1.3783, 87.5812, 3.3197>, <-1.1495, 87.5575, 3.02815>, <-1.532, 87.4379, 3.08676> }
					triangle { <-1.532, 87.4379, 3.08676>, <-1.6294, 86.7751, 3.7828>, <-1.3783, 87.5812, 3.3197> }
					triangle { <-0.6868, 87.9902, 3.503>, <-0.7741, 87.9872, 3.4187>, <-1.1754, 87.7704, 3.2936> }
					triangle { <-0.7741, 87.9872, 3.4187>, <-0.3466, 87.7176, 3.2478>, <-0.9234, 87.6603, 2.9652> }
					triangle { <-1.1754, 87.7704, 3.2936>, <-0.9234, 87.6603, 2.9652>, <-1.1495, 87.5575, 3.02815> }
					triangle { <-1.1754, 87.7704, 3.2936>, <-0.7741, 87.9872, 3.4187>, <-0.9234, 87.6603, 2.9652> }
					triangle { <-1.4598, 87.7638, 3.5486>, <-0.6868, 87.9902, 3.503>, <-1.1754, 87.7704, 3.2936> }
					triangle { <-1.3783, 87.5812, 3.3197>, <-1.1754, 87.7704, 3.2936>, <-1.1495, 87.5575, 3.02815> }
					triangle { <-1.4598, 87.7638, 3.5486>, <-1.1754, 87.7704, 3.2936>, <-1.3783, 87.5812, 3.3197> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-1.5163, 85.8471, 4.707>, <-1.4792, 87.5905, 3.3006>, <-1.729, 87.4589, 3.188> }
					triangle { <-1.5163, 85.8471, 4.707>, <-1.4041, 86.8843, 4.04866>, <-1.4792, 87.5905, 3.3006> }
					triangle { <-1.729, 87.4589, 3.188>, <-1.8362, 86.8636, 3.9373>, <-1.5163, 85.8471, 4.707> }
					triangle { <-1.4041, 86.8843, 4.04866>, <-1.2179, 87.4908, 3.1229>, <-1.4792, 87.5905, 3.3006> }
					triangle { <-1.2179, 87.4908, 3.1229>, <-1.1581, 87.3293, 2.6081>, <-1.4792, 87.5905, 3.3006> }
					triangle { <-1.729, 87.4589, 3.188>, <-1.9036, 87.3809, 2.8696>, <-2.03722, 87.4953, 3.2344> }
					triangle { <-2.03722, 87.4953, 3.2344>, <-1.8362, 86.8636, 3.9373>, <-1.729, 87.4589, 3.188> }
					triangle { <-1.1581, 87.3293, 2.6081>, <-1.2553, 87.3987, 2.6297>, <-1.5915, 87.4946, 2.9482> }
					triangle { <-1.2553, 87.3987, 2.6297>, <-1.3918, 86.9846, 2.3223>, <-1.8314, 87.3452, 2.6264> }
					triangle { <-1.5915, 87.4946, 2.9482>, <-1.8314, 87.3452, 2.6264>, <-1.9036, 87.3809, 2.8696> }
					triangle { <-1.5915, 87.4946, 2.9482>, <-1.2553, 87.3987, 2.6297>, <-1.8314, 87.3452, 2.6264> }
					triangle { <-1.4792, 87.5905, 3.3006>, <-1.1581, 87.3293, 2.6081>, <-1.5915, 87.4946, 2.9482> }
					triangle { <-1.729, 87.4589, 3.188>, <-1.5915, 87.4946, 2.9482>, <-1.9036, 87.3809, 2.8696> }
					triangle { <-1.4792, 87.5905, 3.3006>, <-1.5915, 87.4946, 2.9482>, <-1.729, 87.4589, 3.188> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-1.5163, 85.8471, 4.707>, <-1.7777, 87.5305, 3.2521>, <-2.008789, 87.605, 3.435> }
					triangle { <-1.5163, 85.8471, 4.707>, <-1.5001, 86.7494, 3.8659>, <-1.7777, 87.5305, 3.2521> }
					triangle { <-2.008789, 87.605, 3.435>, <-1.7282, 87.01543, 4.1429>, <-1.5163, 85.8471, 4.707> }
					triangle { <-1.5001, 86.7494, 3.8659>, <-1.8955, 87.3473, 3.002385>, <-1.7777, 87.5305, 3.2521> }
					triangle { <-1.8955, 87.3473, 3.002385>, <-2.3778, 87.3224, 2.7547>, <-1.7777, 87.5305, 3.2521> }
					triangle { <-2.008789, 87.605, 3.435>, <-2.3584, 87.7303, 3.4329>, <-2.04338, 87.8012, 3.6774> }
					triangle { <-2.04338, 87.8012, 3.6774>, <-1.7282, 87.01543, 4.1429>, <-2.008789, 87.605, 3.435> }
					triangle { <-2.3778, 87.3224, 2.7547>, <-2.3541, 87.427, 2.8116>, <-2.1457, 87.6144, 3.1925> }
					triangle { <-2.3541, 87.427, 2.8116>, <-2.8518, 87.2691, 2.9208>, <-2.553, 87.7241, 3.2665> }
					triangle { <-2.1457, 87.6144, 3.1925>, <-2.553, 87.7241, 3.2665>, <-2.3584, 87.7303, 3.4329> }
					triangle { <-2.1457, 87.6144, 3.1925>, <-2.3541, 87.427, 2.8116>, <-2.553, 87.7241, 3.2665> }
					triangle { <-1.7777, 87.5305, 3.2521>, <-2.3778, 87.3224, 2.7547>, <-2.1457, 87.6144, 3.1925> }
					triangle { <-2.008789, 87.605, 3.435>, <-2.1457, 87.6144, 3.1925>, <-2.3584, 87.7303, 3.4329> }
					triangle { <-1.7777, 87.5305, 3.2521>, <-2.1457, 87.6144, 3.1925>, <-2.008789, 87.605, 3.435> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-1.4431, 84.2933, 5.5284>, <-1.452, 84.681, 5.4651>, 0.2183 }
			cylinder { <-1.452, 84.681, 5.4651>, <-1.4784, 85.07191, 5.436>, 0.2183 }
			cylinder { <-1.4784, 85.07191, 5.436>, <-1.522, 85.4623, 5.4414>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.522, 85.4623, 5.4414>, <-1.619, 86.03902, 5.5139>, 0.2183 }
				cylinder { <-1.619, 86.03902, 5.5139>, <-1.7459, 86.5982, 5.6497>, 0.2183 }
				cylinder { <-1.7459, 86.5982, 5.6497>, <-1.9009, 87.1314, 5.8469>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-1.9009, 87.1314, 5.8469>, <-2.2755, 89.1443, 6.7408>, <-2.1883, 89.2422, 6.4675> }
					triangle { <-1.9009, 87.1314, 5.8469>, <-2.206, 88.161, 6.4473>, <-2.2755, 89.1443, 6.7408> }
					triangle { <-2.1883, 89.2422, 6.4675>, <-2.2557, 88.3753, 6.05998>, <-1.9009, 87.1314, 5.8469> }
					triangle { <-2.206, 88.161, 6.4473>, <-2.01338, 89.1461, 6.942>, <-2.2755, 89.1443, 6.7408> }
					triangle { <-2.01338, 89.1461, 6.942>, <-1.5608, 89.4426, 6.9586>, <-2.2755, 89.1443, 6.7408> }
					triangle { <-2.1883, 89.2422, 6.4675>, <-1.9894, 89.5051, 6.2986>, <-2.3383, 89.3241, 6.2054> }
					triangle { <-2.3383, 89.3241, 6.2054>, <-2.2557, 88.3753, 6.05998>, <-2.1883, 89.2422, 6.4675> }
					triangle { <-1.5608, 89.4426, 6.9586>, <-1.654, 89.4939, 6.9009>, <-2.02351, 89.4041, 6.6219> }
					triangle { <-1.654, 89.4939, 6.9009>, <-1.2084, 89.5571, 6.6175>, <-1.7913, 89.6527, 6.3635> }
					triangle { <-2.02351, 89.4041, 6.6219>, <-1.7913, 89.6527, 6.3635>, <-1.9894, 89.5051, 6.2986> }
					triangle { <-2.02351, 89.4041, 6.6219>, <-1.654, 89.4939, 6.9009>, <-1.7913, 89.6527, 6.3635> }
					triangle { <-2.2755, 89.1443, 6.7408>, <-1.5608, 89.4426, 6.9586>, <-2.02351, 89.4041, 6.6219> }
					triangle { <-2.1883, 89.2422, 6.4675>, <-2.02351, 89.4041, 6.6219>, <-1.9894, 89.5051, 6.2986> }
					triangle { <-2.2755, 89.1443, 6.7408>, <-2.02351, 89.4041, 6.6219>, <-2.1883, 89.2422, 6.4675> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-1.9009, 87.1314, 5.8469>, <-2.2906, 89.2452, 6.4562>, <-2.5245, 89.2193, 6.2652> }
					triangle { <-1.9009, 87.1314, 5.8469>, <-2.0269, 88.2605, 6.3189>, <-2.2906, 89.2452, 6.4562> }
					triangle { <-2.5245, 89.2193, 6.2652>, <-2.4573, 88.2633, 6.2043>, <-1.9009, 87.1314, 5.8469> }
					triangle { <-2.0269, 88.2605, 6.3189>, <-2.03609, 89.3793, 6.2936>, <-2.2906, 89.2452, 6.4562> }
					triangle { <-2.03609, 89.3793, 6.2936>, <-2.001999, 89.7164, 5.8715>, <-2.2906, 89.2452, 6.4562> }
					triangle { <-2.5245, 89.2193, 6.2652>, <-2.714, 89.4029, 6.005361>, <-2.8274, 89.1479, 6.2973> }
					triangle { <-2.8274, 89.1479, 6.2973>, <-2.4573, 88.2633, 6.2043>, <-2.5245, 89.2193, 6.2652> }
					triangle { <-2.001999, 89.7164, 5.8715>, <-2.1064, 89.7205, 5.9326>, <-2.4195, 89.4572, 6.1671> }
					triangle { <-2.1064, 89.7205, 5.9326>, <-2.2023, 89.715, 5.4094>, <-2.6617, 89.5925, 5.8423> }
					triangle { <-2.4195, 89.4572, 6.1671>, <-2.6617, 89.5925, 5.8423>, <-2.714, 89.4029, 6.005361> }
					triangle { <-2.4195, 89.4572, 6.1671>, <-2.1064, 89.7205, 5.9326>, <-2.6617, 89.5925, 5.8423> }
					triangle { <-2.2906, 89.2452, 6.4562>, <-2.001999, 89.7164, 5.8715>, <-2.4195, 89.4572, 6.1671> }
					triangle { <-2.5245, 89.2193, 6.2652>, <-2.4195, 89.4572, 6.1671>, <-2.714, 89.4029, 6.005361> }
					triangle { <-2.2906, 89.2452, 6.4562>, <-2.4195, 89.4572, 6.1671>, <-2.5245, 89.2193, 6.2652> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-1.9009, 87.1314, 5.8469>, <-2.5719, 89.201, 6.3547>, <-2.7965, 89.05485, 6.4963> }
					triangle { <-1.9009, 87.1314, 5.8469>, <-2.1126, 88.3166, 6.09985>, <-2.5719, 89.201, 6.3547> }
					triangle { <-2.7965, 89.05485, 6.4963>, <-2.3609, 88.2002, 6.4508>, <-1.9009, 87.1314, 5.8469> }
					triangle { <-2.1126, 88.3166, 6.09985>, <-2.6743, 89.2833, 6.05154>, <-2.5719, 89.201, 6.3547> }
					triangle { <-2.6743, 89.2833, 6.05154>, <-3.1614, 89.3906, 5.8412>, <-2.5719, 89.201, 6.3547> }
					triangle { <-2.7965, 89.05485, 6.4963>, <-3.1609, 89.06745, 6.5614>, <-2.8459, 88.9602, 6.7904> }
					triangle { <-2.8459, 88.9602, 6.7904>, <-2.3609, 88.2002, 6.4508>, <-2.7965, 89.05485, 6.4963> }
					triangle { <-3.1614, 89.3906, 5.8412>, <-3.1523, 89.4061, 5.9609>, <-2.9514, 89.2344, 6.3515> }
					triangle { <-3.1523, 89.4061, 5.9609>, <-3.6022, 89.147, 5.845>, <-3.3634, 89.1669, 6.4417> }
					triangle { <-2.9514, 89.2344, 6.3515>, <-3.3634, 89.1669, 6.4417>, <-3.1609, 89.06745, 6.5614> }
					triangle { <-2.9514, 89.2344, 6.3515>, <-3.1523, 89.4061, 5.9609>, <-3.3634, 89.1669, 6.4417> }
					triangle { <-2.5719, 89.201, 6.3547>, <-3.1614, 89.3906, 5.8412>, <-2.9514, 89.2344, 6.3515> }
					triangle { <-2.7965, 89.05485, 6.4963>, <-2.9514, 89.2344, 6.3515>, <-3.1609, 89.06745, 6.5614> }
					triangle { <-2.5719, 89.201, 6.3547>, <-2.9514, 89.2344, 6.3515>, <-2.7965, 89.05485, 6.4963> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-1.9009, 87.1314, 5.8469>, <-2.7333, 89.07243, 6.5756>, <-2.6309, 88.9745, 6.8436> }
					triangle { <-1.9009, 87.1314, 5.8469>, <-2.3455, 88.2523, 6.09076>, <-2.7333, 89.07243, 6.5756> }
					triangle { <-2.6309, 88.9745, 6.8436>, <-2.09885, 88.2726, 6.461>, <-1.9009, 87.1314, 5.8469> }
					triangle { <-2.3455, 88.2523, 6.09076>, <-3.05213, 88.9899, 6.548>, <-2.7333, 89.07243, 6.5756> }
					triangle { <-3.05213, 88.9899, 6.548>, <-3.4476, 88.9125, 6.9092>, <-2.7333, 89.07243, 6.5756> }
					triangle { <-2.6309, 88.9745, 6.8436>, <-2.7166, 88.959, 7.2036>, <-2.3683, 89.01863, 7.007906> }
					triangle { <-2.3683, 89.01863, 7.007906>, <-2.09885, 88.2726, 6.461>, <-2.6309, 88.9745, 6.8436> }
					triangle { <-3.4476, 88.9125, 6.9092>, <-3.3561, 88.9821, 6.947>, <-2.889, 89.04166, 6.9219> }
					triangle { <-3.3561, 88.9821, 6.947>, <-3.4866, 88.6328, 7.3263>, <-2.9333, 88.9601, 7.3389> }
					triangle { <-2.889, 89.04166, 6.9219>, <-2.9333, 88.9601, 7.3389>, <-2.7166, 88.959, 7.2036> }
					triangle { <-2.889, 89.04166, 6.9219>, <-3.3561, 88.9821, 6.947>, <-2.9333, 88.9601, 7.3389> }
					triangle { <-2.7333, 89.07243, 6.5756>, <-3.4476, 88.9125, 6.9092>, <-2.889, 89.04166, 6.9219> }
					triangle { <-2.6309, 88.9745, 6.8436>, <-2.889, 89.04166, 6.9219>, <-2.7166, 88.959, 7.2036> }
					triangle { <-2.7333, 89.07243, 6.5756>, <-2.889, 89.04166, 6.9219>, <-2.6309, 88.9745, 6.8436> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-1.9009, 87.1314, 5.8469>, <-2.5473, 89.03688, 6.8178>, <-2.2494, 89.09213, 6.8255> }
					triangle { <-1.9009, 87.1314, 5.8469>, <-2.4042, 88.1546, 6.3087>, <-2.5473, 89.03688, 6.8178> }
					triangle { <-2.2494, 89.09213, 6.8255>, <-2.03287, 88.3824, 6.2158>, <-1.9009, 87.1314, 5.8469> }
					triangle { <-2.4042, 88.1546, 6.3087>, <-2.6374, 88.9039, 7.1066>, <-2.5473, 89.03688, 6.8178> }
					triangle { <-2.6374, 88.9039, 7.1066>, <-2.4435, 88.9451, 7.6103>, <-2.5473, 89.03688, 6.8178> }
					triangle { <-2.2494, 89.09213, 6.8255>, <-1.9817, 89.2336, 7.03874>, <-2.04991, 89.2469, 6.6408> }
					triangle { <-2.04991, 89.2469, 6.6408>, <-2.03287, 88.3824, 6.2158>, <-2.2494, 89.09213, 6.8255> }
					triangle { <-2.4435, 88.9451, 7.6103>, <-2.4162, 89.03726, 7.5367>, <-2.3069, 89.1481, 7.09162> }
					triangle { <-2.4162, 89.03726, 7.5367>, <-1.9848, 88.8901, 7.811>, <-1.947, 89.2649, 7.2898> }
					triangle { <-2.3069, 89.1481, 7.09162>, <-1.947, 89.2649, 7.2898>, <-1.9817, 89.2336, 7.03874> }
					triangle { <-2.3069, 89.1481, 7.09162>, <-2.4162, 89.03726, 7.5367>, <-1.947, 89.2649, 7.2898> }
					triangle { <-2.5473, 89.03688, 6.8178>, <-2.4435, 88.9451, 7.6103>, <-2.3069, 89.1481, 7.09162> }
					triangle { <-2.2494, 89.09213, 6.8255>, <-2.3069, 89.1481, 7.09162>, <-1.9817, 89.2336, 7.03874> }
					triangle { <-2.5473, 89.03688, 6.8178>, <-2.3069, 89.1481, 7.09162>, <-2.2494, 89.09213, 6.8255> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-1.4217, 78.4743, 5.8518>, <-1.5494, 78.8289, 5.9627>, 0.2183 }
			cylinder { <-1.5494, 78.8289, 5.9627>, <-1.7123, 79.1681, 6.07566>, 0.2183 }
			cylinder { <-1.7123, 79.1681, 6.07566>, <-1.9089, 79.4886, 6.1894>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <-1.9089, 79.4886, 6.1894>, <-2.1625, 79.7557, 6.3262>, 0.2183 }
			cylinder { <-2.1625, 79.7557, 6.3262>, <-2.3887, 80.03333, 6.4879>, 0.2183 }
			cylinder { <-2.3887, 80.03333, 6.4879>, <-2.5851, 80.3188, 6.6728>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.5851, 80.3188, 6.6728>, <-2.8202, 80.7562, 6.9902>, 0.2183 }
				cylinder { <-2.8202, 80.7562, 6.9902>, <-2.9922, 81.1961, 7.3426>, 0.2183 }
				cylinder { <-2.9922, 81.1961, 7.3426>, <-3.09848, 81.6317, 7.7249>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-3.09848, 81.6317, 7.7249>, <-3.3696, 83.4368, 9.01312>, <-3.6536, 83.425, 8.9078> }
					triangle { <-3.09848, 81.6317, 7.7249>, <-3.1153, 82.5712, 8.519>, <-3.3696, 83.4368, 9.01312> }
					triangle { <-3.6536, 83.425, 8.9078>, <-3.5582, 82.5375, 8.5536>, <-3.09848, 81.6317, 7.7249> }
					triangle { <-3.1153, 82.5712, 8.519>, <-3.1957, 83.6449, 8.8243>, <-3.3696, 83.4368, 9.01312> }
					triangle { <-3.1957, 83.6449, 8.8243>, <-3.3299, 84.07933, 8.5305>, <-3.3696, 83.4368, 9.01312> }
					triangle { <-3.6536, 83.425, 8.9078>, <-3.9318, 83.6376, 8.787>, <-3.9218, 83.3026, 9.01252> }
					triangle { <-3.9218, 83.3026, 9.01252>, <-3.5582, 82.5375, 8.5536>, <-3.6536, 83.425, 8.9078> }
					triangle { <-3.3299, 84.07933, 8.5305>, <-3.4065, 84.05186, 8.6201>, <-3.6029, 83.6931, 8.8549> }
					triangle { <-3.4065, 84.05186, 8.6201>, <-3.6782, 84.1649, 8.177>, <-3.9503, 83.868, 8.6784> }
					triangle { <-3.6029, 83.6931, 8.8549>, <-3.9503, 83.868, 8.6784>, <-3.9318, 83.6376, 8.787> }
					triangle { <-3.6029, 83.6931, 8.8549>, <-3.4065, 84.05186, 8.6201>, <-3.9503, 83.868, 8.6784> }
					triangle { <-3.3696, 83.4368, 9.01312>, <-3.3299, 84.07933, 8.5305>, <-3.6029, 83.6931, 8.8549> }
					triangle { <-3.6536, 83.425, 8.9078>, <-3.6029, 83.6931, 8.8549>, <-3.9318, 83.6376, 8.787> }
					triangle { <-3.3696, 83.4368, 9.01312>, <-3.6029, 83.6931, 8.8549>, <-3.6536, 83.425, 8.9078> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-3.09848, 81.6317, 7.7249>, <-3.6657, 83.3776, 8.9983>, <-3.8183, 83.1678, 9.1551> }
					triangle { <-3.09848, 81.6317, 7.7249>, <-3.275, 82.6674, 8.3649>, <-3.6657, 83.3776, 8.9983> }
					triangle { <-3.8183, 83.1678, 9.1551>, <-3.3785, 82.4293, 8.7269>, <-3.09848, 81.6317, 7.7249> }
					triangle { <-3.275, 82.6674, 8.3649>, <-3.8719, 83.5177, 8.7813>, <-3.6657, 83.3776, 8.9983> }
					triangle { <-3.8719, 83.5177, 8.7813>, <-4.4069, 83.5995, 8.7779>, <-3.6657, 83.3776, 8.9983> }
					triangle { <-3.8183, 83.1678, 9.1551>, <-4.1372, 83.1079, 9.3336>, <-3.7567, 82.9952, 9.4087> }
					triangle { <-3.7567, 82.9952, 9.4087>, <-3.3785, 82.4293, 8.7269>, <-3.8183, 83.1678, 9.1551> }
					triangle { <-4.4069, 83.5995, 8.7779>, <-4.3575, 83.5852, 8.8875>, <-4.02381, 83.3527, 9.126> }
					triangle { <-4.3575, 83.5852, 8.8875>, <-4.8043, 83.2989, 8.851>, <-4.374, 83.2026, 9.319> }
					triangle { <-4.02381, 83.3527, 9.126>, <-4.374, 83.2026, 9.319>, <-4.1372, 83.1079, 9.3336> }
					triangle { <-4.02381, 83.3527, 9.126>, <-4.3575, 83.5852, 8.8875>, <-4.374, 83.2026, 9.319> }
					triangle { <-3.6657, 83.3776, 8.9983>, <-4.4069, 83.5995, 8.7779>, <-4.02381, 83.3527, 9.126> }
					triangle { <-3.8183, 83.1678, 9.1551>, <-4.02381, 83.3527, 9.126>, <-4.1372, 83.1079, 9.3336> }
					triangle { <-3.6657, 83.3776, 8.9983>, <-4.02381, 83.3527, 9.126>, <-3.8183, 83.1678, 9.1551> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-3.09848, 81.6317, 7.7249>, <-3.7325, 83.1741, 9.2116>, <-3.5378, 83.02812, 9.3924> }
					triangle { <-3.09848, 81.6317, 7.7249>, <-3.4926, 82.5728, 8.4123>, <-3.7325, 83.1741, 9.2116> }
					triangle { <-3.5378, 83.02812, 9.3924>, <-3.1338, 82.5357, 8.6737>, <-3.09848, 81.6317, 7.7249> }
					triangle { <-3.4926, 82.5728, 8.4123>, <-4.03581, 83.05392, 9.2643>, <-3.7325, 83.1741, 9.2116> }
					triangle { <-4.03581, 83.05392, 9.2643>, <-4.2756, 82.828, 9.6938>, <-3.7325, 83.1741, 9.2116> }
					triangle { <-3.5378, 83.02812, 9.3924>, <-3.4916, 82.9089, 9.74>, <-3.2374, 83.06844, 9.4697> }
					triangle { <-3.2374, 83.06844, 9.4697>, <-3.1338, 82.5357, 8.6737>, <-3.5378, 83.02812, 9.3924> }
					triangle { <-4.2756, 82.828, 9.6938>, <-4.1808, 82.8989, 9.7189>, <-3.7557, 83.0331, 9.5648> }
					triangle { <-4.1808, 82.8989, 9.7189>, <-4.151, 82.449, 10.00128>, <-3.6473, 82.8426, 9.9314> }
					triangle { <-3.7557, 83.0331, 9.5648>, <-3.6473, 82.8426, 9.9314>, <-3.4916, 82.9089, 9.74> }
					triangle { <-3.7557, 83.0331, 9.5648>, <-4.1808, 82.8989, 9.7189>, <-3.6473, 82.8426, 9.9314> }
					triangle { <-3.7325, 83.1741, 9.2116>, <-4.2756, 82.828, 9.6938>, <-3.7557, 83.0331, 9.5648> }
					triangle { <-3.5378, 83.02812, 9.3924>, <-3.7557, 83.0331, 9.5648>, <-3.4916, 82.9089, 9.74> }
					triangle { <-3.7325, 83.1741, 9.2116>, <-3.7557, 83.0331, 9.5648>, <-3.5378, 83.02812, 9.3924> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-3.09848, 81.6317, 7.7249>, <-3.4783, 83.1056, 9.3603>, <-3.1972, 83.1976, 9.2938> }
					triangle { <-3.09848, 81.6317, 7.7249>, <-3.4693, 82.4173, 8.596>, <-3.4783, 83.1056, 9.3603> }
					triangle { <-3.1972, 83.1976, 9.2938>, <-3.1599, 82.7107, 8.467>, <-3.09848, 81.6317, 7.7249> }
					triangle { <-3.4693, 82.4173, 8.596>, <-3.4624, 82.8902, 9.6103>, <-3.4783, 83.1056, 9.3603> }
					triangle { <-3.4624, 82.8902, 9.6103>, <-3.1162, 82.8237, 10.02105>, <-3.4783, 83.1056, 9.3603> }
					triangle { <-3.1972, 83.1976, 9.2938>, <-2.8813, 83.3137, 9.4483>, <-3.07675, 83.4217, 9.1118> }
					triangle { <-3.07675, 83.4217, 9.1118>, <-3.1599, 82.7107, 8.467>, <-3.1972, 83.1976, 9.2938> }
					triangle { <-3.1162, 82.8237, 10.02105>, <-3.1188, 82.9348, 9.9731>, <-3.1668, 83.173, 9.569> }
					triangle { <-3.1188, 82.9348, 9.9731>, <-2.615, 82.7818, 10.04896>, <-2.7676, 83.2821, 9.6749> }
					triangle { <-3.1668, 83.173, 9.569>, <-2.7676, 83.2821, 9.6749>, <-2.8813, 83.3137, 9.4483> }
					triangle { <-3.1668, 83.173, 9.569>, <-3.1188, 82.9348, 9.9731>, <-2.7676, 83.2821, 9.6749> }
					triangle { <-3.4783, 83.1056, 9.3603>, <-3.1162, 82.8237, 10.02105>, <-3.1668, 83.173, 9.569> }
					triangle { <-3.1972, 83.1976, 9.2938>, <-3.1668, 83.173, 9.569>, <-2.8813, 83.3137, 9.4483> }
					triangle { <-3.4783, 83.1056, 9.3603>, <-3.1668, 83.173, 9.569>, <-3.1972, 83.1976, 9.2938> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-3.09848, 81.6317, 7.7249>, <-3.2507, 83.2705, 9.2357>, <-3.2699, 83.4466, 8.9898> }
					triangle { <-3.09848, 81.6317, 7.7249>, <-3.2327, 82.4163, 8.663>, <-3.2507, 83.2705, 9.2357> }
					triangle { <-3.2699, 83.4466, 8.9898>, <-3.4262, 82.7118, 8.3916>, <-3.09848, 81.6317, 7.7249> }
					triangle { <-3.2327, 82.4163, 8.663>, <-2.9354, 83.2609, 9.3342>, <-3.2507, 83.2705, 9.2357> }
					triangle { <-2.9354, 83.2609, 9.3342>, <-2.5228, 83.6087, 9.2912>, <-3.2507, 83.2705, 9.2357> }
					triangle { <-3.2699, 83.4466, 8.9898>, <-3.1574, 83.7708, 8.8505>, <-3.5061, 83.5686, 8.8249> }
					triangle { <-3.5061, 83.5686, 8.8249>, <-3.4262, 82.7118, 8.3916>, <-3.2699, 83.4466, 8.9898> }
					triangle { <-2.5228, 83.6087, 9.2912>, <-2.6331, 83.6581, 9.2838>, <-3.07095, 83.5871, 9.1237> }
					triangle { <-2.6331, 83.6581, 9.2838>, <-2.3184, 83.8583, 8.9045>, <-2.9577, 83.9255, 8.8888> }
					triangle { <-3.07095, 83.5871, 9.1237>, <-2.9577, 83.9255, 8.8888>, <-3.1574, 83.7708, 8.8505> }
					triangle { <-3.07095, 83.5871, 9.1237>, <-2.6331, 83.6581, 9.2838>, <-2.9577, 83.9255, 8.8888> }
					triangle { <-3.2507, 83.2705, 9.2357>, <-2.5228, 83.6087, 9.2912>, <-3.07095, 83.5871, 9.1237> }
					triangle { <-3.2699, 83.4466, 8.9898>, <-3.07095, 83.5871, 9.1237>, <-3.1574, 83.7708, 8.8505> }
					triangle { <-3.2507, 83.2705, 9.2357>, <-3.07095, 83.5871, 9.1237>, <-3.2699, 83.4466, 8.9898> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <-1.9089, 79.4886, 6.1894>, <-2.04016, 79.8488, 6.2754>, 0.2183 }
			cylinder { <-2.04016, 79.8488, 6.2754>, <-2.2009, 80.2018, 6.3376>, 0.2183 }
			cylinder { <-2.2009, 80.2018, 6.3376>, <-2.3897, 80.5442, 6.3757>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.3897, 80.5442, 6.3757>, <-2.7216, 81.03109, 6.3865>, 0.2183 }
				cylinder { <-2.7216, 81.03109, 6.3865>, <-3.09724, 81.4837, 6.3509>, 0.2183 }
				cylinder { <-3.09724, 81.4837, 6.3509>, <-3.5108, 81.8955, 6.2696>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <-3.5108, 81.8955, 6.2696>, <-5.2232, 83.3236, 6.1294>, <-5.04137, 83.5018, 6.2939> }
					triangle { <-3.5108, 81.8955, 6.2696>, <-4.4999, 82.5957, 6.05775>, <-5.2232, 83.3236, 6.1294> }
					triangle { <-5.04137, 83.5018, 6.2939>, <-4.2615, 82.9626, 6.1414>, <-3.5108, 81.8955, 6.2696> }
					triangle { <-4.4999, 82.5957, 6.05775>, <-5.4252, 83.1612, 6.3345>, <-5.2232, 83.3236, 6.1294> }
					triangle { <-5.4252, 83.1612, 6.3345>, <-5.6278, 83.2758, 6.8231>, <-5.2232, 83.3236, 6.1294> }
					triangle { <-5.04137, 83.5018, 6.2939>, <-5.04114, 83.7423, 6.5755>, <-4.8379, 83.7298, 6.2266> }
					triangle { <-4.8379, 83.7298, 6.2266>, <-4.2615, 82.9626, 6.1414>, <-5.04137, 83.5018, 6.2939> }
					triangle { <-5.6278, 83.2758, 6.8231>, <-5.5931, 83.3716, 6.7578>, <-5.2702, 83.5243, 6.4498> }
					triangle { <-5.5931, 83.3716, 6.7578>, <-5.4213, 83.4215, 7.2588>, <-5.1885, 83.7824, 6.7802> }
					triangle { <-5.2702, 83.5243, 6.4498>, <-5.1885, 83.7824, 6.7802>, <-5.04114, 83.7423, 6.5755> }
					triangle { <-5.2702, 83.5243, 6.4498>, <-5.5931, 83.3716, 6.7578>, <-5.1885, 83.7824, 6.7802> }
					triangle { <-5.2232, 83.3236, 6.1294>, <-5.6278, 83.2758, 6.8231>, <-5.2702, 83.5243, 6.4498> }
					triangle { <-5.04137, 83.5018, 6.2939>, <-5.2702, 83.5243, 6.4498>, <-5.04114, 83.7423, 6.5755> }
					triangle { <-5.2232, 83.3236, 6.1294>, <-5.2702, 83.5243, 6.4498>, <-5.04137, 83.5018, 6.2939> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-3.5108, 81.8955, 6.2696>, <-5.02283, 83.5388, 6.1996>, <-4.8208, 83.668, 6.01422> }
					triangle { <-3.5108, 81.8955, 6.2696>, <-4.4541, 82.6852, 6.2777>, <-5.02283, 83.5388, 6.1996> }
					triangle { <-4.8208, 83.668, 6.01422>, <-4.313, 82.8619, 5.8939>, <-3.5108, 81.8955, 6.2696> }
					triangle { <-4.4541, 82.6852, 6.2777>, <-4.9714, 83.651, 6.5062>, <-5.02283, 83.5388, 6.1996> }
					triangle { <-4.9714, 83.651, 6.5062>, <-4.7703, 84.1134, 6.7028>, <-5.02283, 83.5388, 6.1996> }
					triangle { <-4.8208, 83.668, 6.01422>, <-4.6645, 83.993, 5.9298>, <-4.7842, 83.6805, 5.7037> }
					triangle { <-4.7842, 83.6805, 5.7037>, <-4.313, 82.8619, 5.8939>, <-4.8208, 83.668, 6.01422> }
					triangle { <-4.7703, 84.1134, 6.7028>, <-4.815, 84.1201, 6.5906>, <-4.8608, 83.8833, 6.1854> }
					triangle { <-4.815, 84.1201, 6.5906>, <-4.3476, 84.3729, 6.6152>, <-4.6194, 84.2109, 6.05545> }
					triangle { <-4.8608, 83.8833, 6.1854>, <-4.6194, 84.2109, 6.05545>, <-4.6645, 83.993, 5.9298> }
					triangle { <-4.8608, 83.8833, 6.1854>, <-4.815, 84.1201, 6.5906>, <-4.6194, 84.2109, 6.05545> }
					triangle { <-5.02283, 83.5388, 6.1996>, <-4.7703, 84.1134, 6.7028>, <-4.8608, 83.8833, 6.1854> }
					triangle { <-4.8208, 83.668, 6.01422>, <-4.8608, 83.8833, 6.1854>, <-4.6645, 83.993, 5.9298> }
					triangle { <-5.02283, 83.5388, 6.1996>, <-4.8608, 83.8833, 6.1854>, <-4.8208, 83.668, 6.01422> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-3.5108, 81.8955, 6.2696>, <-4.8851, 83.6268, 5.9453>, <-4.9154, 83.5049, 5.6694> }
					triangle { <-3.5108, 81.8955, 6.2696>, <-4.2821, 82.8539, 6.2567>, <-4.8851, 83.6268, 5.9453> }
					triangle { <-4.9154, 83.5049, 5.6694>, <-4.5065, 82.6722, 5.9176>, <-3.5108, 81.8955, 6.2696> }
					triangle { <-4.2821, 82.8539, 6.2567>, <-4.6509, 83.8595, 5.9325>, <-4.8851, 83.6268, 5.9453> }
					triangle { <-4.6509, 83.8595, 5.9325>, <-4.4713, 84.1836, 5.5379>, <-4.8851, 83.6268, 5.9453> }
					triangle { <-4.9154, 83.5049, 5.6694>, <-4.9419, 83.592, 5.3104>, <-5.1207, 83.3094, 5.5369> }
					triangle { <-5.1207, 83.3094, 5.5369>, <-4.5065, 82.6722, 5.9176>, <-4.9154, 83.5049, 5.6694> }
					triangle { <-4.4713, 84.1836, 5.5379>, <-4.5838, 84.1415, 5.523>, <-4.8608, 83.766, 5.5914> }
					triangle { <-4.5838, 84.1415, 5.523>, <-4.3131, 84.1016, 5.06684>, <-4.8656, 83.7876, 5.1649> }
					triangle { <-4.8608, 83.766, 5.5914>, <-4.8656, 83.7876, 5.1649>, <-4.9419, 83.592, 5.3104> }
					triangle { <-4.8608, 83.766, 5.5914>, <-4.5838, 84.1415, 5.523>, <-4.8656, 83.7876, 5.1649> }
					triangle { <-4.8851, 83.6268, 5.9453>, <-4.4713, 84.1836, 5.5379>, <-4.8608, 83.766, 5.5914> }
					triangle { <-4.9154, 83.5049, 5.6694>, <-4.8608, 83.766, 5.5914>, <-4.9419, 83.592, 5.3104> }
					triangle { <-4.8851, 83.6268, 5.9453>, <-4.8608, 83.766, 5.5914>, <-4.9154, 83.5049, 5.6694> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-3.5108, 81.8955, 6.2696>, <-4.9992, 83.4668, 5.7155>, <-5.1953, 83.2363, 5.7327> }
					triangle { <-3.5108, 81.8955, 6.2696>, <-4.2199, 82.8702, 6.02357>, <-4.9992, 83.4668, 5.7155> }
					triangle { <-5.1953, 83.2363, 5.7327>, <-4.5764, 82.6538, 6.1799>, <-3.5108, 81.8955, 6.2696> }
					triangle { <-4.2199, 82.8702, 6.02357>, <-4.9036, 83.5006, 5.401>, <-4.9992, 83.4668, 5.7155> }
					triangle { <-4.9036, 83.5006, 5.401>, <-5.1412, 83.3899, 4.9274>, <-4.9992, 83.4668, 5.7155> }
					triangle { <-5.1953, 83.2363, 5.7327>, <-5.4925, 83.08973, 5.5674>, <-5.3856, 83.126, 5.9552> }
					triangle { <-5.3856, 83.126, 5.9552>, <-4.5764, 82.6538, 6.1799>, <-5.1953, 83.2363, 5.7327> }
					triangle { <-5.1412, 83.3899, 4.9274>, <-5.2168, 83.4063, 5.02054>, <-5.2702, 83.3333, 5.4833> }
					triangle { <-5.2168, 83.4063, 5.02054>, <-5.3652, 82.98, 4.739>, <-5.5892, 83.09361, 5.331> }
					triangle { <-5.2702, 83.3333, 5.4833>, <-5.5892, 83.09361, 5.331>, <-5.4925, 83.08973, 5.5674> }
					triangle { <-5.2702, 83.3333, 5.4833>, <-5.2168, 83.4063, 5.02054>, <-5.5892, 83.09361, 5.331> }
					triangle { <-4.9992, 83.4668, 5.7155>, <-5.1412, 83.3899, 4.9274>, <-5.2702, 83.3333, 5.4833> }
					triangle { <-5.1953, 83.2363, 5.7327>, <-5.2702, 83.3333, 5.4833>, <-5.4925, 83.08973, 5.5674> }
					triangle { <-4.9992, 83.4668, 5.7155>, <-5.2702, 83.3333, 5.4833>, <-5.1953, 83.2363, 5.7327> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <-3.5108, 81.8955, 6.2696>, <-5.2113, 83.2766, 5.831>, <-5.2742, 83.2344, 6.1245> }
					triangle { <-3.5108, 81.8955, 6.2696>, <-4.3566, 82.7083, 5.8987>, <-5.2113, 83.2766, 5.831> }
					triangle { <-5.2742, 83.2344, 6.1245>, <-4.4227, 82.836, 6.3203>, <-3.5108, 81.8955, 6.2696> }
					triangle { <-4.3566, 82.7083, 5.8987>, <-5.3894, 83.06255, 5.6531>, <-5.2113, 83.2766, 5.831> }
					triangle { <-5.3894, 83.06255, 5.6531>, <-5.8668, 82.8204, 5.7337>, <-5.2113, 83.2766, 5.831> }
					triangle { <-5.2742, 83.2344, 6.1245>, <-5.5547, 83.184, 6.3611>, <-5.2082, 83.3897, 6.3879> }
					triangle { <-5.2082, 83.3897, 6.3879>, <-4.4227, 82.836, 6.3203>, <-5.2742, 83.2344, 6.1245> }
					triangle { <-5.8668, 82.8204, 5.7337>, <-5.85, 82.9233, 5.7952>, <-5.5271, 83.1817, 6.02189> }
					triangle { <-5.85, 82.9233, 5.7952>, <-6.06049, 82.5533, 6.1142>, <-5.7918, 83.09035, 6.3444> }
					triangle { <-5.5271, 83.1817, 6.02189>, <-5.7918, 83.09035, 6.3444>, <-5.5547, 83.184, 6.3611> }
					triangle { <-5.5271, 83.1817, 6.02189>, <-5.85, 82.9233, 5.7952>, <-5.7918, 83.09035, 6.3444> }
					triangle { <-5.2113, 83.2766, 5.831>, <-5.8668, 82.8204, 5.7337>, <-5.5271, 83.1817, 6.02189> }
					triangle { <-5.2742, 83.2344, 6.1245>, <-5.5271, 83.1817, 6.02189>, <-5.5547, 83.184, 6.3611> }
					triangle { <-5.2113, 83.2766, 5.831>, <-5.5271, 83.1817, 6.02189>, <-5.2742, 83.2344, 6.1245> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		}
	union { // internode
		cylinder { <-0.1419, 13.1361, -0.8708>, <-0.4812, 16.4919, -0.9632>, 0.5 }
		cylinder { <-0.4812, 16.4919, -0.9632>, <-0.651, 19.841, -0.589>, 0.5 }
		cylinder { <-0.651, 19.841, -0.589>, <-0.6477, 23.1109, 0.2436>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.6477, 23.1109, 0.2436>, <-0.4608, 24.4248, 1.09112>, 0.4999 }
			cylinder { <-0.4608, 24.4248, 1.09112>, <-0.1103, 25.373, 2.2983>, 0.4999 }
			cylinder { <-0.1103, 25.373, 2.2983>, <0.3625, 25.8448, 3.7242>, 0.4999 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.3625, 25.8448, 3.7242>, <0.5612, 26.04299, 4.3231>, 0.4999 }
				cylinder { <0.5612, 26.04299, 4.3231>, <0.7598, 26.2411, 4.922>, 0.4999 }
				cylinder { <0.7598, 26.2411, 4.922>, <0.9585, 26.4392, 5.5209>, 0.4999 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <0.9585, 26.4392, 5.5209>, <0.9634, 26.4727, 5.6422>, 0.03999 }
				cylinder { <0.9634, 26.4727, 5.6422>, <0.9352, 26.4996, 5.762>, 0.03999 }
				cylinder { <0.9352, 26.4996, 5.762>, <0.8758, 26.5178, 5.8716>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <0.8758, 26.5178, 5.8716>, <-1.6768, 26.9734, 11.05268>, <-2.1219, 26.8471, 10.8945> }
				triangle { <-1.6768, 26.9734, 11.05268>, <-2.1398, 25.05526, 12.4862>, <-2.1219, 26.8471, 10.8945> }
				triangle { <-1.6768, 26.9734, 11.05268>, <-1.686, 25.5171, 12.407>, <-2.1398, 25.05526, 12.4862> }
				triangle { <-2.1398, 25.05526, 12.4862>, <-2.5542, 25.4029, 11.9555>, <-2.1219, 26.8471, 10.8945> }
				triangle { <-2.1219, 26.8471, 10.8945>, <-1.1014, 26.3787, 8.857>, <0.8758, 26.5178, 5.8716> }
				triangle { <0.8758, 26.5178, 5.8716>, <-0.3361, 26.5144, 9.2491>, <-1.6768, 26.9734, 11.05268> }
				triangle { <-0.3361, 26.5144, 9.2491>, <-1.09048, 26.4762, 11.329>, <-1.6768, 26.9734, 11.05268> }
				triangle { <-1.09048, 26.4762, 11.329>, <-1.686, 25.5171, 12.407>, <-1.6768, 26.9734, 11.05268> }
				triangle { <-2.1219, 26.8471, 10.8945>, <-2.5542, 25.4029, 11.9555>, <-2.3693, 26.06114, 10.8912> }
				triangle { <-2.3693, 26.06114, 10.8912>, <-1.1014, 26.3787, 8.857>, <-2.1219, 26.8471, 10.8945> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <0.9585, 26.4392, 5.5209>, <0.9963, 26.477, 5.6349>, 0.03999 }
				cylinder { <0.9963, 26.477, 5.6349>, <1.03418, 26.5147, 5.749>, 0.03999 }
				cylinder { <1.03418, 26.5147, 5.749>, <1.07201, 26.5525, 5.8631>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <1.07201, 26.5525, 5.8631>, <2.9855, 27.882, 11.1676>, <2.5465, 27.8567, 11.3812> }
				triangle { <2.9855, 27.882, 11.1676>, <3.4154, 26.2095, 12.89>, <2.5465, 27.8567, 11.3812> }
				triangle { <2.9855, 27.882, 11.1676>, <3.7382, 26.5453, 12.4333>, <3.4154, 26.2095, 12.89> }
				triangle { <3.4154, 26.2095, 12.89>, <2.7988, 26.6163, 12.7215>, <2.5465, 27.8567, 11.3812> }
				triangle { <2.5465, 27.8567, 11.3812>, <1.7674, 27.04938, 9.3432>, <1.07201, 26.5525, 5.8631> }
				triangle { <1.07201, 26.5525, 5.8631>, <2.596, 27.02053, 9.07794>, <2.9855, 27.882, 11.1676> }
				triangle { <2.596, 27.02053, 9.07794>, <3.5242, 27.2755, 11.07041>, <2.9855, 27.882, 11.1676> }
				triangle { <3.5242, 27.2755, 11.07041>, <3.7382, 26.5453, 12.4333>, <2.9855, 27.882, 11.1676> }
				triangle { <2.5465, 27.8567, 11.3812>, <2.7988, 26.6163, 12.7215>, <2.2674, 27.1529, 11.7067> }
				triangle { <2.2674, 27.1529, 11.7067>, <1.7674, 27.04938, 9.3432>, <2.5465, 27.8567, 11.3812> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-0.6477, 23.1109, 0.2436>, <-0.5865, 26.3385, 1.2256>, 0.5 }
		cylinder { <-0.5865, 26.3385, 1.2256>, <-0.4676, 29.516, 2.3545>, 0.5 }
		cylinder { <-0.4676, 29.516, 2.3545>, <-0.2912, 32.6358, 3.6277>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.2912, 32.6358, 3.6277>, <-0.03041, 33.8097, 4.6442>, 0.4999 }
			cylinder { <-0.03041, 33.8097, 4.6442>, <0.3785, 34.5643, 5.9644>, 0.4999 }
			cylinder { <0.3785, 34.5643, 5.9644>, <0.8876, 34.8114, 7.4338>, 0.4999 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.8876, 34.8114, 7.4338>, <1.1015, 34.9152, 8.05096>, 0.4999 }
				cylinder { <1.1015, 34.9152, 8.05096>, <1.3154, 35.01903, 8.6681>, 0.4999 }
				cylinder { <1.3154, 35.01903, 8.6681>, <1.5292, 35.1228, 9.2852>, 0.4999 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <1.5292, 35.1228, 9.2852>, <1.54, 35.1393, 9.4096>, 0.03999 }
				cylinder { <1.54, 35.1393, 9.4096>, <1.5203, 35.1517, 9.5334>, 0.03999 }
				cylinder { <1.5203, 35.1517, 9.5334>, <1.4713, 35.1591, 9.6492>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <1.4713, 35.1591, 9.6492>, <-0.6141, 35.09742, 15.05431>, <-1.07624, 35.00695, 14.9229> }
				triangle { <-0.6141, 35.09742, 15.05431>, <-1.0441, 33.04271, 16.296>, <-1.07624, 35.00695, 14.9229> }
				triangle { <-0.6141, 35.09742, 15.05431>, <-0.5775, 33.4937, 16.2299>, <-1.0441, 33.04271, 16.296> }
				triangle { <-1.0441, 33.04271, 16.296>, <-1.4848, 33.4651, 15.8472>, <-1.07624, 35.00695, 14.9229> }
				triangle { <-1.07624, 35.00695, 14.9229>, <-0.2531, 34.7435, 12.7629>, <1.4713, 35.1591, 9.6492> }
				triangle { <1.4713, 35.1591, 9.6492>, <0.5478, 34.8042, 13.09858>, <-0.6141, 35.09742, 15.05431> }
				triangle { <0.5478, 34.8042, 13.09858>, <-0.0304, 34.5501, 15.2193>, <-0.6141, 35.09742, 15.05431> }
				triangle { <-0.0304, 34.5501, 15.2193>, <-0.5775, 33.4937, 16.2299>, <-0.6141, 35.09742, 15.05431> }
				triangle { <-1.07624, 35.00695, 14.9229>, <-1.4848, 33.4651, 15.8472>, <-1.3593, 34.2362, 14.8523> }
				triangle { <-1.3593, 34.2362, 14.8523>, <-0.2531, 34.7435, 12.7629>, <-1.07624, 35.00695, 14.9229> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <1.5292, 35.1228, 9.2852>, <1.5699, 35.1425, 9.4028>, 0.03999 }
				cylinder { <1.5699, 35.1425, 9.4028>, <1.6107, 35.1623, 9.5203>, 0.03999 }
				cylinder { <1.6107, 35.1623, 9.5203>, <1.6514, 35.1821, 9.6379>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <1.6514, 35.1821, 9.6379>, <3.6875, 35.6765, 15.03953>, <3.2514, 35.6318, 15.256> }
				triangle { <3.6875, 35.6765, 15.03953>, <4.09735, 33.7609, 16.4924>, <3.2514, 35.6318, 15.256> }
				triangle { <3.6875, 35.6765, 15.03953>, <4.4221, 34.1511, 16.08287>, <4.09735, 33.7609, 16.4924> }
				triangle { <4.09735, 33.7609, 16.4924>, <3.4898, 34.2037, 16.397>, <3.2514, 35.6318, 15.256> }
				triangle { <3.2514, 35.6318, 15.256>, <2.4168, 35.1497, 13.1386>, <1.6514, 35.1821, 9.6379> }
				triangle { <1.6514, 35.1821, 9.6379>, <3.2398, 35.1383, 12.8553>, <3.6875, 35.6765, 15.03953> }
				triangle { <3.2398, 35.1383, 12.8553>, <4.207, 35.07697, 14.8446>, <3.6875, 35.6765, 15.03953> }
				triangle { <4.207, 35.07697, 14.8446>, <4.4221, 34.1511, 16.08287>, <3.6875, 35.6765, 15.03953> }
				triangle { <3.2514, 35.6318, 15.256>, <3.4898, 34.2037, 16.397>, <2.9577, 34.8956, 15.4816> }
				triangle { <2.9577, 34.8956, 15.4816>, <2.4168, 35.1497, 13.1386>, <3.2514, 35.6318, 15.256> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-0.2912, 32.6358, 3.6277>, <0.05431, 35.5381, 5.3137>, 0.5 }
		cylinder { <0.05431, 35.5381, 5.3137>, <0.5616, 38.16, 7.3761>, 0.5 }
		cylinder { <0.5616, 38.16, 7.3761>, <1.2197, 40.4447, 9.7703>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.2197, 40.4447, 9.7703>, <1.6282, 41.05656, 11.05341>, 0.4696 }
			cylinder { <1.6282, 41.05656, 11.05341>, <2.1156, 41.2169, 12.4405>, 0.4696 }
			cylinder { <2.1156, 41.2169, 12.4405>, <2.6325, 40.9098, 13.7917>, 0.4696 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.6325, 40.9098, 13.7917>, <2.8496, 40.7808, 14.3592>, 0.4696 }
				cylinder { <2.8496, 40.7808, 14.3592>, <3.06676, 40.6518, 14.9268>, 0.4696 }
				cylinder { <3.06676, 40.6518, 14.9268>, <3.2838, 40.5227, 15.4943>, 0.4696 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <3.2838, 40.5227, 15.4943>, <3.2935, 40.498, 15.6022>, 0.03528 }
				cylinder { <3.2935, 40.498, 15.6022>, <3.2733, 40.4733, 15.7086>, 0.03528 }
				cylinder { <3.2733, 40.4733, 15.7086>, <3.2247, 40.4505, 15.8059>, 0.03528 }
				texture{chif1}}
			mesh { // leaf
				triangle { <3.2247, 40.4505, 15.8059>, <0.936, 38.932, 20.5038>, <0.5035, 38.9743, 20.3554> }
				triangle { <0.936, 38.932, 20.5038>, <0.1458, 36.8163, 20.8875>, <0.5035, 38.9743, 20.3554> }
				triangle { <0.936, 38.932, 20.5038>, <0.65, 37.1502, 20.986>, <0.1458, 36.8163, 20.8875> }
				triangle { <0.1458, 36.8163, 20.8875>, <-0.1684, 37.4034, 20.6363>, <0.5035, 38.9743, 20.3554> }
				triangle { <0.5035, 38.9743, 20.3554>, <1.3649, 39.3345, 18.3798>, <3.2247, 40.4505, 15.8059> }
				triangle { <3.2247, 40.4505, 15.8059>, <2.09292, 39.1423, 18.6986>, <0.936, 38.932, 20.5038> }
				triangle { <2.09292, 39.1423, 18.6986>, <1.3819, 38.3087, 20.4648>, <0.936, 38.932, 20.5038> }
				triangle { <1.3819, 38.3087, 20.4648>, <0.65, 37.1502, 20.986>, <0.936, 38.932, 20.5038> }
				triangle { <0.5035, 38.9743, 20.3554>, <-0.1684, 37.4034, 20.6363>, <0.1293, 38.3804, 20.02935> }
				triangle { <0.1293, 38.3804, 20.02935>, <1.3649, 39.3345, 18.3798>, <0.5035, 38.9743, 20.3554> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <3.2838, 40.5227, 15.4943>, <3.3227, 40.4997, 15.5958>, 0.03528 }
				cylinder { <3.3227, 40.4997, 15.5958>, <3.3615, 40.4766, 15.6973>, 0.03528 }
				cylinder { <3.3615, 40.4766, 15.6973>, <3.4004, 40.4535, 15.7989>, 0.03528 }
				texture{chif1}}
			mesh { // leaf
				triangle { <3.4004, 40.4535, 15.7989>, <5.3855, 38.9369, 20.6333>, <4.9757, 38.8983, 20.8369> }
				triangle { <5.3855, 38.9369, 20.6333>, <5.46, 36.7558, 21.3301>, <4.9757, 38.8983, 20.8369> }
				triangle { <5.3855, 38.9369, 20.6333>, <5.8221, 37.1725, 21.06434>, <5.46, 36.7558, 21.3301> }
				triangle { <5.46, 36.7558, 21.3301>, <4.9694, 37.2649, 21.4115>, <4.9757, 38.8983, 20.8369> }
				triangle { <4.9757, 38.8983, 20.8369>, <4.1171, 39.2459, 18.8578>, <3.4004, 40.4535, 15.7989> }
				triangle { <3.4004, 40.4535, 15.7989>, <4.8755, 39.1967, 18.5564>, <5.3855, 38.9369, 20.6333> }
				triangle { <4.8755, 39.1967, 18.5564>, <5.7682, 38.3919, 20.2521>, <5.3855, 38.9369, 20.6333> }
				triangle { <5.7682, 38.3919, 20.2521>, <5.8221, 37.1725, 21.06434>, <5.3855, 38.9369, 20.6333> }
				triangle { <4.9757, 38.8983, 20.8369>, <4.9694, 37.2649, 21.4115>, <4.5856, 38.2298, 20.8342> }
				triangle { <4.5856, 38.2298, 20.8342>, <4.1171, 39.2459, 18.8578>, <4.9757, 38.8983, 20.8369> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <1.2197, 40.4447, 9.7703>, <1.5812, 41.2052, 10.961>, 0.216 }
		cylinder { <1.5812, 41.2052, 10.961>, <2.006003, 41.7096, 12.2617>, 0.216 }
		cylinder { <2.006003, 41.7096, 12.2617>, <2.4775, 41.9385, 13.6226>, 0.216 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.4775, 41.9385, 13.6226>, <2.5265, 41.9127, 13.7515>, 0.04454 }
			cylinder { <2.5265, 41.9127, 13.7515>, <2.5734, 41.8422, 13.8633>, 0.04454 }
			cylinder { <2.5734, 41.8422, 13.8633>, <2.6127, 41.7351, 13.945>, 0.04454 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.6127, 41.7351, 13.945>, <2.6292, 41.6901, 13.9793>, 0.04454 }
				cylinder { <2.6292, 41.6901, 13.9793>, <2.6457, 41.6452, 14.01361>, 0.04454 }
				cylinder { <2.6457, 41.6452, 14.01361>, <2.6623, 41.6002, 14.04791>, 0.04454 }
				texture{chif1}}
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <2.4775, 41.9385, 13.6226>, <2.6159, 42.02488, 13.9548>, 0.2056 }
			cylinder { <2.6159, 42.02488, 13.9548>, <2.7716, 42.1386, 14.2708>, 0.2056 }
			cylinder { <2.7716, 42.1386, 14.2708>, <2.9432, 42.2787, 14.5674>, 0.2056 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <2.9432, 42.2787, 14.5674>, <3.129, 42.4437, 14.8417>, 0.2056 }
			cylinder { <3.129, 42.4437, 14.8417>, <3.3271, 42.6322, 15.09124>, 0.2056 }
			cylinder { <3.3271, 42.6322, 15.09124>, <3.5358, 42.8422, 15.3134>, 0.2056 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <3.5358, 42.8422, 15.3134>, <3.7173, 43.05059, 15.5597>, 0.2056 }
			cylinder { <3.7173, 43.05059, 15.5597>, <3.87, 43.2552, 15.8277>, 0.2056 }
			cylinder { <3.87, 43.2552, 15.8277>, <3.9923, 43.4542, 16.1149>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.9923, 43.4542, 16.1149>, <4.1165, 43.738, 16.5757>, 0.2056 }
				cylinder { <4.1165, 43.738, 16.5757>, <4.1794, 44.00292, 17.05961>, 0.2056 }
				cylinder { <4.1794, 44.00292, 17.05961>, <4.1802, 44.2449, 17.5593>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <4.1802, 44.2449, 17.5593>, <4.2449, 44.9885, 19.6717>, <4.5055, 45.1158, 19.5808> }
					triangle { <4.1802, 44.2449, 17.5593>, <4.05066, 44.631, 18.7238>, <4.2449, 44.9885, 19.6717> }
					triangle { <4.5055, 45.1158, 19.5808>, <4.33, 44.9706, 18.6451>, <4.1802, 44.2449, 17.5593> }
					triangle { <4.05066, 44.631, 18.7238>, <4.3134, 44.6966, 19.8129>, <4.2449, 44.9885, 19.6717> }
					triangle { <4.3134, 44.6966, 19.8129>, <4.7464, 44.5043, 20.07784>, <4.2449, 44.9885, 19.6717> }
					triangle { <4.5055, 45.1158, 19.5808>, <4.8535, 45.1861, 19.69>, <4.5863, 45.3989, 19.4723> }
					triangle { <4.5863, 45.3989, 19.4723>, <4.33, 44.9706, 18.6451>, <4.5055, 45.1158, 19.5808> }
					triangle { <4.7464, 44.5043, 20.07784>, <4.7358, 44.6252, 20.07681>, <4.6, 44.9932, 19.8125> }
					triangle { <4.7358, 44.6252, 20.07681>, <5.2397, 44.4859, 19.9709>, <5.0172, 45.08014, 19.856> }
					triangle { <4.6, 44.9932, 19.8125>, <5.0172, 45.08014, 19.856>, <4.8535, 45.1861, 19.69> }
					triangle { <4.6, 44.9932, 19.8125>, <4.7358, 44.6252, 20.07681>, <5.0172, 45.08014, 19.856> }
					triangle { <4.2449, 44.9885, 19.6717>, <4.7464, 44.5043, 20.07784>, <4.6, 44.9932, 19.8125> }
					triangle { <4.5055, 45.1158, 19.5808>, <4.6, 44.9932, 19.8125>, <4.8535, 45.1861, 19.69> }
					triangle { <4.2449, 44.9885, 19.6717>, <4.6, 44.9932, 19.8125>, <4.5055, 45.1158, 19.5808> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.1802, 44.2449, 17.5593>, <4.4414, 45.1961, 19.5708>, <4.3767, 45.4512, 19.4186> }
					triangle { <4.1802, 44.2449, 17.5593>, <4.2927, 44.6174, 18.73>, <4.4414, 45.1961, 19.5708> }
					triangle { <4.3767, 45.4512, 19.4186>, <4.05768, 44.986, 18.6382>, <4.1802, 44.2449, 17.5593> }
					triangle { <4.2927, 44.6174, 18.73>, <4.7708, 45.1629, 19.5863>, <4.4414, 45.1961, 19.5708> }
					triangle { <4.7708, 45.1629, 19.5863>, <5.1807, 45.5187, 19.5859>, <4.4414, 45.1961, 19.5708> }
					triangle { <4.3767, 45.4512, 19.4186>, <4.4711, 45.8091, 19.3889>, <4.1152, 45.6169, 19.3676> }
					triangle { <4.1152, 45.6169, 19.3676>, <4.05768, 44.986, 18.6382>, <4.3767, 45.4512, 19.4186> }
					triangle { <5.1807, 45.5187, 19.5859>, <5.07373, 45.563, 19.6221>, <4.6072, 45.5396, 19.548> }
					triangle { <5.07373, 45.563, 19.6221>, <5.3069, 45.9037, 19.2843>, <4.6819, 45.9465, 19.437> }
					triangle { <4.6072, 45.5396, 19.548>, <4.6819, 45.9465, 19.437>, <4.4711, 45.8091, 19.3889> }
					triangle { <4.6072, 45.5396, 19.548>, <5.07373, 45.563, 19.6221>, <4.6819, 45.9465, 19.437> }
					triangle { <4.4414, 45.1961, 19.5708>, <5.1807, 45.5187, 19.5859>, <4.6072, 45.5396, 19.548> }
					triangle { <4.3767, 45.4512, 19.4186>, <4.6072, 45.5396, 19.548>, <4.4711, 45.8091, 19.3889> }
					triangle { <4.4414, 45.1961, 19.5708>, <4.6072, 45.5396, 19.548>, <4.3767, 45.4512, 19.4186> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.1802, 44.2449, 17.5593>, <4.2839, 45.4293, 19.4581>, <3.9826, 45.4465, 19.4215> }
					triangle { <4.1802, 44.2449, 17.5593>, <4.3828, 44.82, 18.6318>, <4.2839, 45.4293, 19.4581> }
					triangle { <3.9826, 45.4465, 19.4215>, <3.9562, 44.7581, 18.7487>, <4.1802, 44.2449, 17.5593> }
					triangle { <4.3828, 44.82, 18.6318>, <4.422, 45.7004, 19.3266>, <4.2839, 45.4293, 19.4581> }
					triangle { <4.422, 45.7004, 19.3266>, <4.2465, 46.2087, 19.2533>, <4.2839, 45.4293, 19.4581> }
					triangle { <3.9826, 45.4465, 19.4215>, <3.6941, 45.6782, 19.4536>, <3.7379, 45.2828, 19.5299> }
					triangle { <3.7379, 45.2828, 19.5299>, <3.9562, 44.7581, 18.7487>, <3.9826, 45.4465, 19.4215> }
					triangle { <4.2465, 46.2087, 19.2533>, <4.1901, 46.1466, 19.3409>, <4.03312, 45.7175, 19.4627> }
					triangle { <4.1901, 46.1466, 19.3409>, <3.8322, 46.4068, 19.04307>, <3.6629, 45.9323, 19.4456> }
					triangle { <4.03312, 45.7175, 19.4627>, <3.6629, 45.9323, 19.4456>, <3.6941, 45.6782, 19.4536> }
					triangle { <4.03312, 45.7175, 19.4627>, <4.1901, 46.1466, 19.3409>, <3.6629, 45.9323, 19.4456> }
					triangle { <4.2839, 45.4293, 19.4581>, <4.2465, 46.2087, 19.2533>, <4.03312, 45.7175, 19.4627> }
					triangle { <3.9826, 45.4465, 19.4215>, <4.03312, 45.7175, 19.4627>, <3.6941, 45.6782, 19.4536> }
					triangle { <4.2839, 45.4293, 19.4581>, <4.03312, 45.7175, 19.4627>, <3.9826, 45.4465, 19.4215> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.1802, 44.2449, 17.5593>, <3.9885, 45.368, 19.4883>, <3.8642, 45.1082, 19.5855> }
					triangle { <4.1802, 44.2449, 17.5593>, <4.1973, 44.9607, 18.5639>, <3.9885, 45.368, 19.4883> }
					triangle { <3.8642, 45.1082, 19.5855>, <4.1649, 44.5997, 18.825>, <4.1802, 44.2449, 17.5593> }
					triangle { <4.1973, 44.9607, 18.5639>, <3.7458, 45.5712, 19.3903>, <3.9885, 45.368, 19.4883> }
					triangle { <3.7458, 45.5712, 19.3903>, <3.2261, 45.6273, 19.5365>, <3.9885, 45.368, 19.4883> }
					triangle { <3.8642, 45.1082, 19.5855>, <3.5891, 44.973, 19.7952>, <3.9722, 44.8554, 19.7366> }
					triangle { <3.9722, 44.8554, 19.7366>, <4.1649, 44.5997, 18.825>, <3.8642, 45.1082, 19.5855> }
					triangle { <3.2261, 45.6273, 19.5365>, <3.2979, 45.5749, 19.6192>, <3.6657, 45.2827, 19.6739> }
					triangle { <3.2979, 45.5749, 19.6192>, <2.8398, 45.3046, 19.5783>, <3.3589, 45.05708, 19.8699> }
					triangle { <3.6657, 45.2827, 19.6739>, <3.3589, 45.05708, 19.8699>, <3.5891, 44.973, 19.7952> }
					triangle { <3.6657, 45.2827, 19.6739>, <3.2979, 45.5749, 19.6192>, <3.3589, 45.05708, 19.8699> }
					triangle { <3.9885, 45.368, 19.4883>, <3.2261, 45.6273, 19.5365>, <3.6657, 45.2827, 19.6739> }
					triangle { <3.8642, 45.1082, 19.5855>, <3.6657, 45.2827, 19.6739>, <3.5891, 44.973, 19.7952> }
					triangle { <3.9885, 45.368, 19.4883>, <3.6657, 45.2827, 19.6739>, <3.8642, 45.1082, 19.5855> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.1802, 44.2449, 17.5593>, <3.9641, 45.0915, 19.6223>, <4.1922, 44.9008, 19.6854> }
					triangle { <4.1802, 44.2449, 17.5593>, <3.9889, 44.8422, 18.6216>, <3.9641, 45.0915, 19.6223> }
					triangle { <4.1922, 44.9008, 19.6854>, <4.3994, 44.7331, 18.7601>, <4.1802, 44.2449, 17.5593> }
					triangle { <3.9889, 44.8422, 18.6216>, <3.6777, 44.9415, 19.6953>, <3.9641, 45.0915, 19.6223> }
					triangle { <3.6777, 44.9415, 19.6953>, <3.5397, 44.558, 20.0538>, <3.9641, 45.0915, 19.6223> }
					triangle { <4.1922, 44.9008, 19.6854>, <4.3164, 44.6643, 19.9435>, <4.5044, 44.9282, 19.7004> }
					triangle { <4.5044, 44.9282, 19.7004>, <4.3994, 44.7331, 18.7601>, <4.1922, 44.9008, 19.6854> }
					triangle { <3.5397, 44.558, 20.0538>, <3.6402, 44.6205, 20.08088>, <4.02136, 44.8284, 19.8933> }
					triangle { <3.6402, 44.6205, 20.08088>, <3.7228, 44.09957, 20.1605>, <4.2085, 44.5224, 20.1274> }
					triangle { <4.02136, 44.8284, 19.8933>, <4.2085, 44.5224, 20.1274>, <4.3164, 44.6643, 19.9435> }
					triangle { <4.02136, 44.8284, 19.8933>, <3.6402, 44.6205, 20.08088>, <4.2085, 44.5224, 20.1274> }
					triangle { <3.9641, 45.0915, 19.6223>, <3.5397, 44.558, 20.0538>, <4.02136, 44.8284, 19.8933> }
					triangle { <4.1922, 44.9008, 19.6854>, <4.02136, 44.8284, 19.8933>, <4.3164, 44.6643, 19.9435> }
					triangle { <3.9641, 45.0915, 19.6223>, <4.02136, 44.8284, 19.8933>, <4.1922, 44.9008, 19.6854> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <3.9923, 43.4542, 16.1149>, <4.1468, 43.637, 16.3972>, 0.2056 }
			cylinder { <4.1468, 43.637, 16.3972>, <4.3321, 43.802, 16.6719>, 0.2056 }
			cylinder { <4.3321, 43.802, 16.6719>, <4.5462, 43.9476, 16.9365>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.5462, 43.9476, 16.9365>, <4.9173, 44.1264, 17.3088>, 0.2056 }
				cylinder { <4.9173, 44.1264, 17.3088>, <5.3326, 44.2632, 17.651>, 0.2056 }
				cylinder { <5.3326, 44.2632, 17.651>, <5.7859, 44.3559, 17.958>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <5.7859, 44.3559, 17.958>, <7.69, 44.8821, 19.00126>, <7.5066, 45.04986, 19.1748> }
					triangle { <5.7859, 44.3559, 17.958>, <6.8952, 44.5045, 18.4686>, <7.69, 44.8821, 19.00126> }
					triangle { <7.5066, 45.04986, 19.1748>, <6.7052, 44.6315, 18.851>, <5.7859, 44.3559, 17.958> }
					triangle { <6.8952, 44.5045, 18.4686>, <7.813, 45.07389, 18.7618>, <7.69, 44.8821, 19.00126> }
					triangle { <7.813, 45.07389, 18.7618>, <7.9172, 45.6039, 18.728>, <7.69, 44.8821, 19.00126> }
					triangle { <7.5066, 45.04986, 19.1748>, <7.4817, 45.3772, 19.3462>, <7.362, 45.00529, 19.4486> }
					triangle { <7.362, 45.00529, 19.4486>, <6.7052, 44.6315, 18.851>, <7.5066, 45.04986, 19.1748> }
					triangle { <7.9172, 45.6039, 18.728>, <7.9135, 45.559, 18.8404>, <7.6957, 45.2451, 19.1168> }
					triangle { <7.9135, 45.559, 18.8404>, <7.6446, 46.01757, 18.8191>, <7.5843, 45.6085, 19.3116> }
					triangle { <7.6957, 45.2451, 19.1168>, <7.5843, 45.6085, 19.3116>, <7.4817, 45.3772, 19.3462> }
					triangle { <7.6957, 45.2451, 19.1168>, <7.9135, 45.559, 18.8404>, <7.5843, 45.6085, 19.3116> }
					triangle { <7.69, 44.8821, 19.00126>, <7.9172, 45.6039, 18.728>, <7.6957, 45.2451, 19.1168> }
					triangle { <7.5066, 45.04986, 19.1748>, <7.6957, 45.2451, 19.1168>, <7.4817, 45.3772, 19.3462> }
					triangle { <7.69, 44.8821, 19.00126>, <7.6957, 45.2451, 19.1168>, <7.5066, 45.04986, 19.1748> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.7859, 44.3559, 17.958>, <7.5156, 44.9658, 19.2335>, <7.3831, 44.7846, 19.4372> }
					triangle { <5.7859, 44.3559, 17.958>, <6.8163, 44.7278, 18.5178>, <7.5156, 44.9658, 19.2335> }
					triangle { <7.3831, 44.7846, 19.4372>, <6.7939, 44.3803, 18.7957>, <5.7859, 44.3559, 17.958> }
					triangle { <6.8163, 44.7278, 18.5178>, <7.4156, 45.2761, 19.2876>, <7.5156, 44.9658, 19.2335> }
					triangle { <7.4156, 45.2761, 19.2876>, <7.2515, 45.541, 19.7301>, <7.5156, 44.9658, 19.2335> }
					triangle { <7.3831, 44.7846, 19.4372>, <7.3029, 44.7561, 19.7977>, <7.419, 44.4854, 19.5213> }
					triangle { <7.419, 44.4854, 19.5213>, <6.7939, 44.3803, 18.7957>, <7.3831, 44.7846, 19.4372> }
					triangle { <7.2515, 45.541, 19.7301>, <7.3206, 45.4438, 19.7508>, <7.4174, 45.00787, 19.5992> }
					triangle { <7.3206, 45.4438, 19.7508>, <6.9054, 45.4452, 20.08341>, <7.266, 44.9212, 19.9891> }
					triangle { <7.4174, 45.00787, 19.5992>, <7.266, 44.9212, 19.9891>, <7.3029, 44.7561, 19.7977> }
					triangle { <7.4174, 45.00787, 19.5992>, <7.3206, 45.4438, 19.7508>, <7.266, 44.9212, 19.9891> }
					triangle { <7.5156, 44.9658, 19.2335>, <7.2515, 45.541, 19.7301>, <7.4174, 45.00787, 19.5992> }
					triangle { <7.3831, 44.7846, 19.4372>, <7.4174, 45.00787, 19.5992>, <7.3029, 44.7561, 19.7977> }
					triangle { <7.5156, 44.9658, 19.2335>, <7.4174, 45.00787, 19.5992>, <7.3831, 44.7846, 19.4372> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.7859, 44.3559, 17.958>, <7.4538, 44.7204, 19.3989>, <7.5251, 44.4332, 19.3336> }
					triangle { <5.7859, 44.3559, 17.958>, <6.6821, 44.7183, 18.7188>, <7.4538, 44.7204, 19.3989> }
					triangle { <7.5251, 44.4332, 19.3336>, <6.9449, 44.391, 18.5695>, <5.7859, 44.3559, 17.958> }
					triangle { <6.6821, 44.7183, 18.7188>, <7.2681, 44.7234, 19.6722>, <7.4538, 44.7204, 19.3989> }
					triangle { <7.2681, 44.7234, 19.6722>, <7.2344, 44.3949, 20.1011>, <7.4538, 44.7204, 19.3989> }
					triangle { <7.5251, 44.4332, 19.3336>, <7.6444, 44.1175, 19.4862>, <7.7212, 44.2959, 19.1321> }
					triangle { <7.7212, 44.2959, 19.1321>, <6.9449, 44.391, 18.5695>, <7.5251, 44.4332, 19.3336> }
					triangle { <7.2344, 44.3949, 20.1011>, <7.3393, 44.3906, 20.04094>, <7.5312, 44.4133, 19.6107> }
					triangle { <7.3393, 44.3906, 20.04094>, <7.1743, 43.8976, 20.1533>, <7.6343, 44.01331, 19.7192> }
					triangle { <7.5312, 44.4133, 19.6107>, <7.6343, 44.01331, 19.7192>, <7.6444, 44.1175, 19.4862> }
					triangle { <7.5312, 44.4133, 19.6107>, <7.3393, 44.3906, 20.04094>, <7.6343, 44.01331, 19.7192> }
					triangle { <7.4538, 44.7204, 19.3989>, <7.2344, 44.3949, 20.1011>, <7.5312, 44.4133, 19.6107> }
					triangle { <7.5251, 44.4332, 19.3336>, <7.5312, 44.4133, 19.6107>, <7.6444, 44.1175, 19.4862> }
					triangle { <7.4538, 44.7204, 19.3989>, <7.5312, 44.4133, 19.6107>, <7.5251, 44.4332, 19.3336> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.7859, 44.3559, 17.958>, <7.5894, 44.4828, 19.2704>, <7.7378, 44.4778, 19.0061> }
					triangle { <5.7859, 44.3559, 17.958>, <6.6769, 44.489, 18.7957>, <7.5894, 44.4828, 19.2704> }
					triangle { <7.7378, 44.4778, 19.0061>, <6.9508, 44.6489, 18.483>, <5.7859, 44.3559, 17.958> }
					triangle { <6.6769, 44.489, 18.7957>, <7.5729, 44.1743, 19.3878>, <7.5894, 44.4828, 19.2704> }
					triangle { <7.5729, 44.1743, 19.3878>, <7.8895, 43.7389, 19.3318>, <7.5894, 44.4828, 19.2704> }
					triangle { <7.7378, 44.4778, 19.0061>, <8.0374, 44.3379, 18.8393>, <7.8539, 44.6969, 18.8152> }
					triangle { <7.8539, 44.6969, 18.8152>, <6.9508, 44.6489, 18.483>, <7.7378, 44.4778, 19.0061> }
					triangle { <7.8895, 43.7389, 19.3318>, <7.944, 43.8452, 19.3125>, <7.8807, 44.2777, 19.1354> }
					triangle { <7.944, 43.8452, 19.3125>, <8.08214, 43.499, 18.933>, <8.1836, 44.1311, 18.8723> }
					triangle { <7.8807, 44.2777, 19.1354>, <8.1836, 44.1311, 18.8723>, <8.0374, 44.3379, 18.8393> }
					triangle { <7.8807, 44.2777, 19.1354>, <7.944, 43.8452, 19.3125>, <8.1836, 44.1311, 18.8723> }
					triangle { <7.5894, 44.4828, 19.2704>, <7.8895, 43.7389, 19.3318>, <7.8807, 44.2777, 19.1354> }
					triangle { <7.7378, 44.4778, 19.0061>, <7.8807, 44.2777, 19.1354>, <8.0374, 44.3379, 18.8393> }
					triangle { <7.5894, 44.4828, 19.2704>, <7.8807, 44.2777, 19.1354>, <7.7378, 44.4778, 19.0061> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.7859, 44.3559, 17.958>, <7.7376, 44.5842, 19.02089>, <7.7262, 44.8647, 18.9065> }
					triangle { <5.7859, 44.3559, 17.958>, <6.8105, 44.3549, 18.6388>, <7.7376, 44.5842, 19.02089> }
					triangle { <7.7262, 44.8647, 18.9065>, <6.8004, 44.7998, 18.6595>, <5.7859, 44.3559, 17.958> }
					triangle { <6.8105, 44.3549, 18.6388>, <7.9148, 44.3942, 18.8166>, <7.7376, 44.5842, 19.02089> }
					triangle { <7.9148, 44.3942, 18.8166>, <8.3178, 44.4973, 18.4703>, <7.7376, 44.5842, 19.02089> }
					triangle { <7.7262, 44.8647, 18.9065>, <7.9353, 45.1281, 18.7515>, <7.6285, 45.1419, 19.0138> }
					triangle { <7.6285, 45.1419, 19.0138>, <6.8004, 44.7998, 18.6595>, <7.7262, 44.8647, 18.9065> }
					triangle { <8.3178, 44.4973, 18.4703>, <8.3042, 44.5782, 18.5594>, <7.9839, 44.7995, 18.8255> }
					triangle { <8.3042, 44.5782, 18.5594>, <8.3771, 44.829, 18.09596>, <8.1523, 45.1319, 18.6167> }
					triangle { <7.9839, 44.7995, 18.8255>, <8.1523, 45.1319, 18.6167>, <7.9353, 45.1281, 18.7515> }
					triangle { <7.9839, 44.7995, 18.8255>, <8.3042, 44.5782, 18.5594>, <8.1523, 45.1319, 18.6167> }
					triangle { <7.7376, 44.5842, 19.02089>, <8.3178, 44.4973, 18.4703>, <7.9839, 44.7995, 18.8255> }
					triangle { <7.7262, 44.8647, 18.9065>, <7.9839, 44.7995, 18.8255>, <7.9353, 45.1281, 18.7515> }
					triangle { <7.7376, 44.5842, 19.02089>, <7.9839, 44.7995, 18.8255>, <7.7262, 44.8647, 18.9065> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <4.5462, 43.9476, 16.9365>, <4.7453, 44.1252, 17.1931>, 0.2056 }
			cylinder { <4.7453, 44.1252, 17.1931>, <4.9274, 44.3332, 17.4392>, 0.2056 }
			cylinder { <4.9274, 44.3332, 17.4392>, <5.09086, 44.5695, 17.6726>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <5.09086, 44.5695, 17.6726>, <5.2975, 44.9724, 17.9939>, 0.2056 }
				cylinder { <5.2975, 44.9724, 17.9939>, <5.4627, 45.4176, 18.2816>, 0.2056 }
				cylinder { <5.4627, 45.4176, 18.2816>, <5.5839, 45.8984, 18.5315>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <5.5839, 45.8984, 18.5315>, <5.8558, 47.7984, 19.675>, <6.07382, 47.6409, 19.8149> }
					triangle { <5.5839, 45.8984, 18.5315>, <5.6602, 47.0197, 19.0321>, <5.8558, 47.7984, 19.675> }
					triangle { <6.07382, 47.6409, 19.8149>, <6.07762, 46.9358, 19.163>, <5.5839, 45.8984, 18.5315> }
					triangle { <5.6602, 47.0197, 19.0321>, <5.5784, 47.7757, 19.8531>, <5.8558, 47.7984, 19.675> }
					triangle { <5.5784, 47.7757, 19.8531>, <5.4815, 47.7047, 20.3809>, <5.8558, 47.7984, 19.675> }
					triangle { <6.07382, 47.6409, 19.8149>, <6.2251, 47.579, 20.1472>, <6.383, 47.6124, 19.777> }
					triangle { <6.383, 47.6124, 19.777>, <6.07762, 46.9358, 19.163>, <6.07382, 47.6409, 19.8149> }
					triangle { <5.4815, 47.7047, 20.3809>, <5.5901, 47.7508, 20.3541>, <5.9422, 47.7355, 20.04072> }
					triangle { <5.5901, 47.7508, 20.3541>, <5.6408, 47.3687, 20.7207>, <6.144, 47.593, 20.3891> }
					triangle { <5.9422, 47.7355, 20.04072>, <6.144, 47.593, 20.3891>, <6.2251, 47.579, 20.1472> }
					triangle { <5.9422, 47.7355, 20.04072>, <5.5901, 47.7508, 20.3541>, <6.144, 47.593, 20.3891> }
					triangle { <5.8558, 47.7984, 19.675>, <5.4815, 47.7047, 20.3809>, <5.9422, 47.7355, 20.04072> }
					triangle { <6.07382, 47.6409, 19.8149>, <5.9422, 47.7355, 20.04072>, <6.2251, 47.579, 20.1472> }
					triangle { <5.8558, 47.7984, 19.675>, <5.9422, 47.7355, 20.04072>, <6.07382, 47.6409, 19.8149> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.5839, 45.8984, 18.5315>, <6.13, 47.6924, 19.7458>, <6.3768, 47.6918, 19.5699> }
					triangle { <5.5839, 45.8984, 18.5315>, <5.722, 46.8997, 19.2328>, <6.13, 47.6924, 19.7458> }
					triangle { <6.3768, 47.6918, 19.5699>, <6.008075, 47.07071, 18.9372>, <5.5839, 45.8984, 18.5315> }
					triangle { <5.722, 46.8997, 19.2328>, <6.1991, 47.5299, 20.02512>, <6.13, 47.6924, 19.7458> }
					triangle { <6.1991, 47.5299, 20.02512>, <6.6562, 47.4488, 20.3034>, <6.13, 47.6924, 19.7458> }
					triangle { <6.3768, 47.6918, 19.5699>, <6.7433, 47.7449, 19.5768>, <6.4587, 47.8383, 19.3058> }
					triangle { <6.4587, 47.8383, 19.3058>, <6.008075, 47.07071, 18.9372>, <6.3768, 47.6918, 19.5699> }
					triangle { <6.6562, 47.4488, 20.3034>, <6.6562, 47.5459, 20.2312>, <6.5039, 47.7105, 19.8163> }
					triangle { <6.6562, 47.5459, 20.2312>, <7.1137, 47.2797, 20.1775>, <6.9262, 47.7258, 19.754> }
					triangle { <6.5039, 47.7105, 19.8163>, <6.9262, 47.7258, 19.754>, <6.7433, 47.7449, 19.5768> }
					triangle { <6.5039, 47.7105, 19.8163>, <6.6562, 47.5459, 20.2312>, <6.9262, 47.7258, 19.754> }
					triangle { <6.13, 47.6924, 19.7458>, <6.6562, 47.4488, 20.3034>, <6.5039, 47.7105, 19.8163> }
					triangle { <6.3768, 47.6918, 19.5699>, <6.5039, 47.7105, 19.8163>, <6.7433, 47.7449, 19.5768> }
					triangle { <6.13, 47.6924, 19.7458>, <6.5039, 47.7105, 19.8163>, <6.3768, 47.6918, 19.5699> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.5839, 45.8984, 18.5315>, <6.3195, 47.7617, 19.5207>, <6.2486, 47.8881, 19.2544> }
					triangle { <5.5839, 45.8984, 18.5315>, <5.9576, 46.8469, 19.2201>, <6.3195, 47.7617, 19.5207> }
					triangle { <6.2486, 47.8881, 19.2544>, <5.7429, 47.1301, 18.9515>, <5.5839, 45.8984, 18.5315> }
					triangle { <5.9576, 46.8469, 19.2201>, <6.6403, 47.6824, 19.5177>, <6.3195, 47.7617, 19.5207> }
					triangle { <6.6403, 47.6824, 19.5177>, <7.07036, 47.8866, 19.2602>, <6.3195, 47.7617, 19.5207> }
					triangle { <6.2486, 47.8881, 19.2544>, <6.3659, 48.1366, 19.00615>, <5.9985, 48.03914, 19.1426> }
					triangle { <5.9985, 48.03914, 19.1426>, <5.7429, 47.1301, 18.9515>, <6.2486, 47.8881, 19.2544> }
					triangle { <7.07036, 47.8866, 19.2602>, <6.9772, 47.9627, 19.2736>, <6.5064, 47.9892, 19.2789> }
					triangle { <6.9772, 47.9627, 19.2736>, <7.1671, 47.9938, 18.7777>, <6.5927, 48.2334, 18.9392> }
					triangle { <6.5064, 47.9892, 19.2789>, <6.5927, 48.2334, 18.9392>, <6.3659, 48.1366, 19.00615> }
					triangle { <6.5064, 47.9892, 19.2789>, <6.9772, 47.9627, 19.2736>, <6.5927, 48.2334, 18.9392> }
					triangle { <6.3195, 47.7617, 19.5207>, <7.07036, 47.8866, 19.2602>, <6.5064, 47.9892, 19.2789> }
					triangle { <6.2486, 47.8881, 19.2544>, <6.5064, 47.9892, 19.2789>, <6.3659, 48.1366, 19.00615> }
					triangle { <6.3195, 47.7617, 19.5207>, <6.5064, 47.9892, 19.2789>, <6.2486, 47.8881, 19.2544> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.5839, 45.8984, 18.5315>, <6.1642, 47.911, 19.3086>, <5.8652, 47.9603, 19.3015> }
					triangle { <5.5839, 45.8984, 18.5315>, <6.04373, 46.9337, 19.01142>, <6.1642, 47.911, 19.3086> }
					triangle { <5.8652, 47.9603, 19.3015>, <5.6461, 47.03248, 19.1863>, <5.5839, 45.8984, 18.5315> }
					triangle { <6.04373, 46.9337, 19.01142>, <6.2963, 48.0239, 19.02751>, <6.1642, 47.911, 19.3086> }
					triangle { <6.2963, 48.0239, 19.02751>, <6.1554, 48.4171, 18.6832>, <6.1642, 47.911, 19.3086> }
					triangle { <5.8652, 47.9603, 19.3015>, <5.611, 48.2165, 19.2186>, <5.6341, 47.9393, 19.5114> }
					triangle { <5.6341, 47.9393, 19.5114>, <5.6461, 47.03248, 19.1863>, <5.8652, 47.9603, 19.3015> }
					triangle { <6.1554, 48.4171, 18.6832>, <6.1124, 48.429, 18.7957>, <5.9462, 48.1891, 19.1661> }
					triangle { <6.1124, 48.429, 18.7957>, <5.7278, 48.5307, 18.4426>, <5.6012, 48.4189, 19.06314> }
					triangle { <5.9462, 48.1891, 19.1661>, <5.6012, 48.4189, 19.06314>, <5.611, 48.2165, 19.2186> }
					triangle { <5.9462, 48.1891, 19.1661>, <6.1124, 48.429, 18.7957>, <5.6012, 48.4189, 19.06314> }
					triangle { <6.1642, 47.911, 19.3086>, <6.1554, 48.4171, 18.6832>, <5.9462, 48.1891, 19.1661> }
					triangle { <5.8652, 47.9603, 19.3015>, <5.9462, 48.1891, 19.1661>, <5.611, 48.2165, 19.2186> }
					triangle { <6.1642, 47.911, 19.3086>, <5.9462, 48.1891, 19.1661>, <5.8652, 47.9603, 19.3015> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.5839, 45.8984, 18.5315>, <5.8733, 47.9341, 19.4054>, <5.7555, 47.8052, 19.6532> }
					triangle { <5.5839, 45.8984, 18.5315>, <5.8571, 47.04212, 18.8934>, <5.8733, 47.9341, 19.4054> }
					triangle { <5.7555, 47.8052, 19.6532>, <5.8561, 46.9105, 19.319>, <5.5839, 45.8984, 18.5315> }
					triangle { <5.8571, 47.04212, 18.8934>, <5.6302, 48.08246, 19.2379>, <5.8733, 47.9341, 19.4054> }
					triangle { <5.6302, 48.08246, 19.2379>, <5.1587, 48.3029, 19.3863>, <5.8733, 47.9341, 19.4054> }
					triangle { <5.7555, 47.8052, 19.6532>, <5.5226, 47.8667, 19.9345>, <5.8754, 47.6716, 19.9094> }
					triangle { <5.8754, 47.6716, 19.9094>, <5.8561, 46.9105, 19.319>, <5.7555, 47.8052, 19.6532> }
					triangle { <5.1587, 48.3029, 19.3863>, <5.2422, 48.2961, 19.4736>, <5.5922, 48.02996, 19.644> }
					triangle { <5.2422, 48.2961, 19.4736>, <4.7702, 48.1386, 19.6616>, <5.3197, 48.01722, 19.9727> }
					triangle { <5.5922, 48.02996, 19.644>, <5.3197, 48.01722, 19.9727>, <5.5226, 47.8667, 19.9345> }
					triangle { <5.5922, 48.02996, 19.644>, <5.2422, 48.2961, 19.4736>, <5.3197, 48.01722, 19.9727> }
					triangle { <5.8733, 47.9341, 19.4054>, <5.1587, 48.3029, 19.3863>, <5.5922, 48.02996, 19.644> }
					triangle { <5.7555, 47.8052, 19.6532>, <5.5922, 48.02996, 19.644>, <5.5226, 47.8667, 19.9345> }
					triangle { <5.8733, 47.9341, 19.4054>, <5.5922, 48.02996, 19.644>, <5.7555, 47.8052, 19.6532> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <5.09086, 44.5695, 17.6726>, <5.2504, 44.7805, 17.9315>, 0.2056 }
			cylinder { <5.2504, 44.7805, 17.9315>, <5.4046, 44.9639, 18.2137>, 0.2056 }
			cylinder { <5.4046, 44.9639, 18.2137>, <5.5519, 45.1181, 18.5162>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <5.5519, 45.1181, 18.5162>, <5.7571, 45.2914, 19.00221>, 0.2056 }
				cylinder { <5.7571, 45.2914, 19.00221>, <5.9434, 45.4043, 19.5129>, 0.2056 }
				cylinder { <5.9434, 45.4043, 19.5129>, <6.1079, 45.4549, 20.04083>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <6.1079, 45.4549, 20.04083>, <6.975, 45.5189, 22.09266>, <7.03688, 45.8056, 22.01883> }
					triangle { <6.1079, 45.4549, 20.04083>, <6.4871, 45.3607, 21.2041>, <6.975, 45.5189, 22.09266> }
					triangle { <7.03688, 45.8056, 22.01883>, <6.4662, 45.8022, 21.2495>, <6.1079, 45.4549, 20.04083> }
					triangle { <6.4871, 45.3607, 21.2041>, <7.2401, 45.3341, 22.02775>, <6.975, 45.5189, 22.09266> }
					triangle { <7.2401, 45.3341, 22.02775>, <7.7696, 45.4385, 22.01509>, <6.975, 45.5189, 22.09266> }
					triangle { <7.03688, 45.8056, 22.01883>, <7.2963, 46.06693, 22.04827>, <6.8939, 46.07927, 22.06423> }
					triangle { <6.8939, 46.07927, 22.06423>, <6.4662, 45.8022, 21.2495>, <7.03688, 45.8056, 22.01883> }
					triangle { <7.7696, 45.4385, 22.01509>, <7.7038, 45.5139, 22.08252>, <7.2885, 45.7331, 22.1097> }
					triangle { <7.7038, 45.5139, 22.08252>, <8.04794, 45.7887, 21.7864>, <7.5494, 46.06839, 22.07751> }
					triangle { <7.2885, 45.7331, 22.1097>, <7.5494, 46.06839, 22.07751>, <7.2963, 46.06693, 22.04827> }
					triangle { <7.2885, 45.7331, 22.1097>, <7.7038, 45.5139, 22.08252>, <7.5494, 46.06839, 22.07751> }
					triangle { <6.975, 45.5189, 22.09266>, <7.7696, 45.4385, 22.01509>, <7.2885, 45.7331, 22.1097> }
					triangle { <7.03688, 45.8056, 22.01883>, <7.2885, 45.7331, 22.1097>, <7.2963, 46.06693, 22.04827> }
					triangle { <6.975, 45.5189, 22.09266>, <7.2885, 45.7331, 22.1097>, <7.03688, 45.8056, 22.01883> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.1079, 45.4549, 20.04083>, <6.9499, 45.8187, 22.07175>, <6.6989, 45.9836, 22.1071> }
					triangle { <6.1079, 45.4549, 20.04083>, <6.6586, 45.5159, 21.1357>, <6.9499, 45.8187, 22.07175> }
					triangle { <6.6989, 45.9836, 22.1071>, <6.2732, 45.6276, 21.3264>, <6.1079, 45.4549, 20.04083> }
					triangle { <6.6586, 45.5159, 21.1357>, <7.1943, 46.01833, 21.9764>, <6.9499, 45.8187, 22.07175> }
					triangle { <7.1943, 46.01833, 21.9764>, <7.2965, 46.5423, 22.05677>, <6.9499, 45.8187, 22.07175> }
					triangle { <6.6989, 45.9836, 22.1071>, <6.5731, 46.2996, 22.2514>, <6.4162, 45.9293, 22.2275> }
					triangle { <6.4162, 45.9293, 22.2275>, <6.2732, 45.6276, 21.3264>, <6.6989, 45.9836, 22.1071> }
					triangle { <7.2965, 46.5423, 22.05677>, <7.224, 46.4908, 22.1384>, <6.8826, 46.1721, 22.1942> }
					triangle { <7.224, 46.4908, 22.1384>, <7.0269, 46.9613, 21.9923>, <6.6747, 46.5267, 22.3062> }
					triangle { <6.8826, 46.1721, 22.1942>, <6.6747, 46.5267, 22.3062>, <6.5731, 46.2996, 22.2514> }
					triangle { <6.8826, 46.1721, 22.1942>, <7.224, 46.4908, 22.1384>, <6.6747, 46.5267, 22.3062> }
					triangle { <6.9499, 45.8187, 22.07175>, <7.2965, 46.5423, 22.05677>, <6.8826, 46.1721, 22.1942> }
					triangle { <6.6989, 45.9836, 22.1071>, <6.8826, 46.1721, 22.1942>, <6.5731, 46.2996, 22.2514> }
					triangle { <6.9499, 45.8187, 22.07175>, <6.8826, 46.1721, 22.1942>, <6.6989, 45.9836, 22.1071> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.1079, 45.4549, 20.04083>, <6.6696, 45.896, 22.1517>, <6.4398, 45.7096, 22.2141> }
					triangle { <6.1079, 45.4549, 20.04083>, <6.5664, 45.7387, 21.1431>, <6.6696, 45.896, 22.1517> }
					triangle { <6.4398, 45.7096, 22.2141>, <6.3769, 45.3769, 21.3181>, <6.1079, 45.4549, 20.04083> }
					triangle { <6.5664, 45.7387, 21.1431>, <6.5579, 46.206, 22.1568>, <6.6696, 45.896, 22.1517> }
					triangle { <6.5579, 46.206, 22.1568>, <6.1552, 46.4497, 22.4214>, <6.6696, 45.896, 22.1517> }
					triangle { <6.4398, 45.7096, 22.2141>, <6.1538, 45.6626, 22.4431>, <6.4159, 45.405, 22.2778> }
					triangle { <6.4159, 45.405, 22.2778>, <6.3769, 45.3769, 21.3181>, <6.4398, 45.7096, 22.2141> }
					triangle { <6.1552, 46.4497, 22.4214>, <6.1965, 46.3484, 22.4724>, <6.3662, 45.9196, 22.3793> }
					triangle { <6.1965, 46.3484, 22.4724>, <5.6659, 46.3494, 22.4752>, <6.006354, 45.8165, 22.5826> }
					triangle { <6.3662, 45.9196, 22.3793>, <6.006354, 45.8165, 22.5826>, <6.1538, 45.6626, 22.4431> }
					triangle { <6.3662, 45.9196, 22.3793>, <6.1965, 46.3484, 22.4724>, <6.006354, 45.8165, 22.5826> }
					triangle { <6.6696, 45.896, 22.1517>, <6.1552, 46.4497, 22.4214>, <6.3662, 45.9196, 22.3793> }
					triangle { <6.4398, 45.7096, 22.2141>, <6.3662, 45.9196, 22.3793>, <6.1538, 45.6626, 22.4431> }
					triangle { <6.6696, 45.896, 22.1517>, <6.3662, 45.9196, 22.3793>, <6.4398, 45.7096, 22.2141> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.1079, 45.4549, 20.04083>, <6.5188, 45.6447, 22.2228>, <6.6152, 45.3596, 22.193> }
					triangle { <6.1079, 45.4549, 20.04083>, <6.337, 45.7233, 21.2161>, <6.5188, 45.6447, 22.2228> }
					triangle { <6.6152, 45.3596, 22.193>, <6.635, 45.3943, 21.2359>, <6.1079, 45.4549, 20.04083> }
					triangle { <6.337, 45.7233, 21.2161>, <6.2043, 45.6396, 22.3213>, <6.5188, 45.6447, 22.2228> }
					triangle { <6.2043, 45.6396, 22.3213>, <5.9124, 45.2878, 22.6085>, <6.5188, 45.6447, 22.2228> }
					triangle { <6.6152, 45.3596, 22.193>, <6.6139, 45.03032, 22.3603>, <6.8933, 45.2261, 22.1461> }
					triangle { <6.8933, 45.2261, 22.1461>, <6.635, 45.3943, 21.2359>, <6.6152, 45.3596, 22.193> }
					triangle { <5.9124, 45.2878, 22.6085>, <6.03173, 45.2822, 22.626>, <6.4482, 45.3222, 22.4111> }
					triangle { <6.03173, 45.2822, 22.626>, <5.8332, 44.793, 22.5723>, <6.4617, 44.9126, 22.5273> }
					triangle { <6.4482, 45.3222, 22.4111>, <6.4617, 44.9126, 22.5273>, <6.6139, 45.03032, 22.3603> }
					triangle { <6.4482, 45.3222, 22.4111>, <6.03173, 45.2822, 22.626>, <6.4617, 44.9126, 22.5273> }
					triangle { <6.5188, 45.6447, 22.2228>, <5.9124, 45.2878, 22.6085>, <6.4482, 45.3222, 22.4111> }
					triangle { <6.6152, 45.3596, 22.193>, <6.4482, 45.3222, 22.4111>, <6.6139, 45.03032, 22.3603> }
					triangle { <6.5188, 45.6447, 22.2228>, <6.4482, 45.3222, 22.4111>, <6.6152, 45.3596, 22.193> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <6.1079, 45.4549, 20.04083>, <6.7104, 45.4081, 22.1857>, <6.9897, 45.4198, 22.07049> }
					triangle { <6.1079, 45.4549, 20.04083>, <6.2872, 45.4861, 21.2543>, <6.7104, 45.4081, 22.1857> }
					triangle { <6.9897, 45.4198, 22.07049>, <6.691, 45.6611, 21.1929>, <6.1079, 45.4549, 20.04083> }
					triangle { <6.2872, 45.4861, 21.2543>, <6.6323, 45.09264, 22.2403>, <6.7104, 45.4081, 22.1857> }
					triangle { <6.6323, 45.09264, 22.2403>, <6.9252, 44.6534, 22.3536>, <6.7104, 45.4081, 22.1857> }
					triangle { <6.9897, 45.4198, 22.07049>, <7.3306, 45.2839, 22.1126>, <7.1933, 45.6491, 22.01214> }
					triangle { <7.1933, 45.6491, 22.01214>, <6.691, 45.6611, 21.1929>, <6.9897, 45.4198, 22.07049> }
					triangle { <6.9252, 44.6534, 22.3536>, <6.9773, 44.7587, 22.3814>, <7.02683, 45.2052, 22.2419> }
					triangle { <6.9773, 44.7587, 22.3814>, <7.3275, 44.4413, 22.1402>, <7.4298, 45.07061, 22.2104> }
					triangle { <7.02683, 45.2052, 22.2419>, <7.4298, 45.07061, 22.2104>, <7.3306, 45.2839, 22.1126> }
					triangle { <7.02683, 45.2052, 22.2419>, <6.9773, 44.7587, 22.3814>, <7.4298, 45.07061, 22.2104> }
					triangle { <6.7104, 45.4081, 22.1857>, <6.9252, 44.6534, 22.3536>, <7.02683, 45.2052, 22.2419> }
					triangle { <6.9897, 45.4198, 22.07049>, <7.02683, 45.2052, 22.2419>, <7.3306, 45.2839, 22.1126> }
					triangle { <6.7104, 45.4081, 22.1857>, <7.02683, 45.2052, 22.2419>, <6.9897, 45.4198, 22.07049> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <2.4775, 41.9385, 13.6226>, <2.5633, 41.9897, 13.979>, 0.2056 }
			cylinder { <2.5633, 41.9897, 13.979>, <2.6143, 42.03365, 14.343>, 0.2056 }
			cylinder { <2.6143, 42.03365, 14.343>, <2.6301, 42.06974, 14.711>, 0.2056 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <2.6301, 42.06974, 14.711>, <2.5805, 42.06556, 15.07789>, 0.2056 }
			cylinder { <2.5805, 42.06556, 15.07789>, <2.5628, 42.04407, 15.447>, 0.2056 }
			cylinder { <2.5628, 42.04407, 15.447>, <2.5771, 42.00549, 15.8148>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.5771, 42.00549, 15.8148>, <2.6583, 41.9163, 16.3568>, 0.2056 }
				cylinder { <2.6583, 41.9163, 16.3568>, <2.798, 41.7973, 16.8809>, 0.2056 }
				cylinder { <2.798, 41.7973, 16.8809>, <2.9941, 41.6502, 17.3791>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <2.9941, 41.6502, 17.3791>, <3.9319, 41.2683, 19.3641>, <3.6645, 41.363, 19.4686> }
					triangle { <2.9941, 41.6502, 17.3791>, <3.6136, 41.338, 18.3913>, <3.9319, 41.2683, 19.3641> }
					triangle { <3.6645, 41.363, 19.4686>, <3.2323, 41.2999, 18.6162>, <2.9941, 41.6502, 17.3791> }
					triangle { <3.6136, 41.338, 18.3913>, <4.1392, 41.5246, 19.3582>, <3.9319, 41.2683, 19.3641> }
					triangle { <4.1392, 41.5246, 19.3582>, <4.1756, 41.9775, 19.6498>, <3.9319, 41.2683, 19.3641> }
					triangle { <3.6645, 41.363, 19.4686>, <3.5086, 41.5675, 19.7338>, <3.4017, 41.2208, 19.5588> }
					triangle { <3.4017, 41.2208, 19.5588>, <3.2323, 41.2999, 18.6162>, <3.6645, 41.363, 19.4686> }
					triangle { <4.1756, 41.9775, 19.6498>, <4.1172, 41.8864, 19.7032>, <3.8271, 41.5246, 19.6245> }
					triangle { <4.1172, 41.8864, 19.7032>, <3.8477, 42.3385, 19.7706>, <3.5824, 41.7645, 19.8777> }
					triangle { <3.8271, 41.5246, 19.6245>, <3.5824, 41.7645, 19.8777>, <3.5086, 41.5675, 19.7338> }
					triangle { <3.8271, 41.5246, 19.6245>, <4.1172, 41.8864, 19.7032>, <3.5824, 41.7645, 19.8777> }
					triangle { <3.9319, 41.2683, 19.3641>, <4.1756, 41.9775, 19.6498>, <3.8271, 41.5246, 19.6245> }
					triangle { <3.6645, 41.363, 19.4686>, <3.8271, 41.5246, 19.6245>, <3.5086, 41.5675, 19.7338> }
					triangle { <3.9319, 41.2683, 19.3641>, <3.8271, 41.5246, 19.6245>, <3.6645, 41.363, 19.4686> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <2.9941, 41.6502, 17.3791>, <3.6507, 41.2613, 19.4727>, <3.4537, 41.03282, 19.4541> }
					triangle { <2.9941, 41.6502, 17.3791>, <3.493, 41.5207, 18.4927>, <3.6507, 41.2613, 19.4727> }
					triangle { <3.4537, 41.03282, 19.4541>, <3.3679, 41.09447, 18.5021>, <2.9941, 41.6502, 17.3791> }
					triangle { <3.493, 41.5207, 18.4927>, <3.4989, 41.5203, 19.6089>, <3.6507, 41.2613, 19.4727> }
					triangle { <3.4989, 41.5203, 19.6089>, <3.08853, 41.5675, 19.9565>, <3.6507, 41.2613, 19.4727> }
					triangle { <3.4537, 41.03282, 19.4541>, <3.195, 40.8518, 19.6459>, <3.476, 40.7294, 19.3844> }
					triangle { <3.476, 40.7294, 19.3844>, <3.3679, 41.09447, 18.5021>, <3.4537, 41.03282, 19.4541> }
					triangle { <3.08853, 41.5675, 19.9565>, <3.1468, 41.4619, 19.9597>, <3.3652, 41.1417, 19.6932> }
					triangle { <3.1468, 41.4619, 19.9597>, <2.6227, 41.3796, 19.9696>, <3.03917, 40.9096, 19.8391> }
					triangle { <3.3652, 41.1417, 19.6932>, <3.03917, 40.9096, 19.8391>, <3.195, 40.8518, 19.6459> }
					triangle { <3.3652, 41.1417, 19.6932>, <3.1468, 41.4619, 19.9597>, <3.03917, 40.9096, 19.8391> }
					triangle { <3.6507, 41.2613, 19.4727>, <3.08853, 41.5675, 19.9565>, <3.3652, 41.1417, 19.6932> }
					triangle { <3.4537, 41.03282, 19.4541>, <3.3652, 41.1417, 19.6932>, <3.195, 40.8518, 19.6459> }
					triangle { <3.6507, 41.2613, 19.4727>, <3.3652, 41.1417, 19.6932>, <3.4537, 41.03282, 19.4541> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <2.9941, 41.6502, 17.3791>, <3.5411, 40.9831, 19.4337>, <3.6725, 40.7545, 19.2858> }
					triangle { <2.9941, 41.6502, 17.3791>, <3.274, 41.4412, 18.5554>, <3.5411, 40.9831, 19.4337> }
					triangle { <3.6725, 40.7545, 19.2858>, <3.6143, 41.1838, 18.4315>, <2.9941, 41.6502, 17.3791> }
					triangle { <3.274, 41.4412, 18.5554>, <3.2387, 40.8893, 19.5251>, <3.5411, 40.9831, 19.4337> }
					triangle { <3.2387, 40.8893, 19.5251>, <3.01969, 40.4098, 19.6418>, <3.5411, 40.9831, 19.4337> }
					triangle { <3.6725, 40.7545, 19.2858>, <3.7285, 40.3896, 19.2995>, <3.9617, 40.697, 19.1837> }
					triangle { <3.9617, 40.697, 19.1837>, <3.6143, 41.1838, 18.4315>, <3.6725, 40.7545, 19.2858> }
					triangle { <3.01969, 40.4098, 19.6418>, <3.1396, 40.416, 19.6538>, <3.5293, 40.605, 19.4702> }
					triangle { <3.1396, 40.416, 19.6538>, <3.005431, 39.9684, 19.4023>, <3.6068, 40.1914, 19.4036> }
					triangle { <3.5293, 40.605, 19.4702>, <3.6068, 40.1914, 19.4036>, <3.7285, 40.3896, 19.2995> }
					triangle { <3.5293, 40.605, 19.4702>, <3.1396, 40.416, 19.6538>, <3.6068, 40.1914, 19.4036> }
					triangle { <3.5411, 40.9831, 19.4337>, <3.01969, 40.4098, 19.6418>, <3.5293, 40.605, 19.4702> }
					triangle { <3.6725, 40.7545, 19.2858>, <3.5293, 40.605, 19.4702>, <3.7285, 40.3896, 19.2995> }
					triangle { <3.5411, 40.9831, 19.4337>, <3.5293, 40.605, 19.4702>, <3.6725, 40.7545, 19.2858> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <2.9941, 41.6502, 17.3791>, <3.7536, 40.8156, 19.3006>, <4.02067, 40.9101, 19.1947> }
					triangle { <2.9941, 41.6502, 17.3791>, <3.2572, 41.2087, 18.4934>, <3.7536, 40.8156, 19.3006> }
					triangle { <4.02067, 40.9101, 19.1947>, <3.6332, 41.4454, 18.5013>, <2.9941, 41.6502, 17.3791> }
					triangle { <3.2572, 41.2087, 18.4934>, <3.7157, 40.4978, 19.2217>, <3.7536, 40.8156, 19.3006> }
					triangle { <3.7157, 40.4978, 19.2217>, <4.06359, 40.09364, 19.1376>, <3.7536, 40.8156, 19.3006> }
					triangle { <4.02067, 40.9101, 19.1947>, <4.3768, 40.8153, 19.17>, <4.1923, 41.168, 19.232> }
					triangle { <4.1923, 41.168, 19.232>, <3.6332, 41.4454, 18.5013>, <4.02067, 40.9101, 19.1947> }
					triangle { <4.06359, 40.09364, 19.1376>, <4.1054, 40.1844, 19.2053>, <4.09408, 40.6512, 19.2615> }
					triangle { <4.1054, 40.1844, 19.2053>, <4.4704, 40.04204, 18.8474>, <4.5062, 40.5958, 19.169> }
					triangle { <4.09408, 40.6512, 19.2615>, <4.5062, 40.5958, 19.169>, <4.3768, 40.8153, 19.17> }
					triangle { <4.09408, 40.6512, 19.2615>, <4.1054, 40.1844, 19.2053>, <4.5062, 40.5958, 19.169> }
					triangle { <3.7536, 40.8156, 19.3006>, <4.06359, 40.09364, 19.1376>, <4.09408, 40.6512, 19.2615> }
					triangle { <4.02067, 40.9101, 19.1947>, <4.09408, 40.6512, 19.2615>, <4.3768, 40.8153, 19.17> }
					triangle { <3.7536, 40.8156, 19.3006>, <4.09408, 40.6512, 19.2615>, <4.02067, 40.9101, 19.1947> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <2.9941, 41.6502, 17.3791>, <3.9988, 40.9945, 19.257>, <4.01562, 41.2918, 19.3095> }
					triangle { <2.9941, 41.6502, 17.3791>, <3.4702, 41.1439, 18.3904>, <3.9988, 40.9945, 19.257> }
					triangle { <4.01562, 41.2918, 19.3095>, <3.3935, 41.5182, 18.6172>, <2.9941, 41.6502, 17.3791> }
					triangle { <3.4702, 41.1439, 18.3904>, <4.2806, 40.8964, 19.117>, <3.9988, 40.9945, 19.257> }
					triangle { <4.2806, 40.8964, 19.117>, <4.7887, 41.07715, 19.1426>, <3.9988, 40.9945, 19.257> }
					triangle { <4.01562, 41.2918, 19.3095>, <4.2389, 41.5543, 19.4425>, <3.8409, 41.4966, 19.4674> }
					triangle { <3.8409, 41.4966, 19.4674>, <3.3935, 41.5182, 18.6172>, <4.01562, 41.2918, 19.3095> }
					triangle { <4.7887, 41.07715, 19.1426>, <4.7187, 41.1068, 19.2363>, <4.2809, 41.2281, 19.3583> }
					triangle { <4.7187, 41.1068, 19.2363>, <4.9989, 41.5289, 19.07855>, <4.4909, 41.5827, 19.4664> }
					triangle { <4.2809, 41.2281, 19.3583>, <4.4909, 41.5827, 19.4664>, <4.2389, 41.5543, 19.4425> }
					triangle { <4.2809, 41.2281, 19.3583>, <4.7187, 41.1068, 19.2363>, <4.4909, 41.5827, 19.4664> }
					triangle { <3.9988, 40.9945, 19.257>, <4.7887, 41.07715, 19.1426>, <4.2809, 41.2281, 19.3583> }
					triangle { <4.01562, 41.2918, 19.3095>, <4.2809, 41.2281, 19.3583>, <4.2389, 41.5543, 19.4425> }
					triangle { <3.9988, 40.9945, 19.257>, <4.2809, 41.2281, 19.3583>, <4.01562, 41.2918, 19.3095> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <2.6301, 42.06974, 14.711>, <2.7104, 42.1445, 15.06458>, 0.2056 }
			cylinder { <2.7104, 42.1445, 15.06458>, <2.7591, 42.237, 15.4196>, 0.2056 }
			cylinder { <2.7591, 42.237, 15.4196>, <2.7757, 42.3463, 15.7729>, 0.2056 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.7757, 42.3463, 15.7729>, <2.7399, 42.5395, 16.2922>, 0.2056 }
				cylinder { <2.7399, 42.5395, 16.2922>, <2.6441, 42.7591, 16.7931>, 0.2056 }
				cylinder { <2.6441, 42.7591, 16.7931>, <2.4897, 43.00166, 17.2681>, 0.2056 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <2.4897, 43.00166, 17.2681>, <1.7201, 43.769, 19.2136>, <1.9962, 43.6942, 19.3114> }
					triangle { <2.4897, 43.00166, 17.2681>, <1.9556, 43.5093, 18.2493>, <1.7201, 43.769, 19.2136> }
					triangle { <1.9962, 43.6942, 19.3114>, <2.3542, 43.5871, 18.4294>, <2.4897, 43.00166, 17.2681> }
					triangle { <1.9556, 43.5093, 18.2493>, <1.5152, 43.5182, 19.275>, <1.7201, 43.769, 19.2136> }
					triangle { <1.5152, 43.5182, 19.275>, <1.5074, 43.1307, 19.6509>, <1.7201, 43.769, 19.2136> }
					triangle { <1.9962, 43.6942, 19.3114>, <2.1757, 43.5437, 19.5971>, <2.2645, 43.849, 19.3497> }
					triangle { <2.2645, 43.849, 19.3497>, <2.3542, 43.5871, 18.4294>, <1.9962, 43.6942, 19.3114> }
					triangle { <1.5074, 43.1307, 19.6509>, <1.5694, 43.23, 19.6805>, <1.8487, 43.5672, 19.5088> }
					triangle { <1.5694, 43.23, 19.6805>, <1.8473, 42.7973, 19.8113>, <2.1159, 43.379, 19.7821> }
					triangle { <1.8487, 43.5672, 19.5088>, <2.1159, 43.379, 19.7821>, <2.1757, 43.5437, 19.5971> }
					triangle { <1.8487, 43.5672, 19.5088>, <1.5694, 43.23, 19.6805>, <2.1159, 43.379, 19.7821> }
					triangle { <1.7201, 43.769, 19.2136>, <1.5074, 43.1307, 19.6509>, <1.8487, 43.5672, 19.5088> }
					triangle { <1.9962, 43.6942, 19.3114>, <1.8487, 43.5672, 19.5088>, <2.1757, 43.5437, 19.5971> }
					triangle { <1.7201, 43.769, 19.2136>, <1.8487, 43.5672, 19.5088>, <1.9962, 43.6942, 19.3114> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <2.4897, 43.00166, 17.2681>, <2.009486, 43.7946, 19.2946>, <2.2023, 44.01358, 19.2154> }
					triangle { <2.4897, 43.00166, 17.2681>, <2.08585, 43.3488, 18.3736>, <2.009486, 43.7946, 19.2946> }
					triangle { <2.2023, 44.01358, 19.2154>, <2.2077, 43.7677, 18.2896>, <2.4897, 43.00166, 17.2681> }
					triangle { <2.08585, 43.3488, 18.3736>, <2.1744, 43.5657, 19.465>, <2.009486, 43.7946, 19.2946> }
					triangle { <2.1744, 43.5657, 19.465>, <2.6131, 43.5834, 19.7792>, <2.009486, 43.7946, 19.2946> }
					triangle { <2.2023, 44.01358, 19.2154>, <2.4748, 44.2261, 19.3458>, <2.1717, 44.2978, 19.09036> }
					triangle { <2.1717, 44.2978, 19.09036>, <2.2077, 43.7677, 18.2896>, <2.2023, 44.01358, 19.2154> }
					triangle { <2.6131, 43.5834, 19.7792>, <2.5544, 43.6881, 19.7668>, <2.3116, 43.9523, 19.4627> }
					triangle { <2.5544, 43.6881, 19.7668>, <3.07679, 43.7664, 19.7161>, <2.6469, 44.2056, 19.5326> }
					triangle { <2.3116, 43.9523, 19.4627>, <2.6469, 44.2056, 19.5326>, <2.4748, 44.2261, 19.3458> }
					triangle { <2.3116, 43.9523, 19.4627>, <2.5544, 43.6881, 19.7668>, <2.6469, 44.2056, 19.5326> }
					triangle { <2.009486, 43.7946, 19.2946>, <2.6131, 43.5834, 19.7792>, <2.3116, 43.9523, 19.4627> }
					triangle { <2.2023, 44.01358, 19.2154>, <2.3116, 43.9523, 19.4627>, <2.4748, 44.2261, 19.3458> }
					triangle { <2.009486, 43.7946, 19.2946>, <2.3116, 43.9523, 19.4627>, <2.2023, 44.01358, 19.2154> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <2.4897, 43.00166, 17.2681>, <2.113, 44.05905, 19.1932>, <1.9677, 44.2557, 19.01545> }
					triangle { <2.4897, 43.00166, 17.2681>, <2.3086, 43.4371, 18.401>, <2.113, 44.05905, 19.1932> }
					triangle { <1.9677, 44.2557, 19.01545>, <1.957, 43.6684, 18.2588>, <2.4897, 43.00166, 17.2681> }
					triangle { <2.3086, 43.4371, 18.401>, <2.4213, 44.1662, 19.2387>, <2.113, 44.05905, 19.1932> }
					triangle { <2.4213, 44.1662, 19.2387>, <2.6455, 44.6574, 19.2412>, <2.113, 44.05905, 19.1932> }
					triangle { <1.9677, 44.2557, 19.01545>, <1.91, 44.6168, 18.9627>, <1.6704, 44.2947, 18.9289> }
					triangle { <1.6704, 44.2947, 18.9289>, <1.957, 43.6684, 18.2588>, <1.9677, 44.2557, 19.01545> }
					triangle { <2.6455, 44.6574, 19.2412>, <2.527, 44.6547, 19.2643>, <2.1248, 44.4369, 19.1545> }
					triangle { <2.527, 44.6547, 19.2643>, <2.6357, 45.04392, 18.9204>, <2.03855, 44.8303, 19.01583> }
					triangle { <2.1248, 44.4369, 19.1545>, <2.03855, 44.8303, 19.01583>, <1.91, 44.6168, 18.9627> }
					triangle { <2.1248, 44.4369, 19.1545>, <2.527, 44.6547, 19.2643>, <2.03855, 44.8303, 19.01583> }
					triangle { <2.113, 44.05905, 19.1932>, <2.6455, 44.6574, 19.2412>, <2.1248, 44.4369, 19.1545> }
					triangle { <1.9677, 44.2557, 19.01545>, <2.1248, 44.4369, 19.1545>, <1.91, 44.6168, 18.9627> }
					triangle { <2.113, 44.05905, 19.1932>, <2.1248, 44.4369, 19.1545>, <1.9677, 44.2557, 19.01545> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <2.4897, 43.00166, 17.2681>, <1.8886, 44.1993, 19.04865>, <1.6144, 44.08837, 18.9861> }
					triangle { <2.4897, 43.00166, 17.2681>, <2.3182, 43.653, 18.2938>, <1.8886, 44.1993, 19.04865> }
					triangle { <1.6144, 44.08837, 18.9861>, <1.9462, 43.4255, 18.3793>, <2.4897, 43.00166, 17.2681> }
					triangle { <2.3182, 43.653, 18.2938>, <1.9171, 44.4954, 18.9067>, <1.8886, 44.1993, 19.04865> }
					triangle { <1.9171, 44.4954, 18.9067>, <1.56, 44.8785, 18.7755>, <1.8886, 44.1993, 19.04865> }
					triangle { <1.6144, 44.08837, 18.9861>, <1.2566, 44.1794, 18.9736>, <1.4487, 43.8439, 19.0871> }
					triangle { <1.4487, 43.8439, 19.0871>, <1.9462, 43.4255, 18.3793>, <1.6144, 44.08837, 18.9861> }
					triangle { <1.56, 44.8785, 18.7755>, <1.5248, 44.803, 18.8628>, <1.5448, 44.3558, 19.00739> }
					triangle { <1.5248, 44.803, 18.8628>, <1.1296, 44.8763, 18.5163>, <1.1258, 44.3956, 18.9411> }
					triangle { <1.5448, 44.3558, 19.00739>, <1.1258, 44.3956, 18.9411>, <1.2566, 44.1794, 18.9736> }
					triangle { <1.5448, 44.3558, 19.00739>, <1.5248, 44.803, 18.8628>, <1.1258, 44.3956, 18.9411> }
					triangle { <1.8886, 44.1993, 19.04865>, <1.56, 44.8785, 18.7755>, <1.5448, 44.3558, 19.00739> }
					triangle { <1.6144, 44.08837, 18.9861>, <1.5448, 44.3558, 19.00739>, <1.2566, 44.1794, 18.9736> }
					triangle { <1.8886, 44.1993, 19.04865>, <1.5448, 44.3558, 19.00739>, <1.6144, 44.08837, 18.9861> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <2.4897, 43.00166, 17.2681>, <1.6421, 44.0174, 19.06143>, <1.6323, 43.736, 19.1718> }
					triangle { <2.4897, 43.00166, 17.2681>, <2.09672, 43.6983, 18.1987>, <1.6421, 44.0174, 19.06143> }
					triangle { <1.6323, 43.736, 19.1718>, <2.1954, 43.3745, 18.4864>, <2.4897, 43.00166, 17.2681> }
					triangle { <2.09672, 43.6983, 18.1987>, <1.3487, 44.0889, 18.9295>, <1.6421, 44.0174, 19.06143> }
					triangle { <1.3487, 44.0889, 18.9295>, <0.8461, 43.9207, 19.0325>, <1.6421, 44.0174, 19.06143> }
					triangle { <1.6323, 43.736, 19.1718>, <1.4233, 43.5062, 19.3716>, <1.8214, 43.5643, 19.351> }
					triangle { <1.8214, 43.5643, 19.351>, <2.1954, 43.3745, 18.4864>, <1.6323, 43.736, 19.1718> }
					triangle { <0.8461, 43.9207, 19.0325>, <0.924, 43.9091, 19.1239>, <1.3716, 43.8102, 19.2296> }
					triangle { <0.924, 43.9091, 19.1239>, <0.635, 43.4668, 19.07531>, <1.1744, 43.4851, 19.4218> }
					triangle { <1.3716, 43.8102, 19.2296>, <1.1744, 43.4851, 19.4218>, <1.4233, 43.5062, 19.3716> }
					triangle { <1.3716, 43.8102, 19.2296>, <0.924, 43.9091, 19.1239>, <1.1744, 43.4851, 19.4218> }
					triangle { <1.6421, 44.0174, 19.06143>, <0.8461, 43.9207, 19.0325>, <1.3716, 43.8102, 19.2296> }
					triangle { <1.6323, 43.736, 19.1718>, <1.3716, 43.8102, 19.2296>, <1.4233, 43.5062, 19.3716> }
					triangle { <1.6421, 44.0174, 19.06143>, <1.3716, 43.8102, 19.2296>, <1.6323, 43.736, 19.1718> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		}
	union { // internode
		cylinder { <1.2197, 40.4447, 9.7703>, <2.01123, 42.915, 11.925>, 0.4996 }
		cylinder { <2.01123, 42.915, 11.925>, <2.9287, 45.5484, 13.8208>, 0.4996 }
		cylinder { <2.9287, 45.5484, 13.8208>, <3.9636, 48.3197, 15.4396>, 0.4996 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <3.9636, 48.3197, 15.4396>, <4.471, 49.4652, 15.6761>, 0.4048 }
			cylinder { <4.471, 49.4652, 15.6761>, <5.04333, 50.5928, 15.5131>, 0.4048 }
			cylinder { <5.04333, 50.5928, 15.5131>, <5.6227, 51.5887, 14.9671>, 0.4048 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <5.6227, 51.5887, 14.9671>, <5.8661, 52.00696, 14.7378>, 0.4048 }
				cylinder { <5.8661, 52.00696, 14.7378>, <6.1095, 52.4252, 14.5085>, 0.4048 }
				cylinder { <6.1095, 52.4252, 14.5085>, <6.3528, 52.8434, 14.2792>, 0.4048 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <6.3528, 52.8434, 14.2792>, <6.4086, 52.8962, 14.2487>, 0.02622 }
				cylinder { <6.4086, 52.8962, 14.2487>, <6.4785, 52.9334, 14.2254>, 0.02622 }
				cylinder { <6.4785, 52.9334, 14.2254>, <6.5576, 52.9523, 14.2108>, 0.02622 }
				texture{chif1}}
			mesh { // leaf
				triangle { <6.5576, 52.9523, 14.2108>, <10.9932, 53.9307, 13.03815>, <11.1473, 53.6067, 13.2053> }
				triangle { <10.9932, 53.9307, 13.03815>, <11.9063, 53.1166, 11.4878>, <11.1473, 53.6067, 13.2053> }
				triangle { <10.9932, 53.9307, 13.03815>, <11.6415, 53.5563, 11.6124>, <11.9063, 53.1166, 11.4878> }
				triangle { <11.9063, 53.1166, 11.4878>, <11.8722, 52.9506, 12.0775>, <11.1473, 53.6067, 13.2053> }
				triangle { <11.1473, 53.6067, 13.2053>, <9.3686, 53.06058, 13.4997>, <6.5576, 52.9523, 14.2108> }
				triangle { <6.5576, 52.9523, 14.2108>, <9.165, 53.6128, 13.1119>, <10.9932, 53.9307, 13.03815> }
				triangle { <9.165, 53.6128, 13.1119>, <10.772, 53.995, 12.418>, <10.9932, 53.9307, 13.03815> }
				triangle { <10.772, 53.995, 12.418>, <11.6415, 53.5563, 11.6124>, <10.9932, 53.9307, 13.03815> }
				triangle { <11.1473, 53.6067, 13.2053>, <11.8722, 52.9506, 12.0775>, <11.2195, 53.03925, 12.8618> }
				triangle { <11.2195, 53.03925, 12.8618>, <9.3686, 53.06058, 13.4997>, <11.1473, 53.6067, 13.2053> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <6.3528, 52.8434, 14.2792>, <6.3904, 52.9079, 14.2439>, 0.02622 }
				cylinder { <6.3904, 52.9079, 14.2439>, <6.4279, 52.9724, 14.2085>, 0.02622 }
				cylinder { <6.4279, 52.9724, 14.2085>, <6.4654, 53.037, 14.1731>, 0.02622 }
				texture{chif1}}
			mesh { // leaf
				triangle { <6.4654, 53.037, 14.1731>, <8.5017, 56.5639, 11.8447>, <8.8717, 56.4343, 11.8989> }
				triangle { <8.5017, 56.5639, 11.8447>, <9.1152, 56.4124, 9.9737>, <8.8717, 56.4343, 11.8989> }
				triangle { <8.5017, 56.5639, 11.8447>, <8.6958, 56.582, 10.2463>, <9.1152, 56.4124, 9.9737> }
				triangle { <9.1152, 56.4124, 9.9737>, <9.4005, 56.3155, 10.5081>, <8.8717, 56.4343, 11.8989> }
				triangle { <8.8717, 56.4343, 11.8989>, <8.0924, 54.889, 12.6427>, <6.4654, 53.037, 14.1731> }
				triangle { <6.4654, 53.037, 14.1731>, <7.4669, 55.1395, 12.4357>, <8.5017, 56.5639, 11.8447> }
				triangle { <7.4669, 55.1395, 12.4357>, <8.09424, 56.4153, 11.3453>, <8.5017, 56.5639, 11.8447> }
				triangle { <8.09424, 56.4153, 11.3453>, <8.6958, 56.582, 10.2463>, <8.5017, 56.5639, 11.8447> }
				triangle { <8.8717, 56.4343, 11.8989>, <9.4005, 56.3155, 10.5081>, <9.164, 56.02428, 11.4612> }
				triangle { <9.164, 56.02428, 11.4612>, <8.0924, 54.889, 12.6427>, <8.8717, 56.4343, 11.8989> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <3.9636, 48.3197, 15.4396>, <4.4818, 50.06435, 16.5406>, 0.3151 }
		cylinder { <4.4818, 50.06435, 16.5406>, <4.8625, 51.796, 17.7157>, 0.3151 }
		cylinder { <4.8625, 51.796, 17.7157>, <5.1039, 53.5054, 18.9584>, 0.3151 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <5.1039, 53.5054, 18.9584>, <5.07458, 53.6106, 19.06208>, 0.04782 }
			cylinder { <5.07458, 53.6106, 19.06208>, <5.002248, 53.6877, 19.1693>, 0.04782 }
			cylinder { <5.002248, 53.6877, 19.1693>, <4.8953, 53.7277, 19.2676>, 0.04782 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <4.8953, 53.7277, 19.2676>, <4.8503, 53.7424, 19.3094>, 0.04782 }
				cylinder { <4.8503, 53.7424, 19.3094>, <4.8051, 53.7549, 19.3519>, 0.04782 }
				cylinder { <4.8051, 53.7549, 19.3519>, <4.7599, 53.7654, 19.3949>, 0.04782 }
				texture{chif1}}
			}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <5.1039, 53.5054, 18.9584>, <5.1849, 53.8097, 19.1932>, 0.2183 }
			cylinder { <5.1849, 53.8097, 19.1932>, <5.3016, 54.09987, 19.431>, 0.2183 }
			cylinder { <5.3016, 54.09987, 19.431>, <5.4529, 54.3729, 19.6695>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <5.4529, 54.3729, 19.6695>, <5.6373, 54.6262, 19.9065>, 0.2183 }
			cylinder { <5.6373, 54.6262, 19.9065>, <5.853, 54.8574, 20.1396>, 0.2183 }
			cylinder { <5.853, 54.8574, 20.1396>, <6.09807, 55.06429, 20.3667>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <6.09807, 55.06429, 20.3667>, <6.3283, 55.3028, 20.5774>, 0.2183 }
			cylinder { <6.3283, 55.3028, 20.5774>, <6.5417, 55.5707, 20.7698>, 0.2183 }
			cylinder { <6.5417, 55.5707, 20.7698>, <6.7362, 55.8655, 20.9419>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <6.7362, 55.8655, 20.9419>, <6.9884, 56.3519, 21.1589>, 0.2183 }
				cylinder { <6.9884, 56.3519, 21.1589>, <7.1973, 56.8752, 21.3313>, 0.2183 }
				cylinder { <7.1973, 56.8752, 21.3313>, <7.3599, 57.4276, 21.4564>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <7.3599, 57.4276, 21.4564>, <7.7672, 59.5482, 22.08292>, <7.9842, 59.4181, 22.2533> }
					triangle { <7.3599, 57.4276, 21.4564>, <7.5089, 58.64, 21.6586>, <7.7672, 59.5482, 22.08292> }
					triangle { <7.9842, 59.4181, 22.2533>, <7.9294, 58.5681, 21.7965>, <7.3599, 57.4276, 21.4564> }
					triangle { <7.5089, 58.64, 21.6586>, <7.4945, 59.5863, 22.2693>, <7.7672, 59.5482, 22.08292> }
					triangle { <7.4945, 59.5863, 22.2693>, <7.4144, 59.655, 22.8037>, <7.7672, 59.5482, 22.08292> }
					triangle { <7.9842, 59.4181, 22.2533>, <8.1463, 59.4329, 22.5886>, <8.2921, 59.3637, 22.2155> }
					triangle { <8.2921, 59.3637, 22.2155>, <7.9294, 58.5681, 21.7965>, <7.9842, 59.4181, 22.2533> }
					triangle { <7.4144, 59.655, 22.8037>, <7.5246, 59.6871, 22.7631>, <7.8653, 59.5741, 22.4526> }
					triangle { <7.5246, 59.6871, 22.7631>, <7.5718, 59.4045, 23.2154>, <8.07499, 59.5117, 22.8227> }
					triangle { <7.8653, 59.5741, 22.4526>, <8.07499, 59.5117, 22.8227>, <8.1463, 59.4329, 22.5886> }
					triangle { <7.8653, 59.5741, 22.4526>, <7.5246, 59.6871, 22.7631>, <8.07499, 59.5117, 22.8227> }
					triangle { <7.7672, 59.5482, 22.08292>, <7.4144, 59.655, 22.8037>, <7.8653, 59.5741, 22.4526> }
					triangle { <7.9842, 59.4181, 22.2533>, <7.8653, 59.5741, 22.4526>, <8.1463, 59.4329, 22.5886> }
					triangle { <7.7672, 59.5482, 22.08292>, <7.8653, 59.5741, 22.4526>, <7.9842, 59.4181, 22.2533> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <7.3599, 57.4276, 21.4564>, <8.04046, 59.4478, 22.1715>, <8.2815, 59.3894, 21.9939> }
					triangle { <7.3599, 57.4276, 21.4564>, <7.5732, 58.5703, 21.8828>, <8.04046, 59.4478, 22.1715> }
					triangle { <8.2815, 59.3894, 21.9939>, <7.8571, 58.6466, 21.5443>, <7.3599, 57.4276, 21.4564> }
					triangle { <7.5732, 58.5703, 21.8828>, <8.1131, 59.3558, 22.4827>, <8.04046, 59.4478, 22.1715> }
					triangle { <8.1131, 59.3558, 22.4827>, <8.5793, 59.3215, 22.7624>, <8.04046, 59.4478, 22.1715> }
					triangle { <8.2815, 59.3894, 21.9939>, <8.6524, 59.4224, 21.9777>, <8.3603, 59.461, 21.6976> }
					triangle { <8.3603, 59.461, 21.6976>, <7.8571, 58.6466, 21.5443>, <8.2815, 59.3894, 21.9939> }
					triangle { <8.5793, 59.3215, 22.7624>, <8.5811, 59.3979, 22.6675>, <8.4197, 59.4623, 22.2259> }
					triangle { <8.5811, 59.3979, 22.6675>, <9.02601, 59.1, 22.6707>, <8.8422, 59.4382, 22.1504> }
					triangle { <8.4197, 59.4623, 22.2259>, <8.8422, 59.4382, 22.1504>, <8.6524, 59.4224, 21.9777> }
					triangle { <8.4197, 59.4623, 22.2259>, <8.5811, 59.3979, 22.6675>, <8.8422, 59.4382, 22.1504> }
					triangle { <8.04046, 59.4478, 22.1715>, <8.5793, 59.3215, 22.7624>, <8.4197, 59.4623, 22.2259> }
					triangle { <8.2815, 59.3894, 21.9939>, <8.4197, 59.4623, 22.2259>, <8.6524, 59.4224, 21.9777> }
					triangle { <8.04046, 59.4478, 22.1715>, <8.4197, 59.4623, 22.2259>, <8.2815, 59.3894, 21.9939> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <7.3599, 57.4276, 21.4564>, <8.2253, 59.4481, 21.9299>, <8.1497, 59.5082, 21.6405> }
					triangle { <7.3599, 57.4276, 21.4564>, <7.8069, 58.5027, 21.8776>, <8.2253, 59.4481, 21.9299> }
					triangle { <8.1497, 59.5082, 21.6405>, <7.5941, 58.7226, 21.5501>, <7.3599, 57.4276, 21.4564> }
					triangle { <7.8069, 58.5027, 21.8776>, <8.5436, 59.3524, 21.9387>, <8.2253, 59.4481, 21.9299> }
					triangle { <8.5436, 59.3524, 21.9387>, <8.9752, 59.4627, 21.6251>, <8.2253, 59.4481, 21.9299> }
					triangle { <8.1497, 59.5082, 21.6405>, <8.2695, 59.6812, 21.3328>, <7.9012, 59.641, 21.4999> }
					triangle { <7.9012, 59.641, 21.4999>, <7.5941, 58.7226, 21.5501>, <8.1497, 59.5082, 21.6405> }
					triangle { <8.9752, 59.4627, 21.6251>, <8.8858, 59.5453, 21.6214>, <8.4143, 59.5985, 21.6321> }
					triangle { <8.8858, 59.5453, 21.6214>, <9.05873, 59.4405, 21.1256>, <8.4992, 59.746, 21.2373> }
					triangle { <8.4143, 59.5985, 21.6321>, <8.4992, 59.746, 21.2373>, <8.2695, 59.6812, 21.3328> }
					triangle { <8.4143, 59.5985, 21.6321>, <8.8858, 59.5453, 21.6214>, <8.4992, 59.746, 21.2373> }
					triangle { <8.2253, 59.4481, 21.9299>, <8.9752, 59.4627, 21.6251>, <8.4143, 59.5985, 21.6321> }
					triangle { <8.1497, 59.5082, 21.6405>, <8.4143, 59.5985, 21.6321>, <8.2695, 59.6812, 21.3328> }
					triangle { <8.2253, 59.4481, 21.9299>, <8.4143, 59.5985, 21.6321>, <8.1497, 59.5082, 21.6405> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <7.3599, 57.4276, 21.4564>, <8.06811, 59.5488, 21.6896>, <7.7697, 59.6115, 21.6781> }
					triangle { <7.3599, 57.4276, 21.4564>, <7.8893, 58.5299, 21.6502>, <8.06811, 59.5488, 21.6896> }
					triangle { <7.7697, 59.6115, 21.6781>, <7.5014, 58.6919, 21.806>, <7.3599, 57.4276, 21.4564> }
					triangle { <7.8893, 58.5299, 21.6502>, <8.1951, 59.5807, 21.3839>, <8.06811, 59.5488, 21.6896> }
					triangle { <8.1951, 59.5807, 21.3839>, <8.05871, 59.8847, 20.953>, <8.06811, 59.5488, 21.6896> }
					triangle { <7.7697, 59.6115, 21.6781>, <7.5232, 59.8541, 21.5391>, <7.5448, 59.6566, 21.8937> }
					triangle { <7.5448, 59.6566, 21.8937>, <7.5014, 58.6919, 21.806>, <7.7697, 59.6115, 21.6781> }
					triangle { <8.05871, 59.8847, 20.953>, <8.02048, 59.927, 21.06069>, <7.8566, 59.7957, 21.4863> }
					triangle { <8.02048, 59.927, 21.06069>, <7.625, 59.9586, 20.7011>, <7.5169, 60.01267, 21.3368> }
					triangle { <7.8566, 59.7957, 21.4863>, <7.5169, 60.01267, 21.3368>, <7.5232, 59.8541, 21.5391> }
					triangle { <7.8566, 59.7957, 21.4863>, <8.02048, 59.927, 21.06069>, <7.5169, 60.01267, 21.3368> }
					triangle { <8.06811, 59.5488, 21.6896>, <8.05871, 59.8847, 20.953>, <7.8566, 59.7957, 21.4863> }
					triangle { <7.7697, 59.6115, 21.6781>, <7.8566, 59.7957, 21.4863>, <7.5232, 59.8541, 21.5391> }
					triangle { <8.06811, 59.5488, 21.6896>, <7.8566, 59.7957, 21.4863>, <7.7697, 59.6115, 21.6781> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <7.3599, 57.4276, 21.4564>, <7.7807, 59.6116, 21.7856>, <7.6659, 59.555, 22.06256> }
					triangle { <7.3599, 57.4276, 21.4564>, <7.7023, 58.6161, 21.5128>, <7.7807, 59.6116, 21.7856> }
					triangle { <7.6659, 59.555, 22.06256>, <7.7118, 58.595, 21.9605>, <7.3599, 57.4276, 21.4564> }
					triangle { <7.7023, 58.6161, 21.5128>, <7.5369, 59.7274, 21.5913>, <7.7807, 59.6116, 21.7856> }
					triangle { <7.5369, 59.7274, 21.5913>, <7.07948, 60.00542, 21.6924>, <7.7807, 59.6116, 21.7856> }
					triangle { <7.6659, 59.555, 22.06256>, <7.4459, 59.6983, 22.327>, <7.79, 59.4827, 22.3427> }
					triangle { <7.79, 59.4827, 22.3427>, <7.7118, 58.595, 21.9605>, <7.6659, 59.555, 22.06256> }
					triangle { <7.07948, 60.00542, 21.6924>, <7.1665, 60.01606, 21.7769>, <7.5122, 59.7804, 22.00111> }
					triangle { <7.1665, 60.01606, 21.7769>, <6.6922, 59.9361, 22.01214>, <7.2507, 59.8656, 22.3314> }
					triangle { <7.5122, 59.7804, 22.00111>, <7.2507, 59.8656, 22.3314>, <7.4459, 59.6983, 22.327> }
					triangle { <7.5122, 59.7804, 22.00111>, <7.1665, 60.01606, 21.7769>, <7.2507, 59.8656, 22.3314> }
					triangle { <7.7807, 59.6116, 21.7856>, <7.07948, 60.00542, 21.6924>, <7.5122, 59.7804, 22.00111> }
					triangle { <7.6659, 59.555, 22.06256>, <7.5122, 59.7804, 22.00111>, <7.4459, 59.6983, 22.327> }
					triangle { <7.7807, 59.6116, 21.7856>, <7.5122, 59.7804, 22.00111>, <7.6659, 59.555, 22.06256> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <6.7362, 55.8655, 20.9419>, <6.9263, 56.1411, 21.1473>, 0.2183 }
			cylinder { <6.9263, 56.1411, 21.1473>, <7.1104, 56.395, 21.384>, 0.2183 }
			cylinder { <7.1104, 56.395, 21.384>, <7.2866, 56.6247, 21.6496>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.2866, 56.6247, 21.6496>, <7.5326, 56.9192, 22.09683>, 0.2183 }
				cylinder { <7.5326, 56.9192, 22.09683>, <7.7566, 57.1593, 22.5861>, 0.2183 }
				cylinder { <7.7566, 57.1593, 22.5861>, <7.9551, 57.3413, 23.1103>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <7.9551, 57.3413, 23.1103>, <8.9082, 57.87, 25.06768>, <8.9809, 58.1267, 24.9219> }
					triangle { <7.9551, 57.3413, 23.1103>, <8.3765, 57.5204, 24.2558>, <8.9082, 57.87, 25.06768> }
					triangle { <8.9809, 58.1267, 24.9219>, <8.3781, 57.9621, 24.1891>, <7.9551, 57.3413, 23.1103> }
					triangle { <8.3765, 57.5204, 24.2558>, <9.163, 57.6594, 25.04431>, <8.9082, 57.87, 25.06768> }
					triangle { <9.163, 57.6594, 25.04431>, <9.6988, 57.7284, 24.9919>, <8.9082, 57.87, 25.06768> }
					triangle { <8.9809, 58.1267, 24.9219>, <9.2547, 58.3737, 24.8778>, <8.8521, 58.412, 24.9007> }
					triangle { <8.8521, 58.412, 24.9007>, <8.3781, 57.9621, 24.1891>, <8.9809, 58.1267, 24.9219> }
					triangle { <9.6988, 57.7284, 24.9919>, <9.6389, 57.8223, 25.04017>, <9.2335, 58.06517, 25.02214> }
					triangle { <9.6389, 57.8223, 25.04017>, <9.9856, 57.9961, 24.6738>, <9.5099, 58.3685, 24.8993> }
					triangle { <9.2335, 58.06517, 25.02214>, <9.5099, 58.3685, 24.8993>, <9.2547, 58.3737, 24.8778> }
					triangle { <9.2335, 58.06517, 25.02214>, <9.6389, 57.8223, 25.04017>, <9.5099, 58.3685, 24.8993> }
					triangle { <8.9082, 57.87, 25.06768>, <9.6988, 57.7284, 24.9919>, <9.2335, 58.06517, 25.02214> }
					triangle { <8.9809, 58.1267, 24.9219>, <9.2335, 58.06517, 25.02214>, <9.2547, 58.3737, 24.8778> }
					triangle { <8.9082, 57.87, 25.06768>, <9.2335, 58.06517, 25.02214>, <8.9809, 58.1267, 24.9219> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <7.9551, 57.3413, 23.1103>, <8.8963, 58.1576, 24.9723>, <8.6536, 58.3406, 24.9716> }
					triangle { <7.9551, 57.3413, 23.1103>, <8.5533, 57.6446, 24.1457>, <8.8963, 58.1576, 24.9723> }
					triangle { <8.6536, 58.3406, 24.9716>, <8.1792, 57.8224, 24.313>, <7.9551, 57.3413, 23.1103> }
					triangle { <8.5533, 57.6446, 24.1457>, <9.1472, 58.3141, 24.8228>, <8.8963, 58.1576, 24.9723> }
					triangle { <9.1472, 58.3141, 24.8228>, <9.2776, 58.838, 24.7661>, <8.8963, 58.1576, 24.9723> }
					triangle { <8.6536, 58.3406, 24.9716>, <8.5479, 58.6909, 25.0355>, <8.372, 58.3336, 25.1098> }
					triangle { <8.372, 58.3336, 25.1098>, <8.1792, 57.8224, 24.313>, <8.6536, 58.3406, 24.9716> }
					triangle { <9.2776, 58.838, 24.7661>, <9.2056, 58.8124, 24.8604>, <8.8502, 58.5355, 25.00401> }
					triangle { <9.2056, 58.8124, 24.8604>, <9.0243, 59.244, 24.6047>, <8.6626, 58.9198, 25.0289> }
					triangle { <8.8502, 58.5355, 25.00401>, <8.6626, 58.9198, 25.0289>, <8.5479, 58.6909, 25.0355> }
					triangle { <8.8502, 58.5355, 25.00401>, <9.2056, 58.8124, 24.8604>, <8.6626, 58.9198, 25.0289> }
					triangle { <8.8963, 58.1576, 24.9723>, <9.2776, 58.838, 24.7661>, <8.8502, 58.5355, 25.00401> }
					triangle { <8.6536, 58.3406, 24.9716>, <8.8502, 58.5355, 25.00401>, <8.5479, 58.6909, 25.0355> }
					triangle { <8.8963, 58.1576, 24.9723>, <8.8502, 58.5355, 25.00401>, <8.6536, 58.3406, 24.9716> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <7.9551, 57.3413, 23.1103>, <8.6218, 58.2682, 25.0379>, <8.3849, 58.1154, 25.1516> }
					triangle { <7.9551, 57.3413, 23.1103>, <8.4715, 57.8682, 24.0991>, <8.6218, 58.2682, 25.0379> }
					triangle { <8.3849, 58.1154, 25.1516>, <8.2711, 57.5709, 24.3655>, <7.9551, 57.3413, 23.1103> }
					triangle { <8.4715, 57.8682, 24.0991>, <8.5245, 58.5771, 24.9675>, <8.6218, 58.2682, 25.0379> }
					triangle { <8.5245, 58.5771, 24.9675>, <8.1422, 58.9026, 25.1738>, <8.6218, 58.2682, 25.0379> }
					triangle { <8.3849, 58.1154, 25.1516>, <8.1046, 58.143, 25.3937>, <8.349, 57.8367, 25.2911> }
					triangle { <8.349, 57.8367, 25.2911>, <8.2711, 57.5709, 24.3655>, <8.3849, 58.1154, 25.1516> }
					triangle { <8.1422, 58.9026, 25.1738>, <8.1809, 58.8146, 25.2479>, <8.3274, 58.3651, 25.2612> }
					triangle { <8.1809, 58.8146, 25.2479>, <7.6486, 58.8457, 25.2642>, <7.9692, 58.3357, 25.4944> }
					triangle { <8.3274, 58.3651, 25.2612>, <7.9692, 58.3357, 25.4944>, <8.1046, 58.143, 25.3937> }
					triangle { <8.3274, 58.3651, 25.2612>, <8.1809, 58.8146, 25.2479>, <7.9692, 58.3357, 25.4944> }
					triangle { <8.6218, 58.2682, 25.0379>, <8.1422, 58.9026, 25.1738>, <8.3274, 58.3651, 25.2612> }
					triangle { <8.3849, 58.1154, 25.1516>, <8.3274, 58.3651, 25.2612>, <8.1046, 58.143, 25.3937> }
					triangle { <8.6218, 58.2682, 25.0379>, <8.3274, 58.3651, 25.2612>, <8.3849, 58.1154, 25.1516> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <7.9551, 57.3413, 23.1103>, <8.4614, 58.05016, 25.1743>, <8.5436, 57.7603, 25.2148> }
					triangle { <7.9551, 57.3413, 23.1103>, <8.2435, 57.8842, 24.1799>, <8.4614, 58.05016, 25.1743> }
					triangle { <8.5436, 57.7603, 25.2148>, <8.5277, 57.5529, 24.2745>, <7.9551, 57.3413, 23.1103> }
					triangle { <8.2435, 57.8842, 24.1799>, <8.1495, 58.08737, 25.2796>, <8.4614, 58.05016, 25.1743> }
					triangle { <8.1495, 58.08737, 25.2796>, <7.8511, 57.8335, 25.6554>, <8.4614, 58.05016, 25.1743> }
					triangle { <8.5436, 57.7603, 25.2148>, <8.5333, 57.4821, 25.4608>, <8.8146, 57.6034, 25.1957> }
					triangle { <8.8146, 57.6034, 25.1957>, <8.5277, 57.5529, 24.2745>, <8.5436, 57.7603, 25.2148> }
					triangle { <7.8511, 57.8335, 25.6554>, <7.9712, 57.8258, 25.6707>, <8.3827, 57.7878, 25.4407> }
					triangle { <7.9712, 57.8258, 25.6707>, <7.7469, 57.3479, 25.7471>, <8.3815, 57.418, 25.6569> }
					triangle { <8.3827, 57.7878, 25.4407>, <8.3815, 57.418, 25.6569>, <8.5333, 57.4821, 25.4608> }
					triangle { <8.3827, 57.7878, 25.4407>, <7.9712, 57.8258, 25.6707>, <8.3815, 57.418, 25.6569> }
					triangle { <8.4614, 58.05016, 25.1743>, <7.8511, 57.8335, 25.6554>, <8.3827, 57.7878, 25.4407> }
					triangle { <8.5436, 57.7603, 25.2148>, <8.3827, 57.7878, 25.4407>, <8.5333, 57.4821, 25.4608> }
					triangle { <8.4614, 58.05016, 25.1743>, <8.3827, 57.7878, 25.4407>, <8.5436, 57.7603, 25.2148> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <7.9551, 57.3413, 23.1103>, <8.6411, 57.8003, 25.193>, <8.9175, 57.7673, 25.07075> }
					triangle { <7.9551, 57.3413, 23.1103>, <8.1838, 57.666, 24.2783>, <8.6411, 57.8003, 25.193> }
					triangle { <8.9175, 57.7673, 25.07075>, <8.5948, 57.7983, 24.1639>, <7.9551, 57.3413, 23.1103> }
					triangle { <8.1838, 57.666, 24.2783>, <8.55, 57.5116, 25.3278>, <8.6411, 57.8003, 25.193> }
					triangle { <8.55, 57.5116, 25.3278>, <8.8276, 57.09693, 25.5412>, <8.6411, 57.8003, 25.193> }
					triangle { <8.9175, 57.7673, 25.07075>, <9.2548, 57.6269, 25.1371>, <9.1302, 57.9643, 24.9508> }
					triangle { <9.1302, 57.9643, 24.9508>, <8.5948, 57.7983, 24.1639>, <8.9175, 57.7673, 25.07075> }
					triangle { <8.8276, 57.09693, 25.5412>, <8.886, 57.2033, 25.5404>, <8.9512, 57.5996, 25.2907> }
					triangle { <8.886, 57.2033, 25.5404>, <9.2131, 56.8149, 25.3768>, <9.3481, 57.4386, 25.2836> }
					triangle { <8.9512, 57.5996, 25.2907>, <9.3481, 57.4386, 25.2836>, <9.2548, 57.6269, 25.1371> }
					triangle { <8.9512, 57.5996, 25.2907>, <8.886, 57.2033, 25.5404>, <9.3481, 57.4386, 25.2836> }
					triangle { <8.6411, 57.8003, 25.193>, <8.8276, 57.09693, 25.5412>, <8.9512, 57.5996, 25.2907> }
					triangle { <8.9175, 57.7673, 25.07075>, <8.9512, 57.5996, 25.2907>, <9.2548, 57.6269, 25.1371> }
					triangle { <8.6411, 57.8003, 25.193>, <8.9512, 57.5996, 25.2907>, <8.9175, 57.7673, 25.07075> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <7.2866, 56.6247, 21.6496>, <7.4908, 56.8597, 21.8892>, 0.2183 }
			cylinder { <7.4908, 56.8597, 21.8892>, <7.721, 57.09791, 22.1005>, 0.2183 }
			cylinder { <7.721, 57.09791, 22.1005>, <7.9749, 57.3368, 22.2814>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.9749, 57.3368, 22.2814>, <8.3953, 57.6918, 22.4924>, 0.2183 }
				cylinder { <8.3953, 57.6918, 22.4924>, <8.8488, 58.0382, 22.6397>, 0.2183 }
				cylinder { <8.8488, 58.0382, 22.6397>, <9.3285, 58.3706, 22.7212>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <9.3285, 58.3706, 22.7212>, <11.02996, 59.8177, 22.8944>, <10.9317, 59.8434, 23.1809> }
					triangle { <9.3285, 58.3706, 22.7212>, <10.3311, 59.08852, 22.6851>, <11.02996, 59.8177, 22.8944> }
					triangle { <10.9317, 59.8434, 23.1809>, <10.3675, 59.06469, 23.1297>, <9.3285, 58.3706, 22.7212> }
					triangle { <10.3311, 59.08852, 22.6851>, <10.8931, 60.05954, 22.7137>, <11.02996, 59.8177, 22.8944> }
					triangle { <10.8931, 60.05954, 22.7137>, <10.7174, 60.559, 22.8332>, <11.02996, 59.8177, 22.8944> }
					triangle { <10.9317, 59.8434, 23.1809>, <10.8734, 60.09052, 23.452>, <11.01024, 59.7092, 23.4535> }
					triangle { <11.01024, 59.7092, 23.4535>, <10.3675, 59.06469, 23.1297>, <10.9317, 59.8434, 23.1809> }
					triangle { <10.7174, 60.559, 22.8332>, <10.7996, 60.5133, 22.9099>, <10.9449, 60.1148, 23.1191> }
					triangle { <10.7996, 60.5133, 22.9099>, <10.4034, 60.7428, 23.1835>, <10.8247, 60.3418, 23.4619> }
					triangle { <10.9449, 60.1148, 23.1191>, <10.8247, 60.3418, 23.4619>, <10.8734, 60.09052, 23.452> }
					triangle { <10.9449, 60.1148, 23.1191>, <10.7996, 60.5133, 22.9099>, <10.8247, 60.3418, 23.4619> }
					triangle { <11.02996, 59.8177, 22.8944>, <10.7174, 60.559, 22.8332>, <10.9449, 60.1148, 23.1191> }
					triangle { <10.9317, 59.8434, 23.1809>, <10.9449, 60.1148, 23.1191>, <10.8734, 60.09052, 23.452> }
					triangle { <11.02996, 59.8177, 22.8944>, <10.9449, 60.1148, 23.1191>, <10.9317, 59.8434, 23.1809> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <9.3285, 58.3706, 22.7212>, <11.00842, 59.7755, 23.1938>, <11.1132, 59.5391, 23.3536> }
					triangle { <9.3285, 58.3706, 22.7212>, <10.2089, 59.2261, 22.8431>, <11.00842, 59.7755, 23.1938> }
					triangle { <11.1132, 59.5391, 23.3536>, <10.505, 58.9098, 22.9519>, <9.3285, 58.3706, 22.7212> }
					triangle { <10.2089, 59.2261, 22.8431>, <10.8369, 59.973, 23.3973>, <11.00842, 59.7755, 23.1938> }
					triangle { <10.8369, 59.973, 23.3973>, <10.867, 60.07444, 23.9297>, <11.00842, 59.7755, 23.1938> }
					triangle { <11.1132, 59.5391, 23.3536>, <11.28, 59.4496, 23.6732>, <11.3159, 59.3067, 23.2959> }
					triangle { <11.3159, 59.3067, 23.2959>, <10.505, 58.9098, 22.9519>, <11.1132, 59.5391, 23.3536> }
					triangle { <10.867, 60.07444, 23.9297>, <10.9688, 60.03167, 23.8793>, <11.1354, 59.7339, 23.5517> }
					triangle { <10.9688, 60.03167, 23.8793>, <10.8743, 59.78, 24.34>, <11.2949, 59.5544, 23.9064> }
					triangle { <11.1354, 59.7339, 23.5517>, <11.2949, 59.5544, 23.9064>, <11.28, 59.4496, 23.6732> }
					triangle { <11.1354, 59.7339, 23.5517>, <10.9688, 60.03167, 23.8793>, <11.2949, 59.5544, 23.9064> }
					triangle { <11.00842, 59.7755, 23.1938>, <10.867, 60.07444, 23.9297>, <11.1354, 59.7339, 23.5517> }
					triangle { <11.1132, 59.5391, 23.3536>, <11.1354, 59.7339, 23.5517>, <11.28, 59.4496, 23.6732> }
					triangle { <11.00842, 59.7755, 23.1938>, <11.1354, 59.7339, 23.5517>, <11.1132, 59.5391, 23.3536> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <9.3285, 58.3706, 22.7212>, <11.1675, 59.528, 23.2666>, <11.3026, 59.334, 23.07548> }
					triangle { <9.3285, 58.3706, 22.7212>, <10.2372, 59.1311, 23.06447>, <11.1675, 59.528, 23.2666> }
					triangle { <11.3026, 59.334, 23.07548>, <10.4732, 59.0167, 22.7029>, <9.3285, 58.3706, 22.7212> }
					triangle { <10.2372, 59.1311, 23.06447>, <11.1969, 59.4101, 23.575>, <11.1675, 59.528, 23.2666> }
					triangle { <11.1969, 59.4101, 23.575>, <11.5649, 59.09452, 23.8189>, <11.1675, 59.528, 23.2666> }
					triangle { <11.3026, 59.334, 23.07548>, <11.6101, 59.1309, 23.02943>, <11.3802, 59.3424, 22.7716> }
					triangle { <11.3802, 59.3424, 22.7716>, <10.4732, 59.0167, 22.7029>, <11.3026, 59.334, 23.07548> }
					triangle { <11.5649, 59.09452, 23.8189>, <11.6043, 59.1534, 23.7204>, <11.4768, 59.305, 23.291> }
					triangle { <11.6043, 59.1534, 23.7204>, <11.7678, 58.6458, 23.7064>, <11.7838, 59.02558, 23.1854> }
					triangle { <11.4768, 59.305, 23.291>, <11.7838, 59.02558, 23.1854>, <11.6101, 59.1309, 23.02943> }
					triangle { <11.4768, 59.305, 23.291>, <11.6043, 59.1534, 23.7204>, <11.7838, 59.02558, 23.1854> }
					triangle { <11.1675, 59.528, 23.2666>, <11.5649, 59.09452, 23.8189>, <11.4768, 59.305, 23.291> }
					triangle { <11.3026, 59.334, 23.07548>, <11.4768, 59.305, 23.291>, <11.6101, 59.1309, 23.02943> }
					triangle { <11.1675, 59.528, 23.2666>, <11.4768, 59.305, 23.291>, <11.3026, 59.334, 23.07548> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <9.3285, 58.3706, 22.7212>, <11.289, 59.4149, 23.01291>, <11.2399, 59.5096, 22.7282> }
					triangle { <9.3285, 58.3706, 22.7212>, <10.3771, 58.9339, 23.04539>, <11.289, 59.4149, 23.01291> }
					triangle { <11.2399, 59.5096, 22.7282>, <10.3158, 59.2385, 22.7244>, <9.3285, 58.3706, 22.7212> }
					triangle { <10.3771, 58.9339, 23.04539>, <11.4788, 59.1435, 23.00285>, <11.289, 59.4149, 23.01291> }
					triangle { <11.4788, 59.1435, 23.00285>, <11.8531, 58.9643, 22.6529>, <11.289, 59.4149, 23.01291> }
					triangle { <11.2399, 59.5096, 22.7282>, <11.4106, 59.5719, 22.4043>, <11.1148, 59.7673, 22.6002> }
					triangle { <11.1148, 59.7673, 22.6002>, <10.3158, 59.2385, 22.7244>, <11.2399, 59.5096, 22.7282> }
					triangle { <11.8531, 58.9643, 22.6529>, <11.8339, 59.08417, 22.6514>, <11.5006, 59.4168, 22.6948> }
					triangle { <11.8339, 59.08417, 22.6514>, <11.8574, 58.8971, 22.1523>, <11.6204, 59.4811, 22.2886> }
					triangle { <11.5006, 59.4168, 22.6948>, <11.6204, 59.4811, 22.2886>, <11.4106, 59.5719, 22.4043> }
					triangle { <11.5006, 59.4168, 22.6948>, <11.8339, 59.08417, 22.6514>, <11.6204, 59.4811, 22.2886> }
					triangle { <11.289, 59.4149, 23.01291>, <11.8531, 58.9643, 22.6529>, <11.5006, 59.4168, 22.6948> }
					triangle { <11.2399, 59.5096, 22.7282>, <11.5006, 59.4168, 22.6948>, <11.4106, 59.5719, 22.4043> }
					triangle { <11.289, 59.4149, 23.01291>, <11.5006, 59.4168, 22.6948>, <11.2399, 59.5096, 22.7282> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <9.3285, 58.3706, 22.7212>, <11.2026, 59.5967, 22.7793>, <11.00728, 59.8291, 22.7944> }
					triangle { <9.3285, 58.3706, 22.7212>, <10.436, 58.9072, 22.8074>, <11.2026, 59.5967, 22.7793> }
					triangle { <11.00728, 59.8291, 22.7944>, <10.2495, 59.2686, 22.9921>, <9.3285, 58.3706, 22.7212> }
					triangle { <10.436, 58.9072, 22.8074>, <11.2882, 59.5509, 22.4625>, <11.2026, 59.5967, 22.7793> }
					triangle { <11.2882, 59.5509, 22.4625>, <11.3214, 59.8831, 22.03456>, <11.2026, 59.5967, 22.7793> }
					triangle { <11.00728, 59.8291, 22.7944>, <10.9485, 60.1739, 22.6694>, <10.8827, 59.9974, 23.02806> }
					triangle { <10.8827, 59.9974, 23.02806>, <10.2495, 59.2686, 22.9921>, <11.00728, 59.8291, 22.7944> }
					triangle { <11.3214, 59.8831, 22.03456>, <11.329, 59.9372, 22.1429>, <11.1668, 59.9249, 22.5869> }
					triangle { <11.329, 59.9372, 22.1429>, <11.00153, 60.2127, 21.8243>, <11.01872, 60.3069, 22.462> }
					triangle { <11.1668, 59.9249, 22.5869>, <11.01872, 60.3069, 22.462>, <10.9485, 60.1739, 22.6694> }
					triangle { <11.1668, 59.9249, 22.5869>, <11.329, 59.9372, 22.1429>, <11.01872, 60.3069, 22.462> }
					triangle { <11.2026, 59.5967, 22.7793>, <11.3214, 59.8831, 22.03456>, <11.1668, 59.9249, 22.5869> }
					triangle { <11.00728, 59.8291, 22.7944>, <11.1668, 59.9249, 22.5869>, <10.9485, 60.1739, 22.6694> }
					triangle { <11.2026, 59.5967, 22.7793>, <11.1668, 59.9249, 22.5869>, <11.00728, 59.8291, 22.7944> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <7.9749, 57.3368, 22.2814>, <8.1983, 57.5954, 22.4753>, 0.2183 }
			cylinder { <8.1983, 57.5954, 22.4753>, <8.389, 57.8711, 22.6802>, 0.2183 }
			cylinder { <8.389, 57.8711, 22.6802>, <8.5451, 58.1613, 22.8941>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <8.5451, 58.1613, 22.8941>, <8.7113, 58.6178, 23.2275>, 0.2183 }
				cylinder { <8.7113, 58.6178, 23.2275>, <8.8072, 59.08883, 23.5685>, 0.2183 }
				cylinder { <8.8072, 59.08883, 23.5685>, <8.8311, 59.567, 23.912>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <8.8311, 59.567, 23.912>, <8.8679, 61.2226, 25.4116>, <9.1675, 61.2068, 25.3684> }
					triangle { <8.8311, 59.567, 23.912>, <8.6933, 60.5068, 24.6939>, <8.8679, 61.2226, 25.4116> }
					triangle { <9.1675, 61.2068, 25.3684>, <9.09407, 60.6642, 24.5795>, <8.8311, 59.567, 23.912> }
					triangle { <8.6933, 60.5068, 24.6939>, <8.7894, 61.03798, 25.6742>, <8.8679, 61.2226, 25.4116> }
					triangle { <8.7894, 61.03798, 25.6742>, <9.05969, 60.8945, 26.1207>, <8.8679, 61.2226, 25.4116> }
					triangle { <9.1675, 61.2068, 25.3684>, <9.4918, 61.2215, 25.5467>, <9.3715, 61.359, 25.1865> }
					triangle { <9.3715, 61.359, 25.1865>, <9.09407, 60.6642, 24.5795>, <9.1675, 61.2068, 25.3684> }
					triangle { <9.05969, 60.8945, 26.1207>, <9.09937, 60.9951, 26.06645>, <9.1671, 61.1981, 25.6462> }
					triangle { <9.09937, 60.9951, 26.06645>, <9.5115, 60.687, 26.2011>, <9.5703, 61.1736, 25.785> }
					triangle { <9.1671, 61.1981, 25.6462>, <9.5703, 61.1736, 25.785>, <9.4918, 61.2215, 25.5467> }
					triangle { <9.1671, 61.1981, 25.6462>, <9.09937, 60.9951, 26.06645>, <9.5703, 61.1736, 25.785> }
					triangle { <8.8679, 61.2226, 25.4116>, <9.05969, 60.8945, 26.1207>, <9.1671, 61.1981, 25.6462> }
					triangle { <9.1675, 61.2068, 25.3684>, <9.1671, 61.1981, 25.6462>, <9.4918, 61.2215, 25.5467> }
					triangle { <8.8679, 61.2226, 25.4116>, <9.1671, 61.1981, 25.6462>, <9.1675, 61.2068, 25.3684> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <8.8311, 59.567, 23.912>, <9.1441, 61.2849, 25.3056>, <9.2127, 61.433, 25.05027> }
					triangle { <8.8311, 59.567, 23.912>, <8.9042, 60.4309, 24.7848>, <9.1441, 61.2849, 25.3056> }
					triangle { <9.2127, 61.433, 25.05027>, <8.8568, 60.7496, 24.4772>, <8.8311, 59.567, 23.912> }
					triangle { <8.9042, 60.4309, 24.7848>, <9.424, 61.1734, 25.4413>, <9.1441, 61.2849, 25.3056> }
					triangle { <9.424, 61.1734, 25.4413>, <9.9365, 61.347, 25.4295>, <9.1441, 61.2849, 25.3056> }
					triangle { <9.2127, 61.433, 25.05027>, <9.4473, 61.6821, 24.9084>, <9.05303, 61.6151, 24.8522> }
					triangle { <9.05303, 61.6151, 24.8522>, <8.8568, 60.7496, 24.4772>, <9.2127, 61.433, 25.05027> }
					triangle { <9.9365, 61.347, 25.4295>, <9.8529, 61.4313, 25.4064>, <9.4358, 61.5056, 25.1992> }
					triangle { <9.8529, 61.4313, 25.4064>, <10.2522, 61.4713, 25.05731>, <9.685, 61.7589, 24.9621> }
					triangle { <9.4358, 61.5056, 25.1992>, <9.685, 61.7589, 24.9621>, <9.4473, 61.6821, 24.9084> }
					triangle { <9.4358, 61.5056, 25.1992>, <9.8529, 61.4313, 25.4064>, <9.685, 61.7589, 24.9621> }
					triangle { <9.1441, 61.2849, 25.3056>, <9.9365, 61.347, 25.4295>, <9.4358, 61.5056, 25.1992> }
					triangle { <9.2127, 61.433, 25.05027>, <9.4358, 61.5056, 25.1992>, <9.4473, 61.6821, 24.9084> }
					triangle { <9.1441, 61.2849, 25.3056>, <9.4358, 61.5056, 25.1992>, <9.2127, 61.433, 25.05027> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <8.8311, 59.567, 23.912>, <9.1145, 61.4614, 25.06198>, <8.8565, 61.5413, 24.9243> }
					triangle { <8.8311, 59.567, 23.912>, <9.08247, 60.5203, 24.6479>, <9.1145, 61.4614, 25.06198> }
					triangle { <8.8565, 61.5413, 24.9243>, <8.6563, 60.649, 24.6312>, <8.8311, 59.567, 23.912> }
					triangle { <9.08247, 60.5203, 24.6479>, <9.3686, 61.5761, 24.8845>, <9.1145, 61.4614, 25.06198> }
					triangle { <9.3686, 61.5761, 24.8845>, <9.4285, 62.00089, 24.5544>, <9.1145, 61.4614, 25.06198> }
					triangle { <8.8565, 61.5413, 24.9243>, <8.6866, 61.8266, 24.7603>, <8.5538, 61.532, 25.00267> }
					triangle { <8.5538, 61.532, 25.00267>, <8.6563, 60.649, 24.6312>, <8.8565, 61.5413, 24.9243> }
					triangle { <9.4285, 62.00089, 24.5544>, <9.3393, 62.01069, 24.6356>, <9.005527, 61.768, 24.8639> }
					triangle { <9.3393, 62.01069, 24.6356>, <9.169, 62.1714, 24.1579>, <8.7629, 62.03765, 24.6382> }
					triangle { <9.005527, 61.768, 24.8639>, <8.7629, 62.03765, 24.6382>, <8.6866, 61.8266, 24.7603> }
					triangle { <9.005527, 61.768, 24.8639>, <9.3393, 62.01069, 24.6356>, <8.7629, 62.03765, 24.6382> }
					triangle { <9.1145, 61.4614, 25.06198>, <9.4285, 62.00089, 24.5544>, <9.005527, 61.768, 24.8639> }
					triangle { <8.8565, 61.5413, 24.9243>, <9.005527, 61.768, 24.8639>, <8.6866, 61.8266, 24.7603> }
					triangle { <9.1145, 61.4614, 25.06198>, <9.005527, 61.768, 24.8639>, <8.8565, 61.5413, 24.9243> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <8.8311, 59.567, 23.912>, <8.8198, 61.5098, 25.01513>, <8.5878, 61.383, 25.1635> }
					triangle { <8.8311, 59.567, 23.912>, <8.9833, 60.6523, 24.4711>, <8.8198, 61.5098, 25.01513> }
					triangle { <8.5878, 61.383, 25.1635>, <8.7678, 60.5006, 24.8301>, <8.8311, 59.567, 23.912> }
					triangle { <8.9833, 60.6523, 24.4711>, <8.6993, 61.6932, 24.7681>, <8.8198, 61.5098, 25.01513> }
					triangle { <8.6993, 61.6932, 24.7681>, <8.233, 61.9586, 24.6966>, <8.8198, 61.5098, 25.01513> }
					triangle { <8.5878, 61.383, 25.1635>, <8.2538, 61.4567, 25.3056>, <8.5591, 61.2239, 25.4313> }
					triangle { <8.5591, 61.2239, 25.4313>, <8.7678, 60.5006, 24.8301>, <8.5878, 61.383, 25.1635> }
					triangle { <8.233, 61.9586, 24.6966>, <8.2635, 61.9379, 24.8119>, <8.4668, 61.6251, 25.1004> }
					triangle { <8.2635, 61.9379, 24.8119>, <7.7487, 61.8263, 24.7376>, <8.06987, 61.6273, 25.2579> }
					triangle { <8.4668, 61.6251, 25.1004>, <8.06987, 61.6273, 25.2579>, <8.2538, 61.4567, 25.3056> }
					triangle { <8.4668, 61.6251, 25.1004>, <8.2635, 61.9379, 24.8119>, <8.06987, 61.6273, 25.2579> }
					triangle { <8.8198, 61.5098, 25.01513>, <8.233, 61.9586, 24.6966>, <8.4668, 61.6251, 25.1004> }
					triangle { <8.5878, 61.383, 25.1635>, <8.4668, 61.6251, 25.1004>, <8.2538, 61.4567, 25.3056> }
					triangle { <8.8198, 61.5098, 25.01513>, <8.4668, 61.6251, 25.1004>, <8.5878, 61.383, 25.1635> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <8.8311, 59.567, 23.912>, <8.6651, 61.36, 25.2345>, <8.7829, 61.1732, 25.4421> }
					triangle { <8.8311, 59.567, 23.912>, <8.7392, 60.6438, 24.4999>, <8.6651, 61.36, 25.2345> }
					triangle { <8.7829, 61.1732, 25.4421>, <9.04242, 60.5101, 24.7977>, <8.8311, 59.567, 23.912> }
					triangle { <8.7392, 60.6438, 24.4999>, <8.3359, 61.3556, 25.2635>, <8.6651, 61.36, 25.2345> }
					triangle { <8.3359, 61.3556, 25.2635>, <8.001596, 61.2645, 25.6793>, <8.6651, 61.36, 25.2345> }
					triangle { <8.7829, 61.1732, 25.4421>, <8.759, 61.0771, 25.799>, <9.07212, 61.1154, 25.5467> }
					triangle { <9.07212, 61.1154, 25.5467>, <9.04242, 60.5101, 24.7977>, <8.7829, 61.1732, 25.4421> }
					triangle { <8.001596, 61.2645, 25.6793>, <8.113, 61.3008, 25.7096>, <8.5683, 61.2676, 25.5912> }
					triangle { <8.113, 61.3008, 25.7096>, <7.9636, 60.895, 26.01946>, <8.5764, 61.0853, 25.9774> }
					triangle { <8.5683, 61.2676, 25.5912>, <8.5764, 61.0853, 25.9774>, <8.759, 61.0771, 25.799> }
					triangle { <8.5683, 61.2676, 25.5912>, <8.113, 61.3008, 25.7096>, <8.5764, 61.0853, 25.9774> }
					triangle { <8.6651, 61.36, 25.2345>, <8.001596, 61.2645, 25.6793>, <8.5683, 61.2676, 25.5912> }
					triangle { <8.7829, 61.1732, 25.4421>, <8.5683, 61.2676, 25.5912>, <8.759, 61.0771, 25.799> }
					triangle { <8.6651, 61.36, 25.2345>, <8.5683, 61.2676, 25.5912>, <8.7829, 61.1732, 25.4421> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <5.1039, 53.5054, 18.9584>, <5.1284, 53.8407, 19.1615>, 0.2183 }
			cylinder { <5.1284, 53.8407, 19.1615>, <5.1325, 54.1925, 19.3363>, 0.2183 }
			cylinder { <5.1325, 54.1925, 19.3363>, <5.1163, 54.5574, 19.4811>, 0.2183 }
			texture{chif1}}
		union { // inflor. internode
			cylinder { <5.1163, 54.5574, 19.4811>, <5.03804, 54.931, 19.5738>, 0.2183 }
			cylinder { <5.03804, 54.931, 19.5738>, <4.953, 55.2924, 19.7025>, 0.2183 }
			cylinder { <4.953, 55.2924, 19.7025>, <4.8622, 55.6379, 19.8659>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.8622, 55.6379, 19.8659>, <4.7168, 56.1196, 20.1725>, 0.2183 }
				cylinder { <4.7168, 56.1196, 20.1725>, <4.5645, 56.5576, 20.5363>, 0.2183 }
				cylinder { <4.5645, 56.5576, 20.5363>, <4.4075, 56.945, 20.9516>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <4.4075, 56.945, 20.9516>, <4.05868, 58.4074, 22.6041>, <4.04592, 58.6071, 22.3764> }
					triangle { <4.4075, 56.945, 20.9516>, <4.1649, 57.6196, 21.9513>, <4.05868, 58.4074, 22.6041> }
					triangle { <4.04592, 58.6071, 22.3764>, <3.9733, 57.9316, 21.6977>, <4.4075, 56.945, 20.9516> }
					triangle { <4.1649, 57.6196, 21.9513>, <4.3666, 58.4037, 22.724>, <4.05868, 58.4074, 22.6041> }
					triangle { <4.3666, 58.4037, 22.724>, <4.7602, 58.7746, 22.7464>, <4.05868, 58.4074, 22.6041> }
					triangle { <4.04592, 58.6071, 22.3764>, <4.1485, 58.9493, 22.2789>, <3.8146, 58.7334, 22.2077> }
					triangle { <3.8146, 58.7334, 22.2077>, <3.9733, 57.9316, 21.6977>, <4.04592, 58.6071, 22.3764> }
					triangle { <4.7602, 58.7746, 22.7464>, <4.648, 58.8189, 22.736>, <4.2268, 58.7428, 22.5379> }
					triangle { <4.648, 58.8189, 22.736>, <4.9754, 59.0733, 22.4027>, <4.3358, 59.1091, 22.3471> }
					triangle { <4.2268, 58.7428, 22.5379>, <4.3358, 59.1091, 22.3471>, <4.1485, 58.9493, 22.2789> }
					triangle { <4.2268, 58.7428, 22.5379>, <4.648, 58.8189, 22.736>, <4.3358, 59.1091, 22.3471> }
					triangle { <4.05868, 58.4074, 22.6041>, <4.7602, 58.7746, 22.7464>, <4.2268, 58.7428, 22.5379> }
					triangle { <4.04592, 58.6071, 22.3764>, <4.2268, 58.7428, 22.5379>, <4.1485, 58.9493, 22.2789> }
					triangle { <4.05868, 58.4074, 22.6041>, <4.2268, 58.7428, 22.5379>, <4.04592, 58.6071, 22.3764> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.4075, 56.945, 20.9516>, <3.9455, 58.5898, 22.3912>, <3.6705, 58.5746, 22.2648> }
					triangle { <4.4075, 56.945, 20.9516>, <4.2824, 57.7945, 21.8326>, <3.9455, 58.5898, 22.3912> }
					triangle { <3.6705, 58.5746, 22.2648>, <3.841, 57.7349, 21.8312>, <4.4075, 56.945, 20.9516> }
					triangle { <4.2824, 57.7945, 21.8326>, <4.1194, 58.825, 22.2375>, <3.9455, 58.5898, 22.3912> }
					triangle { <4.1194, 58.825, 22.2375>, <3.9804, 59.2803, 21.9798>, <3.9455, 58.5898, 22.3912> }
					triangle { <3.6705, 58.5746, 22.2648>, <3.3892, 58.7842, 22.146>, <3.4034, 58.4285, 22.3368> }
					triangle { <3.4034, 58.4285, 22.3368>, <3.841, 57.7349, 21.8312>, <3.6705, 58.5746, 22.2648> }
					triangle { <3.9804, 59.2803, 21.9798>, <3.8996, 59.2397, 22.0604>, <3.7089, 58.849, 22.243> }
					triangle { <3.8996, 59.2397, 22.0604>, <3.6523, 59.3844, 21.6122>, <3.3647, 59.02353, 22.05997> }
					triangle { <3.7089, 58.849, 22.243>, <3.3647, 59.02353, 22.05997>, <3.3892, 58.7842, 22.146> }
					triangle { <3.7089, 58.849, 22.243>, <3.8996, 59.2397, 22.0604>, <3.3647, 59.02353, 22.05997> }
					triangle { <3.9455, 58.5898, 22.3912>, <3.9804, 59.2803, 21.9798>, <3.7089, 58.849, 22.243> }
					triangle { <3.6705, 58.5746, 22.2648>, <3.7089, 58.849, 22.243>, <3.3892, 58.7842, 22.146> }
					triangle { <3.9455, 58.5898, 22.3912>, <3.7089, 58.849, 22.243>, <3.6705, 58.5746, 22.2648> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.4075, 56.945, 20.9516>, <3.6551, 58.5175, 22.3489>, <3.5047, 58.285, 22.4723> }
					triangle { <4.4075, 56.945, 20.9516>, <4.1282, 57.898, 21.6778>, <3.6551, 58.5175, 22.3489> }
					triangle { <3.5047, 58.285, 22.4723>, <4.01458, 57.6185, 22.00548>, <4.4075, 56.945, 20.9516> }
					triangle { <4.1282, 57.898, 21.6778>, <3.4562, 58.6687, 22.1326>, <3.6551, 58.5175, 22.3489> }
					triangle { <3.4562, 58.6687, 22.1326>, <2.9188, 58.7232, 22.09837>, <3.6551, 58.5175, 22.3489> }
					triangle { <3.5047, 58.285, 22.4723>, <3.1784, 58.1907, 22.6201>, <3.5589, 58.09031, 22.7111> }
					triangle { <3.5589, 58.09031, 22.7111>, <4.01458, 57.6185, 22.00548>, <3.5047, 58.285, 22.4723> }
					triangle { <2.9188, 58.7232, 22.09837>, <2.9614, 58.7001, 22.2092>, <3.2912, 58.4612, 22.447> }
					triangle { <2.9614, 58.7001, 22.2092>, <2.5355, 58.3967, 22.1116>, <2.9381, 58.2742, 22.5978> }
					triangle { <3.2912, 58.4612, 22.447>, <2.9381, 58.2742, 22.5978>, <3.1784, 58.1907, 22.6201> }
					triangle { <3.2912, 58.4612, 22.447>, <2.9614, 58.7001, 22.2092>, <2.9381, 58.2742, 22.5978> }
					triangle { <3.6551, 58.5175, 22.3489>, <2.9188, 58.7232, 22.09837>, <3.2912, 58.4612, 22.447> }
					triangle { <3.5047, 58.285, 22.4723>, <3.2912, 58.4612, 22.447>, <3.1784, 58.1907, 22.6201> }
					triangle { <3.6551, 58.5175, 22.3489>, <3.2912, 58.4612, 22.447>, <3.5047, 58.285, 22.4723> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.4075, 56.945, 20.9516>, <3.5859, 58.2897, 22.5353>, <3.7761, 58.1357, 22.7142> }
					triangle { <4.4075, 56.945, 20.9516>, <3.9138, 57.7881, 21.6993>, <3.5859, 58.2897, 22.5353> }
					triangle { <3.7761, 58.1357, 22.7142>, <4.2557, 57.7421, 21.9812>, <4.4075, 56.945, 20.9516> }
					triangle { <3.9138, 57.7881, 21.6993>, <3.2873, 58.1494, 22.5533>, <3.5859, 58.2897, 22.5353> }
					triangle { <3.2873, 58.1494, 22.5533>, <3.0326, 57.868, 22.9392>, <3.5859, 58.2897, 22.5353> }
					triangle { <3.7761, 58.1357, 22.7142>, <3.8056, 57.9834, 23.05057>, <4.06784, 58.183, 22.817> }
					triangle { <4.06784, 58.183, 22.817>, <4.2557, 57.7421, 21.9812>, <3.7761, 58.1357, 22.7142> }
					triangle { <3.0326, 57.868, 22.9392>, <3.1212, 57.9406, 22.9782>, <3.5471, 58.1116, 22.8699> }
					triangle { <3.1212, 57.9406, 22.9782>, <3.1579, 57.4659, 23.2154>, <3.6415, 57.8897, 23.2224> }
					triangle { <3.5471, 58.1116, 22.8699>, <3.6415, 57.8897, 23.2224>, <3.8056, 57.9834, 23.05057> }
					triangle { <3.5471, 58.1116, 22.8699>, <3.1212, 57.9406, 22.9782>, <3.6415, 57.8897, 23.2224> }
					triangle { <3.5859, 58.2897, 22.5353>, <3.0326, 57.868, 22.9392>, <3.5471, 58.1116, 22.8699> }
					triangle { <3.7761, 58.1357, 22.7142>, <3.5471, 58.1116, 22.8699>, <3.8056, 57.9834, 23.05057> }
					triangle { <3.5859, 58.2897, 22.5353>, <3.5471, 58.1116, 22.8699>, <3.7761, 58.1357, 22.7142> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <4.4075, 56.945, 20.9516>, <3.8391, 58.2206, 22.6954>, <4.1156, 58.3378, 22.654> }
					triangle { <4.4075, 56.945, 20.9516>, <3.9369, 57.6134, 21.8709>, <3.8391, 58.2206, 22.6954> }
					triangle { <4.1156, 58.3378, 22.654>, <4.2298, 57.9386, 21.7881>, <4.4075, 56.945, 20.9516> }
					triangle { <3.9369, 57.6134, 21.8709>, <3.8584, 57.9831, 22.9243>, <3.8391, 58.2206, 22.6954> }
					triangle { <3.8584, 57.9831, 22.9243>, <4.1878, 57.9003, 23.3458>, <3.8391, 58.2206, 22.6954> }
					triangle { <4.1156, 58.3378, 22.654>, <4.4141, 58.4594, 22.8365>, <4.2282, 58.5864, 22.5012> }
					triangle { <4.2282, 58.5864, 22.5012>, <4.2298, 57.9386, 21.7881>, <4.1156, 58.3378, 22.654> }
					triangle { <4.1878, 57.9003, 23.3458>, <4.1793, 58.01518, 23.3087>, <4.1341, 58.2883, 22.9269> }
					triangle { <4.1793, 58.01518, 23.3087>, <4.6886, 57.8903, 23.398>, <4.5183, 58.4135, 23.0652> }
					triangle { <4.1341, 58.2883, 22.9269>, <4.5183, 58.4135, 23.0652>, <4.4141, 58.4594, 22.8365> }
					triangle { <4.1341, 58.2883, 22.9269>, <4.1793, 58.01518, 23.3087>, <4.5183, 58.4135, 23.0652> }
					triangle { <3.8391, 58.2206, 22.6954>, <4.1878, 57.9003, 23.3458>, <4.1341, 58.2883, 22.9269> }
					triangle { <4.1156, 58.3378, 22.654>, <4.1341, 58.2883, 22.9269>, <4.4141, 58.4594, 22.8365> }
					triangle { <3.8391, 58.2206, 22.6954>, <4.1341, 58.2883, 22.9269>, <4.1156, 58.3378, 22.654> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		union { // inflor. internode
			cylinder { <5.1163, 54.5574, 19.4811>, <5.1628, 54.8978, 19.6716>, 0.2183 }
			cylinder { <5.1628, 54.8978, 19.6716>, <5.2159, 55.2543, 19.8278>, 0.2183 }
			cylinder { <5.2159, 55.2543, 19.8278>, <5.2749, 55.6236, 19.9481>, 0.2183 }
			texture{chif1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <5.2749, 55.6236, 19.9481>, <5.3735, 56.194, 20.05893>, 0.2183 }
				cylinder { <5.3735, 56.194, 20.05893>, <5.4807, 56.7721, 20.09836>, 0.2183 }
				cylinder { <5.4807, 56.7721, 20.09836>, <5.5948, 57.3493, 20.06586>, 0.2183 }
				texture{chif1}}
			union { // flower
				mesh { // flower petal
					triangle { <5.5948, 57.3493, 20.06586>, <5.78, 59.5674, 19.8737>, <5.7843, 59.5573, 20.1766> }
					triangle { <5.5948, 57.3493, 20.06586>, <5.7544, 58.5413, 19.8067>, <5.78, 59.5674, 19.8737> }
					triangle { <5.7843, 59.5573, 20.1766>, <5.9291, 58.6085, 20.2109>, <5.5948, 57.3493, 20.06586> }
					triangle { <5.7544, 58.5413, 19.8067>, <5.4697, 59.6231, 19.7745>, <5.78, 59.5674, 19.8737> }
					triangle { <5.4697, 59.6231, 19.7745>, <5.04839, 59.8772, 20.00007>, <5.78, 59.5674, 19.8737> }
					triangle { <5.7843, 59.5573, 20.1766>, <5.6588, 59.7308, 20.4788>, <6.01024, 59.5511, 20.393> }
					triangle { <6.01024, 59.5511, 20.393>, <5.9291, 58.6085, 20.2109>, <5.7843, 59.5573, 20.1766> }
					triangle { <5.04839, 59.8772, 20.00007>, <5.1571, 59.9107, 20.0414>, <5.5886, 59.7523, 20.1464> }
					triangle { <5.1571, 59.9107, 20.0414>, <4.8214, 59.8419, 20.4483>, <5.4578, 59.8789, 20.5327> }
					triangle { <5.5886, 59.7523, 20.1464>, <5.4578, 59.8789, 20.5327>, <5.6588, 59.7308, 20.4788> }
					triangle { <5.5886, 59.7523, 20.1464>, <5.1571, 59.9107, 20.0414>, <5.4578, 59.8789, 20.5327> }
					triangle { <5.78, 59.5674, 19.8737>, <5.04839, 59.8772, 20.00007>, <5.5886, 59.7523, 20.1464> }
					triangle { <5.7843, 59.5573, 20.1766>, <5.5886, 59.7523, 20.1464>, <5.6588, 59.7308, 20.4788> }
					triangle { <5.78, 59.5674, 19.8737>, <5.5886, 59.7523, 20.1464>, <5.7843, 59.5573, 20.1766> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.5948, 57.3493, 20.06586>, <5.8852, 59.5626, 20.1571>, <6.1643, 59.4861, 20.2472> }
					triangle { <5.5948, 57.3493, 20.06586>, <5.6274, 58.5778, 20.00934>, <5.8852, 59.5626, 20.1571> }
					triangle { <6.1643, 59.4861, 20.2472>, <6.07201, 58.5675, 19.983>, <5.5948, 57.3493, 20.06586> }
					triangle { <5.6274, 58.5778, 20.00934>, <5.6985, 59.6145, 20.4247>, <5.8852, 59.5626, 20.1571> }
					triangle { <5.6985, 59.6145, 20.4247>, <5.81, 59.7789, 20.9283>, <5.8852, 59.5626, 20.1571> }
					triangle { <6.1643, 59.4861, 20.2472>, <6.4322, 59.5783, 20.4857>, <6.4395, 59.4499, 20.1028> }
					triangle { <6.4395, 59.4499, 20.1028>, <6.07201, 58.5675, 19.983>, <6.1643, 59.4861, 20.2472> }
					triangle { <5.81, 59.7789, 20.9283>, <5.8912, 59.8108, 20.8443>, <6.1056, 59.6672, 20.4497> }
					triangle { <5.8912, 59.8108, 20.8443>, <6.1402, 59.6279, 21.2774>, <6.4409, 59.6948, 20.7129> }
					triangle { <6.1056, 59.6672, 20.4497>, <6.4409, 59.6948, 20.7129>, <6.4322, 59.5783, 20.4857> }
					triangle { <6.1056, 59.6672, 20.4497>, <5.8912, 59.8108, 20.8443>, <6.4409, 59.6948, 20.7129> }
					triangle { <5.8852, 59.5626, 20.1571>, <5.81, 59.7789, 20.9283>, <6.1056, 59.6672, 20.4497> }
					triangle { <6.1643, 59.4861, 20.2472>, <6.1056, 59.6672, 20.4497>, <6.4322, 59.5783, 20.4857> }
					triangle { <5.8852, 59.5626, 20.1571>, <6.1056, 59.6672, 20.4497>, <6.1643, 59.4861, 20.2472> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.5948, 57.3493, 20.06586>, <6.1815, 59.5034, 20.1472>, <6.3454, 59.4309, 19.9028> }
					triangle { <5.5948, 57.3493, 20.06586>, <5.7779, 58.5587, 20.1976>, <6.1815, 59.5034, 20.1472> }
					triangle { <6.3454, 59.4309, 19.9028>, <5.9027, 58.589, 19.7711>, <5.5948, 57.3493, 20.06586> }
					triangle { <5.7779, 58.5587, 20.1976>, <6.3746, 59.4803, 20.4143>, <6.1815, 59.5034, 20.1472> }
					triangle { <6.3746, 59.4803, 20.4143>, <6.9071, 59.5375, 20.4929>, <6.1815, 59.5034, 20.1472> }
					triangle { <6.3454, 59.4309, 19.9028>, <6.6733, 59.4887, 19.7405>, <6.2991, 59.449, 19.5939> }
					triangle { <6.2991, 59.449, 19.5939>, <5.9027, 58.589, 19.7711>, <6.3454, 59.4309, 19.9028> }
					triangle { <6.9071, 59.5375, 20.4929>, <6.863, 59.5934, 20.3951>, <6.5454, 59.5576, 20.04835> }
					triangle { <6.863, 59.5934, 20.3951>, <7.3137, 59.3393, 20.2715>, <6.9071, 59.5524, 19.8212> }
					triangle { <6.5454, 59.5576, 20.04835>, <6.9071, 59.5524, 19.8212>, <6.6733, 59.4887, 19.7405> }
					triangle { <6.5454, 59.5576, 20.04835>, <6.863, 59.5934, 20.3951>, <6.9071, 59.5524, 19.8212> }
					triangle { <6.1815, 59.5034, 20.1472>, <6.9071, 59.5375, 20.4929>, <6.5454, 59.5576, 20.04835> }
					triangle { <6.3454, 59.4309, 19.9028>, <6.5454, 59.5576, 20.04835>, <6.6733, 59.4887, 19.7405> }
					triangle { <6.1815, 59.5034, 20.1472>, <6.5454, 59.5576, 20.04835>, <6.3454, 59.4309, 19.9028> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.5948, 57.3493, 20.06586>, <6.2622, 59.4712, 19.8576>, <6.07907, 59.4674, 19.6161> }
					triangle { <5.5948, 57.3493, 20.06586>, <5.9993, 58.5101, 20.1132>, <6.2622, 59.4712, 19.8576> }
					triangle { <6.07907, 59.4674, 19.6161>, <5.6536, 58.6436, 19.8661>, <5.5948, 57.3493, 20.06586> }
					triangle { <5.9993, 58.5101, 20.1132>, <6.57, 59.4047, 19.7575>, <6.2622, 59.4712, 19.8576> }
					triangle { <6.57, 59.4047, 19.7575>, <6.8337, 59.4844, 19.2916>, <6.2622, 59.4712, 19.8576> }
					triangle { <6.07907, 59.4674, 19.6161>, <6.05117, 59.585, 19.266>, <5.7816, 59.5497, 19.5647> }
					triangle { <5.7816, 59.5497, 19.5647>, <5.6536, 58.6436, 19.8661>, <6.07907, 59.4674, 19.6161> }
					triangle { <6.8337, 59.4844, 19.2916>, <6.7386, 59.5569, 19.3102>, <6.3043, 59.574, 19.4932> }
					triangle { <6.7386, 59.5569, 19.3102>, <6.7312, 59.3723, 18.8114>, <6.2166, 59.6472, 19.08171> }
					triangle { <6.3043, 59.574, 19.4932>, <6.2166, 59.6472, 19.08171>, <6.05117, 59.585, 19.266> }
					triangle { <6.3043, 59.574, 19.4932>, <6.7386, 59.5569, 19.3102>, <6.2166, 59.6472, 19.08171> }
					triangle { <6.2622, 59.4712, 19.8576>, <6.8337, 59.4844, 19.2916>, <6.3043, 59.574, 19.4932> }
					triangle { <6.07907, 59.4674, 19.6161>, <6.3043, 59.574, 19.4932>, <6.05117, 59.585, 19.266> }
					triangle { <6.2622, 59.4712, 19.8576>, <6.3043, 59.574, 19.4932>, <6.07907, 59.4674, 19.6161> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				mesh { // flower petal
					triangle { <5.5948, 57.3493, 20.06586>, <6.01032, 59.5113, 19.686>, <5.727, 59.5467, 19.7879> }
					triangle { <5.5948, 57.3493, 20.06586>, <5.9846, 58.4992, 19.868>, <6.01032, 59.5113, 19.686> }
					triangle { <5.727, 59.5467, 19.7879>, <5.6702, 58.6558, 20.142>, <5.5948, 57.3493, 20.06586> }
					triangle { <5.9846, 58.4992, 19.868>, <6.002356, 59.4943, 19.3561>, <6.01032, 59.5113, 19.686> }
					triangle { <6.002356, 59.4943, 19.3561>, <5.6676, 59.6975, 18.9824>, <6.01032, 59.5113, 19.686> }
					triangle { <5.727, 59.5467, 19.7879>, <5.4147, 59.7368, 19.7292>, <5.6004, 59.6137, 20.0661> }
					triangle { <5.6004, 59.6137, 20.0661>, <5.6702, 58.6558, 20.142>, <5.727, 59.5467, 19.7879> }
					triangle { <5.6676, 59.6975, 18.9824>, <5.6684, 59.756, 19.08838>, <5.7041, 59.6962, 19.5547> }
					triangle { <5.6684, 59.756, 19.08838>, <5.1676, 59.6876, 18.9223>, <5.3073, 59.8521, 19.528> }
					triangle { <5.7041, 59.6962, 19.5547>, <5.3073, 59.8521, 19.528>, <5.4147, 59.7368, 19.7292> }
					triangle { <5.7041, 59.6962, 19.5547>, <5.6684, 59.756, 19.08838>, <5.3073, 59.8521, 19.528> }
					triangle { <6.01032, 59.5113, 19.686>, <5.6676, 59.6975, 18.9824>, <5.7041, 59.6962, 19.5547> }
					triangle { <5.727, 59.5467, 19.7879>, <5.7041, 59.6962, 19.5547>, <5.4147, 59.7368, 19.7292> }
					triangle { <6.01032, 59.5113, 19.686>, <5.7041, 59.6962, 19.5547>, <5.727, 59.5467, 19.7879> }
					pigment { color rgb <0.62, 0.25, 0.21> }}
				}
			}
		}
	union { // internode
		cylinder { <-0.2912, 32.6358, 3.6277>, <0.007612, 35.8506, 4.6082>, 0.5 }
		cylinder { <0.007612, 35.8506, 4.6082>, <0.4261, 39.1292, 5.2866>, 0.5 }
		cylinder { <0.4261, 39.1292, 5.2866>, <0.9603, 42.4403, 5.6565>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.9603, 42.4403, 5.6565>, <1.3763, 43.9215, 5.3212>, 0.4999 }
			cylinder { <1.3763, 43.9215, 5.3212>, <1.9104, 45.1656, 4.5172>, 0.4999 }
			cylinder { <1.9104, 45.1656, 4.5172>, <2.5002, 46.02707, 3.3384>, 0.4999 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.5002, 46.02707, 3.3384>, <2.748, 46.3888, 2.8434>, 0.4999 }
				cylinder { <2.748, 46.3888, 2.8434>, <2.9957, 46.7507, 2.3483>, 0.4999 }
				cylinder { <2.9957, 46.7507, 2.3483>, <3.2434, 47.1125, 1.8532>, 0.4999 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <3.2434, 47.1125, 1.8532>, <3.32, 47.1727, 1.7734>, 0.03999 }
				cylinder { <3.32, 47.1727, 1.7734>, <3.4205, 47.2197, 1.7137>, 0.03999 }
				cylinder { <3.4205, 47.2197, 1.7137>, <3.5375, 47.2503, 1.6786>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <3.5375, 47.2503, 1.6786>, <8.8866, 48.3477, -0.2579>, <9.1148, 48.1157, 0.1069> }
				triangle { <8.8866, 48.3477, -0.2579>, <10.2119, 46.7274, -1.5097>, <9.1148, 48.1157, 0.1069> }
				triangle { <8.8866, 48.3477, -0.2579>, <9.8148, 47.2333, -1.6187>, <10.2119, 46.7274, -1.5097> }
				triangle { <10.2119, 46.7274, -1.5097>, <10.1629, 46.8774, -0.7685>, <9.1148, 48.1157, 0.1069> }
				triangle { <9.1148, 48.1157, 0.1069>, <7.002635, 47.4088, 0.7787>, <3.5375, 47.2503, 1.6786> }
				triangle { <3.5375, 47.2503, 1.6786>, <6.6914, 47.755, 0.04308>, <8.8866, 48.3477, -0.2579> }
				triangle { <6.6914, 47.755, 0.04308>, <8.64, 48.02969, -0.9689>, <8.8866, 48.3477, -0.2579> }
				triangle { <8.64, 48.02969, -0.9689>, <9.8148, 47.2333, -1.6187>, <8.8866, 48.3477, -0.2579> }
				triangle { <9.1148, 48.1157, 0.1069>, <10.1629, 46.8774, -0.7685>, <9.3074, 47.3163, 0.05338> }
				triangle { <9.3074, 47.3163, 0.05338>, <7.002635, 47.4088, 0.7787>, <9.1148, 48.1157, 0.1069> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <3.2434, 47.1125, 1.8532>, <3.2906, 47.1814, 1.7589>, 0.03999 }
				cylinder { <3.2906, 47.1814, 1.7589>, <3.3378, 47.2503, 1.6646>, 0.03999 }
				cylinder { <3.3378, 47.2503, 1.6646>, <3.385, 47.3192, 1.5703>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <3.385, 47.3192, 1.5703>, <5.4759, 50.1432, -3.03619>, <5.9456, 50.09213, -2.9106> }
				triangle { <5.4759, 50.1432, -3.03619>, <6.3524, 49.01181, -5.01112>, <5.9456, 50.09213, -2.9106> }
				triangle { <5.4759, 50.1432, -3.03619>, <5.7983, 49.2843, -4.8006>, <6.3524, 49.01181, -5.01112> }
				triangle { <6.3524, 49.01181, -5.01112>, <6.6871, 49.2559, -4.3767>, <5.9456, 50.09213, -2.9106> }
				triangle { <5.9456, 50.09213, -2.9106>, <5.1827, 48.7155, -1.1973>, <3.385, 47.3192, 1.5703> }
				triangle { <3.385, 47.3192, 1.5703>, <4.3904, 48.7703, -1.5537>, <5.4759, 50.1432, -3.03619> }
				triangle { <4.3904, 48.7703, -1.5537>, <5.02662, 49.6332, -3.4894>, <5.4759, 50.1432, -3.03619> }
				triangle { <5.02662, 49.6332, -3.4894>, <5.7983, 49.2843, -4.8006>, <5.4759, 50.1432, -3.03619> }
				triangle { <5.9456, 50.09213, -2.9106>, <6.6871, 49.2559, -4.3767>, <6.3891, 49.4446, -3.1619> }
				triangle { <6.3891, 49.4446, -3.1619>, <5.1827, 48.7155, -1.1973>, <5.9456, 50.09213, -2.9106> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <0.9603, 42.4403, 5.6565>, <1.5668, 45.7431, 5.9869>, 0.5 }
		cylinder { <1.5668, 45.7431, 5.9869>, <2.2452, 49.03563, 6.2776>, 0.5 }
		cylinder { <2.2452, 49.03563, 6.2776>, <2.9952, 52.3158, 6.5285>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.9952, 52.3158, 6.5285>, <2.8681, 53.8384, 6.8936>, 0.4988 }
			cylinder { <2.8681, 53.8384, 6.8936>, <2.2796, 55.1784, 7.4644>, 0.4988 }
			cylinder { <2.2796, 55.1784, 7.4644>, <1.2986, 56.1792, 8.1741>, 0.4988 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <1.2986, 56.1792, 8.1741>, <0.8865, 56.5996, 8.4722>, 0.4988 }
				cylinder { <0.8865, 56.5996, 8.4722>, <0.4744, 57.01995, 8.7703>, 0.4988 }
				cylinder { <0.4744, 57.01995, 8.7703>, <0.06243, 57.4402, 9.06839>, 0.4988 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <0.06243, 57.4402, 9.06839>, <-0.02743, 57.5229, 9.09674>, 0.03981 }
				cylinder { <-0.02743, 57.5229, 9.09674>, <-0.1234, 57.6035, 9.0951>, 0.03981 }
				cylinder { <-0.1234, 57.6035, 9.0951>, <-0.2199, 57.6771, 9.06357>, 0.03981 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-0.2199, 57.6771, 9.06357>, <-4.9355, 60.774, 7.8054>, <-4.9453, 60.6508, 7.3336> }
				triangle { <-4.9355, 60.774, 7.8054>, <-7.1606, 59.8037, 7.6375>, <-4.9453, 60.6508, 7.3336> }
				triangle { <-4.9355, 60.774, 7.8054>, <-6.787, 60.1125, 8.07183>, <-7.1606, 59.8037, 7.6375> }
				triangle { <-7.1606, 59.8037, 7.6375>, <-6.621, 59.9231, 7.1217>, <-4.9453, 60.6508, 7.3336> }
				triangle { <-4.9453, 60.6508, 7.3336>, <-3.2244, 59.1767, 7.8365>, <-0.2199, 57.6771, 9.06357> }
				triangle { <-0.2199, 57.6771, 9.06357>, <-3.3492, 59.3718, 8.6736>, <-4.9355, 60.774, 7.8054> }
				triangle { <-3.3492, 59.3718, 8.6736>, <-5.2949, 60.3847, 8.4248>, <-4.9355, 60.774, 7.8054> }
				triangle { <-5.2949, 60.3847, 8.4248>, <-6.787, 60.1125, 8.07183>, <-4.9355, 60.774, 7.8054> }
				triangle { <-4.9453, 60.6508, 7.3336>, <-6.621, 59.9231, 7.1217>, <-5.3619, 59.9923, 7.07151> }
				triangle { <-5.3619, 59.9923, 7.07151>, <-3.2244, 59.1767, 7.8365>, <-4.9453, 60.6508, 7.3336> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <0.06243, 57.4402, 9.06839>, <-0.01586, 57.5201, 9.125>, 0.03981 }
				cylinder { <-0.01586, 57.5201, 9.125>, <-0.09416, 57.6, 9.1816>, 0.03981 }
				cylinder { <-0.09416, 57.6, 9.1816>, <-0.1724, 57.6799, 9.2383>, 0.03981 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-0.1724, 57.6799, 9.2383>, <-3.9888, 61.00942, 12.02398>, <-4.2513, 61.1177, 11.6274> }
				triangle { <-3.9888, 61.00942, 12.02398>, <-6.1881, 60.2266, 12.7103>, <-4.2513, 61.1177, 11.6274> }
				triangle { <-3.9888, 61.00942, 12.02398>, <-5.5901, 60.3002, 12.9563>, <-6.1881, 60.2266, 12.7103> }
				triangle { <-6.1881, 60.2266, 12.7103>, <-5.9474, 60.5703, 12.08153>, <-4.2513, 61.1177, 11.6274> }
				triangle { <-4.2513, 61.1177, 11.6274>, <-2.9228, 59.5773, 10.5097>, <-0.1724, 57.6799, 9.2383> }
				triangle { <-0.1724, 57.6799, 9.2383>, <-2.5829, 59.3643, 11.28>, <-3.9888, 61.00942, 12.02398> }
				triangle { <-2.5829, 59.3643, 11.28>, <-4.09468, 60.3784, 12.5289>, <-3.9888, 61.00942, 12.02398> }
				triangle { <-4.09468, 60.3784, 12.5289>, <-5.5901, 60.3002, 12.9563>, <-3.9888, 61.00942, 12.02398> }
				triangle { <-4.2513, 61.1177, 11.6274>, <-5.9474, 60.5703, 12.08153>, <-4.8903, 60.6545, 11.3972> }
				triangle { <-4.8903, 60.6545, 11.3972>, <-2.9228, 59.5773, 10.5097>, <-4.2513, 61.1177, 11.6274> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <2.9952, 52.3158, 6.5285>, <3.06811, 53.7518, 6.772>, 0.216 }
		cylinder { <3.06811, 53.7518, 6.772>, <2.8868, 55.1509, 7.1412>, 0.216 }
		cylinder { <2.8868, 55.1509, 7.1412>, <2.4585, 56.4594, 7.622>, 0.216 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.4585, 56.4594, 7.622>, <2.3824, 56.561, 7.6818>, 0.04454 }
			cylinder { <2.3824, 56.561, 7.6818>, <2.2792, 56.6281, 7.749>, 0.04454 }
			cylinder { <2.2792, 56.6281, 7.749>, <2.1591, 56.6539, 7.8168>, 0.04454 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.1591, 56.6539, 7.8168>, <2.1087, 56.6647, 7.8454>, 0.04454 }
				cylinder { <2.1087, 56.6647, 7.8454>, <2.05834, 56.6755, 7.8739>, 0.04454 }
				cylinder { <2.05834, 56.6755, 7.8739>, <2.007929, 56.6864, 7.9024>, 0.04454 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <2.9952, 52.3158, 6.5285>, <4.1299, 55.4749, 6.872>, 0.5 }
		cylinder { <4.1299, 55.4749, 6.872>, <5.6322, 58.4653, 7.3031>, 0.5 }
		cylinder { <5.6322, 58.4653, 7.3031>, <7.4795, 61.2421, 7.8152>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <7.4795, 61.2421, 7.8152>, <8.6202, 62.1343, 8.1151>, 0.4696 }
			cylinder { <8.6202, 62.1343, 8.1151>, <9.9769, 62.6117, 8.46>, 0.4696 }
			cylinder { <9.9769, 62.6117, 8.46>, <11.4125, 62.6259, 8.8152>, 0.4696 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <11.4125, 62.6259, 8.8152>, <12.01552, 62.6319, 8.9644>, 0.4696 }
				cylinder { <12.01552, 62.6319, 8.9644>, <12.6184, 62.6379, 9.1136>, 0.4696 }
				cylinder { <12.6184, 62.6379, 9.1136>, <13.2214, 62.6439, 9.2628>, 0.4696 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <13.2214, 62.6439, 9.2628>, <13.3182, 62.6444, 9.3173>, 0.03528 }
				cylinder { <13.3182, 62.6444, 9.3173>, <13.3971, 62.6442, 9.3956>, 0.03528 }
				cylinder { <13.3971, 62.6442, 9.3956>, <13.4521, 62.6433, 9.4921>, 0.03528 }
				texture{chif1}}
			mesh { // leaf
				triangle { <13.4521, 62.6433, 9.4921>, <16.2259, 62.1972, 14.1527>, <15.8546, 62.1988, 14.4229> }
				triangle { <16.2259, 62.1972, 14.1527>, <16.5, 60.2127, 15.2639>, <15.8546, 62.1988, 14.4229> }
				triangle { <16.2259, 62.1972, 14.1527>, <16.7984, 60.5673, 14.8631>, <16.5, 60.2127, 15.2639> }
				triangle { <16.5, 60.2127, 15.2639>, <16.00682, 60.7232, 15.316>, <15.8546, 62.1988, 14.4229> }
				triangle { <15.8546, 62.1988, 14.4229>, <14.6853, 62.1139, 12.5789>, <13.4521, 62.6433, 9.4921> }
				triangle { <13.4521, 62.6433, 9.4921>, <15.3893, 62.0091, 12.1764>, <16.2259, 62.1972, 14.1527> }
				triangle { <15.3893, 62.0091, 12.1764>, <16.5676, 61.5876, 13.8358>, <16.2259, 62.1972, 14.1527> }
				triangle { <16.5676, 61.5876, 13.8358>, <16.7984, 60.5673, 14.8631>, <16.2259, 62.1972, 14.1527> }
				triangle { <15.8546, 62.1988, 14.4229>, <16.00682, 60.7232, 15.316>, <15.4975, 61.5413, 14.6211> }
				triangle { <15.4975, 61.5413, 14.6211>, <14.6853, 62.1139, 12.5789>, <15.8546, 62.1988, 14.4229> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <13.2214, 62.6439, 9.2628>, <13.3293, 62.645, 9.2895>, 0.03528 }
				cylinder { <13.3293, 62.645, 9.2895>, <13.4371, 62.646, 9.3162>, 0.03528 }
				cylinder { <13.4371, 62.646, 9.3162>, <13.545, 62.6471, 9.3428>, 0.03528 }
				texture{chif1}}
			mesh { // leaf
				triangle { <13.545, 62.6471, 9.3428>, <18.8393, 62.2932, 10.5505>, <18.7789, 62.2961, 11.00574> }
				triangle { <18.8393, 62.2932, 10.5505>, <19.8651, 60.3281, 11.1283>, <18.7789, 62.2961, 11.00574> }
				triangle { <18.8393, 62.2932, 10.5505>, <19.775, 60.6787, 10.634>, <19.8651, 60.3281, 11.1283> }
				triangle { <19.8651, 60.3281, 11.1283>, <19.5545, 60.8355, 11.5189>, <18.7789, 62.2961, 11.00574> }
				triangle { <18.7789, 62.2961, 11.00574>, <16.6389, 62.1742, 10.5812>, <13.545, 62.6471, 9.3428> }
				triangle { <13.545, 62.6471, 9.3428>, <16.8346, 62.06862, 9.7944>, <18.8393, 62.2932, 10.5505> }
				triangle { <16.8346, 62.06862, 9.7944>, <18.8554, 61.6814, 10.08767>, <18.8393, 62.2932, 10.5505> }
				triangle { <18.8554, 61.6814, 10.08767>, <19.775, 60.6787, 10.634>, <18.8393, 62.2932, 10.5505> }
				triangle { <18.7789, 62.2961, 11.00574>, <19.5545, 60.8355, 11.5189>, <18.6868, 61.639, 11.4043> }
				triangle { <18.6868, 61.639, 11.4043>, <16.6389, 62.1742, 10.5812>, <18.7789, 62.2961, 11.00574> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <7.4795, 61.2421, 7.8152>, <8.8224, 64.3222, 7.5314>, 0.4996 }
		cylinder { <8.8224, 64.3222, 7.5314>, <9.5465, 67.4421, 6.4764>, 0.4996 }
		cylinder { <9.5465, 67.4421, 6.4764>, <9.5894, 70.3332, 4.7411>, 0.4996 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <9.5894, 70.3332, 4.7411>, <9.3049, 71.2073, 3.8576>, 0.4048 }
			cylinder { <9.3049, 71.2073, 3.8576>, <8.7531, 71.7603, 2.85>, 0.4048 }
			cylinder { <8.7531, 71.7603, 2.85>, <7.9983, 71.9274, 1.8362>, 0.4048 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <7.9983, 71.9274, 1.8362>, <7.6813, 71.9976, 1.4103>, 0.4048 }
				cylinder { <7.6813, 71.9976, 1.4103>, <7.3643, 72.0679, 0.9845>, 0.4048 }
				cylinder { <7.3643, 72.0679, 0.9845>, <7.04732, 72.1381, 0.5587>, 0.4048 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <7.04732, 72.1381, 0.5587>, <7.01598, 72.1404, 0.4823>, 0.02622 }
				cylinder { <7.01598, 72.1404, 0.4823>, <7.004456, 72.1341, 0.4008>, 0.02622 }
				cylinder { <7.004456, 72.1341, 0.4008>, <7.01358, 72.1196, 0.32>, 0.02622 }
				texture{chif1}}
			mesh { // leaf
				triangle { <7.01358, 72.1196, 0.32>, <7.3276, 71.00297, -4.2254>, <7.6988, 70.8673, -4.2039> }
				triangle { <7.3276, 71.00297, -4.2254>, <7.08674, 69.1648, -4.9062>, <7.6988, 70.8673, -4.2039> }
				triangle { <7.3276, 71.00297, -4.2254>, <6.8071, 69.6078, -4.8384>, <7.08674, 69.1648, -4.9062> }
				triangle { <7.08674, 69.1648, -4.9062>, <7.5854, 69.4737, -4.7265>, <7.6988, 70.8673, -4.2039> }
				triangle { <7.6988, 70.8673, -4.2039>, <7.5422, 71.08727, -2.3396>, <7.01358, 72.1196, 0.32> }
				triangle { <7.01358, 72.1196, 0.32>, <6.8605, 71.2335, -2.4428>, <7.3276, 71.00297, -4.2254> }
				triangle { <6.8605, 71.2335, -2.4428>, <6.7695, 70.6588, -4.1374>, <7.3276, 71.00297, -4.2254> }
				triangle { <6.7695, 70.6588, -4.1374>, <6.8071, 69.6078, -4.8384>, <7.3276, 71.00297, -4.2254> }
				triangle { <7.6988, 70.8673, -4.2039>, <7.5854, 69.4737, -4.7265>, <7.8274, 70.2255, -4.07433> }
				triangle { <7.8274, 70.2255, -4.07433>, <7.5422, 71.08727, -2.3396>, <7.6988, 70.8673, -4.2039> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <7.04732, 72.1381, 0.5587>, <6.9984, 72.1489, 0.493>, 0.02622 }
				cylinder { <6.9984, 72.1489, 0.493>, <6.9495, 72.1597, 0.4274>, 0.02622 }
				cylinder { <6.9495, 72.1597, 0.4274>, <6.9006, 72.1705, 0.3617>, 0.02622 }
				texture{chif1}}
			mesh { // leaf
				triangle { <6.9006, 72.1705, 0.3617>, <3.9452, 72.4888, -3.2675>, <4.2046, 72.3591, -3.5369> }
				triangle { <3.9452, 72.4888, -3.2675>, <2.966, 70.9397, -4.00337>, <4.2046, 72.3591, -3.5369> }
				triangle { <3.9452, 72.4888, -3.2675>, <2.892, 71.3367, -3.6629>, <2.966, 70.9397, -4.00337> }
				triangle { <2.966, 70.9397, -4.00337>, <3.5086, 71.1877, -4.1465>, <4.2046, 72.3591, -3.5369> }
				triangle { <4.2046, 72.3591, -3.5369>, <5.3499, 72.00133, -2.08489>, <6.9006, 72.1705, 0.3617> }
				triangle { <6.9006, 72.1705, 0.3617>, <4.8121, 72.1608, -1.6581>, <3.9452, 72.4888, -3.2675> }
				triangle { <4.8121, 72.1608, -1.6581>, <3.5271, 72.1251, -2.9062>, <3.9452, 72.4888, -3.2675> }
				triangle { <3.5271, 72.1251, -2.9062>, <2.892, 71.3367, -3.6629>, <3.9452, 72.4888, -3.2675> }
				triangle { <4.2046, 72.3591, -3.5369>, <3.5086, 71.1877, -4.1465>, <4.2581, 71.7104, -3.6837> }
				triangle { <4.2581, 71.7104, -3.6837>, <5.3499, 72.00133, -2.08489>, <4.2046, 72.3591, -3.5369> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <9.5894, 70.3332, 4.7411>, <9.6292, 72.3168, 3.9743>, 0.3151 }
		cylinder { <9.6292, 72.3168, 3.9743>, <9.6805, 74.4021, 3.5578>, 0.3151 }
		cylinder { <9.6805, 74.4021, 3.5578>, <9.7419, 76.5276, 3.504>, 0.3151 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <9.7419, 76.5276, 3.504>, <9.7472, 76.6705, 3.5512>, 0.04782 }
			cylinder { <9.7472, 76.6705, 3.5512>, <9.753, 76.7892, 3.6437>, 0.04782 }
			cylinder { <9.753, 76.7892, 3.6437>, <9.7585, 76.8697, 3.7708>, 0.04782 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <9.7585, 76.8697, 3.7708>, <9.7608, 76.9036, 3.8242>, 0.04782 }
				cylinder { <9.7608, 76.9036, 3.8242>, <9.7631, 76.9374, 3.8776>, 0.04782 }
				cylinder { <9.7631, 76.9374, 3.8776>, <9.7654, 76.9712, 3.931>, 0.04782 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-0.6477, 23.1109, 0.2436>, <-0.522, 26.4407, 0.7745>, 0.5 }
		cylinder { <-0.522, 26.4407, 0.7745>, <-0.2751, 29.7984, 0.9985>, 0.5 }
		cylinder { <-0.2751, 29.7984, 0.9985>, <0.09058, 33.1516, 0.9135>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.09058, 33.1516, 0.9135>, <0.439, 34.592, 0.3811>, 0.4999 }
			cylinder { <0.439, 34.592, 0.3811>, <0.9244, 35.7394, -0.5817>, 0.4999 }
			cylinder { <0.9244, 35.7394, -0.5817>, <1.4902, 36.4598, -1.8625>, 0.4999 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <1.4902, 36.4598, -1.8625>, <1.7278, 36.7624, -2.4004>, 0.4999 }
				cylinder { <1.7278, 36.7624, -2.4004>, <1.9654, 37.06501, -2.9383>, 0.4999 }
				cylinder { <1.9654, 37.06501, -2.9383>, <2.203, 37.3675, -3.4762>, 0.4999 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <2.203, 37.3675, -3.4762>, <2.2779, 37.42, -3.563>, 0.03999 }
				cylinder { <2.2779, 37.42, -3.563>, <2.3768, 37.4634, -3.6276>, 0.03999 }
				cylinder { <2.3768, 37.4634, -3.6276>, <2.4928, 37.4948, -3.6656>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <2.4928, 37.4948, -3.6656>, <7.8078, 38.5919, -5.6939>, <8.04239, 38.4135, -5.3038> }
				triangle { <7.8078, 38.5919, -5.6939>, <9.2118, 36.8972, -6.7454>, <8.04239, 38.4135, -5.3038> }
				triangle { <7.8078, 38.5919, -5.6939>, <8.7945, 37.3696, -6.9136>, <9.2118, 36.8972, -6.7454> }
				triangle { <9.2118, 36.8972, -6.7454>, <9.1497, 37.1291, -6.02676>, <8.04239, 38.4135, -5.3038> }
				triangle { <8.04239, 38.4135, -5.3038>, <5.956, 37.698, -4.5637>, <2.4928, 37.4948, -3.6656> }
				triangle { <2.4928, 37.4948, -3.6656>, <5.6371, 37.9437, -5.3355>, <7.8078, 38.5919, -5.6939> }
				triangle { <5.6371, 37.9437, -5.3355>, <7.5813, 38.184, -6.3645>, <7.8078, 38.5919, -5.6939> }
				triangle { <7.5813, 38.184, -6.3645>, <8.7945, 37.3696, -6.9136>, <7.8078, 38.5919, -5.6939> }
				triangle { <8.04239, 38.4135, -5.3038>, <9.1497, 37.1291, -6.02676>, <8.2691, 37.6222, -5.2642> }
				triangle { <8.2691, 37.6222, -5.2642>, <5.956, 37.698, -4.5637>, <8.04239, 38.4135, -5.3038> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <2.203, 37.3675, -3.4762>, <2.2483, 37.4252, -3.5787>, 0.03999 }
				cylinder { <2.2483, 37.4252, -3.5787>, <2.2935, 37.4828, -3.6812>, 0.03999 }
				cylinder { <2.2935, 37.4828, -3.6812>, <2.3388, 37.5404, -3.7836>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <2.3388, 37.5404, -3.7836>, <4.3524, 39.8112, -8.7189>, <4.8232, 39.7911, -8.5886> }
				triangle { <4.3524, 39.8112, -8.7189>, <5.2674, 38.4626, -10.5334>, <4.8232, 39.7911, -8.5886> }
				triangle { <4.3524, 39.8112, -8.7189>, <4.7048, 38.7429, -10.3588>, <5.2674, 38.4626, -10.5334> }
				triangle { <5.2674, 38.4626, -10.5334>, <5.5932, 38.7965, -9.9363>, <4.8232, 39.7911, -8.5886> }
				triangle { <4.8232, 39.7911, -8.5886>, <4.09906, 38.6236, -6.7111>, <2.3388, 37.5404, -3.7836> }
				triangle { <2.3388, 37.5404, -3.7836>, <3.3062, 38.6078, -7.07028>, <4.3524, 39.8112, -8.7189> }
				triangle { <3.3062, 38.6078, -7.07028>, <3.9199, 39.2337, -9.102>, <4.3524, 39.8112, -8.7189> }
				triangle { <3.9199, 39.2337, -9.102>, <4.7048, 38.7429, -10.3588>, <4.3524, 39.8112, -8.7189> }
				triangle { <4.8232, 39.7911, -8.5886>, <5.5932, 38.7965, -9.9363>, <5.2868, 39.1306, -8.7553> }
				triangle { <5.2868, 39.1306, -8.7553>, <4.09906, 38.6236, -6.7111>, <4.8232, 39.7911, -8.5886> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <0.09058, 33.1516, 0.9135>, <0.6822, 36.3995, 0.2158>, 0.5 }
		cylinder { <0.6822, 36.3995, 0.2158>, <1.4771, 39.4171, -1.06771>, 0.5 }
		cylinder { <1.4771, 39.4171, -1.06771>, <2.4446, 42.08854, -2.8878>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.4446, 42.08854, -2.8878>, <2.9759, 42.914, -4.05226>, 0.4836 }
			cylinder { <2.9759, 42.914, -4.05226>, <3.5396, 43.2626, -5.4235>, 0.4836 }
			cylinder { <3.5396, 43.2626, -5.4235>, <4.06997, 43.09364, -6.8412>, 0.4836 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <4.06997, 43.09364, -6.8412>, <4.2926, 43.02267, -7.4366>, 0.4836 }
				cylinder { <4.2926, 43.02267, -7.4366>, <4.5154, 42.9517, -8.03207>, 0.4836 }
				cylinder { <4.5154, 42.9517, -8.03207>, <4.7381, 42.8807, -8.6275>, 0.4836 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <4.7381, 42.8807, -8.6275>, <4.8068, 42.8652, -8.7219>, 0.03742 }
				cylinder { <4.8068, 42.8652, -8.7219>, <4.8983, 42.8484, -8.7943>, 0.03742 }
				cylinder { <4.8983, 42.8484, -8.7943>, <5.005941, 42.8315, -8.8393>, 0.03742 }
				texture{chif1}}
			mesh { // leaf
				triangle { <5.005941, 42.8315, -8.8393>, <10.01723, 41.6135, -11.03198>, <10.2488, 41.6253, -10.6198> }
				triangle { <10.01723, 41.6135, -11.03198>, <10.9522, 39.4479, -10.9925>, <10.2488, 41.6253, -10.6198> }
				triangle { <10.01723, 41.6135, -11.03198>, <10.62, 39.82, -11.3789>, <10.9522, 39.4479, -10.9925> }
				triangle { <10.9522, 39.4479, -10.9925>, <11.00609, 40.01355, -10.5295>, <10.2488, 41.6253, -10.6198> }
				triangle { <10.2488, 41.6253, -10.6198>, <8.2277, 41.848, -9.6558>, <5.005941, 42.8315, -8.8393> }
				triangle { <5.005941, 42.8315, -8.8393>, <7.8886, 41.7105, -10.4141>, <10.01723, 41.6135, -11.03198> }
				triangle { <7.8886, 41.7105, -10.4141>, <9.6652, 40.9895, -11.3654>, <10.01723, 41.6135, -11.03198> }
				triangle { <9.6652, 40.9895, -11.3654>, <10.62, 39.82, -11.3789>, <10.01723, 41.6135, -11.03198> }
				triangle { <10.2488, 41.6253, -10.6198>, <11.00609, 40.01355, -10.5295>, <10.3335, 40.9712, -10.1723> }
				triangle { <10.3335, 40.9712, -10.1723>, <8.2277, 41.848, -9.6558>, <10.2488, 41.6253, -10.6198> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <4.7381, 42.8807, -8.6275>, <4.7791, 42.8676, -8.7372>, 0.03742 }
				cylinder { <4.7791, 42.8676, -8.7372>, <4.8201, 42.8545, -8.8469>, 0.03742 }
				cylinder { <4.8201, 42.8545, -8.8469>, <4.8612, 42.8415, -8.9566>, 0.03742 }
				texture{chif1}}
			mesh { // leaf
				triangle { <4.8612, 42.8415, -8.9566>, <6.6663, 41.8144, -14.1614>, <7.1224, 41.7767, -14.04249> }
				triangle { <6.6663, 41.8144, -14.1614>, <7.1489, 39.6465, -14.9567>, <7.1224, 41.7767, -14.04249> }
				triangle { <6.6663, 41.8144, -14.1614>, <6.6759, 40.06403, -14.959>, <7.1489, 39.6465, -14.9567> }
				triangle { <7.1489, 39.6465, -14.9567>, <7.5678, 40.1555, -14.6363>, <7.1224, 41.7767, -14.04249> }
				triangle { <7.1224, 41.7767, -14.04249>, <6.4272, 41.9152, -11.9068>, <4.8612, 42.8415, -8.9566> }
				triangle { <4.8612, 42.8415, -8.9566>, <5.638, 41.8684, -12.1964>, <6.6663, 41.8144, -14.1614> }
				triangle { <5.638, 41.8684, -12.1964>, <6.1276, 41.2366, -14.1819>, <6.6663, 41.8144, -14.1614> }
				triangle { <6.1276, 41.2366, -14.1819>, <6.6759, 40.06403, -14.959>, <6.6663, 41.8144, -14.1614> }
				triangle { <7.1224, 41.7767, -14.04249>, <7.5678, 40.1555, -14.6363>, <7.4419, 41.07531, -13.8393> }
				triangle { <7.4419, 41.07531, -13.8393>, <6.4272, 41.9152, -11.9068>, <7.1224, 41.7767, -14.04249> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <2.4446, 42.08854, -2.8878>, <3.4778, 44.7167, -4.734>, 0.4999 }
		cylinder { <3.4778, 44.7167, -4.734>, <4.5761, 47.3004, -6.6054>, 0.4999 }
		cylinder { <4.5761, 47.3004, -6.6054>, <5.7389, 49.838, -8.5008>, 0.4999 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <5.7389, 49.838, -8.5008>, <5.852, 51.03353, -9.09683>, 0.4256 }
			cylinder { <5.852, 51.03353, -9.09683>, <5.605, 52.2955, -9.4755>, 0.4256 }
			cylinder { <5.605, 52.2955, -9.4755>, <5.02266, 53.4968, -9.5987>, 0.4256 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <5.02266, 53.4968, -9.5987>, <4.778, 54.00133, -9.6504>, 0.4256 }
				cylinder { <4.778, 54.00133, -9.6504>, <4.5334, 54.5058, -9.7021>, 0.4256 }
				cylinder { <4.5334, 54.5058, -9.7021>, <4.2888, 55.01036, -9.7539>, 0.4256 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <4.2888, 55.01036, -9.7539>, <4.2377, 55.081, -9.7809>, 0.02899 }
				cylinder { <4.2377, 55.081, -9.7809>, <4.1787, 55.1353, -9.8246>, 0.02899 }
				cylinder { <4.1787, 55.1353, -9.8246>, <4.1162, 55.1694, -9.8818>, 0.02899 }
				texture{chif1}}
			mesh { // leaf
				triangle { <4.1162, 55.1694, -9.8818>, <0.4864, 56.9731, -12.693>, <0.441, 56.6287, -12.9222> }
				triangle { <0.4864, 56.9731, -12.693>, <-1.5206, 56.5535, -12.3652>, <0.441, 56.6287, -12.9222> }
				triangle { <0.4864, 56.9731, -12.693>, <-1.1465, 56.9462, -12.2461>, <-1.5206, 56.5535, -12.3652> }
				triangle { <-1.5206, 56.5535, -12.3652>, <-1.074, 56.2658, -12.7312>, <0.441, 56.6287, -12.9222> }
				triangle { <0.441, 56.6287, -12.9222>, <1.7232, 55.7814, -11.6727>, <4.1162, 55.1694, -9.8818> }
				triangle { <4.1162, 55.1694, -9.8818>, <1.6811, 56.3957, -11.2602>, <0.4864, 56.9731, -12.693> }
				triangle { <1.6811, 56.3957, -11.2602>, <0.1614, 57.1292, -12.09815>, <0.4864, 56.9731, -12.693> }
				triangle { <0.1614, 57.1292, -12.09815>, <-1.1465, 56.9462, -12.2461>, <0.4864, 56.9731, -12.693> }
				triangle { <0.441, 56.6287, -12.9222>, <-1.074, 56.2658, -12.7312>, <-0.006707, 56.1218, -12.7355> }
				triangle { <-0.006707, 56.1218, -12.7355>, <1.7232, 55.7814, -11.6727>, <0.441, 56.6287, -12.9222> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <4.2888, 55.01036, -9.7539>, <4.2492, 55.09217, -9.7623>, 0.02899 }
				cylinder { <4.2492, 55.09217, -9.7623>, <4.2095, 55.1739, -9.7707>, 0.02899 }
				cylinder { <4.2095, 55.1739, -9.7707>, <4.1698, 55.2558, -9.7791>, 0.02899 }
				texture{chif1}}
			mesh { // leaf
				triangle { <4.1698, 55.2558, -9.7791>, <1.8083, 59.5837, -9.9364>, <1.5761, 59.4883, -10.2683> }
				triangle { <1.8083, 59.5837, -9.9364>, <-0.0994, 59.8662, -9.1666>, <1.5761, 59.4883, -10.2683> }
				triangle { <1.8083, 59.5837, -9.9364>, <0.4309, 59.9336, -9.01604>, <-0.0994, 59.8662, -9.1666> }
				triangle { <-0.0994, 59.8662, -9.1666>, <0.1084, 59.7015, -9.7547>, <1.5761, 59.4883, -10.2683> }
				triangle { <1.5761, 59.4883, -10.2683>, <2.3195, 57.6597, -10.1041>, <4.1698, 55.2558, -9.7791> }
				triangle { <4.1698, 55.2558, -9.7791>, <2.6288, 57.8751, -9.466>, <1.8083, 59.5837, -9.9364> }
				triangle { <2.6288, 57.8751, -9.466>, <1.6522, 59.474, -9.2675>, <1.8083, 59.5837, -9.9364> }
				triangle { <1.6522, 59.474, -9.2675>, <0.4309, 59.9336, -9.01604>, <1.8083, 59.5837, -9.9364> }
				triangle { <1.5761, 59.4883, -10.2683>, <0.1084, 59.7015, -9.7547>, <0.9451, 59.1895, -10.1993> }
				triangle { <0.9451, 59.1895, -10.1993>, <2.3195, 57.6597, -10.1041>, <1.5761, 59.4883, -10.2683> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <5.7389, 49.838, -8.5008>, <7.1824, 51.5132, -9.6407>, 0.3686 }
		cylinder { <7.1824, 51.5132, -9.6407>, <9.1076, 52.8712, -10.4403>, 0.3686 }
		cylinder { <9.1076, 52.8712, -10.4403>, <11.375, 53.8135, -10.8416>, 0.3686 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <11.375, 53.8135, -10.8416>, <11.5753, 53.8394, -10.83>, 0.06425 }
			cylinder { <11.5753, 53.8394, -10.83>, <11.7682, 53.8116, -10.7753>, 0.06425 }
			cylinder { <11.7682, 53.8116, -10.7753>, <11.931, 53.7334, -10.6841>, 0.06425 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <11.931, 53.7334, -10.6841>, <11.9994, 53.7005, -10.6458>, 0.06425 }
				cylinder { <11.9994, 53.7005, -10.6458>, <12.06781, 53.6676, -10.6075>, 0.06425 }
				cylinder { <12.06781, 53.6676, -10.6075>, <12.1362, 53.6348, -10.5692>, 0.06425 }
				texture{chif1}}
			mesh { // leaf
				triangle { <12.1362, 53.6348, -10.5692>, <12.7034, 53.301, -10.2211>, <12.7002, 53.3366, -10.1695> }
				triangle { <12.7034, 53.301, -10.2211>, <12.6642, 53.0812, -10.00116>, <12.7002, 53.3366, -10.1695> }
				triangle { <12.7034, 53.301, -10.2211>, <12.6787, 53.08707, -10.08353>, <12.6642, 53.0812, -10.00116> }
				triangle { <12.6642, 53.0812, -10.00116>, <12.6732, 53.178, -9.9956>, <12.7002, 53.3366, -10.1695> }
				triangle { <12.7002, 53.3366, -10.1695>, <12.4502, 53.4509, -10.287>, <12.1362, 53.6348, -10.5692> }
				triangle { <12.1362, 53.6348, -10.5692>, <12.4578, 53.3733, -10.3672>, <12.7034, 53.301, -10.2211> }
				triangle { <12.4578, 53.3733, -10.3672>, <12.653, 53.2107, -10.2393>, <12.7034, 53.301, -10.2211> }
				triangle { <12.653, 53.2107, -10.2393>, <12.6787, 53.08707, -10.08353>, <12.7034, 53.301, -10.2211> }
				triangle { <12.7002, 53.3366, -10.1695>, <12.6732, 53.178, -9.9956>, <12.6404, 53.3085, -10.08674> }
				triangle { <12.6404, 53.3085, -10.08674>, <12.4502, 53.4509, -10.287>, <12.7002, 53.3366, -10.1695> }
				texture{chif1}}
			mesh { // leaf
				triangle { <12.1362, 53.6348, -10.5692>, <12.7034, 53.301, -10.2211>, <12.7002, 53.3366, -10.1695> }
				triangle { <12.7034, 53.301, -10.2211>, <12.6642, 53.0812, -10.00116>, <12.7002, 53.3366, -10.1695> }
				triangle { <12.7034, 53.301, -10.2211>, <12.6787, 53.08707, -10.08353>, <12.6642, 53.0812, -10.00116> }
				triangle { <12.6642, 53.0812, -10.00116>, <12.6732, 53.178, -9.9956>, <12.7002, 53.3366, -10.1695> }
				triangle { <12.7002, 53.3366, -10.1695>, <12.4502, 53.4509, -10.287>, <12.1362, 53.6348, -10.5692> }
				triangle { <12.1362, 53.6348, -10.5692>, <12.4578, 53.3733, -10.3672>, <12.7034, 53.301, -10.2211> }
				triangle { <12.4578, 53.3733, -10.3672>, <12.653, 53.2107, -10.2393>, <12.7034, 53.301, -10.2211> }
				triangle { <12.653, 53.2107, -10.2393>, <12.6787, 53.08707, -10.08353>, <12.7034, 53.301, -10.2211> }
				triangle { <12.7002, 53.3366, -10.1695>, <12.6732, 53.178, -9.9956>, <12.6404, 53.3085, -10.08674> }
				triangle { <12.6404, 53.3085, -10.08674>, <12.4502, 53.4509, -10.287>, <12.7002, 53.3366, -10.1695> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <0.09058, 33.1516, 0.9135>, <0.4562, 36.5049, 0.8285>, 0.5 }
		cylinder { <0.4562, 36.5049, 0.8285>, <0.822, 39.8582, 0.7434>, 0.5 }
		cylinder { <0.822, 39.8582, 0.7434>, <1.1877, 43.2114, 0.6584>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.1877, 43.2114, 0.6584>, <0.8783, 44.7421, 0.8601>, 0.4999 }
			cylinder { <0.8783, 44.7421, 0.8601>, <0.1251, 46.05975, 1.2797>, 0.4999 }
			cylinder { <0.1251, 46.05975, 1.2797>, <-0.9839, 47.0102, 1.868>, 0.4999 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.9839, 47.0102, 1.868>, <-1.451, 47.3957, 2.1336>, 0.4999 }
				cylinder { <-1.451, 47.3957, 2.1336>, <-1.9188, 47.7673, 2.4172>, 0.4999 }
				cylinder { <-1.9188, 47.7673, 2.4172>, <-2.3869, 48.1242, 2.7187>, 0.4999 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-2.3869, 48.1242, 2.7187>, <-2.4887, 48.1923, 2.748>, 0.03999 }
				cylinder { <-2.4887, 48.1923, 2.748>, <-2.5972, 48.2564, 2.7474>, 0.03999 }
				cylinder { <-2.5972, 48.2564, 2.7474>, <-2.7057, 48.3127, 2.7171>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-2.7057, 48.3127, 2.7171>, <-7.9081, 50.575, 1.5406>, <-7.9164, 50.4281, 1.07443> }
				triangle { <-7.9081, 50.575, 1.5406>, <-9.9617, 49.2593, 1.5165>, <-7.9164, 50.4281, 1.07443> }
				triangle { <-7.9081, 50.575, 1.5406>, <-9.6244, 49.6447, 1.9205>, <-9.9617, 49.2593, 1.5165> }
				triangle { <-9.9617, 49.2593, 1.5165>, <-9.4667, 49.436, 0.9706>, <-7.9164, 50.4281, 1.07443> }
				triangle { <-7.9164, 50.4281, 1.07443>, <-5.9618, 49.2646, 1.5624>, <-2.7057, 48.3127, 2.7171> }
				triangle { <-2.7057, 48.3127, 2.7171>, <-6.08394, 49.4798, 2.397>, <-7.9081, 50.575, 1.5406> }
				triangle { <-6.08394, 49.4798, 2.397>, <-8.1781, 50.1648, 2.1935>, <-7.9081, 50.575, 1.5406> }
				triangle { <-8.1781, 50.1648, 2.1935>, <-9.6244, 49.6447, 1.9205>, <-7.9081, 50.575, 1.5406> }
				triangle { <-7.9164, 50.4281, 1.07443>, <-9.4667, 49.436, 0.9706>, <-8.2343, 49.6988, 0.8597> }
				triangle { <-8.2343, 49.6988, 0.8597>, <-5.9618, 49.2646, 1.5624>, <-7.9164, 50.4281, 1.07443> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-2.3869, 48.1242, 2.7187>, <-2.4744, 48.192, 2.7787>, 0.03999 }
				cylinder { <-2.4744, 48.192, 2.7787>, <-2.5604, 48.2595, 2.8414>, 0.03999 }
				cylinder { <-2.5604, 48.2595, 2.8414>, <-2.6446, 48.3267, 2.9067>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-2.6446, 48.3267, 2.9067>, <-6.6488, 51.03547, 6.1>, <-6.965, 51.09711, 5.7323> }
				triangle { <-6.6488, 51.03547, 6.1>, <-8.6178, 49.9152, 7.003627>, <-6.965, 51.09711, 5.7323> }
				triangle { <-6.6488, 51.03547, 6.1>, <-8.01595, 50.08588, 7.1882>, <-8.6178, 49.9152, 7.003627> }
				triangle { <-8.6178, 49.9152, 7.003627>, <-8.5003, 50.2881, 6.3545>, <-6.965, 51.09711, 5.7323> }
				triangle { <-6.965, 51.09711, 5.7323>, <-5.5252, 49.7755, 4.4703>, <-2.6446, 48.3267, 2.9067> }
				triangle { <-2.6446, 48.3267, 2.9067>, <-5.07786, 49.626, 5.2019>, <-6.6488, 51.03547, 6.1> }
				triangle { <-5.07786, 49.626, 5.2019>, <-6.6003, 50.3987, 6.6095>, <-6.6488, 51.03547, 6.1> }
				triangle { <-6.6003, 50.3987, 6.6095>, <-8.01595, 50.08588, 7.1882>, <-6.6488, 51.03547, 6.1> }
				triangle { <-6.965, 51.09711, 5.7323>, <-8.5003, 50.2881, 6.3545>, <-7.5434, 50.5344, 5.5647> }
				triangle { <-7.5434, 50.5344, 5.5647>, <-5.5252, 49.7755, 4.4703>, <-6.965, 51.09711, 5.7323> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <1.1877, 43.2114, 0.6584>, <1.9468, 46.499, 0.6836>, 0.5 }
		cylinder { <1.9468, 46.499, 0.6836>, <3.08802, 49.6715, 0.8186>, 0.5 }
		cylinder { <3.08802, 49.6715, 0.8186>, <4.594, 52.6812, 1.06142>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <4.594, 52.6812, 1.06142>, <5.7097, 53.7655, 1.3042>, 0.4999 }
			cylinder { <5.7097, 53.7655, 1.3042>, <7.108, 54.4027, 1.648>, 0.4999 }
			cylinder { <7.108, 54.4027, 1.648>, <8.6253, 54.5183, 2.05287>, 0.4999 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <8.6253, 54.5183, 2.05287>, <9.2626, 54.5669, 2.2228>, 0.4999 }
				cylinder { <9.2626, 54.5669, 2.2228>, <9.8999, 54.6155, 2.3928>, 0.4999 }
				cylinder { <9.8999, 54.6155, 2.3928>, <10.5371, 54.6641, 2.5628>, 0.4999 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <10.5371, 54.6641, 2.5628>, <10.6453, 54.6748, 2.6264>, 0.03999 }
				cylinder { <10.6453, 54.6748, 2.6264>, <10.7325, 54.6861, 2.7166>, 0.03999 }
				cylinder { <10.7325, 54.6861, 2.7166>, <10.7924, 54.6974, 2.8269>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <10.7924, 54.6974, 2.8269>, <13.6575, 54.7831, 7.8619>, <13.2566, 54.7797, 8.1416> }
				triangle { <13.6575, 54.7831, 7.8619>, <14.05812, 52.7865, 9.2043>, <13.2566, 54.7797, 8.1416> }
				triangle { <13.6575, 54.7831, 7.8619>, <14.3604, 53.1517, 8.7563>, <14.05812, 52.7865, 9.2043> }
				triangle { <14.05812, 52.7865, 9.2043>, <13.498, 53.2968, 9.2098>, <13.2566, 54.7797, 8.1416> }
				triangle { <13.2566, 54.7797, 8.1416>, <12.06465, 54.4638, 6.1689>, <10.7924, 54.6974, 2.8269> }
				triangle { <10.7924, 54.6974, 2.8269>, <12.8292, 54.3707, 5.7632>, <13.6575, 54.7831, 7.8619> }
				triangle { <12.8292, 54.3707, 5.7632>, <14.0699, 54.1364, 7.5804>, <13.6575, 54.7831, 7.8619> }
				triangle { <14.0699, 54.1364, 7.5804>, <14.3604, 53.1517, 8.7563>, <13.6575, 54.7831, 7.8619> }
				triangle { <13.2566, 54.7797, 8.1416>, <13.498, 53.2968, 9.2098>, <12.9175, 54.07362, 8.3975> }
				triangle { <12.9175, 54.07362, 8.3975>, <12.06465, 54.4638, 6.1689>, <13.2566, 54.7797, 8.1416> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <10.5371, 54.6641, 2.5628>, <10.6585, 54.6733, 2.5952>, 0.03999 }
				cylinder { <10.6585, 54.6733, 2.5952>, <10.7799, 54.6826, 2.6276>, 0.03999 }
				cylinder { <10.7799, 54.6826, 2.6276>, <10.9013, 54.6918, 2.66>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <10.9013, 54.6918, 2.66>, <16.5205, 54.6803, 4.07122>, <16.4457, 54.71, 4.5534> }
				triangle { <16.5205, 54.6803, 4.07122>, <17.7009, 52.6879, 4.8365>, <16.4457, 54.71, 4.5534> }
				triangle { <16.5205, 54.6803, 4.07122>, <17.598, 53.02271, 4.2861>, <17.7009, 52.6879, 4.8365> }
				triangle { <17.7009, 52.6879, 4.8365>, <17.335, 53.2354, 5.2114>, <16.4457, 54.71, 4.5534> }
				triangle { <16.4457, 54.71, 4.5534>, <14.1867, 54.4377, 4.06831>, <10.9013, 54.6918, 2.66> }
				triangle { <10.9013, 54.6918, 2.66>, <14.4185, 54.2844, 3.2433>, <16.5205, 54.6803, 4.07122> }
				triangle { <14.4185, 54.2844, 3.2433>, <16.5804, 54.00156, 3.6206>, <16.5205, 54.6803, 4.07122> }
				triangle { <16.5804, 54.00156, 3.6206>, <17.598, 53.02271, 4.2861>, <16.5205, 54.6803, 4.07122> }
				triangle { <16.4457, 54.71, 4.5534>, <17.335, 53.2354, 5.2114>, <16.373, 54.03398, 5.01895> }
				triangle { <16.373, 54.03398, 5.01895>, <14.1867, 54.4377, 4.06831>, <16.4457, 54.71, 4.5534> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <4.594, 52.6812, 1.06142>, <5.5384, 55.8535, 0.4056>, 0.5 }
		cylinder { <5.5384, 55.8535, 0.4056>, <5.8258, 58.8682, -1.08246>, 0.5 }
		cylinder { <5.8258, 58.8682, -1.08246>, <5.4273, 61.4209, -3.2527>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <5.4273, 61.4209, -3.2527>, <4.9184, 62.2464, -4.4933>, 0.4999 }
			cylinder { <4.9184, 62.2464, -4.4933>, <4.1463, 62.6097, -5.8166>, 0.4999 }
			cylinder { <4.1463, 62.6097, -5.8166>, <3.201, 62.4683, -7.06802>, 0.4999 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <3.201, 62.4683, -7.06802>, <2.804, 62.4089, -7.5935>, 0.4999 }
				cylinder { <2.804, 62.4089, -7.5935>, <2.407, 62.3495, -8.1191>, 0.4999 }
				cylinder { <2.407, 62.3495, -8.1191>, <2.01, 62.2901, -8.6447>, 0.4999 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <2.01, 62.2901, -8.6447>, <1.9601, 62.2687, -8.7584>, 0.03999 }
				cylinder { <1.9601, 62.2687, -8.7584>, <1.939, 62.2384, -8.8788>, 0.03999 }
				cylinder { <1.939, 62.2384, -8.8788>, <1.948, 62.2012, -8.9989>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <1.948, 62.2012, -8.9989>, <2.1485, 60.1161, -14.4007>, <2.622, 59.9957, -14.3847> }
				triangle { <2.1485, 60.1161, -14.4007>, <2.02839, 57.7357, -14.9183>, <2.622, 59.9957, -14.3847> }
				triangle { <2.1485, 60.1161, -14.4007>, <1.6362, 58.2558, -14.8822>, <2.02839, 57.7357, -14.9183> }
				triangle { <2.02839, 57.7357, -14.9183>, <2.6154, 58.1976, -14.791>, <2.622, 59.9957, -14.3847> }
				triangle { <2.622, 59.9957, -14.3847>, <2.5346, 60.5577, -12.1288>, <1.948, 62.2012, -8.9989> }
				triangle { <1.948, 62.2012, -8.9989>, <1.6731, 60.6429, -12.2196>, <2.1485, 60.1161, -14.4007> }
				triangle { <1.6731, 60.6429, -12.2196>, <1.5118, 59.6495, -14.1902>, <2.1485, 60.1161, -14.4007> }
				triangle { <1.5118, 59.6495, -14.1902>, <1.6362, 58.2558, -14.8822>, <2.1485, 60.1161, -14.4007> }
				triangle { <2.622, 59.9957, -14.3847>, <2.6154, 58.1976, -14.791>, <2.8669, 59.2495, -14.135> }
				triangle { <2.8669, 59.2495, -14.135>, <2.5346, 60.5577, -12.1288>, <2.622, 59.9957, -14.3847> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <2.01, 62.2901, -8.6447>, <1.9343, 62.2787, -8.7448>, 0.03999 }
				cylinder { <1.9343, 62.2787, -8.7448>, <1.8587, 62.2674, -8.8449>, 0.03999 }
				cylinder { <1.8587, 62.2674, -8.8449>, <1.7831, 62.2561, -8.945>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <1.7831, 62.2561, -8.945>, <-1.871, 61.376, -13.3541>, <-1.5329, 61.1945, -13.657> }
				triangle { <-1.871, 61.376, -13.3541>, <-2.8442, 59.1993, -13.8675>, <-1.5329, 61.1945, -13.657> }
				triangle { <-1.871, 61.376, -13.3541>, <-2.9941, 59.7458, -13.5443>, <-2.8442, 59.1993, -13.8675> }
				triangle { <-2.8442, 59.1993, -13.8675>, <-2.2139, 59.5426, -14.1106>, <-1.5329, 61.1945, -13.657> }
				triangle { <-1.5329, 61.1945, -13.657>, <-0.08297, 61.2637, -11.8389>, <1.7831, 62.2561, -8.945> }
				triangle { <1.7831, 62.2561, -8.945>, <-0.7677, 61.4776, -11.3458>, <-1.871, 61.376, -13.3541> }
				triangle { <-0.7677, 61.4776, -11.3458>, <-2.3328, 60.9617, -12.8226>, <-1.871, 61.376, -13.3541> }
				triangle { <-2.3328, 60.9617, -12.8226>, <-2.9941, 59.7458, -13.5443>, <-1.871, 61.376, -13.3541> }
				triangle { <-1.5329, 61.1945, -13.657>, <-2.2139, 59.5426, -14.1106>, <-1.3726, 60.3867, -13.6867> }
				triangle { <-1.3726, 60.3867, -13.6867>, <-0.08297, 61.2637, -11.8389>, <-1.5329, 61.1945, -13.657> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <5.4273, 61.4209, -3.2527>, <5.01121, 64.2197, -5.09084>, 0.5 }
		cylinder { <5.01121, 64.2197, -5.09084>, <4.5837, 67.2226, -6.5691>, 0.5 }
		cylinder { <4.5837, 67.2226, -6.5691>, <4.1514, 70.3844, -7.6652>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <4.1514, 70.3844, -7.6652>, <3.9593, 71.947, -7.6456>, 0.4999 }
			cylinder { <3.9593, 71.947, -7.6456>, <3.7994, 73.4141, -7.09714>, 0.4999 }
			cylinder { <3.7994, 73.4141, -7.09714>, <3.6903, 74.6143, -6.08394>, 0.4999 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <3.6903, 74.6143, -6.08394>, <3.6624, 75.1097, -5.6468>, 0.4999 }
				cylinder { <3.6624, 75.1097, -5.6468>, <3.6523, 75.5959, -5.1987>, 0.4999 }
				cylinder { <3.6523, 75.5959, -5.1987>, <3.6601, 76.07237, -4.7402>, 0.4999 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <3.6601, 76.07237, -4.7402>, <3.6312, 76.1583, -4.6528>, 0.03999 }
				cylinder { <3.6312, 76.1583, -4.6528>, <3.5735, 76.2343, -4.5706>, 0.03999 }
				cylinder { <3.5735, 76.2343, -4.5706>, <3.4905, 76.2959, -4.4986>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <3.4905, 76.2959, -4.4986>, <-0.1716, 78.8933, -0.8377>, <-0.5658, 78.6443, -0.9846> }
				triangle { <-0.1716, 78.8933, -0.8377>, <-0.8867, 77.8937, 1.2686>, <-0.5658, 78.6443, -0.9846> }
				triangle { <-0.1716, 78.8933, -0.8377>, <-0.4408, 78.3142, 1.04541>, <-0.8867, 77.8937, 1.2686> }
				triangle { <-0.8867, 77.8937, 1.2686>, <-1.1816, 77.8709, 0.571>, <-0.5658, 78.6443, -0.9846> }
				triangle { <-0.5658, 78.6443, -0.9846>, <0.8991, 77.3772, -2.2727>, <3.4905, 76.2959, -4.4986> }
				triangle { <3.4905, 76.2959, -4.4986>, <1.5524, 77.7951, -1.8775>, <-0.1716, 78.8933, -0.8377> }
				triangle { <1.5524, 77.7951, -1.8775>, <0.3523, 78.6863, -0.2462>, <-0.1716, 78.8933, -0.8377> }
				triangle { <0.3523, 78.6863, -0.2462>, <-0.4408, 78.3142, 1.04541>, <-0.1716, 78.8933, -0.8377> }
				triangle { <-0.5658, 78.6443, -0.9846>, <-1.1816, 77.8709, 0.571>, <-0.7825, 77.9341, -0.6274> }
				triangle { <-0.7825, 77.9341, -0.6274>, <0.8991, 77.3772, -2.2727>, <-0.5658, 78.6443, -0.9846> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <3.6601, 76.07237, -4.7402>, <3.6647, 76.1632, -4.6531>, 0.03999 }
				cylinder { <3.6647, 76.1632, -4.6531>, <3.6723, 76.2543, -4.5664>, 0.03999 }
				cylinder { <3.6723, 76.2543, -4.5664>, <3.683, 76.3454, -4.4802>, 0.03999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <3.683, 76.3454, -4.4802>, <4.348, 80.2314, -0.2355>, <3.8746, 80.2473, -0.1148> }
				triangle { <4.348, 80.2314, -0.2355>, <4.4619, 79.625, 2.1237>, <3.8746, 80.2473, -0.1148> }
				triangle { <4.348, 80.2314, -0.2355>, <4.862, 79.7523, 1.6246>, <4.4619, 79.625, 2.1237> }
				triangle { <4.4619, 79.625, 2.1237>, <3.8805, 79.8174, 1.6776>, <3.8746, 80.2473, -0.1148> }
				triangle { <3.8746, 80.2473, -0.1148>, <3.5882, 78.4886, -1.6102>, <3.683, 76.3454, -4.4802> }
				triangle { <3.683, 76.3454, -4.4802>, <4.455, 78.4555, -1.6828>, <4.348, 80.2314, -0.2355> }
				triangle { <4.455, 78.4555, -1.6828>, <4.9189, 79.7304, 0.06503>, <4.348, 80.2314, -0.2355> }
				triangle { <4.9189, 79.7304, 0.06503>, <4.862, 79.7523, 1.6246>, <4.348, 80.2314, -0.2355> }
				triangle { <3.8746, 80.2473, -0.1148>, <3.8805, 79.8174, 1.6776>, <3.5603, 79.7432, 0.4562> }
				triangle { <3.5603, 79.7432, 0.4562>, <3.5882, 78.4886, -1.6102>, <3.8746, 80.2473, -0.1148> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <4.1514, 70.3844, -7.6652>, <3.9709, 71.8305, -7.7186>, 0.216 }
		cylinder { <3.9709, 71.8305, -7.7186>, <3.8123, 73.2317, -7.3468>, 0.216 }
		cylinder { <3.8123, 73.2317, -7.3468>, <3.6893, 74.4673, -6.5821>, 0.216 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <3.6893, 74.4673, -6.5821>, <3.6827, 74.5548, -6.4726>, 0.04454 }
			cylinder { <3.6827, 74.5548, -6.4726>, <3.6821, 74.6007, -6.3401>, 0.04454 }
			cylinder { <3.6821, 74.6007, -6.3401>, <3.6876, 74.5996, -6.1999>, 0.04454 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <3.6876, 74.5996, -6.1999>, <3.69, 74.5992, -6.141>, 0.04454 }
				cylinder { <3.69, 74.5992, -6.141>, <3.6923, 74.5987, -6.0822>, 0.04454 }
				cylinder { <3.6923, 74.5987, -6.0822>, <3.6946, 74.5983, -6.02333>, 0.04454 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <4.1514, 70.3844, -7.6652>, <3.8863, 73.4978, -8.9386>, 0.5 }
		cylinder { <3.8863, 73.4978, -8.9386>, <3.7898, 76.5461, -10.3823>, 0.5 }
		cylinder { <3.7898, 76.5461, -10.3823>, <3.8625, 79.5126, -11.9884>, 0.5 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <3.8625, 79.5126, -11.9884>, <4.2428, 80.5878, -12.9979>, 0.4836 }
			cylinder { <4.2428, 80.5878, -12.9979>, <4.9259, 81.2735, -14.1738>, 0.4836 }
			cylinder { <4.9259, 81.2735, -14.1738>, <5.8321, 81.4896, -15.3786>, 0.4836 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <5.8321, 81.4896, -15.3786>, <6.2062, 81.5606, -15.8926>, 0.4836 }
				cylinder { <6.2062, 81.5606, -15.8926>, <6.5734, 81.6119, -16.4139>, 0.4836 }
				cylinder { <6.5734, 81.6119, -16.4139>, <6.9331, 81.6434, -16.9419>, 0.4836 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <6.9331, 81.6434, -16.9419>, <7.01964, 81.6581, -17.02068>, 0.03742 }
				cylinder { <7.01964, 81.6581, -17.02068>, <7.1211, 81.6809, -17.0761>, 0.03742 }
				cylinder { <7.1211, 81.6809, -17.0761>, <7.2315, 81.7104, -17.1049>, 0.03742 }
				texture{chif1}}
			mesh { // leaf
				triangle { <7.2315, 81.7104, -17.1049>, <12.5608, 82.6925, -18.5325>, <12.7085, 82.7789, -18.09174> }
				triangle { <12.5608, 82.6925, -18.5325>, <14.2722, 81.08279, -18.3203>, <12.7085, 82.7789, -18.09174> }
				triangle { <12.5608, 82.6925, -18.5325>, <13.8756, 81.3064, -18.757>, <14.2722, 81.08279, -18.3203> }
				triangle { <14.2722, 81.08279, -18.3203>, <14.02937, 81.6028, -17.8645>, <12.7085, 82.7789, -18.09174> }
				triangle { <12.7085, 82.7789, -18.09174>, <10.6561, 82.1338, -17.4322>, <7.2315, 81.7104, -17.1049> }
				triangle { <7.2315, 81.7104, -17.1049>, <10.5096, 81.9036, -18.2288>, <12.5608, 82.6925, -18.5325> }
				triangle { <10.5096, 81.9036, -18.2288>, <12.5393, 81.9943, -18.9019>, <12.5608, 82.6925, -18.5325> }
				triangle { <12.5393, 81.9943, -18.9019>, <13.8756, 81.3064, -18.757>, <12.5608, 82.6925, -18.5325> }
				triangle { <12.7085, 82.7789, -18.09174>, <14.02937, 81.6028, -17.8645>, <12.9861, 82.1954, -17.625> }
				triangle { <12.9861, 82.1954, -17.625>, <10.6561, 82.1338, -17.4322>, <12.7085, 82.7789, -18.09174> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <6.9331, 81.6434, -16.9419>, <6.9971, 81.6482, -17.0408>, 0.03742 }
				cylinder { <6.9971, 81.6482, -17.0408>, <7.05891, 81.6522, -17.1411>, 0.03742 }
				cylinder { <7.05891, 81.6522, -17.1411>, <7.1182, 81.6552, -17.2428>, 0.03742 }
				texture{chif1}}
			mesh { // leaf
				triangle { <7.1182, 81.6552, -17.2428>, <9.9514, 81.3682, -22.06936>, <10.3664, 81.4983, -21.8837> }
				triangle { <9.9514, 81.3682, -22.06936>, <11.297, 79.5257, -22.6693>, <10.3664, 81.4983, -21.8837> }
				triangle { <9.9514, 81.3682, -22.06936>, <10.7119, 79.7429, -22.7623>, <11.297, 79.5257, -22.6693> }
				triangle { <11.297, 79.5257, -22.6693>, <11.4502, 80.1512, -22.3193>, <10.3664, 81.4983, -21.8837> }
				triangle { <10.3664, 81.4983, -21.8837>, <9.3473, 81.369, -19.8816>, <7.1182, 81.6552, -17.2428> }
				triangle { <7.1182, 81.6552, -17.2428>, <8.6824, 81.03963, -20.2795>, <9.9514, 81.3682, -22.06936> }
				triangle { <8.6824, 81.03963, -20.2795>, <9.6663, 80.6342, -22.1365>, <9.9514, 81.3682, -22.06936> }
				triangle { <9.6663, 80.6342, -22.1365>, <10.7119, 79.7429, -22.7623>, <9.9514, 81.3682, -22.06936> }
				triangle { <10.3664, 81.4983, -21.8837>, <11.4502, 80.1512, -22.3193>, <10.881, 80.9602, -21.5993> }
				triangle { <10.881, 80.9602, -21.5993>, <9.3473, 81.369, -19.8816>, <10.3664, 81.4983, -21.8837> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <3.8625, 79.5126, -11.9884>, <4.1092, 80.9545, -13.02435>, 0.2656 }
		cylinder { <4.1092, 80.9545, -13.02435>, <4.5567, 82.22, -14.2123>, 0.2656 }
		cylinder { <4.5567, 82.22, -14.2123>, <5.1918, 83.2717, -15.5175>, 0.2656 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <5.1918, 83.2717, -15.5175>, <5.2659, 83.3177, -15.6305>, 0.0453 }
			cylinder { <5.2659, 83.3177, -15.6305>, <5.3559, 83.3214, -15.7411>, 0.0453 }
			cylinder { <5.3559, 83.3214, -15.7411>, <5.4528, 83.2823, -15.8382>, 0.0453 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <5.4528, 83.2823, -15.8382>, <5.4936, 83.2659, -15.8789>, 0.0453 }
				cylinder { <5.4936, 83.2659, -15.8789>, <5.5343, 83.2495, -15.9197>, 0.0453 }
				cylinder { <5.5343, 83.2495, -15.9197>, <5.575, 83.2331, -15.9605>, 0.0453 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <3.8625, 79.5126, -11.9884>, <3.5233, 82.4812, -13.5556>, 0.4999 }
		cylinder { <3.5233, 82.4812, -13.5556>, <2.7772, 85.4074, -15.06044>, 0.4999 }
		cylinder { <2.7772, 85.4074, -15.06044>, <1.6355, 88.2473, -16.4801>, 0.4999 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.6355, 88.2473, -16.4801>, <0.7851, 89.1919, -16.9066>, 0.4256 }
			cylinder { <0.7851, 89.1919, -16.9066>, <-0.3625, 89.8422, -17.1455>, 0.4256 }
			cylinder { <-0.3625, 89.8422, -17.1455>, <-1.6733, 90.1223, -17.169>, 0.4256 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-1.6733, 90.1223, -17.169>, <-2.2238, 90.24, -17.1789>, 0.4256 }
				cylinder { <-2.2238, 90.24, -17.1789>, <-2.7744, 90.3576, -17.1887>, 0.4256 }
				cylinder { <-2.7744, 90.3576, -17.1887>, <-3.3249, 90.4753, -17.1986>, 0.4256 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-3.3249, 90.4753, -17.1986>, <-3.413, 90.4821, -17.2215>, 0.02899 }
				cylinder { <-3.413, 90.4821, -17.2215>, <-3.4936, 90.4763, -17.2641>, 0.02899 }
				cylinder { <-3.4936, 90.4763, -17.2641>, <-3.5608, 90.4582, -17.3232>, 0.02899 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-3.5608, 90.4582, -17.3232>, <-7.3107, 89.2119, -20.2757>, <-7.07596, 89.00539, -20.5503> }
				triangle { <-7.3107, 89.2119, -20.2757>, <-8.2192, 87.3451, -20.2329>, <-7.07596, 89.00539, -20.5503> }
				triangle { <-7.3107, 89.2119, -20.2757>, <-8.2909, 87.8545, -20.02347>, <-8.2192, 87.3451, -20.2329> }
				triangle { <-8.2192, 87.3451, -20.2329>, <-7.7273, 87.5776, -20.5795>, <-7.07596, 89.00539, -20.5503> }
				triangle { <-7.07596, 89.00539, -20.5503>, <-5.5792, 89.2747, -19.2813>, <-3.5608, 90.4582, -17.3232> }
				triangle { <-3.5608, 90.4582, -17.3232>, <-6.07436, 89.5471, -18.8017>, <-7.3107, 89.2119, -20.2757> }
				triangle { <-6.07436, 89.5471, -18.8017>, <-7.6173, 88.9554, -19.7064>, <-7.3107, 89.2119, -20.2757> }
				triangle { <-7.6173, 88.9554, -19.7064>, <-8.2909, 87.8545, -20.02347>, <-7.3107, 89.2119, -20.2757> }
				triangle { <-7.07596, 89.00539, -20.5503>, <-7.7273, 87.5776, -20.5795>, <-6.9516, 88.3183, -20.4812> }
				triangle { <-6.9516, 88.3183, -20.4812>, <-5.5792, 89.2747, -19.2813>, <-7.07596, 89.00539, -20.5503> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-3.3249, 90.4753, -17.1986>, <-3.4142, 90.4944, -17.2002>, 0.02899 }
				cylinder { <-3.4142, 90.4944, -17.2002>, <-3.5035, 90.5134, -17.2018>, 0.02899 }
				cylinder { <-3.5035, 90.5134, -17.2018>, <-3.5928, 90.5325, -17.2034>, 0.02899 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-3.5928, 90.5325, -17.2034>, <-8.4642, 91.2888, -17.03249>, <-8.5444, 91.1028, -17.3961> }
				triangle { <-8.4642, 91.2888, -17.03249>, <-9.8198, 89.8351, -16.4315>, <-8.5444, 91.1028, -17.3961> }
				triangle { <-8.4642, 91.2888, -17.03249>, <-9.5431, 90.2677, -16.2199>, <-9.8198, 89.8351, -16.4315> }
				triangle { <-9.8198, 89.8351, -16.4315>, <-9.5873, 89.9946, -17.01176>, <-8.5444, 91.1028, -17.3961> }
				triangle { <-8.5444, 91.1028, -17.3961>, <-6.6374, 90.5677, -17.3979>, <-3.5928, 90.5325, -17.2034> }
				triangle { <-3.5928, 90.5325, -17.2034>, <-6.5922, 90.8367, -16.7088>, <-8.4642, 91.2888, -17.03249> }
				triangle { <-6.5922, 90.8367, -16.7088>, <-8.4447, 90.993, -16.4032>, <-8.4642, 91.2888, -17.03249> }
				triangle { <-8.4447, 90.993, -16.4032>, <-9.5431, 90.2677, -16.2199>, <-8.4642, 91.2888, -17.03249> }
				triangle { <-8.5444, 91.1028, -17.3961>, <-9.5873, 89.9946, -17.01176>, <-8.6902, 90.4175, -17.4317> }
				triangle { <-8.6902, 90.4175, -17.4317>, <-6.6374, 90.5677, -17.3979>, <-8.5444, 91.1028, -17.3961> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <1.6355, 88.2473, -16.4801>, <1.1746, 90.549, -17.3044>, 0.3686 }
		cylinder { <1.1746, 90.549, -17.3044>, <1.1125, 92.97, -17.8743>, 0.3686 }
		cylinder { <1.1125, 92.97, -17.8743>, <1.4514, 95.4171, -18.168>, 0.3686 }
		texture{chif1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.4514, 95.4171, -18.168>, <1.5328, 95.6016, -18.1509>, 0.06425 }
			cylinder { <1.5328, 95.6016, -18.1509>, <1.6585, 95.75, -18.09487>, 0.06425 }
			cylinder { <1.6585, 95.75, -18.09487>, <1.8138, 95.8448, -18.00636>, 0.06425 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <1.8138, 95.8448, -18.00636>, <1.879, 95.8847, -17.9691>, 0.06425 }
				cylinder { <1.879, 95.8847, -17.9691>, <1.9442, 95.9245, -17.932>, 0.06425 }
				cylinder { <1.9442, 95.9245, -17.932>, <2.009473, 95.9644, -17.8948>, 0.06425 }
				texture{chif1}}
			mesh { // leaf
				triangle { <2.009473, 95.9644, -17.8948>, <2.6043, 96.2621, -17.5603>, <2.5748, 96.2749, -17.5064> }
				triangle { <2.6043, 96.2621, -17.5603>, <2.7834, 96.1047, -17.3568>, <2.5748, 96.2749, -17.5064> }
				triangle { <2.6043, 96.2621, -17.5603>, <2.7817, 96.1243, -17.4383>, <2.7834, 96.1047, -17.3568> }
				triangle { <2.7834, 96.1047, -17.3568>, <2.7054, 96.1616, -17.3444>, <2.5748, 96.2749, -17.5064> }
				triangle { <2.5748, 96.2749, -17.5064>, <2.3425, 96.1251, -17.6203>, <2.009473, 95.9644, -17.8948> }
				triangle { <2.009473, 95.9644, -17.8948>, <2.4088, 96.09601, -17.7055>, <2.6043, 96.2621, -17.5603> }
				triangle { <2.4088, 96.09601, -17.7055>, <2.6548, 96.1735, -17.5856>, <2.6043, 96.2621, -17.5603> }
				triangle { <2.6548, 96.1735, -17.5856>, <2.7817, 96.1243, -17.4383>, <2.6043, 96.2621, -17.5603> }
				triangle { <2.5748, 96.2749, -17.5064>, <2.7054, 96.1616, -17.3444>, <2.5722, 96.205, -17.4269> }
				triangle { <2.5722, 96.205, -17.4269>, <2.3425, 96.1251, -17.6203>, <2.5748, 96.2749, -17.5064> }
				texture{chif1}}
			mesh { // leaf
				triangle { <2.009473, 95.9644, -17.8948>, <2.6043, 96.2621, -17.5603>, <2.5748, 96.2749, -17.5064> }
				triangle { <2.6043, 96.2621, -17.5603>, <2.7834, 96.1047, -17.3568>, <2.5748, 96.2749, -17.5064> }
				triangle { <2.6043, 96.2621, -17.5603>, <2.7817, 96.1243, -17.4383>, <2.7834, 96.1047, -17.3568> }
				triangle { <2.7834, 96.1047, -17.3568>, <2.7054, 96.1616, -17.3444>, <2.5748, 96.2749, -17.5064> }
				triangle { <2.5748, 96.2749, -17.5064>, <2.3425, 96.1251, -17.6203>, <2.009473, 95.9644, -17.8948> }
				triangle { <2.009473, 95.9644, -17.8948>, <2.4088, 96.09601, -17.7055>, <2.6043, 96.2621, -17.5603> }
				triangle { <2.4088, 96.09601, -17.7055>, <2.6548, 96.1735, -17.5856>, <2.6043, 96.2621, -17.5603> }
				triangle { <2.6548, 96.1735, -17.5856>, <2.7817, 96.1243, -17.4383>, <2.6043, 96.2621, -17.5603> }
				triangle { <2.5748, 96.2749, -17.5064>, <2.7054, 96.1616, -17.3444>, <2.5722, 96.205, -17.4269> }
				triangle { <2.5722, 96.205, -17.4269>, <2.3425, 96.1251, -17.6203>, <2.5748, 96.2749, -17.5064> }
				texture{chif1}}
			}
		} scale 0.060
} // end Copy_of_gilia

