////////////////////////////////////
// Bridge object by Miroslav Hundak

// Object MODIFY
#declare W = 4;		// bridge width
#declare C = 0.1;	// cut size
#declare SW = 0.5;	// side width
#declare BR1 = 25;	// Bow R1
#declare BR2 = 12;	// Bow R2
#declare SH = 0.1;	// step height
#declare SM = 0.2;	// stone margin
#declare WT = 0.07;	// wire thickness

// Textures - include of this .inc file should be put after the include of "x.inc" file
#declare txBow = texture { txWood_1 rotate y*90 }
#declare txArm = texture { txWood_1 translate <5, 2, 8> rotate <31, 53, 15> }
#declare txHolder = texture { txWood_1 translate <2, 25, 3> rotate <18, 0, 5> }
#declare txSteps = texture { txWood_1 translate <6, 7, 0> rotate <0, 0, 0> }
#declare txStone = texture { txBrick_1 }

// Objects:
#declare oHole =
union {
	cylinder { <0, 0, -SW>, <0, 0, SW>, 0.25 scale <2, 1, 1> }
	torus { 0.25, C/2 rotate x*90 scale <2, 1, 1> translate <0, 0, -SW/2> }
	torus { 0.25, C/2 rotate x*90 scale <2, 1, 1> translate <0, 0, SW/2> }
	rotate <0, 0, -30>
}

#declare oBow =
difference {
	union {
		cone { <0, -(BR1-2), (SW/2-C)>, BR1, <0, -(BR1-2), SW/2>, (BR1-C) }
		cone { <0, -(BR1-2), -(SW/2-C)>, BR1, <0, -(BR1-2), -SW/2>, (BR1-C) }
		cylinder { <0, -(BR1-2), -(SW/2-C)>, <0, -(BR1-2), (SW/2-C)>, BR1 }
	}
	union {
		cone { <0, -(BR2-1.5), (SW/2-C)>, BR2, <0, -(BR2-1.5), (SW/2+C)>, BR2+2*C }
		cone { <0, -(BR2-1.5), -(SW/2-C)>, BR2, <0, -(BR2-1.5), -(SW/2+2*C)>, BR2+2*C }
		cylinder { <0, -(BR2-1.5), -SW>, <0, -(BR2-1.5), SW>, BR2 }
		box { <-(BR1+1), 0, -SW>, <(BR1+1), -2*BR1, SW> }
	}
	
	texture { txBow }
}

#declare oArm =
difference {
	box { <1, 0, -SW/2>, <8, 5.5, SW/2> }
	union {
		object { oHole translate <4.5, 2, 0> }
		cylinder { <0, 0, -SW>, <0, 0, SW>, 1 scale <6, 4, 1> translate <8, 6, 0> }
		cone { <0, 0, SW/2-C>, 6, <0, 0, SW/2+C>, 6+2*C scale <1, 4/6, 1> translate <8, 6, 0> }
		cone { <0, 0, -(SW/2-C)>, 6, <0, 0, -(SW/2+C)>, 6+2*C scale <1, 4/6, 1> translate <8, 6, 0> }
		cylinder { <0, 0, -SW>, <0, 0, SW>, 1 scale <7, 5.5, 1> translate <-3, 0, 0> }
		cone { <0, 0, SW/2-C>, 7, <0, 0, SW/2+C>, 7+2*C scale <1, 5.5/7, 1> translate <-3, 0, 0> }
		cone { <0, 0, -(SW/2-C)>, 7, <0, 0, -(SW/2+C)>, 7+2*C scale <1, 5.5/7, 1> translate <-3, 0, 0> }
		cylinder { <1, 5.5, -SW>, <1, 5.5, SW>, 0.5 }
		cone { <1, 5.5, SW/2-C>, 0.5, <1, 5.5, SW/2+C>, 0.5+2*C }
		cone { <1, 5.5, -(SW/2-C)>, 0.5, <1, 5.5, -(SW/2+C)>, 0.5+2*C }
		cylinder { <0, -(BR1-2), -SW>, <0, -(BR1-2), SW>, BR1 translate x*10 }
		cone { <0, -(BR1-2), SW/2-C>, BR1, <0, -(BR1-2), SW/2+C>, BR1+2*C translate x*10 }
		cone { <0, -(BR1-2), -(SW/2-C)>, BR1, <0, -(BR1-2), -(SW/2+C)>, BR1+2*C translate x*10 }
	}
	
	texture { txArm }
}

#declare oHolder =
difference {
	union {
		box { <-2, 0, -SW/2>, <2, 0.7, SW/2> }
		box { <-0.3, 0, -SW/2>, <0.3, 0.9, SW/2> }
		cylinder { <-0.3, 0.7, -(SW/2-C)>, <-0.3, 0.7, SW/2-C>, 0.2 }
		cylinder { <0.3, 0.7, -(SW/2-C)>, <0.3, 0.7, SW/2-C>, 0.2 }
		cone { <-0.3, 0.7, -(SW/2-C)>, 0.2, <-0.3, 0.7, -SW/2>, 0.1 }
		cone { <-0.3, 0.7, SW/2-C>, 0.2, <-0.3, 0.7, SW/2>, 0.1 }
		cone { <0.3, 0.7, -(SW/2-C)>, 0.2, <0.3, 0.7, -SW/2>, 0.1 }
		cone { <0.3, 0.7, SW/2-C>, 0.2, <0.3, 0.7, SW/2>, 0.1 }
	}
	union {
		cone { <0, -(BR1-2), SW/2-C>, BR1, <0, -(BR1-2), SW/2+C>, BR1+2*C translate -y*2 }
		cone { <0, -(BR1-2), -(SW/2-C)>, BR1, <0, -(BR1-2), -(SW/2+C)>, BR1+2*C translate -y*2 }
		box { <-0.4, 0, 0>, <0.4, 0.5, -0.5> rotate x*45 translate <0, 0.9-C, SW/2> }
		box { <-0.4, 0, 0>, <0.4, 0.5, 0.5> rotate -x*45 translate <0, 0.9-C, -SW/2> }
		cylinder { <0, 0, -SW>, <0, 0, SW>, 1 scale <1.5, 0.7, 1> translate <-2, 0.7, 0> }
		cylinder { <0, 0, -SW>, <0, 0, SW>, 1 scale <1.5, 0.7, 1> translate <2, 0.7, 0> }
		cone { <0, 0, -(SW/2-C)>, 1.5, <0, 0, -(SW/2+C)>, 1.5+2*C scale <1, 7/15, 1> translate <-2, 0.7, 0> }
		cone { <0, 0, SW/2-C>, 1.5, <0, 0, SW/2+C>, 1.5+2*C scale <1, 7/15, 1> translate <-2, 0.7, 0> }
		cone { <0, 0, -(SW/2-C)>, 1.5, <0, 0, -(SW/2+C)>, 1.5+2*C scale <1, 7/15, 1> translate <2, 0.7, 0> }
		cone { <0, 0, SW/2-C>, 1.5, <0, 0, SW/2+C>, 1.5+2*C scale <1, 7/15, 1> translate <2, 0.7, 0> }
	}
	
	texture { txHolder scale 1/2 }
}

#declare oStep1 =
box { <0, 0, (W-SW)/2>, <3.2, SH, -(W-SW)/2> }
#declare oStep2 =
box { <0, 0, (W-SW)/2>, <1.6, SH, -(W-SW)/2> }
#declare oStep3 =
box { <0, 0, (W-SW)/2>, <1.3, SH, -(W-SW)/2> }
#declare oStep4 =
box { <0, 0, (W-SW)/2>, <1.1, SH, -(W-SW)/2> }
#declare oStep5 =
box { <0, 0, (W-SW)/2>, <0.8, SH, -(W-SW)/2> }
#declare oStep6 =
box { <0, 0, (W-SW)/2>, <2, SH, -(W-SW)/2> }
#declare oSteps =
union {
	object { oStep1 translate <0, 1.5, 0> }
	object { oStep2 translate <3.2, 1.2, 0> }
	object { oStep3 translate <4.8, 0.9, 0> }
	object { oStep4 translate <6.1, 0.6, 0> }
	object { oStep5 translate <7.2, 0.3, 0> }
	object { oStep6 translate <8, 0, 0> }
	
	texture { txSteps }
}

#declare oHolder2 =
union {
	box { <8, 0, SW/2-C>, <10, 0.3, -(SW/2-C)> }
	box { <8, 0, SW/2-C>, <9.8, 0.5, -(SW/2-C)> }
	cylinder { <9.8, 0.3, SW/2-C>, <9.8, 0.3, -(SW/2-C)>, 0.2 }
	
	texture { txHolder scale 1/2 }
}

#declare oStone =
superellipsoid { <0.05, 0.05> scale <(4+SW+SM)/2, (4+SW+SM)/2, (W+SW+SM)/2>
	texture { txStone }
}

#declare oWire_1 =
cylinder { <0.3, 2.6, 0>, <8.1, 5.3, 0>, WT }
#declare oWire_2 =
cylinder { <8.8, 4.6, 0>, <9.8, 0.3, 0>, WT }
#declare oWire_3 =
torus { 0.3, WT rotate x*90 translate <8.5, 5, 0> }
#declare oWire =
union {
	object { oWire_1 texture { txWire_1 rotate z*30 } }
	object { oWire_2 texture { txWire_1 } }
	object { oWire_3 texture { txWire_1 } }
}

#declare oBridge =
union {
	object { oBow translate <0, 0, -W/2> }
	object { oBow translate <0, 0, W/2> } 
	object { oArm translate <-10, 0, -W/2> }
	object { oArm translate <-10, 0, W/2> }
	object { oArm rotate y*180 translate <10, 0, -W/2> }
	object { oArm rotate y*180 translate <10, 0, W/2> }
	object { oHolder translate <0, 2, -W/2> }
	object { oHolder translate <0, 2, W/2> }
	object { oSteps }
	object { oSteps rotate y*180 }
	object { oStone translate <-8, -(4+SW+SM)/2, 0> }
	object { oStone translate <8, -(4+SW+SM)/2, 0> }
	object { oWire translate <0, 0, -W/2> }
	object { oWire translate <0, 0, W/2> }
	object { oWire rotate y*180 translate <0, 0, -W/2> }
	object { oWire rotate y*180 translate <0, 0, W/2> }
	object { oHolder2 translate <0, 0, -W/2> }
	object { oHolder2 translate <0, 0, W/2> }
	object { oHolder2 rotate y*180 translate <0, 0, -W/2> }
	object { oHolder2 rotate y*180 translate <0, 0, W/2> }
}
