/////////////////////////////////////
// Ground objects by Miroslav Hundak
// -> sPatch export!

// Textures - include of this .inc file should be put after the include of "x.inc" file
#if(TEXTURE_PREVIEW)
#declare txIslands = texture { txBlank }
#declare txRocks = texture { txBlank }
#declare txCliff = texture { txBlank }
#declare txFaar = texture { txBlank }
#declare txFall = texture { txBlank }
#else
#declare txIslands = texture {
	pigment {
		gradient y
		color_map {
			[ 0 color rgb <0.4, 0.3, 0.3> ]
			[ 0.2 color rgb <0.7, 0.6, 0.6> ]
			[ 0.3 color rgb <0.6, 0.5, 0.1> ]
			[ 0.5 color rgb <0.2, 0.85, 0.05> ]
			[ 1 color rgb <0.1, 0.65, 0.2> ]
		}
		turbulence 0.2
	}
	normal {
		bumps 0.2
		scale 1/5
	}
	finish {
		diffuse 0.7
		brilliance 1
	}
}
#declare txRocks = texture {
	pigment { color rgb <0.65, 0.6, 0.6> }
	normal {
		wrinkles 1
		//turbulence 1
		scale 1/5
	}
	finish {
		diffuse 0.6
		brilliance 2
		phong 0.2
		phong_size 40
	}
}
#declare txCliff = texture {
	txRocks
	scale <1, 3, 1>
}
#declare txFaar = texture {
	pigment {
		bozo
		color_map {
			[ 0 color rgb <0.7, 0.7, 0> ]
			[ 1 color rgb <0, 0.5, 0.1> ]
		}
	}
	normal {
		bumps 0.3
		scale 1/50
	}
	finish {
		diffuse 0.7
		brilliance 1
	}
	scale 10
}
#declare txFall = texture {
	pigment { color rgbt <0.5, 0.6, 0.7, 0.3> }
	normal {
		wrinkles 1
		//frequency 2
		turbulence 0.5
		scale <1, 5, 1>*2
	}
	finish {
		diffuse 0.8
		brilliance 3
		phong 1
		phong_size 60
		reflection 0.5
	}
}
#end
	
// Layer 1
#declare oIslands =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.027, -0.002, -1.687> <0.987, 0.063, -1.670> <0.902, 0.137, -1.634> <0.892, 0.214, -1.630> 
		<0.637, -0.002, -1.874> <0.596, 0.063, -1.857> <0.561, 0.137, -1.744> <0.552, 0.214, -1.741> 
		<-0.037, -0.002, -2.466> <-0.048, 0.023, -2.386> <-0.167, 0.120, -1.980> <-0.155, 0.214, -1.783> 
		<-0.203, -0.002, -2.443> <-0.214, 0.023, -2.362> <-0.307, 0.120, -1.950> <-0.295, 0.214, -1.753> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.027, -0.002, -1.687> <1.537, -0.002, -1.442> <2.271, -0.002, -1.243> <2.785, -0.002, -1.008> 
		<0.987, 0.063, -1.670> <1.496, 0.063, -1.425> <2.212, 0.063, -1.186> <2.726, 0.063, -0.950> 
		<0.902, 0.137, -1.634> <1.439, 0.137, -1.460> <2.163, 0.173, -1.036> <2.685, 0.173, -0.821> 
		<0.892, 0.214, -1.630> <1.429, 0.214, -1.456> <2.067, 0.214, -1.032> <2.589, 0.214, -0.817> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.785, -0.002, -1.008> <2.933, -0.002, -0.940> <3.089, -0.002, -0.779> <3.220, -0.002, -0.681> 
		<2.726, 0.063, -0.950> <2.874, 0.063, -0.882> <3.091, 0.063, -0.776> <3.221, 0.063, -0.678> 
		<2.685, 0.173, -0.821> <2.866, 0.173, -0.747> <3.203, 0.182, -0.862> <3.281, 0.182, -0.682> 
		<2.589, 0.214, -0.817> <2.770, 0.214, -0.743> <3.147, 0.214, -0.851> <3.225, 0.214, -0.672> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.220, -0.002, -0.681> <3.220, -0.002, -0.287> <3.414, -0.002, 0.289> <3.220, -0.002, 0.631> 
		<3.221, 0.063, -0.678> <3.221, 0.063, -0.285> <3.412, 0.063, 0.284> <3.217, 0.063, 0.626> 
		<3.281, 0.182, -0.682> <3.435, 0.182, -0.328> <3.483, 0.182, 0.307> <3.267, 0.182, 0.627> 
		<3.225, 0.214, -0.672> <3.379, 0.214, -0.317> <3.427, 0.214, 0.296> <3.211, 0.214, 0.616> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.220, -0.002, 0.631> <2.924, -0.002, 1.149> <2.267, -0.002, 1.692> <1.726, -0.002, 1.943> 
		<3.217, 0.063, 0.626> <2.922, 0.063, 1.145> <2.221, 0.063, 1.642> <1.680, 0.063, 1.893> 
		<3.267, 0.182, 0.627> <2.930, 0.182, 1.126> <2.184, 0.160, 1.610> <1.625, 0.160, 1.833> 
		<3.211, 0.214, 0.616> <2.874, 0.214, 1.115> <2.133, 0.214, 1.553> <1.573, 0.214, 1.776> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.726, -0.002, 1.943> <1.453, -0.002, 2.070> <1.032, -0.002, 1.726> <0.736, -0.002, 1.782> 
		<1.680, 0.063, 1.893> <1.407, 0.063, 2.019> <1.011, 0.063, 1.680> <0.716, 0.063, 1.736> 
		<1.625, 0.160, 1.833> <1.369, 0.160, 1.934> <0.974, 0.159, 1.626> <0.703, 0.159, 1.677> 
		<1.573, 0.214, 1.776> <1.317, 0.214, 1.878> <0.938, 0.214, 1.577> <0.667, 0.214, 1.628> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.736, -0.002, 1.782> <0.140, -0.002, 1.894> <-0.858, -0.002, 2.544> <-1.161, -0.002, 2.488> 
		<0.716, 0.063, 1.736> <0.119, 0.063, 1.848> <-0.831, 0.063, 2.481> <-1.134, 0.063, 2.424> 
		<0.703, 0.159, 1.677> <0.156, 0.159, 1.781> <-0.824, 0.160, 2.399> <-1.102, 0.160, 2.347> 
		<0.667, 0.214, 1.628> <0.120, 0.214, 1.731> <-0.794, 0.214, 2.327> <-1.072, 0.214, 2.275> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.161, -0.002, 2.488> <-1.445, -0.002, 2.436> <-2.123, -0.002, 1.571> <-2.534, -0.002, 1.176> 
		<-1.134, 0.063, 2.424> <-1.419, 0.063, 2.372> <-2.062, 0.063, 1.540> <-2.473, 0.063, 1.145> 
		<-1.102, 0.160, 2.347> <-1.363, 0.160, 2.299> <-1.999, 0.160, 1.443> <-2.399, 0.160, 1.108> 
		<-1.072, 0.214, 2.275> <-1.332, 0.214, 2.227> <-1.930, 0.214, 1.408> <-2.330, 0.214, 1.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.534, -0.002, 1.176> <-2.753, -0.002, 0.965> <-3.147, -0.002, 0.752> <-3.261, -0.002, 0.470> 
		<-2.473, 0.063, 1.145> <-2.692, 0.063, 0.934> <-3.148, 0.063, 0.743> <-3.262, 0.063, 0.461> 
		<-2.399, 0.160, 1.108> <-2.659, 0.160, 0.890> <-3.164, 0.184, 0.728> <-3.322, 0.184, 0.429> 
		<-2.330, 0.214, 1.073> <-2.590, 0.214, 0.855> <-3.107, 0.214, 0.739> <-3.265, 0.214, 0.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.261, -0.002, 0.470> <-3.412, -0.002, 0.092> <-3.504, -0.002, -0.502> <-3.362, -0.002, -0.883> 
		<-3.262, 0.063, 0.461> <-3.414, 0.063, 0.083> <-3.503, 0.063, -0.502> <-3.360, 0.063, -0.884> 
		<-3.322, 0.184, 0.429> <-3.507, 0.184, 0.076> <-3.640, 0.178, -0.609> <-3.395, 0.178, -0.923> 
		<-3.265, 0.214, 0.439> <-3.450, 0.214, 0.087> <-3.602, 0.214, -0.571> <-3.357, 0.214, -0.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.362, -0.002, -0.883> <-3.281, -0.002, -1.098> <-2.856, -0.002, -1.061> <-2.651, -0.002, -1.162> 
		<-3.360, 0.063, -0.884> <-3.280, 0.063, -1.098> <-2.711, 0.063, -1.002> <-2.505, 0.063, -1.103> 
		<-3.395, 0.178, -0.923> <-3.174, 0.178, -1.205> <-2.645, 0.132, -0.930> <-2.301, 0.132, -1.028> 
		<-3.357, 0.214, -0.885> <-3.136, 0.214, -1.167> <-2.511, 0.214, -0.868> <-2.166, 0.214, -0.966> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.651, -0.002, -1.162> <-1.908, -0.002, -1.529> <-0.521, -0.002, -2.397> <-0.203, -0.002, -2.443> 
		<-2.505, 0.063, -1.103> <-1.762, 0.063, -1.470> <-0.532, 0.023, -2.317> <-0.214, 0.023, -2.362> 
		<-2.301, 0.132, -1.028> <-1.715, 0.132, -1.194> <-0.544, 0.120, -1.898> <-0.307, 0.120, -1.950> 
		<-2.166, 0.214, -0.966> <-1.580, 0.214, -1.132> <-0.533, 0.214, -1.701> <-0.295, 0.214, -1.753> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.892, 0.214, -1.630> <0.883, 0.289, -1.627> <1.006, 0.413, -1.721> <0.971, 0.448, -1.665> 
		<0.552, 0.214, -1.741> <0.542, 0.289, -1.737> <0.680, 0.413, -1.816> <0.645, 0.448, -1.760> 
		<-0.155, 0.214, -1.783> <-0.150, 0.262, -1.684> <-0.026, 0.393, -1.642> <-0.019, 0.448, -1.546> 
		<-0.295, 0.214, -1.753> <-0.290, 0.262, -1.653> <-0.156, 0.393, -1.604> <-0.150, 0.448, -1.508> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.892, 0.214, -1.630> <1.429, 0.214, -1.456> <2.067, 0.214, -1.032> <2.589, 0.214, -0.817> 
		<0.883, 0.289, -1.627> <1.420, 0.289, -1.452> <1.818, 0.321, -1.021> <2.340, 0.321, -0.807> 
		<1.006, 0.413, -1.721> <1.304, 0.413, -1.635> <1.745, 0.379, -1.165> <1.991, 0.379, -0.976> 
		<0.971, 0.448, -1.665> <1.269, 0.448, -1.579> <1.483, 0.448, -1.152> <1.729, 0.448, -0.963> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.589, 0.214, -0.817> <2.770, 0.214, -0.743> <3.147, 0.214, -0.851> <3.225, 0.214, -0.672> 
		<2.340, 0.321, -0.807> <2.521, 0.321, -0.732> <2.935, 0.338, -0.811> <3.013, 0.338, -0.632> 
		<1.991, 0.379, -0.976> <2.188, 0.379, -0.824> <2.569, 0.394, -0.803> <2.680, 0.394, -0.580> 
		<1.729, 0.448, -0.963> <1.927, 0.448, -0.811> <2.330, 0.448, -0.758> <2.441, 0.448, -0.535> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.225, 0.214, -0.672> <3.379, 0.214, -0.317> <3.427, 0.214, 0.296> <3.211, 0.214, 0.616> 
		<3.013, 0.338, -0.632> <3.166, 0.338, -0.277> <3.218, 0.335, 0.252> <3.002, 0.335, 0.572> 
		<2.680, 0.394, -0.580> <2.814, 0.394, -0.310> <2.825, 0.395, 0.254> <2.676, 0.395, 0.516> 
		<2.441, 0.448, -0.535> <2.575, 0.448, -0.265> <2.590, 0.448, 0.207> <2.441, 0.448, 0.469> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.211, 0.214, 0.616> <2.874, 0.214, 1.115> <2.133, 0.214, 1.553> <1.573, 0.214, 1.776> 
		<3.002, 0.335, 0.572> <2.665, 0.335, 1.071> <2.055, 0.296, 1.468> <1.496, 0.296, 1.690> 
		<2.676, 0.395, 0.516> <2.450, 0.395, 0.913> <1.787, 0.405, 1.397> <1.372, 0.405, 1.586> 
		<2.441, 0.448, 0.469> <2.215, 0.448, 0.866> <1.714, 0.448, 1.284> <1.298, 0.448, 1.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.573, 0.214, 1.776> <1.317, 0.214, 1.878> <0.938, 0.214, 1.577> <0.667, 0.214, 1.628> 
		<1.496, 0.296, 1.690> <1.240, 0.296, 1.792> <0.884, 0.297, 1.503> <0.613, 0.297, 1.554> 
		<1.372, 0.405, 1.586> <1.136, 0.405, 1.693> <0.743, 0.397, 1.431> <0.490, 0.397, 1.479> 
		<1.298, 0.448, 1.473> <1.063, 0.448, 1.580> <0.696, 0.448, 1.330> <0.442, 0.448, 1.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.667, 0.214, 1.628> <0.120, 0.214, 1.731> <-0.794, 0.214, 2.327> <-1.072, 0.214, 2.275> 
		<0.613, 0.297, 1.554> <0.066, 0.297, 1.657> <-0.749, 0.296, 2.218> <-1.026, 0.296, 2.166> 
		<0.490, 0.397, 1.479> <0.063, 0.397, 1.559> <-0.748, 0.404, 2.060> <-0.963, 0.404, 2.016> 
		<0.442, 0.448, 1.378> <0.016, 0.448, 1.458> <-0.695, 0.448, 1.934> <-0.911, 0.448, 1.890> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.072, 0.214, 2.275> <-1.332, 0.214, 2.227> <-1.930, 0.214, 1.408> <-2.330, 0.214, 1.073> 
		<-1.026, 0.296, 2.166> <-1.287, 0.296, 2.118> <-1.826, 0.296, 1.355> <-2.226, 0.296, 1.020> 
		<-0.963, 0.404, 2.016> <-1.180, 0.404, 1.972> <-1.755, 0.399, 1.205> <-2.089, 0.399, 0.925> 
		<-0.911, 0.448, 1.890> <-1.127, 0.448, 1.846> <-1.627, 0.448, 1.166> <-1.961, 0.448, 0.886> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.330, 0.214, 1.073> <-2.590, 0.214, 0.855> <-3.107, 0.214, 0.739> <-3.265, 0.214, 0.439> 
		<-2.226, 0.296, 1.020> <-2.486, 0.296, 0.803> <-2.871, 0.340, 0.785> <-3.028, 0.340, 0.485> 
		<-2.089, 0.399, 0.925> <-2.208, 0.399, 0.825> <-2.583, 0.386, 0.797> <-2.673, 0.386, 0.670> 
		<-1.961, 0.448, 0.886> <-2.080, 0.448, 0.786> <-2.321, 0.448, 0.758> <-2.412, 0.448, 0.632> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.265, 0.214, 0.439> <-3.450, 0.214, 0.087> <-3.602, 0.214, -0.571> <-3.357, 0.214, -0.885> 
		<-3.028, 0.340, 0.485> <-3.213, 0.340, 0.132> <-3.480, 0.333, -0.449> <-3.235, 0.333, -0.763> 
		<-2.673, 0.386, 0.670> <-2.875, 0.386, 0.389> <-3.202, 0.407, -0.155> <-3.090, 0.407, -0.483> 
		<-2.412, 0.448, 0.632> <-2.614, 0.448, 0.350> <-3.008, 0.448, -0.090> <-2.896, 0.448, -0.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.357, 0.214, -0.885> <-3.136, 0.214, -1.167> <-2.511, 0.214, -0.868> <-2.166, 0.214, -0.966> 
		<-3.235, 0.333, -0.763> <-3.014, 0.333, -1.045> <-2.422, 0.269, -0.827> <-2.078, 0.269, -0.925> 
		<-3.090, 0.407, -0.483> <-2.988, 0.407, -0.784> <-2.287, 0.386, -0.759> <-1.991, 0.386, -0.876> 
		<-2.896, 0.448, -0.418> <-2.793, 0.448, -0.719> <-2.212, 0.448, -0.704> <-1.916, 0.448, -0.822> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.166, 0.214, -0.966> <-1.580, 0.214, -1.132> <-0.533, 0.214, -1.701> <-0.295, 0.214, -1.753> 
		<-2.078, 0.269, -0.925> <-1.492, 0.269, -1.091> <-0.527, 0.262, -1.602> <-0.290, 0.262, -1.653> 
		<-1.991, 0.386, -0.876> <-1.463, 0.386, -1.086> <-0.374, 0.393, -1.540> <-0.156, 0.393, -1.604> 
		<-1.916, 0.448, -0.822> <-1.388, 0.448, -1.031> <-0.368, 0.448, -1.444> <-0.150, 0.448, -1.508> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.971, 0.448, -1.665> <0.858, 0.562, -1.486> <0.613, 0.557, -1.239> <0.511, 0.598, -1.025> 
		<0.645, 0.448, -1.760> <0.532, 0.562, -1.580> <0.390, 0.557, -1.293> <0.288, 0.598, -1.078> 
		<-0.019, 0.448, -1.546> <-0.011, 0.517, -1.424> <0.049, 0.568, -1.233> <-0.026, 0.598, -1.119> 
		<-0.150, 0.448, -1.508> <-0.142, 0.517, -1.386> <-0.177, 0.568, -1.193> <-0.251, 0.598, -1.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.971, 0.448, -1.665> <1.269, 0.448, -1.579> <1.483, 0.448, -1.152> <1.729, 0.448, -0.963> 
		<0.858, 0.562, -1.486> <1.156, 0.562, -1.400> <1.297, 0.498, -1.143> <1.542, 0.498, -0.954> 
		<0.613, 0.557, -1.239> <0.814, 0.557, -1.191> <1.128, 0.600, -0.746> <1.333, 0.575, -0.736> 
		<0.511, 0.598, -1.025> <0.712, 0.598, -0.977> <0.936, 0.624, -0.756> <1.141, 0.598, -0.745> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.729, 0.448, -0.963> <1.927, 0.448, -0.811> <2.330, 0.448, -0.758> <2.441, 0.448, -0.535> 
		<1.542, 0.498, -0.954> <1.740, 0.498, -0.802> <2.059, 0.509, -0.707> <2.170, 0.509, -0.484> 
		<1.333, 0.575, -0.736> <1.449, 0.575, -0.617> <1.749, 0.564, -0.538> <1.808, 0.564, -0.383> 
		<1.141, 0.598, -0.745> <1.258, 0.598, -0.627> <1.471, 0.598, -0.506> <1.529, 0.598, -0.351> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.441, 0.448, -0.535> <2.575, 0.448, -0.265> <2.590, 0.448, 0.207> <2.441, 0.448, 0.469> 
		<2.170, 0.509, -0.484> <2.304, 0.509, -0.214> <2.319, 0.510, 0.153> <2.170, 0.510, 0.415> 
		<1.808, 0.564, -0.383> <1.875, 0.564, -0.206> <1.899, 0.562, 0.116> <1.810, 0.562, 0.283> 
		<1.529, 0.598, -0.351> <1.596, 0.598, -0.174> <1.619, 0.598, 0.113> <1.529, 0.598, 0.279> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.441, 0.448, 0.469> <2.215, 0.448, 0.866> <1.714, 0.448, 1.284> <1.298, 0.448, 1.473> 
		<2.170, 0.510, 0.415> <1.945, 0.510, 0.812> <1.589, 0.522, 1.093> <1.173, 0.522, 1.282> 
		<1.810, 0.562, 0.283> <1.699, 0.562, 0.491> <1.218, 0.553, 0.838> <1.037, 0.553, 0.988> 
		<1.529, 0.598, 0.279> <1.418, 0.598, 0.487> <1.106, 0.598, 0.630> <0.925, 0.598, 0.781> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.298, 0.448, 1.473> <1.063, 0.448, 1.580> <0.696, 0.448, 1.330> <0.442, 0.448, 1.378> 
		<1.173, 0.522, 1.282> <0.938, 0.522, 1.389> <0.633, 0.516, 1.196> <0.379, 0.516, 1.244> 
		<1.037, 0.553, 0.988> <0.853, 0.553, 1.016> <0.492, 0.554, 0.981> <0.313, 0.554, 1.029> 
		<0.925, 0.598, 0.781> <0.741, 0.598, 0.808> <0.492, 0.598, 0.824> <0.313, 0.598, 0.871> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.442, 0.448, 1.378> <0.016, 0.448, 1.458> <-0.695, 0.448, 1.934> <-0.911, 0.448, 1.890> 
		<0.379, 0.516, 1.244> <-0.047, 0.516, 1.324> <-0.610, 0.520, 1.731> <-0.825, 0.520, 1.686> 
		<0.313, 0.554, 1.029> <0.028, 0.554, 1.104> <-0.358, 0.549, 1.431> <-0.653, 0.549, 1.414> 
		<0.313, 0.598, 0.871> <0.028, 0.598, 0.947> <-0.323, 0.598, 1.207> <-0.617, 0.598, 1.189> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.911, 0.448, 1.890> <-1.127, 0.448, 1.846> <-1.627, 0.448, 1.166> <-1.961, 0.448, 0.886> 
		<-0.825, 0.520, 1.686> <-1.042, 0.520, 1.642> <-1.450, 0.516, 1.113> <-1.784, 0.516, 0.833> 
		<-0.653, 0.549, 1.414> <-0.901, 0.549, 1.399> <-1.283, 0.604, 0.784> <-1.523, 0.577, 0.730> 
		<-0.617, 0.598, 1.189> <-0.865, 0.598, 1.175> <-1.092, 0.625, 0.827> <-1.332, 0.598, 0.773> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.961, 0.448, 0.886> <-2.080, 0.448, 0.786> <-2.321, 0.448, 0.758> <-2.412, 0.448, 0.632> 
		<-1.784, 0.516, 0.833> <-1.903, 0.516, 0.733> <-2.064, 0.509, 0.720> <-2.154, 0.509, 0.594> 
		<-1.523, 0.577, 0.730> <-1.617, 0.577, 0.558> <-1.871, 0.557, 0.382> <-1.910, 0.557, 0.190> 
		<-1.332, 0.598, 0.773> <-1.426, 0.598, 0.601> <-1.607, 0.598, 0.392> <-1.646, 0.598, 0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.412, 0.448, 0.632> <-2.614, 0.448, 0.350> <-3.008, 0.448, -0.090> <-2.896, 0.448, -0.418> 
		<-2.154, 0.509, 0.594> <-2.356, 0.509, 0.312> <-2.626, 0.529, 0.037> <-2.515, 0.529, -0.291> 
		<-1.910, 0.557, 0.190> <-1.939, 0.557, 0.045> <-1.942, 0.547, -0.117> <-1.951, 0.547, -0.265> 
		<-1.646, 0.598, 0.200> <-1.675, 0.598, 0.055> <-1.536, 0.598, -0.134> <-1.545, 0.598, -0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.896, 0.448, -0.418> <-2.793, 0.448, -0.719> <-2.212, 0.448, -0.704> <-1.916, 0.448, -0.822> 
		<-2.515, 0.529, -0.291> <-2.412, 0.529, -0.592> <-2.145, 0.503, -0.657> <-1.850, 0.503, -0.774> 
		<-1.951, 0.547, -0.265> <-1.958, 0.547, -0.378> <-1.689, 0.602, -0.616> <-1.752, 0.576, -0.707> 
		<-1.545, 0.598, -0.282> <-1.552, 0.598, -0.395> <-1.635, 0.624, -0.537> <-1.698, 0.598, -0.628> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.916, 0.448, -0.822> <-1.388, 0.448, -1.031> <-0.368, 0.448, -1.444> <-0.150, 0.448, -1.508> 
		<-1.850, 0.503, -0.774> <-1.321, 0.503, -0.983> <-0.360, 0.517, -1.323> <-0.142, 0.517, -1.386> 
		<-1.752, 0.576, -0.707> <-1.318, 0.576, -0.842> <-0.624, 0.568, -1.112> <-0.177, 0.568, -1.193> 
		<-1.698, 0.598, -0.628> <-1.264, 0.598, -0.763> <-0.699, 0.598, -0.998> <-0.251, 0.598, -1.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.440, 0.710, 0.443> <0.442, 0.732, 0.220> <0.309, 0.727, -0.070> <0.320, 0.710, -0.293> 
		<0.090, 0.728, 0.509> <0.091, 0.749, 0.286> <-0.033, 0.744, -0.093> <-0.022, 0.727, -0.316> 
		<-0.368, 0.729, 0.741> <-0.408, 0.753, 0.381> <-0.554, 0.753, -0.159> <-0.461, 0.731, -0.508> 
		<-0.722, 0.710, 0.699> <-0.762, 0.734, 0.340> <-0.897, 0.732, -0.156> <-0.804, 0.710, -0.506> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.440, 0.710, 0.443> <0.090, 0.728, 0.509> <-0.368, 0.729, 0.741> <-0.722, 0.710, 0.699> 
		<0.440, 0.697, 0.581> <0.089, 0.715, 0.646> <-0.351, 0.719, 0.893> <-0.705, 0.700, 0.852> 
		<0.312, 0.636, 0.738> <0.027, 0.636, 0.814> <-0.299, 0.631, 1.058> <-0.594, 0.631, 1.041> 
		<0.313, 0.598, 0.871> <0.028, 0.598, 0.947> <-0.323, 0.598, 1.207> <-0.617, 0.598, 1.189> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.440, 0.710, 0.443> <0.766, 0.694, 0.382> <1.200, 0.641, 0.275> <1.529, 0.598, 0.279> 
		<0.442, 0.732, 0.220> <0.768, 0.716, 0.159> <1.289, 0.641, 0.108> <1.619, 0.598, 0.113> 
		<0.309, 0.727, -0.070> <0.673, 0.710, -0.046> <1.237, 0.643, -0.133> <1.596, 0.598, -0.174> 
		<0.320, 0.710, -0.293> <0.683, 0.693, -0.269> <1.170, 0.643, -0.310> <1.529, 0.598, -0.351> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.440, 0.710, 0.443> <0.766, 0.694, 0.382> <1.200, 0.641, 0.275> <1.529, 0.598, 0.279> 
		<0.440, 0.697, 0.581> <0.766, 0.681, 0.520> <1.089, 0.641, 0.483> <1.418, 0.598, 0.487> 
		<0.312, 0.636, 0.738> <0.492, 0.636, 0.691> <0.922, 0.598, 0.658> <1.106, 0.598, 0.630> 
		<0.313, 0.598, 0.871> <0.492, 0.598, 0.824> <0.741, 0.598, 0.808> <0.925, 0.598, 0.781> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.320, 0.710, -0.293> <-0.022, 0.727, -0.316> <-0.461, 0.731, -0.508> <-0.804, 0.710, -0.506> 
		<0.331, 0.693, -0.522> <-0.011, 0.709, -0.545> <-0.400, 0.716, -0.741> <-0.742, 0.696, -0.739> 
		<0.414, 0.637, -0.821> <0.191, 0.637, -0.874> <-0.154, 0.650, -0.922> <-0.380, 0.650, -0.881> 
		<0.511, 0.598, -1.025> <0.288, 0.598, -1.078> <-0.026, 0.598, -1.119> <-0.251, 0.598, -1.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.320, 0.710, -0.293> <0.683, 0.693, -0.269> <1.170, 0.643, -0.310> <1.529, 0.598, -0.351> 
		<0.331, 0.693, -0.522> <0.694, 0.676, -0.498> <1.111, 0.643, -0.465> <1.471, 0.598, -0.506> 
		<0.414, 0.637, -0.821> <0.615, 0.637, -0.773> <1.053, 0.624, -0.637> <1.258, 0.598, -0.627> 
		<0.511, 0.598, -1.025> <0.712, 0.598, -0.977> <0.936, 0.624, -0.756> <1.141, 0.598, -0.745> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.251, 0.598, -1.079> <-0.380, 0.650, -0.881> <-0.742, 0.696, -0.739> <-0.804, 0.710, -0.506> 
		<-0.699, 0.598, -0.998> <-0.827, 0.650, -0.801> <-0.977, 0.682, -0.737> <-1.038, 0.696, -0.505> 
		<-1.264, 0.598, -0.763> <-1.201, 0.624, -0.672> <-1.319, 0.627, -0.405> <-1.312, 0.627, -0.292> 
		<-1.698, 0.598, -0.628> <-1.635, 0.624, -0.537> <-1.552, 0.598, -0.395> <-1.545, 0.598, -0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.804, 0.710, -0.506> <-1.038, 0.696, -0.505> <-1.312, 0.627, -0.292> <-1.545, 0.598, -0.282> 
		<-0.897, 0.732, -0.156> <-1.131, 0.718, -0.155> <-1.303, 0.627, -0.144> <-1.536, 0.598, -0.134> 
		<-0.762, 0.734, 0.340> <-1.076, 0.717, 0.303> <-1.362, 0.647, 0.068> <-1.675, 0.598, 0.055> 
		<-0.722, 0.710, 0.699> <-1.036, 0.694, 0.663> <-1.333, 0.647, 0.213> <-1.646, 0.598, 0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.722, 0.710, 0.699> <-1.036, 0.694, 0.663> <-1.333, 0.647, 0.213> <-1.646, 0.598, 0.200> 
		<-0.705, 0.700, 0.852> <-1.020, 0.683, 0.816> <-1.295, 0.647, 0.405> <-1.607, 0.598, 0.392> 
		<-0.594, 0.631, 1.041> <-0.842, 0.631, 1.026> <-1.186, 0.625, 0.655> <-1.426, 0.598, 0.601> 
		<-0.617, 0.598, 1.189> <-0.865, 0.598, 1.175> <-1.092, 0.625, 0.827> <-1.332, 0.598, 0.773> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.165, -0.002, 2.585> <-15.160, 0.060, 2.593> <-15.152, 0.184, 2.671> <-15.149, 0.206, 2.611> 
		<-15.228, -0.002, -0.086> <-15.224, 0.060, -0.078> <-15.232, 0.184, 0.174> <-15.230, 0.206, 0.114> 
		<-15.814, -0.002, -3.811> <-15.852, 0.060, -3.631> <-16.025, 0.150, -3.619> <-16.028, 0.206, -3.433> 
		<-14.885, -0.002, -6.316> <-14.923, 0.060, -6.136> <-15.009, 0.150, -5.901> <-15.012, 0.206, -5.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.165, -0.002, 2.585> <-15.154, -0.002, 3.012> <-15.067, -0.002, 3.955> <-14.641, -0.002, 3.911> 
		<-15.160, 0.060, 2.593> <-15.150, 0.060, 3.020> <-15.091, 0.060, 3.752> <-14.665, 0.060, 3.709> 
		<-15.152, 0.184, 2.671> <-15.144, 0.184, 2.897> <-14.931, 0.148, 3.490> <-14.709, 0.148, 3.441> 
		<-15.149, 0.206, 2.611> <-15.141, 0.206, 2.838> <-14.944, 0.206, 3.285> <-14.722, 0.206, 3.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.641, -0.002, 3.911> <-13.546, -0.002, 3.800> <-12.429, -0.002, 2.579> <-11.395, -0.002, 2.201> 
		<-14.665, 0.060, 3.709> <-13.570, 0.060, 3.597> <-12.346, 0.060, 2.434> <-11.312, 0.060, 2.055> 
		<-14.709, 0.148, 3.441> <-13.564, 0.148, 3.186> <-12.090, 0.153, 2.141> <-10.969, 0.153, 1.796> 
		<-14.722, 0.206, 3.236> <-13.577, 0.206, 2.981> <-12.241, 0.206, 2.060> <-11.120, 0.206, 1.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.395, -0.002, 2.201> <-11.192, -0.002, 2.127> <-10.941, -0.002, 2.533> <-10.732, -0.002, 2.480> 
		<-11.312, 0.060, 2.055> <-11.110, 0.060, 1.981> <-10.888, 0.060, 2.375> <-10.678, 0.060, 2.322> 
		<-10.969, 0.153, 1.796> <-10.793, 0.153, 1.742> <-10.604, 0.161, 2.113> <-10.425, 0.161, 2.069> 
		<-11.120, 0.206, 1.715> <-10.943, 0.206, 1.661> <-10.733, 0.206, 1.998> <-10.554, 0.206, 1.954> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.732, -0.002, 2.480> <-9.802, -0.002, 2.245> <-8.673, -0.002, 1.602> <-7.769, -0.002, 1.284> 
		<-10.678, 0.060, 2.322> <-9.749, 0.060, 2.087> <-8.731, 0.060, 1.499> <-7.827, 0.060, 1.181> 
		<-10.425, 0.161, 2.069> <-9.614, 0.161, 1.870> <-8.645, 0.164, 1.186> <-7.838, 0.164, 0.971> 
		<-10.554, 0.206, 1.954> <-9.743, 0.206, 1.755> <-8.768, 0.206, 1.155> <-7.961, 0.206, 0.940> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.769, -0.002, 1.284> <-7.184, -0.002, 1.078> <-6.222, -0.002, 1.165> <-5.775, -0.002, 0.735> 
		<-7.827, 0.060, 1.181> <-7.242, 0.060, 0.974> <-6.228, 0.060, 1.151> <-5.781, 0.060, 0.721> 
		<-7.838, 0.164, 0.971> <-7.206, 0.164, 0.803> <-6.263, 0.193, 1.086> <-5.735, 0.193, 0.701> 
		<-7.961, 0.206, 0.940> <-7.329, 0.206, 0.772> <-6.325, 0.206, 1.072> <-5.796, 0.206, 0.688> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.775, -0.002, 0.735> <-5.424, -0.002, 0.397> <-5.435, -0.002, -0.393> <-5.531, -0.002, -0.871> 
		<-5.781, 0.060, 0.721> <-5.430, 0.060, 0.383> <-5.428, 0.060, -0.385> <-5.524, 0.060, -0.863> 
		<-5.735, 0.193, 0.701> <-5.356, 0.193, 0.426> <-5.256, 0.193, -0.423> <-5.445, 0.193, -0.852> 
		<-5.796, 0.206, 0.688> <-5.418, 0.206, 0.412> <-5.318, 0.206, -0.417> <-5.506, 0.206, -0.845> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.531, -0.002, -0.871> <-5.579, -0.002, -1.113> <-6.127, -0.002, -1.121> <-6.194, -0.002, -1.359> 
		<-5.524, 0.060, -0.863> <-5.572, 0.060, -1.105> <-6.274, 0.060, -1.111> <-6.340, 0.060, -1.348> 
		<-5.445, 0.193, -0.852> <-5.598, 0.193, -1.200> <-6.253, 0.178, -1.057> <-6.524, 0.178, -1.324> 
		<-5.506, 0.206, -0.845> <-5.660, 0.206, -1.193> <-6.410, 0.206, -1.056> <-6.681, 0.206, -1.323> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.194, -0.002, -1.359> <-6.240, -0.002, -1.524> <-5.743, -0.002, -1.576> <-5.775, -0.002, -1.743> 
		<-6.340, 0.060, -1.348> <-6.386, 0.060, -1.513> <-5.908, 0.060, -1.548> <-5.940, 0.060, -1.716> 
		<-6.524, 0.178, -1.324> <-6.628, 0.178, -1.427> <-6.121, 0.179, -1.512> <-6.148, 0.179, -1.655> 
		<-6.681, 0.206, -1.323> <-6.785, 0.206, -1.425> <-6.297, 0.206, -1.508> <-6.324, 0.206, -1.651> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.775, -0.002, -1.743> <-5.812, -0.002, -1.937> <-6.159, -0.002, -2.000> <-6.334, -0.002, -2.092> 
		<-5.940, 0.060, -1.716> <-5.977, 0.060, -1.910> <-6.299, 0.060, -1.956> <-6.474, 0.060, -2.049> 
		<-6.148, 0.179, -1.655> <-6.179, 0.179, -1.820> <-6.494, 0.181, -1.869> <-6.643, 0.181, -1.948> 
		<-6.324, 0.206, -1.651> <-6.355, 0.206, -1.816> <-6.652, 0.206, -1.869> <-6.801, 0.206, -1.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.334, -0.002, -2.092> <-6.809, -0.002, -2.345> <-7.504, -0.002, -2.578> <-7.939, -0.002, -2.895> 
		<-6.474, 0.060, -2.049> <-6.949, 0.060, -2.302> <-7.574, 0.060, -2.499> <-8.009, 0.060, -2.817> 
		<-6.643, 0.181, -1.948> <-7.049, 0.181, -2.164> <-7.683, 0.182, -2.388> <-8.054, 0.182, -2.659> 
		<-6.801, 0.206, -1.948> <-7.206, 0.206, -2.164> <-7.800, 0.206, -2.363> <-8.171, 0.206, -2.634> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.939, -0.002, -2.895> <-8.181, -0.002, -3.072> <-8.289, -0.002, -3.525> <-8.533, -0.002, -3.698> 
		<-8.009, 0.060, -2.817> <-8.251, 0.060, -2.993> <-8.332, 0.060, -3.411> <-8.576, 0.060, -3.584> 
		<-8.054, 0.182, -2.659> <-8.260, 0.182, -2.810> <-8.343, 0.177, -3.217> <-8.551, 0.177, -3.365> 
		<-8.171, 0.206, -2.634> <-8.377, 0.206, -2.784> <-8.469, 0.206, -3.171> <-8.677, 0.206, -3.319> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.533, -0.002, -3.698> <-9.029, -0.002, -4.051> <-9.857, -0.002, -4.246> <-10.348, -0.002, -4.606> 
		<-8.576, 0.060, -3.584> <-9.072, 0.060, -3.937> <-9.820, 0.060, -4.092> <-10.311, 0.060, -4.452> 
		<-8.551, 0.177, -3.365> <-8.975, 0.177, -3.666> <-9.673, 0.163, -3.881> <-10.092, 0.163, -4.188> 
		<-8.677, 0.206, -3.319> <-9.101, 0.206, -3.619> <-9.807, 0.206, -3.786> <-10.226, 0.206, -4.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.348, -0.002, -4.606> <-10.886, -0.002, -4.999> <-11.295, -0.002, -5.941> <-11.919, -0.002, -6.176> 
		<-10.311, 0.060, -4.452> <-10.849, 0.060, -4.845> <-11.189, 0.060, -5.718> <-11.813, 0.060, -5.953> 
		<-10.092, 0.163, -4.188> <-10.551, 0.163, -4.524> <-10.896, 0.142, -5.459> <-11.435, 0.142, -5.642> 
		<-10.226, 0.206, -4.093> <-10.685, 0.206, -4.429> <-11.028, 0.206, -5.251> <-11.566, 0.206, -5.433> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.919, -0.002, -6.176> <-12.752, -0.002, -6.491> <-14.576, -0.002, -7.151> <-14.885, -0.002, -6.316> 
		<-11.813, 0.060, -5.953> <-12.647, 0.060, -6.268> <-14.614, 0.060, -6.971> <-14.923, 0.060, -6.136> 
		<-11.435, 0.142, -5.642> <-12.417, 0.142, -5.975> <-14.587, 0.150, -6.849> <-15.009, 0.150, -5.901> 
		<-11.566, 0.206, -5.433> <-12.549, 0.206, -5.766> <-14.590, 0.206, -6.663> <-15.012, 0.206, -5.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.149, 0.206, 2.611> <-15.128, 0.368, 2.189> <-15.122, 0.449, 1.584> <-15.095, 0.549, 1.143> 
		<-15.230, 0.206, 0.114> <-15.209, 0.368, -0.308> <-15.162, 0.449, -0.104> <-15.136, 0.549, -0.544> 
		<-16.028, 0.206, -3.433> <-16.035, 0.317, -3.064> <-15.529, 0.463, -3.273> <-15.506, 0.549, -2.898> 
		<-15.012, 0.206, -5.715> <-15.019, 0.317, -5.346> <-14.943, 0.463, -4.856> <-14.919, 0.549, -4.481> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.149, 0.206, 2.611> <-15.141, 0.206, 2.838> <-14.944, 0.206, 3.285> <-14.722, 0.206, 3.236> 
		<-15.128, 0.368, 2.189> <-15.121, 0.368, 2.416> <-14.968, 0.313, 2.910> <-14.746, 0.313, 2.861> 
		<-15.122, 0.449, 1.584> <-15.116, 0.449, 1.854> <-15.022, 0.466, 2.335> <-14.753, 0.466, 2.362> 
		<-15.095, 0.549, 1.143> <-15.089, 0.549, 1.413> <-15.034, 0.549, 1.953> <-14.765, 0.549, 1.981> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.722, 0.206, 3.236> <-13.577, 0.206, 2.981> <-12.241, 0.206, 2.060> <-11.120, 0.206, 1.715> 
		<-14.746, 0.313, 2.861> <-13.601, 0.313, 2.606> <-12.720, 0.376, 1.803> <-11.598, 0.376, 1.458> 
		<-14.753, 0.466, 2.362> <-14.182, 0.466, 2.422> <-13.044, 0.434, 1.895> <-12.505, 0.434, 1.697> 
		<-14.765, 0.549, 1.981> <-14.194, 0.549, 2.040> <-13.492, 0.549, 1.563> <-12.953, 0.549, 1.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.120, 0.206, 1.715> <-10.943, 0.206, 1.661> <-10.733, 0.206, 1.998> <-10.554, 0.206, 1.954> 
		<-11.598, 0.376, 1.458> <-11.422, 0.376, 1.404> <-11.160, 0.357, 1.614> <-10.981, 0.357, 1.570> 
		<-12.505, 0.434, 1.697> <-12.302, 0.434, 1.623> <-12.023, 0.450, 1.434> <-11.810, 0.450, 1.405> 
		<-12.953, 0.549, 1.365> <-12.750, 0.549, 1.291> <-12.508, 0.549, 1.106> <-12.295, 0.549, 1.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.554, 0.206, 1.954> <-9.743, 0.206, 1.755> <-8.768, 0.206, 1.155> <-7.961, 0.206, 0.940> 
		<-10.981, 0.357, 1.570> <-10.170, 0.357, 1.371> <-9.168, 0.344, 1.054> <-8.361, 0.344, 0.839> 
		<-11.810, 0.450, 1.405> <-10.938, 0.450, 1.287> <-9.817, 0.493, 1.202> <-8.958, 0.493, 1.013> 
		<-12.295, 0.549, 1.077> <-11.423, 0.549, 0.959> <-10.228, 0.549, 1.069> <-9.368, 0.549, 0.881> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.961, 0.206, 0.940> <-7.329, 0.206, 0.772> <-6.325, 0.206, 1.072> <-5.796, 0.206, 0.688> 
		<-8.361, 0.344, 0.839> <-7.729, 0.344, 0.671> <-7.042, 0.368, 0.911> <-6.513, 0.368, 0.527> 
		<-8.958, 0.493, 1.013> <-8.567, 0.493, 0.927> <-7.767, 0.476, 0.644> <-7.498, 0.476, 0.347> 
		<-9.368, 0.549, 0.881> <-8.977, 0.549, 0.795> <-8.498, 0.549, 0.480> <-8.229, 0.549, 0.184> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.796, 0.206, 0.688> <-5.418, 0.206, 0.412> <-5.318, 0.206, -0.417> <-5.506, 0.206, -0.845> 
		<-6.513, 0.368, 0.527> <-6.135, 0.368, 0.251> <-6.061, 0.371, -0.337> <-6.250, 0.371, -0.765> 
		<-7.498, 0.476, 0.347> <-7.335, 0.476, 0.166> <-7.123, 0.473, -0.382> <-7.262, 0.473, -0.582> 
		<-8.229, 0.549, 0.184> <-8.066, 0.549, 0.003> <-7.885, 0.549, -0.403> <-8.024, 0.549, -0.603> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.506, 0.206, -0.845> <-5.660, 0.206, -1.193> <-6.410, 0.206, -1.056> <-6.681, 0.206, -1.323> 
		<-6.250, 0.371, -0.765> <-6.403, 0.371, -1.113> <-7.184, 0.345, -1.048> <-7.455, 0.345, -1.315> 
		<-7.262, 0.473, -0.582> <-7.511, 0.473, -0.940> <-8.163, 0.455, -1.046> <-8.499, 0.455, -1.323> 
		<-8.024, 0.549, -0.603> <-8.272, 0.549, -0.960> <-8.943, 0.549, -1.054> <-9.280, 0.549, -1.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.681, 0.206, -1.323> <-6.785, 0.206, -1.425> <-6.297, 0.206, -1.508> <-6.324, 0.206, -1.651> 
		<-7.455, 0.345, -1.315> <-7.559, 0.345, -1.418> <-7.189, 0.345, -1.487> <-7.216, 0.345, -1.630> 
		<-8.499, 0.455, -1.323> <-8.577, 0.455, -1.386> <-8.361, 0.451, -1.596> <-8.417, 0.451, -1.679> 
		<-9.280, 0.549, -1.330> <-9.357, 0.549, -1.394> <-9.258, 0.549, -1.580> <-9.315, 0.549, -1.663> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.324, 0.206, -1.651> <-6.355, 0.206, -1.816> <-6.652, 0.206, -1.869> <-6.801, 0.206, -1.948> 
		<-7.216, 0.345, -1.630> <-7.248, 0.345, -1.796> <-7.550, 0.349, -1.872> <-7.699, 0.349, -1.952> 
		<-8.417, 0.451, -1.679> <-8.529, 0.451, -1.843> <-8.731, 0.443, -2.042> <-8.906, 0.443, -2.137> 
		<-9.315, 0.549, -1.663> <-9.427, 0.549, -1.827> <-9.634, 0.549, -2.010> <-9.809, 0.549, -2.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.801, 0.206, -1.948> <-7.206, 0.206, -2.164> <-7.800, 0.206, -2.363> <-8.171, 0.206, -2.634> 
		<-7.699, 0.349, -1.952> <-8.104, 0.349, -2.168> <-8.489, 0.353, -2.209> <-8.860, 0.353, -2.480> 
		<-8.906, 0.443, -2.137> <-9.105, 0.443, -2.244> <-9.637, 0.451, -2.314> <-9.825, 0.451, -2.438> 
		<-9.809, 0.549, -2.105> <-10.007, 0.549, -2.212> <-10.342, 0.549, -2.195> <-10.530, 0.549, -2.319> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.171, 0.206, -2.634> <-8.377, 0.206, -2.784> <-8.469, 0.206, -3.171> <-8.677, 0.206, -3.319> 
		<-8.860, 0.353, -2.480> <-9.067, 0.353, -2.631> <-9.104, 0.354, -2.937> <-9.312, 0.354, -3.085> 
		<-9.825, 0.451, -2.438> <-9.983, 0.451, -2.542> <-10.092, 0.451, -2.904> <-10.246, 0.451, -3.014> 
		<-10.530, 0.549, -2.319> <-10.688, 0.549, -2.423> <-10.751, 0.549, -2.717> <-10.905, 0.549, -2.827> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.677, 0.206, -3.319> <-9.101, 0.206, -3.619> <-9.807, 0.206, -3.786> <-10.226, 0.206, -4.093> 
		<-9.312, 0.354, -3.085> <-9.736, 0.354, -3.386> <-10.276, 0.358, -3.454> <-10.696, 0.358, -3.761> 
		<-10.246, 0.451, -3.014> <-10.560, 0.451, -3.237> <-11.219, 0.449, -3.439> <-11.530, 0.449, -3.666> 
		<-10.905, 0.549, -2.827> <-11.219, 0.549, -3.049> <-11.742, 0.549, -3.173> <-12.052, 0.549, -3.400> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.226, 0.206, -4.093> <-10.685, 0.206, -4.429> <-11.028, 0.206, -5.251> <-11.566, 0.206, -5.433> 
		<-10.696, 0.358, -3.761> <-11.154, 0.358, -4.097> <-11.313, 0.346, -4.799> <-11.851, 0.346, -4.982> 
		<-11.530, 0.449, -3.666> <-11.869, 0.449, -3.915> <-12.271, 0.451, -4.632> <-12.665, 0.451, -4.781> 
		<-12.052, 0.549, -3.400> <-12.392, 0.549, -3.649> <-12.651, 0.549, -4.244> <-13.045, 0.549, -4.392> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.566, 0.206, -5.433> <-12.549, 0.206, -5.766> <-14.590, 0.206, -6.663> <-15.012, 0.206, -5.715> 
		<-11.851, 0.346, -4.982> <-12.834, 0.346, -5.315> <-14.597, 0.317, -6.294> <-15.019, 0.317, -5.346> 
		<-12.665, 0.451, -4.781> <-13.191, 0.451, -4.979> <-14.747, 0.463, -5.383> <-14.943, 0.463, -4.856> 
		<-13.045, 0.549, -4.392> <-13.571, 0.549, -4.591> <-14.723, 0.549, -5.009> <-14.919, 0.549, -4.481> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.341, 0.777, 0.069> <-13.777, 0.777, 0.237> <-14.364, 0.777, 0.443> <-14.802, 0.777, 0.603> 
		<-13.225, 0.709, 0.458> <-13.660, 0.709, 0.626> <-14.313, 0.727, 0.856> <-14.751, 0.727, 1.016> 
		<-13.277, 0.632, 1.125> <-13.816, 0.632, 1.323> <-14.206, 0.638, 1.631> <-14.777, 0.638, 1.572> 
		<-12.953, 0.549, 1.365> <-13.492, 0.549, 1.563> <-14.194, 0.549, 2.040> <-14.765, 0.549, 1.981> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.341, 0.777, 0.069> <-13.341, 0.777, 0.069> <-13.341, 0.777, 0.069> <-13.341, 0.777, 0.069> 
		<-13.036, 0.768, 0.387> <-12.919, 0.699, 0.776> <-12.919, 0.699, 0.776> <-13.225, 0.709, 0.458> 
		<-12.655, 0.623, 0.833> <-12.869, 0.623, 0.862> <-13.074, 0.632, 1.051> <-13.277, 0.632, 1.125> 
		<-12.295, 0.549, 1.077> <-12.508, 0.549, 1.106> <-12.750, 0.549, 1.291> <-12.953, 0.549, 1.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.341, 0.777, 0.069> <-13.607, 0.786, -0.208> <-13.999, 0.640, -0.547> <-14.179, 0.609, -0.884> 
		<-13.777, 0.777, 0.237> <-14.043, 0.786, -0.040> <-14.306, 0.676, -0.310> <-14.486, 0.645, -0.647> 
		<-14.364, 0.777, 0.443> <-14.384, 0.797, 0.285> <-14.835, 0.788, -0.087> <-14.838, 0.788, -0.247> 
		<-14.802, 0.777, 0.603> <-14.822, 0.797, 0.446> <-14.996, 0.777, 0.268> <-14.998, 0.777, 0.108> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.341, 0.777, 0.069> <-12.986, 0.777, -0.069> <-12.527, 0.777, -0.287> <-12.168, 0.777, -0.414> 
		<-13.607, 0.786, -0.208> <-13.252, 0.786, -0.345> <-12.947, 0.783, -0.474> <-12.588, 0.783, -0.601> 
		<-13.999, 0.640, -0.547> <-13.855, 0.623, -0.658> <-13.398, 0.649, -0.724> <-13.216, 0.649, -0.709> 
		<-14.179, 0.609, -0.884> <-14.035, 0.592, -0.996> <-13.761, 0.609, -1.004> <-13.578, 0.609, -0.989> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.341, 0.777, 0.069> <-13.036, 0.768, 0.387> <-12.655, 0.623, 0.833> <-12.295, 0.549, 1.077> 
		<-12.986, 0.777, -0.069> <-12.681, 0.768, 0.250> <-11.783, 0.623, 0.715> <-11.423, 0.549, 0.959> 
		<-12.527, 0.777, -0.287> <-11.679, 0.765, 0.089> <-11.104, 0.668, 0.788> <-10.228, 0.549, 1.069> 
		<-12.168, 0.777, -0.414> <-11.320, 0.765, -0.037> <-10.244, 0.668, 0.599> <-9.368, 0.549, 0.881> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.095, 0.549, 1.143> <-15.077, 0.620, 0.832> <-15.129, 0.769, 0.399> <-14.998, 0.777, 0.108> 
		<-15.136, 0.549, -0.544> <-15.117, 0.620, -0.855> <-15.143, 0.769, -0.600> <-15.011, 0.777, -0.891> 
		<-15.506, 0.549, -2.898> <-15.482, 0.635, -2.523> <-15.283, 0.769, -2.658> <-15.200, 0.777, -2.281> 
		<-14.919, 0.549, -4.481> <-14.895, 0.635, -4.106> <-14.936, 0.769, -3.594> <-14.854, 0.777, -3.218> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.095, 0.549, 1.143> <-15.089, 0.549, 1.413> <-15.034, 0.549, 1.953> <-14.765, 0.549, 1.981> 
		<-15.077, 0.620, 0.832> <-15.070, 0.620, 1.102> <-15.046, 0.638, 1.544> <-14.777, 0.638, 1.572> 
		<-15.129, 0.769, 0.399> <-15.127, 0.769, 0.559> <-14.770, 0.746, 0.859> <-14.751, 0.727, 1.016> 
		<-14.998, 0.777, 0.108> <-14.996, 0.777, 0.268> <-14.822, 0.797, 0.446> <-14.802, 0.777, 0.603> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.368, 0.549, 0.881> <-8.977, 0.549, 0.795> <-8.498, 0.549, 0.480> <-8.229, 0.549, 0.184> 
		<-10.244, 0.668, 0.599> <-9.853, 0.668, 0.513> <-9.477, 0.647, 0.262> <-9.208, 0.647, -0.035> 
		<-11.320, 0.765, -0.037> <-11.122, 0.765, -0.107> <-10.682, 0.765, -0.267> <-10.504, 0.765, -0.377> 
		<-12.168, 0.777, -0.414> <-11.970, 0.777, -0.484> <-11.668, 0.777, -0.473> <-11.490, 0.777, -0.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.229, 0.549, 0.184> <-8.066, 0.549, 0.003> <-7.885, 0.549, -0.403> <-8.024, 0.549, -0.603> 
		<-9.208, 0.647, -0.035> <-9.044, 0.647, -0.216> <-8.848, 0.645, -0.429> <-8.987, 0.645, -0.629> 
		<-10.504, 0.765, -0.377> <-10.376, 0.765, -0.456> <-10.401, 0.724, -1.007> <-10.251, 0.714, -1.008> 
		<-11.490, 0.777, -0.583> <-11.362, 0.777, -0.662> <-11.367, 0.787, -1.001> <-11.217, 0.777, -1.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.024, 0.549, -0.603> <-8.272, 0.549, -0.960> <-8.943, 0.549, -1.054> <-9.280, 0.549, -1.330> 
		<-8.987, 0.645, -0.629> <-9.235, 0.645, -0.987> <-9.585, 0.626, -1.059> <-9.921, 0.626, -1.336> 
		<-10.251, 0.714, -1.008> <-10.312, 0.714, -1.117> <-10.717, 0.767, -1.359> <-10.782, 0.767, -1.466> 
		<-11.217, 0.777, -1.002> <-11.278, 0.777, -1.111> <-11.356, 0.777, -1.259> <-11.420, 0.777, -1.366> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.280, 0.549, -1.330> <-9.357, 0.549, -1.394> <-9.258, 0.549, -1.580> <-9.315, 0.549, -1.663> 
		<-9.921, 0.626, -1.336> <-9.999, 0.626, -1.399> <-9.930, 0.622, -1.568> <-9.987, 0.622, -1.651> 
		<-10.782, 0.767, -1.466> <-10.818, 0.767, -1.525> <-10.846, 0.767, -1.543> <-10.879, 0.767, -1.605> 
		<-11.420, 0.777, -1.366> <-11.457, 0.777, -1.426> <-11.520, 0.777, -1.496> <-11.553, 0.777, -1.557> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.315, 0.549, -1.663> <-9.427, 0.549, -1.827> <-9.634, 0.549, -2.010> <-9.809, 0.549, -2.105> 
		<-9.987, 0.622, -1.651> <-10.099, 0.622, -1.815> <-10.193, 0.615, -1.991> <-10.368, 0.615, -2.085> 
		<-10.879, 0.767, -1.605> <-10.913, 0.767, -1.668> <-11.066, 0.709, -1.810> <-11.093, 0.709, -1.876> 
		<-11.553, 0.777, -1.557> <-11.588, 0.777, -1.620> <-11.616, 0.777, -1.712> <-11.644, 0.777, -1.778> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.809, 0.549, -2.105> <-10.007, 0.549, -2.212> <-10.342, 0.549, -2.195> <-10.530, 0.549, -2.319> 
		<-10.368, 0.615, -2.085> <-10.567, 0.615, -2.193> <-10.876, 0.623, -2.105> <-11.065, 0.623, -2.230> 
		<-11.093, 0.709, -1.876> <-11.289, 0.709, -1.925> <-11.603, 0.766, -2.030> <-11.783, 0.766, -2.122> 
		<-11.644, 0.777, -1.778> <-11.840, 0.777, -1.827> <-12.118, 0.777, -1.848> <-12.298, 0.777, -1.940> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.530, 0.549, -2.319> <-10.688, 0.549, -2.423> <-10.751, 0.549, -2.717> <-10.905, 0.549, -2.827> 
		<-11.065, 0.623, -2.230> <-11.223, 0.623, -2.334> <-11.247, 0.623, -2.576> <-11.402, 0.623, -2.685> 
		<-11.783, 0.766, -2.122> <-11.880, 0.766, -2.171> <-11.954, 0.767, -2.373> <-12.043, 0.767, -2.436> 
		<-12.298, 0.777, -1.940> <-12.395, 0.777, -1.989> <-12.431, 0.777, -2.163> <-12.520, 0.777, -2.226> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.905, 0.549, -2.827> <-11.219, 0.549, -3.049> <-11.742, 0.549, -3.173> <-12.052, 0.549, -3.400> 
		<-11.402, 0.623, -2.685> <-11.715, 0.623, -2.908> <-12.118, 0.621, -2.981> <-12.428, 0.621, -3.208> 
		<-12.043, 0.767, -2.436> <-12.230, 0.767, -2.569> <-12.666, 0.768, -2.691> <-12.850, 0.768, -2.828> 
		<-12.520, 0.777, -2.226> <-12.707, 0.777, -2.359> <-13.014, 0.777, -2.442> <-13.198, 0.777, -2.579> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-12.052, 0.549, -3.400> <-12.392, 0.549, -3.649> <-12.651, 0.549, -4.244> <-13.045, 0.549, -4.392> 
		<-12.428, 0.621, -3.208> <-12.768, 0.621, -3.457> <-12.950, 0.626, -3.938> <-13.344, 0.626, -4.086> 
		<-12.850, 0.768, -2.828> <-13.050, 0.768, -2.976> <-13.387, 0.709, -3.358> <-13.563, 0.709, -3.534> 
		<-13.198, 0.777, -2.579> <-13.398, 0.777, -2.727> <-13.609, 0.777, -2.990> <-13.785, 0.777, -3.166> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.045, 0.549, -4.392> <-13.571, 0.549, -4.591> <-14.723, 0.549, -5.009> <-14.919, 0.549, -4.481> 
		<-13.344, 0.626, -4.086> <-13.871, 0.626, -4.285> <-14.700, 0.635, -4.633> <-14.895, 0.635, -4.106> 
		<-13.563, 0.709, -3.534> <-13.883, 0.709, -3.549> <-14.825, 0.769, -3.895> <-14.936, 0.769, -3.594> 
		<-13.785, 0.777, -3.166> <-14.105, 0.777, -3.181> <-14.742, 0.777, -3.519> <-14.854, 0.777, -3.218> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.159, 0.609, -1.391> <-13.033, 0.650, -1.672> <-12.591, 0.784, -1.836> <-12.298, 0.777, -1.940> 
		<-13.332, 0.596, -1.395> <-13.206, 0.636, -1.675> <-12.687, 0.784, -1.886> <-12.395, 0.777, -1.989> 
		<-13.535, 0.609, -1.543> <-13.273, 0.651, -1.848> <-12.801, 0.785, -2.001> <-12.431, 0.777, -2.163> 
		<-13.700, 0.609, -1.597> <-13.438, 0.651, -1.903> <-12.890, 0.785, -2.064> <-12.520, 0.777, -2.226> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.159, 0.609, -1.391> <-13.332, 0.596, -1.395> <-13.535, 0.609, -1.543> <-13.700, 0.609, -1.597> 
		<-13.244, 0.582, -1.201> <-13.417, 0.568, -1.204> <-13.655, 0.590, -1.402> <-13.820, 0.590, -1.457> 
		<-13.010, 0.590, -0.868> <-13.242, 0.572, -0.828> <-13.490, 0.593, -1.084> <-13.725, 0.593, -1.103> 
		<-12.821, 0.609, -0.777> <-13.053, 0.591, -0.736> <-13.343, 0.609, -0.971> <-13.578, 0.609, -0.989> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.159, 0.609, -1.391> <-13.244, 0.582, -1.201> <-13.010, 0.590, -0.868> <-12.821, 0.609, -0.777> 
		<-12.673, 0.647, -1.382> <-12.759, 0.620, -1.192> <-12.559, 0.625, -0.947> <-12.371, 0.644, -0.855> 
		<-12.039, 0.785, -1.523> <-12.006, 0.785, -1.461> <-11.910, 0.785, -1.355> <-11.873, 0.785, -1.295> 
		<-11.553, 0.777, -1.557> <-11.520, 0.777, -1.496> <-11.457, 0.777, -1.426> <-11.420, 0.777, -1.366> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.159, 0.609, -1.391> <-12.673, 0.647, -1.382> <-12.039, 0.785, -1.523> <-11.553, 0.777, -1.557> 
		<-13.033, 0.650, -1.672> <-12.547, 0.688, -1.663> <-12.073, 0.785, -1.586> <-11.588, 0.777, -1.620> 
		<-12.591, 0.784, -1.836> <-12.411, 0.784, -1.744> <-11.813, 0.777, -1.760> <-11.616, 0.777, -1.712> 
		<-12.298, 0.777, -1.940> <-12.118, 0.777, -1.848> <-11.840, 0.777, -1.827> <-11.644, 0.777, -1.778> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.700, 0.609, -1.597> <-13.438, 0.651, -1.903> <-12.890, 0.785, -2.064> <-12.520, 0.777, -2.226> 
		<-13.885, 0.609, -1.658> <-13.624, 0.651, -1.963> <-13.077, 0.785, -2.196> <-12.707, 0.777, -2.359> 
		<-14.212, 0.593, -1.616> <-14.003, 0.629, -1.977> <-13.354, 0.786, -2.199> <-13.014, 0.777, -2.442> 
		<-14.325, 0.609, -1.774> <-14.116, 0.645, -2.135> <-13.538, 0.786, -2.335> <-13.198, 0.777, -2.579> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.700, 0.609, -1.597> <-13.885, 0.609, -1.658> <-14.212, 0.593, -1.616> <-14.325, 0.609, -1.774> 
		<-13.820, 0.590, -1.457> <-14.005, 0.590, -1.517> <-14.348, 0.570, -1.383> <-14.460, 0.586, -1.541> 
		<-13.725, 0.593, -1.103> <-13.907, 0.593, -1.117> <-14.162, 0.570, -1.234> <-14.306, 0.587, -1.122> 
		<-13.578, 0.609, -0.989> <-13.761, 0.609, -1.004> <-14.035, 0.592, -0.996> <-14.179, 0.609, -0.884> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.325, 0.609, -1.774> <-14.116, 0.645, -2.135> <-13.538, 0.786, -2.335> <-13.198, 0.777, -2.579> 
		<-14.593, 0.648, -2.151> <-14.384, 0.684, -2.512> <-13.738, 0.786, -2.484> <-13.398, 0.777, -2.727> 
		<-14.754, 0.787, -2.765> <-14.643, 0.787, -3.066> <-13.929, 0.777, -3.005> <-13.609, 0.777, -2.990> 
		<-14.854, 0.777, -3.218> <-14.742, 0.777, -3.519> <-14.105, 0.777, -3.181> <-13.785, 0.777, -3.166> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.325, 0.609, -1.774> <-14.593, 0.648, -2.151> <-14.754, 0.787, -2.765> <-14.854, 0.777, -3.218> 
		<-14.460, 0.586, -1.541> <-14.728, 0.625, -1.918> <-15.101, 0.787, -1.828> <-15.200, 0.777, -2.281> 
		<-14.306, 0.587, -1.122> <-14.613, 0.624, -0.885> <-14.851, 0.788, -1.245> <-15.011, 0.777, -0.891> 
		<-14.179, 0.609, -0.884> <-14.486, 0.645, -0.647> <-14.838, 0.788, -0.247> <-14.998, 0.777, 0.108> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.578, 0.609, -0.989> <-13.216, 0.649, -0.709> <-12.588, 0.783, -0.601> <-12.168, 0.777, -0.414> 
		<-13.343, 0.609, -0.971> <-12.981, 0.649, -0.691> <-12.390, 0.783, -0.670> <-11.970, 0.777, -0.484> 
		<-13.053, 0.591, -0.736> <-12.688, 0.628, -0.560> <-12.066, 0.783, -0.556> <-11.668, 0.777, -0.473> 
		<-12.821, 0.609, -0.777> <-12.457, 0.646, -0.600> <-11.888, 0.783, -0.667> <-11.490, 0.777, -0.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-12.821, 0.609, -0.777> <-12.457, 0.646, -0.600> <-11.888, 0.783, -0.667> <-11.490, 0.777, -0.583> 
		<-12.371, 0.644, -0.855> <-12.006, 0.681, -0.679> <-11.760, 0.783, -0.746> <-11.362, 0.777, -0.662> 
		<-11.873, 0.785, -1.295> <-11.809, 0.785, -1.188> <-11.428, 0.787, -1.110> <-11.367, 0.787, -1.001> 
		<-11.420, 0.777, -1.366> <-11.356, 0.777, -1.259> <-11.278, 0.777, -1.111> <-11.217, 0.777, -1.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<15.796, -0.002, -9.317> <15.720, 0.045, -9.207> <15.622, 0.128, -9.064> <15.544, 0.155, -8.949> 
		<18.228, -0.002, -10.773> <18.153, 0.045, -10.663> <17.928, 0.128, -10.445> <17.849, 0.155, -10.330> 
		<20.794, -0.002, -17.094> <20.604, 0.045, -16.889> <20.472, 0.129, -16.527> <20.280, 0.155, -16.320> 
		<23.050, -0.002, -15.376> <22.860, 0.045, -15.171> <22.610, 0.129, -14.899> <22.419, 0.155, -14.692> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<15.796, -0.002, -9.317> <14.971, -0.002, -8.824> <13.460, -0.002, -9.548> <12.600, -0.002, -9.121> 
		<15.720, 0.045, -9.207> <14.896, 0.045, -8.713> <13.435, 0.045, -9.440> <12.574, 0.045, -9.014> 
		<15.622, 0.128, -9.064> <14.841, 0.128, -8.597> <13.339, 0.128, -9.317> <12.542, 0.128, -8.877> 
		<15.544, 0.155, -8.949> <14.763, 0.155, -8.482> <13.312, 0.155, -9.204> <12.515, 0.155, -8.763> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<12.600, -0.002, -9.121> <10.905, -0.002, -8.281> <8.953, -0.002, -6.598> <7.616, -0.002, -5.260> 
		<12.574, 0.045, -9.014> <10.880, 0.045, -8.173> <9.160, 0.045, -6.505> <7.824, 0.045, -5.167> 
		<12.542, 0.128, -8.877> <11.051, 0.128, -8.053> <9.348, 0.075, -6.300> <8.145, 0.075, -5.095> 
		<12.515, 0.155, -8.763> <11.024, 0.155, -7.939> <9.512, 0.155, -6.155> <8.308, 0.155, -4.950> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.616, -0.002, -5.260> <7.188, -0.002, -4.832> <7.043, -0.002, -3.966> <6.871, -0.002, -3.385> 
		<7.824, 0.045, -5.167> <7.396, 0.045, -4.739> <7.107, 0.045, -3.949> <6.935, 0.045, -3.368> 
		<8.145, 0.075, -5.095> <7.714, 0.075, -4.664> <7.282, 0.114, -3.856> <7.018, 0.114, -3.306> 
		<8.308, 0.155, -4.950> <7.877, 0.155, -4.519> <7.349, 0.155, -3.877> <7.085, 0.155, -3.328> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.871, -0.002, -3.385> <6.737, -0.002, -2.935> <6.824, -0.002, -2.256> <6.602, -0.002, -1.842> 
		<6.935, 0.045, -3.368> <6.801, 0.045, -2.918> <6.893, 0.045, -2.263> <6.670, 0.045, -1.849> 
		<7.018, 0.114, -3.306> <6.826, 0.114, -2.905> <6.993, 0.126, -2.232> <6.753, 0.126, -1.857> 
		<7.085, 0.155, -3.328> <6.893, 0.155, -2.926> <7.071, 0.155, -2.240> <6.831, 0.155, -1.865> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.602, -0.002, -1.842> <6.401, -0.002, -1.467> <5.683, -0.002, -1.302> <5.539, -0.002, -0.902> 
		<6.670, 0.045, -1.849> <6.469, 0.045, -1.474> <5.683, 0.045, -1.309> <5.539, 0.045, -0.908> 
		<6.753, 0.126, -1.857> <6.493, 0.126, -1.454> <5.696, 0.142, -1.346> <5.495, 0.142, -0.911> 
		<6.831, 0.155, -1.865> <6.571, 0.155, -1.461> <5.741, 0.155, -1.358> <5.539, 0.155, -0.923> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.539, -0.002, -0.902> <5.374, -0.002, -0.444> <5.475, -0.002, 0.274> <5.681, -0.002, 0.716> 
		<5.539, 0.045, -0.908> <5.374, 0.045, -0.450> <5.465, 0.045, 0.266> <5.671, 0.045, 0.708> 
		<5.495, 0.142, -0.911> <5.291, 0.142, -0.472> <5.346, 0.142, 0.303> <5.607, 0.142, 0.711> 
		<5.539, 0.155, -0.923> <5.336, 0.155, -0.483> <5.387, 0.155, 0.280> <5.648, 0.155, 0.688> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.681, -0.002, 0.716> <5.785, -0.002, 0.940> <6.219, -0.002, 0.926> <6.441, -0.002, 1.034> 
		<5.671, 0.045, 0.708> <5.776, 0.045, 0.932> <6.290, 0.045, 0.874> <6.512, 0.045, 0.982> 
		<5.607, 0.142, 0.711> <5.776, 0.142, 0.975> <6.304, 0.127, 0.816> <6.601, 0.127, 0.917> 
		<5.648, 0.155, 0.688> <5.817, 0.155, 0.952> <6.381, 0.155, 0.760> <6.678, 0.155, 0.861> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.441, -0.002, 1.034> <6.729, -0.002, 1.174> <7.063, -0.002, 1.504> <7.381, -0.002, 1.541> 
		<6.512, 0.045, 0.982> <6.800, 0.045, 1.122> <7.119, 0.045, 1.444> <7.438, 0.045, 1.481> 
		<6.601, 0.127, 0.917> <6.888, 0.127, 1.015> <7.205, 0.127, 1.372> <7.507, 0.127, 1.407> 
		<6.678, 0.155, 0.861> <6.966, 0.155, 0.958> <7.268, 0.155, 1.306> <7.569, 0.155, 1.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.381, -0.002, 1.541> <7.955, -0.002, 1.607> <8.749, -0.002, 1.184> <9.298, -0.002, 1.364> 
		<7.438, 0.045, 1.481> <8.011, 0.045, 1.547> <8.776, 0.045, 1.126> <9.324, 0.045, 1.307> 
		<7.507, 0.127, 1.407> <8.051, 0.127, 1.470> <8.835, 0.125, 1.069> <9.355, 0.125, 1.240> 
		<7.569, 0.155, 1.341> <8.113, 0.155, 1.404> <8.866, 0.155, 1.002> <9.386, 0.155, 1.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.298, -0.002, 1.364> <9.580, -0.002, 1.457> <9.657, -0.002, 1.991> <9.652, -0.002, 2.288> 
		<9.324, 0.045, 1.307> <9.606, 0.045, 1.400> <9.678, 0.045, 1.920> <9.672, 0.045, 2.216> 
		<9.355, 0.125, 1.240> <9.622, 0.125, 1.328> <9.703, 0.126, 1.848> <9.698, 0.126, 2.129> 
		<9.386, 0.155, 1.173> <9.653, 0.155, 1.261> <9.726, 0.155, 1.768> <9.721, 0.155, 2.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.652, -0.002, 2.288> <9.647, -0.002, 2.521> <9.038, -0.002, 2.914> <9.266, -0.002, 2.963> 
		<9.672, 0.045, 2.216> <9.668, 0.045, 2.450> <9.065, 0.045, 2.831> <9.293, 0.045, 2.881> 
		<9.698, 0.126, 2.129> <9.693, 0.126, 2.350> <9.110, 0.127, 2.732> <9.326, 0.127, 2.779> 
		<9.721, 0.155, 2.049> <9.716, 0.155, 2.270> <9.140, 0.155, 2.642> <9.356, 0.155, 2.689> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.266, -0.002, 2.963> <10.533, -0.002, 3.236> <12.347, -0.002, 3.526> <13.583, -0.002, 3.136> 
		<9.293, 0.045, 2.881> <10.560, 0.045, 3.154> <12.306, 0.045, 3.441> <13.542, 0.045, 3.051> 
		<9.326, 0.127, 2.779> <10.527, 0.127, 3.038> <12.319, 0.127, 3.314> <13.491, 0.127, 2.945> 
		<9.356, 0.155, 2.689> <10.556, 0.155, 2.948> <12.275, 0.155, 3.222> <13.447, 0.155, 2.853> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<13.583, -0.002, 3.136> <17.252, -0.002, 1.981> <23.542, -0.002, 1.339> <25.294, -0.002, -2.085> 
		<13.542, 0.045, 3.051> <17.211, 0.045, 1.896> <23.318, 0.045, 1.336> <25.069, 0.045, -2.089> 
		<13.491, 0.127, 2.945> <16.968, 0.127, 1.850> <23.113, 0.129, 1.153> <24.773, 0.129, -2.093> 
		<13.447, 0.155, 2.853> <16.924, 0.155, 1.758> <22.886, 0.155, 1.150> <24.545, 0.155, -2.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<25.294, -0.002, -2.085> <27.135, -0.002, -5.686> <26.267, -0.002, -12.927> <23.050, -0.002, -15.376> 
		<25.069, 0.045, -2.089> <26.910, 0.045, -5.689> <26.078, 0.045, -12.721> <22.860, 0.045, -15.171> 
		<24.773, 0.129, -2.093> <26.518, 0.129, -5.505> <25.659, 0.129, -12.578> <22.610, 0.129, -14.899> 
		<24.545, 0.155, -2.096> <26.290, 0.155, -5.508> <25.468, 0.155, -12.370> <22.419, 0.155, -14.692> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<15.544, 0.155, -8.949> <15.315, 0.233, -8.616> <14.939, 0.290, -8.202> <14.775, 0.345, -7.828> 
		<17.849, 0.155, -10.330> <17.621, 0.233, -9.996> <16.857, 0.290, -9.350> <16.693, 0.345, -8.976> 
		<20.280, 0.155, -16.320> <19.704, 0.234, -15.695> <19.235, 0.290, -14.633> <18.715, 0.345, -13.958> 
		<22.419, 0.155, -14.692> <21.842, 0.234, -14.067> <21.014, 0.290, -13.279> <20.493, 0.345, -12.604> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<15.544, 0.155, -8.949> <14.763, 0.155, -8.482> <13.312, 0.155, -9.204> <12.515, 0.155, -8.763> 
		<15.315, 0.233, -8.616> <14.534, 0.233, -8.148> <13.235, 0.233, -8.881> <12.438, 0.233, -8.440> 
		<14.939, 0.290, -8.202> <14.289, 0.290, -7.813> <12.943, 0.294, -8.346> <12.265, 0.294, -8.010> 
		<14.775, 0.345, -7.828> <14.126, 0.345, -7.439> <12.935, 0.345, -8.009> <12.256, 0.345, -7.673> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<12.515, 0.155, -8.763> <11.024, 0.155, -7.939> <9.512, 0.155, -6.155> <8.308, 0.155, -4.950> 
		<12.438, 0.233, -8.440> <10.947, 0.233, -7.616> <9.590, 0.194, -6.086> <8.386, 0.194, -4.880> 
		<12.265, 0.294, -8.010> <10.929, 0.294, -7.348> <9.403, 0.291, -5.673> <8.267, 0.291, -4.707> 
		<12.256, 0.345, -7.673> <10.921, 0.345, -7.011> <9.463, 0.345, -5.596> <8.328, 0.345, -4.630> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.308, 0.155, -4.950> <7.877, 0.155, -4.519> <7.349, 0.155, -3.877> <7.085, 0.155, -3.328> 
		<8.386, 0.194, -4.880> <7.956, 0.194, -4.449> <7.462, 0.225, -3.914> <7.198, 0.225, -3.364> 
		<8.267, 0.291, -4.707> <7.949, 0.291, -4.436> <7.419, 0.306, -3.991> <7.301, 0.306, -3.590> 
		<8.328, 0.345, -4.630> <8.010, 0.345, -4.359> <7.549, 0.345, -3.966> <7.431, 0.345, -3.565> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.085, 0.155, -3.328> <6.893, 0.155, -2.926> <7.071, 0.155, -2.240> <6.831, 0.155, -1.865> 
		<7.198, 0.225, -3.364> <7.006, 0.225, -2.962> <7.275, 0.231, -2.260> <7.034, 0.231, -1.885> 
		<7.301, 0.306, -3.590> <7.161, 0.306, -3.121> <7.470, 0.279, -2.364> <7.324, 0.279, -1.896> 
		<7.431, 0.345, -3.565> <7.291, 0.345, -3.095> <7.674, 0.345, -2.403> <7.528, 0.345, -1.935> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.831, 0.155, -1.865> <6.571, 0.155, -1.461> <5.741, 0.155, -1.358> <5.539, 0.155, -0.923> 
		<7.034, 0.231, -1.885> <6.774, 0.231, -1.482> <6.075, 0.256, -1.443> <5.874, 0.256, -1.007> 
		<7.324, 0.279, -1.896> <7.224, 0.279, -1.576> <6.458, 0.256, -1.477> <6.344, 0.256, -1.161> 
		<7.528, 0.345, -1.935> <7.428, 0.345, -1.615> <6.804, 0.345, -1.510> <6.691, 0.345, -1.194> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.539, 0.155, -0.923> <5.336, 0.155, -0.483> <5.387, 0.155, 0.280> <5.648, 0.155, 0.688> 
		<5.874, 0.256, -1.007> <5.670, 0.256, -0.568> <5.720, 0.258, 0.092> <5.980, 0.258, 0.500> 
		<6.344, 0.256, -1.161> <6.214, 0.256, -0.800> <6.279, 0.263, -0.128> <6.442, 0.263, 0.220> 
		<6.691, 0.345, -1.194> <6.560, 0.345, -0.833> <6.640, 0.345, -0.267> <6.803, 0.345, 0.081> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.648, 0.155, 0.688> <5.817, 0.155, 0.952> <6.381, 0.155, 0.760> <6.678, 0.155, 0.861> 
		<5.980, 0.258, 0.500> <6.149, 0.258, 0.764> <6.594, 0.232, 0.604> <6.891, 0.232, 0.705> 
		<6.442, 0.263, 0.220> <6.524, 0.263, 0.396> <6.972, 0.297, 0.340> <7.148, 0.297, 0.425> 
		<6.803, 0.345, 0.081> <6.885, 0.345, 0.257> <7.226, 0.345, 0.247> <7.402, 0.345, 0.332> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.678, 0.155, 0.861> <6.966, 0.155, 0.958> <7.268, 0.155, 1.306> <7.569, 0.155, 1.341> 
		<6.891, 0.232, 0.705> <7.179, 0.232, 0.803> <7.436, 0.232, 1.127> <7.738, 0.232, 1.162> 
		<7.148, 0.297, 0.425> <7.375, 0.297, 0.536> <7.677, 0.296, 0.835> <7.928, 0.296, 0.864> 
		<7.402, 0.345, 0.332> <7.629, 0.345, 0.442> <7.892, 0.345, 0.702> <8.143, 0.345, 0.731> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.569, 0.155, 1.341> <8.113, 0.155, 1.404> <8.866, 0.155, 1.002> <9.386, 0.155, 1.173> 
		<7.738, 0.232, 1.162> <8.281, 0.232, 1.225> <8.943, 0.231, 0.834> <9.463, 0.231, 1.005> 
		<7.928, 0.296, 0.864> <8.380, 0.296, 0.917> <9.086, 0.270, 0.577> <9.519, 0.270, 0.720> 
		<8.143, 0.345, 0.731> <8.595, 0.345, 0.783> <9.221, 0.345, 0.450> <9.654, 0.345, 0.592> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.386, 0.155, 1.173> <9.653, 0.155, 1.261> <9.726, 0.155, 1.768> <9.721, 0.155, 2.049> 
		<9.463, 0.231, 1.005> <9.731, 0.231, 1.093> <9.788, 0.232, 1.555> <9.783, 0.232, 1.836> 
		<9.519, 0.270, 0.720> <9.741, 0.270, 0.793> <9.804, 0.290, 1.272> <9.800, 0.290, 1.506> 
		<9.654, 0.345, 0.592> <9.876, 0.345, 0.665> <9.937, 0.345, 1.086> <9.932, 0.345, 1.320> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.721, 0.155, 2.049> <9.716, 0.155, 2.270> <9.140, 0.155, 2.642> <9.356, 0.155, 2.689> 
		<9.783, 0.232, 1.836> <9.778, 0.232, 2.057> <9.220, 0.232, 2.396> <9.436, 0.232, 2.443> 
		<9.800, 0.290, 1.506> <9.796, 0.290, 1.690> <9.298, 0.291, 2.031> <9.478, 0.291, 2.070> 
		<9.932, 0.345, 1.320> <9.929, 0.345, 1.504> <9.449, 0.345, 1.813> <9.629, 0.345, 1.852> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.356, 0.155, 2.689> <10.556, 0.155, 2.948> <12.275, 0.155, 3.222> <13.447, 0.155, 2.853> 
		<9.436, 0.232, 2.443> <10.637, 0.232, 2.702> <12.152, 0.232, 2.967> <13.324, 0.232, 2.598> 
		<9.478, 0.291, 2.070> <10.477, 0.291, 2.285> <12.126, 0.278, 2.573> <13.100, 0.278, 2.266> 
		<9.629, 0.345, 1.852> <10.627, 0.345, 2.068> <12.057, 0.345, 2.296> <13.031, 0.345, 1.989> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<13.447, 0.155, 2.853> <16.924, 0.155, 1.758> <22.886, 0.155, 1.150> <24.545, 0.155, -2.096> 
		<13.324, 0.232, 2.598> <16.801, 0.232, 1.503> <22.203, 0.233, 1.141> <23.863, 0.233, -2.105> 
		<13.100, 0.278, 2.266> <15.992, 0.278, 1.355> <21.566, 0.285, 0.545> <22.947, 0.285, -2.154> 
		<13.031, 0.345, 1.989> <15.923, 0.345, 1.078> <20.882, 0.345, 0.572> <22.262, 0.345, -2.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<24.545, 0.155, -2.096> <26.290, 0.155, -5.508> <25.468, 0.155, -12.370> <22.419, 0.155, -14.692> 
		<23.863, 0.233, -2.105> <25.607, 0.233, -5.517> <24.891, 0.234, -11.745> <21.842, 0.234, -14.067> 
		<22.947, 0.285, -2.154> <24.398, 0.285, -4.992> <23.550, 0.290, -11.348> <21.014, 0.290, -13.279> 
		<22.262, 0.345, -2.127> <23.714, 0.345, -4.965> <23.029, 0.345, -10.673> <20.493, 0.345, -12.604> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<14.775, 0.345, -7.828> <14.518, 0.431, -7.240> <14.337, 0.496, -6.387> <14.156, 0.619, -5.778> 
		<16.693, 0.345, -8.976> <16.436, 0.431, -8.388> <15.646, 0.496, -7.171> <15.465, 0.619, -6.562> 
		<18.715, 0.345, -13.958> <17.924, 0.429, -12.932> <17.446, 0.493, -11.106> <16.845, 0.619, -9.963> 
		<20.493, 0.345, -12.604> <19.703, 0.429, -11.578> <18.660, 0.493, -10.182> <18.060, 0.619, -9.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<14.775, 0.345, -7.828> <14.126, 0.345, -7.439> <12.935, 0.345, -8.009> <12.256, 0.345, -7.673> 
		<14.518, 0.431, -7.240> <13.868, 0.431, -6.851> <12.919, 0.435, -7.408> <12.241, 0.435, -7.072> 
		<14.337, 0.496, -6.387> <13.893, 0.496, -6.122> <13.213, 0.542, -6.346> <12.715, 0.542, -6.207> 
		<14.156, 0.619, -5.778> <13.712, 0.619, -5.512> <12.934, 0.619, -5.811> <12.436, 0.619, -5.672> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<12.256, 0.345, -7.673> <10.921, 0.345, -7.011> <9.463, 0.345, -5.596> <8.328, 0.345, -4.630> 
		<12.241, 0.435, -7.072> <10.905, 0.435, -6.409> <9.570, 0.441, -5.460> <8.435, 0.441, -4.494> 
		<12.715, 0.542, -6.207> <11.598, 0.542, -5.896> <9.591, 0.571, -5.014> <8.641, 0.571, -4.348> 
		<12.436, 0.619, -5.672> <11.319, 0.619, -5.361> <9.775, 0.619, -4.957> <8.825, 0.619, -4.292> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.328, 0.345, -4.630> <8.010, 0.345, -4.359> <7.549, 0.345, -3.966> <7.431, 0.345, -3.565> 
		<8.435, 0.441, -4.494> <8.117, 0.441, -4.223> <7.936, 0.459, -3.891> <7.817, 0.459, -3.490> 
		<8.641, 0.571, -4.348> <8.327, 0.571, -4.128> <8.357, 0.546, -3.483> <8.262, 0.546, -3.111> 
		<8.825, 0.619, -4.292> <8.511, 0.619, -4.072> <8.751, 0.619, -3.396> <8.656, 0.619, -3.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.431, 0.345, -3.565> <7.291, 0.345, -3.095> <7.674, 0.345, -2.403> <7.528, 0.345, -1.935> 
		<7.817, 0.459, -3.490> <7.678, 0.459, -3.021> <7.906, 0.419, -2.447> <7.761, 0.419, -1.980> 
		<8.262, 0.546, -3.111> <8.191, 0.546, -2.832> <8.199, 0.568, -2.371> <8.037, 0.568, -2.133> 
		<8.656, 0.619, -3.025> <8.585, 0.619, -2.746> <8.441, 0.619, -2.380> <8.279, 0.619, -2.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.528, 0.345, -1.935> <7.428, 0.345, -1.615> <6.804, 0.345, -1.510> <6.691, 0.345, -1.194> 
		<7.761, 0.419, -1.980> <7.661, 0.419, -1.659> <7.012, 0.398, -1.530> <6.898, 0.398, -1.214> 
		<8.037, 0.568, -2.133> <7.801, 0.568, -1.785> <7.252, 0.580, -1.501> <7.134, 0.580, -1.097> 
		<8.279, 0.619, -2.142> <8.043, 0.619, -1.794> <7.464, 0.619, -1.499> <7.346, 0.619, -1.095> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.691, 0.345, -1.194> <6.560, 0.345, -0.833> <6.640, 0.345, -0.267> <6.803, 0.345, 0.081> 
		<6.898, 0.398, -1.214> <6.768, 0.398, -0.853> <6.897, 0.403, -0.366> <7.059, 0.403, -0.018> 
		<7.134, 0.580, -1.097> <7.045, 0.580, -0.793> <7.133, 0.578, -0.204> <7.407, 0.578, -0.046> 
		<7.346, 0.619, -1.095> <7.257, 0.619, -0.791> <7.407, 0.619, -0.253> <7.681, 0.619, -0.095> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.803, 0.345, 0.081> <6.885, 0.345, 0.257> <7.226, 0.345, 0.247> <7.402, 0.345, 0.332> 
		<7.059, 0.403, -0.018> <7.141, 0.403, 0.159> <7.728, 0.439, 0.061> <7.903, 0.439, 0.146> 
		<7.407, 0.578, -0.046> <7.788, 0.578, 0.174> <8.186, 0.538, 0.034> <8.625, 0.538, 0.070> 
		<7.681, 0.619, -0.095> <8.062, 0.619, 0.126> <8.709, 0.619, -0.089> <9.148, 0.619, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.402, 0.345, 0.332> <7.629, 0.345, 0.442> <7.892, 0.345, 0.702> <8.143, 0.345, 0.731> 
		<7.903, 0.439, 0.146> <8.130, 0.439, 0.256> <8.305, 0.438, 0.446> <8.556, 0.438, 0.475> 
		<8.625, 0.538, 0.070> <8.773, 0.538, 0.082> <9.023, 0.542, 0.153> <9.160, 0.542, 0.209> 
		<9.148, 0.619, -0.053> <9.296, 0.619, -0.041> <9.490, 0.619, 0.009> <9.628, 0.619, 0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.143, 0.345, 0.731> <8.595, 0.345, 0.783> <9.221, 0.345, 0.450> <9.654, 0.345, 0.592> 
		<8.556, 0.438, 0.475> <9.008, 0.438, 0.527> <9.355, 0.419, 0.323> <9.788, 0.419, 0.465> 
		<9.160, 0.542, 0.209> <9.347, 0.542, 0.285> <9.844, 0.570, 0.375> <10.036, 0.570, 0.438> 
		<9.628, 0.619, 0.065> <9.815, 0.619, 0.141> <10.029, 0.619, 0.320> <10.221, 0.619, 0.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.654, 0.345, 0.592> <9.876, 0.345, 0.665> <9.937, 0.345, 1.086> <9.932, 0.345, 1.320> 
		<9.788, 0.419, 0.465> <10.010, 0.419, 0.538> <10.154, 0.434, 0.782> <10.150, 0.434, 1.016> 
		<10.036, 0.570, 0.438> <10.216, 0.570, 0.498> <10.380, 0.544, 0.495> <10.511, 0.544, 0.634> 
		<10.221, 0.619, 0.383> <10.401, 0.619, 0.443> <10.719, 0.619, 0.329> <10.850, 0.619, 0.467> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.932, 0.345, 1.320> <9.929, 0.345, 1.504> <9.449, 0.345, 1.813> <9.629, 0.345, 1.852> 
		<10.150, 0.434, 1.016> <10.146, 0.434, 1.199> <9.694, 0.433, 1.459> <9.874, 0.433, 1.498> 
		<10.511, 0.544, 0.634> <10.597, 0.544, 0.725> <10.137, 0.560, 1.012> <10.260, 0.560, 1.039> 
		<10.850, 0.619, 0.467> <10.936, 0.619, 0.559> <10.520, 0.619, 0.804> <10.642, 0.619, 0.830> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.629, 0.345, 1.852> <10.627, 0.345, 2.068> <12.057, 0.345, 2.296> <13.031, 0.345, 1.989> 
		<9.874, 0.433, 1.498> <10.872, 0.433, 1.714> <11.979, 0.420, 1.983> <12.953, 0.420, 1.677> 
		<10.260, 0.560, 1.039> <10.941, 0.560, 1.186> <12.118, 0.563, 1.403> <12.783, 0.563, 1.194> 
		<10.642, 0.619, 0.830> <11.324, 0.619, 0.978> <12.300, 0.619, 1.133> <12.965, 0.619, 0.924> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<13.031, 0.345, 1.989> <15.923, 0.345, 1.078> <20.882, 0.345, 0.572> <22.262, 0.345, -2.127> 
		<12.953, 0.420, 1.677> <15.845, 0.420, 0.766> <19.981, 0.424, 0.608> <21.361, 0.424, -2.092> 
		<12.783, 0.563, 1.194> <14.757, 0.563, 0.572> <19.219, 0.478, -0.036> <20.161, 0.478, -1.879> 
		<12.965, 0.619, 0.924> <14.940, 0.619, 0.302> <18.325, 0.619, -0.043> <19.267, 0.619, -1.886> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<22.262, 0.345, -2.127> <23.714, 0.345, -4.965> <23.029, 0.345, -10.673> <20.493, 0.345, -12.604> 
		<21.361, 0.424, -2.092> <22.813, 0.424, -4.929> <22.239, 0.429, -9.648> <19.703, 0.429, -11.578> 
		<20.161, 0.478, -1.879> <21.152, 0.478, -3.817> <20.392, 0.493, -8.864> <18.660, 0.493, -10.182> 
		<19.267, 0.619, -1.886> <20.258, 0.619, -3.824> <19.791, 0.619, -7.720> <18.060, 0.619, -9.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<10.345, 0.872, -4.011> <11.331, 0.872, -4.614> <12.969, 0.872, -4.704> <14.003, 0.872, -5.220> 
		<10.973, 0.796, -4.509> <11.959, 0.796, -5.112> <13.075, 0.859, -4.860> <14.110, 0.859, -5.376> 
		<12.067, 0.721, -4.964> <12.565, 0.721, -5.103> <13.660, 0.655, -5.334> <14.103, 0.655, -5.600> 
		<12.436, 0.619, -5.672> <12.934, 0.619, -5.811> <13.712, 0.619, -5.512> <14.156, 0.619, -5.778> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<10.345, 0.872, -4.011> <10.345, 0.872, -4.011> <10.345, 0.872, -4.011> <10.345, 0.872, -4.011> 
		<9.963, 0.832, -4.282> <10.591, 0.756, -4.780> <10.591, 0.756, -4.780> <10.973, 0.796, -4.509> 
		<9.261, 0.733, -4.158> <10.211, 0.733, -4.823> <10.950, 0.721, -4.653> <12.067, 0.721, -4.964> 
		<8.825, 0.619, -4.292> <9.775, 0.619, -4.957> <11.319, 0.619, -5.361> <12.436, 0.619, -5.672> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<10.345, 0.872, -4.011> <9.963, 0.832, -4.282> <9.261, 0.733, -4.158> <8.825, 0.619, -4.292> 
		<10.070, 0.872, -3.842> <9.688, 0.832, -4.113> <8.947, 0.733, -3.938> <8.511, 0.619, -4.072> 
		<10.320, 0.872, -3.257> <9.846, 0.820, -3.378> <9.223, 0.706, -3.292> <8.751, 0.619, -3.396> 
		<10.273, 0.872, -2.939> <9.799, 0.820, -3.059> <9.129, 0.706, -2.921> <8.656, 0.619, -3.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<10.345, 0.872, -4.011> <10.070, 0.872, -3.842> <10.320, 0.872, -3.257> <10.273, 0.872, -2.939> 
		<10.847, 0.924, -3.654> <10.573, 0.924, -3.486> <10.666, 0.909, -3.169> <10.618, 0.909, -2.851> 
		<11.231, 0.897, -2.870> <11.156, 0.897, -2.870> <11.098, 0.898, -2.613> <11.033, 0.897, -2.574> 
		<11.562, 0.906, -2.349> <11.487, 0.906, -2.349> <11.377, 0.907, -2.387> <11.312, 0.906, -2.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<10.345, 0.872, -4.011> <10.847, 0.924, -3.654> <11.231, 0.897, -2.870> <11.562, 0.906, -2.349> 
		<11.331, 0.872, -4.614> <11.833, 0.924, -4.257> <11.306, 0.897, -2.870> <11.637, 0.906, -2.349> 
		<12.969, 0.872, -4.704> <12.359, 0.946, -3.812> <12.360, 0.897, -3.238> <11.738, 0.906, -2.351> 
		<14.003, 0.872, -5.220> <13.393, 0.946, -4.328> <12.435, 0.896, -3.236> <11.812, 0.906, -2.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<14.156, 0.619, -5.778> <14.103, 0.655, -5.600> <14.110, 0.859, -5.376> <14.003, 0.872, -5.220> 
		<15.465, 0.619, -6.562> <15.412, 0.655, -6.383> <15.385, 0.859, -6.012> <15.278, 0.872, -5.856> 
		<16.845, 0.619, -9.963> <16.672, 0.655, -9.633> <17.215, 0.919, -7.100> <16.943, 0.936, -6.844> 
		<18.060, 0.619, -9.039> <17.886, 0.655, -8.709> <18.252, 0.855, -8.076> <17.980, 0.872, -7.820> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.656, 0.619, -3.025> <8.585, 0.619, -2.746> <8.441, 0.619, -2.380> <8.279, 0.619, -2.142> 
		<9.129, 0.706, -2.921> <9.058, 0.706, -2.642> <8.968, 0.729, -2.401> <8.806, 0.729, -2.163> 
		<9.799, 0.820, -3.059> <9.758, 0.820, -2.782> <9.587, 0.796, -2.337> <9.521, 0.796, -2.065> 
		<10.273, 0.872, -2.939> <10.232, 0.872, -2.662> <10.119, 0.872, -2.304> <10.053, 0.872, -2.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.279, 0.619, -2.142> <8.043, 0.619, -1.794> <7.464, 0.619, -1.499> <7.346, 0.619, -1.095> 
		<8.806, 0.729, -2.163> <8.570, 0.729, -1.814> <8.127, 0.740, -1.491> <8.009, 0.740, -1.087> 
		<9.521, 0.796, -2.065> <9.378, 0.796, -1.804> <8.883, 0.825, -1.251> <8.937, 0.825, -0.958> 
		<10.053, 0.872, -2.032> <9.910, 0.872, -1.771> <9.524, 0.872, -1.454> <9.578, 0.872, -1.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.346, 0.619, -1.095> <7.257, 0.619, -0.791> <7.407, 0.619, -0.253> <7.681, 0.619, -0.095> 
		<8.009, 0.740, -1.087> <7.920, 0.740, -0.783> <8.194, 0.737, -0.394> <8.468, 0.737, -0.235> 
		<8.937, 0.825, -0.958> <8.989, 0.825, -0.673> <9.365, 0.816, -0.298> <9.619, 0.816, -0.158> 
		<9.578, 0.872, -1.161> <9.631, 0.872, -0.876> <10.071, 0.872, -0.688> <10.325, 0.872, -0.548> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.681, 0.619, -0.095> <8.062, 0.619, 0.126> <8.709, 0.619, -0.089> <9.148, 0.619, -0.053> 
		<8.468, 0.737, -0.235> <8.849, 0.737, -0.015> <9.214, 0.697, -0.208> <9.653, 0.697, -0.172> 
		<9.619, 0.816, -0.158> <9.753, 0.816, -0.085> <10.177, 0.796, -0.389> <10.324, 0.796, -0.347> 
		<10.325, 0.872, -0.548> <10.459, 0.872, -0.474> <10.681, 0.872, -0.516> <10.828, 0.872, -0.474> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.148, 0.619, -0.053> <9.296, 0.619, -0.041> <9.490, 0.619, 0.009> <9.628, 0.619, 0.065> 
		<9.653, 0.697, -0.172> <9.801, 0.697, -0.159> <9.990, 0.701, -0.145> <10.127, 0.701, -0.089> 
		<10.324, 0.796, -0.347> <10.485, 0.796, -0.301> <10.866, 0.817, 0.094> <11.020, 0.817, 0.160> 
		<10.828, 0.872, -0.474> <10.989, 0.872, -0.427> <11.189, 0.872, -0.321> <11.343, 0.872, -0.255> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.628, 0.619, 0.065> <9.815, 0.619, 0.141> <10.029, 0.619, 0.320> <10.221, 0.619, 0.383> 
		<10.127, 0.701, -0.089> <10.314, 0.701, -0.013> <10.451, 0.730, 0.194> <10.643, 0.730, 0.257> 
		<11.020, 0.817, 0.160> <11.116, 0.817, 0.234> <11.334, 0.826, 0.345> <11.446, 0.826, 0.390> 
		<11.343, 0.872, -0.255> <11.439, 0.872, -0.181> <11.549, 0.872, -0.053> <11.661, 0.872, -0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<10.221, 0.619, 0.383> <10.401, 0.619, 0.443> <10.719, 0.619, 0.329> <10.850, 0.619, 0.467> 
		<10.643, 0.730, 0.257> <10.823, 0.730, 0.316> <11.126, 0.708, 0.129> <11.257, 0.708, 0.267> 
		<11.446, 0.826, 0.390> <11.638, 0.826, 0.467> <11.966, 0.823, 0.574> <12.172, 0.823, 0.571> 
		<11.661, 0.872, -0.008> <11.853, 0.872, 0.069> <12.127, 0.872, 0.143> <12.334, 0.872, 0.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<10.850, 0.619, 0.467> <10.936, 0.619, 0.559> <10.520, 0.619, 0.804> <10.642, 0.619, 0.830> 
		<11.257, 0.708, 0.267> <11.343, 0.708, 0.359> <11.196, 0.722, 0.435> <11.319, 0.722, 0.462> 
		<12.172, 0.823, 0.571> <12.400, 0.823, 0.568> <12.126, 0.796, 0.295> <12.345, 0.796, 0.231> 
		<12.334, 0.872, 0.141> <12.562, 0.872, 0.138> <12.856, 0.872, 0.038> <13.074, 0.872, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<10.642, 0.619, 0.830> <11.324, 0.619, 0.978> <12.300, 0.619, 1.133> <12.965, 0.619, 0.924> 
		<11.319, 0.722, 0.462> <12.000, 0.722, 0.609> <12.688, 0.737, 0.558> <13.354, 0.737, 0.348> 
		<12.345, 0.796, 0.231> <12.854, 0.796, 0.082> <14.510, 0.809, 0.268> <15.008, 0.809, 0.086> 
		<13.074, 0.872, -0.026> <13.584, 0.872, -0.175> <14.260, 0.872, -0.388> <14.758, 0.872, -0.569> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<12.965, 0.619, 0.924> <14.940, 0.619, 0.302> <18.325, 0.619, -0.043> <19.267, 0.619, -1.886> 
		<13.354, 0.737, 0.348> <15.328, 0.737, -0.273> <18.173, 0.643, -0.044> <19.115, 0.643, -1.887> 
		<15.008, 0.809, 0.086> <16.261, 0.809, -0.371> <18.523, 0.866, -0.925> <19.064, 0.866, -2.144> 
		<14.758, 0.872, -0.569> <16.011, 0.872, -1.026> <18.370, 0.872, -0.935> <18.911, 0.872, -2.153> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<19.267, 0.619, -1.886> <20.258, 0.619, -3.824> <19.791, 0.619, -7.720> <18.060, 0.619, -9.039> 
		<19.115, 0.643, -1.887> <20.106, 0.643, -3.825> <19.618, 0.655, -7.391> <17.886, 0.655, -8.709> 
		<19.064, 0.866, -2.144> <19.764, 0.866, -3.718> <18.531, 0.855, -6.376> <18.252, 0.855, -8.076> 
		<18.911, 0.872, -2.153> <19.610, 0.872, -3.728> <18.259, 0.872, -6.120> <17.980, 0.872, -7.820> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<11.812, 0.906, -2.099> <11.797, 0.907, -2.172> <11.769, 0.907, -2.287> <11.812, 0.906, -2.349> 
		<11.745, 0.907, -2.131> <11.729, 0.908, -2.204> <11.694, 0.907, -2.289> <11.738, 0.906, -2.351> 
		<11.637, 0.906, -2.099> <11.634, 0.907, -2.174> <11.678, 0.907, -2.285> <11.637, 0.906, -2.349> 
		<11.562, 0.906, -2.099> <11.559, 0.907, -2.174> <11.603, 0.907, -2.285> <11.562, 0.906, -2.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<11.812, 0.906, -2.099> <11.745, 0.907, -2.131> <11.637, 0.906, -2.099> <11.562, 0.906, -2.099> 
		<11.954, 0.897, -1.423> <11.886, 0.898, -1.456> <11.664, 0.897, -1.471> <11.589, 0.897, -1.471> 
		<12.575, 0.944, -0.502> <12.368, 0.944, -0.499> <12.150, 0.935, -0.481> <11.958, 0.935, -0.557> 
		<12.334, 0.872, 0.141> <12.127, 0.872, 0.143> <11.853, 0.872, 0.069> <11.661, 0.872, -0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<11.812, 0.906, -2.099> <12.711, 0.896, -1.669> <14.405, 0.960, -1.496> <14.758, 0.872, -0.569> 
		<11.797, 0.907, -2.172> <12.695, 0.897, -1.742> <15.658, 0.960, -1.953> <16.011, 0.872, -1.026> 
		<11.769, 0.907, -2.287> <13.899, 0.897, -2.231> <16.245, 0.954, -1.067> <18.370, 0.872, -0.935> 
		<11.812, 0.906, -2.349> <13.942, 0.896, -2.292> <16.786, 0.954, -2.285> <18.911, 0.872, -2.153> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<11.812, 0.906, -2.099> <11.954, 0.897, -1.423> <12.575, 0.944, -0.502> <12.334, 0.872, 0.141> 
		<12.711, 0.896, -1.669> <12.852, 0.887, -0.994> <12.803, 0.944, -0.505> <12.562, 0.872, 0.138> 
		<14.405, 0.960, -1.496> <13.906, 0.960, -1.314> <13.365, 0.872, -0.111> <12.856, 0.872, 0.038> 
		<14.758, 0.872, -0.569> <14.260, 0.872, -0.388> <13.584, 0.872, -0.175> <13.074, 0.872, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<11.812, 0.906, -2.349> <13.942, 0.896, -2.292> <16.786, 0.954, -2.285> <18.911, 0.872, -2.153> 
		<12.435, 0.896, -3.236> <14.564, 0.886, -3.179> <17.486, 0.954, -3.859> <19.610, 0.872, -3.728> 
		<13.393, 0.946, -4.328> <14.668, 0.946, -4.964> <17.222, 0.936, -5.144> <18.259, 0.872, -6.120> 
		<14.003, 0.872, -5.220> <15.278, 0.872, -5.856> <16.943, 0.936, -6.844> <17.980, 0.872, -7.820> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<11.562, 0.906, -2.349> <11.487, 0.906, -2.349> <11.377, 0.907, -2.387> <11.312, 0.906, -2.349> 
		<11.603, 0.907, -2.285> <11.528, 0.907, -2.285> <11.435, 0.909, -2.340> <11.371, 0.908, -2.302> 
		<11.559, 0.907, -2.174> <11.484, 0.907, -2.174> <11.358, 0.909, -2.232> <11.311, 0.907, -2.174> 
		<11.562, 0.906, -2.099> <11.487, 0.906, -2.099> <11.359, 0.907, -2.157> <11.312, 0.906, -2.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<11.562, 0.906, -2.099> <11.487, 0.906, -2.099> <11.359, 0.907, -2.157> <11.312, 0.906, -2.099> 
		<11.589, 0.897, -1.471> <11.514, 0.897, -1.471> <11.367, 0.898, -1.604> <11.321, 0.897, -1.546> 
		<11.958, 0.935, -0.557> <11.846, 0.935, -0.602> <11.777, 0.929, -0.615> <11.681, 0.929, -0.690> 
		<11.661, 0.872, -0.008> <11.549, 0.872, -0.053> <11.439, 0.872, -0.181> <11.343, 0.872, -0.255> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<11.312, 0.906, -2.099> <11.311, 0.907, -2.174> <11.371, 0.908, -2.302> <11.312, 0.906, -2.349> 
		<10.969, 0.897, -1.667> <10.967, 0.898, -1.742> <10.830, 0.899, -1.978> <10.771, 0.897, -2.025> 
		<10.807, 0.910, -0.814> <10.553, 0.910, -0.953> <10.230, 0.915, -1.066> <10.178, 0.915, -1.351> 
		<10.325, 0.872, -0.548> <10.071, 0.872, -0.688> <9.631, 0.872, -0.876> <9.578, 0.872, -1.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<11.312, 0.906, -2.099> <10.969, 0.897, -1.667> <10.807, 0.910, -0.814> <10.325, 0.872, -0.548> 
		<11.321, 0.897, -1.546> <10.977, 0.887, -1.114> <10.941, 0.910, -0.740> <10.459, 0.872, -0.474> 
		<11.681, 0.929, -0.690> <11.527, 0.929, -0.755> <10.843, 0.872, -0.469> <10.681, 0.872, -0.516> 
		<11.343, 0.872, -0.255> <11.189, 0.872, -0.321> <10.989, 0.872, -0.427> <10.828, 0.872, -0.474> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<11.312, 0.906, -2.349> <11.033, 0.897, -2.574> <10.618, 0.909, -2.851> <10.273, 0.872, -2.939> 
		<10.771, 0.897, -2.025> <10.492, 0.887, -2.250> <10.578, 0.909, -2.574> <10.232, 0.872, -2.662> 
		<10.178, 0.915, -1.351> <10.124, 0.915, -1.643> <9.976, 0.872, -2.043> <10.119, 0.872, -2.304> 
		<9.578, 0.872, -1.161> <9.524, 0.872, -1.454> <9.910, 0.872, -1.771> <10.053, 0.872, -2.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.685, 0.044, -15.828> <-3.708, 0.101, -15.662> <-3.738, 0.200, -15.447> <-3.761, 0.234, -15.275> 
		<-1.619, 0.044, -14.489> <-1.642, 0.101, -14.324> <-1.766, 0.200, -14.184> <-1.790, 0.234, -14.013> 
		<-1.546, 0.044, -10.482> <-1.561, 0.101, -10.447> <-1.581, 0.184, -10.270> <-1.615, 0.234, -10.236> 
		<-0.938, 0.044, -8.097> <-0.953, 0.101, -8.062> <-0.954, 0.184, -8.014> <-0.987, 0.234, -7.980> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.685, 0.044, -15.828> <-5.729, 0.044, -17.152> <-9.935, 0.044, -16.715> <-11.772, 0.044, -15.116> 
		<-3.708, 0.101, -15.662> <-5.752, 0.101, -16.986> <-9.804, 0.101, -16.563> <-11.641, 0.101, -14.964> 
		<-3.738, 0.200, -15.447> <-5.658, 0.200, -16.678> <-9.749, 0.200, -16.262> <-11.470, 0.200, -14.765> 
		<-3.761, 0.234, -15.275> <-5.682, 0.234, -16.506> <-9.615, 0.234, -16.106> <-11.336, 0.234, -14.609> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.772, 0.044, -15.116> <-12.864, 0.044, -14.165> <-9.615, 0.044, -12.427> <-9.178, 0.044, -11.047> 
		<-11.641, 0.101, -14.964> <-12.733, 0.101, -14.013> <-9.534, 0.101, -12.352> <-9.096, 0.101, -10.972> 
		<-11.470, 0.200, -14.765> <-12.493, 0.200, -13.874> <-9.404, 0.198, -12.171> <-8.994, 0.198, -10.878> 
		<-11.336, 0.234, -14.609> <-12.359, 0.234, -13.718> <-9.316, 0.234, -12.090> <-8.906, 0.234, -10.797> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.178, 0.044, -11.047> <-8.790, 0.044, -9.825> <-9.641, 0.044, -7.949> <-9.127, 0.044, -6.774> 
		<-9.096, 0.101, -10.972> <-8.709, 0.101, -9.750> <-9.560, 0.101, -7.955> <-9.046, 0.101, -6.781> 
		<-8.994, 0.198, -10.878> <-8.631, 0.198, -9.734> <-9.431, 0.196, -7.888> <-8.950, 0.196, -6.789> 
		<-8.906, 0.234, -10.797> <-8.544, 0.234, -9.653> <-9.340, 0.234, -7.896> <-8.859, 0.234, -6.796> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.127, 0.044, -6.774> <-8.787, 0.044, -5.998> <-7.285, 0.044, -5.950> <-6.685, 0.044, -5.350> 
		<-9.046, 0.101, -6.781> <-8.707, 0.101, -6.004> <-7.251, 0.101, -5.983> <-6.651, 0.101, -5.384> 
		<-8.950, 0.196, -6.789> <-8.632, 0.196, -6.061> <-7.177, 0.191, -5.981> <-6.616, 0.191, -5.419> 
		<-8.859, 0.234, -6.796> <-8.540, 0.234, -6.068> <-7.134, 0.234, -6.024> <-6.572, 0.234, -5.462> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.685, 0.044, -5.350> <-6.246, 0.044, -4.911> <-6.287, 0.044, -3.879> <-5.821, 0.044, -3.468> 
		<-6.651, 0.101, -5.384> <-6.212, 0.101, -4.944> <-6.270, 0.101, -3.948> <-5.803, 0.101, -3.538> 
		<-6.616, 0.191, -5.419> <-6.204, 0.191, -5.008> <-6.220, 0.195, -4.003> <-5.783, 0.195, -3.619> 
		<-6.572, 0.234, -5.462> <-6.161, 0.234, -5.050> <-6.199, 0.234, -4.084> <-5.762, 0.234, -3.699> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.821, 0.044, -3.468> <-5.324, 0.044, -3.032> <-4.370, 0.044, -2.940> <-3.735, 0.044, -2.756> 
		<-5.803, 0.101, -3.538> <-5.307, 0.101, -3.101> <-4.393, 0.101, -3.023> <-3.758, 0.101, -2.839> 
		<-5.783, 0.195, -3.619> <-5.318, 0.195, -3.210> <-4.381, 0.197, -3.105> <-3.784, 0.197, -2.940> 
		<-5.762, 0.234, -3.699> <-5.297, 0.234, -3.290> <-4.406, 0.234, -3.197> <-3.809, 0.234, -3.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.735, 0.044, -2.756> <-3.444, 0.044, -2.672> <-2.978, 0.044, -2.387> <-2.741, 0.044, -2.576> 
		<-3.758, 0.101, -2.839> <-3.466, 0.101, -2.755> <-2.969, 0.101, -2.471> <-2.732, 0.101, -2.660> 
		<-3.784, 0.197, -2.940> <-3.463, 0.197, -2.851> <-2.919, 0.204, -2.555> <-2.664, 0.204, -2.771> 
		<-3.809, 0.234, -3.032> <-3.488, 0.234, -2.943> <-2.966, 0.234, -2.640> <-2.711, 0.234, -2.856> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.741, 0.044, -2.576> <-2.390, 0.044, -2.857> <-2.475, 0.044, -3.614> <-2.210, 0.044, -3.977> 
		<-2.732, 0.101, -2.660> <-2.381, 0.101, -2.941> <-2.549, 0.101, -3.674> <-2.284, 0.101, -4.037> 
		<-2.664, 0.204, -2.771> <-2.357, 0.204, -3.031> <-2.581, 0.175, -3.753> <-2.391, 0.175, -4.109> 
		<-2.711, 0.234, -2.856> <-2.403, 0.234, -3.116> <-2.647, 0.234, -3.820> <-2.457, 0.234, -4.176> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.210, 0.044, -3.977> <-2.052, 0.044, -4.192> <-1.551, 0.044, -4.152> <-1.419, 0.044, -4.384> 
		<-2.284, 0.101, -4.037> <-2.127, 0.101, -4.252> <-1.653, 0.101, -4.227> <-1.522, 0.101, -4.459> 
		<-2.391, 0.175, -4.109> <-2.273, 0.175, -4.329> <-1.804, 0.176, -4.353> <-1.660, 0.176, -4.558> 
		<-2.457, 0.234, -4.176> <-2.339, 0.234, -4.396> <-1.905, 0.234, -4.430> <-1.761, 0.234, -4.634> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.419, 0.044, -4.384> <-1.197, 0.044, -4.775> <-1.199, 0.044, -5.412> <-1.141, 0.044, -5.859> 
		<-1.522, 0.101, -4.459> <-1.299, 0.101, -4.851> <-1.211, 0.101, -5.452> <-1.153, 0.101, -5.899> 
		<-1.660, 0.176, -4.558> <-1.405, 0.176, -4.920> <-1.241, 0.175, -5.562> <-1.141, 0.175, -5.993> 
		<-1.761, 0.234, -4.634> <-1.506, 0.234, -4.997> <-1.280, 0.234, -5.560> <-1.180, 0.234, -5.992> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.141, 0.044, -5.859> <-1.055, 0.044, -6.527> <-0.771, 0.044, -7.444> <-0.938, 0.044, -8.097> 
		<-1.153, 0.101, -5.899> <-1.066, 0.101, -6.567> <-0.786, 0.101, -7.409> <-0.953, 0.101, -8.062> 
		<-1.141, 0.175, -5.993> <-1.006, 0.175, -6.577> <-0.794, 0.184, -7.437> <-0.954, 0.184, -8.014> 
		<-1.180, 0.234, -5.992> <-1.045, 0.234, -6.576> <-0.827, 0.234, -7.403> <-0.987, 0.234, -7.980> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.761, 0.234, -15.275> <-3.826, 0.326, -14.808> <-3.914, 0.416, -14.178> <-3.980, 0.465, -13.704> 
		<-1.790, 0.234, -14.013> <-1.855, 0.326, -13.545> <-2.242, 0.416, -13.169> <-2.308, 0.465, -12.695> 
		<-1.615, 0.234, -10.236> <-1.669, 0.314, -10.181> <-1.719, 0.443, -9.687> <-1.826, 0.465, -9.665> 
		<-0.987, 0.234, -7.980> <-1.042, 0.314, -7.925> <-1.114, 0.443, -7.830> <-1.222, 0.465, -7.808> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.761, 0.234, -15.275> <-5.682, 0.234, -16.506> <-9.615, 0.234, -16.106> <-11.336, 0.234, -14.609> 
		<-3.826, 0.326, -14.808> <-5.747, 0.326, -16.038> <-9.246, 0.327, -15.676> <-10.966, 0.327, -14.178> 
		<-3.914, 0.416, -14.178> <-5.491, 0.416, -15.130> <-9.080, 0.416, -14.810> <-10.470, 0.416, -13.600> 
		<-3.980, 0.465, -13.704> <-5.557, 0.465, -14.656> <-8.707, 0.465, -14.375> <-10.096, 0.465, -13.166> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.336, 0.234, -14.609> <-12.359, 0.234, -13.718> <-9.316, 0.234, -12.090> <-8.906, 0.234, -10.797> 
		<-10.966, 0.327, -14.178> <-11.989, 0.327, -13.288> <-9.089, 0.325, -11.881> <-8.679, 0.325, -10.589> 
		<-10.470, 0.416, -13.600> <-11.296, 0.416, -12.881> <-8.700, 0.415, -11.347> <-8.369, 0.415, -10.304> 
		<-10.096, 0.465, -13.166> <-10.922, 0.465, -12.447> <-8.466, 0.465, -11.132> <-8.135, 0.465, -10.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.906, 0.234, -10.797> <-8.544, 0.234, -9.653> <-9.340, 0.234, -7.896> <-8.859, 0.234, -6.796> 
		<-8.679, 0.325, -10.589> <-8.316, 0.325, -9.444> <-9.119, 0.324, -7.913> <-8.637, 0.324, -6.814> 
		<-8.369, 0.415, -10.304> <-8.076, 0.415, -9.379> <-8.718, 0.415, -7.726> <-8.330, 0.415, -6.838> 
		<-8.135, 0.465, -10.088> <-7.842, 0.465, -9.164> <-8.485, 0.465, -7.745> <-8.096, 0.465, -6.857> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.859, 0.234, -6.796> <-8.540, 0.234, -6.068> <-7.134, 0.234, -6.024> <-6.572, 0.234, -5.462> 
		<-8.637, 0.324, -6.814> <-8.319, 0.324, -6.086> <-7.044, 0.320, -6.112> <-6.483, 0.320, -5.550> 
		<-8.330, 0.415, -6.838> <-8.073, 0.415, -6.251> <-6.805, 0.413, -6.133> <-6.352, 0.413, -5.679> 
		<-8.096, 0.465, -6.857> <-7.839, 0.465, -6.269> <-6.703, 0.465, -6.233> <-6.250, 0.465, -5.780> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.572, 0.234, -5.462> <-6.161, 0.234, -5.050> <-6.199, 0.234, -4.084> <-5.762, 0.234, -3.699> 
		<-6.483, 0.320, -5.550> <-6.071, 0.320, -5.139> <-6.151, 0.323, -4.273> <-5.714, 0.323, -3.889> 
		<-6.352, 0.413, -5.679> <-6.019, 0.413, -5.347> <-6.000, 0.415, -4.464> <-5.647, 0.415, -4.154> 
		<-6.250, 0.465, -5.780> <-5.917, 0.465, -5.448> <-5.949, 0.465, -4.667> <-5.596, 0.465, -4.357> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.762, 0.234, -3.699> <-5.297, 0.234, -3.290> <-4.406, 0.234, -3.197> <-3.809, 0.234, -3.032> 
		<-5.714, 0.323, -3.889> <-5.249, 0.323, -3.480> <-4.467, 0.324, -3.426> <-3.870, 0.324, -3.261> 
		<-5.647, 0.415, -4.154> <-5.271, 0.415, -3.824> <-4.438, 0.415, -3.705> <-3.954, 0.415, -3.578> 
		<-5.596, 0.465, -4.357> <-5.220, 0.465, -4.026> <-4.502, 0.465, -3.945> <-4.018, 0.465, -3.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.809, 0.234, -3.032> <-3.488, 0.234, -2.943> <-2.966, 0.234, -2.640> <-2.711, 0.234, -2.856> 
		<-3.870, 0.324, -3.261> <-3.549, 0.324, -3.172> <-3.129, 0.337, -2.936> <-2.874, 0.337, -3.151> 
		<-3.954, 0.415, -3.578> <-3.776, 0.415, -3.531> <-3.397, 0.406, -3.397> <-3.230, 0.406, -3.477> 
		<-4.018, 0.465, -3.818> <-3.840, 0.465, -3.771> <-3.570, 0.465, -3.700> <-3.403, 0.465, -3.779> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.711, 0.234, -2.856> <-2.403, 0.234, -3.116> <-2.647, 0.234, -3.820> <-2.457, 0.234, -4.176> 
		<-2.874, 0.337, -3.151> <-2.566, 0.337, -3.412> <-2.724, 0.302, -3.898> <-2.534, 0.302, -4.253> 
		<-3.230, 0.406, -3.477> <-2.963, 0.406, -3.605> <-2.821, 0.437, -4.157> <-2.605, 0.437, -4.360> 
		<-3.403, 0.465, -3.779> <-3.136, 0.465, -3.908> <-2.900, 0.465, -4.255> <-2.684, 0.465, -4.457> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.457, 0.234, -4.176> <-2.339, 0.234, -4.396> <-1.905, 0.234, -4.430> <-1.761, 0.234, -4.634> 
		<-2.534, 0.302, -4.253> <-2.416, 0.302, -4.474> <-2.025, 0.303, -4.521> <-1.881, 0.303, -4.726> 
		<-2.605, 0.437, -4.360> <-2.448, 0.437, -4.507> <-2.173, 0.430, -4.687> <-2.029, 0.430, -4.847> 
		<-2.684, 0.465, -4.457> <-2.527, 0.465, -4.604> <-2.302, 0.465, -4.786> <-2.158, 0.465, -4.946> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.761, 0.234, -4.634> <-1.506, 0.234, -4.997> <-1.280, 0.234, -5.560> <-1.180, 0.234, -5.992> 
		<-1.881, 0.303, -4.726> <-1.627, 0.303, -5.088> <-1.341, 0.325, -5.558> <-1.241, 0.325, -5.989> 
		<-2.029, 0.430, -4.847> <-1.794, 0.430, -5.105> <-1.429, 0.443, -5.488> <-1.320, 0.443, -5.820> 
		<-2.158, 0.465, -4.946> <-1.924, 0.465, -5.204> <-1.532, 0.465, -5.516> <-1.424, 0.465, -5.848> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.180, 0.234, -5.992> <-1.045, 0.234, -6.576> <-0.827, 0.234, -7.403> <-0.987, 0.234, -7.980> 
		<-1.241, 0.325, -5.989> <-1.106, 0.325, -6.573> <-0.881, 0.314, -7.348> <-1.042, 0.314, -7.925> 
		<-1.320, 0.443, -5.820> <-1.137, 0.443, -6.382> <-0.932, 0.443, -7.267> <-1.114, 0.443, -7.830> 
		<-1.424, 0.465, -5.848> <-1.240, 0.465, -6.410> <-1.039, 0.465, -7.246> <-1.222, 0.465, -7.808> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.980, 0.465, -13.704> <-4.090, 0.549, -12.912> <-4.253, 0.633, -11.856> <-4.348, 0.676, -11.059> 
		<-2.308, 0.465, -12.695> <-2.418, 0.549, -11.903> <-3.318, 0.633, -11.250> <-3.413, 0.676, -10.453> 
		<-1.826, 0.465, -9.665> <-2.377, 0.581, -9.556> <-2.996, 0.625, -8.916> <-3.478, 0.676, -8.609> 
		<-1.222, 0.465, -7.808> <-1.772, 0.581, -7.699> <-2.623, 0.625, -7.866> <-3.105, 0.676, -7.559> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.980, 0.465, -13.704> <-5.557, 0.465, -14.656> <-8.707, 0.465, -14.375> <-10.096, 0.465, -13.166> 
		<-4.090, 0.549, -12.912> <-5.667, 0.549, -13.864> <-8.082, 0.549, -13.647> <-9.471, 0.549, -12.438> 
		<-4.253, 0.633, -11.856> <-5.179, 0.633, -12.455> <-7.879, 0.637, -12.119> <-8.710, 0.637, -11.395> 
		<-4.348, 0.676, -11.059> <-5.273, 0.676, -11.658> <-7.178, 0.676, -11.460> <-8.009, 0.676, -10.736> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.096, 0.465, -13.166> <-10.922, 0.465, -12.447> <-8.466, 0.465, -11.132> <-8.135, 0.465, -10.088> 
		<-9.471, 0.549, -12.438> <-10.297, 0.549, -11.719> <-8.078, 0.548, -10.776> <-7.747, 0.548, -9.732> 
		<-8.710, 0.637, -11.395> <-9.205, 0.637, -10.965> <-6.813, 0.713, -9.008> <-6.931, 0.514, -8.395> 
		<-8.009, 0.676, -10.736> <-8.504, 0.676, -10.306> <-6.716, 0.875, -9.507> <-6.835, 0.676, -8.894> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.135, 0.465, -10.088> <-7.842, 0.465, -9.164> <-8.485, 0.465, -7.745> <-8.096, 0.465, -6.857> 
		<-7.747, 0.548, -9.732> <-7.454, 0.548, -8.808> <-8.103, 0.548, -7.776> <-7.714, 0.548, -6.888> 
		<-6.931, 0.514, -8.395> <-6.924, 0.514, -7.815> <-7.402, 0.644, -7.336> <-7.170, 0.644, -6.804> 
		<-6.835, 0.676, -8.894> <-6.828, 0.676, -8.314> <-7.044, 0.676, -7.492> <-6.812, 0.676, -6.960> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.096, 0.465, -6.857> <-7.839, 0.465, -6.269> <-6.703, 0.465, -6.233> <-6.250, 0.465, -5.780> 
		<-7.714, 0.548, -6.888> <-7.457, 0.548, -6.300> <-6.544, 0.547, -6.390> <-6.091, 0.547, -5.936> 
		<-7.170, 0.644, -6.804> <-7.016, 0.644, -6.452> <-6.102, 0.650, -6.386> <-5.830, 0.650, -6.114> 
		<-6.812, 0.676, -6.960> <-6.658, 0.676, -6.608> <-5.978, 0.676, -6.587> <-5.707, 0.676, -6.315> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.250, 0.465, -5.780> <-5.917, 0.465, -5.448> <-5.949, 0.465, -4.667> <-5.596, 0.465, -4.357> 
		<-6.091, 0.547, -5.936> <-5.759, 0.547, -5.604> <-5.865, 0.548, -4.995> <-5.512, 0.548, -4.685> 
		<-5.830, 0.650, -6.114> <-5.631, 0.650, -5.915> <-5.311, 0.669, -5.397> <-5.296, 0.639, -5.117> 
		<-5.707, 0.676, -6.315> <-5.508, 0.676, -6.116> <-5.331, 0.706, -5.742> <-5.315, 0.676, -5.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.596, 0.465, -4.357> <-5.220, 0.465, -4.026> <-4.502, 0.465, -3.945> <-4.018, 0.465, -3.818> 
		<-5.512, 0.548, -4.685> <-5.137, 0.548, -4.354> <-4.607, 0.548, -4.339> <-4.123, 0.548, -4.211> 
		<-5.296, 0.639, -5.117> <-5.012, 0.639, -5.021> <-4.577, 0.648, -4.811> <-4.288, 0.648, -4.735> 
		<-5.315, 0.676, -5.463> <-5.032, 0.676, -5.366> <-4.660, 0.676, -5.217> <-4.371, 0.676, -5.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.018, 0.465, -3.818> <-3.840, 0.465, -3.771> <-3.570, 0.465, -3.700> <-3.403, 0.465, -3.779> 
		<-4.123, 0.548, -4.211> <-3.944, 0.548, -4.164> <-3.787, 0.540, -4.080> <-3.620, 0.540, -4.160> 
		<-4.288, 0.648, -4.735> <-4.181, 0.648, -4.706> <-3.966, 0.647, -4.623> <-3.879, 0.647, -4.692> 
		<-4.371, 0.676, -5.141> <-4.264, 0.676, -5.113> <-4.089, 0.676, -5.049> <-4.003, 0.676, -5.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.403, 0.465, -3.779> <-3.136, 0.465, -3.908> <-2.900, 0.465, -4.255> <-2.684, 0.465, -4.457> 
		<-3.620, 0.540, -4.160> <-3.353, 0.540, -4.288> <-3.194, 0.572, -4.619> <-2.978, 0.572, -4.822> 
		<-3.879, 0.647, -4.692> <-3.725, 0.647, -4.815> <-3.478, 0.613, -5.150> <-3.381, 0.613, -5.323> 
		<-4.003, 0.676, -5.118> <-3.848, 0.676, -5.241> <-3.777, 0.676, -5.521> <-3.680, 0.676, -5.693> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.684, 0.465, -4.457> <-2.527, 0.465, -4.604> <-2.302, 0.465, -4.786> <-2.158, 0.465, -4.946> 
		<-2.978, 0.572, -4.822> <-2.821, 0.572, -4.969> <-2.663, 0.564, -5.063> <-2.519, 0.564, -5.223> 
		<-3.381, 0.613, -5.323> <-3.291, 0.613, -5.378> <-3.141, 0.642, -5.424> <-3.089, 0.642, -5.516> 
		<-3.680, 0.676, -5.693> <-3.590, 0.676, -5.749> <-3.433, 0.676, -5.786> <-3.381, 0.676, -5.878> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.158, 0.465, -4.946> <-1.924, 0.465, -5.204> <-1.532, 0.465, -5.516> <-1.424, 0.465, -5.848> 
		<-2.519, 0.564, -5.223> <-2.285, 0.564, -5.481> <-2.075, 0.584, -5.665> <-1.966, 0.584, -5.997> 
		<-3.089, 0.642, -5.516> <-2.987, 0.642, -5.697> <-2.772, 0.634, -5.996> <-2.738, 0.634, -6.201> 
		<-3.381, 0.676, -5.878> <-3.278, 0.676, -6.058> <-3.230, 0.676, -6.340> <-3.197, 0.676, -6.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.424, 0.465, -5.848> <-1.240, 0.465, -6.410> <-1.039, 0.465, -7.246> <-1.222, 0.465, -7.808> 
		<-1.966, 0.584, -5.997> <-1.783, 0.584, -6.559> <-1.589, 0.581, -7.136> <-1.772, 0.581, -7.699> 
		<-2.738, 0.634, -6.201> <-2.689, 0.634, -6.502> <-2.880, 0.652, -7.702> <-2.623, 0.625, -7.866> 
		<-3.197, 0.676, -6.545> <-3.147, 0.676, -6.847> <-3.361, 0.703, -7.395> <-3.105, 0.676, -7.559> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.628, 0.759, -8.009> <-4.202, 0.735, -7.403> <-3.845, 0.731, -6.453> <-3.381, 0.676, -5.878> 
		<-4.643, 0.761, -8.082> <-4.217, 0.737, -7.476> <-3.742, 0.731, -6.634> <-3.278, 0.676, -6.058> 
		<-4.635, 0.761, -8.184> <-4.166, 0.738, -7.706> <-3.764, 0.725, -6.742> <-3.230, 0.676, -6.340> 
		<-4.628, 0.759, -8.259> <-4.159, 0.736, -7.781> <-3.731, 0.725, -6.947> <-3.197, 0.676, -6.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.628, 0.759, -8.009> <-4.643, 0.761, -8.082> <-4.635, 0.761, -8.184> <-4.628, 0.759, -8.259> 
		<-4.671, 0.761, -8.070> <-4.686, 0.763, -8.144> <-4.687, 0.763, -8.238> <-4.680, 0.761, -8.312> 
		<-4.838, 0.762, -8.072> <-4.850, 0.764, -8.146> <-4.757, 0.763, -8.248> <-4.814, 0.761, -8.297> 
		<-4.878, 0.759, -8.009> <-4.890, 0.761, -8.083> <-4.821, 0.760, -8.210> <-4.878, 0.759, -8.259> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.628, 0.759, -8.009> <-4.671, 0.761, -8.070> <-4.838, 0.762, -8.072> <-4.878, 0.759, -8.009> 
		<-4.455, 0.736, -7.139> <-4.498, 0.738, -7.200> <-4.697, 0.739, -7.210> <-4.738, 0.736, -7.146> 
		<-4.249, 0.735, -5.969> <-4.335, 0.735, -5.899> <-4.439, 0.736, -5.967> <-4.546, 0.736, -5.995> 
		<-4.003, 0.676, -5.118> <-4.089, 0.676, -5.049> <-4.264, 0.676, -5.113> <-4.371, 0.676, -5.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.628, 0.759, -8.009> <-4.455, 0.736, -7.139> <-4.249, 0.735, -5.969> <-4.003, 0.676, -5.118> 
		<-4.202, 0.735, -7.403> <-4.029, 0.712, -6.532> <-4.094, 0.735, -6.092> <-3.848, 0.676, -5.241> 
		<-3.845, 0.731, -6.453> <-3.897, 0.731, -6.361> <-3.687, 0.676, -5.576> <-3.777, 0.676, -5.521> 
		<-3.381, 0.676, -5.878> <-3.433, 0.676, -5.786> <-3.590, 0.676, -5.749> <-3.680, 0.676, -5.693> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.628, 0.759, -8.259> <-4.159, 0.736, -7.781> <-3.731, 0.725, -6.947> <-3.197, 0.676, -6.545> 
		<-4.551, 0.736, -9.100> <-4.082, 0.713, -8.621> <-3.681, 0.725, -7.249> <-3.147, 0.676, -6.847> 
		<-4.448, 0.721, -10.221> <-3.512, 0.721, -9.615> <-3.734, 0.703, -8.445> <-3.361, 0.703, -7.395> 
		<-4.348, 0.676, -11.059> <-3.413, 0.676, -10.453> <-3.478, 0.676, -8.609> <-3.105, 0.676, -7.559> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.628, 0.759, -8.259> <-4.551, 0.736, -9.100> <-4.448, 0.721, -10.221> <-4.348, 0.676, -11.059> 
		<-4.680, 0.761, -8.312> <-4.603, 0.738, -9.153> <-5.373, 0.721, -10.821> <-5.273, 0.676, -11.658> 
		<-4.814, 0.761, -8.297> <-5.717, 0.737, -9.084> <-6.305, 0.725, -10.640> <-7.178, 0.676, -11.460> 
		<-4.878, 0.759, -8.259> <-5.781, 0.735, -9.046> <-7.137, 0.725, -9.916> <-8.009, 0.676, -10.736> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.009, 0.676, -10.736> <-8.504, 0.676, -10.306> <-6.716, 0.875, -9.507> <-6.835, 0.676, -8.894> 
		<-7.137, 0.725, -9.916> <-7.632, 0.725, -9.486> <-6.709, 0.875, -8.927> <-6.828, 0.676, -8.314> 
		<-5.781, 0.735, -9.046> <-6.382, 0.712, -8.688> <-6.406, 0.734, -7.770> <-7.044, 0.676, -7.492> 
		<-4.878, 0.759, -8.259> <-5.479, 0.736, -7.902> <-6.173, 0.734, -7.238> <-6.812, 0.676, -6.960> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.878, 0.759, -8.259> <-5.479, 0.736, -7.902> <-6.173, 0.734, -7.238> <-6.812, 0.676, -6.960> 
		<-4.821, 0.760, -8.210> <-5.422, 0.737, -7.852> <-6.019, 0.734, -6.887> <-6.658, 0.676, -6.608> 
		<-4.890, 0.761, -8.083> <-5.194, 0.737, -7.606> <-5.683, 0.739, -7.066> <-5.978, 0.676, -6.587> 
		<-4.878, 0.759, -8.009> <-5.182, 0.735, -7.532> <-5.412, 0.739, -6.794> <-5.707, 0.676, -6.315> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.878, 0.759, -8.009> <-5.182, 0.735, -7.532> <-5.412, 0.739, -6.794> <-5.707, 0.676, -6.315> 
		<-4.738, 0.736, -7.146> <-5.042, 0.713, -6.669> <-5.213, 0.739, -6.595> <-5.508, 0.676, -6.116> 
		<-4.546, 0.736, -5.995> <-4.836, 0.736, -6.071> <-5.048, 0.706, -5.646> <-5.331, 0.706, -5.742> 
		<-4.371, 0.676, -5.141> <-4.660, 0.676, -5.217> <-5.032, 0.676, -5.366> <-5.315, 0.676, -5.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<11.676, 0.044, -16.896> <11.566, 0.096, -16.767> <11.406, 0.188, -16.611> <11.309, 0.218, -16.466> 
		<13.303, 0.044, -15.699> <13.193, 0.096, -15.570> <12.953, 0.188, -15.473> <12.856, 0.218, -15.328> 
		<11.577, 0.044, -12.057> <11.482, 0.096, -12.026> <11.309, 0.184, -11.919> <11.216, 0.218, -11.865> 
		<10.709, 0.044, -10.233> <10.614, 0.096, -10.202> <10.484, 0.184, -10.186> <10.390, 0.218, -10.131> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<11.676, 0.044, -16.896> <9.303, 0.044, -18.641> <4.603, 0.044, -17.816> <1.859, 0.044, -16.743> 
		<11.566, 0.096, -16.767> <9.193, 0.096, -18.512> <4.638, 0.096, -17.689> <1.895, 0.096, -16.617> 
		<11.406, 0.188, -16.611> <9.150, 0.188, -18.270> <4.542, 0.190, -17.472> <1.934, 0.190, -16.453> 
		<11.309, 0.218, -16.466> <9.054, 0.218, -18.125> <4.585, 0.218, -17.340> <1.977, 0.218, -16.321> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.859, 0.044, -16.743> <0.806, 0.044, -16.332> <1.826, 0.044, -14.097> <1.656, 0.044, -12.980> 
		<1.895, 0.096, -16.617> <0.841, 0.096, -16.205> <1.864, 0.096, -14.026> <1.694, 0.096, -12.908> 
		<1.934, 0.190, -16.453> <0.932, 0.190, -16.061> <1.919, 0.190, -13.882> <1.738, 0.190, -12.823> 
		<1.977, 0.218, -16.321> <0.975, 0.218, -15.929> <1.964, 0.218, -13.802> <1.783, 0.218, -12.742> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.656, 0.044, -12.980> <1.428, 0.044, -11.479> <0.736, 0.044, -9.550> <0.537, 0.044, -8.046> 
		<1.694, 0.096, -12.908> <1.466, 0.096, -11.408> <0.744, 0.096, -9.552> <0.545, 0.096, -8.048> 
		<1.738, 0.190, -12.823> <1.493, 0.190, -11.390> <0.764, 0.166, -9.495> <0.553, 0.166, -8.057> 
		<1.783, 0.218, -12.742> <1.538, 0.218, -11.309> <0.776, 0.218, -9.490> <0.565, 0.218, -8.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.537, 0.044, -8.046> <0.458, 0.044, -7.453> <0.740, 0.044, -6.660> <0.740, 0.044, -6.062> 
		<0.545, 0.096, -8.048> <0.467, 0.096, -7.455> <0.761, 0.096, -6.676> <0.761, 0.096, -6.078> 
		<0.553, 0.166, -8.057> <0.468, 0.166, -7.477> <0.690, 0.162, -6.676> <0.802, 0.162, -6.101> 
		<0.565, 0.218, -8.052> <0.479, 0.218, -7.472> <0.697, 0.218, -6.689> <0.810, 0.218, -6.115> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.740, 0.044, -6.062> <0.740, 0.044, -5.464> <0.390, 0.044, -4.492> <0.537, 0.044, -4.079> 
		<0.761, 0.096, -6.078> <0.761, 0.096, -5.480> <0.622, 0.096, -4.537> <0.770, 0.096, -4.124> 
		<0.802, 0.162, -6.101> <0.915, 0.162, -5.526> <0.960, 0.158, -4.492> <1.120, 0.158, -4.094> 
		<0.810, 0.218, -6.115> <0.922, 0.218, -5.540> <1.153, 0.218, -4.627> <1.313, 0.218, -4.229> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.537, 0.044, -4.079> <0.648, 0.044, -3.769> <1.315, 0.044, -3.286> <1.758, 0.044, -3.214> 
		<0.770, 0.096, -4.124> <0.880, 0.096, -3.814> <1.351, 0.096, -3.359> <1.794, 0.096, -3.287> 
		<1.120, 0.158, -4.094> <1.199, 0.158, -3.899> <1.572, 0.189, -3.424> <1.854, 0.189, -3.369> 
		<1.313, 0.218, -4.229> <1.392, 0.218, -4.034> <1.598, 0.218, -3.513> <1.880, 0.218, -3.458> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.758, 0.044, -3.214> <2.081, 0.044, -3.161> <2.400, 0.044, -3.674> <2.724, 0.044, -3.723> 
		<1.794, 0.096, -3.287> <2.118, 0.096, -3.235> <2.422, 0.096, -3.740> <2.746, 0.096, -3.788> 
		<1.854, 0.189, -3.369> <2.160, 0.189, -3.310> <2.445, 0.178, -3.833> <2.754, 0.178, -3.879> 
		<1.880, 0.218, -3.458> <2.186, 0.218, -3.399> <2.491, 0.218, -3.896> <2.799, 0.218, -3.942> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.724, 0.044, -3.723> <3.448, 0.044, -3.831> <4.472, 0.044, -3.488> <5.165, 0.044, -3.723> 
		<2.746, 0.096, -3.788> <3.471, 0.096, -3.896> <4.458, 0.096, -3.554> <5.152, 0.096, -3.788> 
		<2.754, 0.178, -3.879> <3.442, 0.178, -3.982> <4.463, 0.172, -3.647> <5.122, 0.172, -3.870> 
		<2.799, 0.218, -3.942> <3.487, 0.218, -4.045> <4.460, 0.218, -3.719> <5.120, 0.218, -3.942> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.165, 0.044, -3.723> <5.646, 0.044, -3.885> <6.094, 0.044, -4.497> <6.335, 0.044, -4.943> 
		<5.152, 0.096, -3.788> <5.632, 0.096, -3.951> <6.063, 0.096, -4.545> <6.304, 0.096, -4.991> 
		<5.122, 0.172, -3.870> <5.579, 0.172, -4.025> <6.034, 0.167, -4.629> <6.264, 0.167, -5.053> 
		<5.120, 0.218, -3.942> <5.576, 0.218, -4.096> <6.002, 0.218, -4.678> <6.232, 0.218, -5.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.335, 0.044, -4.943> <6.703, 0.044, -5.622> <6.657, 0.044, -6.790> <7.149, 0.044, -7.385> 
		<6.304, 0.096, -4.991> <6.672, 0.096, -5.670> <6.614, 0.096, -6.801> <7.106, 0.096, -7.396> 
		<6.264, 0.167, -5.053> <6.613, 0.167, -5.699> <6.586, 0.170, -6.868> <7.054, 0.170, -7.434> 
		<6.232, 0.218, -5.102> <6.581, 0.218, -5.748> <6.538, 0.218, -6.858> <7.006, 0.218, -7.423> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.149, 0.044, -7.385> <8.021, 0.044, -8.439> <10.122, 0.044, -8.998> <10.709, 0.044, -10.233> 
		<7.106, 0.096, -7.396> <7.978, 0.096, -8.450> <10.026, 0.096, -8.967> <10.614, 0.096, -10.202> 
		<7.054, 0.170, -7.434> <7.883, 0.170, -8.436> <9.925, 0.184, -9.011> <10.484, 0.184, -10.186> 
		<7.006, 0.218, -7.423> <7.834, 0.218, -8.425> <9.831, 0.218, -8.957> <10.390, 0.218, -10.131> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<11.309, 0.218, -16.466> <11.124, 0.275, -16.187> <10.944, 0.290, -15.763> <10.742, 0.333, -15.494> 
		<12.856, 0.218, -15.328> <12.670, 0.275, -15.049> <12.342, 0.290, -14.734> <12.140, 0.333, -14.465> 
		<11.216, 0.218, -11.865> <11.064, 0.273, -11.777> <10.821, 0.293, -11.408> <10.657, 0.333, -11.336> 
		<10.390, 0.218, -10.131> <10.239, 0.273, -10.043> <10.075, 0.293, -9.841> <9.911, 0.333, -9.769> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<11.309, 0.218, -16.466> <9.054, 0.218, -18.125> <4.585, 0.218, -17.340> <1.977, 0.218, -16.321> 
		<11.124, 0.275, -16.187> <8.868, 0.275, -17.847> <4.677, 0.278, -17.054> <2.069, 0.278, -16.035> 
		<10.944, 0.290, -15.763> <8.906, 0.290, -17.262> <4.577, 0.286, -16.573> <2.220, 0.286, -15.652> 
		<10.742, 0.333, -15.494> <8.703, 0.333, -16.993> <4.664, 0.333, -16.284> <2.307, 0.333, -15.363> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.977, 0.218, -16.321> <0.975, 0.218, -15.929> <1.964, 0.218, -13.802> <1.783, 0.218, -12.742> 
		<2.069, 0.278, -16.035> <1.068, 0.278, -15.644> <2.065, 0.279, -13.623> <1.884, 0.279, -12.563> 
		<2.220, 0.286, -15.652> <1.315, 0.286, -15.298> <2.252, 0.283, -13.258> <2.032, 0.283, -12.312> 
		<2.307, 0.333, -15.363> <1.403, 0.333, -15.009> <2.352, 0.333, -13.075> <2.133, 0.333, -12.129> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.783, 0.218, -12.742> <1.538, 0.218, -11.309> <0.776, 0.218, -9.490> <0.565, 0.218, -8.052> 
		<1.884, 0.279, -12.563> <1.639, 0.279, -11.130> <0.784, 0.255, -9.487> <0.573, 0.255, -8.048> 
		<2.032, 0.283, -12.312> <1.735, 0.283, -11.030> <0.856, 0.326, -9.298> <0.566, 0.326, -8.015> 
		<2.133, 0.333, -12.129> <1.835, 0.333, -10.847> <0.893, 0.333, -9.302> <0.603, 0.333, -8.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.565, 0.218, -8.052> <0.479, 0.218, -7.472> <0.697, 0.218, -6.689> <0.810, 0.218, -6.115> 
		<0.573, 0.255, -8.048> <0.488, 0.255, -7.469> <0.702, 0.253, -6.698> <0.814, 0.253, -6.123> 
		<0.566, 0.326, -8.015> <0.441, 0.326, -7.461> <0.600, 0.325, -6.665> <0.747, 0.325, -6.117> 
		<0.603, 0.333, -8.019> <0.478, 0.333, -7.465> <0.631, 0.333, -6.682> <0.778, 0.333, -6.134> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.810, 0.218, -6.115> <0.922, 0.218, -5.540> <1.153, 0.218, -4.627> <1.313, 0.218, -4.229> 
		<0.814, 0.253, -6.123> <0.927, 0.253, -5.549> <1.284, 0.258, -4.718> <1.444, 0.258, -4.320> 
		<0.747, 0.325, -6.117> <0.868, 0.325, -5.664> <1.202, 0.310, -4.904> <1.380, 0.310, -4.610> 
		<0.778, 0.333, -6.134> <0.899, 0.333, -5.681> <1.303, 0.333, -5.033> <1.481, 0.333, -4.739> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.313, 0.218, -4.229> <1.392, 0.218, -4.034> <1.598, 0.218, -3.513> <1.880, 0.218, -3.458> 
		<1.444, 0.258, -4.320> <1.523, 0.258, -4.125> <1.651, 0.277, -3.696> <1.933, 0.277, -3.641> 
		<1.380, 0.310, -4.610> <1.475, 0.310, -4.454> <1.677, 0.306, -4.015> <1.912, 0.306, -3.930> 
		<1.481, 0.333, -4.739> <1.576, 0.333, -4.583> <1.779, 0.333, -4.184> <2.014, 0.333, -4.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.880, 0.218, -3.458> <2.186, 0.218, -3.399> <2.491, 0.218, -3.896> <2.799, 0.218, -3.942> 
		<1.933, 0.277, -3.641> <2.239, 0.277, -3.582> <2.547, 0.268, -3.974> <2.855, 0.268, -4.020> 
		<1.912, 0.306, -3.930> <2.205, 0.306, -3.825> <2.668, 0.299, -4.092> <2.980, 0.299, -4.100> 
		<2.014, 0.333, -4.099> <2.307, 0.333, -3.994> <2.739, 0.333, -4.168> <3.050, 0.333, -4.175> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.799, 0.218, -3.942> <3.487, 0.218, -4.045> <4.460, 0.218, -3.719> <5.120, 0.218, -3.942> 
		<2.855, 0.268, -4.020> <3.544, 0.268, -4.123> <4.457, 0.260, -3.785> <5.117, 0.260, -4.008> 
		<2.980, 0.299, -4.100> <3.609, 0.299, -4.115> <4.558, 0.313, -3.898> <5.154, 0.313, -4.099> 
		<3.050, 0.333, -4.175> <3.679, 0.333, -4.190> <4.552, 0.333, -3.974> <5.148, 0.333, -4.175> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.120, 0.218, -3.942> <5.576, 0.218, -4.096> <6.002, 0.218, -4.678> <6.232, 0.218, -5.102> 
		<5.117, 0.260, -4.008> <5.574, 0.260, -4.162> <5.979, 0.254, -4.714> <6.209, 0.254, -5.138> 
		<5.154, 0.313, -4.099> <5.567, 0.313, -4.239> <5.973, 0.309, -4.799> <6.180, 0.309, -5.182> 
		<5.148, 0.333, -4.175> <5.561, 0.333, -4.315> <5.946, 0.333, -4.841> <6.153, 0.333, -5.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.232, 0.218, -5.102> <6.581, 0.218, -5.748> <6.538, 0.218, -6.858> <7.006, 0.218, -7.423> 
		<6.209, 0.254, -5.138> <6.559, 0.254, -5.783> <6.492, 0.263, -6.848> <6.959, 0.263, -7.414> 
		<6.180, 0.309, -5.182> <6.496, 0.309, -5.765> <6.486, 0.300, -6.807> <6.908, 0.300, -7.318> 
		<6.153, 0.333, -5.224> <6.469, 0.333, -5.807> <6.430, 0.333, -6.810> <6.852, 0.333, -7.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.006, 0.218, -7.423> <7.834, 0.218, -8.425> <9.831, 0.218, -8.957> <10.390, 0.218, -10.131> 
		<6.959, 0.263, -7.414> <7.788, 0.263, -8.416> <9.680, 0.273, -8.869> <10.239, 0.273, -10.043> 
		<6.908, 0.300, -7.318> <7.657, 0.300, -8.223> <9.570, 0.293, -8.780> <10.075, 0.293, -9.841> 
		<6.852, 0.333, -7.322> <7.601, 0.333, -8.227> <9.406, 0.333, -8.708> <9.911, 0.333, -9.769> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<10.742, 0.333, -15.494> <10.343, 0.418, -14.965> <9.742, 0.578, -14.324> <9.313, 0.642, -13.817> 
		<12.140, 0.333, -14.465> <11.741, 0.418, -13.937> <10.827, 0.578, -13.526> <10.398, 0.642, -13.019> 
		<10.657, 0.333, -11.336> <10.298, 0.422, -11.178> <8.530, 0.713, -10.305> <8.472, 0.744, -10.702> 
		<9.911, 0.333, -9.769> <9.552, 0.422, -9.611> <8.727, 0.612, -8.976> <8.668, 0.642, -9.372> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<10.742, 0.333, -15.494> <8.703, 0.333, -16.993> <4.664, 0.333, -16.284> <2.307, 0.333, -15.363> 
		<10.343, 0.418, -14.965> <8.305, 0.418, -16.465> <4.813, 0.414, -15.791> <2.456, 0.414, -14.870> 
		<9.742, 0.578, -14.324> <8.159, 0.578, -15.489> <4.367, 0.584, -14.896> <2.537, 0.584, -14.181> 
		<9.313, 0.642, -13.817> <7.730, 0.642, -14.982> <4.594, 0.642, -14.431> <2.764, 0.642, -13.716> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.307, 0.333, -15.363> <1.403, 0.333, -15.009> <2.352, 0.333, -13.075> <2.133, 0.333, -12.129> 
		<2.456, 0.414, -14.870> <1.552, 0.414, -14.516> <2.506, 0.411, -12.796> <2.286, 0.411, -11.849> 
		<2.537, 0.584, -14.181> <1.834, 0.584, -13.906> <2.612, 0.616, -12.280> <2.572, 0.616, -11.527> 
		<2.764, 0.642, -13.716> <2.062, 0.642, -13.441> <2.669, 0.642, -11.958> <2.628, 0.642, -11.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.133, 0.333, -12.129> <1.835, 0.333, -10.847> <0.893, 0.333, -9.302> <0.603, 0.333, -8.019> 
		<2.286, 0.411, -11.849> <1.989, 0.411, -10.568> <1.552, 0.458, -9.367> <1.262, 0.458, -8.084> 
		<2.572, 0.616, -11.527> <2.724, 0.686, -10.662> <2.273, 0.556, -8.814> <2.237, 0.556, -7.934> 
		<2.628, 0.642, -11.205> <2.781, 0.712, -10.340> <2.847, 0.642, -9.155> <2.811, 0.642, -8.275> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.603, 0.333, -8.019> <0.478, 0.333, -7.465> <0.631, 0.333, -6.682> <0.778, 0.333, -6.134> 
		<1.262, 0.458, -8.084> <1.137, 0.458, -7.530> <1.125, 0.461, -6.948> <1.271, 0.461, -6.400> 
		<2.237, 0.556, -7.934> <2.221, 0.556, -7.538> <1.899, 0.557, -7.081> <1.980, 0.557, -6.693> 
		<2.811, 0.642, -8.275> <2.795, 0.642, -7.879> <2.376, 0.642, -7.391> <2.456, 0.642, -7.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.778, 0.333, -6.134> <0.899, 0.333, -5.681> <1.303, 0.333, -5.033> <1.481, 0.333, -4.739> 
		<1.271, 0.461, -6.400> <1.392, 0.461, -5.947> <1.764, 0.439, -5.622> <1.942, 0.439, -5.329> 
		<1.980, 0.557, -6.693> <2.030, 0.557, -6.454> <2.329, 0.545, -6.295> <2.541, 0.545, -6.172> 
		<2.456, 0.642, -7.003> <2.506, 0.642, -6.763> <2.950, 0.642, -6.716> <3.162, 0.642, -6.592> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.481, 0.333, -4.739> <1.576, 0.333, -4.583> <1.779, 0.333, -4.184> <2.014, 0.333, -4.099> 
		<1.942, 0.439, -5.329> <2.037, 0.439, -5.173> <2.158, 0.435, -4.813> <2.393, 0.435, -4.729> 
		<2.541, 0.545, -6.172> <2.687, 0.568, -6.271> <3.072, 0.548, -5.597> <3.123, 0.548, -5.427> 
		<3.162, 0.642, -6.592> <3.308, 0.665, -6.691> <3.409, 0.642, -6.251> <3.460, 0.642, -6.080> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.014, 0.333, -4.099> <2.307, 0.333, -3.994> <2.739, 0.333, -4.168> <3.050, 0.333, -4.175> 
		<2.393, 0.435, -4.729> <2.686, 0.435, -4.623> <2.931, 0.427, -4.372> <3.243, 0.427, -4.380> 
		<3.123, 0.548, -5.427> <3.228, 0.548, -5.075> <3.175, 0.599, -4.752> <3.520, 0.599, -4.626> 
		<3.460, 0.642, -6.080> <3.566, 0.642, -5.728> <3.331, 0.642, -5.000> <3.677, 0.642, -4.874> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.050, 0.333, -4.175> <3.679, 0.333, -4.190> <4.552, 0.333, -3.974> <5.148, 0.333, -4.175> 
		<3.243, 0.427, -4.380> <3.872, 0.427, -4.395> <4.520, 0.441, -4.374> <5.116, 0.441, -4.576> 
		<3.520, 0.599, -4.626> <3.934, 0.599, -4.475> <4.646, 0.550, -4.923> <5.041, 0.550, -5.116> 
		<3.677, 0.642, -4.874> <4.090, 0.642, -4.723> <4.600, 0.642, -5.326> <4.996, 0.642, -5.520> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.148, 0.333, -4.175> <5.561, 0.333, -4.315> <5.946, 0.333, -4.841> <6.153, 0.333, -5.224> 
		<5.116, 0.441, -4.576> <5.529, 0.441, -4.716> <5.828, 0.438, -5.022> <6.035, 0.438, -5.406> 
		<5.041, 0.550, -5.116> <5.268, 0.550, -5.213> <5.692, 0.588, -5.418> <5.828, 0.588, -5.623> 
		<4.996, 0.642, -5.520> <5.222, 0.642, -5.617> <5.614, 0.642, -5.638> <5.750, 0.642, -5.843> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.153, 0.333, -5.224> <6.469, 0.333, -5.807> <6.430, 0.333, -6.810> <6.852, 0.333, -7.322> 
		<6.035, 0.438, -5.406> <6.351, 0.438, -5.989> <6.261, 0.434, -6.822> <6.683, 0.434, -7.333> 
		<5.828, 0.588, -5.623> <6.113, 0.588, -6.052> <5.978, 0.606, -6.882> <6.307, 0.606, -7.279> 
		<5.750, 0.642, -5.843> <6.035, 0.642, -6.272> <5.965, 0.642, -7.075> <6.293, 0.642, -7.472> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.852, 0.333, -7.322> <7.601, 0.333, -8.227> <9.406, 0.333, -8.708> <9.911, 0.333, -9.769> 
		<6.683, 0.434, -7.333> <7.432, 0.434, -8.239> <9.047, 0.422, -8.549> <9.552, 0.422, -9.611> 
		<6.307, 0.606, -7.279> <6.888, 0.606, -7.982> <8.014, 0.612, -8.405> <8.727, 0.612, -8.976> 
		<6.293, 0.642, -7.472> <6.875, 0.642, -8.175> <7.956, 0.642, -8.802> <8.668, 0.642, -9.372> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.276, 0.948, -7.715> <5.084, 0.987, -8.032> <4.581, 0.987, -8.462> <4.222, 0.948, -8.371> 
		<5.713, 0.994, -8.569> <5.522, 1.032, -8.886> <4.756, 1.030, -9.078> <4.397, 0.991, -8.987> 
		<6.091, 0.988, -9.822> <5.821, 1.040, -10.329> <5.364, 1.023, -10.139> <4.874, 0.984, -9.837> 
		<6.621, 0.948, -10.624> <6.351, 1.000, -11.131> <5.195, 0.988, -10.757> <4.706, 0.948, -10.455> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.276, 0.948, -7.715> <5.713, 0.994, -8.569> <6.091, 0.988, -9.822> <6.621, 0.948, -10.624> 
		<5.577, 0.888, -7.216> <6.015, 0.933, -8.070> <6.537, 0.902, -8.983> <7.067, 0.862, -9.784> 
		<5.560, 0.775, -6.382> <5.845, 0.775, -6.811> <5.899, 0.817, -8.012> <6.227, 0.817, -8.409> 
		<5.750, 0.642, -5.843> <6.035, 0.642, -6.272> <5.965, 0.642, -7.075> <6.293, 0.642, -7.472> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.276, 0.948, -7.715> <4.828, 0.902, -6.841> <4.194, 0.785, -5.697> <3.677, 0.642, -4.874> 
		<5.577, 0.888, -7.216> <5.130, 0.841, -6.342> <4.607, 0.785, -5.546> <4.090, 0.642, -4.723> 
		<5.560, 0.775, -6.382> <5.424, 0.775, -6.177> <4.826, 0.642, -5.423> <4.600, 0.642, -5.326> 
		<5.750, 0.642, -5.843> <5.614, 0.642, -5.638> <5.222, 0.642, -5.617> <4.996, 0.642, -5.520> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.276, 0.948, -7.715> <4.828, 0.902, -6.841> <4.194, 0.785, -5.697> <3.677, 0.642, -4.874> 
		<5.084, 0.987, -8.032> <4.637, 0.940, -7.158> <3.848, 0.785, -5.823> <3.331, 0.642, -5.000> 
		<4.581, 0.987, -8.462> <4.382, 0.938, -7.761> <3.898, 0.735, -6.371> <3.566, 0.642, -5.728> 
		<4.222, 0.948, -8.371> <4.023, 0.899, -7.670> <3.793, 0.735, -6.724> <3.460, 0.642, -6.080> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.621, 0.948, -10.624> <7.313, 0.896, -11.671> <8.505, 0.763, -12.863> <9.313, 0.642, -13.817> 
		<6.351, 1.000, -11.131> <7.043, 0.948, -12.178> <6.922, 0.763, -14.027> <7.730, 0.642, -14.982> 
		<5.195, 0.988, -10.757> <4.895, 0.925, -11.857> <5.093, 0.770, -13.411> <4.594, 0.642, -14.431> 
		<4.706, 0.948, -10.455> <4.406, 0.885, -11.555> <3.263, 0.770, -12.696> <2.764, 0.642, -13.716> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.621, 0.948, -10.624> <7.313, 0.896, -11.671> <8.505, 0.763, -12.863> <9.313, 0.642, -13.817> 
		<7.067, 0.862, -9.784> <7.760, 0.810, -10.831> <9.590, 0.763, -12.064> <10.398, 0.642, -13.019> 
		<6.227, 0.817, -8.409> <6.809, 0.817, -9.112> <7.759, 0.744, -10.131> <8.472, 0.744, -10.702> 
		<6.293, 0.642, -7.472> <6.875, 0.642, -8.175> <7.956, 0.642, -8.802> <8.668, 0.642, -9.372> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.764, 0.642, -13.716> <2.062, 0.642, -13.441> <2.669, 0.642, -11.958> <2.628, 0.642, -11.205> 
		<3.263, 0.770, -12.696> <2.560, 0.770, -12.421> <2.821, 0.712, -11.093> <2.781, 0.712, -10.340> 
		<4.406, 0.885, -11.555> <3.666, 0.826, -11.099> <3.590, 0.754, -9.596> <2.847, 0.642, -9.155> 
		<4.706, 0.948, -10.455> <3.966, 0.889, -9.999> <3.554, 0.754, -8.716> <2.811, 0.642, -8.275> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.706, 0.948, -10.455> <4.874, 0.984, -9.837> <4.397, 0.991, -8.987> <4.222, 0.948, -8.371> 
		<3.966, 0.889, -9.999> <4.134, 0.924, -9.381> <3.745, 0.921, -8.822> <3.570, 0.878, -8.206> 
		<3.554, 0.754, -8.716> <3.538, 0.754, -8.320> <2.937, 0.742, -7.755> <3.017, 0.742, -7.367> 
		<2.811, 0.642, -8.275> <2.795, 0.642, -7.879> <2.376, 0.642, -7.391> <2.456, 0.642, -7.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.222, 0.948, -8.371> <4.023, 0.899, -7.670> <3.793, 0.735, -6.724> <3.460, 0.642, -6.080> 
		<3.570, 0.878, -8.206> <3.370, 0.829, -7.506> <3.742, 0.735, -6.894> <3.409, 0.642, -6.251> 
		<3.017, 0.742, -7.367> <3.067, 0.742, -7.128> <3.096, 0.665, -6.815> <3.308, 0.665, -6.691> 
		<2.456, 0.642, -7.003> <2.506, 0.642, -6.763> <2.950, 0.642, -6.716> <3.162, 0.642, -6.592> 
	}
	
	texture { txIslands }
}

// Layer 2
#declare oRocks =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.655, 0.013, 9.813> <-4.604, 0.069, 9.745> <-4.537, 0.143, 9.655> <-4.487, 0.199, 9.587> 
		<-4.531, -0.019, 10.020> <-4.481, 0.037, 9.953> <-4.442, 0.161, 9.837> <-4.392, 0.217, 9.769> 
		<-4.367, -0.061, 10.297> <-4.345, 0.045, 10.204> <-4.288, 0.135, 10.105> <-4.266, 0.241, 10.011> 
		<-4.243, -0.093, 10.504> <-4.222, 0.013, 10.411> <-4.193, 0.154, 10.287> <-4.171, 0.259, 10.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.655, 0.013, 9.813> <-4.728, 0.012, 9.626> <-4.826, 0.011, 9.377> <-4.899, 0.011, 9.191> 
		<-4.604, 0.069, 9.745> <-4.678, 0.068, 9.558> <-4.753, 0.070, 9.307> <-4.826, 0.070, 9.120> 
		<-4.537, 0.143, 9.655> <-4.588, 0.146, 9.465> <-4.678, 0.146, 9.216> <-4.729, 0.148, 9.026> 
		<-4.487, 0.199, 9.587> <-4.538, 0.201, 9.398> <-4.606, 0.205, 9.145> <-4.657, 0.207, 8.956> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.899, 0.011, 9.191> <-5.027, -0.011, 8.882> <-5.198, -0.041, 8.471> <-5.326, -0.063, 8.162> 
		<-4.826, 0.070, 9.120> <-4.954, 0.048, 8.812> <-5.105, 0.074, 8.482> <-5.233, 0.052, 8.173> 
		<-4.729, 0.148, 9.026> <-4.837, 0.182, 8.800> <-5.001, 0.171, 8.415> <-5.109, 0.205, 8.189> 
		<-4.657, 0.207, 8.956> <-4.765, 0.241, 8.729> <-4.909, 0.286, 8.427> <-5.017, 0.320, 8.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.326, -0.063, 8.162> <-5.227, 0.034, 7.868> <-5.096, 0.163, 7.476> <-4.998, 0.260, 7.182> 
		<-5.233, 0.052, 8.173> <-5.135, 0.149, 7.880> <-5.081, 0.146, 7.454> <-4.982, 0.243, 7.160> 
		<-5.109, 0.205, 8.189> <-5.088, 0.170, 7.861> <-4.983, 0.255, 7.458> <-4.961, 0.221, 7.130> 
		<-5.017, 0.320, 8.200> <-4.995, 0.285, 7.872> <-4.967, 0.239, 7.435> <-4.946, 0.204, 7.108> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.998, 0.260, 7.182> <-4.945, 0.145, 6.719> <-4.873, -0.007, 6.101> <-4.820, -0.122, 5.638> 
		<-4.982, 0.243, 7.160> <-4.929, 0.129, 6.697> <-4.832, 0.121, 6.222> <-4.779, 0.007, 5.758> 
		<-4.961, 0.221, 7.130> <-4.882, 0.251, 6.809> <-4.803, 0.147, 6.239> <-4.724, 0.178, 5.919> 
		<-4.946, 0.204, 7.108> <-4.867, 0.235, 6.787> <-4.761, 0.276, 6.359> <-4.682, 0.307, 6.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.820, -0.122, 5.638> <-4.634, -0.167, 5.246> <-4.385, -0.228, 4.724> <-4.199, -0.274, 4.332> 
		<-4.779, 0.007, 5.758> <-4.592, -0.039, 5.366> <-4.367, -0.063, 4.751> <-4.180, -0.109, 4.359> 
		<-4.724, 0.178, 5.919> <-4.560, 0.169, 5.434> <-4.319, 0.120, 4.880> <-4.155, 0.111, 4.395> 
		<-4.682, 0.307, 6.039> <-4.519, 0.298, 5.554> <-4.301, 0.286, 4.907> <-4.137, 0.276, 4.422> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.199, -0.274, 4.332> <-4.115, -0.179, 4.104> <-4.005, -0.053, 3.800> <-3.921, 0.042, 3.572> 
		<-4.180, -0.109, 4.359> <-4.097, -0.014, 4.131> <-3.989, -0.028, 3.814> <-3.906, 0.067, 3.586> 
		<-4.155, 0.111, 4.395> <-4.076, 0.066, 4.154> <-3.966, 0.145, 3.846> <-3.886, 0.100, 3.604> 
		<-4.137, 0.276, 4.422> <-4.057, 0.231, 4.181> <-3.951, 0.170, 3.859> <-3.871, 0.124, 3.618> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.921, 0.042, 3.572> <-3.770, -0.026, 3.889> <-3.568, -0.117, 4.312> <-3.417, -0.185, 4.629> 
		<-3.906, 0.067, 3.586> <-3.755, -0.001, 3.903> <-3.584, -0.012, 4.407> <-3.433, -0.081, 4.724> 
		<-3.886, 0.100, 3.604> <-3.766, 0.111, 4.002> <-3.714, 0.011, 4.562> <-3.477, 0.027, 4.904> 
		<-3.871, 0.124, 3.618> <-3.751, 0.136, 4.016> <-3.707, 0.146, 4.604> <-3.470, 0.163, 4.945> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.417, -0.185, 4.629> <-3.214, -0.183, 4.783> <-2.943, -0.182, 4.989> <-2.740, -0.180, 5.144> 
		<-3.433, -0.081, 4.724> <-3.230, -0.079, 4.878> <-2.957, -0.068, 5.001> <-2.753, -0.066, 5.155> 
		<-3.477, 0.027, 4.904> <-3.353, 0.036, 5.082> <-2.977, 0.074, 5.099> <-2.771, 0.085, 5.170> 
		<-3.470, 0.163, 4.945> <-3.346, 0.171, 5.124> <-2.990, 0.188, 5.111> <-2.785, 0.199, 5.182> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.740, -0.180, 5.144> <-2.719, -0.149, 5.620> <-2.690, -0.107, 6.255> <-2.669, -0.075, 6.732> 
		<-2.753, -0.066, 5.155> <-2.732, -0.035, 5.632> <-2.800, 0.018, 6.328> <-2.779, 0.050, 6.805> 
		<-2.771, 0.085, 5.170> <-2.846, 0.128, 5.708> <-2.850, 0.174, 6.364> <-2.925, 0.216, 6.902> 
		<-2.785, 0.199, 5.182> <-2.860, 0.242, 5.720> <-2.959, 0.298, 6.437> <-3.034, 0.341, 6.975> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.669, -0.075, 6.732> <-2.692, -0.015, 7.092> <-2.722, 0.064, 7.572> <-2.744, 0.124, 7.932> 
		<-2.779, 0.050, 6.805> <-2.801, 0.109, 7.165> <-2.830, 0.146, 7.585> <-2.853, 0.206, 7.945> 
		<-2.925, 0.216, 6.902> <-2.946, 0.233, 7.203> <-3.017, 0.331, 7.730> <-3.020, 0.306, 8.030> 
		<-3.034, 0.341, 6.975> <-3.056, 0.358, 7.276> <-3.103, 0.423, 7.676> <-3.106, 0.398, 7.976> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.744, 0.124, 7.932> <-2.823, 0.075, 8.091> <-2.928, 0.010, 8.303> <-3.007, -0.039, 8.462> 
		<-2.853, 0.206, 7.945> <-2.932, 0.157, 8.104> <-2.941, 0.091, 8.251> <-3.020, 0.043, 8.410> 
		<-3.020, 0.306, 8.030> <-3.021, 0.298, 8.137> <-3.054, 0.201, 8.247> <-3.036, 0.151, 8.341> 
		<-3.106, 0.398, 7.976> <-3.108, 0.389, 8.083> <-3.066, 0.282, 8.195> <-3.049, 0.233, 8.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.007, -0.039, 8.462> <-3.236, -0.050, 8.839> <-3.542, -0.064, 9.342> <-3.771, -0.075, 9.719> 
		<-3.020, 0.043, 8.410> <-3.249, 0.032, 8.787> <-3.509, 0.165, 9.259> <-3.738, 0.154, 9.636> 
		<-3.036, 0.151, 8.341> <-3.221, 0.289, 8.687> <-3.511, 0.323, 9.180> <-3.695, 0.461, 9.526> 
		<-3.049, 0.233, 8.289> <-3.233, 0.370, 8.635> <-3.478, 0.553, 9.097> <-3.663, 0.690, 9.443> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.771, -0.075, 9.719> <-3.913, -0.081, 9.955> <-4.101, -0.088, 10.269> <-4.243, -0.093, 10.504> 
		<-3.738, 0.154, 9.636> <-3.880, 0.149, 9.872> <-4.080, 0.018, 10.176> <-4.222, 0.013, 10.411> 
		<-3.695, 0.461, 9.526> <-3.848, 0.331, 9.751> <-4.040, 0.283, 10.061> <-4.193, 0.154, 10.287> 
		<-3.663, 0.690, 9.443> <-3.815, 0.561, 9.668> <-4.019, 0.389, 9.968> <-4.171, 0.259, 10.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.487, 0.199, 9.587> <-4.496, 0.264, 9.510> <-4.508, 0.351, 9.407> <-4.517, 0.416, 9.329> 
		<-4.392, 0.217, 9.769> <-4.401, 0.282, 9.692> <-4.379, 0.401, 9.558> <-4.389, 0.466, 9.481> 
		<-4.266, 0.241, 10.011> <-4.241, 0.338, 9.904> <-4.242, 0.436, 9.791> <-4.217, 0.533, 9.684> 
		<-4.171, 0.259, 10.193> <-4.147, 0.357, 10.086> <-4.113, 0.486, 9.943> <-4.089, 0.583, 9.836> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.487, 0.199, 9.587> <-4.538, 0.201, 9.398> <-4.606, 0.205, 9.145> <-4.657, 0.207, 8.956> 
		<-4.496, 0.264, 9.510> <-4.547, 0.266, 9.320> <-4.572, 0.337, 9.051> <-4.623, 0.340, 8.862> 
		<-4.508, 0.351, 9.407> <-4.516, 0.421, 9.201> <-4.570, 0.447, 8.943> <-4.578, 0.517, 8.737> 
		<-4.517, 0.416, 9.329> <-4.525, 0.486, 9.123> <-4.536, 0.579, 8.849> <-4.544, 0.649, 8.643> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.657, 0.207, 8.956> <-4.765, 0.241, 8.729> <-4.909, 0.286, 8.427> <-5.017, 0.320, 8.200> 
		<-4.623, 0.340, 8.862> <-4.731, 0.374, 8.635> <-4.871, 0.379, 8.391> <-4.979, 0.413, 8.164> 
		<-4.578, 0.517, 8.737> <-4.682, 0.511, 8.568> <-4.824, 0.543, 8.285> <-4.928, 0.537, 8.116> 
		<-4.544, 0.649, 8.643> <-4.648, 0.644, 8.474> <-4.786, 0.636, 8.249> <-4.890, 0.630, 8.080> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.017, 0.320, 8.200> <-4.995, 0.285, 7.872> <-4.967, 0.239, 7.435> <-4.946, 0.204, 7.108> 
		<-4.979, 0.413, 8.164> <-4.957, 0.378, 7.836> <-4.911, 0.306, 7.401> <-4.890, 0.272, 7.073> 
		<-4.928, 0.537, 8.116> <-4.889, 0.477, 7.790> <-4.855, 0.422, 7.353> <-4.816, 0.362, 7.026> 
		<-4.890, 0.630, 8.080> <-4.851, 0.570, 7.754> <-4.799, 0.490, 7.318> <-4.760, 0.430, 6.991> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.946, 0.204, 7.108> <-4.867, 0.235, 6.787> <-4.761, 0.276, 6.359> <-4.682, 0.307, 6.039> 
		<-4.890, 0.272, 7.073> <-4.811, 0.302, 6.752> <-4.710, 0.441, 6.364> <-4.631, 0.472, 6.043> 
		<-4.816, 0.362, 7.026> <-4.741, 0.491, 6.745> <-4.637, 0.564, 6.330> <-4.562, 0.693, 6.049> 
		<-4.760, 0.430, 6.991> <-4.685, 0.558, 6.710> <-4.585, 0.730, 6.335> <-4.511, 0.858, 6.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.682, 0.307, 6.039> <-4.519, 0.298, 5.554> <-4.301, 0.286, 4.907> <-4.137, 0.276, 4.422> 
		<-4.631, 0.472, 6.043> <-4.467, 0.463, 5.558> <-4.306, 0.369, 5.055> <-4.142, 0.360, 4.570> 
		<-4.562, 0.693, 6.049> <-4.455, 0.602, 5.708> <-4.256, 0.563, 5.109> <-4.149, 0.472, 4.768> 
		<-4.511, 0.858, 6.054> <-4.404, 0.767, 5.712> <-4.261, 0.646, 5.257> <-4.154, 0.555, 4.916> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.137, 0.276, 4.422> <-4.057, 0.231, 4.181> <-3.951, 0.170, 3.859> <-3.871, 0.124, 3.618> 
		<-4.142, 0.360, 4.570> <-4.062, 0.314, 4.329> <-3.916, 0.353, 3.919> <-3.836, 0.308, 3.678> 
		<-4.149, 0.472, 4.768> <-4.029, 0.526, 4.438> <-3.909, 0.498, 4.087> <-3.789, 0.552, 3.758> 
		<-4.154, 0.555, 4.916> <-4.034, 0.609, 4.586> <-3.874, 0.682, 4.147> <-3.754, 0.736, 3.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.871, 0.124, 3.618> <-3.751, 0.136, 4.016> <-3.707, 0.146, 4.604> <-3.470, 0.163, 4.945> 
		<-3.836, 0.308, 3.678> <-3.716, 0.319, 4.076> <-3.700, 0.282, 4.645> <-3.463, 0.298, 4.986> 
		<-3.789, 0.552, 3.758> <-3.675, 0.518, 4.075> <-3.517, 0.518, 4.579> <-3.402, 0.483, 4.896> 
		<-3.754, 0.736, 3.818> <-3.640, 0.701, 4.135> <-3.488, 0.655, 4.558> <-3.373, 0.621, 4.875> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.470, 0.163, 4.945> <-3.346, 0.171, 5.124> <-2.990, 0.188, 5.111> <-2.785, 0.199, 5.182> 
		<-3.463, 0.298, 4.986> <-3.338, 0.307, 5.165> <-3.037, 0.249, 5.236> <-2.832, 0.260, 5.307> 
		<-3.402, 0.483, 4.896> <-3.273, 0.417, 5.113> <-2.888, 0.345, 5.219> <-2.882, 0.338, 5.481> 
		<-3.373, 0.621, 4.875> <-3.244, 0.555, 5.092> <-2.948, 0.408, 5.338> <-2.942, 0.401, 5.599> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.785, 0.199, 5.182> <-2.860, 0.242, 5.720> <-2.959, 0.298, 6.437> <-3.034, 0.341, 6.975> 
		<-2.832, 0.260, 5.307> <-2.907, 0.302, 5.845> <-3.046, 0.364, 6.495> <-3.121, 0.407, 7.033> 
		<-2.882, 0.338, 5.481> <-2.871, 0.325, 5.967> <-3.122, 0.446, 6.639> <-3.236, 0.494, 7.110> 
		<-2.942, 0.401, 5.599> <-2.931, 0.388, 6.085> <-3.208, 0.512, 6.697> <-3.322, 0.560, 7.167> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.034, 0.341, 6.975> <-3.056, 0.358, 7.276> <-3.103, 0.423, 7.676> <-3.106, 0.398, 7.976> 
		<-3.121, 0.407, 7.033> <-3.142, 0.424, 7.333> <-3.181, 0.506, 7.627> <-3.184, 0.482, 7.927> 
		<-3.236, 0.494, 7.110> <-3.202, 0.512, 7.252> <-3.212, 0.535, 7.600> <-3.178, 0.553, 7.742> 
		<-3.322, 0.560, 7.167> <-3.288, 0.578, 7.310> <-3.243, 0.602, 7.499> <-3.209, 0.620, 7.642> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.106, 0.398, 7.976> <-3.108, 0.389, 8.083> <-3.066, 0.282, 8.195> <-3.049, 0.233, 8.289> 
		<-3.184, 0.482, 7.927> <-3.186, 0.473, 8.035> <-3.160, 0.415, 8.159> <-3.142, 0.366, 8.253> 
		<-3.178, 0.553, 7.742> <-3.224, 0.570, 7.900> <-3.221, 0.526, 8.046> <-3.267, 0.543, 8.204> 
		<-3.209, 0.620, 7.642> <-3.254, 0.637, 7.800> <-3.315, 0.659, 8.010> <-3.360, 0.676, 8.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.049, 0.233, 8.289> <-3.233, 0.370, 8.635> <-3.478, 0.553, 9.097> <-3.663, 0.690, 9.443> 
		<-3.142, 0.366, 8.253> <-3.326, 0.503, 8.599> <-3.531, 0.542, 9.037> <-3.715, 0.679, 9.383> 
		<-3.267, 0.543, 8.204> <-3.410, 0.536, 8.527> <-3.641, 0.671, 8.981> <-3.784, 0.665, 9.304> 
		<-3.360, 0.676, 8.168> <-3.503, 0.669, 8.491> <-3.694, 0.660, 8.921> <-3.837, 0.654, 9.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.663, 0.690, 9.443> <-3.815, 0.561, 9.668> <-4.019, 0.389, 9.968> <-4.171, 0.259, 10.193> 
		<-3.715, 0.679, 9.383> <-3.867, 0.550, 9.608> <-3.994, 0.486, 9.861> <-4.147, 0.357, 10.086> 
		<-3.784, 0.665, 9.304> <-3.860, 0.643, 9.481> <-4.038, 0.507, 9.765> <-4.113, 0.486, 9.943> 
		<-3.837, 0.654, 9.244> <-3.912, 0.632, 9.422> <-4.013, 0.604, 9.658> <-4.089, 0.583, 9.836> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.583, 1.011, 5.144> <-3.583, 1.011, 5.144> <-3.583, 1.011, 5.144> <-3.583, 1.011, 5.144> 
		<-3.634, 0.929, 4.746> <-3.806, 0.792, 4.677> <-3.806, 0.792, 4.677> <-3.754, 0.875, 5.075> 
		<-3.703, 0.818, 4.216> <-3.823, 0.764, 4.545> <-3.863, 0.746, 4.655> <-3.982, 0.692, 4.984> 
		<-3.754, 0.736, 3.818> <-3.874, 0.682, 4.147> <-4.034, 0.609, 4.586> <-4.154, 0.555, 4.916> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.583, 1.011, 5.144> <-3.634, 0.929, 4.746> <-3.703, 0.818, 4.216> <-3.754, 0.736, 3.818> 
		<-3.490, 0.984, 5.045> <-3.542, 0.901, 4.647> <-3.589, 0.784, 4.533> <-3.640, 0.701, 4.135> 
		<-3.393, 0.751, 5.126> <-3.411, 0.745, 5.053> <-3.469, 0.661, 4.631> <-3.488, 0.655, 4.558> 
		<-3.311, 0.639, 5.118> <-3.330, 0.634, 5.045> <-3.355, 0.626, 4.948> <-3.373, 0.621, 4.875> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.583, 1.011, 5.144> <-3.708, 1.049, 5.278> <-3.822, 0.771, 5.489> <-3.832, 0.795, 5.675> 
		<-3.754, 0.875, 5.075> <-3.880, 0.912, 5.210> <-3.851, 0.796, 5.258> <-3.860, 0.820, 5.444> 
		<-3.982, 0.692, 4.984> <-4.090, 0.783, 5.325> <-4.200, 0.748, 5.599> <-4.307, 0.839, 5.940> 
		<-4.154, 0.555, 4.916> <-4.261, 0.646, 5.257> <-4.404, 0.767, 5.712> <-4.511, 0.858, 6.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.583, 1.011, 5.144> <-3.490, 0.984, 5.045> <-3.393, 0.751, 5.126> <-3.311, 0.639, 5.118> 
		<-3.708, 1.049, 5.278> <-3.616, 1.021, 5.179> <-3.493, 0.910, 5.513> <-3.412, 0.799, 5.506> 
		<-3.822, 0.771, 5.489> <-3.835, 0.803, 5.741> <-3.606, 1.120, 5.742> <-3.559, 1.119, 5.991> 
		<-3.832, 0.795, 5.675> <-3.844, 0.826, 5.927> <-3.694, 1.173, 6.161> <-3.647, 1.171, 6.410> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.517, 0.416, 9.329> <-4.425, 0.549, 9.043> <-4.303, 0.727, 8.661> <-4.211, 0.860, 8.375> 
		<-4.389, 0.466, 9.481> <-4.297, 0.599, 9.195> <-4.238, 0.749, 8.734> <-4.146, 0.882, 8.448> 
		<-4.217, 0.533, 9.684> <-4.189, 0.638, 9.318> <-4.088, 0.806, 8.910> <-4.059, 0.912, 8.545> 
		<-4.089, 0.583, 9.836> <-4.060, 0.688, 9.470> <-4.022, 0.828, 8.983> <-3.994, 0.933, 8.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.517, 0.416, 9.329> <-4.525, 0.486, 9.123> <-4.536, 0.579, 8.849> <-4.544, 0.649, 8.643> 
		<-4.425, 0.549, 9.043> <-4.433, 0.619, 8.837> <-4.465, 0.608, 8.639> <-4.473, 0.678, 8.434> 
		<-4.303, 0.727, 8.661> <-4.332, 0.692, 8.533> <-4.350, 0.751, 8.284> <-4.379, 0.716, 8.155> 
		<-4.211, 0.860, 8.375> <-4.240, 0.826, 8.246> <-4.279, 0.779, 8.074> <-4.309, 0.744, 7.945> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.544, 0.649, 8.643> <-4.648, 0.644, 8.474> <-4.786, 0.636, 8.249> <-4.890, 0.630, 8.080> 
		<-4.473, 0.678, 8.434> <-4.577, 0.672, 8.265> <-4.643, 0.672, 8.166> <-4.747, 0.666, 7.997> 
		<-4.379, 0.716, 8.155> <-4.410, 0.718, 8.112> <-4.524, 0.713, 7.929> <-4.555, 0.714, 7.886> 
		<-4.309, 0.744, 7.945> <-4.340, 0.746, 7.903> <-4.381, 0.749, 7.845> <-4.412, 0.750, 7.802> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.890, 0.630, 8.080> <-4.851, 0.570, 7.754> <-4.799, 0.490, 7.318> <-4.760, 0.430, 6.991> 
		<-4.747, 0.666, 7.997> <-4.708, 0.606, 7.670> <-4.685, 0.584, 7.352> <-4.646, 0.524, 7.025> 
		<-4.555, 0.714, 7.886> <-4.546, 0.712, 7.676> <-4.504, 0.651, 7.280> <-4.495, 0.649, 7.070> 
		<-4.412, 0.750, 7.802> <-4.403, 0.748, 7.593> <-4.390, 0.745, 7.313> <-4.381, 0.743, 7.103> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.760, 0.430, 6.991> <-4.685, 0.558, 6.710> <-4.585, 0.730, 6.335> <-4.511, 0.858, 6.054> 
		<-4.646, 0.524, 7.025> <-4.572, 0.652, 6.744> <-4.382, 0.711, 6.221> <-4.307, 0.839, 5.940> 
		<-4.495, 0.649, 7.070> <-4.330, 0.664, 6.641> <-3.804, 0.770, 5.898> <-3.860, 0.820, 5.444> 
		<-4.381, 0.743, 7.103> <-4.216, 0.758, 6.675> <-3.776, 0.745, 6.128> <-3.832, 0.795, 5.675> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.373, 0.621, 4.875> <-3.244, 0.555, 5.092> <-2.948, 0.408, 5.338> <-2.942, 0.401, 5.599> 
		<-3.355, 0.626, 4.948> <-3.225, 0.560, 5.165> <-3.052, 0.519, 5.546> <-3.047, 0.512, 5.807> 
		<-3.330, 0.634, 5.045> <-3.336, 0.675, 5.389> <-3.208, 0.623, 5.721> <-3.214, 0.665, 6.066> 
		<-3.311, 0.639, 5.118> <-3.317, 0.681, 5.462> <-3.325, 0.737, 5.921> <-3.331, 0.778, 6.266> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.942, 0.401, 5.599> <-2.931, 0.388, 6.085> <-3.208, 0.512, 6.697> <-3.322, 0.560, 7.167> 
		<-3.047, 0.512, 5.807> <-3.036, 0.499, 6.293> <-3.291, 0.543, 6.633> <-3.405, 0.590, 7.104> 
		<-3.214, 0.665, 6.066> <-3.294, 0.630, 6.273> <-3.435, 0.666, 6.812> <-3.515, 0.631, 7.020> 
		<-3.331, 0.778, 6.266> <-3.411, 0.743, 6.473> <-3.518, 0.697, 6.749> <-3.597, 0.661, 6.957> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.322, 0.560, 7.167> <-3.288, 0.578, 7.310> <-3.243, 0.602, 7.499> <-3.209, 0.620, 7.642> 
		<-3.405, 0.590, 7.104> <-3.371, 0.608, 7.246> <-3.332, 0.625, 7.460> <-3.298, 0.643, 7.603> 
		<-3.515, 0.631, 7.020> <-3.488, 0.641, 7.186> <-3.444, 0.663, 7.384> <-3.417, 0.673, 7.551> 
		<-3.597, 0.661, 6.957> <-3.570, 0.672, 7.123> <-3.534, 0.686, 7.345> <-3.506, 0.696, 7.512> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.209, 0.620, 7.642> <-3.254, 0.637, 7.800> <-3.315, 0.659, 8.010> <-3.360, 0.676, 8.168> 
		<-3.298, 0.643, 7.603> <-3.344, 0.660, 7.761> <-3.343, 0.692, 7.859> <-3.389, 0.709, 8.017> 
		<-3.417, 0.673, 7.551> <-3.402, 0.700, 7.597> <-3.442, 0.725, 7.770> <-3.427, 0.752, 7.816> 
		<-3.506, 0.696, 7.512> <-3.491, 0.722, 7.558> <-3.471, 0.758, 7.619> <-3.455, 0.784, 7.665> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.360, 0.676, 8.168> <-3.503, 0.669, 8.491> <-3.694, 0.660, 8.921> <-3.837, 0.654, 9.244> 
		<-3.389, 0.709, 8.017> <-3.532, 0.702, 8.340> <-3.699, 0.713, 8.648> <-3.842, 0.706, 8.971> 
		<-3.427, 0.752, 7.816> <-3.546, 0.765, 8.017> <-3.729, 0.762, 8.407> <-3.849, 0.775, 8.608> 
		<-3.455, 0.784, 7.665> <-3.575, 0.797, 7.866> <-3.735, 0.814, 8.134> <-3.854, 0.827, 8.335> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.837, 0.654, 9.244> <-3.912, 0.632, 9.422> <-4.013, 0.604, 9.658> <-4.089, 0.583, 9.836> 
		<-3.842, 0.706, 8.971> <-3.918, 0.685, 9.149> <-3.985, 0.709, 9.293> <-4.060, 0.688, 9.470> 
		<-3.849, 0.775, 8.608> <-3.891, 0.807, 8.692> <-3.980, 0.797, 8.898> <-4.022, 0.828, 8.983> 
		<-3.854, 0.827, 8.335> <-3.896, 0.859, 8.419> <-3.952, 0.902, 8.533> <-3.994, 0.933, 8.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.775, 0.915, 7.311> <-3.736, 0.992, 7.041> <-3.705, 1.206, 6.686> <-3.647, 1.171, 6.410> 
		<-3.798, 0.889, 7.618> <-3.760, 0.966, 7.348> <-3.631, 1.204, 7.077> <-3.573, 1.169, 6.801> 
		<-3.830, 0.854, 8.027> <-3.711, 0.841, 7.827> <-3.633, 0.913, 7.490> <-3.513, 0.900, 7.289> 
		<-3.854, 0.827, 8.335> <-3.735, 0.814, 8.134> <-3.575, 0.797, 7.866> <-3.455, 0.784, 7.665> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.775, 0.915, 7.311> <-3.843, 0.974, 7.307> <-3.935, 1.053, 7.302> <-4.004, 1.112, 7.299> 
		<-3.736, 0.992, 7.041> <-3.805, 1.051, 7.037> <-3.883, 0.958, 6.815> <-3.952, 1.017, 6.812> 
		<-3.705, 1.206, 6.686> <-3.752, 1.207, 6.436> <-3.896, 0.922, 6.414> <-3.883, 0.890, 6.162> 
		<-3.647, 1.171, 6.410> <-3.694, 1.173, 6.161> <-3.844, 0.826, 5.927> <-3.832, 0.795, 5.675> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.775, 0.915, 7.311> <-3.906, 0.898, 7.630> <-4.080, 0.877, 8.056> <-4.211, 0.860, 8.375> 
		<-3.843, 0.974, 7.307> <-3.974, 0.958, 7.626> <-4.109, 0.842, 7.927> <-4.240, 0.826, 8.246> 
		<-3.935, 1.053, 7.302> <-4.027, 0.943, 7.496> <-4.188, 0.889, 7.880> <-4.279, 0.779, 8.074> 
		<-4.004, 1.112, 7.299> <-4.095, 1.002, 7.493> <-4.217, 0.855, 7.751> <-4.309, 0.744, 7.945> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.775, 0.915, 7.311> <-3.798, 0.889, 7.618> <-3.830, 0.854, 8.027> <-3.854, 0.827, 8.335> 
		<-3.906, 0.898, 7.630> <-3.929, 0.872, 7.937> <-3.872, 0.885, 8.112> <-3.896, 0.859, 8.419> 
		<-4.080, 0.877, 8.056> <-4.015, 0.899, 8.129> <-4.017, 0.880, 8.460> <-3.952, 0.902, 8.533> 
		<-4.211, 0.860, 8.375> <-4.146, 0.882, 8.448> <-4.059, 0.912, 8.545> <-3.994, 0.933, 8.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.647, 1.171, 6.410> <-3.559, 1.119, 5.991> <-3.412, 0.799, 5.506> <-3.311, 0.639, 5.118> 
		<-3.573, 1.169, 6.801> <-3.485, 1.117, 6.383> <-3.470, 0.816, 6.224> <-3.370, 0.656, 5.836> 
		<-3.513, 0.900, 7.289> <-3.528, 0.874, 7.243> <-3.432, 0.705, 6.840> <-3.448, 0.679, 6.794> 
		<-3.455, 0.784, 7.665> <-3.471, 0.758, 7.619> <-3.491, 0.722, 7.558> <-3.506, 0.696, 7.512> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.311, 0.639, 5.118> <-3.317, 0.681, 5.462> <-3.325, 0.737, 5.921> <-3.331, 0.778, 6.266> 
		<-3.370, 0.656, 5.836> <-3.376, 0.698, 6.180> <-3.405, 0.701, 6.129> <-3.411, 0.743, 6.473> 
		<-3.448, 0.679, 6.794> <-3.475, 0.669, 6.627> <-3.490, 0.707, 6.916> <-3.518, 0.697, 6.749> 
		<-3.506, 0.696, 7.512> <-3.534, 0.686, 7.345> <-3.570, 0.672, 7.123> <-3.597, 0.661, 6.957> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.832, 0.795, 5.675> <-3.832, 0.795, 5.675> <-3.832, 0.795, 5.675> <-3.832, 0.795, 5.675> 
		<-3.776, 0.745, 6.128> <-3.827, 0.840, 6.615> <-3.827, 0.840, 6.615> <-3.883, 0.890, 6.162> 
		<-4.216, 0.758, 6.675> <-4.103, 0.869, 6.734> <-4.065, 0.906, 6.753> <-3.952, 1.017, 6.812> 
		<-4.381, 0.743, 7.103> <-4.268, 0.854, 7.162> <-4.117, 1.001, 7.240> <-4.004, 1.112, 7.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.004, 1.112, 7.299> <-4.095, 1.002, 7.493> <-4.217, 0.855, 7.751> <-4.309, 0.744, 7.945> 
		<-4.117, 1.001, 7.240> <-4.209, 0.891, 7.434> <-4.248, 0.856, 7.708> <-4.340, 0.746, 7.903> 
		<-4.268, 0.854, 7.162> <-4.277, 0.856, 7.372> <-4.372, 0.746, 7.636> <-4.381, 0.749, 7.845> 
		<-4.381, 0.743, 7.103> <-4.390, 0.745, 7.313> <-4.403, 0.748, 7.593> <-4.412, 0.750, 7.802> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.709, -0.011, 8.615> <-0.719, 0.105, 8.517> <-0.726, 0.317, 8.427> <-0.740, 0.376, 8.287> 
		<-0.571, -0.024, 8.222> <-0.581, 0.092, 8.124> <-0.599, 0.282, 8.125> <-0.614, 0.341, 7.985> 
		<-0.387, -0.041, 7.699> <-0.408, 0.052, 7.691> <-0.402, 0.208, 7.589> <-0.445, 0.293, 7.582> 
		<-0.249, -0.054, 7.306> <-0.270, 0.040, 7.298> <-0.275, 0.172, 7.286> <-0.319, 0.258, 7.279> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.709, -0.011, 8.615> <-0.811, -0.023, 8.270> <-0.946, -0.039, 7.811> <-1.047, -0.051, 7.466> 
		<-0.719, 0.105, 8.517> <-0.820, 0.093, 8.172> <-0.914, 0.059, 7.799> <-1.015, 0.047, 7.454> 
		<-0.726, 0.317, 8.427> <-0.786, 0.287, 8.169> <-0.926, 0.225, 7.729> <-0.986, 0.195, 7.471> 
		<-0.740, 0.376, 8.287> <-0.800, 0.346, 8.029> <-0.880, 0.306, 7.684> <-0.940, 0.276, 7.426> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.047, -0.051, 7.466> <-1.149, -0.074, 7.396> <-1.285, -0.105, 7.302> <-1.386, -0.128, 7.232> 
		<-1.015, 0.047, 7.454> <-1.117, 0.024, 7.384> <-1.242, 0.036, 7.323> <-1.343, 0.013, 7.253> 
		<-0.986, 0.195, 7.471> <-1.077, 0.215, 7.434> <-1.229, 0.195, 7.345> <-1.320, 0.215, 7.308> 
		<-0.940, 0.276, 7.426> <-1.031, 0.296, 7.388> <-1.152, 0.323, 7.339> <-1.243, 0.343, 7.302> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.386, -0.128, 7.232> <-1.293, -0.092, 7.087> <-1.170, -0.044, 6.893> <-1.077, -0.008, 6.748> 
		<-1.343, 0.013, 7.253> <-1.251, 0.049, 7.108> <-1.168, 0.033, 6.956> <-1.075, 0.069, 6.811> 
		<-1.320, 0.215, 7.308> <-1.268, 0.187, 7.205> <-1.156, 0.202, 7.006> <-1.104, 0.174, 6.903> 
		<-1.243, 0.343, 7.302> <-1.191, 0.315, 7.199> <-1.122, 0.278, 7.061> <-1.071, 0.250, 6.958> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.077, -0.008, 6.748> <-0.914, -0.033, 6.493> <-0.698, -0.065, 6.153> <-0.535, -0.089, 5.898> 
		<-1.075, 0.069, 6.811> <-0.913, 0.045, 6.556> <-0.729, 0.011, 6.265> <-0.566, -0.013, 6.010> 
		<-1.104, 0.174, 6.903> <-0.975, 0.148, 6.697> <-0.748, 0.111, 6.364> <-0.618, 0.086, 6.158> 
		<-1.071, 0.250, 6.958> <-0.941, 0.224, 6.752> <-0.768, 0.190, 6.477> <-0.638, 0.164, 6.271> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.535, -0.089, 5.898> <-0.461, -0.079, 6.140> <-0.361, -0.064, 6.463> <-0.287, -0.054, 6.706> 
		<-0.566, -0.013, 6.010> <-0.492, -0.002, 6.252> <-0.421, 0.068, 6.505> <-0.347, 0.079, 6.747> 
		<-0.618, 0.086, 6.158> <-0.573, 0.153, 6.330> <-0.470, 0.195, 6.615> <-0.424, 0.262, 6.786> 
		<-0.638, 0.164, 6.271> <-0.593, 0.231, 6.442> <-0.532, 0.321, 6.671> <-0.487, 0.387, 6.843> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.287, -0.054, 6.706> <-0.275, -0.054, 6.886> <-0.260, -0.054, 7.126> <-0.249, -0.054, 7.306> 
		<-0.347, 0.079, 6.747> <-0.335, 0.079, 6.927> <-0.281, 0.040, 7.118> <-0.270, 0.040, 7.298> 
		<-0.424, 0.262, 6.786> <-0.374, 0.223, 6.917> <-0.326, 0.211, 7.155> <-0.275, 0.172, 7.286> 
		<-0.487, 0.387, 6.843> <-0.436, 0.349, 6.974> <-0.369, 0.297, 7.148> <-0.319, 0.258, 7.279> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.740, 0.376, 8.287> <-0.749, 0.412, 8.201> <-0.764, 0.212, 8.091> <-0.773, 0.246, 8.003> 
		<-0.614, 0.341, 7.985> <-0.623, 0.377, 7.898> <-0.683, 0.272, 7.869> <-0.692, 0.306, 7.782> 
		<-0.445, 0.293, 7.582> <-0.481, 0.364, 7.576> <-0.539, 0.322, 7.503> <-0.585, 0.385, 7.487> 
		<-0.319, 0.258, 7.279> <-0.355, 0.328, 7.274> <-0.458, 0.382, 7.282> <-0.504, 0.445, 7.266> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.740, 0.376, 8.287> <-0.800, 0.346, 8.029> <-0.880, 0.306, 7.684> <-0.940, 0.276, 7.426> 
		<-0.749, 0.412, 8.201> <-0.809, 0.382, 7.942> <-0.863, 0.337, 7.667> <-0.923, 0.307, 7.408> 
		<-0.764, 0.212, 8.091> <-0.807, 0.193, 7.891> <-0.882, 0.167, 7.554> <-0.925, 0.148, 7.355> 
		<-0.773, 0.246, 8.003> <-0.816, 0.227, 7.803> <-0.874, 0.201, 7.537> <-0.917, 0.182, 7.337> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.940, 0.276, 7.426> <-1.031, 0.296, 7.388> <-1.152, 0.323, 7.339> <-1.243, 0.343, 7.302> 
		<-0.923, 0.307, 7.408> <-1.014, 0.327, 7.371> <-1.125, 0.369, 7.337> <-1.216, 0.389, 7.299> 
		<-0.925, 0.148, 7.355> <-1.008, 0.152, 7.318> <-1.145, 0.157, 7.267> <-1.228, 0.161, 7.231> 
		<-0.917, 0.182, 7.337> <-0.999, 0.186, 7.300> <-1.108, 0.192, 7.252> <-1.191, 0.196, 7.216> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.243, 0.343, 7.302> <-1.191, 0.315, 7.199> <-1.122, 0.278, 7.061> <-1.071, 0.250, 6.958> 
		<-1.216, 0.389, 7.299> <-1.164, 0.361, 7.196> <-1.111, 0.304, 7.081> <-1.059, 0.276, 6.977> 
		<-1.228, 0.161, 7.231> <-1.166, 0.162, 7.136> <-1.068, 0.174, 6.984> <-1.006, 0.175, 6.890> 
		<-1.191, 0.196, 7.216> <-1.129, 0.198, 7.121> <-1.047, 0.199, 6.995> <-0.985, 0.200, 6.900> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.071, 0.250, 6.958> <-0.941, 0.224, 6.752> <-0.768, 0.190, 6.477> <-0.638, 0.164, 6.271> 
		<-1.059, 0.276, 6.977> <-0.929, 0.251, 6.771> <-0.777, 0.228, 6.531> <-0.648, 0.202, 6.325> 
		<-1.006, 0.175, 6.890> <-0.901, 0.204, 6.754> <-0.737, 0.221, 6.537> <-0.631, 0.250, 6.402> 
		<-0.985, 0.200, 6.900> <-0.879, 0.229, 6.765> <-0.738, 0.268, 6.584> <-0.632, 0.297, 6.449> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.638, 0.164, 6.271> <-0.593, 0.231, 6.442> <-0.532, 0.321, 6.671> <-0.487, 0.387, 6.843> 
		<-0.648, 0.202, 6.325> <-0.602, 0.269, 6.496> <-0.540, 0.337, 6.679> <-0.495, 0.404, 6.850> 
		<-0.631, 0.250, 6.402> <-0.594, 0.278, 6.539> <-0.539, 0.348, 6.756> <-0.501, 0.376, 6.893> 
		<-0.632, 0.297, 6.449> <-0.595, 0.325, 6.586> <-0.544, 0.362, 6.769> <-0.507, 0.390, 6.906> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.487, 0.387, 6.843> <-0.436, 0.349, 6.974> <-0.369, 0.297, 7.148> <-0.319, 0.258, 7.279> 
		<-0.495, 0.404, 6.850> <-0.444, 0.365, 6.981> <-0.405, 0.367, 7.143> <-0.355, 0.328, 7.274> 
		<-0.501, 0.376, 6.893> <-0.500, 0.393, 7.001> <-0.459, 0.366, 7.174> <-0.458, 0.382, 7.282> 
		<-0.507, 0.390, 6.906> <-0.506, 0.406, 7.014> <-0.505, 0.428, 7.158> <-0.504, 0.445, 7.266> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.803, 0.606, 7.692> <-0.803, 0.606, 7.692> <-0.803, 0.606, 7.692> <-0.803, 0.606, 7.692> 
		<-0.738, 0.613, 7.540> <-0.758, 0.593, 7.419> <-0.758, 0.593, 7.419> <-0.823, 0.586, 7.571> 
		<-0.650, 0.622, 7.338> <-0.742, 0.645, 7.343> <-0.796, 0.633, 7.384> <-0.851, 0.559, 7.409> 
		<-0.585, 0.628, 7.185> <-0.677, 0.652, 7.191> <-0.817, 0.613, 7.263> <-0.872, 0.539, 7.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.803, 0.606, 7.692> <-0.738, 0.613, 7.540> <-0.650, 0.622, 7.338> <-0.585, 0.628, 7.185> 
		<-0.794, 0.498, 7.786> <-0.729, 0.505, 7.634> <-0.588, 0.606, 7.334> <-0.523, 0.612, 7.182> 
		<-0.787, 0.297, 7.870> <-0.706, 0.357, 7.649> <-0.622, 0.437, 7.474> <-0.541, 0.497, 7.253> 
		<-0.773, 0.246, 8.003> <-0.692, 0.306, 7.782> <-0.585, 0.385, 7.487> <-0.504, 0.445, 7.266> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.803, 0.606, 7.692> <-0.794, 0.498, 7.786> <-0.787, 0.297, 7.870> <-0.773, 0.246, 8.003> 
		<-0.823, 0.586, 7.571> <-0.815, 0.478, 7.664> <-0.830, 0.278, 7.670> <-0.816, 0.227, 7.803> 
		<-0.851, 0.559, 7.409> <-0.914, 0.475, 7.438> <-0.849, 0.295, 7.487> <-0.874, 0.201, 7.537> 
		<-0.872, 0.539, 7.288> <-0.934, 0.455, 7.316> <-0.892, 0.276, 7.287> <-0.917, 0.182, 7.337> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.007, 0.569, 7.204> <-0.966, 0.560, 7.229> <-0.912, 0.548, 7.263> <-0.872, 0.539, 7.288> 
		<-1.062, 0.457, 7.208> <-1.022, 0.448, 7.233> <-0.975, 0.464, 7.291> <-0.934, 0.455, 7.316> 
		<-1.105, 0.279, 7.180> <-1.022, 0.275, 7.216> <-0.974, 0.280, 7.251> <-0.892, 0.276, 7.287> 
		<-1.191, 0.196, 7.216> <-1.108, 0.192, 7.252> <-0.999, 0.186, 7.300> <-0.917, 0.182, 7.337> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.007, 0.569, 7.204> <-0.948, 0.565, 7.168> <-0.868, 0.559, 7.121> <-0.809, 0.555, 7.085> 
		<-0.966, 0.560, 7.229> <-0.907, 0.556, 7.194> <-0.821, 0.610, 7.155> <-0.762, 0.605, 7.119> 
		<-0.912, 0.548, 7.263> <-0.858, 0.622, 7.238> <-0.744, 0.630, 7.161> <-0.652, 0.606, 7.155> 
		<-0.872, 0.539, 7.288> <-0.817, 0.613, 7.263> <-0.677, 0.652, 7.191> <-0.585, 0.628, 7.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.007, 0.569, 7.204> <-1.062, 0.457, 7.208> <-1.105, 0.279, 7.180> <-1.191, 0.196, 7.216> 
		<-0.948, 0.565, 7.168> <-1.003, 0.453, 7.172> <-1.043, 0.280, 7.085> <-1.129, 0.198, 7.121> 
		<-0.868, 0.559, 7.121> <-0.949, 0.473, 7.064> <-0.965, 0.294, 7.034> <-1.047, 0.199, 6.995> 
		<-0.809, 0.555, 7.085> <-0.889, 0.469, 7.028> <-0.903, 0.295, 6.940> <-0.985, 0.200, 6.900> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.643, 0.563, 6.672> <-0.619, 0.564, 6.775> <-0.586, 0.565, 6.912> <-0.561, 0.566, 7.015> 
		<-0.693, 0.561, 6.796> <-0.668, 0.562, 6.899> <-0.593, 0.584, 6.963> <-0.568, 0.585, 7.066> 
		<-0.759, 0.557, 6.961> <-0.712, 0.608, 6.995> <-0.645, 0.588, 7.104> <-0.578, 0.609, 7.134> 
		<-0.809, 0.555, 7.085> <-0.762, 0.605, 7.119> <-0.652, 0.606, 7.155> <-0.585, 0.628, 7.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.643, 0.563, 6.672> <-0.693, 0.561, 6.796> <-0.759, 0.557, 6.961> <-0.809, 0.555, 7.085> 
		<-0.640, 0.483, 6.605> <-0.690, 0.481, 6.729> <-0.840, 0.471, 6.904> <-0.889, 0.469, 7.028> 
		<-0.633, 0.371, 6.523> <-0.739, 0.341, 6.658> <-0.798, 0.324, 6.804> <-0.903, 0.295, 6.940> 
		<-0.632, 0.297, 6.449> <-0.738, 0.268, 6.584> <-0.879, 0.229, 6.765> <-0.985, 0.200, 6.900> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.643, 0.563, 6.672> <-0.640, 0.483, 6.605> <-0.633, 0.371, 6.523> <-0.632, 0.297, 6.449> 
		<-0.619, 0.564, 6.775> <-0.615, 0.484, 6.708> <-0.595, 0.398, 6.660> <-0.595, 0.325, 6.586> 
		<-0.586, 0.565, 6.912> <-0.569, 0.512, 6.879> <-0.563, 0.406, 6.811> <-0.544, 0.362, 6.769> 
		<-0.561, 0.566, 7.015> <-0.545, 0.513, 6.982> <-0.525, 0.434, 6.949> <-0.507, 0.390, 6.906> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.561, 0.566, 7.015> <-0.545, 0.513, 6.982> <-0.525, 0.434, 6.949> <-0.507, 0.390, 6.906> 
		<-0.568, 0.585, 7.066> <-0.552, 0.532, 7.033> <-0.524, 0.451, 7.057> <-0.506, 0.406, 7.014> 
		<-0.578, 0.609, 7.134> <-0.515, 0.593, 7.130> <-0.542, 0.480, 7.145> <-0.505, 0.428, 7.158> 
		<-0.585, 0.628, 7.185> <-0.523, 0.612, 7.182> <-0.541, 0.497, 7.253> <-0.504, 0.445, 7.266> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.329, -0.237, 6.817> <7.402, -0.116, 6.714> <7.499, 0.044, 6.577> <7.572, 0.164, 6.474> 
		<7.309, -0.226, 6.731> <7.382, -0.106, 6.629> <7.393, 0.001, 6.749> <7.466, 0.121, 6.646> 
		<7.282, -0.212, 6.618> <7.269, -0.146, 6.772> <7.338, -0.003, 6.721> <7.325, 0.063, 6.875> 
		<7.262, -0.201, 6.532> <7.249, -0.135, 6.687> <7.232, -0.047, 6.893> <7.219, 0.019, 7.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.329, -0.237, 6.817> <7.837, -0.243, 6.764> <8.514, -0.251, 6.693> <9.022, -0.257, 6.640> 
		<7.402, -0.116, 6.714> <7.910, -0.122, 6.661> <8.313, -0.161, 6.712> <8.821, -0.167, 6.659> 
		<7.499, 0.044, 6.577> <7.733, 0.008, 6.646> <8.319, -0.010, 6.616> <8.554, -0.047, 6.684> 
		<7.572, 0.164, 6.474> <7.807, 0.128, 6.543> <8.119, 0.079, 6.634> <8.353, 0.043, 6.703> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.022, -0.257, 6.640> <9.374, -0.294, 7.191> <9.844, -0.343, 7.925> <10.197, -0.380, 8.475> 
		<8.821, -0.167, 6.659> <9.174, -0.204, 7.210> <9.727, -0.242, 8.077> <10.079, -0.279, 8.627> 
		<8.554, -0.047, 6.684> <8.989, -0.073, 7.368> <9.487, -0.118, 8.146> <9.922, -0.144, 8.830> 
		<8.353, 0.043, 6.703> <8.789, 0.017, 7.387> <9.369, -0.017, 8.299> <9.805, -0.043, 8.982> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<10.197, -0.380, 8.475> <9.801, -0.439, 8.923> <9.272, -0.517, 9.521> <8.876, -0.576, 9.969> 
		<10.079, -0.279, 8.627> <9.683, -0.338, 9.075> <9.211, -0.397, 9.521> <8.815, -0.456, 9.969> 
		<9.922, -0.144, 8.830> <9.582, -0.184, 9.126> <9.072, -0.256, 9.673> <8.732, -0.296, 9.969> 
		<9.805, -0.043, 8.982> <9.464, -0.083, 9.278> <9.011, -0.137, 9.673> <8.670, -0.177, 9.969> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.876, -0.576, 9.969> <9.042, -0.436, 9.638> <9.262, -0.249, 9.195> <9.427, -0.109, 8.864> 
		<8.815, -0.456, 9.969> <8.980, -0.316, 9.638> <8.957, -0.240, 9.222> <9.122, -0.100, 8.890> 
		<8.732, -0.296, 9.969> <8.654, -0.267, 9.664> <8.794, -0.117, 9.230> <8.716, -0.088, 8.925> 
		<8.670, -0.177, 9.969> <8.592, -0.147, 9.664> <8.489, -0.109, 9.257> <8.411, -0.079, 8.952> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.427, -0.109, 8.864> <8.783, -0.079, 9.061> <7.924, -0.040, 9.323> <7.280, -0.010, 9.520> 
		<9.122, -0.100, 8.890> <8.478, -0.070, 9.087> <7.748, -0.099, 9.313> <7.103, -0.069, 9.510> 
		<8.716, -0.088, 8.925> <8.200, -0.127, 9.085> <7.384, -0.110, 9.335> <6.868, -0.149, 9.495> 
		<8.411, -0.079, 8.952> <7.895, -0.118, 9.111> <7.207, -0.170, 9.325> <6.692, -0.209, 9.485> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.280, -0.010, 9.520> <6.515, -0.163, 9.625> <5.496, -0.366, 9.765> <4.731, -0.519, 9.870> 
		<7.103, -0.069, 9.510> <6.339, -0.222, 9.614> <5.505, -0.204, 9.928> <4.741, -0.357, 10.033> 
		<6.868, -0.149, 9.495> <6.290, -0.080, 9.774> <5.332, -0.210, 9.971> <4.754, -0.140, 10.250> 
		<6.692, -0.209, 9.485> <6.113, -0.139, 9.763> <5.342, -0.047, 10.134> <4.763, 0.022, 10.413> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.731, -0.519, 9.870> <4.456, -0.421, 9.539> <4.088, -0.289, 9.098> <3.812, -0.191, 8.767> 
		<4.741, -0.357, 10.033> <4.465, -0.258, 9.702> <4.110, -0.173, 9.220> <3.834, -0.075, 8.889> 
		<4.754, -0.140, 10.250> <4.491, -0.088, 9.879> <4.127, 0.028, 9.424> <3.864, 0.080, 9.053> 
		<4.763, 0.022, 10.413> <4.500, 0.074, 10.042> <4.149, 0.144, 9.547> <3.886, 0.196, 9.176> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.812, -0.191, 8.767> <3.600, -0.174, 9.382> <3.317, -0.151, 10.203> <3.104, -0.134, 10.818> 
		<3.834, -0.075, 8.889> <3.622, -0.058, 9.505> <3.327, -0.164, 10.137> <3.114, -0.146, 10.752> 
		<3.864, 0.080, 9.053> <3.639, -0.032, 9.480> <3.352, -0.052, 10.237> <3.127, -0.163, 10.664> 
		<3.886, 0.196, 9.176> <3.661, 0.084, 9.602> <3.362, -0.064, 10.171> <3.137, -0.176, 10.597> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.104, -0.134, 10.818> <3.016, -0.124, 10.319> <2.899, -0.110, 9.653> <2.811, -0.100, 9.154> 
		<3.114, -0.146, 10.752> <3.026, -0.136, 10.253> <2.679, -0.108, 9.709> <2.591, -0.098, 9.209> 
		<3.127, -0.163, 10.664> <2.810, -0.139, 10.286> <2.616, -0.120, 9.661> <2.299, -0.096, 9.284> 
		<3.137, -0.176, 10.597> <2.820, -0.151, 10.220> <2.397, -0.119, 9.717> <2.080, -0.094, 9.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.811, -0.100, 9.154> <2.725, -0.069, 8.517> <2.611, -0.028, 7.668> <2.526, 0.003, 7.031> 
		<2.591, -0.098, 9.209> <2.506, -0.068, 8.573> <2.640, 0.014, 7.758> <2.555, 0.045, 7.121> 
		<2.299, -0.096, 9.284> <2.462, -0.025, 8.681> <2.431, 0.030, 7.844> <2.594, 0.100, 7.241> 
		<2.080, -0.094, 9.339> <2.243, -0.023, 8.737> <2.460, 0.071, 7.934> <2.623, 0.142, 7.332> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.526, 0.003, 7.031> <2.734, -0.102, 6.806> <3.011, -0.242, 6.506> <3.219, -0.346, 6.281> 
		<2.555, 0.045, 7.121> <2.763, -0.060, 6.896> <3.035, -0.137, 6.548> <3.243, -0.242, 6.322> 
		<2.594, 0.100, 7.241> <2.797, 0.058, 6.968> <3.072, -0.060, 6.652> <3.275, -0.102, 6.378> 
		<2.623, 0.142, 7.332> <2.826, 0.100, 7.058> <3.096, 0.044, 6.693> <3.299, 0.002, 6.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.219, -0.346, 6.281> <3.632, -0.283, 5.881> <4.184, -0.198, 5.348> <4.597, -0.135, 4.949> 
		<3.243, -0.242, 6.322> <3.657, -0.178, 5.923> <4.200, -0.200, 5.411> <4.613, -0.137, 5.011> 
		<3.275, -0.102, 6.378> <3.680, -0.145, 5.999> <4.229, -0.096, 5.473> <4.634, -0.139, 5.094> 
		<3.299, 0.002, 6.419> <3.705, -0.041, 6.041> <4.245, -0.098, 5.535> <4.650, -0.141, 5.156> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.597, -0.135, 4.949> <4.819, -0.126, 5.331> <5.114, -0.114, 5.840> <5.335, -0.106, 6.222> 
		<4.613, -0.137, 5.011> <4.834, -0.128, 5.393> <5.193, -0.125, 5.810> <5.414, -0.116, 6.191> 
		<4.634, -0.139, 5.094> <4.919, -0.139, 5.383> <5.235, -0.131, 5.862> <5.520, -0.131, 6.151> 
		<4.650, -0.141, 5.156> <4.935, -0.141, 5.446> <5.314, -0.142, 5.831> <5.599, -0.142, 6.120> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.335, -0.106, 6.222> <5.641, -0.144, 6.101> <6.049, -0.194, 5.939> <6.355, -0.232, 5.818> 
		<5.414, -0.116, 6.191> <5.720, -0.154, 6.070> <5.995, -0.080, 6.046> <6.301, -0.118, 5.924> 
		<5.520, -0.131, 6.151> <5.693, -0.044, 6.167> <6.056, -0.053, 6.051> <6.229, 0.034, 6.066> 
		<5.599, -0.142, 6.120> <5.772, -0.055, 6.136> <6.002, 0.061, 6.157> <6.175, 0.148, 6.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.355, -0.232, 5.818> <6.627, -0.223, 6.032> <6.990, -0.210, 6.318> <7.262, -0.201, 6.532> 
		<6.301, -0.118, 5.924> <6.573, -0.109, 6.139> <6.977, -0.144, 6.472> <7.249, -0.135, 6.687> 
		<6.229, 0.034, 6.066> <6.542, -0.005, 6.329> <6.919, -0.008, 6.630> <7.232, -0.047, 6.893> 
		<6.175, 0.148, 6.173> <6.488, 0.109, 6.435> <6.906, 0.058, 6.785> <7.219, 0.019, 7.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.572, 0.164, 6.474> <7.486, 0.242, 6.515> <7.371, 0.345, 6.570> <7.285, 0.422, 6.611> 
		<7.466, 0.121, 6.646> <7.380, 0.198, 6.687> <7.130, 0.279, 6.623> <7.044, 0.356, 6.664> 
		<7.325, 0.063, 6.875> <7.104, 0.118, 6.798> <6.944, 0.214, 6.813> <6.722, 0.269, 6.735> 
		<7.219, 0.019, 7.047> <6.998, 0.075, 6.969> <6.703, 0.148, 6.866> <6.481, 0.203, 6.789> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.572, 0.164, 6.474> <7.807, 0.128, 6.543> <8.119, 0.079, 6.634> <8.353, 0.043, 6.703> 
		<7.486, 0.242, 6.515> <7.720, 0.205, 6.584> <8.097, 0.109, 6.714> <8.331, 0.073, 6.783> 
		<7.371, 0.345, 6.570> <7.670, 0.261, 6.677> <8.004, 0.196, 6.782> <8.302, 0.112, 6.890> 
		<7.285, 0.422, 6.611> <7.584, 0.338, 6.719> <7.982, 0.226, 6.862> <8.281, 0.141, 6.969> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.353, 0.043, 6.703> <8.789, 0.017, 7.387> <9.369, -0.017, 8.299> <9.805, -0.043, 8.982> 
		<8.331, 0.073, 6.783> <8.767, 0.047, 7.467> <9.169, 0.118, 8.220> <9.604, 0.092, 8.904> 
		<8.302, 0.112, 6.890> <8.559, 0.191, 7.415> <9.080, 0.192, 8.274> <9.337, 0.272, 8.800> 
		<8.281, 0.141, 6.969> <8.538, 0.221, 7.495> <8.880, 0.327, 8.196> <9.137, 0.407, 8.721> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.805, -0.043, 8.982> <9.464, -0.083, 9.278> <9.011, -0.137, 9.673> <8.670, -0.177, 9.969> 
		<9.604, 0.092, 8.904> <9.264, 0.052, 9.200> <8.953, 0.023, 9.521> <8.613, -0.017, 9.817> 
		<9.337, 0.272, 8.800> <9.140, 0.256, 9.022> <8.734, 0.211, 9.392> <8.537, 0.196, 9.614> 
		<9.137, 0.407, 8.721> <8.939, 0.391, 8.943> <8.677, 0.371, 9.239> <8.480, 0.356, 9.461> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.670, -0.177, 9.969> <8.592, -0.147, 9.664> <8.489, -0.109, 9.257> <8.411, -0.079, 8.952> 
		<8.613, -0.017, 9.817> <8.535, 0.012, 9.511> <8.481, 0.113, 9.178> <8.403, 0.142, 8.873> 
		<8.537, 0.196, 9.614> <8.508, 0.287, 9.382> <8.421, 0.347, 9.000> <8.392, 0.438, 8.768> 
		<8.480, 0.356, 9.461> <8.451, 0.447, 9.230> <8.413, 0.569, 8.921> <8.384, 0.660, 8.690> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.411, -0.079, 8.952> <7.895, -0.118, 9.111> <7.207, -0.170, 9.325> <6.692, -0.209, 9.485> 
		<8.403, 0.142, 8.873> <7.887, 0.104, 9.033> <7.221, 0.002, 9.289> <6.705, -0.037, 9.449> 
		<8.392, 0.438, 8.768> <7.898, 0.349, 8.971> <7.217, 0.281, 9.198> <6.723, 0.192, 9.401> 
		<8.384, 0.660, 8.690> <7.890, 0.571, 8.892> <7.231, 0.453, 9.162> <6.737, 0.364, 9.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.692, -0.209, 9.485> <6.113, -0.139, 9.763> <5.342, -0.047, 10.134> <4.763, 0.022, 10.413> 
		<6.705, -0.037, 9.449> <6.127, 0.032, 9.727> <5.417, 0.047, 10.077> <4.839, 0.116, 10.355> 
		<6.723, 0.192, 9.401> <6.207, 0.183, 9.658> <5.456, 0.250, 10.022> <4.940, 0.241, 10.279> 
		<6.737, 0.364, 9.365> <6.220, 0.355, 9.622> <5.532, 0.343, 9.964> <5.015, 0.334, 10.221> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.763, 0.022, 10.413> <4.500, 0.074, 10.042> <4.149, 0.144, 9.547> <3.886, 0.196, 9.176> 
		<4.839, 0.116, 10.355> <4.576, 0.168, 9.984> <4.286, 0.149, 9.373> <4.023, 0.201, 9.002> 
		<4.940, 0.241, 10.279> <4.738, 0.204, 9.792> <4.408, 0.244, 9.258> <4.206, 0.208, 8.771> 
		<5.015, 0.334, 10.221> <4.814, 0.298, 9.734> <4.544, 0.249, 9.085> <4.343, 0.213, 8.598> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.886, 0.196, 9.176> <3.661, 0.084, 9.602> <3.362, -0.064, 10.171> <3.137, -0.176, 10.597> 
		<4.023, 0.201, 9.002> <3.798, 0.089, 9.429> <3.517, 0.164, 9.924> <3.292, 0.053, 10.350> 
		<4.206, 0.208, 8.771> <3.999, 0.320, 9.124> <3.705, 0.246, 9.668> <3.499, 0.358, 10.020> 
		<4.343, 0.213, 8.598> <4.136, 0.325, 8.950> <3.860, 0.474, 9.420> <3.653, 0.586, 9.773> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.137, -0.176, 10.597> <2.820, -0.151, 10.220> <2.397, -0.119, 9.717> <2.080, -0.094, 9.339> 
		<3.292, 0.053, 10.350> <2.975, 0.077, 9.973> <2.596, -0.014, 9.629> <2.278, 0.011, 9.252> 
		<3.499, 0.358, 10.020> <3.225, 0.258, 9.803> <2.817, 0.250, 9.353> <2.543, 0.151, 9.135> 
		<3.653, 0.586, 9.773> <3.380, 0.487, 9.555> <3.016, 0.355, 9.265> <2.742, 0.256, 9.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.080, -0.094, 9.339> <2.243, -0.023, 8.737> <2.460, 0.071, 7.934> <2.623, 0.142, 7.332> 
		<2.278, 0.011, 9.252> <2.441, 0.082, 8.650> <2.478, 0.109, 7.951> <2.641, 0.180, 7.348> 
		<2.543, 0.151, 9.135> <2.526, 0.154, 8.637> <2.683, 0.227, 7.869> <2.666, 0.230, 7.371> 
		<2.742, 0.256, 9.048> <2.725, 0.259, 8.550> <2.701, 0.264, 7.886> <2.684, 0.268, 7.388> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.623, 0.142, 7.332> <2.826, 0.100, 7.058> <3.096, 0.044, 6.693> <3.299, 0.002, 6.419> 
		<2.641, 0.180, 7.348> <2.844, 0.138, 7.075> <3.152, 0.155, 6.657> <3.355, 0.113, 6.383> 
		<2.666, 0.230, 7.371> <2.906, 0.261, 7.045> <3.189, 0.230, 6.662> <3.430, 0.261, 6.335> 
		<2.684, 0.268, 7.388> <2.924, 0.299, 7.061> <3.245, 0.341, 6.626> <3.485, 0.372, 6.300> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.299, 0.002, 6.419> <3.705, -0.041, 6.041> <4.245, -0.098, 5.535> <4.650, -0.141, 5.156> 
		<3.355, 0.113, 6.383> <3.760, 0.070, 6.005> <4.146, 0.057, 5.633> <4.551, 0.014, 5.254> 
		<3.430, 0.261, 6.335> <3.680, 0.262, 6.090> <4.168, 0.219, 5.630> <4.419, 0.220, 5.384> 
		<3.485, 0.372, 6.300> <3.736, 0.373, 6.054> <4.069, 0.374, 5.727> <4.320, 0.375, 5.482> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.650, -0.141, 5.156> <4.935, -0.141, 5.446> <5.314, -0.142, 5.831> <5.599, -0.142, 6.120> 
		<4.551, 0.014, 5.254> <4.835, 0.014, 5.543> <5.283, 0.016, 5.864> <5.568, 0.016, 6.153> 
		<4.419, 0.220, 5.384> <4.771, 0.223, 5.608> <5.173, 0.223, 5.972> <5.526, 0.226, 6.196> 
		<4.320, 0.375, 5.482> <4.672, 0.378, 5.706> <5.142, 0.381, 6.004> <5.495, 0.384, 6.228> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.599, -0.142, 6.120> <5.772, -0.055, 6.136> <6.002, 0.061, 6.157> <6.175, 0.148, 6.173> 
		<5.568, 0.016, 6.153> <5.740, 0.103, 6.168> <5.936, 0.108, 6.084> <6.109, 0.195, 6.100> 
		<5.526, 0.226, 6.196> <5.664, 0.203, 6.106> <5.883, 0.282, 6.092> <6.020, 0.258, 6.003> 
		<5.495, 0.384, 6.228> <5.633, 0.360, 6.139> <5.816, 0.329, 6.019> <5.954, 0.305, 5.930> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.175, 0.148, 6.173> <6.488, 0.109, 6.435> <6.906, 0.058, 6.785> <7.219, 0.019, 7.047> 
		<6.109, 0.195, 6.100> <6.422, 0.157, 6.362> <6.685, 0.113, 6.707> <6.998, 0.075, 6.969> 
		<6.020, 0.258, 6.003> <6.179, 0.227, 6.260> <6.544, 0.179, 6.608> <6.703, 0.148, 6.866> 
		<5.954, 0.305, 5.930> <6.112, 0.275, 6.187> <6.323, 0.234, 6.531> <6.481, 0.203, 6.789> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.285, 0.422, 6.611> <7.228, 0.468, 6.848> <7.153, 0.529, 7.164> <7.096, 0.575, 7.401> 
		<7.044, 0.356, 6.664> <6.987, 0.402, 6.901> <7.099, 0.596, 7.108> <7.042, 0.642, 7.345> 
		<6.722, 0.269, 6.735> <6.853, 0.447, 6.863> <6.840, 0.553, 7.143> <6.970, 0.731, 7.271> 
		<6.481, 0.203, 6.789> <6.612, 0.382, 6.917> <6.786, 0.619, 7.087> <6.917, 0.797, 7.215> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.285, 0.422, 6.611> <7.584, 0.338, 6.719> <7.982, 0.226, 6.862> <8.281, 0.141, 6.969> 
		<7.228, 0.468, 6.848> <7.527, 0.384, 6.956> <7.963, 0.328, 7.007> <8.261, 0.244, 7.114> 
		<7.153, 0.529, 7.164> <7.489, 0.501, 7.180> <7.899, 0.408, 7.292> <8.236, 0.380, 7.308> 
		<7.096, 0.575, 7.401> <7.432, 0.547, 7.417> <7.880, 0.510, 7.437> <8.216, 0.483, 7.453> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.281, 0.141, 6.969> <8.538, 0.221, 7.495> <8.880, 0.327, 8.196> <9.137, 0.407, 8.721> 
		<8.261, 0.244, 7.114> <8.518, 0.323, 7.640> <8.744, 0.350, 8.097> <9.001, 0.429, 8.622> 
		<8.236, 0.380, 7.308> <8.376, 0.380, 7.589> <8.680, 0.459, 8.209> <8.821, 0.459, 8.490> 
		<8.216, 0.483, 7.453> <8.357, 0.482, 7.734> <8.544, 0.482, 8.110> <8.685, 0.482, 8.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<9.137, 0.407, 8.721> <8.939, 0.391, 8.943> <8.677, 0.371, 9.239> <8.480, 0.356, 9.461> 
		<9.001, 0.429, 8.622> <8.804, 0.414, 8.844> <8.654, 0.429, 9.203> <8.457, 0.414, 9.425> 
		<8.821, 0.459, 8.490> <8.737, 0.479, 8.775> <8.512, 0.471, 9.092> <8.428, 0.491, 9.376> 
		<8.685, 0.482, 8.391> <8.601, 0.502, 8.676> <8.489, 0.529, 9.055> <8.405, 0.549, 9.340> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.480, 0.356, 9.461> <8.451, 0.447, 9.230> <8.413, 0.569, 8.921> <8.384, 0.660, 8.690> 
		<8.457, 0.414, 9.425> <8.429, 0.505, 9.193> <8.337, 0.567, 9.010> <8.308, 0.658, 8.779> 
		<8.428, 0.491, 9.376> <8.345, 0.523, 9.270> <8.289, 0.625, 9.003> <8.206, 0.656, 8.897> 
		<8.405, 0.549, 9.340> <8.323, 0.581, 9.234> <8.213, 0.623, 9.092> <8.130, 0.655, 8.986> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.384, 0.660, 8.690> <7.890, 0.571, 8.892> <7.231, 0.453, 9.162> <6.737, 0.364, 9.365> 
		<8.308, 0.658, 8.779> <7.814, 0.570, 8.981> <7.220, 0.541, 9.068> <6.726, 0.453, 9.271> 
		<8.206, 0.656, 8.897> <7.778, 0.657, 8.917> <7.141, 0.569, 9.126> <6.712, 0.570, 9.145> 
		<8.130, 0.655, 8.986> <7.702, 0.656, 9.005> <7.130, 0.657, 9.031> <6.701, 0.658, 9.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.737, 0.364, 9.365> <6.220, 0.355, 9.622> <5.532, 0.343, 9.964> <5.015, 0.334, 10.221> 
		<6.726, 0.453, 9.271> <6.210, 0.444, 9.527> <5.469, 0.413, 9.704> <4.953, 0.404, 9.961> 
		<6.712, 0.570, 9.145> <6.143, 0.543, 9.236> <5.438, 0.525, 9.523> <4.869, 0.498, 9.614> 
		<6.701, 0.658, 9.051> <6.133, 0.631, 9.142> <5.375, 0.595, 9.263> <4.807, 0.568, 9.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.015, 0.334, 10.221> <4.814, 0.298, 9.734> <4.544, 0.249, 9.085> <4.343, 0.213, 8.598> 
		<4.953, 0.404, 9.961> <4.751, 0.368, 9.474> <4.527, 0.383, 9.145> <4.326, 0.347, 8.658> 
		<4.869, 0.498, 9.614> <4.713, 0.525, 9.448> <4.459, 0.498, 8.905> <4.303, 0.526, 8.739> 
		<4.807, 0.568, 9.354> <4.650, 0.595, 9.187> <4.442, 0.632, 8.966> <4.286, 0.660, 8.799> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.343, 0.213, 8.598> <4.136, 0.325, 8.950> <3.860, 0.474, 9.420> <3.653, 0.586, 9.773> 
		<4.326, 0.347, 8.658> <4.119, 0.459, 9.011> <3.941, 0.487, 9.379> <3.734, 0.599, 9.732> 
		<4.303, 0.526, 8.739> <4.194, 0.517, 8.990> <3.950, 0.626, 9.426> <3.841, 0.617, 9.677> 
		<4.286, 0.660, 8.799> <4.177, 0.651, 9.050> <4.031, 0.639, 9.384> <3.922, 0.630, 9.635> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.653, 0.586, 9.773> <3.380, 0.487, 9.555> <3.016, 0.355, 9.265> <2.742, 0.256, 9.048> 
		<3.734, 0.599, 9.732> <3.461, 0.500, 9.514> <2.980, 0.449, 9.093> <2.706, 0.350, 8.875> 
		<3.841, 0.617, 9.677> <3.451, 0.599, 9.328> <3.048, 0.494, 8.994> <2.658, 0.476, 8.645> 
		<3.922, 0.630, 9.635> <3.532, 0.612, 9.286> <3.012, 0.589, 8.821> <2.622, 0.571, 8.472> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.742, 0.256, 9.048> <2.725, 0.259, 8.550> <2.701, 0.264, 7.886> <2.684, 0.268, 7.388> 
		<2.706, 0.350, 8.875> <2.689, 0.354, 8.377> <2.800, 0.349, 7.880> <2.783, 0.352, 7.383> 
		<2.658, 0.476, 8.645> <2.775, 0.470, 8.314> <2.797, 0.471, 7.706> <2.914, 0.465, 7.375> 
		<2.622, 0.571, 8.472> <2.739, 0.565, 8.142> <2.895, 0.556, 7.701> <3.012, 0.550, 7.370> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.684, 0.268, 7.388> <2.924, 0.299, 7.061> <3.245, 0.341, 6.626> <3.485, 0.372, 6.300> 
		<2.783, 0.352, 7.383> <3.023, 0.384, 7.056> <3.324, 0.501, 6.866> <3.565, 0.532, 6.539> 
		<2.914, 0.465, 7.375> <3.135, 0.572, 7.294> <3.449, 0.639, 6.940> <3.671, 0.745, 6.859> 
		<3.012, 0.550, 7.370> <3.234, 0.656, 7.289> <3.529, 0.798, 7.180> <3.750, 0.905, 7.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.485, 0.372, 6.300> <3.736, 0.373, 6.054> <4.069, 0.374, 5.727> <4.320, 0.375, 5.482> 
		<3.565, 0.532, 6.539> <3.815, 0.533, 6.294> <4.122, 0.464, 5.832> <4.372, 0.465, 5.586> 
		<3.671, 0.745, 6.859> <3.894, 0.676, 6.479> <4.219, 0.654, 6.106> <4.442, 0.584, 5.726> 
		<3.750, 0.905, 7.099> <3.973, 0.836, 6.718> <4.271, 0.743, 6.211> <4.494, 0.674, 5.830> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.320, 0.375, 5.482> <4.672, 0.378, 5.706> <5.142, 0.381, 6.004> <5.495, 0.384, 6.228> 
		<4.372, 0.465, 5.586> <4.725, 0.467, 5.810> <5.179, 0.557, 6.021> <5.531, 0.560, 6.244> 
		<4.442, 0.584, 5.726> <4.779, 0.673, 5.861> <5.243, 0.706, 6.131> <5.580, 0.795, 6.266> 
		<4.494, 0.674, 5.830> <4.831, 0.763, 5.966> <5.280, 0.882, 6.147> <5.617, 0.971, 6.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.495, 0.384, 6.228> <5.633, 0.360, 6.139> <5.816, 0.329, 6.019> <5.954, 0.305, 5.930> 
		<5.531, 0.560, 6.244> <5.669, 0.536, 6.155> <5.993, 0.458, 5.952> <6.131, 0.435, 5.862> 
		<5.580, 0.795, 6.266> <5.858, 0.725, 6.093> <6.088, 0.678, 5.945> <6.366, 0.608, 5.772> 
		<5.617, 0.971, 6.282> <5.894, 0.901, 6.109> <6.265, 0.807, 5.878> <6.543, 0.737, 5.704> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.954, 0.305, 5.930> <6.112, 0.275, 6.187> <6.323, 0.234, 6.531> <6.481, 0.203, 6.789> 
		<6.131, 0.435, 5.862> <6.289, 0.404, 6.120> <6.454, 0.412, 6.659> <6.612, 0.382, 6.917> 
		<6.366, 0.608, 5.772> <6.478, 0.626, 6.225> <6.674, 0.601, 6.634> <6.786, 0.619, 7.087> 
		<6.543, 0.737, 5.704> <6.655, 0.755, 6.158> <6.804, 0.779, 6.762> <6.917, 0.797, 7.215> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.096, 0.575, 7.401> <6.988, 0.608, 7.257> <6.844, 0.652, 7.065> <6.737, 0.685, 6.921> 
		<7.042, 0.642, 7.345> <6.934, 0.675, 7.201> <6.689, 0.576, 7.246> <6.581, 0.609, 7.102> 
		<6.970, 0.731, 7.271> <6.761, 0.621, 7.364> <6.583, 0.618, 7.251> <6.373, 0.508, 7.343> 
		<6.917, 0.797, 7.215> <6.707, 0.688, 7.308> <6.427, 0.542, 7.432> <6.217, 0.433, 7.524> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.096, 0.575, 7.401> <7.432, 0.547, 7.417> <7.880, 0.510, 7.437> <8.216, 0.483, 7.453> 
		<6.988, 0.608, 7.257> <7.324, 0.580, 7.273> <7.484, 0.442, 7.490> <7.820, 0.414, 7.506> 
		<6.844, 0.652, 7.065> <6.893, 0.523, 7.278> <7.245, 0.452, 7.364> <7.293, 0.323, 7.576> 
		<6.737, 0.685, 6.921> <6.785, 0.556, 7.134> <6.849, 0.384, 7.417> <6.897, 0.255, 7.629> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.216, 0.483, 7.453> <8.357, 0.482, 7.734> <8.544, 0.482, 8.110> <8.685, 0.482, 8.391> 
		<7.820, 0.414, 7.506> <7.961, 0.414, 7.787> <8.293, 0.479, 8.217> <8.433, 0.478, 8.498> 
		<7.293, 0.323, 7.576> <7.577, 0.388, 7.912> <7.813, 0.409, 8.305> <8.098, 0.474, 8.641> 
		<6.897, 0.255, 7.629> <7.182, 0.319, 7.965> <7.561, 0.406, 8.413> <7.846, 0.471, 8.748> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.685, 0.482, 8.391> <8.601, 0.502, 8.676> <8.489, 0.529, 9.055> <8.405, 0.549, 9.340> 
		<8.433, 0.478, 8.498> <8.349, 0.499, 8.783> <8.049, 0.550, 8.938> <7.965, 0.571, 9.223> 
		<8.098, 0.474, 8.641> <7.825, 0.519, 8.701> <7.650, 0.554, 9.006> <7.377, 0.599, 9.066> 
		<7.846, 0.471, 8.748> <7.573, 0.516, 8.809> <7.209, 0.576, 8.889> <6.936, 0.621, 8.949> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.405, 0.549, 9.340> <8.323, 0.581, 9.234> <8.213, 0.623, 9.092> <8.130, 0.655, 8.986> 
		<7.965, 0.571, 9.223> <7.882, 0.602, 9.116> <7.923, 0.637, 8.808> <7.841, 0.669, 8.702> 
		<7.377, 0.599, 9.066> <7.446, 0.623, 8.794> <7.386, 0.663, 8.597> <7.455, 0.687, 8.324> 
		<6.936, 0.621, 8.949> <7.005, 0.645, 8.677> <7.097, 0.677, 8.313> <7.165, 0.700, 8.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.130, 0.655, 8.986> <7.702, 0.656, 9.005> <7.130, 0.657, 9.031> <6.701, 0.658, 9.051> 
		<7.841, 0.669, 8.702> <7.412, 0.670, 8.722> <7.050, 0.595, 8.943> <6.621, 0.596, 8.963> 
		<7.455, 0.687, 8.324> <7.235, 0.612, 8.539> <6.734, 0.588, 8.630> <6.514, 0.513, 8.845> 
		<7.165, 0.700, 8.041> <6.946, 0.625, 8.256> <6.654, 0.525, 8.542> <6.434, 0.450, 8.757> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.701, 0.658, 9.051> <6.133, 0.631, 9.142> <5.375, 0.595, 9.263> <4.807, 0.568, 9.354> 
		<6.621, 0.596, 8.963> <6.053, 0.569, 9.054> <5.529, 0.558, 9.154> <4.960, 0.531, 9.245> 
		<6.514, 0.513, 8.845> <6.180, 0.511, 8.916> <5.500, 0.484, 9.030> <5.166, 0.483, 9.101> 
		<6.434, 0.450, 8.757> <6.100, 0.449, 8.828> <5.654, 0.448, 8.922> <5.319, 0.446, 8.992> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.807, 0.568, 9.354> <4.650, 0.595, 9.187> <4.442, 0.632, 8.966> <4.286, 0.660, 8.799> 
		<4.960, 0.531, 9.245> <4.804, 0.559, 9.079> <4.608, 0.516, 8.832> <4.452, 0.543, 8.666> 
		<5.166, 0.483, 9.101> <5.022, 0.430, 8.909> <4.818, 0.440, 8.679> <4.674, 0.388, 8.487> 
		<5.319, 0.446, 8.992> <5.176, 0.394, 8.801> <4.984, 0.324, 8.545> <4.840, 0.272, 8.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.286, 0.660, 8.799> <4.177, 0.651, 9.050> <4.031, 0.639, 9.384> <3.922, 0.630, 9.635> 
		<4.452, 0.543, 8.666> <4.343, 0.534, 8.916> <4.299, 0.564, 9.312> <4.189, 0.555, 9.563> 
		<4.674, 0.388, 8.487> <4.666, 0.421, 8.800> <4.554, 0.423, 9.154> <4.547, 0.456, 9.467> 
		<4.840, 0.272, 8.354> <4.833, 0.305, 8.666> <4.822, 0.349, 9.082> <4.815, 0.382, 9.395> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.922, 0.630, 9.635> <3.532, 0.612, 9.286> <3.012, 0.589, 8.821> <2.622, 0.571, 8.472> 
		<4.189, 0.555, 9.563> <3.800, 0.538, 9.214> <3.289, 0.586, 8.875> <2.899, 0.568, 8.526> 
		<4.547, 0.456, 9.467> <4.166, 0.510, 9.244> <3.649, 0.511, 8.820> <3.268, 0.565, 8.597> 
		<4.815, 0.382, 9.395> <4.434, 0.436, 9.171> <3.926, 0.508, 8.874> <3.545, 0.562, 8.651> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.622, 0.571, 8.472> <2.739, 0.565, 8.142> <2.895, 0.556, 7.701> <3.012, 0.550, 7.370> 
		<2.899, 0.568, 8.526> <3.016, 0.562, 8.195> <3.216, 0.480, 7.731> <3.333, 0.474, 7.400> 
		<3.268, 0.565, 8.597> <3.429, 0.485, 8.243> <3.599, 0.453, 7.794> <3.760, 0.373, 7.440> 
		<3.545, 0.562, 8.651> <3.706, 0.483, 8.296> <3.919, 0.377, 7.824> <4.080, 0.298, 7.469> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.012, 0.550, 7.370> <3.234, 0.656, 7.289> <3.529, 0.798, 7.180> <3.750, 0.905, 7.099> 
		<3.333, 0.474, 7.400> <3.554, 0.581, 7.319> <3.749, 0.643, 7.187> <3.971, 0.749, 7.105> 
		<3.760, 0.373, 7.440> <3.881, 0.400, 7.335> <4.143, 0.515, 7.219> <4.264, 0.541, 7.114> 
		<4.080, 0.298, 7.469> <4.201, 0.324, 7.365> <4.363, 0.359, 7.225> <4.485, 0.386, 7.120> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.750, 0.905, 7.099> <3.973, 0.836, 6.718> <4.271, 0.743, 6.211> <4.494, 0.674, 5.830> 
		<3.971, 0.749, 7.105> <4.194, 0.680, 6.725> <4.518, 0.744, 6.316> <4.741, 0.675, 5.935> 
		<4.264, 0.541, 7.114> <4.514, 0.628, 6.832> <4.821, 0.588, 6.357> <5.071, 0.675, 6.075> 
		<4.485, 0.386, 7.120> <4.735, 0.473, 6.838> <5.068, 0.589, 6.462> <5.318, 0.676, 6.179> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.494, 0.674, 5.830> <4.831, 0.763, 5.966> <5.280, 0.882, 6.147> <5.617, 0.971, 6.282> 
		<4.741, 0.675, 5.935> <5.078, 0.764, 6.071> <5.283, 0.668, 6.375> <5.619, 0.757, 6.510> 
		<5.071, 0.675, 6.075> <5.163, 0.549, 6.334> <5.530, 0.597, 6.556> <5.623, 0.471, 6.815> 
		<5.318, 0.676, 6.179> <5.410, 0.550, 6.438> <5.533, 0.382, 6.784> <5.625, 0.256, 7.043> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.617, 0.971, 6.282> <5.894, 0.901, 6.109> <6.265, 0.807, 5.878> <6.543, 0.737, 5.704> 
		<5.619, 0.757, 6.510> <5.897, 0.687, 6.337> <6.179, 0.703, 6.104> <6.457, 0.633, 5.930> 
		<5.623, 0.471, 6.815> <5.812, 0.511, 6.639> <6.153, 0.454, 6.407> <6.342, 0.494, 6.232> 
		<5.625, 0.256, 7.043> <5.815, 0.296, 6.867> <6.067, 0.350, 6.634> <6.256, 0.389, 6.458> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.543, 0.737, 5.704> <6.655, 0.755, 6.158> <6.804, 0.779, 6.762> <6.917, 0.797, 7.215> 
		<6.457, 0.633, 5.930> <6.569, 0.651, 6.384> <6.595, 0.670, 6.855> <6.707, 0.688, 7.308> 
		<6.342, 0.494, 6.232> <6.330, 0.507, 6.552> <6.439, 0.529, 7.112> <6.427, 0.542, 7.432> 
		<6.256, 0.389, 6.458> <6.245, 0.402, 6.778> <6.229, 0.420, 7.205> <6.217, 0.433, 7.524> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.015, 0.892, 8.334> <6.832, 0.878, 8.531> <6.588, 0.859, 8.795> <6.406, 0.845, 8.992> 
		<6.957, 0.943, 8.113> <6.775, 0.929, 8.310> <6.726, 0.864, 8.593> <6.543, 0.850, 8.791> 
		<6.881, 1.011, 7.818> <6.893, 0.951, 8.035> <6.714, 0.917, 8.305> <6.726, 0.857, 8.523> 
		<6.823, 1.062, 7.597> <6.835, 1.002, 7.814> <6.851, 0.922, 8.104> <6.863, 0.862, 8.321> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.015, 0.892, 8.334> <6.957, 0.943, 8.113> <6.881, 1.011, 7.818> <6.823, 1.062, 7.597> 
		<7.264, 0.766, 8.458> <7.207, 0.817, 8.237> <6.903, 0.769, 7.828> <6.845, 0.819, 7.607> 
		<7.596, 0.597, 8.624> <7.312, 0.532, 8.288> <7.160, 0.561, 7.955> <6.875, 0.497, 7.620> 
		<7.846, 0.471, 8.748> <7.561, 0.406, 8.413> <7.182, 0.319, 7.965> <6.897, 0.255, 7.629> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.015, 0.892, 8.334> <7.264, 0.766, 8.458> <7.596, 0.597, 8.624> <7.846, 0.471, 8.748> 
		<6.832, 0.878, 8.531> <7.081, 0.752, 8.656> <7.323, 0.642, 8.684> <7.573, 0.516, 8.809> 
		<6.588, 0.859, 8.795> <6.747, 0.792, 8.782> <7.050, 0.643, 8.902> <7.209, 0.576, 8.889> 
		<6.406, 0.845, 8.992> <6.565, 0.778, 8.979> <6.777, 0.688, 8.962> <6.936, 0.621, 8.949> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.406, 0.845, 8.992> <6.565, 0.778, 8.979> <6.777, 0.688, 8.962> <6.936, 0.621, 8.949> 
		<6.543, 0.850, 8.791> <6.702, 0.783, 8.778> <6.846, 0.712, 8.690> <7.005, 0.645, 8.677> 
		<6.726, 0.857, 8.523> <6.817, 0.809, 8.438> <7.006, 0.725, 8.397> <7.097, 0.677, 8.313> 
		<6.863, 0.862, 8.321> <6.954, 0.813, 8.237> <7.075, 0.749, 8.125> <7.165, 0.700, 8.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.618, 0.792, 7.594> <4.674, 0.863, 7.783> <4.748, 0.958, 8.034> <4.804, 1.029, 8.223> 
		<4.456, 0.643, 7.557> <4.512, 0.715, 7.745> <4.371, 0.818, 8.163> <4.427, 0.889, 8.351> 
		<4.241, 0.446, 7.507> <4.081, 0.525, 7.861> <4.083, 0.623, 8.168> <3.923, 0.702, 8.522> 
		<4.080, 0.298, 7.469> <3.919, 0.377, 7.824> <3.706, 0.483, 8.296> <3.545, 0.562, 8.651> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.618, 0.792, 7.594> <4.729, 0.803, 7.560> <4.878, 0.819, 7.515> <4.990, 0.831, 7.481> 
		<4.674, 0.863, 7.783> <4.785, 0.875, 7.749> <4.953, 0.909, 7.373> <5.065, 0.921, 7.339> 
		<4.748, 0.958, 8.034> <4.879, 0.988, 7.670> <5.034, 1.010, 7.515> <5.164, 1.041, 7.151> 
		<4.804, 1.029, 8.223> <4.935, 1.060, 7.859> <5.109, 1.101, 7.373> <5.239, 1.131, 7.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.618, 0.792, 7.594> <4.456, 0.643, 7.557> <4.241, 0.446, 7.507> <4.080, 0.298, 7.469> 
		<4.729, 0.803, 7.560> <4.568, 0.655, 7.523> <4.363, 0.472, 7.402> <4.201, 0.324, 7.365> 
		<4.878, 0.819, 7.515> <4.727, 0.685, 7.407> <4.515, 0.493, 7.333> <4.363, 0.359, 7.225> 
		<4.990, 0.831, 7.481> <4.838, 0.697, 7.373> <4.636, 0.519, 7.228> <4.485, 0.386, 7.120> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.990, 0.831, 7.481> <4.838, 0.697, 7.373> <4.636, 0.519, 7.228> <4.485, 0.386, 7.120> 
		<5.065, 0.921, 7.339> <4.913, 0.787, 7.231> <4.886, 0.606, 6.946> <4.735, 0.473, 6.838> 
		<5.164, 1.041, 7.151> <5.188, 0.904, 6.902> <5.044, 0.725, 6.710> <5.068, 0.589, 6.462> 
		<5.239, 1.131, 7.009> <5.263, 0.994, 6.760> <5.294, 0.812, 6.428> <5.318, 0.676, 6.179> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.737, 0.685, 6.921> <6.613, 0.781, 7.206> <6.449, 0.910, 7.587> <6.326, 1.006, 7.872> 
		<6.581, 0.609, 7.102> <6.458, 0.706, 7.387> <6.427, 0.965, 7.520> <6.303, 1.061, 7.805> 
		<6.373, 0.508, 7.343> <6.383, 0.736, 7.381> <6.263, 0.908, 7.678> <6.273, 1.135, 7.715> 
		<6.217, 0.433, 7.524> <6.227, 0.660, 7.562> <6.240, 0.963, 7.611> <6.250, 1.190, 7.648> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.737, 0.685, 6.921> <6.785, 0.556, 7.134> <6.849, 0.384, 7.417> <6.897, 0.255, 7.629> 
		<6.613, 0.781, 7.206> <6.662, 0.652, 7.419> <6.827, 0.626, 7.407> <6.875, 0.497, 7.620> 
		<6.449, 0.910, 7.587> <6.598, 0.926, 7.504> <6.696, 0.803, 7.689> <6.845, 0.819, 7.607> 
		<6.326, 1.006, 7.872> <6.475, 1.023, 7.789> <6.674, 1.045, 7.679> <6.823, 1.062, 7.597> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.165, 0.700, 8.041> <6.946, 0.625, 8.256> <6.654, 0.525, 8.542> <6.434, 0.450, 8.757> 
		<7.075, 0.749, 8.125> <6.855, 0.674, 8.340> <6.682, 0.664, 8.427> <6.463, 0.589, 8.642> 
		<6.954, 0.813, 8.237> <6.853, 0.829, 8.253> <6.601, 0.759, 8.473> <6.500, 0.774, 8.489> 
		<6.863, 0.862, 8.321> <6.763, 0.877, 8.337> <6.629, 0.897, 8.358> <6.528, 0.913, 8.374> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.434, 0.450, 8.757> <6.100, 0.449, 8.828> <5.654, 0.448, 8.922> <5.319, 0.446, 8.992> 
		<6.463, 0.589, 8.642> <6.128, 0.588, 8.713> <5.560, 0.631, 8.858> <5.226, 0.629, 8.929> 
		<6.500, 0.774, 8.489> <6.044, 0.817, 8.611> <5.557, 0.830, 8.722> <5.100, 0.873, 8.844> 
		<6.528, 0.913, 8.374> <6.072, 0.956, 8.496> <5.463, 1.013, 8.659> <5.007, 1.056, 8.781> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.319, 0.446, 8.992> <5.176, 0.394, 8.801> <4.984, 0.324, 8.545> <4.840, 0.272, 8.354> 
		<5.226, 0.629, 8.929> <5.082, 0.577, 8.737> <5.056, 0.604, 8.701> <4.912, 0.551, 8.510> 
		<5.100, 0.873, 8.844> <5.123, 0.917, 8.872> <4.986, 0.880, 8.690> <5.008, 0.924, 8.718> 
		<5.007, 1.056, 8.781> <5.029, 1.100, 8.809> <5.058, 1.159, 8.846> <5.080, 1.203, 8.874> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.840, 0.272, 8.354> <4.833, 0.305, 8.666> <4.822, 0.349, 9.082> <4.815, 0.382, 9.395> 
		<4.912, 0.551, 8.510> <4.905, 0.584, 8.822> <4.873, 0.570, 8.902> <4.866, 0.603, 9.215> 
		<5.008, 0.924, 8.718> <4.980, 0.899, 8.694> <4.963, 0.923, 8.999> <4.934, 0.898, 8.975> 
		<5.080, 1.203, 8.874> <5.052, 1.178, 8.850> <5.014, 1.144, 8.819> <4.985, 1.119, 8.795> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.815, 0.382, 9.395> <4.434, 0.436, 9.171> <3.926, 0.508, 8.874> <3.545, 0.562, 8.651> 
		<4.866, 0.603, 9.215> <4.485, 0.657, 8.991> <4.304, 0.648, 8.745> <3.923, 0.702, 8.522> 
		<4.934, 0.898, 8.975> <4.880, 0.871, 8.803> <4.481, 0.916, 8.523> <4.427, 0.889, 8.351> 
		<4.985, 1.119, 8.795> <4.931, 1.092, 8.623> <4.859, 1.056, 8.395> <4.804, 1.029, 8.223> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.318, 0.676, 6.179> <5.410, 0.550, 6.438> <5.533, 0.382, 6.784> <5.625, 0.256, 7.043> 
		<5.294, 0.812, 6.428> <5.386, 0.687, 6.687> <5.538, 0.581, 6.841> <5.630, 0.455, 7.100> 
		<5.263, 0.994, 6.760> <5.384, 0.931, 6.828> <5.516, 0.784, 7.110> <5.637, 0.721, 7.177> 
		<5.239, 1.131, 7.009> <5.360, 1.068, 7.077> <5.521, 0.983, 7.167> <5.642, 0.920, 7.235> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.625, 0.256, 7.043> <5.815, 0.296, 6.867> <6.067, 0.350, 6.634> <6.256, 0.389, 6.458> 
		<5.630, 0.455, 7.100> <5.820, 0.495, 6.925> <5.966, 0.518, 6.840> <6.155, 0.558, 6.665> 
		<5.637, 0.721, 7.177> <5.720, 0.730, 7.151> <5.937, 0.773, 6.967> <6.020, 0.783, 6.941> 
		<5.642, 0.920, 7.235> <5.725, 0.929, 7.209> <5.836, 0.942, 7.174> <5.919, 0.952, 7.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.256, 0.389, 6.458> <6.245, 0.402, 6.778> <6.229, 0.420, 7.205> <6.217, 0.433, 7.524> 
		<6.155, 0.558, 6.665> <6.143, 0.571, 6.985> <6.239, 0.647, 7.242> <6.227, 0.660, 7.562> 
		<6.020, 0.783, 6.941> <6.120, 0.854, 7.091> <6.141, 0.891, 7.461> <6.240, 0.963, 7.611> 
		<5.919, 0.952, 7.148> <6.019, 1.023, 7.298> <6.151, 1.118, 7.498> <6.250, 1.190, 7.648> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.239, 1.131, 7.009> <5.360, 1.068, 7.077> <5.521, 0.983, 7.167> <5.642, 0.920, 7.235> 
		<5.109, 1.101, 7.373> <5.230, 1.037, 7.441> <5.324, 1.043, 7.635> <5.445, 0.980, 7.703> 
		<4.935, 1.060, 7.859> <4.989, 1.087, 8.030> <5.128, 1.032, 8.155> <5.182, 1.059, 8.327> 
		<4.804, 1.029, 8.223> <4.859, 1.056, 8.395> <4.931, 1.092, 8.623> <4.985, 1.119, 8.795> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.642, 0.920, 7.235> <5.725, 0.929, 7.209> <5.836, 0.942, 7.174> <5.919, 0.952, 7.148> 
		<5.445, 0.980, 7.703> <5.528, 0.989, 7.677> <5.584, 1.018, 7.692> <5.668, 1.027, 7.666> 
		<5.182, 1.059, 8.327> <5.211, 1.085, 8.351> <5.303, 1.103, 8.332> <5.332, 1.128, 8.356> 
		<4.985, 1.119, 8.795> <5.014, 1.144, 8.819> <5.052, 1.178, 8.850> <5.080, 1.203, 8.874> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.919, 0.952, 7.148> <6.019, 1.023, 7.298> <6.151, 1.118, 7.498> <6.250, 1.190, 7.648> 
		<5.668, 1.027, 7.666> <5.767, 1.099, 7.816> <5.778, 1.078, 7.838> <5.877, 1.150, 7.988> 
		<5.332, 1.128, 8.356> <5.310, 1.084, 8.328> <5.402, 1.140, 8.469> <5.380, 1.096, 8.441> 
		<5.080, 1.203, 8.874> <5.058, 1.159, 8.846> <5.029, 1.100, 8.809> <5.007, 1.056, 8.781> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.250, 1.190, 7.648> <6.273, 1.135, 7.715> <6.303, 1.061, 7.805> <6.326, 1.006, 7.872> 
		<5.877, 1.150, 7.988> <5.900, 1.095, 8.055> <6.364, 1.033, 7.955> <6.387, 0.978, 8.022> 
		<5.380, 1.096, 8.441> <5.836, 1.053, 8.319> <6.011, 0.984, 8.345> <6.468, 0.941, 8.223> 
		<5.007, 1.056, 8.781> <5.463, 1.013, 8.659> <6.072, 0.956, 8.496> <6.528, 0.913, 8.374> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.326, 1.006, 7.872> <6.475, 1.023, 7.789> <6.674, 1.045, 7.679> <6.823, 1.062, 7.597> 
		<6.387, 0.978, 8.022> <6.536, 0.995, 7.940> <6.686, 0.985, 7.897> <6.835, 1.002, 7.814> 
		<6.468, 0.941, 8.223> <6.568, 0.925, 8.207> <6.751, 0.937, 8.120> <6.851, 0.922, 8.104> 
		<6.528, 0.913, 8.374> <6.629, 0.897, 8.358> <6.763, 0.877, 8.337> <6.863, 0.862, 8.321> 
	}
	
	texture { txRocks }
}

// Layer 3
#declare oCliff =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.589, -0.717, 81.864> <-5.278, 0.008, 81.713> <-6.566, 0.766, 81.139> <-6.884, 1.700, 81.361> 
		<-4.042, -0.637, 78.293> <-4.730, 0.088, 78.142> <-4.950, 1.015, 77.630> <-5.268, 1.949, 77.852> 
		<-2.349, -0.491, 73.550> <-1.970, 0.403, 73.461> <-1.868, 1.619, 73.750> <-1.937, 2.561, 73.510> 
		<-2.763, -0.449, 69.961> <-2.384, 0.445, 69.872> <-1.429, 1.587, 69.904> <-1.498, 2.530, 69.664> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.763, -0.449, 69.961> <-2.384, 0.445, 69.872> <-1.429, 1.587, 69.904> <-1.498, 2.530, 69.664> 
		<-2.913, -0.434, 68.665> <-2.533, 0.460, 68.576> <-1.253, 1.575, 68.358> <-1.322, 2.517, 68.118> 
		<-5.226, -0.543, 68.174> <-4.890, 0.094, 67.790> <-3.967, 0.754, 67.244> <-3.967, 1.561, 67.119> 
		<-6.261, -0.550, 67.380> <-5.925, 0.088, 66.996> <-5.143, 0.769, 66.225> <-5.143, 1.575, 66.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.261, -0.550, 67.380> <-5.925, 0.088, 66.996> <-5.143, 0.769, 66.225> <-5.143, 1.575, 66.099> 
		<-7.118, -0.555, 66.723> <-6.783, 0.083, 66.339> <-5.980, 0.779, 65.499> <-5.980, 1.585, 65.374> 
		<-8.039, -0.612, 65.429> <-7.722, 0.316, 65.096> <-7.216, 1.591, 63.965> <-6.909, 2.579, 63.923> 
		<-9.068, -0.486, 65.127> <-8.751, 0.442, 64.794> <-8.320, 1.620, 64.058> <-8.013, 2.608, 64.017> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.068, -0.486, 65.127> <-8.751, 0.442, 64.794> <-8.320, 1.620, 64.058> <-8.013, 2.608, 64.017> 
		<-10.148, -0.353, 64.810> <-9.832, 0.575, 64.477> <-10.501, 1.678, 64.243> <-10.194, 2.667, 64.201> 
		<-12.189, 0.018, 66.425> <-12.763, 0.492, 66.855> <-12.291, 1.138, 67.163> <-12.549, 1.911, 67.437> 
		<-12.759, 0.248, 65.472> <-13.333, 0.723, 65.902> <-14.414, 1.056, 66.631> <-14.672, 1.829, 66.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-12.759, 0.248, 65.472> <-13.333, 0.723, 65.902> <-14.414, 1.056, 66.631> <-14.672, 1.829, 66.905> 
		<-13.415, 0.513, 64.377> <-13.989, 0.987, 64.807> <-15.892, 1.000, 66.261> <-16.150, 1.773, 66.535> 
		<-10.592, 0.695, 62.430> <-10.573, 1.314, 62.978> <-12.295, 1.668, 63.768> <-12.276, 2.288, 64.316> 
		<-11.313, 0.420, 61.379> <-11.293, 1.039, 61.927> <-11.268, 1.865, 62.658> <-11.249, 2.484, 63.206> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.313, 0.420, 61.379> <-11.293, 1.039, 61.927> <-11.268, 1.865, 62.658> <-11.249, 2.484, 63.206> 
		<-11.973, 0.168, 60.414> <-11.954, 0.787, 60.963> <-11.993, 1.508, 61.977> <-11.974, 2.127, 62.525> 
		<-14.404, -0.469, 63.032> <-13.976, 0.112, 62.692> <-13.409, 0.518, 61.902> <-13.261, 1.301, 61.913> 
		<-15.091, -0.641, 62.069> <-14.664, -0.061, 61.729> <-13.814, 0.511, 60.926> <-13.666, 1.294, 60.937> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.091, -0.641, 62.069> <-14.664, -0.061, 61.729> <-13.814, 0.511, 60.926> <-13.666, 1.294, 60.937> 
		<-15.936, -0.853, 60.887> <-15.508, -0.272, 60.548> <-14.261, 0.503, 59.848> <-14.114, 1.286, 59.859> 
		<-14.507, -0.415, 58.702> <-14.350, 0.413, 58.690> <-13.723, 1.413, 58.387> <-13.496, 2.224, 58.342> 
		<-14.257, -0.317, 57.259> <-14.100, 0.510, 57.247> <-13.960, 1.632, 57.265> <-13.733, 2.442, 57.220> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.257, -0.317, 57.259> <-14.100, 0.510, 57.247> <-13.960, 1.632, 57.265> <-13.733, 2.442, 57.220> 
		<-14.588, -0.023, 55.775> <-14.431, 0.805, 55.763> <-14.299, 1.945, 55.656> <-14.073, 2.756, 55.611> 
		<-15.240, 0.749, 53.853> <-15.299, 1.461, 53.754> <-15.865, 2.442, 53.596> <-15.736, 3.151, 53.641> 
		<-15.361, 0.665, 52.311> <-15.420, 1.377, 52.212> <-15.685, 2.330, 51.936> <-15.557, 3.038, 51.980> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.361, 0.665, 52.311> <-15.420, 1.377, 52.212> <-15.685, 2.330, 51.936> <-15.557, 3.038, 51.980> 
		<-15.526, 0.551, 50.204> <-15.585, 1.263, 50.104> <-15.442, 2.178, 49.693> <-15.314, 2.887, 49.737> 
		<-15.284, -0.717, 47.546> <-14.461, 0.060, 47.492> <-13.044, 0.638, 47.507> <-12.519, 1.643, 47.523> 
		<-15.183, -0.959, 45.445> <-14.359, -0.181, 45.391> <-12.964, 0.628, 45.247> <-12.438, 1.633, 45.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.183, -0.959, 45.445> <-14.359, -0.181, 45.391> <-12.964, 0.628, 45.247> <-12.438, 1.633, 45.263> 
		<-15.148, -1.041, 44.731> <-14.325, -0.263, 44.677> <-12.917, 0.623, 43.922> <-12.391, 1.627, 43.938> 
		<-14.409, -0.612, 43.588> <-14.495, 0.404, 43.279> <-14.289, 1.571, 43.357> <-14.375, 2.587, 43.047> 
		<-14.918, -0.390, 43.130> <-15.004, 0.625, 42.820> <-15.119, 1.980, 42.407> <-15.205, 2.995, 42.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.918, -0.390, 43.130> <-15.004, 0.625, 42.820> <-15.119, 1.980, 42.407> <-15.205, 2.995, 42.097> 
		<-15.579, -0.103, 42.534> <-15.665, 0.913, 42.224> <-15.972, 1.719, 42.468> <-16.059, 2.735, 42.158> 
		<-17.166, 0.199, 43.425> <-17.192, 0.762, 43.234> <-17.328, 1.850, 42.609> <-17.329, 2.432, 42.734> 
		<-17.963, 0.250, 42.938> <-17.989, 0.813, 42.747> <-18.049, 1.545, 42.176> <-18.050, 2.126, 42.302> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-17.963, 0.250, 42.938> <-17.989, 0.813, 42.747> <-18.049, 1.545, 42.176> <-18.050, 2.126, 42.302> 
		<-18.909, 0.311, 42.361> <-18.935, 0.874, 42.170> <-18.799, 1.227, 41.726> <-18.800, 1.808, 41.852> 
		<-19.664, 0.131, 40.944> <-19.427, 0.521, 40.844> <-19.001, 0.829, 40.390> <-18.939, 1.287, 40.460> 
		<-20.126, -0.054, 39.952> <-19.889, 0.335, 39.852> <-19.398, 0.787, 39.549> <-19.335, 1.245, 39.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-20.126, -0.054, 39.952> <-19.889, 0.335, 39.852> <-19.398, 0.787, 39.549> <-19.335, 1.245, 39.619> 
		<-21.081, -0.437, 37.901> <-20.844, -0.047, 37.801> <-20.336, 0.687, 37.556> <-20.274, 1.144, 37.625> 
		<-22.109, -1.617, 35.133> <-22.051, -0.633, 35.154> <-21.705, 0.411, 35.106> <-21.908, 1.376, 35.090> 
		<-22.636, -1.624, 32.901> <-22.579, -0.640, 32.921> <-22.242, 0.692, 32.985> <-22.445, 1.656, 32.969> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-22.636, -1.624, 32.901> <-22.579, -0.640, 32.921> <-22.242, 0.692, 32.985> <-22.445, 1.656, 32.969> 
		<-22.907, -1.627, 31.752> <-22.850, -0.643, 31.773> <-22.622, 0.891, 31.484> <-22.825, 1.855, 31.468> 
		<-23.192, -0.194, 30.321> <-23.089, 0.671, 29.905> <-23.008, 1.736, 29.527> <-22.926, 2.675, 29.321> 
		<-22.646, -0.087, 29.280> <-22.544, 0.778, 28.864> <-22.386, 1.857, 28.101> <-22.304, 2.797, 27.895> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-22.646, -0.087, 29.280> <-22.544, 0.778, 28.864> <-22.386, 1.857, 28.101> <-22.304, 2.797, 27.895> 
		<-21.988, 0.041, 28.024> <-21.885, 0.906, 27.609> <-21.806, 1.971, 26.772> <-21.724, 2.910, 26.566> 
		<-19.413, -0.841, 27.602> <-19.310, 0.152, 27.114> <-19.077, 1.418, 26.303> <-19.055, 2.490, 26.009> 
		<-19.130, -0.939, 26.210> <-19.027, 0.054, 25.722> <-18.809, 1.300, 24.878> <-18.788, 2.372, 24.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-19.130, -0.939, 26.210> <-19.027, 0.054, 25.722> <-18.809, 1.300, 24.878> <-18.788, 2.372, 24.584> 
		<-18.820, -1.047, 24.687> <-18.717, -0.054, 24.200> <-18.553, 1.187, 23.517> <-18.532, 2.259, 23.223> 
		<-21.435, -0.687, 22.898> <-21.396, 0.161, 22.623> <-21.415, 1.598, 22.004> <-21.309, 2.455, 21.775> 
		<-21.042, -0.646, 21.392> <-21.002, 0.203, 21.116> <-21.016, 1.326, 20.702> <-20.910, 2.183, 20.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-21.042, -0.646, 21.392> <-21.002, 0.203, 21.116> <-21.016, 1.326, 20.702> <-20.910, 2.183, 20.473> 
		<-20.556, -0.595, 19.529> <-20.516, 0.254, 19.253> <-20.497, 0.973, 19.010> <-20.391, 1.829, 18.781> 
		<-17.960, -0.710, 18.122> <-17.883, -0.285, 18.141> <-17.541, 0.278, 18.122> <-17.555, 0.709, 18.153> 
		<-16.650, -0.677, 16.711> <-16.573, -0.253, 16.730> <-16.380, 0.308, 16.742> <-16.393, 0.739, 16.772> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-16.650, -0.677, 16.711> <-16.573, -0.253, 16.730> <-16.380, 0.308, 16.742> <-16.393, 0.739, 16.772> 
		<-16.176, -0.666, 16.200> <-16.099, -0.241, 16.219> <-15.687, 0.326, 15.917> <-15.700, 0.757, 15.948> 
		<-15.186, -0.451, 15.680> <-15.235, 0.397, 15.311> <-15.120, 1.330, 14.878> <-15.266, 2.243, 14.832> 
		<-15.099, -0.497, 14.989> <-15.149, 0.352, 14.620> <-15.118, 1.417, 13.805> <-15.264, 2.331, 13.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.099, -0.497, 14.989> <-15.149, 0.352, 14.620> <-15.118, 1.417, 13.805> <-15.264, 2.331, 13.759> 
		<-14.983, -0.559, 14.058> <-15.032, 0.290, 13.689> <-15.116, 1.495, 12.844> <-15.262, 2.409, 12.799> 
		<-16.120, -0.993, 12.986> <-16.214, -0.333, 12.662> <-16.829, 0.524, 11.918> <-16.616, 1.234, 11.898> 
		<-16.067, -0.987, 12.047> <-16.161, -0.327, 11.722> <-16.595, 0.502, 10.983> <-16.382, 1.212, 10.964> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-16.067, -0.987, 12.047> <-16.161, -0.327, 11.722> <-16.595, 0.502, 10.983> <-16.382, 1.212, 10.964> 
		<-16.001, -0.980, 10.884> <-16.095, -0.320, 10.559> <-16.292, 0.474, 9.776> <-16.079, 1.184, 9.757> 
		<-14.915, -0.643, 9.575> <-14.634, 0.152, 9.406> <-14.301, 1.291, 8.936> <-14.253, 2.144, 9.030> 
		<-14.728, -0.458, 8.440> <-14.447, 0.337, 8.271> <-13.837, 1.338, 7.781> <-13.789, 2.191, 7.875> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.728, -0.458, 8.440> <-14.447, 0.337, 8.271> <-13.837, 1.338, 7.781> <-13.789, 2.191, 7.875> 
		<-14.504, -0.235, 7.075> <-14.222, 0.559, 6.906> <-13.336, 1.388, 6.533> <-13.287, 2.242, 6.628> 
		<-14.995, 0.185, 5.203> <-14.591, 0.536, 5.089> <-13.530, 1.047, 4.685> <-13.420, 1.569, 4.804> 
		<-14.714, 0.350, 3.840> <-14.310, 0.700, 3.726> <-13.475, 0.994, 3.341> <-13.365, 1.517, 3.460> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.714, 0.350, 3.840> <-14.310, 0.700, 3.726> <-13.475, 0.994, 3.341> <-13.365, 1.517, 3.460> 
		<-14.441, 0.510, 2.513> <-14.036, 0.860, 2.400> <-13.411, 0.933, 1.772> <-13.301, 1.456, 1.891> 
		<-13.014, 0.709, 1.027> <-13.157, 1.073, 0.595> <-13.151, 1.276, -0.083> <-13.182, 1.844, -0.213> 
		<-12.919, 0.600, -0.329> <-13.062, 0.965, -0.761> <-13.364, 1.247, -1.640> <-13.395, 1.815, -1.770> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-12.919, 0.600, -0.329> <-13.062, 0.965, -0.761> <-13.364, 1.247, -1.640> <-13.395, 1.815, -1.770> 
		<-12.758, 0.417, -2.629> <-12.901, 0.781, -3.061> <-13.643, 1.209, -3.677> <-13.674, 1.776, -3.807> 
		<-13.602, -0.231, -5.617> <-13.931, 0.333, -5.777> <-14.498, 0.778, -6.453> <-14.513, 1.450, -6.422> 
		<-13.895, -0.587, -7.884> <-14.224, -0.023, -8.044> <-14.977, 0.622, -8.447> <-14.992, 1.293, -8.416> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.884, 1.700, 81.361> <-7.201, 2.633, 81.582> <-6.456, 3.531, 82.995> <-6.377, 4.531, 83.110> 
		<-5.268, 1.949, 77.852> <-5.586, 2.882, 78.073> <-5.486, 3.597, 78.653> <-5.408, 4.597, 78.768> 
		<-1.937, 2.561, 73.510> <-2.000, 3.417, 73.292> <-2.944, 3.936, 73.020> <-3.177, 4.787, 73.085> 
		<-1.498, 2.530, 69.664> <-1.561, 3.385, 69.446> <-2.914, 3.899, 68.571> <-3.146, 4.750, 68.636> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.498, 2.530, 69.664> <-1.561, 3.385, 69.446> <-2.914, 3.899, 68.571> <-3.146, 4.750, 68.636> 
		<-1.322, 2.517, 68.118> <-1.385, 3.373, 67.900> <-2.906, 3.890, 67.451> <-3.138, 4.741, 67.516> 
		<-3.967, 1.561, 67.119> <-3.968, 2.473, 66.977> <-5.232, 3.615, 67.146> <-5.405, 4.504, 67.324> 
		<-5.143, 1.575, 66.099> <-5.144, 2.487, 65.958> <-6.090, 3.506, 66.435> <-6.263, 4.395, 66.613> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.143, 1.575, 66.099> <-5.144, 2.487, 65.958> <-6.090, 3.506, 66.435> <-6.263, 4.395, 66.613> 
		<-5.980, 1.585, 65.374> <-5.981, 2.498, 65.232> <-6.590, 3.442, 66.022> <-6.762, 4.331, 66.199> 
		<-6.909, 2.579, 63.923> <-6.744, 3.112, 63.901> <-7.116, 3.501, 64.813> <-6.986, 4.042, 64.856> 
		<-8.013, 2.608, 64.017> <-7.847, 3.141, 63.994> <-7.748, 3.640, 64.887> <-7.618, 4.181, 64.930> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.013, 2.608, 64.017> <-7.847, 3.141, 63.994> <-7.748, 3.640, 64.887> <-7.618, 4.181, 64.930> 
		<-10.194, 2.667, 64.201> <-10.029, 3.199, 64.179> <-10.052, 4.147, 65.157> <-9.922, 4.689, 65.200> 
		<-12.549, 1.911, 67.437> <-12.954, 3.123, 67.867> <-12.444, 4.693, 68.050> <-12.451, 6.042, 68.069> 
		<-14.672, 1.829, 66.905> <-15.077, 3.042, 67.335> <-14.762, 4.920, 67.588> <-14.769, 6.268, 67.607> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.672, 1.829, 66.905> <-15.077, 3.042, 67.335> <-14.762, 4.920, 67.588> <-14.769, 6.268, 67.607> 
		<-16.150, 1.773, 66.535> <-16.555, 2.985, 66.965> <-16.102, 5.051, 67.321> <-16.109, 6.399, 67.340> 
		<-12.276, 2.288, 64.316> <-12.662, 2.941, 64.539> <-12.660, 4.129, 65.294> <-12.727, 4.917, 65.286> 
		<-11.249, 2.484, 63.206> <-11.635, 3.137, 63.429> <-12.468, 3.874, 63.959> <-12.536, 4.662, 63.950> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.249, 2.484, 63.206> <-11.635, 3.137, 63.429> <-12.468, 3.874, 63.959> <-12.536, 4.662, 63.950> 
		<-11.974, 2.127, 62.525> <-12.360, 2.780, 62.749> <-12.369, 3.741, 63.265> <-12.436, 4.529, 63.256> 
		<-13.261, 1.301, 61.913> <-13.032, 2.517, 61.930> <-13.956, 4.028, 62.609> <-13.949, 5.240, 62.863> 
		<-13.666, 1.294, 60.937> <-13.437, 2.510, 60.954> <-13.994, 4.013, 61.896> <-13.987, 5.224, 62.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.666, 1.294, 60.937> <-13.437, 2.510, 60.954> <-13.994, 4.013, 61.896> <-13.987, 5.224, 62.150> 
		<-14.114, 1.286, 59.859> <-13.885, 2.503, 59.876> <-14.079, 3.979, 60.302> <-14.072, 5.190, 60.556> 
		<-13.496, 2.224, 58.342> <-13.316, 2.870, 58.306> <-12.849, 3.685, 58.591> <-12.843, 4.357, 58.576> 
		<-13.733, 2.442, 57.220> <-13.552, 3.089, 57.184> <-12.913, 3.840, 57.004> <-12.906, 4.512, 56.988> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.733, 2.442, 57.220> <-13.552, 3.089, 57.184> <-12.913, 3.840, 57.004> <-12.906, 4.512, 56.988> 
		<-14.073, 2.756, 55.611> <-13.892, 3.402, 55.575> <-12.971, 3.981, 55.555> <-12.964, 4.653, 55.539> 
		<-15.736, 3.151, 53.641> <-15.555, 4.153, 53.704> <-14.517, 5.216, 54.129> <-14.400, 6.229, 54.111> 
		<-15.557, 3.038, 51.980> <-15.375, 4.040, 52.043> <-14.483, 5.138, 52.675> <-14.366, 6.151, 52.656> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.557, 3.038, 51.980> <-15.375, 4.040, 52.043> <-14.483, 5.138, 52.675> <-14.366, 6.151, 52.656> 
		<-15.314, 2.887, 49.737> <-15.132, 3.888, 49.800> <-14.430, 5.015, 50.376> <-14.313, 6.028, 50.357> 
		<-12.519, 1.643, 47.523> <-12.200, 2.252, 47.533> <-13.098, 3.895, 47.585> <-13.159, 4.575, 47.663> 
		<-12.438, 1.633, 45.263> <-12.120, 2.242, 45.273> <-12.581, 3.219, 45.445> <-12.642, 3.899, 45.523> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-12.438, 1.633, 45.263> <-12.120, 2.242, 45.273> <-12.581, 3.219, 45.445> <-12.642, 3.899, 45.523> 
		<-12.391, 1.627, 43.938> <-12.073, 2.236, 43.948> <-13.013, 3.764, 44.846> <-13.074, 4.444, 44.923> 
		<-14.375, 2.587, 43.047> <-14.039, 3.402, 43.475> <-13.319, 4.719, 43.582> <-13.211, 5.668, 43.808> 
		<-15.205, 2.995, 42.097> <-14.869, 3.811, 42.525> <-14.191, 4.766, 43.298> <-14.083, 5.715, 43.524> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.205, 2.995, 42.097> <-14.869, 3.811, 42.525> <-14.191, 4.766, 43.298> <-14.083, 5.715, 43.524> 
		<-16.059, 2.735, 42.158> <-15.722, 3.550, 42.587> <-15.382, 4.831, 42.910> <-15.274, 5.779, 43.136> 
		<-17.329, 2.432, 42.734> <-17.330, 3.177, 42.895> <-16.814, 3.726, 44.167> <-16.886, 4.459, 44.363> 
		<-18.050, 2.126, 42.302> <-18.051, 2.872, 42.463> <-17.895, 3.454, 43.591> <-17.967, 4.187, 43.787> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.050, 2.126, 42.302> <-18.051, 2.872, 42.463> <-17.895, 3.454, 43.591> <-17.967, 4.187, 43.787> 
		<-18.800, 1.808, 41.852> <-18.801, 2.554, 42.012> <-18.808, 3.224, 43.105> <-18.880, 3.957, 43.301> 
		<-18.939, 1.287, 40.460> <-18.809, 2.247, 40.606> <-18.993, 3.326, 41.324> <-19.018, 4.279, 41.549> 
		<-19.335, 1.245, 39.619> <-19.205, 2.204, 39.765> <-19.504, 3.392, 40.398> <-19.528, 4.345, 40.623> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-19.335, 1.245, 39.619> <-19.205, 2.204, 39.765> <-19.504, 3.392, 40.398> <-19.528, 4.345, 40.623> 
		<-20.274, 1.144, 37.625> <-20.144, 2.104, 37.772> <-20.812, 3.561, 38.023> <-20.836, 4.514, 38.249> 
		<-21.908, 1.376, 35.090> <-22.135, 2.454, 35.072> <-23.539, 3.692, 35.262> <-23.465, 4.777, 35.441> 
		<-22.445, 1.656, 32.969> <-22.673, 2.735, 32.951> <-24.101, 3.884, 32.611> <-24.026, 4.969, 32.790> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-22.445, 1.656, 32.969> <-22.673, 2.735, 32.951> <-24.101, 3.884, 32.611> <-24.026, 4.969, 32.790> 
		<-22.825, 1.855, 31.468> <-23.053, 2.934, 31.450> <-24.414, 3.991, 31.136> <-24.339, 5.076, 31.315> 
		<-22.926, 2.675, 29.321> <-22.863, 3.396, 29.163> <-23.003, 4.584, 29.189> <-22.973, 5.294, 29.396> 
		<-22.304, 2.797, 27.895> <-22.241, 3.517, 27.737> <-22.210, 4.542, 27.902> <-22.180, 5.252, 28.110> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-22.304, 2.797, 27.895> <-22.241, 3.517, 27.737> <-22.210, 4.542, 27.902> <-22.180, 5.252, 28.110> 
		<-21.724, 2.910, 26.566> <-21.662, 3.631, 26.408> <-21.469, 4.503, 26.700> <-21.439, 5.213, 26.907> 
		<-19.055, 2.490, 26.009> <-19.042, 3.168, 25.823> <-19.218, 4.139, 25.883> <-19.320, 4.817, 26.037> 
		<-18.788, 2.372, 24.584> <-18.774, 3.050, 24.398> <-18.916, 4.025, 24.508> <-19.018, 4.703, 24.662> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.788, 2.372, 24.584> <-18.774, 3.050, 24.398> <-18.916, 4.025, 24.508> <-19.018, 4.703, 24.662> 
		<-18.532, 2.259, 23.223> <-18.519, 2.937, 23.037> <-18.603, 3.907, 23.086> <-18.705, 4.585, 23.240> 
		<-21.309, 2.455, 21.775> <-21.220, 3.173, 21.583> <-20.801, 3.863, 21.335> <-20.802, 4.609, 21.397> 
		<-20.910, 2.183, 20.473> <-20.821, 2.901, 20.281> <-20.393, 3.832, 19.933> <-20.395, 4.578, 19.995> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-20.910, 2.183, 20.473> <-20.821, 2.901, 20.281> <-20.393, 3.832, 19.933> <-20.395, 4.578, 19.995> 
		<-20.391, 1.829, 18.781> <-20.302, 2.548, 18.589> <-20.007, 3.803, 18.604> <-20.009, 4.549, 18.666> 
		<-17.555, 0.709, 18.153> <-17.591, 1.856, 18.235> <-17.550, 3.231, 18.070> <-17.687, 4.371, 18.146> 
		<-16.393, 0.739, 16.772> <-16.430, 1.886, 16.854> <-16.679, 3.398, 17.008> <-16.816, 4.537, 17.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-16.393, 0.739, 16.772> <-16.430, 1.886, 16.854> <-16.679, 3.398, 17.008> <-16.816, 4.537, 17.084> 
		<-15.700, 0.757, 15.948> <-15.737, 1.904, 16.030> <-16.177, 3.494, 16.396> <-16.314, 4.634, 16.472> 
		<-15.266, 2.243, 14.832> <-15.423, 3.223, 14.783> <-16.236, 4.465, 15.192> <-16.379, 5.422, 15.419> 
		<-15.264, 2.331, 13.759> <-15.421, 3.311, 13.710> <-15.903, 4.454, 14.468> <-16.046, 5.411, 14.694> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.264, 2.331, 13.759> <-15.421, 3.311, 13.710> <-15.903, 4.454, 14.468> <-16.046, 5.411, 14.694> 
		<-15.262, 2.409, 12.799> <-15.419, 3.389, 12.750> <-15.481, 4.440, 13.551> <-15.625, 5.397, 13.778> 
		<-16.616, 1.234, 11.898> <-16.280, 2.355, 11.868> <-14.735, 3.450, 12.586> <-14.705, 4.587, 12.864> 
		<-16.382, 1.212, 10.964> <-16.046, 2.333, 10.934> <-14.463, 3.324, 11.623> <-14.432, 4.460, 11.901> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-16.382, 1.212, 10.964> <-16.046, 2.333, 10.934> <-14.463, 3.324, 11.623> <-14.432, 4.460, 11.901> 
		<-16.079, 1.184, 9.757> <-15.743, 2.305, 9.727> <-14.227, 3.215, 10.791> <-14.197, 4.351, 11.069> 
		<-14.253, 2.144, 9.030> <-14.205, 2.976, 9.122> <-14.485, 3.772, 9.798> <-14.521, 4.606, 9.870> 
		<-13.789, 2.191, 7.875> <-13.741, 3.023, 7.967> <-14.402, 3.830, 8.933> <-14.437, 4.664, 9.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.789, 2.191, 7.875> <-13.741, 3.023, 7.967> <-14.402, 3.830, 8.933> <-14.437, 4.664, 9.004> 
		<-13.287, 2.242, 6.628> <-13.240, 3.074, 6.719> <-14.281, 3.913, 7.686> <-14.316, 4.748, 7.757> 
		<-13.420, 1.569, 4.804> <-13.196, 2.635, 5.047> <-13.760, 3.735, 6.086> <-13.902, 4.841, 6.127> 
		<-13.365, 1.517, 3.460> <-13.142, 2.583, 3.703> <-13.610, 3.825, 4.843> <-13.752, 4.931, 4.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.365, 1.517, 3.460> <-13.142, 2.583, 3.703> <-13.610, 3.825, 4.843> <-13.752, 4.931, 4.883> 
		<-13.301, 1.456, 1.891> <-13.078, 2.521, 2.134> <-13.382, 3.962, 2.952> <-13.525, 5.068, 2.993> 
		<-13.182, 1.844, -0.213> <-13.239, 2.903, -0.456> <-13.065, 4.297, 0.278> <-13.138, 5.365, 0.472> 
		<-13.395, 1.815, -1.770> <-13.452, 2.874, -2.013> <-13.108, 4.352, -1.630> <-13.181, 5.421, -1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.395, 1.815, -1.770> <-13.452, 2.874, -2.013> <-13.108, 4.352, -1.630> <-13.181, 5.421, -1.436> 
		<-13.674, 1.776, -3.807> <-13.731, 2.836, -4.051> <-13.149, 4.407, -3.500> <-13.222, 5.475, -3.305> 
		<-14.513, 1.450, -6.422> <-14.542, 2.706, -6.364> <-13.948, 4.090, -5.861> <-13.775, 5.332, -5.759> 
		<-14.992, 1.293, -8.416> <-15.021, 2.550, -8.358> <-14.202, 4.052, -7.714> <-14.030, 5.294, -7.612> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.377, 4.531, 83.110> <-6.300, 5.502, 83.222> <-6.468, 6.651, 82.191> <-6.417, 7.619, 82.043> 
		<-5.408, 4.597, 78.768> <-5.331, 5.568, 78.880> <-5.514, 7.032, 78.624> <-5.462, 8.000, 78.475> 
		<-3.177, 4.787, 73.085> <-3.524, 6.059, 73.183> <-3.279, 7.507, 73.957> <-3.248, 8.826, 73.863> 
		<-3.146, 4.750, 68.636> <-3.494, 6.023, 68.734> <-3.266, 7.570, 70.245> <-3.235, 8.889, 70.151> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.146, 4.750, 68.636> <-3.494, 6.023, 68.734> <-3.266, 7.570, 70.245> <-3.235, 8.889, 70.151> 
		<-3.138, 4.741, 67.516> <-3.486, 6.013, 67.614> <-3.261, 7.592, 68.949> <-3.230, 8.911, 68.856> 
		<-5.405, 4.504, 67.324> <-5.604, 5.531, 67.529> <-5.904, 6.969, 68.460> <-5.697, 8.015, 68.457> 
		<-6.263, 4.395, 66.613> <-6.462, 5.422, 66.818> <-6.571, 6.823, 67.360> <-6.364, 7.869, 67.357> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.263, 4.395, 66.613> <-6.462, 5.422, 66.818> <-6.571, 6.823, 67.360> <-6.364, 7.869, 67.357> 
		<-6.762, 4.331, 66.199> <-6.961, 5.359, 66.404> <-7.024, 6.724, 66.613> <-6.817, 7.770, 66.610> 
		<-6.986, 4.042, 64.856> <-6.701, 5.232, 64.951> <-6.070, 6.934, 64.656> <-5.809, 8.122, 64.495> 
		<-7.618, 4.181, 64.930> <-7.333, 5.371, 65.025> <-6.948, 6.948, 64.617> <-6.687, 8.136, 64.457> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.618, 4.181, 64.930> <-7.333, 5.371, 65.025> <-6.948, 6.948, 64.617> <-6.687, 8.136, 64.457> 
		<-9.922, 4.689, 65.200> <-9.637, 5.878, 65.294> <-9.467, 6.987, 64.507> <-9.207, 8.176, 64.346> 
		<-12.451, 6.042, 68.069> <-12.453, 6.593, 68.077> <-12.549, 7.044, 67.771> <-12.306, 7.513, 67.611> 
		<-14.769, 6.268, 67.607> <-14.772, 6.820, 67.615> <-14.945, 7.532, 67.152> <-14.702, 8.001, 66.992> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.769, 6.268, 67.607> <-14.772, 6.820, 67.615> <-14.945, 7.532, 67.152> <-14.702, 8.001, 66.992> 
		<-16.109, 6.399, 67.340> <-16.112, 6.951, 67.348> <-16.359, 7.819, 66.786> <-16.116, 8.289, 66.626> 
		<-12.727, 4.917, 65.286> <-12.845, 6.306, 65.270> <-12.273, 7.371, 64.678> <-12.162, 8.751, 64.514> 
		<-12.536, 4.662, 63.950> <-12.654, 6.051, 63.935> <-11.929, 7.800, 63.294> <-11.818, 9.180, 63.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-12.536, 4.662, 63.950> <-12.654, 6.051, 63.935> <-11.929, 7.800, 63.294> <-11.818, 9.180, 63.130> 
		<-12.436, 4.529, 63.256> <-12.554, 5.918, 63.240> <-11.799, 7.962, 62.771> <-11.688, 9.343, 62.607> 
		<-13.949, 5.240, 62.863> <-13.942, 6.465, 63.119> <-13.344, 8.202, 63.362> <-13.454, 9.433, 63.159> 
		<-13.987, 5.224, 62.150> <-13.980, 6.450, 62.406> <-13.508, 8.124, 62.829> <-13.618, 9.355, 62.626> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.987, 5.224, 62.150> <-13.980, 6.450, 62.406> <-13.508, 8.124, 62.829> <-13.618, 9.355, 62.626> 
		<-14.072, 5.190, 60.556> <-14.064, 6.416, 60.813> <-14.000, 7.890, 61.226> <-14.110, 9.121, 61.023> 
		<-12.843, 4.357, 58.576> <-12.832, 5.516, 58.548> <-13.366, 7.225, 58.875> <-13.478, 8.373, 58.762> 
		<-12.906, 4.512, 56.988> <-12.895, 5.671, 56.961> <-13.563, 7.149, 57.195> <-13.676, 8.297, 57.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-12.906, 4.512, 56.988> <-12.895, 5.671, 56.961> <-13.563, 7.149, 57.195> <-13.676, 8.297, 57.082> 
		<-12.964, 4.653, 55.539> <-12.953, 5.812, 55.512> <-13.752, 7.076, 55.595> <-13.864, 8.224, 55.482> 
		<-14.400, 6.229, 54.111> <-14.301, 7.084, 54.095> <-14.366, 7.881, 53.671> <-14.521, 8.695, 53.436> 
		<-14.366, 6.151, 52.656> <-14.267, 7.007, 52.641> <-14.728, 8.051, 52.109> <-14.883, 8.865, 51.874> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.366, 6.151, 52.656> <-14.267, 7.007, 52.641> <-14.728, 8.051, 52.109> <-14.883, 8.865, 51.874> 
		<-14.313, 6.028, 50.357> <-14.214, 6.884, 50.342> <-14.740, 7.866, 49.926> <-14.895, 8.680, 49.691> 
		<-13.159, 4.575, 47.663> <-13.844, 5.879, 47.386> <-14.638, 6.931, 46.855> <-14.997, 8.384, 46.784> 
		<-12.642, 3.899, 45.523> <-13.326, 5.204, 45.246> <-14.565, 6.793, 44.670> <-14.924, 8.247, 44.599> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-12.642, 3.899, 45.523> <-13.326, 5.204, 45.246> <-14.565, 6.793, 44.670> <-14.924, 8.247, 44.599> 
		<-13.074, 4.444, 44.923> <-13.759, 5.748, 44.646> <-14.552, 6.769, 44.289> <-14.911, 8.223, 44.217> 
		<-13.211, 5.668, 43.808> <-13.123, 6.442, 43.993> <-14.177, 7.451, 43.463> <-14.226, 8.249, 43.412> 
		<-14.083, 5.715, 43.524> <-13.995, 6.489, 43.709> <-14.548, 7.533, 43.420> <-14.598, 8.330, 43.369> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.083, 5.715, 43.524> <-13.995, 6.489, 43.709> <-14.548, 7.533, 43.420> <-14.598, 8.330, 43.369> 
		<-15.274, 5.779, 43.136> <-15.186, 6.554, 43.320> <-15.795, 7.805, 43.277> <-15.844, 8.603, 43.226> 
		<-16.886, 4.459, 44.363> <-17.028, 5.892, 44.747> <-17.534, 7.853, 44.908> <-17.598, 9.328, 44.703> 
		<-17.967, 4.187, 43.787> <-18.108, 5.620, 44.171> <-18.672, 7.606, 44.367> <-18.735, 9.080, 44.162> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-17.967, 4.187, 43.787> <-18.108, 5.620, 44.171> <-18.672, 7.606, 44.367> <-18.735, 9.080, 44.162> 
		<-18.880, 3.957, 43.301> <-19.021, 5.390, 43.684> <-19.652, 7.392, 43.900> <-19.716, 8.866, 43.695> 
		<-19.018, 4.279, 41.549> <-19.040, 5.140, 41.753> <-18.916, 6.452, 42.300> <-19.151, 7.280, 42.094> 
		<-19.528, 4.345, 40.623> <-19.550, 5.206, 40.826> <-19.254, 6.437, 41.247> <-19.490, 7.264, 41.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-19.528, 4.345, 40.623> <-19.550, 5.206, 40.826> <-19.254, 6.437, 41.247> <-19.490, 7.264, 41.041> 
		<-20.836, 4.514, 38.249> <-20.858, 5.375, 38.452> <-19.941, 6.405, 39.109> <-20.176, 7.232, 38.903> 
		<-23.465, 4.777, 35.441> <-23.369, 6.160, 35.669> <-21.804, 7.451, 36.397> <-21.456, 8.812, 36.358> 
		<-24.026, 4.969, 32.790> <-23.931, 6.352, 33.018> <-22.292, 7.570, 34.208> <-21.944, 8.931, 34.169> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-24.026, 4.969, 32.790> <-23.931, 6.352, 33.018> <-22.292, 7.570, 34.208> <-21.944, 8.931, 34.169> 
		<-24.339, 5.076, 31.315> <-24.244, 6.459, 31.543> <-22.611, 7.648, 32.776> <-22.264, 9.009, 32.737> 
		<-22.973, 5.294, 29.396> <-22.937, 6.139, 29.643> <-22.606, 7.183, 30.922> <-22.479, 8.046, 30.792> 
		<-22.180, 5.252, 28.110> <-22.144, 6.097, 28.356> <-22.215, 7.035, 29.513> <-22.088, 7.898, 29.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-22.180, 5.252, 28.110> <-22.144, 6.097, 28.356> <-22.215, 7.035, 29.513> <-22.088, 7.898, 29.383> 
		<-21.439, 5.213, 26.907> <-21.403, 6.058, 27.153> <-21.874, 6.906, 28.282> <-21.746, 7.768, 28.152> 
		<-19.320, 4.817, 26.037> <-19.478, 5.866, 26.275> <-20.189, 7.004, 26.562> <-20.376, 8.011, 26.926> 
		<-19.018, 4.703, 24.662> <-19.175, 5.752, 24.899> <-19.455, 7.053, 25.509> <-19.643, 8.059, 25.873> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-19.018, 4.703, 24.662> <-19.175, 5.752, 24.899> <-19.455, 7.053, 25.509> <-19.643, 8.059, 25.873> 
		<-18.705, 4.585, 23.240> <-18.863, 5.634, 23.478> <-19.840, 7.266, 24.054> <-20.027, 8.273, 24.417> 
		<-20.802, 4.609, 21.397> <-20.805, 5.909, 21.505> <-21.102, 7.538, 22.335> <-21.332, 8.813, 22.485> 
		<-20.395, 4.578, 19.995> <-20.398, 5.878, 20.103> <-20.695, 7.496, 20.870> <-20.925, 8.771, 21.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-20.395, 4.578, 19.995> <-20.398, 5.878, 20.103> <-20.695, 7.496, 20.870> <-20.925, 8.771, 21.020> 
		<-20.009, 4.549, 18.666> <-20.012, 5.849, 18.774> <-20.264, 7.450, 19.321> <-20.494, 8.726, 19.471> 
		<-17.687, 4.371, 18.146> <-17.805, 5.352, 18.212> <-18.376, 6.945, 18.421> <-18.255, 7.926, 18.489> 
		<-16.816, 4.537, 17.084> <-16.934, 5.519, 17.150> <-17.363, 6.827, 17.177> <-17.242, 7.808, 17.245> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-16.816, 4.537, 17.084> <-16.934, 5.519, 17.150> <-17.363, 6.827, 17.177> <-17.242, 7.808, 17.245> 
		<-16.314, 4.634, 16.472> <-16.432, 5.615, 16.538> <-16.911, 6.774, 16.621> <-16.790, 7.755, 16.689> 
		<-16.379, 5.422, 15.419> <-16.502, 6.243, 15.613> <-16.459, 7.220, 15.947> <-16.311, 8.052, 15.833> 
		<-16.046, 5.411, 14.694> <-16.169, 6.232, 14.889> <-16.294, 7.383, 15.266> <-16.147, 8.215, 15.153> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-16.046, 5.411, 14.694> <-16.169, 6.232, 14.889> <-16.294, 7.383, 15.266> <-16.147, 8.215, 15.153> 
		<-15.625, 5.397, 13.778> <-15.748, 6.219, 13.972> <-16.129, 7.546, 14.584> <-15.982, 8.378, 14.470> 
		<-14.705, 4.587, 12.864> <-14.667, 5.993, 13.209> <-16.131, 7.396, 13.688> <-16.390, 8.812, 13.525> 
		<-14.432, 4.460, 11.901> <-14.394, 5.867, 12.245> <-15.918, 7.447, 13.001> <-16.177, 8.863, 12.838> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.432, 4.460, 11.901> <-14.394, 5.867, 12.245> <-15.918, 7.447, 13.001> <-16.177, 8.863, 12.838> 
		<-14.197, 4.351, 11.069> <-14.159, 5.758, 11.414> <-15.485, 7.552, 11.604> <-15.743, 8.968, 11.441> 
		<-14.521, 4.606, 9.870> <-14.572, 5.834, 9.974> <-14.653, 7.695, 9.977> <-14.375, 8.890, 9.855> 
		<-14.437, 4.664, 9.004> <-14.488, 5.892, 9.109> <-14.341, 7.523, 8.555> <-14.063, 8.718, 8.432> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.437, 4.664, 9.004> <-14.488, 5.892, 9.109> <-14.341, 7.523, 8.555> <-14.063, 8.718, 8.432> 
		<-14.316, 4.748, 7.757> <-14.367, 5.976, 7.862> <-14.031, 7.352, 7.146> <-13.754, 8.548, 7.023> 
		<-13.902, 4.841, 6.127> <-14.020, 5.761, 6.161> <-14.300, 6.740, 5.305> <-14.193, 7.646, 5.137> 
		<-13.752, 4.931, 4.883> <-13.870, 5.851, 4.917> <-14.275, 6.848, 3.858> <-14.168, 7.755, 3.689> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.752, 4.931, 4.883> <-13.870, 5.851, 4.917> <-14.275, 6.848, 3.858> <-14.168, 7.755, 3.689> 
		<-13.525, 5.068, 2.993> <-13.643, 5.988, 3.026> <-14.253, 6.947, 2.541> <-14.145, 7.854, 2.373> 
		<-13.138, 5.365, 0.472> <-13.222, 6.590, 0.695> <-13.879, 8.138, 0.971> <-13.919, 9.385, 0.927> 
		<-13.181, 5.421, -1.436> <-13.264, 6.646, -1.213> <-13.871, 8.134, -0.349> <-13.911, 9.381, -0.393> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.181, 5.421, -1.436> <-13.264, 6.646, -1.213> <-13.871, 8.134, -0.349> <-13.911, 9.381, -0.393> 
		<-13.222, 5.475, -3.305> <-13.306, 6.700, -3.082> <-13.857, 8.127, -2.653> <-13.897, 9.374, -2.697> 
		<-13.775, 5.332, -5.759> <-13.674, 6.055, -5.700> <-13.925, 7.502, -5.538> <-14.042, 8.218, -5.639> 
		<-14.030, 5.294, -7.612> <-13.929, 6.017, -7.553> <-13.981, 7.003, -7.786> <-14.098, 7.719, -7.887> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.417, 7.619, 82.043> <-6.341, 9.036, 81.826> <-5.961, 10.945, 81.922> <-5.959, 12.380, 81.907> 
		<-5.462, 8.000, 78.475> <-5.387, 9.417, 78.258> <-5.058, 11.166, 77.764> <-5.056, 12.601, 77.748> 
		<-3.248, 8.826, 73.863> <-3.214, 10.242, 73.763> <-3.584, 11.718, 72.322> <-3.304, 13.110, 72.291> 
		<-3.235, 8.889, 70.151> <-3.201, 10.305, 70.051> <-3.228, 11.726, 68.075> <-2.948, 13.118, 68.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.235, 8.889, 70.151> <-3.201, 10.305, 70.051> <-3.228, 11.726, 68.075> <-2.948, 13.118, 68.045> 
		<-3.230, 8.911, 68.856> <-3.197, 10.327, 68.756> <-3.169, 11.727, 67.367> <-2.889, 13.119, 67.337> 
		<-5.697, 8.015, 68.457> <-5.411, 9.458, 68.453> <-4.615, 11.112, 67.402> <-4.279, 12.525, 67.167> 
		<-6.364, 7.869, 67.357> <-6.078, 9.312, 67.352> <-5.013, 10.996, 66.825> <-4.676, 12.409, 66.589> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.364, 7.869, 67.357> <-6.078, 9.312, 67.352> <-5.013, 10.996, 66.825> <-4.676, 12.409, 66.589> 
		<-6.817, 7.770, 66.610> <-6.531, 9.213, 66.605> <-5.515, 10.849, 66.095> <-5.178, 12.262, 65.859> 
		<-5.809, 8.122, 64.495> <-5.537, 9.361, 64.327> <-5.746, 11.071, 64.848> <-5.493, 12.312, 64.662> 
		<-6.687, 8.136, 64.457> <-6.415, 9.375, 64.289> <-6.097, 11.030, 64.022> <-5.844, 12.270, 63.835> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.687, 8.136, 64.457> <-6.415, 9.375, 64.289> <-6.097, 11.030, 64.022> <-5.844, 12.270, 63.835> 
		<-9.207, 8.176, 64.346> <-8.935, 9.415, 64.179> <-7.977, 10.771, 64.627> <-7.724, 12.011, 64.441> 
		<-12.306, 7.513, 67.611> <-11.723, 8.642, 67.225> <-10.404, 9.847, 66.257> <-10.157, 11.147, 66.141> 
		<-14.702, 8.001, 66.992> <-14.119, 9.130, 66.606> <-12.359, 10.106, 65.970> <-12.112, 11.406, 65.854> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.702, 8.001, 66.992> <-14.119, 9.130, 66.606> <-12.359, 10.106, 65.970> <-12.112, 11.406, 65.854> 
		<-16.116, 8.289, 66.626> <-15.533, 9.418, 66.241> <-13.346, 10.237, 65.825> <-13.099, 11.536, 65.709> 
		<-12.162, 8.751, 64.514> <-12.069, 9.907, 64.376> <-11.305, 11.675, 63.691> <-11.414, 12.830, 63.821> 
		<-11.818, 9.180, 63.130> <-11.726, 10.336, 62.993> <-11.752, 11.912, 62.822> <-11.861, 13.067, 62.952> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.818, 9.180, 63.130> <-11.726, 10.336, 62.993> <-11.752, 11.912, 62.822> <-11.861, 13.067, 62.952> 
		<-11.688, 9.343, 62.607> <-11.596, 10.498, 62.470> <-12.217, 12.159, 61.919> <-12.325, 13.314, 62.050> 
		<-13.454, 9.433, 63.159> <-13.558, 10.598, 62.966> <-14.165, 11.773, 62.026> <-14.395, 12.929, 61.899> 
		<-13.618, 9.355, 62.626> <-13.722, 10.520, 62.433> <-14.428, 11.601, 61.030> <-14.659, 12.757, 60.903> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.618, 9.355, 62.626> <-13.722, 10.520, 62.433> <-14.428, 11.601, 61.030> <-14.659, 12.757, 60.903> 
		<-14.110, 9.121, 61.023> <-14.214, 10.286, 60.830> <-14.794, 11.363, 59.647> <-15.024, 12.519, 59.521> 
		<-13.478, 8.373, 58.762> <-13.586, 9.476, 58.653> <-13.953, 11.082, 57.898> <-13.940, 12.167, 57.651> 
		<-13.676, 8.297, 57.082> <-13.784, 9.399, 56.973> <-13.645, 10.828, 56.505> <-13.631, 11.913, 56.257> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.676, 8.297, 57.082> <-13.784, 9.399, 56.973> <-13.645, 10.828, 56.505> <-13.631, 11.913, 56.257> 
		<-13.864, 8.224, 55.482> <-13.972, 9.326, 55.373> <-14.064, 10.690, 55.130> <-14.051, 11.775, 54.883> 
		<-14.521, 8.695, 53.436> <-14.565, 9.471, 53.377> <-14.987, 10.617, 52.990> <-14.884, 11.380, 53.110> 
		<-14.883, 8.865, 51.874> <-14.927, 9.641, 51.814> <-15.132, 10.688, 51.556> <-15.029, 11.452, 51.676> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.883, 8.865, 51.874> <-14.927, 9.641, 51.814> <-15.132, 10.688, 51.556> <-15.029, 11.452, 51.676> 
		<-14.895, 8.680, 49.691> <-14.939, 9.456, 49.632> <-15.333, 10.788, 49.571> <-15.230, 11.551, 49.691> 
		<-14.997, 8.384, 46.784> <-15.303, 9.623, 46.723> <-15.153, 10.974, 47.036> <-14.880, 12.221, 47.080> 
		<-14.924, 8.247, 44.599> <-15.230, 9.485, 44.538> <-15.033, 11.224, 45.058> <-14.760, 12.471, 45.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.924, 8.247, 44.599> <-15.230, 9.485, 44.538> <-15.033, 11.224, 45.058> <-14.760, 12.471, 45.102> 
		<-14.911, 8.223, 44.217> <-15.217, 9.461, 44.157> <-14.996, 11.300, 44.455> <-14.723, 12.547, 44.499> 
		<-14.226, 8.249, 43.412> <-14.304, 9.509, 43.331> <-14.168, 11.538, 43.360> <-14.040, 12.796, 43.382> 
		<-14.598, 8.330, 43.369> <-14.676, 9.590, 43.288> <-14.635, 11.278, 43.065> <-14.506, 12.536, 43.087> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.598, 8.330, 43.369> <-14.676, 9.590, 43.288> <-14.635, 11.278, 43.065> <-14.506, 12.536, 43.087> 
		<-15.844, 8.603, 43.226> <-15.922, 9.863, 43.145> <-15.608, 10.736, 42.450> <-15.480, 11.994, 42.472> 
		<-17.598, 9.328, 44.703> <-17.624, 9.917, 44.621> <-17.558, 10.595, 43.626> <-17.242, 11.076, 43.475> 
		<-18.735, 9.080, 44.162> <-18.761, 9.669, 44.079> <-18.557, 10.052, 43.055> <-18.241, 10.533, 42.904> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.735, 9.080, 44.162> <-18.761, 9.669, 44.079> <-18.557, 10.052, 43.055> <-18.241, 10.533, 42.904> 
		<-19.716, 8.866, 43.695> <-19.741, 9.456, 43.613> <-19.636, 9.465, 42.437> <-19.320, 9.947, 42.286> 
		<-19.151, 7.280, 42.094> <-19.373, 8.061, 41.900> <-20.356, 8.072, 40.843> <-20.381, 8.896, 40.717> 
		<-19.490, 7.264, 41.041> <-19.712, 8.045, 40.847> <-20.848, 8.251, 39.572> <-20.873, 9.076, 39.446> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-19.490, 7.264, 41.041> <-19.712, 8.045, 40.847> <-20.848, 8.251, 39.572> <-20.873, 9.076, 39.446> 
		<-20.176, 7.232, 38.903> <-20.398, 8.013, 38.709> <-21.661, 8.549, 37.471> <-21.686, 9.374, 37.345> 
		<-21.456, 8.812, 36.358> <-21.200, 9.817, 36.329> <-22.169, 10.461, 35.195> <-22.187, 11.414, 34.786> 
		<-21.944, 8.931, 34.169> <-21.688, 9.935, 34.140> <-22.215, 11.040, 32.998> <-22.233, 11.992, 32.589> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-21.944, 8.931, 34.169> <-21.688, 9.935, 34.140> <-22.215, 11.040, 32.998> <-22.233, 11.992, 32.589> 
		<-22.264, 9.009, 32.737> <-22.007, 10.013, 32.708> <-22.250, 11.472, 31.354> <-22.268, 12.425, 30.944> 
		<-22.479, 8.046, 30.792> <-22.257, 9.547, 30.565> <-21.854, 10.752, 28.886> <-21.702, 12.259, 28.639> 
		<-22.088, 7.898, 29.383> <-21.866, 9.399, 29.156> <-21.285, 10.836, 27.286> <-21.133, 12.343, 27.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-22.088, 7.898, 29.383> <-21.866, 9.399, 29.156> <-21.285, 10.836, 27.286> <-21.133, 12.343, 27.039> 
		<-21.746, 7.768, 28.152> <-21.525, 9.270, 27.925> <-21.034, 10.872, 26.581> <-20.882, 12.379, 26.334> 
		<-20.376, 8.011, 26.926> <-20.353, 9.308, 26.692> <-19.505, 11.059, 26.117> <-19.479, 12.347, 25.838> 
		<-19.643, 8.059, 25.873> <-19.620, 9.356, 25.639> <-19.593, 11.095, 25.375> <-19.567, 12.383, 25.095> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-19.643, 8.059, 25.873> <-19.620, 9.356, 25.639> <-19.593, 11.095, 25.375> <-19.567, 12.383, 25.095> 
		<-20.027, 8.273, 24.417> <-20.005, 9.570, 24.184> <-19.759, 11.164, 23.963> <-19.733, 12.452, 23.683> 
		<-21.332, 8.813, 22.485> <-21.543, 9.981, 22.622> <-20.888, 11.402, 22.213> <-21.166, 12.563, 22.190> 
		<-20.925, 8.771, 21.020> <-21.136, 9.938, 21.158> <-21.574, 11.480, 20.968> <-21.852, 12.640, 20.945> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-20.925, 8.771, 21.020> <-21.136, 9.938, 21.158> <-21.574, 11.480, 20.968> <-21.852, 12.640, 20.945> 
		<-20.494, 8.726, 19.471> <-20.705, 9.893, 19.609> <-19.787, 11.285, 19.964> <-20.065, 12.446, 19.941> 
		<-18.255, 7.926, 18.489> <-18.094, 9.236, 18.579> <-17.469, 10.860, 19.158> <-17.327, 12.173, 19.068> 
		<-17.242, 7.808, 17.245> <-17.081, 9.118, 17.336> <-16.038, 10.680, 17.689> <-15.896, 11.993, 17.599> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-17.242, 7.808, 17.245> <-17.081, 9.118, 17.336> <-16.038, 10.680, 17.689> <-15.896, 11.993, 17.599> 
		<-16.790, 7.755, 16.689> <-16.628, 9.065, 16.779> <-15.224, 10.578, 16.854> <-15.082, 11.890, 16.763> 
		<-16.311, 8.052, 15.833> <-16.104, 9.219, 15.674> <-15.092, 10.787, 15.247> <-14.966, 11.947, 14.983> 
		<-16.147, 8.215, 15.153> <-15.939, 9.382, 14.993> <-15.043, 10.609, 14.091> <-14.918, 11.769, 13.826> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-16.147, 8.215, 15.153> <-15.939, 9.382, 14.993> <-15.043, 10.609, 14.091> <-14.918, 11.769, 13.826> 
		<-15.982, 8.378, 14.470> <-15.774, 9.546, 14.311> <-15.008, 10.478, 13.239> <-14.882, 11.638, 12.975> 
		<-16.390, 8.812, 13.525> <-16.539, 9.626, 13.432> <-16.078, 10.151, 12.129> <-15.943, 10.954, 11.950> 
		<-16.177, 8.863, 12.838> <-16.326, 9.678, 12.745> <-15.761, 10.197, 11.328> <-15.627, 11.000, 11.149> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-16.177, 8.863, 12.838> <-16.326, 9.678, 12.745> <-15.761, 10.197, 11.328> <-15.627, 11.000, 11.149> 
		<-15.743, 8.968, 11.441> <-15.892, 9.782, 11.347> <-15.292, 10.265, 10.141> <-15.158, 11.068, 9.962> 
		<-14.375, 8.890, 9.855> <-14.130, 9.948, 9.746> <-13.213, 10.938, 9.473> <-13.137, 12.026, 9.444> 
		<-14.063, 8.718, 8.432> <-13.817, 9.776, 8.323> <-12.787, 11.002, 8.269> <-12.711, 12.090, 8.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.063, 8.718, 8.432> <-13.817, 9.776, 8.323> <-12.787, 11.002, 8.269> <-12.711, 12.090, 8.241> 
		<-13.754, 8.548, 7.023> <-13.508, 9.605, 6.915> <-12.326, 11.071, 6.965> <-12.249, 12.159, 6.937> 
		<-14.193, 7.646, 5.137> <-14.059, 8.768, 4.929> <-13.007, 10.308, 5.079> <-12.890, 11.451, 5.066> 
		<-14.168, 7.755, 3.689> <-14.035, 8.877, 3.482> <-13.101, 10.253, 3.698> <-12.984, 11.396, 3.685> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.168, 7.755, 3.689> <-14.035, 8.877, 3.482> <-13.101, 10.253, 3.698> <-12.984, 11.396, 3.685> 
		<-14.145, 7.854, 2.373> <-14.012, 8.975, 2.165> <-13.210, 10.190, 2.094> <-13.093, 11.332, 2.080> 
		<-13.919, 9.385, 0.927> <-13.945, 10.191, 0.899> <-13.229, 10.796, 0.043> <-13.103, 11.584, -0.076> 
		<-13.911, 9.381, -0.393> <-13.937, 10.187, -0.422> <-13.511, 10.909, -1.537> <-13.384, 11.697, -1.657> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.911, 9.381, -0.393> <-13.937, 10.187, -0.422> <-13.511, 10.909, -1.537> <-13.384, 11.697, -1.657> 
		<-13.897, 9.374, -2.697> <-13.924, 10.180, -2.725> <-13.887, 11.060, -3.655> <-13.761, 11.848, -3.775> 
		<-14.042, 8.218, -5.639> <-14.269, 9.604, -5.835> <-14.629, 10.688, -6.365> <-14.633, 12.099, -6.514> 
		<-14.098, 7.719, -7.887> <-14.325, 9.106, -8.083> <-15.165, 10.860, -8.446> <-15.169, 12.271, -8.596> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.959, 12.380, 81.907> <-5.958, 13.505, 81.895> <-5.288, 15.976, 81.908> <-6.405, 16.104, 81.952> 
		<-5.056, 12.601, 77.748> <-5.054, 13.726, 77.736> <-3.884, 16.061, 78.319> <-5.001, 16.189, 78.362> 
		<-3.304, 13.110, 72.291> <-3.067, 14.284, 72.265> <-1.055, 16.242, 73.510> <-2.210, 16.359, 73.811> 
		<-2.948, 13.118, 68.045> <-2.711, 14.292, 68.019> <-0.569, 16.270, 69.686> <-1.724, 16.387, 69.987> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.948, 13.118, 68.045> <-2.711, 14.292, 68.019> <-0.569, 16.270, 69.686> <-1.724, 16.387, 69.987> 
		<-2.889, 13.119, 67.337> <-2.652, 14.294, 67.311> <-0.387, 16.281, 68.251> <-1.541, 16.398, 68.552> 
		<-4.279, 12.525, 67.167> <-4.012, 13.641, 66.980> <-2.110, 16.085, 66.617> <-3.238, 16.227, 66.860> 
		<-4.676, 12.409, 66.589> <-4.410, 13.525, 66.403> <-3.244, 16.080, 65.721> <-4.373, 16.222, 65.963> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.676, 12.409, 66.589> <-4.410, 13.525, 66.403> <-3.244, 16.080, 65.721> <-4.373, 16.222, 65.963> 
		<-5.178, 12.262, 65.859> <-4.912, 13.378, 65.673> <-4.340, 16.076, 64.855> <-5.469, 16.217, 65.097> 
		<-5.493, 12.312, 64.662> <-6.370, 13.538, 64.838> <-5.887, 16.145, 64.123> <-7.369, 16.347, 64.377> 
		<-5.844, 12.270, 63.835> <-6.720, 13.496, 64.012> <-7.283, 16.156, 64.169> <-8.765, 16.357, 64.422> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.844, 12.270, 63.835> <-6.720, 13.496, 64.012> <-7.283, 16.156, 64.169> <-8.765, 16.357, 64.422> 
		<-7.724, 12.011, 64.441> <-8.601, 13.237, 64.617> <-8.702, 16.166, 64.216> <-10.184, 16.367, 64.469> 
		<-10.157, 11.147, 66.141> <-9.879, 12.615, 66.009> <-10.256, 16.123, 66.523> <-11.728, 16.401, 66.446> 
		<-12.112, 11.406, 65.854> <-11.833, 12.874, 65.722> <-11.657, 16.007, 66.327> <-13.129, 16.285, 66.251> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-12.112, 11.406, 65.854> <-11.833, 12.874, 65.722> <-11.657, 16.007, 66.327> <-13.129, 16.285, 66.251> 
		<-13.099, 11.536, 65.709> <-12.820, 13.005, 65.578> <-12.383, 15.947, 66.226> <-13.855, 16.225, 66.149> 
		<-11.414, 12.830, 63.821> <-11.503, 13.777, 63.928> <-11.247, 16.023, 64.627> <-12.194, 16.156, 64.580> 
		<-11.861, 13.067, 62.952> <-11.950, 14.014, 63.059> <-11.519, 15.917, 63.953> <-12.466, 16.051, 63.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.861, 13.067, 62.952> <-11.950, 14.014, 63.059> <-11.519, 15.917, 63.953> <-12.466, 16.051, 63.905> 
		<-12.325, 13.314, 62.050> <-12.414, 14.261, 62.156> <-11.867, 15.783, 63.090> <-12.813, 15.916, 63.042> 
		<-14.395, 12.929, 61.899> <-14.573, 13.820, 61.802> <-13.911, 15.397, 62.968> <-14.810, 15.529, 62.875> 
		<-14.659, 12.757, 60.903> <-14.836, 13.648, 60.806> <-13.967, 15.480, 62.034> <-14.866, 15.612, 61.940> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.659, 12.757, 60.903> <-14.836, 13.648, 60.806> <-13.967, 15.480, 62.034> <-14.866, 15.612, 61.940> 
		<-15.024, 12.519, 59.521> <-15.202, 13.410, 59.423> <-14.068, 15.630, 60.345> <-14.967, 15.762, 60.252> 
		<-13.940, 12.167, 57.651> <-13.718, 13.599, 57.797> <-11.634, 16.485, 58.614> <-13.045, 16.801, 58.432> 
		<-13.631, 11.913, 56.257> <-13.410, 13.345, 56.403> <-11.484, 16.371, 56.926> <-12.894, 16.687, 56.745> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.631, 11.913, 56.257> <-13.410, 13.345, 56.403> <-11.484, 16.371, 56.926> <-12.894, 16.687, 56.745> 
		<-14.051, 11.775, 54.883> <-13.830, 13.207, 55.029> <-11.366, 16.282, 55.611> <-12.777, 16.598, 55.429> 
		<-14.884, 11.380, 53.110> <-14.731, 12.513, 53.288> <-12.880, 14.888, 54.277> <-14.015, 15.080, 54.158> 
		<-15.029, 11.452, 51.676> <-14.876, 12.584, 51.854> <-12.919, 14.805, 52.956> <-14.054, 14.997, 52.837> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.029, 11.452, 51.676> <-14.876, 12.584, 51.854> <-12.919, 14.805, 52.956> <-14.054, 14.997, 52.837> 
		<-15.230, 11.551, 49.691> <-15.077, 12.684, 49.869> <-12.990, 14.653, 50.543> <-14.124, 14.845, 50.424> 
		<-14.880, 12.221, 47.080> <-14.637, 13.331, 47.120> <-12.171, 15.634, 47.217> <-13.286, 15.851, 47.288> 
		<-14.760, 12.471, 45.102> <-14.517, 13.581, 45.142> <-12.128, 15.720, 44.801> <-13.242, 15.937, 44.871> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.760, 12.471, 45.102> <-14.517, 13.581, 45.142> <-12.128, 15.720, 44.801> <-13.242, 15.937, 44.871> 
		<-14.723, 12.547, 44.499> <-14.480, 13.658, 44.538> <-12.119, 15.738, 44.309> <-13.233, 15.955, 44.380> 
		<-14.040, 12.796, 43.382> <-13.952, 13.658, 43.397> <-12.720, 15.484, 43.711> <-13.577, 15.617, 43.746> 
		<-14.506, 12.536, 43.087> <-14.419, 13.399, 43.102> <-13.028, 15.197, 43.457> <-13.884, 15.330, 43.492> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.506, 12.536, 43.087> <-14.419, 13.399, 43.102> <-13.028, 15.197, 43.457> <-13.884, 15.330, 43.492> 
		<-15.480, 11.994, 42.472> <-15.392, 12.857, 42.487> <-13.538, 14.722, 43.036> <-14.394, 14.855, 43.070> 
		<-17.242, 11.076, 43.475> <-16.623, 12.019, 43.179> <-13.995, 13.378, 43.224> <-15.114, 13.700, 43.169> 
		<-18.241, 10.533, 42.904> <-17.622, 11.476, 42.608> <-14.681, 13.232, 42.811> <-15.801, 13.555, 42.757> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.241, 10.533, 42.904> <-17.622, 11.476, 42.608> <-14.681, 13.232, 42.811> <-15.801, 13.555, 42.757> 
		<-19.320, 9.947, 42.286> <-18.702, 10.890, 41.990> <-15.897, 12.974, 42.081> <-17.016, 13.296, 42.026> 
		<-20.381, 8.896, 40.717> <-20.428, 10.433, 40.482> <-17.486, 13.650, 41.416> <-18.967, 14.092, 41.240> 
		<-20.873, 9.076, 39.446> <-20.920, 10.613, 39.211> <-18.218, 13.652, 40.174> <-19.698, 14.095, 39.998> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-20.873, 9.076, 39.446> <-20.920, 10.613, 39.211> <-18.218, 13.652, 40.174> <-19.698, 14.095, 39.998> 
		<-21.686, 9.374, 37.345> <-21.733, 10.910, 37.110> <-19.463, 13.656, 38.059> <-20.943, 14.098, 37.883> 
		<-22.187, 11.414, 34.786> <-22.196, 11.868, 34.591> <-21.169, 13.553, 34.612> <-21.656, 13.638, 34.598> 
		<-22.233, 11.992, 32.589> <-22.242, 12.446, 32.394> <-21.546, 13.488, 32.187> <-22.032, 13.573, 32.174> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-22.233, 11.992, 32.589> <-22.242, 12.446, 32.394> <-21.546, 13.488, 32.187> <-22.032, 13.573, 32.174> 
		<-22.268, 12.425, 30.944> <-22.276, 12.879, 30.749> <-21.720, 13.458, 31.061> <-22.207, 13.543, 31.047> 
		<-21.702, 12.259, 28.639> <-21.642, 12.857, 28.541> <-21.227, 13.369, 29.413> <-21.826, 13.465, 29.460> 
		<-21.133, 12.343, 27.039> <-21.073, 12.940, 26.941> <-20.896, 13.689, 28.370> <-21.495, 13.786, 28.417> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-21.133, 12.343, 27.039> <-21.073, 12.940, 26.941> <-20.896, 13.689, 28.370> <-21.495, 13.786, 28.417> 
		<-20.882, 12.379, 26.334> <-20.822, 12.977, 26.236> <-20.440, 14.131, 26.933> <-21.039, 14.227, 26.980> 
		<-19.479, 12.347, 25.838> <-19.457, 13.455, 25.597> <-18.649, 15.253, 25.659> <-19.761, 15.461, 25.574> 
		<-19.567, 12.383, 25.095> <-19.545, 13.491, 24.855> <-18.370, 15.833, 24.226> <-19.482, 16.041, 24.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-19.567, 12.383, 25.095> <-19.545, 13.491, 24.855> <-18.370, 15.833, 24.226> <-19.482, 16.041, 24.141> 
		<-19.733, 12.452, 23.683> <-19.711, 13.560, 23.443> <-18.233, 16.119, 23.519> <-19.345, 16.327, 23.433> 
		<-21.166, 12.563, 22.190> <-20.668, 13.722, 22.416> <-19.242, 16.189, 22.363> <-20.492, 16.468, 22.412> 
		<-21.852, 12.640, 20.945> <-21.353, 13.800, 21.171> <-18.940, 16.225, 21.650> <-20.190, 16.504, 21.699> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-21.852, 12.640, 20.945> <-21.353, 13.800, 21.171> <-18.940, 16.225, 21.650> <-20.190, 16.504, 21.699> 
		<-20.065, 12.446, 19.941> <-19.567, 13.605, 20.167> <-18.196, 16.313, 19.893> <-19.446, 16.593, 19.943> 
		<-17.327, 12.173, 19.068> <-17.181, 13.525, 18.975> <-15.993, 16.234, 18.374> <-17.271, 16.700, 18.279> 
		<-15.896, 11.993, 17.599> <-15.750, 13.345, 17.506> <-15.033, 15.953, 16.747> <-16.311, 16.419, 16.653> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.896, 11.993, 17.599> <-15.750, 13.345, 17.506> <-15.033, 15.953, 16.747> <-16.311, 16.419, 16.653> 
		<-15.082, 11.890, 16.763> <-14.936, 13.243, 16.670> <-14.511, 15.800, 15.862> <-15.789, 16.266, 15.768> 
		<-14.966, 11.947, 14.983> <-14.859, 12.929, 14.759> <-14.670, 14.939, 14.614> <-15.641, 15.224, 14.586> 
		<-14.918, 11.769, 13.826> <-14.811, 12.751, 13.603> <-14.429, 14.815, 13.612> <-15.400, 15.100, 13.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-14.918, 11.769, 13.826> <-14.811, 12.751, 13.603> <-14.429, 14.815, 13.612> <-15.400, 15.100, 13.583> 
		<-14.882, 11.638, 12.975> <-14.776, 12.619, 12.751> <-14.261, 14.729, 12.915> <-15.232, 15.014, 12.886> 
		<-15.943, 10.954, 11.950> <-15.711, 12.341, 11.640> <-13.924, 15.027, 11.964> <-15.255, 15.577, 11.959> 
		<-15.627, 11.000, 11.149> <-15.395, 12.387, 10.839> <-13.692, 15.210, 11.306> <-15.023, 15.760, 11.300> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-15.627, 11.000, 11.149> <-15.395, 12.387, 10.839> <-13.692, 15.210, 11.306> <-15.023, 15.760, 11.300> 
		<-15.158, 11.068, 9.962> <-14.926, 12.455, 9.653> <-13.351, 15.478, 10.342> <-14.683, 16.028, 10.336> 
		<-13.137, 12.026, 9.444> <-13.041, 13.393, 9.409> <-12.451, 16.047, 9.276> <-13.741, 16.512, 9.258> 
		<-12.711, 12.090, 8.241> <-12.615, 13.457, 8.206> <-12.220, 16.124, 8.247> <-13.510, 16.589, 8.229> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-12.711, 12.090, 8.241> <-12.615, 13.457, 8.206> <-12.220, 16.124, 8.247> <-13.510, 16.589, 8.229> 
		<-12.249, 12.159, 6.937> <-12.153, 13.526, 6.902> <-11.915, 16.226, 6.889> <-13.205, 16.690, 6.870> 
		<-12.890, 11.451, 5.066> <-12.739, 12.929, 5.048> <-12.000, 15.919, 5.001> <-13.379, 16.471, 4.974> 
		<-12.984, 11.396, 3.685> <-12.833, 12.874, 3.667> <-11.912, 15.786, 3.614> <-13.291, 16.338, 3.586> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-12.984, 11.396, 3.685> <-12.833, 12.874, 3.667> <-11.912, 15.786, 3.614> <-13.291, 16.338, 3.586> 
		<-13.093, 11.332, 2.080> <-12.942, 12.810, 2.062> <-11.818, 15.643, 2.126> <-13.197, 16.195, 2.098> 
		<-13.103, 11.584, -0.076> <-12.915, 12.760, -0.254> <-11.670, 15.286, 0.141> <-12.804, 15.690, 0.148> 
		<-13.384, 11.697, -1.657> <-13.196, 12.872, -1.835> <-11.771, 15.264, -1.354> <-12.904, 15.668, -1.346> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-13.384, 11.697, -1.657> <-13.196, 12.872, -1.835> <-11.771, 15.264, -1.354> <-12.904, 15.668, -1.346> 
		<-13.761, 11.848, -3.775> <-13.573, 13.023, -3.953> <-11.922, 15.232, -3.614> <-13.056, 15.635, -3.606> 
		<-14.633, 12.099, -6.514> <-14.637, 13.301, -6.642> <-12.621, 15.597, -6.519> <-13.757, 16.011, -6.551> 
		<-15.169, 12.271, -8.596> <-15.172, 13.473, -8.723> <-12.987, 15.744, -8.750> <-14.122, 16.158, -8.782> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-49.873, 17.398, 83.617> <-49.258, 17.483, 82.452> <-48.450, 17.665, 80.896> <-47.823, 17.682, 79.735> 
		<-36.832, 17.010, 83.117> <-36.217, 17.095, 81.953> <-34.620, 17.277, 77.971> <-33.993, 17.294, 76.810> 
		<-19.367, 17.585, 82.456> <-17.962, 17.670, 78.867> <-15.828, 17.744, 77.359> <-15.342, 17.773, 73.534> 
		<-6.405, 16.104, 81.952> <-5.001, 16.189, 78.362> <-2.210, 16.359, 73.811> <-1.724, 16.387, 69.987> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-47.823, 17.682, 79.735> <-47.106, 17.701, 78.409> <-45.773, 17.521, 76.796> <-45.397, 17.516, 75.336> 
		<-33.993, 17.294, 76.810> <-33.276, 17.313, 75.484> <-33.466, 17.133, 73.984> <-33.089, 17.128, 72.524> 
		<-15.342, 17.773, 73.534> <-15.160, 17.783, 72.100> <-15.495, 17.764, 69.493> <-16.629, 17.759, 68.596> 
		<-1.724, 16.387, 69.987> <-1.541, 16.398, 68.552> <-3.238, 16.227, 66.860> <-4.373, 16.222, 65.963> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-45.397, 17.516, 75.336> <-45.041, 17.512, 73.959> <-45.547, 17.643, 72.019> <-45.466, 17.651, 70.599> 
		<-33.089, 17.128, 72.524> <-32.734, 17.124, 71.147> <-34.537, 17.255, 70.166> <-34.456, 17.263, 68.746> 
		<-16.629, 17.759, 68.596> <-17.726, 17.755, 67.730> <-18.284, 17.829, 66.240> <-19.681, 17.839, 66.286> 
		<-4.373, 16.222, 65.963> <-5.469, 16.217, 65.097> <-7.369, 16.347, 64.377> <-8.765, 16.357, 64.422> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-45.466, 17.651, 70.599> <-45.355, 17.663, 68.658> <-45.405, 17.641, 65.988> <-44.755, 17.580, 64.157> 
		<-34.456, 17.263, 68.746> <-34.344, 17.274, 66.805> <-35.918, 17.253, 66.616> <-35.267, 17.192, 64.785> 
		<-19.681, 17.839, 66.286> <-21.099, 17.850, 66.332> <-21.067, 18.168, 65.961> <-22.468, 18.052, 65.765> 
		<-8.765, 16.357, 64.422> <-10.184, 16.367, 64.469> <-11.728, 16.401, 66.446> <-13.129, 16.285, 66.251> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-44.755, 17.580, 64.157> <-44.380, 17.545, 63.102> <-42.528, 17.462, 62.503> <-42.211, 17.345, 61.436> 
		<-35.267, 17.192, 64.785> <-34.893, 17.156, 63.730> <-33.604, 17.073, 63.244> <-33.287, 16.957, 62.176> 
		<-22.468, 18.052, 65.765> <-23.193, 17.992, 65.664> <-21.058, 17.406, 64.137> <-21.330, 17.300, 63.462> 
		<-13.129, 16.285, 66.251> <-13.855, 16.225, 66.149> <-12.194, 16.156, 64.580> <-12.466, 16.051, 63.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-42.211, 17.345, 61.436> <-41.909, 17.235, 60.415> <-43.096, 16.830, 59.019> <-42.920, 16.907, 57.967> 
		<-33.287, 16.957, 62.176> <-32.985, 16.846, 61.156> <-34.680, 16.441, 60.212> <-34.504, 16.519, 59.159> 
		<-21.330, 17.300, 63.462> <-21.677, 17.166, 62.600> <-23.185, 16.759, 62.005> <-23.241, 16.842, 61.070> 
		<-12.466, 16.051, 63.905> <-12.813, 15.916, 63.042> <-14.810, 15.529, 62.875> <-14.866, 15.612, 61.940> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-42.920, 16.907, 57.967> <-42.637, 17.031, 56.276> <-40.633, 18.095, 54.481> <-40.760, 17.981, 52.771> 
		<-34.504, 16.519, 59.159> <-34.221, 16.643, 57.468> <-32.273, 17.706, 55.673> <-32.400, 17.593, 53.963> 
		<-23.241, 16.842, 61.070> <-23.342, 16.992, 59.382> <-21.230, 18.632, 57.381> <-21.079, 18.518, 55.693> 
		<-14.866, 15.612, 61.940> <-14.967, 15.762, 60.252> <-13.045, 16.801, 58.432> <-12.894, 16.687, 56.745> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-40.760, 17.981, 52.771> <-40.877, 17.877, 51.199> <-42.969, 16.275, 50.120> <-43.611, 16.292, 48.676> 
		<-32.400, 17.593, 53.963> <-32.517, 17.489, 52.391> <-34.102, 15.886, 51.369> <-34.744, 15.903, 49.924> 
		<-21.079, 18.518, 55.693> <-20.962, 18.429, 54.378> <-22.805, 16.569, 53.235> <-22.844, 16.486, 51.915> 
		<-12.894, 16.687, 56.745> <-12.777, 16.598, 55.429> <-14.015, 15.080, 54.158> <-14.054, 14.997, 52.837> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-43.611, 16.292, 48.676> <-43.916, 16.300, 47.990> <-43.543, 17.953, 47.635> <-43.363, 18.050, 46.913> 
		<-34.744, 15.903, 49.924> <-35.049, 15.911, 49.238> <-34.507, 17.319, 47.023> <-34.327, 17.416, 46.300> 
		<-22.844, 16.486, 51.915> <-22.915, 16.333, 49.502> <-22.180, 17.586, 47.851> <-22.136, 17.672, 45.434> 
		<-14.054, 14.997, 52.837> <-14.124, 14.845, 50.424> <-13.286, 15.851, 47.288> <-13.242, 15.937, 44.871> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-43.363, 18.050, 46.913> <-43.144, 18.168, 46.030> <-42.814, 17.025, 45.069> <-42.502, 16.889, 44.217> 
		<-34.327, 17.416, 46.300> <-34.107, 17.534, 45.417> <-34.229, 16.557, 44.852> <-33.917, 16.421, 44.000> 
		<-22.136, 17.672, 45.434> <-22.127, 17.690, 44.943> <-22.068, 16.937, 44.089> <-22.376, 16.650, 43.834> 
		<-13.242, 15.937, 44.871> <-13.233, 15.955, 44.380> <-13.577, 15.617, 43.746> <-13.884, 15.330, 43.492> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-42.502, 16.889, 44.217> <-42.229, 16.770, 43.472> <-41.536, 17.389, 42.553> <-41.481, 17.227, 41.769> 
		<-33.917, 16.421, 44.000> <-33.644, 16.302, 43.255> <-33.832, 16.287, 42.849> <-33.777, 16.126, 42.065> 
		<-22.376, 16.650, 43.834> <-22.886, 16.176, 43.413> <-22.590, 15.854, 42.804> <-23.276, 15.708, 42.392> 
		<-13.884, 15.330, 43.492> <-14.394, 14.855, 43.070> <-15.114, 13.700, 43.169> <-15.801, 13.555, 42.757> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-41.481, 17.227, 41.769> <-41.375, 16.914, 40.248> <-42.416, 15.745, 38.399> <-41.995, 15.389, 36.943> 
		<-33.777, 16.126, 42.065> <-33.671, 15.812, 40.544> <-35.727, 15.357, 39.315> <-35.306, 15.001, 37.860> 
		<-23.276, 15.708, 42.392> <-24.492, 15.450, 41.661> <-25.405, 16.017, 40.478> <-26.136, 16.019, 39.235> 
		<-15.801, 13.555, 42.757> <-17.016, 13.296, 42.026> <-18.967, 14.092, 41.240> <-19.698, 14.095, 39.998> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-41.995, 15.389, 36.943> <-41.519, 14.987, 35.298> <-39.409, 14.926, 33.731> <-38.690, 14.868, 32.126> 
		<-35.306, 15.001, 37.860> <-34.830, 14.598, 36.214> <-34.412, 14.537, 33.745> <-33.693, 14.480, 32.140> 
		<-26.136, 16.019, 39.235> <-27.382, 16.023, 37.120> <-26.592, 14.501, 34.459> <-26.968, 14.436, 32.035> 
		<-19.698, 14.095, 39.998> <-20.943, 14.098, 37.883> <-21.656, 13.638, 34.598> <-22.032, 13.573, 32.174> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-38.690, 14.868, 32.126> <-38.224, 14.831, 31.086> <-38.646, 15.036, 29.396> <-38.153, 15.080, 28.369> 
		<-33.693, 14.480, 32.140> <-33.227, 14.442, 31.100> <-33.649, 14.648, 29.411> <-33.156, 14.692, 28.383> 
		<-26.968, 14.436, 32.035> <-27.143, 14.406, 30.908> <-26.760, 14.259, 29.846> <-26.429, 14.579, 28.803> 
		<-22.032, 13.573, 32.174> <-22.207, 13.543, 31.047> <-21.826, 13.465, 29.460> <-21.495, 13.786, 28.417> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-38.153, 15.080, 28.369> <-37.427, 15.146, 26.857> <-35.363, 15.085, 25.485> <-34.754, 15.221, 23.926> 
		<-33.156, 14.692, 28.383> <-32.430, 14.757, 26.871> <-30.782, 15.330, 25.549> <-30.172, 15.467, 23.991> 
		<-26.429, 14.579, 28.803> <-25.973, 15.021, 27.365> <-24.258, 16.302, 25.228> <-23.980, 16.882, 23.794> 
		<-21.495, 13.786, 28.417> <-21.039, 14.227, 26.980> <-19.761, 15.461, 25.574> <-19.482, 16.041, 24.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-34.754, 15.221, 23.926> <-34.473, 15.285, 23.207> <-35.751, 15.458, 22.168> <-35.462, 15.685, 21.485> 
		<-30.172, 15.467, 23.991> <-29.891, 15.530, 23.271> <-31.170, 15.704, 22.232> <-30.881, 15.931, 21.549> 
		<-23.980, 16.882, 23.794> <-23.843, 17.168, 23.087> <-24.967, 17.469, 22.590> <-24.665, 17.505, 21.877> 
		<-19.482, 16.041, 24.141> <-19.345, 16.327, 23.433> <-20.492, 16.468, 22.412> <-20.190, 16.504, 21.699> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-35.462, 15.685, 21.485> <-34.715, 16.272, 19.721> <-32.599, 17.563, 18.160> <-31.583, 17.714, 16.438> 
		<-30.881, 15.931, 21.549> <-30.133, 16.518, 19.785> <-28.017, 17.175, 18.224> <-27.001, 17.325, 16.503> 
		<-24.665, 17.505, 21.877> <-23.921, 17.594, 20.120> <-21.581, 18.272, 17.960> <-20.621, 17.991, 16.334> 
		<-20.190, 16.504, 21.699> <-19.446, 16.593, 19.943> <-17.271, 16.700, 18.279> <-16.311, 16.419, 16.653> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-31.583, 17.714, 16.438> <-31.056, 17.792, 15.546> <-30.913, 16.518, 14.372> <-30.671, 16.395, 13.369> 
		<-27.001, 17.325, 16.503> <-26.475, 17.403, 15.611> <-26.331, 16.130, 14.436> <-26.090, 16.006, 13.433> 
		<-20.621, 17.991, 16.334> <-20.099, 17.838, 15.449> <-20.051, 16.519, 14.458> <-19.810, 16.395, 13.455> 
		<-16.311, 16.419, 16.653> <-15.789, 16.266, 15.768> <-15.641, 15.224, 14.586> <-15.400, 15.100, 13.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-30.671, 16.395, 13.369> <-30.503, 16.309, 12.672> <-30.527, 16.871, 11.744> <-30.295, 17.054, 11.086> 
		<-26.090, 16.006, 13.433> <-25.922, 15.921, 12.737> <-25.945, 16.483, 11.809> <-25.713, 16.666, 11.150> 
		<-19.810, 16.395, 13.455> <-19.642, 16.309, 12.759> <-19.506, 17.331, 11.940> <-19.273, 17.514, 11.282> 
		<-15.400, 15.100, 13.583> <-15.232, 15.014, 12.886> <-15.255, 15.577, 11.959> <-15.023, 15.760, 11.300> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-30.295, 17.054, 11.086> <-29.954, 17.322, 10.122> <-29.012, 17.806, 9.043> <-28.781, 17.883, 8.015> 
		<-25.713, 16.666, 11.150> <-25.373, 16.934, 10.186> <-24.431, 17.418, 9.108> <-24.200, 17.495, 8.079> 
		<-19.273, 17.514, 11.282> <-18.933, 17.782, 10.318> <-18.066, 18.071, 9.197> <-17.835, 18.148, 8.168> 
		<-15.023, 15.760, 11.300> <-14.683, 16.028, 10.336> <-13.741, 16.512, 9.258> <-13.510, 16.589, 8.229> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-28.781, 17.883, 8.015> <-28.476, 17.985, 6.656> <-28.650, 17.766, 4.760> <-28.563, 17.632, 3.372> 
		<-24.200, 17.495, 8.079> <-23.895, 17.597, 6.720> <-24.069, 17.377, 4.824> <-23.981, 17.244, 3.437> 
		<-17.835, 18.148, 8.168> <-17.530, 18.250, 6.809> <-17.647, 18.180, 4.888> <-17.559, 18.046, 3.501> 
		<-13.510, 16.589, 8.229> <-13.205, 16.690, 6.870> <-13.379, 16.471, 4.974> <-13.291, 16.338, 3.586> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-28.563, 17.632, 3.372> <-28.469, 17.489, 1.884> <-28.076, 16.984, -0.066> <-28.176, 16.963, -1.561> 
		<-23.981, 17.244, 3.437> <-23.887, 17.101, 1.948> <-23.494, 16.596, -0.002> <-23.595, 16.574, -1.496> 
		<-17.559, 18.046, 3.501> <-17.465, 17.903, 2.013> <-17.136, 17.232, 0.176> <-17.236, 17.210, -1.318> 
		<-13.291, 16.338, 3.586> <-13.197, 16.195, 2.098> <-12.804, 15.690, 0.148> <-12.904, 15.668, -1.346> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-28.176, 16.963, -1.561> <-28.328, 16.930, -3.820> <-29.029, 17.306, -6.766> <-29.394, 17.453, -8.996> 
		<-23.595, 16.574, -1.496> <-23.746, 16.541, -3.756> <-24.447, 16.917, -6.701> <-24.813, 17.064, -8.932> 
		<-17.236, 17.210, -1.318> <-17.388, 17.177, -3.578> <-18.076, 17.585, -6.673> <-18.442, 17.732, -8.904> 
		<-12.904, 15.668, -1.346> <-13.056, 15.635, -3.606> <-13.757, 16.011, -6.551> <-14.122, 16.158, -8.782> 
	}
	
	texture { txCliff }
}

// Layer 4
#declare oFaar =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.469, 0.000, 62.214> <-4.559, 0.468, 70.271> <-10.231, 0.664, 80.614> <-11.769, 1.562, 89.071> 
		<-0.896, 0.000, 64.263> <-3.985, 0.468, 72.320> <-9.514, 0.664, 83.173> <-11.052, 1.562, 91.630> 
		<-1.218, 0.000, 67.715> <-4.165, 0.468, 76.282> <-10.087, 0.672, 87.017> <-11.455, 1.562, 95.941> 
		<0.443, 0.000, 69.044> <-2.504, 0.468, 77.611> <-8.012, 0.672, 88.677> <-9.380, 1.562, 97.601> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.443, 0.000, 69.044> <-2.504, 0.468, 77.611> <-8.012, 0.672, 88.677> <-9.380, 1.562, 97.601> 
		<1.639, 0.000, 70.001> <-1.308, 0.468, 78.568> <-6.519, 0.672, 89.872> <-7.887, 1.562, 98.796> 
		<3.856, 0.000, 67.962> <1.277, 0.468, 76.427> <-4.087, 0.677, 87.735> <-5.052, 1.562, 96.500> 
		<5.361, 0.000, 67.678> <2.781, 0.468, 76.143> <-2.272, 0.677, 87.131> <-3.238, 1.562, 95.895> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.361, 0.000, 67.678> <2.781, 0.468, 76.143> <-2.272, 0.677, 87.131> <-3.238, 1.562, 95.895> 
		<9.520, 0.000, 66.895> <6.940, 0.468, 75.360> <2.980, 0.677, 85.380> <2.014, 1.562, 94.144> 
		<15.124, 0.000, 64.786> <13.584, 0.468, 72.064> <8.515, 0.735, 82.926> <8.658, 1.562, 90.333> 
		<19.296, 0.000, 65.492> <17.756, 0.468, 72.771> <14.021, 0.735, 82.347> <14.164, 1.562, 89.753> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<19.296, 0.000, 65.492> <17.756, 0.468, 72.771> <14.021, 0.735, 82.347> <14.164, 1.562, 89.753> 
		<25.644, 0.000, 66.567> <24.104, 0.468, 73.846> <22.379, 0.735, 81.467> <22.522, 1.562, 88.873> 
		<32.993, 0.000, 74.968> <33.863, 0.468, 80.279> <32.555, 0.910, 89.047> <34.294, 1.562, 94.120> 
		<39.241, 0.000, 73.416> <40.112, 0.468, 78.726> <40.405, 0.910, 86.045> <42.144, 1.562, 91.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<39.241, 0.000, 73.416> <40.112, 0.468, 78.726> <40.405, 0.910, 86.045> <42.144, 1.562, 91.118> 
		<48.137, 0.000, 71.206> <49.008, 0.468, 76.516> <51.097, 0.910, 81.957> <52.836, 1.562, 87.030> 
		<57.777, 0.000, 61.890> <60.443, 0.468, 65.793> <62.351, 0.955, 73.044> <65.293, 1.562, 76.724> 
		<63.285, 0.000, 54.563> <65.951, 0.468, 58.466> <69.230, 0.955, 63.894> <72.172, 1.562, 67.574> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<63.285, 0.000, 54.563> <65.951, 0.468, 58.466> <69.230, 0.955, 63.894> <72.172, 1.562, 67.574> 
		<67.168, 0.000, 49.397> <69.834, 0.468, 53.300> <74.080, 0.955, 57.442> <77.022, 1.562, 61.122> 
		<67.301, 0.000, 40.028> <70.396, 0.468, 42.381> <74.131, 0.993, 47.041> <77.188, 1.562, 49.421> 
		<69.022, 0.000, 33.798> <72.117, 0.468, 36.151> <76.280, 0.993, 39.261> <79.337, 1.562, 41.641> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.769, 1.562, 89.071> <-13.044, 2.306, 96.084> <-10.757, 6.127, 105.506> <-10.638, 5.354, 112.629> 
		<-11.052, 1.562, 91.630> <-12.328, 2.306, 98.643> <-9.904, 6.127, 108.551> <-9.786, 5.354, 115.675> 
		<-11.455, 1.562, 95.941> <-12.610, 2.312, 103.470> <-10.454, 6.154, 113.196> <-10.265, 5.354, 120.806> 
		<-9.380, 1.562, 97.601> <-10.535, 2.312, 105.130> <-7.984, 6.154, 115.172> <-7.796, 5.354, 122.781> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.380, 1.562, 97.601> <-10.535, 2.312, 105.130> <-7.984, 6.154, 115.172> <-7.796, 5.354, 122.781> 
		<-7.887, 1.562, 98.796> <-9.041, 2.312, 106.325> <-6.207, 6.154, 116.593> <-6.019, 5.354, 124.203> 
		<-5.052, 1.562, 96.500> <-5.879, 2.319, 104.005> <-3.000, 6.151, 113.933> <-2.646, 5.354, 121.471> 
		<-3.238, 1.562, 95.895> <-4.065, 2.319, 103.400> <-0.841, 6.151, 113.213> <-0.487, 5.354, 120.751> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.238, 1.562, 95.895> <-4.065, 2.319, 103.400> <-0.841, 6.151, 113.213> <-0.487, 5.354, 120.751> 
		<2.014, 1.562, 94.144> <1.187, 2.319, 101.649> <5.409, 6.151, 111.130> <5.764, 5.354, 118.667> 
		<8.658, 1.562, 90.333> <8.801, 2.385, 97.709> <12.848, 6.147, 106.797> <13.671, 5.354, 114.131> 
		<14.164, 1.562, 89.753> <14.307, 2.385, 97.129> <19.400, 6.147, 106.107> <20.223, 5.354, 113.442> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<14.164, 1.562, 89.753> <14.307, 2.385, 97.129> <19.400, 6.147, 106.107> <20.223, 5.354, 113.442> 
		<22.522, 1.562, 88.873> <22.665, 2.385, 96.249> <29.346, 6.147, 105.060> <30.169, 5.354, 112.395> 
		<34.294, 1.562, 94.120> <36.881, 2.531, 101.664> <42.505, 6.195, 110.824> <44.179, 5.354, 118.638> 
		<42.144, 1.562, 91.118> <44.731, 2.531, 98.663> <51.846, 6.195, 107.253> <53.521, 5.354, 115.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<42.144, 1.562, 91.118> <44.731, 2.531, 98.663> <51.846, 6.195, 107.253> <53.521, 5.354, 115.066> 
		<52.836, 1.562, 87.030> <55.423, 2.531, 94.575> <64.571, 6.195, 102.387> <66.245, 5.354, 110.201> 
		<65.293, 1.562, 76.724> <70.158, 2.564, 82.808> <78.457, 6.221, 90.580> <81.069, 5.354, 97.936> 
		<72.172, 1.562, 67.574> <77.036, 2.564, 73.658> <86.643, 6.221, 79.691> <89.255, 5.354, 87.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<72.172, 1.562, 67.574> <77.036, 2.564, 73.658> <86.643, 6.221, 79.691> <89.255, 5.354, 87.047> 
		<77.022, 1.562, 61.122> <81.886, 2.564, 67.207> <92.414, 6.221, 72.013> <95.026, 5.354, 79.369> 
		<77.188, 1.562, 49.421> <82.760, 2.599, 53.759> <92.433, 6.211, 58.930> <95.224, 5.354, 65.444> 
		<79.337, 1.562, 41.641> <84.910, 2.599, 45.979> <94.991, 6.211, 49.672> <97.782, 5.354, 56.186> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.912, -4.016, 140.498> <-10.059, -4.016, 143.544> <-10.539, -4.016, 148.674> <-8.069, -4.016, 150.650> 
		<-10.830, -1.205, 132.138> <-9.977, -1.205, 135.183> <-10.457, -1.205, 140.314> <-7.987, -1.205, 142.289> 
		<-10.492, 4.403, 121.398> <-9.639, 4.403, 124.443> <-10.049, 4.432, 129.575> <-7.579, 4.432, 131.551> 
		<-10.638, 5.354, 112.629> <-9.786, 5.354, 115.675> <-10.265, 5.354, 120.806> <-7.796, 5.354, 122.781> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.069, -4.016, 150.650> <-6.292, -4.016, 152.072> <-2.919, -4.016, 149.339> <-0.760, -4.016, 148.620> 
		<-7.987, -1.205, 142.289> <-6.210, -1.205, 143.711> <-2.837, -1.205, 140.979> <-0.678, -1.205, 140.259> 
		<-7.579, 4.432, 131.551> <-5.802, 4.432, 132.973> <-2.234, 4.427, 130.233> <-0.075, 4.427, 129.513> 
		<-7.796, 5.354, 122.781> <-6.019, 5.354, 124.203> <-2.646, 5.354, 121.471> <-0.487, 5.354, 120.751> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.760, -4.016, 148.620> <5.491, -4.016, 146.536> <13.397, -4.016, 142.000> <19.950, -4.016, 141.310> 
		<-0.678, -1.205, 140.259> <5.573, -1.205, 138.176> <13.479, -1.205, 133.640> <20.032, -1.205, 132.950> 
		<-0.075, 4.427, 129.513> <6.176, 4.427, 127.430> <14.649, 4.411, 122.847> <21.201, 4.411, 122.157> 
		<-0.487, 5.354, 120.751> <5.764, 5.354, 118.667> <13.671, 5.354, 114.131> <20.223, 5.354, 113.442> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<19.950, -4.016, 141.310> <29.896, -4.016, 140.264> <43.906, -4.016, 146.507> <53.247, -4.016, 142.935> 
		<20.032, -1.205, 132.950> <29.978, -1.205, 131.903> <43.988, -1.205, 138.146> <53.329, -1.205, 134.574> 
		<21.201, 4.411, 122.157> <31.147, 4.411, 121.110> <46.017, 4.431, 127.215> <55.359, 4.431, 123.644> 
		<20.223, 5.354, 113.442> <30.169, 5.354, 112.395> <44.179, 5.354, 118.638> <53.521, 5.354, 115.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<53.247, -4.016, 142.935> <65.972, -4.016, 138.070> <80.796, -4.016, 125.805> <88.981, -4.016, 114.916> 
		<53.329, -1.205, 134.574> <66.054, -1.205, 129.709> <80.878, -1.205, 117.444> <89.063, -1.205, 106.555> 
		<55.359, 4.431, 123.644> <68.083, 4.431, 118.778> <84.002, 4.381, 106.198> <92.188, 4.381, 95.309> 
		<53.521, 5.354, 115.066> <66.245, 5.354, 110.201> <81.069, 5.354, 97.936> <89.255, 5.354, 87.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<88.981, -4.016, 114.916> <94.753, -4.016, 107.238> <94.951, -4.016, 93.313> <97.509, -4.016, 84.055> 
		<89.063, -1.205, 106.555> <94.835, -1.205, 98.877> <95.032, -1.205, 84.953> <97.591, -1.205, 75.694> 
		<92.188, 4.381, 95.309> <97.960, 4.381, 87.631> <98.672, 4.296, 73.494> <101.231, 4.296, 64.235> 
		<89.255, 5.354, 87.047> <95.026, 5.354, 79.369> <95.224, 5.354, 65.444> <97.782, 5.354, 56.186> 
	}
	
	texture { txFaar }
}

// Layer 5
#declare oFall =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-31.788, 15.133, 41.549> <-28.315, 15.262, 40.975> <-23.651, 16.073, 40.205> <-20.213, 15.561, 39.637> 
		<-32.120, 15.151, 41.033> <-28.648, 15.280, 40.459> <-24.027, 15.934, 40.033> <-20.589, 15.422, 39.465> 
		<-32.628, 15.185, 40.382> <-29.199, 15.156, 40.152> <-24.665, 15.454, 39.750> <-21.254, 15.171, 39.437> 
		<-32.896, 15.193, 39.830> <-29.468, 15.164, 39.600> <-24.877, 15.380, 39.376> <-21.467, 15.097, 39.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-31.788, 15.133, 41.549> <-32.120, 14.971, 41.033> <-32.624, 14.705, 40.392> <-32.896, 14.592, 39.830> 
		<-28.315, 15.262, 40.975> <-28.648, 15.099, 40.459> <-29.001, 14.513, 39.896> <-29.274, 14.400, 39.334> 
		<-23.651, 16.073, 40.205> <-23.834, 15.590, 39.767> <-24.093, 14.556, 39.080> <-24.440, 14.395, 38.522> 
		<-20.213, 15.561, 39.637> <-20.396, 15.078, 39.199> <-20.476, 14.112, 38.737> <-20.822, 13.951, 38.178> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-32.896, 14.592, 39.830> <-33.194, 14.469, 39.216> <-33.463, 14.386, 38.327> <-33.673, 14.352, 37.667> 
		<-29.274, 14.400, 39.334> <-29.572, 14.276, 38.721> <-29.946, 14.506, 38.078> <-30.156, 14.472, 37.418> 
		<-24.440, 14.395, 38.522> <-24.736, 14.257, 38.044> <-25.219, 14.853, 37.776> <-25.449, 14.911, 37.249> 
		<-20.822, 13.951, 38.178> <-21.118, 13.813, 37.701> <-21.719, 14.694, 37.363> <-21.949, 14.752, 36.836> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-33.673, 14.352, 37.667> <-33.913, 14.314, 36.910> <-34.248, 14.352, 35.899> <-34.394, 14.352, 35.117> 
		<-30.156, 14.472, 37.418> <-30.396, 14.433, 36.661> <-30.703, 14.364, 35.614> <-30.848, 14.364, 34.832> 
		<-25.449, 14.911, 37.249> <-25.780, 14.994, 36.492> <-25.989, 14.520, 35.190> <-26.125, 14.464, 34.374> 
		<-21.949, 14.752, 36.836> <-22.279, 14.835, 36.080> <-22.438, 14.446, 34.983> <-22.574, 14.391, 34.167> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-34.394, 14.352, 35.117> <-34.549, 14.352, 34.279> <-34.687, 14.352, 33.141> <-34.671, 14.352, 32.289> 
		<-30.848, 14.364, 34.832> <-31.003, 14.364, 33.994> <-31.135, 14.364, 32.920> <-31.119, 14.364, 32.067> 
		<-26.125, 14.464, 34.374> <-26.254, 14.411, 33.597> <-26.388, 14.459, 32.680> <-26.373, 14.459, 31.892> 
		<-22.574, 14.391, 34.167> <-22.704, 14.337, 33.390> <-22.846, 14.391, 32.339> <-22.831, 14.391, 31.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-34.671, 14.352, 32.289> <-34.653, 14.352, 31.367> <-34.571, 14.302, 30.114> <-34.283, 14.352, 29.239> 
		<-31.119, 14.364, 32.067> <-31.101, 14.364, 31.145> <-31.028, 14.313, 29.961> <-30.739, 14.364, 29.086> 
		<-26.373, 14.459, 31.892> <-26.357, 14.459, 31.038> <-26.259, 14.430, 29.763> <-26.009, 14.520, 28.952> 
		<-22.831, 14.391, 31.550> <-22.815, 14.391, 30.697> <-22.722, 14.301, 29.539> <-22.472, 14.391, 28.728> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-34.283, 14.352, 29.239> <-34.043, 14.394, 28.512> <-33.351, 14.512, 27.717> <-32.952, 14.652, 27.077> 
		<-30.739, 14.364, 29.086> <-30.500, 14.406, 28.359> <-29.864, 14.594, 27.601> <-29.465, 14.735, 26.961> 
		<-26.009, 14.520, 28.952> <-25.798, 14.595, 28.269> <-25.279, 15.182, 27.189> <-24.796, 15.333, 26.678> 
		<-22.472, 14.391, 28.728> <-22.261, 14.466, 28.045> <-21.813, 14.777, 27.202> <-21.330, 14.928, 26.692> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-32.952, 14.652, 27.077> <-32.633, 14.765, 26.566> <-32.214, 15.031, 25.913> <-31.898, 15.193, 25.414> 
		<-29.465, 14.735, 26.961> <-29.147, 14.847, 26.450> <-28.709, 15.002, 26.191> <-28.393, 15.164, 25.692> 
		<-24.796, 15.333, 26.678> <-24.557, 15.408, 26.426> <-23.994, 15.722, 26.247> <-23.659, 15.772, 26.142> 
		<-21.330, 14.928, 26.692> <-21.091, 15.003, 26.440> <-20.548, 15.046, 26.446> <-20.213, 15.097, 26.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-31.898, 15.193, 25.414> <-32.214, 15.193, 25.913> <-32.640, 15.193, 26.576> <-32.952, 15.193, 27.077> 
		<-28.393, 15.164, 25.692> <-28.709, 15.164, 26.191> <-29.104, 15.139, 26.510> <-29.416, 15.139, 27.012> 
		<-23.659, 15.772, 26.142> <-23.944, 15.747, 26.298> <-24.453, 15.429, 26.639> <-24.677, 15.436, 26.876> 
		<-20.213, 15.097, 26.341> <-20.499, 15.072, 26.497> <-20.941, 15.006, 26.623> <-21.165, 15.014, 26.859> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-32.952, 15.193, 27.077> <-33.355, 15.193, 27.724> <-34.044, 15.193, 28.516> <-34.283, 15.193, 29.239> 
		<-29.416, 15.139, 27.012> <-29.819, 15.139, 27.658> <-30.501, 15.186, 28.363> <-30.739, 15.186, 29.086> 
		<-24.677, 15.436, 26.876> <-25.148, 15.451, 27.374> <-25.787, 15.269, 28.138> <-26.016, 15.290, 28.783> 
		<-21.165, 15.014, 26.859> <-21.637, 15.028, 27.357> <-22.242, 15.147, 28.082> <-22.472, 15.169, 28.728> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-34.283, 15.193, 29.239> <-34.572, 15.193, 30.115> <-34.653, 15.193, 31.367> <-34.671, 15.193, 32.289> 
		<-30.739, 15.186, 29.086> <-31.028, 15.186, 29.962> <-31.101, 15.186, 31.145> <-31.119, 15.186, 32.067> 
		<-26.016, 15.290, 28.783> <-26.301, 15.317, 29.587> <-26.364, 15.401, 30.818> <-26.380, 15.401, 31.671> 
		<-22.472, 15.169, 28.728> <-22.757, 15.195, 29.532> <-22.815, 15.169, 30.697> <-22.831, 15.169, 31.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-34.671, 15.193, 32.289> <-34.687, 15.193, 33.141> <-34.549, 15.193, 34.279> <-34.394, 15.193, 35.117> 
		<-31.119, 15.186, 32.067> <-31.135, 15.186, 32.920> <-31.003, 15.186, 33.994> <-30.848, 15.186, 34.832> 
		<-26.380, 15.401, 31.671> <-26.395, 15.401, 32.460> <-26.237, 15.450, 33.647> <-26.114, 15.409, 34.425> 
		<-22.831, 15.169, 31.550> <-22.846, 15.169, 32.339> <-22.698, 15.209, 33.389> <-22.574, 15.169, 34.167> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-34.394, 15.193, 35.117> <-34.248, 15.193, 35.899> <-33.913, 15.193, 36.910> <-33.673, 15.193, 37.667> 
		<-30.848, 15.186, 34.832> <-30.703, 15.186, 35.614> <-30.431, 15.111, 36.521> <-30.191, 15.111, 37.279> 
		<-26.114, 15.409, 34.425> <-26.007, 15.375, 35.099> <-25.686, 15.199, 36.120> <-25.535, 15.189, 36.786> 
		<-22.574, 15.169, 34.167> <-22.467, 15.134, 34.840> <-22.216, 14.930, 35.705> <-22.066, 14.920, 36.371> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-33.673, 15.193, 37.667> <-33.464, 15.193, 38.324> <-33.198, 15.203, 39.210> <-32.896, 15.193, 39.830> 
		<-30.191, 15.111, 37.279> <-29.982, 15.111, 37.935> <-29.769, 15.174, 38.980> <-29.468, 15.164, 39.600> 
		<-25.535, 15.189, 36.786> <-25.352, 15.177, 37.595> <-25.281, 15.241, 38.665> <-24.877, 15.380, 39.376> 
		<-22.066, 14.920, 36.371> <-21.883, 14.908, 37.180> <-21.870, 14.958, 38.353> <-21.467, 15.097, 39.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-20.213, 15.561, 39.637> <-19.494, 15.454, 39.518> <-19.447, 14.003, 39.511> <-19.321, 13.278, 39.489> 
		<-20.589, 15.422, 39.465> <-19.870, 15.315, 39.346> <-19.401, 14.361, 39.520> <-19.274, 13.635, 39.498> 
		<-21.254, 15.171, 39.437> <-20.559, 15.113, 39.374> <-19.677, 14.604, 39.067> <-19.364, 13.990, 38.940> 
		<-21.467, 15.097, 39.063> <-20.771, 15.040, 39.000> <-19.733, 14.688, 38.721> <-19.421, 14.074, 38.593> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-20.213, 15.561, 39.637> <-20.396, 15.078, 39.199> <-20.476, 14.112, 38.737> <-20.822, 13.951, 38.178> 
		<-19.494, 15.454, 39.518> <-19.677, 14.971, 39.080> <-19.987, 14.052, 38.691> <-20.333, 13.891, 38.132> 
		<-19.447, 14.003, 39.511> <-19.486, 13.703, 39.504> <-19.620, 13.385, 38.866> <-19.719, 13.425, 38.583> 
		<-19.321, 13.278, 39.489> <-19.360, 12.978, 39.481> <-19.467, 12.916, 38.848> <-19.566, 12.956, 38.565> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-20.822, 13.951, 38.178> <-21.118, 13.813, 37.701> <-21.719, 14.694, 37.363> <-21.949, 14.752, 36.836> 
		<-20.333, 13.891, 38.132> <-20.629, 13.753, 37.655> <-21.152, 14.668, 37.296> <-21.383, 14.726, 36.769> 
		<-19.719, 13.425, 38.583> <-19.988, 13.534, 37.813> <-20.393, 14.090, 36.889> <-20.698, 14.288, 36.151> 
		<-19.566, 12.956, 38.565> <-19.835, 13.064, 37.795> <-20.194, 13.557, 36.852> <-20.499, 13.754, 36.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-21.949, 14.752, 36.836> <-22.279, 14.835, 36.080> <-22.438, 14.446, 34.983> <-22.574, 14.391, 34.167> 
		<-21.383, 14.726, 36.769> <-21.713, 14.809, 36.013> <-22.044, 14.438, 34.960> <-22.180, 14.382, 34.144> 
		<-20.698, 14.288, 36.151> <-20.916, 14.429, 35.622> <-21.419, 14.382, 34.928> <-21.509, 14.421, 34.347> 
		<-20.499, 13.754, 36.114> <-20.718, 13.895, 35.585> <-21.217, 14.043, 34.935> <-21.307, 14.081, 34.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-22.574, 14.391, 34.167> <-22.704, 14.337, 33.390> <-22.846, 14.391, 32.339> <-22.831, 14.391, 31.550> 
		<-22.180, 14.382, 34.144> <-22.309, 14.329, 33.367> <-22.350, 14.381, 32.291> <-22.335, 14.381, 31.502> 
		<-21.509, 14.421, 34.347> <-21.663, 14.487, 33.355> <-21.654, 14.549, 31.972> <-21.563, 14.512, 30.971> 
		<-21.307, 14.081, 34.353> <-21.461, 14.147, 33.361> <-21.384, 14.131, 32.000> <-21.293, 14.094, 30.999> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-22.831, 14.391, 31.550> <-22.815, 14.391, 30.697> <-22.722, 14.301, 29.539> <-22.472, 14.391, 28.728> 
		<-22.335, 14.381, 31.502> <-22.319, 14.381, 30.649> <-22.178, 14.281, 29.504> <-21.927, 14.371, 28.694> 
		<-21.563, 14.512, 30.971> <-21.490, 14.482, 30.171> <-21.323, 14.502, 29.064> <-21.055, 14.319, 28.329> 
		<-21.293, 14.094, 30.999> <-21.220, 14.064, 30.199> <-21.034, 14.043, 29.119> <-20.765, 13.859, 28.384> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-22.472, 14.391, 28.728> <-22.261, 14.466, 28.045> <-21.813, 14.777, 27.202> <-21.330, 14.928, 26.692> 
		<-21.927, 14.371, 28.694> <-21.716, 14.446, 28.011> <-21.111, 14.695, 27.205> <-20.628, 14.846, 26.694> 
		<-21.055, 14.319, 28.329> <-20.884, 14.202, 27.861> <-20.396, 13.981, 27.462> <-20.134, 13.781, 27.071> 
		<-20.765, 13.859, 28.384> <-20.594, 13.742, 27.917> <-20.141, 13.325, 27.518> <-19.878, 13.125, 27.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-21.330, 14.928, 26.692> <-21.091, 15.003, 26.440> <-20.548, 15.046, 26.446> <-20.213, 15.097, 26.341> 
		<-20.628, 14.846, 26.694> <-20.390, 14.921, 26.442> <-19.793, 14.898, 26.490> <-19.458, 14.949, 26.385> 
		<-20.134, 13.781, 27.071> <-19.945, 13.638, 26.789> <-19.753, 13.279, 26.253> <-19.439, 13.466, 26.202> 
		<-19.878, 13.125, 27.127> <-19.689, 12.981, 26.845> <-19.577, 12.530, 26.196> <-19.264, 12.717, 26.144> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-20.213, 15.097, 26.341> <-20.499, 15.072, 26.497> <-20.941, 15.006, 26.623> <-21.165, 15.014, 26.859> 
		<-19.458, 14.949, 26.385> <-19.743, 14.924, 26.540> <-20.205, 14.918, 26.619> <-20.429, 14.925, 26.856> 
		<-19.439, 13.466, 26.202> <-19.134, 13.648, 26.151> <-19.368, 14.027, 26.678> <-19.461, 14.224, 26.962> 
		<-19.264, 12.717, 26.144> <-18.959, 12.899, 26.093> <-19.095, 13.339, 26.728> <-19.188, 13.537, 27.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-21.165, 15.014, 26.859> <-21.637, 15.028, 27.357> <-22.242, 15.147, 28.082> <-22.472, 15.169, 28.728> 
		<-20.429, 14.925, 26.856> <-20.900, 14.940, 27.354> <-21.545, 15.123, 28.071> <-21.774, 15.145, 28.717> 
		<-19.461, 14.224, 26.962> <-19.660, 14.643, 27.567> <-20.343, 15.200, 28.257> <-20.562, 15.311, 28.978> 
		<-19.188, 13.537, 27.013> <-19.387, 13.955, 27.617> <-19.990, 14.599, 28.299> <-20.209, 14.710, 29.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-22.472, 15.169, 28.728> <-22.757, 15.195, 29.532> <-22.815, 15.169, 30.697> <-22.831, 15.169, 31.550> 
		<-21.774, 15.145, 28.717> <-22.060, 15.171, 29.521> <-22.105, 15.122, 30.672> <-22.122, 15.122, 31.526> 
		<-20.562, 15.311, 28.978> <-20.810, 15.436, 29.789> <-21.054, 14.960, 30.932> <-21.027, 14.877, 31.785> 
		<-20.209, 14.710, 29.020> <-20.457, 14.835, 29.832> <-20.678, 14.357, 30.957> <-20.651, 14.274, 31.810> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-22.831, 15.169, 31.550> <-22.846, 15.169, 32.339> <-22.698, 15.209, 33.389> <-22.574, 15.169, 34.167> 
		<-22.122, 15.122, 31.526> <-22.136, 15.122, 32.314> <-21.892, 15.154, 33.330> <-21.769, 15.114, 34.108> 
		<-21.027, 14.877, 31.785> <-21.005, 14.809, 32.482> <-20.588, 14.938, 33.415> <-20.463, 14.913, 34.105> 
		<-20.651, 14.274, 31.810> <-20.629, 14.206, 32.507> <-20.176, 14.242, 33.378> <-20.051, 14.218, 34.068> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-22.574, 15.169, 34.167> <-22.467, 15.134, 34.840> <-22.216, 14.930, 35.705> <-22.066, 14.920, 36.371> 
		<-21.769, 15.114, 34.108> <-21.662, 15.079, 34.781> <-21.519, 14.876, 35.622> <-21.369, 14.866, 36.288> 
		<-20.463, 14.913, 34.105> <-20.358, 14.893, 34.683> <-20.287, 14.763, 35.529> <-20.206, 14.745, 36.111> 
		<-20.051, 14.218, 34.068> <-19.946, 14.197, 34.646> <-19.967, 14.143, 35.437> <-19.886, 14.125, 36.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-22.066, 14.920, 36.371> <-21.883, 14.908, 37.180> <-21.870, 14.958, 38.353> <-21.467, 15.097, 39.063> 
		<-21.369, 14.866, 36.288> <-21.186, 14.854, 37.096> <-21.175, 14.900, 38.289> <-20.771, 15.040, 39.000> 
		<-20.206, 14.745, 36.111> <-20.098, 14.720, 36.888> <-19.856, 14.872, 37.968> <-19.733, 14.688, 38.721> 
		<-19.886, 14.125, 36.019> <-19.778, 14.100, 36.796> <-19.543, 14.258, 37.840> <-19.421, 14.074, 38.593> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-19.321, 13.278, 39.489> <-19.009, 11.483, 39.433> <-18.883, 9.046, 39.301> <-18.764, 7.229, 39.377> 
		<-19.274, 13.635, 39.498> <-18.962, 11.840, 39.442> <-18.310, 9.258, 39.092> <-18.191, 7.441, 39.168> 
		<-19.364, 13.990, 38.940> <-18.540, 12.371, 38.603> <-18.159, 9.870, 38.337> <-17.976, 8.033, 38.255> 
		<-19.421, 14.074, 38.593> <-18.597, 12.455, 38.257> <-18.126, 10.010, 37.707> <-17.943, 8.173, 37.626> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-19.321, 13.278, 39.489> <-19.360, 12.978, 39.481> <-19.467, 12.916, 38.848> <-19.566, 12.956, 38.565> 
		<-19.009, 11.483, 39.433> <-19.048, 11.183, 39.425> <-18.984, 11.433, 38.793> <-19.082, 11.473, 38.510> 
		<-18.883, 9.046, 39.301> <-19.297, 8.893, 39.452> <-18.851, 9.279, 38.441> <-18.952, 9.399, 38.001> 
		<-18.764, 7.229, 39.377> <-19.178, 7.075, 39.528> <-18.730, 7.725, 38.390> <-18.830, 7.845, 37.950> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-19.566, 12.956, 38.565> <-19.835, 13.064, 37.795> <-20.194, 13.557, 36.852> <-20.499, 13.754, 36.114> 
		<-19.082, 11.473, 38.510> <-19.351, 11.582, 37.740> <-19.588, 11.929, 36.738> <-19.893, 12.126, 36.000> 
		<-18.952, 9.399, 38.001> <-19.063, 9.532, 37.517> <-19.624, 9.679, 36.815> <-19.664, 9.779, 36.313> 
		<-18.830, 7.845, 37.950> <-18.941, 7.977, 37.466> <-19.414, 7.952, 36.871> <-19.453, 8.052, 36.369> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-20.499, 13.754, 36.114> <-20.718, 13.895, 35.585> <-21.217, 14.043, 34.935> <-21.307, 14.081, 34.353> 
		<-19.893, 12.126, 36.000> <-20.111, 12.267, 35.472> <-20.309, 12.515, 34.963> <-20.399, 12.553, 34.382> 
		<-19.664, 9.779, 36.313> <-19.714, 9.907, 35.672> <-19.421, 10.123, 34.950> <-19.449, 10.322, 34.326> 
		<-19.453, 8.052, 36.369> <-19.503, 8.180, 35.728> <-19.090, 8.377, 34.898> <-19.118, 8.576, 34.274> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-21.307, 14.081, 34.353> <-21.461, 14.147, 33.361> <-21.384, 14.131, 32.000> <-21.293, 14.094, 30.999> 
		<-20.399, 12.553, 34.382> <-20.553, 12.619, 33.389> <-20.575, 12.881, 32.084> <-20.485, 12.844, 31.082> 
		<-19.449, 10.322, 34.326> <-19.484, 10.560, 33.578> <-19.915, 10.916, 32.575> <-19.888, 10.954, 31.791> 
		<-19.118, 8.576, 34.274> <-19.152, 8.814, 33.526> <-19.685, 9.445, 32.662> <-19.659, 9.483, 31.878> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-21.293, 14.094, 30.999> <-21.220, 14.064, 30.199> <-21.034, 14.043, 29.119> <-20.765, 13.859, 28.384> 
		<-20.485, 12.844, 31.082> <-20.412, 12.814, 30.283> <-20.164, 12.665, 29.284> <-19.896, 12.481, 28.550> 
		<-19.888, 10.954, 31.791> <-19.861, 10.992, 30.993> <-19.325, 10.663, 30.096> <-19.163, 10.435, 29.348> 
		<-19.659, 9.483, 31.878> <-19.631, 9.522, 31.080> <-19.114, 9.040, 30.147> <-18.951, 8.811, 29.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-20.765, 13.859, 28.384> <-20.594, 13.742, 27.917> <-20.141, 13.325, 27.518> <-19.878, 13.125, 27.127> 
		<-19.896, 12.481, 28.550> <-19.725, 12.364, 28.082> <-19.576, 11.877, 27.642> <-19.314, 11.678, 27.250> 
		<-19.163, 10.435, 29.348> <-19.025, 10.240, 28.712> <-18.899, 9.864, 27.880> <-18.807, 9.629, 27.250> 
		<-18.951, 8.811, 29.399> <-18.813, 8.617, 28.763> <-18.750, 8.313, 27.908> <-18.659, 8.078, 27.278> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-19.878, 13.125, 27.127> <-19.689, 12.981, 26.845> <-19.577, 12.530, 26.196> <-19.264, 12.717, 26.144> 
		<-19.314, 11.678, 27.250> <-19.125, 11.534, 26.969> <-19.213, 10.973, 26.075> <-18.900, 11.160, 26.024> 
		<-18.807, 9.629, 27.250> <-18.740, 9.456, 26.786> <-18.782, 8.639, 25.708> <-18.525, 9.051, 25.829> 
		<-18.659, 8.078, 27.278> <-18.591, 7.905, 26.813> <-18.680, 7.041, 25.630> <-18.424, 7.453, 25.751> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-19.264, 12.717, 26.144> <-18.959, 12.899, 26.093> <-19.095, 13.339, 26.728> <-19.188, 13.537, 27.013> 
		<-18.900, 11.160, 26.024> <-18.594, 11.342, 25.973> <-18.513, 11.872, 26.835> <-18.606, 12.070, 27.120> 
		<-18.525, 9.051, 25.829> <-18.246, 9.501, 25.962> <-18.562, 9.687, 26.812> <-18.614, 9.897, 27.313> 
		<-18.424, 7.453, 25.751> <-18.144, 7.902, 25.884> <-18.457, 8.109, 26.847> <-18.509, 8.319, 27.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-19.188, 13.537, 27.013> <-19.387, 13.955, 27.617> <-19.990, 14.599, 28.299> <-20.209, 14.710, 29.020> 
		<-18.606, 12.070, 27.120> <-18.805, 12.489, 27.724> <-19.080, 13.051, 28.409> <-19.300, 13.161, 29.130> 
		<-18.614, 9.897, 27.313> <-18.669, 10.119, 27.844> <-18.925, 10.553, 28.641> <-19.005, 10.672, 29.202> 
		<-18.509, 8.319, 27.349> <-18.565, 8.541, 27.880> <-18.700, 8.768, 28.612> <-18.781, 8.886, 29.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-20.209, 14.710, 29.020> <-20.457, 14.835, 29.832> <-20.678, 14.357, 30.957> <-20.651, 14.274, 31.810> 
		<-19.300, 13.161, 29.130> <-19.547, 13.286, 29.941> <-19.847, 13.024, 31.012> <-19.820, 12.941, 31.865> 
		<-19.005, 10.672, 29.202> <-19.116, 10.836, 29.979> <-19.337, 10.769, 31.012> <-19.374, 10.812, 31.812> 
		<-18.781, 8.886, 29.173> <-18.892, 9.050, 29.950> <-19.108, 9.214, 30.996> <-19.145, 9.257, 31.796> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-20.651, 14.274, 31.810> <-20.629, 14.206, 32.507> <-20.176, 14.242, 33.378> <-20.051, 14.218, 34.068> 
		<-19.820, 12.941, 31.865> <-19.798, 12.873, 32.563> <-19.383, 12.903, 33.307> <-19.257, 12.879, 33.996> 
		<-19.374, 10.812, 31.812> <-19.403, 10.845, 32.428> <-19.316, 10.863, 33.302> <-19.219, 10.679, 33.883> 
		<-19.145, 9.257, 31.796> <-19.174, 9.290, 32.412> <-19.096, 9.322, 33.264> <-19.000, 9.137, 33.845> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-20.051, 14.218, 34.068> <-19.946, 14.197, 34.646> <-19.967, 14.143, 35.437> <-19.886, 14.125, 36.019> 
		<-19.257, 12.879, 33.996> <-19.152, 12.858, 34.575> <-19.123, 12.509, 35.194> <-19.042, 12.491, 35.776> 
		<-19.219, 10.679, 33.883> <-19.132, 10.510, 34.413> <-18.914, 10.100, 34.814> <-18.767, 9.966, 35.340> 
		<-19.000, 9.137, 33.845> <-18.912, 8.968, 34.375> <-18.702, 8.258, 34.834> <-18.555, 8.123, 35.361> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-19.886, 14.125, 36.019> <-19.778, 14.100, 36.796> <-19.543, 14.258, 37.840> <-19.421, 14.074, 38.593> 
		<-19.042, 12.491, 35.776> <-18.934, 12.466, 36.553> <-18.719, 12.639, 37.504> <-18.597, 12.455, 38.257> 
		<-18.767, 9.966, 35.340> <-18.582, 9.798, 35.999> <-18.090, 10.163, 37.021> <-18.126, 10.010, 37.707> 
		<-18.555, 8.123, 35.361> <-18.371, 7.956, 36.020> <-17.907, 8.326, 36.940> <-17.943, 8.173, 37.626> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.199, -3.840, 40.203> <-17.547, -3.510, 39.984> <-17.748, -3.332, 38.542> <-17.714, -3.043, 37.837> 
		<-18.369, -0.519, 39.955> <-17.716, -0.189, 39.736> <-17.816, 0.033, 38.479> <-17.783, 0.322, 37.774> 
		<-18.546, 3.905, 39.516> <-17.973, 4.117, 39.306> <-17.642, 4.687, 38.107> <-17.609, 4.827, 37.478> 
		<-18.764, 7.229, 39.377> <-18.191, 7.441, 39.168> <-17.976, 8.033, 38.255> <-17.943, 8.173, 37.626> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.199, -3.840, 40.203> <-18.369, -0.519, 39.955> <-18.546, 3.905, 39.516> <-18.764, 7.229, 39.377> 
		<-18.772, -4.129, 40.395> <-18.941, -0.809, 40.147> <-18.960, 3.751, 39.667> <-19.178, 7.075, 39.528> 
		<-18.262, -3.485, 38.682> <-18.424, -0.132, 38.658> <-18.467, 4.379, 38.280> <-18.730, 7.725, 38.390> 
		<-18.289, -3.334, 38.030> <-18.451, 0.020, 38.006> <-18.568, 4.499, 37.840> <-18.830, 7.845, 37.950> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.289, -3.334, 38.030> <-18.451, 0.020, 38.006> <-18.568, 4.499, 37.840> <-18.830, 7.845, 37.950> 
		<-18.356, -3.088, 37.614> <-18.519, 0.265, 37.590> <-18.679, 4.632, 37.356> <-18.941, 7.977, 37.466> 
		<-18.513, -2.688, 37.100> <-18.794, 0.482, 37.017> <-19.028, 4.793, 36.974> <-19.414, 7.952, 36.871> 
		<-18.514, -2.516, 36.644> <-18.795, 0.654, 36.561> <-19.068, 4.893, 36.472> <-19.453, 8.052, 36.369> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.514, -2.516, 36.644> <-18.795, 0.654, 36.561> <-19.068, 4.893, 36.472> <-19.453, 8.052, 36.369> 
		<-18.515, -2.213, 35.838> <-18.797, 0.958, 35.755> <-19.118, 5.021, 35.831> <-19.503, 8.180, 35.728> 
		<-18.248, -1.877, 34.733> <-18.494, 1.227, 34.851> <-18.509, 5.318, 34.807> <-19.090, 8.377, 34.898> 
		<-18.299, -1.769, 33.880> <-18.544, 1.334, 33.998> <-18.537, 5.517, 34.183> <-19.118, 8.576, 34.274> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.299, -1.769, 33.880> <-18.544, 1.334, 33.998> <-18.537, 5.517, 34.183> <-19.118, 8.576, 34.274> 
		<-18.334, -1.694, 33.284> <-18.580, 1.409, 33.402> <-18.572, 5.755, 33.435> <-19.152, 8.814, 33.526> 
		<-18.742, -1.910, 32.542> <-19.002, 1.512, 32.522> <-19.157, 6.060, 32.861> <-19.685, 9.445, 32.662> 
		<-18.792, -1.923, 31.942> <-19.052, 1.499, 31.923> <-19.130, 6.098, 32.077> <-19.659, 9.483, 31.878> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.792, -1.923, 31.942> <-19.052, 1.499, 31.923> <-19.130, 6.098, 32.077> <-19.659, 9.483, 31.878> 
		<-18.868, -1.943, 31.025> <-19.128, 1.479, 31.005> <-19.103, 6.137, 31.279> <-19.631, 9.522, 31.080> 
		<-18.812, -1.592, 29.743> <-18.883, 1.615, 29.901> <-18.700, 5.857, 30.246> <-19.114, 9.040, 30.147> 
		<-18.716, -1.879, 28.874> <-18.787, 1.328, 29.031> <-18.537, 5.628, 29.497> <-18.951, 8.811, 29.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.716, -1.879, 28.874> <-18.787, 1.328, 29.031> <-18.537, 5.628, 29.497> <-18.951, 8.811, 29.399> 
		<-18.649, -2.080, 28.263> <-18.719, 1.127, 28.421> <-18.399, 5.434, 28.862> <-18.813, 8.617, 28.763> 
		<-18.373, -3.052, 27.952> <-18.483, 0.396, 27.908> <-18.421, 4.880, 27.969> <-18.750, 8.313, 27.908> 
		<-18.293, -3.414, 27.423> <-18.403, 0.034, 27.379> <-18.330, 4.645, 27.339> <-18.659, 8.078, 27.278> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.293, -3.414, 27.423> <-18.403, 0.034, 27.379> <-18.330, 4.645, 27.339> <-18.659, 8.078, 27.278> 
		<-18.208, -3.800, 26.859> <-18.318, -0.352, 26.815> <-18.262, 4.472, 26.875> <-18.591, 7.905, 26.813> 
		<-18.423, -4.956, 25.363> <-18.497, -1.426, 25.495> <-18.455, 3.519, 25.458> <-18.680, 7.041, 25.630> 
		<-18.178, -4.314, 25.314> <-18.251, -0.784, 25.445> <-18.199, 3.931, 25.579> <-18.424, 7.453, 25.751> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.178, -4.314, 25.314> <-18.251, -0.784, 25.445> <-18.199, 3.931, 25.579> <-18.424, 7.453, 25.751> 
		<-17.910, -3.614, 25.260> <-17.984, -0.084, 25.391> <-17.919, 4.380, 25.712> <-18.144, 7.902, 25.884> 
		<-18.122, -3.325, 26.762> <-18.238, 0.007, 26.288> <-18.234, 4.749, 26.923> <-18.457, 8.109, 26.847> 
		<-18.097, -2.902, 27.383> <-18.213, 0.431, 26.909> <-18.286, 4.959, 27.424> <-18.509, 8.319, 27.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.165, -1.569, 28.756> <-18.138, -1.732, 28.206> <-18.078, -3.470, 27.464> <-18.097, -2.902, 27.383> 
		<-18.350, 1.568, 28.881> <-18.323, 1.405, 28.331> <-18.194, -0.137, 26.989> <-18.213, 0.431, 26.909> 
		<-18.389, 5.767, 29.122> <-18.309, 5.648, 28.561> <-18.342, 5.181, 27.956> <-18.286, 4.959, 27.424> 
		<-18.781, 8.886, 29.173> <-18.700, 8.768, 28.612> <-18.565, 8.541, 27.880> <-18.509, 8.319, 27.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.165, -1.569, 28.756> <-18.350, 1.568, 28.881> <-18.389, 5.767, 29.122> <-18.781, 8.886, 29.173> 
		<-18.206, -1.323, 29.587> <-18.390, 1.813, 29.712> <-18.500, 5.931, 29.900> <-18.892, 9.050, 29.950> 
		<-18.370, -1.643, 30.777> <-18.622, 1.626, 30.823> <-18.630, 5.970, 30.961> <-19.108, 9.214, 30.996> 
		<-18.307, -1.641, 31.642> <-18.558, 1.628, 31.688> <-18.667, 6.013, 31.762> <-19.145, 9.257, 31.796> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.307, -1.641, 31.642> <-18.558, 1.628, 31.688> <-18.667, 6.013, 31.762> <-19.145, 9.257, 31.796> 
		<-18.260, -1.639, 32.270> <-18.512, 1.630, 32.316> <-18.696, 6.046, 32.377> <-19.174, 9.290, 32.412> 
		<-17.843, -1.478, 33.055> <-18.202, 1.730, 33.105> <-18.640, 6.127, 33.185> <-19.096, 9.322, 33.264> 
		<-17.802, -1.555, 33.678> <-18.161, 1.653, 33.729> <-18.544, 5.942, 33.766> <-19.000, 9.137, 33.845> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-17.802, -1.555, 33.678> <-18.161, 1.653, 33.729> <-18.544, 5.942, 33.766> <-19.000, 9.137, 33.845> 
		<-17.751, -1.651, 34.455> <-18.111, 1.557, 34.505> <-18.456, 5.774, 34.296> <-18.912, 8.968, 34.375> 
		<-18.024, -1.940, 35.464> <-18.188, 1.158, 35.212> <-18.347, 5.165, 34.869> <-18.702, 8.258, 34.834> 
		<-18.009, -2.204, 36.202> <-18.173, 0.894, 35.950> <-18.199, 5.031, 35.396> <-18.555, 8.123, 35.361> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-18.009, -2.204, 36.202> <-18.173, 0.894, 35.950> <-18.199, 5.031, 35.396> <-18.555, 8.123, 35.361> 
		<-17.998, -2.392, 36.728> <-18.162, 0.706, 36.475> <-18.015, 4.863, 36.054> <-18.371, 7.956, 36.020> 
		<-17.690, -2.832, 37.321> <-17.758, 0.533, 37.257> <-17.573, 4.980, 36.792> <-17.907, 8.326, 36.940> 
		<-17.714, -3.043, 37.837> <-17.783, 0.322, 37.774> <-17.609, 4.827, 37.478> <-17.943, 8.173, 37.626> 
	}

	texture { txFall }
	interior { ior 1.33 }
}
