
#include "colors.inc"	// Standard Color definitions
#include "woods.inc"	// Standard Texture definitions
#include "skies.inc"
#include "glass.inc"
//Note not all textures, pigments,etc. in this file were used in the file regarden.pov and there
// is the possibility that some textures pigments etc. used in the file regarden.pov are not here
//
#declare Blue_Sky_Map =color_map {    [0.0, 0.5 color rgb <0.25, 0.25, 0.5>
              color rgb <0.25, 0.25, 0.5>]
    [0.5, 0.6 color rgb <0.25, 0.25, 0.5>
              color rgb <0.7, 0.7, 0.7>]    [0.6, 1.0 color rgb <0.7, 0.7, 0.7>
              color rgb <0.3, 0.3, 0.3>]}
#declare Water = texture {
  pigment {
    color rgbf <0.9, 0.9, 1.0, 0.6>
  }
  normal { bumps 0.4 }
  finish {
    reflection 0.4
    refraction 0.5
    ior 1.33
    phong 1.0
    phong_size 100
  }
  scale <0.2,0.2,0.2>
}

#declare Quiet_Water = texture {
  pigment {
    color rgb <0.0, 0.0,0.3>
  }
  normal { bumps 0.04 }
  finish {
    reflection 0.4
    refraction 0.5
    ior 1.33
    phong 1.0
    phong_size 100
  }
  scale <0.2,0.2,0.2>
}
 #declare Navy_Plastic = texture {
  pigment { color rgb <0.137255, 0.137255, 0.556863> }  finish { phong 1.0 }}

#declare Yellowt = texture {  pigment { color rgb <1, 1, 0> }}

#declare Yellow_Plastic = texture {  pigment { color rgb <1, 1, 0> }
  finish { phong 1.0 }}
  
  #declare Orange_Plastic = texture {  pigment { color rgb <1, 0.5, 0.0> }
  finish { phong 1.0 }}

// Basic Blue Sky w/ clouds.
#declare Blue_Sky = pigment {    bozo
    color_map { Blue_Sky_Map }    turbulence 0.3}
// Bright Blue Sky w/ very white clouds. 
#declare Bright_Blue_Sky = pigment {
    bozo    turbulence 0.56    color_map {
        [0.0, 0.5 color rgb <0.5, 0.5, 1.0>
                  color rgb <0.5, 0.5, 1.0>]
        [0.5, 0.6 color rgb <0.5, 0.5, 1.0>
                  color rgb <1.0, 1.0, 1.0>]
        [0.6, 1.0 color rgb <1.0, 1.0, 1.0>
                  color rgb <0.5, 0.5, 0.5>]    }}// Another sky
#declare Blue_Sky2 =pigment {    agate    color_map {
        [0.0, 0.3 color rgb <0.0, 0.0, 1.0> 
                  color rgb <0.0, 0.0, 1.0>]
        [0.3, 1.0 color rgb <0.0, 0.0, 1.0> 
                  color rgb <1.0, 1.0, 1.0>]    }    scale .75}
// Small puffs of white clouds
#declare Blue_Sky3 = pigment {    granite
    turbulence 0.1    color_map {        [0.0, 0.3 color rgb <0.0, 0.0, 1.0> 
                  color rgb <0.0, 0.0, 1.0>]
        [0.3, 1.0 color rgb <0.0, 0.0, 1.0> 
                  color rgb <1.0, 1.0, 1.0>]    }    scale .75}

#declare White_RPlastic = texture {  pigment { color rgb <1, 1, 1,> }
  finish { phong 1.0 reflection 0.4 }}
  #declare White_Plastic = texture {  pigment { color rgb <1, 1, 1,> }
  finish { phong 1.0 }}
  
  #declare Red_Plastic = texture {  pigment { color rgb <1,0,0> }
  finish { phong 1.0 }}
#declare Crystal = texture {  pigment { color rgbf <0.98, 0.98, 0.98, 0.9> }
  finish {    ambient 0.1    diffuse 0.1    specular 0.8    reflection 0.1
    refraction 0.9    ior 1.45    roughness 0.0003    phong 1    phong_size 400
  }}
  
  #declare Blue_Plastic = texture {  pigment { color rgb <0, 0, 1> }
  finish { phong 1.0 }}
  
  #declare Bright_Sky_2 = texture {  pigment {    bozo    turbulence 0.56
    color_map {       [0.0 0.5 color rgb <0.5, 0.5, 1.0>
                color rgb <0.5, 0.5, 1.0>]
       [0.5 0.6 color rgb <0.5, 0.5, 1.0>
                color rgb <1.0, 1.0, 1.0>]
       [0.6 1.0 color rgb <1.0, 1.0, 1.0>
                color rgb <0.5, 0.5, 0.5>]    }  }  finish {ambient 0.4}}
                
                
  #declare Green_Plastic = texture {  pigment { color rgb <0, 1, 0> }
  finish { phong 1.0 }}                                             
  
  #declare Black_Plastic = texture {pigment{color rgb <1,1,1>}
  finish {phong 1.0}}
   
   #declare Green_Plastic = texture {pigment{color rgb <0,1,0>}
  finish {phong 1.0}}
   
  #declare Grass = texture {  pigment {    granite    turbulence 0.7
    color_map {      [0.00 0.07 color rgbf <0.7743, 0.3353, 0.5701, 0.98>
                 color rgbf <0.5210, 0.1044, 0.0333, 0.45>]
      [0.07 0.13 color rgbf <0.5210, 0.1044, 0.0333, 0.45>
                 color rgbf <0.3663, 0.5682, 0.0687, 0.82>]
      [0.13 0.31 color rgbf <0.3663, 0.5682, 0.0687, 0.82>
                 color rgbf <0.0887, 0.9886, 0.4438, 0.01>]
      [0.31 0.39 color rgbf <0.0887, 0.9886, 0.4438, 0.01>
                 color rgbf <0.1308, 0.9083, 0.5524, 0.74>]
      [0.39 0.55 color rgbf <0.1308, 0.9083, 0.5524, 0.74>
                 color rgbf <0.4840, 0.3945, 0.7343, 0.69>]
      [0.55 1.00 color rgbf <0.4840, 0.3945, 0.7343, 0.69>
                 color rgbf <0.1755, 0.5095, 0.4480, 0.43>]    }  }
  finish {phong 0.66 phong_size 81}  scale <0.98 0.87 0.81>}


  #declare Wood1 = texture {  /* Bottom wood-grain layer */    pigment {
        wood        turbulence 0.05        colour_map {
            [0.00 0.34  color rgb <0.58, 0.45, 0.23>
                        color rgb <0.65, 0.45, 0.25>]
            [0.34 0.40  color rgb <0.65, 0.45, 0.25>
                        color rgb <0.33, 0.23, 0.13>]
            [0.40 0.47  color rgb <0.33, 0.23, 0.13>
                        color rgb <0.60, 0.40, 0.20>]
            [0.47 1.00  color rgb <0.60, 0.40, 0.20>
                        color rgb <0.25, 0.15, 0.05>]        }    }    finish {
        crand 0.02        ambient 0.32        diffuse 0.63        phong 0.2
        phong_size 10    }    normal { bumps 0.05 }}
texture {     /* top layer, adds small dark spots */    pigment {        bozo
        color_map {            [0.0 0.8 color rgbf <1.00, 1.00, 1.00, 1.00>
                     color rgbf <1.00, 0.90, 0.80, 0.80>]
            [0.8 1.0 color rgbf <1.00, 0.90, 0.80, 0.80>
                     color rgbf <0.30, 0.20, 0.10, 0.40>]        }    scale 0.25
    }}

#declare Henna_Wood = texture {  pigment {    wood    turbulence 0.2  }
  finish {phong 0.3 ambient 0.4}  scale <0.4 14 0.4>  rotate <0 45 0>}

#declare DMFWood4 =pigment {    wood    turbulence 0.04    octaves 3
    scale <0.05, .05, 1>    color_map {
        [0.0, 0.1 color rgb <0.888, 0.600, 0.3>
                  color rgb <0.888, 0.600, 0.3>]
        [0.1, 0.9 color rgb <0.888, 0.600, 0.3>
                  color rgb <0.600, 0.400, 0.2>]
        [0.9, 1.0 color rgb <0.600, 0.400, 0.2>
                  color rgb <0.600, 0.400, 0.2>]    }}
#declare SandstP = texture {  pigment {    granite    turbulence 0.70
    color_map {      [0.00 color rgb <0.86, 0.82, 0.67>]
      [0.50 color rgb <0.91, 0.87, 0.71>]
      [1.00 color rgb <0.86, 0.84, 0.59>]    }  }  normal {    bumps 0.10
    scale <0.20, 0.20, 0.20>  }  finish {    ambient 0.50    diffuse 1.00
    specular 0.50    roughness 0.01    metallic    reflection 0.11
    crand 0.250  }}texture {  pigment {    colour rgbf <1.00, 1.00, 1.00, 1.00>
  }  //finish {    ambient 0.50    brilliance 1.50    phong 0.90    phong_size 80
  }//}
  
  #declare Brown_Brick = texture {    pigment {
        color rgb < 0.000, 0.000, 0.000 >    }}texture {    pigment {
        granite        color_map {
            [ 0.000 rgbf < 0.027, 0.012, 0.012, 0.000 > ]
            [ 0.034 rgbf < 0.851, 0.812, 0.741, 0.235 > ]
            [ 0.034 rgbf < 0.851, 0.812, 0.741, 0.235 > ]
            [ 0.342 rgbf < 0.792, 0.694, 0.690, 0.839 > ]
            [ 0.342 rgbf < 0.792, 0.694, 0.690, 0.839 > ]
            [ 0.462 rgbf < 0.631, 0.506, 0.471, 0.608 > ]
            [ 0.462 rgbf < 0.631, 0.506, 0.471, 0.608 > ]
            [ 0.632 rgbf < 0.851, 0.812, 0.741, 0.922 > ]
            [ 0.632 rgbf < 0.851, 0.812, 0.741, 0.922 > ]
            [ 0.983 rgbf < 0.647, 0.655, 0.655, 0.282 > ]
            [ 0.983 rgbf < 0.647, 0.655, 0.655, 0.282 > ]
            [ 1.001 rgbf < 0.027, 0.012, 0.012, 0.000 > ]        }
        turbulence < 0.600, 0.600, 0.600 >    }
    rotate < 0.000, 0.000, 50.000 >    scale < 3.000, 6.000, 2.000 >}texture {
    pigment {        granite        color_map {
            [ 0.000 rgbf < 0.831, 0.631, 0.569, 0.447 > ]
            [ 0.153 rgbf < 0.925, 0.831, 0.714, 0.678 > ]
            [ 0.153 rgbf < 0.925, 0.831, 0.714, 0.678 > ]
            [ 0.297 rgbf < 0.871, 0.702, 0.659, 0.475 > ]
            [ 0.297 rgbf < 0.871, 0.702, 0.659, 0.475 > ]
            [ 0.441 rgbf < 0.831, 0.631, 0.569, 0.918 > ]
            [ 0.441 rgbf < 0.831, 0.631, 0.569, 0.918 > ]
            [ 0.763 rgbf < 0.937, 0.882, 0.820, 0.655 > ]
            [ 0.763 rgbf < 0.937, 0.882, 0.820, 0.655 > ]
            [ 1.001 rgbf < 0.831, 0.631, 0.569, 0.447 > ]        }
        turbulence < 0.600, 0.600, 0.600 >    }    finish {        phong 1.0
        phong_size 90    }    rotate < 0.000, 0.000, -50.000 >
    scale < 1.000, 2.000, 1.000 >}
// End of file
// A texture for the roof tiles.

// I grew up in a house with hand-made glass windows. They had all these great
// optical effects, bubbles, and distortions. That's what this is supposed to
// simulate.
#declare OldGlass = texture {    pigment {      bozo
      turbulence 0.15      color_map 
       {[0.0, 0.5   color red 1 green 1 blue 1 filter 0.95
                 color red 1 green 1 blue 1 filter 0.9]
        [0.5, 1.001 color red 1  green 1  blue 1 filter 0.9
                 color red .9  green .9  blue .9 filter 1]       }    }
    finish      {ambient 0      diffuse 0      reflection 0.5
      refraction 0.85      ior 1.5      phong 0.3      phong_size 60     }}
 #declare S_Glass2 = texture {  pigment { color rgbf < 0.92, 0.95, 0.96, 0.98 > }
  finish {     ambient 0.24     diffuse 0.21     reflection 0.15
     refraction 0.88     ior 1.3     specular 0.7          roughness 0.005
     phong .4 phong_size 150  }}
#declare bird =blob {
   threshold .65
   sphere{    <-1,-1,0>, .50,1    texture {Yellow_Plastic}  }
   sphere{    <-1.45,-1,0>, .50,1    texture {Yellow_Plastic}  } 
   
   cylinder {    <-1,-.6,0>           <-.7,-.6,0>, .1,1       texture {Orange_Plastic}rotate<0,0,0>  }   
  
  sphere{    <-1,-.6,0>, .3,1    texture {Yellow_Plastic}  }
  sphere{    <-1,-.63,-.3>, .16,1    texture {White_Plastic}  } 
  
  sphere{    <-1,-.65,-.41>, .02,1    texture{Black_Plastic}  }
  
  sphere{    <-1,-.63,.3>, .16,1    texture {White_Plastic}  } 
  
  sphere{    <-1,-.65,.41>, .02,1    texture{Black_Plastic}  }  
  }
 #declare Crystal_1 = texture {  pigment { color rgbf <0.999, 0.999, 0.999, 0.919> }
  finish {    ambient 0.1    diffuse 0.1    specular 0.8    reflection 0.1
    refraction 1.9    ior 1.45    roughness 0.0003    phong 1    phong_size 400
  }}    
  //rgb <1, 1, 0>
   #declare YellowCrystal = texture {  pigment { color  rgb <1, 1, 0> }
  finish {    ambient 0.1    diffuse 0.1    specular 0.8    reflection 0.1
    refraction 0.9    ior 1.45    roughness 0.0003    phong 1    phong_size 400
  }}    
  
  #declare Cane = 
texture{ pigment {
    gradient x+z+y-x+y+z
    color_map {
        [0.0 rgb <1,0,0>]
        [0.0 rgb <1,1,1>]
        [0.50 rgb <1,1,1>]
        [0.50 rgb <1,0,0>]
        
        
        [0.0 rgb <1,0,0>]
        [0.0 rgb <1,1,1>]
        [0.50 rgb <1,1,1>]
        [0.50 rgb <1,0,0>]
        
        
    }
}       }

//#declare voltorb=texture{ pigment{image_map {gif "voltroll.gif"   }    }}

#declare Bumble = texture {
  pigment {
    gradient <1 0 0>
    color_map {
      [0 .5 color rgb <0, 0, 0> color rgb <0, 0, 0>]
      [.5 1 color rgb <.9, .56, .1> color rgb <.9, .56, .1>]
    }
  }
  finish {
    ambient .1
    phong 1
    phong_size 70
  }
  translate <0 0 0>
  rotate <0 0 10>
}
#declare Mountains = texture {
  pigment {
    bozo
    turbulence 0.5
    color_map {
      [0.00 0.29 color rgb <0.79, 0.71, 0.66>
                 color rgb <0.83, 0.69, 0.62>]
      [0.29 0.31 color rgb <0.83, 0.69, 0.62>
                 color rgb <0.76, 0.66, 0.61>]
      [0.31 0.43 color rgb <0.76, 0.66, 0.61>
                 color rgb <0.88, 0.76, 0.73>]
      [0.43 0.64 color rgb <0.88, 0.76, 0.73>
                 color rgb <0.70, 0.60, 0.55>]
      [0.64 0.69 color rgb <0.70, 0.60, 0.55>
                 color rgb <0.87, 0.71, 0.66>]
      [0.69 1.00 color rgb <0.87, 0.71, 0.66>
                 color rgb <0.79, 0.71, 0.66>]
    }
  }
  normal {bumps 0.5 scale <1,0.2,1>}
}
texture {
  pigment {
    marble
    turbulence 1.0
    color_map {
      [0.00 0.20 color rgbf <0.79, 0.71, 0.66, 0.5>
                 color rgbf <0.53, 0.39, 0.32, 0.5>]
      [0.20 0.40 color rgbf <0.53, 0.39, 0.32, 0.5>
                 color rgbf <0.76, 0.66, 0.61, 0.5>]
      [0.40 0.60 color rgbf <0.76, 0.66, 0.61, 0.5>
                 color rgbf <0.88, 0.76, 0.73, 0.5>]
      [0.60 0.80 color rgbf <0.88, 0.76, 0.73, 0.5>
                 color rgbf <0.50, 0.40, 0.25, 0.5>]
      [0.80 1.00 color rgbf <0.50, 0.40, 0.25, 0.5>
                 color rgbf <0.79, 0.71, 0.66, 0.5>]
    }
  }
  finish {ambient 0.02}
  normal {wrinkles 0.9}
  scale <0.1,0.5,0.5>
  rotate <0,0,90>
}
#declare SwimBrick = texture {
  brick texture {
      pigment { color rgb <0.9,0.9,1.0> }
    },
    texture {
      pigment { color rgb <1.0,1.0,1.0> }
      finish { reflection 0.2 phong 1.0 phong_size 90 }
    }
  brick_size 0.15
  mortar 0.01
  scale <1,1.4,1>
}
#declare Swimbrick = texture {
  brick texture {
      pigment { color rgb <0.9,0.9,1.0> }
    },
    texture {
      pigment { color rgb <1.0,1.0,1.0> }
      finish { reflection 0.2 phong 1.0 phong_size 90 }
    }
  brick_size 0.15
  mortar 0.01
  scale <1,1.4,1>
}
//#declare Log=texture{ pigment{image_map {gif "log.gif"   }    }}

#declare Cork =
texture {
    pigment {
        granite
        color_map {
            [0.00, 0.60 color rgb <0.93, 0.71, 0.532>
                        color rgb <0.98, 0.81, 0.60>]
            [0.60, 0.65 color rgb <0.50, 0.30, 0.20>
                        color rgb <0.50, 0.30, 0.20>]
            [0.65, 1.00 color rgb <0.80, 0.53, 0.46>
                        color rgb <0.85, 0.75, 0.35>]
        }
    }
    finish{ 
        specular 0.1 
        roughness 0.5 
    }
    scale 0.25     // Generally looks best scaled longer on one axis
}

#declare mmred = 
blob{
sphere{<0,0,0>.025,10}
sphere{<.01,0,.01>.02,10}
sphere{<-.01,0,-.01>.02,10}
sphere{<-.01,0,.01>.02,10}
sphere{<.01,0,-.01>.02,10}

sphere{<.012,0,0>.02,10}
sphere{<0,0,-.012>.02,10}
sphere{<0,0,.012>.02,10}
sphere{<-.012,0,0>.02,10}

texture{pigment{color Red}} 
scale<1.3,0,1.3>
} 
 #declare mmblue = 
blob{
sphere{<0,0,0>.025,10}
sphere{<.01,0,.01>.02,10}
sphere{<-.01,0,-.01>.02,10}
sphere{<-.01,0,.01>.02,10}
sphere{<.01,0,-.01>.02,10}

sphere{<.012,0,0>.02,10}
sphere{<0,0,-.012>.02,10}
sphere{<0,0,.012>.02,10}
sphere{<-.012,0,0>.02,10}

texture{pigment{color Blue}} 
scale<1.3,0,1.3>
}

#declare mmyellow = 
blob{
sphere{<0,0,0>.025,10}
sphere{<.01,0,.01>.02,10}
sphere{<-.01,0,-.01>.02,10}
sphere{<-.01,0,.01>.02,10}
sphere{<.01,0,-.01>.02,10}

sphere{<.012,0,0>.02,10}
sphere{<0,0,-.012>.02,10}
sphere{<0,0,.012>.02,10}
sphere{<-.012,0,0>.02,10}

texture{pigment{color Yellow}} 
scale<1.3,0,1.3>
}
 #declare mmgreen = 
blob{
sphere{<0,0,0>.025,10}
sphere{<.01,0,.01>.02,10}
sphere{<-.01,0,-.01>.02,10}
sphere{<-.01,0,.01>.02,10}
sphere{<.01,0,-.01>.02,10}

sphere{<.012,0,0>.02,10}
sphere{<0,0,-.012>.02,10}
sphere{<0,0,.012>.02,10}
sphere{<-.012,0,0>.02,10}

texture{pigment{color Green}} 
scale<1.3,0,1.3>
}

#declare GreyBrick = texture {
  brick texture {
      pigment {color red 0.752941 green 0.752941 blue 0.752941 } //
    },
    texture {
      pigment { color rgb <1.0,1.0,1.0> }
      finish { reflection 0.2 phong 1.0 phong_size 90 }
    }
  brick_size 0.15
  mortar 0.01
  scale <1,1.4,1>
}


    declare Car=union{
     mesh{




triangle{<3,  -5, 0>   < 3,  0,  0>           < 0,  0,  0>   texture {Red_Plastic}}//front
triangle{<3,  -5, 0>   < 0,  -5, 0>           < 0,  0,  0>   texture {Red_Plastic}}//front
triangle{<10,  -5, 0>   < 10,  0, 0>          < 6,  0,  0>   texture {Red_Plastic}}//front
triangle{<10,  -5, 0>   < 6,  -5, 0>          < 6,  0,  0>   texture {Red_Plastic}}//front
triangle{<3,  -0, -0>   < 3,  -1.5, 0>    < 6,  -1.5,  -0>   texture {Red_Plastic}}//bit above front door
triangle{<3,  -0, -0>   < 6,  -1.5, 0>    < 6,  -0,    -0>   texture {Red_Plastic}}//bit above front door
triangle{<3,  -5, -0>   < 3,  -1.5, 0>    < 6,  -1.5,  -0> texture   {Red_Plastic}}//front door
triangle{<3,  -5, -0>   < 6,  -1.5, 0>    < 6,  -5,    -0> texture   {Red_Plastic}}//front door
triangle{<10,  -5, 10>   < 10,  0, 10>       < 0,  0,  10>   texture {Red_Plastic}}//Back
triangle{<10,  -5, 10>   < 0,  -5, 10>       < 0,  0,  10>   texture {Red_Plastic}}//Back

triangle{<10,  -5, 0>   <10,  0, 0>     <10,  0,  3 >   texture {Red_Plastic}}//side
triangle{<10,  -5, 0>   <10,  0, 3>     <10,  -5,  3>   texture {Red_Plastic}}//side
triangle{<10,  -5, 6>   <10,  0, 6>     <10,  0,  10>   texture {Red_Plastic}}//side
triangle{<10,  -5, 6>   <10,  0, 10>    <10,  -5, 10>   texture {Red_Plastic}}//side                                                                        
triangle{<10,  -1, 3>   <10,  0, 3>     <10,  0,  6 >   texture {Red_Plastic}}//side
triangle{<10,  -1, 3>   <10,  0, 6>     <10,  -1,  6>   texture {Red_Plastic}}//side
triangle{<10,  -5, 3>   <10,  -3, 3>    <10,  -3,  6>   texture {Red_Plastic}}//side
triangle{<10,  -5, 3>   <10,  -3, 6>    <10,  -5,  6>   texture {Red_Plastic}}//side
triangle{<10,  -4, 3>   <10,  -1, 3>    <10,  -1,  6>   texture {White_Plastic}}//Windowpain
triangle{<10,  -4, 3>   <10,  -1, 6>    <10,  -4,  6>   texture {White_Plastic}}//windowpane
 
 
 
 
 
 
 
triangle{<0,  -5, 0>   < 0,  0, 0>     < 0,  0,  3 >   texture {Red_Plastic}}//side
triangle{<0,  -5, 0>   < 0,  0, 3>     < 0,  -5,  3>   texture {Red_Plastic}}//side
triangle{<0,  -5, 6>   < 0,  0, 6>     < 0,  0,  10>   texture {Red_Plastic}}//side
triangle{<0,  -5, 6>   < 0,  0, 10>    < 0,  -5, 10>   texture {Red_Plastic}}//side                                                                        
triangle{<0,  -1, 3>   < 0,  0, 3>     < 0,  0,  6 >   texture {Red_Plastic}}//side
triangle{<0,  -1, 3>   < 0,  0, 6>     < 0,  -1,  6>   texture {Red_Plastic}}//side
triangle{<0,  -5, 3>   < 0,  -3, 3>    < 0,  -3,  6>   texture {Red_Plastic}}//side
triangle{<0,  -5, 3>   < 0,  -3, 6>    < 0,  -5,  6>   texture {Red_Plastic}}//side
triangle{<0,  -4, 3>   < 0,  -1, 3>    < 0,  -1,  6>   texture {White_Plastic}}//Windowpain
triangle{<0,  -4, 3>   < 0,  -1, 6>    < 0,  -4,  6>   texture {White_Plastic}}//windowpane






                                                                        
                                                                        
triangle{<10,  3, 0>   <0,  3, 0>      < 0,  3,  10>   texture {White_Plastic}}//floor
triangle{<10,  3, 0>   <0,  3, 10>      < 10, 3,  10>   texture {White_Plastic}}//floor

triangle{<10,  -5, 0>   <0,  -5, 0>      < 0,  -5,  10>   texture {White_Plastic}}//floor
triangle{<10,  -5, 0>   <0,  -5, 10>      < 10, -5,  10>   texture {White_Plastic}}//floor                                                                                       
                                                                                       
 

  
       }

cylinder{<10,  -5, 0><10,3,0>,.3 texture{White_Plastic}translate<.3,-.3,0>}
cylinder{<0,  -5, 10><0,3,10>,.3 texture{White_Plastic}translate<-.3,.3,0>}
cylinder{<10,  -5, 10><10,3,10>,.3 texture{White_Plastic}translate<.3,.3,0>}
cylinder{<0,  -5, 0><0,3,0>,.3 texture{White_Plastic}translate<-.3,-.3,0>}

rotate <0,180,0> scale<.07,.07,.07> scale<1,1.5,1>
      
       }
       
declare train=object{
union{
difference{
sphere{<0,0,0,>,1 texture{ White_Plastic} scale<.9,.5,1> hollow}

cylinder{<-10,0,0>,<-0,0,0>,10}                      
cylinder{<0.5,5,0>,<0.5,.2,0>.1 texture{Black_Plastic}}
cylinder{<0.6,5,0>,<0.6,.2,0>.1 texture{Black_Plastic}}
cylinder{<0,0,-10>,<0,0,-.3>10 texture{White_Plastic}}
cylinder{<0,0,10>,<0,0,.3>10 texture{White_Plastic}}

cylinder{<0,-10,0>,<0,-.25,0>10 texture{White_Plastic}} 
cylinder{<0,10,0>,<0,.25,0>10 texture{White_Plastic}}
//cylinder{<0,0,0
cylinder{<0.5,5,0>,<0.5,.2,0>.1 texture{Black_Plastic}}
cylinder{<0.6,5,0>,<0.6,.2,0>.1 texture{Black_Plastic}}
}               
sphere{<.95,0,0>,.1 texture{Red_Plastic}}
cylinder{<0.5,.21,0>,<0.5,.22,0>.1 texture{Black_Plastic}}
cylinder{<0.6,.21,0>,<0.6,.22,0>.1 texture{Black_Plastic}}
//cone{<.5,0,0>,.4<1,0,0>.05 texture{Blue_Plastic}}

}} 

declare monotrack =
difference{
sphere{<0,0,0,>,1 texture{ White_Plastic} scale<.9,.5,1> hollow}

cylinder{<-10,0,0>,<-0,0,0>,10}                      
cylinder{<10,0,0>,<.5,0,0>,10}                      
cylinder{<0.5,5,0>,<0.5,.2,0>.1 texture{Black_Plastic}}
cylinder{<0.6,5,0>,<0.6,.2,0>.1 texture{Black_Plastic}}
cylinder{<0,0,-10>,<0,0,-.3>10 texture{White_Plastic}}
cylinder{<0,0,10>,<0,0,.3>10 texture{White_Plastic}}

cylinder{<0,-10,0>,<0,-.25,0>10 texture{White_Plastic}} 
cylinder{<0,10,0>,<0,.25,0>10 texture{White_Plastic}}
//cylinder{<0,0,0
cylinder{<0.5,5,0>,<0.5,.2,0>.1 texture{Black_Plastic}}
cylinder{<0.6,5,0>,<0.6,.2,0>.1 texture{Black_Plastic}}
}               

#declare Mybrick = texture {
  brick texture {
      pigment { color rgb <0.9,0.9,1.0> }
    },
    texture {
      pigment { color rgb <1.0,1.0,1.0> }
      finish { phong 1.0 phong_size 90 }
    }
  brick_size 0.15
  mortar 0.01
  scale <1,1.4,1>
}

#declare caterpillar=  union{
 sphere {     <0, 0, 0>, 1    texture {      pigment {  color Green  }    }  } //head

sphere {    <-0.2,0.3, -.9>,.2  texture {     pigment { color White }    }  } //eye      
sphere {    <0.2,0.3, -.9>,.2    texture {    pigment { color White }    }  } //eye    
sphere {    <-0.2,0.2, -1.05>,.05    texture{  pigment { color Black }    }  }//pupil       
sphere {    <0.2,0.2, -1.05>,.05   texture {   pigment { color Black }    }  }//pupil 
//sphere {    <0,-0.2, -1.5>,.09   texture {    pigment { color Black }    }  }//mouth 
 cone  {    <0,-0.2, -1.005>, 0.2           <-0.1,-0.4, -2>, 0.01        texture {pigment {  color Orchid }}  }//nose 
 cone  {    <0,.7, 0>, 0.3           <-0,2, -0>, 0.001        texture {pigment {  color Orchid }}  }//dunce hat or horn change base and colour acordingly 
         
   sphere{    <1, -1, 0>, 1                                             texture {pigment {  color Green  }}  }
   cone  {     <1.1, -1, -0.5>, 0.4           <1, -2.5, -0.5>, 0.1        texture {pigment {  color Orchid }}  }     
   cone  {    <1.1, -1,   0.5>, 0.4           <1, -2.05,  0.5>, 0.1        texture {pigment {  color Orchid }}  }    
  
   sphere {    <2, -1, 0>, 1    texture {     pigment {  color Green  }    }  }
   cone {     <2.1, -1, -0.4>, 0.4           <2, -2.5, -0.4>, 0.1        texture {pigment {  color Orchid }}  }     
   cone {    <2.1, -1,  0.6>, 0.4           <2, -2.5,  0.6>, 0.1        texture {pigment {  color Orchid }}  }     
      
   sphere {    <3, -1, 0.2>, 1    texture {      pigment {  color Green  }    }  }     
   cone {     <3.1, -1, -0.2>, 0.4           <3, -2.5, -0.2>, 0.1        texture {pigment {  color Orchid }}  }     
   cone {    <3.1, -1,  0.8>, 0.4           <3, -2.5,  0.8>, 0.1        texture {pigment {  color Orchid }}  }     
   
   sphere {    <4, -1, 0>, 1    texture {      pigment {  color Green  }    }  }     
   cone {     <4.1, -1, -0.4>, 0.4           <4, -2.5, -0.4>, 0.1        texture {pigment {  color Orchid }}  }     
   cone {    <4.1, -1,  0.6>, 0.4           <4, -2.5,  0.6>, 0.1        texture {pigment {  color Orchid }}  }   
      
    sphere {    <5, -1, -1>, 1    texture {      pigment {  color Green  }    }  }     
   cone {     <5.1, -1, -1.4>, 0.4           <5, -2.5, -1.4>, 0.1        texture {pigment {  color Orchid }}  }     
   cone {    <5.1, -1,  -0.4>, 0.4           <5, -2.5,  -0.4>, 0.1        texture {pigment {  color Orchid }}  }   
   
   cone {    <5, -1, -1>, 0.4           <4, 0.5, -03>, 0.1        texture {pigment {  color Orchid }}  }      
    
   cone {    <2.5, -2, -1>, 3.5           <2.5, 4, -1>, 3.5       texture {T_Glass1} hollow }            
   cone {    <2.5, 3.5, -1>, 3.5           <2.5, 4, -1>, 3.5       texture {pigment {  color Black }}  }     
   
   cone {    <-1,-.6,0>, .2           <-.4,-.6,0>, .01       texture {Orange_Plastic}rotate<0,0,0>  }   
 
 }  


declare duck=
blob {
   threshold .65
   sphere{    <-1,-1,0>, .50,1    texture {Yellow_Plastic}  }
   sphere{    <-1.3,-1,0>, .50,1    texture {Yellow_Plastic}  } 
   
   cylinder {    <-1,-.6,0>           <-.7,-.6,0>, .1,1       texture {Orange_Plastic}rotate<0,0,0>  }   
  
  sphere{    <-1,-.6,0>, .3,1    texture {Yellow_Plastic}  }
  sphere{    <-1,-.63,-.2>, .13,1    texture {White_Plastic}  } 
  
  sphere{    <-1,-.65,-.31>, .02,1    texture{pigment {color Black}}  }
  
  sphere{    <-1,-.63,.2>, .13,1    texture {White_Plastic}  } 
  
  sphere{    <-1,-.65,.31>, .02,1    texture{pigment {color Black}}  }  
  }
  

#declare Fire_Ball = texture

{

  pigment

  {

    bozo

    turbulence 0.6

    color_map

    {

      [0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]

      [0.19 color rgbf<1.000, 1.000, 1.000, 1.000>]

      [0.50 color rgb<1.000, 0.000, 0.000>]

      [0.76 color rgb<1.000, 1.000, 0.000>]

      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]

    }

  }

  normal

  {

    wrinkles 0.5

    turbulence 0.6  lambda 2.5

  }

  finish {

    ambient 0.15

    diffuse 0.75

    specular 0.6

  }

}



#declare Electricity = texture

{

  pigment

  {

    gradient y

    turbulence 0.6  lambda 2.25

    color_map

    {

      [0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]

      [0.30 color rgbf<1.000, 1.000, 1.000, 1.000>]

      [0.30 color rgb<0.149, 0.000, 1.000>]

      [0.50 color rgb<1.000, 1.000, 1.000>]

      [0.70 color rgb<0.149, 0.000, 1.000>]

      [0.70 color rgbf<1.000, 1.000, 1.000, 1.000>]

      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]

    }

    scale <1.25, 1.0, 1.0>

  }

  finish {

    ambient 0.4

    diffuse 0.8

  }

}

  
#declare Skin_Plastic = texture {
  pigment { color rgb <1,0.84, 0.77> }
  finish { phong 1.0 }
}




declare hand=

blob {
    threshold .65
    sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
    sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
    sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    cylinder { <-.65,-.28,0>, <-.65,.28,-.05>, .26, 1 }    //lower pinky
    cylinder { <-.65,.28,-.05>, <-.65, .68,-.2>, .26, 1 }  //upper pinky
    cylinder { <-.3,-.28,0>, <-.3,.44,-.05>, .26, 1 }      //lower ring
    cylinder { <-.3,.44,-.05>, <-.3, .9,-.2>, .26, 1 }     //upper ring
    cylinder { <.05,-.28,0>, <.05, .49,-.05>, .26, 1 }     //lower middle
    cylinder { <.05,.49,-.05>, <.05, .95,-.2>, .26, 1 }    //upper middle
    cylinder { <.4,-.4,0>, <.4, .512, -.05>, .26, 1 }      //lower index
    cylinder { <.4,.512,-.05>, <.4, .85, -.2>, .26, 1 }    //upper index
    cylinder { <.41, -.95,0>, <.85, -.68, -.05>, .25, 1 }  //lower thumb
    cylinder { <.85,-.68,-.05>, <1.2, -.4, -.2>, .25, 1 }  //upper thumb
    
     sphere { <-.65,.28,-.05>, .26, -1 } //counteract pinky knuckle bulge
  sphere { <-.65,-.28,0>, .26, -1 }   //counteract pinky palm bulge
  sphere { <-.3,.44,-.05>, .26, -1 }  //counteract ring knuckle bulge
  sphere { <-.3,-.28,0>, .26, -1 }    //counteract ring palm bulge
  sphere { <.05,.49,-.05>, .26, -1 }  //counteract middle knuckle bulge
  sphere { <.05,-.28,0>, .26, -1 }    //counteract middle palm bulge
  sphere { <.4,.512,-.05>, .26, -1 }  //counteract index knuckle bulge
  sphere { <.4,-.4,0>, .26, -1 }      //counteract index palm bulge
  sphere { <.85,-.68,-.05>, .25, -1 } //counteract thumb knuckle bulge
  sphere { <.41,-.7,0>, .25, -.89 }   //counteract thumb heel bulge
    
    
    pigment { Flesh }
  }
  
  
  
  
  
 declare person=
   
   union{
     cylinder{<-2.3,-6,0><-2.3,3,0>,2  texture{Skin_Plastic}}    //rightleg
 
      cylinder{<2.3,-6,0><2.3,3,0>,2  texture{Skin_Plastic}}    //left leg
     
        
         cone{ <2.3,3,0>,2<2.3,3,10>2.5 texture{Skin_Plastic}} 
          cone{ <-2.3,3,0>,2<-2.3,3,10>2.5 texture{Skin_Plastic}}    
            
          cylinder { <0,3,1><0,3,12>2.5 hollow texture{Orange_Plastic}scale<2,0,0>} 
          cylinder { <0,3,11><0,3,12>2.5  texture{Orange_Plastic}scale<2,0,0>} 
        // cone{ <2.3,3,0>,2<2.3,11,0>2.5 texture{Skin_Plastic}}   
         
     
      //cylinder{<2.3,-6,0><2.3,3,0>,2  texture{Skin_Plastic}}    //left leg
     
     sphere{ <2.3,3,0>,2.1 texture{Skin_Plastic}}     //left knee
     sphere{ <2.3,3,0>,2.1 texture{Skin_Plastic}translate<0,-9,0>}//left ankle 
      
     sphere{ <-2.3,3,0>,2.1 texture{Skin_Plastic}}     //right knee
     sphere{ <-2.3,3,0>,2.1 texture{Skin_Plastic}translate<0,-9,0>}//right ankle  
      
     sphere{<0,3,10>,2.5 texture {Skin_Plastic }scale<2,0,0>}
     
     cone{<0,3,10>,1.<0,9,10 >2.5 texture {Skin_Plastic }scale<2,0,0>} //body
    
     
     
     cylinder{<0,7,10 > <0,17,10>2.51  texture{Red_Plastic}scale<2,0,0>}//body 
   //  cylinder{<0,8.99,10 > <0,7,10>2.5 open  texture{Red_Plastic}scale<2,0,0>}//body
     
     sphere{<0,9,10 >2. texture {Skin_Plastic }scale<2,0,0>} //body
     
     
     cylinder{<0,9,10 > <0,17,10>2.5 texture{Skin_Plastic}scale<2,0,0>}//body
    
    
     cone{<0,20,10 >.5 <0,17,10>2.5 texture{Skin_Plastic}scale<2,0,0>}//body
     sphere{ <0,17,10>2.5 texture{Skin_Plastic}scale<2,0,0>}//body 
     cylinder{<0,18,10 > <0,24,10>2 texture{Skin_Plastic}scale<0,0,0>}//head 
     difference{
     
     union{
     cylinder{<0,18,8.5 > <0,25,8>4.9 open texture{Yellow_Plastic}scale<0,0,1>}  //hair
     
     difference{
     sphere{ <0,25,8>4.9 hollow texture{Yellow_Plastic}scale<1,0,1>} 
     cylinder{ <0,25,8><0,-10,8>4.9 texture{Yellow_Plastic}scale<0,0,1> }
         
     }     }   
     
     cylinder{<0,18,3 > <0,30,3>4.9 open texture{Yellow_Plastic}scale<0,0,1>}           
                }
                
                
       
     sphere  {<0,25,10>5 texture{Skin_Plastic   }  translate<0,-.15,2> scale<.7,0,.7>}
     
     sphere { <0,24,3> 1 texture{Skin_Plastic} translate<0,-.15,2> }
     
     sphere { <1.5,26,4> 1 texture{White_Plastic} translate<0,-.15,2> }
     sphere { <1.5,26,3> .3 texture{pigment{color Green}} translate<0,-.15,2> }  
     sphere { <-1.5,26,4> 1 texture{White_Plastic} translate<0,-.15,2> }  
     sphere { <-1.5,26,3> .3 texture{pigment{color Green}} translate<0,-.15,2> }    
       
       
       
       
       
       
       
       
       
       
       
     
        
        
        
        
      
     sphere{  <5,14.5,10>2.0 texture{Red_Plastic}scale<1.3,0,0>}
     sphere{  <6,14.5,10>2.0 texture{Red_Plastic}scale<0,0,0>}
     
     cylinder{<6.5,14.5,10><6.5,9.5,10>1.8   texture{Red_Plastic}   }
     sphere{<6.5,9.5,10>1.9    texture{Red_Plastic}   }
     cylinder{<6.5,14,10><6.5,9,2>1.8 texture {Skin_Plastic}scale<0,.5,0> translate<0,1.5,0>}    
     
     
     
     
     
     
     
      union{
    hand
    
    rotate<270,0,180> scale<3.5,3.5,3.5> translate<5.5,6,-2>}
        
    sphere{  <-5,14.5,10>2.0 texture{Red_Plastic}scale<1.3,0,0>}
     sphere{  <-6,14.5,10>2.0 texture{Red_Plastic}scale<0,0,0>}
     
     cylinder{<-6.5,14.5,10><-6.5,9.5,10>1.8   texture{Red_Plastic}   }
     sphere{<-6.5,9.5,10>1.9    texture{Red_Plastic}   }
     
      cone{<-6.5,9.5,10>1.9<-6.5,3.8,10>1    texture{Skin_Plastic}   }
     
     
     
           union{
    hand
    
    rotate<0,90,180> scale<3.5,3.5,3.5> translate<-6,0,10>}  
  
  
  
  
  
  
  
   //right Shoe  
     
    difference{
    
  sphere{ <2.3,-6.5,-1>,2.5 texture{Blue_Plastic}scale<1,.9,1.8>}
  cylinder{<2.3,-7.5,-1><2.3,-10,-1>10   texture{Blue_Plastic}} 
     
     
                                              }
     
    cylinder{ <2.3,-6.5,0><2.3,-8,0>,2.3 texture{Blue_Plastic}} 
    
    cylinder{ <2.3,-6.5,-3><2.3,-8,-3>,2.3 texture{Blue_Plastic}}
    
    
   //left Shoe 
    
  difference{
    
  sphere{ <-2.3,-6.5,-1>,2.5 texture{Blue_Plastic}scale<1,.9,1.8>}
  cylinder{<-2.3,-7.5,-1><-2.3,-10,-1>10   texture{Blue_Plastic}} 
     
     
                                              }
     
    cylinder{ <-2.3,-6.5,0><-2.3,-8,0>,2.3 texture{Blue_Plastic}} 
    
    cylinder{ <-2.3,-6.5,-3><-2.3,-8,-3>,2.3 texture{Blue_Plastic}}  
    
    
    
    
    
      }