#declare sky_color=SkyBlue;  // basic sky color
#declare num_planes = 20;
#declare clouds_height=5000; // first layer starts here
#declare plane_dist=40;      // distance between succesive planes
#declare textu_dist=40;      // distance between textures on succesive planes
#declare cnt_planes=1;       // counter

// place the planes
union{
#while (cnt_planes<=num_planes)

 // basic pigment for the lower plane
 #declare p=sky_color*.5+White*.5;

 // two derived pigments to mix on each plane, more "white" each pass
 #declare p1=p*(1-(cnt_planes/num_planes))+White*(cnt_planes/num_planes);
 #declare p2=p*.9*(1-(cnt_planes/num_planes))+White*.9*(cnt_planes/num_planes);

 // place the plane
 plane{
  y,0
  texture{
   pigment{
    granite           // try other patterns...
    octaves 9
    lambda 3
    turbulence 4
    color_map{        // notice that each plane has more transparency
     [0.0 Clear]
     [0.6 Clear]      // play with the "cloud zone" entries
     [0.7 p1 filter 0.7+0.1*(cnt_planes/num_planes)]
     [1.0 p2 filter 0.7+0.1*(cnt_planes/num_planes)]
    }
    scale 1000000     // depends on the patern
   }
//   finish{Luminous}   // prevent shadows
   finish{ambient sun_color}
   translate (clouds_height+textu_dist*cnt_planes)*y
  }
  no_shadow
  translate (clouds_height+plane_dist*cnt_planes)*y
 }
 #declare cnt_planes=cnt_planes+1;
#end
translate -100*z
}

