//
// Base scene for Texture Preview
// Moray for Windows V3.0
// Copyright (c) 1995-1997 SoftTronics, Lutz + Kretzschmar
//
// Avoid adding any include files to this scene. The rendering of
// this file must fly!
//


#declare PreviewTexture = 
   material  // PreviewTexture
   {   
      texture
      {      
         pigment
         {
            image_map
            {
               tga   "D:\scenes\Tv.tga"
               once
               interpolate 2
            }
            scale  <2.8, 2.2, 1.0>
            translate -1.4 * x
         }      
         finish
         {
            ambient 0.2
            diffuse 0.8
            phong 0.75
            phong_size 49.003333
            specular 0.410067
            reflection 0.15
         }
      }
   }
camera {  //  Camera PreviewCam
  location  <0.00, -7.50, 3>
  direction <0.0,     0.0,  3.00>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.0,     0.0,  0.0>
  look_at   <0.000, -0.100, 0.000>
}

// *******  L I G H T S *******
light_source {   // Light1
  <5.820, -8.500, 6.316>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light1
  <5.820, -1.500, 3>
  color rgb <0.400, 0.400, 0.400>
}

#declare FloorTxtr = texture {
  pigment {
    checker
      color rgb < 1.00,  1.00,  1.00>
      color rgb < 0.10,  0.10,  0.10>
    scale 0.45
  }
  finish {
    ambient   0.25
    diffuse   0.80
  }
}
#declare BackdropTxtr = texture {

  pigment {
    checker
      color rgb < 1.00,  1.00,  1.00>
      color rgb < 0.100,  0.100,  0.100>
      scale <1000, 0.2, 0.2>
      translate x*500
  }
//  pigment {
//      color rgb < 1.00,  1.00,  1.00>
//  }

  finish {
    ambient   0.25
    diffuse   0.80
  }
}

// ********  O B J E C T S *******

#declare Floor = object {
  disc { <0,0,-1> z, 25 }
  texture { FloorTxtr }
  hollow
}

#declare Backdrop = object {
  disc { <0,2.5,0> y,25 }
  texture { BackdropTxtr }
  hollow
}

#declare PreviewStone = object {
  merge {
    object { box    { <-1,-1,-1>, <1,1,1>} }
    object { sphere { <0,0,1.75>,1 } }
    material {
      PreviewTexture
    }
    scale 0.6
    translate -0.399*z
    rotate z*60
  }
  hollow
}

#declare PreviewSphere = object {
  sphere {<0,0,0>,1}
    material {
      PreviewTexture
    }
  hollow
}

#declare PreviewCube = object {
  box { <-0.9,-0.9,-0.9>,<0.9,0.9,0.9>}
  scale 0.9
    material {
      PreviewTexture
    }
  rotate z*60
  hollow
}

#declare PreviewPlane = object {
  plane { z,0 }
    material {
      PreviewTexture
    }
  hollow
}

#declare PreviewDisc = object {
  disc { <0,0,0>, z , 1.0 }
    material {
      PreviewTexture
    }
  scale 1.5
  hollow
}

#declare PreviewCylinder = object {
  cylinder { <0,0,-0.9>, <0,0,0.9>, 0.9 }
    material {
      PreviewTexture
    }
  hollow
}

#declare PreviewTorus = object {
  torus { 0.9, 0.3  rotate -x*90 }
    material {
      PreviewTexture
    }
  hollow
}


object { Floor }

object { Backdrop }


object { PreviewCube }


