//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 24 materials and 74 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//  Patched by Y. Paris to include a Tree

//  Date : 12/22/1999    (22.12.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.1 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <    285.371,     -22.415,     102.528>
  direction <        0.0,         0.0,      1.8316> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33330,         0.0,         0.0> // Aspect ratio
  look_at   <     -9.198,     -93.534,      22.095>
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <-4085.102, 3424.163, 2798.817>
  color rgb <1.000, 1.000, 1.000>
}

light_source { // Arealight001
  <-13.628, -129.666, 916.918>
  color rgb <1.000, 1.000, 1.000>*0.8000
  area_light <539.715, 0.000, 0.000>, <0.000, 1473.307, 0.000>, 3, 3
  adaptive 1
  jitter
}


light_source {   // Spotlight Spotlight001
  <-5352.916, 4286.052, 1336.602>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-873.381, -3144.458, -1876.484>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
}


//
// ********  MATERIALS  *******
//

#include "zen.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//
//#include "colors.inc"
#include "txttree.inc"
#include "maketree.pov" // tree & leaf macro
//=========================================
// Tree macro Parameters
//-----------------------------------------
// These parameters must be declared before calling the tree macro
//-----------------------------------------
#declare dofile=false;    // true creates a tree file ; false otherwise
#declare dotexture=true;  // true creates a textured tree (with the texture following the branch); false otherwise
#declare ftname="gttree3.inc" // file name for tree
#declare fvname="gtfoliage3.inc" // file name for foliage
#declare ffname="gtleaf3.inc" // file name for leaf
#declare txtTree=texture{txtTree_5} // Bark texture

//-----------------------------------------
// Random streams
// one stream for branches and another one for leaves
// so that the leafed tree has the same structure as the leafless one
//-----------------------------------------
#declare rsd=211;      // random seed
//#declare rsd=212;      // random seed
//#declare rsd=213;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

//-----------------------------------------
// Tree structure parameters        
// test with low level0 and nseg0 (3 or 4)
// High (>=6) recursion levels [level0] gives more complex trees
// High (>=6) segment numbers [nseg0] gives smoother trees
//-----------------------------------------
#declare level0=5;      // recursion level
//#declare level0=2;      // recursion level
#declare nseg0=7;       // initial number of branch segments (decreases of one at each level)
#declare nb=5;          // max number of branches per level
#declare dotop=true;   // if true, generates an extra branch on top of trunk (sometimes necessary to give more verticality)

#declare lb0=20;        // initial branch length
#declare rb0=1;         // initial branch radius
#declare ab0=25;        // initial branch angle (x angle between the trunk and the first branch)
#declare qlb=0.7;       // branch length decrease ratio (1=constant length)
#declare qrb=0.6;       // branch radius decrease ratio (1=constant radius)
#declare qab=1;       // branch angle decrease ratio (1=constant angle)
#declare stdax=10;      // stdev of x angle (angle x = ax+(0.5-rand)*stdax)
#declare stday=10;      // stdev of y angle (angle y = ay+(0.5-rand)*stday)

#declare branchproba=0.9; // probability of branch apparition 
#declare jb=0.4;        // secondary branches start after this ratio of branch length

#declare fgnarl=0.3;    // gnarledness factor - keep it low <0.8
#declare stdlseg=0.5;     // stddev of branch segment length (0...1) (adds more randomness to branch length)

#declare twigproba=0; // probability to have a twig on a trunk segment

#declare v0=<0,1,0>;    // initial direction - change to give an initial orientation
#declare pos0=<0,0,0>;  // initial trunk position (no need to change this one)

//-----------------------------------------
// constraints parameters
//-----------------------------------------
#declare vpush=<0,-0.2,0>;// direction of push (wind, gravity...) <0,-1,0> = gravity ; <0,1,0> = antigravity
#declare fpush=0.7;       // force of push
#declare aboveground=4; // constrains the branches above this level 
#declare belowsky=1000;  // constrains the branches below this level 

//-----------------------------------------
// root parameters
//-----------------------------------------
#declare rootproba=0;   // probability of root 0=no root ; 1=all [nb] roots
#declare nroot=5;      // number of main roots;
#declare vroot=<1,-0.4,0>; // initial direction of root 
#declare yroot=<0,0.5,0>;   // initial position of root above ground

//-----------------------------------------
// leaf position parameters
//-----------------------------------------
#declare leafproba=1;   // probability of leaf 0=no leaf ; 1=leaf on each segment
#declare leaflevel=4;   // level where the leaves start to appear
#declare alz0=100;       // max z angle for leaf
#declare alx0=-10;      // start x angle for leaf
#declare stdalx=20;     // std x angle for leaf
#declare stdlsize=0.1;  // stddev of leaf size 0=constant size; size = leafsize*(1+stdlsize*rand)

//-----------------------------------------
// leaf structure parameters
//-----------------------------------------
#declare txtLeaf=texture{txtLeaf_1} // Leaf texture
#declare lsize=0.6;     // leaf size
#declare seg=10;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=5;          // leaf length
#declare wl=1;          // leaf width 
#declare fl=0.5;        // depth of leaf fold
#declare lpow=1;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=1;      // number of lobes (individual leaves)
#declare alobes=0;    // angle made by all the lobes
#declare qlobes=1;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)                               
#declare ls=3;          // stalk length (0=no stalk)
#declare ws=0.1;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward
//-----------------------------------------
// end of parameters
//=========================================

//=========================================
// Make the tree now !
//-----------------------------------------

object{
        #if (leafproba>0)
        #declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
                 ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
                 #if (dotexture=false)  // no texture applied to tree segments, so the leaf texture must be used for the individual leaf
                        texture{txtLeaf}
                 #end
        } 
        
        #end              
        MakeTree()
        
        #if (dotexture = true) // texture is already applied to tree so that we can safely apply the leaf texture to the leaves
                texture {txtLeaf}
        #else

                texture {txtTree} // apply tree texture  regardless of the tree structure
        #end          
  rotate <90.0, -70.0, 0.0>
  scale <1, 1.2, 1>
  translate  <-25, -140, 10.0>
}


box { // wall_picture
  <-1, -1, -1>, <1, 1, 1>
  material {
    poster
  }
  scale <541.313599, -322.762878, 33.522545>
  rotate -90.0*x
  translate  <-1555.445297, -900.980849, 254.848545>
}




union { // small_table
  superellipsoid { // table
    <0.1, 0.1>
    material {
      S_Wood1
    }
    scale <715.28241, 335.537354, 13.950943>
    translate  <-1569.566851, 427.145433, -410.699275>
  }
  box { // table01
    <-1, -1, -1>, <1, 1, 1>
    material {
      S_Wood1
    }
    scale <29.205633, 306.65213, 190.68338>
    translate  <-2053.781378, 420.432068, -612.370997>
  }
  box { // table02
    <-1, -1, -1>, <1, 1, 1>
    material {
      S_Wood1
    }
    scale <29.205633, 306.65213, 190.68338>
    translate  <-1023.044696, 420.432068, -612.370997>
  }
}


box { // outside
  <-1, -1, -1>, <1, 1, 1>
  material {
    back_map
  }
  scale <3592.525391, 2699.004639, 21.532629>
  rotate <-90.0, -180.0, -90.0>
  translate  <-6422.675021, -1039.838538, -930.993114>
}


#declare fountain = union {
  box { // fountain01
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood5
    }
    scale <18.757307, 1.0, 4.617229>
    translate  <-19.961148, -127.429676, 5.261424>
  }
  box { // fountain02
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood5
    }
    scale <18.757307, 1.0, 4.617229>
    translate  <-19.961148, -165.14886, 5.261424>
  }
  box { // fountain03
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood5
    }
    scale <18.757307, 1.0, 4.617229>
    rotate -90.0*z
    translate  <-2.316253, -146.798987, 5.261424>
  }
  box { // fountain04
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood5
    }
    scale <18.757307, 1.0, 4.617229>
    rotate -90.0*z
    translate  <-37.808909, -145.967203, 5.261424>
  }
  box { // fountain05
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood5
    }
    scale <18.171019, 18.661219, 0.671161>
    rotate <0.0, 0.0, 0.0>
    translate  <-20.101315, -146.282992, 2.063797>
  }
  scale <1.3, 1.3, 1.0>
  translate  <6.897662, 41.903299, -0.986517>
}
#declare Stone01 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.471325, 0.000000, -0.038899>, <0.512027, -0.004350, -0.190647>, <0.209322, 0.000000, -0.158445>, <0.097036, 0.000000, -0.209679>, 
      <0.414866, 0.006034, 0.171594>, <0.455568, 0.001684, 0.019846>, <0.140818, 0.171534, -0.114126>, <0.082367, 0.150000, -0.165360>, 
      <0.193533, -0.005856, 0.249464>, <0.160627, 0.233751, 0.159244>, <0.042629, 0.500589, -0.041395>, <0.099948, 0.494463, -0.255097>, 
      <-0.024483, 0.012987, 0.243376>, <-0.036559, 0.233751, 0.232932>, <-0.009178, 0.506126, 0.151754>, <0.048141, 0.500000, -0.061948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.471325, 0.000000, -0.038899>, <0.512027, -0.004350, -0.190647>, <0.209322, 0.000000, -0.158445>, <0.097036, 0.000000, -0.209679>, 
      <0.414866, 0.006034, 0.171594>, <0.455568, 0.001684, 0.019846>, <0.211065, -0.150000, -0.099933>, <0.098778, -0.150000, -0.151168>, 
      <0.193533, -0.005856, 0.249464>, <0.205792, -0.224585, 0.286984>, <0.035264, -0.499456, 0.031115>, <0.155943, -0.505675, -0.212610>, 
      <-0.024483, 0.012987, 0.243376>, <-0.012224, -0.211125, 0.253978>, <0.044655, -0.493781, 0.202304>, <0.102843, -0.500000, -0.014640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.471325, 0.000000, -0.038899>, <0.414866, 0.006034, 0.171594>, <0.193533, -0.005856, 0.249464>, <-0.024483, 0.012987, 0.243376>, 
      <0.471325, 0.000000, -0.038899>, <0.427822, -0.190435, 0.158572>, <0.205792, -0.224585, 0.286984>, <-0.012224, -0.211125, 0.253978>, 
      <0.471325, 0.000000, -0.038899>, <0.427822, -0.190435, 0.158572>, <0.282118, -0.493781, 0.203071>, <0.044655, -0.493781, 0.202304>, 
      <0.471325, 0.000000, -0.038899>, <0.484281, -0.236846, -0.027694>, <0.340307, -0.500000, -0.013873>, <0.102843, -0.500000, -0.014640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.471325, 0.000000, -0.038899>, <0.512027, -0.004350, -0.190647>, <0.209322, 0.000000, -0.158445>, <0.097036, 0.000000, -0.209679>, 
      <0.471325, 0.000000, -0.038899>, <0.524983, -0.241196, -0.179442>, <0.211065, -0.150000, -0.099933>, <0.098778, -0.150000, -0.151168>, 
      <0.471325, 0.000000, -0.038899>, <0.524983, -0.241196, -0.179442>, <0.393406, -0.505675, -0.211842>, <0.155943, -0.505675, -0.212610>, 
      <0.471325, 0.000000, -0.038899>, <0.484281, -0.236846, -0.027694>, <0.340307, -0.500000, -0.013873>, <0.102843, -0.500000, -0.014640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.471325, 0.000000, -0.038899>, <0.512027, -0.004350, -0.190647>, <0.209322, 0.000000, -0.158445>, <0.097036, 0.000000, -0.209679>, 
      <0.471325, 0.000000, -0.038899>, <0.498365, 0.245400, -0.202462>, <0.140818, 0.171534, -0.114126>, <0.082367, 0.150000, -0.165360>, 
      <0.471325, 0.000000, -0.038899>, <0.498365, 0.245400, -0.202462>, <0.350349, 0.494463, -0.254288>, <0.099948, 0.494463, -0.255097>, 
      <0.471325, 0.000000, -0.038899>, <0.457663, 0.249750, -0.050714>, <0.298543, 0.500000, -0.061139>, <0.048141, 0.500000, -0.061948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.471325, 0.000000, -0.038899>, <0.457663, 0.249750, -0.050714>, <0.298543, 0.500000, -0.061139>, <0.048141, 0.500000, -0.061948>, 
      <0.484281, -0.236846, -0.027694>, <0.470619, 0.012904, -0.039509>, <0.350349, 0.494463, -0.254288>, <0.099948, 0.494463, -0.255097>, 
      <0.340307, -0.500000, -0.013873>, <0.393406, -0.505675, -0.211842>, <0.084110, 0.000000, -0.106848>, <0.082367, 0.150000, -0.165360>, 
      <0.102843, -0.500000, -0.014640>, <0.155943, -0.505675, -0.212610>, <0.098778, -0.150000, -0.151168>, <0.097036, 0.000000, -0.209679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.471325, 0.000000, -0.038899>, <0.414866, 0.006034, 0.171594>, <0.193533, -0.005856, 0.249464>, <-0.024483, 0.012987, 0.243376>, 
      <0.471325, 0.000000, -0.038899>, <0.401205, 0.255784, 0.159779>, <0.160627, 0.233751, 0.159244>, <-0.036559, 0.233751, 0.232932>, 
      <0.471325, 0.000000, -0.038899>, <0.401205, 0.255784, 0.159779>, <0.241224, 0.506126, 0.152563>, <-0.009178, 0.506126, 0.151754>, 
      <0.471325, 0.000000, -0.038899>, <0.457663, 0.249750, -0.050714>, <0.298543, 0.500000, -0.061139>, <0.048141, 0.500000, -0.061948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.471325, 0.000000, -0.038899>, <0.484281, -0.236846, -0.027694>, <0.340307, -0.500000, -0.013873>, <0.102843, -0.500000, -0.014640>, 
      <0.457663, 0.249750, -0.050714>, <0.470619, 0.012904, -0.039509>, <0.282118, -0.493781, 0.203071>, <0.044655, -0.493781, 0.202304>, 
      <0.298543, 0.500000, -0.061139>, <0.241224, 0.506126, 0.152563>, <-0.024300, 0.009638, 0.243534>, <-0.012224, -0.211125, 0.253978>, 
      <0.048141, 0.500000, -0.061948>, <-0.009178, 0.506126, 0.151754>, <-0.036559, 0.233751, 0.232932>, <-0.024483, 0.012987, 0.243376>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521053, 0.000000, -0.042105>, <-0.577734, 0.006058, 0.169219>, <-0.243359, 0.012987, 0.242669>, <-0.024483, 0.012987, 0.243376>, 
      <-0.457696, -0.006771, -0.278316>, <-0.514378, -0.000713, -0.066992>, <-0.231100, -0.211125, 0.253271>, <-0.012224, -0.211125, 0.253978>, 
      <-0.088391, 0.000000, -0.159407>, <-0.086649, -0.150000, -0.100895>, <0.035264, -0.499456, 0.031115>, <0.044655, -0.493781, 0.202304>, 
      <0.097036, 0.000000, -0.209679>, <0.098778, -0.150000, -0.151168>, <0.155943, -0.505675, -0.212610>, <0.102843, -0.500000, -0.014640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521053, 0.000000, -0.042105>, <-0.577734, 0.006058, 0.169219>, <-0.243359, 0.012987, 0.242669>, <-0.024483, 0.012987, 0.243376>, 
      <-0.457696, -0.006771, -0.278316>, <-0.514378, -0.000713, -0.066992>, <-0.255435, 0.233751, 0.232225>, <-0.036559, 0.233751, 0.232932>, 
      <-0.088391, 0.000000, -0.159407>, <-0.103059, 0.150000, -0.115088>, <0.042629, 0.500589, -0.041395>, <-0.009178, 0.506126, 0.151754>, 
      <0.097036, 0.000000, -0.209679>, <0.082367, 0.150000, -0.165360>, <0.099948, 0.494463, -0.255097>, <0.048141, 0.500000, -0.061948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521053, 0.000000, -0.042105>, <-0.457696, -0.006771, -0.278316>, <-0.088391, 0.000000, -0.159407>, <0.097036, 0.000000, -0.209679>, 
      <-0.536849, 0.288778, -0.055767>, <-0.473493, 0.282007, -0.291977>, <0.023896, 0.000000, -0.108173>, <0.209322, 0.000000, -0.158445>, 
      <-0.241389, 0.500000, -0.062883>, <0.009012, 0.500000, -0.062074>, <0.498365, 0.245400, -0.202462>, <0.512027, -0.004350, -0.190647>, 
      <0.048141, 0.500000, -0.061948>, <0.298543, 0.500000, -0.061139>, <0.457663, 0.249750, -0.050714>, <0.471325, 0.000000, -0.038899>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521053, 0.000000, -0.042105>, <-0.536849, 0.288778, -0.055767>, <-0.241389, 0.500000, -0.062883>, <0.048141, 0.500000, -0.061948>, 
      <-0.577734, 0.006058, 0.169219>, <-0.593531, 0.294835, 0.155557>, <0.009012, 0.500000, -0.062074>, <0.298543, 0.500000, -0.061139>, 
      <-0.243359, 0.012987, 0.242669>, <-0.022368, 0.012987, 0.198738>, <0.401205, 0.255784, 0.159779>, <0.457663, 0.249750, -0.050714>, 
      <-0.024483, 0.012987, 0.243376>, <0.193533, -0.005856, 0.249464>, <0.414866, 0.006034, 0.171594>, <0.471325, 0.000000, -0.038899>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521053, 0.000000, -0.042105>, <-0.536849, 0.288778, -0.055767>, <-0.241389, 0.500000, -0.062883>, <0.048141, 0.500000, -0.061948>, 
      <-0.521053, 0.000000, -0.042105>, <-0.473493, 0.282007, -0.291977>, <-0.189583, 0.494463, -0.256032>, <0.099948, 0.494463, -0.255097>, 
      <-0.521053, 0.000000, -0.042105>, <-0.473493, 0.282007, -0.291977>, <-0.103059, 0.150000, -0.115088>, <0.082367, 0.150000, -0.165360>, 
      <-0.521053, 0.000000, -0.042105>, <-0.457696, -0.006771, -0.278316>, <-0.088391, 0.000000, -0.159407>, <0.097036, 0.000000, -0.209679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521053, 0.000000, -0.042105>, <-0.577734, 0.006058, 0.169219>, <-0.243359, 0.012987, 0.242669>, <-0.024483, 0.012987, 0.243376>, 
      <-0.521053, 0.000000, -0.042105>, <-0.593531, 0.294835, 0.155557>, <-0.255435, 0.233751, 0.232225>, <-0.036559, 0.233751, 0.232932>, 
      <-0.521053, 0.000000, -0.042105>, <-0.593531, 0.294835, 0.155557>, <-0.292757, 0.506126, 0.141891>, <-0.009178, 0.506126, 0.151754>, 
      <-0.521053, 0.000000, -0.042105>, <-0.536849, 0.288778, -0.055767>, <-0.241389, 0.500000, -0.062883>, <0.048141, 0.500000, -0.061948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521053, 0.000000, -0.042105>, <-0.457696, -0.006771, -0.278316>, <-0.088391, 0.000000, -0.159407>, <0.097036, 0.000000, -0.209679>, 
      <-0.504378, -0.304829, -0.027684>, <-0.441022, -0.311600, -0.263895>, <0.023896, 0.000000, -0.108173>, <0.209322, 0.000000, -0.158445>, 
      <-0.202780, -0.500000, -0.015627>, <0.034683, -0.500000, -0.014860>, <0.524983, -0.241196, -0.179442>, <0.512027, -0.004350, -0.190647>, 
      <0.102843, -0.500000, -0.014640>, <0.340307, -0.500000, -0.013873>, <0.484281, -0.236846, -0.027694>, <0.471325, 0.000000, -0.038899>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521053, 0.000000, -0.042105>, <-0.577734, 0.006058, 0.169219>, <-0.243359, 0.012987, 0.242669>, <-0.024483, 0.012987, 0.243376>, 
      <-0.504378, -0.304829, -0.027684>, <-0.561059, -0.298771, 0.183640>, <-0.022368, 0.012987, 0.198738>, <0.193533, -0.005856, 0.249464>, 
      <-0.202780, -0.500000, -0.015627>, <0.034683, -0.500000, -0.014860>, <0.427822, -0.190435, 0.158572>, <0.414866, 0.006034, 0.171594>, 
      <0.102843, -0.500000, -0.014640>, <0.340307, -0.500000, -0.013873>, <0.484281, -0.236846, -0.027694>, <0.471325, 0.000000, -0.038899>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521053, 0.000000, -0.042105>, <-0.577734, 0.006058, 0.169219>, <-0.243359, 0.012987, 0.242669>, <-0.024483, 0.012987, 0.243376>, 
      <-0.521053, 0.000000, -0.042105>, <-0.561059, -0.298771, 0.183640>, <-0.231100, -0.211125, 0.253271>, <-0.012224, -0.211125, 0.253978>, 
      <-0.521053, 0.000000, -0.042105>, <-0.561059, -0.298771, 0.183640>, <-0.260969, -0.493781, 0.201316>, <0.044655, -0.493781, 0.202304>, 
      <-0.521053, 0.000000, -0.042105>, <-0.504378, -0.304829, -0.027684>, <-0.202780, -0.500000, -0.015627>, <0.102843, -0.500000, -0.014640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521053, 0.000000, -0.042105>, <-0.536849, 0.288778, -0.055767>, <-0.241389, 0.500000, -0.062883>, <0.048141, 0.500000, -0.061948>, 
      <-0.504378, -0.304829, -0.027684>, <-0.520175, -0.016051, -0.041346>, <-0.251097, 0.506126, 0.124037>, <-0.009178, 0.506126, 0.151754>, 
      <-0.202780, -0.500000, -0.015627>, <-0.260969, -0.493781, 0.201316>, <-0.024300, 0.009638, 0.243534>, <-0.036559, 0.233751, 0.232932>, 
      <0.102843, -0.500000, -0.014640>, <0.044655, -0.493781, 0.202304>, <-0.012224, -0.211125, 0.253978>, <-0.024483, 0.012987, 0.243376>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521053, 0.000000, -0.042105>, <-0.457696, -0.006771, -0.278316>, <-0.088391, 0.000000, -0.159407>, <0.097036, 0.000000, -0.209679>, 
      <-0.521053, 0.000000, -0.042105>, <-0.441022, -0.311600, -0.263895>, <-0.086649, -0.150000, -0.100895>, <0.098778, -0.150000, -0.151168>, 
      <-0.521053, 0.000000, -0.042105>, <-0.441022, -0.311600, -0.263895>, <-0.149680, -0.505675, -0.213597>, <0.155943, -0.505675, -0.212610>, 
      <-0.521053, 0.000000, -0.042105>, <-0.504378, -0.304829, -0.027684>, <-0.202780, -0.500000, -0.015627>, <0.102843, -0.500000, -0.014640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521053, 0.000000, -0.042105>, <-0.504378, -0.304829, -0.027684>, <-0.202780, -0.500000, -0.015627>, <0.102843, -0.500000, -0.014640>, 
      <-0.536849, 0.288778, -0.055767>, <-0.520175, -0.016051, -0.041346>, <-0.149680, -0.505675, -0.213597>, <0.155943, -0.505675, -0.212610>, 
      <-0.241389, 0.500000, -0.062883>, <-0.189583, 0.494463, -0.256032>, <0.084110, 0.000000, -0.106848>, <0.098778, -0.150000, -0.151168>, 
      <0.048141, 0.500000, -0.061948>, <0.099948, 0.494463, -0.255097>, <0.082367, 0.150000, -0.165360>, <0.097036, 0.000000, -0.209679>
    }
  }
  material {
    stone
  }
  scale <-12.268231, -16.804693, -10.657678>
  rotate <-180.0, 0.0, -180.0>
  translate  <13.508503, -31.089114, 0.986517>
}
#declare Sand = object { 
  height_field {
    tga "D:\scenes\Image1.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    SandstP
  }
  scale <58.546394, 91.276299, 1.0>
  translate  <-20.387447, -96.134656, -0.707384>
}
#declare width01 = difference {
  box { // Cadre001
    <-1, -1, -1>, <1, 1, 1>
    scale <66.288521, 5.034719, 1.837628>
    translate  <-20.589857, -0.686329, 0.0>
  }
  box { // intersec01
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <45.780655, -6.06332, 0.0>
  }
  box { // intersec02
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <-87.472445, -5.663219, 0.0>
  }
  material {
    DMFWood5
  }
}
#declare width02 = difference {
  box { // Cadre002
    <-1, -1, -1>, <1, 1, 1>
    scale <66.288521, 5.034719, 1.837628>
    translate  <-20.589857, -0.686329, 0.0>
  }
  box { // intersec03
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <45.780655, -6.06332, 0.0>
  }
  box { // intersec04
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <-87.472445, -5.663219, 0.0>
  }
  material {
    BlackPine
  }
  rotate <-180.0, 0.0, -0.0>
  translate  -191.0*y
}
#declare length01 = difference {
  box { // Cadre003
    <-1, -1, -1>, <1, 1, 1>
    material {
      BlackPine
    }
    scale <100.0, 5.034719, 1.837628>
    rotate -90.0*z
    translate  <40.836868, -95.452831, 0.0>
  }
  box { // intersec05
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <35.242141, 4.625557, 0.0>
  }
  box { // intersec06
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <35.210207, -195.519718, 0.0>
  }
  material {
    BlackPine
  }
}
#declare length02 = difference {
  box { // Cadre004
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 5.034719, 1.837628>
    rotate -90.0*z
    translate  <40.836868, -95.452831, 0.0>
  }
  box { // intersec07
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <35.242141, 4.625557, 0.0>
  }
  box { // intersec08
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <35.210207, -195.519718, 0.0>
  }
  material {
    BlackPine
  }
  rotate <-180.0, 0.0, -180.0>
  translate  -41.408618*x
}
#declare cadre = union {
  object { width01 }
  object { width02 }
  object { length01 }
  object { length02 }
  material {
    DMFWood5
  }
}
#declare Stone02 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.330808, -0.250000, 0.121212>, <-0.295831, -0.314007, 0.024501>, <-0.249194, -0.399348, -0.104447>, <-0.214217, -0.463355, -0.201158>, 
      <-0.399686, -0.252057, 0.012294>, <-0.364708, -0.316063, -0.084417>, <-0.302583, -0.402277, -0.104447>, <-0.267606, -0.466284, -0.201158>, 
      <-0.491522, -0.254800, -0.132931>, <-0.454274, -0.343809, -0.125853>, <-0.385313, -0.425096, -0.213250>, <-0.331888, -0.504814, -0.200957>, 
      <-0.560400, -0.256856, -0.241849>, <-0.523151, -0.345866, -0.234771>, <-0.435743, -0.442865, -0.213164>, <-0.382318, -0.522583, -0.200870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.307076, 0.002381, 0.281678>, <-0.322821, -0.079757, 0.314939>, <-0.323688, -0.174286, 0.169352>, <-0.330808, -0.250000, 0.121212>, 
      <-0.444708, -0.026477, 0.168885>, <-0.460454, -0.108615, 0.202146>, <-0.392566, -0.176343, 0.060434>, <-0.399686, -0.252057, 0.012294>, 
      <-0.512830, 0.000714, -0.085194>, <-0.514899, -0.076536, -0.095887>, <-0.521559, -0.183026, -0.138638>, <-0.491522, -0.254800, -0.132931>, 
      <-0.601010, 0.000000, -0.242424>, <-0.603080, -0.077250, -0.253117>, <-0.590436, -0.185083, -0.247556>, <-0.560400, -0.256856, -0.241849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225610, 0.298781, -0.101010>, <-0.259930, 0.185265, -0.013712>, <-0.281315, 0.136767, 0.227260>, <-0.307076, 0.002381, 0.281678>, 
      <-0.320540, 0.261734, -0.131695>, <-0.354860, 0.148219, -0.044397>, <-0.418947, 0.107909, 0.114467>, <-0.444708, -0.026477, 0.168885>, 
      <-0.451829, 0.213415, -0.157576>, <-0.476952, 0.166700, -0.181592>, <-0.511285, 0.058370, -0.077213>, <-0.512830, 0.000714, -0.085194>, 
      <-0.548781, 0.176829, -0.181818>, <-0.573904, 0.130114, -0.205835>, <-0.599465, 0.057656, -0.234444>, <-0.601010, 0.000000, -0.242424>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225610, 0.298781, -0.101010>, <-0.320540, 0.261734, -0.131695>, <-0.451829, 0.213415, -0.157576>, <-0.548781, 0.176829, -0.181818>, 
      <-0.210737, 0.347973, -0.138841>, <-0.305667, 0.310927, -0.169526>, <-0.418829, 0.274777, -0.126029>, <-0.515780, 0.238192, -0.150271>, 
      <-0.177322, 0.439634, -0.101010>, <-0.260198, 0.410112, -0.088784>, <-0.375949, 0.344512, -0.109091>, <-0.452205, 0.300610, -0.096970>, 
      <-0.156627, 0.500000, -0.101010>, <-0.239503, 0.470478, -0.088784>, <-0.334559, 0.397561, -0.072727>, <-0.410816, 0.353659, -0.060606>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.048780, 0.371951, -0.020202>, <-0.099111, 0.366502, -0.056545>, <-0.170020, 0.320474, -0.083042>, <-0.225610, 0.298781, -0.101010>, 
      <-0.054395, 0.404969, -0.058756>, <-0.104726, 0.399520, -0.095099>, <-0.155147, 0.369667, -0.120873>, <-0.210737, 0.347973, -0.138841>, 
      <-0.014634, 0.461585, -0.090909>, <-0.060689, 0.463765, -0.080010>, <-0.133117, 0.455381, -0.107532>, <-0.177322, 0.439634, -0.101010>, 
      <0.000000, 0.500000, -0.121212>, <-0.046055, 0.502180, -0.110313>, <-0.112422, 0.515747, -0.107532>, <-0.156627, 0.500000, -0.101010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.061408, 0.138890, 0.300443>, <-0.049137, 0.097937, 0.294814>, <-0.216970, 0.021273, 0.355523>, <-0.307076, 0.002381, 0.281678>, 
      <0.028351, 0.208808, 0.204250>, <-0.082194, 0.167855, 0.198620>, <-0.191208, 0.155659, 0.301104>, <-0.281315, 0.136767, 0.227260>, 
      <-0.035210, 0.292151, 0.072977>, <-0.085541, 0.286703, 0.036634>, <-0.204340, 0.206958, 0.004256>, <-0.259930, 0.185265, -0.013712>, 
      <-0.048780, 0.371951, -0.020202>, <-0.099111, 0.366502, -0.056545>, <-0.170020, 0.320474, -0.083042>, <-0.225610, 0.298781, -0.101010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.052600, -0.170548, 0.281103>, <-0.057310, -0.309881, 0.171676>, <0.012100, -0.400762, -0.056278>, <0.039829, -0.499425, -0.200870>, 
      <-0.150636, -0.170548, 0.296071>, <-0.155346, -0.309881, 0.186643>, <-0.064787, -0.398435, -0.053358>, <-0.037059, -0.497098, -0.197950>, 
      <-0.247346, -0.226164, 0.169180>, <-0.212368, -0.290171, 0.072469>, <-0.172332, -0.395132, -0.104447>, <-0.137354, -0.459138, -0.201158>, 
      <-0.330808, -0.250000, 0.121212>, <-0.295831, -0.314007, 0.024501>, <-0.249194, -0.399348, -0.104447>, <-0.214217, -0.463355, -0.201158>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.052600, -0.170548, 0.281103>, <-0.150636, -0.170548, 0.296071>, <-0.247346, -0.226164, 0.169180>, <-0.330808, -0.250000, 0.121212>, 
      <-0.049966, -0.092637, 0.342292>, <-0.148002, -0.092637, 0.357260>, <-0.240226, -0.150450, 0.217319>, <-0.323688, -0.174286, 0.169352>, 
      <0.027206, 0.046058, 0.294641>, <-0.083340, 0.005106, 0.289012>, <-0.232715, -0.060864, 0.388783>, <-0.322821, -0.079757, 0.314939>, 
      <0.061408, 0.138890, 0.300443>, <-0.049137, 0.097937, 0.294814>, <-0.216970, 0.021273, 0.355523>, <-0.307076, 0.002381, 0.281678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.330808, -0.250000, 0.020202>, <0.324575, -0.318767, -0.052180>, <0.316264, -0.410456, -0.148690>, <0.310031, -0.479223, -0.221072>, 
      <0.215786, -0.226164, 0.098472>, <0.209553, -0.294931, 0.026090>, <0.234752, -0.410354, -0.148486>, <0.228519, -0.479121, -0.220869>, 
      <0.086938, -0.170548, 0.259800>, <0.082227, -0.309881, 0.150372>, <0.093517, -0.403226, -0.059371>, <0.121246, -0.501889, -0.203963>, 
      <-0.052600, -0.170548, 0.281103>, <-0.057310, -0.309881, 0.171676>, <0.012100, -0.400762, -0.056278>, <0.039829, -0.499425, -0.200870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.330808, -0.250000, 0.020202>, <0.412478, -0.273596, -0.052267>, <0.521372, -0.305057, -0.148891>, <0.603043, -0.328652, -0.221360>, 
      <0.324575, -0.318767, -0.052180>, <0.406245, -0.342363, -0.124649>, <0.495758, -0.359605, -0.149065>, <0.577429, -0.383201, -0.221534>, 
      <0.316264, -0.410456, -0.148690>, <0.373879, -0.410528, -0.148834>, <0.473922, -0.442363, -0.213538>, <0.530913, -0.448596, -0.207822>, 
      <0.310031, -0.479223, -0.221072>, <0.367646, -0.479295, -0.221216>, <0.443009, -0.493767, -0.207736>, <0.500000, -0.500000, -0.202020>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.325120, 0.142666, 0.341997>, <0.441005, 0.084930, 0.179223>, <0.595518, 0.007949, -0.037809>, <0.711403, -0.049786, -0.200583>, 
      <0.326827, 0.024866, 0.245459>, <0.442711, -0.032870, 0.082684>, <0.589009, -0.081702, -0.041656>, <0.704893, -0.139438, -0.204430>, 
      <0.329102, -0.132200, 0.116741>, <0.410772, -0.155796, 0.044272>, <0.559612, -0.223618, -0.148631>, <0.641283, -0.247214, -0.221100>, 
      <0.330808, -0.250000, 0.020202>, <0.412478, -0.273596, -0.052267>, <0.521372, -0.305057, -0.148891>, <0.603043, -0.328652, -0.221360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.325120, 0.142666, 0.341997>, <0.326827, 0.024866, 0.245459>, <0.329102, -0.132200, 0.116741>, <0.330808, -0.250000, 0.020202>, 
      <0.246007, 0.141533, 0.329531>, <0.247713, 0.023733, 0.232992>, <0.214079, -0.108365, 0.195011>, <0.215786, -0.226164, 0.098472>, 
      <0.140522, 0.140022, 0.312909>, <0.106319, 0.047191, 0.307107>, <0.089571, -0.092637, 0.320989>, <0.086938, -0.170548, 0.259800>, 
      <0.061408, 0.138890, 0.300443>, <0.027206, 0.046058, 0.294641>, <-0.049966, -0.092637, 0.342292>, <-0.052600, -0.170548, 0.281103>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.250000, 0.350271, 0.242424>, <0.238115, 0.423229, 0.124695>, <0.264141, 0.440940, -0.068687>, <0.270202, 0.479798, -0.202020>, 
      <0.422066, 0.299501, 0.197453>, <0.410181, 0.372460, 0.079723>, <0.334605, 0.420911, -0.074100>, <0.340665, 0.459769, -0.207433>, 
      <0.522421, 0.223356, -0.067278>, <0.485454, 0.289638, -0.060472>, <0.465224, 0.339935, -0.183875>, <0.417781, 0.398226, -0.171323>, 
      <0.639173, 0.168964, -0.200008>, <0.602206, 0.235246, -0.193201>, <0.528472, 0.304975, -0.170719>, <0.481029, 0.363266, -0.158167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.250000, 0.350271, 0.242424>, <0.138810, 0.383079, 0.271485>, <0.047744, 0.382401, 0.049497>, <-0.048780, 0.371951, -0.020202>, 
      <0.238115, 0.423229, 0.124695>, <0.126925, 0.456037, 0.153755>, <0.042129, 0.415419, 0.010944>, <-0.054395, 0.404969, -0.058756>, 
      <0.264141, 0.440940, -0.068687>, <0.182771, 0.464070, -0.062436>, <0.067823, 0.457683, -0.110423>, <-0.014634, 0.461585, -0.090909>, 
      <0.270202, 0.479798, -0.202020>, <0.188831, 0.502928, -0.195769>, <0.082457, 0.496097, -0.140726>, <0.000000, 0.500000, -0.121212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.250000, 0.350271, 0.242424>, <0.422066, 0.299501, 0.197453>, <0.522421, 0.223356, -0.067278>, <0.639173, 0.168964, -0.200008>, 
      <0.256212, 0.312138, 0.303959>, <0.428278, 0.261368, 0.258987>, <0.555950, 0.163240, -0.073452>, <0.672702, 0.108848, -0.206181>, 
      <0.302584, 0.204947, 0.312125>, <0.418469, 0.147212, 0.149351>, <0.600518, 0.076815, -0.034854>, <0.716403, 0.019079, -0.197628>, 
      <0.325120, 0.142666, 0.341997>, <0.441005, 0.084930, 0.179223>, <0.595518, 0.007949, -0.037809>, <0.711403, -0.049786, -0.200583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.250000, 0.350271, 0.242424>, <0.256212, 0.312138, 0.303959>, <0.302584, 0.204947, 0.312125>, <0.325120, 0.142666, 0.341997>, 
      <0.138810, 0.383079, 0.271485>, <0.145022, 0.344945, 0.333020>, <0.223471, 0.203814, 0.299659>, <0.246007, 0.141533, 0.329531>, 
      <0.047744, 0.382401, 0.049497>, <0.061314, 0.302601, 0.142677>, <0.107465, 0.209941, 0.216716>, <0.140522, 0.140022, 0.312909>, 
      <-0.048780, 0.371951, -0.020202>, <-0.035210, 0.292151, 0.072977>, <0.028351, 0.208808, 0.204250>, <0.061408, 0.138890, 0.300443>
    }
  }
  material {
    stone
  }
  scale <13.428599, 13.96147, 11.19401>
  translate  <-53.655068, -75.758928, 0.328839>
}
#declare garden = union {
  object { Stone01 }
  object { Sand }
  object { cadre }
  object { Stone02 }
}
#declare CSG001 = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cork
    }
    scale <2.0, 0.7, 0.7>
    translate  2.3*z
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      Cork
    }
    scale <0.7, 0.7, 4.0>
    rotate -90.0*y
    translate  <2.0, 0.0, 3.0>
  }
  scale <1.2, 1.0, 1.0>
}
#declare tool = union {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      Cork
    }
    scale <0.5, 0.5, 20.0>
    rotate -90.0*x
    translate  3.0*z
  }
  object { CSG001 }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      Cork
    }
    scale <0.3, 0.3, 2.6>
    translate  -1.0*z
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      Cork
    }
    scale <0.3, 0.3, 2.6>
    translate  <1.5, 0.0, -1.0>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      Cork
    }
    scale <0.3, 0.3, 2.6>
    translate  <-1.5, 0.0, -1.0>
  }
  scale 2.235788
  rotate <-7.757936, -5.845485, -143.704422>
  translate  <24.139793, -87.781047, 0.450248>
}
union { // dry_garden
  object { fountain }
  object { garden }
  object { tool }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      tree_soil
    }
    scale <22.221472, 23.686886, 1.0>
    rotate <-0.0, 0.0, -0.415545>
    translate  <-19.040719, -148.279022, 4.8247>
  }
  rotate -18.17527*z
  translate  <34.278128, -5.935283, 1.972259>
}


box { // window_glass
  <-1, -1, -1>, <1, 1, 1>
  material {
    window_material
  }
  hollow
  scale <-1.520701, 725.921509, 641.905151>
  translate  <-3770.366618, 98.437979, 132.11315>
}


#declare width03 = difference {
  box { // Cadre005
    <-1, -1, -1>, <1, 1, 1>
    scale <66.288521, 5.034719, 1.837628>
    translate  <-20.589857, -0.686329, 0.0>
  }
  box { // intersec09
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <45.780655, -6.06332, 0.0>
  }
  box { // intersec10
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <-87.472445, -5.663219, 0.0>
  }
  material {
    DMFWood5
  }
}
#declare width04 = difference {
  box { // Cadre006
    <-1, -1, -1>, <1, 1, 1>
    scale <66.288521, 5.034719, 1.837628>
    translate  <-20.589857, -0.686329, 0.0>
  }
  box { // intersec11
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <45.780655, -6.06332, 0.0>
  }
  box { // intersec12
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <-87.472445, -5.663219, 0.0>
  }
  material {
    BlackPine
  }
  rotate <-180.0, 0.0, -0.0>
  translate  -191.0*y
}
#declare length03 = difference {
  box { // Cadre007
    <-1, -1, -1>, <1, 1, 1>
    material {
      BlackPine
    }
    scale <100.0, 5.034719, 1.837628>
    rotate -90.0*z
    translate  <40.836868, -95.452831, 0.0>
  }
  box { // intersec13
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <35.242141, 4.625557, 0.0>
  }
  box { // intersec14
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <35.210207, -195.519718, 0.0>
  }
  material {
    BlackPine
  }
}
#declare length04 = difference {
  box { // Cadre008
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 5.034719, 1.837628>
    rotate -90.0*z
    translate  <40.836868, -95.452831, 0.0>
  }
  box { // intersec15
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <35.242141, 4.625557, 0.0>
  }
  box { // intersec16
    <-1, -1, -1>, <1, 1, 1>
    scale <7.493424, 7.493424, 2.441485>
    rotate -45.0*z
    translate  <35.210207, -195.519718, 0.0>
  }
  material {
    BlackPine
  }
  rotate <-180.0, 0.0, -180.0>
  translate  -41.408618*x
}
#declare window_edge01 = union {
  object { width03 }
  object { width04 }
  object { length03 }
  object { length04 }
  material {
    DMFWood5
  }
  scale <11.0, 7.3, 5.0>
  rotate -90.0*y
  translate  <-3770.370093, 751.31355, 364.646509>
}
union { // window
  cylinder { // window_join
    <0,0,1>, <0,0,0>, 1 
    material {
      DMFWood5
    }
    scale <9.530828, 11.532255, 174.897568>
    translate  <-3751.611638, -684.597122, -65.494136>
  }
  object { window_edge01 }
}


union { // sofa
  superellipsoid { // sofa01
    <0.2, 0.3>
    material {
      Material1
    }
    scale <709.569519, 261.395996, 105.093506>
    rotate <-74.264999, -0.0, 0.0>
    translate  <-1561.304211, -635.704092, -360.518249>
  }
  superellipsoid { // sofa02
    <0.2, 0.2>
    material {
      Material1
    }
    scale <709.569458, 277.87027, 72.373177>
    translate  <-1569.135875, -326.425772, -582.450282>
  }
}






#declare walls = union {
  box { // wall01
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wallpaper
    }
    scale <4406.633789, 1.0, 1788.793457>
    translate  <610.406555, -810.900728, 1053.521127>
  }
  box { // wall02
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wallpaper
    }
    scale <4406.633789, 1.0, 1788.793457>
    rotate -90.0*z
    translate  <-3781.312832, 3550.218533, 1053.521127>
  }
  box { // floor
    <-1, -1, -1>, <1, 1, 1>
    material {
      soil
    }
    scale <4463.238281, 4125.131348, 1.0>
    translate  <689.907814, 3313.868288, -734.2723>
  }
  box { // wall03
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wallpaper
    }
    scale <4406.633789, 1.0, 1788.793457>
    translate  <610.406555, 7168.085865, 1053.521127>
  }
  box { // wall04
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wallpaper
    }
    scale <4406.633789, 1.0, 1788.793457>
    rotate -90.0*z
    translate  <5000.0, 3550.218533, 1053.521127>
  }
  box { // roof
    <-1, -1, -1>, <1, 1, 1>
    material {
      white
    }
    scale <4463.238281, 4125.131348, 1.0>
    translate  <689.907814, 3313.868288, 2752.838501>
  }
  material {
    Wallpaper
  }
  scale <1.0, 0.8, 0.6>
  translate  <0.0, -234.468778, -351.703166>
}
difference { // room
  object { walls }
  box { // window01
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wallpaper
    }
    scale <344.16333, 724.168518, 708.728394>
    translate  <-3835.108519, 93.787511, 160.0>
  }
  box { // window02
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wallpaper
    }
    scale <344.16333, 724.168518, 708.728394>
    translate  <-3835.108519, 1711.622076, 160.0>
  }
}


#declare plant01 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.951083, -1.671816>, <-0.033791, 0.767503, -2.160018>, <-0.034769, 0.522729, -2.810954>, <-0.035502, 0.339148, -3.299156>, 
      <0.135537, 0.993031, -1.482668>, <0.134804, 0.809450, -1.970870>, <0.109766, 0.578979, -2.683006>, <0.109033, 0.395398, -3.171208>, 
      <0.360331, 1.048961, -1.230470>, <0.351574, 1.016451, -1.804908>, <0.532678, 0.641720, -2.527058>, <0.399880, 0.464847, -3.058277>, 
      <0.528926, 1.090909, -1.041322>, <0.520169, 1.058399, -1.615760>, <0.579079, 0.703521, -2.341444>, <0.446281, 0.526648, -2.872663>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.951083, -1.671816>, <-0.191736, 0.993031, -1.482668>, <-0.403306, 1.048961, -1.230470>, <-0.561984, 1.090909, -1.041322>, 
      <-0.033791, 0.767503, -2.160018>, <-0.192469, 0.809450, -1.970870>, <-0.394508, 1.016297, -1.809877>, <-0.553186, 1.058245, -1.620729>, 
      <-0.034769, 0.522729, -2.810954>, <-0.162961, 0.578979, -2.687965>, <-0.547931, 0.648192, -2.524148>, <-0.588184, 0.705669, -2.351522>, 
      <-0.035502, 0.339148, -3.299156>, <-0.163694, 0.395398, -3.176167>, <-0.422557, 0.469171, -3.061818>, <-0.462810, 0.526648, -2.889192>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.642428, -0.056905>, <-0.033058, 0.735025, -0.541378>, <-0.033058, 0.858487, -1.187343>, <-0.033058, 0.951083, -1.671816>, 
      <0.125620, 0.662923, 0.074216>, <0.125620, 0.755519, -0.410257>, <0.135537, 0.900434, -0.998194>, <0.135537, 0.993031, -1.482668>, 
      <0.337189, 0.690249, 0.249044>, <0.370476, 0.925327, -0.123236>, <0.367050, 1.073908, -0.789682>, <0.360331, 1.048961, -1.230470>, 
      <0.495867, 0.710744, 0.380165>, <0.529153, 0.945821, 0.007884>, <0.535645, 1.115856, -0.600534>, <0.528926, 1.090909, -1.041322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.642428, -0.056905>, <-0.176859, 0.662923, 0.073068>, <-0.368595, 0.690249, 0.246366>, <-0.512396, 0.710744, 0.376339>, 
      <-0.033058, 0.735025, -0.541378>, <-0.176859, 0.755519, -0.411405>, <-0.404902, 0.922913, -0.126000>, <-0.548704, 0.943407, 0.003973>, 
      <-0.033058, 0.858487, -1.187343>, <-0.191736, 0.900434, -0.998194>, <-0.409985, 1.073757, -0.790643>, <-0.568663, 1.115705, -0.601495>, 
      <-0.033058, 0.951083, -1.671816>, <-0.191736, 0.993031, -1.482668>, <-0.403306, 1.048961, -1.230470>, <-0.561984, 1.090909, -1.041322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.330578, -0.309880, 1.177036>, <0.216529, -0.287468, 1.066917>, <0.064463, -0.257586, 0.920092>, <-0.049587, -0.235174, 0.809974>, 
      <0.330578, -0.309880, 1.177036>, <0.124075, -0.840169, 1.300007>, <0.079339, -0.863118, 1.166196>, <-0.034711, -0.840707, 1.056078>, 
      <0.330578, -0.309880, 1.177036>, <0.124075, -0.840169, 1.300007>, <0.084297, -1.064962, 1.248231>, <-0.014876, -1.648083, 1.384217>, 
      <0.330578, -0.309880, 1.177036>, <0.238124, -0.862581, 1.410126>, <0.099173, -1.670495, 1.494335>, <0.000000, -2.253616, 1.630321>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.330578, -0.309880, 1.177036>, <0.216529, -0.287468, 1.066917>, <0.064463, -0.257586, 0.920092>, <-0.049587, -0.235174, 0.809974>, 
      <0.390233, 0.046745, 1.026637>, <0.276183, 0.069156, 0.916518>, <0.069421, 0.005695, 0.660029>, <-0.044628, 0.028107, 0.549910>, 
      <0.466345, 0.502251, 0.710345>, <0.307667, 0.481756, 0.579224>, <0.120661, 0.399642, 0.334280>, <-0.038017, 0.379148, 0.203159>, 
      <0.495867, 0.710744, 0.380165>, <0.337189, 0.690249, 0.249044>, <0.125620, 0.662923, 0.074216>, <-0.033058, 0.642428, -0.056905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.250325, -0.845955, 1.399273>, <-0.104132, -1.663344, 1.489950>, <0.000000, -2.253616, 1.630321>, 
      <-0.347107, -0.286043, 1.162420>, <-0.161069, -0.830695, 1.293540>, <-0.119008, -1.057811, 1.243846>, <-0.014876, -1.648083, 1.384217>, 
      <-0.347107, -0.286043, 1.162420>, <-0.161069, -0.830695, 1.293540>, <-0.123967, -0.855967, 1.161812>, <-0.034711, -0.840707, 1.056078>, 
      <-0.347107, -0.286043, 1.162420>, <-0.257851, -0.270782, 1.056686>, <-0.138843, -0.250435, 0.915707>, <-0.049587, -0.235174, 0.809974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.407485, 0.063263, 1.014656>, <-0.480747, 0.507931, 0.700931>, <-0.512396, 0.710744, 0.376339>, 
      <-0.257851, -0.270782, 1.056686>, <-0.318229, 0.078524, 0.908922>, <-0.336945, 0.487436, 0.570958>, <-0.368595, 0.690249, 0.246366>, 
      <-0.138843, -0.250435, 0.915707>, <-0.133884, 0.012846, 0.655644>, <-0.181818, 0.399642, 0.333132>, <-0.176859, 0.662923, 0.073068>, 
      <-0.049587, -0.235174, 0.809974>, <-0.044628, 0.028107, 0.549910>, <-0.038017, 0.379148, 0.203159>, <-0.033058, 0.642428, -0.056905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.257851, -0.270782, 1.056686>, <-0.138843, -0.250435, 0.915707>, <-0.049587, -0.235174, 0.809974>, 
      <-0.250325, -0.845955, 1.399273>, <-0.161069, -0.830695, 1.293540>, <-0.024794, -0.272847, 1.025826>, <0.064463, -0.257586, 0.920092>, 
      <-0.104132, -1.663344, 1.489950>, <-0.004959, -1.080223, 1.353965>, <0.124075, -0.840169, 1.300007>, <0.216529, -0.287468, 1.066917>, 
      <0.000000, -2.253616, 1.630321>, <0.099173, -1.670495, 1.494335>, <0.238124, -0.862581, 1.410126>, <0.330578, -0.309880, 1.177036>
    }
  }
  material {
    Grass
  }
  scale <-84.712639, -72.953751, -94.579308>
  rotate <-86.849884, -13.387192, 164.027313>
  translate  <-2561.613599, -370.81985, -450.74239>
}
#declare plant02 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.951083, -1.671816>, <-0.033791, 0.767503, -2.160018>, <-0.034769, 0.522729, -2.810954>, <-0.035502, 0.339148, -3.299156>, 
      <0.135537, 0.993031, -1.482668>, <0.134804, 0.809450, -1.970870>, <0.109766, 0.578979, -2.683006>, <0.109033, 0.395398, -3.171208>, 
      <0.360331, 1.048961, -1.230470>, <0.351574, 1.016451, -1.804908>, <0.532678, 0.641720, -2.527058>, <0.399880, 0.464847, -3.058277>, 
      <0.528926, 1.090909, -1.041322>, <0.520169, 1.058399, -1.615760>, <0.579079, 0.703521, -2.341444>, <0.446281, 0.526648, -2.872663>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.951083, -1.671816>, <-0.191736, 0.993031, -1.482668>, <-0.403306, 1.048961, -1.230470>, <-0.561984, 1.090909, -1.041322>, 
      <-0.033791, 0.767503, -2.160018>, <-0.192469, 0.809450, -1.970870>, <-0.394508, 1.016297, -1.809877>, <-0.553186, 1.058245, -1.620729>, 
      <-0.034769, 0.522729, -2.810954>, <-0.162961, 0.578979, -2.687965>, <-0.547931, 0.648192, -2.524148>, <-0.588184, 0.705669, -2.351522>, 
      <-0.035502, 0.339148, -3.299156>, <-0.163694, 0.395398, -3.176167>, <-0.422557, 0.469171, -3.061818>, <-0.462810, 0.526648, -2.889192>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.642428, -0.056905>, <-0.033058, 0.735025, -0.541378>, <-0.033058, 0.858487, -1.187343>, <-0.033058, 0.951083, -1.671816>, 
      <0.125620, 0.662923, 0.074216>, <0.125620, 0.755519, -0.410257>, <0.135537, 0.900434, -0.998194>, <0.135537, 0.993031, -1.482668>, 
      <0.337189, 0.690249, 0.249044>, <0.370476, 0.925327, -0.123236>, <0.367050, 1.073908, -0.789682>, <0.360331, 1.048961, -1.230470>, 
      <0.495867, 0.710744, 0.380165>, <0.529153, 0.945821, 0.007884>, <0.535645, 1.115856, -0.600534>, <0.528926, 1.090909, -1.041322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.642428, -0.056905>, <-0.176859, 0.662923, 0.073068>, <-0.368595, 0.690249, 0.246366>, <-0.512396, 0.710744, 0.376339>, 
      <-0.033058, 0.735025, -0.541378>, <-0.176859, 0.755519, -0.411405>, <-0.404902, 0.922913, -0.126000>, <-0.548704, 0.943407, 0.003973>, 
      <-0.033058, 0.858487, -1.187343>, <-0.191736, 0.900434, -0.998194>, <-0.409985, 1.073757, -0.790643>, <-0.568663, 1.115705, -0.601495>, 
      <-0.033058, 0.951083, -1.671816>, <-0.191736, 0.993031, -1.482668>, <-0.403306, 1.048961, -1.230470>, <-0.561984, 1.090909, -1.041322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.330578, -0.309880, 1.177036>, <0.216529, -0.287468, 1.066917>, <0.064463, -0.257586, 0.920092>, <-0.049587, -0.235174, 0.809974>, 
      <0.330578, -0.309880, 1.177036>, <0.124075, -0.840169, 1.300007>, <0.079339, -0.863118, 1.166196>, <-0.034711, -0.840707, 1.056078>, 
      <0.330578, -0.309880, 1.177036>, <0.124075, -0.840169, 1.300007>, <0.084297, -1.064962, 1.248231>, <-0.014876, -1.648083, 1.384217>, 
      <0.330578, -0.309880, 1.177036>, <0.238124, -0.862581, 1.410126>, <0.099173, -1.670495, 1.494335>, <0.000000, -2.253616, 1.630321>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.330578, -0.309880, 1.177036>, <0.216529, -0.287468, 1.066917>, <0.064463, -0.257586, 0.920092>, <-0.049587, -0.235174, 0.809974>, 
      <0.390233, 0.046745, 1.026637>, <0.276183, 0.069156, 0.916518>, <0.069421, 0.005695, 0.660029>, <-0.044628, 0.028107, 0.549910>, 
      <0.466345, 0.502251, 0.710345>, <0.307667, 0.481756, 0.579224>, <0.120661, 0.399642, 0.334280>, <-0.038017, 0.379148, 0.203159>, 
      <0.495867, 0.710744, 0.380165>, <0.337189, 0.690249, 0.249044>, <0.125620, 0.662923, 0.074216>, <-0.033058, 0.642428, -0.056905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.250325, -0.845955, 1.399273>, <-0.104132, -1.663344, 1.489950>, <0.000000, -2.253616, 1.630321>, 
      <-0.347107, -0.286043, 1.162420>, <-0.161069, -0.830695, 1.293540>, <-0.119008, -1.057811, 1.243846>, <-0.014876, -1.648083, 1.384217>, 
      <-0.347107, -0.286043, 1.162420>, <-0.161069, -0.830695, 1.293540>, <-0.123967, -0.855967, 1.161812>, <-0.034711, -0.840707, 1.056078>, 
      <-0.347107, -0.286043, 1.162420>, <-0.257851, -0.270782, 1.056686>, <-0.138843, -0.250435, 0.915707>, <-0.049587, -0.235174, 0.809974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.407485, 0.063263, 1.014656>, <-0.480747, 0.507931, 0.700931>, <-0.512396, 0.710744, 0.376339>, 
      <-0.257851, -0.270782, 1.056686>, <-0.318229, 0.078524, 0.908922>, <-0.336945, 0.487436, 0.570958>, <-0.368595, 0.690249, 0.246366>, 
      <-0.138843, -0.250435, 0.915707>, <-0.133884, 0.012846, 0.655644>, <-0.181818, 0.399642, 0.333132>, <-0.176859, 0.662923, 0.073068>, 
      <-0.049587, -0.235174, 0.809974>, <-0.044628, 0.028107, 0.549910>, <-0.038017, 0.379148, 0.203159>, <-0.033058, 0.642428, -0.056905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.257851, -0.270782, 1.056686>, <-0.138843, -0.250435, 0.915707>, <-0.049587, -0.235174, 0.809974>, 
      <-0.250325, -0.845955, 1.399273>, <-0.161069, -0.830695, 1.293540>, <-0.024794, -0.272847, 1.025826>, <0.064463, -0.257586, 0.920092>, 
      <-0.104132, -1.663344, 1.489950>, <-0.004959, -1.080223, 1.353965>, <0.124075, -0.840169, 1.300007>, <0.216529, -0.287468, 1.066917>, 
      <0.000000, -2.253616, 1.630321>, <0.099173, -1.670495, 1.494335>, <0.238124, -0.862581, 1.410126>, <0.330578, -0.309880, 1.177036>
    }
  }
  material {
    Grass
  }
  scale <-111.542336, -89.677963, -72.300041>
  rotate <-91.810669, 13.318939, 117.505394>
  translate  <-2444.218913, -458.866707, -440.890808>
}
#declare plant03 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.951083, -1.671816>, <-0.033791, 0.767503, -2.160018>, <-0.034769, 0.522729, -2.810954>, <-0.035502, 0.339148, -3.299156>, 
      <0.135537, 0.993031, -1.482668>, <0.134804, 0.809450, -1.970870>, <0.109766, 0.578979, -2.683006>, <0.109033, 0.395398, -3.171208>, 
      <0.360331, 1.048961, -1.230470>, <0.351574, 1.016451, -1.804908>, <0.532678, 0.641720, -2.527058>, <0.399880, 0.464847, -3.058277>, 
      <0.528926, 1.090909, -1.041322>, <0.520169, 1.058399, -1.615760>, <0.579079, 0.703521, -2.341444>, <0.446281, 0.526648, -2.872663>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.951083, -1.671816>, <-0.191736, 0.993031, -1.482668>, <-0.403306, 1.048961, -1.230470>, <-0.561984, 1.090909, -1.041322>, 
      <-0.033791, 0.767503, -2.160018>, <-0.192469, 0.809450, -1.970870>, <-0.394508, 1.016297, -1.809877>, <-0.553186, 1.058245, -1.620729>, 
      <-0.034769, 0.522729, -2.810954>, <-0.162961, 0.578979, -2.687965>, <-0.547931, 0.648192, -2.524148>, <-0.588184, 0.705669, -2.351522>, 
      <-0.035502, 0.339148, -3.299156>, <-0.163694, 0.395398, -3.176167>, <-0.422557, 0.469171, -3.061818>, <-0.462810, 0.526648, -2.889192>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.642428, -0.056905>, <-0.033058, 0.735025, -0.541378>, <-0.033058, 0.858487, -1.187343>, <-0.033058, 0.951083, -1.671816>, 
      <0.125620, 0.662923, 0.074216>, <0.125620, 0.755519, -0.410257>, <0.135537, 0.900434, -0.998194>, <0.135537, 0.993031, -1.482668>, 
      <0.337189, 0.690249, 0.249044>, <0.370476, 0.925327, -0.123236>, <0.367050, 1.073908, -0.789682>, <0.360331, 1.048961, -1.230470>, 
      <0.495867, 0.710744, 0.380165>, <0.529153, 0.945821, 0.007884>, <0.535645, 1.115856, -0.600534>, <0.528926, 1.090909, -1.041322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.642428, -0.056905>, <-0.176859, 0.662923, 0.073068>, <-0.368595, 0.690249, 0.246366>, <-0.512396, 0.710744, 0.376339>, 
      <-0.033058, 0.735025, -0.541378>, <-0.176859, 0.755519, -0.411405>, <-0.404902, 0.922913, -0.126000>, <-0.548704, 0.943407, 0.003973>, 
      <-0.033058, 0.858487, -1.187343>, <-0.191736, 0.900434, -0.998194>, <-0.409985, 1.073757, -0.790643>, <-0.568663, 1.115705, -0.601495>, 
      <-0.033058, 0.951083, -1.671816>, <-0.191736, 0.993031, -1.482668>, <-0.403306, 1.048961, -1.230470>, <-0.561984, 1.090909, -1.041322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.330578, -0.309880, 1.177036>, <0.216529, -0.287468, 1.066917>, <0.064463, -0.257586, 0.920092>, <-0.049587, -0.235174, 0.809974>, 
      <0.330578, -0.309880, 1.177036>, <0.124075, -0.840169, 1.300007>, <0.079339, -0.863118, 1.166196>, <-0.034711, -0.840707, 1.056078>, 
      <0.330578, -0.309880, 1.177036>, <0.124075, -0.840169, 1.300007>, <0.084297, -1.064962, 1.248231>, <-0.014876, -1.648083, 1.384217>, 
      <0.330578, -0.309880, 1.177036>, <0.238124, -0.862581, 1.410126>, <0.099173, -1.670495, 1.494335>, <0.000000, -2.253616, 1.630321>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.330578, -0.309880, 1.177036>, <0.216529, -0.287468, 1.066917>, <0.064463, -0.257586, 0.920092>, <-0.049587, -0.235174, 0.809974>, 
      <0.390233, 0.046745, 1.026637>, <0.276183, 0.069156, 0.916518>, <0.069421, 0.005695, 0.660029>, <-0.044628, 0.028107, 0.549910>, 
      <0.466345, 0.502251, 0.710345>, <0.307667, 0.481756, 0.579224>, <0.120661, 0.399642, 0.334280>, <-0.038017, 0.379148, 0.203159>, 
      <0.495867, 0.710744, 0.380165>, <0.337189, 0.690249, 0.249044>, <0.125620, 0.662923, 0.074216>, <-0.033058, 0.642428, -0.056905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.250325, -0.845955, 1.399273>, <-0.104132, -1.663344, 1.489950>, <0.000000, -2.253616, 1.630321>, 
      <-0.347107, -0.286043, 1.162420>, <-0.161069, -0.830695, 1.293540>, <-0.119008, -1.057811, 1.243846>, <-0.014876, -1.648083, 1.384217>, 
      <-0.347107, -0.286043, 1.162420>, <-0.161069, -0.830695, 1.293540>, <-0.123967, -0.855967, 1.161812>, <-0.034711, -0.840707, 1.056078>, 
      <-0.347107, -0.286043, 1.162420>, <-0.257851, -0.270782, 1.056686>, <-0.138843, -0.250435, 0.915707>, <-0.049587, -0.235174, 0.809974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.407485, 0.063263, 1.014656>, <-0.480747, 0.507931, 0.700931>, <-0.512396, 0.710744, 0.376339>, 
      <-0.257851, -0.270782, 1.056686>, <-0.318229, 0.078524, 0.908922>, <-0.336945, 0.487436, 0.570958>, <-0.368595, 0.690249, 0.246366>, 
      <-0.138843, -0.250435, 0.915707>, <-0.133884, 0.012846, 0.655644>, <-0.181818, 0.399642, 0.333132>, <-0.176859, 0.662923, 0.073068>, 
      <-0.049587, -0.235174, 0.809974>, <-0.044628, 0.028107, 0.549910>, <-0.038017, 0.379148, 0.203159>, <-0.033058, 0.642428, -0.056905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.257851, -0.270782, 1.056686>, <-0.138843, -0.250435, 0.915707>, <-0.049587, -0.235174, 0.809974>, 
      <-0.250325, -0.845955, 1.399273>, <-0.161069, -0.830695, 1.293540>, <-0.024794, -0.272847, 1.025826>, <0.064463, -0.257586, 0.920092>, 
      <-0.104132, -1.663344, 1.489950>, <-0.004959, -1.080223, 1.353965>, <0.124075, -0.840169, 1.300007>, <0.216529, -0.287468, 1.066917>, 
      <0.000000, -2.253616, 1.630321>, <0.099173, -1.670495, 1.494335>, <0.238124, -0.862581, 1.410126>, <0.330578, -0.309880, 1.177036>
    }
  }
  material {
    Grass
  }
  scale -92.787514
  rotate <-86.542969, -18.679901, -161.000565>
  translate  <-2700.288007, -327.61954, -470.22686>
}
#declare plant04 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.951083, -1.671816>, <-0.033791, 0.767503, -2.160018>, <-0.034769, 0.522729, -2.810954>, <-0.035502, 0.339148, -3.299156>, 
      <0.135537, 0.993031, -1.482668>, <0.134804, 0.809450, -1.970870>, <0.109766, 0.578979, -2.683006>, <0.109033, 0.395398, -3.171208>, 
      <0.360331, 1.048961, -1.230470>, <0.351574, 1.016451, -1.804908>, <0.532678, 0.641720, -2.527058>, <0.399880, 0.464847, -3.058277>, 
      <0.528926, 1.090909, -1.041322>, <0.520169, 1.058399, -1.615760>, <0.579079, 0.703521, -2.341444>, <0.446281, 0.526648, -2.872663>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.951083, -1.671816>, <-0.191736, 0.993031, -1.482668>, <-0.403306, 1.048961, -1.230470>, <-0.561984, 1.090909, -1.041322>, 
      <-0.033791, 0.767503, -2.160018>, <-0.192469, 0.809450, -1.970870>, <-0.394508, 1.016297, -1.809877>, <-0.553186, 1.058245, -1.620729>, 
      <-0.034769, 0.522729, -2.810954>, <-0.162961, 0.578979, -2.687965>, <-0.547931, 0.648192, -2.524148>, <-0.588184, 0.705669, -2.351522>, 
      <-0.035502, 0.339148, -3.299156>, <-0.163694, 0.395398, -3.176167>, <-0.422557, 0.469171, -3.061818>, <-0.462810, 0.526648, -2.889192>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.642428, -0.056905>, <-0.033058, 0.735025, -0.541378>, <-0.033058, 0.858487, -1.187343>, <-0.033058, 0.951083, -1.671816>, 
      <0.125620, 0.662923, 0.074216>, <0.125620, 0.755519, -0.410257>, <0.135537, 0.900434, -0.998194>, <0.135537, 0.993031, -1.482668>, 
      <0.337189, 0.690249, 0.249044>, <0.370476, 0.925327, -0.123236>, <0.367050, 1.073908, -0.789682>, <0.360331, 1.048961, -1.230470>, 
      <0.495867, 0.710744, 0.380165>, <0.529153, 0.945821, 0.007884>, <0.535645, 1.115856, -0.600534>, <0.528926, 1.090909, -1.041322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.642428, -0.056905>, <-0.176859, 0.662923, 0.073068>, <-0.368595, 0.690249, 0.246366>, <-0.512396, 0.710744, 0.376339>, 
      <-0.033058, 0.735025, -0.541378>, <-0.176859, 0.755519, -0.411405>, <-0.404902, 0.922913, -0.126000>, <-0.548704, 0.943407, 0.003973>, 
      <-0.033058, 0.858487, -1.187343>, <-0.191736, 0.900434, -0.998194>, <-0.409985, 1.073757, -0.790643>, <-0.568663, 1.115705, -0.601495>, 
      <-0.033058, 0.951083, -1.671816>, <-0.191736, 0.993031, -1.482668>, <-0.403306, 1.048961, -1.230470>, <-0.561984, 1.090909, -1.041322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.330578, -0.309880, 1.177036>, <0.216529, -0.287468, 1.066917>, <0.064463, -0.257586, 0.920092>, <-0.049587, -0.235174, 0.809974>, 
      <0.330578, -0.309880, 1.177036>, <0.124075, -0.840169, 1.300007>, <0.079339, -0.863118, 1.166196>, <-0.034711, -0.840707, 1.056078>, 
      <0.330578, -0.309880, 1.177036>, <0.124075, -0.840169, 1.300007>, <0.084297, -1.064962, 1.248231>, <-0.014876, -1.648083, 1.384217>, 
      <0.330578, -0.309880, 1.177036>, <0.238124, -0.862581, 1.410126>, <0.099173, -1.670495, 1.494335>, <0.000000, -2.253616, 1.630321>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.330578, -0.309880, 1.177036>, <0.216529, -0.287468, 1.066917>, <0.064463, -0.257586, 0.920092>, <-0.049587, -0.235174, 0.809974>, 
      <0.390233, 0.046745, 1.026637>, <0.276183, 0.069156, 0.916518>, <0.069421, 0.005695, 0.660029>, <-0.044628, 0.028107, 0.549910>, 
      <0.466345, 0.502251, 0.710345>, <0.307667, 0.481756, 0.579224>, <0.120661, 0.399642, 0.334280>, <-0.038017, 0.379148, 0.203159>, 
      <0.495867, 0.710744, 0.380165>, <0.337189, 0.690249, 0.249044>, <0.125620, 0.662923, 0.074216>, <-0.033058, 0.642428, -0.056905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.250325, -0.845955, 1.399273>, <-0.104132, -1.663344, 1.489950>, <0.000000, -2.253616, 1.630321>, 
      <-0.347107, -0.286043, 1.162420>, <-0.161069, -0.830695, 1.293540>, <-0.119008, -1.057811, 1.243846>, <-0.014876, -1.648083, 1.384217>, 
      <-0.347107, -0.286043, 1.162420>, <-0.161069, -0.830695, 1.293540>, <-0.123967, -0.855967, 1.161812>, <-0.034711, -0.840707, 1.056078>, 
      <-0.347107, -0.286043, 1.162420>, <-0.257851, -0.270782, 1.056686>, <-0.138843, -0.250435, 0.915707>, <-0.049587, -0.235174, 0.809974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.407485, 0.063263, 1.014656>, <-0.480747, 0.507931, 0.700931>, <-0.512396, 0.710744, 0.376339>, 
      <-0.257851, -0.270782, 1.056686>, <-0.318229, 0.078524, 0.908922>, <-0.336945, 0.487436, 0.570958>, <-0.368595, 0.690249, 0.246366>, 
      <-0.138843, -0.250435, 0.915707>, <-0.133884, 0.012846, 0.655644>, <-0.181818, 0.399642, 0.333132>, <-0.176859, 0.662923, 0.073068>, 
      <-0.049587, -0.235174, 0.809974>, <-0.044628, 0.028107, 0.549910>, <-0.038017, 0.379148, 0.203159>, <-0.033058, 0.642428, -0.056905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.257851, -0.270782, 1.056686>, <-0.138843, -0.250435, 0.915707>, <-0.049587, -0.235174, 0.809974>, 
      <-0.250325, -0.845955, 1.399273>, <-0.161069, -0.830695, 1.293540>, <-0.024794, -0.272847, 1.025826>, <0.064463, -0.257586, 0.920092>, 
      <-0.104132, -1.663344, 1.489950>, <-0.004959, -1.080223, 1.353965>, <0.124075, -0.840169, 1.300007>, <0.216529, -0.287468, 1.066917>, 
      <0.000000, -2.253616, 1.630321>, <0.099173, -1.670495, 1.494335>, <0.238124, -0.862581, 1.410126>, <0.330578, -0.309880, 1.177036>
    }
  }
  material {
    Grass
  }
  scale -92.787514
  rotate <-93.322083, -0.274216, 89.094185>
  translate  <-2426.242757, -542.831294, -483.379582>
}
#declare plant05 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.951083, -1.671816>, <-0.033791, 0.767503, -2.160018>, <-0.034769, 0.522729, -2.810954>, <-0.035502, 0.339148, -3.299156>, 
      <0.135537, 0.993031, -1.482668>, <0.134804, 0.809450, -1.970870>, <0.109766, 0.578979, -2.683006>, <0.109033, 0.395398, -3.171208>, 
      <0.360331, 1.048961, -1.230470>, <0.351574, 1.016451, -1.804908>, <0.532678, 0.641720, -2.527058>, <0.399880, 0.464847, -3.058277>, 
      <0.528926, 1.090909, -1.041322>, <0.520169, 1.058399, -1.615760>, <0.579079, 0.703521, -2.341444>, <0.446281, 0.526648, -2.872663>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.951083, -1.671816>, <-0.191736, 0.993031, -1.482668>, <-0.403306, 1.048961, -1.230470>, <-0.561984, 1.090909, -1.041322>, 
      <-0.033791, 0.767503, -2.160018>, <-0.192469, 0.809450, -1.970870>, <-0.394508, 1.016297, -1.809877>, <-0.553186, 1.058245, -1.620729>, 
      <-0.034769, 0.522729, -2.810954>, <-0.162961, 0.578979, -2.687965>, <-0.547931, 0.648192, -2.524148>, <-0.588184, 0.705669, -2.351522>, 
      <-0.035502, 0.339148, -3.299156>, <-0.163694, 0.395398, -3.176167>, <-0.422557, 0.469171, -3.061818>, <-0.462810, 0.526648, -2.889192>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.642428, -0.056905>, <-0.033058, 0.735025, -0.541378>, <-0.033058, 0.858487, -1.187343>, <-0.033058, 0.951083, -1.671816>, 
      <0.125620, 0.662923, 0.074216>, <0.125620, 0.755519, -0.410257>, <0.135537, 0.900434, -0.998194>, <0.135537, 0.993031, -1.482668>, 
      <0.337189, 0.690249, 0.249044>, <0.370476, 0.925327, -0.123236>, <0.367050, 1.073908, -0.789682>, <0.360331, 1.048961, -1.230470>, 
      <0.495867, 0.710744, 0.380165>, <0.529153, 0.945821, 0.007884>, <0.535645, 1.115856, -0.600534>, <0.528926, 1.090909, -1.041322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.642428, -0.056905>, <-0.176859, 0.662923, 0.073068>, <-0.368595, 0.690249, 0.246366>, <-0.512396, 0.710744, 0.376339>, 
      <-0.033058, 0.735025, -0.541378>, <-0.176859, 0.755519, -0.411405>, <-0.404902, 0.922913, -0.126000>, <-0.548704, 0.943407, 0.003973>, 
      <-0.033058, 0.858487, -1.187343>, <-0.191736, 0.900434, -0.998194>, <-0.409985, 1.073757, -0.790643>, <-0.568663, 1.115705, -0.601495>, 
      <-0.033058, 0.951083, -1.671816>, <-0.191736, 0.993031, -1.482668>, <-0.403306, 1.048961, -1.230470>, <-0.561984, 1.090909, -1.041322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.330578, -0.309880, 1.177036>, <0.216529, -0.287468, 1.066917>, <0.064463, -0.257586, 0.920092>, <-0.049587, -0.235174, 0.809974>, 
      <0.330578, -0.309880, 1.177036>, <0.124075, -0.840169, 1.300007>, <0.079339, -0.863118, 1.166196>, <-0.034711, -0.840707, 1.056078>, 
      <0.330578, -0.309880, 1.177036>, <0.124075, -0.840169, 1.300007>, <0.084297, -1.064962, 1.248231>, <-0.014876, -1.648083, 1.384217>, 
      <0.330578, -0.309880, 1.177036>, <0.238124, -0.862581, 1.410126>, <0.099173, -1.670495, 1.494335>, <0.000000, -2.253616, 1.630321>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.330578, -0.309880, 1.177036>, <0.216529, -0.287468, 1.066917>, <0.064463, -0.257586, 0.920092>, <-0.049587, -0.235174, 0.809974>, 
      <0.390233, 0.046745, 1.026637>, <0.276183, 0.069156, 0.916518>, <0.069421, 0.005695, 0.660029>, <-0.044628, 0.028107, 0.549910>, 
      <0.466345, 0.502251, 0.710345>, <0.307667, 0.481756, 0.579224>, <0.120661, 0.399642, 0.334280>, <-0.038017, 0.379148, 0.203159>, 
      <0.495867, 0.710744, 0.380165>, <0.337189, 0.690249, 0.249044>, <0.125620, 0.662923, 0.074216>, <-0.033058, 0.642428, -0.056905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.250325, -0.845955, 1.399273>, <-0.104132, -1.663344, 1.489950>, <0.000000, -2.253616, 1.630321>, 
      <-0.347107, -0.286043, 1.162420>, <-0.161069, -0.830695, 1.293540>, <-0.119008, -1.057811, 1.243846>, <-0.014876, -1.648083, 1.384217>, 
      <-0.347107, -0.286043, 1.162420>, <-0.161069, -0.830695, 1.293540>, <-0.123967, -0.855967, 1.161812>, <-0.034711, -0.840707, 1.056078>, 
      <-0.347107, -0.286043, 1.162420>, <-0.257851, -0.270782, 1.056686>, <-0.138843, -0.250435, 0.915707>, <-0.049587, -0.235174, 0.809974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.407485, 0.063263, 1.014656>, <-0.480747, 0.507931, 0.700931>, <-0.512396, 0.710744, 0.376339>, 
      <-0.257851, -0.270782, 1.056686>, <-0.318229, 0.078524, 0.908922>, <-0.336945, 0.487436, 0.570958>, <-0.368595, 0.690249, 0.246366>, 
      <-0.138843, -0.250435, 0.915707>, <-0.133884, 0.012846, 0.655644>, <-0.181818, 0.399642, 0.333132>, <-0.176859, 0.662923, 0.073068>, 
      <-0.049587, -0.235174, 0.809974>, <-0.044628, 0.028107, 0.549910>, <-0.038017, 0.379148, 0.203159>, <-0.033058, 0.642428, -0.056905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.257851, -0.270782, 1.056686>, <-0.138843, -0.250435, 0.915707>, <-0.049587, -0.235174, 0.809974>, 
      <-0.250325, -0.845955, 1.399273>, <-0.161069, -0.830695, 1.293540>, <-0.024794, -0.272847, 1.025826>, <0.064463, -0.257586, 0.920092>, 
      <-0.104132, -1.663344, 1.489950>, <-0.004959, -1.080223, 1.353965>, <0.124075, -0.840169, 1.300007>, <0.216529, -0.287468, 1.066917>, 
      <0.000000, -2.253616, 1.630321>, <0.099173, -1.670495, 1.494335>, <0.238124, -0.862581, 1.410126>, <0.330578, -0.309880, 1.177036>
    }
  }
  material {
    Grass
  }
  scale -92.787514
  rotate <-93.322083, -0.274216, -116.251419>
  translate  <-2797.466218, -433.180938, -483.379582>
}
#declare plant06 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.951083, -1.671816>, <-0.033791, 0.767503, -2.160018>, <-0.034769, 0.522729, -2.810954>, <-0.035502, 0.339148, -3.299156>, 
      <0.135537, 0.993031, -1.482668>, <0.134804, 0.809450, -1.970870>, <0.109766, 0.578979, -2.683006>, <0.109033, 0.395398, -3.171208>, 
      <0.360331, 1.048961, -1.230470>, <0.351574, 1.016451, -1.804908>, <0.532678, 0.641720, -2.527058>, <0.399880, 0.464847, -3.058277>, 
      <0.528926, 1.090909, -1.041322>, <0.520169, 1.058399, -1.615760>, <0.579079, 0.703521, -2.341444>, <0.446281, 0.526648, -2.872663>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.951083, -1.671816>, <-0.191736, 0.993031, -1.482668>, <-0.403306, 1.048961, -1.230470>, <-0.561984, 1.090909, -1.041322>, 
      <-0.033791, 0.767503, -2.160018>, <-0.192469, 0.809450, -1.970870>, <-0.394508, 1.016297, -1.809877>, <-0.553186, 1.058245, -1.620729>, 
      <-0.034769, 0.522729, -2.810954>, <-0.162961, 0.578979, -2.687965>, <-0.547931, 0.648192, -2.524148>, <-0.588184, 0.705669, -2.351522>, 
      <-0.035502, 0.339148, -3.299156>, <-0.163694, 0.395398, -3.176167>, <-0.422557, 0.469171, -3.061818>, <-0.462810, 0.526648, -2.889192>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.642428, -0.056905>, <-0.033058, 0.735025, -0.541378>, <-0.033058, 0.858487, -1.187343>, <-0.033058, 0.951083, -1.671816>, 
      <0.125620, 0.662923, 0.074216>, <0.125620, 0.755519, -0.410257>, <0.135537, 0.900434, -0.998194>, <0.135537, 0.993031, -1.482668>, 
      <0.337189, 0.690249, 0.249044>, <0.370476, 0.925327, -0.123236>, <0.367050, 1.073908, -0.789682>, <0.360331, 1.048961, -1.230470>, 
      <0.495867, 0.710744, 0.380165>, <0.529153, 0.945821, 0.007884>, <0.535645, 1.115856, -0.600534>, <0.528926, 1.090909, -1.041322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033058, 0.642428, -0.056905>, <-0.176859, 0.662923, 0.073068>, <-0.368595, 0.690249, 0.246366>, <-0.512396, 0.710744, 0.376339>, 
      <-0.033058, 0.735025, -0.541378>, <-0.176859, 0.755519, -0.411405>, <-0.404902, 0.922913, -0.126000>, <-0.548704, 0.943407, 0.003973>, 
      <-0.033058, 0.858487, -1.187343>, <-0.191736, 0.900434, -0.998194>, <-0.409985, 1.073757, -0.790643>, <-0.568663, 1.115705, -0.601495>, 
      <-0.033058, 0.951083, -1.671816>, <-0.191736, 0.993031, -1.482668>, <-0.403306, 1.048961, -1.230470>, <-0.561984, 1.090909, -1.041322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.330578, -0.309880, 1.177036>, <0.216529, -0.287468, 1.066917>, <0.064463, -0.257586, 0.920092>, <-0.049587, -0.235174, 0.809974>, 
      <0.330578, -0.309880, 1.177036>, <0.124075, -0.840169, 1.300007>, <0.079339, -0.863118, 1.166196>, <-0.034711, -0.840707, 1.056078>, 
      <0.330578, -0.309880, 1.177036>, <0.124075, -0.840169, 1.300007>, <0.084297, -1.064962, 1.248231>, <-0.014876, -1.648083, 1.384217>, 
      <0.330578, -0.309880, 1.177036>, <0.238124, -0.862581, 1.410126>, <0.099173, -1.670495, 1.494335>, <0.000000, -2.253616, 1.630321>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.330578, -0.309880, 1.177036>, <0.216529, -0.287468, 1.066917>, <0.064463, -0.257586, 0.920092>, <-0.049587, -0.235174, 0.809974>, 
      <0.390233, 0.046745, 1.026637>, <0.276183, 0.069156, 0.916518>, <0.069421, 0.005695, 0.660029>, <-0.044628, 0.028107, 0.549910>, 
      <0.466345, 0.502251, 0.710345>, <0.307667, 0.481756, 0.579224>, <0.120661, 0.399642, 0.334280>, <-0.038017, 0.379148, 0.203159>, 
      <0.495867, 0.710744, 0.380165>, <0.337189, 0.690249, 0.249044>, <0.125620, 0.662923, 0.074216>, <-0.033058, 0.642428, -0.056905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.250325, -0.845955, 1.399273>, <-0.104132, -1.663344, 1.489950>, <0.000000, -2.253616, 1.630321>, 
      <-0.347107, -0.286043, 1.162420>, <-0.161069, -0.830695, 1.293540>, <-0.119008, -1.057811, 1.243846>, <-0.014876, -1.648083, 1.384217>, 
      <-0.347107, -0.286043, 1.162420>, <-0.161069, -0.830695, 1.293540>, <-0.123967, -0.855967, 1.161812>, <-0.034711, -0.840707, 1.056078>, 
      <-0.347107, -0.286043, 1.162420>, <-0.257851, -0.270782, 1.056686>, <-0.138843, -0.250435, 0.915707>, <-0.049587, -0.235174, 0.809974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.407485, 0.063263, 1.014656>, <-0.480747, 0.507931, 0.700931>, <-0.512396, 0.710744, 0.376339>, 
      <-0.257851, -0.270782, 1.056686>, <-0.318229, 0.078524, 0.908922>, <-0.336945, 0.487436, 0.570958>, <-0.368595, 0.690249, 0.246366>, 
      <-0.138843, -0.250435, 0.915707>, <-0.133884, 0.012846, 0.655644>, <-0.181818, 0.399642, 0.333132>, <-0.176859, 0.662923, 0.073068>, 
      <-0.049587, -0.235174, 0.809974>, <-0.044628, 0.028107, 0.549910>, <-0.038017, 0.379148, 0.203159>, <-0.033058, 0.642428, -0.056905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347107, -0.286043, 1.162420>, <-0.257851, -0.270782, 1.056686>, <-0.138843, -0.250435, 0.915707>, <-0.049587, -0.235174, 0.809974>, 
      <-0.250325, -0.845955, 1.399273>, <-0.161069, -0.830695, 1.293540>, <-0.024794, -0.272847, 1.025826>, <0.064463, -0.257586, 0.920092>, 
      <-0.104132, -1.663344, 1.489950>, <-0.004959, -1.080223, 1.353965>, <0.124075, -0.840169, 1.300007>, <0.216529, -0.287468, 1.066917>, 
      <0.000000, -2.253616, 1.630321>, <0.099173, -1.670495, 1.494335>, <0.238124, -0.862581, 1.410126>, <0.330578, -0.309880, 1.177036>
    }
  }
  material {
    Grass
  }
  scale <-89.772652, -121.405602, -89.841217>
  rotate <-91.590149, -2.612161, -57.968845>
  translate  <-2791.056281, -659.219685, -494.19479>
}
union { // plante
  object { plant01 }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      body_texture
    }
    scale <196.635269, 180.473801, 322.124786>
    translate  <-2598.018516, -506.781473, -783.078157>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      BlackPine
    }
    scale <161.97847, 140.682648, 322.124786>
    translate  <-2598.018516, -506.781473, -783.078157>
  }
  object { plant02 }
  object { plant03 }
  object { plant04 }
  object { plant05 }
  object { plant06 }
}


union { // element
  box { // elem01
    <-1, -1, -1>, <1, 1, 1>
    material {
      S_Wood1
    }
    scale <-90.280975, -405.032837, -4.715717>
    rotate -180.0*z
    translate  <-21.894204, -378.799687, -7.348778>
  }
  box { // elem02
    <-1, -1, -1>, <1, 1, 1>
    material {
      S_Wood1
    }
    scale <90.0, 1.814523, 320.0>
    translate  <-22.210064, -20.879442, -332.128284>
  }
  box { // elem03
    <-1, -1, -1>, <1, 1, 1>
    material {
      S_Wood1
    }
    scale <400.0, 1.814523, 320.0>
    rotate -90.0*z
    translate  <65.916154, -415.0, -332.128284>
  }
}


union { // rideaux
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.258718, 0.311822, 5.436107>, <9.271438, 0.214865, 3.794156>, <9.288396, 0.085589, 1.604890>, <9.301115, -0.011367, -0.037061>, 
      <9.572731, 0.309381, 5.436107>, <9.585450, 0.212425, 3.794156>, <9.539430, 0.078011, 1.604890>, <9.552149, -0.018946, -0.037061>, 
      <9.911589, -0.020798, 5.436107>, <9.888947, -0.032856, 3.794156>, <9.894119, -0.133832, 1.604890>, <9.871478, -0.145891, -0.037061>, 
      <10.191390, -0.163350, 5.436107>, <10.168749, -0.175408, 3.794156>, <10.138560, -0.191485, 1.604890>, <10.115919, -0.203544, -0.037061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.645703, -0.151337, 5.436107>, <8.649704, -0.153804, 3.794156>, <8.655037, -0.157093, 1.604890>, <8.659038, -0.159559, -0.037061>, 
      <8.876197, -0.151673, 5.436107>, <8.880198, -0.154139, 3.794156>, <8.850186, -0.188673, 1.604890>, <8.854186, -0.191140, -0.037061>, 
      <9.028232, 0.313613, 5.436107>, <9.040950, 0.216656, 3.794156>, <9.090798, 0.091555, 1.604890>, <9.103518, -0.005402, -0.037061>, 
      <9.258718, 0.311822, 5.436107>, <9.271438, 0.214865, 3.794156>, <9.288396, 0.085589, 1.604890>, <9.301115, -0.011367, -0.037061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.068764, 0.313553, 5.436107>, <8.065594, 0.276419, 3.794156>, <8.061370, 0.226907, 1.604890>, <8.058201, 0.189773, -0.037061>, 
      <8.290671, 0.300696, 5.436107>, <8.287502, 0.263562, 3.794156>, <8.269282, 0.211220, 1.604890>, <8.266112, 0.174086, -0.037061>, 
      <8.423424, -0.151014, 5.436107>, <8.427425, -0.153480, 3.794156>, <8.449212, -0.123784, 1.604890>, <8.453213, -0.126251, -0.037061>, 
      <8.645703, -0.151337, 5.436107>, <8.649704, -0.153804, 3.794156>, <8.655037, -0.157093, 1.604890>, <8.659038, -0.159559, -0.037061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.365077, -0.077137, 5.436107>, <7.380310, -0.073724, 3.794156>, <7.400622, -0.069174, 1.604890>, <7.415855, -0.065761, -0.037061>, 
      <7.603054, -0.036271, 5.436107>, <7.618287, -0.032858, 3.794156>, <7.606202, -0.041818, 1.604890>, <7.621435, -0.038405, -0.037061>, 
      <7.827707, 0.327520, 5.436107>, <7.824538, 0.290386, 3.794156>, <7.854566, 0.242511, 1.604890>, <7.851397, 0.205376, -0.037061>, 
      <8.068764, 0.313553, 5.436107>, <8.065594, 0.276419, 3.794156>, <8.061370, 0.226907, 1.604890>, <8.058201, 0.189773, -0.037061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.922054, 0.116637, 5.436107>, <6.904636, 0.090904, 3.794156>, <6.881412, 0.056594, 1.604890>, <6.863994, 0.030862, -0.037061>, 
      <7.067070, 0.120367, 5.436107>, <7.049652, 0.094635, 3.794156>, <7.047255, 0.083900, 1.604890>, <7.029838, 0.058168, -0.037061>, 
      <7.222105, -0.101688, 5.436107>, <7.237338, -0.098276, 3.794156>, <7.234014, -0.091344, 1.604890>, <7.249247, -0.087931, -0.037061>, 
      <7.365077, -0.077137, 5.436107>, <7.380310, -0.073724, 3.794156>, <7.400622, -0.069174, 1.604890>, <7.415855, -0.065761, -0.037061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.434706, -0.101071, 5.436107>, <6.411232, -0.142806, 3.794156>, <6.379933, -0.198453, 1.604890>, <6.356459, -0.240189, -0.037061>, 
      <6.593620, -0.081385, 5.436107>, <6.570146, -0.123121, 3.794156>, <6.548885, -0.163088, 1.604890>, <6.525411, -0.204823, -0.037061>, 
      <6.761977, 0.112519, 5.436107>, <6.744560, 0.086786, 3.794156>, <6.711091, 0.028552, 1.604890>, <6.693674, 0.002819, -0.037061>, 
      <6.922054, 0.116637, 5.436107>, <6.904636, 0.090904, 3.794156>, <6.881412, 0.056594, 1.604890>, <6.863994, 0.030862, -0.037061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.925841, -0.006769, 5.436107>, <5.896045, -0.060630, 3.794156>, <5.856316, -0.132445, 1.604890>, <5.826520, -0.186307, -0.037061>, 
      <6.078963, 0.018903, 5.436107>, <6.049166, -0.034958, 3.794156>, <6.014828, -0.112433, 1.608071>, <5.985031, -0.166294, -0.033879>, 
      <6.280625, -0.120158, 5.436107>, <6.257151, -0.161893, 3.794156>, <6.223522, -0.231194, 1.604890>, <6.200048, -0.272929, -0.037061>, 
      <6.434706, -0.101071, 5.436107>, <6.411232, -0.142806, 3.794156>, <6.379933, -0.198453, 1.604890>, <6.356459, -0.240189, -0.037061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.460128, -0.264464, 5.436107>, <5.360667, -0.303688, 3.786764>, <5.228052, -0.355988, 1.587640>, <5.128590, -0.395213, -0.061703>, 
      <5.619286, -0.252426, 5.440617>, <5.519825, -0.291651, 3.791274>, <5.446080, -0.371640, 1.581281>, <5.346619, -0.410865, -0.068062>, 
      <5.768362, -0.033171, 5.436107>, <5.738566, -0.087032, 3.794156>, <5.639400, -0.159832, 1.600536>, <5.609603, -0.213694, -0.041414>, 
      <5.925841, -0.006769, 5.436107>, <5.896045, -0.060630, 3.794156>, <5.856316, -0.132445, 1.604890>, <5.826520, -0.186307, -0.037061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.763310, -0.094692, 5.403164>, <4.701072, -0.094811, 3.782215>, <4.618088, -0.094969, 1.620949>, <4.555850, -0.095088, 0.000000>, 
      <4.971610, -0.149187, 5.408896>, <4.909372, -0.149306, 3.787947>, <4.810244, -0.124564, 1.607830>, <4.748007, -0.124683, -0.013119>, 
      <5.245440, -0.280701, 5.430023>, <5.145978, -0.319926, 3.780680>, <5.033769, -0.342041, 1.593306>, <4.934308, -0.381266, -0.056037>, 
      <5.460128, -0.264464, 5.436107>, <5.360667, -0.303688, 3.786764>, <5.228052, -0.355988, 1.587640>, <5.128590, -0.395213, -0.061703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.263013, 0.048722, 5.403164>, <4.251549, -0.042700, 3.782215>, <4.236265, -0.164595, 1.620949>, <4.224801, -0.256016, 0.000000>, 
      <4.414544, 0.086355, 5.403164>, <4.403080, -0.005067, 3.782215>, <4.329884, -0.106032, 1.620949>, <4.318421, -0.197454, 0.000000>, 
      <4.612313, -0.055189, 5.399009>, <4.550075, -0.055308, 3.778060>, <4.509195, -0.078198, 1.628384>, <4.446957, -0.078317, 0.007434>, 
      <4.763310, -0.094692, 5.403164>, <4.701072, -0.094811, 3.782215>, <4.618088, -0.094969, 1.620949>, <4.555850, -0.095088, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.924905, -0.302911, 5.403164>, <3.882644, -0.385404, 3.782215>, <3.826296, -0.495395, 1.620949>, <3.784036, -0.577888, 0.000000>, 
      <4.051309, -0.229163, 5.403164>, <4.009048, -0.311657, 3.782215>, <3.983987, -0.451320, 1.620949>, <3.941726, -0.533814, 0.000000>, 
      <4.120983, 0.013449, 5.403164>, <4.109520, -0.077973, 3.782215>, <4.097452, -0.251428, 1.620949>, <4.085988, -0.342849, 0.000000>, 
      <4.263013, 0.048722, 5.403164>, <4.251549, -0.042700, 3.782215>, <4.236265, -0.164595, 1.620949>, <4.224801, -0.256016, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.567590, -0.357008, 5.403164>, <3.501538, -0.400280, 3.782215>, <3.413468, -0.457976, 1.620949>, <3.347416, -0.501248, 0.000000>, 
      <3.671026, -0.389488, 5.403164>, <3.604974, -0.432760, 3.782215>, <3.534666, -0.512720, 1.620949>, <3.468614, -0.555992, 0.000000>, 
      <3.831261, -0.357546, 5.403164>, <3.789001, -0.440039, 3.782215>, <3.698217, -0.531194, 1.620949>, <3.655956, -0.613687, 0.000000>, 
      <3.924905, -0.302911, 5.403164>, <3.882644, -0.385404, 3.782215>, <3.826296, -0.495395, 1.620949>, <3.784036, -0.577888, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.106570, -0.045949, 5.403164>, <3.073190, -0.098654, 3.782215>, <3.028683, -0.168926, 1.620949>, <2.995303, -0.221630, 0.000000>, 
      <3.246665, -0.136559, 5.403164>, <3.213285, -0.189263, 3.782215>, <3.133552, -0.253766, 1.620949>, <3.100172, -0.306470, 0.000000>, 
      <3.408410, -0.307025, 5.403164>, <3.342357, -0.350297, 3.782215>, <3.290537, -0.402450, 1.620949>, <3.224484, -0.445722, 0.000000>, 
      <3.567590, -0.357008, 5.403164>, <3.501538, -0.400280, 3.782215>, <3.413468, -0.457976, 1.620949>, <3.347416, -0.501248, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.659184, 0.230527, 5.403164>, <2.673674, 0.166308, 3.782215>, <2.692995, 0.080682, 1.620949>, <2.707486, 0.016463, 0.000000>, 
      <2.813455, 0.197454, 5.403164>, <2.827945, 0.133235, 3.782215>, <2.804341, 0.068049, 1.620949>, <2.818831, 0.003830, 0.000000>, 
      <2.974088, 0.039737, 5.403164>, <2.940708, -0.012968, 3.782215>, <2.941563, -0.098445, 1.620949>, <2.908183, -0.151149, 0.000000>, 
      <3.106570, -0.045949, 5.403164>, <3.073190, -0.098654, 3.782215>, <3.028683, -0.168926, 1.620949>, <2.995303, -0.221630, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.365943, 0.112830, 5.403164>, <2.351934, 0.035503, 3.782215>, <2.333256, -0.067600, 1.620949>, <2.319247, -0.144927, 0.000000>, 
      <2.455575, 0.143684, 5.403164>, <2.441566, 0.066357, 3.782215>, <2.444983, -0.009060, 1.620949>, <2.430974, -0.086388, 0.000000>, 
      <2.566496, 0.250398, 5.403164>, <2.580986, 0.186179, 3.782215>, <2.567665, 0.094902, 1.620949>, <2.582156, 0.030682, 0.000000>, 
      <2.659184, 0.230527, 5.403164>, <2.673674, 0.166308, 3.782215>, <2.692995, 0.080682, 1.620949>, <2.707486, 0.016463, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.765358, -0.077154, 5.403164>, <1.786289, -0.186191, 3.782215>, <1.814198, -0.331575, 1.620949>, <1.835129, -0.440612, 0.000000>, 
      <1.941793, -0.009461, 5.403164>, <1.962724, -0.118499, 3.782215>, <1.982390, -0.305626, 1.620949>, <2.003321, -0.414664, 0.000000>, 
      <2.187258, 0.051321, 5.403164>, <2.173249, -0.026006, 3.782215>, <2.182512, -0.146583, 1.620949>, <2.168503, -0.223910, 0.000000>, 
      <2.365943, 0.112830, 5.403164>, <2.351934, 0.035503, 3.782215>, <2.333256, -0.067600, 1.620949>, <2.319247, -0.144927, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.174599, -0.344253, 5.403164>, <1.199293, -0.333624, 3.782215>, <1.232219, -0.319453, 1.620949>, <1.256913, -0.308824, 0.000000>, 
      <1.366451, -0.376240, 5.403164>, <1.391145, -0.365611, 3.782215>, <1.400229, -0.377586, 1.627754>, <1.424923, -0.366957, 0.006804>, 
      <1.583764, -0.146826, 5.403164>, <1.604696, -0.255863, 3.782215>, <1.638365, -0.358702, 1.620949>, <1.659296, -0.467740, 0.000000>, 
      <1.765358, -0.077154, 5.403164>, <1.786289, -0.186191, 3.782215>, <1.814198, -0.331575, 1.620949>, <1.835129, -0.440612, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.665635, 0.106198, 5.403164>, <0.652729, 0.068016, 3.767482>, <0.635521, 0.017108, 1.586574>, <0.622615, -0.021074, -0.049107>, 
      <0.868457, 0.085251, 5.403164>, <0.855551, 0.047070, 3.767482>, <0.825810, -0.069218, 1.601307>, <0.812904, -0.107399, -0.034375>, 
      <0.973474, -0.310721, 5.403164>, <0.998169, -0.300092, 3.782215>, <1.034405, -0.251008, 1.612938>, <1.059099, -0.240379, -0.008011>, 
      <1.174599, -0.344253, 5.403164>, <1.199293, -0.333624, 3.782215>, <1.232219, -0.319453, 1.620949>, <1.256913, -0.308824, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.053273, -0.228446, 5.403164>, <0.034558, -0.285621, 3.782215>, <0.009603, -0.361856, 1.620949>, <-0.009112, -0.419031, 0.000000>, 
      <0.253360, -0.166860, 5.403164>, <0.234645, -0.224035, 3.782215>, <0.232842, -0.340787, 1.610548>, <0.214126, -0.397963, -0.010401>, 
      <0.457392, 0.127705, 5.403164>, <0.444486, 0.089523, 3.767482>, <0.446003, -0.102280, 1.601307>, <0.433097, -0.140461, -0.034375>, 
      <0.665635, 0.106198, 5.403164>, <0.652729, 0.068016, 3.767482>, <0.635521, 0.017108, 1.586574>, <0.622615, -0.021074, -0.049107>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.619580, -0.289386, 5.403164>, <-0.563107, -0.238733, 3.782215>, <-0.487809, -0.171196, 1.620949>, <-0.431336, -0.120543, 0.000000>, 
      <-0.422814, -0.338000, 5.403164>, <-0.366341, -0.287347, 3.782215>, <-0.350377, -0.243138, 1.620949>, <-0.293904, -0.192485, 0.000000>, 
      <-0.140441, -0.288070, 5.403164>, <-0.159156, -0.345246, 3.782215>, <-0.144667, -0.376415, 1.628137>, <-0.163383, -0.433591, 0.007188>, 
      <0.053273, -0.228446, 5.403164>, <0.034558, -0.285621, 3.782215>, <0.009603, -0.361856, 1.620949>, <-0.009112, -0.419031, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.092931, 0.054740, 5.403164>, <-1.095531, 0.084175, 3.782215>, <-1.098998, 0.123422, 1.620949>, <-1.101598, 0.152857, 0.000000>, 
      <-0.925296, 0.003566, 5.393003>, <-0.927896, 0.033001, 3.772054>, <-0.889200, 0.067345, 1.620949>, <-0.891800, 0.096780, 0.000000>, 
      <-0.790022, -0.247276, 5.403164>, <-0.733548, -0.196623, 3.782215>, <-0.680206, -0.070481, 1.620949>, <-0.623733, -0.019828, 0.000000>, 
      <-0.619580, -0.289386, 5.403164>, <-0.563107, -0.238733, 3.782215>, <-0.487809, -0.171196, 1.620949>, <-0.431336, -0.120543, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.633668, 0.020185, 5.464630>, <-1.643061, 0.076888, 3.825241>, <-1.655586, 0.152492, 1.639389>, <-1.664979, 0.209195, 0.000000>, 
      <-1.470504, 0.032042, 5.464630>, <-1.479897, 0.088745, 3.825241>, <-1.488046, 0.180454, 1.639389>, <-1.497439, 0.237157, 0.000000>, 
      <-1.249135, 0.102424, 5.412632>, <-1.251735, 0.131859, 3.791682>, <-1.263095, 0.167283, 1.620949>, <-1.265695, 0.196718, 0.000000>, 
      <-1.092931, 0.054740, 5.403164>, <-1.095531, 0.084175, 3.782215>, <-1.098998, 0.123422, 1.620949>, <-1.101598, 0.152857, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.033751, -0.013630, 5.403164>, <-2.048042, -0.012742, 3.782215>, <-2.067096, -0.011557, 1.620949>, <-2.081386, -0.010669, 0.000000>, 
      <-1.913698, 0.005110, 5.412389>, <-1.927989, 0.005998, 3.791440>, <-1.951573, 0.069749, 1.620949>, <-1.965864, 0.070638, 0.000000>, 
      <-1.755203, 0.011353, 5.464630>, <-1.764597, 0.068056, 3.825241>, <-1.794925, 0.129236, 1.639389>, <-1.804318, 0.185939, 0.000000>, 
      <-1.633668, 0.020185, 5.464630>, <-1.643061, 0.076888, 3.825241>, <-1.655586, 0.152492, 1.639389>, <-1.664979, 0.209195, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.433597, -0.104682, 5.403164>, <-2.452856, -0.186364, 3.782215>, <-2.478535, -0.295274, 1.620949>, <-2.497794, -0.376956, 0.000000>, 
      <-2.312031, -0.085794, 5.403164>, <-2.331290, -0.167477, 3.782215>, <-2.322179, -0.238412, 1.620949>, <-2.341438, -0.320095, 0.000000>, 
      <-2.154955, -0.032550, 5.393851>, <-2.169245, -0.031661, 3.772902>, <-2.203151, -0.107315, 1.620949>, <-2.217441, -0.106427, 0.000000>, 
      <-2.033751, -0.013630, 5.403164>, <-2.048042, -0.012742, 3.782215>, <-2.067096, -0.011557, 1.620949>, <-2.081386, -0.010669, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.851094, -0.140619, 5.403164>, <-2.875541, -0.194500, 3.782215>, <-2.908137, -0.266341, 1.620949>, <-2.932584, -0.320222, 0.000000>, 
      <-2.731251, -0.178584, 5.403164>, <-2.755698, -0.232465, 3.782215>, <-2.797054, -0.336797, 1.620949>, <-2.821501, -0.390678, 0.000000>, 
      <-2.557819, -0.123982, 5.403164>, <-2.577078, -0.205664, 3.782215>, <-2.602157, -0.340231, 1.620949>, <-2.621416, -0.421914, 0.000000>, 
      <-2.433597, -0.104682, 5.403164>, <-2.452856, -0.186364, 3.782215>, <-2.478535, -0.295274, 1.620949>, <-2.497794, -0.376956, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.162154, 0.126115, 5.403164>, <-3.163871, 0.102695, 3.782215>, <-3.166159, 0.071468, 1.620949>, <-3.167876, 0.048048, 0.000000>, 
      <-3.041230, 0.104003, 5.403164>, <-3.042947, 0.080582, 3.782215>, <-3.060045, -0.005528, 1.620949>, <-3.061761, -0.028948, 0.000000>, 
      <-2.968283, -0.103495, 5.403164>, <-2.992730, -0.157376, 3.782215>, <-3.018851, -0.196120, 1.620949>, <-3.043298, -0.250001, 0.000000>, 
      <-2.851094, -0.140619, 5.403164>, <-2.875541, -0.194500, 3.782215>, <-2.908137, -0.266341, 1.620949>, <-2.932584, -0.320222, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.587052, -0.006040, 5.403164>, <-3.593757, 0.047032, 3.782215>, <-3.602697, 0.117796, 1.620949>, <-3.609402, 0.170868, 0.000000>, 
      <-3.462316, 0.041511, 5.403164>, <-3.469021, 0.094583, 3.782215>, <-3.465213, 0.116852, 1.620949>, <-3.471918, 0.169924, 0.000000>, 
      <-3.293469, 0.150128, 5.403164>, <-3.295186, 0.126707, 3.782215>, <-3.277439, 0.152211, 1.620949>, <-3.279156, 0.128791, 0.000000>, 
      <-3.162154, 0.126115, 5.403164>, <-3.163871, 0.102695, 3.782215>, <-3.166159, 0.071468, 1.620949>, <-3.167876, 0.048048, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.946565, -0.172908, 5.403164>, <-3.984624, -0.104756, 3.782215>, <-4.035370, -0.013886, 1.620949>, <-4.073429, 0.054266, 0.000000>, 
      <-3.837154, -0.126349, 5.403164>, <-3.875214, -0.058196, 3.782215>, <-3.911832, 0.059195, 1.620949>, <-3.949891, 0.127347, 0.000000>, 
      <-3.698158, -0.048395, 5.403164>, <-3.704864, 0.004678, 3.782215>, <-3.746230, 0.118781, 1.620949>, <-3.752934, 0.171854, 0.000000>, 
      <-3.587052, -0.006040, 5.403164>, <-3.593757, 0.047032, 3.782215>, <-3.602697, 0.117796, 1.620949>, <-3.609402, 0.170868, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.284673, -0.302911, 5.403164>, <-4.326934, -0.305617, 3.782215>, <-4.383281, -0.309226, 1.620949>, <-4.425542, -0.311932, 0.000000>, 
      <-4.179076, -0.277243, 5.403164>, <-4.221337, -0.279949, 3.782215>, <-4.248938, -0.237256, 1.620949>, <-4.291199, -0.239963, 0.000000>, 
      <-4.046560, -0.215461, 5.403164>, <-4.084619, -0.147309, 3.782215>, <-4.166542, -0.091484, 1.620949>, <-4.204602, -0.023331, 0.000000>, 
      <-3.946565, -0.172908, 5.403164>, <-3.984624, -0.104756, 3.782215>, <-4.035370, -0.013886, 1.620949>, <-4.073429, 0.054266, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.703928, -0.357008, 5.403164>, <-4.751398, -0.360387, 3.782215>, <-4.814692, -0.364891, 1.620949>, <-4.862162, -0.368270, 0.000000>, 
      <-4.582934, -0.395001, 5.403164>, <-4.630404, -0.398380, 3.782215>, <-4.689623, -0.407326, 1.620949>, <-4.737093, -0.410704, 0.000000>, 
      <-4.407904, -0.332866, 5.403164>, <-4.450164, -0.335572, 3.782215>, <-4.499700, -0.371593, 1.620949>, <-4.541961, -0.374299, 0.000000>, 
      <-4.284673, -0.302911, 5.403164>, <-4.326934, -0.305617, 3.782215>, <-4.383281, -0.309226, 1.620949>, <-4.425542, -0.311932, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.103008, -0.045949, 5.403164>, <-5.136388, -0.045462, 3.782215>, <-5.180894, -0.044813, 1.620949>, <-5.214274, -0.044326, 0.000000>, 
      <-4.972426, -0.123347, 5.403164>, <-5.005806, -0.122860, 3.782215>, <-5.065499, -0.130176, 1.620949>, <-5.098878, -0.129689, 0.000000>, 
      <-4.848752, -0.311532, 5.403164>, <-4.896222, -0.314911, 3.782215>, <-4.950619, -0.318773, 1.620949>, <-4.998089, -0.322152, 0.000000>, 
      <-4.703928, -0.357008, 5.403164>, <-4.751398, -0.360387, 3.782215>, <-4.814692, -0.364891, 1.620949>, <-4.862162, -0.368270, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.470838, 0.097549, 5.403164>, <-5.480214, 0.099819, 3.782215>, <-5.492716, 0.102845, 1.620949>, <-5.502092, 0.105115, 0.000000>, 
      <-5.355021, 0.072720, 5.403164>, <-5.364397, 0.074989, 3.782215>, <-5.398211, 0.079730, 1.620949>, <-5.407588, 0.082000, 0.000000>, 
      <-5.204904, 0.014446, 5.403164>, <-5.238283, 0.014932, 3.782215>, <-5.259110, 0.013047, 1.620949>, <-5.292490, 0.013534, 0.000000>, 
      <-5.103008, -0.045949, 5.403164>, <-5.136388, -0.045462, 3.782215>, <-5.180894, -0.044813, 1.620949>, <-5.214274, -0.044326, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.843635, 0.112830, 5.403164>, <-5.857644, 0.115290, 3.782215>, <-5.876322, 0.118569, 1.620949>, <-5.890331, 0.121029, 0.000000>, 
      <-5.742194, 0.160144, 5.403164>, <-5.756203, 0.162604, 3.782215>, <-5.770030, 0.166429, 1.620949>, <-5.784040, 0.168888, 0.000000>, 
      <-5.580284, 0.121013, 5.403164>, <-5.589660, 0.123282, 3.782215>, <-5.605948, 0.130540, 1.620949>, <-5.615324, 0.132810, 0.000000>, 
      <-5.470838, 0.097549, 5.403164>, <-5.480214, 0.099819, 3.782215>, <-5.492716, 0.102845, 1.620949>, <-5.502092, 0.105115, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.320576, -0.298784, 5.403164>, <-6.350036, -0.301439, 3.782215>, <-6.389316, -0.304979, 1.620949>, <-6.418775, -0.307634, 0.000000>, 
      <-6.147676, -0.222454, 5.403164>, <-6.177135, -0.225109, 3.782215>, <-6.202571, -0.222537, 1.620949>, <-6.232030, -0.225191, 0.000000>, 
      <-6.014920, 0.032940, 5.403164>, <-6.028929, 0.035399, 3.782215>, <-6.062458, 0.034759, 1.620949>, <-6.076466, 0.037219, 0.000000>, 
      <-5.843635, 0.112830, 5.403164>, <-5.857644, 0.115290, 3.782215>, <-5.876322, 0.118569, 1.620949>, <-5.890331, 0.121029, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.778593, -0.299927, 5.403164>, <-6.804219, -0.302596, 3.782215>, <-6.838387, -0.306155, 1.620949>, <-6.864013, -0.308824, 0.000000>, 
      <-6.650978, -0.350864, 5.403164>, <-6.676604, -0.353533, 3.782215>, <-6.716937, -0.361756, 1.620949>, <-6.742563, -0.364425, 0.000000>, 
      <-6.446277, -0.354278, 5.403164>, <-6.475737, -0.356932, 3.782215>, <-6.511510, -0.358924, 1.620949>, <-6.540969, -0.361579, 0.000000>, 
      <-6.320576, -0.298784, 5.403164>, <-6.350036, -0.301439, 3.782215>, <-6.389316, -0.304979, 1.620949>, <-6.418775, -0.307634, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.272183, 0.081041, 5.403164>, <-7.275369, 0.083105, 3.782215>, <-7.279616, 0.085858, 1.620949>, <-7.282801, 0.087923, 0.000000>, 
      <-7.124106, -0.033250, 5.403164>, <-7.127292, -0.031185, 3.782215>, <-7.153979, -0.033166, 1.620949>, <-7.157165, -0.031101, 0.000000>, 
      <-6.952320, -0.230586, 5.403164>, <-6.977946, -0.233255, 3.782215>, <-6.995745, -0.234115, 1.620949>, <-7.021371, -0.236785, 0.000000>, 
      <-6.778593, -0.299927, 5.403164>, <-6.804219, -0.302596, 3.782215>, <-6.838387, -0.306155, 1.620949>, <-6.864013, -0.308824, 0.000000>
    }
  }
  material {
    rideau
  }
  scale <-195.264496, -264.357758, -332.949829>
  rotate 90.0*z
  translate  <-3379.311646, 1172.079426, 1184.950051>
}


union { // whiskey_Glass
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.549020, 0.203921>, <0.000000, -0.464594, 0.062851>, <0.000000, -0.170196, 0.143529>, <0.000000, -0.007843, 0.117647>, 
      <0.126061, -0.549020, 0.203921>, <0.126061, -0.464594, 0.062851>, <0.001801, -0.170196, 0.143529>, <0.001801, -0.007843, 0.117647>, 
      <0.299078, -0.477354, 0.203921>, <0.239380, -0.417656, 0.062851>, <0.119074, -0.121620, 0.143529>, <0.004273, -0.006819, 0.117647>, 
      <0.388216, -0.388216, 0.203921>, <0.328518, -0.328518, 0.062851>, <0.120347, -0.120347, 0.143529>, <0.005546, -0.005546, 0.117647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.388216, -0.388216, 0.203921>, <-0.328518, -0.328518, 0.062851>, <-0.120347, -0.120347, 0.143529>, <-0.005546, -0.005546, 0.117647>, 
      <-0.299078, -0.477354, 0.203921>, <-0.239379, -0.417656, 0.062851>, <-0.119073, -0.121620, 0.143529>, <-0.004273, -0.006819, 0.117647>, 
      <-0.126060, -0.549020, 0.203921>, <-0.126060, -0.464594, 0.062851>, <-0.001801, -0.170196, 0.143529>, <-0.001801, -0.007843, 0.117647>, 
      <0.000000, -0.549020, 0.203921>, <0.000000, -0.464594, 0.062851>, <0.000000, -0.170196, 0.143529>, <0.000000, -0.007843, 0.117647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.549020, 0.000000, 0.203921>, <-0.464594, 0.000000, 0.062851>, <-0.170196, 0.000000, 0.143529>, <-0.007843, 0.000000, 0.117647>, 
      <-0.549020, -0.126061, 0.203921>, <-0.464594, -0.126061, 0.062851>, <-0.170196, -0.001801, 0.143529>, <-0.007843, -0.001801, 0.117647>, 
      <-0.477354, -0.299078, 0.203921>, <-0.417656, -0.239380, 0.062851>, <-0.121620, -0.119074, 0.143529>, <-0.006819, -0.004273, 0.117647>, 
      <-0.388216, -0.388216, 0.203921>, <-0.328518, -0.328518, 0.062851>, <-0.120347, -0.120347, 0.143529>, <-0.005546, -0.005546, 0.117647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.388216, 0.388216, 0.203921>, <-0.328518, 0.328518, 0.062851>, <-0.120347, 0.120347, 0.143529>, <-0.005546, 0.005546, 0.117647>, 
      <-0.477354, 0.299078, 0.203921>, <-0.417656, 0.239380, 0.062851>, <-0.121620, 0.119073, 0.143529>, <-0.006819, 0.004273, 0.117647>, 
      <-0.549020, 0.126060, 0.203921>, <-0.464594, 0.126060, 0.062851>, <-0.170196, 0.001801, 0.143529>, <-0.007843, 0.001801, 0.117647>, 
      <-0.549020, 0.000000, 0.203921>, <-0.464594, 0.000000, 0.062851>, <-0.170196, 0.000000, 0.143529>, <-0.007843, 0.000000, 0.117647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.549020, 0.203921>, <0.000000, 0.464594, 0.062851>, <0.000000, 0.170196, 0.143529>, <0.000000, 0.007843, 0.117647>, 
      <-0.126061, 0.549020, 0.203921>, <-0.126060, 0.464594, 0.062851>, <-0.001801, 0.170196, 0.143529>, <-0.001801, 0.007843, 0.117647>, 
      <-0.299078, 0.477354, 0.203921>, <-0.239380, 0.417656, 0.062851>, <-0.119073, 0.121620, 0.143529>, <-0.004273, 0.006819, 0.117647>, 
      <-0.388216, 0.388216, 0.203921>, <-0.328518, 0.328518, 0.062851>, <-0.120347, 0.120347, 0.143529>, <-0.005546, 0.005546, 0.117647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.388216, 0.388216, 0.203921>, <0.328518, 0.328518, 0.062851>, <0.120347, 0.120347, 0.143529>, <0.005546, 0.005546, 0.117647>, 
      <0.299078, 0.477354, 0.203921>, <0.239380, 0.417656, 0.062851>, <0.119073, 0.121620, 0.143529>, <0.004273, 0.006819, 0.117647>, 
      <0.126060, 0.549020, 0.203921>, <0.126060, 0.464594, 0.062851>, <0.001801, 0.170196, 0.143529>, <0.001801, 0.007843, 0.117647>, 
      <0.000000, 0.549020, 0.203921>, <0.000000, 0.464594, 0.062851>, <0.000000, 0.170196, 0.143529>, <0.000000, 0.007843, 0.117647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.697842, 1.270588>, <0.000000, -0.650389, 0.950992>, <0.000000, -0.714941, 0.481164>, <0.000000, -0.549020, 0.203921>, 
      <0.160232, -0.697842, 1.270588>, <0.160232, -0.650389, 0.950992>, <0.126061, -0.714941, 0.481164>, <0.126061, -0.549020, 0.203921>, 
      <0.380148, -0.606749, 1.270588>, <0.346594, -0.573195, 0.950992>, <0.416402, -0.594678, 0.481164>, <0.299078, -0.477354, 0.203921>, 
      <0.493449, -0.493449, 1.270588>, <0.459894, -0.459894, 0.950992>, <0.505540, -0.505540, 0.481164>, <0.388216, -0.388216, 0.203921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.493449, -0.493449, 1.270588>, <-0.459894, -0.459894, 0.950992>, <-0.505540, -0.505540, 0.481164>, <-0.388216, -0.388216, 0.203921>, 
      <-0.380148, -0.606749, 1.270588>, <-0.346593, -0.573195, 0.950992>, <-0.416401, -0.594678, 0.481164>, <-0.299078, -0.477354, 0.203921>, 
      <-0.160231, -0.697842, 1.270588>, <-0.160231, -0.650389, 0.950992>, <-0.126060, -0.714941, 0.481164>, <-0.126060, -0.549020, 0.203921>, 
      <0.000000, -0.697842, 1.270588>, <0.000000, -0.650389, 0.950992>, <0.000000, -0.714941, 0.481164>, <0.000000, -0.549020, 0.203921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.697842, -0.000000, 1.270588>, <-0.650389, -0.000000, 0.950992>, <-0.714941, -0.000000, 0.481164>, <-0.549020, 0.000000, 0.203921>, 
      <-0.697842, -0.160232, 1.270588>, <-0.650389, -0.160232, 0.950992>, <-0.714941, -0.126061, 0.481164>, <-0.549020, -0.126061, 0.203921>, 
      <-0.606749, -0.380148, 1.270588>, <-0.573195, -0.346594, 0.950992>, <-0.594678, -0.416401, 0.481164>, <-0.477354, -0.299078, 0.203921>, 
      <-0.493449, -0.493449, 1.270588>, <-0.459894, -0.459894, 0.950992>, <-0.505540, -0.505540, 0.481164>, <-0.388216, -0.388216, 0.203921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.493449, 0.493449, 1.270588>, <-0.459894, 0.459894, 0.950992>, <-0.505540, 0.505540, 0.481164>, <-0.388216, 0.388216, 0.203921>, 
      <-0.606749, 0.380148, 1.270588>, <-0.573195, 0.346593, 0.950992>, <-0.594678, 0.416401, 0.481164>, <-0.477354, 0.299078, 0.203921>, 
      <-0.697842, 0.160231, 1.270588>, <-0.650389, 0.160231, 0.950992>, <-0.714941, 0.126060, 0.481164>, <-0.549020, 0.126060, 0.203921>, 
      <-0.697842, -0.000000, 1.270588>, <-0.650389, -0.000000, 0.950992>, <-0.714941, -0.000000, 0.481164>, <-0.549020, 0.000000, 0.203921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.697842, 1.270588>, <0.000000, 0.650389, 0.950992>, <0.000000, 0.714941, 0.481164>, <0.000000, 0.549020, 0.203921>, 
      <-0.160232, 0.697842, 1.270588>, <-0.160232, 0.650389, 0.950992>, <-0.126061, 0.714941, 0.481164>, <-0.126061, 0.549020, 0.203921>, 
      <-0.380148, 0.606749, 1.270588>, <-0.346593, 0.573195, 0.950992>, <-0.416401, 0.594678, 0.481164>, <-0.299078, 0.477354, 0.203921>, 
      <-0.493449, 0.493449, 1.270588>, <-0.459894, 0.459894, 0.950992>, <-0.505540, 0.505540, 0.481164>, <-0.388216, 0.388216, 0.203921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.493449, 0.493449, 1.270588>, <0.459894, 0.459894, 0.950992>, <0.505540, 0.505540, 0.481164>, <0.388216, 0.388216, 0.203921>, 
      <0.380148, 0.606749, 1.270588>, <0.346593, 0.573195, 0.950992>, <0.416401, 0.594678, 0.481164>, <0.299078, 0.477354, 0.203921>, 
      <0.160232, 0.697842, 1.270588>, <0.160232, 0.650389, 0.950992>, <0.126060, 0.714941, 0.481164>, <0.126060, 0.549020, 0.203921>, 
      <0.000000, 0.697842, 1.270588>, <0.000000, 0.650389, 0.950992>, <0.000000, 0.714941, 0.481164>, <0.000000, 0.549020, 0.203921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.721372, 1.364707>, <0.000000, -0.692267, 1.364707>, <0.000000, -0.702116, 1.299377>, <0.000000, -0.697842, 1.270588>, 
      <0.165634, -0.721372, 1.364707>, <0.165634, -0.692267, 1.364707>, <0.160232, -0.702116, 1.299377>, <0.160232, -0.697842, 1.270588>, 
      <0.392966, -0.627208, 1.364707>, <0.372386, -0.606628, 1.364707>, <0.383171, -0.609772, 1.299377>, <0.380148, -0.606749, 1.270588>, 
      <0.510087, -0.510087, 1.364707>, <0.489507, -0.489507, 1.364707>, <0.496471, -0.496471, 1.299377>, <0.493449, -0.493449, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.510087, -0.510087, 1.364707>, <-0.489507, -0.489507, 1.364707>, <-0.496471, -0.496471, 1.299377>, <-0.493449, -0.493449, 1.270588>, 
      <-0.392966, -0.627208, 1.364707>, <-0.372386, -0.606628, 1.364707>, <-0.383170, -0.609772, 1.299377>, <-0.380148, -0.606749, 1.270588>, 
      <-0.165634, -0.721372, 1.364707>, <-0.165634, -0.692267, 1.364707>, <-0.160231, -0.702116, 1.299377>, <-0.160231, -0.697842, 1.270588>, 
      <0.000000, -0.721372, 1.364707>, <0.000000, -0.692267, 1.364707>, <0.000000, -0.702116, 1.299377>, <0.000000, -0.697842, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.721372, -0.000000, 1.364707>, <-0.692267, -0.000000, 1.364707>, <-0.702116, -0.000000, 1.299377>, <-0.697842, -0.000000, 1.270588>, 
      <-0.721372, -0.165634, 1.364707>, <-0.692267, -0.165634, 1.364707>, <-0.702116, -0.160232, 1.299377>, <-0.697842, -0.160232, 1.270588>, 
      <-0.627208, -0.392966, 1.364707>, <-0.606628, -0.372386, 1.364707>, <-0.609772, -0.383171, 1.299377>, <-0.606749, -0.380148, 1.270588>, 
      <-0.510087, -0.510087, 1.364707>, <-0.489507, -0.489507, 1.364707>, <-0.496471, -0.496471, 1.299377>, <-0.493449, -0.493449, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.510087, 0.510087, 1.364707>, <-0.489507, 0.489507, 1.364707>, <-0.496471, 0.496471, 1.299377>, <-0.493449, 0.493449, 1.270588>, 
      <-0.627208, 0.392966, 1.364707>, <-0.606628, 0.372386, 1.364707>, <-0.609772, 0.383170, 1.299377>, <-0.606749, 0.380148, 1.270588>, 
      <-0.721372, 0.165634, 1.364707>, <-0.692267, 0.165634, 1.364707>, <-0.702116, 0.160231, 1.299377>, <-0.697842, 0.160231, 1.270588>, 
      <-0.721372, -0.000000, 1.364707>, <-0.692267, -0.000000, 1.364707>, <-0.702116, -0.000000, 1.299377>, <-0.697842, -0.000000, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.721372, 1.364707>, <0.000000, 0.692267, 1.364707>, <0.000000, 0.702116, 1.299377>, <0.000000, 0.697842, 1.270588>, 
      <-0.165634, 0.721372, 1.364707>, <-0.165634, 0.692267, 1.364707>, <-0.160232, 0.702116, 1.299377>, <-0.160232, 0.697842, 1.270588>, 
      <-0.392966, 0.627208, 1.364707>, <-0.372386, 0.606628, 1.364707>, <-0.383170, 0.609772, 1.299377>, <-0.380148, 0.606749, 1.270588>, 
      <-0.510087, 0.510087, 1.364707>, <-0.489507, 0.489507, 1.364707>, <-0.496471, 0.496471, 1.299377>, <-0.493449, 0.493449, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.510087, 0.510087, 1.364707>, <0.489507, 0.489507, 1.364707>, <0.496471, 0.496471, 1.299377>, <0.493449, 0.493449, 1.270588>, 
      <0.392966, 0.627208, 1.364707>, <0.372386, 0.606628, 1.364707>, <0.383170, 0.609772, 1.299377>, <0.380148, 0.606749, 1.270588>, 
      <0.165634, 0.721372, 1.364707>, <0.165634, 0.692267, 1.364707>, <0.160232, 0.702116, 1.299377>, <0.160232, 0.697842, 1.270588>, 
      <0.000000, 0.721372, 1.364707>, <0.000000, 0.692267, 1.364707>, <0.000000, 0.702116, 1.299377>, <0.000000, 0.697842, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.752744, 1.270588>, <0.000000, -0.751904, 1.300339>, <0.000000, -0.751134, 1.364707>, <0.000000, -0.721372, 1.364707>, 
      <0.172838, -0.752744, 1.270588>, <0.172838, -0.751904, 1.300339>, <0.165634, -0.751134, 1.364707>, <0.165634, -0.721372, 1.364707>, 
      <0.410056, -0.654485, 1.270588>, <0.409462, -0.653891, 1.300339>, <0.414011, -0.648253, 1.364707>, <0.392966, -0.627208, 1.364707>, 
      <0.532270, -0.532270, 1.270588>, <0.531676, -0.531676, 1.300339>, <0.531132, -0.531132, 1.364707>, <0.510087, -0.510087, 1.364707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.532270, -0.532270, 1.270588>, <-0.531676, -0.531676, 1.300339>, <-0.531132, -0.531132, 1.364707>, <-0.510087, -0.510087, 1.364707>, 
      <-0.410055, -0.654485, 1.270588>, <-0.409461, -0.653891, 1.300339>, <-0.414011, -0.648253, 1.364707>, <-0.392966, -0.627208, 1.364707>, 
      <-0.172838, -0.752744, 1.270588>, <-0.172838, -0.751904, 1.300339>, <-0.165634, -0.751134, 1.364707>, <-0.165634, -0.721372, 1.364707>, 
      <0.000000, -0.752744, 1.270588>, <0.000000, -0.751904, 1.300339>, <0.000000, -0.751134, 1.364707>, <0.000000, -0.721372, 1.364707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.752744, -0.000000, 1.270588>, <-0.751904, -0.000000, 1.300339>, <-0.751134, -0.000000, 1.364707>, <-0.721372, -0.000000, 1.364707>, 
      <-0.752744, -0.172838, 1.270588>, <-0.751904, -0.172838, 1.300339>, <-0.751134, -0.165634, 1.364707>, <-0.721372, -0.165634, 1.364707>, 
      <-0.654485, -0.410056, 1.270588>, <-0.653891, -0.409462, 1.300339>, <-0.648253, -0.414011, 1.364707>, <-0.627208, -0.392966, 1.364707>, 
      <-0.532270, -0.532270, 1.270588>, <-0.531676, -0.531676, 1.300339>, <-0.531132, -0.531132, 1.364707>, <-0.510087, -0.510087, 1.364707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.532270, 0.532270, 1.270588>, <-0.531676, 0.531676, 1.300339>, <-0.531132, 0.531132, 1.364707>, <-0.510087, 0.510087, 1.364707>, 
      <-0.654485, 0.410056, 1.270588>, <-0.653891, 0.409462, 1.300339>, <-0.648253, 0.414011, 1.364707>, <-0.627208, 0.392966, 1.364707>, 
      <-0.752744, 0.172838, 1.270588>, <-0.751904, 0.172838, 1.300339>, <-0.751134, 0.165634, 1.364707>, <-0.721372, 0.165634, 1.364707>, 
      <-0.752744, -0.000000, 1.270588>, <-0.751904, -0.000000, 1.300339>, <-0.751134, -0.000000, 1.364707>, <-0.721372, -0.000000, 1.364707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.752744, 1.270588>, <0.000000, 0.751904, 1.300339>, <0.000000, 0.751134, 1.364707>, <0.000000, 0.721372, 1.364707>, 
      <-0.172838, 0.752744, 1.270588>, <-0.172838, 0.751904, 1.300339>, <-0.165634, 0.751134, 1.364707>, <-0.165634, 0.721372, 1.364707>, 
      <-0.410056, 0.654485, 1.270588>, <-0.409462, 0.653891, 1.300339>, <-0.414011, 0.648253, 1.364707>, <-0.392966, 0.627208, 1.364707>, 
      <-0.532270, 0.532270, 1.270588>, <-0.531676, 0.531676, 1.300339>, <-0.531132, 0.531132, 1.364707>, <-0.510087, 0.510087, 1.364707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.532270, 0.532270, 1.270588>, <0.531676, 0.531676, 1.300339>, <0.531132, 0.531132, 1.364707>, <0.510087, 0.510087, 1.364707>, 
      <0.410056, 0.654485, 1.270588>, <0.409462, 0.653891, 1.300339>, <0.414011, 0.648253, 1.364707>, <0.392966, 0.627208, 1.364707>, 
      <0.172838, 0.752744, 1.270588>, <0.172838, 0.751904, 1.300339>, <0.165634, 0.751134, 1.364707>, <0.165634, 0.721372, 1.364707>, 
      <0.000000, 0.752744, 1.270588>, <0.000000, 0.751904, 1.300339>, <0.000000, 0.751134, 1.364707>, <0.000000, 0.721372, 1.364707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.760784, -0.031373>, <0.000000, -0.777697, 0.358857>, <0.000000, -0.763766, 0.880148>, <0.000000, -0.752744, 1.270588>, 
      <0.174684, -0.760784, -0.031373>, <0.174684, -0.777697, 0.358857>, <0.172838, -0.763766, 0.880148>, <0.172838, -0.752744, 1.270588>, 
      <0.414436, -0.661475, -0.031373>, <0.426395, -0.673435, 0.358857>, <0.417850, -0.662279, 0.880148>, <0.410056, -0.654485, 1.270588>, 
      <0.537956, -0.537955, -0.031373>, <0.549915, -0.549915, 0.358857>, <0.540064, -0.540064, 0.880148>, <0.532270, -0.532270, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.537955, -0.537956, -0.031373>, <-0.549915, -0.549915, 0.358857>, <-0.540064, -0.540064, 0.880148>, <-0.532270, -0.532270, 1.270588>, 
      <-0.414435, -0.661476, -0.031373>, <-0.426395, -0.673435, 0.358857>, <-0.417849, -0.662279, 0.880148>, <-0.410055, -0.654485, 1.270588>, 
      <-0.174684, -0.760784, -0.031373>, <-0.174684, -0.777697, 0.358857>, <-0.172838, -0.763766, 0.880148>, <-0.172838, -0.752744, 1.270588>, 
      <0.000000, -0.760784, -0.031373>, <0.000000, -0.777697, 0.358857>, <0.000000, -0.763766, 0.880148>, <0.000000, -0.752744, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.760784, -0.000000, -0.031373>, <-0.777697, -0.000000, 0.358857>, <-0.763766, -0.000000, 0.880148>, <-0.752744, -0.000000, 1.270588>, 
      <-0.760784, -0.174684, -0.031373>, <-0.777697, -0.174684, 0.358857>, <-0.763766, -0.172838, 0.880148>, <-0.752744, -0.172838, 1.270588>, 
      <-0.661475, -0.414436, -0.031373>, <-0.673435, -0.426395, 0.358857>, <-0.662279, -0.417850, 0.880148>, <-0.654485, -0.410056, 1.270588>, 
      <-0.537955, -0.537956, -0.031373>, <-0.549915, -0.549915, 0.358857>, <-0.540064, -0.540064, 0.880148>, <-0.532270, -0.532270, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.537956, 0.537956, -0.031373>, <-0.549915, 0.549915, 0.358857>, <-0.540064, 0.540064, 0.880148>, <-0.532270, 0.532270, 1.270588>, 
      <-0.661476, 0.414436, -0.031373>, <-0.673435, 0.426395, 0.358857>, <-0.662279, 0.417849, 0.880148>, <-0.654485, 0.410056, 1.270588>, 
      <-0.760784, 0.174684, -0.031373>, <-0.777697, 0.174684, 0.358857>, <-0.763766, 0.172838, 0.880148>, <-0.752744, 0.172838, 1.270588>, 
      <-0.760784, -0.000000, -0.031373>, <-0.777697, -0.000000, 0.358857>, <-0.763766, -0.000000, 0.880148>, <-0.752744, -0.000000, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.760784, -0.031373>, <0.000000, 0.777697, 0.358857>, <0.000000, 0.763766, 0.880148>, <0.000000, 0.752744, 1.270588>, 
      <-0.174684, 0.760784, -0.031373>, <-0.174684, 0.777697, 0.358857>, <-0.172838, 0.763766, 0.880148>, <-0.172838, 0.752744, 1.270588>, 
      <-0.414436, 0.661476, -0.031373>, <-0.426395, 0.673435, 0.358857>, <-0.417850, 0.662279, 0.880148>, <-0.410056, 0.654485, 1.270588>, 
      <-0.537956, 0.537956, -0.031373>, <-0.549915, 0.549915, 0.358857>, <-0.540064, 0.540064, 0.880148>, <-0.532270, 0.532270, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.537956, 0.537956, -0.031373>, <0.549915, 0.549915, 0.358857>, <0.540064, 0.540064, 0.880148>, <0.532270, 0.532270, 1.270588>, 
      <0.414436, 0.661476, -0.031373>, <0.426395, 0.673435, 0.358857>, <0.417850, 0.662279, 0.880148>, <0.410056, 0.654485, 1.270588>, 
      <0.174684, 0.760784, -0.031373>, <0.174684, 0.777697, 0.358857>, <0.172838, 0.763766, 0.880148>, <0.172838, 0.752744, 1.270588>, 
      <0.000000, 0.760784, -0.031373>, <0.000000, 0.777697, 0.358857>, <0.000000, 0.763766, 0.880148>, <0.000000, 0.752744, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.690196, -0.172549>, <0.000000, -0.736454, -0.162430>, <0.000000, -0.758734, -0.078681>, <0.000000, -0.760784, -0.031373>, 
      <0.158476, -0.690196, -0.172549>, <0.158476, -0.736454, -0.162430>, <0.174684, -0.758733, -0.078681>, <0.174684, -0.760784, -0.031373>, 
      <0.375983, -0.600102, -0.172549>, <0.408692, -0.632811, -0.162430>, <0.412986, -0.660026, -0.078681>, <0.414436, -0.661475, -0.031373>, 
      <0.488042, -0.488042, -0.172549>, <0.520752, -0.520752, -0.162430>, <0.536506, -0.536505, -0.078681>, <0.537956, -0.537955, -0.031373>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.488042, -0.488042, -0.172549>, <-0.520752, -0.520752, -0.162430>, <-0.536506, -0.536506, -0.078681>, <-0.537955, -0.537956, -0.031373>, 
      <-0.375983, -0.600102, -0.172549>, <-0.408692, -0.632811, -0.162430>, <-0.412986, -0.660026, -0.078681>, <-0.414435, -0.661476, -0.031373>, 
      <-0.158476, -0.690196, -0.172549>, <-0.158476, -0.736454, -0.162430>, <-0.174684, -0.758734, -0.078681>, <-0.174684, -0.760784, -0.031373>, 
      <0.000000, -0.690196, -0.172549>, <0.000000, -0.736454, -0.162430>, <0.000000, -0.758734, -0.078681>, <0.000000, -0.760784, -0.031373>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.690196, -0.000000, -0.172549>, <-0.736454, -0.000000, -0.162430>, <-0.758734, -0.000000, -0.078681>, <-0.760784, -0.000000, -0.031373>, 
      <-0.690196, -0.158476, -0.172549>, <-0.736454, -0.158476, -0.162430>, <-0.758734, -0.174684, -0.078681>, <-0.760784, -0.174684, -0.031373>, 
      <-0.600102, -0.375983, -0.172549>, <-0.632811, -0.408692, -0.162430>, <-0.660026, -0.412986, -0.078681>, <-0.661475, -0.414436, -0.031373>, 
      <-0.488042, -0.488042, -0.172549>, <-0.520752, -0.520752, -0.162430>, <-0.536506, -0.536506, -0.078681>, <-0.537955, -0.537956, -0.031373>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.488042, 0.488042, -0.172549>, <-0.520752, 0.520752, -0.162430>, <-0.536506, 0.536506, -0.078681>, <-0.537956, 0.537956, -0.031373>, 
      <-0.600102, 0.375983, -0.172549>, <-0.632811, 0.408692, -0.162430>, <-0.660026, 0.412986, -0.078681>, <-0.661476, 0.414436, -0.031373>, 
      <-0.690196, 0.158476, -0.172549>, <-0.736454, 0.158476, -0.162430>, <-0.758734, 0.174684, -0.078681>, <-0.760784, 0.174684, -0.031373>, 
      <-0.690196, -0.000000, -0.172549>, <-0.736454, -0.000000, -0.162430>, <-0.758734, -0.000000, -0.078681>, <-0.760784, -0.000000, -0.031373>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.690196, -0.172549>, <0.000000, 0.736454, -0.162430>, <0.000000, 0.758734, -0.078681>, <0.000000, 0.760784, -0.031373>, 
      <-0.158476, 0.690196, -0.172549>, <-0.158476, 0.736454, -0.162430>, <-0.174684, 0.758734, -0.078681>, <-0.174684, 0.760784, -0.031373>, 
      <-0.375983, 0.600102, -0.172549>, <-0.408692, 0.632811, -0.162430>, <-0.412986, 0.660026, -0.078681>, <-0.414436, 0.661476, -0.031373>, 
      <-0.488042, 0.488042, -0.172549>, <-0.520752, 0.520752, -0.162430>, <-0.536506, 0.536506, -0.078681>, <-0.537956, 0.537956, -0.031373>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.488042, 0.488042, -0.172549>, <0.520752, 0.520752, -0.162430>, <0.536506, 0.536506, -0.078681>, <0.537956, 0.537956, -0.031373>, 
      <0.375983, 0.600102, -0.172549>, <0.408692, 0.632811, -0.162430>, <0.412986, 0.660026, -0.078681>, <0.414436, 0.661476, -0.031373>, 
      <0.158476, 0.690196, -0.172549>, <0.158476, 0.736454, -0.162430>, <0.174684, 0.758734, -0.078681>, <0.174684, 0.760784, -0.031373>, 
      <0.000000, 0.690196, -0.172549>, <0.000000, 0.736454, -0.162430>, <0.000000, 0.758734, -0.078681>, <0.000000, 0.760784, -0.031373>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.007843, -0.196078>, <0.000000, -0.212549, -0.189019>, <0.000000, -0.490100, -0.216320>, <0.000000, -0.690196, -0.172549>, 
      <0.001801, -0.007843, -0.196078>, <0.001801, -0.212549, -0.189019>, <0.158476, -0.490100, -0.216320>, <0.158476, -0.690196, -0.172549>, 
      <0.004273, -0.006819, -0.196078>, <0.149021, -0.151568, -0.189019>, <0.234494, -0.458612, -0.216320>, <0.375983, -0.600102, -0.172549>, 
      <0.005546, -0.005546, -0.196078>, <0.150295, -0.150295, -0.189019>, <0.346553, -0.346553, -0.216320>, <0.488042, -0.488042, -0.172549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.005546, -0.005546, -0.196078>, <-0.150295, -0.150295, -0.189019>, <-0.346553, -0.346553, -0.216320>, <-0.488042, -0.488042, -0.172549>, 
      <-0.004273, -0.006819, -0.196078>, <-0.149021, -0.151568, -0.189019>, <-0.234493, -0.458612, -0.216320>, <-0.375983, -0.600102, -0.172549>, 
      <-0.001801, -0.007843, -0.196078>, <-0.001801, -0.212549, -0.189019>, <-0.158476, -0.490100, -0.216320>, <-0.158476, -0.690196, -0.172549>, 
      <0.000000, -0.007843, -0.196078>, <0.000000, -0.212549, -0.189019>, <0.000000, -0.490100, -0.216320>, <0.000000, -0.690196, -0.172549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.007843, 0.000000, -0.196078>, <-0.212549, 0.000000, -0.189019>, <-0.490100, 0.000000, -0.216320>, <-0.690196, -0.000000, -0.172549>, 
      <-0.007843, -0.001801, -0.196078>, <-0.212549, -0.001801, -0.189019>, <-0.490100, -0.158476, -0.216320>, <-0.690196, -0.158476, -0.172549>, 
      <-0.006819, -0.004273, -0.196078>, <-0.151568, -0.149021, -0.189019>, <-0.458612, -0.234494, -0.216320>, <-0.600102, -0.375983, -0.172549>, 
      <-0.005546, -0.005546, -0.196078>, <-0.150295, -0.150295, -0.189019>, <-0.346553, -0.346553, -0.216320>, <-0.488042, -0.488042, -0.172549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.005546, 0.005546, -0.196078>, <-0.150295, 0.150295, -0.189019>, <-0.346553, 0.346553, -0.216320>, <-0.488042, 0.488042, -0.172549>, 
      <-0.006819, 0.004273, -0.196078>, <-0.151568, 0.149021, -0.189019>, <-0.458612, 0.234493, -0.216320>, <-0.600102, 0.375983, -0.172549>, 
      <-0.007843, 0.001801, -0.196078>, <-0.212549, 0.001801, -0.189019>, <-0.490100, 0.158476, -0.216320>, <-0.690196, 0.158476, -0.172549>, 
      <-0.007843, 0.000000, -0.196078>, <-0.212549, 0.000000, -0.189019>, <-0.490100, 0.000000, -0.216320>, <-0.690196, -0.000000, -0.172549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.007843, -0.196078>, <0.000000, 0.212549, -0.189019>, <0.000000, 0.490100, -0.216320>, <0.000000, 0.690196, -0.172549>, 
      <-0.001801, 0.007843, -0.196078>, <-0.001801, 0.212549, -0.189019>, <-0.158476, 0.490100, -0.216320>, <-0.158476, 0.690196, -0.172549>, 
      <-0.004273, 0.006819, -0.196078>, <-0.149021, 0.151568, -0.189019>, <-0.234494, 0.458612, -0.216320>, <-0.375983, 0.600102, -0.172549>, 
      <-0.005546, 0.005546, -0.196078>, <-0.150295, 0.150295, -0.189019>, <-0.346553, 0.346553, -0.216320>, <-0.488042, 0.488042, -0.172549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.005546, 0.005546, -0.196078>, <0.150295, 0.150295, -0.189019>, <0.346553, 0.346553, -0.216320>, <0.488042, 0.488042, -0.172549>, 
      <0.004273, 0.006819, -0.196078>, <0.149021, 0.151568, -0.189019>, <0.234493, 0.458612, -0.216320>, <0.375983, 0.600102, -0.172549>, 
      <0.001801, 0.007843, -0.196078>, <0.001801, 0.212549, -0.189019>, <0.158476, 0.490100, -0.216320>, <0.158476, 0.690196, -0.172549>, 
      <0.000000, 0.007843, -0.196078>, <0.000000, 0.212549, -0.189019>, <0.000000, 0.490100, -0.216320>, <0.000000, 0.690196, -0.172549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.690196, 0.000000, -0.172549>, <0.690196, 0.158476, -0.172549>, <0.600102, 0.375983, -0.172549>, <0.488042, 0.488042, -0.172549>, 
      <0.490100, 0.000000, -0.216320>, <0.490100, 0.158476, -0.216320>, <0.458612, 0.234494, -0.216320>, <0.346553, 0.346553, -0.216320>, 
      <0.212549, 0.000000, -0.189019>, <0.212549, 0.001801, -0.189019>, <0.151568, 0.149021, -0.189019>, <0.150295, 0.150295, -0.189019>, 
      <0.007843, 0.000000, -0.196078>, <0.007843, 0.001801, -0.196078>, <0.006819, 0.004273, -0.196078>, <0.005546, 0.005546, -0.196078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.690196, 0.000000, -0.172549>, <0.490100, 0.000000, -0.216320>, <0.212549, 0.000000, -0.189019>, <0.007843, 0.000000, -0.196078>, 
      <0.690196, -0.158476, -0.172549>, <0.490100, -0.158476, -0.216320>, <0.212549, -0.001801, -0.189019>, <0.007843, -0.001801, -0.196078>, 
      <0.600102, -0.375983, -0.172549>, <0.458612, -0.234493, -0.216320>, <0.151568, -0.149021, -0.189019>, <0.006819, -0.004273, -0.196078>, 
      <0.488042, -0.488042, -0.172549>, <0.346553, -0.346553, -0.216320>, <0.150295, -0.150295, -0.189019>, <0.005546, -0.005546, -0.196078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.721372, 0.000000, 1.364707>, <0.721372, 0.165634, 1.364707>, <0.627208, 0.392966, 1.364707>, <0.510087, 0.510087, 1.364707>, 
      <0.751134, 0.000000, 1.364707>, <0.751134, 0.165634, 1.364707>, <0.648253, 0.414011, 1.364707>, <0.531132, 0.531132, 1.364707>, 
      <0.751904, 0.000000, 1.300339>, <0.751904, 0.172838, 1.300339>, <0.653891, 0.409462, 1.300339>, <0.531676, 0.531676, 1.300339>, 
      <0.752744, 0.000000, 1.270588>, <0.752744, 0.172838, 1.270588>, <0.654485, 0.410056, 1.270588>, <0.532270, 0.532270, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.721372, 0.000000, 1.364707>, <0.751134, 0.000000, 1.364707>, <0.751904, 0.000000, 1.300339>, <0.752744, 0.000000, 1.270588>, 
      <0.721372, -0.165634, 1.364707>, <0.751134, -0.165634, 1.364707>, <0.751904, -0.172837, 1.300339>, <0.752744, -0.172837, 1.270588>, 
      <0.627208, -0.392966, 1.364707>, <0.648253, -0.414011, 1.364707>, <0.653891, -0.409461, 1.300339>, <0.654485, -0.410055, 1.270588>, 
      <0.510087, -0.510087, 1.364707>, <0.531132, -0.531132, 1.364707>, <0.531676, -0.531676, 1.300339>, <0.532270, -0.532270, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.760784, 0.000000, -0.031373>, <0.777697, 0.000000, 0.358857>, <0.763766, 0.000000, 0.880148>, <0.752744, 0.000000, 1.270588>, 
      <0.760784, 0.174684, -0.031373>, <0.777697, 0.174684, 0.358857>, <0.763766, 0.172838, 0.880148>, <0.752744, 0.172838, 1.270588>, 
      <0.661475, 0.414436, -0.031373>, <0.673435, 0.426395, 0.358857>, <0.662279, 0.417850, 0.880148>, <0.654485, 0.410056, 1.270588>, 
      <0.537956, 0.537956, -0.031373>, <0.549915, 0.549915, 0.358857>, <0.540064, 0.540064, 0.880148>, <0.532270, 0.532270, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.760784, 0.000000, -0.031373>, <0.760784, -0.174684, -0.031373>, <0.661476, -0.414435, -0.031373>, <0.537956, -0.537955, -0.031373>, 
      <0.777697, 0.000000, 0.358857>, <0.777697, -0.174684, 0.358857>, <0.673435, -0.426395, 0.358857>, <0.549915, -0.549915, 0.358857>, 
      <0.763766, 0.000000, 0.880148>, <0.763766, -0.172837, 0.880148>, <0.662279, -0.417849, 0.880148>, <0.540064, -0.540064, 0.880148>, 
      <0.752744, 0.000000, 1.270588>, <0.752744, -0.172837, 1.270588>, <0.654485, -0.410055, 1.270588>, <0.532270, -0.532270, 1.270588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.760784, 0.000000, -0.031373>, <0.760784, 0.174684, -0.031373>, <0.661475, 0.414436, -0.031373>, <0.537956, 0.537956, -0.031373>, 
      <0.758734, 0.000000, -0.078681>, <0.758733, 0.174684, -0.078681>, <0.660026, 0.412986, -0.078681>, <0.536506, 0.536506, -0.078681>, 
      <0.736454, 0.000000, -0.162430>, <0.736454, 0.158476, -0.162430>, <0.632811, 0.408692, -0.162430>, <0.520752, 0.520752, -0.162430>, 
      <0.690196, 0.000000, -0.172549>, <0.690196, 0.158476, -0.172549>, <0.600102, 0.375983, -0.172549>, <0.488042, 0.488042, -0.172549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.760784, 0.000000, -0.031373>, <0.758734, 0.000000, -0.078681>, <0.736454, 0.000000, -0.162430>, <0.690196, 0.000000, -0.172549>, 
      <0.760784, -0.174684, -0.031373>, <0.758734, -0.174684, -0.078681>, <0.736454, -0.158476, -0.162430>, <0.690196, -0.158476, -0.172549>, 
      <0.661476, -0.414435, -0.031373>, <0.660026, -0.412986, -0.078681>, <0.632811, -0.408692, -0.162430>, <0.600102, -0.375983, -0.172549>, 
      <0.537956, -0.537955, -0.031373>, <0.536506, -0.536505, -0.078681>, <0.520752, -0.520752, -0.162430>, <0.488042, -0.488042, -0.172549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.007843, 0.000000, 0.117647>, <0.007843, 0.001801, 0.117647>, <0.006819, 0.004273, 0.117647>, <0.005546, 0.005546, 0.117647>, 
      <0.170196, 0.000000, 0.143529>, <0.170196, 0.001801, 0.143529>, <0.121620, 0.119074, 0.143529>, <0.120347, 0.120347, 0.143529>, 
      <0.464594, 0.000000, 0.062851>, <0.464594, 0.126060, 0.062851>, <0.417656, 0.239380, 0.062851>, <0.328518, 0.328518, 0.062851>, 
      <0.549020, 0.000000, 0.203921>, <0.549020, 0.126060, 0.203921>, <0.477354, 0.299078, 0.203921>, <0.388216, 0.388216, 0.203921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.007843, 0.000000, 0.117647>, <0.170196, 0.000000, 0.143529>, <0.464594, 0.000000, 0.062851>, <0.549020, 0.000000, 0.203921>, 
      <0.007843, -0.001801, 0.117647>, <0.170196, -0.001801, 0.143529>, <0.464594, -0.126060, 0.062851>, <0.549020, -0.126060, 0.203921>, 
      <0.006819, -0.004273, 0.117647>, <0.121620, -0.119073, 0.143529>, <0.417656, -0.239379, 0.062851>, <0.477354, -0.299077, 0.203921>, 
      <0.005546, -0.005546, 0.117647>, <0.120347, -0.120347, 0.143529>, <0.328518, -0.328518, 0.062851>, <0.388216, -0.388216, 0.203921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.697842, 0.000000, 1.270588>, <0.650389, 0.000000, 0.950992>, <0.714941, 0.000000, 0.481164>, <0.549020, 0.000000, 0.203921>, 
      <0.697842, 0.160232, 1.270588>, <0.650389, 0.160232, 0.950992>, <0.714941, 0.126060, 0.481164>, <0.549020, 0.126060, 0.203921>, 
      <0.606749, 0.380148, 1.270588>, <0.573195, 0.346593, 0.950992>, <0.594678, 0.416401, 0.481164>, <0.477354, 0.299078, 0.203921>, 
      <0.493449, 0.493449, 1.270588>, <0.459894, 0.459894, 0.950992>, <0.505540, 0.505540, 0.481164>, <0.388216, 0.388216, 0.203921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.697842, 0.000000, 1.270588>, <0.697842, -0.160231, 1.270588>, <0.606750, -0.380148, 1.270588>, <0.493449, -0.493449, 1.270588>, 
      <0.650389, 0.000000, 0.950992>, <0.650389, -0.160231, 0.950992>, <0.573195, -0.346593, 0.950992>, <0.459894, -0.459894, 0.950992>, 
      <0.714941, 0.000000, 0.481164>, <0.714941, -0.126060, 0.481164>, <0.594678, -0.416401, 0.481164>, <0.505540, -0.505540, 0.481164>, 
      <0.549020, 0.000000, 0.203921>, <0.549020, -0.126060, 0.203921>, <0.477354, -0.299077, 0.203921>, <0.388216, -0.388216, 0.203921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.697842, 0.000000, 1.270588>, <0.697842, 0.160232, 1.270588>, <0.606749, 0.380148, 1.270588>, <0.493449, 0.493449, 1.270588>, 
      <0.702116, 0.000000, 1.299377>, <0.702116, 0.160232, 1.299377>, <0.609772, 0.383170, 1.299377>, <0.496471, 0.496471, 1.299377>, 
      <0.692267, 0.000000, 1.364707>, <0.692267, 0.165634, 1.364707>, <0.606628, 0.372386, 1.364707>, <0.489507, 0.489507, 1.364707>, 
      <0.721372, 0.000000, 1.364707>, <0.721372, 0.165634, 1.364707>, <0.627208, 0.392966, 1.364707>, <0.510087, 0.510087, 1.364707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.697842, 0.000000, 1.270588>, <0.702116, 0.000000, 1.299377>, <0.692267, 0.000000, 1.364707>, <0.721372, 0.000000, 1.364707>, 
      <0.697842, -0.160231, 1.270588>, <0.702116, -0.160231, 1.299377>, <0.692267, -0.165634, 1.364707>, <0.721372, -0.165634, 1.364707>, 
      <0.606750, -0.380148, 1.270588>, <0.609772, -0.383170, 1.299377>, <0.606628, -0.372386, 1.364707>, <0.627208, -0.392966, 1.364707>, 
      <0.493449, -0.493449, 1.270588>, <0.496471, -0.496471, 1.299377>, <0.489507, -0.489507, 1.364707>, <0.510087, -0.510087, 1.364707>
    }
  }
  material {
    Glass
  }
  scale 18.613621
  translate  <-66.084514, -212.180072, 3.728069>
}


#declare mag_cover = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.765957, 2.000000, -0.574468>, <-0.974670, 2.000000, -0.605619>, <-1.257447, 2.000000, -0.604255>, <-1.468085, 2.000000, -0.617021>, 
      <-0.765957, 1.400000, -0.568085>, <-0.974670, 1.400000, -0.599236>, <-1.251064, 1.400000, -0.610638>, <-1.461702, 1.400000, -0.623404>, 
      <-0.765957, 0.600000, -0.559574>, <-0.969970, 0.600000, -0.586979>, <-1.248936, 0.600000, -0.606382>, <-1.453191, 0.600000, -0.631914>, 
      <-0.765957, 0.000000, -0.553191>, <-0.969970, 0.000000, -0.580596>, <-1.242553, 0.000000, -0.612765>, <-1.446808, 0.000000, -0.638297>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.042553, 2.000000, -0.404255>, <-0.259574, 2.000000, -0.455319>, <-0.545452, 2.000000, -0.541557>, <-0.765957, 2.000000, -0.574468>, 
      <-0.036170, 1.400000, -0.417021>, <-0.253191, 1.400000, -0.468085>, <-0.545452, 1.400000, -0.535174>, <-0.765957, 1.400000, -0.568085>, 
      <-0.027659, 0.600000, -0.434042>, <-0.251063, 0.600000, -0.465957>, <-0.542293, 0.600000, -0.529530>, <-0.765957, 0.600000, -0.559574>, 
      <-0.021276, 0.000000, -0.446808>, <-0.244680, 0.000000, -0.478723>, <-0.542293, 0.000000, -0.523147>, <-0.765957, 0.000000, -0.553191>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.659574, 2.000000, -0.680851>, <0.443879, 2.000000, -0.612079>, <0.168085, 2.000000, -0.487234>, <-0.042553, 2.000000, -0.404255>, 
      <0.659574, 1.400000, -0.674468>, <0.443879, 1.400000, -0.605696>, <0.174468, 1.400000, -0.500000>, <-0.036170, 1.400000, -0.417021>, 
      <0.659574, 0.600000, -0.665957>, <0.453257, 0.600000, -0.609145>, <0.176596, 0.600000, -0.497872>, <-0.027659, 0.600000, -0.434042>, 
      <0.659574, 0.000000, -0.659574>, <0.453257, 0.000000, -0.602762>, <0.182979, 0.000000, -0.510638>, <-0.021276, 0.000000, -0.446808>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.425532, 2.000000, -0.872340>, <1.195745, 2.000000, -0.814893>, <0.885240, 2.000000, -0.752803>, <0.659574, 2.000000, -0.680851>, 
      <1.431915, 1.400000, -0.865957>, <1.202128, 1.400000, -0.808511>, <0.885240, 1.400000, -0.746420>, <0.659574, 1.400000, -0.674468>, 
      <1.440426, 0.600000, -0.857447>, <1.204255, 0.600000, -0.800000>, <0.893909, 0.600000, -0.730484>, <0.659574, 0.600000, -0.665957>, 
      <1.446809, 0.000000, -0.851064>, <1.210639, 0.000000, -0.793617>, <0.893909, 0.000000, -0.724101>, <0.659574, 0.000000, -0.659574>
    }
  }
  material {
    cover
  }
}
#declare mag_interior = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.221954, 1.531089, -0.590089>, <-0.347232, 1.531089, -0.625695>, <-0.522418, 1.531089, -0.635614>, <-0.651188, 1.531089, -0.655125>, 
      <-0.224895, 1.071762, -0.589925>, <-0.350174, 1.071762, -0.625530>, <-0.523409, 1.071762, -0.635450>, <-0.652179, 1.071762, -0.654960>, 
      <-0.228817, 0.459327, -0.589705>, <-0.352241, 0.459327, -0.624784>, <-0.526680, 0.459327, -0.635230>, <-0.653500, 0.459327, -0.654741>, 
      <-0.231759, 0.000000, -0.589541>, <-0.355182, 0.000000, -0.624619>, <-0.527671, 0.000000, -0.635066>, <-0.654490, 0.000000, -0.654576>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033350, 1.531089, -0.479529>, <-0.098576, 1.531089, -0.472663>, <-0.158866, 1.531089, -0.572159>, <-0.221954, 1.531089, -0.590089>, 
      <-0.034341, 1.071762, -0.479364>, <-0.099567, 1.071762, -0.472498>, <-0.161808, 1.071762, -0.571995>, <-0.224895, 1.071762, -0.589925>, 
      <-0.035662, 0.459327, -0.479145>, <-0.102229, 0.459327, -0.469403>, <-0.164104, 0.459327, -0.571313>, <-0.228817, 0.459327, -0.589705>, 
      <-0.036652, 0.000000, -0.478980>, <-0.103220, 0.000000, -0.469239>, <-0.167045, 0.000000, -0.571148>, <-0.231759, 0.000000, -0.589541>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.025181, 1.531089, -0.616104>, <-0.015509, 1.531089, -0.597900>, <0.010981, 1.531089, -0.484195>, <-0.033350, 1.531089, -0.479529>, 
      <0.028093, 1.071762, -0.619841>, <-0.012597, 1.071762, -0.601638>, <0.009991, 1.071762, -0.484031>, <-0.034341, 1.071762, -0.479364>, 
      <0.031975, 0.459327, -0.624825>, <-0.013365, 0.459327, -0.604366>, <0.013557, 0.459327, -0.486347>, <-0.035662, 0.459327, -0.479145>, 
      <0.034887, 0.000000, -0.628562>, <-0.010454, 0.000000, -0.608104>, <0.012566, 0.000000, -0.486183>, <-0.036652, 0.000000, -0.478980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.460920, 1.531089, -0.700650>, <0.330198, 1.531089, -0.675286>, <0.146732, 1.531089, -0.670481>, <0.025181, 1.531089, -0.616104>, 
      <0.471636, 1.071762, -0.706338>, <0.340914, 1.071762, -0.680974>, <0.149644, 1.071762, -0.674219>, <0.028093, 1.071762, -0.619841>, 
      <0.485924, 0.459327, -0.713923>, <0.347398, 0.459327, -0.686608>, <0.160674, 0.459327, -0.682896>, <0.031975, 0.459327, -0.624825>, 
      <0.496639, 0.000000, -0.719612>, <0.358114, 0.000000, -0.692297>, <0.163585, 0.000000, -0.686633>, <0.034887, 0.000000, -0.628562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.708117, 2.000000, -0.663274>, <-0.922768, 2.000000, -0.700004>, <-1.216219, 2.000000, -0.668943>, <-1.433976, 2.000000, -0.671372>, 
      <-0.710068, 1.400000, -0.658842>, <-0.924720, 1.400000, -0.695572>, <-1.202031, 1.400000, -0.675325>, <-1.419789, 1.400000, -0.677755>, 
      <-0.712669, 0.600000, -0.652933>, <-0.911763, 0.600000, -0.687392>, <-1.199253, 0.600000, -0.673021>, <-1.400873, 0.600000, -0.686265>, 
      <-0.714620, 0.000000, -0.648501>, <-0.913714, 0.000000, -0.682960>, <-1.185066, 0.000000, -0.679404>, <-1.386685, 0.000000, -0.692648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.042553, 2.000000, -0.433281>, <-0.242222, 2.000000, -0.502279>, <-0.499889, 2.000000, -0.627643>, <-0.708117, 2.000000, -0.663274>, 
      <-0.036170, 1.400000, -0.440194>, <-0.235839, 1.400000, -0.509192>, <-0.501840, 1.400000, -0.623211>, <-0.710068, 1.400000, -0.658842>, 
      <-0.027659, 0.600000, -0.449410>, <-0.235662, 0.600000, -0.507064>, <-0.499986, 0.600000, -0.616121>, <-0.712669, 0.600000, -0.652933>, 
      <-0.021276, 0.000000, -0.456323>, <-0.229279, 0.000000, -0.513976>, <-0.501937, 0.000000, -0.611689>, <-0.714620, 0.000000, -0.648501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.588035, 2.000000, -0.745926>, <0.387171, 2.000000, -0.680823>, <0.146623, 2.000000, -0.527075>, <-0.042553, 2.000000, -0.433281>, 
      <0.584133, 1.400000, -0.747347>, <0.383269, 1.400000, -0.682244>, <0.153007, 1.400000, -0.533987>, <-0.036170, 1.400000, -0.440194>, 
      <0.578930, 0.600000, -0.749242>, <0.388128, 0.600000, -0.690985>, <0.151232, 0.600000, -0.537713>, <-0.027659, 0.600000, -0.449410>, 
      <0.575028, 0.000000, -0.750664>, <0.384226, 0.000000, -0.692406>, <0.157615, 0.000000, -0.544625>, <-0.021276, 0.000000, -0.456323>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.412525, 2.000000, -0.904898>, <1.165178, 2.000000, -0.857206>, <0.827665, 2.000000, -0.823595>, <0.588035, 2.000000, -0.745926>, 
      <1.415006, 1.400000, -0.902417>, <1.167659, 1.400000, -0.854725>, <0.823763, 1.400000, -0.825016>, <0.584133, 1.400000, -0.747347>, 
      <1.418314, 0.600000, -0.899109>, <1.164584, 0.600000, -0.855320>, <0.825188, 0.600000, -0.824432>, <0.578930, 0.600000, -0.749242>, 
      <1.420795, 0.000000, -0.896629>, <1.167065, 0.000000, -0.852839>, <0.821286, 0.000000, -0.825853>, <0.575028, 0.000000, -0.750664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.773153, 2.000000, -0.649022>, <-0.963427, 2.000000, -0.677533>, <-1.222071, 2.000000, -0.645586>, <-1.414465, 2.000000, -0.644113>, 
      <-0.784859, 1.400000, -0.648492>, <-0.975134, 1.400000, -0.677003>, <-1.215688, 1.400000, -0.651968>, <-1.408082, 1.400000, -0.650496>, 
      <-0.800467, 0.600000, -0.647785>, <-0.973081, 0.600000, -0.672610>, <-1.225267, 0.600000, -0.653566>, <-1.399571, 0.600000, -0.659006>, 
      <-0.812174, 0.000000, -0.647255>, <-0.984787, 0.000000, -0.672080>, <-1.218884, 0.000000, -0.659949>, <-1.393188, 0.000000, -0.665389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.042553, 2.000000, -0.438539>, <-0.261733, 2.000000, -0.501684>, <-0.547577, 2.000000, -0.615220>, <-0.773153, 2.000000, -0.649022>, 
      <-0.036170, 1.400000, -0.447403>, <-0.255350, 1.400000, -0.510548>, <-0.559283, 1.400000, -0.614690>, <-0.784859, 1.400000, -0.648492>, 
      <-0.027659, 0.600000, -0.459221>, <-0.264928, 0.600000, -0.512972>, <-0.559663, 0.600000, -0.613153>, <-0.800467, 0.600000, -0.647785>, 
      <-0.021276, 0.000000, -0.468085>, <-0.258545, 0.000000, -0.521836>, <-0.571370, 0.000000, -0.612623>, <-0.812174, 0.000000, -0.647255>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.659574, 2.000000, -0.744681>, <0.440868, 2.000000, -0.674174>, <0.168085, 2.000000, -0.530382>, <-0.042553, 2.000000, -0.438539>, 
      <0.659574, 1.400000, -0.738298>, <0.440868, 1.400000, -0.667791>, <0.174468, 1.400000, -0.539246>, <-0.036170, 1.400000, -0.447403>, 
      <0.659574, 0.600000, -0.729787>, <0.449875, 0.600000, -0.669675>, <0.176596, 0.600000, -0.535817>, <-0.027659, 0.600000, -0.459221>, 
      <0.659574, 0.000000, -0.723404>, <0.449875, 0.000000, -0.663292>, <0.182979, 0.000000, -0.544681>, <-0.021276, 0.000000, -0.468085>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.380007, 2.000000, -0.897149>, <1.163877, 2.000000, -0.851409>, <0.869835, 2.000000, -0.812466>, <0.659574, 2.000000, -0.744681>, 
      <1.386390, 1.400000, -0.890766>, <1.170260, 1.400000, -0.845026>, <0.869835, 1.400000, -0.806083>, <0.659574, 1.400000, -0.738298>, 
      <1.394901, 0.600000, -0.882256>, <1.172388, 0.600000, -0.836515>, <0.877945, 0.600000, -0.792385>, <0.659574, 0.600000, -0.729787>, 
      <1.401284, 0.000000, -0.875873>, <1.178771, 0.000000, -0.830132>, <0.877945, 0.000000, -0.786002>, <0.659574, 0.000000, -0.723404>
    }
  }
  material {
    pages
  }
}
union { // magazine
  object { mag_cover }
  object { mag_interior }
  scale 95.446121
  rotate <-0.39409, -4.022064, 26.651148>
  translate  <-1836.207572, 156.274408, -320.296925>
}


