// Persistence of Vision Ray Tracer Scene Description File
// Auth: bob franke
//
                        
#version 3.1;  



//#declare notUseAsInclude = true;


#if (notUseAsInclude) 
              
  #declare sepia=false;              
  #include "colors.inc" 
  #include "finish.inc"  
  #include "textures.inc" 
  #include "ruintex.inc"
  
  global_settings
  {
    assumed_gamma 2.2
  }
  
  // ----------------------------------------
  camera
  {
    location  <-40, 10, -125>
    direction 1.5*z
    right     4/3*x
    look_at   <-20.0, 5,  0.0>
  }
  
  sky_sphere{
    pigment { color blue 0.6}
  }
  
  light_source
  {
    0*x // light's position (translated below)
    color White*2
    translate <5, 30, -30>*100
  }


// ----------------------------------------


#end



#declare rx = seed(4746);
#declare ry = seed(12345);
#declare rz = seed(9873);


#declare rx = seed(46);
#declare ry = seed(145);
#declare rz = seed(73);
 
 
#macro shingles(xx,yy,zz,rot) 
  box{<-1,0,0>,<1,-8,-.08>
    rotate<rot,rand(ry)*2,rand(rz)*2>
    translate<rand(rx)*.5+xx,rand(ry)*.5+yy,zz>
  }
#end  


#macro shingles2(xx,yy,zz,rot) 
  box{<-1,0,0>,<1,-4,-.08>
    rotate<rot,rand(ry)*2,rand(rz)*2>
    translate<rand(rx)*.5+xx,rand(ry)*.5+yy,zz>
  }
#end   
  
#macro barnSiding(xx,yy,zz,rot) 
  box{<-.5,0,0>,<.5,-10.5,-.08>
    rotate<rot,rand(ry),rand(rz)*1.5>
    translate<rand(rx)*.15+xx,rand(ry)*.25+yy,zz>
  }
#end  
  


#macro shingles(xx,yy,zz,rot) 
  box{<-1,0,0>,<1,-8,-.08>
    rotate<rot,rand(ry)*2,rand(rz)*2>
    translate<rand(rx)*.5+xx,rand(ry)*.5+yy,zz>
  }
#end  


#declare roof=  
  union{  
    #declare yy = 4;
    #declare xx = -28; 
    object{   
      union{
        #while (xx < 28)    
          #if ((xx <= -28) | (xx > 27))    
             shingles(xx,yy,0,2)
          #else          
            #if (rand(rx) > .5)   
              shingles(xx,yy,0,2)
            #end        
          #end  
          #declare xx = xx + 2.2;  
        #end
      }    
      clipped_by{plane{y,0} }
    } 
    
    #declare yy = 0;
    #declare xx = -29;
    #declare kk = -29; 
    #while (yy > -55)
      #while (xx < 28)  
        #if (yy = -52)
            #if (rand(rx) > .2)   
              shingles(xx,yy,0,2)
            #end          
        #end      
                  
            
            
        #if ((xx <= -28) | (xx > 26)) 
           shingles(xx,yy,0,2)
        #else          
          #if (rand(rx) > .5)   
            shingles(xx,yy,0,2)
          #end        
        #end              
        #declare xx = xx + 2.2;  
      #end  
      #if (kk = -29) 
        #declare xx=-28;
        #declare kk=-28;
      #else
        #declare xx=-29;
        #declare kk=-29;
      #end  
// add shiplap for shingles         
      box{<-27,yy,0>,<28,yy-.5,.1> texture{oldRoof  scale 3} }
      #declare yy = yy - 4;
    #end     
    texture{oldRoof rotate<0,0,90> scale 3 }
  }




#declare barnSide=
  union{  
    #declare yy = 13.5;
    #declare xx = 1; 
    object{   
      union{
        #while (xx < 58)
          #if (rand(rx) > .05)
            shingles2(xx,yy,0,-3.25)
          #end  
          #declare xx = xx + 2.2;  
        #end
      }    
      clipped_by{plane{y,8.875} }
    } 
    
    #declare yy = 8.875;
    #declare xx = 2;
    #declare kk = 2; 
    #while (yy > 0)
      #while (xx < 58)  
        #if (rand(rx) > .05)
           shingles2(xx,yy,0,-3.25) 
        #end  
        #declare xx = xx + 2.2;  
      #end  
      #if (kk = 2) 
        #declare xx=1;
        #declare kk=1;
      #else
        #declare xx=2;
        #declare kk=2;
      #end     
      #declare yy = yy - 2;
    #end     
    texture{oldSiding   rotate<0,0,90>translate<0,9,0> scale 3}
  }



#declare supports=
union{
  box{<-45,9,0>,<45,8,1> texture{oldWood scale 3 rotate<0,0,90>}}
  union{ 
    box{<-45,9,0>,<-44,0,1> } 
    box{<45,9,0>,<44,0,1> }         
    box{<-30,9,0>,<-29,0,1> } 
    box{<30,9,0>,<29,0,1> } 
    box{<-15,9,0>,<-14,0,1> } 
    box{<15,9,0>,<14,0,1> } 
    box{<-.5,9,0>,<.5,0,1> }
    texture{oldWood scale 3}
  } 
} 



#declare rx = seed(436);
#declare ry = seed(1345);
#declare rz = seed(7333);  

#declare barnFront=
object{  
  union{  
    #declare yy = 19.5; 
    #declare xx = -45;
    box{<-50,yy,0>,<50,yy-.5,.1> texture{oldSiding  scale 3} }  
        
    #while (xx < 45)
        #if (rand(rx) > .375)
          barnSiding(xx,yy,0,1)
        #end
      #declare xx = xx + 1.2;  
    #end   
    
    #declare yy = 14;
    box{<-50,yy,0>,<50,yy-.5,.1>  texture{oldSiding  scale 3} }
    
    #declare yy = 19;
    #declare xx = -45.5;
    #declare kk = -30; 
    #while (yy < 50)
      #while (xx < 45)       
        #if (rand(rx) > .375)
          barnSiding(xx,yy,0,1.5)
        #end  
        #declare xx = xx + 1.2;  
      #end  
      #if (kk = -30) 
        #declare xx=-45.5;
        #declare kk=-30.5;
      #else
        #declare xx=-45;
        #declare kk=-30;
      #end    
      box{<-50,yy,0>,<50,yy-.5,.1> texture{oldSiding  scale 3} }  
      #declare yy = yy + 5;
    #end
  }
  clipped_by{plane{y,0} rotate<0,0,-38> translate<0,44,0>     }
  clipped_by{plane{y,0} rotate<0,0,38> translate<0,44,0>     } 
  texture{mossyOldWood2 rotate<0,90,0> rotate<0,0,90>}
}


#declare barn=
union{  
  object{barnSide   finish { ambient .2} rotate<0,-90,0> translate<-45,0,0>}
  object{barnSide rotate<0,-90,0> translate<45,0,0>}  
  
  union{
    difference{
      object{barnFront finish { ambient .15}}
      box{<-8,20,-10>,<8,35,10> }

    }
      box{<-8,20,-.45>,<8,21,.25> texture{oldSiding scale 1 }}      
      box{<-8,35,-.45>,<8,34,.25> texture{oldSiding rotate<0,0,0> scale 1 }}      
      box{<-8,20,-.45>,<-7,35,.25> texture{oldSiding rotate<0,0,90> scale 1 }}      
      box{<8,20,-.45>,<7,35,.25> texture{oldSiding rotate<0,90,90> scale 1 }}      
  }  

  box{<-32,19,.5>,<30,19.01,54> pigment{Silver}}

  object{barnFront translate<0,0,54>}  
  
  box{<-.3,.3,.5>,<.3,-.3,-7> texture{oldSiding rotate<0,0,0> scale 2 }  rotate<-15,0,0> translate<0,42,0>}


  object{supports}            
  object{supports translate<0,0,15>}            
  object{supports translate<0,0,30>}            
  object{supports translate<0,0,45>}            
  
object{roof  rotate<0,90,0> rotate<0,0,-52>  translate<0,44,28>  }
object{roof  rotate<0,-90,0> rotate<0,0,52>  translate<0,44,28>  }
}


#if (notUseAsInclude) 
//  object{barn rotate<0,-45,0>} 
  
  
// BEND OPTIONS
//   #declare bend_object = object {barn rotate<0,0,0> rotate<0,0,0> }  
   #declare bend_object = object {barn }  
   #declare object_axis1 = <0,10,-1>;
   #declare object_axis2 = <0,10,55>;
   #declare bend_smoothness = 5;
   #declare bend_direction = <0, 1, 0>;
   #declare bend_angle = 15;  
// ONLY BEND MIDDLE SECTION OF STEM
//   #declare bend_start = .9 - MClock * .4;
//   #declare bend_finish = 1;

// CREATE BENT OBJECT
   object{#include "Bend.inc"  rotate<7,0,0>  rotate<0,-45,0>   }
  

  
  plane
  {
    y, // <X Y Z> unit surface normal, vector points "away from surface"
    0.0 // distance from the origin in the direction of the surface normal
    hollow on // has an inside pigment? 
    pigment{Tan}
  }

#end  //#if (notUseAsInclude) 









