// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1;




#include "colors.inc"  
  


#macro grayScale(theColor,useSepia) 
  #if (useSepia)
     red (theColor.red*.3 + theColor.green*.11 + theColor.blue*.59)*1.1
     green (theColor.red*.30 + theColor.green*.11 + theColor.blue*.59)
     blue (theColor.red*.30 + theColor.green*.11 + theColor.blue*.59)
  #else   
     red theColor.red
     green theColor.green
     blue theColor.blue 
  #end   
#end

#declare oldWood = 
texture {
    pigment{grayScale(Silver*.7,sepia)}
    normal {
        bumps -0.5
        scale <0.001, 1, 0.001>
    }
}


#declare hubPigment =  
pigment {
    wood
    turbulence 0.05            // For best results,  keep this low!
    scale <0.2, 0.2, 1>        // Scaled for a unit object
    color_map {
        [0.0 Silver*.6]
        [0.2 Silver*.6]
        [0.9 Silver + Brown*.3]
    }
}  

#declare veryDarkRusty_Iron = 
texture {
  pigment {
    granite
    color_map {
      [0.0 rgb <0.42*1.1, 0.20, 0.20>*.4]
      [0.5 rgb <0.50*1.1, 0.50, 0.02>*.4]
      [0.6 rgb <0.60*1.1, 0.20, 0.20>*.4]
      [0.6 rgb <0.30*1.1, 0.20, 0.20>*.4]
    }
  }
  finish { ambient 0.2 diffuse 0.6 }
  normal { wrinkles 1 scale 0.1 }
} #declare darkRusty_Iron = 
texture {
  pigment {
    granite
    color_map {
      [0.0 rgb <0.42*1.1, 0.20, 0.20>*.65]
      [0.5 rgb <0.50*1.1, 0.50, 0.02>*.65]
      [0.6 rgb <0.60*1.1, 0.20, 0.20>*.65]
      [0.6 rgb <0.30*1.1, 0.20, 0.20>*.65]
    }
  }
  finish { ambient 0.2 diffuse 0.6 }
  normal { wrinkles 1 scale 0.1 }
}   


#declare xRusty_Iron = 
texture {
  pigment {
    granite
    color_map {
      [0.0 rgb <0.42*1.1, 0.20, 0.20>]
      [0.5 rgb <0.50*1.1, 0.50, 0.02>]
      [0.6 rgb <0.60*1.1, 0.20, 0.20>]
      [0.6 rgb <0.30*1.1, 0.20, 0.20>]
    }
  }
  finish { ambient 0.2 diffuse 0.6 }
  normal { wrinkles 1 scale 0.1 }
} 

#declare mossyOldWood =  
texture{
  pigment{
    bozo
    turbulence 0.56 
    omega 0.2
    color_map {
//      [0.0 Silver*.7]
//      [1.0 Silver]
      [0.0 Silver*1.1]
      [1.0 Silver*1.3]
    }    
    scale .5 
  } 
  normal{  
    bump_map { 
//      gif "vwood2.gif"
      gif "sidewood.gif"
      interpolate 2
      bump_size 1.125
    }  
    rotate<0,0,0>
    scale 8   //13
    translate<.85,0,0>
  } 
  finish {
//    Shiny  
    crand .3  ambient .15}
}
texture{   
  pigment {
    bozo
    turbulence .25  
    lambda 3
    color_map {
      [ 0.0 color rgbf<0.57, 0.86, 0.44,.6> ]
//      [ 0.0 color rgbf<0.0, 0.4, 0.0,.6> ]
      [ 0.7 color rgbf<1.000, 1.000, 1.000, 1.000> ]
      [ 1.0 color rgbf<1.000, 1.000, 1.000, 1.000> ]
    }
  } 
  scale 2
}      
 
      
#declare oldWood_2 =  
texture{
  pigment{
    bozo
    turbulence 0.56 
    omega 0.2
    color_map {
      [0.0 Silver*1.1]
      [1.0 Silver*1.3]
    }    
    scale .5 
  } 
  normal{  
    bump_map { 
      gif "sidewood.gif"
      interpolate 2
      bump_size 2
    }  
    rotate<0,0,90> 
    scale 20
  } 
  finish {
    crand .2 }
}  

#declare oldWood_3 =  
texture{
  pigment{
    bozo
    turbulence 0.56 
    omega 0.2
    color_map {
      [0.0 Silver*1.1]
      [1.0 Silver*1.3]
    }    
    scale .5 
  } 
  normal{  
    bump_map { 
      gif "sidewood.gif"
      interpolate 2
      bump_size 2
    }  
//    scale 20
  } 
  finish {
    crand .3 }
}  
 
texture{   
  pigment {color rgbf<0.92, 0.78, 0.62,.4>   } 
}                  

   
      
#declare topRailTexture =  
texture{
  pigment{
    bozo
    turbulence 0.56 
    omega 0.2
    color_map {
      [0.0 Silver*.9]
      [1.0 Silver]
    }    
    scale .5 
  } 
  normal{  
    bump_map { 
//      gif "vwood2.gif"
      gif "sidewood.gif"
      interpolate 2
      bump_size 1.5
    }  
    scale 10
    translate<.85,0,0>
  } 
  finish {
//    Shiny  
    crand .3 ambient .2}
}
texture{   
  pigment {color rgbf<0.92, 0.78, 0.62,.8>   } 
}   
  
 

#declare oldSiding =  
texture{
  pigment{
    bozo
    turbulence 0.56 
    omega 0.2
    color_map {
      [0.0 grayScale(Silver*.8,sepia) ]
      [1.0 grayScale(Silver*.9,sepia) ]
    }    
    scale .5 
  } 
  normal{  
    bump_map { 
      gif "vwood2.gif"
      interpolate 2
      bump_size 2
    }  
    rotate<0,0,90>
    scale 13
    translate<.85,0,0>
  } 
  finish {
//    Shiny  
    crand .15}
}   


#declare oldRoof =  
texture{
  pigment{
    bozo
    turbulence 0.56 
    omega 0.2
    color_map {
      [0.0 grayScale(Silver*.4,sepia)]
      [1.0 grayScale(Silver*.5,sepia)]
    }    
    scale .5 
  } 
  normal{  
    bump_map { 
      gif "vwood2.gif"
      interpolate 2
      bump_size 2
    }  
    rotate<0,0,90>
    scale 8
    translate<.85,0,0>
  } 
  finish {
//    Shiny  
    crand .15}
}   


#declare darkOak = 
pigment {
    wood
    turbulence 0.04            // For best results,  keep this low!
    octaves 3
    scale <0.2, 0.2, 1>        // Scaled for a unit object
    color_map {
        [0.1 rgb <0.60, 0.30, 0.18>*1.25]
        [0.9 rgb <0.30, 0.15, 0.09>]
    }
}

//color red 0.576471 green 0.858824 blue 0.439216;


 
 
 
 
 
 
 
 
#declare mossyOldWood2 =  
texture{
  pigment{
    bozo
    turbulence 0.56 
    omega 0.2
    color_map {
      [0.0 Silver*.9]
      [1.0 Silver*1]
    }    
    scale .5 
  } 
  normal{  
    bump_map { 
      gif "sidewood.gif"
      interpolate 2
      bump_size 2
    }  
    rotate<0,0,0>
    scale 8   //13
    translate<.85,0,0>
  } 
  finish {
    crand .1  ambient .15}
}