// Persistence of Vision Ray Tracer Scene Description File
// Auth: Bob Franke
//

#version 3.1;   

//#declare notIncludeWagon = true;

#if (notIncludeWagon)  
  #declare sepia=false;
  #declare test=false; 
  #declare sepia=false;  
  #include "colors.inc" 
  #include "finish.inc"  
  #include "textures.inc" 
  #include "ruintex.inc"
  // ----------------------------------------

  camera{
    location  <-5, 5+0, -30.0>
    direction 1.5*z
    right     4/3*x
    look_at   <0, 5 , 0+0>
  } 


  sky_sphere{
    pigment{
      gradient y
      color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
    }
  }
  
light_source{<-10, 75, -50>*100 color White*1.5}         
light_source{<30, 35, -150> color White*0.4 shadowless}

// ----------------------------------------
  plane { y, -2.5 pigment {color rgb <0.7,0.5,0.3>}}
#end //#if (notIncludeWagon)   

 
#declare xcone=
cone {
  <0, 0, 1>, .3535   // Center and radius of one end
  <0, 0, 0>, .35    // Center and radius of other end   
}   

#declare reinfStrap=
union{ 
  box{<-1.5/12,.9,0>,<1.5/12,2.9,-.75/12> texture{darkRusty_Iron scale .2}}
  sphere{<0,2.75,0>, .75/12 scale<1,1,.5> translate<0,0,-.75/12> pigment{Black}}   
  sphere{<0,2.00,0>, .75/12 scale<1,1,.5> translate<0,0,-.75/12> pigment{Black}}   
  sphere{<0,1.0,0>, .75/12 scale<1,1,.5> translate<0,0,-.75/12> pigment{Black}}   
  sphere{<0,1.55,0>, .75/12 scale<1,1,.5> translate<0,0,-.75/12> pigment{Black}}   
}         
 
     
#declare spring=
union{
  difference{
    cylinder{<0,0,.5>,<0,0,-.5>,9.6}
    cylinder{<0,0,1>,<0,0,-1>,9.3}
    box{<10,0,2>,<-10,-10,-2> rotate<0,0,40>}
    box{<10,0,2>,<-10,-10,-2> rotate<0,0,-40>}
  } 
  
  difference{
    cylinder{<9.958577,8.35623,.5>,<9.958577,8.35623,-.5>,3.7}
    cylinder{<9.958577,8.35623,1>,<9.958577,8.35623,-1>,3.4}
    box{<10,0,2>,<-10,10,-2> rotate<0,0,40> translate<9.958577,8.35623,0>          }
    box{<10,-10,4>,<0,10,-4>  translate<9.958577,8.35623,0>          }
  } 
  
  difference{
    cylinder{<-9.958577,8.35623,.5>,<-9.958577,8.35623,-.5>,3.7}
    cylinder{<-9.958577,8.35623,1>,<-9.958577,8.35623,-1>,3.4}
    box{<10,0,2>,<-10,10,-2> rotate<0,0,-40> translate<-9.958577,8.35623,0>          }
    box{<-10,-10,4>,<0,10,-4>  translate<-9.958577,8.35623,0>          }
  } 
  
                              
  box{<-9.958577,8.35623-3.7,-.5>,<-12,8.35623-3.4,.5>}
  box{<9.958577,8.35623-3.7,-.5>,<12,8.35623-3.4,.5>}
 
   
  translate<0,-8.35623+3.7,0> 
  rotate<0,-90,0>
  texture{xRusty_Iron scale .2}
}          


#declare seat=     
union{    
  superellipsoid{ <0.05,  0.125> translate <1,-1,1> rotate<0,0,5>  
    scale<.04,.3,1.3/2>
    translate<-1.95,.6,-.55>   
    texture{mossyOldWood rotate<0,0,0>}         
  }

  superellipsoid{ <0.05,  0.25> translate <1,-1,1> rotate<0,0,-5>  
    scale<.04,.3,1.3/2>
    translate<1.9,.6,-.55> 
    texture{mossyOldWood rotate<0,0,0>}    
  }
  
  
  box{<-2,0.0,0>,<2,1,0.08> rotate<10,0,0> translate<0,.03,.65>
      texture{mossyOldWood rotate<0,0,0>}    
  }
  superellipsoid{ <0.25,  0.06> translate <1,-1,1>  
    scale<2,.04,1.55/2>
    translate<-2,.05,-.75>  
    texture{mossyOldWood rotate<0,90,0>}      
  }
            
  object{spring scale .1   translate<-1.85,-.5,.1>  }
  object{spring scale .1 rotate<180,0,0>  translate<-1.85,-.5,.1>  }
  object{spring scale .1   translate<1.85,-.5,.1>  }
  object{spring scale .1 rotate<180,0,0>  translate<1.85,-.5,.1>  }
}  

        
#declare topRail=
union{
  box{<.25,0,0>,<6.75,-1,0.0006> } 
  cylinder{<0.25,-0.25,0>,<0.25,-0.25,0.06>,0.25 }  
  cylinder{<0.25,-0.75,0>,<0.25,-0.75,0.06>,0.25 }  
  cylinder{<6.75,-0.25,0>,<6.75,-0.25,0.06>,0.25 }  
  cylinder{<6.75,-0.75,0>,<6.75,-0.75,0.06>,0.25 }  
  
  box{<0,-0.25,0>,<0.25,-0.75,0.06> } 
  box{<0,-0.25,0>,<0.25,-0.75,0.06> } 
  
  box{<6.75,-0.25,0>,<7.0,-0.75,0.06> } 
  box{<6.75,-0.25,0>,<7.0,-0.75,0.06> } 
  texture{topRailTexture}    
}                        

#declare topRail2=
union{
  box{<.25,0,0>,<6.75,-1,0.0006> } 
  cylinder{<0.25,-0.25,0>,<0.25,-0.25,0.06>,0.25 }  
  cylinder{<0.25,-0.75,0>,<0.25,-0.75,0.06>,0.25 }  
  cylinder{<6.75,-0.25,0>,<6.75,-0.25,0.06>,0.25 }  
  cylinder{<6.75,-0.75,0>,<6.75,-0.75,0.06>,0.25 }  
  
  box{<0,-0.25,0>,<0.25,-0.75,0.06> } 
  box{<0,-0.25,0>,<0.25,-0.75,0.06> } 
  
  box{<6.75,-0.25,0>,<7.0,-0.75,0.06> } 
  box{<6.75,-0.25,0>,<7.0,-0.75,0.06> } 
  texture{topRailTexture}    
}      
 
     
#declare rearAxle=
union{
  union{
    box{<-10.25,2/12,3>,<-9.75,8/12,-3>}
    intersection{
      box{<-10.25,2/12,4>,<-9.75,8/12,-4>}
      object{xcone translate<-10.0,5/12,-4>}
    }
    cylinder{<-10.0,5/12,-4>,<-10.0,5/12,-4.5>, .25}  
    cylinder{<-10.0,5/12,4>,<-10.0,5/12,4.5>, .25}  
    
    intersection{
      box{<-10.25,2/12,4>,<-9.75,8/12,-4> }
      object{xcone rotate<0,180,0> translate<-10.0,5/12,4>}
    }  
    pigment{DMFLightOak}                       
  }  
  #declare notUseAsInclude = false;
  #include "wheel2.pov"
  object{woodRim scale<1,1,1.5>  translate<-10,5/12,4.5>}
  #declare notUseAsInclude = true;
}     
   
#if (test)
  #declare rBottomSideBoard= box{<-12.1,.8,-3>,<.85,1.75,-3.1> }  
  #declare rTopSideBoard = box{<-12.1,1.85,-3>,<.85,3,-3.1>} 
  #declare lBottomSideBoard = box{<-12.1,.8,3>,<.85,1.75,3.1> }  
  #declare lTopSideBoard = box{<-12.1,1.85,3>,<.85,3,3.1> }   
  #declare aftBoard = box{<-12,.85,-3>,<-11.9,3,3> }
  #declare foreBoard = box{<.65,.85,-3>,<.75,3,3> }
#else
  #declare rBottomSideBoard= 
    superellipsoid{ <0.05,  0.25> translate <1,-1,1>  scale<12.95/2,.95/2,.1/2> translate<-12.1,1.75,-3.1> }
  
  #declare rTopSideBoard= 
    difference{
      superellipsoid{ <0.05,  0.25> translate <1,-1,1>  scale<12.95/2,1.15/2,.1/2> translate<-12.1,3,-3.1> }
      box{<0,0,-.5>,<13,1,.5> rotate<0,0,2> translate<-12.5,2.6,-3> }
   }

  
  #declare lBottomSideBoard= 
    superellipsoid{ <0.05,  0.25> translate <1,-1,1>  scale<12.95/2,.95/2,.1/2>  rotate<0,0,-5> translate<-12.1,1.75,3.0> texture{mossyOldWood}}
  
  #declare lTopSideBoard=
       superellipsoid{ <0.05,  0.25> translate <1,-1,1>  scale<12.95/2,1.15/2,.1/2> translate<-12.1,3,3.0> }

  #declare aftBoard= 
    superellipsoid{ <0.25,  0.05> translate <1,-1,1>  scale<.1/2,2.15/2,6/2> translate<-12.1,3,-3.0> }
  
  #declare foreBoard=
    difference{
      superellipsoid{ <0.25,  0.05> translate <1,-1,1>  scale<.1/2,2.15/2,6/2> translate<.65,3,-3.0> }   
      sphere{<0,0,0>,3 scale<1,.03,1.5> translate<0,2.25,-1.5>}      
    }    
#end   

  
#declare wagon =
union{  
  box{<-11.5,0,-3/12>,<0.75,4/12,3/13> texture{mossyOldWood rotate<0,90,0>}}
  box{<-.25,4/12,3>,<0.25,8/12,-3> pigment{darkOak scale .2 translate<0,6/12,0> rotate<1,1,1>} }
    
  object{rearAxle}    
  
  #declare notUseAsInclude = false;  
  #include "frntaxle.pov"
  object{frontAxle translate<0,-8/12,0>rotate<0,30,0> }
  #declare notUseAsInclude = true;
  
  object{aftBoard  texture{mossyOldWood rotate<0,90,0> translate<0,0,-7>}}
  object{foreBoard  texture{mossyOldWood rotate<0,90,0> translate<-5,2,-9>}}
  
  union{
    object{lBottomSideBoard}   
    object{lTopSideBoard}   
    object{rBottomSideBoard}   
    object{rTopSideBoard}   
    texture{mossyOldWood}
  }
  
  object{reinfStrap translate<-0,0,-3.1> }            
  object{reinfStrap translate<-4,0,-3.1> }            
  object{reinfStrap translate<-7,0,-3.1> }            
  object{reinfStrap translate<-11,0,-3.1> } 
             
  object{reinfStrap translate<-0,0,3.0> }            
  object{reinfStrap translate<-4,0,3.0> }            
  object{reinfStrap translate<-7,0,3.0> }            
  object{reinfStrap translate<-11,0,3.0> }            
  
  union{
    box{<-.1,.9,-3.1>,<.1,3.1,-3.12> translate<-9,0,0> }
    box{<-.1,.9,-3.1>,<.1,3.1,-3.12> translate<-5,0,0> }
    box{<-.1,0,0>, <.1,1,-.02> rotate<-20,0,0> translate<-9,3.1,-3.1> }
    box{<-.1,0,0>, <.1,1,-.02> rotate<-20,0,0> translate<-5,3.1,-3.1> }
    
    box{<-.1,.9, 3.1>,<.1,3.1, 3.12> translate<-9,0,0> }
    box{<-.1,.9, 3.1>,<.1,3.1, 3.12> translate<-5,0,0> }
    box{<-.1,0,0>, <.1,1,-.02> rotate< 20,0,0> translate<-9,3.1, 3.2> }
    box{<-.1,0,0>, <.1,1,-.02> rotate< 20,0,0> translate<-5,3.1, 3.1> }
   texture{xRusty_Iron scale .2}
  }    
  object{topRail scale<1.25,.875,1> rotate<-20,0,0> translate<-12,4.125,-3.445>}
  object{topRail2 scale<1.25,.875,1> rotate<20,5,-10> translate<-12,4.5,3.445>}  
  object{seat rotate<0,-90,0> rotate<20,0,0>translate<-.75,2.625,0>}  
}  



#if (notIncludeWagon)  
  object{wagon rotate<-15,0,1> rotate<0,45,0> translate<0,-1.25,0>} 
//    object{woodRim scale<1,1,1.5> rotate<10,52,0> translate<-4,-.5,-5> finish { ambient .3}}            
#end
 



