//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 26 materials and 166 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1991-1999 Lutz + Kretzschmar
//

//  Date : 01/23/2000    (23.01.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }





#declare Air = 

   media  // Air

   {

      samples 20,100

      confidence 0.999

      variance 1.0/2.0

      scattering

      {

         3 ,  rgb <0.015, 0.014, 0.005> // mie murky scattering

         extinction 0.1

      }

   }


media { Air }

camera {  //  Camera StdCam
  location  <     -0.792,     -37.737,       5.401>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      0.000,      -0.651,       6.182>
}

//
// *******  L I G H T S *******
//

light_source {   // Spotlight Spotlight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    37.711  // outer radius (in deg)
    radius     22.894  // inner radius
    tightness  0.000
  media_attenuation on
  scale <26.805412, 30.363985, 22.306416>
  rotate 20.731836*y
  translate  <14.973322, 0.101021, 35.555881>
}


//
// ********  MATERIALS  *******
//

#include "ruins.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

cylinder { // Cylndr006
  <0,0,1>, <0,0,0>, 1 
  material {
    Rusty_Iron
  }
  scale <0.1, 0.1, 8.0>
  rotate <-90.0, 0.0, 101.131218>
  translate  <8.601935, -10.895784, 0.1>
}


#include "G:\MORAYWIN\POVScn\man.inc"

#declare Hat_1_hat_1_Ref = object {
  Hat_1_hat_1
  material {
    Hat
  }
  scale <1.15, 1.0, 1.0>
  translate  -0.01*y
}
#declare Hat_1_band_1_Ref = object {
  Hat_1_band_1
  material {
    Hat2
  }
  scale <1.15, 1.0, 1.0>
  translate  -0.01*y
}
#declare hip_3_pants_3_Ref = object {
  hip_3_pants_3
  material {
    Pants
  }
}
#declare hip_3_belt_3_Ref = object {
  hip_3_belt_3
  material {
    Belt
  }
}
#declare hip_3_buckle_3_Ref = object {
  hip_3_buckle_3
  material {
    Copper_Metal
  }
}
#declare hip_3_shirt_3_Ref = object {
  hip_3_shirt_3
  material {
    Shirt
  }
}
#declare abdomen_3_pants_3_Ref = object {
  abdomen_3_pants_3
  material {
    Shirt
  }
}
#declare chest_3_pants_3_Ref = object {
  chest_3_pants_3
  material {
    Shirt
  }
}
#declare chest_3_belt_3_Ref = object {
  chest_3_belt_3
  material {
    Shirt
  }
}
#declare neck_3_pants_3_Ref = object {
  neck_3_pants_3
  material {
    Skin
  }
}
#declare head_3_pants_3_Ref = object {
  head_3_pants_3
  material {
    Skin
  }
}
#declare head_3_belt_3_Ref = object {
  head_3_belt_3
  material {
    Skin
  }
}
#declare head_3_buckle_3_Ref = object {
  head_3_buckle_3
  material {
    Skin
  }
}
#declare head_3_shirt_3_Ref = object {
  head_3_shirt_3
  material {
    Bone
  }
}
#declare head_3_shirt_3_0_Ref = object {
  head_3_shirt_3_0
  material {
    Hair
  }
}
#declare head_3_shirt_3_1_Ref = object {
  head_3_shirt_3_1
  material {
    Lips
  }
}
#declare head_3_skin_3_Ref = object {
  head_3_skin_3
  material {
    Bone
  }
}
#declare leftEye_3_pants_3_Ref = object {
  leftEye_3_pants_3
  material {
    Eye1
  }
}
#declare leftEye_3_belt_3_Ref = object {
  leftEye_3_belt_3
  material {
    Eye2
  }
}
#declare leftEye_3_buckle_3_Ref = object {
  leftEye_3_buckle_3
  material {
    Eye3
  }
}
#declare rightEye_3_pants_3_Ref = object {
  rightEye_3_pants_3
  material {
    Eye1
  }
}
#declare rightEye_3_belt_3_Ref = object {
  rightEye_3_belt_3
  material {
    Eye2
  }
}
#declare rightEye_3_buckle_3_Ref = object {
  rightEye_3_buckle_3
  material {
    Eye3
  }
}
#declare rCollar_3_pants_3_Ref = object {
  rCollar_3_pants_3
  material {
    Shirt
  }
}
#declare rShldr_3_pants_3_Ref = object {
  rShldr_3_pants_3
  material {
    Shirt
  }
}
#declare rShldr_3_belt_3_Ref = object {
  rShldr_3_belt_3
  material {
    Skin
  }
}
#declare rForeArm_3_pants_3_Ref = object {
  rForeArm_3_pants_3
  material {
    Skin
  }
}
#declare rHand_3_pants_3_Ref = object {
  rHand_3_pants_3
  material {
    Skin
  }
}
#declare rThumb1_3_pants_3_Ref = object {
  rThumb1_3_pants_3
  material {
    Skin
  }
}
#declare rThumb2_3_pants_3_Ref = object {
  rThumb2_3_pants_3
  material {
    Skin
  }
}
#declare rThumb3_3_pants_3_Ref = object {
  rThumb3_3_pants_3
  material {
    Skin
  }
}
#declare rThumb3_3_belt_3_Ref = object {
  rThumb3_3_belt_3
  material {
    Skin
  }
}
#declare rIndex1_3_pants_3_Ref = object {
  rIndex1_3_pants_3
  material {
    Skin
  }
}
#declare rIndex2_3_pants_3_Ref = object {
  rIndex2_3_pants_3
  material {
    Skin
  }
}
#declare rIndex3_3_pants_3_Ref = object {
  rIndex3_3_pants_3
  material {
    Skin
  }
}
#declare rIndex3_3_belt_3_Ref = object {
  rIndex3_3_belt_3
  material {
    Skin
  }
}
#declare rMid1_3_pants_3_Ref = object {
  rMid1_3_pants_3
  material {
    Skin
  }
}
#declare rMid2_3_pants_3_Ref = object {
  rMid2_3_pants_3
  material {
    Skin
  }
}
#declare rMid3_3_pants_3_Ref = object {
  rMid3_3_pants_3
  material {
    Skin
  }
}
#declare rMid3_3_belt_3_Ref = object {
  rMid3_3_belt_3
  material {
    Skin
  }
}
#declare rRing1_3_pants_3_Ref = object {
  rRing1_3_pants_3
  material {
    Skin
  }
}
#declare rRing2_3_pants_3_Ref = object {
  rRing2_3_pants_3
  material {
    Skin
  }
}
#declare rRing3_3_pants_3_Ref = object {
  rRing3_3_pants_3
  material {
    Skin
  }
}
#declare rRing3_3_belt_3_Ref = object {
  rRing3_3_belt_3
  material {
    Skin
  }
}
#declare rPinky1_3_pants_3_Ref = object {
  rPinky1_3_pants_3
  material {
    Skin
  }
}
#declare rPinky2_3_pants_3_Ref = object {
  rPinky2_3_pants_3
  material {
    Skin
  }
}
#declare rPinky3_3_pants_3_Ref = object {
  rPinky3_3_pants_3
  material {
    Skin
  }
}
#declare rPinky3_3_belt_3_Ref = object {
  rPinky3_3_belt_3
  material {
    Skin
  }
}
#declare lCollar_3_pants_3_Ref = object {
  lCollar_3_pants_3
  material {
    Shirt
  }
}
#declare lShldr_3_pants_3_Ref = object {
  lShldr_3_pants_3
  material {
    Shirt
  }
}
#declare lShldr_3_belt_3_Ref = object {
  lShldr_3_belt_3
  material {
    Skin
  }
}
#declare lForeArm_3_pants_3_Ref = object {
  lForeArm_3_pants_3
  material {
    Skin
  }
}
#declare lHand_3_pants_3_Ref = object {
  lHand_3_pants_3
  material {
    Skin
  }
}
#declare lThumb1_3_pants_3_Ref = object {
  lThumb1_3_pants_3
  material {
    Skin
  }
}
#declare lThumb2_3_pants_3_Ref = object {
  lThumb2_3_pants_3
  material {
    Skin
  }
}
#declare lThumb3_3_pants_3_Ref = object {
  lThumb3_3_pants_3
  material {
    Skin
  }
}
#declare lThumb3_3_belt_3_Ref = object {
  lThumb3_3_belt_3
  material {
    Skin
  }
}
#declare lIndex1_3_pants_3_Ref = object {
  lIndex1_3_pants_3
  material {
    Skin
  }
}
#declare lIndex2_3_pants_3_Ref = object {
  lIndex2_3_pants_3
  material {
    Skin
  }
}
#declare lIndex3_3_pants_3_Ref = object {
  lIndex3_3_pants_3
  material {
    Skin
  }
}
#declare lIndex3_3_belt_3_Ref = object {
  lIndex3_3_belt_3
  material {
    Skin
  }
}
#declare lMid1_3_pants_3_Ref = object {
  lMid1_3_pants_3
  material {
    Skin
  }
}
#declare lMid2_3_pants_3_Ref = object {
  lMid2_3_pants_3
  material {
    Skin
  }
}
#declare lMid3_3_pants_3_Ref = object {
  lMid3_3_pants_3
  material {
    Skin
  }
}
#declare lMid3_3_belt_3_Ref = object {
  lMid3_3_belt_3
  material {
    Skin
  }
}
#declare lRing1_3_pants_3_Ref = object {
  lRing1_3_pants_3
  material {
    Skin
  }
}
#declare lRing2_3_pants_3_Ref = object {
  lRing2_3_pants_3
  material {
    Skin
  }
}
#declare lRing3_3_pants_3_Ref = object {
  lRing3_3_pants_3
  material {
    Skin
  }
}
#declare lRing3_3_belt_3_Ref = object {
  lRing3_3_belt_3
  material {
    Skin
  }
}
#declare lPinky1_3_pants_3_Ref = object {
  lPinky1_3_pants_3
  material {
    Skin
  }
}
#declare lPinky2_3_pants_3_Ref = object {
  lPinky2_3_pants_3
  material {
    Skin
  }
}
#declare lPinky3_3_pants_3_Ref = object {
  lPinky3_3_pants_3
  material {
    Skin
  }
}
#declare lPinky3_3_belt_3_Ref = object {
  lPinky3_3_belt_3
  material {
    Skin
  }
}
#declare rThigh_3_pants_3_Ref = object {
  rThigh_3_pants_3
  material {
    Pants
  }
}
#declare rShin_3_pants_3_Ref = object {
  rShin_3_pants_3
  material {
    Pants
  }
}
#declare rShin_3_belt_3_Ref = object {
  rShin_3_belt_3
  material {
    Pants
  }
}
#declare rFoot_3_pants_3_Ref = object {
  rFoot_3_pants_3
  material {
    Pants
  }
}
#declare rFoot_3_belt_3_Ref = object {
  rFoot_3_belt_3
  material {
    Boots
  }
}
#declare rFoot_3_buckle_3_Ref = object {
  rFoot_3_buckle_3
  material {
    Boots
  }
}
#declare rFoot_3_shirt_3_Ref = object {
  rFoot_3_shirt_3
  material {
    Boots_1
  }
}
#declare rToe_3_pants_3_Ref = object {
  rToe_3_pants_3
  material {
    Boots
  }
}
#declare rToe_3_belt_3_Ref = object {
  rToe_3_belt_3
  material {
    Boots
  }
}
#declare lThigh_3_pants_3_Ref = object {
  lThigh_3_pants_3
  material {
    Pants
  }
}
#declare lShin_3_pants_3_Ref = object {
  lShin_3_pants_3
  material {
    Pants
  }
}
#declare lShin_3_belt_3_Ref = object {
  lShin_3_belt_3
  material {
    Pants
  }
}
#declare lFoot_3_pants_3_Ref = object {
  lFoot_3_pants_3
  material {
    Pants
  }
}
#declare lFoot_3_belt_3_Ref = object {
  lFoot_3_belt_3
  material {
    Boots
  }
}
#declare lFoot_3_buckle_3_Ref = object {
  lFoot_3_buckle_3
  material {
    Boots
  }
}
#declare lFoot_3_shirt_3_Ref = object {
  lFoot_3_shirt_3
  material {
    Boots_1
  }
}
#declare lToe_3_pants_3_Ref = object {
  lToe_3_pants_3
  material {
    Boots
  }
}
#declare lToe_3_belt_3_Ref = object {
  lToe_3_belt_3
  material {
    Boots
  }
}
#declare figureHair_3_pants_3_Ref = object {
  figureHair_3_pants_3
  material {
    Hair
  }
}
union { // man_group
  object { Hat_1_hat_1_Ref }
  object { Hat_1_band_1_Ref }
  object { hip_3_pants_3_Ref }
  object { hip_3_belt_3_Ref }
  object { hip_3_buckle_3_Ref }
  object { hip_3_shirt_3_Ref }
  object { abdomen_3_pants_3_Ref }
  object { chest_3_pants_3_Ref }
  object { chest_3_belt_3_Ref }
  object { neck_3_pants_3_Ref }
  object { head_3_pants_3_Ref }
  object { head_3_belt_3_Ref }
  object { head_3_buckle_3_Ref }
  object { head_3_shirt_3_Ref }
  object { head_3_shirt_3_0_Ref }
  object { head_3_shirt_3_1_Ref }
  object { head_3_skin_3_Ref }
  object { leftEye_3_pants_3_Ref }
  object { leftEye_3_belt_3_Ref }
  object { leftEye_3_buckle_3_Ref }
  object { rightEye_3_pants_3_Ref }
  object { rightEye_3_belt_3_Ref }
  object { rightEye_3_buckle_3_Ref }
  object { rCollar_3_pants_3_Ref }
  object { rShldr_3_pants_3_Ref }
  object { rShldr_3_belt_3_Ref }
  object { rForeArm_3_pants_3_Ref }
  object { rHand_3_pants_3_Ref }
  object { rThumb1_3_pants_3_Ref }
  object { rThumb2_3_pants_3_Ref }
  object { rThumb3_3_pants_3_Ref }
  object { rThumb3_3_belt_3_Ref }
  object { rIndex1_3_pants_3_Ref }
  object { rIndex2_3_pants_3_Ref }
  object { rIndex3_3_pants_3_Ref }
  object { rIndex3_3_belt_3_Ref }
  object { rMid1_3_pants_3_Ref }
  object { rMid2_3_pants_3_Ref }
  object { rMid3_3_pants_3_Ref }
  object { rMid3_3_belt_3_Ref }
  object { rRing1_3_pants_3_Ref }
  object { rRing2_3_pants_3_Ref }
  object { rRing3_3_pants_3_Ref }
  object { rRing3_3_belt_3_Ref }
  object { rPinky1_3_pants_3_Ref }
  object { rPinky2_3_pants_3_Ref }
  object { rPinky3_3_pants_3_Ref }
  object { rPinky3_3_belt_3_Ref }
  object { lCollar_3_pants_3_Ref }
  object { lShldr_3_pants_3_Ref }
  object { lShldr_3_belt_3_Ref }
  object { lForeArm_3_pants_3_Ref }
  object { lHand_3_pants_3_Ref }
  object { lThumb1_3_pants_3_Ref }
  object { lThumb2_3_pants_3_Ref }
  object { lThumb3_3_pants_3_Ref }
  object { lThumb3_3_belt_3_Ref }
  object { lIndex1_3_pants_3_Ref }
  object { lIndex2_3_pants_3_Ref }
  object { lIndex3_3_pants_3_Ref }
  object { lIndex3_3_belt_3_Ref }
  object { lMid1_3_pants_3_Ref }
  object { lMid2_3_pants_3_Ref }
  object { lMid3_3_pants_3_Ref }
  object { lMid3_3_belt_3_Ref }
  object { lRing1_3_pants_3_Ref }
  object { lRing2_3_pants_3_Ref }
  object { lRing3_3_pants_3_Ref }
  object { lRing3_3_belt_3_Ref }
  object { lPinky1_3_pants_3_Ref }
  object { lPinky2_3_pants_3_Ref }
  object { lPinky3_3_pants_3_Ref }
  object { lPinky3_3_belt_3_Ref }
  object { rThigh_3_pants_3_Ref }
  object { rShin_3_pants_3_Ref }
  object { rShin_3_belt_3_Ref }
  object { rFoot_3_pants_3_Ref }
  object { rFoot_3_belt_3_Ref }
  object { rFoot_3_buckle_3_Ref }
  object { rFoot_3_shirt_3_Ref }
  object { rToe_3_pants_3_Ref }
  object { rToe_3_belt_3_Ref }
  object { lThigh_3_pants_3_Ref }
  object { lShin_3_pants_3_Ref }
  object { lShin_3_belt_3_Ref }
  object { lFoot_3_pants_3_Ref }
  object { lFoot_3_belt_3_Ref }
  object { lFoot_3_buckle_3_Ref }
  object { lFoot_3_shirt_3_Ref }
  object { lToe_3_pants_3_Ref }
  object { lToe_3_belt_3_Ref }
  object { figureHair_3_pants_3_Ref }
  scale 13.249704
  rotate <90.0, 4.360433, 125.293442>
  translate  <-4.386937, -5.65843, -0.343851>
}


sphere { // Sphere001
  <0,0,0>,1
  material {
    Evening_Cloud_Sky
  }
  no_shadow
  hollow
  scale <229.792374, 227.60173, 87.400352>
}


#declare sPatchObj1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.219248, 7.400001, 1.500000>, <0.219248, 7.399057, 1.380338>, <0.119665, 7.398270, 1.280759>, <0.000000, 7.398270, 1.280759>, 
      <0.195697, 7.250001, 1.470000>, <0.195697, 7.249056, 1.350339>, <0.119665, 7.265638, 1.277815>, <0.000000, 7.265638, 1.277815>, 
      <0.153507, 7.046331, 1.448777>, <0.153507, 7.076984, 1.378340>, <0.076817, 7.085345, 1.301140>, <0.000000, 7.085345, 1.301140>, 
      <0.140743, 6.900001, 1.400000>, <0.140743, 6.930654, 1.329563>, <0.076817, 6.956161, 1.270947>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 7.401731, 1.719241>, <0.119665, 7.401731, 1.719241>, <0.219248, 7.400946, 1.619662>, <0.219248, 7.400001, 1.500000>, 
      <0.000000, 7.234363, 1.662184>, <0.119665, 7.234363, 1.662184>, <0.195697, 7.250946, 1.589662>, <0.195697, 7.250001, 1.470000>, 
      <0.000000, 7.007190, 1.596760>, <0.076817, 7.007190, 1.596760>, <0.153507, 7.015679, 1.519213>, <0.153507, 7.046331, 1.448777>, 
      <0.000000, 6.843840, 1.529052>, <0.076817, 6.843840, 1.529052>, <0.140743, 6.869349, 1.470437>, <0.140743, 6.900001, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219248, 7.400001, 1.500000>, <-0.219248, 7.400946, 1.619662>, <-0.119665, 7.401731, 1.719241>, <0.000000, 7.401731, 1.719241>, 
      <-0.195697, 7.250001, 1.470000>, <-0.195697, 7.250946, 1.589662>, <-0.119665, 7.234363, 1.662184>, <0.000000, 7.234363, 1.662184>, 
      <-0.153507, 7.046331, 1.448777>, <-0.153507, 7.015679, 1.519213>, <-0.076817, 7.007190, 1.596760>, <0.000000, 7.007190, 1.596760>, 
      <-0.140743, 6.900001, 1.400000>, <-0.140743, 6.869349, 1.470437>, <-0.076817, 6.843840, 1.529052>, <0.000000, 6.843840, 1.529052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219248, 7.400001, 1.500000>, <-0.195697, 7.250001, 1.470000>, <-0.153507, 7.046331, 1.448777>, <-0.140743, 6.900001, 1.400000>, 
      <-0.219248, 7.399057, 1.380338>, <-0.195697, 7.249056, 1.350339>, <-0.153507, 7.076984, 1.378340>, <-0.140743, 6.930654, 1.329563>, 
      <-0.119665, 7.398270, 1.280759>, <-0.119665, 7.265638, 1.277815>, <-0.076817, 7.085345, 1.301140>, <-0.076817, 6.956161, 1.270947>, 
      <0.000000, 7.398270, 1.280759>, <0.000000, 7.265638, 1.277815>, <0.000000, 7.085345, 1.301140>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.500000, 1.200000>, <0.140743, 6.594869, 1.294869>, <0.129679, 6.773155, 1.357718>, <0.140743, 6.900001, 1.400000>, 
      <0.140743, 6.549170, 1.140982>, <0.140743, 6.644039, 1.235850>, <0.129679, 6.803808, 1.287281>, <0.140743, 6.930654, 1.329563>, 
      <0.076817, 6.590089, 1.091868>, <0.076817, 6.676048, 1.178805>, <0.076817, 6.837111, 1.243122>, <0.076817, 6.956161, 1.270947>, 
      <0.000000, 6.590089, 1.091868>, <0.000000, 6.676048, 1.178805>, <0.000000, 6.837111, 1.243122>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.409912, 1.308132>, <0.000000, 6.513676, 1.410952>, <0.000000, 6.708895, 1.473117>, <0.000000, 6.843840, 1.529052>, 
      <0.076817, 6.409912, 1.308132>, <0.076817, 6.513676, 1.410952>, <0.076817, 6.708895, 1.473117>, <0.076817, 6.843840, 1.529052>, 
      <0.140743, 6.450830, 1.259018>, <0.140743, 6.545699, 1.353887>, <0.129679, 6.742502, 1.428155>, <0.140743, 6.869349, 1.470437>, 
      <0.140743, 6.500000, 1.200000>, <0.140743, 6.594869, 1.294869>, <0.129679, 6.773155, 1.357718>, <0.140743, 6.900001, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.594869, 1.294869>, <-0.129679, 6.773155, 1.357718>, <-0.140743, 6.900001, 1.400000>, 
      <-0.140743, 6.450830, 1.259018>, <-0.140743, 6.545699, 1.353887>, <-0.129679, 6.742502, 1.428155>, <-0.140743, 6.869349, 1.470437>, 
      <-0.076817, 6.409912, 1.308132>, <-0.076817, 6.513676, 1.410952>, <-0.076817, 6.708895, 1.473117>, <-0.076817, 6.843840, 1.529052>, 
      <0.000000, 6.409912, 1.308132>, <0.000000, 6.513676, 1.410952>, <0.000000, 6.708895, 1.473117>, <0.000000, 6.843840, 1.529052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.549170, 1.140982>, <-0.076817, 6.590089, 1.091868>, <0.000000, 6.590089, 1.091868>, 
      <-0.140743, 6.594869, 1.294869>, <-0.140743, 6.644039, 1.235850>, <-0.076817, 6.676048, 1.178805>, <0.000000, 6.676048, 1.178805>, 
      <-0.129679, 6.773155, 1.357718>, <-0.129679, 6.803808, 1.287281>, <-0.076817, 6.837111, 1.243122>, <0.000000, 6.837111, 1.243122>, 
      <-0.140743, 6.900001, 1.400000>, <-0.140743, 6.930654, 1.329563>, <-0.076817, 6.956161, 1.270947>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.300001, 0.800000>, <0.140743, 6.347109, 0.925622>, <0.140743, 6.405132, 1.105132>, <0.140743, 6.500000, 1.200000>, 
      <0.140743, 6.367223, 0.762823>, <0.140743, 6.414331, 0.888445>, <0.140743, 6.454302, 1.046113>, <0.140743, 6.549170, 1.140982>, 
      <0.076817, 6.423163, 0.731885>, <0.076817, 6.463122, 0.844019>, <0.076817, 6.506392, 1.007219>, <0.076817, 6.590089, 1.091868>, 
      <0.000000, 6.423163, 0.731885>, <0.000000, 6.463122, 0.844019>, <0.000000, 6.506392, 1.007219>, <0.000000, 6.590089, 1.091868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.176838, 0.868115>, <0.000000, 6.231413, 1.007169>, <0.000000, 6.303803, 1.202988>, <0.000000, 6.409912, 1.308132>, 
      <0.076818, 6.176838, 0.868115>, <0.076818, 6.231413, 1.007169>, <0.076817, 6.303803, 1.202988>, <0.076817, 6.409912, 1.308132>, 
      <0.140743, 6.232779, 0.837177>, <0.140743, 6.279887, 0.962799>, <0.140743, 6.355962, 1.164150>, <0.140743, 6.450830, 1.259018>, 
      <0.140743, 6.300001, 0.800000>, <0.140743, 6.347109, 0.925622>, <0.140743, 6.405132, 1.105132>, <0.140743, 6.500000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.347109, 0.925622>, <-0.140743, 6.405132, 1.105132>, <-0.140743, 6.500000, 1.200000>, 
      <-0.140743, 6.232779, 0.837177>, <-0.140743, 6.279887, 0.962799>, <-0.140743, 6.355962, 1.164150>, <-0.140743, 6.450830, 1.259018>, 
      <-0.076818, 6.176838, 0.868115>, <-0.076818, 6.231413, 1.007169>, <-0.076817, 6.303803, 1.202988>, <-0.076817, 6.409912, 1.308132>, 
      <0.000000, 6.176838, 0.868115>, <0.000000, 6.231413, 1.007169>, <0.000000, 6.303803, 1.202988>, <0.000000, 6.409912, 1.308132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.367223, 0.762823>, <-0.076817, 6.423163, 0.731885>, <0.000000, 6.423163, 0.731885>, 
      <-0.140743, 6.347109, 0.925622>, <-0.140743, 6.414331, 0.888445>, <-0.076817, 6.463122, 0.844019>, <0.000000, 6.463122, 0.844019>, 
      <-0.140743, 6.405132, 1.105132>, <-0.140743, 6.454302, 1.046113>, <-0.076817, 6.506392, 1.007219>, <0.000000, 6.506392, 1.007219>, 
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.549170, 1.140982>, <-0.076817, 6.590089, 1.091868>, <0.000000, 6.590089, 1.091868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.200001, 0.400000>, <0.140743, 6.261370, 0.507396>, <0.140743, 6.256570, 0.684182>, <0.140743, 6.300001, 0.800000>, 
      <0.140743, 6.262360, 0.355143>, <0.140743, 6.323730, 0.462539>, <0.140743, 6.323792, 0.647006>, <0.140743, 6.367223, 0.762823>, 
      <0.076817, 6.314255, 0.317814>, <0.076817, 6.379783, 0.428288>, <0.076817, 6.380047, 0.610892>, <0.076817, 6.423163, 0.731885>, 
      <0.000000, 6.314255, 0.317814>, <0.000000, 6.379783, 0.428288>, <0.000000, 6.380047, 0.610892>, <0.000000, 6.423163, 0.731885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.085747, 0.482186>, <0.000000, 6.142796, 0.586574>, <0.000000, 6.133376, 0.757378>, <0.000000, 6.176838, 0.868115>, 
      <0.076817, 6.085747, 0.482186>, <0.076817, 6.142796, 0.586574>, <0.076818, 6.133376, 0.757378>, <0.076818, 6.176838, 0.868115>, 
      <0.140743, 6.137641, 0.444857>, <0.140743, 6.199010, 0.552253>, <0.140743, 6.189348, 0.721360>, <0.140743, 6.232779, 0.837177>, 
      <0.140743, 6.200001, 0.400000>, <0.140743, 6.261370, 0.507396>, <0.140743, 6.256570, 0.684182>, <0.140743, 6.300001, 0.800000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.261370, 0.507396>, <-0.140743, 6.256570, 0.684182>, <-0.140743, 6.300001, 0.800000>, 
      <-0.140743, 6.137641, 0.444857>, <-0.140743, 6.199010, 0.552253>, <-0.140743, 6.189348, 0.721360>, <-0.140743, 6.232779, 0.837177>, 
      <-0.076817, 6.085747, 0.482186>, <-0.076817, 6.142796, 0.586574>, <-0.076818, 6.133376, 0.757378>, <-0.076818, 6.176838, 0.868115>, 
      <0.000000, 6.085747, 0.482186>, <0.000000, 6.142796, 0.586574>, <0.000000, 6.133376, 0.757378>, <0.000000, 6.176838, 0.868115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.262360, 0.355143>, <-0.076817, 6.314255, 0.317814>, <0.000000, 6.314255, 0.317814>, 
      <-0.140743, 6.261370, 0.507396>, <-0.140743, 6.323730, 0.462539>, <-0.076817, 6.379783, 0.428288>, <0.000000, 6.379783, 0.428288>, 
      <-0.140743, 6.256570, 0.684182>, <-0.140743, 6.323792, 0.647006>, <-0.076817, 6.380047, 0.610892>, <0.000000, 6.380047, 0.610892>, 
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.367223, 0.762823>, <-0.076817, 6.423163, 0.731885>, <0.000000, 6.423163, 0.731885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 5.900001, 0.100000>, <0.140743, 6.005904, 0.170602>, <0.140743, 6.136853, 0.289491>, <0.140743, 6.200001, 0.400000>, 
      <0.140743, 5.943369, 0.036596>, <0.140743, 6.049272, 0.107198>, <0.140743, 6.199212, 0.244634>, <0.140743, 6.262360, 0.355143>, 
      <0.076817, 5.979459, -0.016168>, <0.076817, 6.098843, 0.060477>, <0.076817, 6.241880, 0.195795>, <0.076817, 6.314255, 0.317814>, 
      <0.000000, 5.979459, -0.016168>, <0.000000, 6.098843, 0.060477>, <0.000000, 6.241880, 0.195795>, <0.000000, 6.314255, 0.317814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 5.820542, 0.216168>, <0.000000, 5.912734, 0.280972>, <0.000000, 6.031705, 0.383300>, <0.000000, 6.085747, 0.482186>, 
      <0.076817, 5.820542, 0.216168>, <0.076817, 5.912734, 0.280972>, <0.076817, 6.031705, 0.383300>, <0.076817, 6.085747, 0.482186>, 
      <0.140743, 5.856633, 0.163404>, <0.140743, 5.962535, 0.234006>, <0.140743, 6.074493, 0.334348>, <0.140743, 6.137641, 0.444857>, 
      <0.140743, 5.900001, 0.100000>, <0.140743, 6.005904, 0.170602>, <0.140743, 6.136853, 0.289491>, <0.140743, 6.200001, 0.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 6.005904, 0.170602>, <-0.140743, 6.136853, 0.289491>, <-0.140743, 6.200001, 0.400000>, 
      <-0.140743, 5.856633, 0.163404>, <-0.140743, 5.962535, 0.234006>, <-0.140743, 6.074493, 0.334348>, <-0.140743, 6.137641, 0.444857>, 
      <-0.076817, 5.820542, 0.216168>, <-0.076817, 5.912734, 0.280972>, <-0.076817, 6.031705, 0.383300>, <-0.076817, 6.085747, 0.482186>, 
      <0.000000, 5.820542, 0.216168>, <0.000000, 5.912734, 0.280972>, <0.000000, 6.031705, 0.383300>, <0.000000, 6.085747, 0.482186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 5.943369, 0.036596>, <-0.076817, 5.979459, -0.016168>, <0.000000, 5.979459, -0.016168>, 
      <-0.140743, 6.005904, 0.170602>, <-0.140743, 6.049272, 0.107198>, <-0.076817, 6.098843, 0.060477>, <0.000000, 6.098843, 0.060477>, 
      <-0.140743, 6.136853, 0.289491>, <-0.140743, 6.199212, 0.244634>, <-0.076817, 6.241880, 0.195795>, <0.000000, 6.241880, 0.195795>, 
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.262360, 0.355143>, <-0.076817, 6.314255, 0.317814>, <0.000000, 6.314255, 0.317814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 5.600000, 0.000000>, <0.140743, 5.694855, 0.001608>, <0.140743, 5.821066, 0.047376>, <0.140743, 5.900001, 0.100000>, 
      <0.140743, 5.600000, -0.076817>, <0.140743, 5.694855, -0.075210>, <0.140743, 5.864434, -0.016028>, <0.140743, 5.943369, 0.036596>, 
      <0.076817, 5.600000, -0.140743>, <0.076817, 5.719790, -0.138247>, <0.076817, 5.878634, -0.080898>, <0.076817, 5.979459, -0.016168>, 
      <0.000000, 5.600000, -0.140743>, <0.000000, 5.719790, -0.138247>, <0.000000, 5.878634, -0.080898>, <0.000000, 5.979459, -0.016168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 5.600000, 0.140743>, <0.000000, 5.669919, 0.141649>, <0.000000, 5.763336, 0.175957>, <0.000000, 5.820542, 0.216168>, 
      <0.076817, 5.600000, 0.140743>, <0.076817, 5.669919, 0.141649>, <0.076817, 5.763336, 0.175957>, <0.076817, 5.820542, 0.216168>, 
      <0.140743, 5.600000, 0.076817>, <0.140743, 5.694855, 0.078425>, <0.140743, 5.777697, 0.110781>, <0.140743, 5.856633, 0.163404>, 
      <0.140743, 5.600000, 0.000000>, <0.140743, 5.694855, 0.001608>, <0.140743, 5.821066, 0.047376>, <0.140743, 5.900001, 0.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.694855, 0.001608>, <-0.140743, 5.821066, 0.047376>, <-0.140743, 5.900001, 0.100000>, 
      <-0.140743, 5.600000, 0.076817>, <-0.140743, 5.694855, 0.078425>, <-0.140743, 5.777697, 0.110781>, <-0.140743, 5.856633, 0.163404>, 
      <-0.076817, 5.600000, 0.140743>, <-0.076817, 5.669919, 0.141649>, <-0.076817, 5.763336, 0.175957>, <-0.076817, 5.820542, 0.216168>, 
      <0.000000, 5.600000, 0.140743>, <0.000000, 5.669919, 0.141649>, <0.000000, 5.763336, 0.175957>, <0.000000, 5.820542, 0.216168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.600000, -0.076817>, <-0.076817, 5.600000, -0.140743>, <0.000000, 5.600000, -0.140743>, 
      <-0.140743, 5.694855, 0.001608>, <-0.140743, 5.694855, -0.075210>, <-0.076817, 5.719790, -0.138247>, <0.000000, 5.719790, -0.138247>, 
      <-0.140743, 5.821066, 0.047376>, <-0.140743, 5.864434, -0.016028>, <-0.076817, 5.878634, -0.080898>, <0.000000, 5.878634, -0.080898>, 
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 5.943369, 0.036596>, <-0.076817, 5.979459, -0.016168>, <0.000000, 5.979459, -0.016168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -1.500000, 1.300000>, <0.140743, -1.410000, 1.270000>, <0.140743, -1.282369, 1.247068>, <0.140743, -1.200000, 1.200000>, 
      <0.140743, -1.500606, 1.223185>, <0.140743, -1.410606, 1.193185>, <0.140743, -1.286611, 1.170368>, <0.140743, -1.204243, 1.123300>, 
      <0.076817, -1.501111, 1.159261>, <0.076817, -1.413110, 1.129324>, <0.076817, -1.287603, 1.107091>, <0.076817, -1.207773, 1.059472>, 
      <0.000000, -1.501111, 1.159261>, <0.000000, -1.413110, 1.129324>, <0.000000, -1.287603, 1.107091>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.498889, 1.440739>, <0.000000, -1.406890, 1.410676>, <0.000000, -1.277067, 1.387108>, <0.000000, -1.192227, 1.340528>, 
      <0.076817, -1.498889, 1.440739>, <0.076817, -1.406890, 1.410676>, <0.076817, -1.277067, 1.387108>, <0.076817, -1.192227, 1.340528>, 
      <0.140743, -1.499394, 1.376815>, <0.140743, -1.409394, 1.346815>, <0.140743, -1.278126, 1.323768>, <0.140743, -1.195758, 1.276700>, 
      <0.140743, -1.500000, 1.300000>, <0.140743, -1.410000, 1.270000>, <0.140743, -1.282369, 1.247068>, <0.140743, -1.200000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -1.500000, 1.300000>, <-0.140743, -1.410000, 1.270000>, <-0.140743, -1.282369, 1.247068>, <-0.140743, -1.200000, 1.200000>, 
      <-0.140743, -1.499394, 1.376815>, <-0.140743, -1.409394, 1.346815>, <-0.140743, -1.278126, 1.323768>, <-0.140743, -1.195758, 1.276700>, 
      <-0.076817, -1.498889, 1.440739>, <-0.076817, -1.406890, 1.410676>, <-0.076817, -1.277067, 1.387108>, <-0.076817, -1.192227, 1.340528>, 
      <0.000000, -1.498889, 1.440739>, <0.000000, -1.406890, 1.410676>, <0.000000, -1.277067, 1.387108>, <0.000000, -1.192227, 1.340528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -1.500000, 1.300000>, <-0.140743, -1.500606, 1.223185>, <-0.076817, -1.501111, 1.159261>, <0.000000, -1.501111, 1.159261>, 
      <-0.140743, -1.410000, 1.270000>, <-0.140743, -1.410606, 1.193185>, <-0.076817, -1.413110, 1.129324>, <0.000000, -1.413110, 1.129324>, 
      <-0.140743, -1.282369, 1.247068>, <-0.140743, -1.286611, 1.170368>, <-0.076817, -1.287603, 1.107091>, <0.000000, -1.287603, 1.107091>, 
      <-0.140743, -1.200000, 1.200000>, <-0.140743, -1.204243, 1.123300>, <-0.076817, -1.207773, 1.059472>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.800000, 0.900000>, <0.140743, -0.822117, 0.826436>, <0.076817, -0.840523, 0.765217>, <0.000000, -0.840523, 0.765217>, 
      <0.140743, -0.906066, 1.006066>, <0.140743, -0.928184, 0.932502>, <0.076817, -0.935585, 0.869593>, <0.000000, -0.935585, 0.869593>, 
      <0.140743, -1.069764, 1.125579>, <0.140743, -1.074006, 1.048879>, <0.076817, -1.086527, 0.987148>, <0.000000, -1.086527, 0.987148>, 
      <0.140743, -1.200000, 1.200000>, <0.140743, -1.204243, 1.123300>, <0.076817, -1.207773, 1.059472>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.759477, 1.034783>, <0.076817, -0.759477, 1.034783>, <0.140743, -0.777883, 0.973564>, <0.140743, -0.800000, 0.900000>, 
      <0.000000, -0.876080, 1.142817>, <0.076817, -0.876080, 1.142817>, <0.140743, -0.883949, 1.079630>, <0.140743, -0.906066, 1.006066>, 
      <0.000000, -1.052888, 1.264027>, <0.076817, -1.052888, 1.264027>, <0.140743, -1.065521, 1.202279>, <0.140743, -1.069764, 1.125579>, 
      <0.000000, -1.192227, 1.340528>, <0.076817, -1.192227, 1.340528>, <0.140743, -1.195758, 1.276700>, <0.140743, -1.200000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.777883, 0.973564>, <-0.076817, -0.759477, 1.034783>, <0.000000, -0.759477, 1.034783>, 
      <-0.140743, -0.906066, 1.006066>, <-0.140743, -0.883949, 1.079630>, <-0.076817, -0.876080, 1.142817>, <0.000000, -0.876080, 1.142817>, 
      <-0.140743, -1.069764, 1.125579>, <-0.140743, -1.065521, 1.202279>, <-0.076817, -1.052888, 1.264027>, <0.000000, -1.052888, 1.264027>, 
      <-0.140743, -1.200000, 1.200000>, <-0.140743, -1.195758, 1.276700>, <-0.076817, -1.192227, 1.340528>, <0.000000, -1.192227, 1.340528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.906066, 1.006066>, <-0.140743, -1.069764, 1.125579>, <-0.140743, -1.200000, 1.200000>, 
      <-0.140743, -0.822117, 0.826436>, <-0.140743, -0.928184, 0.932502>, <-0.140743, -1.074006, 1.048879>, <-0.140743, -1.204243, 1.123300>, 
      <-0.076817, -0.840523, 0.765217>, <-0.076817, -0.935585, 0.869593>, <-0.076817, -1.086527, 0.987148>, <-0.076817, -1.207773, 1.059472>, 
      <0.000000, -0.840523, 0.765217>, <0.000000, -0.935585, 0.869593>, <0.000000, -1.086527, 0.987148>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.600000, 0.600000>, <0.140743, -0.651009, 0.542563>, <0.076817, -0.693458, 0.494766>, <0.000000, -0.693458, 0.494766>, 
      <0.140743, -0.660000, 0.690000>, <0.140743, -0.711009, 0.632563>, <0.076817, -0.740982, 0.573955>, <0.000000, -0.740982, 0.573955>, 
      <0.140743, -0.723515, 0.823515>, <0.140743, -0.745632, 0.749950>, <0.076817, -0.778336, 0.696937>, <0.000000, -0.778336, 0.696937>, 
      <0.140743, -0.800000, 0.900000>, <0.140743, -0.822117, 0.826436>, <0.076817, -0.840523, 0.765217>, <0.000000, -0.840523, 0.765217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.506542, 0.705234>, <0.076817, -0.506542, 0.705234>, <0.140743, -0.548991, 0.657437>, <0.140743, -0.600000, 0.600000>, 
      <0.000000, -0.579132, 0.806539>, <0.076817, -0.579132, 0.806539>, <0.140743, -0.608991, 0.747437>, <0.140743, -0.660000, 0.690000>, 
      <0.000000, -0.668057, 0.950081>, <0.076817, -0.668057, 0.950081>, <0.140743, -0.701397, 0.897079>, <0.140743, -0.723515, 0.823515>, 
      <0.000000, -0.759477, 1.034783>, <0.076817, -0.759477, 1.034783>, <0.140743, -0.777883, 0.973564>, <0.140743, -0.800000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.548991, 0.657437>, <-0.076817, -0.506542, 0.705234>, <0.000000, -0.506542, 0.705234>, 
      <-0.140743, -0.660000, 0.690000>, <-0.140743, -0.608991, 0.747437>, <-0.076817, -0.579132, 0.806539>, <0.000000, -0.579132, 0.806539>, 
      <-0.140743, -0.723515, 0.823515>, <-0.140743, -0.701397, 0.897079>, <-0.076817, -0.668057, 0.950081>, <0.000000, -0.668057, 0.950081>, 
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.777883, 0.973564>, <-0.076817, -0.759477, 1.034783>, <0.000000, -0.759477, 1.034783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.660000, 0.690000>, <-0.140743, -0.723515, 0.823515>, <-0.140743, -0.800000, 0.900000>, 
      <-0.140743, -0.651009, 0.542563>, <-0.140743, -0.711009, 0.632563>, <-0.140743, -0.745632, 0.749950>, <-0.140743, -0.822117, 0.826436>, 
      <-0.076817, -0.693458, 0.494766>, <-0.076817, -0.740982, 0.573955>, <-0.076817, -0.778336, 0.696937>, <-0.076817, -0.840523, 0.765217>, 
      <0.000000, -0.693458, 0.494766>, <0.000000, -0.740982, 0.573955>, <0.000000, -0.778336, 0.696937>, <0.000000, -0.840523, 0.765217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.400000, 0.300000>, <0.140743, -0.472022, 0.273284>, <0.076817, -0.531957, 0.251052>, <0.000000, -0.531957, 0.251052>, 
      <0.140743, -0.467571, 0.384464>, <0.140743, -0.539593, 0.357748>, <0.076817, -0.586693, 0.319587>, <0.000000, -0.586693, 0.319587>, 
      <0.140743, -0.540000, 0.510000>, <0.140743, -0.591009, 0.452563>, <0.076817, -0.648324, 0.419559>, <0.000000, -0.648324, 0.419559>, 
      <0.140743, -0.600000, 0.600000>, <0.140743, -0.651009, 0.542563>, <0.076817, -0.693458, 0.494766>, <0.000000, -0.693458, 0.494766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.268043, 0.348948>, <0.076817, -0.268043, 0.348948>, <0.140743, -0.327978, 0.326716>, <0.140743, -0.400000, 0.300000>, 
      <0.000000, -0.348475, 0.449320>, <0.076817, -0.348475, 0.449320>, <0.140743, -0.395549, 0.411180>, <0.140743, -0.467571, 0.384464>, 
      <0.000000, -0.431625, 0.600681>, <0.076817, -0.431625, 0.600681>, <0.140743, -0.488991, 0.567437>, <0.140743, -0.540000, 0.510000>, 
      <0.000000, -0.506542, 0.705234>, <0.076817, -0.506542, 0.705234>, <0.140743, -0.548991, 0.657437>, <0.140743, -0.600000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.327978, 0.326716>, <-0.076817, -0.268043, 0.348948>, <0.000000, -0.268043, 0.348948>, 
      <-0.140743, -0.467571, 0.384464>, <-0.140743, -0.395549, 0.411180>, <-0.076817, -0.348475, 0.449320>, <0.000000, -0.348475, 0.449320>, 
      <-0.140743, -0.540000, 0.510000>, <-0.140743, -0.488991, 0.567437>, <-0.076817, -0.431625, 0.600681>, <0.000000, -0.431625, 0.600681>, 
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.548991, 0.657437>, <-0.076817, -0.506542, 0.705234>, <0.000000, -0.506542, 0.705234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.467571, 0.384464>, <-0.140743, -0.540000, 0.510000>, <-0.140743, -0.600000, 0.600000>, 
      <-0.140743, -0.472022, 0.273284>, <-0.140743, -0.539593, 0.357748>, <-0.140743, -0.591009, 0.452563>, <-0.140743, -0.651009, 0.542563>, 
      <-0.076817, -0.531957, 0.251052>, <-0.076817, -0.586693, 0.319587>, <-0.076817, -0.648324, 0.419559>, <-0.076817, -0.693458, 0.494766>, 
      <0.000000, -0.531957, 0.251052>, <0.000000, -0.586693, 0.319587>, <0.000000, -0.648324, 0.419559>, <0.000000, -0.693458, 0.494766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.200000, 0.100000>, <0.140743, -0.252355, 0.043787>, <0.076817, -0.295923, -0.002992>, <0.000000, -0.295923, -0.002992>, 
      <0.140743, -0.267882, 0.150912>, <0.140743, -0.320237, 0.094699>, <0.076817, -0.379687, 0.058702>, <0.000000, -0.379687, 0.058702>, 
      <0.140743, -0.346993, 0.233741>, <0.140743, -0.419015, 0.207025>, <0.076817, -0.467036, 0.169764>, <0.000000, -0.467036, 0.169764>, 
      <0.140743, -0.400000, 0.300000>, <0.140743, -0.472022, 0.273284>, <0.076817, -0.531957, 0.251052>, <0.000000, -0.531957, 0.251052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.104077, 0.202992>, <0.076817, -0.104077, 0.202992>, <0.140743, -0.147645, 0.156213>, <0.140743, -0.200000, 0.100000>, 
      <0.000000, -0.156086, 0.243390>, <0.076817, -0.156086, 0.243390>, <0.140743, -0.215528, 0.207125>, <0.140743, -0.267882, 0.150912>, 
      <0.000000, -0.226862, 0.297557>, <0.076817, -0.226862, 0.297557>, <0.140743, -0.274971, 0.260457>, <0.140743, -0.346993, 0.233741>, 
      <0.000000, -0.268043, 0.348948>, <0.076817, -0.268043, 0.348948>, <0.140743, -0.327978, 0.326716>, <0.140743, -0.400000, 0.300000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.147645, 0.156213>, <-0.076817, -0.104077, 0.202992>, <0.000000, -0.104077, 0.202992>, 
      <-0.140743, -0.267882, 0.150912>, <-0.140743, -0.215528, 0.207125>, <-0.076817, -0.156086, 0.243390>, <0.000000, -0.156086, 0.243390>, 
      <-0.140743, -0.346993, 0.233741>, <-0.140743, -0.274971, 0.260457>, <-0.076817, -0.226862, 0.297557>, <0.000000, -0.226862, 0.297557>, 
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.327978, 0.326716>, <-0.076817, -0.268043, 0.348948>, <0.000000, -0.268043, 0.348948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.267882, 0.150912>, <-0.140743, -0.346993, 0.233741>, <-0.140743, -0.400000, 0.300000>, 
      <-0.140743, -0.252355, 0.043787>, <-0.140743, -0.320237, 0.094699>, <-0.140743, -0.419015, 0.207025>, <-0.140743, -0.472022, 0.273284>, 
      <-0.076817, -0.295923, -0.002992>, <-0.076817, -0.379687, 0.058702>, <-0.076817, -0.467036, 0.169764>, <-0.076817, -0.531957, 0.251052>, 
      <0.000000, -0.295923, -0.002992>, <0.000000, -0.379687, 0.058702>, <0.000000, -0.467036, 0.169764>, <0.000000, -0.531957, 0.251052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 0.000000, 0.000000>, <0.140743, 0.000000, -0.076817>, <0.076817, 0.000000, -0.140743>, <0.000000, 0.000000, -0.140743>, 
      <0.140743, -0.067072, 0.001156>, <0.140743, -0.067072, -0.075661>, <0.076817, -0.097897, -0.138456>, <0.000000, -0.097897, -0.138456>, 
      <0.140743, -0.146334, 0.059751>, <0.140743, -0.198689, 0.003538>, <0.076817, -0.217076, -0.061064>, <0.000000, -0.217076, -0.061064>, 
      <0.140743, -0.200000, 0.100000>, <0.140743, -0.252355, 0.043787>, <0.076817, -0.295923, -0.002992>, <0.000000, -0.295923, -0.002992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 0.000000, 0.000000>, <0.140743, 1.679750, -0.028961>, <0.140743, 3.920241, -0.028470>, <0.140743, 5.600000, 0.000000>, 
      <0.140743, 0.000000, -0.076817>, <0.140743, 1.679750, -0.105779>, <0.140743, 3.920241, -0.105288>, <0.140743, 5.600000, -0.076817>, 
      <0.076817, 0.000000, -0.140743>, <0.076817, 1.679542, -0.179983>, <0.076817, 3.920364, -0.175736>, <0.076817, 5.600000, -0.140743>, 
      <0.000000, 0.000000, -0.140743>, <0.000000, 1.679542, -0.179983>, <0.000000, 3.920364, -0.175736>, <0.000000, 5.600000, -0.140743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.140743>, <0.076817, 0.000000, 0.140743>, <0.140743, 0.000000, 0.076817>, <0.140743, 0.000000, 0.000000>, 
      <0.000000, -0.036380, 0.141140>, <0.076817, -0.036380, 0.141140>, <0.140743, -0.067072, 0.077974>, <0.140743, -0.067072, 0.001156>, 
      <0.000000, -0.075345, 0.180674>, <0.076817, -0.075345, 0.180674>, <0.140743, -0.093980, 0.115964>, <0.140743, -0.146334, 0.059751>, 
      <0.000000, -0.104077, 0.202992>, <0.076817, -0.104077, 0.202992>, <0.140743, -0.147645, 0.156213>, <0.140743, -0.200000, 0.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.140743>, <0.000000, 1.679900, 0.122410>, <0.000000, 3.920141, 0.118975>, <0.000000, 5.600000, 0.140743>, 
      <0.076817, 0.000000, 0.140743>, <0.076817, 1.679900, 0.122410>, <0.076817, 3.920141, 0.118975>, <0.076817, 5.600000, 0.140743>, 
      <0.140743, 0.000000, 0.076817>, <0.140743, 1.679750, 0.047856>, <0.140743, 3.920241, 0.048347>, <0.140743, 5.600000, 0.076817>, 
      <0.140743, 0.000000, 0.000000>, <0.140743, 1.679750, -0.028961>, <0.140743, 3.920241, -0.028470>, <0.140743, 5.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 0.000000, 0.076817>, <-0.076817, 0.000000, 0.140743>, <0.000000, 0.000000, 0.140743>, 
      <-0.140743, -0.067072, 0.001156>, <-0.140743, -0.067072, 0.077974>, <-0.076817, -0.036380, 0.141140>, <0.000000, -0.036380, 0.141140>, 
      <-0.140743, -0.146334, 0.059751>, <-0.140743, -0.093980, 0.115964>, <-0.076817, -0.075345, 0.180674>, <0.000000, -0.075345, 0.180674>, 
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.147645, 0.156213>, <-0.076817, -0.104077, 0.202992>, <0.000000, -0.104077, 0.202992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 1.679750, -0.028961>, <-0.140743, 3.920241, -0.028470>, <-0.140743, 5.600000, 0.000000>, 
      <-0.140743, 0.000000, 0.076817>, <-0.140743, 1.679750, 0.047856>, <-0.140743, 3.920241, 0.048347>, <-0.140743, 5.600000, 0.076817>, 
      <-0.076817, 0.000000, 0.140743>, <-0.076817, 1.679900, 0.122410>, <-0.076817, 3.920141, 0.118975>, <-0.076817, 5.600000, 0.140743>, 
      <0.000000, 0.000000, 0.140743>, <0.000000, 1.679900, 0.122410>, <0.000000, 3.920141, 0.118975>, <0.000000, 5.600000, 0.140743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, -0.067072, 0.001156>, <-0.140743, -0.146334, 0.059751>, <-0.140743, -0.200000, 0.100000>, 
      <-0.140743, 0.000000, -0.076817>, <-0.140743, -0.067072, -0.075661>, <-0.140743, -0.198689, 0.003538>, <-0.140743, -0.252355, 0.043787>, 
      <-0.076817, 0.000000, -0.140743>, <-0.076817, -0.097897, -0.138456>, <-0.076817, -0.217076, -0.061064>, <-0.076817, -0.295923, -0.002992>, 
      <0.000000, 0.000000, -0.140743>, <0.000000, -0.097897, -0.138456>, <0.000000, -0.217076, -0.061064>, <0.000000, -0.295923, -0.002992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 0.000000, -0.076817>, <-0.076817, 0.000000, -0.140743>, <0.000000, 0.000000, -0.140743>, 
      <-0.140743, 1.679750, -0.028961>, <-0.140743, 1.679750, -0.105779>, <-0.076817, 1.679542, -0.179983>, <0.000000, 1.679542, -0.179983>, 
      <-0.140743, 3.920241, -0.028470>, <-0.140743, 3.920241, -0.105288>, <-0.076817, 3.920364, -0.175736>, <0.000000, 3.920364, -0.175736>, 
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.600000, -0.076817>, <-0.076817, 5.600000, -0.140743>, <0.000000, 5.600000, -0.140743>
    }
  }
  rotate 90.0*x
  translate  <-7.273379, 4.296583, 1.482859>
}
#declare sPatchObj2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.219248, 7.400001, 1.500000>, <0.219248, 7.399057, 1.380338>, <0.119665, 7.398270, 1.280759>, <0.000000, 7.398270, 1.280759>, 
      <0.195697, 7.250001, 1.470000>, <0.195697, 7.249056, 1.350339>, <0.119665, 7.265638, 1.277815>, <0.000000, 7.265638, 1.277815>, 
      <0.153507, 7.046331, 1.448777>, <0.153507, 7.076984, 1.378340>, <0.076817, 7.085345, 1.301140>, <0.000000, 7.085345, 1.301140>, 
      <0.140743, 6.900001, 1.400000>, <0.140743, 6.930654, 1.329563>, <0.076817, 6.956161, 1.270947>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 7.401731, 1.719241>, <0.119665, 7.401731, 1.719241>, <0.219248, 7.400946, 1.619662>, <0.219248, 7.400001, 1.500000>, 
      <0.000000, 7.234363, 1.662184>, <0.119665, 7.234363, 1.662184>, <0.195697, 7.250946, 1.589662>, <0.195697, 7.250001, 1.470000>, 
      <0.000000, 7.007190, 1.596760>, <0.076817, 7.007190, 1.596760>, <0.153507, 7.015679, 1.519213>, <0.153507, 7.046331, 1.448777>, 
      <0.000000, 6.843840, 1.529052>, <0.076817, 6.843840, 1.529052>, <0.140743, 6.869349, 1.470437>, <0.140743, 6.900001, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219248, 7.400001, 1.500000>, <-0.219248, 7.400946, 1.619662>, <-0.119665, 7.401731, 1.719241>, <0.000000, 7.401731, 1.719241>, 
      <-0.195697, 7.250001, 1.470000>, <-0.195697, 7.250946, 1.589662>, <-0.119665, 7.234363, 1.662184>, <0.000000, 7.234363, 1.662184>, 
      <-0.153507, 7.046331, 1.448777>, <-0.153507, 7.015679, 1.519213>, <-0.076817, 7.007190, 1.596760>, <0.000000, 7.007190, 1.596760>, 
      <-0.140743, 6.900001, 1.400000>, <-0.140743, 6.869349, 1.470437>, <-0.076817, 6.843840, 1.529052>, <0.000000, 6.843840, 1.529052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219248, 7.400001, 1.500000>, <-0.195697, 7.250001, 1.470000>, <-0.153507, 7.046331, 1.448777>, <-0.140743, 6.900001, 1.400000>, 
      <-0.219248, 7.399057, 1.380338>, <-0.195697, 7.249056, 1.350339>, <-0.153507, 7.076984, 1.378340>, <-0.140743, 6.930654, 1.329563>, 
      <-0.119665, 7.398270, 1.280759>, <-0.119665, 7.265638, 1.277815>, <-0.076817, 7.085345, 1.301140>, <-0.076817, 6.956161, 1.270947>, 
      <0.000000, 7.398270, 1.280759>, <0.000000, 7.265638, 1.277815>, <0.000000, 7.085345, 1.301140>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.500000, 1.200000>, <0.140743, 6.594869, 1.294869>, <0.129679, 6.773155, 1.357718>, <0.140743, 6.900001, 1.400000>, 
      <0.140743, 6.549170, 1.140982>, <0.140743, 6.644039, 1.235850>, <0.129679, 6.803808, 1.287281>, <0.140743, 6.930654, 1.329563>, 
      <0.076817, 6.590089, 1.091868>, <0.076817, 6.676048, 1.178805>, <0.076817, 6.837111, 1.243122>, <0.076817, 6.956161, 1.270947>, 
      <0.000000, 6.590089, 1.091868>, <0.000000, 6.676048, 1.178805>, <0.000000, 6.837111, 1.243122>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.409912, 1.308132>, <0.000000, 6.513676, 1.410952>, <0.000000, 6.708895, 1.473117>, <0.000000, 6.843840, 1.529052>, 
      <0.076817, 6.409912, 1.308132>, <0.076817, 6.513676, 1.410952>, <0.076817, 6.708895, 1.473117>, <0.076817, 6.843840, 1.529052>, 
      <0.140743, 6.450830, 1.259018>, <0.140743, 6.545699, 1.353887>, <0.129679, 6.742502, 1.428155>, <0.140743, 6.869349, 1.470437>, 
      <0.140743, 6.500000, 1.200000>, <0.140743, 6.594869, 1.294869>, <0.129679, 6.773155, 1.357718>, <0.140743, 6.900001, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.594869, 1.294869>, <-0.129679, 6.773155, 1.357718>, <-0.140743, 6.900001, 1.400000>, 
      <-0.140743, 6.450830, 1.259018>, <-0.140743, 6.545699, 1.353887>, <-0.129679, 6.742502, 1.428155>, <-0.140743, 6.869349, 1.470437>, 
      <-0.076817, 6.409912, 1.308132>, <-0.076817, 6.513676, 1.410952>, <-0.076817, 6.708895, 1.473117>, <-0.076817, 6.843840, 1.529052>, 
      <0.000000, 6.409912, 1.308132>, <0.000000, 6.513676, 1.410952>, <0.000000, 6.708895, 1.473117>, <0.000000, 6.843840, 1.529052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.549170, 1.140982>, <-0.076817, 6.590089, 1.091868>, <0.000000, 6.590089, 1.091868>, 
      <-0.140743, 6.594869, 1.294869>, <-0.140743, 6.644039, 1.235850>, <-0.076817, 6.676048, 1.178805>, <0.000000, 6.676048, 1.178805>, 
      <-0.129679, 6.773155, 1.357718>, <-0.129679, 6.803808, 1.287281>, <-0.076817, 6.837111, 1.243122>, <0.000000, 6.837111, 1.243122>, 
      <-0.140743, 6.900001, 1.400000>, <-0.140743, 6.930654, 1.329563>, <-0.076817, 6.956161, 1.270947>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.300001, 0.800000>, <0.140743, 6.347109, 0.925622>, <0.140743, 6.405132, 1.105132>, <0.140743, 6.500000, 1.200000>, 
      <0.140743, 6.367223, 0.762823>, <0.140743, 6.414331, 0.888445>, <0.140743, 6.454302, 1.046113>, <0.140743, 6.549170, 1.140982>, 
      <0.076817, 6.423163, 0.731885>, <0.076817, 6.463122, 0.844019>, <0.076817, 6.506392, 1.007219>, <0.076817, 6.590089, 1.091868>, 
      <0.000000, 6.423163, 0.731885>, <0.000000, 6.463122, 0.844019>, <0.000000, 6.506392, 1.007219>, <0.000000, 6.590089, 1.091868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.176838, 0.868115>, <0.000000, 6.231413, 1.007169>, <0.000000, 6.303803, 1.202988>, <0.000000, 6.409912, 1.308132>, 
      <0.076818, 6.176838, 0.868115>, <0.076818, 6.231413, 1.007169>, <0.076817, 6.303803, 1.202988>, <0.076817, 6.409912, 1.308132>, 
      <0.140743, 6.232779, 0.837177>, <0.140743, 6.279887, 0.962799>, <0.140743, 6.355962, 1.164150>, <0.140743, 6.450830, 1.259018>, 
      <0.140743, 6.300001, 0.800000>, <0.140743, 6.347109, 0.925622>, <0.140743, 6.405132, 1.105132>, <0.140743, 6.500000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.347109, 0.925622>, <-0.140743, 6.405132, 1.105132>, <-0.140743, 6.500000, 1.200000>, 
      <-0.140743, 6.232779, 0.837177>, <-0.140743, 6.279887, 0.962799>, <-0.140743, 6.355962, 1.164150>, <-0.140743, 6.450830, 1.259018>, 
      <-0.076818, 6.176838, 0.868115>, <-0.076818, 6.231413, 1.007169>, <-0.076817, 6.303803, 1.202988>, <-0.076817, 6.409912, 1.308132>, 
      <0.000000, 6.176838, 0.868115>, <0.000000, 6.231413, 1.007169>, <0.000000, 6.303803, 1.202988>, <0.000000, 6.409912, 1.308132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.367223, 0.762823>, <-0.076817, 6.423163, 0.731885>, <0.000000, 6.423163, 0.731885>, 
      <-0.140743, 6.347109, 0.925622>, <-0.140743, 6.414331, 0.888445>, <-0.076817, 6.463122, 0.844019>, <0.000000, 6.463122, 0.844019>, 
      <-0.140743, 6.405132, 1.105132>, <-0.140743, 6.454302, 1.046113>, <-0.076817, 6.506392, 1.007219>, <0.000000, 6.506392, 1.007219>, 
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.549170, 1.140982>, <-0.076817, 6.590089, 1.091868>, <0.000000, 6.590089, 1.091868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.200001, 0.400000>, <0.140743, 6.261370, 0.507396>, <0.140743, 6.256570, 0.684182>, <0.140743, 6.300001, 0.800000>, 
      <0.140743, 6.262360, 0.355143>, <0.140743, 6.323730, 0.462539>, <0.140743, 6.323792, 0.647006>, <0.140743, 6.367223, 0.762823>, 
      <0.076817, 6.314255, 0.317814>, <0.076817, 6.379783, 0.428288>, <0.076817, 6.380047, 0.610892>, <0.076817, 6.423163, 0.731885>, 
      <0.000000, 6.314255, 0.317814>, <0.000000, 6.379783, 0.428288>, <0.000000, 6.380047, 0.610892>, <0.000000, 6.423163, 0.731885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.085747, 0.482186>, <0.000000, 6.142796, 0.586574>, <0.000000, 6.133376, 0.757378>, <0.000000, 6.176838, 0.868115>, 
      <0.076817, 6.085747, 0.482186>, <0.076817, 6.142796, 0.586574>, <0.076818, 6.133376, 0.757378>, <0.076818, 6.176838, 0.868115>, 
      <0.140743, 6.137641, 0.444857>, <0.140743, 6.199010, 0.552253>, <0.140743, 6.189348, 0.721360>, <0.140743, 6.232779, 0.837177>, 
      <0.140743, 6.200001, 0.400000>, <0.140743, 6.261370, 0.507396>, <0.140743, 6.256570, 0.684182>, <0.140743, 6.300001, 0.800000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.261370, 0.507396>, <-0.140743, 6.256570, 0.684182>, <-0.140743, 6.300001, 0.800000>, 
      <-0.140743, 6.137641, 0.444857>, <-0.140743, 6.199010, 0.552253>, <-0.140743, 6.189348, 0.721360>, <-0.140743, 6.232779, 0.837177>, 
      <-0.076817, 6.085747, 0.482186>, <-0.076817, 6.142796, 0.586574>, <-0.076818, 6.133376, 0.757378>, <-0.076818, 6.176838, 0.868115>, 
      <0.000000, 6.085747, 0.482186>, <0.000000, 6.142796, 0.586574>, <0.000000, 6.133376, 0.757378>, <0.000000, 6.176838, 0.868115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.262360, 0.355143>, <-0.076817, 6.314255, 0.317814>, <0.000000, 6.314255, 0.317814>, 
      <-0.140743, 6.261370, 0.507396>, <-0.140743, 6.323730, 0.462539>, <-0.076817, 6.379783, 0.428288>, <0.000000, 6.379783, 0.428288>, 
      <-0.140743, 6.256570, 0.684182>, <-0.140743, 6.323792, 0.647006>, <-0.076817, 6.380047, 0.610892>, <0.000000, 6.380047, 0.610892>, 
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.367223, 0.762823>, <-0.076817, 6.423163, 0.731885>, <0.000000, 6.423163, 0.731885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 5.900001, 0.100000>, <0.140743, 6.005904, 0.170602>, <0.140743, 6.136853, 0.289491>, <0.140743, 6.200001, 0.400000>, 
      <0.140743, 5.943369, 0.036596>, <0.140743, 6.049272, 0.107198>, <0.140743, 6.199212, 0.244634>, <0.140743, 6.262360, 0.355143>, 
      <0.076817, 5.979459, -0.016168>, <0.076817, 6.098843, 0.060477>, <0.076817, 6.241880, 0.195795>, <0.076817, 6.314255, 0.317814>, 
      <0.000000, 5.979459, -0.016168>, <0.000000, 6.098843, 0.060477>, <0.000000, 6.241880, 0.195795>, <0.000000, 6.314255, 0.317814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 5.820542, 0.216168>, <0.000000, 5.912734, 0.280972>, <0.000000, 6.031705, 0.383300>, <0.000000, 6.085747, 0.482186>, 
      <0.076817, 5.820542, 0.216168>, <0.076817, 5.912734, 0.280972>, <0.076817, 6.031705, 0.383300>, <0.076817, 6.085747, 0.482186>, 
      <0.140743, 5.856633, 0.163404>, <0.140743, 5.962535, 0.234006>, <0.140743, 6.074493, 0.334348>, <0.140743, 6.137641, 0.444857>, 
      <0.140743, 5.900001, 0.100000>, <0.140743, 6.005904, 0.170602>, <0.140743, 6.136853, 0.289491>, <0.140743, 6.200001, 0.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 6.005904, 0.170602>, <-0.140743, 6.136853, 0.289491>, <-0.140743, 6.200001, 0.400000>, 
      <-0.140743, 5.856633, 0.163404>, <-0.140743, 5.962535, 0.234006>, <-0.140743, 6.074493, 0.334348>, <-0.140743, 6.137641, 0.444857>, 
      <-0.076817, 5.820542, 0.216168>, <-0.076817, 5.912734, 0.280972>, <-0.076817, 6.031705, 0.383300>, <-0.076817, 6.085747, 0.482186>, 
      <0.000000, 5.820542, 0.216168>, <0.000000, 5.912734, 0.280972>, <0.000000, 6.031705, 0.383300>, <0.000000, 6.085747, 0.482186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 5.943369, 0.036596>, <-0.076817, 5.979459, -0.016168>, <0.000000, 5.979459, -0.016168>, 
      <-0.140743, 6.005904, 0.170602>, <-0.140743, 6.049272, 0.107198>, <-0.076817, 6.098843, 0.060477>, <0.000000, 6.098843, 0.060477>, 
      <-0.140743, 6.136853, 0.289491>, <-0.140743, 6.199212, 0.244634>, <-0.076817, 6.241880, 0.195795>, <0.000000, 6.241880, 0.195795>, 
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.262360, 0.355143>, <-0.076817, 6.314255, 0.317814>, <0.000000, 6.314255, 0.317814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 5.600000, 0.000000>, <0.140743, 5.694855, 0.001608>, <0.140743, 5.821066, 0.047376>, <0.140743, 5.900001, 0.100000>, 
      <0.140743, 5.600000, -0.076817>, <0.140743, 5.694855, -0.075210>, <0.140743, 5.864434, -0.016028>, <0.140743, 5.943369, 0.036596>, 
      <0.076817, 5.600000, -0.140743>, <0.076817, 5.719790, -0.138247>, <0.076817, 5.878634, -0.080898>, <0.076817, 5.979459, -0.016168>, 
      <0.000000, 5.600000, -0.140743>, <0.000000, 5.719790, -0.138247>, <0.000000, 5.878634, -0.080898>, <0.000000, 5.979459, -0.016168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 5.600000, 0.140743>, <0.000000, 5.669919, 0.141649>, <0.000000, 5.763336, 0.175957>, <0.000000, 5.820542, 0.216168>, 
      <0.076817, 5.600000, 0.140743>, <0.076817, 5.669919, 0.141649>, <0.076817, 5.763336, 0.175957>, <0.076817, 5.820542, 0.216168>, 
      <0.140743, 5.600000, 0.076817>, <0.140743, 5.694855, 0.078425>, <0.140743, 5.777697, 0.110781>, <0.140743, 5.856633, 0.163404>, 
      <0.140743, 5.600000, 0.000000>, <0.140743, 5.694855, 0.001608>, <0.140743, 5.821066, 0.047376>, <0.140743, 5.900001, 0.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.694855, 0.001608>, <-0.140743, 5.821066, 0.047376>, <-0.140743, 5.900001, 0.100000>, 
      <-0.140743, 5.600000, 0.076817>, <-0.140743, 5.694855, 0.078425>, <-0.140743, 5.777697, 0.110781>, <-0.140743, 5.856633, 0.163404>, 
      <-0.076817, 5.600000, 0.140743>, <-0.076817, 5.669919, 0.141649>, <-0.076817, 5.763336, 0.175957>, <-0.076817, 5.820542, 0.216168>, 
      <0.000000, 5.600000, 0.140743>, <0.000000, 5.669919, 0.141649>, <0.000000, 5.763336, 0.175957>, <0.000000, 5.820542, 0.216168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.600000, -0.076817>, <-0.076817, 5.600000, -0.140743>, <0.000000, 5.600000, -0.140743>, 
      <-0.140743, 5.694855, 0.001608>, <-0.140743, 5.694855, -0.075210>, <-0.076817, 5.719790, -0.138247>, <0.000000, 5.719790, -0.138247>, 
      <-0.140743, 5.821066, 0.047376>, <-0.140743, 5.864434, -0.016028>, <-0.076817, 5.878634, -0.080898>, <0.000000, 5.878634, -0.080898>, 
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 5.943369, 0.036596>, <-0.076817, 5.979459, -0.016168>, <0.000000, 5.979459, -0.016168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -1.500000, 1.300000>, <0.140743, -1.410000, 1.270000>, <0.140743, -1.282369, 1.247068>, <0.140743, -1.200000, 1.200000>, 
      <0.140743, -1.500606, 1.223185>, <0.140743, -1.410606, 1.193185>, <0.140743, -1.286611, 1.170368>, <0.140743, -1.204243, 1.123300>, 
      <0.076817, -1.501111, 1.159261>, <0.076817, -1.413110, 1.129324>, <0.076817, -1.287603, 1.107091>, <0.076817, -1.207773, 1.059472>, 
      <0.000000, -1.501111, 1.159261>, <0.000000, -1.413110, 1.129324>, <0.000000, -1.287603, 1.107091>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.498889, 1.440739>, <0.000000, -1.406890, 1.410676>, <0.000000, -1.277067, 1.387108>, <0.000000, -1.192227, 1.340528>, 
      <0.076817, -1.498889, 1.440739>, <0.076817, -1.406890, 1.410676>, <0.076817, -1.277067, 1.387108>, <0.076817, -1.192227, 1.340528>, 
      <0.140743, -1.499394, 1.376815>, <0.140743, -1.409394, 1.346815>, <0.140743, -1.278126, 1.323768>, <0.140743, -1.195758, 1.276700>, 
      <0.140743, -1.500000, 1.300000>, <0.140743, -1.410000, 1.270000>, <0.140743, -1.282369, 1.247068>, <0.140743, -1.200000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -1.500000, 1.300000>, <-0.140743, -1.410000, 1.270000>, <-0.140743, -1.282369, 1.247068>, <-0.140743, -1.200000, 1.200000>, 
      <-0.140743, -1.499394, 1.376815>, <-0.140743, -1.409394, 1.346815>, <-0.140743, -1.278126, 1.323768>, <-0.140743, -1.195758, 1.276700>, 
      <-0.076817, -1.498889, 1.440739>, <-0.076817, -1.406890, 1.410676>, <-0.076817, -1.277067, 1.387108>, <-0.076817, -1.192227, 1.340528>, 
      <0.000000, -1.498889, 1.440739>, <0.000000, -1.406890, 1.410676>, <0.000000, -1.277067, 1.387108>, <0.000000, -1.192227, 1.340528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -1.500000, 1.300000>, <-0.140743, -1.500606, 1.223185>, <-0.076817, -1.501111, 1.159261>, <0.000000, -1.501111, 1.159261>, 
      <-0.140743, -1.410000, 1.270000>, <-0.140743, -1.410606, 1.193185>, <-0.076817, -1.413110, 1.129324>, <0.000000, -1.413110, 1.129324>, 
      <-0.140743, -1.282369, 1.247068>, <-0.140743, -1.286611, 1.170368>, <-0.076817, -1.287603, 1.107091>, <0.000000, -1.287603, 1.107091>, 
      <-0.140743, -1.200000, 1.200000>, <-0.140743, -1.204243, 1.123300>, <-0.076817, -1.207773, 1.059472>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.800000, 0.900000>, <0.140743, -0.822117, 0.826436>, <0.076817, -0.840523, 0.765217>, <0.000000, -0.840523, 0.765217>, 
      <0.140743, -0.906066, 1.006066>, <0.140743, -0.928184, 0.932502>, <0.076817, -0.935585, 0.869593>, <0.000000, -0.935585, 0.869593>, 
      <0.140743, -1.069764, 1.125579>, <0.140743, -1.074006, 1.048879>, <0.076817, -1.086527, 0.987148>, <0.000000, -1.086527, 0.987148>, 
      <0.140743, -1.200000, 1.200000>, <0.140743, -1.204243, 1.123300>, <0.076817, -1.207773, 1.059472>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.759477, 1.034783>, <0.076817, -0.759477, 1.034783>, <0.140743, -0.777883, 0.973564>, <0.140743, -0.800000, 0.900000>, 
      <0.000000, -0.876080, 1.142817>, <0.076817, -0.876080, 1.142817>, <0.140743, -0.883949, 1.079630>, <0.140743, -0.906066, 1.006066>, 
      <0.000000, -1.052888, 1.264027>, <0.076817, -1.052888, 1.264027>, <0.140743, -1.065521, 1.202279>, <0.140743, -1.069764, 1.125579>, 
      <0.000000, -1.192227, 1.340528>, <0.076817, -1.192227, 1.340528>, <0.140743, -1.195758, 1.276700>, <0.140743, -1.200000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.777883, 0.973564>, <-0.076817, -0.759477, 1.034783>, <0.000000, -0.759477, 1.034783>, 
      <-0.140743, -0.906066, 1.006066>, <-0.140743, -0.883949, 1.079630>, <-0.076817, -0.876080, 1.142817>, <0.000000, -0.876080, 1.142817>, 
      <-0.140743, -1.069764, 1.125579>, <-0.140743, -1.065521, 1.202279>, <-0.076817, -1.052888, 1.264027>, <0.000000, -1.052888, 1.264027>, 
      <-0.140743, -1.200000, 1.200000>, <-0.140743, -1.195758, 1.276700>, <-0.076817, -1.192227, 1.340528>, <0.000000, -1.192227, 1.340528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.906066, 1.006066>, <-0.140743, -1.069764, 1.125579>, <-0.140743, -1.200000, 1.200000>, 
      <-0.140743, -0.822117, 0.826436>, <-0.140743, -0.928184, 0.932502>, <-0.140743, -1.074006, 1.048879>, <-0.140743, -1.204243, 1.123300>, 
      <-0.076817, -0.840523, 0.765217>, <-0.076817, -0.935585, 0.869593>, <-0.076817, -1.086527, 0.987148>, <-0.076817, -1.207773, 1.059472>, 
      <0.000000, -0.840523, 0.765217>, <0.000000, -0.935585, 0.869593>, <0.000000, -1.086527, 0.987148>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.600000, 0.600000>, <0.140743, -0.651009, 0.542563>, <0.076817, -0.693458, 0.494766>, <0.000000, -0.693458, 0.494766>, 
      <0.140743, -0.660000, 0.690000>, <0.140743, -0.711009, 0.632563>, <0.076817, -0.740982, 0.573955>, <0.000000, -0.740982, 0.573955>, 
      <0.140743, -0.723515, 0.823515>, <0.140743, -0.745632, 0.749950>, <0.076817, -0.778336, 0.696937>, <0.000000, -0.778336, 0.696937>, 
      <0.140743, -0.800000, 0.900000>, <0.140743, -0.822117, 0.826436>, <0.076817, -0.840523, 0.765217>, <0.000000, -0.840523, 0.765217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.506542, 0.705234>, <0.076817, -0.506542, 0.705234>, <0.140743, -0.548991, 0.657437>, <0.140743, -0.600000, 0.600000>, 
      <0.000000, -0.579132, 0.806539>, <0.076817, -0.579132, 0.806539>, <0.140743, -0.608991, 0.747437>, <0.140743, -0.660000, 0.690000>, 
      <0.000000, -0.668057, 0.950081>, <0.076817, -0.668057, 0.950081>, <0.140743, -0.701397, 0.897079>, <0.140743, -0.723515, 0.823515>, 
      <0.000000, -0.759477, 1.034783>, <0.076817, -0.759477, 1.034783>, <0.140743, -0.777883, 0.973564>, <0.140743, -0.800000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.548991, 0.657437>, <-0.076817, -0.506542, 0.705234>, <0.000000, -0.506542, 0.705234>, 
      <-0.140743, -0.660000, 0.690000>, <-0.140743, -0.608991, 0.747437>, <-0.076817, -0.579132, 0.806539>, <0.000000, -0.579132, 0.806539>, 
      <-0.140743, -0.723515, 0.823515>, <-0.140743, -0.701397, 0.897079>, <-0.076817, -0.668057, 0.950081>, <0.000000, -0.668057, 0.950081>, 
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.777883, 0.973564>, <-0.076817, -0.759477, 1.034783>, <0.000000, -0.759477, 1.034783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.660000, 0.690000>, <-0.140743, -0.723515, 0.823515>, <-0.140743, -0.800000, 0.900000>, 
      <-0.140743, -0.651009, 0.542563>, <-0.140743, -0.711009, 0.632563>, <-0.140743, -0.745632, 0.749950>, <-0.140743, -0.822117, 0.826436>, 
      <-0.076817, -0.693458, 0.494766>, <-0.076817, -0.740982, 0.573955>, <-0.076817, -0.778336, 0.696937>, <-0.076817, -0.840523, 0.765217>, 
      <0.000000, -0.693458, 0.494766>, <0.000000, -0.740982, 0.573955>, <0.000000, -0.778336, 0.696937>, <0.000000, -0.840523, 0.765217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.400000, 0.300000>, <0.140743, -0.472022, 0.273284>, <0.076817, -0.531957, 0.251052>, <0.000000, -0.531957, 0.251052>, 
      <0.140743, -0.467571, 0.384464>, <0.140743, -0.539593, 0.357748>, <0.076817, -0.586693, 0.319587>, <0.000000, -0.586693, 0.319587>, 
      <0.140743, -0.540000, 0.510000>, <0.140743, -0.591009, 0.452563>, <0.076817, -0.648324, 0.419559>, <0.000000, -0.648324, 0.419559>, 
      <0.140743, -0.600000, 0.600000>, <0.140743, -0.651009, 0.542563>, <0.076817, -0.693458, 0.494766>, <0.000000, -0.693458, 0.494766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.268043, 0.348948>, <0.076817, -0.268043, 0.348948>, <0.140743, -0.327978, 0.326716>, <0.140743, -0.400000, 0.300000>, 
      <0.000000, -0.348475, 0.449320>, <0.076817, -0.348475, 0.449320>, <0.140743, -0.395549, 0.411180>, <0.140743, -0.467571, 0.384464>, 
      <0.000000, -0.431625, 0.600681>, <0.076817, -0.431625, 0.600681>, <0.140743, -0.488991, 0.567437>, <0.140743, -0.540000, 0.510000>, 
      <0.000000, -0.506542, 0.705234>, <0.076817, -0.506542, 0.705234>, <0.140743, -0.548991, 0.657437>, <0.140743, -0.600000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.327978, 0.326716>, <-0.076817, -0.268043, 0.348948>, <0.000000, -0.268043, 0.348948>, 
      <-0.140743, -0.467571, 0.384464>, <-0.140743, -0.395549, 0.411180>, <-0.076817, -0.348475, 0.449320>, <0.000000, -0.348475, 0.449320>, 
      <-0.140743, -0.540000, 0.510000>, <-0.140743, -0.488991, 0.567437>, <-0.076817, -0.431625, 0.600681>, <0.000000, -0.431625, 0.600681>, 
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.548991, 0.657437>, <-0.076817, -0.506542, 0.705234>, <0.000000, -0.506542, 0.705234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.467571, 0.384464>, <-0.140743, -0.540000, 0.510000>, <-0.140743, -0.600000, 0.600000>, 
      <-0.140743, -0.472022, 0.273284>, <-0.140743, -0.539593, 0.357748>, <-0.140743, -0.591009, 0.452563>, <-0.140743, -0.651009, 0.542563>, 
      <-0.076817, -0.531957, 0.251052>, <-0.076817, -0.586693, 0.319587>, <-0.076817, -0.648324, 0.419559>, <-0.076817, -0.693458, 0.494766>, 
      <0.000000, -0.531957, 0.251052>, <0.000000, -0.586693, 0.319587>, <0.000000, -0.648324, 0.419559>, <0.000000, -0.693458, 0.494766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.200000, 0.100000>, <0.140743, -0.252355, 0.043787>, <0.076817, -0.295923, -0.002992>, <0.000000, -0.295923, -0.002992>, 
      <0.140743, -0.267882, 0.150912>, <0.140743, -0.320237, 0.094699>, <0.076817, -0.379687, 0.058702>, <0.000000, -0.379687, 0.058702>, 
      <0.140743, -0.346993, 0.233741>, <0.140743, -0.419015, 0.207025>, <0.076817, -0.467036, 0.169764>, <0.000000, -0.467036, 0.169764>, 
      <0.140743, -0.400000, 0.300000>, <0.140743, -0.472022, 0.273284>, <0.076817, -0.531957, 0.251052>, <0.000000, -0.531957, 0.251052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.104077, 0.202992>, <0.076817, -0.104077, 0.202992>, <0.140743, -0.147645, 0.156213>, <0.140743, -0.200000, 0.100000>, 
      <0.000000, -0.156086, 0.243390>, <0.076817, -0.156086, 0.243390>, <0.140743, -0.215528, 0.207125>, <0.140743, -0.267882, 0.150912>, 
      <0.000000, -0.226862, 0.297557>, <0.076817, -0.226862, 0.297557>, <0.140743, -0.274971, 0.260457>, <0.140743, -0.346993, 0.233741>, 
      <0.000000, -0.268043, 0.348948>, <0.076817, -0.268043, 0.348948>, <0.140743, -0.327978, 0.326716>, <0.140743, -0.400000, 0.300000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.147645, 0.156213>, <-0.076817, -0.104077, 0.202992>, <0.000000, -0.104077, 0.202992>, 
      <-0.140743, -0.267882, 0.150912>, <-0.140743, -0.215528, 0.207125>, <-0.076817, -0.156086, 0.243390>, <0.000000, -0.156086, 0.243390>, 
      <-0.140743, -0.346993, 0.233741>, <-0.140743, -0.274971, 0.260457>, <-0.076817, -0.226862, 0.297557>, <0.000000, -0.226862, 0.297557>, 
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.327978, 0.326716>, <-0.076817, -0.268043, 0.348948>, <0.000000, -0.268043, 0.348948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.267882, 0.150912>, <-0.140743, -0.346993, 0.233741>, <-0.140743, -0.400000, 0.300000>, 
      <-0.140743, -0.252355, 0.043787>, <-0.140743, -0.320237, 0.094699>, <-0.140743, -0.419015, 0.207025>, <-0.140743, -0.472022, 0.273284>, 
      <-0.076817, -0.295923, -0.002992>, <-0.076817, -0.379687, 0.058702>, <-0.076817, -0.467036, 0.169764>, <-0.076817, -0.531957, 0.251052>, 
      <0.000000, -0.295923, -0.002992>, <0.000000, -0.379687, 0.058702>, <0.000000, -0.467036, 0.169764>, <0.000000, -0.531957, 0.251052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 0.000000, 0.000000>, <0.140743, 0.000000, -0.076817>, <0.076817, 0.000000, -0.140743>, <0.000000, 0.000000, -0.140743>, 
      <0.140743, -0.067072, 0.001156>, <0.140743, -0.067072, -0.075661>, <0.076817, -0.097897, -0.138456>, <0.000000, -0.097897, -0.138456>, 
      <0.140743, -0.146334, 0.059751>, <0.140743, -0.198689, 0.003538>, <0.076817, -0.217076, -0.061064>, <0.000000, -0.217076, -0.061064>, 
      <0.140743, -0.200000, 0.100000>, <0.140743, -0.252355, 0.043787>, <0.076817, -0.295923, -0.002992>, <0.000000, -0.295923, -0.002992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 0.000000, 0.000000>, <0.140743, 1.679750, -0.028961>, <0.140743, 3.920241, -0.028470>, <0.140743, 5.600000, 0.000000>, 
      <0.140743, 0.000000, -0.076817>, <0.140743, 1.679750, -0.105779>, <0.140743, 3.920241, -0.105288>, <0.140743, 5.600000, -0.076817>, 
      <0.076817, 0.000000, -0.140743>, <0.076817, 1.679542, -0.179983>, <0.076817, 3.920364, -0.175736>, <0.076817, 5.600000, -0.140743>, 
      <0.000000, 0.000000, -0.140743>, <0.000000, 1.679542, -0.179983>, <0.000000, 3.920364, -0.175736>, <0.000000, 5.600000, -0.140743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.140743>, <0.076817, 0.000000, 0.140743>, <0.140743, 0.000000, 0.076817>, <0.140743, 0.000000, 0.000000>, 
      <0.000000, -0.036380, 0.141140>, <0.076817, -0.036380, 0.141140>, <0.140743, -0.067072, 0.077974>, <0.140743, -0.067072, 0.001156>, 
      <0.000000, -0.075345, 0.180674>, <0.076817, -0.075345, 0.180674>, <0.140743, -0.093980, 0.115964>, <0.140743, -0.146334, 0.059751>, 
      <0.000000, -0.104077, 0.202992>, <0.076817, -0.104077, 0.202992>, <0.140743, -0.147645, 0.156213>, <0.140743, -0.200000, 0.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.140743>, <0.000000, 1.679900, 0.122410>, <0.000000, 3.920141, 0.118975>, <0.000000, 5.600000, 0.140743>, 
      <0.076817, 0.000000, 0.140743>, <0.076817, 1.679900, 0.122410>, <0.076817, 3.920141, 0.118975>, <0.076817, 5.600000, 0.140743>, 
      <0.140743, 0.000000, 0.076817>, <0.140743, 1.679750, 0.047856>, <0.140743, 3.920241, 0.048347>, <0.140743, 5.600000, 0.076817>, 
      <0.140743, 0.000000, 0.000000>, <0.140743, 1.679750, -0.028961>, <0.140743, 3.920241, -0.028470>, <0.140743, 5.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 0.000000, 0.076817>, <-0.076817, 0.000000, 0.140743>, <0.000000, 0.000000, 0.140743>, 
      <-0.140743, -0.067072, 0.001156>, <-0.140743, -0.067072, 0.077974>, <-0.076817, -0.036380, 0.141140>, <0.000000, -0.036380, 0.141140>, 
      <-0.140743, -0.146334, 0.059751>, <-0.140743, -0.093980, 0.115964>, <-0.076817, -0.075345, 0.180674>, <0.000000, -0.075345, 0.180674>, 
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.147645, 0.156213>, <-0.076817, -0.104077, 0.202992>, <0.000000, -0.104077, 0.202992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 1.679750, -0.028961>, <-0.140743, 3.920241, -0.028470>, <-0.140743, 5.600000, 0.000000>, 
      <-0.140743, 0.000000, 0.076817>, <-0.140743, 1.679750, 0.047856>, <-0.140743, 3.920241, 0.048347>, <-0.140743, 5.600000, 0.076817>, 
      <-0.076817, 0.000000, 0.140743>, <-0.076817, 1.679900, 0.122410>, <-0.076817, 3.920141, 0.118975>, <-0.076817, 5.600000, 0.140743>, 
      <0.000000, 0.000000, 0.140743>, <0.000000, 1.679900, 0.122410>, <0.000000, 3.920141, 0.118975>, <0.000000, 5.600000, 0.140743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, -0.067072, 0.001156>, <-0.140743, -0.146334, 0.059751>, <-0.140743, -0.200000, 0.100000>, 
      <-0.140743, 0.000000, -0.076817>, <-0.140743, -0.067072, -0.075661>, <-0.140743, -0.198689, 0.003538>, <-0.140743, -0.252355, 0.043787>, 
      <-0.076817, 0.000000, -0.140743>, <-0.076817, -0.097897, -0.138456>, <-0.076817, -0.217076, -0.061064>, <-0.076817, -0.295923, -0.002992>, 
      <0.000000, 0.000000, -0.140743>, <0.000000, -0.097897, -0.138456>, <0.000000, -0.217076, -0.061064>, <0.000000, -0.295923, -0.002992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 0.000000, -0.076817>, <-0.076817, 0.000000, -0.140743>, <0.000000, 0.000000, -0.140743>, 
      <-0.140743, 1.679750, -0.028961>, <-0.140743, 1.679750, -0.105779>, <-0.076817, 1.679542, -0.179983>, <0.000000, 1.679542, -0.179983>, 
      <-0.140743, 3.920241, -0.028470>, <-0.140743, 3.920241, -0.105288>, <-0.076817, 3.920364, -0.175736>, <0.000000, 3.920364, -0.175736>, 
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.600000, -0.076817>, <-0.076817, 5.600000, -0.140743>, <0.000000, 5.600000, -0.140743>
    }
  }
  rotate <90.0, 0.0, -72.0>
  translate  <-7.273379, 4.296583, 1.482859>
}
#declare sPatchObj3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.219248, 7.400001, 1.500000>, <0.219248, 7.399057, 1.380338>, <0.119665, 7.398270, 1.280759>, <0.000000, 7.398270, 1.280759>, 
      <0.195697, 7.250001, 1.470000>, <0.195697, 7.249056, 1.350339>, <0.119665, 7.265638, 1.277815>, <0.000000, 7.265638, 1.277815>, 
      <0.153507, 7.046331, 1.448777>, <0.153507, 7.076984, 1.378340>, <0.076817, 7.085345, 1.301140>, <0.000000, 7.085345, 1.301140>, 
      <0.140743, 6.900001, 1.400000>, <0.140743, 6.930654, 1.329563>, <0.076817, 6.956161, 1.270947>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 7.401731, 1.719241>, <0.119665, 7.401731, 1.719241>, <0.219248, 7.400946, 1.619662>, <0.219248, 7.400001, 1.500000>, 
      <0.000000, 7.234363, 1.662184>, <0.119665, 7.234363, 1.662184>, <0.195697, 7.250946, 1.589662>, <0.195697, 7.250001, 1.470000>, 
      <0.000000, 7.007190, 1.596760>, <0.076817, 7.007190, 1.596760>, <0.153507, 7.015679, 1.519213>, <0.153507, 7.046331, 1.448777>, 
      <0.000000, 6.843840, 1.529052>, <0.076817, 6.843840, 1.529052>, <0.140743, 6.869349, 1.470437>, <0.140743, 6.900001, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219248, 7.400001, 1.500000>, <-0.219248, 7.400946, 1.619662>, <-0.119665, 7.401731, 1.719241>, <0.000000, 7.401731, 1.719241>, 
      <-0.195697, 7.250001, 1.470000>, <-0.195697, 7.250946, 1.589662>, <-0.119665, 7.234363, 1.662184>, <0.000000, 7.234363, 1.662184>, 
      <-0.153507, 7.046331, 1.448777>, <-0.153507, 7.015679, 1.519213>, <-0.076817, 7.007190, 1.596760>, <0.000000, 7.007190, 1.596760>, 
      <-0.140743, 6.900001, 1.400000>, <-0.140743, 6.869349, 1.470437>, <-0.076817, 6.843840, 1.529052>, <0.000000, 6.843840, 1.529052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219248, 7.400001, 1.500000>, <-0.195697, 7.250001, 1.470000>, <-0.153507, 7.046331, 1.448777>, <-0.140743, 6.900001, 1.400000>, 
      <-0.219248, 7.399057, 1.380338>, <-0.195697, 7.249056, 1.350339>, <-0.153507, 7.076984, 1.378340>, <-0.140743, 6.930654, 1.329563>, 
      <-0.119665, 7.398270, 1.280759>, <-0.119665, 7.265638, 1.277815>, <-0.076817, 7.085345, 1.301140>, <-0.076817, 6.956161, 1.270947>, 
      <0.000000, 7.398270, 1.280759>, <0.000000, 7.265638, 1.277815>, <0.000000, 7.085345, 1.301140>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.500000, 1.200000>, <0.140743, 6.594869, 1.294869>, <0.129679, 6.773155, 1.357718>, <0.140743, 6.900001, 1.400000>, 
      <0.140743, 6.549170, 1.140982>, <0.140743, 6.644039, 1.235850>, <0.129679, 6.803808, 1.287281>, <0.140743, 6.930654, 1.329563>, 
      <0.076817, 6.590089, 1.091868>, <0.076817, 6.676048, 1.178805>, <0.076817, 6.837111, 1.243122>, <0.076817, 6.956161, 1.270947>, 
      <0.000000, 6.590089, 1.091868>, <0.000000, 6.676048, 1.178805>, <0.000000, 6.837111, 1.243122>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.409912, 1.308132>, <0.000000, 6.513676, 1.410952>, <0.000000, 6.708895, 1.473117>, <0.000000, 6.843840, 1.529052>, 
      <0.076817, 6.409912, 1.308132>, <0.076817, 6.513676, 1.410952>, <0.076817, 6.708895, 1.473117>, <0.076817, 6.843840, 1.529052>, 
      <0.140743, 6.450830, 1.259018>, <0.140743, 6.545699, 1.353887>, <0.129679, 6.742502, 1.428155>, <0.140743, 6.869349, 1.470437>, 
      <0.140743, 6.500000, 1.200000>, <0.140743, 6.594869, 1.294869>, <0.129679, 6.773155, 1.357718>, <0.140743, 6.900001, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.594869, 1.294869>, <-0.129679, 6.773155, 1.357718>, <-0.140743, 6.900001, 1.400000>, 
      <-0.140743, 6.450830, 1.259018>, <-0.140743, 6.545699, 1.353887>, <-0.129679, 6.742502, 1.428155>, <-0.140743, 6.869349, 1.470437>, 
      <-0.076817, 6.409912, 1.308132>, <-0.076817, 6.513676, 1.410952>, <-0.076817, 6.708895, 1.473117>, <-0.076817, 6.843840, 1.529052>, 
      <0.000000, 6.409912, 1.308132>, <0.000000, 6.513676, 1.410952>, <0.000000, 6.708895, 1.473117>, <0.000000, 6.843840, 1.529052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.549170, 1.140982>, <-0.076817, 6.590089, 1.091868>, <0.000000, 6.590089, 1.091868>, 
      <-0.140743, 6.594869, 1.294869>, <-0.140743, 6.644039, 1.235850>, <-0.076817, 6.676048, 1.178805>, <0.000000, 6.676048, 1.178805>, 
      <-0.129679, 6.773155, 1.357718>, <-0.129679, 6.803808, 1.287281>, <-0.076817, 6.837111, 1.243122>, <0.000000, 6.837111, 1.243122>, 
      <-0.140743, 6.900001, 1.400000>, <-0.140743, 6.930654, 1.329563>, <-0.076817, 6.956161, 1.270947>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.300001, 0.800000>, <0.140743, 6.347109, 0.925622>, <0.140743, 6.405132, 1.105132>, <0.140743, 6.500000, 1.200000>, 
      <0.140743, 6.367223, 0.762823>, <0.140743, 6.414331, 0.888445>, <0.140743, 6.454302, 1.046113>, <0.140743, 6.549170, 1.140982>, 
      <0.076817, 6.423163, 0.731885>, <0.076817, 6.463122, 0.844019>, <0.076817, 6.506392, 1.007219>, <0.076817, 6.590089, 1.091868>, 
      <0.000000, 6.423163, 0.731885>, <0.000000, 6.463122, 0.844019>, <0.000000, 6.506392, 1.007219>, <0.000000, 6.590089, 1.091868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.176838, 0.868115>, <0.000000, 6.231413, 1.007169>, <0.000000, 6.303803, 1.202988>, <0.000000, 6.409912, 1.308132>, 
      <0.076818, 6.176838, 0.868115>, <0.076818, 6.231413, 1.007169>, <0.076817, 6.303803, 1.202988>, <0.076817, 6.409912, 1.308132>, 
      <0.140743, 6.232779, 0.837177>, <0.140743, 6.279887, 0.962799>, <0.140743, 6.355962, 1.164150>, <0.140743, 6.450830, 1.259018>, 
      <0.140743, 6.300001, 0.800000>, <0.140743, 6.347109, 0.925622>, <0.140743, 6.405132, 1.105132>, <0.140743, 6.500000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.347109, 0.925622>, <-0.140743, 6.405132, 1.105132>, <-0.140743, 6.500000, 1.200000>, 
      <-0.140743, 6.232779, 0.837177>, <-0.140743, 6.279887, 0.962799>, <-0.140743, 6.355962, 1.164150>, <-0.140743, 6.450830, 1.259018>, 
      <-0.076818, 6.176838, 0.868115>, <-0.076818, 6.231413, 1.007169>, <-0.076817, 6.303803, 1.202988>, <-0.076817, 6.409912, 1.308132>, 
      <0.000000, 6.176838, 0.868115>, <0.000000, 6.231413, 1.007169>, <0.000000, 6.303803, 1.202988>, <0.000000, 6.409912, 1.308132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.367223, 0.762823>, <-0.076817, 6.423163, 0.731885>, <0.000000, 6.423163, 0.731885>, 
      <-0.140743, 6.347109, 0.925622>, <-0.140743, 6.414331, 0.888445>, <-0.076817, 6.463122, 0.844019>, <0.000000, 6.463122, 0.844019>, 
      <-0.140743, 6.405132, 1.105132>, <-0.140743, 6.454302, 1.046113>, <-0.076817, 6.506392, 1.007219>, <0.000000, 6.506392, 1.007219>, 
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.549170, 1.140982>, <-0.076817, 6.590089, 1.091868>, <0.000000, 6.590089, 1.091868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.200001, 0.400000>, <0.140743, 6.261370, 0.507396>, <0.140743, 6.256570, 0.684182>, <0.140743, 6.300001, 0.800000>, 
      <0.140743, 6.262360, 0.355143>, <0.140743, 6.323730, 0.462539>, <0.140743, 6.323792, 0.647006>, <0.140743, 6.367223, 0.762823>, 
      <0.076817, 6.314255, 0.317814>, <0.076817, 6.379783, 0.428288>, <0.076817, 6.380047, 0.610892>, <0.076817, 6.423163, 0.731885>, 
      <0.000000, 6.314255, 0.317814>, <0.000000, 6.379783, 0.428288>, <0.000000, 6.380047, 0.610892>, <0.000000, 6.423163, 0.731885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.085747, 0.482186>, <0.000000, 6.142796, 0.586574>, <0.000000, 6.133376, 0.757378>, <0.000000, 6.176838, 0.868115>, 
      <0.076817, 6.085747, 0.482186>, <0.076817, 6.142796, 0.586574>, <0.076818, 6.133376, 0.757378>, <0.076818, 6.176838, 0.868115>, 
      <0.140743, 6.137641, 0.444857>, <0.140743, 6.199010, 0.552253>, <0.140743, 6.189348, 0.721360>, <0.140743, 6.232779, 0.837177>, 
      <0.140743, 6.200001, 0.400000>, <0.140743, 6.261370, 0.507396>, <0.140743, 6.256570, 0.684182>, <0.140743, 6.300001, 0.800000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.261370, 0.507396>, <-0.140743, 6.256570, 0.684182>, <-0.140743, 6.300001, 0.800000>, 
      <-0.140743, 6.137641, 0.444857>, <-0.140743, 6.199010, 0.552253>, <-0.140743, 6.189348, 0.721360>, <-0.140743, 6.232779, 0.837177>, 
      <-0.076817, 6.085747, 0.482186>, <-0.076817, 6.142796, 0.586574>, <-0.076818, 6.133376, 0.757378>, <-0.076818, 6.176838, 0.868115>, 
      <0.000000, 6.085747, 0.482186>, <0.000000, 6.142796, 0.586574>, <0.000000, 6.133376, 0.757378>, <0.000000, 6.176838, 0.868115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.262360, 0.355143>, <-0.076817, 6.314255, 0.317814>, <0.000000, 6.314255, 0.317814>, 
      <-0.140743, 6.261370, 0.507396>, <-0.140743, 6.323730, 0.462539>, <-0.076817, 6.379783, 0.428288>, <0.000000, 6.379783, 0.428288>, 
      <-0.140743, 6.256570, 0.684182>, <-0.140743, 6.323792, 0.647006>, <-0.076817, 6.380047, 0.610892>, <0.000000, 6.380047, 0.610892>, 
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.367223, 0.762823>, <-0.076817, 6.423163, 0.731885>, <0.000000, 6.423163, 0.731885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 5.900001, 0.100000>, <0.140743, 6.005904, 0.170602>, <0.140743, 6.136853, 0.289491>, <0.140743, 6.200001, 0.400000>, 
      <0.140743, 5.943369, 0.036596>, <0.140743, 6.049272, 0.107198>, <0.140743, 6.199212, 0.244634>, <0.140743, 6.262360, 0.355143>, 
      <0.076817, 5.979459, -0.016168>, <0.076817, 6.098843, 0.060477>, <0.076817, 6.241880, 0.195795>, <0.076817, 6.314255, 0.317814>, 
      <0.000000, 5.979459, -0.016168>, <0.000000, 6.098843, 0.060477>, <0.000000, 6.241880, 0.195795>, <0.000000, 6.314255, 0.317814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 5.820542, 0.216168>, <0.000000, 5.912734, 0.280972>, <0.000000, 6.031705, 0.383300>, <0.000000, 6.085747, 0.482186>, 
      <0.076817, 5.820542, 0.216168>, <0.076817, 5.912734, 0.280972>, <0.076817, 6.031705, 0.383300>, <0.076817, 6.085747, 0.482186>, 
      <0.140743, 5.856633, 0.163404>, <0.140743, 5.962535, 0.234006>, <0.140743, 6.074493, 0.334348>, <0.140743, 6.137641, 0.444857>, 
      <0.140743, 5.900001, 0.100000>, <0.140743, 6.005904, 0.170602>, <0.140743, 6.136853, 0.289491>, <0.140743, 6.200001, 0.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 6.005904, 0.170602>, <-0.140743, 6.136853, 0.289491>, <-0.140743, 6.200001, 0.400000>, 
      <-0.140743, 5.856633, 0.163404>, <-0.140743, 5.962535, 0.234006>, <-0.140743, 6.074493, 0.334348>, <-0.140743, 6.137641, 0.444857>, 
      <-0.076817, 5.820542, 0.216168>, <-0.076817, 5.912734, 0.280972>, <-0.076817, 6.031705, 0.383300>, <-0.076817, 6.085747, 0.482186>, 
      <0.000000, 5.820542, 0.216168>, <0.000000, 5.912734, 0.280972>, <0.000000, 6.031705, 0.383300>, <0.000000, 6.085747, 0.482186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 5.943369, 0.036596>, <-0.076817, 5.979459, -0.016168>, <0.000000, 5.979459, -0.016168>, 
      <-0.140743, 6.005904, 0.170602>, <-0.140743, 6.049272, 0.107198>, <-0.076817, 6.098843, 0.060477>, <0.000000, 6.098843, 0.060477>, 
      <-0.140743, 6.136853, 0.289491>, <-0.140743, 6.199212, 0.244634>, <-0.076817, 6.241880, 0.195795>, <0.000000, 6.241880, 0.195795>, 
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.262360, 0.355143>, <-0.076817, 6.314255, 0.317814>, <0.000000, 6.314255, 0.317814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 5.600000, 0.000000>, <0.140743, 5.694855, 0.001608>, <0.140743, 5.821066, 0.047376>, <0.140743, 5.900001, 0.100000>, 
      <0.140743, 5.600000, -0.076817>, <0.140743, 5.694855, -0.075210>, <0.140743, 5.864434, -0.016028>, <0.140743, 5.943369, 0.036596>, 
      <0.076817, 5.600000, -0.140743>, <0.076817, 5.719790, -0.138247>, <0.076817, 5.878634, -0.080898>, <0.076817, 5.979459, -0.016168>, 
      <0.000000, 5.600000, -0.140743>, <0.000000, 5.719790, -0.138247>, <0.000000, 5.878634, -0.080898>, <0.000000, 5.979459, -0.016168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 5.600000, 0.140743>, <0.000000, 5.669919, 0.141649>, <0.000000, 5.763336, 0.175957>, <0.000000, 5.820542, 0.216168>, 
      <0.076817, 5.600000, 0.140743>, <0.076817, 5.669919, 0.141649>, <0.076817, 5.763336, 0.175957>, <0.076817, 5.820542, 0.216168>, 
      <0.140743, 5.600000, 0.076817>, <0.140743, 5.694855, 0.078425>, <0.140743, 5.777697, 0.110781>, <0.140743, 5.856633, 0.163404>, 
      <0.140743, 5.600000, 0.000000>, <0.140743, 5.694855, 0.001608>, <0.140743, 5.821066, 0.047376>, <0.140743, 5.900001, 0.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.694855, 0.001608>, <-0.140743, 5.821066, 0.047376>, <-0.140743, 5.900001, 0.100000>, 
      <-0.140743, 5.600000, 0.076817>, <-0.140743, 5.694855, 0.078425>, <-0.140743, 5.777697, 0.110781>, <-0.140743, 5.856633, 0.163404>, 
      <-0.076817, 5.600000, 0.140743>, <-0.076817, 5.669919, 0.141649>, <-0.076817, 5.763336, 0.175957>, <-0.076817, 5.820542, 0.216168>, 
      <0.000000, 5.600000, 0.140743>, <0.000000, 5.669919, 0.141649>, <0.000000, 5.763336, 0.175957>, <0.000000, 5.820542, 0.216168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.600000, -0.076817>, <-0.076817, 5.600000, -0.140743>, <0.000000, 5.600000, -0.140743>, 
      <-0.140743, 5.694855, 0.001608>, <-0.140743, 5.694855, -0.075210>, <-0.076817, 5.719790, -0.138247>, <0.000000, 5.719790, -0.138247>, 
      <-0.140743, 5.821066, 0.047376>, <-0.140743, 5.864434, -0.016028>, <-0.076817, 5.878634, -0.080898>, <0.000000, 5.878634, -0.080898>, 
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 5.943369, 0.036596>, <-0.076817, 5.979459, -0.016168>, <0.000000, 5.979459, -0.016168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -1.500000, 1.300000>, <0.140743, -1.410000, 1.270000>, <0.140743, -1.282369, 1.247068>, <0.140743, -1.200000, 1.200000>, 
      <0.140743, -1.500606, 1.223185>, <0.140743, -1.410606, 1.193185>, <0.140743, -1.286611, 1.170368>, <0.140743, -1.204243, 1.123300>, 
      <0.076817, -1.501111, 1.159261>, <0.076817, -1.413110, 1.129324>, <0.076817, -1.287603, 1.107091>, <0.076817, -1.207773, 1.059472>, 
      <0.000000, -1.501111, 1.159261>, <0.000000, -1.413110, 1.129324>, <0.000000, -1.287603, 1.107091>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.498889, 1.440739>, <0.000000, -1.406890, 1.410676>, <0.000000, -1.277067, 1.387108>, <0.000000, -1.192227, 1.340528>, 
      <0.076817, -1.498889, 1.440739>, <0.076817, -1.406890, 1.410676>, <0.076817, -1.277067, 1.387108>, <0.076817, -1.192227, 1.340528>, 
      <0.140743, -1.499394, 1.376815>, <0.140743, -1.409394, 1.346815>, <0.140743, -1.278126, 1.323768>, <0.140743, -1.195758, 1.276700>, 
      <0.140743, -1.500000, 1.300000>, <0.140743, -1.410000, 1.270000>, <0.140743, -1.282369, 1.247068>, <0.140743, -1.200000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -1.500000, 1.300000>, <-0.140743, -1.410000, 1.270000>, <-0.140743, -1.282369, 1.247068>, <-0.140743, -1.200000, 1.200000>, 
      <-0.140743, -1.499394, 1.376815>, <-0.140743, -1.409394, 1.346815>, <-0.140743, -1.278126, 1.323768>, <-0.140743, -1.195758, 1.276700>, 
      <-0.076817, -1.498889, 1.440739>, <-0.076817, -1.406890, 1.410676>, <-0.076817, -1.277067, 1.387108>, <-0.076817, -1.192227, 1.340528>, 
      <0.000000, -1.498889, 1.440739>, <0.000000, -1.406890, 1.410676>, <0.000000, -1.277067, 1.387108>, <0.000000, -1.192227, 1.340528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -1.500000, 1.300000>, <-0.140743, -1.500606, 1.223185>, <-0.076817, -1.501111, 1.159261>, <0.000000, -1.501111, 1.159261>, 
      <-0.140743, -1.410000, 1.270000>, <-0.140743, -1.410606, 1.193185>, <-0.076817, -1.413110, 1.129324>, <0.000000, -1.413110, 1.129324>, 
      <-0.140743, -1.282369, 1.247068>, <-0.140743, -1.286611, 1.170368>, <-0.076817, -1.287603, 1.107091>, <0.000000, -1.287603, 1.107091>, 
      <-0.140743, -1.200000, 1.200000>, <-0.140743, -1.204243, 1.123300>, <-0.076817, -1.207773, 1.059472>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.800000, 0.900000>, <0.140743, -0.822117, 0.826436>, <0.076817, -0.840523, 0.765217>, <0.000000, -0.840523, 0.765217>, 
      <0.140743, -0.906066, 1.006066>, <0.140743, -0.928184, 0.932502>, <0.076817, -0.935585, 0.869593>, <0.000000, -0.935585, 0.869593>, 
      <0.140743, -1.069764, 1.125579>, <0.140743, -1.074006, 1.048879>, <0.076817, -1.086527, 0.987148>, <0.000000, -1.086527, 0.987148>, 
      <0.140743, -1.200000, 1.200000>, <0.140743, -1.204243, 1.123300>, <0.076817, -1.207773, 1.059472>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.759477, 1.034783>, <0.076817, -0.759477, 1.034783>, <0.140743, -0.777883, 0.973564>, <0.140743, -0.800000, 0.900000>, 
      <0.000000, -0.876080, 1.142817>, <0.076817, -0.876080, 1.142817>, <0.140743, -0.883949, 1.079630>, <0.140743, -0.906066, 1.006066>, 
      <0.000000, -1.052888, 1.264027>, <0.076817, -1.052888, 1.264027>, <0.140743, -1.065521, 1.202279>, <0.140743, -1.069764, 1.125579>, 
      <0.000000, -1.192227, 1.340528>, <0.076817, -1.192227, 1.340528>, <0.140743, -1.195758, 1.276700>, <0.140743, -1.200000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.777883, 0.973564>, <-0.076817, -0.759477, 1.034783>, <0.000000, -0.759477, 1.034783>, 
      <-0.140743, -0.906066, 1.006066>, <-0.140743, -0.883949, 1.079630>, <-0.076817, -0.876080, 1.142817>, <0.000000, -0.876080, 1.142817>, 
      <-0.140743, -1.069764, 1.125579>, <-0.140743, -1.065521, 1.202279>, <-0.076817, -1.052888, 1.264027>, <0.000000, -1.052888, 1.264027>, 
      <-0.140743, -1.200000, 1.200000>, <-0.140743, -1.195758, 1.276700>, <-0.076817, -1.192227, 1.340528>, <0.000000, -1.192227, 1.340528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.906066, 1.006066>, <-0.140743, -1.069764, 1.125579>, <-0.140743, -1.200000, 1.200000>, 
      <-0.140743, -0.822117, 0.826436>, <-0.140743, -0.928184, 0.932502>, <-0.140743, -1.074006, 1.048879>, <-0.140743, -1.204243, 1.123300>, 
      <-0.076817, -0.840523, 0.765217>, <-0.076817, -0.935585, 0.869593>, <-0.076817, -1.086527, 0.987148>, <-0.076817, -1.207773, 1.059472>, 
      <0.000000, -0.840523, 0.765217>, <0.000000, -0.935585, 0.869593>, <0.000000, -1.086527, 0.987148>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.600000, 0.600000>, <0.140743, -0.651009, 0.542563>, <0.076817, -0.693458, 0.494766>, <0.000000, -0.693458, 0.494766>, 
      <0.140743, -0.660000, 0.690000>, <0.140743, -0.711009, 0.632563>, <0.076817, -0.740982, 0.573955>, <0.000000, -0.740982, 0.573955>, 
      <0.140743, -0.723515, 0.823515>, <0.140743, -0.745632, 0.749950>, <0.076817, -0.778336, 0.696937>, <0.000000, -0.778336, 0.696937>, 
      <0.140743, -0.800000, 0.900000>, <0.140743, -0.822117, 0.826436>, <0.076817, -0.840523, 0.765217>, <0.000000, -0.840523, 0.765217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.506542, 0.705234>, <0.076817, -0.506542, 0.705234>, <0.140743, -0.548991, 0.657437>, <0.140743, -0.600000, 0.600000>, 
      <0.000000, -0.579132, 0.806539>, <0.076817, -0.579132, 0.806539>, <0.140743, -0.608991, 0.747437>, <0.140743, -0.660000, 0.690000>, 
      <0.000000, -0.668057, 0.950081>, <0.076817, -0.668057, 0.950081>, <0.140743, -0.701397, 0.897079>, <0.140743, -0.723515, 0.823515>, 
      <0.000000, -0.759477, 1.034783>, <0.076817, -0.759477, 1.034783>, <0.140743, -0.777883, 0.973564>, <0.140743, -0.800000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.548991, 0.657437>, <-0.076817, -0.506542, 0.705234>, <0.000000, -0.506542, 0.705234>, 
      <-0.140743, -0.660000, 0.690000>, <-0.140743, -0.608991, 0.747437>, <-0.076817, -0.579132, 0.806539>, <0.000000, -0.579132, 0.806539>, 
      <-0.140743, -0.723515, 0.823515>, <-0.140743, -0.701397, 0.897079>, <-0.076817, -0.668057, 0.950081>, <0.000000, -0.668057, 0.950081>, 
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.777883, 0.973564>, <-0.076817, -0.759477, 1.034783>, <0.000000, -0.759477, 1.034783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.660000, 0.690000>, <-0.140743, -0.723515, 0.823515>, <-0.140743, -0.800000, 0.900000>, 
      <-0.140743, -0.651009, 0.542563>, <-0.140743, -0.711009, 0.632563>, <-0.140743, -0.745632, 0.749950>, <-0.140743, -0.822117, 0.826436>, 
      <-0.076817, -0.693458, 0.494766>, <-0.076817, -0.740982, 0.573955>, <-0.076817, -0.778336, 0.696937>, <-0.076817, -0.840523, 0.765217>, 
      <0.000000, -0.693458, 0.494766>, <0.000000, -0.740982, 0.573955>, <0.000000, -0.778336, 0.696937>, <0.000000, -0.840523, 0.765217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.400000, 0.300000>, <0.140743, -0.472022, 0.273284>, <0.076817, -0.531957, 0.251052>, <0.000000, -0.531957, 0.251052>, 
      <0.140743, -0.467571, 0.384464>, <0.140743, -0.539593, 0.357748>, <0.076817, -0.586693, 0.319587>, <0.000000, -0.586693, 0.319587>, 
      <0.140743, -0.540000, 0.510000>, <0.140743, -0.591009, 0.452563>, <0.076817, -0.648324, 0.419559>, <0.000000, -0.648324, 0.419559>, 
      <0.140743, -0.600000, 0.600000>, <0.140743, -0.651009, 0.542563>, <0.076817, -0.693458, 0.494766>, <0.000000, -0.693458, 0.494766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.268043, 0.348948>, <0.076817, -0.268043, 0.348948>, <0.140743, -0.327978, 0.326716>, <0.140743, -0.400000, 0.300000>, 
      <0.000000, -0.348475, 0.449320>, <0.076817, -0.348475, 0.449320>, <0.140743, -0.395549, 0.411180>, <0.140743, -0.467571, 0.384464>, 
      <0.000000, -0.431625, 0.600681>, <0.076817, -0.431625, 0.600681>, <0.140743, -0.488991, 0.567437>, <0.140743, -0.540000, 0.510000>, 
      <0.000000, -0.506542, 0.705234>, <0.076817, -0.506542, 0.705234>, <0.140743, -0.548991, 0.657437>, <0.140743, -0.600000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.327978, 0.326716>, <-0.076817, -0.268043, 0.348948>, <0.000000, -0.268043, 0.348948>, 
      <-0.140743, -0.467571, 0.384464>, <-0.140743, -0.395549, 0.411180>, <-0.076817, -0.348475, 0.449320>, <0.000000, -0.348475, 0.449320>, 
      <-0.140743, -0.540000, 0.510000>, <-0.140743, -0.488991, 0.567437>, <-0.076817, -0.431625, 0.600681>, <0.000000, -0.431625, 0.600681>, 
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.548991, 0.657437>, <-0.076817, -0.506542, 0.705234>, <0.000000, -0.506542, 0.705234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.467571, 0.384464>, <-0.140743, -0.540000, 0.510000>, <-0.140743, -0.600000, 0.600000>, 
      <-0.140743, -0.472022, 0.273284>, <-0.140743, -0.539593, 0.357748>, <-0.140743, -0.591009, 0.452563>, <-0.140743, -0.651009, 0.542563>, 
      <-0.076817, -0.531957, 0.251052>, <-0.076817, -0.586693, 0.319587>, <-0.076817, -0.648324, 0.419559>, <-0.076817, -0.693458, 0.494766>, 
      <0.000000, -0.531957, 0.251052>, <0.000000, -0.586693, 0.319587>, <0.000000, -0.648324, 0.419559>, <0.000000, -0.693458, 0.494766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.200000, 0.100000>, <0.140743, -0.252355, 0.043787>, <0.076817, -0.295923, -0.002992>, <0.000000, -0.295923, -0.002992>, 
      <0.140743, -0.267882, 0.150912>, <0.140743, -0.320237, 0.094699>, <0.076817, -0.379687, 0.058702>, <0.000000, -0.379687, 0.058702>, 
      <0.140743, -0.346993, 0.233741>, <0.140743, -0.419015, 0.207025>, <0.076817, -0.467036, 0.169764>, <0.000000, -0.467036, 0.169764>, 
      <0.140743, -0.400000, 0.300000>, <0.140743, -0.472022, 0.273284>, <0.076817, -0.531957, 0.251052>, <0.000000, -0.531957, 0.251052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.104077, 0.202992>, <0.076817, -0.104077, 0.202992>, <0.140743, -0.147645, 0.156213>, <0.140743, -0.200000, 0.100000>, 
      <0.000000, -0.156086, 0.243390>, <0.076817, -0.156086, 0.243390>, <0.140743, -0.215528, 0.207125>, <0.140743, -0.267882, 0.150912>, 
      <0.000000, -0.226862, 0.297557>, <0.076817, -0.226862, 0.297557>, <0.140743, -0.274971, 0.260457>, <0.140743, -0.346993, 0.233741>, 
      <0.000000, -0.268043, 0.348948>, <0.076817, -0.268043, 0.348948>, <0.140743, -0.327978, 0.326716>, <0.140743, -0.400000, 0.300000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.147645, 0.156213>, <-0.076817, -0.104077, 0.202992>, <0.000000, -0.104077, 0.202992>, 
      <-0.140743, -0.267882, 0.150912>, <-0.140743, -0.215528, 0.207125>, <-0.076817, -0.156086, 0.243390>, <0.000000, -0.156086, 0.243390>, 
      <-0.140743, -0.346993, 0.233741>, <-0.140743, -0.274971, 0.260457>, <-0.076817, -0.226862, 0.297557>, <0.000000, -0.226862, 0.297557>, 
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.327978, 0.326716>, <-0.076817, -0.268043, 0.348948>, <0.000000, -0.268043, 0.348948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.267882, 0.150912>, <-0.140743, -0.346993, 0.233741>, <-0.140743, -0.400000, 0.300000>, 
      <-0.140743, -0.252355, 0.043787>, <-0.140743, -0.320237, 0.094699>, <-0.140743, -0.419015, 0.207025>, <-0.140743, -0.472022, 0.273284>, 
      <-0.076817, -0.295923, -0.002992>, <-0.076817, -0.379687, 0.058702>, <-0.076817, -0.467036, 0.169764>, <-0.076817, -0.531957, 0.251052>, 
      <0.000000, -0.295923, -0.002992>, <0.000000, -0.379687, 0.058702>, <0.000000, -0.467036, 0.169764>, <0.000000, -0.531957, 0.251052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 0.000000, 0.000000>, <0.140743, 0.000000, -0.076817>, <0.076817, 0.000000, -0.140743>, <0.000000, 0.000000, -0.140743>, 
      <0.140743, -0.067072, 0.001156>, <0.140743, -0.067072, -0.075661>, <0.076817, -0.097897, -0.138456>, <0.000000, -0.097897, -0.138456>, 
      <0.140743, -0.146334, 0.059751>, <0.140743, -0.198689, 0.003538>, <0.076817, -0.217076, -0.061064>, <0.000000, -0.217076, -0.061064>, 
      <0.140743, -0.200000, 0.100000>, <0.140743, -0.252355, 0.043787>, <0.076817, -0.295923, -0.002992>, <0.000000, -0.295923, -0.002992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 0.000000, 0.000000>, <0.140743, 1.679750, -0.028961>, <0.140743, 3.920241, -0.028470>, <0.140743, 5.600000, 0.000000>, 
      <0.140743, 0.000000, -0.076817>, <0.140743, 1.679750, -0.105779>, <0.140743, 3.920241, -0.105288>, <0.140743, 5.600000, -0.076817>, 
      <0.076817, 0.000000, -0.140743>, <0.076817, 1.679542, -0.179983>, <0.076817, 3.920364, -0.175736>, <0.076817, 5.600000, -0.140743>, 
      <0.000000, 0.000000, -0.140743>, <0.000000, 1.679542, -0.179983>, <0.000000, 3.920364, -0.175736>, <0.000000, 5.600000, -0.140743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.140743>, <0.076817, 0.000000, 0.140743>, <0.140743, 0.000000, 0.076817>, <0.140743, 0.000000, 0.000000>, 
      <0.000000, -0.036380, 0.141140>, <0.076817, -0.036380, 0.141140>, <0.140743, -0.067072, 0.077974>, <0.140743, -0.067072, 0.001156>, 
      <0.000000, -0.075345, 0.180674>, <0.076817, -0.075345, 0.180674>, <0.140743, -0.093980, 0.115964>, <0.140743, -0.146334, 0.059751>, 
      <0.000000, -0.104077, 0.202992>, <0.076817, -0.104077, 0.202992>, <0.140743, -0.147645, 0.156213>, <0.140743, -0.200000, 0.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.140743>, <0.000000, 1.679900, 0.122410>, <0.000000, 3.920141, 0.118975>, <0.000000, 5.600000, 0.140743>, 
      <0.076817, 0.000000, 0.140743>, <0.076817, 1.679900, 0.122410>, <0.076817, 3.920141, 0.118975>, <0.076817, 5.600000, 0.140743>, 
      <0.140743, 0.000000, 0.076817>, <0.140743, 1.679750, 0.047856>, <0.140743, 3.920241, 0.048347>, <0.140743, 5.600000, 0.076817>, 
      <0.140743, 0.000000, 0.000000>, <0.140743, 1.679750, -0.028961>, <0.140743, 3.920241, -0.028470>, <0.140743, 5.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 0.000000, 0.076817>, <-0.076817, 0.000000, 0.140743>, <0.000000, 0.000000, 0.140743>, 
      <-0.140743, -0.067072, 0.001156>, <-0.140743, -0.067072, 0.077974>, <-0.076817, -0.036380, 0.141140>, <0.000000, -0.036380, 0.141140>, 
      <-0.140743, -0.146334, 0.059751>, <-0.140743, -0.093980, 0.115964>, <-0.076817, -0.075345, 0.180674>, <0.000000, -0.075345, 0.180674>, 
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.147645, 0.156213>, <-0.076817, -0.104077, 0.202992>, <0.000000, -0.104077, 0.202992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 1.679750, -0.028961>, <-0.140743, 3.920241, -0.028470>, <-0.140743, 5.600000, 0.000000>, 
      <-0.140743, 0.000000, 0.076817>, <-0.140743, 1.679750, 0.047856>, <-0.140743, 3.920241, 0.048347>, <-0.140743, 5.600000, 0.076817>, 
      <-0.076817, 0.000000, 0.140743>, <-0.076817, 1.679900, 0.122410>, <-0.076817, 3.920141, 0.118975>, <-0.076817, 5.600000, 0.140743>, 
      <0.000000, 0.000000, 0.140743>, <0.000000, 1.679900, 0.122410>, <0.000000, 3.920141, 0.118975>, <0.000000, 5.600000, 0.140743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, -0.067072, 0.001156>, <-0.140743, -0.146334, 0.059751>, <-0.140743, -0.200000, 0.100000>, 
      <-0.140743, 0.000000, -0.076817>, <-0.140743, -0.067072, -0.075661>, <-0.140743, -0.198689, 0.003538>, <-0.140743, -0.252355, 0.043787>, 
      <-0.076817, 0.000000, -0.140743>, <-0.076817, -0.097897, -0.138456>, <-0.076817, -0.217076, -0.061064>, <-0.076817, -0.295923, -0.002992>, 
      <0.000000, 0.000000, -0.140743>, <0.000000, -0.097897, -0.138456>, <0.000000, -0.217076, -0.061064>, <0.000000, -0.295923, -0.002992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 0.000000, -0.076817>, <-0.076817, 0.000000, -0.140743>, <0.000000, 0.000000, -0.140743>, 
      <-0.140743, 1.679750, -0.028961>, <-0.140743, 1.679750, -0.105779>, <-0.076817, 1.679542, -0.179983>, <0.000000, 1.679542, -0.179983>, 
      <-0.140743, 3.920241, -0.028470>, <-0.140743, 3.920241, -0.105288>, <-0.076817, 3.920364, -0.175736>, <0.000000, 3.920364, -0.175736>, 
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.600000, -0.076817>, <-0.076817, 5.600000, -0.140743>, <0.000000, 5.600000, -0.140743>
    }
  }
  rotate <90.0, 0.0, -144.0>
  translate  <-7.273379, 4.296583, 1.482859>
}
#declare sPatchObj4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.219248, 7.400001, 1.500000>, <0.219248, 7.399057, 1.380338>, <0.119665, 7.398270, 1.280759>, <0.000000, 7.398270, 1.280759>, 
      <0.195697, 7.250001, 1.470000>, <0.195697, 7.249056, 1.350339>, <0.119665, 7.265638, 1.277815>, <0.000000, 7.265638, 1.277815>, 
      <0.153507, 7.046331, 1.448777>, <0.153507, 7.076984, 1.378340>, <0.076817, 7.085345, 1.301140>, <0.000000, 7.085345, 1.301140>, 
      <0.140743, 6.900001, 1.400000>, <0.140743, 6.930654, 1.329563>, <0.076817, 6.956161, 1.270947>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 7.401731, 1.719241>, <0.119665, 7.401731, 1.719241>, <0.219248, 7.400946, 1.619662>, <0.219248, 7.400001, 1.500000>, 
      <0.000000, 7.234363, 1.662184>, <0.119665, 7.234363, 1.662184>, <0.195697, 7.250946, 1.589662>, <0.195697, 7.250001, 1.470000>, 
      <0.000000, 7.007190, 1.596760>, <0.076817, 7.007190, 1.596760>, <0.153507, 7.015679, 1.519213>, <0.153507, 7.046331, 1.448777>, 
      <0.000000, 6.843840, 1.529052>, <0.076817, 6.843840, 1.529052>, <0.140743, 6.869349, 1.470437>, <0.140743, 6.900001, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219248, 7.400001, 1.500000>, <-0.219248, 7.400946, 1.619662>, <-0.119665, 7.401731, 1.719241>, <0.000000, 7.401731, 1.719241>, 
      <-0.195697, 7.250001, 1.470000>, <-0.195697, 7.250946, 1.589662>, <-0.119665, 7.234363, 1.662184>, <0.000000, 7.234363, 1.662184>, 
      <-0.153507, 7.046331, 1.448777>, <-0.153507, 7.015679, 1.519213>, <-0.076817, 7.007190, 1.596760>, <0.000000, 7.007190, 1.596760>, 
      <-0.140743, 6.900001, 1.400000>, <-0.140743, 6.869349, 1.470437>, <-0.076817, 6.843840, 1.529052>, <0.000000, 6.843840, 1.529052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219248, 7.400001, 1.500000>, <-0.195697, 7.250001, 1.470000>, <-0.153507, 7.046331, 1.448777>, <-0.140743, 6.900001, 1.400000>, 
      <-0.219248, 7.399057, 1.380338>, <-0.195697, 7.249056, 1.350339>, <-0.153507, 7.076984, 1.378340>, <-0.140743, 6.930654, 1.329563>, 
      <-0.119665, 7.398270, 1.280759>, <-0.119665, 7.265638, 1.277815>, <-0.076817, 7.085345, 1.301140>, <-0.076817, 6.956161, 1.270947>, 
      <0.000000, 7.398270, 1.280759>, <0.000000, 7.265638, 1.277815>, <0.000000, 7.085345, 1.301140>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.500000, 1.200000>, <0.140743, 6.594869, 1.294869>, <0.129679, 6.773155, 1.357718>, <0.140743, 6.900001, 1.400000>, 
      <0.140743, 6.549170, 1.140982>, <0.140743, 6.644039, 1.235850>, <0.129679, 6.803808, 1.287281>, <0.140743, 6.930654, 1.329563>, 
      <0.076817, 6.590089, 1.091868>, <0.076817, 6.676048, 1.178805>, <0.076817, 6.837111, 1.243122>, <0.076817, 6.956161, 1.270947>, 
      <0.000000, 6.590089, 1.091868>, <0.000000, 6.676048, 1.178805>, <0.000000, 6.837111, 1.243122>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.409912, 1.308132>, <0.000000, 6.513676, 1.410952>, <0.000000, 6.708895, 1.473117>, <0.000000, 6.843840, 1.529052>, 
      <0.076817, 6.409912, 1.308132>, <0.076817, 6.513676, 1.410952>, <0.076817, 6.708895, 1.473117>, <0.076817, 6.843840, 1.529052>, 
      <0.140743, 6.450830, 1.259018>, <0.140743, 6.545699, 1.353887>, <0.129679, 6.742502, 1.428155>, <0.140743, 6.869349, 1.470437>, 
      <0.140743, 6.500000, 1.200000>, <0.140743, 6.594869, 1.294869>, <0.129679, 6.773155, 1.357718>, <0.140743, 6.900001, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.594869, 1.294869>, <-0.129679, 6.773155, 1.357718>, <-0.140743, 6.900001, 1.400000>, 
      <-0.140743, 6.450830, 1.259018>, <-0.140743, 6.545699, 1.353887>, <-0.129679, 6.742502, 1.428155>, <-0.140743, 6.869349, 1.470437>, 
      <-0.076817, 6.409912, 1.308132>, <-0.076817, 6.513676, 1.410952>, <-0.076817, 6.708895, 1.473117>, <-0.076817, 6.843840, 1.529052>, 
      <0.000000, 6.409912, 1.308132>, <0.000000, 6.513676, 1.410952>, <0.000000, 6.708895, 1.473117>, <0.000000, 6.843840, 1.529052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.549170, 1.140982>, <-0.076817, 6.590089, 1.091868>, <0.000000, 6.590089, 1.091868>, 
      <-0.140743, 6.594869, 1.294869>, <-0.140743, 6.644039, 1.235850>, <-0.076817, 6.676048, 1.178805>, <0.000000, 6.676048, 1.178805>, 
      <-0.129679, 6.773155, 1.357718>, <-0.129679, 6.803808, 1.287281>, <-0.076817, 6.837111, 1.243122>, <0.000000, 6.837111, 1.243122>, 
      <-0.140743, 6.900001, 1.400000>, <-0.140743, 6.930654, 1.329563>, <-0.076817, 6.956161, 1.270947>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.300001, 0.800000>, <0.140743, 6.347109, 0.925622>, <0.140743, 6.405132, 1.105132>, <0.140743, 6.500000, 1.200000>, 
      <0.140743, 6.367223, 0.762823>, <0.140743, 6.414331, 0.888445>, <0.140743, 6.454302, 1.046113>, <0.140743, 6.549170, 1.140982>, 
      <0.076817, 6.423163, 0.731885>, <0.076817, 6.463122, 0.844019>, <0.076817, 6.506392, 1.007219>, <0.076817, 6.590089, 1.091868>, 
      <0.000000, 6.423163, 0.731885>, <0.000000, 6.463122, 0.844019>, <0.000000, 6.506392, 1.007219>, <0.000000, 6.590089, 1.091868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.176838, 0.868115>, <0.000000, 6.231413, 1.007169>, <0.000000, 6.303803, 1.202988>, <0.000000, 6.409912, 1.308132>, 
      <0.076818, 6.176838, 0.868115>, <0.076818, 6.231413, 1.007169>, <0.076817, 6.303803, 1.202988>, <0.076817, 6.409912, 1.308132>, 
      <0.140743, 6.232779, 0.837177>, <0.140743, 6.279887, 0.962799>, <0.140743, 6.355962, 1.164150>, <0.140743, 6.450830, 1.259018>, 
      <0.140743, 6.300001, 0.800000>, <0.140743, 6.347109, 0.925622>, <0.140743, 6.405132, 1.105132>, <0.140743, 6.500000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.347109, 0.925622>, <-0.140743, 6.405132, 1.105132>, <-0.140743, 6.500000, 1.200000>, 
      <-0.140743, 6.232779, 0.837177>, <-0.140743, 6.279887, 0.962799>, <-0.140743, 6.355962, 1.164150>, <-0.140743, 6.450830, 1.259018>, 
      <-0.076818, 6.176838, 0.868115>, <-0.076818, 6.231413, 1.007169>, <-0.076817, 6.303803, 1.202988>, <-0.076817, 6.409912, 1.308132>, 
      <0.000000, 6.176838, 0.868115>, <0.000000, 6.231413, 1.007169>, <0.000000, 6.303803, 1.202988>, <0.000000, 6.409912, 1.308132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.367223, 0.762823>, <-0.076817, 6.423163, 0.731885>, <0.000000, 6.423163, 0.731885>, 
      <-0.140743, 6.347109, 0.925622>, <-0.140743, 6.414331, 0.888445>, <-0.076817, 6.463122, 0.844019>, <0.000000, 6.463122, 0.844019>, 
      <-0.140743, 6.405132, 1.105132>, <-0.140743, 6.454302, 1.046113>, <-0.076817, 6.506392, 1.007219>, <0.000000, 6.506392, 1.007219>, 
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.549170, 1.140982>, <-0.076817, 6.590089, 1.091868>, <0.000000, 6.590089, 1.091868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.200001, 0.400000>, <0.140743, 6.261370, 0.507396>, <0.140743, 6.256570, 0.684182>, <0.140743, 6.300001, 0.800000>, 
      <0.140743, 6.262360, 0.355143>, <0.140743, 6.323730, 0.462539>, <0.140743, 6.323792, 0.647006>, <0.140743, 6.367223, 0.762823>, 
      <0.076817, 6.314255, 0.317814>, <0.076817, 6.379783, 0.428288>, <0.076817, 6.380047, 0.610892>, <0.076817, 6.423163, 0.731885>, 
      <0.000000, 6.314255, 0.317814>, <0.000000, 6.379783, 0.428288>, <0.000000, 6.380047, 0.610892>, <0.000000, 6.423163, 0.731885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.085747, 0.482186>, <0.000000, 6.142796, 0.586574>, <0.000000, 6.133376, 0.757378>, <0.000000, 6.176838, 0.868115>, 
      <0.076817, 6.085747, 0.482186>, <0.076817, 6.142796, 0.586574>, <0.076818, 6.133376, 0.757378>, <0.076818, 6.176838, 0.868115>, 
      <0.140743, 6.137641, 0.444857>, <0.140743, 6.199010, 0.552253>, <0.140743, 6.189348, 0.721360>, <0.140743, 6.232779, 0.837177>, 
      <0.140743, 6.200001, 0.400000>, <0.140743, 6.261370, 0.507396>, <0.140743, 6.256570, 0.684182>, <0.140743, 6.300001, 0.800000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.261370, 0.507396>, <-0.140743, 6.256570, 0.684182>, <-0.140743, 6.300001, 0.800000>, 
      <-0.140743, 6.137641, 0.444857>, <-0.140743, 6.199010, 0.552253>, <-0.140743, 6.189348, 0.721360>, <-0.140743, 6.232779, 0.837177>, 
      <-0.076817, 6.085747, 0.482186>, <-0.076817, 6.142796, 0.586574>, <-0.076818, 6.133376, 0.757378>, <-0.076818, 6.176838, 0.868115>, 
      <0.000000, 6.085747, 0.482186>, <0.000000, 6.142796, 0.586574>, <0.000000, 6.133376, 0.757378>, <0.000000, 6.176838, 0.868115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.262360, 0.355143>, <-0.076817, 6.314255, 0.317814>, <0.000000, 6.314255, 0.317814>, 
      <-0.140743, 6.261370, 0.507396>, <-0.140743, 6.323730, 0.462539>, <-0.076817, 6.379783, 0.428288>, <0.000000, 6.379783, 0.428288>, 
      <-0.140743, 6.256570, 0.684182>, <-0.140743, 6.323792, 0.647006>, <-0.076817, 6.380047, 0.610892>, <0.000000, 6.380047, 0.610892>, 
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.367223, 0.762823>, <-0.076817, 6.423163, 0.731885>, <0.000000, 6.423163, 0.731885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 5.900001, 0.100000>, <0.140743, 6.005904, 0.170602>, <0.140743, 6.136853, 0.289491>, <0.140743, 6.200001, 0.400000>, 
      <0.140743, 5.943369, 0.036596>, <0.140743, 6.049272, 0.107198>, <0.140743, 6.199212, 0.244634>, <0.140743, 6.262360, 0.355143>, 
      <0.076817, 5.979459, -0.016168>, <0.076817, 6.098843, 0.060477>, <0.076817, 6.241880, 0.195795>, <0.076817, 6.314255, 0.317814>, 
      <0.000000, 5.979459, -0.016168>, <0.000000, 6.098843, 0.060477>, <0.000000, 6.241880, 0.195795>, <0.000000, 6.314255, 0.317814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 5.820542, 0.216168>, <0.000000, 5.912734, 0.280972>, <0.000000, 6.031705, 0.383300>, <0.000000, 6.085747, 0.482186>, 
      <0.076817, 5.820542, 0.216168>, <0.076817, 5.912734, 0.280972>, <0.076817, 6.031705, 0.383300>, <0.076817, 6.085747, 0.482186>, 
      <0.140743, 5.856633, 0.163404>, <0.140743, 5.962535, 0.234006>, <0.140743, 6.074493, 0.334348>, <0.140743, 6.137641, 0.444857>, 
      <0.140743, 5.900001, 0.100000>, <0.140743, 6.005904, 0.170602>, <0.140743, 6.136853, 0.289491>, <0.140743, 6.200001, 0.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 6.005904, 0.170602>, <-0.140743, 6.136853, 0.289491>, <-0.140743, 6.200001, 0.400000>, 
      <-0.140743, 5.856633, 0.163404>, <-0.140743, 5.962535, 0.234006>, <-0.140743, 6.074493, 0.334348>, <-0.140743, 6.137641, 0.444857>, 
      <-0.076817, 5.820542, 0.216168>, <-0.076817, 5.912734, 0.280972>, <-0.076817, 6.031705, 0.383300>, <-0.076817, 6.085747, 0.482186>, 
      <0.000000, 5.820542, 0.216168>, <0.000000, 5.912734, 0.280972>, <0.000000, 6.031705, 0.383300>, <0.000000, 6.085747, 0.482186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 5.943369, 0.036596>, <-0.076817, 5.979459, -0.016168>, <0.000000, 5.979459, -0.016168>, 
      <-0.140743, 6.005904, 0.170602>, <-0.140743, 6.049272, 0.107198>, <-0.076817, 6.098843, 0.060477>, <0.000000, 6.098843, 0.060477>, 
      <-0.140743, 6.136853, 0.289491>, <-0.140743, 6.199212, 0.244634>, <-0.076817, 6.241880, 0.195795>, <0.000000, 6.241880, 0.195795>, 
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.262360, 0.355143>, <-0.076817, 6.314255, 0.317814>, <0.000000, 6.314255, 0.317814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 5.600000, 0.000000>, <0.140743, 5.694855, 0.001608>, <0.140743, 5.821066, 0.047376>, <0.140743, 5.900001, 0.100000>, 
      <0.140743, 5.600000, -0.076817>, <0.140743, 5.694855, -0.075210>, <0.140743, 5.864434, -0.016028>, <0.140743, 5.943369, 0.036596>, 
      <0.076817, 5.600000, -0.140743>, <0.076817, 5.719790, -0.138247>, <0.076817, 5.878634, -0.080898>, <0.076817, 5.979459, -0.016168>, 
      <0.000000, 5.600000, -0.140743>, <0.000000, 5.719790, -0.138247>, <0.000000, 5.878634, -0.080898>, <0.000000, 5.979459, -0.016168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 5.600000, 0.140743>, <0.000000, 5.669919, 0.141649>, <0.000000, 5.763336, 0.175957>, <0.000000, 5.820542, 0.216168>, 
      <0.076817, 5.600000, 0.140743>, <0.076817, 5.669919, 0.141649>, <0.076817, 5.763336, 0.175957>, <0.076817, 5.820542, 0.216168>, 
      <0.140743, 5.600000, 0.076817>, <0.140743, 5.694855, 0.078425>, <0.140743, 5.777697, 0.110781>, <0.140743, 5.856633, 0.163404>, 
      <0.140743, 5.600000, 0.000000>, <0.140743, 5.694855, 0.001608>, <0.140743, 5.821066, 0.047376>, <0.140743, 5.900001, 0.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.694855, 0.001608>, <-0.140743, 5.821066, 0.047376>, <-0.140743, 5.900001, 0.100000>, 
      <-0.140743, 5.600000, 0.076817>, <-0.140743, 5.694855, 0.078425>, <-0.140743, 5.777697, 0.110781>, <-0.140743, 5.856633, 0.163404>, 
      <-0.076817, 5.600000, 0.140743>, <-0.076817, 5.669919, 0.141649>, <-0.076817, 5.763336, 0.175957>, <-0.076817, 5.820542, 0.216168>, 
      <0.000000, 5.600000, 0.140743>, <0.000000, 5.669919, 0.141649>, <0.000000, 5.763336, 0.175957>, <0.000000, 5.820542, 0.216168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.600000, -0.076817>, <-0.076817, 5.600000, -0.140743>, <0.000000, 5.600000, -0.140743>, 
      <-0.140743, 5.694855, 0.001608>, <-0.140743, 5.694855, -0.075210>, <-0.076817, 5.719790, -0.138247>, <0.000000, 5.719790, -0.138247>, 
      <-0.140743, 5.821066, 0.047376>, <-0.140743, 5.864434, -0.016028>, <-0.076817, 5.878634, -0.080898>, <0.000000, 5.878634, -0.080898>, 
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 5.943369, 0.036596>, <-0.076817, 5.979459, -0.016168>, <0.000000, 5.979459, -0.016168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -1.500000, 1.300000>, <0.140743, -1.410000, 1.270000>, <0.140743, -1.282369, 1.247068>, <0.140743, -1.200000, 1.200000>, 
      <0.140743, -1.500606, 1.223185>, <0.140743, -1.410606, 1.193185>, <0.140743, -1.286611, 1.170368>, <0.140743, -1.204243, 1.123300>, 
      <0.076817, -1.501111, 1.159261>, <0.076817, -1.413110, 1.129324>, <0.076817, -1.287603, 1.107091>, <0.076817, -1.207773, 1.059472>, 
      <0.000000, -1.501111, 1.159261>, <0.000000, -1.413110, 1.129324>, <0.000000, -1.287603, 1.107091>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.498889, 1.440739>, <0.000000, -1.406890, 1.410676>, <0.000000, -1.277067, 1.387108>, <0.000000, -1.192227, 1.340528>, 
      <0.076817, -1.498889, 1.440739>, <0.076817, -1.406890, 1.410676>, <0.076817, -1.277067, 1.387108>, <0.076817, -1.192227, 1.340528>, 
      <0.140743, -1.499394, 1.376815>, <0.140743, -1.409394, 1.346815>, <0.140743, -1.278126, 1.323768>, <0.140743, -1.195758, 1.276700>, 
      <0.140743, -1.500000, 1.300000>, <0.140743, -1.410000, 1.270000>, <0.140743, -1.282369, 1.247068>, <0.140743, -1.200000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -1.500000, 1.300000>, <-0.140743, -1.410000, 1.270000>, <-0.140743, -1.282369, 1.247068>, <-0.140743, -1.200000, 1.200000>, 
      <-0.140743, -1.499394, 1.376815>, <-0.140743, -1.409394, 1.346815>, <-0.140743, -1.278126, 1.323768>, <-0.140743, -1.195758, 1.276700>, 
      <-0.076817, -1.498889, 1.440739>, <-0.076817, -1.406890, 1.410676>, <-0.076817, -1.277067, 1.387108>, <-0.076817, -1.192227, 1.340528>, 
      <0.000000, -1.498889, 1.440739>, <0.000000, -1.406890, 1.410676>, <0.000000, -1.277067, 1.387108>, <0.000000, -1.192227, 1.340528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -1.500000, 1.300000>, <-0.140743, -1.500606, 1.223185>, <-0.076817, -1.501111, 1.159261>, <0.000000, -1.501111, 1.159261>, 
      <-0.140743, -1.410000, 1.270000>, <-0.140743, -1.410606, 1.193185>, <-0.076817, -1.413110, 1.129324>, <0.000000, -1.413110, 1.129324>, 
      <-0.140743, -1.282369, 1.247068>, <-0.140743, -1.286611, 1.170368>, <-0.076817, -1.287603, 1.107091>, <0.000000, -1.287603, 1.107091>, 
      <-0.140743, -1.200000, 1.200000>, <-0.140743, -1.204243, 1.123300>, <-0.076817, -1.207773, 1.059472>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.800000, 0.900000>, <0.140743, -0.822117, 0.826436>, <0.076817, -0.840523, 0.765217>, <0.000000, -0.840523, 0.765217>, 
      <0.140743, -0.906066, 1.006066>, <0.140743, -0.928184, 0.932502>, <0.076817, -0.935585, 0.869593>, <0.000000, -0.935585, 0.869593>, 
      <0.140743, -1.069764, 1.125579>, <0.140743, -1.074006, 1.048879>, <0.076817, -1.086527, 0.987148>, <0.000000, -1.086527, 0.987148>, 
      <0.140743, -1.200000, 1.200000>, <0.140743, -1.204243, 1.123300>, <0.076817, -1.207773, 1.059472>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.759477, 1.034783>, <0.076817, -0.759477, 1.034783>, <0.140743, -0.777883, 0.973564>, <0.140743, -0.800000, 0.900000>, 
      <0.000000, -0.876080, 1.142817>, <0.076817, -0.876080, 1.142817>, <0.140743, -0.883949, 1.079630>, <0.140743, -0.906066, 1.006066>, 
      <0.000000, -1.052888, 1.264027>, <0.076817, -1.052888, 1.264027>, <0.140743, -1.065521, 1.202279>, <0.140743, -1.069764, 1.125579>, 
      <0.000000, -1.192227, 1.340528>, <0.076817, -1.192227, 1.340528>, <0.140743, -1.195758, 1.276700>, <0.140743, -1.200000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.777883, 0.973564>, <-0.076817, -0.759477, 1.034783>, <0.000000, -0.759477, 1.034783>, 
      <-0.140743, -0.906066, 1.006066>, <-0.140743, -0.883949, 1.079630>, <-0.076817, -0.876080, 1.142817>, <0.000000, -0.876080, 1.142817>, 
      <-0.140743, -1.069764, 1.125579>, <-0.140743, -1.065521, 1.202279>, <-0.076817, -1.052888, 1.264027>, <0.000000, -1.052888, 1.264027>, 
      <-0.140743, -1.200000, 1.200000>, <-0.140743, -1.195758, 1.276700>, <-0.076817, -1.192227, 1.340528>, <0.000000, -1.192227, 1.340528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.906066, 1.006066>, <-0.140743, -1.069764, 1.125579>, <-0.140743, -1.200000, 1.200000>, 
      <-0.140743, -0.822117, 0.826436>, <-0.140743, -0.928184, 0.932502>, <-0.140743, -1.074006, 1.048879>, <-0.140743, -1.204243, 1.123300>, 
      <-0.076817, -0.840523, 0.765217>, <-0.076817, -0.935585, 0.869593>, <-0.076817, -1.086527, 0.987148>, <-0.076817, -1.207773, 1.059472>, 
      <0.000000, -0.840523, 0.765217>, <0.000000, -0.935585, 0.869593>, <0.000000, -1.086527, 0.987148>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.600000, 0.600000>, <0.140743, -0.651009, 0.542563>, <0.076817, -0.693458, 0.494766>, <0.000000, -0.693458, 0.494766>, 
      <0.140743, -0.660000, 0.690000>, <0.140743, -0.711009, 0.632563>, <0.076817, -0.740982, 0.573955>, <0.000000, -0.740982, 0.573955>, 
      <0.140743, -0.723515, 0.823515>, <0.140743, -0.745632, 0.749950>, <0.076817, -0.778336, 0.696937>, <0.000000, -0.778336, 0.696937>, 
      <0.140743, -0.800000, 0.900000>, <0.140743, -0.822117, 0.826436>, <0.076817, -0.840523, 0.765217>, <0.000000, -0.840523, 0.765217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.506542, 0.705234>, <0.076817, -0.506542, 0.705234>, <0.140743, -0.548991, 0.657437>, <0.140743, -0.600000, 0.600000>, 
      <0.000000, -0.579132, 0.806539>, <0.076817, -0.579132, 0.806539>, <0.140743, -0.608991, 0.747437>, <0.140743, -0.660000, 0.690000>, 
      <0.000000, -0.668057, 0.950081>, <0.076817, -0.668057, 0.950081>, <0.140743, -0.701397, 0.897079>, <0.140743, -0.723515, 0.823515>, 
      <0.000000, -0.759477, 1.034783>, <0.076817, -0.759477, 1.034783>, <0.140743, -0.777883, 0.973564>, <0.140743, -0.800000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.548991, 0.657437>, <-0.076817, -0.506542, 0.705234>, <0.000000, -0.506542, 0.705234>, 
      <-0.140743, -0.660000, 0.690000>, <-0.140743, -0.608991, 0.747437>, <-0.076817, -0.579132, 0.806539>, <0.000000, -0.579132, 0.806539>, 
      <-0.140743, -0.723515, 0.823515>, <-0.140743, -0.701397, 0.897079>, <-0.076817, -0.668057, 0.950081>, <0.000000, -0.668057, 0.950081>, 
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.777883, 0.973564>, <-0.076817, -0.759477, 1.034783>, <0.000000, -0.759477, 1.034783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.660000, 0.690000>, <-0.140743, -0.723515, 0.823515>, <-0.140743, -0.800000, 0.900000>, 
      <-0.140743, -0.651009, 0.542563>, <-0.140743, -0.711009, 0.632563>, <-0.140743, -0.745632, 0.749950>, <-0.140743, -0.822117, 0.826436>, 
      <-0.076817, -0.693458, 0.494766>, <-0.076817, -0.740982, 0.573955>, <-0.076817, -0.778336, 0.696937>, <-0.076817, -0.840523, 0.765217>, 
      <0.000000, -0.693458, 0.494766>, <0.000000, -0.740982, 0.573955>, <0.000000, -0.778336, 0.696937>, <0.000000, -0.840523, 0.765217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.400000, 0.300000>, <0.140743, -0.472022, 0.273284>, <0.076817, -0.531957, 0.251052>, <0.000000, -0.531957, 0.251052>, 
      <0.140743, -0.467571, 0.384464>, <0.140743, -0.539593, 0.357748>, <0.076817, -0.586693, 0.319587>, <0.000000, -0.586693, 0.319587>, 
      <0.140743, -0.540000, 0.510000>, <0.140743, -0.591009, 0.452563>, <0.076817, -0.648324, 0.419559>, <0.000000, -0.648324, 0.419559>, 
      <0.140743, -0.600000, 0.600000>, <0.140743, -0.651009, 0.542563>, <0.076817, -0.693458, 0.494766>, <0.000000, -0.693458, 0.494766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.268043, 0.348948>, <0.076817, -0.268043, 0.348948>, <0.140743, -0.327978, 0.326716>, <0.140743, -0.400000, 0.300000>, 
      <0.000000, -0.348475, 0.449320>, <0.076817, -0.348475, 0.449320>, <0.140743, -0.395549, 0.411180>, <0.140743, -0.467571, 0.384464>, 
      <0.000000, -0.431625, 0.600681>, <0.076817, -0.431625, 0.600681>, <0.140743, -0.488991, 0.567437>, <0.140743, -0.540000, 0.510000>, 
      <0.000000, -0.506542, 0.705234>, <0.076817, -0.506542, 0.705234>, <0.140743, -0.548991, 0.657437>, <0.140743, -0.600000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.327978, 0.326716>, <-0.076817, -0.268043, 0.348948>, <0.000000, -0.268043, 0.348948>, 
      <-0.140743, -0.467571, 0.384464>, <-0.140743, -0.395549, 0.411180>, <-0.076817, -0.348475, 0.449320>, <0.000000, -0.348475, 0.449320>, 
      <-0.140743, -0.540000, 0.510000>, <-0.140743, -0.488991, 0.567437>, <-0.076817, -0.431625, 0.600681>, <0.000000, -0.431625, 0.600681>, 
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.548991, 0.657437>, <-0.076817, -0.506542, 0.705234>, <0.000000, -0.506542, 0.705234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.467571, 0.384464>, <-0.140743, -0.540000, 0.510000>, <-0.140743, -0.600000, 0.600000>, 
      <-0.140743, -0.472022, 0.273284>, <-0.140743, -0.539593, 0.357748>, <-0.140743, -0.591009, 0.452563>, <-0.140743, -0.651009, 0.542563>, 
      <-0.076817, -0.531957, 0.251052>, <-0.076817, -0.586693, 0.319587>, <-0.076817, -0.648324, 0.419559>, <-0.076817, -0.693458, 0.494766>, 
      <0.000000, -0.531957, 0.251052>, <0.000000, -0.586693, 0.319587>, <0.000000, -0.648324, 0.419559>, <0.000000, -0.693458, 0.494766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.200000, 0.100000>, <0.140743, -0.252355, 0.043787>, <0.076817, -0.295923, -0.002992>, <0.000000, -0.295923, -0.002992>, 
      <0.140743, -0.267882, 0.150912>, <0.140743, -0.320237, 0.094699>, <0.076817, -0.379687, 0.058702>, <0.000000, -0.379687, 0.058702>, 
      <0.140743, -0.346993, 0.233741>, <0.140743, -0.419015, 0.207025>, <0.076817, -0.467036, 0.169764>, <0.000000, -0.467036, 0.169764>, 
      <0.140743, -0.400000, 0.300000>, <0.140743, -0.472022, 0.273284>, <0.076817, -0.531957, 0.251052>, <0.000000, -0.531957, 0.251052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.104077, 0.202992>, <0.076817, -0.104077, 0.202992>, <0.140743, -0.147645, 0.156213>, <0.140743, -0.200000, 0.100000>, 
      <0.000000, -0.156086, 0.243390>, <0.076817, -0.156086, 0.243390>, <0.140743, -0.215528, 0.207125>, <0.140743, -0.267882, 0.150912>, 
      <0.000000, -0.226862, 0.297557>, <0.076817, -0.226862, 0.297557>, <0.140743, -0.274971, 0.260457>, <0.140743, -0.346993, 0.233741>, 
      <0.000000, -0.268043, 0.348948>, <0.076817, -0.268043, 0.348948>, <0.140743, -0.327978, 0.326716>, <0.140743, -0.400000, 0.300000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.147645, 0.156213>, <-0.076817, -0.104077, 0.202992>, <0.000000, -0.104077, 0.202992>, 
      <-0.140743, -0.267882, 0.150912>, <-0.140743, -0.215528, 0.207125>, <-0.076817, -0.156086, 0.243390>, <0.000000, -0.156086, 0.243390>, 
      <-0.140743, -0.346993, 0.233741>, <-0.140743, -0.274971, 0.260457>, <-0.076817, -0.226862, 0.297557>, <0.000000, -0.226862, 0.297557>, 
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.327978, 0.326716>, <-0.076817, -0.268043, 0.348948>, <0.000000, -0.268043, 0.348948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.267882, 0.150912>, <-0.140743, -0.346993, 0.233741>, <-0.140743, -0.400000, 0.300000>, 
      <-0.140743, -0.252355, 0.043787>, <-0.140743, -0.320237, 0.094699>, <-0.140743, -0.419015, 0.207025>, <-0.140743, -0.472022, 0.273284>, 
      <-0.076817, -0.295923, -0.002992>, <-0.076817, -0.379687, 0.058702>, <-0.076817, -0.467036, 0.169764>, <-0.076817, -0.531957, 0.251052>, 
      <0.000000, -0.295923, -0.002992>, <0.000000, -0.379687, 0.058702>, <0.000000, -0.467036, 0.169764>, <0.000000, -0.531957, 0.251052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 0.000000, 0.000000>, <0.140743, 0.000000, -0.076817>, <0.076817, 0.000000, -0.140743>, <0.000000, 0.000000, -0.140743>, 
      <0.140743, -0.067072, 0.001156>, <0.140743, -0.067072, -0.075661>, <0.076817, -0.097897, -0.138456>, <0.000000, -0.097897, -0.138456>, 
      <0.140743, -0.146334, 0.059751>, <0.140743, -0.198689, 0.003538>, <0.076817, -0.217076, -0.061064>, <0.000000, -0.217076, -0.061064>, 
      <0.140743, -0.200000, 0.100000>, <0.140743, -0.252355, 0.043787>, <0.076817, -0.295923, -0.002992>, <0.000000, -0.295923, -0.002992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 0.000000, 0.000000>, <0.140743, 1.679750, -0.028961>, <0.140743, 3.920241, -0.028470>, <0.140743, 5.600000, 0.000000>, 
      <0.140743, 0.000000, -0.076817>, <0.140743, 1.679750, -0.105779>, <0.140743, 3.920241, -0.105288>, <0.140743, 5.600000, -0.076817>, 
      <0.076817, 0.000000, -0.140743>, <0.076817, 1.679542, -0.179983>, <0.076817, 3.920364, -0.175736>, <0.076817, 5.600000, -0.140743>, 
      <0.000000, 0.000000, -0.140743>, <0.000000, 1.679542, -0.179983>, <0.000000, 3.920364, -0.175736>, <0.000000, 5.600000, -0.140743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.140743>, <0.076817, 0.000000, 0.140743>, <0.140743, 0.000000, 0.076817>, <0.140743, 0.000000, 0.000000>, 
      <0.000000, -0.036380, 0.141140>, <0.076817, -0.036380, 0.141140>, <0.140743, -0.067072, 0.077974>, <0.140743, -0.067072, 0.001156>, 
      <0.000000, -0.075345, 0.180674>, <0.076817, -0.075345, 0.180674>, <0.140743, -0.093980, 0.115964>, <0.140743, -0.146334, 0.059751>, 
      <0.000000, -0.104077, 0.202992>, <0.076817, -0.104077, 0.202992>, <0.140743, -0.147645, 0.156213>, <0.140743, -0.200000, 0.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.140743>, <0.000000, 1.679900, 0.122410>, <0.000000, 3.920141, 0.118975>, <0.000000, 5.600000, 0.140743>, 
      <0.076817, 0.000000, 0.140743>, <0.076817, 1.679900, 0.122410>, <0.076817, 3.920141, 0.118975>, <0.076817, 5.600000, 0.140743>, 
      <0.140743, 0.000000, 0.076817>, <0.140743, 1.679750, 0.047856>, <0.140743, 3.920241, 0.048347>, <0.140743, 5.600000, 0.076817>, 
      <0.140743, 0.000000, 0.000000>, <0.140743, 1.679750, -0.028961>, <0.140743, 3.920241, -0.028470>, <0.140743, 5.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 0.000000, 0.076817>, <-0.076817, 0.000000, 0.140743>, <0.000000, 0.000000, 0.140743>, 
      <-0.140743, -0.067072, 0.001156>, <-0.140743, -0.067072, 0.077974>, <-0.076817, -0.036380, 0.141140>, <0.000000, -0.036380, 0.141140>, 
      <-0.140743, -0.146334, 0.059751>, <-0.140743, -0.093980, 0.115964>, <-0.076817, -0.075345, 0.180674>, <0.000000, -0.075345, 0.180674>, 
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.147645, 0.156213>, <-0.076817, -0.104077, 0.202992>, <0.000000, -0.104077, 0.202992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 1.679750, -0.028961>, <-0.140743, 3.920241, -0.028470>, <-0.140743, 5.600000, 0.000000>, 
      <-0.140743, 0.000000, 0.076817>, <-0.140743, 1.679750, 0.047856>, <-0.140743, 3.920241, 0.048347>, <-0.140743, 5.600000, 0.076817>, 
      <-0.076817, 0.000000, 0.140743>, <-0.076817, 1.679900, 0.122410>, <-0.076817, 3.920141, 0.118975>, <-0.076817, 5.600000, 0.140743>, 
      <0.000000, 0.000000, 0.140743>, <0.000000, 1.679900, 0.122410>, <0.000000, 3.920141, 0.118975>, <0.000000, 5.600000, 0.140743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, -0.067072, 0.001156>, <-0.140743, -0.146334, 0.059751>, <-0.140743, -0.200000, 0.100000>, 
      <-0.140743, 0.000000, -0.076817>, <-0.140743, -0.067072, -0.075661>, <-0.140743, -0.198689, 0.003538>, <-0.140743, -0.252355, 0.043787>, 
      <-0.076817, 0.000000, -0.140743>, <-0.076817, -0.097897, -0.138456>, <-0.076817, -0.217076, -0.061064>, <-0.076817, -0.295923, -0.002992>, 
      <0.000000, 0.000000, -0.140743>, <0.000000, -0.097897, -0.138456>, <0.000000, -0.217076, -0.061064>, <0.000000, -0.295923, -0.002992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 0.000000, -0.076817>, <-0.076817, 0.000000, -0.140743>, <0.000000, 0.000000, -0.140743>, 
      <-0.140743, 1.679750, -0.028961>, <-0.140743, 1.679750, -0.105779>, <-0.076817, 1.679542, -0.179983>, <0.000000, 1.679542, -0.179983>, 
      <-0.140743, 3.920241, -0.028470>, <-0.140743, 3.920241, -0.105288>, <-0.076817, 3.920364, -0.175736>, <0.000000, 3.920364, -0.175736>, 
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.600000, -0.076817>, <-0.076817, 5.600000, -0.140743>, <0.000000, 5.600000, -0.140743>
    }
  }
  rotate <90.0, 0.0, 144.0>
  translate  <-7.273379, 4.296583, 1.482859>
}
#declare sPatchObj5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.219248, 7.400001, 1.500000>, <0.219248, 7.399057, 1.380338>, <0.119665, 7.398270, 1.280759>, <0.000000, 7.398270, 1.280759>, 
      <0.195697, 7.250001, 1.470000>, <0.195697, 7.249056, 1.350339>, <0.119665, 7.265638, 1.277815>, <0.000000, 7.265638, 1.277815>, 
      <0.153507, 7.046331, 1.448777>, <0.153507, 7.076984, 1.378340>, <0.076817, 7.085345, 1.301140>, <0.000000, 7.085345, 1.301140>, 
      <0.140743, 6.900001, 1.400000>, <0.140743, 6.930654, 1.329563>, <0.076817, 6.956161, 1.270947>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 7.401731, 1.719241>, <0.119665, 7.401731, 1.719241>, <0.219248, 7.400946, 1.619662>, <0.219248, 7.400001, 1.500000>, 
      <0.000000, 7.234363, 1.662184>, <0.119665, 7.234363, 1.662184>, <0.195697, 7.250946, 1.589662>, <0.195697, 7.250001, 1.470000>, 
      <0.000000, 7.007190, 1.596760>, <0.076817, 7.007190, 1.596760>, <0.153507, 7.015679, 1.519213>, <0.153507, 7.046331, 1.448777>, 
      <0.000000, 6.843840, 1.529052>, <0.076817, 6.843840, 1.529052>, <0.140743, 6.869349, 1.470437>, <0.140743, 6.900001, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219248, 7.400001, 1.500000>, <-0.219248, 7.400946, 1.619662>, <-0.119665, 7.401731, 1.719241>, <0.000000, 7.401731, 1.719241>, 
      <-0.195697, 7.250001, 1.470000>, <-0.195697, 7.250946, 1.589662>, <-0.119665, 7.234363, 1.662184>, <0.000000, 7.234363, 1.662184>, 
      <-0.153507, 7.046331, 1.448777>, <-0.153507, 7.015679, 1.519213>, <-0.076817, 7.007190, 1.596760>, <0.000000, 7.007190, 1.596760>, 
      <-0.140743, 6.900001, 1.400000>, <-0.140743, 6.869349, 1.470437>, <-0.076817, 6.843840, 1.529052>, <0.000000, 6.843840, 1.529052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219248, 7.400001, 1.500000>, <-0.195697, 7.250001, 1.470000>, <-0.153507, 7.046331, 1.448777>, <-0.140743, 6.900001, 1.400000>, 
      <-0.219248, 7.399057, 1.380338>, <-0.195697, 7.249056, 1.350339>, <-0.153507, 7.076984, 1.378340>, <-0.140743, 6.930654, 1.329563>, 
      <-0.119665, 7.398270, 1.280759>, <-0.119665, 7.265638, 1.277815>, <-0.076817, 7.085345, 1.301140>, <-0.076817, 6.956161, 1.270947>, 
      <0.000000, 7.398270, 1.280759>, <0.000000, 7.265638, 1.277815>, <0.000000, 7.085345, 1.301140>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.500000, 1.200000>, <0.140743, 6.594869, 1.294869>, <0.129679, 6.773155, 1.357718>, <0.140743, 6.900001, 1.400000>, 
      <0.140743, 6.549170, 1.140982>, <0.140743, 6.644039, 1.235850>, <0.129679, 6.803808, 1.287281>, <0.140743, 6.930654, 1.329563>, 
      <0.076817, 6.590089, 1.091868>, <0.076817, 6.676048, 1.178805>, <0.076817, 6.837111, 1.243122>, <0.076817, 6.956161, 1.270947>, 
      <0.000000, 6.590089, 1.091868>, <0.000000, 6.676048, 1.178805>, <0.000000, 6.837111, 1.243122>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.409912, 1.308132>, <0.000000, 6.513676, 1.410952>, <0.000000, 6.708895, 1.473117>, <0.000000, 6.843840, 1.529052>, 
      <0.076817, 6.409912, 1.308132>, <0.076817, 6.513676, 1.410952>, <0.076817, 6.708895, 1.473117>, <0.076817, 6.843840, 1.529052>, 
      <0.140743, 6.450830, 1.259018>, <0.140743, 6.545699, 1.353887>, <0.129679, 6.742502, 1.428155>, <0.140743, 6.869349, 1.470437>, 
      <0.140743, 6.500000, 1.200000>, <0.140743, 6.594869, 1.294869>, <0.129679, 6.773155, 1.357718>, <0.140743, 6.900001, 1.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.594869, 1.294869>, <-0.129679, 6.773155, 1.357718>, <-0.140743, 6.900001, 1.400000>, 
      <-0.140743, 6.450830, 1.259018>, <-0.140743, 6.545699, 1.353887>, <-0.129679, 6.742502, 1.428155>, <-0.140743, 6.869349, 1.470437>, 
      <-0.076817, 6.409912, 1.308132>, <-0.076817, 6.513676, 1.410952>, <-0.076817, 6.708895, 1.473117>, <-0.076817, 6.843840, 1.529052>, 
      <0.000000, 6.409912, 1.308132>, <0.000000, 6.513676, 1.410952>, <0.000000, 6.708895, 1.473117>, <0.000000, 6.843840, 1.529052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.549170, 1.140982>, <-0.076817, 6.590089, 1.091868>, <0.000000, 6.590089, 1.091868>, 
      <-0.140743, 6.594869, 1.294869>, <-0.140743, 6.644039, 1.235850>, <-0.076817, 6.676048, 1.178805>, <0.000000, 6.676048, 1.178805>, 
      <-0.129679, 6.773155, 1.357718>, <-0.129679, 6.803808, 1.287281>, <-0.076817, 6.837111, 1.243122>, <0.000000, 6.837111, 1.243122>, 
      <-0.140743, 6.900001, 1.400000>, <-0.140743, 6.930654, 1.329563>, <-0.076817, 6.956161, 1.270947>, <0.000000, 6.956161, 1.270947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.300001, 0.800000>, <0.140743, 6.347109, 0.925622>, <0.140743, 6.405132, 1.105132>, <0.140743, 6.500000, 1.200000>, 
      <0.140743, 6.367223, 0.762823>, <0.140743, 6.414331, 0.888445>, <0.140743, 6.454302, 1.046113>, <0.140743, 6.549170, 1.140982>, 
      <0.076817, 6.423163, 0.731885>, <0.076817, 6.463122, 0.844019>, <0.076817, 6.506392, 1.007219>, <0.076817, 6.590089, 1.091868>, 
      <0.000000, 6.423163, 0.731885>, <0.000000, 6.463122, 0.844019>, <0.000000, 6.506392, 1.007219>, <0.000000, 6.590089, 1.091868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.176838, 0.868115>, <0.000000, 6.231413, 1.007169>, <0.000000, 6.303803, 1.202988>, <0.000000, 6.409912, 1.308132>, 
      <0.076818, 6.176838, 0.868115>, <0.076818, 6.231413, 1.007169>, <0.076817, 6.303803, 1.202988>, <0.076817, 6.409912, 1.308132>, 
      <0.140743, 6.232779, 0.837177>, <0.140743, 6.279887, 0.962799>, <0.140743, 6.355962, 1.164150>, <0.140743, 6.450830, 1.259018>, 
      <0.140743, 6.300001, 0.800000>, <0.140743, 6.347109, 0.925622>, <0.140743, 6.405132, 1.105132>, <0.140743, 6.500000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.347109, 0.925622>, <-0.140743, 6.405132, 1.105132>, <-0.140743, 6.500000, 1.200000>, 
      <-0.140743, 6.232779, 0.837177>, <-0.140743, 6.279887, 0.962799>, <-0.140743, 6.355962, 1.164150>, <-0.140743, 6.450830, 1.259018>, 
      <-0.076818, 6.176838, 0.868115>, <-0.076818, 6.231413, 1.007169>, <-0.076817, 6.303803, 1.202988>, <-0.076817, 6.409912, 1.308132>, 
      <0.000000, 6.176838, 0.868115>, <0.000000, 6.231413, 1.007169>, <0.000000, 6.303803, 1.202988>, <0.000000, 6.409912, 1.308132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.367223, 0.762823>, <-0.076817, 6.423163, 0.731885>, <0.000000, 6.423163, 0.731885>, 
      <-0.140743, 6.347109, 0.925622>, <-0.140743, 6.414331, 0.888445>, <-0.076817, 6.463122, 0.844019>, <0.000000, 6.463122, 0.844019>, 
      <-0.140743, 6.405132, 1.105132>, <-0.140743, 6.454302, 1.046113>, <-0.076817, 6.506392, 1.007219>, <0.000000, 6.506392, 1.007219>, 
      <-0.140743, 6.500000, 1.200000>, <-0.140743, 6.549170, 1.140982>, <-0.076817, 6.590089, 1.091868>, <0.000000, 6.590089, 1.091868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 6.200001, 0.400000>, <0.140743, 6.261370, 0.507396>, <0.140743, 6.256570, 0.684182>, <0.140743, 6.300001, 0.800000>, 
      <0.140743, 6.262360, 0.355143>, <0.140743, 6.323730, 0.462539>, <0.140743, 6.323792, 0.647006>, <0.140743, 6.367223, 0.762823>, 
      <0.076817, 6.314255, 0.317814>, <0.076817, 6.379783, 0.428288>, <0.076817, 6.380047, 0.610892>, <0.076817, 6.423163, 0.731885>, 
      <0.000000, 6.314255, 0.317814>, <0.000000, 6.379783, 0.428288>, <0.000000, 6.380047, 0.610892>, <0.000000, 6.423163, 0.731885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 6.085747, 0.482186>, <0.000000, 6.142796, 0.586574>, <0.000000, 6.133376, 0.757378>, <0.000000, 6.176838, 0.868115>, 
      <0.076817, 6.085747, 0.482186>, <0.076817, 6.142796, 0.586574>, <0.076818, 6.133376, 0.757378>, <0.076818, 6.176838, 0.868115>, 
      <0.140743, 6.137641, 0.444857>, <0.140743, 6.199010, 0.552253>, <0.140743, 6.189348, 0.721360>, <0.140743, 6.232779, 0.837177>, 
      <0.140743, 6.200001, 0.400000>, <0.140743, 6.261370, 0.507396>, <0.140743, 6.256570, 0.684182>, <0.140743, 6.300001, 0.800000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.261370, 0.507396>, <-0.140743, 6.256570, 0.684182>, <-0.140743, 6.300001, 0.800000>, 
      <-0.140743, 6.137641, 0.444857>, <-0.140743, 6.199010, 0.552253>, <-0.140743, 6.189348, 0.721360>, <-0.140743, 6.232779, 0.837177>, 
      <-0.076817, 6.085747, 0.482186>, <-0.076817, 6.142796, 0.586574>, <-0.076818, 6.133376, 0.757378>, <-0.076818, 6.176838, 0.868115>, 
      <0.000000, 6.085747, 0.482186>, <0.000000, 6.142796, 0.586574>, <0.000000, 6.133376, 0.757378>, <0.000000, 6.176838, 0.868115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.262360, 0.355143>, <-0.076817, 6.314255, 0.317814>, <0.000000, 6.314255, 0.317814>, 
      <-0.140743, 6.261370, 0.507396>, <-0.140743, 6.323730, 0.462539>, <-0.076817, 6.379783, 0.428288>, <0.000000, 6.379783, 0.428288>, 
      <-0.140743, 6.256570, 0.684182>, <-0.140743, 6.323792, 0.647006>, <-0.076817, 6.380047, 0.610892>, <0.000000, 6.380047, 0.610892>, 
      <-0.140743, 6.300001, 0.800000>, <-0.140743, 6.367223, 0.762823>, <-0.076817, 6.423163, 0.731885>, <0.000000, 6.423163, 0.731885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 5.900001, 0.100000>, <0.140743, 6.005904, 0.170602>, <0.140743, 6.136853, 0.289491>, <0.140743, 6.200001, 0.400000>, 
      <0.140743, 5.943369, 0.036596>, <0.140743, 6.049272, 0.107198>, <0.140743, 6.199212, 0.244634>, <0.140743, 6.262360, 0.355143>, 
      <0.076817, 5.979459, -0.016168>, <0.076817, 6.098843, 0.060477>, <0.076817, 6.241880, 0.195795>, <0.076817, 6.314255, 0.317814>, 
      <0.000000, 5.979459, -0.016168>, <0.000000, 6.098843, 0.060477>, <0.000000, 6.241880, 0.195795>, <0.000000, 6.314255, 0.317814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 5.820542, 0.216168>, <0.000000, 5.912734, 0.280972>, <0.000000, 6.031705, 0.383300>, <0.000000, 6.085747, 0.482186>, 
      <0.076817, 5.820542, 0.216168>, <0.076817, 5.912734, 0.280972>, <0.076817, 6.031705, 0.383300>, <0.076817, 6.085747, 0.482186>, 
      <0.140743, 5.856633, 0.163404>, <0.140743, 5.962535, 0.234006>, <0.140743, 6.074493, 0.334348>, <0.140743, 6.137641, 0.444857>, 
      <0.140743, 5.900001, 0.100000>, <0.140743, 6.005904, 0.170602>, <0.140743, 6.136853, 0.289491>, <0.140743, 6.200001, 0.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 6.005904, 0.170602>, <-0.140743, 6.136853, 0.289491>, <-0.140743, 6.200001, 0.400000>, 
      <-0.140743, 5.856633, 0.163404>, <-0.140743, 5.962535, 0.234006>, <-0.140743, 6.074493, 0.334348>, <-0.140743, 6.137641, 0.444857>, 
      <-0.076817, 5.820542, 0.216168>, <-0.076817, 5.912734, 0.280972>, <-0.076817, 6.031705, 0.383300>, <-0.076817, 6.085747, 0.482186>, 
      <0.000000, 5.820542, 0.216168>, <0.000000, 5.912734, 0.280972>, <0.000000, 6.031705, 0.383300>, <0.000000, 6.085747, 0.482186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 5.943369, 0.036596>, <-0.076817, 5.979459, -0.016168>, <0.000000, 5.979459, -0.016168>, 
      <-0.140743, 6.005904, 0.170602>, <-0.140743, 6.049272, 0.107198>, <-0.076817, 6.098843, 0.060477>, <0.000000, 6.098843, 0.060477>, 
      <-0.140743, 6.136853, 0.289491>, <-0.140743, 6.199212, 0.244634>, <-0.076817, 6.241880, 0.195795>, <0.000000, 6.241880, 0.195795>, 
      <-0.140743, 6.200001, 0.400000>, <-0.140743, 6.262360, 0.355143>, <-0.076817, 6.314255, 0.317814>, <0.000000, 6.314255, 0.317814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 5.600000, 0.000000>, <0.140743, 5.694855, 0.001608>, <0.140743, 5.821066, 0.047376>, <0.140743, 5.900001, 0.100000>, 
      <0.140743, 5.600000, -0.076817>, <0.140743, 5.694855, -0.075210>, <0.140743, 5.864434, -0.016028>, <0.140743, 5.943369, 0.036596>, 
      <0.076817, 5.600000, -0.140743>, <0.076817, 5.719790, -0.138247>, <0.076817, 5.878634, -0.080898>, <0.076817, 5.979459, -0.016168>, 
      <0.000000, 5.600000, -0.140743>, <0.000000, 5.719790, -0.138247>, <0.000000, 5.878634, -0.080898>, <0.000000, 5.979459, -0.016168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 5.600000, 0.140743>, <0.000000, 5.669919, 0.141649>, <0.000000, 5.763336, 0.175957>, <0.000000, 5.820542, 0.216168>, 
      <0.076817, 5.600000, 0.140743>, <0.076817, 5.669919, 0.141649>, <0.076817, 5.763336, 0.175957>, <0.076817, 5.820542, 0.216168>, 
      <0.140743, 5.600000, 0.076817>, <0.140743, 5.694855, 0.078425>, <0.140743, 5.777697, 0.110781>, <0.140743, 5.856633, 0.163404>, 
      <0.140743, 5.600000, 0.000000>, <0.140743, 5.694855, 0.001608>, <0.140743, 5.821066, 0.047376>, <0.140743, 5.900001, 0.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.694855, 0.001608>, <-0.140743, 5.821066, 0.047376>, <-0.140743, 5.900001, 0.100000>, 
      <-0.140743, 5.600000, 0.076817>, <-0.140743, 5.694855, 0.078425>, <-0.140743, 5.777697, 0.110781>, <-0.140743, 5.856633, 0.163404>, 
      <-0.076817, 5.600000, 0.140743>, <-0.076817, 5.669919, 0.141649>, <-0.076817, 5.763336, 0.175957>, <-0.076817, 5.820542, 0.216168>, 
      <0.000000, 5.600000, 0.140743>, <0.000000, 5.669919, 0.141649>, <0.000000, 5.763336, 0.175957>, <0.000000, 5.820542, 0.216168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.600000, -0.076817>, <-0.076817, 5.600000, -0.140743>, <0.000000, 5.600000, -0.140743>, 
      <-0.140743, 5.694855, 0.001608>, <-0.140743, 5.694855, -0.075210>, <-0.076817, 5.719790, -0.138247>, <0.000000, 5.719790, -0.138247>, 
      <-0.140743, 5.821066, 0.047376>, <-0.140743, 5.864434, -0.016028>, <-0.076817, 5.878634, -0.080898>, <0.000000, 5.878634, -0.080898>, 
      <-0.140743, 5.900001, 0.100000>, <-0.140743, 5.943369, 0.036596>, <-0.076817, 5.979459, -0.016168>, <0.000000, 5.979459, -0.016168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -1.500000, 1.300000>, <0.140743, -1.410000, 1.270000>, <0.140743, -1.282369, 1.247068>, <0.140743, -1.200000, 1.200000>, 
      <0.140743, -1.500606, 1.223185>, <0.140743, -1.410606, 1.193185>, <0.140743, -1.286611, 1.170368>, <0.140743, -1.204243, 1.123300>, 
      <0.076817, -1.501111, 1.159261>, <0.076817, -1.413110, 1.129324>, <0.076817, -1.287603, 1.107091>, <0.076817, -1.207773, 1.059472>, 
      <0.000000, -1.501111, 1.159261>, <0.000000, -1.413110, 1.129324>, <0.000000, -1.287603, 1.107091>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.498889, 1.440739>, <0.000000, -1.406890, 1.410676>, <0.000000, -1.277067, 1.387108>, <0.000000, -1.192227, 1.340528>, 
      <0.076817, -1.498889, 1.440739>, <0.076817, -1.406890, 1.410676>, <0.076817, -1.277067, 1.387108>, <0.076817, -1.192227, 1.340528>, 
      <0.140743, -1.499394, 1.376815>, <0.140743, -1.409394, 1.346815>, <0.140743, -1.278126, 1.323768>, <0.140743, -1.195758, 1.276700>, 
      <0.140743, -1.500000, 1.300000>, <0.140743, -1.410000, 1.270000>, <0.140743, -1.282369, 1.247068>, <0.140743, -1.200000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -1.500000, 1.300000>, <-0.140743, -1.410000, 1.270000>, <-0.140743, -1.282369, 1.247068>, <-0.140743, -1.200000, 1.200000>, 
      <-0.140743, -1.499394, 1.376815>, <-0.140743, -1.409394, 1.346815>, <-0.140743, -1.278126, 1.323768>, <-0.140743, -1.195758, 1.276700>, 
      <-0.076817, -1.498889, 1.440739>, <-0.076817, -1.406890, 1.410676>, <-0.076817, -1.277067, 1.387108>, <-0.076817, -1.192227, 1.340528>, 
      <0.000000, -1.498889, 1.440739>, <0.000000, -1.406890, 1.410676>, <0.000000, -1.277067, 1.387108>, <0.000000, -1.192227, 1.340528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -1.500000, 1.300000>, <-0.140743, -1.500606, 1.223185>, <-0.076817, -1.501111, 1.159261>, <0.000000, -1.501111, 1.159261>, 
      <-0.140743, -1.410000, 1.270000>, <-0.140743, -1.410606, 1.193185>, <-0.076817, -1.413110, 1.129324>, <0.000000, -1.413110, 1.129324>, 
      <-0.140743, -1.282369, 1.247068>, <-0.140743, -1.286611, 1.170368>, <-0.076817, -1.287603, 1.107091>, <0.000000, -1.287603, 1.107091>, 
      <-0.140743, -1.200000, 1.200000>, <-0.140743, -1.204243, 1.123300>, <-0.076817, -1.207773, 1.059472>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.800000, 0.900000>, <0.140743, -0.822117, 0.826436>, <0.076817, -0.840523, 0.765217>, <0.000000, -0.840523, 0.765217>, 
      <0.140743, -0.906066, 1.006066>, <0.140743, -0.928184, 0.932502>, <0.076817, -0.935585, 0.869593>, <0.000000, -0.935585, 0.869593>, 
      <0.140743, -1.069764, 1.125579>, <0.140743, -1.074006, 1.048879>, <0.076817, -1.086527, 0.987148>, <0.000000, -1.086527, 0.987148>, 
      <0.140743, -1.200000, 1.200000>, <0.140743, -1.204243, 1.123300>, <0.076817, -1.207773, 1.059472>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.759477, 1.034783>, <0.076817, -0.759477, 1.034783>, <0.140743, -0.777883, 0.973564>, <0.140743, -0.800000, 0.900000>, 
      <0.000000, -0.876080, 1.142817>, <0.076817, -0.876080, 1.142817>, <0.140743, -0.883949, 1.079630>, <0.140743, -0.906066, 1.006066>, 
      <0.000000, -1.052888, 1.264027>, <0.076817, -1.052888, 1.264027>, <0.140743, -1.065521, 1.202279>, <0.140743, -1.069764, 1.125579>, 
      <0.000000, -1.192227, 1.340528>, <0.076817, -1.192227, 1.340528>, <0.140743, -1.195758, 1.276700>, <0.140743, -1.200000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.777883, 0.973564>, <-0.076817, -0.759477, 1.034783>, <0.000000, -0.759477, 1.034783>, 
      <-0.140743, -0.906066, 1.006066>, <-0.140743, -0.883949, 1.079630>, <-0.076817, -0.876080, 1.142817>, <0.000000, -0.876080, 1.142817>, 
      <-0.140743, -1.069764, 1.125579>, <-0.140743, -1.065521, 1.202279>, <-0.076817, -1.052888, 1.264027>, <0.000000, -1.052888, 1.264027>, 
      <-0.140743, -1.200000, 1.200000>, <-0.140743, -1.195758, 1.276700>, <-0.076817, -1.192227, 1.340528>, <0.000000, -1.192227, 1.340528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.906066, 1.006066>, <-0.140743, -1.069764, 1.125579>, <-0.140743, -1.200000, 1.200000>, 
      <-0.140743, -0.822117, 0.826436>, <-0.140743, -0.928184, 0.932502>, <-0.140743, -1.074006, 1.048879>, <-0.140743, -1.204243, 1.123300>, 
      <-0.076817, -0.840523, 0.765217>, <-0.076817, -0.935585, 0.869593>, <-0.076817, -1.086527, 0.987148>, <-0.076817, -1.207773, 1.059472>, 
      <0.000000, -0.840523, 0.765217>, <0.000000, -0.935585, 0.869593>, <0.000000, -1.086527, 0.987148>, <0.000000, -1.207773, 1.059472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.600000, 0.600000>, <0.140743, -0.651009, 0.542563>, <0.076817, -0.693458, 0.494766>, <0.000000, -0.693458, 0.494766>, 
      <0.140743, -0.660000, 0.690000>, <0.140743, -0.711009, 0.632563>, <0.076817, -0.740982, 0.573955>, <0.000000, -0.740982, 0.573955>, 
      <0.140743, -0.723515, 0.823515>, <0.140743, -0.745632, 0.749950>, <0.076817, -0.778336, 0.696937>, <0.000000, -0.778336, 0.696937>, 
      <0.140743, -0.800000, 0.900000>, <0.140743, -0.822117, 0.826436>, <0.076817, -0.840523, 0.765217>, <0.000000, -0.840523, 0.765217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.506542, 0.705234>, <0.076817, -0.506542, 0.705234>, <0.140743, -0.548991, 0.657437>, <0.140743, -0.600000, 0.600000>, 
      <0.000000, -0.579132, 0.806539>, <0.076817, -0.579132, 0.806539>, <0.140743, -0.608991, 0.747437>, <0.140743, -0.660000, 0.690000>, 
      <0.000000, -0.668057, 0.950081>, <0.076817, -0.668057, 0.950081>, <0.140743, -0.701397, 0.897079>, <0.140743, -0.723515, 0.823515>, 
      <0.000000, -0.759477, 1.034783>, <0.076817, -0.759477, 1.034783>, <0.140743, -0.777883, 0.973564>, <0.140743, -0.800000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.548991, 0.657437>, <-0.076817, -0.506542, 0.705234>, <0.000000, -0.506542, 0.705234>, 
      <-0.140743, -0.660000, 0.690000>, <-0.140743, -0.608991, 0.747437>, <-0.076817, -0.579132, 0.806539>, <0.000000, -0.579132, 0.806539>, 
      <-0.140743, -0.723515, 0.823515>, <-0.140743, -0.701397, 0.897079>, <-0.076817, -0.668057, 0.950081>, <0.000000, -0.668057, 0.950081>, 
      <-0.140743, -0.800000, 0.900000>, <-0.140743, -0.777883, 0.973564>, <-0.076817, -0.759477, 1.034783>, <0.000000, -0.759477, 1.034783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.660000, 0.690000>, <-0.140743, -0.723515, 0.823515>, <-0.140743, -0.800000, 0.900000>, 
      <-0.140743, -0.651009, 0.542563>, <-0.140743, -0.711009, 0.632563>, <-0.140743, -0.745632, 0.749950>, <-0.140743, -0.822117, 0.826436>, 
      <-0.076817, -0.693458, 0.494766>, <-0.076817, -0.740982, 0.573955>, <-0.076817, -0.778336, 0.696937>, <-0.076817, -0.840523, 0.765217>, 
      <0.000000, -0.693458, 0.494766>, <0.000000, -0.740982, 0.573955>, <0.000000, -0.778336, 0.696937>, <0.000000, -0.840523, 0.765217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.400000, 0.300000>, <0.140743, -0.472022, 0.273284>, <0.076817, -0.531957, 0.251052>, <0.000000, -0.531957, 0.251052>, 
      <0.140743, -0.467571, 0.384464>, <0.140743, -0.539593, 0.357748>, <0.076817, -0.586693, 0.319587>, <0.000000, -0.586693, 0.319587>, 
      <0.140743, -0.540000, 0.510000>, <0.140743, -0.591009, 0.452563>, <0.076817, -0.648324, 0.419559>, <0.000000, -0.648324, 0.419559>, 
      <0.140743, -0.600000, 0.600000>, <0.140743, -0.651009, 0.542563>, <0.076817, -0.693458, 0.494766>, <0.000000, -0.693458, 0.494766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.268043, 0.348948>, <0.076817, -0.268043, 0.348948>, <0.140743, -0.327978, 0.326716>, <0.140743, -0.400000, 0.300000>, 
      <0.000000, -0.348475, 0.449320>, <0.076817, -0.348475, 0.449320>, <0.140743, -0.395549, 0.411180>, <0.140743, -0.467571, 0.384464>, 
      <0.000000, -0.431625, 0.600681>, <0.076817, -0.431625, 0.600681>, <0.140743, -0.488991, 0.567437>, <0.140743, -0.540000, 0.510000>, 
      <0.000000, -0.506542, 0.705234>, <0.076817, -0.506542, 0.705234>, <0.140743, -0.548991, 0.657437>, <0.140743, -0.600000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.327978, 0.326716>, <-0.076817, -0.268043, 0.348948>, <0.000000, -0.268043, 0.348948>, 
      <-0.140743, -0.467571, 0.384464>, <-0.140743, -0.395549, 0.411180>, <-0.076817, -0.348475, 0.449320>, <0.000000, -0.348475, 0.449320>, 
      <-0.140743, -0.540000, 0.510000>, <-0.140743, -0.488991, 0.567437>, <-0.076817, -0.431625, 0.600681>, <0.000000, -0.431625, 0.600681>, 
      <-0.140743, -0.600000, 0.600000>, <-0.140743, -0.548991, 0.657437>, <-0.076817, -0.506542, 0.705234>, <0.000000, -0.506542, 0.705234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.467571, 0.384464>, <-0.140743, -0.540000, 0.510000>, <-0.140743, -0.600000, 0.600000>, 
      <-0.140743, -0.472022, 0.273284>, <-0.140743, -0.539593, 0.357748>, <-0.140743, -0.591009, 0.452563>, <-0.140743, -0.651009, 0.542563>, 
      <-0.076817, -0.531957, 0.251052>, <-0.076817, -0.586693, 0.319587>, <-0.076817, -0.648324, 0.419559>, <-0.076817, -0.693458, 0.494766>, 
      <0.000000, -0.531957, 0.251052>, <0.000000, -0.586693, 0.319587>, <0.000000, -0.648324, 0.419559>, <0.000000, -0.693458, 0.494766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, -0.200000, 0.100000>, <0.140743, -0.252355, 0.043787>, <0.076817, -0.295923, -0.002992>, <0.000000, -0.295923, -0.002992>, 
      <0.140743, -0.267882, 0.150912>, <0.140743, -0.320237, 0.094699>, <0.076817, -0.379687, 0.058702>, <0.000000, -0.379687, 0.058702>, 
      <0.140743, -0.346993, 0.233741>, <0.140743, -0.419015, 0.207025>, <0.076817, -0.467036, 0.169764>, <0.000000, -0.467036, 0.169764>, 
      <0.140743, -0.400000, 0.300000>, <0.140743, -0.472022, 0.273284>, <0.076817, -0.531957, 0.251052>, <0.000000, -0.531957, 0.251052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.104077, 0.202992>, <0.076817, -0.104077, 0.202992>, <0.140743, -0.147645, 0.156213>, <0.140743, -0.200000, 0.100000>, 
      <0.000000, -0.156086, 0.243390>, <0.076817, -0.156086, 0.243390>, <0.140743, -0.215528, 0.207125>, <0.140743, -0.267882, 0.150912>, 
      <0.000000, -0.226862, 0.297557>, <0.076817, -0.226862, 0.297557>, <0.140743, -0.274971, 0.260457>, <0.140743, -0.346993, 0.233741>, 
      <0.000000, -0.268043, 0.348948>, <0.076817, -0.268043, 0.348948>, <0.140743, -0.327978, 0.326716>, <0.140743, -0.400000, 0.300000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.147645, 0.156213>, <-0.076817, -0.104077, 0.202992>, <0.000000, -0.104077, 0.202992>, 
      <-0.140743, -0.267882, 0.150912>, <-0.140743, -0.215528, 0.207125>, <-0.076817, -0.156086, 0.243390>, <0.000000, -0.156086, 0.243390>, 
      <-0.140743, -0.346993, 0.233741>, <-0.140743, -0.274971, 0.260457>, <-0.076817, -0.226862, 0.297557>, <0.000000, -0.226862, 0.297557>, 
      <-0.140743, -0.400000, 0.300000>, <-0.140743, -0.327978, 0.326716>, <-0.076817, -0.268043, 0.348948>, <0.000000, -0.268043, 0.348948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.267882, 0.150912>, <-0.140743, -0.346993, 0.233741>, <-0.140743, -0.400000, 0.300000>, 
      <-0.140743, -0.252355, 0.043787>, <-0.140743, -0.320237, 0.094699>, <-0.140743, -0.419015, 0.207025>, <-0.140743, -0.472022, 0.273284>, 
      <-0.076817, -0.295923, -0.002992>, <-0.076817, -0.379687, 0.058702>, <-0.076817, -0.467036, 0.169764>, <-0.076817, -0.531957, 0.251052>, 
      <0.000000, -0.295923, -0.002992>, <0.000000, -0.379687, 0.058702>, <0.000000, -0.467036, 0.169764>, <0.000000, -0.531957, 0.251052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 0.000000, 0.000000>, <0.140743, 0.000000, -0.076817>, <0.076817, 0.000000, -0.140743>, <0.000000, 0.000000, -0.140743>, 
      <0.140743, -0.067072, 0.001156>, <0.140743, -0.067072, -0.075661>, <0.076817, -0.097897, -0.138456>, <0.000000, -0.097897, -0.138456>, 
      <0.140743, -0.146334, 0.059751>, <0.140743, -0.198689, 0.003538>, <0.076817, -0.217076, -0.061064>, <0.000000, -0.217076, -0.061064>, 
      <0.140743, -0.200000, 0.100000>, <0.140743, -0.252355, 0.043787>, <0.076817, -0.295923, -0.002992>, <0.000000, -0.295923, -0.002992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.140743, 0.000000, 0.000000>, <0.140743, 1.679750, -0.028961>, <0.140743, 3.920241, -0.028470>, <0.140743, 5.600000, 0.000000>, 
      <0.140743, 0.000000, -0.076817>, <0.140743, 1.679750, -0.105779>, <0.140743, 3.920241, -0.105288>, <0.140743, 5.600000, -0.076817>, 
      <0.076817, 0.000000, -0.140743>, <0.076817, 1.679542, -0.179983>, <0.076817, 3.920364, -0.175736>, <0.076817, 5.600000, -0.140743>, 
      <0.000000, 0.000000, -0.140743>, <0.000000, 1.679542, -0.179983>, <0.000000, 3.920364, -0.175736>, <0.000000, 5.600000, -0.140743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.140743>, <0.076817, 0.000000, 0.140743>, <0.140743, 0.000000, 0.076817>, <0.140743, 0.000000, 0.000000>, 
      <0.000000, -0.036380, 0.141140>, <0.076817, -0.036380, 0.141140>, <0.140743, -0.067072, 0.077974>, <0.140743, -0.067072, 0.001156>, 
      <0.000000, -0.075345, 0.180674>, <0.076817, -0.075345, 0.180674>, <0.140743, -0.093980, 0.115964>, <0.140743, -0.146334, 0.059751>, 
      <0.000000, -0.104077, 0.202992>, <0.076817, -0.104077, 0.202992>, <0.140743, -0.147645, 0.156213>, <0.140743, -0.200000, 0.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.140743>, <0.000000, 1.679900, 0.122410>, <0.000000, 3.920141, 0.118975>, <0.000000, 5.600000, 0.140743>, 
      <0.076817, 0.000000, 0.140743>, <0.076817, 1.679900, 0.122410>, <0.076817, 3.920141, 0.118975>, <0.076817, 5.600000, 0.140743>, 
      <0.140743, 0.000000, 0.076817>, <0.140743, 1.679750, 0.047856>, <0.140743, 3.920241, 0.048347>, <0.140743, 5.600000, 0.076817>, 
      <0.140743, 0.000000, 0.000000>, <0.140743, 1.679750, -0.028961>, <0.140743, 3.920241, -0.028470>, <0.140743, 5.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 0.000000, 0.076817>, <-0.076817, 0.000000, 0.140743>, <0.000000, 0.000000, 0.140743>, 
      <-0.140743, -0.067072, 0.001156>, <-0.140743, -0.067072, 0.077974>, <-0.076817, -0.036380, 0.141140>, <0.000000, -0.036380, 0.141140>, 
      <-0.140743, -0.146334, 0.059751>, <-0.140743, -0.093980, 0.115964>, <-0.076817, -0.075345, 0.180674>, <0.000000, -0.075345, 0.180674>, 
      <-0.140743, -0.200000, 0.100000>, <-0.140743, -0.147645, 0.156213>, <-0.076817, -0.104077, 0.202992>, <0.000000, -0.104077, 0.202992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 1.679750, -0.028961>, <-0.140743, 3.920241, -0.028470>, <-0.140743, 5.600000, 0.000000>, 
      <-0.140743, 0.000000, 0.076817>, <-0.140743, 1.679750, 0.047856>, <-0.140743, 3.920241, 0.048347>, <-0.140743, 5.600000, 0.076817>, 
      <-0.076817, 0.000000, 0.140743>, <-0.076817, 1.679900, 0.122410>, <-0.076817, 3.920141, 0.118975>, <-0.076817, 5.600000, 0.140743>, 
      <0.000000, 0.000000, 0.140743>, <0.000000, 1.679900, 0.122410>, <0.000000, 3.920141, 0.118975>, <0.000000, 5.600000, 0.140743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, -0.067072, 0.001156>, <-0.140743, -0.146334, 0.059751>, <-0.140743, -0.200000, 0.100000>, 
      <-0.140743, 0.000000, -0.076817>, <-0.140743, -0.067072, -0.075661>, <-0.140743, -0.198689, 0.003538>, <-0.140743, -0.252355, 0.043787>, 
      <-0.076817, 0.000000, -0.140743>, <-0.076817, -0.097897, -0.138456>, <-0.076817, -0.217076, -0.061064>, <-0.076817, -0.295923, -0.002992>, 
      <0.000000, 0.000000, -0.140743>, <0.000000, -0.097897, -0.138456>, <0.000000, -0.217076, -0.061064>, <0.000000, -0.295923, -0.002992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140743, 0.000000, 0.000000>, <-0.140743, 0.000000, -0.076817>, <-0.076817, 0.000000, -0.140743>, <0.000000, 0.000000, -0.140743>, 
      <-0.140743, 1.679750, -0.028961>, <-0.140743, 1.679750, -0.105779>, <-0.076817, 1.679542, -0.179983>, <0.000000, 1.679542, -0.179983>, 
      <-0.140743, 3.920241, -0.028470>, <-0.140743, 3.920241, -0.105288>, <-0.076817, 3.920364, -0.175736>, <0.000000, 3.920364, -0.175736>, 
      <-0.140743, 5.600000, 0.000000>, <-0.140743, 5.600000, -0.076817>, <-0.076817, 5.600000, -0.140743>, <0.000000, 5.600000, -0.140743>
    }
  }
  rotate <90.0, 0.0, 72.0>
  translate  <-7.273379, 4.296583, 1.482859>
}
union { // Group006
  object { sPatchObj1 }
  object { sPatchObj2 }
  object { sPatchObj3 }
  object { sPatchObj4 }
  object { sPatchObj5 }
  material {
    Rusty_Iron
  }
  rotate <95.599236, -252.056931, 71.695297>
  translate  <-10.496016, 1.95564, -4.408196>
}


box { // Cube001
  <-1, -1, -1>, <1, 1, 1>
  material {
    Material1
  }
  scale <67.241287, 6.234315, 25.200232>
  translate  <1.231806, 125.188531, 7.169874>
}


plane { // Plane001
  z,0
  material {
    Material2
  }
  hollow
  scale <10.708235, 12.026636, 1.0>
  translate  0.05*z
}


prism { // TransSweep002
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.4, 0.4, 0.2>
  rotate -1.151663*z
  translate  <5.153754, -5.633173, 0.0>
}


// Include contains 'TransSweep001'
#include "ruins.in1"

object {
  TransSweep001_Raw
  material {
    Material1
  }
  scale 2.0
  rotate -28.326731*z
  translate  <2.996369, -5.992737, 0.0>
}


superellipsoid { // SuperQ001
  <0.1, 0.1>
  material {
    Material1
  }
  scale <2.0, 2.0, 1.0>
  rotate 16.947559*z
  translate  1.0*z
}


#declare RotSweep001 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  translate  <-13.0, 0.0, 0.5>
}
#declare RotSweep002 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  rotate <180.0, 0.0, 180.0>
  translate  <-13.0, 0.0, 13.6>
}
union { // Group001
  object { RotSweep001 }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      Column
    }
    scale <2.0, 2.0, 15.0>
    translate  -13.0*x
  }
  object { RotSweep002 }
}




difference { // CSG001
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      Ceiling
    }
    scale <20.0, 20.0, 1.0>
    translate  15.0*z
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <2.05, 2.05, 1.5>
    translate  <0.0, -2.0, 15.0>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <2.05, 2.05, 1.5>
    translate  <-2.0, 2.0, 15.0>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <2.05, 2.05, 1.5>
    translate  <2.0, 2.0, 15.0>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <2.05, 2.05, 1.5>
    translate  <-4.0, -2.0, 15.0>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <2.05, 2.05, 1.5>
    translate  <8.0, -2.0, 15.0>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <2.05, 2.05, 1.5>
    translate  <10.0, 2.0, 15.0>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <2.05, 2.05, 1.5>
    translate  <8.0, 6.0, 15.0>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <2.05, 2.05, 1.5>
    translate  <6.0, 2.0, 15.0>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <2.05, 2.05, 1.5>
    translate  <0.0, 6.0, 15.0>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <2.05, 2.05, 1.5>
    translate  <4.0, -2.0, 15.0>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <2.05, 2.05, 1.5>
    translate  <6.0, -6.0, 15.0>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <2.05, 2.05, 1.5>
    translate  <4.0, 6.0, 15.0>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <2.05, 2.05, 1.5>
    translate  <2.0, -6.0, 15.0>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <0.241737, 0.22573, 1.5>
    rotate <0.0, 0.0, -37.821075>
    translate  <0.108144, -3.936666, 15.0>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <0.684872, 0.960962, 1.5>
    rotate <0.0, 0.0, -36.309067>
    translate  <-3.515307, -0.264969, 15.0>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <0.346191, 0.271766, 1.5>
    rotate <0.0, 0.0, -37.821075>
    translate  <9.970781, 3.780367, 15.0>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <0.13758, 0.495353, 1.5>
    rotate <0.0, 0.0, -37.821075>
    translate  <7.99113, -3.909119, 15.0>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <0.684872, 0.960962, 1.5>
    rotate <0.0, 0.0, -36.309067>
    translate  <-1.200927, 4.07422, 15.0>
  }
  material {
    Material3_1
  }
}


#declare RotSweep003 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  translate  <-13.0, 0.0, 0.5>
}
#declare RotSweep004 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  rotate <180.0, 0.0, 180.0>
  translate  <-13.0, 0.0, 13.6>
}
union { // Group002
  object { RotSweep003 }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      Column
    }
    scale <2.0, 2.0, 15.0>
    translate  -13.0*x
  }
  object { RotSweep004 }
  translate  10.0*y
}


#declare RotSweep005 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  translate  <-13.0, 0.0, 0.5>
}
#declare RotSweep006 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  rotate <180.0, 0.0, 180.0>
  translate  <-13.0, 0.0, 13.6>
}
union { // Group003
  object { RotSweep005 }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      Column
    }
    scale <2.0, 2.0, 15.0>
    translate  -13.0*x
  }
  object { RotSweep006 }
  translate  20.0*y
}


#declare RotSweep007 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  translate  <-13.0, 0.0, 0.5>
}
#declare RotSweep008 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  rotate <180.0, 0.0, 180.0>
  translate  <-13.0, 0.0, 13.6>
}
union { // Group004
  object { RotSweep007 }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      Column
    }
    scale <2.0, 2.0, 15.0>
    translate  -13.0*x
  }
  object { RotSweep008 }
  translate  -10.0*y
}


#declare RotSweep009 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  translate  <-13.0, 0.0, 0.5>
}
#declare RotSweep010 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  rotate <180.0, 0.0, 180.0>
  translate  <-13.0, 0.0, 13.6>
}
union { // Group005
  object { RotSweep009 }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      Column
    }
    scale <2.0, 2.0, 15.0>
    translate  -13.0*x
  }
  object { RotSweep010 }
  translate  -20.0*y
}


superellipsoid { // SuperQ002
  <0.1, 0.1>
  material {
    Material1
  }
  scale <2.0, 2.0, 1.0>
  rotate 44.518181*y
  translate  <3.671576, 0.0, 2.03537>
}


prism { // TransSweep003
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.5, 0.5, 0.25>
  rotate -79.796745*z
  translate  <-0.359564, -3.116223, 0.0>
}


prism { // TransSweep004
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.3, 0.3, 0.15>
  rotate -101.648392*z
  translate  <4.914045, -7.191285, 0.0>
}


prism { // TransSweep005
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.5, 0.5, 0.25>
  rotate 22.709185*z
  translate  <4.79419, -2.996369, 0.0>
}


prism { // TransSweep006
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.2, 0.2, 0.1>
  rotate -1.151663*z
  translate  <4.434626, -5.633173, 0.0>
}


prism { // TransSweep007
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.2, 0.2, 0.1>
  rotate -1.151663*z
  translate  <-0.395295, -1.438257, 2.000946>
}


prism { // TransSweep008
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.4, 0.4, 0.2>
  rotate -1.151663*z
  translate  <0.323833, 0.958838, 2.000946>
}


// Include contains 'TransSweep009'
#include "ruins.in2"

object {
  TransSweep009_Raw
  material {
    Material1
  }
  scale 2.0
  rotate -161.617935*z
  translate  <7.910413, -4.914045, 0.0>
}


prism { // TransSweep010
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.1, 0.1, 0.05>
  rotate -101.648392*z
  translate  <6.117728, -5.287785, 0.0>
}


prism { // TransSweep011
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.25, 0.25, 0.125>
  rotate 58.800922*z
  translate  <6.425647, -7.527196, 0.0>
}


prism { // TransSweep012
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.35, 0.35, 0.175>
  rotate -65.843781*z
  translate  <1.582921, -7.975079, 0.0>
}


prism { // TransSweep013
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.25, 0.3, 0.15>
  rotate 167.472397*z
  translate  <2.142773, -6.771395, 2.0>
}


prism { // TransSweep014
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.1, 0.12, 0.06>
  rotate 167.472397*z
  translate  <2.142773, -4.224065, 2.0>
}


prism { // TransSweep015
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.3, 0.3, 0.15>
  rotate 161.292999*z
  translate  <-0.768461, -6.267528, 0.0>
}


prism { // TransSweep016
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.38, 0.38, 0.19>
  rotate -94.059441*z
  translate  <0.239274, -4.615962, 0.0>
}


prism { // TransSweep017
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.639066, -0.532909>,
  <-0.360934, -0.644374>,
  <0.002123, -0.490446>,
  <0.320594, -0.100849>,
  <0.193206, 0.373673>,
  <-0.132696, 0.262208>,
  <-0.511677, 0.278132>,
  <-0.579618, 0.026327>,
  <-0.736518, -0.22>,
  <-0.639066, -0.532909>
  rotate -x*90
  material {
    Material1
  }
  scale <0.1, 0.1, 0.05>
  rotate -112.187744*z
  translate  <-0.54452, -5.259793, 0.0>
}


#declare RotSweep011 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  translate  <-13.0, 0.0, 0.5>
}
#declare RotSweep012 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  rotate <180.0, 0.0, 180.0>
  translate  <-13.0, 0.0, 13.6>
}
union { // Group007
  object { RotSweep011 }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      Column
    }
    scale <2.0, 2.0, 15.0>
    translate  -13.0*x
  }
  object { RotSweep012 }
  translate  30.0*y
}


#declare RotSweep013 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  translate  <-13.0, 0.0, 0.5>
}
#declare RotSweep014 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  rotate <180.0, 0.0, 180.0>
  translate  <-13.0, 0.0, 13.6>
}
union { // Group008
  object { RotSweep013 }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      Column
    }
    scale <2.0, 2.0, 15.0>
    translate  -13.0*x
  }
  object { RotSweep014 }
  translate  40.0*y
}


#declare RotSweep015 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  translate  <-13.0, 0.0, 0.5>
}
#declare RotSweep016 = lathe {
  linear_spline
  3  // control points
  <2.719745, -0.883227>,
  <2.414013, 0.436306>,
  <1.0, 1.021231>
  rotate <90,0,90>
  material {
    T_Stone32
  }
  scale <1.0, 1.0, 0.5>
  rotate <180.0, 0.0, 180.0>
  translate  <-13.0, 0.0, 13.6>
}
union { // Group009
  object { RotSweep015 }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      Column
    }
    scale <2.0, 2.0, 15.0>
    translate  -13.0*x
  }
  object { RotSweep016 }
  translate  50.0*y
}


union { // sPatchObj6
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.181642, -0.120829, -0.077768>, <-0.501095, 0.008340, 0.073919>, <-0.555381, 0.058201, 0.070989>, 
      <-0.130926, -0.097201, -0.029692>, <-0.133066, -0.098198, -0.031720>, <-0.510563, 0.016196, 0.118818>, <-0.564849, 0.066057, 0.115887>, 
      <-0.130926, -0.097201, -0.029692>, <-0.133066, -0.098198, -0.031720>, <-0.362102, 0.109298, 0.194351>, <-0.396337, 0.149574, 0.241234>, 
      <-0.130926, -0.097201, -0.029692>, <-0.082349, -0.074570, 0.016356>, <-0.320226, 0.111530, 0.214567>, <-0.354461, 0.151806, 0.261450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.082349, -0.074570, 0.016356>, <-0.320226, 0.111530, 0.214567>, <-0.354461, 0.151806, 0.261450>, 
      <-0.032439, -0.083797, -0.058255>, <0.016138, -0.061166, -0.012207>, <-0.264805, 0.114483, 0.241321>, <-0.299040, 0.154759, 0.288205>, 
      <0.342377, 0.091514, 0.176242>, <0.301671, 0.103458, 0.226890>, <0.021767, 0.088666, 0.347293>, <-0.044249, 0.089469, 0.349751>, 
      <0.412284, 0.142474, 0.232911>, <0.371578, 0.154417, 0.283559>, <0.083332, 0.087916, 0.345002>, <0.017316, 0.088720, 0.347459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.032439, -0.083797, -0.058255>, <0.342377, 0.091514, 0.176242>, <0.412284, 0.142474, 0.232911>, 
      <-0.130926, -0.097201, -0.029692>, <-0.100076, -0.093002, -0.038639>, <0.301671, 0.103458, 0.226890>, <0.371578, 0.154417, 0.283559>, 
      <-0.130926, -0.097201, -0.029692>, <-0.100076, -0.093002, -0.038639>, <0.070575, 0.040499, 0.293689>, <0.083332, 0.087916, 0.345002>, 
      <-0.130926, -0.097201, -0.029692>, <-0.198563, -0.106406, -0.010076>, <0.004559, 0.041302, 0.296146>, <0.017316, 0.088720, 0.347459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.082349, -0.074570, 0.016356>, <-0.320226, 0.111530, 0.214567>, <-0.354461, 0.151806, 0.261450>, 
      <-0.130926, -0.097201, -0.029692>, <-0.149986, -0.083775, 0.035972>, <-0.264805, 0.114483, 0.241321>, <-0.299040, 0.154759, 0.288205>, 
      <-0.130926, -0.097201, -0.029692>, <-0.149986, -0.083775, 0.035972>, <-0.057006, 0.042051, 0.298437>, <-0.044249, 0.089469, 0.349751>, 
      <-0.130926, -0.097201, -0.029692>, <-0.198563, -0.106406, -0.010076>, <0.004559, 0.041302, 0.296146>, <0.017316, 0.088720, 0.347459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.181642, -0.120829, -0.077768>, <-0.501095, 0.008340, 0.073919>, <-0.555381, 0.058201, 0.070989>, 
      <-0.198563, -0.106406, -0.010076>, <-0.249279, -0.130034, -0.058152>, <-0.510563, 0.016196, 0.118818>, <-0.564849, 0.066057, 0.115887>, 
      <0.004559, 0.041302, 0.296146>, <-0.057006, 0.042051, 0.298437>, <-0.340915, 0.152528, 0.267989>, <-0.396337, 0.149574, 0.241234>, 
      <0.017316, 0.088720, 0.347459>, <-0.044249, 0.089469, 0.349751>, <-0.299040, 0.154759, 0.288205>, <-0.354461, 0.151806, 0.261450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.032439, -0.083797, -0.058255>, <0.342377, 0.091514, 0.176242>, <0.412284, 0.142474, 0.232911>, 
      <-0.142798, -0.067962, -0.100668>, <-0.044310, -0.054558, -0.129231>, <0.371508, 0.082967, 0.139996>, <0.441415, 0.133927, 0.196665>, 
      <0.202881, 0.064320, -0.205156>, <0.230724, 0.064208, -0.175574>, <0.303233, 0.005970, 0.000533>, <0.315504, 0.009328, 0.039114>, 
      <0.262245, 0.101418, -0.238817>, <0.290089, 0.101306, -0.209235>, <0.288951, 0.002062, -0.044370>, <0.301222, 0.005420, -0.005789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.142798, -0.067962, -0.100668>, <0.202881, 0.064320, -0.205156>, <0.262245, 0.101418, -0.238817>, 
      <-0.130926, -0.097201, -0.029692>, <-0.131968, -0.094634, -0.035923>, <0.230724, 0.064208, -0.175574>, <0.290089, 0.101306, -0.209235>, 
      <-0.130926, -0.097201, -0.029692>, <-0.131968, -0.094634, -0.035923>, <0.224372, -0.027076, -0.045433>, <0.288951, 0.002062, -0.044370>, 
      <-0.130926, -0.097201, -0.029692>, <-0.120096, -0.123873, 0.035053>, <0.236643, -0.023718, -0.006852>, <0.301222, 0.005420, -0.005789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.032439, -0.083797, -0.058255>, <0.342377, 0.091514, 0.176242>, <0.412284, 0.142474, 0.232911>, 
      <-0.130926, -0.097201, -0.029692>, <-0.021609, -0.110470, 0.006490>, <0.371508, 0.082967, 0.139996>, <0.441415, 0.133927, 0.196665>, 
      <-0.130926, -0.097201, -0.029692>, <-0.021609, -0.110470, 0.006490>, <0.250924, -0.019810, 0.038051>, <0.315504, 0.009328, 0.039114>, 
      <-0.130926, -0.097201, -0.029692>, <-0.120096, -0.123873, 0.035053>, <0.236643, -0.023718, -0.006852>, <0.301222, 0.005420, -0.005789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.198563, -0.106406, -0.010076>, <0.004559, 0.041302, 0.296146>, <0.017316, 0.088720, 0.347459>, 
      <-0.120096, -0.123873, 0.035053>, <-0.187733, -0.133079, 0.054669>, <0.070575, 0.040499, 0.293689>, <0.083332, 0.087916, 0.345002>, 
      <0.236643, -0.023718, -0.006852>, <0.250924, -0.019810, 0.038051>, <0.400709, 0.145870, 0.247313>, <0.371578, 0.154417, 0.283559>, 
      <0.301222, 0.005420, -0.005789>, <0.315504, 0.009328, 0.039114>, <0.441415, 0.133927, 0.196665>, <0.412284, 0.142474, 0.232911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.181642, -0.120829, -0.077768>, <-0.501095, 0.008340, 0.073919>, <-0.555381, 0.058201, 0.070989>, 
      <-0.130926, -0.097201, -0.029692>, <-0.204428, -0.111747, -0.044803>, <-0.488951, -0.001737, 0.016331>, <-0.543237, 0.048124, 0.013400>, 
      <-0.130926, -0.097201, -0.029692>, <-0.204428, -0.111747, -0.044803>, <-0.289227, 0.055516, -0.094583>, <-0.305630, 0.081728, -0.121642>, 
      <-0.130926, -0.097201, -0.029692>, <-0.153711, -0.088119, 0.003273>, <-0.248178, 0.051014, -0.137713>, <-0.264581, 0.077227, -0.164773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.153711, -0.088119, 0.003273>, <-0.248178, 0.051014, -0.137713>, <-0.264581, 0.077227, -0.164773>, 
      <-0.082349, -0.074570, 0.016356>, <-0.105135, -0.065488, 0.049321>, <-0.289227, 0.055516, -0.094583>, <-0.305630, 0.081728, -0.121642>, 
      <-0.320226, 0.111530, 0.214567>, <-0.362102, 0.109298, 0.194351>, <-0.552705, 0.055980, 0.058298>, <-0.543237, 0.048124, 0.013400>, 
      <-0.354461, 0.151806, 0.261450>, <-0.396337, 0.149574, 0.241234>, <-0.564849, 0.066057, 0.115887>, <-0.555381, 0.058201, 0.070989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.142798, -0.067962, -0.100668>, <0.202881, 0.064320, -0.205156>, <0.262245, 0.101418, -0.238817>, 
      <-0.153711, -0.088119, 0.003273>, <-0.165583, -0.058880, -0.067702>, <0.158589, 0.064499, -0.252212>, <0.217953, 0.101597, -0.285873>, 
      <-0.248178, 0.051014, -0.137713>, <-0.213381, 0.047199, -0.174276>, <-0.074521, 0.007627, -0.421651>, <-0.024448, 0.009926, -0.428689>, 
      <-0.264581, 0.077227, -0.164773>, <-0.229784, 0.073411, -0.201335>, <-0.138449, 0.004692, -0.412666>, <-0.088375, 0.006991, -0.419704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.095069, -0.111494, -0.081569>, <-0.102292, -0.027401, -0.366744>, <-0.088375, 0.006991, -0.419704>, 
      <-0.130926, -0.097201, -0.029692>, <-0.117854, -0.102411, -0.048604>, <-0.152365, -0.029700, -0.359706>, <-0.138449, 0.004692, -0.412666>, 
      <-0.130926, -0.097201, -0.029692>, <-0.117854, -0.102411, -0.048604>, <-0.213381, 0.047199, -0.174276>, <-0.229784, 0.073411, -0.201335>, 
      <-0.130926, -0.097201, -0.029692>, <-0.153711, -0.088119, 0.003273>, <-0.248178, 0.051014, -0.137713>, <-0.264581, 0.077227, -0.164773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.095069, -0.111494, -0.081569>, <-0.102292, -0.027401, -0.366744>, <-0.088375, 0.006991, -0.419704>, 
      <-0.181642, -0.120829, -0.077768>, <-0.145785, -0.135122, -0.129645>, <-0.152365, -0.029700, -0.359706>, <-0.138449, 0.004692, -0.412666>, 
      <-0.501095, 0.008340, 0.073919>, <-0.488951, -0.001737, 0.016331>, <-0.270832, 0.077912, -0.158205>, <-0.229784, 0.073411, -0.201335>, 
      <-0.555381, 0.058201, 0.070989>, <-0.543237, 0.048124, 0.013400>, <-0.305630, 0.081728, -0.121642>, <-0.264581, 0.077227, -0.164773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.142798, -0.067962, -0.100668>, <0.202881, 0.064320, -0.205156>, <0.262245, 0.101418, -0.238817>, 
      <-0.130926, -0.097201, -0.029692>, <-0.106941, -0.082255, -0.152545>, <0.158589, 0.064499, -0.252212>, <0.217953, 0.101597, -0.285873>, 
      <-0.130926, -0.097201, -0.029692>, <-0.106941, -0.082255, -0.152545>, <-0.038364, -0.024465, -0.375729>, <-0.024448, 0.009926, -0.428689>, 
      <-0.130926, -0.097201, -0.029692>, <-0.095069, -0.111494, -0.081569>, <-0.102292, -0.027401, -0.366744>, <-0.088375, 0.006991, -0.419704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.120096, -0.123873, 0.035053>, <0.236643, -0.023718, -0.006852>, <0.301222, 0.005420, -0.005789>, 
      <-0.095069, -0.111494, -0.081569>, <-0.084239, -0.138166, -0.016824>, <0.224372, -0.027076, -0.045433>, <0.288951, 0.002062, -0.044370>, 
      <-0.102292, -0.027401, -0.366744>, <-0.038364, -0.024465, -0.375729>, <0.245797, 0.101484, -0.256292>, <0.290089, 0.101306, -0.209235>, 
      <-0.088375, 0.006991, -0.419704>, <-0.024448, 0.009926, -0.428689>, <0.217953, 0.101597, -0.285873>, <0.262245, 0.101418, -0.238817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.138668, 0.808151, -0.039635>, <0.091090, 0.757787, 0.050347>, <0.139101, 0.740972, 0.077758>, 
      <-0.211878, 0.832868, -0.039083>, <-0.157131, 0.814384, -0.039496>, <0.081876, 0.758480, 0.062797>, <0.129888, 0.741665, 0.090208>, 
      <-0.170670, 0.860889, 0.067242>, <-0.128429, 0.866318, 0.086046>, <0.061359, 0.771076, 0.160018>, <0.105467, 0.756185, 0.159685>, 
      <-0.176779, 0.847620, 0.080140>, <-0.134538, 0.853049, 0.098943>, <0.046671, 0.776036, 0.160129>, <0.090778, 0.761144, 0.159796>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.138668, 0.808151, -0.039635>, <0.091090, 0.757787, 0.050347>, <0.139101, 0.740972, 0.077758>, 
      <-0.193416, 0.826635, -0.039222>, <-0.087636, 0.814710, -0.016918>, <0.081876, 0.758480, 0.062797>, <0.129888, 0.741665, 0.090208>, 
      <-0.193416, 0.826635, -0.039222>, <-0.087636, 0.814710, -0.016918>, <0.095360, 0.779703, 0.109604>, <0.105467, 0.756185, 0.159685>, 
      <-0.193416, 0.826635, -0.039222>, <-0.142384, 0.833194, -0.016505>, <0.080671, 0.784662, 0.109715>, <0.090778, 0.761144, 0.159796>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.211878, 0.832868, -0.039083>, <-0.170670, 0.860889, 0.067242>, <-0.176779, 0.847620, 0.080140>, 
      <-0.193416, 0.826635, -0.039222>, <-0.160846, 0.839428, -0.016366>, <-0.128429, 0.866318, 0.086046>, <-0.134538, 0.853049, 0.098943>, 
      <-0.193416, 0.826635, -0.039222>, <-0.160846, 0.839428, -0.016366>, <0.036564, 0.799554, 0.110047>, <0.046671, 0.776036, 0.160129>, 
      <-0.193416, 0.826635, -0.039222>, <-0.142384, 0.833194, -0.016505>, <0.080671, 0.784662, 0.109715>, <0.090778, 0.761144, 0.159796>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.211878, 0.832868, -0.039083>, <-0.170670, 0.860889, 0.067242>, <-0.176779, 0.847620, 0.080140>, 
      <-0.193416, 0.826635, -0.039222>, <-0.241165, 0.829104, -0.052120>, <-0.207903, 0.856103, 0.050668>, <-0.214012, 0.842834, 0.063566>, 
      <-0.193416, 0.826635, -0.039222>, <-0.241165, 0.829104, -0.052120>, <-0.328775, 0.734429, 0.000363>, <-0.355822, 0.716814, 0.000451>, 
      <-0.193416, 0.826635, -0.039222>, <-0.222703, 0.822871, -0.052259>, <-0.327586, 0.721509, -0.038567>, <-0.354633, 0.703894, -0.038479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.142384, 0.833194, -0.016505>, <0.080671, 0.784662, 0.109715>, <0.090778, 0.761144, 0.159796>, 
      <-0.222703, 0.822871, -0.052259>, <-0.171670, 0.829430, -0.029542>, <0.036564, 0.799554, 0.110047>, <0.046671, 0.776036, 0.160129>, 
      <-0.327586, 0.721509, -0.038567>, <-0.328775, 0.734429, 0.000363>, <-0.171771, 0.848264, 0.082369>, <-0.134538, 0.853049, 0.098943>, 
      <-0.354633, 0.703894, -0.038479>, <-0.355822, 0.716814, 0.000451>, <-0.214012, 0.842834, 0.063566>, <-0.176779, 0.847620, 0.080140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.222703, 0.822871, -0.052259>, <-0.327586, 0.721509, -0.038567>, <-0.354633, 0.703894, -0.038479>, 
      <-0.143147, 0.835525, -0.042525>, <-0.172433, 0.831761, -0.055562>, <-0.326324, 0.707796, -0.079887>, <-0.353371, 0.690181, -0.079799>, 
      <0.027634, 0.803928, -0.205853>, <-0.006634, 0.799659, -0.202735>, <-0.174961, 0.742018, -0.229510>, <-0.205269, 0.736169, -0.213716>, 
      <0.046692, 0.781341, -0.247609>, <0.012424, 0.777073, -0.244491>, <-0.136890, 0.749365, -0.249349>, <-0.167198, 0.743516, -0.233555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.222703, 0.822871, -0.052259>, <-0.327586, 0.721509, -0.038567>, <-0.354633, 0.703894, -0.038479>, 
      <-0.193416, 0.826635, -0.039222>, <-0.256042, 0.816975, -0.050068>, <-0.326324, 0.707796, -0.079887>, <-0.353371, 0.690181, -0.079799>, 
      <-0.193416, 0.826635, -0.039222>, <-0.256042, 0.816975, -0.050068>, <-0.196526, 0.751514, -0.184748>, <-0.205269, 0.736169, -0.213716>, 
      <-0.193416, 0.826635, -0.039222>, <-0.226755, 0.820739, -0.037031>, <-0.158455, 0.758861, -0.204587>, <-0.167198, 0.743516, -0.233555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.211878, 0.832868, -0.039083>, <-0.170670, 0.860889, 0.067242>, <-0.176779, 0.847620, 0.080140>, 
      <-0.226755, 0.820739, -0.037031>, <-0.245218, 0.826973, -0.036892>, <-0.207903, 0.856103, 0.050668>, <-0.214012, 0.842834, 0.063566>, 
      <-0.158455, 0.758861, -0.204587>, <-0.196526, 0.751514, -0.184748>, <-0.354560, 0.703101, -0.040869>, <-0.355822, 0.716814, 0.000451>, 
      <-0.167198, 0.743516, -0.233555>, <-0.205269, 0.736169, -0.213716>, <-0.353371, 0.690181, -0.079799>, <-0.354633, 0.703894, -0.038479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.143147, 0.835525, -0.042525>, <0.027634, 0.803928, -0.205853>, <0.046692, 0.781341, -0.247609>, 
      <-0.193416, 0.826635, -0.039222>, <-0.176486, 0.829629, -0.040334>, <-0.006634, 0.799659, -0.202735>, <0.012424, 0.777073, -0.244491>, 
      <-0.193416, 0.826635, -0.039222>, <-0.176486, 0.829629, -0.040334>, <-0.128147, 0.764710, -0.220380>, <-0.136890, 0.749365, -0.249349>, 
      <-0.193416, 0.826635, -0.039222>, <-0.226755, 0.820739, -0.037031>, <-0.158455, 0.758861, -0.204587>, <-0.167198, 0.743516, -0.233555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.143147, 0.835525, -0.042525>, <0.027634, 0.803928, -0.205853>, <0.046692, 0.781341, -0.247609>, 
      <-0.143689, 0.811638, 0.020326>, <-0.093419, 0.820527, 0.017023>, <0.046122, 0.806230, -0.207535>, <0.065180, 0.783644, -0.249291>, 
      <0.213898, 0.764081, -0.108731>, <0.216139, 0.768177, -0.140750>, <0.174796, 0.782937, -0.256965>, <0.146804, 0.786979, -0.272684>, 
      <0.290819, 0.746089, -0.110518>, <0.293059, 0.750185, -0.142537>, <0.190979, 0.780600, -0.247877>, <0.162987, 0.784642, -0.263596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.138668, 0.808151, -0.039635>, <0.091090, 0.757787, 0.050347>, <0.139101, 0.740972, 0.077758>, 
      <-0.193416, 0.826635, -0.039222>, <-0.088941, 0.793154, 0.019913>, <0.113985, 0.756064, 0.019410>, <0.161996, 0.739249, 0.046821>, 
      <-0.193416, 0.826635, -0.039222>, <-0.088941, 0.793154, 0.019913>, <0.211230, 0.759203, -0.070608>, <0.288151, 0.741212, -0.072395>, 
      <-0.193416, 0.826635, -0.039222>, <-0.143689, 0.811638, 0.020326>, <0.213898, 0.764081, -0.108731>, <0.290819, 0.746089, -0.110518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.142384, 0.833194, -0.016505>, <0.080671, 0.784662, 0.109715>, <0.090778, 0.761144, 0.159796>, 
      <-0.143689, 0.811638, 0.020326>, <-0.092656, 0.818197, 0.043043>, <0.095360, 0.779703, 0.109604>, <0.105467, 0.756185, 0.159685>, 
      <0.213898, 0.764081, -0.108731>, <0.211230, 0.759203, -0.070608>, <0.152782, 0.739942, 0.059270>, <0.129888, 0.741665, 0.090208>, 
      <0.290819, 0.746089, -0.110518>, <0.288151, 0.741212, -0.072395>, <0.161996, 0.739249, 0.046821>, <0.139101, 0.740972, 0.077758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.143147, 0.835525, -0.042525>, <0.027634, 0.803928, -0.205853>, <0.046692, 0.781341, -0.247609>, 
      <-0.193416, 0.826635, -0.039222>, <-0.185576, 0.848321, -0.093334>, <0.046122, 0.806230, -0.207535>, <0.065180, 0.783644, -0.249291>, 
      <-0.193416, 0.826635, -0.039222>, <-0.185576, 0.848321, -0.093334>, <0.095026, 0.807918, -0.234919>, <0.146804, 0.786979, -0.272684>, 
      <-0.193416, 0.826635, -0.039222>, <-0.235845, 0.839431, -0.090031>, <0.111210, 0.805581, -0.225831>, <0.162987, 0.784642, -0.263596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.226755, 0.820739, -0.037031>, <-0.158455, 0.758861, -0.204587>, <-0.167198, 0.743516, -0.233555>, 
      <-0.235845, 0.839431, -0.090031>, <-0.269184, 0.833535, -0.087840>, <-0.128147, 0.764710, -0.220380>, <-0.136890, 0.749365, -0.249349>, 
      <0.111210, 0.805581, -0.225831>, <0.095026, 0.807918, -0.234919>, <0.030913, 0.779376, -0.246173>, <0.012424, 0.777073, -0.244491>, 
      <0.162987, 0.784642, -0.263596>, <0.146804, 0.786979, -0.272684>, <0.065180, 0.783644, -0.249291>, <0.046692, 0.781341, -0.247609>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.143689, 0.811638, 0.020326>, <0.213898, 0.764081, -0.108731>, <0.290819, 0.746089, -0.110518>, 
      <-0.193416, 0.826635, -0.039222>, <-0.186118, 0.824434, -0.030482>, <0.216139, 0.768177, -0.140750>, <0.293059, 0.750185, -0.142537>, 
      <-0.193416, 0.826635, -0.039222>, <-0.186118, 0.824434, -0.030482>, <0.139202, 0.801539, -0.210112>, <0.190979, 0.780600, -0.247877>, 
      <-0.193416, 0.826635, -0.039222>, <-0.235845, 0.839431, -0.090031>, <0.111210, 0.805581, -0.225831>, <0.162987, 0.784642, -0.263596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.235845, 0.839431, -0.090031>, <0.111210, 0.805581, -0.225831>, <0.162987, 0.784642, -0.263596>, 
      <-0.138668, 0.808151, -0.039635>, <-0.181097, 0.820947, -0.090443>, <0.139202, 0.801539, -0.210112>, <0.190979, 0.780600, -0.247877>, 
      <0.091090, 0.757787, 0.050347>, <0.113985, 0.756064, 0.019410>, <0.290392, 0.745308, -0.104414>, <0.293059, 0.750185, -0.142537>, 
      <0.139101, 0.740972, 0.077758>, <0.161996, 0.739249, 0.046821>, <0.288151, 0.741212, -0.072395>, <0.290819, 0.746089, -0.110518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.489668, 0.633694, -0.038254>, <-0.483781, 0.657139, -0.040112>, <-0.374948, 0.690663, -0.038413>, <-0.354633, 0.703894, -0.038479>, 
      <-0.486959, 0.635809, 0.005070>, <-0.481072, 0.659253, 0.003211>, <-0.376137, 0.703583, 0.000518>, <-0.355822, 0.716814, 0.000451>, 
      <-0.295386, 0.669896, 0.081073>, <-0.282228, 0.692701, 0.063029>, <-0.224019, 0.821101, 0.084691>, <-0.214012, 0.842834, 0.063566>, 
      <-0.265201, 0.670722, 0.112329>, <-0.252044, 0.693527, 0.094285>, <-0.186785, 0.825886, 0.101265>, <-0.176779, 0.847620, 0.080140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.295915, 0.646749, -0.378813>, <-0.279325, 0.670270, -0.359709>, <-0.176101, 0.727891, -0.263052>, <-0.167198, 0.743516, -0.233555>, 
      <-0.342037, 0.651683, -0.337000>, <-0.325448, 0.675205, -0.317896>, <-0.214172, 0.720544, -0.243213>, <-0.205269, 0.736169, -0.213716>, 
      <-0.493561, 0.630655, -0.100508>, <-0.487675, 0.654100, -0.102367>, <-0.373686, 0.676951, -0.079733>, <-0.353371, 0.690181, -0.079799>, 
      <-0.489668, 0.633694, -0.038254>, <-0.483781, 0.657139, -0.040112>, <-0.374948, 0.690663, -0.038413>, <-0.354633, 0.703894, -0.038479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.014939, 0.579710, -0.495716>, <0.017206, 0.619197, -0.463237>, <0.065759, 0.758745, -0.289384>, <0.046692, 0.781341, -0.247609>, 
      <-0.039010, 0.579687, -0.497253>, <-0.036743, 0.619174, -0.464774>, <0.031491, 0.754476, -0.286266>, <0.012424, 0.777073, -0.244491>, 
      <-0.256055, 0.642485, -0.414949>, <-0.239465, 0.666006, -0.395845>, <-0.145793, 0.733740, -0.278845>, <-0.136890, 0.749365, -0.249349>, 
      <-0.295915, 0.646749, -0.378813>, <-0.279325, 0.670270, -0.359709>, <-0.176101, 0.727891, -0.263052>, <-0.167198, 0.743516, -0.233555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.250824, 0.646981, -0.363234>, <0.228777, 0.665402, -0.353076>, <0.186389, 0.775178, -0.280665>, <0.162987, 0.784642, -0.263596>, 
      <0.225916, 0.637023, -0.398626>, <0.203869, 0.655444, -0.388467>, <0.170206, 0.777515, -0.289753>, <0.146804, 0.786979, -0.272684>, 
      <0.059330, 0.579729, -0.494451>, <0.061597, 0.619216, -0.461972>, <0.084247, 0.761047, -0.291066>, <0.065180, 0.783644, -0.249291>, 
      <0.014939, 0.579710, -0.495716>, <0.017206, 0.619197, -0.463237>, <0.065759, 0.758745, -0.289384>, <0.046692, 0.781341, -0.247609>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.327695, 0.704749, -0.051325>, <0.317944, 0.712472, -0.054797>, <0.303391, 0.743148, -0.110810>, <0.290819, 0.746089, -0.110518>, 
      <0.325630, 0.703357, -0.103259>, <0.315879, 0.711081, -0.106731>, <0.305631, 0.747245, -0.142829>, <0.293059, 0.750185, -0.142537>, 
      <0.279986, 0.658640, -0.321798>, <0.257940, 0.677061, -0.311640>, <0.214382, 0.771136, -0.264946>, <0.190979, 0.780600, -0.247877>, 
      <0.250824, 0.646981, -0.363234>, <0.228777, 0.665402, -0.353076>, <0.186389, 0.775178, -0.280665>, <0.162987, 0.784642, -0.263596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.274330, 0.662821, 0.227823>, <0.255335, 0.683840, 0.208129>, <0.167768, 0.730932, 0.094125>, <0.139101, 0.740972, 0.077758>, 
      <0.308064, 0.667455, 0.197249>, <0.289069, 0.688474, 0.177556>, <0.190663, 0.729209, 0.063187>, <0.161996, 0.739249, 0.046821>, 
      <0.329513, 0.705974, -0.005615>, <0.319762, 0.713697, -0.009087>, <0.300723, 0.738271, -0.072687>, <0.288151, 0.741212, -0.072395>, 
      <0.327695, 0.704749, -0.051325>, <0.317944, 0.712472, -0.054797>, <0.303391, 0.743148, -0.110810>, <0.290819, 0.746089, -0.110518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.114909, 0.643946, 0.349810>, <-0.115310, 0.679393, 0.316922>, <0.099467, 0.740924, 0.202853>, <0.090778, 0.761144, 0.159796>, 
      <-0.051309, 0.643015, 0.363424>, <-0.051710, 0.678462, 0.330536>, <0.114156, 0.735965, 0.202743>, <0.105467, 0.756185, 0.159685>, 
      <0.226380, 0.656234, 0.271281>, <0.207385, 0.677253, 0.251587>, <0.158555, 0.731626, 0.106574>, <0.129888, 0.741665, 0.090208>, 
      <0.274330, 0.662821, 0.227823>, <0.255335, 0.683840, 0.208129>, <0.167768, 0.730932, 0.094125>, <0.139101, 0.740972, 0.077758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.114909, 0.643946, 0.349810>, <-0.158880, 0.644590, 0.340397>, <-0.233966, 0.671577, 0.144673>, <-0.265201, 0.670722, 0.112329>, 
      <-0.115310, 0.679393, 0.316922>, <-0.159281, 0.680037, 0.307509>, <-0.220809, 0.694381, 0.126629>, <-0.252044, 0.693527, 0.094285>, 
      <0.099467, 0.740924, 0.202853>, <0.055360, 0.755816, 0.203186>, <-0.144545, 0.831316, 0.120069>, <-0.186785, 0.825886, 0.101265>, 
      <0.090778, 0.761144, 0.159796>, <0.046671, 0.776036, 0.160129>, <-0.134538, 0.853049, 0.098943>, <-0.176779, 0.847620, 0.080140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.399754, 0.524188, -0.024234>, <-0.392317, 0.545584, -0.023073>, <-0.495175, 0.611761, -0.036515>, <-0.489668, 0.633694, -0.038254>, 
      <-0.402404, 0.524534, 0.037087>, <-0.394967, 0.545929, 0.038248>, <-0.492466, 0.613875, 0.006808>, <-0.486959, 0.635809, 0.005070>, 
      <-0.421675, 0.505833, 0.315388>, <-0.407095, 0.549187, 0.291269>, <-0.316701, 0.632951, 0.110305>, <-0.295386, 0.669896, 0.081073>, 
      <-0.380452, 0.494606, 0.359456>, <-0.365873, 0.537960, 0.335338>, <-0.286517, 0.633777, 0.141561>, <-0.265201, 0.670722, 0.112329>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.345935, 0.490099, -0.439381>, <-0.341961, 0.517708, -0.438265>, <-0.309321, 0.627742, -0.394250>, <-0.295915, 0.646749, -0.378813>, 
      <-0.384674, 0.505282, -0.386987>, <-0.380700, 0.532891, -0.385871>, <-0.355443, 0.632677, -0.352437>, <-0.342037, 0.651683, -0.337000>, 
      <-0.396866, 0.523811, -0.091076>, <-0.389429, 0.545207, -0.089915>, <-0.499068, 0.608722, -0.098770>, <-0.493561, 0.630655, -0.100508>, 
      <-0.399754, 0.524188, -0.024234>, <-0.392317, 0.545584, -0.023073>, <-0.495175, 0.611761, -0.036515>, <-0.489668, 0.633694, -0.038254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.022430, 0.358719, -0.595231>, <0.024836, 0.397270, -0.595210>, <0.013228, 0.549908, -0.520229>, <0.014939, 0.579710, -0.495716>, 
      <-0.044622, 0.358399, -0.596453>, <-0.042216, 0.396950, -0.596433>, <-0.040721, 0.549885, -0.521766>, <-0.039010, 0.579687, -0.497253>, 
      <-0.307104, 0.474880, -0.491899>, <-0.303130, 0.502488, -0.490783>, <-0.269460, 0.623478, -0.430387>, <-0.256055, 0.642485, -0.414949>, 
      <-0.345935, 0.490099, -0.439381>, <-0.341961, 0.517708, -0.438265>, <-0.309321, 0.627742, -0.394250>, <-0.295915, 0.646749, -0.378813>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.510606, 0.494186, -0.423767>, <0.481326, 0.533296, -0.420457>, <0.286252, 0.617379, -0.379558>, <0.250824, 0.646981, -0.363234>, 
      <0.450736, 0.482706, -0.483289>, <0.421456, 0.521816, -0.479980>, <0.261344, 0.607421, -0.414950>, <0.225916, 0.637023, -0.398626>, 
      <0.107615, 0.359125, -0.593678>, <0.110021, 0.397677, -0.593658>, <0.057619, 0.549927, -0.518964>, <0.059330, 0.579729, -0.494451>, 
      <0.022430, 0.358719, -0.595231>, <0.024836, 0.397270, -0.595210>, <0.013228, 0.549908, -0.520229>, <0.014939, 0.579710, -0.495716>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.632239, 0.475654, 0.011042>, <0.600580, 0.528259, 0.007241>, <0.374140, 0.667960, -0.034789>, <0.327695, 0.704749, -0.051325>, 
      <0.640862, 0.480975, -0.060225>, <0.609203, 0.533580, -0.064026>, <0.372075, 0.666569, -0.086722>, <0.325630, 0.703357, -0.103259>, 
      <0.561188, 0.503885, -0.373478>, <0.531908, 0.542996, -0.370169>, <0.315414, 0.629038, -0.338122>, <0.279986, 0.658640, -0.321798>, 
      <0.510606, 0.494186, -0.423767>, <0.481326, 0.533296, -0.420457>, <0.286252, 0.617379, -0.379558>, <0.250824, 0.646981, -0.363234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.415280, 0.435364, 0.364093>, <0.408094, 0.480673, 0.350543>, <0.300665, 0.633680, 0.255126>, <0.274330, 0.662821, 0.227823>, 
      <0.463780, 0.443146, 0.319532>, <0.456594, 0.488455, 0.305982>, <0.334399, 0.638314, 0.224553>, <0.308064, 0.667455, 0.197249>, 
      <0.624294, 0.470752, 0.076703>, <0.592635, 0.523357, 0.072902>, <0.375958, 0.669185, 0.010922>, <0.329513, 0.705974, -0.005615>, 
      <0.632239, 0.475654, 0.011042>, <0.600580, 0.528259, 0.007241>, <0.374140, 0.667960, -0.034789>, <0.327695, 0.704749, -0.051325>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.094987, 0.389451, 0.504660>, <0.080251, 0.444987, 0.496379>, <-0.114427, 0.601392, 0.389292>, <-0.114909, 0.643946, 0.349810>, 
      <0.151028, 0.385279, 0.504987>, <0.136292, 0.440814, 0.496706>, <-0.050827, 0.600461, 0.402907>, <-0.051309, 0.643015, 0.363424>, 
      <0.374184, 0.428770, 0.401851>, <0.366997, 0.474079, 0.388302>, <0.252715, 0.627093, 0.298584>, <0.226380, 0.656234, 0.271281>, 
      <0.415280, 0.435364, 0.364093>, <0.408094, 0.480673, 0.350543>, <0.300665, 0.633680, 0.255126>, <0.274330, 0.662821, 0.227823>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.094987, 0.389451, 0.504660>, <0.014270, 0.395460, 0.504190>, <-0.326091, 0.479801, 0.417570>, <-0.380452, 0.494606, 0.359456>, 
      <0.080251, 0.444987, 0.496379>, <-0.000465, 0.450996, 0.495909>, <-0.311512, 0.523156, 0.393452>, <-0.365873, 0.537960, 0.335338>, 
      <-0.114427, 0.601392, 0.389292>, <-0.158398, 0.602036, 0.379880>, <-0.255282, 0.634631, 0.173905>, <-0.286517, 0.633777, 0.141561>, 
      <-0.114909, 0.643946, 0.349810>, <-0.158880, 0.644590, 0.340397>, <-0.233966, 0.671577, 0.144673>, <-0.265201, 0.670722, 0.112329>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.595427, 0.329434, -0.054767>, <-0.601265, 0.327236, 0.018146>, <-0.469346, 0.236542, 0.309874>, <-0.412173, 0.233676, 0.355461>, 
      <-0.610370, 0.284691, -0.045624>, <-0.616208, 0.282494, 0.027289>, <-0.467755, 0.215558, 0.303874>, <-0.410582, 0.212692, 0.349462>, 
      <-0.590741, 0.090679, 0.069080>, <-0.600209, 0.098535, 0.113978>, <-0.406940, 0.162049, 0.255755>, <-0.365064, 0.164280, 0.275970>, 
      <-0.555381, 0.058201, 0.070989>, <-0.564849, 0.066057, 0.115887>, <-0.396337, 0.149574, 0.241234>, <-0.354461, 0.151806, 0.261450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.595427, 0.329434, -0.054767>, <-0.581667, 0.370634, -0.063186>, <-0.414262, 0.482450, -0.026499>, <-0.399754, 0.524188, -0.024234>, 
      <-0.601265, 0.327236, 0.018146>, <-0.587505, 0.368437, 0.009727>, <-0.416912, 0.482796, 0.034821>, <-0.402404, 0.524534, 0.037087>, 
      <-0.469346, 0.236542, 0.309874>, <-0.472391, 0.276699, 0.321354>, <-0.433482, 0.470723, 0.334919>, <-0.421675, 0.505833, 0.315388>, 
      <-0.412173, 0.233676, 0.355461>, <-0.415218, 0.273832, 0.366942>, <-0.392259, 0.459496, 0.378988>, <-0.380452, 0.494606, 0.359456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.352119, 0.256284, -0.394596>, <-0.358261, 0.287454, -0.415328>, <-0.351336, 0.452580, -0.440898>, <-0.345935, 0.490099, -0.439381>, 
      <-0.405399, 0.267527, -0.354555>, <-0.411541, 0.298698, -0.375287>, <-0.390074, 0.467763, -0.388504>, <-0.384674, 0.505282, -0.386987>, 
      <-0.590035, 0.331464, -0.122111>, <-0.576275, 0.372664, -0.130530>, <-0.411374, 0.482073, -0.093341>, <-0.396866, 0.523811, -0.091076>, 
      <-0.595427, 0.329434, -0.054767>, <-0.581667, 0.370634, -0.063186>, <-0.414262, 0.482450, -0.026499>, <-0.399754, 0.524188, -0.024234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.352119, 0.256284, -0.394596>, <-0.405399, 0.267527, -0.354555>, <-0.590035, 0.331464, -0.122111>, <-0.595427, 0.329434, -0.054767>, 
      <-0.344273, 0.216467, -0.368113>, <-0.397553, 0.227710, -0.328072>, <-0.604978, 0.286721, -0.112968>, <-0.610370, 0.284691, -0.045624>, 
      <-0.283926, 0.108141, -0.196686>, <-0.324974, 0.112642, -0.153555>, <-0.578597, 0.080602, 0.011491>, <-0.590741, 0.090679, 0.069080>, 
      <-0.264581, 0.077227, -0.164773>, <-0.305630, 0.081728, -0.121642>, <-0.543237, 0.048124, 0.013400>, <-0.555381, 0.058201, 0.070989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008414, 0.205559, -0.495916>, <-0.000413, 0.230957, -0.508590>, <0.020593, 0.329286, -0.595247>, <0.022430, 0.358719, -0.595231>, 
      <-0.065980, 0.202467, -0.496064>, <-0.057979, 0.227865, -0.508738>, <-0.046459, 0.328966, -0.596469>, <-0.044622, 0.358399, -0.596453>, 
      <-0.306675, 0.246694, -0.428748>, <-0.312817, 0.277865, -0.449480>, <-0.312505, 0.437361, -0.493416>, <-0.307104, 0.474880, -0.491899>, 
      <-0.352119, 0.256284, -0.394596>, <-0.358261, 0.287454, -0.415328>, <-0.351336, 0.452580, -0.440898>, <-0.345935, 0.490099, -0.439381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008414, 0.205559, -0.495916>, <-0.065980, 0.202467, -0.496064>, <-0.306675, 0.246694, -0.428748>, <-0.352119, 0.256284, -0.394596>, 
      <-0.018234, 0.174387, -0.480360>, <-0.075801, 0.171295, -0.480507>, <-0.298829, 0.206877, -0.402265>, <-0.344273, 0.216467, -0.368113>, 
      <-0.080585, 0.026242, -0.449350>, <-0.130659, 0.023943, -0.442312>, <-0.249128, 0.104325, -0.233248>, <-0.283926, 0.108141, -0.196686>, 
      <-0.088375, 0.006991, -0.419704>, <-0.138449, 0.004692, -0.412666>, <-0.229784, 0.073411, -0.201335>, <-0.264581, 0.077227, -0.164773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.508710, 0.302518, -0.392385>, <0.441230, 0.299106, -0.444645>, <0.076882, 0.210140, -0.495697>, <-0.008414, 0.205559, -0.495916>, 
      <0.480769, 0.258331, -0.371578>, <0.413289, 0.254919, -0.423838>, <0.067061, 0.178968, -0.480141>, <-0.018234, 0.174387, -0.480360>, 
      <0.305248, 0.128292, -0.263201>, <0.260957, 0.128470, -0.310257>, <-0.016657, 0.029178, -0.458334>, <-0.080585, 0.026242, -0.449350>, 
      <0.262245, 0.101418, -0.238817>, <0.217953, 0.101597, -0.285873>, <-0.024448, 0.009926, -0.428689>, <-0.088375, 0.006991, -0.419704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.508710, 0.302518, -0.392385>, <0.524074, 0.326815, -0.403826>, <0.529106, 0.469475, -0.425858>, <0.510606, 0.494186, -0.423767>, 
      <0.441230, 0.299106, -0.444645>, <0.456593, 0.323403, -0.456087>, <0.469237, 0.457994, -0.485381>, <0.450736, 0.482706, -0.483289>, 
      <0.076882, 0.210140, -0.495697>, <0.084883, 0.235538, -0.508371>, <0.105778, 0.329692, -0.593694>, <0.107615, 0.359125, -0.593678>, 
      <-0.008414, 0.205559, -0.495916>, <-0.000413, 0.230957, -0.508590>, <0.020593, 0.329286, -0.595247>, <0.022430, 0.358719, -0.595231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.609322, 0.236794, -0.017509>, <0.631471, 0.268258, -0.016383>, <0.652050, 0.442735, 0.013421>, <0.632239, 0.475654, 0.011042>, 
      <0.623110, 0.241393, -0.078511>, <0.645258, 0.272857, -0.077385>, <0.660673, 0.448056, -0.057846>, <0.640862, 0.480975, -0.060225>, 
      <0.558250, 0.305023, -0.354018>, <0.573614, 0.329320, -0.365459>, <0.579689, 0.479174, -0.375570>, <0.561188, 0.503885, -0.373478>, 
      <0.508710, 0.302518, -0.392385>, <0.524074, 0.326815, -0.403826>, <0.529106, 0.469475, -0.425858>, <0.510606, 0.494186, -0.423767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.609322, 0.236794, -0.017509>, <0.623110, 0.241393, -0.078511>, <0.558250, 0.305023, -0.354018>, <0.508710, 0.302518, -0.392385>, 
      <0.573990, 0.186603, -0.019306>, <0.587778, 0.191202, -0.080308>, <0.530310, 0.260836, -0.333211>, <0.480769, 0.258331, -0.371578>, 
      <0.357188, 0.030672, -0.004868>, <0.344917, 0.027314, -0.043449>, <0.333092, 0.128179, -0.233620>, <0.305248, 0.128292, -0.263201>, 
      <0.301222, 0.005420, -0.005789>, <0.288951, 0.002062, -0.044370>, <0.290089, 0.101306, -0.209235>, <0.262245, 0.101418, -0.238817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.340382, 0.246366, 0.352365>, <0.400954, 0.240245, 0.312331>, <0.593302, 0.231450, 0.053371>, <0.609322, 0.236794, -0.017509>, 
      <0.340124, 0.221089, 0.341044>, <0.400696, 0.214968, 0.301009>, <0.557970, 0.181259, 0.051575>, <0.573990, 0.186603, -0.019306>, 
      <0.431007, 0.156122, 0.248088>, <0.460138, 0.147575, 0.211842>, <0.371470, 0.034580, 0.040035>, <0.357188, 0.030672, -0.004868>, 
      <0.412284, 0.142474, 0.232911>, <0.441415, 0.133927, 0.196665>, <0.315504, 0.009328, 0.039114>, <0.301222, 0.005420, -0.005789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.340382, 0.246366, 0.352365>, <0.340685, 0.275969, 0.365624>, <0.420153, 0.404638, 0.373282>, <0.415280, 0.435364, 0.364093>, 
      <0.400954, 0.240245, 0.312331>, <0.401257, 0.269848, 0.325589>, <0.468654, 0.412420, 0.328720>, <0.463780, 0.443146, 0.319532>, 
      <0.593302, 0.231450, 0.053371>, <0.615450, 0.262913, 0.054497>, <0.644106, 0.437833, 0.079082>, <0.624294, 0.470752, 0.076703>, 
      <0.609322, 0.236794, -0.017509>, <0.631471, 0.268258, -0.016383>, <0.652050, 0.442735, 0.013421>, <0.632239, 0.475654, 0.011042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.023854, 0.300778, 0.400981>, <-0.017423, 0.325676, 0.413996>, <0.102303, 0.361878, 0.508772>, <0.094987, 0.389451, 0.504660>, 
      <0.035312, 0.301776, 0.400738>, <0.041742, 0.326674, 0.413753>, <0.158344, 0.357706, 0.509098>, <0.151028, 0.385279, 0.504987>, 
      <0.291190, 0.251337, 0.384878>, <0.291493, 0.280940, 0.398137>, <0.379057, 0.398044, 0.411040>, <0.374184, 0.428770, 0.401851>, 
      <0.340382, 0.246366, 0.352365>, <0.340685, 0.275969, 0.365624>, <0.420153, 0.404638, 0.373282>, <0.415280, 0.435364, 0.364093>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.023854, 0.300778, 0.400981>, <0.035312, 0.301776, 0.400738>, <0.291190, 0.251337, 0.384878>, <0.340382, 0.246366, 0.352365>, 
      <-0.031764, 0.270152, 0.384972>, <0.027402, 0.271150, 0.384729>, <0.290932, 0.226060, 0.373556>, <0.340124, 0.221089, 0.341044>, 
      <0.023684, 0.112389, 0.373072>, <0.089700, 0.111585, 0.370615>, <0.390301, 0.168066, 0.298736>, <0.431007, 0.156122, 0.248088>, 
      <0.017316, 0.088720, 0.347459>, <0.083332, 0.087916, 0.345002>, <0.371578, 0.154417, 0.283559>, <0.412284, 0.142474, 0.232911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.023854, 0.300778, 0.400981>, <-0.031764, 0.270152, 0.384972>, <0.023684, 0.112389, 0.373072>, <0.017316, 0.088720, 0.347459>, 
      <-0.087037, 0.299713, 0.401241>, <-0.094946, 0.269087, 0.385232>, <-0.037881, 0.113138, 0.375364>, <-0.044249, 0.089469, 0.349751>, 
      <-0.362803, 0.231201, 0.394827>, <-0.361212, 0.210216, 0.388827>, <-0.309643, 0.167234, 0.302725>, <-0.299040, 0.154759, 0.288205>, 
      <-0.412173, 0.233676, 0.355461>, <-0.410582, 0.212692, 0.349462>, <-0.365064, 0.164280, 0.275970>, <-0.354461, 0.151806, 0.261450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.023854, 0.300778, 0.400981>, <-0.087037, 0.299713, 0.401241>, <-0.362803, 0.231201, 0.394827>, <-0.412173, 0.233676, 0.355461>, 
      <-0.017423, 0.325676, 0.413996>, <-0.080606, 0.324611, 0.414256>, <-0.365847, 0.271357, 0.406308>, <-0.415218, 0.273832, 0.366942>, 
      <0.102303, 0.361878, 0.508772>, <0.021586, 0.367888, 0.508301>, <-0.337898, 0.444691, 0.437102>, <-0.392259, 0.459496, 0.378988>, 
      <0.094987, 0.389451, 0.504660>, <0.014270, 0.395460, 0.504190>, <-0.326091, 0.479801, 0.417570>, <-0.380452, 0.494606, 0.359456>
    }
  }
  material {
    Material1
  }
  scale 0.2
  rotate <118.039688, 0.0, -0.0>
  translate  <7.257212, -7.626243, 0.068759>
}


union { // sPatchObj7
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.181642, -0.120829, -0.077768>, <-0.501095, 0.008340, 0.073919>, <-0.555381, 0.058201, 0.070989>, 
      <-0.130926, -0.097201, -0.029692>, <-0.133066, -0.098198, -0.031720>, <-0.510563, 0.016196, 0.118818>, <-0.564849, 0.066057, 0.115887>, 
      <-0.130926, -0.097201, -0.029692>, <-0.133066, -0.098198, -0.031720>, <-0.362102, 0.109298, 0.194351>, <-0.396337, 0.149574, 0.241234>, 
      <-0.130926, -0.097201, -0.029692>, <-0.082349, -0.074570, 0.016356>, <-0.320226, 0.111530, 0.214567>, <-0.354461, 0.151806, 0.261450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.082349, -0.074570, 0.016356>, <-0.320226, 0.111530, 0.214567>, <-0.354461, 0.151806, 0.261450>, 
      <-0.032439, -0.083797, -0.058255>, <0.016138, -0.061166, -0.012207>, <-0.264805, 0.114483, 0.241321>, <-0.299040, 0.154759, 0.288205>, 
      <0.342377, 0.091514, 0.176242>, <0.301671, 0.103458, 0.226890>, <0.021767, 0.088666, 0.347293>, <-0.044249, 0.089469, 0.349751>, 
      <0.412284, 0.142474, 0.232911>, <0.371578, 0.154417, 0.283559>, <0.083332, 0.087916, 0.345002>, <0.017316, 0.088720, 0.347459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.032439, -0.083797, -0.058255>, <0.342377, 0.091514, 0.176242>, <0.412284, 0.142474, 0.232911>, 
      <-0.130926, -0.097201, -0.029692>, <-0.100076, -0.093002, -0.038639>, <0.301671, 0.103458, 0.226890>, <0.371578, 0.154417, 0.283559>, 
      <-0.130926, -0.097201, -0.029692>, <-0.100076, -0.093002, -0.038639>, <0.070575, 0.040499, 0.293689>, <0.083332, 0.087916, 0.345002>, 
      <-0.130926, -0.097201, -0.029692>, <-0.198563, -0.106406, -0.010076>, <0.004559, 0.041302, 0.296146>, <0.017316, 0.088720, 0.347459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.082349, -0.074570, 0.016356>, <-0.320226, 0.111530, 0.214567>, <-0.354461, 0.151806, 0.261450>, 
      <-0.130926, -0.097201, -0.029692>, <-0.149986, -0.083775, 0.035972>, <-0.264805, 0.114483, 0.241321>, <-0.299040, 0.154759, 0.288205>, 
      <-0.130926, -0.097201, -0.029692>, <-0.149986, -0.083775, 0.035972>, <-0.057006, 0.042051, 0.298437>, <-0.044249, 0.089469, 0.349751>, 
      <-0.130926, -0.097201, -0.029692>, <-0.198563, -0.106406, -0.010076>, <0.004559, 0.041302, 0.296146>, <0.017316, 0.088720, 0.347459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.181642, -0.120829, -0.077768>, <-0.501095, 0.008340, 0.073919>, <-0.555381, 0.058201, 0.070989>, 
      <-0.198563, -0.106406, -0.010076>, <-0.249279, -0.130034, -0.058152>, <-0.510563, 0.016196, 0.118818>, <-0.564849, 0.066057, 0.115887>, 
      <0.004559, 0.041302, 0.296146>, <-0.057006, 0.042051, 0.298437>, <-0.340915, 0.152528, 0.267989>, <-0.396337, 0.149574, 0.241234>, 
      <0.017316, 0.088720, 0.347459>, <-0.044249, 0.089469, 0.349751>, <-0.299040, 0.154759, 0.288205>, <-0.354461, 0.151806, 0.261450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.032439, -0.083797, -0.058255>, <0.342377, 0.091514, 0.176242>, <0.412284, 0.142474, 0.232911>, 
      <-0.142798, -0.067962, -0.100668>, <-0.044310, -0.054558, -0.129231>, <0.371508, 0.082967, 0.139996>, <0.441415, 0.133927, 0.196665>, 
      <0.202881, 0.064320, -0.205156>, <0.230724, 0.064208, -0.175574>, <0.303233, 0.005970, 0.000533>, <0.315504, 0.009328, 0.039114>, 
      <0.262245, 0.101418, -0.238817>, <0.290089, 0.101306, -0.209235>, <0.288951, 0.002062, -0.044370>, <0.301222, 0.005420, -0.005789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.142798, -0.067962, -0.100668>, <0.202881, 0.064320, -0.205156>, <0.262245, 0.101418, -0.238817>, 
      <-0.130926, -0.097201, -0.029692>, <-0.131968, -0.094634, -0.035923>, <0.230724, 0.064208, -0.175574>, <0.290089, 0.101306, -0.209235>, 
      <-0.130926, -0.097201, -0.029692>, <-0.131968, -0.094634, -0.035923>, <0.224372, -0.027076, -0.045433>, <0.288951, 0.002062, -0.044370>, 
      <-0.130926, -0.097201, -0.029692>, <-0.120096, -0.123873, 0.035053>, <0.236643, -0.023718, -0.006852>, <0.301222, 0.005420, -0.005789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.032439, -0.083797, -0.058255>, <0.342377, 0.091514, 0.176242>, <0.412284, 0.142474, 0.232911>, 
      <-0.130926, -0.097201, -0.029692>, <-0.021609, -0.110470, 0.006490>, <0.371508, 0.082967, 0.139996>, <0.441415, 0.133927, 0.196665>, 
      <-0.130926, -0.097201, -0.029692>, <-0.021609, -0.110470, 0.006490>, <0.250924, -0.019810, 0.038051>, <0.315504, 0.009328, 0.039114>, 
      <-0.130926, -0.097201, -0.029692>, <-0.120096, -0.123873, 0.035053>, <0.236643, -0.023718, -0.006852>, <0.301222, 0.005420, -0.005789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.198563, -0.106406, -0.010076>, <0.004559, 0.041302, 0.296146>, <0.017316, 0.088720, 0.347459>, 
      <-0.120096, -0.123873, 0.035053>, <-0.187733, -0.133079, 0.054669>, <0.070575, 0.040499, 0.293689>, <0.083332, 0.087916, 0.345002>, 
      <0.236643, -0.023718, -0.006852>, <0.250924, -0.019810, 0.038051>, <0.400709, 0.145870, 0.247313>, <0.371578, 0.154417, 0.283559>, 
      <0.301222, 0.005420, -0.005789>, <0.315504, 0.009328, 0.039114>, <0.441415, 0.133927, 0.196665>, <0.412284, 0.142474, 0.232911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.181642, -0.120829, -0.077768>, <-0.501095, 0.008340, 0.073919>, <-0.555381, 0.058201, 0.070989>, 
      <-0.130926, -0.097201, -0.029692>, <-0.204428, -0.111747, -0.044803>, <-0.488951, -0.001737, 0.016331>, <-0.543237, 0.048124, 0.013400>, 
      <-0.130926, -0.097201, -0.029692>, <-0.204428, -0.111747, -0.044803>, <-0.289227, 0.055516, -0.094583>, <-0.305630, 0.081728, -0.121642>, 
      <-0.130926, -0.097201, -0.029692>, <-0.153711, -0.088119, 0.003273>, <-0.248178, 0.051014, -0.137713>, <-0.264581, 0.077227, -0.164773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.153711, -0.088119, 0.003273>, <-0.248178, 0.051014, -0.137713>, <-0.264581, 0.077227, -0.164773>, 
      <-0.082349, -0.074570, 0.016356>, <-0.105135, -0.065488, 0.049321>, <-0.289227, 0.055516, -0.094583>, <-0.305630, 0.081728, -0.121642>, 
      <-0.320226, 0.111530, 0.214567>, <-0.362102, 0.109298, 0.194351>, <-0.552705, 0.055980, 0.058298>, <-0.543237, 0.048124, 0.013400>, 
      <-0.354461, 0.151806, 0.261450>, <-0.396337, 0.149574, 0.241234>, <-0.564849, 0.066057, 0.115887>, <-0.555381, 0.058201, 0.070989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.142798, -0.067962, -0.100668>, <0.202881, 0.064320, -0.205156>, <0.262245, 0.101418, -0.238817>, 
      <-0.153711, -0.088119, 0.003273>, <-0.165583, -0.058880, -0.067702>, <0.158589, 0.064499, -0.252212>, <0.217953, 0.101597, -0.285873>, 
      <-0.248178, 0.051014, -0.137713>, <-0.213381, 0.047199, -0.174276>, <-0.074521, 0.007627, -0.421651>, <-0.024448, 0.009926, -0.428689>, 
      <-0.264581, 0.077227, -0.164773>, <-0.229784, 0.073411, -0.201335>, <-0.138449, 0.004692, -0.412666>, <-0.088375, 0.006991, -0.419704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.095069, -0.111494, -0.081569>, <-0.102292, -0.027401, -0.366744>, <-0.088375, 0.006991, -0.419704>, 
      <-0.130926, -0.097201, -0.029692>, <-0.117854, -0.102411, -0.048604>, <-0.152365, -0.029700, -0.359706>, <-0.138449, 0.004692, -0.412666>, 
      <-0.130926, -0.097201, -0.029692>, <-0.117854, -0.102411, -0.048604>, <-0.213381, 0.047199, -0.174276>, <-0.229784, 0.073411, -0.201335>, 
      <-0.130926, -0.097201, -0.029692>, <-0.153711, -0.088119, 0.003273>, <-0.248178, 0.051014, -0.137713>, <-0.264581, 0.077227, -0.164773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.095069, -0.111494, -0.081569>, <-0.102292, -0.027401, -0.366744>, <-0.088375, 0.006991, -0.419704>, 
      <-0.181642, -0.120829, -0.077768>, <-0.145785, -0.135122, -0.129645>, <-0.152365, -0.029700, -0.359706>, <-0.138449, 0.004692, -0.412666>, 
      <-0.501095, 0.008340, 0.073919>, <-0.488951, -0.001737, 0.016331>, <-0.270832, 0.077912, -0.158205>, <-0.229784, 0.073411, -0.201335>, 
      <-0.555381, 0.058201, 0.070989>, <-0.543237, 0.048124, 0.013400>, <-0.305630, 0.081728, -0.121642>, <-0.264581, 0.077227, -0.164773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.142798, -0.067962, -0.100668>, <0.202881, 0.064320, -0.205156>, <0.262245, 0.101418, -0.238817>, 
      <-0.130926, -0.097201, -0.029692>, <-0.106941, -0.082255, -0.152545>, <0.158589, 0.064499, -0.252212>, <0.217953, 0.101597, -0.285873>, 
      <-0.130926, -0.097201, -0.029692>, <-0.106941, -0.082255, -0.152545>, <-0.038364, -0.024465, -0.375729>, <-0.024448, 0.009926, -0.428689>, 
      <-0.130926, -0.097201, -0.029692>, <-0.095069, -0.111494, -0.081569>, <-0.102292, -0.027401, -0.366744>, <-0.088375, 0.006991, -0.419704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130926, -0.097201, -0.029692>, <-0.120096, -0.123873, 0.035053>, <0.236643, -0.023718, -0.006852>, <0.301222, 0.005420, -0.005789>, 
      <-0.095069, -0.111494, -0.081569>, <-0.084239, -0.138166, -0.016824>, <0.224372, -0.027076, -0.045433>, <0.288951, 0.002062, -0.044370>, 
      <-0.102292, -0.027401, -0.366744>, <-0.038364, -0.024465, -0.375729>, <0.245797, 0.101484, -0.256292>, <0.290089, 0.101306, -0.209235>, 
      <-0.088375, 0.006991, -0.419704>, <-0.024448, 0.009926, -0.428689>, <0.217953, 0.101597, -0.285873>, <0.262245, 0.101418, -0.238817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.138668, 0.808151, -0.039635>, <0.091090, 0.757787, 0.050347>, <0.139101, 0.740972, 0.077758>, 
      <-0.211878, 0.832868, -0.039083>, <-0.157131, 0.814384, -0.039496>, <0.081876, 0.758480, 0.062797>, <0.129888, 0.741665, 0.090208>, 
      <-0.170670, 0.860889, 0.067242>, <-0.128429, 0.866318, 0.086046>, <0.061359, 0.771076, 0.160018>, <0.105467, 0.756185, 0.159685>, 
      <-0.176779, 0.847620, 0.080140>, <-0.134538, 0.853049, 0.098943>, <0.046671, 0.776036, 0.160129>, <0.090778, 0.761144, 0.159796>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.138668, 0.808151, -0.039635>, <0.091090, 0.757787, 0.050347>, <0.139101, 0.740972, 0.077758>, 
      <-0.193416, 0.826635, -0.039222>, <-0.087636, 0.814710, -0.016918>, <0.081876, 0.758480, 0.062797>, <0.129888, 0.741665, 0.090208>, 
      <-0.193416, 0.826635, -0.039222>, <-0.087636, 0.814710, -0.016918>, <0.095360, 0.779703, 0.109604>, <0.105467, 0.756185, 0.159685>, 
      <-0.193416, 0.826635, -0.039222>, <-0.142384, 0.833194, -0.016505>, <0.080671, 0.784662, 0.109715>, <0.090778, 0.761144, 0.159796>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.211878, 0.832868, -0.039083>, <-0.170670, 0.860889, 0.067242>, <-0.176779, 0.847620, 0.080140>, 
      <-0.193416, 0.826635, -0.039222>, <-0.160846, 0.839428, -0.016366>, <-0.128429, 0.866318, 0.086046>, <-0.134538, 0.853049, 0.098943>, 
      <-0.193416, 0.826635, -0.039222>, <-0.160846, 0.839428, -0.016366>, <0.036564, 0.799554, 0.110047>, <0.046671, 0.776036, 0.160129>, 
      <-0.193416, 0.826635, -0.039222>, <-0.142384, 0.833194, -0.016505>, <0.080671, 0.784662, 0.109715>, <0.090778, 0.761144, 0.159796>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.211878, 0.832868, -0.039083>, <-0.170670, 0.860889, 0.067242>, <-0.176779, 0.847620, 0.080140>, 
      <-0.193416, 0.826635, -0.039222>, <-0.241165, 0.829104, -0.052120>, <-0.207903, 0.856103, 0.050668>, <-0.214012, 0.842834, 0.063566>, 
      <-0.193416, 0.826635, -0.039222>, <-0.241165, 0.829104, -0.052120>, <-0.328775, 0.734429, 0.000363>, <-0.355822, 0.716814, 0.000451>, 
      <-0.193416, 0.826635, -0.039222>, <-0.222703, 0.822871, -0.052259>, <-0.327586, 0.721509, -0.038567>, <-0.354633, 0.703894, -0.038479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.142384, 0.833194, -0.016505>, <0.080671, 0.784662, 0.109715>, <0.090778, 0.761144, 0.159796>, 
      <-0.222703, 0.822871, -0.052259>, <-0.171670, 0.829430, -0.029542>, <0.036564, 0.799554, 0.110047>, <0.046671, 0.776036, 0.160129>, 
      <-0.327586, 0.721509, -0.038567>, <-0.328775, 0.734429, 0.000363>, <-0.171771, 0.848264, 0.082369>, <-0.134538, 0.853049, 0.098943>, 
      <-0.354633, 0.703894, -0.038479>, <-0.355822, 0.716814, 0.000451>, <-0.214012, 0.842834, 0.063566>, <-0.176779, 0.847620, 0.080140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.222703, 0.822871, -0.052259>, <-0.327586, 0.721509, -0.038567>, <-0.354633, 0.703894, -0.038479>, 
      <-0.143147, 0.835525, -0.042525>, <-0.172433, 0.831761, -0.055562>, <-0.326324, 0.707796, -0.079887>, <-0.353371, 0.690181, -0.079799>, 
      <0.027634, 0.803928, -0.205853>, <-0.006634, 0.799659, -0.202735>, <-0.174961, 0.742018, -0.229510>, <-0.205269, 0.736169, -0.213716>, 
      <0.046692, 0.781341, -0.247609>, <0.012424, 0.777073, -0.244491>, <-0.136890, 0.749365, -0.249349>, <-0.167198, 0.743516, -0.233555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.222703, 0.822871, -0.052259>, <-0.327586, 0.721509, -0.038567>, <-0.354633, 0.703894, -0.038479>, 
      <-0.193416, 0.826635, -0.039222>, <-0.256042, 0.816975, -0.050068>, <-0.326324, 0.707796, -0.079887>, <-0.353371, 0.690181, -0.079799>, 
      <-0.193416, 0.826635, -0.039222>, <-0.256042, 0.816975, -0.050068>, <-0.196526, 0.751514, -0.184748>, <-0.205269, 0.736169, -0.213716>, 
      <-0.193416, 0.826635, -0.039222>, <-0.226755, 0.820739, -0.037031>, <-0.158455, 0.758861, -0.204587>, <-0.167198, 0.743516, -0.233555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.211878, 0.832868, -0.039083>, <-0.170670, 0.860889, 0.067242>, <-0.176779, 0.847620, 0.080140>, 
      <-0.226755, 0.820739, -0.037031>, <-0.245218, 0.826973, -0.036892>, <-0.207903, 0.856103, 0.050668>, <-0.214012, 0.842834, 0.063566>, 
      <-0.158455, 0.758861, -0.204587>, <-0.196526, 0.751514, -0.184748>, <-0.354560, 0.703101, -0.040869>, <-0.355822, 0.716814, 0.000451>, 
      <-0.167198, 0.743516, -0.233555>, <-0.205269, 0.736169, -0.213716>, <-0.353371, 0.690181, -0.079799>, <-0.354633, 0.703894, -0.038479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.143147, 0.835525, -0.042525>, <0.027634, 0.803928, -0.205853>, <0.046692, 0.781341, -0.247609>, 
      <-0.193416, 0.826635, -0.039222>, <-0.176486, 0.829629, -0.040334>, <-0.006634, 0.799659, -0.202735>, <0.012424, 0.777073, -0.244491>, 
      <-0.193416, 0.826635, -0.039222>, <-0.176486, 0.829629, -0.040334>, <-0.128147, 0.764710, -0.220380>, <-0.136890, 0.749365, -0.249349>, 
      <-0.193416, 0.826635, -0.039222>, <-0.226755, 0.820739, -0.037031>, <-0.158455, 0.758861, -0.204587>, <-0.167198, 0.743516, -0.233555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.143147, 0.835525, -0.042525>, <0.027634, 0.803928, -0.205853>, <0.046692, 0.781341, -0.247609>, 
      <-0.143689, 0.811638, 0.020326>, <-0.093419, 0.820527, 0.017023>, <0.046122, 0.806230, -0.207535>, <0.065180, 0.783644, -0.249291>, 
      <0.213898, 0.764081, -0.108731>, <0.216139, 0.768177, -0.140750>, <0.174796, 0.782937, -0.256965>, <0.146804, 0.786979, -0.272684>, 
      <0.290819, 0.746089, -0.110518>, <0.293059, 0.750185, -0.142537>, <0.190979, 0.780600, -0.247877>, <0.162987, 0.784642, -0.263596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.138668, 0.808151, -0.039635>, <0.091090, 0.757787, 0.050347>, <0.139101, 0.740972, 0.077758>, 
      <-0.193416, 0.826635, -0.039222>, <-0.088941, 0.793154, 0.019913>, <0.113985, 0.756064, 0.019410>, <0.161996, 0.739249, 0.046821>, 
      <-0.193416, 0.826635, -0.039222>, <-0.088941, 0.793154, 0.019913>, <0.211230, 0.759203, -0.070608>, <0.288151, 0.741212, -0.072395>, 
      <-0.193416, 0.826635, -0.039222>, <-0.143689, 0.811638, 0.020326>, <0.213898, 0.764081, -0.108731>, <0.290819, 0.746089, -0.110518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.142384, 0.833194, -0.016505>, <0.080671, 0.784662, 0.109715>, <0.090778, 0.761144, 0.159796>, 
      <-0.143689, 0.811638, 0.020326>, <-0.092656, 0.818197, 0.043043>, <0.095360, 0.779703, 0.109604>, <0.105467, 0.756185, 0.159685>, 
      <0.213898, 0.764081, -0.108731>, <0.211230, 0.759203, -0.070608>, <0.152782, 0.739942, 0.059270>, <0.129888, 0.741665, 0.090208>, 
      <0.290819, 0.746089, -0.110518>, <0.288151, 0.741212, -0.072395>, <0.161996, 0.739249, 0.046821>, <0.139101, 0.740972, 0.077758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.143147, 0.835525, -0.042525>, <0.027634, 0.803928, -0.205853>, <0.046692, 0.781341, -0.247609>, 
      <-0.193416, 0.826635, -0.039222>, <-0.185576, 0.848321, -0.093334>, <0.046122, 0.806230, -0.207535>, <0.065180, 0.783644, -0.249291>, 
      <-0.193416, 0.826635, -0.039222>, <-0.185576, 0.848321, -0.093334>, <0.095026, 0.807918, -0.234919>, <0.146804, 0.786979, -0.272684>, 
      <-0.193416, 0.826635, -0.039222>, <-0.235845, 0.839431, -0.090031>, <0.111210, 0.805581, -0.225831>, <0.162987, 0.784642, -0.263596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.226755, 0.820739, -0.037031>, <-0.158455, 0.758861, -0.204587>, <-0.167198, 0.743516, -0.233555>, 
      <-0.235845, 0.839431, -0.090031>, <-0.269184, 0.833535, -0.087840>, <-0.128147, 0.764710, -0.220380>, <-0.136890, 0.749365, -0.249349>, 
      <0.111210, 0.805581, -0.225831>, <0.095026, 0.807918, -0.234919>, <0.030913, 0.779376, -0.246173>, <0.012424, 0.777073, -0.244491>, 
      <0.162987, 0.784642, -0.263596>, <0.146804, 0.786979, -0.272684>, <0.065180, 0.783644, -0.249291>, <0.046692, 0.781341, -0.247609>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.143689, 0.811638, 0.020326>, <0.213898, 0.764081, -0.108731>, <0.290819, 0.746089, -0.110518>, 
      <-0.193416, 0.826635, -0.039222>, <-0.186118, 0.824434, -0.030482>, <0.216139, 0.768177, -0.140750>, <0.293059, 0.750185, -0.142537>, 
      <-0.193416, 0.826635, -0.039222>, <-0.186118, 0.824434, -0.030482>, <0.139202, 0.801539, -0.210112>, <0.190979, 0.780600, -0.247877>, 
      <-0.193416, 0.826635, -0.039222>, <-0.235845, 0.839431, -0.090031>, <0.111210, 0.805581, -0.225831>, <0.162987, 0.784642, -0.263596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193416, 0.826635, -0.039222>, <-0.235845, 0.839431, -0.090031>, <0.111210, 0.805581, -0.225831>, <0.162987, 0.784642, -0.263596>, 
      <-0.138668, 0.808151, -0.039635>, <-0.181097, 0.820947, -0.090443>, <0.139202, 0.801539, -0.210112>, <0.190979, 0.780600, -0.247877>, 
      <0.091090, 0.757787, 0.050347>, <0.113985, 0.756064, 0.019410>, <0.290392, 0.745308, -0.104414>, <0.293059, 0.750185, -0.142537>, 
      <0.139101, 0.740972, 0.077758>, <0.161996, 0.739249, 0.046821>, <0.288151, 0.741212, -0.072395>, <0.290819, 0.746089, -0.110518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.489668, 0.633694, -0.038254>, <-0.483781, 0.657139, -0.040112>, <-0.374948, 0.690663, -0.038413>, <-0.354633, 0.703894, -0.038479>, 
      <-0.486959, 0.635809, 0.005070>, <-0.481072, 0.659253, 0.003211>, <-0.376137, 0.703583, 0.000518>, <-0.355822, 0.716814, 0.000451>, 
      <-0.295386, 0.669896, 0.081073>, <-0.282228, 0.692701, 0.063029>, <-0.224019, 0.821101, 0.084691>, <-0.214012, 0.842834, 0.063566>, 
      <-0.265201, 0.670722, 0.112329>, <-0.252044, 0.693527, 0.094285>, <-0.186785, 0.825886, 0.101265>, <-0.176779, 0.847620, 0.080140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.295915, 0.646749, -0.378813>, <-0.279325, 0.670270, -0.359709>, <-0.176101, 0.727891, -0.263052>, <-0.167198, 0.743516, -0.233555>, 
      <-0.342037, 0.651683, -0.337000>, <-0.325448, 0.675205, -0.317896>, <-0.214172, 0.720544, -0.243213>, <-0.205269, 0.736169, -0.213716>, 
      <-0.493561, 0.630655, -0.100508>, <-0.487675, 0.654100, -0.102367>, <-0.373686, 0.676951, -0.079733>, <-0.353371, 0.690181, -0.079799>, 
      <-0.489668, 0.633694, -0.038254>, <-0.483781, 0.657139, -0.040112>, <-0.374948, 0.690663, -0.038413>, <-0.354633, 0.703894, -0.038479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.014939, 0.579710, -0.495716>, <0.017206, 0.619197, -0.463237>, <0.065759, 0.758745, -0.289384>, <0.046692, 0.781341, -0.247609>, 
      <-0.039010, 0.579687, -0.497253>, <-0.036743, 0.619174, -0.464774>, <0.031491, 0.754476, -0.286266>, <0.012424, 0.777073, -0.244491>, 
      <-0.256055, 0.642485, -0.414949>, <-0.239465, 0.666006, -0.395845>, <-0.145793, 0.733740, -0.278845>, <-0.136890, 0.749365, -0.249349>, 
      <-0.295915, 0.646749, -0.378813>, <-0.279325, 0.670270, -0.359709>, <-0.176101, 0.727891, -0.263052>, <-0.167198, 0.743516, -0.233555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.250824, 0.646981, -0.363234>, <0.228777, 0.665402, -0.353076>, <0.186389, 0.775178, -0.280665>, <0.162987, 0.784642, -0.263596>, 
      <0.225916, 0.637023, -0.398626>, <0.203869, 0.655444, -0.388467>, <0.170206, 0.777515, -0.289753>, <0.146804, 0.786979, -0.272684>, 
      <0.059330, 0.579729, -0.494451>, <0.061597, 0.619216, -0.461972>, <0.084247, 0.761047, -0.291066>, <0.065180, 0.783644, -0.249291>, 
      <0.014939, 0.579710, -0.495716>, <0.017206, 0.619197, -0.463237>, <0.065759, 0.758745, -0.289384>, <0.046692, 0.781341, -0.247609>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.327695, 0.704749, -0.051325>, <0.317944, 0.712472, -0.054797>, <0.303391, 0.743148, -0.110810>, <0.290819, 0.746089, -0.110518>, 
      <0.325630, 0.703357, -0.103259>, <0.315879, 0.711081, -0.106731>, <0.305631, 0.747245, -0.142829>, <0.293059, 0.750185, -0.142537>, 
      <0.279986, 0.658640, -0.321798>, <0.257940, 0.677061, -0.311640>, <0.214382, 0.771136, -0.264946>, <0.190979, 0.780600, -0.247877>, 
      <0.250824, 0.646981, -0.363234>, <0.228777, 0.665402, -0.353076>, <0.186389, 0.775178, -0.280665>, <0.162987, 0.784642, -0.263596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.274330, 0.662821, 0.227823>, <0.255335, 0.683840, 0.208129>, <0.167768, 0.730932, 0.094125>, <0.139101, 0.740972, 0.077758>, 
      <0.308064, 0.667455, 0.197249>, <0.289069, 0.688474, 0.177556>, <0.190663, 0.729209, 0.063187>, <0.161996, 0.739249, 0.046821>, 
      <0.329513, 0.705974, -0.005615>, <0.319762, 0.713697, -0.009087>, <0.300723, 0.738271, -0.072687>, <0.288151, 0.741212, -0.072395>, 
      <0.327695, 0.704749, -0.051325>, <0.317944, 0.712472, -0.054797>, <0.303391, 0.743148, -0.110810>, <0.290819, 0.746089, -0.110518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.114909, 0.643946, 0.349810>, <-0.115310, 0.679393, 0.316922>, <0.099467, 0.740924, 0.202853>, <0.090778, 0.761144, 0.159796>, 
      <-0.051309, 0.643015, 0.363424>, <-0.051710, 0.678462, 0.330536>, <0.114156, 0.735965, 0.202743>, <0.105467, 0.756185, 0.159685>, 
      <0.226380, 0.656234, 0.271281>, <0.207385, 0.677253, 0.251587>, <0.158555, 0.731626, 0.106574>, <0.129888, 0.741665, 0.090208>, 
      <0.274330, 0.662821, 0.227823>, <0.255335, 0.683840, 0.208129>, <0.167768, 0.730932, 0.094125>, <0.139101, 0.740972, 0.077758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.114909, 0.643946, 0.349810>, <-0.158880, 0.644590, 0.340397>, <-0.233966, 0.671577, 0.144673>, <-0.265201, 0.670722, 0.112329>, 
      <-0.115310, 0.679393, 0.316922>, <-0.159281, 0.680037, 0.307509>, <-0.220809, 0.694381, 0.126629>, <-0.252044, 0.693527, 0.094285>, 
      <0.099467, 0.740924, 0.202853>, <0.055360, 0.755816, 0.203186>, <-0.144545, 0.831316, 0.120069>, <-0.186785, 0.825886, 0.101265>, 
      <0.090778, 0.761144, 0.159796>, <0.046671, 0.776036, 0.160129>, <-0.134538, 0.853049, 0.098943>, <-0.176779, 0.847620, 0.080140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.399754, 0.524188, -0.024234>, <-0.392317, 0.545584, -0.023073>, <-0.495175, 0.611761, -0.036515>, <-0.489668, 0.633694, -0.038254>, 
      <-0.402404, 0.524534, 0.037087>, <-0.394967, 0.545929, 0.038248>, <-0.492466, 0.613875, 0.006808>, <-0.486959, 0.635809, 0.005070>, 
      <-0.421675, 0.505833, 0.315388>, <-0.407095, 0.549187, 0.291269>, <-0.316701, 0.632951, 0.110305>, <-0.295386, 0.669896, 0.081073>, 
      <-0.380452, 0.494606, 0.359456>, <-0.365873, 0.537960, 0.335338>, <-0.286517, 0.633777, 0.141561>, <-0.265201, 0.670722, 0.112329>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.345935, 0.490099, -0.439381>, <-0.341961, 0.517708, -0.438265>, <-0.309321, 0.627742, -0.394250>, <-0.295915, 0.646749, -0.378813>, 
      <-0.384674, 0.505282, -0.386987>, <-0.380700, 0.532891, -0.385871>, <-0.355443, 0.632677, -0.352437>, <-0.342037, 0.651683, -0.337000>, 
      <-0.396866, 0.523811, -0.091076>, <-0.389429, 0.545207, -0.089915>, <-0.499068, 0.608722, -0.098770>, <-0.493561, 0.630655, -0.100508>, 
      <-0.399754, 0.524188, -0.024234>, <-0.392317, 0.545584, -0.023073>, <-0.495175, 0.611761, -0.036515>, <-0.489668, 0.633694, -0.038254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.022430, 0.358719, -0.595231>, <0.024836, 0.397270, -0.595210>, <0.013228, 0.549908, -0.520229>, <0.014939, 0.579710, -0.495716>, 
      <-0.044622, 0.358399, -0.596453>, <-0.042216, 0.396950, -0.596433>, <-0.040721, 0.549885, -0.521766>, <-0.039010, 0.579687, -0.497253>, 
      <-0.307104, 0.474880, -0.491899>, <-0.303130, 0.502488, -0.490783>, <-0.269460, 0.623478, -0.430387>, <-0.256055, 0.642485, -0.414949>, 
      <-0.345935, 0.490099, -0.439381>, <-0.341961, 0.517708, -0.438265>, <-0.309321, 0.627742, -0.394250>, <-0.295915, 0.646749, -0.378813>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.510606, 0.494186, -0.423767>, <0.481326, 0.533296, -0.420457>, <0.286252, 0.617379, -0.379558>, <0.250824, 0.646981, -0.363234>, 
      <0.450736, 0.482706, -0.483289>, <0.421456, 0.521816, -0.479980>, <0.261344, 0.607421, -0.414950>, <0.225916, 0.637023, -0.398626>, 
      <0.107615, 0.359125, -0.593678>, <0.110021, 0.397677, -0.593658>, <0.057619, 0.549927, -0.518964>, <0.059330, 0.579729, -0.494451>, 
      <0.022430, 0.358719, -0.595231>, <0.024836, 0.397270, -0.595210>, <0.013228, 0.549908, -0.520229>, <0.014939, 0.579710, -0.495716>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.632239, 0.475654, 0.011042>, <0.600580, 0.528259, 0.007241>, <0.374140, 0.667960, -0.034789>, <0.327695, 0.704749, -0.051325>, 
      <0.640862, 0.480975, -0.060225>, <0.609203, 0.533580, -0.064026>, <0.372075, 0.666569, -0.086722>, <0.325630, 0.703357, -0.103259>, 
      <0.561188, 0.503885, -0.373478>, <0.531908, 0.542996, -0.370169>, <0.315414, 0.629038, -0.338122>, <0.279986, 0.658640, -0.321798>, 
      <0.510606, 0.494186, -0.423767>, <0.481326, 0.533296, -0.420457>, <0.286252, 0.617379, -0.379558>, <0.250824, 0.646981, -0.363234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.415280, 0.435364, 0.364093>, <0.408094, 0.480673, 0.350543>, <0.300665, 0.633680, 0.255126>, <0.274330, 0.662821, 0.227823>, 
      <0.463780, 0.443146, 0.319532>, <0.456594, 0.488455, 0.305982>, <0.334399, 0.638314, 0.224553>, <0.308064, 0.667455, 0.197249>, 
      <0.624294, 0.470752, 0.076703>, <0.592635, 0.523357, 0.072902>, <0.375958, 0.669185, 0.010922>, <0.329513, 0.705974, -0.005615>, 
      <0.632239, 0.475654, 0.011042>, <0.600580, 0.528259, 0.007241>, <0.374140, 0.667960, -0.034789>, <0.327695, 0.704749, -0.051325>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.094987, 0.389451, 0.504660>, <0.080251, 0.444987, 0.496379>, <-0.114427, 0.601392, 0.389292>, <-0.114909, 0.643946, 0.349810>, 
      <0.151028, 0.385279, 0.504987>, <0.136292, 0.440814, 0.496706>, <-0.050827, 0.600461, 0.402907>, <-0.051309, 0.643015, 0.363424>, 
      <0.374184, 0.428770, 0.401851>, <0.366997, 0.474079, 0.388302>, <0.252715, 0.627093, 0.298584>, <0.226380, 0.656234, 0.271281>, 
      <0.415280, 0.435364, 0.364093>, <0.408094, 0.480673, 0.350543>, <0.300665, 0.633680, 0.255126>, <0.274330, 0.662821, 0.227823>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.094987, 0.389451, 0.504660>, <0.014270, 0.395460, 0.504190>, <-0.326091, 0.479801, 0.417570>, <-0.380452, 0.494606, 0.359456>, 
      <0.080251, 0.444987, 0.496379>, <-0.000465, 0.450996, 0.495909>, <-0.311512, 0.523156, 0.393452>, <-0.365873, 0.537960, 0.335338>, 
      <-0.114427, 0.601392, 0.389292>, <-0.158398, 0.602036, 0.379880>, <-0.255282, 0.634631, 0.173905>, <-0.286517, 0.633777, 0.141561>, 
      <-0.114909, 0.643946, 0.349810>, <-0.158880, 0.644590, 0.340397>, <-0.233966, 0.671577, 0.144673>, <-0.265201, 0.670722, 0.112329>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.595427, 0.329434, -0.054767>, <-0.601265, 0.327236, 0.018146>, <-0.469346, 0.236542, 0.309874>, <-0.412173, 0.233676, 0.355461>, 
      <-0.610370, 0.284691, -0.045624>, <-0.616208, 0.282494, 0.027289>, <-0.467755, 0.215558, 0.303874>, <-0.410582, 0.212692, 0.349462>, 
      <-0.590741, 0.090679, 0.069080>, <-0.600209, 0.098535, 0.113978>, <-0.406940, 0.162049, 0.255755>, <-0.365064, 0.164280, 0.275970>, 
      <-0.555381, 0.058201, 0.070989>, <-0.564849, 0.066057, 0.115887>, <-0.396337, 0.149574, 0.241234>, <-0.354461, 0.151806, 0.261450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.595427, 0.329434, -0.054767>, <-0.581667, 0.370634, -0.063186>, <-0.414262, 0.482450, -0.026499>, <-0.399754, 0.524188, -0.024234>, 
      <-0.601265, 0.327236, 0.018146>, <-0.587505, 0.368437, 0.009727>, <-0.416912, 0.482796, 0.034821>, <-0.402404, 0.524534, 0.037087>, 
      <-0.469346, 0.236542, 0.309874>, <-0.472391, 0.276699, 0.321354>, <-0.433482, 0.470723, 0.334919>, <-0.421675, 0.505833, 0.315388>, 
      <-0.412173, 0.233676, 0.355461>, <-0.415218, 0.273832, 0.366942>, <-0.392259, 0.459496, 0.378988>, <-0.380452, 0.494606, 0.359456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.352119, 0.256284, -0.394596>, <-0.358261, 0.287454, -0.415328>, <-0.351336, 0.452580, -0.440898>, <-0.345935, 0.490099, -0.439381>, 
      <-0.405399, 0.267527, -0.354555>, <-0.411541, 0.298698, -0.375287>, <-0.390074, 0.467763, -0.388504>, <-0.384674, 0.505282, -0.386987>, 
      <-0.590035, 0.331464, -0.122111>, <-0.576275, 0.372664, -0.130530>, <-0.411374, 0.482073, -0.093341>, <-0.396866, 0.523811, -0.091076>, 
      <-0.595427, 0.329434, -0.054767>, <-0.581667, 0.370634, -0.063186>, <-0.414262, 0.482450, -0.026499>, <-0.399754, 0.524188, -0.024234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.352119, 0.256284, -0.394596>, <-0.405399, 0.267527, -0.354555>, <-0.590035, 0.331464, -0.122111>, <-0.595427, 0.329434, -0.054767>, 
      <-0.344273, 0.216467, -0.368113>, <-0.397553, 0.227710, -0.328072>, <-0.604978, 0.286721, -0.112968>, <-0.610370, 0.284691, -0.045624>, 
      <-0.283926, 0.108141, -0.196686>, <-0.324974, 0.112642, -0.153555>, <-0.578597, 0.080602, 0.011491>, <-0.590741, 0.090679, 0.069080>, 
      <-0.264581, 0.077227, -0.164773>, <-0.305630, 0.081728, -0.121642>, <-0.543237, 0.048124, 0.013400>, <-0.555381, 0.058201, 0.070989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008414, 0.205559, -0.495916>, <-0.000413, 0.230957, -0.508590>, <0.020593, 0.329286, -0.595247>, <0.022430, 0.358719, -0.595231>, 
      <-0.065980, 0.202467, -0.496064>, <-0.057979, 0.227865, -0.508738>, <-0.046459, 0.328966, -0.596469>, <-0.044622, 0.358399, -0.596453>, 
      <-0.306675, 0.246694, -0.428748>, <-0.312817, 0.277865, -0.449480>, <-0.312505, 0.437361, -0.493416>, <-0.307104, 0.474880, -0.491899>, 
      <-0.352119, 0.256284, -0.394596>, <-0.358261, 0.287454, -0.415328>, <-0.351336, 0.452580, -0.440898>, <-0.345935, 0.490099, -0.439381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008414, 0.205559, -0.495916>, <-0.065980, 0.202467, -0.496064>, <-0.306675, 0.246694, -0.428748>, <-0.352119, 0.256284, -0.394596>, 
      <-0.018234, 0.174387, -0.480360>, <-0.075801, 0.171295, -0.480507>, <-0.298829, 0.206877, -0.402265>, <-0.344273, 0.216467, -0.368113>, 
      <-0.080585, 0.026242, -0.449350>, <-0.130659, 0.023943, -0.442312>, <-0.249128, 0.104325, -0.233248>, <-0.283926, 0.108141, -0.196686>, 
      <-0.088375, 0.006991, -0.419704>, <-0.138449, 0.004692, -0.412666>, <-0.229784, 0.073411, -0.201335>, <-0.264581, 0.077227, -0.164773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.508710, 0.302518, -0.392385>, <0.441230, 0.299106, -0.444645>, <0.076882, 0.210140, -0.495697>, <-0.008414, 0.205559, -0.495916>, 
      <0.480769, 0.258331, -0.371578>, <0.413289, 0.254919, -0.423838>, <0.067061, 0.178968, -0.480141>, <-0.018234, 0.174387, -0.480360>, 
      <0.305248, 0.128292, -0.263201>, <0.260957, 0.128470, -0.310257>, <-0.016657, 0.029178, -0.458334>, <-0.080585, 0.026242, -0.449350>, 
      <0.262245, 0.101418, -0.238817>, <0.217953, 0.101597, -0.285873>, <-0.024448, 0.009926, -0.428689>, <-0.088375, 0.006991, -0.419704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.508710, 0.302518, -0.392385>, <0.524074, 0.326815, -0.403826>, <0.529106, 0.469475, -0.425858>, <0.510606, 0.494186, -0.423767>, 
      <0.441230, 0.299106, -0.444645>, <0.456593, 0.323403, -0.456087>, <0.469237, 0.457994, -0.485381>, <0.450736, 0.482706, -0.483289>, 
      <0.076882, 0.210140, -0.495697>, <0.084883, 0.235538, -0.508371>, <0.105778, 0.329692, -0.593694>, <0.107615, 0.359125, -0.593678>, 
      <-0.008414, 0.205559, -0.495916>, <-0.000413, 0.230957, -0.508590>, <0.020593, 0.329286, -0.595247>, <0.022430, 0.358719, -0.595231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.609322, 0.236794, -0.017509>, <0.631471, 0.268258, -0.016383>, <0.652050, 0.442735, 0.013421>, <0.632239, 0.475654, 0.011042>, 
      <0.623110, 0.241393, -0.078511>, <0.645258, 0.272857, -0.077385>, <0.660673, 0.448056, -0.057846>, <0.640862, 0.480975, -0.060225>, 
      <0.558250, 0.305023, -0.354018>, <0.573614, 0.329320, -0.365459>, <0.579689, 0.479174, -0.375570>, <0.561188, 0.503885, -0.373478>, 
      <0.508710, 0.302518, -0.392385>, <0.524074, 0.326815, -0.403826>, <0.529106, 0.469475, -0.425858>, <0.510606, 0.494186, -0.423767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.609322, 0.236794, -0.017509>, <0.623110, 0.241393, -0.078511>, <0.558250, 0.305023, -0.354018>, <0.508710, 0.302518, -0.392385>, 
      <0.573990, 0.186603, -0.019306>, <0.587778, 0.191202, -0.080308>, <0.530310, 0.260836, -0.333211>, <0.480769, 0.258331, -0.371578>, 
      <0.357188, 0.030672, -0.004868>, <0.344917, 0.027314, -0.043449>, <0.333092, 0.128179, -0.233620>, <0.305248, 0.128292, -0.263201>, 
      <0.301222, 0.005420, -0.005789>, <0.288951, 0.002062, -0.044370>, <0.290089, 0.101306, -0.209235>, <0.262245, 0.101418, -0.238817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.340382, 0.246366, 0.352365>, <0.400954, 0.240245, 0.312331>, <0.593302, 0.231450, 0.053371>, <0.609322, 0.236794, -0.017509>, 
      <0.340124, 0.221089, 0.341044>, <0.400696, 0.214968, 0.301009>, <0.557970, 0.181259, 0.051575>, <0.573990, 0.186603, -0.019306>, 
      <0.431007, 0.156122, 0.248088>, <0.460138, 0.147575, 0.211842>, <0.371470, 0.034580, 0.040035>, <0.357188, 0.030672, -0.004868>, 
      <0.412284, 0.142474, 0.232911>, <0.441415, 0.133927, 0.196665>, <0.315504, 0.009328, 0.039114>, <0.301222, 0.005420, -0.005789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.340382, 0.246366, 0.352365>, <0.340685, 0.275969, 0.365624>, <0.420153, 0.404638, 0.373282>, <0.415280, 0.435364, 0.364093>, 
      <0.400954, 0.240245, 0.312331>, <0.401257, 0.269848, 0.325589>, <0.468654, 0.412420, 0.328720>, <0.463780, 0.443146, 0.319532>, 
      <0.593302, 0.231450, 0.053371>, <0.615450, 0.262913, 0.054497>, <0.644106, 0.437833, 0.079082>, <0.624294, 0.470752, 0.076703>, 
      <0.609322, 0.236794, -0.017509>, <0.631471, 0.268258, -0.016383>, <0.652050, 0.442735, 0.013421>, <0.632239, 0.475654, 0.011042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.023854, 0.300778, 0.400981>, <-0.017423, 0.325676, 0.413996>, <0.102303, 0.361878, 0.508772>, <0.094987, 0.389451, 0.504660>, 
      <0.035312, 0.301776, 0.400738>, <0.041742, 0.326674, 0.413753>, <0.158344, 0.357706, 0.509098>, <0.151028, 0.385279, 0.504987>, 
      <0.291190, 0.251337, 0.384878>, <0.291493, 0.280940, 0.398137>, <0.379057, 0.398044, 0.411040>, <0.374184, 0.428770, 0.401851>, 
      <0.340382, 0.246366, 0.352365>, <0.340685, 0.275969, 0.365624>, <0.420153, 0.404638, 0.373282>, <0.415280, 0.435364, 0.364093>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.023854, 0.300778, 0.400981>, <0.035312, 0.301776, 0.400738>, <0.291190, 0.251337, 0.384878>, <0.340382, 0.246366, 0.352365>, 
      <-0.031764, 0.270152, 0.384972>, <0.027402, 0.271150, 0.384729>, <0.290932, 0.226060, 0.373556>, <0.340124, 0.221089, 0.341044>, 
      <0.023684, 0.112389, 0.373072>, <0.089700, 0.111585, 0.370615>, <0.390301, 0.168066, 0.298736>, <0.431007, 0.156122, 0.248088>, 
      <0.017316, 0.088720, 0.347459>, <0.083332, 0.087916, 0.345002>, <0.371578, 0.154417, 0.283559>, <0.412284, 0.142474, 0.232911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.023854, 0.300778, 0.400981>, <-0.031764, 0.270152, 0.384972>, <0.023684, 0.112389, 0.373072>, <0.017316, 0.088720, 0.347459>, 
      <-0.087037, 0.299713, 0.401241>, <-0.094946, 0.269087, 0.385232>, <-0.037881, 0.113138, 0.375364>, <-0.044249, 0.089469, 0.349751>, 
      <-0.362803, 0.231201, 0.394827>, <-0.361212, 0.210216, 0.388827>, <-0.309643, 0.167234, 0.302725>, <-0.299040, 0.154759, 0.288205>, 
      <-0.412173, 0.233676, 0.355461>, <-0.410582, 0.212692, 0.349462>, <-0.365064, 0.164280, 0.275970>, <-0.354461, 0.151806, 0.261450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.023854, 0.300778, 0.400981>, <-0.087037, 0.299713, 0.401241>, <-0.362803, 0.231201, 0.394827>, <-0.412173, 0.233676, 0.355461>, 
      <-0.017423, 0.325676, 0.413996>, <-0.080606, 0.324611, 0.414256>, <-0.365847, 0.271357, 0.406308>, <-0.415218, 0.273832, 0.366942>, 
      <0.102303, 0.361878, 0.508772>, <0.021586, 0.367888, 0.508301>, <-0.337898, 0.444691, 0.437102>, <-0.392259, 0.459496, 0.378988>, 
      <0.094987, 0.389451, 0.504660>, <0.014270, 0.395460, 0.504190>, <-0.326091, 0.479801, 0.417570>, <-0.380452, 0.494606, 0.359456>
    }
  }
  material {
    Material1
  }
  scale 0.15
  rotate <118.039688, -0.0, -29.219765>
  translate  <-1.244533, -5.518169, 0.064418>
}


