// Persistence of Vision Ray Tracer Scene Description File
// File: Ruins.pov
// Date: 20/02/20
// Auth: Mick Hazelgrove

#version unofficial MegaPov 0.4;

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
  max_trace_level 15
}

// ----------------------------------------

#declare Ground_on = 1;
#declare Grass_on = 1;
#declare Fog_on = 1;         
#declare Rocks_on = 1; 
#declare Statue_on = 1;
#declare Plants_on = 1;
$AtMosLights_on=1; 
$Raven_on=1;
                                   

//-----------------------------------------
camera {
	location <5.0, 5.0, -37>//was -37
	direction <-0.4, 0.0, 1>//x-.4
	up <0.0, 1.0, 0.0>
	right <1.25, 0.0, 0.5>
	angle 50.000
}

sky_sphere
{
  pigment
  {
    gradient y 
    color_map { [0.0 color rgb<.8,.5,.2>] [1.0 color  Gold+White] } 
  }
  rotate x*-20
}


light_source {  <20.5,9,35>color rgb <0.5, 0.2, 1> media_interaction off } 
light_source { <1000.0, 200.0, 50.0> color rgb <1,1,.875>/3 media_interaction off }

// ----------------------------------------

#if (Ground_on = 1)

//ground 

#declare GTex = texture{
	pigment {
		gradient y 
		pigment_map {
		[ 0.2 rgb <.2,.75,.1> ]
			[0.5 bozo color_map { 
                [0.0 rgb <.3,.1,0>*2]
                [0.25 rgb<.1,.05,0>*2] //t was .65
                [0.5 rgb <.5,.125,0>*2]
                [0.75 rgb <.2,.15,0>*2]//t was ./65 
                [1.0 rgb <.7,.3,0>*2]
            }
            turbulence 0.3
            scale <.0125,.05,.0125>/2 
          ]
		} // color_map 
		scale.5
		translate y*2.5
	} // pigment 
	   normal{
            gradient y normal_map{
                [0.4 bump_map{ gif "GBM4.gif" bump_size 2} rotate x*90 rotate y*45 scale .8 ]
                [1.0 bumps 15 scale .005]
                }//end of normal map
                 turbulence .2
                 scale.52  
              }//end of normal dec
}

height_field
{
	tga
	"gladehf.tga"
	smooth
        texture{GTex }
	translate <-.5, -0.827, -.5>
	scale <63.000, 24.650, 63.000> 
}

#end
 
//-----------------------------------------------
#if(Grass_on = 1)

#macro Reorient(Axis1,Axis2)
  #local vX1=vnormalize(Axis1);
  #local vX2=vnormalize(Axis2);
  #local vY=vnormalize(vcross(vX1,vX2));
#if (vlength(vY)>0)
  #local vZ1=vnormalize(vcross(vX1,vY));
  #local vZ2=vnormalize(vcross(vX2,vY));
  matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
  matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
#end
#end



#include"grass.inc"
#include"Gladepts3.inc"
#warning concat("starting grass ","\n")

#declare Rnd = seed(623);                      

#declare N = 1;
#while(N < HF_pts)
   #if(HF_pts_array[N].y>-2)
    object{Patch scale .00125+rand(Rnd)/3 
        Reorient(y,HF_pts_array[N-1])   
            translate HF_pts_array[N]
            translate y*-.25
            }//end obj
          #end//end if
	#declare N = N+36;     
#end

object{Patch translate<-14.5,-2.75,-53.75> scale.00125+rand(Rnd)/2}
object{Patch translate<-14.25,-2.75,-54> scale.00125+rand(Rnd)/2}
object{Patch translate<-14.75,-2.5,-53.5> scale.00125+rand(Rnd)/2}
object{Patch translate<-14.325,-2.5,-54> scale.00125+rand(Rnd)/2}
object{Patch translate<-14.25,-2.5,-54> scale.00125+rand(Rnd)/2}
#warning concat("grass parsed","\n")

#end
//-----------------------------------------
#if(Fog_on = 1)

#declare Mist =
material {
  texture {pigment {rgbf<1,1,1,1>}}
  interior {
    media {
    method 3
      emission rgb .2//was.2
      intervals 1
      samples 20, 20
      confidence 0.9999
      variance 1/1000
      density {
       planar
       scallop_wave 
       octaves 5
        turbulence .5
        color_map  {
          [0.0 color rgb <0, 0, 0>]
          [0.475 color rgb <1,1,0.5>]//<1.0,1.0,0.5>
          [0.525 color rgb <1,1,0.5>]//<1.0,1.0,0.5>
          [1.0 color rgb <0, 0, 0>]
        }//cm 
        translate -0.5*y
        scale 3//scale 3
       }//density
       }//media
  }//interior
  }//material

#declare Mist2 =
material {
  texture {pigment {rgbf<1,1,1,1>}}
  interior {
    media {
    method 3
      emission rgb .3
      intervals 1
      samples 10, 10
      confidence 0.9999
      variance 1/1000
      density {
       planar
       scallop_wave 
       octaves 5
        turbulence .5
        color_map  {
          [0.0 color rgb <0, 0, 0>]
          [0.45 color rgb <1,1,.5>]
          [0.5 color rgb <0.5, 0.3, 0.85>*2]//<1,1,0.5>]
          [0.55 color rgb <1,1,0.5>]
          [1.0 color rgb <0, 0, 0>]
        }//cm 
        translate -0.5*y
        scale 3//scale 6
       }//density
       }//media
  }//interior
  }//material
    

box{ //sky
  <-80, 0, -40>
  < 80,  5,  3000>  
  material {Mist scale <2,1,1>} 
  rotate y*30
  rotate x*20  
  translate 10*y
  translate z*-25 
  hollow on
}
box{ //low
  <-30, 0, -50>
  < 30,  2,  0>  
  material {Mist2 scale <2,1,1>} 
  translate -1*y  
  hollow on
}

#end      
                                                                                                          
//-------------------------------------------------

#if(Rocks_on = 1)

#include"roadhfpts.inc"
#include"rck1.inc"
#include"rck2.inc"
#include"rck3.inc"
#declare RDTex = texture{
    pigment{
            granite color_map {
                [0.0 rgb <.3,.1,0>*3]
                [0.25 rgb<.1,.3,0>*3] 
                [0.5 rgb <.5,.125,0>*2]
                [0.55 rgb<.5,1,.2>]
                [0.75 rgb <.2,.15,0>*3]
                [1.0 rgb <.7,.3,0>*2]
            }//end col map
            turbulence 0.3
            scale .0125
            }//end pigment
         normal{
            average normal_map{
                [0.4 bumps 5 turbulence .3 scale.0125]
                [0.6 dents 3 scale .05]
                [1.0 bumps 15 scale .15]
                }//end of normal map
                 turbulence .2
                 scale.52  
              }//end of normal dec
       }//end tex
            	
#declare RockTex = texture{
	    pigment { Wheat }
	      normal{
            average normal_map{
                [0.0 bumps 15 scale 0.01 ]
                [0.3 dents 10 scale 0.002]
                [0.6  granite 10 scale 0.001]
                [1.0 wrinkles 15 scale .1 ramp_wave]
                }//end of normal map  
              }//end of normal dec
	       finish{specular .25 ambient .3}
	    }//end of texture
texture{ 
  pigment {
    bozo
    turbulence .5
    frequency 3
    lambda 6
    color_map{
      [0.5 rgbt 1]
      [0.65 rgbt <.5,.3,.2,.6>]
      [0.7 rgb <.1,.3,0>]
      [0.85 rgb <.5,.3,0>*2.5]
      [0.9 rgb <.4,.5,0>]
    }
    scale 1.25
  }
  normal{granite 15 scale 0.01}
  translate y*.2
}

#declare Path = union{

height_field
{
	tga
	"road.tga"
	smooth
        texture{RDTex}
	translate <-.5, -1.25, -.5>
	scale <30.0, 1.5, 50.0> 
}
   
#declare Rd = seed(735);
                      
#warning concat("starting rocks ","\n")

#declare N = 1;
#while(N < rHF_pts)
   #declare XP =(rHF_pts_array[N].x/63)*30;
   #declare YP =(rHF_pts_array[N].y/63)*1.5; 
   #declare ZP =(rHF_pts_array[N].z/63)*50 ; 

   #declare SS1=.00025+rand(Rd)/200;
    object{rock1 rotate z*90 scale SS1 texture{RockTex}
       rotate y*rand(Rd)*360    
            translate <XP,YP,ZP> 
            translate y*-(SS1+1.5)
            }//end obj

	#declare N = N+(rand(Rd)*3) ;       
#end

#declare N = 1;
#while(N < rHF_pts)
   #declare XP =(rHF_pts_array[N].x/63)*30; 
   #declare YP =(rHF_pts_array[N].y/63)*1.5;
   #declare ZP =(rHF_pts_array[N].z/63)*50 ;
   
   #declare SS2=.00075+rand(Rd)/100;
    object{rock2 rotate z*90 scale SS2 texture{RockTex}
        rotate y*rand(Rd)*360    
            translate <XP,YP,ZP> 
            translate y*-(SS2+1.5)
            }//end obj

	#declare N = N+(30+(rand(Rd)*10));       
#end

#declare N = 1;

#while(N < rHF_pts)
   #declare XP =(rHF_pts_array[N].x/63)*30; 
   #declare YP =(rHF_pts_array[N].y/63)*1.5;
   #declare ZP =(rHF_pts_array[N].z/63)*50 ;
   
   #declare SS3=.0025+rand(Rd)/100;
    object{rock3 rotate z*90 scale SS3 texture{RockTex}
        rotate y*rand(Rd)*360   
            translate<XP,YP,ZP> 
            translate y*-(SS3+1.5)
            }//end obj

	#declare N = N+(50+(rand(Rd)*10));
       
#end
}
object{Path 
//rotate x*-90
}
#warning concat("rocks parsed","\n")

#end

//----------------------------------------------
#if(Statue_on = 1)

#declare StatueTex = texture{
	    pigment { Wheat }
	      normal{
            average normal_map{
                [0.0 bumps 5 scale 0.01 ]
                [0.3 dents 3 scale 0.002]
                [0.6  granite 10 scale 0.001]
                [1.0 wrinkles 5 scale .1 ramp_wave]
                }//end of normal map  
              }//end of normal dec
	       finish{specular .25 ambient .3}
	    }//end of texture
texture{ 
  pigment {
    bozo
    turbulence .5
    frequency 3
    lambda 6
    color_map{
      [0.5 rgbt 1]
      [0.65 rgbt <.5,.3,.2,.6>]
      [0.7 rgb <.1,.3,0>]
      [0.85 rgb <.5,.3,0>*2.5]
      [0.9 rgb <.4,.5,0>]
    }
    scale 1.25
  }
  normal{granite 15 scale 0.005}
  translate y*.2
}

#include"head2.inc"
#include"body.inc"

#declare Sstone = union{
object{head2 
rotate y*180 
rotate x*100 
scale <1,1,.6>/12

translate <0,3,-.05> 
}

object{body scale <.2,.2,.4> 
        rotate x*-90 
        rotate y*180
        translate y*-2
        }
}

object{Sstone  texture{StatueTex}//left
scale <.7 ,.9,.7>*1.25
rotate y*-60
rotate z*15
translate<-13.5,3,-16.25>
} 

object{Sstone  texture{StatueTex}//right
scale <.7 ,.9,.7>*1.25
rotate y*-60
rotate y*180
rotate z*-12
translate<4.125,3,-17>
}
$ Tower = union{
$StoneCirc=union{
$Rad=12.1;
$Angle=0;

    #while(Angle<390)
          object{Sstone scale <.7 ,.9,.7>texture{StatueTex}  rotate y*180
            translate<0,0,Rad>
                rotate x*-10
                rotate y*Angle
                }
                $Angle = Angle+30;
   #end//loop 
}//end union
$StoneCirc2=union{
$Rad=10.45;
$Angle=180;

    #while(Angle<390)
          object{Sstone scale <.7 ,.9,.7>texture{StatueTex}  rotate y*180
            translate<0,0,Rad>
                rotate x*-10
                rotate y*Angle
                }
                $Angle = Angle +30;
   #end//loop 
}//end union
$StoneCirc3=union{
$Rad=8.95;
$Angle=250;

    #while(Angle<330)
          object{Sstone scale <.7 ,.9,.7>texture{StatueTex}  rotate y*180
            translate<0,0,Rad>
                rotate x*-10
                rotate y*Angle
                }
                $Angle = Angle+30;
   #end//loop 
}//end union

object{StoneCirc translate<-22,2,35>}
object{StoneCirc2 translate<-22,11.5,35>}
object{StoneCirc3 translate<-22,21,35>}

#include"beam.inc" 

$BeamCirc=union{
$Rad=11.25; //was 10.5
$Angle=15;

    #while(Angle<405)
          object{beam scale <1.75 ,.6,.6>texture{StatueTex} 
            translate<0,0,Rad>
                rotate x*-10
                rotate y*Angle
                }
                $Angle = Angle+30;
   #end//loop 
}//end union
$BeamCirc2=union{
$Rad=9.15;
$Angle=195;

    #while(Angle<375)
          object{beam scale <1.65 ,.6,.6>texture{StatueTex}
            translate<0,0,Rad>
                rotate x*-10
                rotate y*Angle
                }
                $Angle = Angle +30;
   #end//loop 
}//end union
$BeamCirc3=union{
$Rad=8.1;
$Angle=265;

    #while(Angle<315)
          object{beam scale <1.55 ,.6,.6>texture{StatueTex}
            translate<0,0,Rad>
                rotate x*-10
                rotate y*Angle
                }
                $Angle = Angle+30;
   #end//loop 
}//end union
object{BeamCirc translate<-22,6,35>}
object{BeamCirc2 translate<-22,15.5,35>}
object{BeamCirc3 translate<-22,25,35>}

object{body  scale<.2,.2,.4>scale<.7 ,.9,.7>texture{StatueTex} 
         rotate x*-100
        translate<-32.5,25,75>
        }
}//end Tower

object{Tower rotate y*-7.5 }

object{Sstone  texture{StatueTex}
scale <.7 ,.9,.7>*1.25
rotate y*-60
rotate z*170
translate<-10.5,2,35>
}
$Tripod=union{
$Rs=1.85;
$Ag =5;
    #while(Ag<375)
        object{Sstone texture{StatueTex}
            scale <.5 ,1.1,.6>*1.25
                rotate y*180
                rotate x*-7
                    translate<0,0,Rs> 
                    rotate y*Ag }
        $Ag=Ag+120;
    #end
}//end union

object{Tripod rotate y*-10translate<-20.5,7,35>}

#declare Egg = difference{

sphere{0,1.25  scale<1,1.5,1>
    pigment{rgbf<0.125, 0 ,1,.9>}
        finish{phong 1 phong_size 90 reflection .2}
            interior{ior 1.5 
            dispersion 1.1 disp_nelems 7}
        }        

height_field{
	tga
	"gladehf.tga"     
 inverse 
    pigment{rgbf<1, .8 ,.9,.9>}
        finish{phong 1 phong_size 90 reflection .2}
            scale <4,1.5,5>
                rotate x*-30
                    translate <-1.5,-1.25,-1.5>
            }

}//end diff

object{Egg 
translate<-20.5,13.75,35> 
}

#declare Egg2 = difference{

sphere{0,1.25  scale<1,1.5,1>
    pigment{rgbf<0.125, 0 ,1,.9>}
        finish{phong 1 phong_size 90 reflection .2}
            interior{ior 1.5 
            dispersion 1.1 disp_nelems 7}
        }        

height_field{
	tga
	"gladehf.tga"     
    pigment{rgbf<.9, .6 ,1,.9>}
        finish{phong 1 phong_size 10 reflection .2}
            scale <4,1.5,5>
                rotate x*-30
                    translate <-1.5,-1.25,-1.5>
            }

}//end diff 

object{rock1 scale 000001/200 scale <1.325,.8,1.25>texture{RockTex}translate<.25,-.75,-11.125>}

object{Egg2
    rotate z*15
    rotate x*-195
    rotate y*110 
        translate<-1,1,-11>
    }
   
object{Egg2 scale.7
rotate x*90
rotate y*-15
        translate<-4.5,-.6,-19>
    }
        
#end

//------------------------------------------------ 
#if (Plants_on = 1)
#include"Gladepts3.inc"

#include"snapdragon.inc"
#include"buttercup.inc"
#include"Fern.inc"



//right
object{snapdragon scale 0.125/4 rotate z*5 translate<4.5,-3,-17.5>}
object{snapdragon scale 0.1/4 rotate z*15 translate<3.75,-3,-18.5>}
object{snapdragon scale 0.15/4 translate<5,-3,-19>}//near
//front
object{snapdragon scale 0.15/4 rotate y*180 translate<-6,-3,-28>}
object{snapdragon scale 0.125/4 rotate z*10 rotate y*180 translate<-6,-3,-28>}
//mid back
object{snapdragon scale 0.15/4 rotate z*5 rotate y*180 translate<-10,-1.375,-10>}
object{snapdragon scale 0.125/4 rotate z*15 rotate y*180 translate<-10.5,-1.4,-10>}
object{snapdragon scale 0.15/4 rotate y*180 translate<-7.5,-3,-10>}

object{buttercup scale 0.15/6 translate<-11,-1,-16>} 
object{buttercup scale 0.15/6 rotate y*45 translate<2,-1,-19>} 
object{buttercup scale 0.125/6 rotate x* 5 rotate y*135 translate<-3,-1,-10.5>}


object{fern scale 0.15/3 rotate y*-100 translate<5,-1,-19>}//right 
object{fern scale 0.15/3 rotate y*-90 translate<-8,0.25,-12>}
object{fern scale 0.15/3 rotate y*-150 translate<-14,0.5,-10>}//<-12,1.75,-14>
object{fern scale 0.15/3 rotate y*-175 translate<-27,1.5,-6>}
object{fern scale 0.15/4 rotate y*-30 translate<-4.125,2,-1>}
object{fern scale 0.15/4 rotate y*-175 translate<-4.125,2.25,-1>}
object{fern scale 0.15/4 rotate y*-80 translate<6,2.75,-1>} //far right

object{fern scale 0.15/4 rotate y*-130 translate<-1.5,-1.5,-26>}
object{fern scale 0.15/4 rotate y*-30 translate<-1.5,-1.5,-26>}
object{fern scale 0.15/4 rotate y*-30 translate<-5.25,-1.125,-27>}
object{fern scale 0.15/4 rotate y*-30 translate<-6.25,-1.5,-25>}


#end

//-------------------------------------------
#if (AtMosLights_on =1)

box{<-100,0,-100><100,100,100> 
pigment {color rgbt 1}
    interior{
        media{
          method 3
            scattering{5, <0.09,0.09,0.08> 
                extinction .01}
                    samples 15, 25 
                          intervals 10
                                ratio .999
                                    confidence .9
                                        variance 1/1000
  
  } 
 }
 hollow on 
}



#declare R = seed(7823); 
#declare Rd=.25;
$Rd2=15;
#declare Ang = 0;

#declare Rays = union{

#while(Ang<360)
light_source
{<0, 100,Rd>
  color rgb <.025,.025,.0125>*2*(rand(R)*3)
  spotlight cylinder
  point_at <0, -10, Rd2>
    $Rads= 2*(rand(R)*2);  
        #if( Rads>1)
            radius Rads
        #else
            radius 1.5
        #end    
  tightness 3    
  falloff 10   
  media_attenuation on
  rotate y*Ang 
}
      #declare Ang = Ang+(30+rand(R)*10);
#end 

}    

#declare Rnd = seed(1265); //center left 
#declare Rad=.35;
$Rad2=30;
#declare Angle = 0;

#declare Rays2 = union{

#while(Angle<360)
light_source
{<0, 100,Rad>
  color rgb <.0275,.0275,.0275>*(3*(rand(Rnd)*3))
  spotlight cylinder
  point_at <0, -10, Rad2>   
  radius 2 *(rand(Rnd)*2)
  tightness 3 //lower softer
  falloff 10 //must be bigger than radius
 fade_distance 45 //50 works 20 no beam
  fade_power 2  
  media_attenuation on
  rotate y*Angle 
}
      #declare Angle = Angle+(30+rand(Rnd)*10);
#end
} 

box{<-100,0,-100><100,100,100> 
pigment {color rgbt 1}
    interior{
        media{
          method 3
            scattering{5, <0.09,0.09,0.08> 
                extinction .01}
                    samples 15, 25 
                          intervals 10
                                ratio .999
                                    confidence .9
                                        variance 1/1000
  
  } 
 }
 hollow on
}

object{Rays translate <-18.25,0,25>}
object{Rays2 translate <-18.25,0,25>}

#end
//--------------------------------------------------

#if(Raven_on = 1)

#include"raven2.inc"

object{Raven2 scale .005 
    pigment{
            wood color_map {
                [0.0 rgb 0]
                [0.25 rgb<0,.5,0>] 
                [0.5 rgb 0]
                [0.75 rgb<0,0,1>]
                [1.0 rgb 0]
            }//end col map
            turbulence 0.125
            scale .01  
            rotate x*90
            }//end pigment
    normal{wood 2 scale .01 turbulence .125 rotate x*90}
        finish{
          diffuse .7
          ambient .1
          specular 1 
          roughness .1
          irid {
          0.25
          thickness .125
          turbulence .3
        }
         metallic 1
        }
rotate x*-20
rotate y*-15
translate<5,8.25,-17.5>

}
sphere{0,.03 translate<4.6,8.8,-17.6> pigment{rgb<2,1,0>}
finish{specular 3 roughness.005}
}

#include"raven.inc"

object{Raven scale .0075 
    pigment{Black}
    normal{wood 2 scale .01 turbulence .125 rotate x*90}
        finish{
         diffuse .7
          ambient .1
          specular 1 
          roughness .1
          reflection .125
         metallic 1
        }
rotate x*-20
rotate y*-15
translate<-36.55,28.275,32>
}

#include"raven4.inc"

object{Raven4 scale .0075 
    pigment{Black}
    normal{wood 2 scale .01 turbulence .125 rotate x*90}
        finish{
         diffuse .7
          ambient .1
          specular 1 
          roughness .1 
          reflection .125
         metallic 1
        }
rotate y*180
 rotate x*180
 rotate x*-85
 rotate y*20
 //rotate z*12

translate<-9,10,35>
}

#end 
   
//EOF                        