// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: 
// Date: 
// Auth: 




//******************************** HEADER *************************************
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "coulphil.inc"
#version unofficial MegaPov 0.4;


//****************** ACTION **********************
#declare evier =  union
{
    difference
        {
        superellipsoid
           {<0.05, 0.05>
                scale <0.4,0.075,0.2>
                translate <0.4,0.075,-0.2>
                texture {Plastique_Bl}
           }
/*
        box {<0.0, 0.0, -0.4>,<0.6, 0.15, 0.0>
                texture {Plastique_Bl}
            } */
        box {<0.03,0.03,-0.37>,<0.77,0.8,0.5>
                texture {Plastique_Bl}
            }
        }
        cylinder {0.015*x,0.785*x,0.015        
                translate <0,0.15,-.385>
                texture {Plastique_Bl}
            }
        sphere {<0.015, 0.0, 0.015>, 0.015
                translate <0,0.15,-.4>
                texture {Plastique_Bl}
            }
        sphere {<0.0, 0, 0>, 0.015
                translate <0.785,0.15,-.385>
                texture {Plastique_Bl}
            }
        cylinder {0*z,-0.385*z,0.015        
                translate <0.015,0.15,0>
                texture {Plastique_Bl}
            }
        cylinder {0*z,-0.385*z,0.015        
                translate <0.785,0.15,0>
                texture {Plastique_Bl}
            }
translate 0.65*y            
} // Fin evier 
// *********************************************************************
#declare Muret_evier1 =
box {<0.0,0,0>,<0.1,0.65,-0.35>
 }
 #declare Muret_evier = union
 {
 object {Muret_evier1 
                 texture {
                        pigment
                                {
                                brick      color Gray, color Rouge_Brique
                                brick_size <2,1,1>   // size of brick
                                mortar     0.2       // width of mortar
                                scale 0.2
                                }
                        normal 
                                {                           
                                brick
                                brick_size <2,1,1>   // size of brick
                                mortar     0.2       // width of mortar
                                scale 0.2
                                }
                         rotate 90*y       
                         scale 0.5
                        }
translate 0.05*x
 }
 object {Muret_evier1 
                 texture {
                        pigment
                                {
                                brick      color Gray, color Rouge_Brique
                                brick_size <2,1,1>   // size of brick
                                mortar     0.2       // width of mortar
                                scale 0.2
                                }
                        normal 
                                {                           
                                brick
                                brick_size <2,1,1>   // size of brick
                                mortar     0.2       // width of mortar
                                scale 0.2
                                }
                         rotate 90*y       
                         translate 0.6*z
                         scale 0.5
                        }
translate 0.65*x}
 
 }
// Robinet ********************************
#declare Robinet =
union {
blob
{
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
  sphere { < 0,   0,    0> 0.035, 1.0 }
  cylinder { 0*z, -0.05*z, 0.025, 1.0 }
  cylinder {<0,0,0>,<0,0.0,0.1>,0.025, 1.0}

  // [sturm]
  scale 2
} 
intersection {        
        torus {0.1,0.025
              }
        box   {<-1,-1,0>,<0,1,-1>
              }
               rotate -90*z
               translate <0,-0.1,-0.085>
             }
cylinder {<0,0,0>,<0,0.12,0>,0.01}

blob
{
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
  sphere { < 0,   0,    0> 0.025, 1.0 }
  sphere { < 0.025,   0,    0> 0.0125, 1.0 }
  sphere { < 0.025,   0,    0> 0.0125, 1.0 rotate 120*y}
  sphere { < 0.025,   0,    0> 0.0125, 1.0 rotate -120*y}
  cylinder { 0*x, 0.025*x, 0.005, 1.0 }
  cylinder { 0*x, 0.025*x, 0.005, 1.0  rotate 120*y}
  cylinder { 0*x, 0.025*x, 0.005, 1.0  rotate -120*y}
  
  // [sturm]
  scale 2
  translate 0.12*y
}
cylinder {<0,0,0>,<0,0.05,0>,0.025}
cylinder {<0,0,0>,<0,0.06,0>,0.02}

translate -0.1*z
    texture {T_Brass_5A}
    
}
// Fin Robinet ********************************

// Casserole ***********************************
#declare Casserole =    // Fond et Centre de la casserole en <0,0,0>   manche en +x
union {
   difference {
        cylinder {0*y, 0.12*y ,0.1
                
                 }
        cylinder {0.001*y, 0.2*y ,0.099
                
                 }
        texture {Brushed_Aluminum rotate 90*z scale 0.1}
           }

   difference { // Manche de la casserole
        blob
           {
           threshold 0.6
           cylinder {<0.1, 0, 0>,<0.2, 0.0, 0.0>,0.025, 1.0}
           sphere { < 0.2, 0, 0> 0.035, 1.0 }
           sphere { < 0.175, 0, 0> 0.035, 1.0 scale <0.45,3,1>}
           scale <1.4,0.4,1.2>
           rotate 15*z
           translate <-0.01,0.06,0>
           //texture {}
           } 
        union {
                cylinder {0*y, 0.12*y ,0.1
                         }
                cylinder {0*y, 0.2*y ,0.0075
                        translate <0.27,0,0>
                         }
              }
             texture {T_Chrome_1A}
            }
}
// Fin Casserole *******************************



