// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc:   Huis.inc  Diffrentes fentres et porte
// Date: 
// Auth: 


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "coulphil.inc" // Mes couleurs
#include "MYTEXTUR.INC" // Mes textures
#include "glass.INC"
#include "metals.inc"
//#include "GOLDS.INC"
//#include "woods.inc"
//#include "skies.inc"
#include "newior.inc"
//#include "consts.inc"                  // Index of refraction constants
#version unofficial MegaPov 0.4;


/*
background {color Bleu_Nuit}



light_source
{
  <20,50,-30>
  color Blanc*2
  // looks_like { sphere { 0*x, 8 pigment { Bleu_Clair } finish{ambient 1.0}} }
//  media_attenuation on

}

light_source {0*x color Or2 translate <-2, -50, -20.1> }
//light_source {0*x color Or2 translate <-20, 50, 0.1> }

#declare F_Glass3 =
finish  {
    ambient 0.05
    diffuse 0.3
    reflection 0.8
    specular 0.8
    roughness 0.003
    phong 1
    phong_size 400
}

#declare T_Glass3 =
texture {
    pigment { color rgbf <0.98, 0.98, 0.98, 0.8> }
    finish { F_Glass3 }
}
*/

// montants externe vertical
#declare T_Montant_fenetre =
texture {pigment {Vert_Pale}
        }


#declare Montant_externe_Vertical =
box {<-0.05,-0.05,-0.025>,<0.05,2.05,0.025>
        texture {T_Montant_fenetre}
        }

#declare Montant_externe_Horizontal =
box {<-0.05,-0.05,-0.025>,<1.05,0.05,0.025>
        texture {T_Montant_fenetre}
        }

#declare Montant_central_V = union {
        box {<0.45,-0.05,-0.025>,<0.55,2.05,0.025>
        texture {T_Montant_fenetre}
        }
        box {<0.475,-0.05,-0.0275>,<0.525,2.05,0.0275>
        texture {T_Montant_fenetre}
        }
}

#declare poigne_fenetre = union {
        superellipsoid
                {
                <0.5, 1.0> 
                scale <0.02,0.07,0.01>
                }
        cylinder {0.07*z,0*z,0.01}
  texture {T_Chrome_2D}
}

#declare Montant_central_H = 
box {<-0.04,-0.01,-0.01>,<1.04,0.01,0.01>
        texture {T_Montant_fenetre}
        }

#declare T_Glass3 =
texture {
    pigment { color rgbf <0.98, 0.98, 0.98, 0.9> }
    finish { F_Glass3 }
}

#declare Vitre =
box {<-0.04,-0.04,-0.005>,<1.04,2.04,0.005>
        texture {T_Glass3}
        interior{ior Crown_Glass_Ior_1}
}

#declare Vitre_cassee = union
{
  difference
     {
      box {<-0.04,-0.04,-0.005>,<1.04,2.04,0.005>
           texture {T_Glass3}
           interior{ior Crown_Glass_Ior_1}
          }
      cylinder {<-0.45,0,-1>,<-0.45,0,1>,0.8
           texture {T_Glass3}
           interior{ior Crown_Glass_Ior_1}
          }
     } // Diff1  
  intersection {
     difference
        {
         box {<-0.04,-0.04,-0.005>,<0.4,0.4,0.005>
              texture {T_Glass3}
              interior{ior Crown_Glass_Ior_1}
             }
         cylinder {<0.65,0.3,-1>,<0.65,0.3,1>,0.5
              texture {T_Glass3}
              interior{ior Crown_Glass_Ior_1}
             }
        } // Diff2
     cylinder {<0.5,-0.1,-1>,<0.5,-0.1,1>,0.53
              texture {T_Glass3}
              interior{ior Crown_Glass_Ior_1}
             }
     } // Fin Intersection    
} // Fin union


#declare Grande_fenetre = union {
object {Montant_externe_Vertical}
object {Montant_externe_Vertical translate 1*x}
object {Montant_externe_Horizontal}
object {Montant_externe_Horizontal translate 2*y}
object {Montant_central_V}
object {Montant_central_H translate 1.3333*y}

object {poigne_fenetre translate <0.5,1,-0.07>}
object {Vitre}
}

#declare Grande_fenetre_cassee = union {
object {Montant_externe_Vertical}
object {Montant_externe_Vertical translate 1*x}
object {Montant_externe_Horizontal}
object {Montant_externe_Horizontal translate 2*y}
object {Montant_central_V}
object {Montant_central_H translate 1.3333*y}

object {poigne_fenetre translate <0.5,1,-0.07>}
object {Vitre_cassee}
}
// **********************************************************
#declare poigne_porte = union {
        superellipsoid
                {
                <0.5, 1.0> 
                scale <0.1,0.03,0.02>
                }
        cylinder {0.07*z,0*z,0.02 translate 0.08*x}
  texture {T_Chrome_2D}
}

#declare T_Montant_Porte =
texture {pigment {Vert_Pale2}
                finish {Plastic}
        }
//------------- Battant Porte
#declare Porte_Classe = union {
difference {
union {
        box {<0.1,0.01,-0.025>,<0.90,2.00,0.025>
                texture {T_Montant_Porte}
            }// Battant porte

// ------------- Montant de la porte --------------
        box {<0.0,0.00,-0.025>,<0.095,2.00,0.025>
                texture {T_Montant_Porte}
            }// 
        box {<0.905,0.00,-0.025>,<1.0,2.00,0.025>
                texture {T_Montant_Porte}
            }// 
        box {<0.0,2.005,-0.025>,<1.0,2.105,0.025>
                texture {T_Montant_Porte}
            }// 
        object {poigne_porte translate <0.75,1.0,-0.10>}
}
union {
        box {<0.2,1.2,-0.035>,<0.80,1.90,-0.022>
                texture {T_Montant_Porte}
            }// Battant porte
        box {<0.2,0.3,-0.035>,<0.80,0.80,-0.022>
                texture {T_Montant_Porte}
            }// Battant porte
}
}
        box {<0.3,1.3,0.0>,<0.70,1.80,-0.025>
                texture {T_Montant_Porte}
            }// Battant porte
        box {<0.3,0.4,0.0>,<0.70,0.70,-0.025>
                texture {T_Montant_Porte}
            }// Battant porte

}
// ----------------------------------------------

/*

object {Porte_Classe}

object {Grande_fenetre}

*/