//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 80 materials and 8 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 02/29/2000    (29.02.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <   -182.295,    -194.777,     -27.159>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34062,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         22.00000    // Vertical      16.500
  look_at   <    -15.990,       0.304,     -23.500>
}

//
// *******  L I G H T S *******
//

light_source {   // Light004
  <0.0, 0.0, 0.0>
  color rgb <0.500, 0.514, 0.414>*0.4000
  shadowless
  translate  <-23.589676, -97.607215, -44.659833>
}

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <0.271, 0.286, 0.300>*0.2000
  translate  <-29.977985, 16.530751, -27.994917>
}

light_source {   // Light002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.857, 0.700>*2.0000
  fade_distance  0.1
  fade_power 0.1
  translate  <373.067156, -1353.331398, 607.29908>
}


//
// ********  MATERIALS  *******
//

#include "cas_arth.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

plane { // ground
  z,0
  material {
    grey_1
  }
  translate  <4.555255, 136.89108, -50.0>
}


#declare HgtFld001 = object { 
  height_field {
    gif "C:\PROGRAM FILES\MORAY FOR WINDOWS\Maps\grass2.gif"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    fence_2
    rotate -1.0*x
  }
  scale <96.631042, 100.0, 1.0>
  translate  <-17.820834, -25.734184, -50.621765>
}
difference { // muddy_ground
  object { HgtFld001 }
  sphere { // Sphere1418
    <0,0,0>,1
    material {
      fence
    }
    scale <5.71014, -5.710136, 5.71014>
    translate  <-8.952563, -23.266957, -45.628925>
  }
  sphere { // Sphere1419
    <0,0,0>,1
    material {
      fence
    }
    scale 5.71014
    translate  <-60.000355, -51.270774, -45.628925>
  }
  sphere { // Sphere1420
    <0,0,0>,1
    material {
      fence
    }
    scale <-4.0, -3.0, -5.710136>
    rotate -180.0*z
    translate  <-76.896976, -29.571078, -45.628925>
  }
}








