// rock.inc
// Simple rocks made by rotating and scaling superellipsoids
// Note that the y1 value is the bottom of the rock, not the centre

#ifndef (RockSeed)
    #declare RockSeed = seed(9201);
    #declare RockSmall = 0.01;
    #declare RockBig = 0.08;
#end

#macro Rock(x1,y1,z1)
superellipsoid { <0.7 + 0.2*rand(RockSeed), 0.7 + 0.2*rand(RockSeed)>
    rotate <rand(RockSeed)*180,rand(RockSeed)*180,rand(RockSeed)*180>
    translate <0,1,0>
    scale <RockSmall+rand(RockSeed)*RockBig,
           RockSmall+rand(RockSeed)*RockBig,
           RockSmall+rand(RockSeed)*RockBig>
    texture {
        pigment { bozo
            colour_map {
                [0.0 rgb <1,0.8,0.5>]
                [1.0 rgb <0.7,0.4,0.2>]
            }
            turbulence 0.5
            scale RockSmall+rand(RockSeed)*RockBig
        }
        normal { crackle 0.2
            scale RockSmall+rand(RockSeed)*RockBig
        }
    }
    translate <x1,y1,z1>
}
#end // macro Rock

#macro Rock2(x1,y1,z1,SizeX,SizeY,SizeZ)
superellipsoid { <0.7 + 0.2*rand(RockSeed), 0.7 + 0.2*rand(RockSeed)>
    rotate <rand(RockSeed)*180,rand(RockSeed)*180,rand(RockSeed)*180>
    translate <0,1,0>
    scale <SizeX,SizeY,SizeZ>
    texture {
        pigment { bozo
            colour_map {
                [0.0 rgb <1,0.8,0.5>]
                [1.0 rgb <0.7,0.4,0.2>]
            }
            turbulence 0.5
            scale <SizeX,SizeY,SizeZ>
        }
        normal { granite 0.2
            scale <SizeX,SizeY,SizeZ>
            turbulence 0.2
        }
    }
    translate <x1,y1,z1>
}
#end // macro Rock2
