// windmill.inc
// A water pump windmill

#include "..\History\girder.inc"

#macro Windmill(x1,y1,z1,rot,BladeRotate,Bent)

#local Height = 15;
#local Base = 1.5;
#local Thick1 = 0.06;
#local Thick2 = 0.04;
#local CableThick = 0.02;
#local Sections = 5;
#local Grey = 0.7;
#local NumBlades = 18;
#local BladeLength = 2;
#local BladeHole = 1;
#local BladeThick = 0.05;
#local BladeShaft = 1;
#local StrutThick = 0.02;
#local StrutOffset = 0.2;
#local FinDepth = 1;
#local FinOffset = 1.2;
#local FinLength = 2;

union {
    // main legs
    Girder(-Base,0,-Base,0,Height,0,Thick1)
    Girder(Base,0,-Base,0,Height,0,Thick1)
    Girder(-Base,0,Base,0,Height,0,Thick1)
    Girder(Base,0,Base,0,Height,0,Thick1)
    // struts
    #local i = 1;
    #while (i < Sections)
        #local h = (Height / Sections) * i;
        #local h0 = (Height / Sections) * (i - 1);
        #local b = (Base / Sections) * (Sections - i);
        #local b0 = (Base / Sections) * (Sections - i + 1);
        // horizontal struts
        Girder(-b,h,-b,-b,h,b,Thick2)
        Girder(-b,h,b,b,h,b,Thick2)
        Girder(b,h,b,b,h,-b,Thick2)
        Girder(b,h,-b,-b,h,-b,Thick2)
        // diagonal struts
        cylinder { <-b,h,-b>, <-b0,h0,b0>, CableThick }
        cylinder { <-b,h,b>, <b0,h0,b0>, CableThick }
        cylinder { <b,h,b>, <b0,h0,-b0>, CableThick }
        cylinder { <b,h,-b>, <-b0,h0,-b0>, CableThick }
        cylinder { <-b0,h0,-b0>, <-b,h,b>, CableThick }
        cylinder { <-b0,h0,b0>, <b,h,b>, CableThick }
        cylinder { <b0,h0,b0>, <b,h,-b>, CableThick }
        cylinder { <b0,h0,-b0>, <-b,h,-b>, CableThick }
        #local i = i + 1;
    #end
    
    // drive shaft
    cylinder { <0,0,0>, <0,Height,0>, Thick1 }

    // fan
    #local r1 = 2 * pi * BladeHole / NumBlades;
    #local r2 = 2 * pi * (BladeHole+BladeLength) / NumBlades;
    union {
        // fan blades
        #local i = 0;
        #while (i < NumBlades)
            #local Angle = (i / NumBlades) * 360;
            difference {
                cone { <BladeHole,0,0>, r1, <BladeHole+BladeLength,0,0>, r2 open }
                cone { <BladeHole,0,-BladeThick>, r1, <BladeHole+BladeLength,0,-BladeThick>, r2 open }
                plane { <0,-1,0>, 0 }
                plane { <0,1,0>, 0 
                    rotate <60,0,0>
                }
                rotate <0,270/NumBlades,0> // 0.75*360
                rotate <0,0,Angle>
                //translate <0,0,-(r1+r2)*0.375>
            }
            #local i = i + 1;
        #end
        // frame tori
        #local TorusRad = BladeHole + BladeLength / 2;
        torus { TorusRad, StrutThick
            rotate <90,0,0>
        }
        torus { BladeHole, StrutThick
            rotate <90,0,0>
        }
        // frame struts
        cylinder { <0,0,StrutOffset>, <TorusRad,0,0>, StrutThick }
        cylinder { <0,0,StrutOffset>, <-TorusRad,0,0>, StrutThick }
        cylinder { <0,0,StrutOffset>, <TorusRad,0,0>, StrutThick
            rotate <0,0,60>
        }
        cylinder { <0,0,StrutOffset>, <-TorusRad,0,0>, StrutThick
            rotate <0,0,60>
        }
        cylinder { <0,0,StrutOffset>, <TorusRad,0,0>, StrutThick
            rotate <0,0,-60>
        }
        cylinder { <0,0,StrutOffset>, <-TorusRad,0,0>, StrutThick
            rotate <0,0,-60>
        }
        cylinder { <0,0,-StrutOffset>, <TorusRad,0,0>, StrutThick }
        cylinder { <0,0,-StrutOffset>, <-TorusRad,0,0>, StrutThick }
        cylinder { <0,0,-StrutOffset>, <TorusRad,0,0>, StrutThick
            rotate <0,0,60>
        }
        cylinder { <0,0,-StrutOffset>, <-TorusRad,0,0>, StrutThick
            rotate <0,0,60>
        }
        cylinder { <0,0,-StrutOffset>, <TorusRad,0,0>, StrutThick
            rotate <0,0,-60>
        }
        cylinder { <0,0,-StrutOffset>, <-TorusRad,0,0>, StrutThick
            rotate <0,0,-60>
        }
        // fan shaft
        cylinder { <0,0,0>, <0,0,BladeShaft+StrutOffset>, BladeThick }
        // translate up to top of tower and rotate a bit
        translate <0,Height,-BladeShaft>
        rotate <0,BladeRotate,0>
    }
    // directional fin
    union {
        box { <-BladeThick/2,-FinDepth/2,FinOffset>, <BladeThick/2,FinDepth/2,FinOffset+FinLength>
            #if (Bent)
                rotate <0,90,0>
            #end
        }
        sphere { <0,0,0>, 0 }
        translate <0,Height,0>
        rotate <0,BladeRotate,0>
    }
    
    // texture
    texture {
        pigment { rgb <Grey,Grey,Grey> }
        finish {
            specular 0.6
            roughness 0.01
            metallic
        }
    }
    // rust layer
    texture {
        pigment { Pigment_Rust2
        }
        normal { granite 0.3
            turbulence 0.3
            scale 0.1
        }
    }
    
    // dirt layer
    texture {
        pigment { bozo
            colour_map {
                [ 0.0 rgbt <1,1,1,1> ]
                [ 1.0 rgbt <0.4,0.3,0.1,0.5> ]
            }
            turbulence 0.7
            omega 0.8
            scale 0.7
        }
    }
    
    // rotate and move into position
    rotate<0,rot,0>
    translate <x1,y1,z1>
}
#end // macro Windmill()