// CITY GENERATOR: DEFAULT CITY
// This scene shows the default city objects and options, under different
// lighting conditions (including the city_night option).
//
// This scene should be rendered as a four-frame, non-cyclic animation.

// CAMERA AND ENVIRONMENT
   camera {location <90, 30, -140> look_at <10, 25, 0> angle 50}
   plane {y, -.01 pigment {rgb <0, .2, 0>}}

   #switch (int(clock*3))
   #case (0)    // Morning
      light_source {<6000, 500, -1000> rgb <.8, .7, .6>}
      default {finish {ambient <.3, .3, .25> diffuse .7}}
      fog {fog_type 2 rgb <.6, .6, .5> distance 5000 fog_alt 500}
      sky_sphere {pigment {gradient y pigment_map {
         [0 rgb 1]
         [.1 wrinkles color_map {[.5 rgb 1] [.7 rgb <.4, .5, .6>]} scale .1]
         [.15 wrinkles color_map {[.1 rgb 1] [.4 rgb <.4, .5, .6>]} scale .1]
         [.2 rgb <.4, .5, .6>]}}}
      #break

   #case (1)    // Daytime
      light_source {<3000, 6000, -7000> rgb 1}
      default {finish {ambient .4 diffuse .7}}
      fog {fog_type 2 rgb <.6, .75, .9> distance 5000 fog_alt 1000}
      sky_sphere {pigment {granite color_map {
         [.4 rgb <.3, .5, .8>] [.7 rgb .9]}
         scale <1, .7, 1>}}
      #break

   #case (2)    // Sunset
      #declare city_night = true;
      #declare windows_lit = .2;
      light_source {<-5000, 1000, -2000> rgb <.8, .6, .3>}
      default {finish {ambient <.3, .2, .25> diffuse .7}}
      fog {fog_type 2 rgb <.9, .8, .5> distance 5000 fog_alt 500}
      sky_sphere {pigment {wrinkles color_map {
         [.4 rgb <.7, .2, .4>] [.8 rgb <.9, .5, .4>]}
         scale <.4, .04, .4>}}
      #break

   #case (3)    // Night
      #declare city_night = true;
      #declare windows_lit = .5;
      light_source {<-6000, 500, -3000> rgb <.2, .25, .3>}
      fog {fog_type 2 rgb <.1, .15, .2> distance 5000 fog_alt 500}
   #end

// GENERATE DEFAULT CITY
   #include "CITY"
