// CITY GENERATOR: SKY LINE ON THE RIVER
// This scene shows how the various city options can be used to create
// cities of different sizes, and how the city_transform option can
// be used to modify the city as a whole.

// CAMERA, LIGHT, AND DEFAULT FINISH
   camera {location <3, 2, -15> look_at <0, 4, 0> angle 80}
   light_source {<20, 70, -100> rgb <1, .9, .7>}
   default {finish {ambient .3 diffuse .6}}

// WATER PLANE AND SKY
   plane {y, -.01
      pigment {rgb <.3, .4, .6>}
      normal {ripples .2 scale 100 frequency 250}
      finish {phong .8 phong_size 15 reflection .3}}

   sky_sphere {pigment {rgb <.2, .5, .8>}
      pigment {granite color_map {
         [.4 rgbt 1] [.8 rgb .9 transmit .4]}
         scale <1, .6, 1>}}

   fog {fog_type 2 color rgb <.7, .9, 1> distance 200 fog_alt 50}

// CITY (ONE BUILDING DEEP)
   #declare city_block_count = 1;
   #declare buildings_per_block = <11, 1, 0>;
   #declare city_transform = transform {scale <.1, .125, .1>}
   #declare city_tileable = true;
   #declare max_building_height = 60;
   #declare building_height_falloff = 0;
   #declare building_height_turb = 1;
   #declare city_seed = 123456;

   #include "DEFAULT.OBJ"
   #include "OFFICES.OBJ"
   #include "FLATS.OBJ"
   #include "HOTELS.OBJ"
   #include "CITY"
