//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  - Parts of this file, such as textures, and object placement, 
//  were generated for POV-Ray V3.1 
//  By Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//  
//  - The city (MYCIT2.INC) was generated using FILECITY.MCR
//  By Chris Colefax
//
//  -'MtRain01' 8-bit .RAW courtesy of Terragen and my supple wrist
//  -'MtRain01' 8-bit .RAW to .GIF conversion courtesy of Paint Shop Pro
//  - NOTE:  Import TerraGen 8-bit raw files as greyscale - not RGB!
//  - Cloud4 and Cloud9 created using Blobs for Windows
//  - The entire visual trio of .POV and .INC files has been subsequently
//  arranged and ASCII tweeked hundreds of times - fubared by rjchase
//  using the CODEMAX editor in POVWin3.1.  See "MyCity.txt"

//#version unofficial MegaPov 0.4;

//  
// ENVIRONMENT
//
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.4
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  //motion_blur 2, 2
  radiosity {
    brightness       3.3
    count            6 //4 // for debug
    distance_maximum 45.0
    error_bound      0.4
    gray_threshold   0.6  //0.0 //
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6  //1 //
    recursion_limit  1
  }
} 

//               //
//    LIGHTS     //
//               //
light_source {<-500, 500, -1000> rgb <1, 1, 0.81>} // late Oktober morn 
light_source {<-500, 500, -500> rgb 1 shadowless}  // fill light
//light_source {<1000, 500, 0> rgb 0.5   // from rgb .25 fill light
// shadowless} // third light source renders slower - of course

//              //
//  INCLUDES    //
//              //
      #include "MyCitxt9.INC" // Material file
      #include "MYCIT2.INC"  // Created by MyCit.MCR 
      #include "MyCity.INC"   // object declare file
      
//  CAMERA  //      
//   
//  Comment in/out cameras 
//  to render a specific scene
//  declare in "MYCITty.INC" 
   camera {
      //Zooom
      //Top_View
      Left_Hand  // primary view   
   }                        

//              //
//  ACTION!     //
//              //
sky_sphere
   {  // Sky_Sphere
     pigment
     { gradient -y
       color_map { [0.0 color rgb <1.0, 0.25, 0.25> ] // red sky
                   // [0.27 color 1.0 ] // white
                   [0.06 color rgb <0.9, 0.25, 0.25> ]
                   [0.1 color rgb <0.8, 0.5, 0.5> ]
                   [0.3 color rgb <0.9, 0.75, 0.75> ]
                   [1.1 color rgb <0.0, 0.0, 1.0> ]
                 }
     }
   } // end sky_sphere

//      FOG     //
//              //
fog {  // ground_fog
    fog_type 2
    distance 40  //  from distance 20
    color rgb <0.76, 0.76, 0.7 >
    turbulence 0.8
        turb_depth 0.3
        omega 0.5
        lambda 0.5
        octaves 3.0
    fog_offset 1  
    fog_alt 4  
    }

//            //
//  OBJECTS   //
//            //
// 
//  TERRAIN PLANE
//
plane {
  y, 0   // yup
  material {
      DryGrass
      }
  hollow
  }
  
//
//  TRANSFORM VOLCANO
//  and effluvium clouds
//
object {Volcano}

//
// TRANSFORM NEEDLE
//
object { Space_Needle 
  scale  <2, 2, 2> 
  rotate <-100, 15, 4> // cocky tilt for the broken needle 
  translate <18, -19, -950> 
    } // end Space_Needle

//
// TRANSFORM CITY OBJECT
//
object { City
    scale <0.8, 0.6, 0.6>
    translate <1, 10, -320>
    }

// 
// CLOUDS AND LIGHTNING
//
//  Cloud_Plane                 //
//  a place for cirrus clounds  //
object { Cloud_Plane1
    scale <750, 100, 100> 
    translate <0, 100, 1800> 
    }

object { Cloud_Plane2
    scale <150, 700, 100> 
    rotate <0, 45, 90>  // rotate so diff from Cloud_Plane1
    translate <0, 150, 1850>  // now t'late to compliment same
    }

object { Cloud9
        scale <100, 55 ,50>
        translate <1150, 200, 1200> 
        }
object { Cloud9
        scale <100, 10 ,10>
        rotate <0, 180, 0>
        translate <1050, 100, 1200>
        }

//
// TRANSFORM LIGHTNING
//
object { Lightning_OBJ  //  low right bolt 
        scale 300
        translate <1300, 150, 1200>
        }
object { Lightning_OBJ  // high left bolt from cloud to cloud
        scale 400
        rotate 179*y  //  make it differ somehow
        translate <-400, 400, 1600>
        }

//
//  END OF MYCITY
//