 road.pov  Yzp 8"p`J J8`YZTXhZ8   pZTEXTNPOV       Z  tĺ)i                       r  // Persistence of Vision Ray Tracer Scene Description File
// File: BrokenColumns.pov
// Vers: 3.1
// Desc: A Road with a couple of temples and the remains of a statue
// Date: 2/28/2000
// Auth: Joshua R English [jre]
// Note: To render this file you will need to make 5 tga images of 
//       random noise and name them "break1.tga","break2.tga"... etc
#version 3.1;

#include "sun.inc"

global_settings { assumed_gamma 1.0 
//                  radiosity { brightness 0.333
//                              count 100
//                              nearest_count 1
//                              gray_threshold .5 }   
 }

// ----------------------------------------
// the main camera for building the road.
#declare MainCam =
camera { location  <-10.0, 6, -12.0>
         direction 0.9*z
         sky <0,1,0>
         right     4/3*x
         look_at   <-4.0, 3.0,  6.0>
         }

// The following camera is for the land map
#declare LayoutCam =
camera  { location <0,50,-0.001>
          direction 1*z
          right 1*x
          look_at <0,0,0> 
          orthographic
          translate <0,0,42> }

// For the plaza
#declare PlazaCam =
camera { location <8,15,-9>
         direction 1*z
         right 4/3*x
         look_at <8,0,5> }


#declare RoamingCam = 
camera { location <15,4,50>
         direction 1*z
         right 4/3*x
         look_at <-05,2,65> }


camera { MainCam }
// Booleans to turn parts on or off
#declare ShowStandingColumns = true;
#declare ShowFallenColumns = true;
#declare ShowPlaza = true;
#declare ShowTableau = false;
#declare ShowLand = true;
#declare ShowGrass = true;
#declare ShowFoot = true;
#declare ShowRocks = true;

// If The Cool Sky from Brian and Lois Bivolcic isn't included, fake one
#ifndef(HelloSun)
sky_sphere { pigment { wrinkles
                       color_map { [0.0 color rgb <0.7,0.7,1.0>]
                                   [1.0 color blue 0.5] } } }

light_source { <0,0,-1000> color rgb 1 
               rotate <45,-15,0> }
fog
{
  fog_type   2
  distance   80
  color      rgb 0.46 // gray
  fog_offset 0.1
  fog_alt    0.2
  turbulence 0.8
}
#end
// ----------------------------------------
#declare sand = 
  pigment { wrinkles 
            color_map { [ 0.0 rgb <251,223,141>/255 ]
                        [ 0.2 rgb <236,223,138>/255 ]
                        [ 0.4 rgb <250,219,147>/255 ]
                        [ 0.6 rgb <249,222,141>/255 ]
                        [ 0.8 rgb <245,230,142>/255 ]
                        [ 1.0 rgb <251,223,141>/255 ] }
          }

#declare grass = 
  pigment { wrinkles 
            color_map { [ 0.0 rgb <  1,117, 17>/255 ]
                        [ 0.2 rgb < 12,117, 16>/255 ]
                        [ 0.4 rgb <  5,103, 19>/255 ]
                        [ 0.6 rgb < 41,162, 39>/255 ]
                        [ 0.8 rgb <  9, 88, 11>/255 ]
                        [ 1.0 rgb <  1,117, 17>/255 ] }
          }

plane { y, -2 
        pigment { grass }  }         
                 
// extra ground info
union {  
  cylinder { <-2.25,0,-4> <-2.25,0,42> 0.125 }
  cylinder { <-14.75,0,-4> <-14.75,0,47> 0.125 }
  box { <-14.75,-.125,-4> <-2.25,.125,47> }
  scale <1,0.5,1> translate -2*y
  pigment { sand } normal { granite } }


difference { cylinder { <0,0,0> <0,0.2,0> 11 } // 0,25
             box { <-12,-0.5,-12> <12,0.5,0> }
             box { <0,-0.5,-12> <12,0.5,12> }
             pigment { sand } normal { granite }
             translate <-4,-2,47> }

difference { cylinder { <0,0,0> <0,0.2,0> 9 }
             cylinder { <0,-0.1,0> <0,0.3,0> 5 }
             box { <-9,-0.5,-9> <9,0.5,0> }
             box { <-9,-1,9> <9,1,0> rotate 40*y }
             pigment { sand } normal { granite }
             translate <3,-2,42> }

box { <-19.5,-.125,0> <-5,.25,40> 
      pigment { sand } normal { granite }
rotate 40*y translate <3,-2,42>  }

#macro Swap(a,b)
  #local tmp = a;
  #declare a = b;
  #declare b = tmp;
#end


#macro RoundedBox(mn,mx,rd)
  #if(mn.x > mx.x) Swap(mn.x,mx.x) #end
  #if(mn.y > mx.y) Swap(mn.y,mx.y) #end
  #if(mn.z > mx.z) Swap(mn.z,mx.z) #end
  merge { 
   sphere {<mn.x+rd,mn.y+rd,mn.z+rd> rd }
   sphere {<mx.x-rd,mn.y+rd,mn.z+rd> rd }
   sphere {<mn.x+rd,mx.y-rd,mn.z+rd> rd }
   sphere {<mx.x-rd,mx.y-rd,mn.z+rd> rd }

   sphere {<mn.x+rd,mn.y+rd,mx.z-rd> rd }
   sphere {<mx.x-rd,mn.y+rd,mx.z-rd> rd }
   sphere {<mn.x+rd,mx.y-rd,mx.z-rd> rd }
   sphere {<mx.x-rd,mx.y-rd,mx.z-rd> rd }

   cylinder { <mn.x+rd,mn.y+rd,mn.z+rd> <mx.x-rd,mn.y+rd,mn.z+rd> rd }
   cylinder { <mn.x+rd,mn.y+rd,mx.z-rd> <mx.x-rd,mn.y+rd,mx.z-rd> rd }
   cylinder { <mn.x+rd,mn.y+rd,mn.z+rd> <mn.x+rd,mn.y+rd,mx.z-rd> rd }
   cylinder { <mx.x-rd,mn.y+rd,mn.z+rd> <mx.x-rd,mn.y+rd,mx.z-rd> rd }

   cylinder { <mn.x+rd,mx.y-rd,mn.z+rd> <mx.x-rd,mx.y-rd,mn.z+rd> rd }
   cylinder { <mn.x+rd,mx.y-rd,mx.z-rd> <mx.x-rd,mx.y-rd,mx.z-rd> rd }
   cylinder { <mn.x+rd,mx.y-rd,mn.z+rd> <mn.x+rd,mx.y-rd,mx.z-rd> rd }
   cylinder { <mx.x-rd,mx.y-rd,mn.z+rd> <mx.x-rd,mx.y-rd,mx.z-rd> rd }

   cylinder { <mn.x+rd,mn.y+rd,mn.z+rd> <mn.x+rd,mx.y-rd,mn.z+rd> rd }
   cylinder { <mn.x+rd,mn.y+rd,mx.z-rd> <mn.x+rd,mx.y-rd,mx.z-rd> rd }
   cylinder { <mx.x-rd,mn.y+rd,mn.z+rd> <mx.x-rd,mx.y-rd,mn.z+rd> rd }
   cylinder { <mx.x-rd,mn.y+rd,mx.z-rd> <mx.x-rd,mx.y-rd,mx.z-rd> rd }

   box { <mn.x+rd,mn.y+rd,mn.z> <mx.x-rd,mx.y-rd,mx.z> }
   box { <mn.x+rd,mn.y,mn.z+rd> <mx.x-rd,mx.y,mx.z-rd> }
   box { <mn.x,mn.y+rd,mn.z+rd> <mx.x,mx.y-rd,mx.z-rd> }
}
#end

#declare peelingslope = slope_map {
	[ 0.00000,  < 0.14953,  6.05403 > ]
	[ 0.22642,  < 0.40187,  -2.09135 > ]
	[ 0.51887,  < 0.09346,  -0.44028 > ]
	[ 0.86792,  < 0.20561,  0.00000 > ]
	[ 1.04717,  < 0.18692,  0.00000 > ]
}

#declare texseed = seed(41);
#macro OldTexturize()
 texture { pigment { agate translate (rand(texseed)*6-3) rotate rand(texseed)*180 scale 3 }
           normal { granite 0.3 }
  }
#end
// Give each block it's own variation on the texture
#macro Texturize()
 #local trans = rand(texseed)*4-2;
 #local turb = rand(texseed);
 texture { pigment { bozo 
                     scale 2
                     color_map { [ 0.25 rgb <0.75,0.55,0.15> ]
                                 [ 0.25 rgb 0.95 ]
                                 [ 1.00 rgb 1 ] 
                                }
                     translate trans
                     turbulence turb
                     quick_color rgb 0.75
 }
           normal { bozo  1
                    scale 2 
                    slope_map { peelingslope }
                     translate trans
                     turbulence turb

                   }
  }
  texture { pigment { crackle 
                      color_map { [ 0.99 rgbf 1 ] [ 0.99 rgbf <0,0,0,0.5>] }
                     }
            normal { crackle 0.1 }
         }
#end



#macro breaker(img,ytrans)
height_field { tga concat("break" + str(img,1,0) + ".tga")
              // water_level 0.3
               translate <-0.5,0,-0.5>
               scale <3,0.75,3> 
               translate ytrans*y }
#end

#declare column = 
difference { 
  cylinder { <0,0,0> <0,15,0> 1.5 }
  #local cnt = 0;
  #while ( cnt < 360)
    union { sphere { <1.5,1,0> 0.15 }
            cylinder { <1.5,1,0> <1.5,14,0> 0.15 }
            sphere { <1.5,14,0> 0.15 }
            rotate cnt*y
           } 
    #declare cnt = cnt + 360/15;
  #end
 }
// From Colors.inc
#declare White = rgb 1;
#declare Black = 1;
#declare DarkGreen = color red 0.184314 green 0.309804 blue 0.184314;
#declare DimGray = color red 0.329412 green 0.329412 blue 0.329412;

// From Stones.inc
#declare T_Grnt20 =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.3 color Black color White]
    [0.3, 0.4 color White color White]
    [0.4, 0.6 color White color White]
    [0.6, 1.0 color White color White]
   }
 }
 finish {
  crand 0.02
 }
 }
//---------- Overtint Green with Black T_Cracks
#declare T_Crack3 =
texture {
pigment
 {marble
  turbulence 0.85
  color_map
   {[0.0, 0.04 color Black filter 0.6 color Black filter 1.0]
    [0.04, 0.97 color DarkGreen filter 0.80 color DarkGreen filter 0.90]
    [0.97, 1.001 color Black filter 0.9 color Black filter 1.0]
   }
 }
 }

//--------- Overtint with White T_Crack
#declare T_Crack4 =
texture {
pigment
 {marble
  turbulence 0.85
  color_map
   {[0.0, 0.03 color White filter 0.3 color White filter 1.0]
    [0.03, 0.97 color Black filter 0.70 color DimGray filter 0.90]
    [0.97, 1.001 color White filter 0.9 color White filter 1.0]
   }
 }
 }

#declare T_Stone17 =
texture{T_Grnt20 scale <1, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}
}
texture{T_Crack3 scale <1, 2, 1.4> rotate <10, 0, -20>
}


#declare column_texture = 
  texture { T_Stone17 }
  texture { T_Crack4 }
  texture { pigment { rgbf 1 }
            normal { gradient y
                     slope_map { [ 0.00000,  < 0.98131,  0.00003 > ]
	                              [ 0.30189,  < -0.00000,  0.00000 > ] }
	                  turbulence 0.15 omega 0.9 octaves 9 lambda 1 }
           }


// -- one column
//union { // Uncomment  here to get the land image

#if (ShowStandingColumns)
object { RoundedBox(<-2,-2,-2.5>,<2,0,2.5>,0.125) Texturize() }

intersection { 
  object { column }
  union { object { breaker(1,0) }
          box { <-3,0,-3,> <3,-30,3> }
          scale <1.75,0.5,1.75> rotate 30*z translate 7.2*y }
  texture { column_texture }
  }
#end

#if (ShowFallenColumns)
difference { 
  object { column }
  union { object { breaker(1,0) }
          box { <-3,0,-3,> <3,-30,3> }
          scale <1.75,0.5,1.75> rotate 30*z translate 7.2*y }
  texture { column_texture }
  translate -15*y
  rotate 90*y
  rotate <85,-52,0>
  translate <-11,-1,3>
  }
#end
// -- second column

#if (ShowStandingColumns)
object { RoundedBox(<-2,-2,6.5>,<2,0,11.5>,0.125) Texturize() }

intersection { 
  object { column }
  union { object { breaker(2,0) }
          box { <-3,0,-3,> <3,-30,3> }
          scale <1.75,0.5,1.75> rotate 5*z translate 9.5*y }
  texture { column_texture }
  translate 9*z
  }
#end

#if (ShowFallenColumns)
difference { 
  object { column }
  union { object { breaker(1,0) }
          box { <-3,0,-3,> <3,-30,3> }
          scale <1.75,0.5,1.75> rotate 5*z translate 9.5*y }
  texture { column_texture }
  translate -15*y
  rotate 75*y
  rotate <95,-112,0>
  translate <-13,-2.5,12>
  }
#end
// -- third column
#if (ShowStandingColumns)
object { RoundedBox(<-2,-2,16.5>,<2,0,21.5>,0.125) Texturize() }

intersection { 
  object { column }
  union { object { breaker(3,0) }
          box { <-3,0,-3,> <3,-30,3> }
          scale <1.75,0.5,1.75> rotate 5*x translate 8*y }
  texture { column_texture }
  translate 19*z
  }
#end
#if (ShowFallenColumns)
difference { 
  object { column }
  union { object { breaker(3,0) }
          box { <-3,0,-3,> <3,-30,3> }
          scale <1.75,0.5,1.75> rotate 5*x translate 8*y }
  texture { column_texture }
  translate -15*y
  //rotate 75*y
  rotate <15,-112,0>
  translate <-15,3.5,19>
  }
#end



// Test of the ground plane
#if (ShowLand)
height_field {
  tga "Gearhart24000.tga"
  //smooth
  water_level 0.000015
  pigment {
    gradient y
      color_map { // approximate MacDEM colors
        [0.0  color rgb <0.0, 0.59, 0.8>]
        [0.000015  color rgb <0.00, 0.30, 0.02>]
        [0.002991  color rgb <0.99, 0.80, 0.02>]
      }
    }
  finish { ambient 0.01 }
  translate <-0.5, 0.000000, -0.5>
  scale <1.000000, 6.680428, 1.425076> // restore DEM aspect ratios (e,u,n)
  scale <1,6,1>
  rotate -89*y
  //scale 32185.039062 // scale DEM to true size (feet)
  scale 900
 translate <0,-2,60>
}
#end
// blocks in the plaza
#if (ShowPlaza)
object { RoundedBox(<2,-2,-2.5>,<6,0,1.5>,0.125) Texturize() }
object { RoundedBox(<2,-2,1.5>,<6,0,5.5>,0.125) Texturize() }
object { RoundedBox(<2,-2,5.5>,<4,0,8>,0.125) Texturize() }
object { RoundedBox(<4,-2,5.5>,<8,0,8>,0.125) Texturize() }
object { RoundedBox(<2,-2,8>,<7,0,12>,0.125) Texturize() }
object { RoundedBox(<2,-2,12>,<6,0,17>,0.125) Texturize() }
object { RoundedBox(<2,-2,17>,<9,0,21.5>,0.125) Texturize() }

object { RoundedBox(<6,-2,-2.5>,<11,0,0.5>,0.125) Texturize() }
object { RoundedBox(<6,-2,0.5>,<11,0,5.5>,0.125) Texturize() }
object { RoundedBox(<8,-2,5.5>,<11,0,12>,0.125) Texturize() }
object { RoundedBox(<7,-2,8>,<8,0,12>,0.125) Texturize() }
object { RoundedBox(<6,-2,12>,<15,0,17>,0.125) Texturize() }
object { RoundedBox(<6,-2,17>,<12,0,21.5>,0.125) Texturize() }

object { RoundedBox(<11,-2,-2.5>,<14,0,2.5>,0.125) Texturize() }
object { RoundedBox(<11,-2,2.5>,<15,0,6.5>,0.125) Texturize() }
object { RoundedBox(<11,-2,6.5>,<16,0,12>,0.125) Texturize() }
object { RoundedBox(<12,-2,17>,<16,0,21.5>,0.125) Texturize() }

object { RoundedBox(<16,-2,6.5>,<24,0,10>,0.125) Texturize() }
object { RoundedBox(<16,-2,10>,<24,0,12>,0.125) Texturize() }
object { RoundedBox(<15,-2,12>,<24,0,17>,0.125) Texturize() }
object { RoundedBox(<16,-2,17>,<24,0,21.5>,0.125) Texturize() }


object { RoundedBox(<14,0,17>,<19,2,21.5>,0.125) Texturize() }
object { RoundedBox(<19,0,17>,<24,2,21.5>,0.125) Texturize() }
object { RoundedBox(<16,2,17>,<21.5,4,21.5>,0.125) Texturize() }
object { RoundedBox(<21.5,2,17>,<24,4,21.5>,0.125) Texturize() }
object { RoundedBox(<21,0,11>,<24,2,17>,0.125) Texturize() }
#end

// Monolithic tableau
#if (ShowTableau)
#declare col1x = 4.5;
#declare col3x = 29.5;
#declare col2x = (col1x + col3x)/2;


object { column translate <col1x,-1,23.5> texture { column_texture } }


// this column will be broken
//object { column translate <col2x,-1,23.5> texture { column_texture } }
intersection { 
  object { column }
  object { breaker(4,0)  
    scale <1.75,2,1.75> rotate -45*y translate 12*y }
  texture { column_texture }
  translate <col2x,-1,23.5>
  }


object { column translate <col3x,-1,23.5> texture { column_texture } }

//box { <col1x-1,14,22> <col2x+1,15,25> pigment { rgb 1 } }
difference {
  box { <-2,0,-2> <10.5,2,2> }
  sphere { <-1,0.25,-2> 0.15 }
  cylinder { <-1,0.25,-2> <11,0.25,-2> 0.15 }
  sphere { <-1,0.75,-2> 0.15 }
  cylinder { <-1,0.75,-2> <11,0.75,-2> 0.15 }
  sphere { <-1,1.25,-2> 0.15 }
  cylinder { <-1,1.25,-2> <11,1.25,-2> 0.15 }
  sphere { <-1,1.75,-2> 0.15 }
  cylinder { <-1,1.75,-2> <11,1.75,-2> 0.15 }
  texture { column_texture }
  rotate -8.1*z
  translate <6.5,14,23.5> }

difference {
  box { <-10.51,0,-2> <2,2,2> }
  sphere { <1,0.25,-2> 0.15 }
  cylinder { <-11,0.25,-2> <1,0.25,-2> 0.15 }
  sphere { <1,0.75,-2> 0.15 }
  cylinder { <-11,0.75,-2> <1,0.75,-2> 0.15 }
  sphere { <1,1.25,-2> 0.15 }
  cylinder { <-11,1.25,-2> <1,1.25,-2> 0.15 }
  sphere { <1,1.75,-2> 0.15 }
  cylinder { <-11,1.75,-2> <1,1.75,-2> 0.15 }
  texture { column_texture }
  rotate 8.05*z
  translate <28,14,23.5> }

#end

object { RoundedBox(<31.5,0,21.5> <35.5,14,25.5>, 0.125)
           texture { column_texture } }
object { RoundedBox(<31.5,14,15> <35.5,16,26>, 0.125)
         texture { column_texture} }

// Rock the Third column leans on
// Textures from Stones.inc
#declare T_Grnt17a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.034   color rgbf <0.027, 0.012, 0.012, 0.000>
                    color rgbf <0.851, 0.812, 0.741, 0.000>]
    [0.034, 0.342   color rgbf <0.851, 0.812, 0.741, 0.000>
                    color rgbf <0.792, 0.694, 0.690, 0.000>]
    [0.342, 0.462   color rgbf <0.792, 0.694, 0.690, 0.000>
                    color rgbf <0.631, 0.506, 0.471, 0.000>]
    [0.462, 0.632   color rgbf <0.631, 0.506, 0.471, 0.000>
                    color rgbf <0.851, 0.812, 0.741, 0.000>]
    [0.632, 0.983   color rgbf <0.851, 0.812, 0.741, 0.000>
                    color rgbf <0.647, 0.655, 0.655, 0.000>]
    [0.983, 1.001   color rgbf <0.647, 0.655, 0.655, 0.000>
                    color rgbf <0.027, 0.012, 0.012, 0.000>]
   }
 }
 }

#declare T_Grnt3a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.153   color rgbf <0.831, 0.631, 0.569, 0.447>
                    color rgbf <0.925, 0.831, 0.714, 0.678>]
    [0.153, 0.297   color rgbf <0.925, 0.831, 0.714, 0.678>
                    color rgbf <0.871, 0.702, 0.659, 0.475>]
    [0.297, 0.441   color rgbf <0.871, 0.702, 0.659, 0.475>
                    color rgbf <0.831, 0.631, 0.569, 0.918>]
    [0.441, 0.763   color rgbf <0.831, 0.631, 0.569, 0.918>
                    color rgbf <0.937, 0.882, 0.820, 0.655>]
    [0.763, 1.001   color rgbf <0.937, 0.882, 0.820, 0.655>
                    color rgbf <0.831, 0.631, 0.569, 0.447>]
   }
 }
 }


#declare T_Stone10 =
texture{pigment{color Black}}
texture{T_Grnt17a scale <6, 2, 6> rotate <0, 0, 50> normal { granite 0.8 } }
texture{T_Grnt3a scale <1, 0.2, 1> rotate <0, 0, -50>
        normal { granite 0.5 rotate 180*y}
        //finish{phong 1.0 phong_size 90}
}

#if (ShowRocks)
#declare rkcnt = 0;
#declare rkmax = 25;
intersection {
  #while ( rkcnt < rkmax )
    sphere { <0.5,0,0> 1 rotate <110*rkcnt,-15*rkcnt,17*rkcnt> }
    #declare rkcnt = rkcnt + 1;
  #end
  texture { T_Stone10 }
  scale <6,8,6>
  rotate -45*y
  translate <-19,-1,20.25>
}
#declare rkcnt = 0;
#declare rkmax = 25;
intersection {
  #while ( rkcnt < rkmax )
    box { -1 1 rotate <40*rkcnt,-05*rkcnt,11*rkcnt> }
    #declare rkcnt = rkcnt + 1;
  #end
  texture { T_Stone10 }
  scale <5,8,5>
  translate <-21,-1,13>
}
#end

//clipped_by { plane { y, -1.8 } } } // Uncomment to land map

#if (ShowGrass)
#include "grasspatch2.inc"
#declare Patch_Translation = <0,-2,0>;
#declare Patch_Shape = 1;

#declare Blade_Density = 2; 
#declare PlotPoints = false;


#declare Blade_Detail = 14;
#declare Max_Blade_Angle = 45;
#declare Min_Blade_Angle = 25;

#declare Blade_Height_Minimum = 2;
#declare Blade_Height_Maximum = 3;

#declare Patch_X_Minimum = -2;
#declare Patch_X_Maximum = 2;

#declare Patch_Z_Minimum = 2.5;
#declare Patch_Z_Maximum = 6.5;

PlantPatch()

#declare Patch_X_Minimum = -2;
#declare Patch_X_Maximum = 2;

#declare Patch_Z_Minimum = 11.5;
#declare Patch_Z_Maximum = 16.5;

PlantPatch()

#declare Patch_X_Minimum = -2;
#declare Patch_X_Maximum = 4;

#declare Patch_Z_Minimum = -4.5;
#declare Patch_Z_Maximum = -2.5;

PlantPatch()

#declare Patch_X_Minimum = -3;
#declare Patch_X_Maximum = -2;

#declare Patch_Z_Minimum = -4.5;
#declare Patch_Z_Maximum = 21.5;

PlantPatch()

#declare Patch_X_Minimum = -3;
#declare Patch_X_Maximum = 2;

#declare Patch_Z_Minimum = 21.5;
#declare Patch_Z_Maximum = 25.5;

PlantPatch()

#declare Patch_X_Minimum = -3;
#declare Patch_X_Maximum = 0;
#declare Patch_Z_Minimum = 26;
#declare Patch_Z_Maximum = 49;
PlantPatch()

#declare Patch_X_Minimum = -20;
#declare Patch_X_Maximum = -14.5;
#declare Patch_Z_Minimum = 26;
#declare Patch_Z_Maximum = 49;
PlantPatch()

// Some free form patches
//CheckDefaults()
#declare Patch_Shape = 3;
#declare BezRad = 1;
#declare  Patch_Path = array[4] { <-13,-2,22>, <-6,-2,19>, <-19,-2,13> <-15,-2,6> }
//DrawSpline(Patch_Path)
PlantPatch()
#declare  Patch_Path = array[4] { <-13,-2,8>, <-6,-2,4>, <-19,-2,2> <-10,-2,-2> }
//DrawSpline(Patch_Path)
PlantPatch()
#end

// There needs to be something in the background here
union {
//box { <-40,-2,-15> <-15,15,15> pigment { rgb 1 } }

object { RoundedBox(<-15,-2,-15>,<00,0,15>,0.125) Texturize() }

//object { column translate <-13,0,-13> texture { column_texture } }
//object { column translate <-08,0,-13> texture { column_texture } }
//object { column translate <-03,0,-13> texture { column_texture } }
//object { column translate <-13,0, 13> texture { column_texture } }
//object { column translate <-08,0, 13> texture { column_texture } }
//object { column translate <-03,0, 13> texture { column_texture } }

intersection { 
  object { column }
  union { object { breaker(1,0) }
          box { <-3,0,-3,> <3,-30,3> }
          scale <1.75,0.5,1.75> rotate 30*z translate 7.2*y }
  texture { column_texture }
  translate <-13,0,-13>
  }

intersection { 
  object { column }
  union { object { breaker(2,0) }
          box { <-3,0,-3,> <3,-30,3> }
          scale <1.75,0.5,1.75> rotate 30*z translate 9.2*y }
  texture { column_texture }
  translate <-8,0,-13>
  }

intersection { 
  object { column }
  union { object { breaker(3,0) }
          box { <-3,0,-3,> <3,-30,3> }
          scale <1.75,0.5,1.75> rotate 30*z translate 10.5*y }
  texture { column_texture }
  translate <-3,0,-13>
  }

intersection { 
  object { column }
  union { object { breaker(4,0) }
          box { <-3,0,-3,> <3,-30,3> }
          scale <1.75,0.5,1.75> rotate 30*z translate 9*y }
  texture { column_texture }
  translate <-13,0,13>
  }

intersection { 
  object { column }
  union { object { breaker(5,0) }
          box { <-3,0,-3,> <3,-30,3> }
          scale <1.75,0.5,1.75> rotate 30*z translate 5*y }
  texture { column_texture }
  translate <-8,0,13>
  }

intersection { 
  object { column }
  union { object { breaker(1,0) }
          box { <-3,0,-3,> <3,-30,3> }
          scale <1.75,0.8,1.75> rotate 30*z translate 7.2*y }
  texture { column_texture }
  translate <-3,0,13>
  }

// Broken Tops
difference { 
  object { column }
  union { object { breaker(3,0) }
          box { <-3,0,-3,> <3,-30,3> }
          scale <1.75,0.5,1.75> rotate 5*x translate 10.5*y }
  texture { column_texture }
  translate -15*y
  rotate -90*x
  rotate <0,-12,0>
  translate <-1,1.5,-2>
  }

rotate 40*y
translate <-05,0,65> 
}

// Big Broken Foot
// What says "ruins" better thana  big broken foot?
box { <0,-2,28> <40,5,48> 
      pigment { crackle 
                scale 2
                color_map { [0 rgb 0.5 ] [1 rgb 1 ] } }
      normal { crackle scale 2 } }

#if (ShowFoot)
  #include "nufoot.inc"
  object { Foot 
           scale <-1,1,1>
           translate 0.018*y
           scale 50
           rotate -100*y
           // The Basic Bronze
           texture {  pigment { rgb <0.36, 0.28, 0.20> } 
                      normal { granite 0.7 frequency 4 scale 3 }
                      finish { metallic ambient 0.3
                               diffuse 0.65
                               specular 0.85
                               roughness 0.01
                               brilliance 2.0 }
                 }
         // The Green oxidation
         texture {  pigment { planar 
                              color_map { [0.5 rgbf 1 ]
                                          [0.55 rgbf <0.28,0.37,0.23,0.19> ] 
                                          [0.6 rgbf <0.56,0.75,0.56,0.12> ] } 
                              turbulence 1.05 omega 0.8 } 
                    finish { ambient 0.2 specular 0 diffuse 0.5 }
                 }
         // The Rust    
         texture { pigment { planar 
                             color_map { [0.75 rgbf 1 ]
                                         [0.75 rgb <0.89, 0.51, 0.28>]
                                         [0.82 rgb <0.70, 0.13, 0.00>]
                                         [0.90 rgb <0.69, 0.41, 0.08>]
                                         [1.00 rgb <0.49, 0.31, 0.28>]} 
                             scale <0.125,1.1,0.125>
                             turbulence 0.38 omega 0.8 
                             translate 1.5*y}    
                           } 
           scale 9
           translate <22,5,38>
  }

#end





                                                                                                  n  a 88! P |N  | !a Xa XH E1A 8! @ |N  a  d <Tc>N  | !a Xa XH EA  X   X8  d X9   ( A X9`  j  X, ƀa X#  X8, ʀ X ʁ X ́a X+ ΁A X* ҁ X, րa X8CP<     q  q    6           Trillian                   XBD    m
bezier.inc                                                      ϻf#TEXTNPOV                   Include     m  `     2Trillian:Applications:POV-Ray 3:Include:bezier.inc   4        Trillian                   XBD    mgrasspatch2.inc                                                 ٖTEXTNPOV                   Include     m  `     7Trillian:Applications:POV-Ray 3:Include:grasspatch2.inc                 Trillian                   XBD   Ȝ
nufoot.inc                                                      (ĺ.TEXTNPOV                   ruins    Ȝ     (Trillian:Desktop Folder:ruins:nufoot.inc  an:A        Trillian                   XBD   Ȝsun.inc                                                         rTEXTNPOV                   ruins    Ȝ     %Trillian:Desktop Folder:ruins:sun.inc   fog
{
          	    	         $  6 G                                  nST16    n SELc   "NwPM   .styl   :NwPo   F                        i            