
/*
 * "Ruinas"
 *
 * Jaime Vives Piqueres, (?)2000, IRTC 01-02-2000 ("Ruins").
 *
 */


/*
   BASICS
*/

#version 3.1;
global_settings{
 ambient_light 3
}
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"
#include "consts.inc"



/* RADIOSITY SETTINGS */
//#declare Rad_Quality = Radiosity_Debug
//#declare Rad_Quality = Radiosity_Fast
//#declare Rad_Quality = Radiosity_Normal
#declare Rad_Quality = Radiosity_2Bounce
//#declare Rad_Quality = Radiosity_Final
#include "rad_def.inc"


/*
  TRACE CONTROL
*/

// 0,1 = off,on
#declare trace_wall  =1;
#declare trace_floor =1;
#declare trace_bushes=1;


/*
  COMMON TEXTURES
*/

// basic sand/rock color
#declare p_sand=OrangeRed*.5+Flesh*.45;

// rock texture...
#declare t_rock=
texture{
 pigment{
  granite
  turbulence 0.2
  color_map{
   [0.0 Gold+Orange*.2]
   [0.0 p_sand]
   [1.0 Gold+Gray20]
  }
  scale <30,4,4>
  scale .1
 }
}
texture{  // ...with a layer of falling dirty
 pigment{
  gradient y
  turbulence 0.4
  color_map{
   [0.0 DarkTan*.9 filter 0.8]
   [0.4 p_sand filter 0.7]
   [0.5 DarkTan*.8 filter 0.6]
   [0.51 Clear]
   [1.0 Clear]
  }
  scale <10,400,10>
  translate 300*y
 }
 normal{granite scale 4}
}

// sand texture...
#declare t_floor=
texture{
 pigment{
  granite
  turbulence 0.2
  color_map{
   [0.0 Gold+Orange*.1]
   [0.5 p_sand+Gold*.5]
   [1.0 Gold+Gray30]
  }
  scale 1
  rotate 90*x
 }
}
texture{  // ...with some color variation
 pigment{
  bozo
  turbulence 0.4
  color_map{
   [0.0 DarkTan filter 0.8]
   [1.0 Clear]
  }
  scale 200
 }
 normal{granite scale .5}
}


/*
  ROCK WALL
*/

#if (trace_wall)

// wall hf (see hf_wall.pov)
#declare wall=
height_field{
 png "hf_wall"
 water_level 0.1
 translate -.5
 rotate -90*x
 scale <800,600,100>
}

object{wall
 translate <10,300,-40>
 texture{t_rock}
}

// tomb door hf (see hf_portal.pov)
#declare portal=
height_field{
 png "hf_portal"
 water_level .1
 translate -.5
 rotate -90*x
 scale <150*1.2,200*1.2,50>
}

object{portal
 translate <10,100*1.2,0>
 texture{t_rock}
}

// simple tomb interior (not seen at all, only for some darkness)
difference{
 box{-1,1}
 box{<-.9,-.9,-1.1>,<.9,.9,.9>}
 scale .5
 scale <150*1.3,200*1.3,500>
 texture{t_rock}
 translate <10,100*1.2,250>
}

#end // if trace_wall


/*
  SAND FLOOR
*/

#if (trace_floor)

// floor hf
#declare sand_floor=
intersection{
 height_field{
  png "hf_floor"
  smooth
  water_level 0.1
  translate -.5
 }
 box{-.5,.5 scale <0.99,1,0.99>}
 scale <700,20,500>
}

object{sand_floor
 texture{t_floor}
 translate <5,9,-270>
}

#end // if trace_floor


/*
  BUSHES
*/

#if (trace_bushes)

// bush texture
#declare t_leaf=
texture{
 pigment{
  spotted
  color_map{
   [0.0 Gold]
   [0.4 Green*.25+Gold*.75]
   [0.6 Gold]
   [1.0 Tan]
  }
 }
 finish{Glossy}
 scale 4
}

// basic bush shape
#declare r_leaf=seed(947);
#declare min_group_radius=10;
#declare max_group_radius=20;
#declare num_sph=10;
#declare cnt_sph=1;
#declare num_leaf=256;
#declare bush=
union{
 #while (cnt_sph<num_sph)
  #declare cnt_leaf=1;
  union{
   #while (cnt_leaf<=num_leaf)
    sphere{0,1
     scale <.5,1,.1>
     scale .1+rand(r_leaf)
     texture{t_leaf}
     rotate -45*x
     translate (-min_group_radius+max_group_radius*rand(r_leaf))*z
     rotate 360*rand(r_leaf)*y
     rotate 360*rand(r_leaf)*x
    }
    #declare cnt_leaf=cnt_leaf+1;
   #end
   translate (min_group_radius*rand(r_leaf))*z
   rotate 360*rand(r_leaf)*y
   rotate 360*rand(r_leaf)*x
  }
  #declare cnt_sph=cnt_sph+1;
 #end
}

// right
union{
object{bush translate <90,15,-150>}
object{bush rotate 90*y translate <100,15,-160>}
object{bush rotate 90*y translate <110,20,-140>}
object{bush rotate -90*y translate <180,10,-60>}
object{bush rotate 190*y translate <175,5,-40>}
translate -25*x
}
// left
object{bush translate <-90,10,-150>}
object{bush rotate 130*y translate <-120,15,-150>}
object{bush rotate 190*y translate <-110,10,-160>}
union{
object{bush translate <-90,10,-150>}
object{bush rotate 130*y translate <-120,15,-150>}
object{bush rotate 190*y translate <-110,10,-160>}
 translate <50,10,115>
}

#end // if trace_bushes


/*
  SUN & SKY
*/

// some brigth sunlight
#declare l_color=White+Gold*.25+SkyBlue*.125;
light_source{
 <100000,50000,-70000>
 l_color*.9
 fade_distance 1000000
 fade_power 2
}

// don't know why I put this invisible sky, but well...
sky_sphere{
 pigment{
  wrinkles
  lambda 3
  color_map{
   [0.0 SummerSky]
   [0.4 SummerSky]
   [0.6 White]
   [1.0 White]
  }
  scale <1,1/3,1>
 }
}


/*
  CAMERA
*/

#declare desde=<-10,40,-398>;
#declare hacia=<2,138,0>;
camera{
 location desde
 right 1*x       // use square image size!
 look_at hacia
}


