/*camera {  //  Camera StdCam
  location  <     13.819,     -28.864,       7.018>
  direction <        0.0,         0.0,      1.9423> // Aperture is 0.50 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     -1.213,       0.441,      -4.067>
}*/

#declare CARFRONT = difference {
  superellipsoid { // SuperQ001
    <0.3, 0.6>
    texture {
      DullBlackPlastic
    }
    scale <7.498004, 1.0, 1.891883>
    translate  <0.010906, -5.883666, -2.930472>
  }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal_3
    }
    scale <1.0, 1.075941, 1.379704>
    rotate 90.0*x
    translate  <-4.9556, -5.577459, -2.96169>
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal_3
    }
    scale <1.0, 1.075941, 1.379704>
    rotate 90.0*x
    translate  <4.9556, -5.577459, -2.9616>
  }
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      MetallicOrange
    }
    scale <0.362941, 1.21776, 1.3797>
    rotate 90.0*x
    translate  <-6.55283, -5.57742, -3.084885>
  }
  cone { // Cone004
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      MetallicOrange
    }
    scale <0.362941, 1.21776, 1.3797>
    rotate 90.0*x
    translate  <6.55283, -5.57742, -3.084885>
  }
  scale <0.95, 1.0, 1.0>
  translate  <0.0, -0.455645, -0.151882>
}      

#declare TYRE1 = union {
  superellipsoid { // SuperQ003
    <1.0, 0.2>
    texture {
      Chrome_Textur1
    }
    scale <1.976155, 1.976154, 0.779044>
    rotate -90.0*y
    translate  <-8.6423, 1.42805, -5.15716>
  }
  torus { // Torus002
    1.6, 0.4  rotate -x*90
    texture {
      DullBlackPlastic
    }
    scale 1.488077
    rotate <-90.0, 0.0, -90.0>
    translate  <-8.54238, 1.428051, -5.157163>
  }
  translate  <16.08535, 0.0, 0.76>
}
#declare HUBDECOR = union {
  sphere { // Sphere001
    <0,0,0>,1
    texture {
      DullBlackPlastic
    }
    scale 0.25
    translate  <8.21261, 0.0, -4.359904>
  }
  sphere { // Sphere003
    <0,0,0>,1
    texture {
      DullBlackPlastic
    }
    scale 0.25
    translate  <8.21261, 0.471208, -3.464608>
  }
  sphere { // Sphere004
    <0,0,0>,1
    texture {
      DullBlackPlastic
    }
    scale 0.25
    translate  <8.21261, 1.437185, -3.087641>
  }
  sphere { // Sphere005
    <0,0,0>,1
    texture {
      DullBlackPlastic
    }
    scale 0.25
    translate  <8.21261, 2.308921, -3.488168>
  }
  sphere { // Sphere006
    <0,0,0>,1
    texture {
      DullBlackPlastic
    }
    scale 0.25
    translate  <8.21261, 2.638766, -4.383464>
  }
  sphere { // Sphere007
    <0,0,0>,1
    texture {
      DullBlackPlastic
    }
    scale 0.25
    translate  <8.21261, 2.214679, -5.208079>
  }
  sphere { // Sphere008
    <0,0,0>,1
    texture {
      DullBlackPlastic
    }
    scale 0.25
    translate  <8.21261, 1.437185, -5.585045>
  }
  sphere { // Sphere009
    <0,0,0>,1
    texture {
      DullBlackPlastic
    }
    scale 0.25
    translate  <8.21261, 0.54189, -5.231639>
  }
 }
 
#declare WHEEL1 = difference {
  object { TYRE1 }
  object { HUBDECOR }
  translate  0.32224*x
}
#declare WHEEL2 = union {
  superellipsoid { // SuperQ002
    <1.0, 0.2>
    texture {
      Chrome_Textur1
    }
    scale <1.976155, 1.976154, 0.779044>
    rotate <0.0, -90.0, 0.0>
    translate  <-8.5423, 1.42805, -5.15716>
  }
  torus { // Torus001
    1.6, 0.4  rotate -x*90
    texture {
      DullBlackPlastic
    }
    scale 1.488077
    rotate <-90.0, 0.0, -90.0>
    translate  <-8.54238, 1.428051, -5.157163>
  }
  translate  <0.509647, 0.0, 0.764471>
}
#declare CarBody = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.278767, -6.212463, -3.387879>, <-6.760467, -7.156395, -2.166159>, <-6.442962, -7.163448, -1.484757>, <-5.529077, -7.170500, -1.484931>, 
      <-8.299161, -6.171520, -5.036117>, <-8.043802, -6.385510, -0.832910>, <-7.043904, -6.392562, -0.833074>, <-6.044007, -6.399614, -0.833237>, 
      <-8.719564, -5.279346, -4.774963>, <-8.356935, -5.492824, -0.697251>, <-7.357038, -5.499876, -0.697415>, <-6.197785, -5.550651, -0.739947>, 
      <-8.713982, -4.514968, -4.741875>, <-8.192001, -4.731306, -0.440854>, <-7.192104, -4.738358, -0.441025>, <-6.112635, -4.780741, -0.523562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.713982, -4.514968, -4.741875>, <-8.192001, -4.731306, -0.440854>, <-7.192104, -4.738358, -0.441025>, <-6.112635, -4.780741, -0.523562>, 
      <-8.708401, -3.750589, -4.708786>, <-8.027067, -3.969788, -0.184458>, <-7.027170, -3.976840, -0.184636>, <-6.027484, -4.010832, -0.307177>, 
      <-8.702819, -2.943612, -4.693778>, <-8.021489, -3.164547, -0.128868>, <-7.021592, -3.171599, -0.129046>, <-6.021906, -3.205591, -0.251586>, 
      <-8.692037, -2.901719, -4.769205>, <-8.010745, -2.581573, -0.101846>, <-7.010796, -2.585099, -0.101936>, <-6.010953, -2.620989, -0.227856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.692037, -2.901719, -4.769205>, <-8.010745, -2.581573, -0.101846>, <-7.010796, -2.585099, -0.101936>, <-6.010953, -2.620989, -0.227856>, 
      <-8.681256, -2.859825, -4.844632>, <-8.000000, -1.998600, -0.074825>, <-7.000000, -1.998600, -0.074825>, <-6.000000, -2.036387, -0.204125>, 
      <-9.000000, -0.943726, -2.294479>, <-8.000000, -0.999300, -0.037412>, <-7.000000, -0.999300, -0.037412>, <-6.000000, -1.037087, -0.166712>, 
      <-8.872204, -0.028939, -1.916850>, <-8.000000, 0.000000, 0.000000>, <-7.000000, 0.000000, 0.000000>, <-6.000000, -0.037788, -0.129300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.872204, -0.028939, -1.916850>, <-8.000000, 0.000000, 0.000000>, <-7.000000, 0.000000, 0.000000>, <-6.000000, -0.037788, -0.129300>, 
      <-8.744409, 0.885847, -1.539220>, <-8.000000, 0.999300, 0.037412>, <-7.000000, 0.999300, 0.037412>, <-6.000000, 0.961512, -0.091887>, 
      <-8.744409, 1.885830, -1.544977>, <-8.000000, 1.998600, 0.074825>, <-7.000000, 1.998600, 0.074825>, <-6.000000, 1.960812, -0.054475>, 
      <-8.872204, 2.971011, -1.934121>, <-8.000000, 2.997900, 0.112237>, <-7.000000, 2.997900, 0.112237>, <-6.000000, 2.960112, -0.017062>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.872204, 2.971011, -1.934121>, <-8.000000, 2.997900, 0.112237>, <-7.000000, 2.997900, 0.112237>, <-6.000000, 2.960112, -0.017062>, 
      <-9.000000, 4.056191, -2.323265>, <-8.000000, 3.997200, 0.149650>, <-7.000000, 3.997200, 0.149650>, <-6.000000, 3.959412, 0.020350>, 
      <-8.681256, 5.375912, -4.799736>, <-8.000000, 4.996500, 0.187062>, <-7.000000, 4.996500, 0.187062>, <-6.000000, 4.958712, 0.057763>, 
      <-8.681256, 6.120304, -4.933289>, <-8.000000, 5.995799, 0.224475>, <-7.000000, 5.995799, 0.224475>, <-6.000000, 5.958012, 0.095175>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.681256, 6.120304, -4.933289>, <-8.000000, 5.995799, 0.224475>, <-7.000000, 5.995799, 0.224475>, <-6.000000, 5.958012, 0.095175>, 
      <-8.681256, 6.864696, -5.066841>, <-8.000000, 6.995099, 0.261887>, <-7.000000, 6.995099, 0.261887>, <-6.000000, 6.957312, 0.132588>, 
      <-8.681256, 7.864680, -5.072599>, <-8.000000, 7.994399, 0.299300>, <-7.000000, 7.994399, 0.299300>, <-6.000000, 7.994399, 0.299300>, 
      <-8.681256, 8.864663, -5.078356>, <-8.000000, 8.993699, 0.336712>, <-7.000000, 8.993699, 0.336712>, <-6.000000, 8.993699, 0.336712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.529077, -7.170500, -1.484931>, <-4.615193, -7.177552, -1.485105>, <-3.701308, -7.184604, -1.485278>, <-2.787424, -7.191656, -1.485452>, 
      <-6.044007, -6.399614, -0.833237>, <-5.044110, -6.406666, -0.833401>, <-4.044213, -6.413718, -0.833564>, <-3.044316, -6.420770, -0.833728>, 
      <-6.197785, -5.550651, -0.739947>, <-5.038532, -5.601425, -0.782480>, <-4.038635, -5.608477, -0.782643>, <-3.038738, -5.615529, -0.782807>, 
      <-6.112635, -4.780741, -0.523562>, <-5.033165, -4.823125, -0.606098>, <-4.033268, -4.830177, -0.606269>, <-3.033371, -4.837229, -0.606440>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.112635, -4.780741, -0.523562>, <-5.033165, -4.823125, -0.606098>, <-4.033268, -4.830177, -0.606269>, <-3.033371, -4.837229, -0.606440>, 
      <-6.027484, -4.010832, -0.307177>, <-5.027798, -4.044824, -0.429717>, <-4.027901, -4.051876, -0.429895>, <-3.028004, -4.058928, -0.430074>, 
      <-6.021906, -3.205591, -0.251586>, <-5.022220, -3.239583, -0.374127>, <-4.022323, -3.246635, -0.374305>, <-3.022426, -3.253687, -0.374484>, 
      <-6.010953, -2.620989, -0.227856>, <-5.011110, -2.656879, -0.353776>, <-4.011161, -2.660405, -0.353865>, <-3.011213, -2.663931, -0.353954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.010953, -2.620989, -0.227856>, <-5.011110, -2.656879, -0.353776>, <-4.011161, -2.660405, -0.353865>, <-3.011213, -2.663931, -0.353954>, 
      <-6.000000, -2.036387, -0.204125>, <-5.000000, -2.074175, -0.333425>, <-4.000000, -2.074175, -0.333425>, <-3.000000, -2.074175, -0.333425>, 
      <-6.000000, -1.037087, -0.166712>, <-5.000000, -1.074875, -0.296012>, <-4.000000, -1.074875, -0.296012>, <-3.000000, -1.074875, -0.296012>, 
      <-6.000000, -0.037788, -0.129300>, <-5.000000, -0.075575, -0.258600>, <-4.000000, -0.075575, -0.258600>, <-3.000000, -0.075575, -0.258600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, -0.037788, -0.129300>, <-5.000000, -0.075575, -0.258600>, <-4.000000, -0.075575, -0.258600>, <-3.000000, -0.075575, -0.258600>, 
      <-6.000000, 0.961512, -0.091887>, <-5.000000, 0.923725, -0.221187>, <-4.000000, 0.923725, -0.221187>, <-3.000000, 0.923725, -0.221187>, 
      <-6.000000, 1.960812, -0.054475>, <-5.000000, 1.923025, -0.183775>, <-4.000000, 1.923025, -0.183775>, <-3.000000, 1.923025, -0.183775>, 
      <-6.000000, 2.960112, -0.017062>, <-5.000000, 2.922325, -0.146362>, <-4.000000, 2.922325, -0.146362>, <-3.000000, 2.922325, -0.146362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, 2.960112, -0.017062>, <-5.000000, 2.922325, -0.146362>, <-4.000000, 2.922325, -0.146362>, <-3.000000, 2.922325, -0.146362>, 
      <-6.000000, 3.959412, 0.020350>, <-5.000000, 3.921625, -0.108950>, <-4.000000, 3.921625, -0.108950>, <-3.000000, 3.921625, -0.108950>, 
      <-6.000000, 4.958712, 0.057763>, <-5.000000, 4.920924, -0.071537>, <-4.000000, 4.920924, -0.071537>, <-3.000000, 4.920924, -0.071537>, 
      <-6.000000, 5.958012, 0.095175>, <-5.000000, 5.920224, -0.034125>, <-4.000000, 5.920224, -0.034125>, <-3.000000, 5.920224, -0.034125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, 5.958012, 0.095175>, <-5.000000, 5.920224, -0.034125>, <-4.000000, 5.920224, -0.034125>, <-3.000000, 5.920224, -0.034125>, 
      <-6.000000, 6.957312, 0.132588>, <-5.000000, 6.919524, 0.003288>, <-4.000000, 6.919524, 0.003288>, <-3.000000, 6.919524, 0.003288>, 
      <-6.000000, 7.994399, 0.299300>, <-5.000000, 7.994399, 0.299300>, <-4.000000, 7.994399, 0.299300>, <-3.000000, 7.994399, 0.299300>, 
      <-6.000000, 8.993699, 0.336712>, <-5.000000, 8.993699, 0.336712>, <-4.000000, 8.993699, 0.336712>, <-3.000000, 8.993699, 0.336712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.787424, -7.191656, -1.485452>, <-1.873539, -7.198708, -1.485626>, <-0.959655, -7.205760, -1.485800>, <-0.045770, -7.212812, -1.485973>, 
      <-3.044316, -6.420770, -0.833728>, <-2.044419, -6.427822, -0.833891>, <-1.044522, -6.434874, -0.834055>, <-0.044625, -6.441926, -0.834218>, 
      <-3.038738, -5.615529, -0.782807>, <-2.038841, -5.622581, -0.782970>, <-1.038944, -5.629633, -0.783134>, <-0.039047, -5.636685, -0.783297>, 
      <-3.033371, -4.837229, -0.606440>, <-2.033474, -4.844281, -0.606611>, <-1.033577, -4.851333, -0.606782>, <-0.033679, -4.858385, -0.606953>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.033371, -4.837229, -0.606440>, <-2.033474, -4.844281, -0.606611>, <-1.033577, -4.851333, -0.606782>, <-0.033679, -4.858385, -0.606953>, 
      <-3.028004, -4.058928, -0.430074>, <-2.028106, -4.065980, -0.430252>, <-1.028209, -4.073032, -0.430431>, <-0.028312, -4.080084, -0.430609>, 
      <-3.022426, -3.253687, -0.374484>, <-2.022528, -3.260740, -0.374662>, <-1.022631, -3.267792, -0.374841>, <-0.022734, -3.274844, -0.375019>, 
      <-3.011213, -2.663931, -0.353954>, <-2.011264, -2.667457, -0.354043>, <-1.011316, -2.670983, -0.354133>, <-0.011367, -2.674509, -0.354222>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.011213, -2.663931, -0.353954>, <-2.011264, -2.667457, -0.354043>, <-1.011316, -2.670983, -0.354133>, <-0.011367, -2.674509, -0.354222>, 
      <-3.000000, -2.074175, -0.333425>, <-2.000000, -2.074175, -0.333425>, <-1.000000, -2.074175, -0.333425>, <0.000000, -2.074175, -0.333425>, 
      <-3.000000, -1.074875, -0.296012>, <-2.000000, -1.074875, -0.296012>, <-1.000000, -1.074875, -0.296012>, <0.000000, -1.074875, -0.296012>, 
      <-3.000000, -0.075575, -0.258600>, <-2.000000, -0.075575, -0.258600>, <-1.000000, -0.075575, -0.258600>, <0.000000, -0.075575, -0.258600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -0.075575, -0.258600>, <-2.000000, -0.075575, -0.258600>, <-1.000000, -0.075575, -0.258600>, <0.000000, -0.075575, -0.258600>, 
      <-3.000000, 0.923725, -0.221187>, <-2.000000, 0.923725, -0.221187>, <-1.000000, 0.923725, -0.221187>, <0.000000, 0.923725, -0.221187>, 
      <-3.000000, 1.923025, -0.183775>, <-2.000000, 1.923025, -0.183775>, <-1.000000, 1.923025, -0.183775>, <0.000000, 1.923025, -0.183775>, 
      <-3.000000, 2.922325, -0.146362>, <-2.000000, 2.922325, -0.146362>, <-1.000000, 2.922325, -0.146362>, <0.000000, 2.922325, -0.146362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 2.922325, -0.146362>, <-2.000000, 2.922325, -0.146362>, <-1.000000, 2.922325, -0.146362>, <0.000000, 2.922325, -0.146362>, 
      <-3.000000, 3.921625, -0.108950>, <-2.000000, 3.921625, -0.108950>, <-1.000000, 3.921625, -0.108950>, <0.000000, 3.921625, -0.108950>, 
      <-3.000000, 4.920924, -0.071537>, <-2.000000, 4.920924, -0.071537>, <-1.000000, 4.920924, -0.071537>, <0.000000, 4.920924, -0.071537>, 
      <-3.000000, 5.920224, -0.034125>, <-2.000000, 5.920224, -0.034125>, <-1.000000, 5.920224, -0.034125>, <0.000000, 5.920224, -0.034125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 5.920224, -0.034125>, <-2.000000, 5.920224, -0.034125>, <-1.000000, 5.920224, -0.034125>, <0.000000, 5.920224, -0.034125>, 
      <-3.000000, 6.919524, 0.003288>, <-2.000000, 6.919524, 0.003288>, <-1.000000, 6.919524, 0.003288>, <0.000000, 6.919524, 0.003288>, 
      <-3.000000, 7.994399, 0.299300>, <-2.000000, 7.994399, 0.299300>, <-1.000000, 7.994399, 0.299300>, <0.000000, 7.994399, 0.299300>, 
      <-3.000000, 8.993699, 0.336712>, <-2.000000, 8.993699, 0.336712>, <-1.000000, 8.993699, 0.336712>, <0.000000, 8.993699, 0.336712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.045770, -7.212812, -1.485973>, <0.868114, -7.219864, -1.486147>, <1.781999, -7.226916, -1.486321>, <2.695883, -7.233968, -1.486495>, 
      <-0.044625, -6.441926, -0.834218>, <0.955272, -6.448978, -0.834382>, <1.955170, -6.456030, -0.834546>, <2.955067, -6.463082, -0.834709>, 
      <-0.039047, -5.636685, -0.783297>, <0.960851, -5.643738, -0.783461>, <1.960748, -5.650790, -0.783624>, <2.960645, -5.657842, -0.783788>, 
      <-0.033679, -4.858385, -0.606953>, <0.966218, -4.865437, -0.607124>, <1.966115, -4.872489, -0.607295>, <2.966012, -4.879541, -0.607466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.033679, -4.858385, -0.606953>, <0.966218, -4.865437, -0.607124>, <1.966115, -4.872489, -0.607295>, <2.966012, -4.879541, -0.607466>, 
      <-0.028312, -4.080084, -0.430609>, <0.971585, -4.087136, -0.430788>, <1.971482, -4.094188, -0.430966>, <2.971379, -4.101241, -0.431145>, 
      <-0.022734, -3.274844, -0.375019>, <0.977163, -3.281896, -0.375198>, <1.977060, -3.288948, -0.375376>, <2.976957, -3.296000, -0.375555>, 
      <-0.011367, -2.674509, -0.354222>, <0.988581, -2.678035, -0.354311>, <1.988530, -2.681561, -0.354400>, <2.988479, -2.685087, -0.354490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.011367, -2.674509, -0.354222>, <0.988581, -2.678035, -0.354311>, <1.988530, -2.681561, -0.354400>, <2.988479, -2.685087, -0.354490>, 
      <0.000000, -2.074175, -0.333425>, <1.000000, -2.074175, -0.333425>, <2.000000, -2.074175, -0.333425>, <3.000000, -2.074175, -0.333425>, 
      <0.000000, -1.074875, -0.296012>, <1.000000, -1.074875, -0.296012>, <2.000000, -1.074875, -0.296012>, <3.000000, -1.074875, -0.296012>, 
      <0.000000, -0.075575, -0.258600>, <1.000000, -0.075575, -0.258600>, <2.000000, -0.075575, -0.258600>, <3.000000, -0.075575, -0.258600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.075575, -0.258600>, <1.000000, -0.075575, -0.258600>, <2.000000, -0.075575, -0.258600>, <3.000000, -0.075575, -0.258600>, 
      <0.000000, 0.923725, -0.221187>, <1.000000, 0.923725, -0.221187>, <2.000000, 0.923725, -0.221187>, <3.000000, 0.923725, -0.221187>, 
      <0.000000, 1.923025, -0.183775>, <1.000000, 1.923025, -0.183775>, <2.000000, 1.923025, -0.183775>, <3.000000, 1.923025, -0.183775>, 
      <0.000000, 2.922325, -0.146362>, <1.000000, 2.922325, -0.146362>, <2.000000, 2.922325, -0.146362>, <3.000000, 2.922325, -0.146362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 2.922325, -0.146362>, <1.000000, 2.922325, -0.146362>, <2.000000, 2.922325, -0.146362>, <3.000000, 2.922325, -0.146362>, 
      <0.000000, 3.921625, -0.108950>, <1.000000, 3.921625, -0.108950>, <2.000000, 3.921625, -0.108950>, <3.000000, 3.921625, -0.108950>, 
      <0.000000, 4.920924, -0.071537>, <1.000000, 4.920924, -0.071537>, <2.000000, 4.920924, -0.071537>, <3.000000, 4.920924, -0.071537>, 
      <0.000000, 5.920224, -0.034125>, <1.000000, 5.920224, -0.034125>, <2.000000, 5.920224, -0.034125>, <3.000000, 5.920224, -0.034125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 5.920224, -0.034125>, <1.000000, 5.920224, -0.034125>, <2.000000, 5.920224, -0.034125>, <3.000000, 5.920224, -0.034125>, 
      <0.000000, 6.919524, 0.003288>, <1.000000, 6.919524, 0.003288>, <2.000000, 6.919524, 0.003288>, <3.000000, 6.919524, 0.003288>, 
      <0.000000, 7.994399, 0.299300>, <1.000000, 7.994399, 0.299300>, <2.000000, 7.994399, 0.299300>, <3.000000, 7.994399, 0.299300>, 
      <0.000000, 8.993699, 0.336712>, <1.000000, 8.993699, 0.336712>, <2.000000, 8.993699, 0.336712>, <3.000000, 8.993699, 0.336712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.695883, -7.233968, -1.486495>, <3.609767, -7.241020, -1.486669>, <4.523652, -7.248072, -1.486842>, <5.596909, -7.361372, -1.487016>, 
      <2.955067, -6.463082, -0.834709>, <3.954964, -6.470134, -0.834873>, <4.954861, -6.477187, -0.835036>, <5.954758, -6.484239, -0.835200>, 
      <2.960645, -5.657842, -0.783788>, <3.960542, -5.664894, -0.783952>, <4.960439, -5.671946, -0.784115>, <6.119692, -5.680122, -0.784305>, 
      <2.966012, -4.879541, -0.607466>, <3.965909, -4.886593, -0.607637>, <4.965806, -4.893645, -0.607808>, <6.045487, -4.887789, -0.546812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.966012, -4.879541, -0.607466>, <3.965909, -4.886593, -0.607637>, <4.965806, -4.893645, -0.607808>, <6.045487, -4.887789, -0.546812>, 
      <2.971379, -4.101241, -0.431145>, <3.971276, -4.108293, -0.431323>, <4.971173, -4.115345, -0.431502>, <5.971281, -4.095456, -0.309319>, 
      <2.976957, -3.296000, -0.375555>, <3.976854, -3.303052, -0.375733>, <4.976751, -3.310104, -0.375912>, <5.976859, -3.290216, -0.253729>, 
      <2.988479, -2.685087, -0.354490>, <3.988427, -2.688613, -0.354579>, <4.988376, -2.692139, -0.354668>, <5.988430, -2.663302, -0.228927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.988479, -2.685087, -0.354490>, <3.988427, -2.688613, -0.354579>, <4.988376, -2.692139, -0.354668>, <5.988430, -2.663302, -0.228927>, 
      <3.000000, -2.074175, -0.333425>, <4.000000, -2.074175, -0.333425>, <5.000000, -2.074175, -0.333425>, <6.000000, -2.036387, -0.204125>, 
      <3.000000, -1.074875, -0.296012>, <4.000000, -1.074875, -0.296012>, <5.000000, -1.074875, -0.296012>, <6.000000, -1.037087, -0.166712>, 
      <3.000000, -0.075575, -0.258600>, <4.000000, -0.075575, -0.258600>, <5.000000, -0.075575, -0.258600>, <6.000000, -0.037788, -0.129300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.000000, -0.075575, -0.258600>, <4.000000, -0.075575, -0.258600>, <5.000000, -0.075575, -0.258600>, <6.000000, -0.037788, -0.129300>, 
      <3.000000, 0.923725, -0.221187>, <4.000000, 0.923725, -0.221187>, <5.000000, 0.923725, -0.221187>, <6.000000, 0.961512, -0.091887>, 
      <3.000000, 1.923025, -0.183775>, <4.000000, 1.923025, -0.183775>, <5.000000, 1.923025, -0.183775>, <6.000000, 1.960812, -0.054475>, 
      <3.000000, 2.922325, -0.146362>, <4.000000, 2.922325, -0.146362>, <5.000000, 2.922325, -0.146362>, <6.000000, 2.960112, -0.017062>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.000000, 2.922325, -0.146362>, <4.000000, 2.922325, -0.146362>, <5.000000, 2.922325, -0.146362>, <6.000000, 2.960112, -0.017062>, 
      <3.000000, 3.921625, -0.108950>, <4.000000, 3.921625, -0.108950>, <5.000000, 3.921625, -0.108950>, <6.000000, 3.959412, 0.020350>, 
      <3.000000, 4.920924, -0.071537>, <4.000000, 4.920924, -0.071537>, <5.000000, 4.920924, -0.071537>, <6.000000, 4.958712, 0.057763>, 
      <3.000000, 5.920224, -0.034125>, <4.000000, 5.920224, -0.034125>, <5.000000, 5.920224, -0.034125>, <6.000000, 5.958012, 0.095175>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.000000, 5.920224, -0.034125>, <4.000000, 5.920224, -0.034125>, <5.000000, 5.920224, -0.034125>, <6.000000, 5.958012, 0.095175>, 
      <3.000000, 6.919524, 0.003288>, <4.000000, 6.919524, 0.003288>, <5.000000, 6.919524, 0.003288>, <6.000000, 6.957312, 0.132588>, 
      <3.000000, 7.994399, 0.299300>, <4.000000, 7.994399, 0.299300>, <5.000000, 7.994399, 0.299300>, <6.000000, 7.994399, 0.299300>, 
      <3.000000, 8.993699, 0.336712>, <4.000000, 8.993699, 0.336712>, <5.000000, 8.993699, 0.336712>, <6.000000, 8.993699, 0.336712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.596909, -7.361372, -1.487016>, <6.670165, -7.474673, -1.487190>, <7.009714, -7.269228, -2.339334>, <7.224078, -6.892143, -3.645591>, 
      <5.954758, -6.484239, -0.835200>, <6.954655, -6.491291, -0.835363>, <7.954552, -6.498343, -0.835527>, <8.017604, -6.259019, -5.028430>, 
      <6.119692, -5.680122, -0.784305>, <7.278945, -5.688298, -0.784494>, <8.278842, -5.695350, -0.784658>, <8.534368, -5.452042, -4.929486>, 
      <6.045487, -4.887789, -0.546812>, <7.125167, -4.881933, -0.485815>, <8.125064, -4.888985, -0.485986>, <8.539950, -4.645065, -4.861445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.045487, -4.887789, -0.546812>, <7.125167, -4.881933, -0.485815>, <8.125064, -4.888985, -0.485986>, <8.539950, -4.645065, -4.861445>, 
      <5.971281, -4.095456, -0.309319>, <6.971389, -4.075568, -0.187135>, <7.971287, -4.082620, -0.187314>, <8.545532, -3.838088, -4.793404>, 
      <5.976859, -3.290216, -0.253729>, <6.976967, -3.270327, -0.131545>, <7.976865, -3.277380, -0.131724>, <8.551114, -3.456104, -4.778395>, 
      <5.988430, -2.663302, -0.228927>, <6.988484, -2.634464, -0.103185>, <7.988432, -2.637990, -0.103274>, <8.563061, -3.147684, -4.853866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.988430, -2.663302, -0.228927>, <6.988484, -2.634464, -0.103185>, <7.988432, -2.637990, -0.103274>, <8.563061, -3.147684, -4.853866>, 
      <6.000000, -2.036387, -0.204125>, <7.000000, -1.998600, -0.074825>, <8.000000, -1.998600, -0.074825>, <8.575007, -2.839263, -4.929337>, 
      <6.000000, -1.037087, -0.166712>, <7.000000, -0.999300, -0.037412>, <8.000000, -0.999300, -0.037412>, <9.000000, -1.029412, -2.379184>, 
      <6.000000, -0.037788, -0.129300>, <7.000000, 0.000000, 0.000000>, <8.000000, 0.000000, 0.000000>, <9.000000, -0.114626, -2.044153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.000000, -0.037788, -0.129300>, <7.000000, 0.000000, 0.000000>, <8.000000, 0.000000, 0.000000>, <9.000000, -0.114626, -2.044153>, 
      <6.000000, 0.961512, -0.091887>, <7.000000, 0.999300, 0.037412>, <8.000000, 0.999300, 0.037412>, <9.000000, 0.800161, -1.709122>, 
      <6.000000, 1.960812, -0.054475>, <7.000000, 1.998600, 0.074825>, <8.000000, 1.998600, 0.074825>, <9.000000, 1.800144, -1.714880>, 
      <6.000000, 2.960112, -0.017062>, <7.000000, 2.997900, 0.112237>, <8.000000, 2.997900, 0.112237>, <9.000000, 2.757529, -2.061425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.000000, 2.960112, -0.017062>, <7.000000, 2.997900, 0.112237>, <8.000000, 2.997900, 0.112237>, <9.000000, 2.757529, -2.061425>, 
      <6.000000, 3.959412, 0.020350>, <7.000000, 3.997200, 0.149650>, <8.000000, 3.997200, 0.149650>, <9.000000, 3.714914, -2.407970>, 
      <6.000000, 4.958712, 0.057763>, <7.000000, 4.996500, 0.187062>, <8.000000, 4.996500, 0.187062>, <8.681256, 5.396474, -4.884441>, 
      <6.000000, 5.958012, 0.095175>, <7.000000, 5.995799, 0.224475>, <8.000000, 5.995799, 0.224475>, <8.681256, 6.140866, -5.017994>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.000000, 5.958012, 0.095175>, <7.000000, 5.995799, 0.224475>, <8.000000, 5.995799, 0.224475>, <8.681256, 6.140866, -5.017994>, 
      <6.000000, 6.957312, 0.132588>, <7.000000, 6.995099, 0.261887>, <8.000000, 6.995099, 0.261887>, <8.681256, 6.885258, -5.151547>, 
      <6.000000, 7.994399, 0.299300>, <7.000000, 7.994399, 0.299300>, <8.000000, 7.994399, 0.299300>, <8.681256, 7.885242, -5.157304>, 
      <6.000000, 8.993699, 0.336712>, <7.000000, 8.993699, 0.336712>, <8.000000, 8.993699, 0.336712>, <8.681256, 8.885225, -5.163061>
    }
  }
  texture {
    RedPlastic
  }
}

#declare Car=
 union { // CSG006
  object { CARFRONT }
  object { WHEEL1 }
  object { WHEEL2 }
  object { CarBody }
  superellipsoid { // SuperQ004
    <0.1, 0.1>
    texture {
      Chrome_Metal_3
    }
    scale <3.61271, 1.0, 0.108117>
    translate  <0.0, -6.33091, -2.38199>
  }
  superellipsoid { // SuperQ005
    <0.1, 0.1>
    texture {
      Chrome_Metal_3
    }
    scale <3.61271, 1.0, 0.108117>
    translate  <0.0, -6.3309, -3.146461>
  }
  superellipsoid { // SuperQ006
    <0.1, 0.1>
    texture {
      Chrome_Metal_3
    }
    scale <3.61271, 1.0, 0.108117>
    translate  <0.0, -6.3309, -3.78352>
  }
 }



