// Persistence of Vision Ray Tracer Scene Description File
// File: DistantCity.inc
// Vers: 3.1
// Desc: Macro to create a cityscape. Intended for far background. Little detail present. 
// Date: 15 Jan 2000 
// Auth: Gail Shaw
 
#declare HeightRand=seed(37838);
#declare SizeRand=seed(3729);
#declare DamageRand=seed(7292);
#declare RoadRand=seed(1048); 
 
#macro DistantCity (NoOfBuildings,AverageHeight,HeightVarience,AverageSize,SizeVarience,DamagedPercentage,DamageObject,BuildingsbetweenRoadsX,BuildingsbetweenRoadsZ,AverageRoad,RoadVarience)
 #local CurrentX=0;
 #local CurrentY=0;
 #local CurrentZ=0;
 #local EndX=0;
 #local EndZ=0;
 #local NextX=0;
 #local NextZ=0; 
 #local Loop1=0;
 #local Loop2=0;
 #local MaxX=0;
 #local MaxZ=0;
 #local BuildCurrentBlock=0;
 #local BuildCurrentRow=0;
 union {
  #while (Loop1<NoOfBuildings)
   #while (Loop2<NoOfBuildings)
    #local EndX=CurrentX+AverageSize+(rand(SizeRand)-0.5)*SizeVarience;
    #local EndZ=CurrentZ+AverageSize+(rand(SizeRand)-0.5)*SizeVarience;
    #local CurrentY=AverageHeight+(rand(HeightRand)-0.5)*HeightVarience; 
    #if (rand(DamageRand)<DamagedPercentage)
     difference {
      box {
       <CurrentX,0,CurrentZ>,<EndX,CurrentY,EndZ>
      }
      object {
       DamageObject
       scale <EndX-CurrentX+2,-HeightVarience/2,EndZ-CurrentZ+2>
       translate <CurrentX-1,CurrentY-(rand(HeightRand)/2*HeightVarience),CurrentZ-1>
      }
     }
    #else
     box {
      <CurrentX,0,CurrentZ>,<EndX,CurrentY,EndZ>
     }
    #end
    #local BuildCurrentBlock=BuildCurrentBlock+1;
    #if (BuildCurrentBlock<BuildingsbetweenRoadsX)
     #local NextX=EndX+AverageSize/5;
    #else
     #local NextX=EndX+AverageRoad+(rand(RoadRand)-0.5)*RoadVarience;
     #local BuildCurrentBlock=0;
    #end
    #local NextZ=max(NextZ,EndZ);
    #local CurrentX=NextX;
    #local Loop2=Loop2+1;
    #local MaxX=max(MaxX,CurrentX);
   #end
   #local CurrentX=0;
   #local BuildCurrentBlock=0;
   #local BuildCurrentRow=BuildCurrentRow+1;
   #if (BuildCurrentRow<BuildingsbetweenRoadsZ)
    #local CurrentZ=NextZ+AverageSize/5;
   #else 
    #local CurrentZ=NextZ+AverageRoad+(rand(RoadRand)-0.5)*RoadVarience;
    #local BuildCurrentRow=0;
   #end
   #local Loop2=0;
   #local Loop1=Loop1+1;
  #end 
  #local MaxZ=CurrentZ;
  #debug concat("Max Extent of the city is ",str(MaxX,0,3),",",str(MaxZ,0,3),"\n") 
 }
#end