// Persistence of Vision Ray Tracer Scene Description File
// File: brickwall.inc
// Vers: 3.14159  Megapov 0.3
// Desc: Macro to create a brick wall 
// Date: 8 Jan 2000 
// Auth: Gail Shaw

#declare Windowx1=-1;
#declare Windowx2=-1;
#declare Windowy1=-1;
#declare Windowy2=-1;  

#declare Start=<0,0,0>; 
          
#declare StaggeredLeft=0;
#declare StaggeredRight=0;
#declare UnevenStagger=0;        
#declare Stagger=seed(3437);  

#declare SecondTexture=0;
#declare LayerTexture=
 texture {
  pigment {rgbft<1,1,1,1,1>}
 }

// if any of the window variables are greater than zero then a window is created in the wall.
// The numbers specify the number of bricks along and up the window starts and finishes.
// (the window was specified this way to prevent fractions of bricks.) The value for the window
// should be a multiple of 1/2 and should not be closer than one brick to the start or end of the wall

// The variable Start allows multiple walls to look continous. The wall is translated BEFORE
// texturing. 

// StaggeredLeft and StaggeredRight create walls with uneven sides if they are set !=0
// If UnevenStagger is 0 then each successive row is half a brick shorter than the
// previous. If it is !=0 then each row is shorter by -0.5 to 1.5 bricks

// if SecondTexture is !=0 then the texture specified by LayerTexture is applied to all
// bricks uniformly. Good for dirt, soot etc.

// creates a brick wall in the x-y plane             
#macro BrickWall(Length,Height,MaxLength,MaxHeight,MortarThickness,BrickPig1,BrickPig2,BrickTex1,MortarTex)
 // Length and Height are the desired dimensions of the wall.
 // MaxLength and MaxHeight are the maximum desired sized of the bricks
 // MortarThickness is a percentage of the brick width. 10% to 15% looks quite good.
 // The two brick pigments are used in a bozo pattern with repeat warps to generate different colours for 
 //   each brick. For a monocoloured wall set them to the same pigment.
 // BrickTex is the remainder of the texture (normal and finish) for the bricks.  
 // MortarTex is the texture for the mortar.
 #local BrickHeight=Height/ceil((Height+MaxHeight*MortarThickness/120)/(MaxHeight+MaxHeight*MortarThickness/120));
 #local BrickLength=Length/ceil((Length+BrickHeight*MortarThickness/80)/(MaxLength+BrickHeight*MortarThickness/80));
 #local EffectiveLength = BrickLength+BrickHeight*MortarThickness/80; 
 #local EffectiveHeight = BrickHeight+BrickHeight*MortarThickness/120;
 #local NoOfBricks=floor(Length/EffectiveLength);
 #local TotalBricks=NoOfBricks;
 #local NoOfRows=floor(Height/EffectiveHeight);  
 #debug concat ("Overlap spot is x:",str((TotalBricks-1)*EffectiveLength-BrickHeight*MortarThickness/120,0,2)," y:",str((NoOfRows-1)*EffectiveHeight-BrickHeight*MortarThickness/120,0,2),"\n")                                 
 #if (StaggeredLeft!=0)         
  #local ArrayLeft=array[NoOfRows+2] 
  #if (UnevenStagger = 0)
   #local ArrayLeft[0]=0;
   #local ArrayLoop=1;    
   #while (ArrayLoop<NoOfRows+2)
    #local ArrayLeft[ArrayLoop]=ceil(0.5*(ArrayLoop-1));
    #local ArrayLoop=ArrayLoop+1;      
   #end
  #else
   #local ArrayLeft[0]=0;
   #local ArrayLoop=1;    
   #while (ArrayLoop<NoOfRows+2)
    #local ArrayLeft[ArrayLoop]=ceil(ArrayLeft[ArrayLoop-1]+(rand(Stagger)-0.4)*2);
    #local ArrayLoop=ArrayLoop+1;
   #end
  #end
 #else 
  #local ArrayLeft=array[NoOfRows+2] 
  #local ArrayLoop=1;    
  #while (ArrayLoop<NoOfRows+2)
   #local ArrayLeft[ArrayLoop]=0;
   #local ArrayLoop=ArrayLoop+1;      
  #end
 #end
 #if (StaggeredRight!=0)
  #local ArrayRight=array[NoOfRows+2]
  #if (UnevenStagger = 0)
   #local ArrayRight[0]=0;
   #local ArrayLoop=1;    
   #while (ArrayLoop<NoOfRows+2)
    #local ArrayRight[ArrayLoop]=ceil(0.5*(ArrayLoop-1));
    #local ArrayLoop=ArrayLoop+1;
   #end
  #else
   #local ArrayRight[0]=0;
   #local ArrayLoop=1;    
   #while (ArrayLoop<NoOfRows+2)
    #local ArrayRight[ArrayLoop]=ceil(ArrayRight[ArrayLoop-1]+(rand(Stagger)-0.4)*2);
    #local ArrayLoop=ArrayLoop+1;
   #end
  #end
 #else
  #local ArrayRight=array[NoOfRows+2] 
  #local ArrayLoop=1;    
  #while (ArrayLoop<NoOfRows+2)
   #local ArrayRight[ArrayLoop]=0;
   #local ArrayLoop=ArrayLoop+1;      
  #end
 #end
 //#debug concat("No Of Bricks is: ",str(NoOfBricks,0,0),"\n") 
 //#debug concat("No Of Rows is: ",str(NoOfRows,0,0),"\n")
 #local Loop1=0;
 #local Loop2=0;                
 #local BrickPigA=
  pigment {
   bozo
   pigment_map {
    [0.0 BrickPig1]
    [1.0 BrickPig2]
   }
   scale Length/2  
  }  
 #local BrickPigB = 
  pigment {
   BrickPigA
   warp {repeat x*EffectiveLength offset <0,Height,0>}
  }
 #local BrickPig = 
  pigment {
   BrickPigB
   warp {repeat y*EffectiveHeight offset <7.5*EffectiveLength,0,0>}
  }
 #local BrickTex = 
  texture {
   BrickTex1
   pigment {BrickPig}
  }
  
 union {
  #if (Windowx1 >0 | Windowx2>0 | Windowy1>0 | Windowy2 >0)  
   difference {
    union {  
     box {
      <BrickHeight*MortarThickness/200,0,BrickHeight*MortarThickness/300>,<NoOfBricks*EffectiveLength-BrickHeight*MortarThickness/60,EffectiveHeight-BrickHeight*MortarThickness/80,BrickHeight*1.2-BrickHeight*MortarThickness/200>      
      texture {MortarTex}
     }
     #local MortarLoop=1;
     #while (MortarLoop<NoOfRows)
       #if (StaggeredRight!=0)
        #local NoOfBricks=TotalBricks-ArrayRight[MortarLoop];
       #end
       #if (mod(MortarLoop,2)=1 & StaggeredLeft!=0)
        #local BrickBit1=0.5;
       #else
        #local BrickBit1=0;  
       #end
       #if (mod(MortarLoop,2)=1 & StaggeredRight!=0)
        #local BrickBit2=0.5;
       #else
        #local BrickBit2=0;  
       #end
       #if ((ArrayLeft[MortarLoop]+ArrayRight[MortarLoop])<TotalBricks)
        box {
         <ArrayLeft[MortarLoop]*EffectiveLength+BrickBit1*EffectiveLength+BrickHeight*MortarThickness/200,-BrickHeight*MortarThickness/80,BrickHeight*MortarThickness/300>,<NoOfBricks*EffectiveLength-BrickBit2*EffectiveLength-BrickHeight*MortarThickness/60,EffectiveHeight-BrickHeight*MortarThickness/80,BrickHeight*1.2-BrickHeight*MortarThickness/200>
         translate y*MortarLoop*EffectiveHeight
         texture {MortarTex}
        }
       #end                   
       #local MortarLoop=MortarLoop+1;
      #end
     }    
    /*box {
     <BrickHeight*MortarThickness/200,0,BrickHeight*MortarThickness/300>,<NoOfBricks*EffectiveLength-BrickHeight*MortarThickness/60,NoOfRows*EffectiveHeight-BrickHeight*MortarThickness/80,BrickHeight*1.2-BrickHeight*MortarThickness/200>
    }*/
    box {
     <EffectiveLength*(Windowx1-0.5)+BrickLength/2-BrickHeight*MortarThickness/100,EffectiveHeight*Windowy1-BrickHeight*MortarThickness/100,-1>,
        <EffectiveLength*(Windowx2+1)+BrickHeight*MortarThickness/100,EffectiveHeight*Windowy2+BrickHeight*MortarThickness/200,BrickHeight*2>
    }
    texture {MortarTex}
   }
   #debug concat("Windows is from: ",str(EffectiveLength*(Windowx1-0.5)+BrickLength/2-BrickHeight*MortarThickness/100,0,3),",",str(EffectiveHeight*Windowy1-BrickHeight*MortarThickness/100,0,3)," to ",str(EffectiveLength*(Windowx2+1)+BrickHeight*MortarThickness/100,0,3),",",str(EffectiveHeight*Windowy2+BrickHeight*MortarThickness/200,0,3),"\n")
  #else             
   box {
    <BrickHeight*MortarThickness/200,0,BrickHeight*MortarThickness/300>,<NoOfBricks*EffectiveLength-BrickHeight*MortarThickness/60,EffectiveHeight-BrickHeight*MortarThickness/80,BrickHeight*1.2-BrickHeight*MortarThickness/200>      
    texture {MortarTex}
   }
   #local MortarLoop=1;
   #while (MortarLoop<NoOfRows)
    #if (StaggeredRight!=0)
     #local NoOfBricks=TotalBricks-ArrayRight[MortarLoop];
    #end
    #if (mod(MortarLoop,2)=1 & StaggeredLeft!=0)
     #local BrickBit1=0.5;
    #else
     #local BrickBit1=0;  
    #end
    #if (mod(MortarLoop,2)=1 & StaggeredRight!=0)
     #local BrickBit2=0.5;
    #else
     #local BrickBit2=0;  
    #end 
    #if ((ArrayLeft[MortarLoop]+ArrayRight[MortarLoop])<TotalBricks)
     box {
      <ArrayLeft[MortarLoop]*EffectiveLength+BrickBit1*EffectiveLength+BrickHeight*MortarThickness/200,-BrickHeight*MortarThickness/80,BrickHeight*MortarThickness/300>,<NoOfBricks*EffectiveLength-BrickBit2*EffectiveLength-BrickHeight*MortarThickness/60,EffectiveHeight-BrickHeight*MortarThickness/80,BrickHeight*1.2-BrickHeight*MortarThickness/200>
      translate y*MortarLoop*EffectiveHeight
      texture {MortarTex}
     }                   
    #end
    #local MortarLoop=MortarLoop+1;
   #end    
  #end
  #debug concat("Max extent of the wall is <",str(TotalBricks*EffectiveLength-BrickHeight*MortarThickness/120,0,3),",",str(NoOfRows*EffectiveHeight-BrickHeight*MortarThickness/120,0,3),",",str(BrickHeight*1.2-BrickHeight*MortarThickness/200,0,3),">\n")
  #while (Loop1<NoOfRows)
   #if (StaggeredRight!=0)
    #local NoOfBricks=TotalBricks-ArrayRight[Loop1];
   #end    
   #while (Loop2<NoOfBricks)
    #if ((Loop2+1)>Windowx1 & (Loop2-1)<Windowx2 & (Loop1+1)>Windowy1 & Loop1<Windowy2) 
    #else     
     box {
      <0,0,0>,<BrickLength,BrickHeight,BrickHeight*1.2>
      translate <EffectiveLength*Loop2,EffectiveHeight*Loop1,0>
     }
    #end
    #local Loop2=Loop2+1;
   #end 
   #if ((Windowx1 > 0 | Windowx2>0) & (Loop1+1)>Windowy1 & Loop1<Windowy2)
     box {
      <0,0,0>,<BrickLength/2-BrickHeight*MortarThickness/200,BrickHeight,BrickHeight*1.2>
      translate <EffectiveLength*(Windowx1-0.5),EffectiveHeight*Loop1,0>
     }
     box {
      <0,0,0>,<BrickLength/2,BrickHeight,BrickHeight*1.2>
      translate <EffectiveLength*(Windowx2+1),EffectiveHeight*Loop1,0>
     }
   #end
   #local Loop1=Loop1+1;          
   #if (StaggeredLeft!=0)
    #local Loop2=0+ArrayLeft[Loop1];
   #else
    #local Loop2=0;
   #end
   #if (Loop1<NoOfRows) 
    #if (StaggeredLeft=0) 
     box {
      <0,0,0>,<BrickLength/2-BrickHeight*MortarThickness/200,BrickHeight,BrickHeight*1.2>
      translate <0,EffectiveHeight*Loop1,0>
     }
    #end
    #if (StaggeredRight=0)      
     box {
      <0,0,0>,<BrickLength/2-BrickHeight*MortarThickness/200,BrickHeight,BrickHeight*1.2>
      translate <EffectiveLength/2+EffectiveLength*(NoOfBricks-1),EffectiveHeight*Loop1,0>
     }
    #end
   #end    
   #if (StaggeredRight!=0)
    #local NoOfBricks=TotalBricks-ArrayRight[Loop1];
   #end
   #while ((Loop2<NoOfBricks-1) & (Loop1<NoOfRows))     
    #if ((Loop2+1.5)>Windowx1 & (Loop2-0.5)<Windowx2 & (Loop1+1)>Windowy1 & Loop1<Windowy2)  
    #else      
     box {
      <0,0,0>,<BrickLength,BrickHeight,BrickHeight*1.2>
      translate <EffectiveLength/2+EffectiveLength*Loop2,EffectiveHeight*Loop1,0>
     }
    #end    
    #local Loop2=Loop2+1;
   #end
   #if ((Windowx1 > 0 | Windowx2>0) & (Loop1+1)>Windowy1 & Loop1<Windowy2)
     box {
      <0,0,0>,<BrickLength/2-BrickHeight*MortarThickness/200,BrickHeight,BrickHeight*1.2>
      translate <EffectiveLength*(Windowx1-0.5),EffectiveHeight*Loop1,0>
     }
     box {
      <0,0,0>,<BrickLength/2,BrickHeight,BrickHeight*1.2>
      translate <EffectiveLength*(Windowx2+1),EffectiveHeight*Loop1,0>
     }
   #end 
   #local Loop1=Loop1+1;
   #if (StaggeredLeft!=0)
    //#debug concat("Loop counter is ", str(Loop1,0,0), "\n")
    #local Loop2=0+ArrayLeft[Loop1];
   #else
    #local Loop2=0;
   #end
  #end
  translate Start
  texture {BrickTex} 
  #if (SecondTexture!=0)
   texture {LayerTexture}
  #end
  bounded_by {
   box {
    <-BrickHeight*MortarThickness/200,-BrickHeight*MortarThickness/200,-BrickHeight*MortarThickness/200>,<Length+BrickHeight*MortarThickness/200,Height+BrickHeight*MortarThickness/200,BrickHeight*1.2+BrickHeight*MortarThickness/200>
    translate Start
   }
  }
 }
#end 

/* Example follows

object {
 BrickWall(5,3,0.8,0.2,10,pigment{Gray30},pigment{Gray70},texture{BrickTex},texture{Mortar})
 translate <-2.5,-0.5,0>
}

*/

#macro DistantWall(Length,Height,BrickLength,BrickHeight,MortarThickness,BrickPig1,BrickPig2,BrickTex1,MortarTex)
 #local EffectiveLength = BrickLength+BrickHeight*MortarThickness/100; 
 #local EffectiveHeight = BrickHeight+BrickHeight*MortarThickness/100;
 #local BrickPigA=
  pigment {
   bozo
   pigment_map {
    [0.0 BrickPig1]
    [1.0 BrickPig2]
   }
   scale Length/2  
  }  
 #local BrickPigB = 
  pigment {
   BrickPigA
   warp {repeat x*EffectiveLength offset <0,Height,0>}
  }
 #local BrickPig = 
  pigment {
   BrickPigB
   warp {repeat y*EffectiveHeight offset <7.5*EffectiveLength,0,0>}
  }
 #local BrickTex = 
  texture {
   BrickTex1
   pigment {BrickPig}
  }
 box {
  <0,0,0>,<Length,Height,BrickHeight*1.2>
  translate Start
  texture {
   brick texture {BrickTex} texture {MortarTex}
   brick_size <BrickLength,BrickHeight,BrickHeight*1.2>
   mortar BrickHeight*MortarThickness/100  
  } 
 }
#end