// Persistence of Vision Ray Tracer Scene Description File
// File: pavingstones.inc
// Vers: 3.1
// Desc: uneven paving stones, lie of stones depends on an underlying object 
// Date: 9 Jan 2000 
// Auth: Gail Shaw
                   
//Reorient macro by John VanSickle

#macro Reorient(Axis1,Axis2)
  #local vX1=vnormalize(Axis1);
  #local vX2=vnormalize(Axis2);
  #local vY=vnormalize(vcross(vX1,vX2));
  #local vZ1=vnormalize(vcross(vX1,vY));
  #local vZ2=vnormalize(vcross(vX2,vY));
  matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
  matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
#end                   

#declare DoTexture=true;

// Length defines the x and z dimensions of the paved area which always starts at <0,0,0>
// Height is the thickness of the stones
// UnderObject is the object that determines the orientation of the stone. Please note that
// if the UnderObject is smaller than the desired area, no stones will be layed in areas that
// the UnderObject does not cover. For something interesting try very small stones and
// a sphere as an object. The Flagsones macro does not place the Underobject in the scene. 
// The UnderObject should start at <0,0,0> and extend into the positive XZ quadrant
// MaxSize is the maximum size of a stone. At the moment the stones are square.
// StoneTex in the texture that will be applied to the stones. If DoTexture is set
// to false before calling the macro, the texture will not be applied (possibly of use for
// mosaics.

#macro FlagStones (Length,Height,UnderObject,MaxSize,StoneTex)
 #local FlagSize = Length/ceil(Length/MaxSize);     
 #debug concat("Flag Size is " , str(FlagSize,0,3),"\n")
 #local NoOfStones = Length/FlagSize; 
 #debug concat("No of stones is " , str(NoOfStones,0,0), "\n")
 #local StartPoint = <FlagSize/2,max_extent(UnderObject).y,FlagSize/2>;  
 #local TexSeed=seed(38839);
 #local Flagstone = 
  isosurface {
   function {(x^10+y^10+z^10)+noise3d(x*0.5,y*0.5,z*0.5)*0.3+noise3d(x*5,y*5,z*5)*0.35}
   threshold 1
   method 1      
   //eval           
   contained_by {box {<-2,-2,-2>,<2,2,2>}}
   accuracy 0.01    
   scale <FlagSize/2,Height,FlagSize/2>
   scale 0.98 
   translate y*Height/2
  }
   
 //#debug concat("Flag size is ",str(FlagSize,0,1),"\n")
 #local Loop1=0;
 #local Loop2=0;
 union {
  #while (Loop1<NoOfStones)
   #while (Loop2<NoOfStones)  
    #local Norm=<0,0,0>;           
    #local Intersect=trace(UnderObject,StartPoint+<FlagSize*Loop2,0,FlagSize*Loop1>,<0,-1,0>,Norm);
    #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
     object {
      Flagstone          
      Reorient(<0.0001,1,0>,Norm)
      translate Intersect 
      #if (DoTexture=true) 
       texture {StoneTex translate <rand(TexSeed)*50,rand(TexSeed)*30,rand(TexSeed)*80>}
      #end
     }
    #end
    #local Loop2=Loop2+1;
   #end
   #local Loop2=0;
   #local Loop1=Loop1+1;
  #end     
 }   
#end