// Persistence of Vision Ray Tracer Scene Description File
// File: ruincity.pov
// Vers: 3.14159
// Desc: A devistated city street, viewed from an alley
// Date: 06 Jan 2000 
// Auth: Gail Shaw
 
#version unofficial MegaPov 0.4;   
 
#include "kolors.inc"     
#include "metals.inc"
#include "ruincity.inc" 
#include "Buildings.inc"   
#include "atmos.inc"   
#include "junkobj.inc"   
#include "car.inc"  
#include "randobj.inc" 
#include "gttree1.inc" 
#include "teddy.inc"
#include "Weed.inc"

// switches to turn on or off various objects in the scene.

#declare ShowBuildings=1;
#declare ShowFloor=1;
#declare ShowCity=1;
#declare ShowJunk1=1;
#declare ShowJunk2=1;
#declare ShowCar=1;
#declare ShowFog=1;
#declare ShowClouds=1;  
#declare ShowTree=1;
#declare ShowPlant=1;   
#declare ShowBear=1;

global_settings {
 max_trace_level 20
 assumed_gamma 2.2
}
                                      
light_source {
 <49,500,380>
 White 
}

// main camera 

camera {
 location <5,4.1,-20>
 look_at <1.9,2.8,0>        
 //look_at <0,4,-15>
 angle 50  
}

// window camera
/*
camera {
 location <3,4.1,-5>
 look_at <6.9,4,-4>        
 //look_at <0,4,-15>
 angle 50  
} */

//filler light 
light_source {
 <1,10,-25>
 White*0.5   
 fade_distance 20
 shadowless
}


background {rgb <0.3591, 0.4375,0.5430>}

#if (ShowFloor=1)
 object {CloseFlagStones} 

 object {Dust}
 
 //object {Dust2}

 object {Road}

 object {DistantFlagStones}      
                             
 plane {
  y,-3
  pigment {Gray20}
 }                             
                              
#end

#if (ShowBuildings=1)  
 
 box {
  <-10,-3,-40>,<20,30,-41>
  pigment {Black}
 }

 object {RedWall}

 object {BrownWall}

 object {Window} 
 
 object {DistantBuilding scale 0.85 translate <-35,0,55>} 
 object {DistantBuild2 scale <0.75,0.8,0.85> translate <7,-1,80>}
 object {Wall}
 
 object {
  SingleGate 
  texture {T_Chrome_3A}
  texture {
   pigment {
    wrinkles
    color_map {
     [0.0 rgbt<0.2,0.2,0.2,0.2>]
     [0.6 rgbt<0.3,0.3,0.3,0.3>]
     [0.75 rgbt<0.4,0.4,0.4,0.4>]
     [1.0 rgbt<0.5,0.5,0.5,0.6>]
    }       
    turbulence 0.6
    translate x*5  
    //scale 0.1
   }
  }
  translate <-5.2,2.5,55>
 }

 object {
  GatePost
  translate <-8,2.5,55>
 } 
 
 object {
  GatePost
  translate <2,2.5,55>
 }

 box {
  <2,0,55.1>,<9,1.5,55.3>
  texture {
   pigment {Cornsilk1}
   finish {
    diffuse 0.3
   }
   normal {
    granite 0.5
    scale 0.1
   }
  }
  texture {
    pigment {
     wrinkles
     color_map {
      [0.0 rgbt<0.2,0.2,0.2,0.2>]
      [0.2 rgbt<0.3,0.3,0.3,0.3>]
      [0.35 rgbt<0.4,0.4,0.4,0.4>]
      [1.0 rgbt<0.5,0.5,0.5,0.6>]
     }       
     turbulence 0.6 
     scale <1,5,1>
     translate x*5  
     scale 0.6
    }
   }
 }
 
 object {
  GatePost
  translate <9,2.5,55>
 }
 
 box {
  <9,0,55.1>,<16.2,0.75,55.3>
  texture {
   pigment {Cornsilk1}
   finish {
    diffuse 0.3
   }
   normal {
    granite 0.5
    scale 0.1
   }
  }
  texture {
    pigment {
     wrinkles
     color_map {
      [0.0 rgbt<0.2,0.2,0.2,0.2>]
      [0.2 rgbt<0.3,0.3,0.3,0.3>]
      [0.35 rgbt<0.4,0.4,0.4,0.4>]
      [1.0 rgbt<0.5,0.5,0.5,0.6>]
     }       
     turbulence 0.6 
     scale <1,5,1>
     translate x*5  
     scale 0.6
    }
   }
 }
 
 object {
  GatePost
  translate <16.2,2.5,55>
 }
 
 object {
  GatePost
  translate <-3.4,2.5,55>
 }

#end

#if (ShowCity=1)
 object {City}   
 
 object {Hill}     
#end

#if (ShowJunk1=1)
 object {JunkPile}
                 
 object {DustbinLid}                 
                 
 object {Pipe} 

 object {LargeStone}

 object {Skull}

 object {Arm}         
 
 object {
  Dustbin
  scale 1
  rotate x*-90
  rotate y*-30
  translate <-3,1.45,-7.5>
 } 
#end

#if (ShowJunk2=1)
 object {
  Downpipe
  scale 1.2            
  rotate y*40
  translate <4.3,-0.23,-3.5>
 }
 
 object {CorregatedIron}
 
 object {
  Brick1()
  scale 0.9  
  rotate z*5
  translate <5.45,0.5,-9.78>
 }  
 
 object {
  Brick1()         
  rotate y*23
  translate <3.9,0.2,-9.2>
 }
 
 object {
  Brick1()         
  rotate y*-5
  translate <4.7,0.2,-8.2>
 }                          
 
 object {
  Brick1()   
  scale 0.9
  rotate z*-50
  translate <-2.05,2.5,-1.5>
 }
 
 object {
  Brick1()   
  scale 0.9
  rotate y*-40
  translate <-1.5,0.6,-1.7>
 }

 object {Death}
 
#end 

#if (ShowCar=1)
 object {
  Car
  rotate x*-90
  rotate y*95
  scale <-0.22,0.22,0.22>
  translate <14,2.3,34>
 }
#end

#if (ShowTree=1)
 object {
  Tree       
  scale 0.25 
  rotate y*10
  rotate x*-90
  rotate y*50
  translate <9,1,4>
 }
#end

#if (ShowPlant=1)
 object {
  Weed
  scale 0.04
  translate <1.82,0.5,-6>
  texture {
   pigment {
    spotted 
    color_map {
     [0.0 DarkGreen1]
     [0.25 DarkOliveGreen]
     [1.0 Sienna]
    }
    scale 0.01
   }
  }
 }
#end

#if (ShowBear=1)
 object {
  Bear
  scale 0.35
  rotate x*90
  //rotate z*-80
  rotate y*80
  translate <1.2,0.5,-10>
 }
#end

#if (ShowFog=1)
 fog {CityFog}
#end

#if (ShowClouds=1)
 object {Clouds}
#end