 // Persistence of Vision Ray Tracer Scene Description File
// Auth: Bob Franke
//

#version 3.1;

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "skies.inc"
#include "finish.inc"

//#declare notUseAsInclude = true;

#if (notUseAsInclude)

  global_settings{
    assumed_gamma 2.2
  }  
  
  camera{
    location  <0.0, 0.0, -8.0>
    direction 1.5*z  
    right     4/3*x
    look_at   <0.0, 0.0,  0.0>
  }
  
  sky_sphere{
    pigment{
      gradient y
      color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
    }
  }
  
  light_source{
    0*x // light's position (translated below)
    color White*2 // light's color
    translate <-10, 10, -30>
  }
#end //#if (notUseAsInclude)

//modified DMFLightOak
#declare DMFLightOak = 
pigment {
    wood
    turbulence 0.05            // For best results,  keep this low!
    scale <0.2, 0.2, 1>        // Scaled for a unit object
    color_map {
        [0.0 Silver*.6]
        [0.2 Silver*.6]
        [0.9 Silver + Brown*.3]
    }
}


#declare xRusty_Iron = 
texture {
  pigment {
    granite
    color_map {
      [0.0 rgb <0.42*1.1, 0.20, 0.20>*1.2]
      [0.5 rgb <0.50*1.1, 0.50, 0.02>*1.2]
      [0.6 rgb <0.60*1.1, 0.20, 0.20>*1.2]
      [0.6 rgb <0.30*1.1, 0.20, 0.20>*1.2]
    }
  }
  finish { ambient 0.2 diffuse 0.6 }
  normal { wrinkles 1 scale 0.1 }
}
  

#declare Rust =
texture { 
    pigment {
        granite
        color_map {
            [0.0 rgb <0.89*.75, 0.51, 0.28>]
            [0.4 rgb <0.70*.75, 0.13, 0.00>]
            [0.5 rgb <0.69*.75, 0.41, 0.08>]
            [0.6 rgb <0.49*.75, 0.31, 0.28>]
            [1.0 rgb <0.89*.75, 0.51, 0.28>]
        }
    }
    finish { ambient 0.2 diffuse 0.4 }
}



//#declare Dull = finish {specular 0.8 roughness 0.02}
//#declare Shiny = finish {specular 1 roughness 0.001}


#declare zz=0; 
#declare rimSection=
difference{
  merge{
   difference{ 
    cylinder{<0,0,-0.12>,<0,0,0.12> ,1.96}      
    cylinder{<0,0,-1>,<0,0,1> ,1.71}     
   }  
    


   difference{ 
    cylinder{<0,0,-0.08>,<0,0,0.08> ,2.0}     
    cylinder{<0,0,-1>,<0,0,1> ,1.67}    
   }  

    torus{1.96,0.04 rotate<90,0,0> translate<0,0,-0.08>  }
    torus{1.96,0.04 rotate<90,0,0> translate<0,0,0.08>  }
    torus{1.71,0.04 rotate<90,0,0> translate<0,0,-0.08>  }
    torus{1.71,0.04 rotate<90,0,0> translate<0,0,0.08>  } 
  } 
  
  box{<-4,0,1>,<4,5,-1> rotate<0,0,-11.25>}
  box{<-4,0,1>,<4,-5,-1> rotate<0,0,11.25>}
}  

#declare spoke=
cone{<0,.38,0>,0.05*1.5 <0,2,0>, 0.03*1.5  
  pigment{Clear} 
}

#declare woodRim=
union{ 
  union{
    union{
      #while (zz < 360)
        object{rimSection rotate<0,0,zz>}   
        #declare zz=zz+22.5;
      #end 
      texture{pigment{ Silver}
        normal{  
          bump_map { 
            gif "rim3.gif"
            bump_size 12
            interpolate 2  
          }  
          translate <-.5, .5, 0> 
          scale 4
        } 
        finish {Shiny  crand .22 ambient .2}
      }  
    }  
 
    difference{ 
      cylinder{<0,0,-0.08>,<0,0,0.08> ,2.025}     
      cylinder{<0,0,-1>,<0,0,1> ,2.0}  
      texture{xRusty_Iron scale .1}
    }   
    scale<1,1,1.5>    
  }    
      
      
  #declare R2 = seed(12345);   
  #declare zz=0;
  #while (zz < 360)
    object{spoke 
      texture{pigment{ Silver}
        normal{  
          bump_map { 
            gif "vwood.gif"
            bump_size 6
            interpolate 2 
          }  
        }  
        translate <-.5, .5, 0> 
        scale 2
        translate <rand(R2),rand(R2) ,0> 
        rotate<0,rand(R2)*360,0> 
        finish {Shiny  crand .10 ambient .1}
      }  
      scale<.75,1,1>
      rotate<0,0,zz>
    } 
    #declare zz=zz+22.5;
  #end 
     
  difference{  
    union{
      cylinder{<0,0,0>,<0,0,.2>,.4 } 
      cone{<0,0,0>,0.4 <0,0,-.3>, .325 }
    }                                    
    cylinder{<0,0,-.8>,<0,0,.8>,.15 }  
    sphere{<0,0,-.60>,.43 }
    texture{pigment{DMFLightOak  scale .1 rotate <0,.05,0> translate<0,.08,0>} 
      normal{  
        bump_map { 
          gif "hubmap.gif"
          bump_size 1.5
          interpolate 2 
          once  
        }  
        translate <-.5, .5, 0> 
        scale 1.2
      } 
      finish {
//        Shiny  
        crand .4}
    } 
  }      
 
} 

#if (notUseAsInclude)
  object{woodRim  rotate<0,55,0>}      
#end 









/*


#declare hole= 
sphere { <0, 0, 0>, 25
//   pigment {Red}
   normal {
      bump_map {
         gif "c:\pov-ra~1\include\plasma3.gif"
         bump_size 100
//         interpolate 2
         once
      }
      scale 50             
      translate <-25, -25, 0>
   }
//   finish {ambient 0.2 diffuse 0.7 specular 0.6}      
    texture{pigment{ Silver}
    normal{  
      bump_map { 
        gif "rim3.gif"
        bump_size 15
        interpolate 2   
      }  
      translate <-.5, .5, 0> 
      scale 4
    } 
    finish {Shiny  crand .15}
    }  
   scale 1/200 

} 
*/
/* 
*/ 



