// Persistence of Vision Ray Tracer Scene Description File
// File: BobineEDF.inc
// Vers: 3.1
// Desc: 
// Date: 
// Auth: 

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "coulphil.inc" // Mes couleurs
//#include "MYTEXTUR.INC" // Mes textures
//#include "METALS.INC"
//#include "GOLDS.INC"
#include "woods.inc"
//#include "skies.inc"
//#include "CONSTS.INC"
//#include "CHARS.INC"
//#include "glass.INC"
//#include "stones.inc"


// *********************************************************************

// Bobine de cable EDF
#declare Planche_Rayon1 = difference
{
cylinder
{
  0*y,  0.55*y,  0.5
  
}
union {
        cylinder
        {
        -y,  y,  0.05
        }

        box {<0,-1,-1>,<1,1,1>
        rotate 0.5*y
            }

        box {<0,-1,-1>,<-1,1,1>
        rotate 14.5*y
            }
     }
}

#declare Planche_Rayon = union
{
   intersection
   {
        object {Planche_Rayon1}
        cylinder
                {
                0.041*y,  0.51*y,  0.25
                }
   }

   intersection
   {
        object {Planche_Rayon1}
        cylinder
                {
                0.5*y,  0.551*y,  0.499
                }
   }

   intersection
   {
        object {Planche_Rayon1}
        cylinder
                {
                0.0*y,  0.051*y,  0.499
                }
   }

}


#declare R1 = seed(3156);

#declare Bobin1 = union {
#declare tourne = 360;
#while (tourne>0)
object {Planche_Rayon rotate tourne*y
texture { T_Wood27 scale 0.1 rotate 360*rand(R1)}
}
#declare tourne = tourne-15;
#end
}

#declare cerclage = difference
{
   cylinder
           {
           0.5*y,  0.55*y,  0.51
           }
   cylinder
           {
           0.4*y,  0.56*y,  0.50
           }
   texture {Rust scale 0.1}
}
#declare BobineEDF = union 
{
object {cerclage}
object {cerclage translate -0.5*y}
object {Bobin1}
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// CaisseBois 40 x 30 x 50

#declare CouvercleCB = union
{

box {<-0.20, 0,-0.30>,<0.20, 0.05, -0.205>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    } 
box {<-0.20, 0,-0.195>,<0.20, 0.01, -0.105>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    } 
box {<-0.20, 0,-0.095>,<0.20, 0.01, -0.005>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    } 
box {<-0.20, 0,0.005>,<0.20, 0.01, 0.095>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    } 
box {<-0.20, 0,0.105>,<0.20, 0.01, 0.195>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    } 
box {<-0.20, 0,0.205>,<0.20, 0.05, 0.30>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    } 
} // Couvercle
     
#declare PlancheCB = union
{
box {<-0.20, 0,-0.30>,<-0.17, 0.05, 0.30>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    } 
box {<-0.20, 0.25,-0.30>,<-0.17, 0.30, 0.30>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    } 

box {<-0.19, 0.05,-0.29>,<-0.18, 0.25, -0.205>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    }
box {<-0.19, 0.05,-0.195>,<-0.18, 0.25, -0.105>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    }
box {<-0.19, 0.05,-0.095>,<-0.18, 0.25, -0.005>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    }

box {<-0.19, 0.05,0.005>,<-0.18, 0.25, 0.095>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    }
box {<-0.19, 0.05,0.105>,<-0.18, 0.25, 0.195>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    }
box {<-0.19, 0.05,0.205>,<-0.18, 0.25, 0.29>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    }
    
}

#declare PlancheCB2 = union
{
box {<-0.19, 0.05,-0.29>,<-0.105, 0.25, -0.28>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    }
box {<-0.095, 0.05,-0.29>,<-0.005, 0.25, -0.28>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    }
box {<0.005, 0.05,-0.29>,<0.095, 0.25, -0.28>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    }
box {<0.105, 0.05,-0.29>,<0.19, 0.25, -0.28>  
        texture { T_Wood23 scale 0.1 rotate 360*rand(R1)}
    }

} 



#declare CaisseBois = union
{
object {CouvercleCB}
object {CouvercleCB rotate 180*x translate 0.30*y}

object {PlancheCB}
object {PlancheCB translate 0.38*x}

object {PlancheCB2}
object {PlancheCB2 translate 0.56*z}

}

