// Persistence of Vision Ray Tracer Scene Description File
// File: LitFer.inc
// Vers: 3.1
// Desc: 
// Date: 
// Auth: 

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "coulphil.inc" // Mes couleurs
//#include "MYTEXTUR.INC" // Mes textures
//#include "METALS.INC"
//#include "GOLDS.INC"
//#include "woods.inc"
//#include "skies.inc"
//#include "CONSTS.INC"
//#include "CHARS.INC"
#include "glass.INC"
//#include "stones.inc"

// Lit de fer 

// texture du lit
#declare T_FerLit =
texture {
    pigment {
        granite
        color_map {
            [0.0 Gray15]
            [0.5 Gray35]
            [0.6 rgb <0.50, 0.20, 0.20>]
            [0.6 rgb <0.30, 0.20, 0.20>]
        }
    }
    finish { ambient 0.2 diffuse 0.6 }
    normal { wrinkles 1 scale 0.1 }
}

// ********************
#declare montantLit1 = difference
{
torus {0.2,0.015
rotate 90*x
}
union {
box {-1,1 translate 1*x}
box {-1,1 translate -1*y} 
      }
translate -0.2*x
} // *********************************

#declare montantLit2 = difference
{
torus {0.2,0.015
rotate 90*x
}
union {
box {-1,1 translate -1*x}
box {-1,1 translate -1*y} 
      }
translate 0.2*x
} // *********************************
#declare MontantLit = union {
cylinder {-.2*x,.2*x,0.015
translate 0.6*y
}

cylinder {0.0*y,.4*y,0.015
translate -0.4*x
}

cylinder {0.0*y,.4*y,0.015
translate 0.4*x
}

box {<-0.4,0.3,-0.01>,<0.4,0.32,0.01>
}

object {montantLit1 translate 0.4*y}
object {montantLit2 translate 0.4*y}
}
// *********************************
// Sommier

#declare Sommier = union {
box {<-0.4,0.3,0.0>,<-0.41,0.32,-1.8>
}
box {<0.4,0.3,0.0>,<0.41,0.32,-1.8>
}

}

#declare LitFer = union {
object {MontantLit}
object {MontantLit translate -1.8*z}
object {Sommier}
   texture {T_FerLit //scale 0.1
           }
}

//object {LitFer}

//**********************************************************************

// Corde de pendu

   #declare link_object = union {sphere {<0,2,0>,3} sphere{<0,-2,0>,3}}
//   #declare scale_links = 1
   #declare link_count = 200;
   #declare link_twist = -.05;
   #declare link_looseness = 12;
//   #declare link_size_turb = 0.5
//   #declare link_seed = 84
//   #declare link_size_turb = 0.8
   #declare link_point1 = <-10, 6, -3>;
   #declare link_point2 = <10, 6, -3>;
   #declare Corde = #include "LINK.INC"
   #declare Anneau = union 
{ 
   object {Corde texture {Yellow_Pine}
         scale 0.5
         translate <0,-3,1.5>
        }

  object {Corde texture {Yellow_Pine}
         rotate 180*x
         scale 0.5
         translate <0,3,-1.5>
        }

}
   #declare link_count = 20;
   #declare link_twist = -.5;
   #declare link_looseness = 0;
   #declare link_point1 = <-5, 6, -3>;
   #declare link_point2 = <5, 6, -3>;
   #declare Corde = #include "LINK.INC"
   #declare Noeud =
   object {Corde texture {Yellow_Pine}
         rotate 90*z
         scale 1
         translate <6,20,0>
        }

   #declare link_count = 250;
   #declare link_twist = -.05;
   #declare link_looseness = 0;
   #declare link_point1 = <-20, 6, -3>;
   #declare link_point2 = <20, 6, -3>;
   #declare Corde = #include "LINK.INC"
   #declare Corde_Liee =  
 
   object {Corde texture {Yellow_Pine}
         rotate 90*z
         scale 1
         translate <6,40,0>
        }



#declare Pendu = union 
{
object {Anneau translate -6*z rotate 10*x}
object {Noeud }
object {Corde_Liee}
translate -60*y
scale 0.010
}


//**********************************************************************

