// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: 
// Date: 
// Auth: 
#version unofficial MegaPov 0.4;

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "coulphil.inc" // Mes couleurs
#include "MYTEXTUR.INC" // Mes textures
//#include "METALS.INC"
//#include "GOLDS.INC"
//#include "woods.inc"
//#include "skies.inc"
//#include "CONSTS.INC"
//#include "CHARS.INC"
#include "glass.INC"
//#include "stones.inc"

global_settings{
  photons{
    count 20000
    autostop 0
    jitter .4
  } 
ini_option "+QR" // turn on radiosity  
ambient_light color rgb <0.6941176,0.7137254,0.8196078>*0.25
}

#declare True = 1;
#declare False = 0;


#declare PI=3.1415926535897;

#declare camera_location = <-1.50, 0.85, -2.0>;
//#declare camera_location = <-0.5,1.3,-0.575>;
#declare camera_look_at = <0.0, 1.15, 1.0>;
//#declare camera_look_at = <-2.20,1.9,1.85>;
#declare flare_position = <-100,80,60>;
//#include "LensFlar.inc"


background {color Gray35}


// set viewer's position in the scene
camera
{   ultra_wide_angle
//  perspective (default) | orthographic | fisheye |
//  ultra_wide_angle | omnimax | panoramic | cylinder 1
  location  camera_location
  direction 1.0*z
//  sky       y
  up        y
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   camera_look_at
  angle 105
  normal { ripples 0.2 }
  aperture 0.2
  blur_samples 4
  focal_point <0.7,2.75,-0.575>
}



light_source
{
  <-100,80,60> // flare_position
  color rgb <0.6941176,0.7137254,0.8196078> 

} 

// light_source {0*x color Or translate <0, 2.5 , -2> }




#declare Soltex = texture {
                        pigment {
                        checker 
                                color Blanc
                                color Noir
                                }
                        finish {
                                ambient   0.10
                                diffuse   0.40
                                brilliance   0.15
                                phong   1.00
                                phong_size  20.00
                                specular  1.0000
                                roughness  0.0010
                                reflection  0.15
                                }
                        scale 0.2
}


plane{y,0 texture {Soltex} hollow}

// ************************************************************

#include "Bougeoir.inc"
#include "BobineEDF.inc"
#include "BouteilleVin.inc"
#include "LitFer.inc"
#include "Matelat.inc"
#include "Cuisine.inc"
object {BobineEDF rotate 12*y translate <-1.5,0,-0.1>}
object {Bougeoir rotate 9*y translate <-1.30,0.45,-0.4>}
object {BouteilleVin translate <-1.80,0.45,-0.2>}
object {BouteilleVin translate <-0.80,0.0,0.0>}
object {BouteilleVin translate <-1.25,0.0,-0.8>}
object {BouteilleVin translate <-1.45,0.0,-0.7>}
object {BouteilleVin rotate 90*z rotate -17*y translate <-0.1,0.1,-0.9>}
object {BouteilleVin rotate 90*z rotate 40*y translate <-0.7,0.1,-1>}
object {Boite_Conserve translate <1.0,0,1>}
object {Boite_Conserve rotate 15*y translate <0.80,0,1.2>}
object {Boite_Conserve rotate -25*y translate <1.10,0,0.8>}
object {Boite_Conserve rotate 90*x rotate 115*y translate <0.65,0.12,-1.25>}
object {Boite_Conserve rotate 90*x rotate -115*y translate <-1.80,0.12,-0.80>}
union {
        object {Muret_evier}
        object {evier}
        rotate 90*y translate <2.5,0.0,0>
}
object {BouteilleVin translate <2.25,0.0,-0.3>}

object{Robinet rotate 90*y translate <2.45,1.25,-0.3>}
object {Casserole rotate 90*z rotate 180*y translate <0,0.05,-0.06> translate <2.36,1.55,0.0>}
object {Casserole scale 1.1 rotate 90*z rotate 180*y translate <0,0.05,-0.06> translate <2.36,1.52,-0.4>}


union {
        object {LitFer }
        object {Matelat 
              translate <0,0.3,-1.8>
               }
        scale 1.2
        translate <1.5,0,2.5>
      }       

object {CaisseBois
       rotate 35*y
       translate <0.8,0,2.0>
       }   
object {BouteilleVin translate <0.8,0.3,2>}

#declare Mur_RPL = 
difference {
    union {
        box {<-2.5,0,3.005>,<2.5,6.0,3.5>
                texture {
                        pigment
                                {
                                brick      color Gray, color Rouge_Brique
                                brick_size <2,1,1>   // size of brick
                                mortar     0.2       // width of mortar
                                scale 0.2
                                }
                        normal 
                                {                           
                                brick
                                brick_size <2,1,1>   // size of brick
                                mortar     0.2       // width of mortar
                                scale 0.2
                                }
                        }
            }
        difference 
                {
                box {<-2.5,0,3>,<2.5,10.0,3.5>
                        texture {Crepi scale 0.5}
                    }

                height_field
                        {
                        gif "E:\Images\Lezard2.gif"
                        pigment {Noir}
                        rotate 180*x
                        water_level 0 
                        scale <5,1000,6>
                        rotate 90*x
                        translate 3.05*z
                        translate -2.0*x
                        texture {Crepi}
                        }
                } 
        }
       box {<-1,1,-1.5>,<-0.25,3,1.5> texture {Crepi scale 0.5}
                translate <-1.0,-0.5,2.90>
           } // Trou de la fentre
}

object {Mur_RPL}


#include "huis.inc"
object {Grande_fenetre_cassee 
                // rotate -90*y 
                translate <-2.0,0.5,3.2>
       } // fenetre 1

box {<2.5,0,3.5>,<2.55,5.0,-2.5>
       texture {Enduit}
    }

// Lezarde *************************************************
//box {<-2.5,0,3.5>,<-2.55,6.0,-1.5>
#declare Mur_Lezarde =
intersection {
box {<-2,0,0>,<7,6.0,0.5>
       texture {Enduit}
    }

height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "E:\Images\Lezarde.gif"     // the file name to read
   pigment {Noir}
   rotate 180*x
//  inverse | texture {...}
//  [smooth]        // make smoother surface
   water_level 0 // truncate/clip below N (0.0 ... 1.0)
// translate VECTOR | rotate VECTOR | scale VECTOR
scale <6,1000,6>
rotate 90*x
translate .05*z
translate 1*x

}
rotate -90*y
translate <-2.5,0,-3.5>
}

object {Mur_Lezarde} 

box {<-2.55,0,-2.5>,<2.55,6.0,-2.250>
       texture {Enduit}
    }

#include "Froissee.inc"
object {Feuille_froissee rotate 90*x scale 0.2
        translate <-0.25,0.01,-1.2>
       }
       
#include "Affiche.inc"
object {Affiche 
                rotate 90*y
                translate <2.49,1.0,1.5>
       }
// Toit en tle ********************************************

#include "ToleOndulee.inc"
object {Tole_ondulee
        //        translate 3*y
        rotate 90*y
        scale 0.02
        translate <4,0,4>
        rotate 150*z
        translate <2.5,2.6,-2.5>
       }

// Pleintes *************************************************

box{<-2.5,0,2.990>,<2.5,0.15,3.5>
        texture { T_Wood23 scale 0.1}
   }

box{<-2.49,0,-1.5>,<-2.5,0.15,3.5>
        texture { T_Wood23 scale 0.1}
   }
difference {   
box{<2.49,0,-1.5>,<2.5,0.15,3.5>
        texture { T_Wood23 scale 0.1}
   }
box {<0,0,0>,<0.5,0.5,0.5>   
        texture { T_Wood23 scale 0.1}
        //pigment {Vert}
        rotate 35*x   
        translate <2.48,0.17,0.35>
   }
}
   
   
// Fils lectriques *****************************************
cylinder {<2.495,0.155,-1.5>,<2.495,0.155,3.5>,0.005
          texture {Plastique_Gris}
         }
cylinder {<2.495,0.155,2.0>,<2.495,2.0,2.0>,0.005
          texture {Plastique_Gris}
         }
// Interrupteur *********************************************
sphere {0,0.025
        texture {Silver_Texture}
        scale <0.8,0.95,0.95>
        translate <2.49,1.5,2.0>
       }
cylinder {0*x,-0.03*x,0.025       
        texture {Plastique_Bl}
        translate <2.515,1.5,2.0> 
       }
       
// Applique *************************************************       
intersection {
        torus
                {
                0.4,
                0.0075
                texture {Plastique_N}
                rotate 90*x
                }
        box
                {<-1,0,-1>,<0,1,1>
                texture {Plastique_N}
                }
            translate <2.5,1.6,2>
            }
cylinder {<-0.04,0,0>,<0,0,0>,0.06
        texture { T_Wood23 scale 0.1}
            translate <2.5,2,2>
            }
        
cylinder {0*y,-0.03*y,0.015
        texture { Brass_Texture}
            translate <2.1,1.6,2>
            }

object {Ampoule translate <2.1,1.6,2>
       }            
       
// Poutres **************************************************

box{<-6,0,0.0>,<0,0.25,0.25>
        texture { T_Wood23 scale 0.1}
        rotate -30*z
        translate <2.6,2.4,2.3>
   }
box{<-6,0,0.0>,<0,0.25,0.25>
        texture { T_Wood23 scale 0.1}
        translate <2.6,2.5,2.3>
   }
box{<-6,0,0.0>,<0,0.25,0.25>
        texture { T_Wood23 scale 0.1}
        translate <2.6,2.5,-0.7>
   }

// Corde de pendu **************************************************

// object {Pendu translate <0.7,2.95,-0.575>} 
// Pendu ************************************************** 
 #include "Hung03b.inc"
// object {HungMan translate <0.7,0.20,-0.55>}      

union {
       object {Pendu 
                translate <0.0,2.95,0.0>
              }
       object {HungMan 
                translate <0.02,0.840,0>
              }
translate <0.7,0.0,-0.575>               
}
// Tabouret **************************************************
#declare Pied_Tabouret_Bois = 
        cylinder {-0.4*y,0.0*y,0.03
                texture {Yellow_Pine}
                rotate 10*z
                translate <0.075,0.4,0>
                 }




#declare Tabouret_Bois = union
{
object {Pied_Tabouret_Bois
}
object {Pied_Tabouret_Bois 
                rotate 120*y}
object {Pied_Tabouret_Bois 
                rotate -120*y}
cylinder {0.35*y,0.41*y,0.15
                texture {Yellow_Pine}
         }
}

object {Tabouret_Bois  rotate 80*z rotate 20*y translate <0.7,0.1,-0.575>}


#declare lintau = 1.5;
#declare Lporte = 1;
#declare Epaismur = 0.5;
#declare Fenestron = 0;
#declare Fenetre = 0;
#include "torchi.inc"

// -3-
object {Mur1
       //rotate -90*y
       translate <0,0,10>
       }
// carrelage *********************************************************
#declare carreau =
 superellipsoid {<0.1, 0.1>
                translate 1*y
                }

// ------------------------------------------------------------------



#declare panneau = union {
#declare murY=0;
#while (murY<6)
#declare murX=0;
#while (murX<6)
object {carreau
       translate <murX*2,murY*2,0>}
#declare murX=murX+1;
#end
#declare murY=murY+1;
#end
}
#declare CarTex = texture { pigment {rgb 1} finish {ambient 0.2 reflection 0.4 specular 0.7} }
object {panneau // X Fond
       rotate -90*y
       scale 0.1
       translate <2.58,0.60,-1.0>
       texture {CarTex}
       }

// Etagere *******************************************
#declare Etagere_Biblio = 
        box {<0.0,0.0,0.30>,<1.5,0.02,0.0>
                texture {T_Wood3}
        } // Corps du bureau

object {Etagere_Biblio rotate -90*y translate <-2.2,1.8,1.750>}
object {BouteilleVin translate <-2.25,1.82,2.25>}
object {BouteilleVin translate <-2.28,1.82,1.85>}

// Lettre de Faillite *********************************
#include "Affiche.inc"
object{Faillite rotate 67*y translate <-1.38, 0.595, -1.845>}

// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color Or2       // light's color
  spotlight               // this kind of light source
  translate <-1.55, 1.30, -2.1> // <x y z> position of light
  point_at <-1.35, 0.595, -1.9>      // direction of spotlight
  radius 3                // hotspot (inner, in degrees)
  tightness 20            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 10               // intensity falloff radius (outer, in degrees)
}



