#declare Test_G = off;

#include "colors.inc"
#include "stones.inc"

#include "reorient.mcr"

#declare TextureGalet = array[10]

#declare TextureGalet[0] = texture { T_Stone19 finish {phong 0.1} }
#declare TextureGalet[1] = texture { T_Stone3 finish {phong 0.5} }
#declare TextureGalet[2] = texture { T_Stone4 finish {phong 0.1} }
#declare TextureGalet[3] = texture { T_Stone15 finish {phong 0.2} }
#declare TextureGalet[4] = texture { T_Stone19 finish {phong 0.1} }
#declare TextureGalet[5] = texture { T_Stone12 finish {phong 0.1} }
#declare TextureGalet[6] = texture { T_Stone19 finish {phong 0.4} }
#declare TextureGalet[7] = texture { T_Stone24 finish {phong 0.1} }
#declare TextureGalet[8] = texture { T_Stone15 finish {phong 0.3} }
#declare TextureGalet[9] = texture { T_Stone16 finish {phong 0.1} }

#macro Galet(tmax, tmin, ep, rnd)

#local St = seed(rnd*38321);

object {
	blob {
		sphere { <-.4 + rand(St)*.1, 0, 0>, 1, 1 }
		sphere { <.3 - rand(St)*.1, 0, 0>, .8, 1 }
		threshold .1
	}
	scale <tmax, ep, tmin>
	texture { TextureGalet[min(9, floor(rand(St)*10))] translate 124+3041*rand(St) }
}

#end


#macro PlaceGaletSur(Obj, Pos, tmax, tmin, ep, rnd, sc)

#local St = seed(rnd*1234);

#local Norm = <0,0,0>;
#local Start = Pos + 1000*y;
#local Inter = trace(Obj, Start, -y, Norm);

#if ((Norm.x!=0) | (Norm.y!=0) | (Norm.z!=0))

	#if (vdot(y, vnormalize(Norm)) > .2)
	object {
		Galet(tmax, tmin, ep, rand(St)*12345)
		scale sc*.7 + .6*sc*rand(St)
		rotate rand(St)*360*y
		/* test si Norm est non-vertical */
		#if (vdot(y, vnormalize(Norm)) < 1)
		Reorient(y, Norm)
		#end
		translate Inter
	}
	#end

#else
	#debug "Pas d'intersection"
#end

#end

#if (Test_G)

camera {
	location <0,0,-3>
	right x*4/3
	up y
	look_at <0,0,0>
}


light_source { <100,100,-100> color rgb 1}

#declare Truc = sphere {
	0, 3
	translate -3*y
	pigment { rgb <1,0,0> }
	finish { ambient .4 diffuse .6 }
}

object { Truc }


PlaceGaletSur(Truc, <0, 0, -.2>, .8, .5, .3, 12, .4)
PlaceGaletSur(Truc, <-.5, 0, -.5>, .8, .5, .3, 1212, .4)
PlaceGaletSur(Truc, <.5, 0, -.5>, .8, .5, .3, 121, .4)



#end
