// Persistence of Vision Ray Tracer Scene Description File
// File: facade_brick.pov
// Vers: 3.1
// Desc: IRTC 01-02/2000 ruines
// Date: 16 janvier 2000 
// Auth: Franck Becquart
 
#include "colors.inc" 
#include "textures.inc"	
#include "stones1.inc"	
#include "woods.inc"
#include "glass.inc"
#include "blinde.pov"
#include "cloture.pov"
#include "skies.inc"    
#include "pilone elec.pov"                

              /*                    
  
camera { location <4.5,1.5,-7> look_at <5,1.5,0> } 
      
light_source{<00,500,-510> color White*1.5} 
  
plane{y,0 pigment{Gray}translate y*-0.001 }

background{SkyBlue}      
                       
                      */
                       

#declare Beige= color rgb <0.94, 0.93, 0.88>;


#declare T_Grnt222 = texture {
  pigment {
    granite
    turbulence 0.0
    color_map {
      [0.0, 0.07 color Black color Black]
      [0.07, 0.2 color Black color Black]
      [0.2, 0.3 color Black color Black]
      [0.3, 0.7 color Black color Black]
      [0.7, 1.0 color Black color Black]
    }
  }
  finish {
    crand 0.02
  }
}

#declare bruler = texture {
  pigment {
    wrinkles
    turbulence 0.1
    color_map {
      [0.000, 0.300 color rgb <0.94, 0.93, 0.88>
      color rgb <0.000000, 0.000000, 0.000000>] 
      [0.000, 0.200 color rgb <0.94, 0.93, 0.88>
      color rgb <0.000000, 0.000000, 0.000000>]
      [0.800, 1.000 color rgb <0.20, 0.20, 0.20>
      color rgb <0.329412, 0.329412, 0.329412>]
    }
  }
  finish {
    crand 0.05
  }
  scale <0.5,2,0.5>
}


//=== briques ===//
#declare brick1=  
box { <0,0,0>,<0.085,0.06,0.2>    pigment { color Firebrick } }        // brique-angle

#declare brick2=
box { <0,0,0>,<0.200,0.06,0.2>    pigment { color Firebrick } }        // brique entiere double 

#declare brick3=  
box { <0.445,-0.03,0>,<0.645,0.03,0.2>  pigment { color Firebrick } }  // brique pour l'arche

#declare brick4=  
box { <0,0,0>,<0.1,0.06,0.2>    pigment { color Firebrick } }          // demi-brique

#declare brick5=  
box { <0,0,0>,<0.06,0.1,0.2>    pigment { color Firebrick } }          // brique verticale

#declare brick6=
box { <0,0,0>,<0.100,0.06,0.2>    pigment { color Firebrick } }        // brique entiere simple

#declare brick7=  
box { <0,0,0>,<0.1,0.06,0.1>    pigment { color Firebrick } }          // demi-brique


//=== montages des briques ===//
#declare bande1=
union {
object { brick2 translate x*0.000 } 
object { brick2 translate x*0.215 }
object { brick2 translate x*0.430 } 
object { brick2 translate x*0.645 }
}
#declare bande2=
union {
object { brick2 translate x*0.000 } 
object { brick2 translate x*0.215 }
object { brick2 translate x*0.430 } 
}
#declare bande3=
union {
object { brick2 translate x*0.000 } 
object { brick2 translate x*0.215 }
object { brick2 translate x*0.435 } 
object { brick2 translate x*0.655 } 
object { brick2 translate x*0.875 } 
object { brick2 translate x*1.090 } 
object { brick2 translate x*1.305 }
}
#declare ligne1=
union  {
object { bande1 translate x*0.000 } 
object { bande1 translate x*0.860 } 
object { bande1 translate x*1.720 } 
object { bande1 translate x*2.580 }
object { brick2 translate x*3.440 }
object { brick1 translate x*3.655 }
object { brick2 translate x*3.755 }
object { brick2 translate x*4.845 }
object { brick1 translate x*5.060 }
object { bande1 translate x*5.160 } 
}
#declare ligne2=
union  {
object { brick1 translate x*0.000 }        
object { bande1 translate x*0.100 } 
object { bande1 translate x*0.960 } 
object { bande1 translate x*1.820 } 
object { bande1 translate x*2.680 }
object { brick2 translate x*3.755 }
object { brick2 translate x*4.845 }
object { brick2 translate x*3.540 }
object { bande1 translate x*5.060 } 
object { brick1 translate x*5.920 }
}
#declare ligne3=
union  {
object { bande2 translate x*0.000 }
object { brick1 translate x*0.645 }
object { brick4 translate x*2.895 }
object { bande2 translate x*3.010 }
object { brick1 translate x*3.655 }
object { brick2 translate x*3.755 }
object { brick2 translate x*4.845 }
object { brick1 translate x*5.060 }
object { bande1 translate x*5.160 } 
}
#declare ligne4=
union  {
object { brick1 translate x*0.000 }        
object { bande2 translate x*0.100 }
object { bande1 translate x*2.895 }
object { brick2 translate x*3.755 }
object { brick2 translate x*4.845 }
object { brick2 translate x*3.540 }
object { bande1 translate x*5.060 } 
object { brick1 translate x*5.920 }
}
#declare ligne5=
union  {
object { bande2 translate x*0.000 }
object { brick1 translate x*0.645 }
object { brick4 translate x*2.895 }
object { bande2 translate x*3.010 }
object { brick1 translate x*3.655 }
object { brick1 translate x*5.060 }
object { bande1 translate x*5.160 } 
}                    
#declare ligne6=
union  {
object { bande1 translate x*0.000 } 
object { bande1 translate x*0.860 } 
object { bande1 translate x*1.720 } 
object { bande1 translate x*2.580 }
object { brick2 translate x*3.440 }
object { brick1 translate x*3.655 }
object { brick1 translate x*5.060 }
object { bande1 translate x*5.160 } 
}
#declare ligne7=
union  {
object { brick1 translate x*0.000 }        
object { bande1 translate x*0.100 } 
object { bande1 translate x*0.960 } 
object { bande1 translate x*1.820 } 
object { bande1 translate x*2.680 }
object { brick2 translate x*3.540 }
object { bande1 translate x*5.060 } 
object { brick1 translate x*5.920 }
}
#declare ligne8=
union  {
object { bande1 translate x*0.000 } 
object { bande1 translate x*0.860 } 
object { bande1 translate x*1.720 } 
object { bande1 translate x*2.580 }
object { bande1 translate x*3.440 }
object { bande1 translate x*4.300 }
object { bande1 translate x*5.160 }
}
#declare ligne9=
union  { 
object { brick1 translate x*0.000 }
object { bande1 translate x*0.100 } 
object { bande1 translate x*0.960 } 
object { bande1 translate x*1.820 } 
object { bande1 translate x*2.680 }
object { bande1 translate x*3.540 }
object { bande1 translate x*4.400 }
object { brick2 translate x*5.260 }
object { brick2 translate x*5.475 }
object { brick2 translate x*5.690 }
object { brick1 translate x*5.905 }
}
#declare ligne10=
union  {
object { bande1 translate x*0.000 } 
object { brick2 translate x*0.860 } 
object { bande1 translate x*2.150 } 
object { bande1 translate x*3.010 }
object { bande1 translate x*4.945 }
object { brick2 translate x*5.805 }
}
#declare ligne11=
union  { 
object { brick1 translate x*0.000 }
object { bande1 translate x*0.100 } 
object { brick4 translate x*0.960 } 
object { brick1 translate x*2.150 } 
object { bande1 translate x*2.250 } 
object { brick2 translate x*3.110 }
object { brick2 translate x*3.325 }
object { brick2 translate x*3.540 }
object { brick4 translate x*3.755 } 
object { brick1 translate x*4.945 }  
object { bande1 translate x*5.045 }
object { brick4 translate x*5.905 }
}   
#declare linteau_h=
union {
object { brick5 translate x*0.000 }
object { brick5 translate x*0.075 }
object { brick5 translate x*0.150 }
object { brick5 translate x*0.225 }
object { brick5 translate x*0.300 }
object { brick5 translate x*0.375 }
object { brick5 translate x*0.450 }
object { brick5 translate x*0.525 }
object { brick5 translate x*0.600 }
object { brick5 translate x*0.675 }
object { brick5 translate x*0.750 }
object { brick5 translate x*0.825 }
object { brick5 translate x*0.900 }
object { brick5 translate x*0.975 }
}
#declare  linteau_b=
union {
object { linteau_h }
object { linteau_h translate x*1.050 }
} 
#declare arc=
union {
object { brick3 rotate z*10 }   
object { brick3 rotate z*20 }
object { brick3 rotate z*30 }
object { brick3 rotate z*40 }
object { brick3 rotate z*50 }   
object { brick3 rotate z*60 }
object { brick3 rotate z*70 }
object { brick3 rotate z*80 }
object { brick3 rotate z*90 }   
object { brick3 rotate z*100}
object { brick3 rotate z*110}
object { brick3 rotate z*120}
object { brick3 rotate z*130}   
object { brick3 rotate z*140}
object { brick3 rotate z*150}
object { brick3 rotate z*160}
object { brick3 rotate z*170}   
object { brick3 rotate z*180}
translate y*0.045
}
#declare remplissage_arc=
difference {
union {
object { bande3 translate <3.655,2.700,0> }
object { brick2 translate <3.970,2.625,0> }
object { brick2 translate <3.755,2.625,0> } 
object { brick2 translate <3.870,2.550,0> }
object { brick2 translate <3.655,2.550,0> } 
object { brick2 translate <3.755,2.475,0> } 
object { brick2 translate <3.655,2.400,0> } 
object { brick2 translate <3.755,2.325,0> }
object { brick2 translate <3.755,2.250,0> }  
object { brick2 translate <4.630,2.625,0> }
object { brick2 translate <4.845,2.625,0> } 
object { brick2 translate <4.730,2.550,0> } 
object { brick2 translate <4.945,2.550,0> }
object { brick2 translate <4.845,2.475,0> }
object { brick2 translate <4.945,2.400,0> }
object { brick2 translate <4.845,2.325,0> }
object { brick2 translate <4.845,2.250,0> }  
}
cylinder { <4.4,2.025,-0.1>,<4.4,2.075,0.3>,0.685 pigment { color Firebrick } }
}  
#declare joint=
difference {
box { <0.005,0,0.005>,<6,5.775,0.2> pigment { color Gray } }
union {
box { <0.725,0.73,-0.10>,<2.9,2.060,0.21> pigment { color Gray } }
box { <3.95,-0.01,-0.10>,<4.85,2.09,0.21> pigment { color Gray } }  
box { <1.01,3.65,-0.10>,<2.156,5.05,0.21> pigment { color Gray } }
box { <3.855,3.65,-0.10>,<4.946,5.05,0.21> pigment { color Gray } } 
box { <6,0,-0.10>,<9,8,0.21> pigment { color Gray } }
cylinder { <4.4,2.055,-0.1>,<4.4,2.055,0.21>,0.46 pigment { color Gray } }
}
}

//=== soubassement ===//
#declare soubassement=
union {
difference {
box { <-0.01,-0.1,-0.01>, <6.015,0.8,6> 
        pigment {
	brick pigment{White}, pigment{Gray}
	brick_size <0.5,0.3,0.3>
	mortar 0.020
	translate y-0.2
}
normal { brick normal{bumps 0.05}, normal{granite 0.05}
scale 0.3
}
}
cylinder { <1.5,0,-0.1>,<1.5,0,1>,0.4 pigment {
	brick pigment{White}, pigment{Gray}
	brick_size <0.5,0.3,0.3>
	mortar 0.02
	translate y-0.2}
        normal { brick normal{bumps 0.05}, normal{granite 0.05}
        scale 0.3
}
}
}
cylinder { <0,-0.5,0.05>,<0,0.5,0.05>,0.01 texture { Rusty_Iron } translate x*1.5 }
cylinder { <0,-0.5,0.05>,<0,0.5,0.05>,0.01 texture { Rusty_Iron } translate x*1.3 }
cylinder { <0,-0.5,0.05>,<0,0.5,0.05>,0.01 texture { Rusty_Iron } translate x*1.7 }
}

//=== escalier ===//
#declare beton = texture {
  pigment {
    granite
    turbulence 0.8
    color_map {
      [0.0, 0.5 color White color VLightGray]
      [0.5, 0.54 color VLightGray color DimGrey]
      [0.54, 1.0 color VLightGray color VLightGray]
}
}
}
#declare marche=
union {
box   { <0,0,0>,<0.89,0.03,0.5> texture { beton scale 0.01} }
difference {
cylinder { <0,0,0>,<0.89,0,0>,0.03  texture { beton scale 0.01} }
box   { <-0.1,0,0.1>,<0.9,-0.1,-0.35> texture { beton scale 0.01} }
}                                                            
}
#declare esca1=
union  {
object { brick6 translate x*0.000 }
object { brick6 translate x*0.115 }
object { brick6 translate x*0.230 }
object { brick6 translate x*0.345 }
object { brick6 translate x*0.460 }
object { brick6 translate x*0.575 }
object { brick6 translate x*0.690 }
object { brick6 translate x*0.805 }
}
#declare esca2=
union  {
object { brick2 translate x*0.030 }
object { brick2 translate x*0.245 }
object { brick2 translate x*0.460 }
object { brick2 translate x*0.675 }
}
#declare esca3=
union  {
object { brick6 translate <0.000,0,0.000> }
object { brick6 translate <0.115,0,0.000> }
object { brick6 translate <0.000,0,0.215> }
object { brick6 translate <0.115,0,0.215> }
object { brick6 translate <0.000,0,0.430> }
object { brick6 translate <0.115,0,0.430> }
object { brick6 translate <0.000,0,0.645> }
object { brick6 translate <0.115,0,0.645> } 
object { brick6 translate <0.000,0,0.860> }
object { brick6 translate <0.115,0,0.860> } 
object { brick6 translate <0.000,0,1.075> }
object { brick6 translate <0.115,0,1.075> }
object { brick6 translate <0.000,0,1.290> }
object { brick6 translate <0.115,0,1.290> }
}                 
#declare esca4=
union  {
object { brick7 translate <0.000,0,0.000> }
object { brick7 translate <0.115,0,0.000> }
object { brick6 translate <0.000,0,0.115> }
object { brick6 translate <0.115,0,0.115> }
object { brick6 translate <0.000,0,0.330> }
object { brick6 translate <0.115,0,0.330> }
object { brick6 translate <0.000,0,0.545> }
object { brick6 translate <0.115,0,0.545> } 
object { brick6 translate <0.000,0,0.760> }
object { brick6 translate <0.115,0,0.760> } 
object { brick6 translate <0.000,0,0.975> }
object { brick6 translate <0.115,0,0.975> }
object { brick6 translate <0.000,0,1.190> }
object { brick6 translate <0.115,0,1.190> }
}      
#declare bord_esca=
union {
object { esca3 translate <0,0.000,0> }    
object { esca4 translate <0,0.075,0> }   
object { esca3 translate <0,0.150,0> }    
object { esca4 translate <0,0.225,0> } 
object { esca3 translate <0,0.300,0.315> }    
object { esca4 translate <0,0.375,0.315> }
object { esca3 translate <0,0.450,0.315> }    
object { esca4 translate <0,0.525,0.315> }
object { esca3 translate <0,0.600,0.630> }    
object { esca4 translate <0,0.675,0.630> }
object { esca3 translate <0,0.750,0.630> }    
object { esca4 translate <0,0.825,0.630> }
object { esca3 translate <0,0.900,0.945> }    
object { esca4 translate <0,0.975,0.945> }
object { esca3 translate <0,1.050,0.945> }    
object { esca4 translate <0,1.125,0.945> }
box { <0.005,-0.015,0.005>,<0.21,0.284,1.2> pigment { color Gray } translate y*0.000 }
box { <0.005,-0.015,0.320>,<0.21,0.284,1.2> pigment { color Gray } translate y*0.300 }
box { <0.005,-0.015,0.635>,<0.21,0.284,1.2> pigment { color Gray } translate y*0.600 }
box { <0.005,-0.015,0.950>,<0.21,0.284,1.2> pigment { color Gray } translate y*0.900 }
}
#declare escalier=
union {               
object { esca2 translate <0,0.000,0> }
object { esca1 translate <0,0.075,0> }
object { esca2 translate <0,0.150,0> }
object { marche translate <0,0.21,0> }
object { esca2 translate <0,0.210,0.315> }
object { esca1 translate <0,0.285,0.315> }
object { esca2 translate <0,0.360,0.315> }
object { marche translate <0,0.42,0.315> }
object { esca2  translate <0,0.420,0.63> }
object { esca1  translate <0,0.495,0.63> }
object { esca2  translate <0,0.570,0.63> }
object { marche translate <0,0.63,0.63> }
object { esca2  translate <0,0.630,0.945> }
object { esca1  translate <0,0.705,0.945> }
object { esca2  translate <0,0.780,0.945> }
object { marche translate <0,0.84,0.945> }              
box { <0,0.00,0.005>,<0.89,0.20,1.1> pigment { color Gray } }
box { <0,0.20,0.320>,<0.89,0.41,1.1> pigment { color Gray } }
box { <0,0.41,0.635>,<0.89,0.62,1.1> pigment { color Gray } }
box { <0,0.62,0.950>,<0.89,0.83,1.1> pigment { color Gray } }
object { bord_esca translate x*-0.20 }
object { bord_esca translate x*0.890  }
}                 

//=== montage faade ===//
#declare facade=
union  {
object { ligne1 translate y*0.000 }
object { ligne2 translate y*0.075 }
object { ligne1 translate y*0.150 }
object { ligne2 translate y*0.225 }
object { ligne1 translate y*0.300 }
object { ligne2 translate y*0.375 }
object { ligne1 translate y*0.450 }
object { ligne2 translate y*0.525 }
object { ligne1 translate y*0.600 }
object { ligne2 translate y*0.675 }
object { ligne3 translate y*0.750 }
object { ligne4 translate y*0.825 }
object { ligne3 translate y*0.900 }
object { ligne4 translate y*0.975 }
object { ligne3 translate y*1.050 }
object { ligne4 translate y*1.125 }
object { ligne3 translate y*1.200 }
object { ligne4 translate y*1.275 }
object { ligne3 translate y*1.350 }
object { ligne4 translate y*1.425 }
object { ligne3 translate y*1.500 }
object { ligne4 translate y*1.575 }
object { ligne3 translate y*1.650 }
object { ligne4 translate y*1.725 }
object { ligne3 translate y*1.800 }
object { ligne4 translate y*1.875 }
object { ligne3 translate y*1.950 } 
object { ligne4 translate y*2.025 }
object { ligne5 translate y*2.100 }
object { ligne7 translate y*2.175 }
object { ligne6 translate y*2.250 }
object { ligne7 translate y*2.325 }
object { ligne6 translate y*2.400 }
object { ligne7 translate y*2.475 }
object { ligne6 translate y*2.550 }
object { ligne7 translate y*2.625 }
object { ligne6 translate y*2.700 }  
object { ligne9 translate y*2.775 }
object { ligne8 translate y*2.850 }
object { ligne9 translate y*2.925 } 
object { ligne8 translate y*3.000 }
object { ligne9 translate y*3.075 }
object { ligne8 translate y*3.150 }
object { ligne9 translate y*3.225 } 
object { ligne8 translate y*3.300 }
object { ligne9 translate y*3.375 }
object { ligne8 translate y*3.450 }
object { ligne9 translate y*3.525 } 
object { ligne8 translate y*3.600 } 
object { ligne11 translate y*3.675 }
object { ligne10 translate y*3.750 }
object { ligne11 translate y*3.825 } 
object { ligne10 translate y*3.900 }  
object { ligne11 translate y*3.975 }
object { ligne10 translate y*4.050 }
object { ligne11 translate y*4.125 } 
object { ligne10 translate y*4.200 } 
object { ligne11 translate y*4.275 }
object { ligne10 translate y*4.350 }
object { ligne11 translate y*4.425 } 
object { ligne10 translate y*4.500 }
object { ligne11 translate y*4.575 }
object { ligne10 translate y*4.650 }
object { ligne11 translate y*4.725 } 
object { ligne10 translate y*4.800 }
object { ligne11 translate y*4.875 }
object { ligne10 translate y*4.950 }
object { ligne11 translate y*5.025 } 
object { ligne10 translate y*5.100 }
object { ligne9 translate y*5.175 }
object { ligne8 translate y*5.250 }
object { ligne9 translate y*5.325 } 
object { ligne8 translate y*5.400 }
object { ligne9 translate y*5.475 }
object { ligne8 translate y*5.550 }
object { ligne9 translate y*5.625 } 
object { ligne8 translate y*5.700 }
object { linteau_h translate <1.09475,5.050,0> }
object { linteau_h translate <3.88275,5.050,0> } 
object { linteau_b translate <0.77000,2.050,0> }
object { remplissage_arc }
object { arc translate <4.4,2.025,0>  }
object { joint }
}
             

//=== porte ===//
  
  
#declare porte=
union {
box { <0.00,0,0>,<0.03,2.025,0.03> texture { bruler } }
box { <0.86,0,0>,<0.89,2.025,0.03> texture { bruler } }
#declare port1=
difference {
cylinder { <0.445,0,0>,<0.445,0,0.03>,0.445 texture { bruler } }
box { <-1,0,-0.1>,<1,-1,0.1> texture { bruler } }
}
#declare port2=
difference {
cylinder { <0.445,0.00,-0.1>,<0.445,0.00,0.04>,0.415 texture { bruler } }
box { <-1,0.03,-0.1>,<1,-1,0.1> texture { bruler } }
}
difference {
object { port1 }
object { port2 }
translate y*2.025
}
box { <-0.015,0,0>,<0.015,0.42,0.03> texture { bruler }  translate <0.445,2.025,0> }
box { <-0.015,0,0>,<0.015,0.42,0.03> texture { bruler }  rotate z*45 translate <0.445,2.045,0> }
box { <-0.015,0,0>,<0.015,0.42,0.03> texture { bruler } rotate z*-45 translate <0.445,2.045,0> }
#declare port3=
difference {
cylinder { <0.445,0.00,0.01>,<0.445,0.00,0.02>,0.43 texture {Glass3 } }
box { <-1,0.02,-0.1>,<1,-1,0.1> pigment { White } }
}
object { port3 translate <0,2.025,0> }
union {
box { <0.02,0,0.01>,<0.87,2.026,0.05> texture { bruler } }
box { <0.1,0.1,0>,<0.38,0.8,0.06> texture { bruler } }
box { <0.48,0.1,0>,<0.79,0.8,0.06> texture { bruler } }
box { <0.1,1.2,0>,<0.38,1.9,0.06> texture { bruler } }
box { <0.48,1.2,0>,<0.79,1.9,0.06> texture { bruler } }
box { <0.1,0.9,0>,<0.79,1.1,0.06> texture { bruler } }
rotate <-125,15,00>
translate <0.3,0.3,0>
}
}                             

#declare cable=
difference { 
torus { 40.0, 0.01  rotate -x*90 pigment { color Black }
translate  0.093615*z
}
box { <-1, -1, -1>, <1, 1, 1> pigment { color Black }
scale <50.0, 50.0, 55.0>
translate  50.0*y
}
box { <-1, -1, -1>, <1, 1, 1>pigment { color Black }
scale <50.0, 50.0, 55.0>
translate  50.0*x
}
translate  40.0*x
}

//=== fenetres ===//
#declare fenetre=
union {
#declare cadre=
union {
box { <0,0,0>,<0.05,1.25,0.05> texture { bruler } }           
box { <2.115,0,0>,<2.165,1.25,0.05> texture { bruler } } 
box { <1.05,0,0>,<1.115,1.25,0.05> texture { bruler } }
box { <0,0,0>,<2.165,0.05,0.05> texture { bruler } }
box { <0,1.2,0>,<2.165,1.25,0.05> texture { bruler } }
}
#declare batant=
union {
box { <0.05,0.05,0.04>,<0.09,1.2,0.09> texture { bruler scale 5} }
box { <1.01,0.05,0.04>,<1.05,1.2,0.09> texture { bruler scale 5} }
box { <0.05,0.05,0.04>,<1.05,0.09,0.09> texture { bruler scale 5} } 
box { <0.05,1.16,0.04>,<1.05,1.20,0.09> texture { bruler scale 5} }
box { <0.05,0.615,0.06>,<1.05,0.635,0.08> texture { bruler scale 5} }
box { <0.54,0.09,0.06>,<0.56,1.16,0.08> texture { bruler scale 5} }
} 
#declare vitre=
union {
prism { 
  linear_sweep
  linear_spline
  -1.0,0.0
  12  
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.409932, -0.74518>,
  <-0.146766, -0.824604>,
  <-0.235122, -0.248112>,
  <0.142847, 0.262741>,
  <0.158513, 0.683383>,
  <0.064789, 0.744789>,
  <0.089202, 0.944288>,
  <-0.001565, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
texture {Glass3 }
  scale <0.225, 0.2625, 0.005>
  translate  <0.225, 0.2625, -0.022866>
}


prism { 
  linear_sweep
  linear_spline
  -1.0,0.0
  12  
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.996786, -0.353944>,
  <0.432264, 0.012642>,
  <-0.235122, -0.248112>,
  <-0.584853, 0.01235>,
  <-0.796103, 0.018282>,
  <-0.82723, 0.392676>,
  <-0.70892, 0.74867>,
  <-0.838811, 0.913928>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
 texture {Glass3 }
  scale <0.225, 0.2625, 0.005>
  translate  <0.225, 0.8075, -0.022866>
}




prism { 
  linear_sweep
  linear_spline
  -1.0,0.0
  23  
  <-1.0, -1.0>,
  <0.3, -1.0>,
  <1.0, -1.0>,
  <0.995759, 0.996372>,
  <-1.0, 1.0>,
  <-1.001565, -0.99856>,
  <-0.013313, -0.311961>,
  <0.085454, -0.64046>,
  <0.070657, -0.241069>,
  <0.378302, -0.703832>,
  <0.071343, -0.245726>,
  <0.564945, 0.373865>,
  <0.087637, -0.202613>,
  <0.094679, 0.500121>,
  <0.064241, -0.176496>,
  <-0.105567, 0.035659>,
  <-0.014259, -0.189972>,
  <-0.471988, -0.249848>,
  <-0.042583, -0.237175>,
  <-0.296664, -0.380351>,
  <0.000853, -0.285188>,
  <-0.099232, -0.356669>,
  <-1.0, -1.0>
  rotate -x*90
texture {Glass3 }
  scale <0.225, 0.2625, 0.005>
  translate  <0.695, 0.2625, -0.022866>
}


prism { 
  linear_sweep
  linear_spline
  -1.0,0.0
  8  
  <-0.162754, 0.165884>,
  <0.404069, 0.010955>,
  <1.0, -1.0>,
  <0.995759, 0.996372>,
  <-1.0, 1.0>,
  <-0.56651, 0.835524>,
  <-0.203599, 0.482872>,
  <-0.162754, 0.165884>
  rotate -x*90
texture {Glass3 }
  scale <0.225, 0.2625, 0.005>
  translate  <0.695, 0.8075, -0.022866>
}
}
#declare vitre2=
union {
box { <0.09,0.09,0.08>,<0.54,0.615,0.1> texture {Glass3 } }
box { <0.09,0.09,0.08>,<0.54,0.615,0.1> translate x*0.47 texture {Glass3 }  }
box { <0.09,0.09,0.08>,<0.54,0.615,0.1> translate <0.47,0.525,0> texture {Glass3 } }
box { <0.09,0.09,0.08>,<0.54,0.615,0.1> translate y*0.525 texture {Glass3 } }
}
object { cadre  } 
object { batant } 
object { batant rotate <0,15,10> translate <1.08,-0.18,0.45> }
object { vitre translate <0.09,0.09,0.08> }
object { vitre2 translate x*1.065 } 
} 
 
#declare facade_a=
difference {
box { <0,0.8,0.2>,<6,6.6,6> pigment { color Gray } }
box { <0.2,0.7,0>,<5.8,6.4,5.8> pigment { color Gray } }
}


//=== palisade ===//
         /*
#declare pilier=
union{ 
box { <0,0,0>,<0.15,1.8,0.15> pigment { color Gray }finish { crand 0.05}  } 
prism { linear_spline
        conic_sweep 
        0,1,5,
        <-0.075,-0.075>,<0.075,-0.075>,<0.075,0.075>,<-0.075,0.075>,<-0.075,-0.075>scale <1,0.1,1>
        rotate x*180 translate <0.075,1.9,0.075> pigment { color Gray }finish { crand 0.05}  }  
} 
#declare plaque=
union{ 
box { <0.15,0,0.5>,<2,0.5,0.1> pigment { color Gray }finish { crand 0.05}  }  
box { <0.15,0.5,0.65>,<2,0.53,0.115> pigment { color Gray }finish { crand 0.05}  }  
} 

#declare palisade=
union {
object { pilier }
object { pilier translate x*2 }
object { pilier translate x*4 }
object { pilier translate x*6 }
object { plaque }
object { plaque translate y*0.53 }
object { plaque translate y*1.06 }
object { plaque translate x*2    }
object { plaque translate <2,0.53,0> }
object { plaque translate <2,1.06,0> }
object { plaque translate x*4        }
object { plaque translate <4,0.53,0> }
object { plaque translate <4,1.06,0> }
}

#declare entre1=
union  {
object { ligne9 translate y*0.000 }
object { ligne8 translate y*0.075 }
object { ligne9 translate y*0.150 }
object { ligne8 translate y*0.225 }
}
#declare  mur1=
union  {               
object { entre1 translate <0,0,0> }
object { entre1 translate <0,0.3,0> }
object { entre1 translate <0,0.6,0> }
object { entre1 translate <0,0.9,0> }
object { entre1 translate <0,1.2,0> }
object { entre1 translate <0,1.5,0> }
object { entre1 translate <0,1.8,0> }
object { entre1 translate <0,2.1,0> }
object { entre1 translate <0,2.4,0> }
object { entre1 translate <0,2.7,0> }
object { entre1 translate <0,3,0> }
object { entre1 translate <0,3.3,0> }
object { entre1 translate <0,3.6,0> }
object { entre1 translate <0,3.9,0> }
object { entre1 translate <0,4.2,0> }
object { entre1 translate <0,4.5,0> }
object { entre1 translate <0,4.8,0> }
object { entre1 translate <0,5.1,0> }
object { entre1 translate <0,5.4,0> }
object { entre1 translate <0,5.7,0> }
object { entre1 translate <0,6,0> }
object { entre1 translate <0,6.3,0> }
object { entre1 translate <0,6.6,0> }
object { entre1 translate <0,6.9,0> }
box { <0.005,0,0.005>,<6,7.2,0.2> pigment {color Gray }}
}



              */




//=== assemblage finale ===//
  
#declare facade_B=
union  {  
object { facade_a  }  
object { facade translate y*0.8 }
object { soubassement }
object { escalier translate <3.965,0,-1> }
object { porte  translate <3.965,0.82,0.1> }  
object { pilone rotate y*-90 translate <0.2,3,-0> }
object { cable translate <0.2,4.35,-0.75> } 
object { cable  rotate <0,90,-90> translate <0.2,4.4,-0.75> }                       
object { fenetre translate <0.73,1.4,0.1> scale <1,1.08,1> } 
object { mur translate <6.02,0.08,0> }
object { blinde rotate y*45 translate <8.3,1.3,1.6> scale 0.75 }
object { fenetre translate <1.05,4.5,0.1> scale <1,1,1> } 
object { fenetre translate <3.93,4.5,0.1> scale <0.98,1,1> }  
box { <0,0.8,-0.0001>,<6,5,-0.001> pigment {image_map {  gif "impact2.gif" 
  map_type 0 
  interpolate 2
  filter 215,1
  once
  
}
scale <6,5,1>
}
} 
object { pilone_elec scale 0.9 rotate y*90 translate <1.5,0.15,-5 > }
}

