//
// Neglect: entry for the irtc, january-february 2000
// (c) 2000 by J. Berger
//
#include "enter"

#declare High_Quality = false ;
#declare Do_Media = false ;
#declare Iso_Walls = false ;

#default {
  finish { ambient 0.05 diffuse 0.8 }
}

#include "metrics.inc"
#include "colors.inc"
#include "textures.inc"

global_settings {
  ini_option "-MB"
  ini_option "+QR"
  ini_option "Preview_Start_Size=16"
  #if (High_Quality)
    ini_option "Preview_End_Size=4"
  #else
    ini_option "Preview_End_Size=8"
  #end
  
  radiosity{
    #if (High_Quality)
      count 50            // CHANGE range from 20 to 150
      nearest_count 10     // CHANGE range from 3 to 10
      error_bound 2
    #else
      count 30            // CHANGE range from 20 to 150
      nearest_count 5      // CHANGE range from 3 to 10
      error_bound 3
    #end
    //error_bound 2.25     // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
                         //   1 : preview_end_size = 4
                         //   3 : preview_end_size = 8
                         //   use preview_start_size = 16
                         // you can go lower than 1, but then you probably will want to set
                         // preview_end_size to 2, which is really slow
    recursion_limit 4    // CHANGE
  
    low_error_factor .5  // leave this
    gray_threshold 0.2   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    //max_sample 4         // CHANGE - this should be the same as the brightest object
    //adc_bailout 0.01/0.1 // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
}

camera {
  location <0, 1.7, 0>*m
  look_at  <0, 1.7, 5>*m
  up 1.33*y
  right 1*x
  angle 60
/*  translate -<0, 1.7, 0>*m
  rotate -45*y
  translate <0, 1.7, 0>*m
  translate 10*m*x*/
}

light_source {
  <0, 1.7, 0>*m
  color rgb .2
  shadowless
  media_interaction off
}

light_source {
  <10, 8.5, -1>*10000*km
  color White*3
  media_attenuation on
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [ 0.0 color White ]
      [ 1.0 color Blue  ]
    }
  }
}

#macro CenterRotate (P, A)
  translate -P
  rotate A
  translate P
#end

#declare TStone = texture {
  pigment {
    gradient x
    turbulence 0.75
    frequency 6
    scale 0.5
    rotate <0, -45, 30>
    color_map {
      [0.02 color rgbf <0.85, 0.85, 0.85, 0.0> ]
      [0.10 color rgbf <1.00, 1.00, 1.00, 0.0> ]
      [1.00 color rgbf <0.85, 0.85, 0.85, 0.0> ]
    }
    scale 5*cm
  }
  normal { granite 0.5*cm scale 2.5*cm }
}
texture {
  pigment {
    crackle
    turbulence 0.3
    lambda 2.5
    omega 0.75
    octaves 5
    scale 0.45
    frequency 2
    phase 0.25
    rotate <0, 5, 60>
    color_map {
      [0.00 color rgbt <0.00, 0.00, 0.00, 1.00> ]
      [0.15 color rgbt <0.40, 0.30, 0.30, 0.50> ]
      [0.30 color rgbt <0.15, 0.08, 0.02, 0.00> ]
      [0.35 color rgbt <0.60, 0.40, 0.35, 0.50> ]
      [0.45 color rgbt <0.40, 0.35, 0.30, 0.60> ]
      [0.65 color rgbt <0.00, 0.00, 0.00, 1.00> ]
    }
    scale 5*cm
  }
  normal {
    crackle 0.5*cm
    turbulence 0.3
    lambda 2.5
    omega 0.75
    octaves 5
    scale 2.25*cm
    frequency 2
    phase 0.25
    rotate <0, 5, 60>
    slope_map {
      [ 0.00 <0.1, 0.0> ]
      [ 0.15 <0.0, 0.0> ]
      [ 0.30 <0.1, 0.1> ]
      [ 0.35 <0.5, 0.0> ]
      [ 0.45 <0.2, 0.1> ]
      [ 0.65 <1.0, 0.0> ]
    }
  }
  finish { specular 0.5 roughness 0.005 brilliance 0.8 }
}

#local NBasicPeel = normal {
  granite 0.2
  slope_map {
    [ 0.00 <0.00,0>]
    [ 0.10 <0.10,1>]
    [ 0.15 <0.70,0>]
    [ 0.20 <0.75,1>]
    [ 0.21 <1.00,0>]
    [ 0.25 <0.80,-1>]
    [ 0.70 <0.40,0>]
    [ 1.00 <0.70,0>]
  }
}
  
/*#declare TWall = texture {
  pigment {
    granite
    color_map {
      [ 0.10 color <0.70, 0.70, 0.70> ]
      [ 0.15 color <0.75, 0.75, 0.70> ]
      [ 0.18 color <0.75, 0.75, 0.70> ]
      [ 0.20 color <229, 210, 117>/255 ]
//      [ 1.00 color <0.90, 0.79, 0.70> ]
    }
  }
  normal { NBasicPeel } 
  finish { specular 0.1 roughness 1 brilliance 0.9 }
  scale 6*m
}*/
#declare TWall = texture {
  pigment { color <229, 210, 117>/255 }
  normal { granite 1*cm scale 5*cm }
}
texture {
  pigment {
    crackle
    color_map {
      [ 0.0005 rgb 0 ]
      [ 0.0025 rgbt <0, 0, 0, 0.5> ]
      [ 0.0050 rgbt <0.5, 0.5, 0.5, 0.5> ]
      [ 0.0100 rgbt <0, 0, 0, 1> ]
    }
    turbulence 0.5
    scale 1*m
  }
}

#declare Arch = union {
  #local S = seed (645) ;
  box { <-3.5, -1, -0.25>*m, <-2.5, 5, 0.25>*m }
  box { <3.5, -1, -0.25>*m, <2.5, 5, 0.25>*m }
  difference {
    cylinder { <0, 5, -0.25>*m, <0, 5, 0.25>*m, 3.5*m }
    cylinder { <0, 5, -0.26>*m, <0, 5, 0.26>*m, 2.5*m }
    plane    { y, 5*m }
    bounded_by { box { <-3.5, 5, -0.25>*m, <3.5, 8.5, 0.25>*m } }
  }
  union {
    union {
      #local i = -10*cm ;
      #while (i < 5*m)
	box { 
	  <3.52, 0.015, -0.27>*m, <2.48, 0.285, 0.27>*m 
	  CenterRotate(<3, 0.15, 0>*m, <rand(S), rand(S), rand(S)>*2-1)
	  translate i*y
	}
	#local i = i + 30*cm ;
	box { 
	  <3.52, 0.015, -0.27>*m, <2.48, 0.285, -0.01>*m
	  CenterRotate(<3, 0.15, -0.13>*m, <rand(S), rand(S), rand(S)>*2-1)
	  translate i*y 
	}
	box { 
	  <3.52, 0.015, 0.27>*m, <2.48, 0.285, 0.01>*m
	  CenterRotate(<3, 0.15, 0.13>*m, <rand(S), rand(S), rand(S)>*2-1)
	  translate i*y
	}
	#local i = i + 30*cm ;
      #end
      bounded_by { box { <3.52, 0.015-0.1, -0.27>*m, <2.48, 0.285+i/m-0.1, 0.27>*m } }
    }
    union {
      #local i = -10*cm ;
      #while (i < 5*m)
	box { 
	  <-3.52, 0.015, -0.27>*m, <-2.48, 0.285, 0.27>*m
	  CenterRotate(<-3, 0.15, 0>*m, <rand(S), rand(S), rand(S)>*2-1)
	  translate i*y
	}
	#local i = i + 30*cm ;
	box { 
	  <-3.52, 0.015, -0.27>*m, <-2.48, 0.285, -0.01>*m
	  CenterRotate(<-3, 0.15, -0.13>*m, <rand(S), rand(S), rand(S)>*2-1)
	  translate i*y
	}
	box {
	  <-3.52, 0.015, 0.27>*m, <-2.48, 0.285, 0.01>*m
	  CenterRotate(<-3, 0.15, 0.13>*m, <rand(S), rand(S), rand(S)>*2-1)
	  translate i*y
	}
	#local i = i + 30*cm ;
      #end
      bounded_by { box { <-3.52, 0.015-0.1, -0.27>*m, <-2.48, 0.285+i/m-0.1, 0.27>*m } }
    }
    
    #local K = 11 ;
    #local R = 2.47*m ;
    #local H = 75*cm ;
    #local Z = 54*cm ;
    #local Mortar = 1.5*cm ;
    #local Length = pi*R/(2*K+1) + 2*H*tan(pi/(2*K+1)) ;
    union {
      union {
	#local i = 0 ;
	#while (i < K)
	  difference {
	    box { <-Length/2, R, -Z/2>, <Length/2, H+R, Z/2> }
	    plane { x, 0 rotate 90/(2*K+2)*z translate Mortar*x }
	    plane { -x, 0 rotate -90/(2*K+2)*z translate -Mortar*x }
	    bounded_by { box { <-Length/2, R, -Z/2>, <Length/2, H+R, Z/2> } }
	    CenterRotate(<0, R+H/2, 0>, <rand(S), rand(S), rand(S)>*2-1)
	    rotate 90*(1-(2*i+1)/(2*K+2))*z
	  }
	  difference {
	    box { <-Length/2, R, -Z/2>, <Length/2, H+R, Z/2> }
	    plane { x, 0 rotate 90/(2*K+2)*z translate Mortar*x }
	    plane { -x, 0 rotate -90/(2*K+2)*z translate -Mortar*x }
	    bounded_by { box { <-Length/2, R, -Z/2>, <Length/2, H+R, Z/2> } }
	    CenterRotate(<0, R+H/2, 0>, <rand(S), rand(S), rand(S)>*2-1)
	    rotate -90*(1-(2*i+1)/(2*K+2))*z
	  }
	  #local i = i + 1 ;
	#end
	#local Length = pi*R/(2*K+1) + 2*H*tan(2*pi/(2*K+1)) ;
	bounded_by { box { <-R-H, 0, -Z/2>, <R+H, R+H, Z/2> } }
      }
      difference {
	box { <-Length/2, R-H/4, -Z/2-H/4>, <Length/2, H+R, Z/2+H/4> }
	plane { x, 0 rotate 90/(K+1)*z translate -Mortar*x }
	plane { -x, 0 rotate -90/(K+1)*z translate Mortar*x }
	bounded_by { box { <-Length/2, R-H/4, -Z/2>, <Length/2, H+R, Z/2> } }
      }
      //rotate 90*y
      translate 5*m*y
    }
    texture { TStone }
  }
  pigment {
    granite
    color_map {
      [ 0.0 rgb 0.1 ]
      [ 1.0 rgb 0.9 ]
    }
    turbulence 1
    scale 1*m
  }
}

#declare Frame = union {
  box { <2.98, 1.8, -0.6>*m, <4.02, 2.01, 0.6>*m }
  union {
    #local i = 0 ;					    // 0
    #while (i < 2*m)					    // 2*m
      difference {
	box { <2.98, 2.03, -0.45>*m, <4.02, 2.21, -0.29>*m }
	plane { -z, 0 rotate 30*y translate 3.5*m*x-0.29*m*z }
	bounded_by { box { <2.98, 2.03, -0.45>*m, <4.02, 2.21, -0.29>*m } }
	CenterRotate(<3.5, 2.12, -0.37>*m, <rand(S), rand(S), rand(S)>-0.5)
	translate i*y 
      }
      #local i = i + 20*cm ;
      difference {
	box { <2.98, 2.03, -0.6>*m, <4.02, 2.21, -0.29>*m }
	plane { -z, 0 rotate 30*y translate 3.5*m*x-0.29*m*z }
	bounded_by { box { <2.98, 2.03, -0.6>*m, <4.02, 2.21, -0.29>*m } }
	CenterRotate(<3.5, 2.12, -0.445>*m, <rand(S), rand(S), rand(S)>-0.5)
	translate i*y 
      }
      #local i = i + 20*cm ;
    #end
    bounded_by { box { <2.98, 2.03, -0.6>*m, <4.02, 2.21+1.8, -0.29>*m } }
  }
  union {
    #local i = 0 ;					    // 0
    #while (i < 2*m)					    // 2*m
      difference {
	box { <2.98, 2.03, 0.45>*m, <4.02, 2.21, 0.29>*m }
	plane { z, 0 rotate -30*y translate 3.5*m*x+0.29*m*z }
	bounded_by { box { <2.98, 2.03, 0.45>*m, <4.02, 2.21, 0.29>*m } }
	CenterRotate(<3.5, 2.12, 0.37>*m, <rand(S), rand(S), rand(S)>-0.5)
	translate i*y 
      }
      #local i = i + 20*cm ;
      difference {
	box { <2.98, 2.03, 0.6>*m, <4.02, 2.21, 0.29>*m }
	plane { z, 0 rotate -30*y translate 3.5*m*x+0.29*m*z }
	bounded_by { box { <2.98, 2.03, 0.6>*m, <4.02, 2.21, 0.29>*m } }
	CenterRotate(<3.5, 2.12, 0.445>*m, <rand(S), rand(S), rand(S)>-0.5)
	translate i*y 
      }
      #local i = i + 20*cm ;
    #end
    bounded_by { box { <2.98, 2.03, 0.6>*m, <4.02, 2.21+1.8, 0.29>*m } }
  }
  
  #local K = 3 ;
  #local R = 29*cm ;
  #local H = 31*cm ;
  #local Z = 1.04*m ;
  #local Mortar = 0.5*cm ;
  #local Length = pi*R/(2*K+1) + 2*H*tan(pi/(2*K+1)) ;
  #local dH = -H/2 ;
  #if (abs(floor(K/2)-K/2)>0.1)
    #local H = H/2 ;
    #local dH = H;
  #end
  union {
    union {
      #local i = 0 ;
      #while (i < K)
	difference {
	  box { <-Length/2, R, -Z/2>, <Length/2, H+R, Z/2> }
	  plane { x, 0 rotate 90/(2*K+2)*z translate Mortar*x }
	  plane { -x, 0 rotate -90/(2*K+2)*z translate -Mortar*x }
	  plane { y, 0 rotate -30*x translate R*y }
	  bounded_by { box { <-Length/2, R, -Z/2>, <Length/2, H+R, Z/2> } }
	  CenterRotate(<0, R+H/2, 0>, <rand(S), rand(S), rand(S)>-0.5)
	  rotate 90*(1-(2*i+1)/(2*K+2))*z
	}
	difference {
	  box { <-Length/2, R, -Z/2>, <Length/2, H+R, Z/2> }
	  plane { x, 0 rotate 90/(2*K+2)*z translate Mortar*x }
	  plane { -x, 0 rotate -90/(2*K+2)*z translate -Mortar*x }
	  plane { y, 0 rotate -30*x translate R*y }
	  bounded_by { box { <-Length/2, R, -Z/2>, <Length/2, H+R, Z/2> } }
	  CenterRotate(<0, R+H/2, 0>, <rand(S), rand(S), rand(S)>-0.5)
	  rotate -90*(1-(2*i+1)/(2*K+2))*z
	}
	#local i = i + 1 ;
	#local H = H+dH ;
	#local dH = -dH ;
      #end
      bounded_by { box { <-R-H, 0, -Z/2>, <R+H, R+H, Z/2> } }
    }
    #local Length = pi*R/(2*K+1) + 2*H*tan(2*pi/(2*K+1)) ;
    difference {
      box { <-Length/2, R-H/4, -Z/2>, <Length/2, H+R, Z/2> }
      plane { x, 0 rotate 90/(K+1)*z translate -Mortar*x }
      plane { -x, 0 rotate -90/(K+1)*z translate Mortar*x }
      plane { y, 0 rotate -30*x translate (R-H/4)*y }
      bounded_by { box { <-Length/2, R-H/4, -Z/2>, <Length/2, H+R, Z/2> } }
    }
    rotate 90*y
    translate <3.5, 4, 0>*m
  }
  texture { TStone }
}

union {							    // walls
  box { <-4, -1, -0.5>*m, <4, 12, -1.5>*m }
  #declare FWrinkles = function { pigment { wrinkles scale 1.5*m } }
  #declare L = 1*m;
  #declare W = 6*m;
  #declare D = 9*m;
  #declare C = 12*cm;
  #if (Iso_Walls)
    isosurface {
      function { (FWrinkles-0.5)*C-L/2+x }
      max_gradient 1.2
      eval
      method 2
      accuracy 1*mm
      bounded_by { box { -<L, W, D>/2-C, <L, W, D>/2+C } }
      // } (for xemacs)
  #else
    box {
      -<L, W, D>/2, <L, W, D>/2
      // } (for xemacs)
  #end
  // { (for xemacs)
    translate <-3.5, 2, 3.5>*m
  }
  /*box {
    <-4, -1, -1>*m, <-3, 5, 8>*m
  }*/
  difference {
    #if (Iso_Walls)
      isosurface {
	function { (FWrinkles-0.5)*C-L/2-x }
	max_gradient 1.2
	eval
	method 2
	accuracy 1*mm
	bounded_by { box { -<L, W, D>/2-C, <L, W, D>/2+C } }
	// } (for xemacs)
    #else
      box {
	-<L, W, D>/2, <L, W, D>/2
	// } (for xemacs)
    #end
    // { (for xemacs)
      translate <3.5, 2, 3.5>*m
    }
    //box { <4, -1, -1>*m, <3, 5, 8>*m }
    #local i = 0 ;
    #while (i<2)
      box { <5, 2, -0.3>*m, <2, 4, 0.3>*m translate (4*i+2)*m*z }
      cylinder { <5, 4, 0>*m, <2, 4, 0>*m, 0.3*m translate (4*i+2)*m*z }
      prism {
	linear_sweep
	linear_spline
	2*m, 4*m, 4
	<3, 0>*m, <5, 1.2>*m, <5, -1.2>*m, <3, 0>*m
	translate (4*i+2)*m*z
      }
      cone {
	<3, 4, 0>*m, 0, <5, 4, 0>*m, 1.2*m
	translate (4*i+2)*m*z
      }
      #local i = i + 1 ;
    #end
  }
  object { Frame translate 2*m*z }
  object { Frame translate 6*m*z }
  #if (Iso_Walls)					    // alcove
    isosurface {
      function {
	(FWrinkles-0.5)*C+3*m-sqrt(x*x+z*z)
      }
      max_gradient 1.3
      eval
      method 2
      bounded_by { box { -<4, 0.1, 0>*m, <4, 5, 4>*m } }
      translate 8*m*z
    }
  #else
    difference {
      cylinder {
	-1*m*y, 5*m*y, 4*m
      }
      cylinder {
	-2*m*y, 6*m*y, 3*m
      }
      plane {
	z, 0
      }
      translate 8*m*z
    }
  #end
  object { Arch }
  object { Arch translate 4*m*z }
  object { Arch translate 8*m*z }

  texture { TWall }
}

union {							    // stones row
  union {
    box { <-3.48, 5.01, 0.03>*m, <-2.92, 5.17, 7.97>*m texture { TWall } }
    #local i = -50*cm ;
    #while (i < 8*m)
      box { 
	<-3.5, 4.99, 0.01>*m, <-2.9, 5.19, 0.39>*m
	CenterRotate(<-3.245, 5.04, 0.2>*m, <rand(S), rand(S), rand(S)>*2-1)
	translate i*z
      }
      #declare i = i + 40*cm ;
    #end
    bounded_by { box { <-3.5, 4.99, 0.01>*m, <-2.9, 5.19, 8>*m } }
  }
  union {
    box { <3.48, 5.01, 0.03>*m, <2.92, 5.17, 7.97>*m texture { TWall } }
    #local i = -50*cm ;
    #while (i < 8*m)
      box { 
	<3.5, 4.99, 0.01>*m, <2.9, 5.19, 0.39>*m
	CenterRotate(<3.245, 5.04, 0.2>*m, <rand(S), rand(S), rand(S)>*2-1)
	translate i*z
      }
      #declare i = i + 40*cm ;
    #end
    bounded_by { box { <3.5, 4.99, 0.01>*m, <2.9, 5.19, 8>*m } }
  }
  difference {
    cylinder { <0, 5.01, 8>*m, <0, 5.17, 8>*m, 3.5*m }
    cylinder { <0, 5.0, 8>*m, <0, 5.18, 8>*m, 2.94*m }
    plane { z, 8*m }
    bounded_by { box { <-3.5, 5.01, 8>*m, <3.5, 5.17, 12.5>*m } }
    texture { TWall }
  }
  union {
    #declare i = 0 ;
    #while (i < 11)
      box {
	<0.01, 4.99, 2.9>*m, <0.41, 5.19, 3.5>*m
	CenterRotate(<0.21, 5.04, 3.245>*m, <rand(S), rand(S), rand(S)>*2-1)
	rotate (-90+i*180/22)*y
	translate 8*m*z
      }
      #declare i = i + 1 ;
    #end
    bounded_by { box { <-3.5, 4.99, 8>*m, <3.5, 5.19, 12.5>*m } }
  }
  union {
    #while (i < 22)
      box {
	<0.01, 4.99, 2.9>*m, <0.401, 5.19, 3.5>*m
	CenterRotate(<0.21, 5.04, 3.245>*m, <rand(S), rand(S), rand(S)>*2-1)
	rotate (-90+i*180/22)*y
	translate 8*m*z
      }
      #declare i = i + 1 ;
    #end
    bounded_by { box { <0, 4.99, 8>*m, <3.5, 5.19, 12.5>*m } }
  }
    
  texture { TStone }
}

union {							    // planks
  #local i = 0 ;
  #local S = seed (1234) ;
  #while (i < 6)
    box {
      -<1, 3, 50>*cm, <1, 3, 50>*cm
      rotate (10+10*rand(S))*x
      translate <3, 2+i*0.16, 2>*m
    }
    #local i = i + 1 ;
  #end
  #local i = 0 ;
  #while (i < 4)
    box {
      -<1, 3, 50>*cm, <1, 3, 50>*cm
      rotate -20*rand(S)*x
      translate <2.98, 2+i*0.24, 2>*m
    }
    #local i = i + 1 ;
  #end
  #local i = 0 ;
  #while (i < 5)
    box {
      -<1, 3, 50>*cm, <1, 3, 50>*cm
      rotate (10*rand(S))*x
      translate <2.96, 2+i*0.16, 2>*m
    }
    #local i = i + 1 ;
  #end
  bounded_by { box { <2.95, 1.8, 1.5>*m, <3.01, 3, 2.5>*m } }
  //translate 50*cm*x
  pigment { DMFDarkOak scale 1*cm }
}

#declare TPlank = texture {
  pigment { 
    wood 
    color_map {
      [ 0.0 rgb <147, 102, 11>/255  ]
      [ 1.0 rgb <193, 178, 108>/255 ]
    }
    turbulence 0.1
    translate -2*x
    scale <1, 1, 2>/2*4*cm
  }
}
texture {
  pigment {
    wood
    color_map {
      [ 0.5 rgbt <0, 0, 0, 1> ]
      [ 1.0 rgbt <35, 97, 51, 200>/255 ]
    }
    turbulence 1
    scale 20*cm
  }
}

union {							    // plank heap
  #local S = seed (2174) ;
  #local j = 0 ;
  #while (j < 11)
    #local i = 0 ;
    #while (i<4-j/4)
      box {
	-<10, 2, 75>*cm, <10, 2, 75>*cm
	texture { TPlank translate x*rand(S)*50*cm }
	rotate (rand(S)-0.5)*z
	rotate (rand(S)*5-2.5)*y
	translate <2.86*m-26*cm*i-rand(S)*cm, 2*cm+j*4.1*cm, 5.85*m+30*cm*rand(S)>
      }
      #local i = i + 1 ;
    #end
    #local j = j + 1 ;
  #end
  box {
    -<10, 2, 75>*cm, <10, 2, 75>*cm
    texture { TPlank translate x*rand(S)*50*cm }
    rotate 90*y
    translate -70*cm*x+2*cm*y
    rotate z*asin(24.6/145)*180/pi
    rotate y
    translate <198, 24.6, 545>*cm
  }
  box {
    -<10, 2, 75>*cm, <10, 2, 75>*cm
    texture { TPlank translate x*rand(S)*50*cm }
    rotate 90*y
    translate -50*cm*x+2*cm*y
    rotate z*asin(32.8/125)*180/pi
    rotate -y
    translate <218, 32.8, 610>*cm
  }
}

union {							    // roof
  #if(Iso_Walls)
    #declare FWrinkles = function { pigment { wrinkles scale 1.5*m } }
    #declare C = 12*cm ;
    isosurface {
      function { (FWrinkles-0.5)*C+3*m-sqrt(x*x+y*y) }
      max_gradient 1.2
      eval
      method 2
      bounded_by { box { <-4, 0, -1>*m, <4, 4, 8>*m } }
      translate 5*m*y
    }
    isosurface {
      function { (FWrinkles-0.5)*C+3*m-sqrt(x*x+y*y+z*z) }
      max_gradient 1.3
      eval
      method 2
      bounded_by { box { <-4, 0, 0>*m, <4, 4, 4>*m } }
      translate <0, 5, 8>*m
    }
  #else
    difference {
      cylinder { <0, 5, -1>*m, <0, 5, 8>*m, 4*m }
      cylinder { <0, 5, -2>*m, <0, 5, 9>*m, 3*m }
      plane    { y, 5*m }
    }
    difference {
      sphere { <0, 5, 8>*m, 4*m }
      sphere { <0, 5, 8>*m, 3*m }
      plane  { z, 8*m }
      plane  { y, 5*m }
    }
  #end
  texture { TWall }
}

#declare FWrinkles = function { pigment { wrinkles scale 5*cm } }
#declare L = 50*cm;
#declare W = 25*cm;
#declare D = 20*cm;
#declare C = 1*cm;
#if (High_Quality)
  isosurface {						    // stone
    function { FWrinkles*C-min(min(min(L/2+x, L/2-x), min(W/2+y, W/2-y)), min(D/2+z, D/2-z)) }
    max_gradient 1.5
    eval
    method 2
    accuracy 1*mm
    bounded_by { box { -<L, W, D>/2-C, <L, W, D>/2+C } }
    // } (for xemacs)
#else
  box {
    -<L, W, D>/2, <L, W, D>/2
    // } (for xemacs)
#end
// { (for xemacs)
  texture { TStone }
  rotate -10*y
  translate W/2*y
  translate <-1.05, 0, 2.73>*m
}

#declare FWood = function {
  pigment {
    wood
    turbulence 0.1
    translate -2*x
    //rotate 2*x
    //translate -y
    scale <1, 1, 2>/2*5*cm
  }
}
#declare L = 20*cm;
#declare W = 4*cm;
#declare D = 1.5*m;
#declare C = 3*mm;
#if (High_Quality)
  isosurface {						    // front planks
    function {
      (0.5-FWood)*C-min(min(min(L/2+x, L/2-x), min(W/2+y, W/2-y)), min(D/2+z, D/2-z)) 
    }
    max_gradient 53.3
    eval
    accuracy 0.1*mm
    bounded_by { box { -<L, W, D>/2-C/2, <L, W, D>/2+C/2 } }
    //} (for xemacs)
#else
  box {
    -<L, W, D>/2-C, <L, W, D>/2+C
    //} (for xemacs)
#end
//{ (for xemacs)
  texture {
    pigment { 
      wood 
      color_map {
	[ 0.0 rgb <147, 102, 11>/255 /*<0.7188, 0.5234, 0.04297> <1, 0.7, 0.2>*/ ]
	[ 1.0 rgb <193, 178, 108>/255/*<0.9297, 0.8633, 0.50780> <1, 0.9, 0.5>*/ ]
      }
      turbulence 0.1
      translate -2*x
      //rotate 2*x
      //translate -y
      scale <1, 1, 2>/2*4*cm
    }
  }
  texture {
    pigment {
      wood
      color_map {
	[ 0.5 rgbt <0, 0, 0, 1> ]
	[ 1.0 rgbt <35, 97, 51, 200>/255 ]
      }
      turbulence 1
      scale 20*cm
    }
  }
  rotate 35*y
  translate <13*cm, W/2, 2.97*m>
}
#declare FWood = function {
  pigment {
    wood
    turbulence 0.03
    frequency 5
    translate 2*z
    //rotate 2*x
    //translate -y
    scale <1, 1, 2>/2*5*cm
  }
}
#declare L = 6*cm;
#declare W = 2*cm;
#declare D = 1*m;
#declare C = 2*mm;
#if (High_Quality)
  isosurface {
    function {
      (0.5-FWood)*C-min(min(min(L/2+x, L/2-x), min(W/2+y, W/2-y)), min(D/2+z, D/2-z)) 
    }
    max_gradient 21.3
    eval
    accuracy 0.1*mm
    bounded_by { box { -<L, W, D>/2-C, <L, W, D>/2+C } }
    //} (for xemacs)
#else
  box {
    -<L, W, D>/2-C, <L, W, D>/2+C
    //} (for xemacs)
#end
//{ (for xemacs)
  texture {
    pigment { 
      wood 
      color_map {
	[ 0.0 rgb <1, 0.7, 0.2> ]
	[ 1.0 rgb <1, 0.9, 0.5> ]
      }
      turbulence 0.03
      frequency 5
      translate 2*z
      //rotate 2*x
      //translate -y
      scale <1, 1, 2>/2*5*cm
    }
  }
  rotate 80*y
  translate 30*cm*x+W/2*y
  rotate -z*asin(4/80)*180/pi
  translate 4*cm*y-30*cm*z
  rotate 35*y
  translate <13*cm, W/2, 2.97*m>
}

union {							    // altar
  union {
    #declare FWrinkles = function { pigment { wrinkles scale 5*cm } }
    #declare L = 2*m;
    #declare W = 20*cm;
    #declare D = 1*m;
    #declare C = 1*cm;
    #if (High_Quality)
      isosurface {						   
	function { FWrinkles*C-min(min(min(L/2+x, L/2-x), min(W/2+y, W/2-y)), min(D/2+z, D/2-z)) }
	max_gradient 1.5
	eval
	method 2
	accuracy 1*mm
	bounded_by { box { -<L, W, D>/2-C, <L, W, D>/2+C } }
	// } (for xemacs)
    #else
      box {
	-<L, W, D>/2, <L, W, D>/2
	// } (for xemacs)
    #end
    //{ (for xemacs)
      rotate <1, -1, 2>
      translate 80*cm*y
    }
    #macro MStoneCyl(H, R, C)
      #local FWrinkles = function { pigment { wrinkles scale 5*cm } }
      #if (High_Quality)
	isosurface {						   
	  function { FWrinkles*C-R+sqrt(x*x+z*z) }
	  max_gradient 1.5
	  eval
	  method 2
	  accuracy R/100
	  bounded_by { box { -<R+C, 0, R+C>, <R+C, H, R+C> } }
	}
      #else
	cylinder { 0, H*y, R }
      #end
    #end
    //box { -<100, 10, 50>*cm, <100, 10, 50>*cm translate 80*cm*y }
    //cylinder { <-80, -10, -30>*cm, <-80, 80, -30>*cm, 15*cm }
    #declare S = seed (153);
    object { 
      MStoneCyl(90*cm, 15*cm, 1*cm)
      rotate rand(S)*2*z
      rotate rand(S)*360*y
      translate -<80, 10, 30>*cm
    }
    //cylinder { <80, -10, -30>*cm, <80, 80, -30>*cm, 15*cm }
    object {
      MStoneCyl(90*cm, 15*cm, 1*cm)
      rotate rand(S)*2*z
      rotate rand(S)*360*y
      translate <80, -10, -30>*cm
    }
    cylinder { <-80, -10, 30>*cm, <-80, 80, 30>*cm, 15*cm }
    cylinder { <80, -10, 30>*cm, <80, 80, 30>*cm, 15*cm }
    texture { TStone }
  }
  box {
    -<80, 10, 30>*cm, <80, 80, 30>*cm
    texture {
      pigment {
	granite
	color_map {
	  [ 0.05 rgb <244, 239, 195>/1023 ]
	  [ 0.20 rgb <244, 239, 195>/255 ]
	  [ 0.90 rgb <244, 239, 195>/255 ]
	  [ 0.95 rgb 1.0 ]
	}
	scale 20*cm
      }
      normal {
	granite 1*cm scale 20*cm
      }
      finish {
	specular 0.2
      }
    }
  }
  bounded_by { box { -<101, 10, 51>*cm, <101, 91, 51>*cm } }
  translate 8*m*z
}

#if (Do_Media)
  box {							    // inside
    <-3.5, -1, -1>*m, <3.5, 12, 13>*m
    pigment { color rgbf 1 }
    hollow
    interior {
      media {
	intervals 1
	scattering { 1, 0.07/m }
	#if (High_Quality)
	  samples 60, 100
	#else
	  samples 5, 100
	#end
	method 3
	jitter 0.15
      }
    }
  }
#end

height_field {
  png "sig6.png"
  smooth
  scale <100, 2, 50>*cm
  translate <-1.3, -0.02, 2.2>*m
  pigment { 
    gradient y
    color_map {
      [ 0.00 color Black ]
      [ 0.05 color <224, 219, 197>/510 ]
      [ 1.00 color <224, 219, 197>/255 ]
    }
    scale 2.2*cm
    translate -2.1*cm*y
  }
  //pigment { color Red }
}

difference {						    // floor
  //box { <-3.5, -0.5, -1>*m, <3.5, 0, 13>*m }
  #declare FWrinkles = function { pigment { wrinkles scale 50*cm } }
  #declare FW2 = function { pigment { wrinkles scale 2*m } }
  #declare X = -0.8*m; #declare LX = 0.5*m ; #declare lX = 0.1*m ;
  #declare Z = 2.45*m-6*m ; #declare LZ = 0.25*m ; #declare lZ = 0.1*m ;
  #declare Dip = function { 
    1-
    if(abs(x-X)-LX-lX, 0,if(LX-abs(x-X), 1, (cos(pi*(abs(x-X)-LX)/lX)+1)/2))*
    if(abs(z-Z)-LZ-lZ, 0,if(LZ-abs(z-Z), 1, (cos(pi*(abs(z-Z)-LZ)/lZ)+1)/2))
  }
  #declare L = 7*m;
  #declare W = 50*cm;
  #declare D = 14*m;
  #declare C = 4*cm;
  #if (High_Quality)
    isosurface {
      function {
	Dip*(FWrinkles+2*FW2-1.5)*C-W/2+y
	//min(min(min(L/2+x, L/2-x), min(W/2+y, W/2-y)), min(D/2+z, D/2-z))
      }
      max_gradient 1.3
      eval
      method 2
      accuracy 5*mm
      bounded_by { box { -<L, W, D>/2-3*C, <L, W, D>/2+3*C } }
      translate -W/2*y+6*m*z
    }
  #else
    box { <-3.5, -0.5, -1>*m, <3.5, 0, 13>*m }
  #end
  box { <-1.299, -0.1, 2.201>*m, <-0.301, 0.1, 2.699>*m }
  bounded_by { box { -<L, W, D>/2-C, <L, W, D>/2+C translate -W/2*y+6*m*z } }
  pigment { color <226, 216, 170>/255 }
  /*normal {
    wrinkles 1*cm
    scale 5*cm
  }*/
}

plane {
  y,
  -50*cm
  pigment { color Green/7 }
  //finish { diffuse 0.0 ambient 0.5 }
}

#include "leave"