// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio
#declare fol5=
texture{
    pigment{rgb <0.47266, 0.47266, 0> } 
    finish{phong 0.5 ambient 0.5 diffuse 0.2}
    
    } 
    
    
#declare follaje5= union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <0.0, 0.2072, 0.0>, 0.1554 }
		cylinder { <0.0, 0.2072, 0.0>, <0.0, 0.4144, 0.0>, 0.1554 }
		cylinder { <0.0, 0.4144, 0.0>, <0.0, 0.6216, 0.0>, 0.1554 }
		texture{fol5}}
	union { // internode
		cylinder { <0.0, 0.6216, 0.0>, <0.0, 0.8322, 0.0>, 0.1579 }
		cylinder { <0.0, 0.8322, 0.0>, <0.0, 1.0428, 0.0>, 0.1579 }
		cylinder { <0.0, 1.0428, 0.0>, <0.0, 1.2533, 0.0>, 0.1579 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 1.2533, 0.0>, <0.3663, 5.2002, 0.5786>, 0.2002 }
			cylinder { <0.3663, 5.2002, 0.5786>, <1.08839, 8.9719, 1.7187>, 0.2002 }
			cylinder { <1.08839, 8.9719, 1.7187>, <2.1447, 12.4574, 3.3869>, 0.2002 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.1447, 12.4574, 3.3869>, <2.4616, 13.5031, 3.8873>, 0.2002 }
				cylinder { <2.4616, 13.5031, 3.8873>, <2.7785, 14.5487, 4.3878>, 0.2002 }
				cylinder { <2.7785, 14.5487, 4.3878>, <3.09545, 15.5943, 4.8882>, 0.2002 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <3.09545, 15.5943, 4.8882>, <3.2493, 15.8635, 4.9712>, 0.01604 }
				cylinder { <3.2493, 15.8635, 4.9712>, <3.4613, 16.103, 4.9976>, 0.01604 }
				cylinder { <3.4613, 16.103, 4.9976>, <3.716, 16.2955, 4.9654>, 0.01604 }
				texture {fol5}}
			mesh { // leaf
				triangle { <5.9145, 17.1126, 4.884>, <9.9672, 20.07979, 5.1791>, <3.716, 16.2955, 4.9654> }
				triangle { <5.9145, 17.1126, 4.884>, <10.3301, 19.5574, 4.926>, <9.9672, 20.07979, 5.1791> }
				triangle { <10.3301, 19.5574, 4.926>, <14.2054, 20.8142, 6.3665>, <9.9672, 20.07979, 5.1791> }
				triangle { <9.9672, 20.07979, 5.1791>, <14.2054, 20.8142, 6.3665>, <14.01209, 21.2552, 6.6756> }
				triangle { <14.2054, 20.8142, 6.3665>, <15.08524, 20.2806, 7.7403>, <14.01209, 21.2552, 6.6756> }
				triangle { <15.08524, 20.2806, 7.7403>, <13.8493, 21.4966, 6.8316>, <14.01209, 21.2552, 6.6756> }
				triangle { <14.01209, 21.2552, 6.6756>, <13.8493, 21.4966, 6.8316>, <9.9672, 20.07979, 5.1791> }
				triangle { <9.9672, 20.07979, 5.1791>, <13.8493, 21.4966, 6.8316>, <9.7052, 20.6107, 5.483> }
				triangle { <9.7052, 20.6107, 5.483>, <3.716, 16.2955, 4.9654>, <9.9672, 20.07979, 5.1791> }
				triangle { <3.716, 16.2955, 4.9654>, <9.7052, 20.6107, 5.483>, <5.182, 17.9973, 5.1781> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <3.09545, 15.5943, 4.8882>, <3.4123, 16.64, 5.3887>, 0.2002 }
				cylinder { <3.4123, 16.64, 5.3887>, <3.7292, 17.6856, 5.8891>, 0.2002 }
				cylinder { <3.7292, 17.6856, 5.8891>, <4.04617, 18.7313, 6.3896>, 0.2002 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <4.04617, 18.7313, 6.3896>, <4.05541, 19.00043, 6.5642>, 0.01604 }
				cylinder { <4.05541, 19.00043, 6.5642>, <3.9886, 19.2399, 6.7671>, 0.01604 }
				cylinder { <3.9886, 19.2399, 6.7671>, <3.8505, 19.4325, 6.9836>, 0.01604 }
				texture {fol5}}
			mesh { // leaf
				triangle { <3.4567, 20.7543, 8.8822>, <1.2471, 23.1157, 12.7367>, <3.8505, 19.4325, 6.9836> }
				triangle { <3.4567, 20.7543, 8.8822>, <1.8547, 23.4011, 12.8703>, <1.2471, 23.1157, 12.7367> }
				triangle { <1.8547, 23.4011, 12.8703>, <1.1281, 24.355, 17.02177>, <1.2471, 23.1157, 12.7367> }
				triangle { <1.2471, 23.1157, 12.7367>, <1.1281, 24.355, 17.02177>, <0.6226, 24.08923, 17.05468> }
				triangle { <1.1281, 24.355, 17.02177>, <1.622, 23.5185, 18.4368>, <0.6226, 24.08923, 17.05468> }
				triangle { <1.622, 23.5185, 18.4368>, <0.3374, 23.9267, 17.01735>, <0.6226, 24.08923, 17.05468> }
				triangle { <0.6226, 24.08923, 17.05468>, <0.3374, 23.9267, 17.01735>, <1.2471, 23.1157, 12.7367> }
				triangle { <1.2471, 23.1157, 12.7367>, <0.3374, 23.9267, 17.01735>, <0.6422, 22.8388, 12.7161> }
				triangle { <0.6422, 22.8388, 12.7161>, <3.8505, 19.4325, 6.9836>, <1.2471, 23.1157, 12.7367> }
				triangle { <3.8505, 19.4325, 6.9836>, <0.6422, 22.8388, 12.7161>, <2.4245, 20.3264, 8.486> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <4.04617, 18.7313, 6.3896>, <4.363, 19.7769, 6.89>, 0.2002 }
				cylinder { <4.363, 19.7769, 6.89>, <4.6799, 20.8225, 7.3904>, 0.2002 }
				cylinder { <4.6799, 20.8225, 7.3904>, <4.9968, 21.8682, 7.8909>, 0.2002 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <4.9968, 21.8682, 7.8909>, <5.1507, 22.1373, 7.9739>, 0.01604 }
				cylinder { <5.1507, 22.1373, 7.9739>, <5.3627, 22.3768, 8.000317>, 0.01604 }
				cylinder { <5.3627, 22.3768, 8.000317>, <5.6174, 22.5694, 7.9681>, 0.01604 }
				texture {fol5}}
			mesh { // leaf
				triangle { <7.8159, 23.3864, 7.8867>, <11.8686, 26.3536, 8.1818>, <5.6174, 22.5694, 7.9681> }
				triangle { <7.8159, 23.3864, 7.8867>, <12.2315, 25.8312, 7.9287>, <11.8686, 26.3536, 8.1818> }
				triangle { <12.2315, 25.8312, 7.9287>, <16.1068, 27.0881, 9.3692>, <11.8686, 26.3536, 8.1818> }
				triangle { <11.8686, 26.3536, 8.1818>, <16.1068, 27.0881, 9.3692>, <15.9135, 27.529, 9.6783> }
				triangle { <16.1068, 27.0881, 9.3692>, <16.9866, 26.5544, 10.743>, <15.9135, 27.529, 9.6783> }
				triangle { <16.9866, 26.5544, 10.743>, <15.7507, 27.7705, 9.8342>, <15.9135, 27.529, 9.6783> }
				triangle { <15.9135, 27.529, 9.6783>, <15.7507, 27.7705, 9.8342>, <11.8686, 26.3536, 8.1818> }
				triangle { <11.8686, 26.3536, 8.1818>, <15.7507, 27.7705, 9.8342>, <11.6067, 26.8845, 8.4857> }
				triangle { <11.6067, 26.8845, 8.4857>, <5.6174, 22.5694, 7.9681>, <11.8686, 26.3536, 8.1818> }
				triangle { <5.6174, 22.5694, 7.9681>, <11.6067, 26.8845, 8.4857>, <7.08346, 24.2711, 8.1808> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <4.9968, 21.8682, 7.8909>, <5.3137, 22.9138, 8.3913>, 0.2002 }
				cylinder { <5.3137, 22.9138, 8.3913>, <5.6306, 23.9594, 8.8918>, 0.2002 }
				cylinder { <5.6306, 23.9594, 8.8918>, <5.9475, 25.00513, 9.3922>, 0.2002 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <5.9475, 25.00513, 9.3922>, <5.9568, 25.2742, 9.5668>, 0.01604 }
				cylinder { <5.9568, 25.2742, 9.5668>, <5.89, 25.5137, 9.7697>, 0.01604 }
				cylinder { <5.89, 25.5137, 9.7697>, <5.752, 25.7063, 9.9863>, 0.01604 }
				texture {fol5}}
			mesh { // leaf
				triangle { <5.3582, 27.02823, 11.8849>, <3.1485, 29.3895, 15.7394>, <5.752, 25.7063, 9.9863> }
				triangle { <5.3582, 27.02823, 11.8849>, <3.7562, 29.6749, 15.873>, <3.1485, 29.3895, 15.7394> }
				triangle { <3.7562, 29.6749, 15.873>, <3.02961, 30.6289, 20.02446>, <3.1485, 29.3895, 15.7394> }
				triangle { <3.1485, 29.3895, 15.7394>, <3.02961, 30.6289, 20.02446>, <2.524, 30.363, 20.05736> }
				triangle { <3.02961, 30.6289, 20.02446>, <3.5235, 29.7923, 21.4395>, <2.524, 30.363, 20.05736> }
				triangle { <3.5235, 29.7923, 21.4395>, <2.2388, 30.2006, 20.02003>, <2.524, 30.363, 20.05736> }
				triangle { <2.524, 30.363, 20.05736>, <2.2388, 30.2006, 20.02003>, <3.1485, 29.3895, 15.7394> }
				triangle { <3.1485, 29.3895, 15.7394>, <2.2388, 30.2006, 20.02003>, <2.5436, 29.1127, 15.7188> }
				triangle { <2.5436, 29.1127, 15.7188>, <5.752, 25.7063, 9.9863>, <3.1485, 29.3895, 15.7394> }
				triangle { <5.752, 25.7063, 9.9863>, <2.5436, 29.1127, 15.7188>, <4.3259, 26.6002, 11.4887> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <5.9475, 25.00513, 9.3922>, <6.2645, 26.05077, 9.8927>, 0.2002 }
				cylinder { <6.2645, 26.05077, 9.8927>, <6.5814, 27.09641, 10.3931>, 0.2002 }
				cylinder { <6.5814, 27.09641, 10.3931>, <6.8983, 28.142, 10.8936>, 0.2002 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <6.8983, 28.142, 10.8936>, <7.05219, 28.4111, 10.9766>, 0.01604 }
				cylinder { <7.05219, 28.4111, 10.9766>, <7.2641, 28.6507, 11.003>, 0.01604 }
				cylinder { <7.2641, 28.6507, 11.003>, <7.5189, 28.8432, 10.9708>, 0.01604 }
				texture {fol5}}
			mesh { // leaf
				triangle { <9.7173, 29.6602, 10.8894>, <13.7701, 32.6274, 11.1845>, <7.5189, 28.8432, 10.9708> }
				triangle { <9.7173, 29.6602, 10.8894>, <14.1329, 32.105, 10.9314>, <13.7701, 32.6274, 11.1845> }
				triangle { <14.1329, 32.105, 10.9314>, <18.00826, 33.3619, 12.3718>, <13.7701, 32.6274, 11.1845> }
				triangle { <13.7701, 32.6274, 11.1845>, <18.00826, 33.3619, 12.3718>, <17.8149, 33.8029, 12.6809> }
				triangle { <18.00826, 33.3619, 12.3718>, <18.888, 32.8283, 13.7457>, <17.8149, 33.8029, 12.6809> }
				triangle { <18.888, 32.8283, 13.7457>, <17.6521, 34.04434, 12.8369>, <17.8149, 33.8029, 12.6809> }
				triangle { <17.8149, 33.8029, 12.6809>, <17.6521, 34.04434, 12.8369>, <13.7701, 32.6274, 11.1845> }
				triangle { <13.7701, 32.6274, 11.1845>, <17.6521, 34.04434, 12.8369>, <13.5081, 33.1584, 11.4884> }
				triangle { <13.5081, 33.1584, 11.4884>, <7.5189, 28.8432, 10.9708>, <13.7701, 32.6274, 11.1845> }
				triangle { <7.5189, 28.8432, 10.9708>, <13.5081, 33.1584, 11.4884>, <8.9848, 30.5449, 11.1835> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <6.8983, 28.142, 10.8936>, <7.2152, 29.1876, 11.394>, 0.2002 }
				cylinder { <7.2152, 29.1876, 11.394>, <7.5321, 30.2333, 11.8945>, 0.2002 }
				cylinder { <7.5321, 30.2333, 11.8945>, <7.849, 31.2789, 12.3949>, 0.2002 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <7.849, 31.2789, 12.3949>, <7.8582, 31.5481, 12.5695>, 0.01604 }
				cylinder { <7.8582, 31.5481, 12.5695>, <7.7914, 31.7876, 12.7724>, 0.01604 }
				cylinder { <7.7914, 31.7876, 12.7724>, <7.6534, 31.9801, 12.9889>, 0.01604 }
				texture {fol5}}
			mesh { // leaf
				triangle { <7.2596, 33.302, 14.8876>, <5.04996, 35.6634, 18.7421>, <7.6534, 31.9801, 12.9889> }
				triangle { <7.2596, 33.302, 14.8876>, <5.6576, 35.9488, 18.8757>, <5.04996, 35.6634, 18.7421> }
				triangle { <5.6576, 35.9488, 18.8757>, <4.931, 36.9027, 23.02714>, <5.04996, 35.6634, 18.7421> }
				triangle { <5.04996, 35.6634, 18.7421>, <4.931, 36.9027, 23.02714>, <4.4254, 36.6369, 23.06004> }
				triangle { <4.931, 36.9027, 23.02714>, <5.4249, 36.0662, 24.4422>, <4.4254, 36.6369, 23.06004> }
				triangle { <5.4249, 36.0662, 24.4422>, <4.1402, 36.4744, 23.02272>, <4.4254, 36.6369, 23.06004> }
				triangle { <4.4254, 36.6369, 23.06004>, <4.1402, 36.4744, 23.02272>, <5.04996, 35.6634, 18.7421> }
				triangle { <5.04996, 35.6634, 18.7421>, <4.1402, 36.4744, 23.02272>, <4.4451, 35.3865, 18.7215> }
				triangle { <4.4451, 35.3865, 18.7215>, <7.6534, 31.9801, 12.9889>, <5.04996, 35.6634, 18.7421> }
				triangle { <7.6534, 31.9801, 12.9889>, <4.4451, 35.3865, 18.7215>, <6.2273, 32.8741, 14.4914> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <7.849, 31.2789, 12.3949>, <7.9336, 31.5582, 12.5286>, 0.01604 }
				cylinder { <7.9336, 31.5582, 12.5286>, <8.01829, 31.8374, 12.6622>, 0.01604 }
				cylinder { <8.01829, 31.8374, 12.6622>, <8.1029, 32.1167, 12.7959>, 0.01604 }
				texture {fol5}}
			mesh { // leaf
				triangle { <9.2939, 33.7921, 13.928>, <10.496, 37.7982, 16.7248>, <8.1029, 32.1167, 12.7959> }
				triangle { <9.2939, 33.7921, 13.928>, <11.1494, 37.6797, 16.5586>, <10.496, 37.7982, 16.7248> }
				triangle { <11.1494, 37.6797, 16.5586>, <12.9624, 39.7806, 19.8709>, <10.496, 37.7982, 16.7248> }
				triangle { <10.496, 37.7982, 16.7248>, <12.9624, 39.7806, 19.8709>, <12.4725, 39.8898, 20.1454> }
				triangle { <12.9624, 39.7806, 19.8709>, <13.6059, 39.1604, 21.3364>, <12.4725, 39.8898, 20.1454> }
				triangle { <13.6059, 39.1604, 21.3364>, <12.1644, 39.9293, 20.258>, <12.4725, 39.8898, 20.1454> }
				triangle { <12.4725, 39.8898, 20.1454>, <12.1644, 39.9293, 20.258>, <10.496, 37.7982, 16.7248> }
				triangle { <10.496, 37.7982, 16.7248>, <12.1644, 39.9293, 20.258>, <9.9011, 37.9468, 16.9833> }
				triangle { <9.9011, 37.9468, 16.9833>, <8.1029, 32.1167, 12.7959>, <10.496, 37.7982, 16.7248> }
				triangle { <8.1029, 32.1167, 12.7959>, <9.9011, 37.9468, 16.9833>, <8.1318, 33.9988, 14.03962> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <0.0, 1.2533, 0.0>, <0.05527, 1.5661, 0.08728>, 0.247 }
		cylinder { <0.05527, 1.5661, 0.08728>, <0.1602, 1.8306, 0.253>, 0.247 }
		cylinder { <0.1602, 1.8306, 0.253>, <0.3043, 2.02032, 0.4805>, 0.247 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.3043, 2.02032, 0.4805>, <4.3585, 5.6044, 6.8828>, 0.4191 }
			cylinder { <4.3585, 5.6044, 6.8828>, <8.6809, 7.8402, 13.7086>, 0.4191 }
			cylinder { <8.6809, 7.8402, 13.7086>, <13.1441, 8.6619, 20.7568>, 0.4191 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <13.1441, 8.6619, 20.7568>, <14.483, 8.9084, 22.8713>, 0.4191 }
				cylinder { <14.483, 8.9084, 22.8713>, <15.822, 9.1549, 24.9857>, 0.4191 }
				cylinder { <15.822, 9.1549, 24.9857>, <17.161, 9.4014, 27.1002>, 0.4191 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <17.161, 9.4014, 27.1002>, <18.1989, 9.5342, 28.03856>, 0.07027 }
				cylinder { <18.1989, 9.5342, 28.03856>, <19.4511, 9.6523, 28.6655>, 0.07027 }
				cylinder { <19.4511, 9.6523, 28.6655>, <20.8271, 9.7473, 28.9358>, 0.07027 }
				texture {fol5}}
			mesh { // leaf
				triangle { <25.6496, 8.8371, 29.1159>, <35.6984, 8.2763, 32.2094>, <20.8271, 9.7473, 28.9358> }
				triangle { <25.6496, 8.8371, 29.1159>, <35.9889, 7.6805, 30.9395>, <35.6984, 8.2763, 32.2094> }
				triangle { <35.9889, 7.6805, 30.9395>, <43.6864, 3.5657, 33.303>, <35.6984, 8.2763, 32.2094> }
				triangle { <35.6984, 8.2763, 32.2094>, <43.6864, 3.5657, 33.303>, <43.6106, 3.8272, 34.469> }
				triangle { <43.6864, 3.5657, 33.303>, <44.2644, 0.1315, 34.1831>, <43.6106, 3.8272, 34.469> }
				triangle { <44.2644, 0.1315, 34.1831>, <43.4697, 4.04167, 35.1109>, <43.6106, 3.8272, 34.469> }
				triangle { <43.6106, 3.8272, 34.469>, <43.4697, 4.04167, 35.1109>, <35.6984, 8.2763, 32.2094> }
				triangle { <35.6984, 8.2763, 32.2094>, <43.4697, 4.04167, 35.1109>, <35.5808, 8.7165, 33.5254> }
				triangle { <35.5808, 8.7165, 33.5254>, <20.8271, 9.7473, 28.9358>, <35.6984, 8.2763, 32.2094> }
				triangle { <20.8271, 9.7473, 28.9358>, <35.5808, 8.7165, 33.5254>, <24.9947, 10.1485, 31.1177> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <17.161, 9.4014, 27.1002>, <18.4999, 9.6479, 29.2146>, 0.4191 }
				cylinder { <18.4999, 9.6479, 29.2146>, <19.8389, 9.8944, 31.3291>, 0.4191 }
				cylinder { <19.8389, 9.8944, 31.3291>, <21.1779, 10.1409, 33.4436>, 0.4191 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <21.1779, 10.1409, 33.4436>, <21.5824, 10.2737, 34.783>, 0.07027 }
				cylinder { <21.5824, 10.2737, 34.783>, <21.6138, 10.3918, 36.1831>, 0.07027 }
				cylinder { <21.6138, 10.3918, 36.1831>, <21.2698, 10.4868, 37.5425>, 0.07027 }
				texture {fol5}}
			mesh { // leaf
				triangle { <20.9939, 9.6957, 42.3815>, <17.5461, 8.992, 52.3051>, <21.2698, 10.4868, 37.5425> }
				triangle { <20.9939, 9.6957, 42.3815>, <18.8711, 8.5866, 52.6687>, <17.5461, 8.992, 52.3051> }
				triangle { <18.8711, 8.5866, 52.6687>, <16.7427, 4.4004, 60.3962>, <17.5461, 8.992, 52.3051> }
				triangle { <17.5461, 8.992, 52.3051>, <16.7427, 4.4004, 60.3962>, <15.5566, 4.4953, 60.2628> }
				triangle { <16.7427, 4.4004, 60.3962>, <16.3172, 0.8948, 61.05361>, <15.5566, 4.4953, 60.2628> }
				triangle { <16.3172, 0.8948, 61.05361>, <14.8985, 4.6145, 60.08801>, <15.5566, 4.4953, 60.2628> }
				triangle { <15.5566, 4.4953, 60.2628>, <14.8985, 4.6145, 60.08801>, <17.5461, 8.992, 52.3051> }
				triangle { <17.5461, 8.992, 52.3051>, <14.8985, 4.6145, 60.08801>, <16.189, 9.2418, 52.1176> }
				triangle { <16.189, 9.2418, 52.1176>, <21.2698, 10.4868, 37.5425>, <17.5461, 8.992, 52.3051> }
				triangle { <21.2698, 10.4868, 37.5425>, <16.189, 9.2418, 52.1176>, <18.8632, 10.6976, 41.5989> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <21.1779, 10.1409, 33.4436>, <22.5168, 10.3874, 35.558>, 0.4191 }
				cylinder { <22.5168, 10.3874, 35.558>, <23.8558, 10.6339, 37.6725>, 0.4191 }
				cylinder { <23.8558, 10.6339, 37.6725>, <25.1948, 10.8804, 39.7869>, 0.4191 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <25.1948, 10.8804, 39.7869>, <26.2327, 11.01321, 40.7253>, 0.07027 }
				cylinder { <26.2327, 11.01321, 40.7253>, <27.4849, 11.1313, 41.3523>, 0.07027 }
				cylinder { <27.4849, 11.1313, 41.3523>, <28.8609, 11.2263, 41.6225>, 0.07027 }
				texture {fol5}}
			mesh { // leaf
				triangle { <33.6834, 10.3161, 41.8027>, <43.7322, 9.7553, 44.8961>, <28.8609, 11.2263, 41.6225> }
				triangle { <33.6834, 10.3161, 41.8027>, <44.02277, 9.1595, 43.6263>, <43.7322, 9.7553, 44.8961> }
				triangle { <44.02277, 9.1595, 43.6263>, <51.7202, 5.04471, 45.9898>, <43.7322, 9.7553, 44.8961> }
				triangle { <43.7322, 9.7553, 44.8961>, <51.7202, 5.04471, 45.9898>, <51.6444, 5.3062, 47.1557> }
				triangle { <51.7202, 5.04471, 45.9898>, <52.2982, 1.6105, 46.8699>, <51.6444, 5.3062, 47.1557> }
				triangle { <52.2982, 1.6105, 46.8699>, <51.5035, 5.5206, 47.7976>, <51.6444, 5.3062, 47.1557> }
				triangle { <51.6444, 5.3062, 47.1557>, <51.5035, 5.5206, 47.7976>, <43.7322, 9.7553, 44.8961> }
				triangle { <43.7322, 9.7553, 44.8961>, <51.5035, 5.5206, 47.7976>, <43.6146, 10.1955, 46.2121> }
				triangle { <43.6146, 10.1955, 46.2121>, <28.8609, 11.2263, 41.6225>, <43.7322, 9.7553, 44.8961> }
				triangle { <28.8609, 11.2263, 41.6225>, <43.6146, 10.1955, 46.2121>, <33.0285, 11.6275, 43.8045> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <25.1948, 10.8804, 39.7869>, <26.5337, 11.1269, 41.9014>, 0.4191 }
				cylinder { <26.5337, 11.1269, 41.9014>, <27.8727, 11.3734, 44.0159>, 0.4191 }
				cylinder { <27.8727, 11.3734, 44.0159>, <29.2117, 11.6199, 46.1303>, 0.4191 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <29.2117, 11.6199, 46.1303>, <29.6162, 11.7527, 47.4697>, 0.07027 }
				cylinder { <29.6162, 11.7527, 47.4697>, <29.6476, 11.8708, 48.8699>, 0.07027 }
				cylinder { <29.6476, 11.8708, 48.8699>, <29.3036, 11.9658, 50.2293>, 0.07027 }
				texture {fol5}}
			mesh { // leaf
				triangle { <29.02776, 11.1746, 55.06826>, <25.5799, 10.471, 64.9919>, <29.3036, 11.9658, 50.2293> }
				triangle { <29.02776, 11.1746, 55.06826>, <26.9049, 10.06569, 65.3555>, <25.5799, 10.471, 64.9919> }
				triangle { <26.9049, 10.06569, 65.3555>, <24.7765, 5.8794, 73.08305>, <25.5799, 10.471, 64.9919> }
				triangle { <25.5799, 10.471, 64.9919>, <24.7765, 5.8794, 73.08305>, <23.5904, 5.9742, 72.9496> }
				triangle { <24.7765, 5.8794, 73.08305>, <24.351, 2.3738, 73.7403>, <23.5904, 5.9742, 72.9496> }
				triangle { <24.351, 2.3738, 73.7403>, <22.9323, 6.09354, 72.7747>, <23.5904, 5.9742, 72.9496> }
				triangle { <23.5904, 5.9742, 72.9496>, <22.9323, 6.09354, 72.7747>, <25.5799, 10.471, 64.9919> }
				triangle { <25.5799, 10.471, 64.9919>, <22.9323, 6.09354, 72.7747>, <24.2228, 10.7208, 64.8044> }
				triangle { <24.2228, 10.7208, 64.8044>, <29.3036, 11.9658, 50.2293>, <25.5799, 10.471, 64.9919> }
				triangle { <29.3036, 11.9658, 50.2293>, <24.2228, 10.7208, 64.8044>, <26.897, 12.1765, 54.2857> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <29.2117, 11.6199, 46.1303>, <30.5506, 11.8664, 48.2448>, 0.4191 }
				cylinder { <30.5506, 11.8664, 48.2448>, <31.8896, 12.1129, 50.3592>, 0.4191 }
				cylinder { <31.8896, 12.1129, 50.3592>, <33.2286, 12.3594, 52.4737>, 0.4191 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <33.2286, 12.3594, 52.4737>, <34.2665, 12.4922, 53.412>, 0.07027 }
				cylinder { <34.2665, 12.4922, 53.412>, <35.5187, 12.6103, 54.03907>, 0.07027 }
				cylinder { <35.5187, 12.6103, 54.03907>, <36.8947, 12.7053, 54.3093>, 0.07027 }
				texture {fol5}}
			mesh { // leaf
				triangle { <41.7172, 11.7951, 54.4894>, <51.766, 11.2343, 57.5829>, <36.8947, 12.7053, 54.3093> }
				triangle { <41.7172, 11.7951, 54.4894>, <52.05657, 10.6385, 56.313>, <51.766, 11.2343, 57.5829> }
				triangle { <52.05657, 10.6385, 56.313>, <59.754, 6.5237, 58.6765>, <51.766, 11.2343, 57.5829> }
				triangle { <51.766, 11.2343, 57.5829>, <59.754, 6.5237, 58.6765>, <59.6782, 6.7852, 59.8425> }
				triangle { <59.754, 6.5237, 58.6765>, <60.332, 3.08955, 59.5566>, <59.6782, 6.7852, 59.8425> }
				triangle { <60.332, 3.08955, 59.5566>, <59.5373, 6.9996, 60.4844>, <59.6782, 6.7852, 59.8425> }
				triangle { <59.6782, 6.7852, 59.8425>, <59.5373, 6.9996, 60.4844>, <51.766, 11.2343, 57.5829> }
				triangle { <51.766, 11.2343, 57.5829>, <59.5373, 6.9996, 60.4844>, <51.6484, 11.6745, 58.8989> }
				triangle { <51.6484, 11.6745, 58.8989>, <36.8947, 12.7053, 54.3093>, <51.766, 11.2343, 57.5829> }
				triangle { <36.8947, 12.7053, 54.3093>, <51.6484, 11.6745, 58.8989>, <41.06229, 13.1065, 56.4912> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <33.2286, 12.3594, 52.4737>, <34.5675, 12.6059, 54.5882>, 0.4191 }
				cylinder { <34.5675, 12.6059, 54.5882>, <35.9065, 12.8524, 56.7026>, 0.4191 }
				cylinder { <35.9065, 12.8524, 56.7026>, <37.2455, 13.09893, 58.8171>, 0.4191 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <37.2455, 13.09893, 58.8171>, <37.65, 13.2317, 60.1565>, 0.07027 }
				cylinder { <37.65, 13.2317, 60.1565>, <37.6814, 13.3498, 61.5566>, 0.07027 }
				cylinder { <37.6814, 13.3498, 61.5566>, <37.3374, 13.4448, 62.916>, 0.07027 }
				texture {fol5}}
			mesh { // leaf
				triangle { <37.06156, 12.6536, 67.755>, <33.6137, 11.95, 77.6787>, <37.3374, 13.4448, 62.916> }
				triangle { <37.06156, 12.6536, 67.755>, <34.9387, 11.5446, 78.04231>, <33.6137, 11.95, 77.6787> }
				triangle { <34.9387, 11.5446, 78.04231>, <32.8103, 7.3584, 85.7698>, <33.6137, 11.95, 77.6787> }
				triangle { <33.6137, 11.95, 77.6787>, <32.8103, 7.3584, 85.7698>, <31.6242, 7.4532, 85.6363> }
				triangle { <32.8103, 7.3584, 85.7698>, <32.3848, 3.8528, 86.4271>, <31.6242, 7.4532, 85.6363> }
				triangle { <32.3848, 3.8528, 86.4271>, <30.9661, 7.5725, 85.4615>, <31.6242, 7.4532, 85.6363> }
				triangle { <31.6242, 7.4532, 85.6363>, <30.9661, 7.5725, 85.4615>, <33.6137, 11.95, 77.6787> }
				triangle { <33.6137, 11.95, 77.6787>, <30.9661, 7.5725, 85.4615>, <32.2566, 12.1998, 77.4911> }
				triangle { <32.2566, 12.1998, 77.4911>, <37.3374, 13.4448, 62.916>, <33.6137, 11.95, 77.6787> }
				triangle { <37.3374, 13.4448, 62.916>, <32.2566, 12.1998, 77.4911>, <34.9308, 13.6555, 66.9725> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <37.2455, 13.09893, 58.8171>, <37.9938, 13.2366, 59.9988>, 0.07027 }
				cylinder { <37.9938, 13.2366, 59.9988>, <38.7421, 13.3744, 61.1804>, 0.07027 }
				cylinder { <38.7421, 13.3744, 61.1804>, <39.4903, 13.5122, 62.3621>, 0.07027 }
				texture {fol5}}
			mesh { // leaf
				triangle { <42.7595, 12.8043, 65.9578>, <47.5144, 12.4884, 75.3468>, <39.4903, 13.5122, 62.3621> }
				triangle { <42.7595, 12.8043, 65.9578>, <48.6739, 11.9879, 74.6709>, <47.5144, 12.4884, 75.3468> }
				triangle { <48.6739, 11.9879, 74.6709>, <52.6013, 8.07202, 81.8131>, <47.5144, 12.4884, 75.3468> }
				triangle { <47.5144, 12.4884, 75.3468>, <52.6013, 8.07202, 81.8131>, <51.6903, 8.2553, 82.568> }
				triangle { <52.6013, 8.07202, 81.8131>, <52.6288, 4.6174, 82.7966>, <51.6903, 8.2553, 82.568> }
				triangle { <52.6288, 4.6174, 82.7966>, <51.1149, 8.4221, 82.9129>, <51.6903, 8.2553, 82.568> }
				triangle { <51.6903, 8.2553, 82.568>, <51.1149, 8.4221, 82.9129>, <47.5144, 12.4884, 75.3468> }
				triangle { <47.5144, 12.4884, 75.3468>, <51.1149, 8.4221, 82.9129>, <46.4529, 12.8385, 76.1776> }
				triangle { <46.4529, 12.8385, 76.1776>, <39.4903, 13.5122, 62.3621>, <47.5144, 12.4884, 75.3468> }
				triangle { <39.4903, 13.5122, 62.3621>, <46.4529, 12.8385, 76.1776>, <40.7673, 13.9559, 66.8857> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <0.3043, 2.02032, 0.4805>, <0.4152, 2.1663, 0.6556>, 0.1901 }
		cylinder { <0.4152, 2.1663, 0.6556>, <0.5261, 2.3123, 0.8308>, 0.1901 }
		cylinder { <0.5261, 2.3123, 0.8308>, <0.637, 2.4583, 1.00596>, 0.1901 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.637, 2.4583, 1.00596>, <2.7181, 5.3139, 3.3789>, 0.2128 }
			cylinder { <2.7181, 5.3139, 3.3789>, <4.9573, 8.4901, 5.1151>, 0.2128 }
			cylinder { <4.9573, 8.4901, 5.1151>, <7.2887, 11.8935, 6.1632>, 0.2128 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <7.2887, 11.8935, 6.1632>, <7.9881, 12.9146, 6.4777>, 0.2128 }
				cylinder { <7.9881, 12.9146, 6.4777>, <8.6875, 13.9356, 6.7921>, 0.2128 }
				cylinder { <8.6875, 13.9356, 6.7921>, <9.3869, 14.9566, 7.1065>, 0.2128 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <9.3869, 14.9566, 7.1065>, <9.4977, 15.2889, 7.1993>, 0.01811 }
				cylinder { <9.4977, 15.2889, 7.1993>, <9.5128, 15.6397, 7.2888>, 0.01811 }
				cylinder { <9.5128, 15.6397, 7.2888>, <9.431, 15.9835, 7.3686>, 0.01811 }
				texture {fol5}}
			mesh { // leaf
				triangle { <8.5275, 18.3052, 7.2622>, <7.8873, 23.5821, 7.833>, <9.431, 15.9835, 7.3686> }
				triangle { <8.5275, 18.3052, 7.2622>, <7.2463, 23.5076, 7.4974>, <7.8873, 23.5821, 7.833> }
				triangle { <7.2463, 23.5076, 7.4974>, <6.8006, 27.8549, 6.08914>, <7.8873, 23.5821, 7.833> }
				triangle { <7.8873, 23.5821, 7.833>, <6.8006, 27.8549, 6.08914>, <7.3532, 28.03452, 6.2678> }
				triangle { <6.8006, 27.8549, 6.08914>, <7.133, 28.5834, 4.4505>, <7.3532, 28.03452, 6.2678> }
				triangle { <7.133, 28.5834, 4.4505>, <7.6771, 28.08209, 6.3944>, <7.3532, 28.03452, 6.2678> }
				triangle { <7.3532, 28.03452, 6.2678>, <7.6771, 28.08209, 6.3944>, <7.8873, 23.5821, 7.833> }
				triangle { <7.8873, 23.5821, 7.833>, <7.6771, 28.08209, 6.3944>, <8.5159, 23.758, 8.1051> }
				triangle { <8.5159, 23.758, 8.1051>, <9.431, 15.9835, 7.3686>, <7.8873, 23.5821, 7.833> }
				triangle { <9.431, 15.9835, 7.3686>, <8.5159, 23.758, 8.1051>, <9.574, 18.3013, 7.9636> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <9.3869, 14.9566, 7.1065>, <10.08635, 15.9776, 7.421>, 0.2128 }
				cylinder { <10.08635, 15.9776, 7.421>, <10.7857, 16.9986, 7.7354>, 0.2128 }
				cylinder { <10.7857, 16.9986, 7.7354>, <11.4851, 18.0197, 8.04989>, 0.2128 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <11.4851, 18.0197, 8.04989>, <11.7569, 18.2458, 8.1291>, 0.01811 }
				cylinder { <11.7569, 18.2458, 8.1291>, <12.0823, 18.392, 8.1926>, 0.01811 }
				cylinder { <12.0823, 18.392, 8.1926>, <12.4377, 18.4477, 8.2359>, 0.01811 }
				texture {fol5}}
			mesh { // leaf
				triangle { <14.7475, 19.3667, 8.04062>, <20.06939, 19.8544, 7.8963>, <12.4377, 18.4477, 8.2359> }
				triangle { <14.7475, 19.3667, 8.04062>, <19.9687, 20.5688, 7.8036>, <20.06939, 19.8544, 7.8963> }
				triangle { <19.9687, 20.5688, 7.8036>, <24.04454, 21.5059, 5.9088>, <20.06939, 19.8544, 7.8963> }
				triangle { <20.06939, 19.8544, 7.8963>, <24.04454, 21.5059, 5.9088>, <24.2271, 20.9276, 5.8663> }
				triangle { <24.04454, 21.5059, 5.9088>, <24.4824, 21.7355, 4.1533>, <24.2271, 20.9276, 5.8663> }
				triangle { <24.4824, 21.7355, 4.1533>, <24.2808, 20.5808, 5.8715>, <24.2271, 20.9276, 5.8663> }
				triangle { <24.2271, 20.9276, 5.8663>, <24.2808, 20.5808, 5.8715>, <20.06939, 19.8544, 7.8963> }
				triangle { <20.06939, 19.8544, 7.8963>, <24.2808, 20.5808, 5.8715>, <20.2603, 19.1739, 7.9168> }
				triangle { <20.2603, 19.1739, 7.9168>, <12.4377, 18.4477, 8.2359>, <20.06939, 19.8544, 7.8963> }
				triangle { <12.4377, 18.4477, 8.2359>, <20.2603, 19.1739, 7.9168>, <14.8132, 18.1488, 8.3559> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <11.4851, 18.0197, 8.04989>, <12.1845, 19.04071, 8.3643>, 0.2128 }
				cylinder { <12.1845, 19.04071, 8.3643>, <12.8839, 20.06173, 8.6787>, 0.2128 }
				cylinder { <12.8839, 20.06173, 8.6787>, <13.5833, 21.08275, 8.9932>, 0.2128 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <13.5833, 21.08275, 8.9932>, <13.6941, 21.415, 9.08593>, 0.01811 }
				cylinder { <13.6941, 21.415, 9.08593>, <13.7092, 21.7658, 9.1754>, 0.01811 }
				cylinder { <13.7092, 21.7658, 9.1754>, <13.6275, 22.1096, 9.2552>, 0.01811 }
				texture {fol5}}
			mesh { // leaf
				triangle { <12.724, 24.4313, 9.1488>, <12.08381, 29.7082, 9.7196>, <13.6275, 22.1096, 9.2552> }
				triangle { <12.724, 24.4313, 9.1488>, <11.4428, 29.6338, 9.384>, <12.08381, 29.7082, 9.7196> }
				triangle { <11.4428, 29.6338, 9.384>, <10.997, 33.981, 7.9757>, <12.08381, 29.7082, 9.7196> }
				triangle { <12.08381, 29.7082, 9.7196>, <10.997, 33.981, 7.9757>, <11.5497, 34.1606, 8.1544> }
				triangle { <10.997, 33.981, 7.9757>, <11.3295, 34.7095, 6.3371>, <11.5497, 34.1606, 8.1544> }
				triangle { <11.3295, 34.7095, 6.3371>, <11.8736, 34.2082, 8.281>, <11.5497, 34.1606, 8.1544> }
				triangle { <11.5497, 34.1606, 8.1544>, <11.8736, 34.2082, 8.281>, <12.08381, 29.7082, 9.7196> }
				triangle { <12.08381, 29.7082, 9.7196>, <11.8736, 34.2082, 8.281>, <12.7123, 29.8841, 9.9917> }
				triangle { <12.7123, 29.8841, 9.9917>, <13.6275, 22.1096, 9.2552>, <12.08381, 29.7082, 9.7196> }
				triangle { <13.6275, 22.1096, 9.2552>, <12.7123, 29.8841, 9.9917>, <13.7704, 24.4274, 9.8503> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <13.5833, 21.08275, 8.9932>, <14.2827, 22.1037, 9.3076>, 0.2128 }
				cylinder { <14.2827, 22.1037, 9.3076>, <14.9822, 23.1247, 9.622>, 0.2128 }
				cylinder { <14.9822, 23.1247, 9.622>, <15.6816, 24.1458, 9.9365>, 0.2128 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <15.6816, 24.1458, 9.9365>, <15.9533, 24.3719, 10.01577>, 0.01811 }
				cylinder { <15.9533, 24.3719, 10.01577>, <16.2787, 24.5182, 10.07932>, 0.01811 }
				cylinder { <16.2787, 24.5182, 10.07932>, <16.6341, 24.5739, 10.1225>, 0.01811 }
				texture {fol5}}
			mesh { // leaf
				triangle { <18.9439, 25.4928, 9.9272>, <24.2658, 25.9806, 9.7829>, <16.6341, 24.5739, 10.1225> }
				triangle { <18.9439, 25.4928, 9.9272>, <24.1651, 26.6949, 9.6902>, <24.2658, 25.9806, 9.7829> }
				triangle { <24.1651, 26.6949, 9.6902>, <28.2409, 27.6321, 7.7954>, <24.2658, 25.9806, 9.7829> }
				triangle { <24.2658, 25.9806, 9.7829>, <28.2409, 27.6321, 7.7954>, <28.4235, 27.05379, 7.7529> }
				triangle { <28.2409, 27.6321, 7.7954>, <28.6789, 27.8616, 6.03995>, <28.4235, 27.05379, 7.7529> }
				triangle { <28.6789, 27.8616, 6.03995>, <28.4772, 26.7069, 7.7581>, <28.4235, 27.05379, 7.7529> }
				triangle { <28.4235, 27.05379, 7.7529>, <28.4772, 26.7069, 7.7581>, <24.2658, 25.9806, 9.7829> }
				triangle { <24.2658, 25.9806, 9.7829>, <28.4772, 26.7069, 7.7581>, <24.4567, 25.3, 9.8035> }
				triangle { <24.4567, 25.3, 9.8035>, <16.6341, 24.5739, 10.1225>, <24.2658, 25.9806, 9.7829> }
				triangle { <16.6341, 24.5739, 10.1225>, <24.4567, 25.3, 9.8035>, <19.00964, 24.2749, 10.2425> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <15.6816, 24.1458, 9.9365>, <16.381, 25.1668, 10.2509>, 0.2128 }
				cylinder { <16.381, 25.1668, 10.2509>, <17.08042, 26.1878, 10.5653>, 0.2128 }
				cylinder { <17.08042, 26.1878, 10.5653>, <17.7798, 27.2088, 10.8798>, 0.2128 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <17.7798, 27.2088, 10.8798>, <17.8906, 27.5411, 10.9725>, 0.01811 }
				cylinder { <17.8906, 27.5411, 10.9725>, <17.9057, 27.8919, 11.06208>, 0.01811 }
				cylinder { <17.9057, 27.8919, 11.06208>, <17.8239, 28.2358, 11.1419>, 0.01811 }
				texture {fol5}}
			mesh { // leaf
				triangle { <16.9204, 30.5574, 11.03546>, <16.2802, 35.8343, 11.6063>, <17.8239, 28.2358, 11.1419> }
				triangle { <16.9204, 30.5574, 11.03546>, <15.6392, 35.7599, 11.2707>, <16.2802, 35.8343, 11.6063> }
				triangle { <15.6392, 35.7599, 11.2707>, <15.1935, 40.1071, 9.8623>, <16.2802, 35.8343, 11.6063> }
				triangle { <16.2802, 35.8343, 11.6063>, <15.1935, 40.1071, 9.8623>, <15.7461, 40.2867, 10.04107> }
				triangle { <15.1935, 40.1071, 9.8623>, <15.5259, 40.8356, 8.2237>, <15.7461, 40.2867, 10.04107> }
				triangle { <15.5259, 40.8356, 8.2237>, <16.07005, 40.3343, 10.1677>, <15.7461, 40.2867, 10.04107> }
				triangle { <15.7461, 40.2867, 10.04107>, <16.07005, 40.3343, 10.1677>, <16.2802, 35.8343, 11.6063> }
				triangle { <16.2802, 35.8343, 11.6063>, <16.07005, 40.3343, 10.1677>, <16.9087, 36.01026, 11.8783> }
				triangle { <16.9087, 36.01026, 11.8783>, <17.8239, 28.2358, 11.1419>, <16.2802, 35.8343, 11.6063> }
				triangle { <17.8239, 28.2358, 11.1419>, <16.9087, 36.01026, 11.8783>, <17.9668, 30.5536, 11.7369> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <17.7798, 27.2088, 10.8798>, <18.4792, 28.2298, 11.1942>, 0.2128 }
				cylinder { <18.4792, 28.2298, 11.1942>, <19.1786, 29.2509, 11.5087>, 0.2128 }
				cylinder { <19.1786, 29.2509, 11.5087>, <19.878, 30.2719, 11.8231>, 0.2128 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <19.878, 30.2719, 11.8231>, <20.1498, 30.498, 11.9024>, 0.01811 }
				cylinder { <20.1498, 30.498, 11.9024>, <20.4751, 30.6443, 11.9659>, 0.01811 }
				cylinder { <20.4751, 30.6443, 11.9659>, <20.8306, 30.7, 12.00918>, 0.01811 }
				texture {fol5}}
			mesh { // leaf
				triangle { <23.1403, 31.6189, 11.8138>, <28.4622, 32.1067, 11.6696>, <20.8306, 30.7, 12.00918> }
				triangle { <23.1403, 31.6189, 11.8138>, <28.3616, 32.821, 11.5769>, <28.4622, 32.1067, 11.6696> }
				triangle { <28.3616, 32.821, 11.5769>, <32.4374, 33.7582, 9.682>, <28.4622, 32.1067, 11.6696> }
				triangle { <28.4622, 32.1067, 11.6696>, <32.4374, 33.7582, 9.682>, <32.62, 33.1799, 9.6396> }
				triangle { <32.4374, 33.7582, 9.682>, <32.8753, 33.9877, 7.9265>, <32.62, 33.1799, 9.6396> }
				triangle { <32.8753, 33.9877, 7.9265>, <32.6737, 32.833, 9.6448>, <32.62, 33.1799, 9.6396> }
				triangle { <32.62, 33.1799, 9.6396>, <32.6737, 32.833, 9.6448>, <28.4622, 32.1067, 11.6696> }
				triangle { <28.4622, 32.1067, 11.6696>, <32.6737, 32.833, 9.6448>, <28.6532, 31.4261, 11.6901> }
				triangle { <28.6532, 31.4261, 11.6901>, <20.8306, 30.7, 12.00918>, <28.4622, 32.1067, 11.6696> }
				triangle { <20.8306, 30.7, 12.00918>, <28.6532, 31.4261, 11.6901>, <23.206, 30.401, 12.1292> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <19.878, 30.2719, 11.8231>, <20.07652, 30.5616, 11.9123>, 0.01811 }
				cylinder { <20.07652, 30.5616, 11.9123>, <20.2749, 30.8513, 12.00159>, 0.01811 }
				cylinder { <20.2749, 30.8513, 12.00159>, <20.4734, 31.1411, 12.09082>, 0.01811 }
				texture {fol5}}
			mesh { // leaf
				triangle { <21.4718, 33.4256, 12.1313>, <24.8422, 37.5311, 12.7371>, <20.4734, 31.1411, 12.09082> }
				triangle { <21.4718, 33.4256, 12.1313>, <24.2953, 37.9671, 12.5377>, <24.8422, 37.5311, 12.7371> }
				triangle { <24.2953, 37.9671, 12.5377>, <26.8423, 41.5379, 11.1799>, <24.8422, 37.5311, 12.7371> }
				triangle { <24.8422, 37.5311, 12.7371>, <26.8423, 41.5379, 11.1799>, <27.3784, 41.2581, 11.2417> }
				triangle { <26.8423, 41.5379, 11.1799>, <27.3369, 42.03683, 9.4969>, <27.3784, 41.2581, 11.2417> }
				triangle { <27.3369, 42.03683, 9.4969>, <27.6553, 41.05045, 11.3002>, <27.3784, 41.2581, 11.2417> }
				triangle { <27.3784, 41.2581, 11.2417>, <27.6553, 41.05045, 11.3002>, <24.8422, 37.5311, 12.7371> }
				triangle { <24.8422, 37.5311, 12.7371>, <27.6553, 41.05045, 11.3002>, <25.4425, 37.1838, 12.8751> }
				triangle { <25.4425, 37.1838, 12.8751>, <20.4734, 31.1411, 12.09082>, <24.8422, 37.5311, 12.7371> }
				triangle { <20.4734, 31.1411, 12.09082>, <25.4425, 37.1838, 12.8751>, <22.2995, 32.605, 12.6093> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <0.637, 2.4583, 1.00596>, <0.6846, 2.5209, 1.08117>, 0.08166 }
		cylinder { <0.6846, 2.5209, 1.08117>, <0.7322, 2.5836, 1.1563>, 0.08166 }
		cylinder { <0.7322, 2.5836, 1.1563>, <0.7798, 2.6463, 1.2315>, 0.08166 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.7798, 2.6463, 1.2315>, <1.3536, 3.7327, 2.7616>, 0.09811 }
			cylinder { <1.3536, 3.7327, 2.7616>, <1.6259, 4.7436, 4.4213>, 0.09811 }
			cylinder { <1.6259, 4.7436, 4.4213>, <1.5887, 5.6491, 6.1616>, 0.09811 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <1.5887, 5.6491, 6.1616>, <1.5775, 5.9208, 6.6838>, 0.09811 }
				cylinder { <1.5775, 5.9208, 6.6838>, <1.5663, 6.1925, 7.2059>, 0.09811 }
				cylinder { <1.5663, 6.1925, 7.2059>, <1.5552, 6.4642, 7.728>, 0.09811 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.5552, 6.4642, 7.728>, <1.5618, 6.4817, 7.8027>, 0.00385 }
				cylinder { <1.5618, 6.4817, 7.8027>, <1.5759, 6.48, 7.8784>, 0.00385 }
				cylinder { <1.5759, 6.48, 7.8784>, <1.5966, 6.4591, 7.9495>, 0.00385 }
				texture {fol5}}
			mesh { // leaf
				triangle { <1.6946, 5.8885, 8.9426>, <1.9934, 5.3287, 11.3242>, <1.5966, 6.4591, 7.9495> }
				triangle { <1.6946, 5.8885, 8.9426>, <1.9736, 5.006076, 11.2353>, <1.9934, 5.3287, 11.3242> }
				triangle { <1.9736, 5.006076, 11.2353>, <1.4139, 4.2336, 13.1249>, <1.9934, 5.3287, 11.3242> }
				triangle { <1.9934, 5.3287, 11.3242>, <1.4139, 4.2336, 13.1249>, <1.3831, 4.4828, 13.2494> }
				triangle { <1.4139, 4.2336, 13.1249>, <0.6534, 4.01578, 13.4097>, <1.3831, 4.4828, 13.2494> }
				triangle { <0.6534, 4.01578, 13.4097>, <1.3749, 4.6372, 13.2971>, <1.3831, 4.4828, 13.2494> }
				triangle { <1.3831, 4.4828, 13.2494>, <1.3749, 4.6372, 13.2971>, <1.9934, 5.3287, 11.3242> }
				triangle { <1.9934, 5.3287, 11.3242>, <1.3749, 4.6372, 13.2971>, <1.9876, 5.6269, 11.4558> }
				triangle { <1.9876, 5.6269, 11.4558>, <1.5966, 6.4591, 7.9495>, <1.9934, 5.3287, 11.3242> }
				triangle { <1.5966, 6.4591, 7.9495>, <1.9876, 5.6269, 11.4558>, <1.793, 6.453, 9.03712> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <1.5552, 6.4642, 7.728>, <1.544, 6.7358, 8.2501>, 0.09811 }
				cylinder { <1.544, 6.7358, 8.2501>, <1.5329, 7.007567, 8.7722>, 0.09811 }
				cylinder { <1.5329, 7.007567, 8.7722>, <1.5217, 7.2792, 9.2943>, 0.09811 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.5217, 7.2792, 9.2943>, <1.5123, 7.3302, 9.3513>, 0.00385 }
				cylinder { <1.5123, 7.3302, 9.3513>, <1.4956, 7.3929, 9.3928>, 0.00385 }
				cylinder { <1.4956, 7.3929, 9.3928>, <1.4729, 7.4627, 9.4158>, 0.00385 }
				texture {fol5}}
			mesh { // leaf
				triangle { <0.9457, 8.3183, 9.9739>, <-0.1213, 10.4689, 10.5315>, <1.4729, 7.4627, 9.4158> }
				triangle { <0.9457, 8.3183, 9.9739>, <-0.1498, 10.3561, 10.8459>, <-0.1213, 10.4689, 10.5315> }
				triangle { <-0.1498, 10.3561, 10.8459>, <-1.7244, 11.6326, 11.4554>, <-0.1213, 10.4689, 10.5315> }
				triangle { <-0.1213, 10.4689, 10.5315>, <-1.7244, 11.6326, 11.4554>, <-1.7698, 11.7444, 11.2025> }
				triangle { <-1.7244, 11.6326, 11.4554>, <-2.5481, 11.4747, 11.5153>, <-1.7698, 11.7444, 11.2025> }
				triangle { <-2.5481, 11.4747, 11.5153>, <-1.7737, 11.7938, 11.04848>, <-1.7698, 11.7444, 11.2025> }
				triangle { <-1.7698, 11.7444, 11.2025>, <-1.7737, 11.7938, 11.04848>, <-0.1213, 10.4689, 10.5315> }
				triangle { <-0.1213, 10.4689, 10.5315>, <-1.7737, 11.7938, 11.04848>, <-0.1406, 10.6035, 10.2352> }
				triangle { <-0.1406, 10.6035, 10.2352>, <1.4729, 7.4627, 9.4158>, <-0.1213, 10.4689, 10.5315> }
				triangle { <1.4729, 7.4627, 9.4158>, <-0.1406, 10.6035, 10.2352>, <1.08029, 8.4956, 9.4374> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <1.5217, 7.2792, 9.2943>, <1.5105, 7.5509, 9.8165>, 0.09811 }
				cylinder { <1.5105, 7.5509, 9.8165>, <1.4994, 7.8225, 10.3386>, 0.09811 }
				cylinder { <1.4994, 7.8225, 10.3386>, <1.4882, 8.09426, 10.8607>, 0.09811 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.4882, 8.09426, 10.8607>, <1.4948, 8.1118, 10.9354>, 0.00385 }
				cylinder { <1.4948, 8.1118, 10.9354>, <1.509, 8.11, 11.0111>, 0.00385 }
				cylinder { <1.509, 8.11, 11.0111>, <1.5297, 8.0892, 11.08228>, 0.00385 }
				texture {fol5}}
			mesh { // leaf
				triangle { <1.6276, 7.5185, 12.07537>, <1.9264, 6.9588, 14.4569>, <1.5297, 8.0892, 11.08228> }
				triangle { <1.6276, 7.5185, 12.07537>, <1.9066, 6.6361, 14.368>, <1.9264, 6.9588, 14.4569> }
				triangle { <1.9066, 6.6361, 14.368>, <1.347, 5.8637, 16.2576>, <1.9264, 6.9588, 14.4569> }
				triangle { <1.9264, 6.9588, 14.4569>, <1.347, 5.8637, 16.2576>, <1.3161, 6.1128, 16.3821> }
				triangle { <1.347, 5.8637, 16.2576>, <0.5864, 5.6458, 16.5424>, <1.3161, 6.1128, 16.3821> }
				triangle { <0.5864, 5.6458, 16.5424>, <1.308, 6.2673, 16.4298>, <1.3161, 6.1128, 16.3821> }
				triangle { <1.3161, 6.1128, 16.3821>, <1.308, 6.2673, 16.4298>, <1.9264, 6.9588, 14.4569> }
				triangle { <1.9264, 6.9588, 14.4569>, <1.308, 6.2673, 16.4298>, <1.9206, 7.257, 14.5885> }
				triangle { <1.9206, 7.257, 14.5885>, <1.5297, 8.0892, 11.08228>, <1.9264, 6.9588, 14.4569> }
				triangle { <1.5297, 8.0892, 11.08228>, <1.9206, 7.257, 14.5885>, <1.726, 8.08307, 12.1698> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <1.4882, 8.09426, 10.8607>, <1.4771, 8.3659, 11.3828>, 0.09811 }
				cylinder { <1.4771, 8.3659, 11.3828>, <1.4659, 8.6376, 11.9049>, 0.09811 }
				cylinder { <1.4659, 8.6376, 11.9049>, <1.4547, 8.9092, 12.427>, 0.09811 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.4547, 8.9092, 12.427>, <1.4453, 8.9602, 12.484>, 0.00385 }
				cylinder { <1.4453, 8.9602, 12.484>, <1.4287, 9.02295, 12.5255>, 0.00385 }
				cylinder { <1.4287, 9.02295, 12.5255>, <1.4059, 9.09283, 12.5485>, 0.00385 }
				texture {fol5}}
			mesh { // leaf
				triangle { <0.8787, 9.9484, 13.1066>, <-0.1883, 12.09898, 13.6642>, <1.4059, 9.09283, 12.5485> }
				triangle { <0.8787, 9.9484, 13.1066>, <-0.2167, 11.9861, 13.9786>, <-0.1883, 12.09898, 13.6642> }
				triangle { <-0.2167, 11.9861, 13.9786>, <-1.7913, 13.2626, 14.5881>, <-0.1883, 12.09898, 13.6642> }
				triangle { <-0.1883, 12.09898, 13.6642>, <-1.7913, 13.2626, 14.5881>, <-1.8368, 13.3744, 14.3352> }
				triangle { <-1.7913, 13.2626, 14.5881>, <-2.615, 13.1048, 14.648>, <-1.8368, 13.3744, 14.3352> }
				triangle { <-2.615, 13.1048, 14.648>, <-1.8406, 13.4239, 14.1811>, <-1.8368, 13.3744, 14.3352> }
				triangle { <-1.8368, 13.3744, 14.3352>, <-1.8406, 13.4239, 14.1811>, <-0.1883, 12.09898, 13.6642> }
				triangle { <-0.1883, 12.09898, 13.6642>, <-1.8406, 13.4239, 14.1811>, <-0.2076, 12.2335, 13.3679> }
				triangle { <-0.2076, 12.2335, 13.3679>, <1.4059, 9.09283, 12.5485>, <-0.1883, 12.09898, 13.6642> }
				triangle { <1.4059, 9.09283, 12.5485>, <-0.2076, 12.2335, 13.3679>, <1.01333, 10.1256, 12.5701> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <1.4547, 8.9092, 12.427>, <1.4436, 9.1809, 12.9492>, 0.09811 }
				cylinder { <1.4436, 9.1809, 12.9492>, <1.4324, 9.4526, 13.4713>, 0.09811 }
				cylinder { <1.4324, 9.4526, 13.4713>, <1.4213, 9.7243, 13.9934>, 0.09811 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.4213, 9.7243, 13.9934>, <1.4279, 9.7418, 14.06813>, 0.00385 }
				cylinder { <1.4279, 9.7418, 14.06813>, <1.442, 9.7401, 14.1438>, 0.00385 }
				cylinder { <1.442, 9.7401, 14.1438>, <1.4627, 9.7192, 14.2149>, 0.00385 }
				texture {fol5}}
			mesh { // leaf
				triangle { <1.5606, 9.1486, 15.208>, <1.8594, 8.5888, 17.5896>, <1.4627, 9.7192, 14.2149> }
				triangle { <1.5606, 9.1486, 15.208>, <1.8396, 8.2661, 17.5007>, <1.8594, 8.5888, 17.5896> }
				triangle { <1.8396, 8.2661, 17.5007>, <1.28, 7.4937, 19.3903>, <1.8594, 8.5888, 17.5896> }
				triangle { <1.8594, 8.5888, 17.5896>, <1.28, 7.4937, 19.3903>, <1.2492, 7.7429, 19.5148> }
				triangle { <1.28, 7.4937, 19.3903>, <0.5195, 7.2758, 19.6751>, <1.2492, 7.7429, 19.5148> }
				triangle { <0.5195, 7.2758, 19.6751>, <1.241, 7.8973, 19.5625>, <1.2492, 7.7429, 19.5148> }
				triangle { <1.2492, 7.7429, 19.5148>, <1.241, 7.8973, 19.5625>, <1.8594, 8.5888, 17.5896> }
				triangle { <1.8594, 8.5888, 17.5896>, <1.241, 7.8973, 19.5625>, <1.8537, 8.887, 17.7212> }
				triangle { <1.8537, 8.887, 17.7212>, <1.4627, 9.7192, 14.2149>, <1.8594, 8.5888, 17.5896> }
				triangle { <1.4627, 9.7192, 14.2149>, <1.8537, 8.887, 17.7212>, <1.6591, 9.7131, 15.3025> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <1.4213, 9.7243, 13.9934>, <1.4101, 9.9959, 14.5155>, 0.09811 }
				cylinder { <1.4101, 9.9959, 14.5155>, <1.3989, 10.2676, 15.03767>, 0.09811 }
				cylinder { <1.3989, 10.2676, 15.03767>, <1.3878, 10.5393, 15.5597>, 0.09811 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.3878, 10.5393, 15.5597>, <1.3784, 10.5903, 15.6167>, 0.00385 }
				cylinder { <1.3784, 10.5903, 15.6167>, <1.3617, 10.653, 15.6582>, 0.00385 }
				cylinder { <1.3617, 10.653, 15.6582>, <1.339, 10.7228, 15.6812>, 0.00385 }
				texture {fol5}}
			mesh { // leaf
				triangle { <0.8117, 11.5784, 16.2393>, <-0.2553, 13.729, 16.7969>, <1.339, 10.7228, 15.6812> }
				triangle { <0.8117, 11.5784, 16.2393>, <-0.2837, 13.6162, 17.1113>, <-0.2553, 13.729, 16.7969> }
				triangle { <-0.2837, 13.6162, 17.1113>, <-1.8583, 14.8927, 17.7208>, <-0.2553, 13.729, 16.7969> }
				triangle { <-0.2553, 13.729, 16.7969>, <-1.8583, 14.8927, 17.7208>, <-1.9037, 15.0045, 17.4679> }
				triangle { <-1.8583, 14.8927, 17.7208>, <-2.682, 14.7348, 17.7807>, <-1.9037, 15.0045, 17.4679> }
				triangle { <-2.682, 14.7348, 17.7807>, <-1.9076, 15.05398, 17.3138>, <-1.9037, 15.0045, 17.4679> }
				triangle { <-1.9037, 15.0045, 17.4679>, <-1.9076, 15.05398, 17.3138>, <-0.2553, 13.729, 16.7969> }
				triangle { <-0.2553, 13.729, 16.7969>, <-1.9076, 15.05398, 17.3138>, <-0.2745, 13.8636, 16.5006> }
				triangle { <-0.2745, 13.8636, 16.5006>, <1.339, 10.7228, 15.6812>, <-0.2553, 13.729, 16.7969> }
				triangle { <1.339, 10.7228, 15.6812>, <-0.2745, 13.8636, 16.5006>, <0.9463, 11.7557, 15.7028> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.3878, 10.5393, 15.5597>, <1.3863, 10.5748, 15.628>, 0.00385 }
				cylinder { <1.3863, 10.5748, 15.628>, <1.3849, 10.6104, 15.6963>, 0.00385 }
				cylinder { <1.3849, 10.6104, 15.6963>, <1.3834, 10.6459, 15.7646>, 0.00385 }
				texture {fol5}}
			mesh { // leaf
				triangle { <1.186, 10.8963, 16.8691>, <0.7591, 12.09983, 18.9771>, <1.3834, 10.6459, 15.7646> }
				triangle { <1.186, 10.8963, 16.8691>, <0.7729, 11.8027, 19.132>, <0.7591, 12.09983, 18.9771> }
				triangle { <0.7729, 11.8027, 19.132>, <-0.319, 12.3431, 20.8628>, <0.7591, 12.09983, 18.9771> }
				triangle { <0.7591, 12.09983, 18.9771>, <-0.319, 12.3431, 20.8628>, <-0.3906, 12.5987, 20.7726> }
				triangle { <-0.319, 12.3431, 20.8628>, <-1.126, 12.2019, 21.05186>, <-0.3906, 12.5987, 20.7726> }
				triangle { <-1.126, 12.2019, 21.05186>, <-0.4156, 12.7403, 20.6984>, <-0.3906, 12.5987, 20.7726> }
				triangle { <-0.3906, 12.5987, 20.7726>, <-0.4156, 12.7403, 20.6984>, <0.7591, 12.09983, 18.9771> }
				triangle { <0.7591, 12.09983, 18.9771>, <-0.4156, 12.7403, 20.6984>, <0.7083, 12.4011, 18.8635> }
				triangle { <0.7083, 12.4011, 18.8635>, <1.3834, 10.6459, 15.7646>, <0.7591, 12.09983, 18.9771> }
				triangle { <1.3834, 10.6459, 15.7646>, <0.7083, 12.4011, 18.8635>, <1.2411, 11.3904, 16.5689> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <0.7798, 2.6463, 1.2315>, <0.8024, 2.6761, 1.2672>, 0.03869 }
		cylinder { <0.8024, 2.6761, 1.2672>, <0.825, 2.7058, 1.3028>, 0.03869 }
		cylinder { <0.825, 2.7058, 1.3028>, <0.8476, 2.7355, 1.3385>, 0.03869 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.8476, 2.7355, 1.3385>, <1.4367, 3.2286, 2.007436>, 0.05093 }
			cylinder { <1.4367, 3.2286, 2.007436>, <2.1521, 3.6137, 2.6219>, 0.05093 }
			cylinder { <2.1521, 3.6137, 2.6219>, <2.9727, 3.8796, 3.1639>, 0.05093 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.9727, 3.8796, 3.1639>, <3.2189, 3.9593, 3.3265>, 0.05093 }
				cylinder { <3.2189, 3.9593, 3.3265>, <3.465, 4.03909, 3.4891>, 0.05093 }
				cylinder { <3.465, 4.03909, 3.4891>, <3.7112, 4.1188, 3.6517>, 0.05093 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <3.7112, 4.1188, 3.6517>, <3.7287, 4.1277, 3.6584>, 0.001037 }
				cylinder { <3.7287, 4.1277, 3.6584>, <3.7458, 4.1393, 3.6603>, 0.001037 }
				cylinder { <3.7458, 4.1393, 3.6603>, <3.7612, 4.1529, 3.6572>, 0.001037 }
				texture {fol5}}
			mesh { // leaf
				triangle { <4.2185, 4.4528, 3.4184>, <5.2911, 5.1333, 3.2643>, <3.7612, 4.1529, 3.6572> }
				triangle { <4.2185, 4.4528, 3.4184>, <5.2574, 5.1331, 3.0936>, <5.2911, 5.1333, 3.2643> }
				triangle { <5.2574, 5.1331, 3.0936>, <6.2814, 5.3277, 2.7456>, <5.2911, 5.1333, 3.2643> }
				triangle { <5.2911, 5.1333, 3.2643>, <6.2814, 5.3277, 2.7456>, <6.3437, 5.3178, 2.8767> }
				triangle { <6.2814, 5.3277, 2.7456>, <6.5803, 5.04892, 2.5923>, <6.3437, 5.3178, 2.8767> }
				triangle { <6.5803, 5.04892, 2.5923>, <6.3659, 5.3107, 2.9574>, <6.3437, 5.3178, 2.8767> }
				triangle { <6.3437, 5.3178, 2.8767>, <6.3659, 5.3107, 2.9574>, <5.2911, 5.1333, 3.2643> }
				triangle { <5.2911, 5.1333, 3.2643>, <6.3659, 5.3107, 2.9574>, <5.3507, 5.1325, 3.4227> }
				triangle { <5.3507, 5.1325, 3.4227>, <3.7612, 4.1529, 3.6572>, <5.2911, 5.1333, 3.2643> }
				triangle { <3.7612, 4.1529, 3.6572>, <5.3507, 5.1325, 3.4227>, <4.235, 4.4705, 3.7189> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <3.7112, 4.1188, 3.6517>, <3.9574, 4.1985, 3.8143>, 0.05093 }
				cylinder { <3.9574, 4.1985, 3.8143>, <4.2036, 4.2783, 3.9769>, 0.05093 }
				cylinder { <4.2036, 4.2783, 3.9769>, <4.4497, 4.358, 4.1394>, 0.05093 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <4.4497, 4.358, 4.1394>, <4.4644, 4.3596, 4.154>, 0.001037 }
				cylinder { <4.4644, 4.3596, 4.154>, <4.476, 4.3573, 4.1711>, 0.001037 }
				cylinder { <4.476, 4.3573, 4.1711>, <4.4837, 4.3511, 4.1893>, 0.001037 }
				texture {fol5}}
			mesh { // leaf
				triangle { <4.8485, 4.1469, 4.6152>, <5.3103, 3.5796, 5.665>, <4.4837, 4.3511, 4.1893> }
				triangle { <4.8485, 4.1469, 4.6152>, <5.4668, 3.641, 5.6199>, <5.3103, 3.5796, 5.665> }
				triangle { <5.4668, 3.641, 5.6199>, <6.07222, 2.921, 6.1879>, <5.3103, 3.5796, 5.665> }
				triangle { <5.3103, 3.5796, 5.665>, <6.07222, 2.921, 6.1879>, <5.9605, 2.8379, 6.2301> }
				triangle { <6.07222, 2.921, 6.1879>, <6.277, 2.561, 6.05037>, <5.9605, 2.8379, 6.2301> }
				triangle { <6.277, 2.561, 6.05037>, <5.8877, 2.8, 6.248>, <5.9605, 2.8379, 6.2301> }
				triangle { <5.9605, 2.8379, 6.2301>, <5.8877, 2.8, 6.248>, <5.3103, 3.5796, 5.665> }
				triangle { <5.3103, 3.5796, 5.665>, <5.8877, 2.8, 6.248>, <5.1722, 3.4978, 5.7187> }
				triangle { <5.1722, 3.4978, 5.7187>, <4.4837, 4.3511, 4.1893>, <5.3103, 3.5796, 5.665> }
				triangle { <4.4837, 4.3511, 4.1893>, <5.1722, 3.4978, 5.7187>, <4.5635, 4.08391, 4.6907> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <4.4497, 4.358, 4.1394>, <4.6959, 4.4378, 4.302>, 0.05093 }
				cylinder { <4.6959, 4.4378, 4.302>, <4.9421, 4.5175, 4.4646>, 0.05093 }
				cylinder { <4.9421, 4.5175, 4.4646>, <5.1882, 4.5973, 4.6272>, 0.05093 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <5.1882, 4.5973, 4.6272>, <5.2058, 4.6061, 4.634>, 0.001037 }
				cylinder { <5.2058, 4.6061, 4.634>, <5.2228, 4.6178, 4.6359>, 0.001037 }
				cylinder { <5.2228, 4.6178, 4.6359>, <5.2382, 4.6314, 4.6328>, 0.001037 }
				texture {fol5}}
			mesh { // leaf
				triangle { <5.6956, 4.9313, 4.394>, <6.7681, 5.6118, 4.2399>, <5.2382, 4.6314, 4.6328> }
				triangle { <5.6956, 4.9313, 4.394>, <6.7344, 5.6116, 4.06917>, <6.7681, 5.6118, 4.2399> }
				triangle { <6.7344, 5.6116, 4.06917>, <7.7584, 5.8062, 3.7212>, <6.7681, 5.6118, 4.2399> }
				triangle { <6.7681, 5.6118, 4.2399>, <7.7584, 5.8062, 3.7212>, <7.8207, 5.7963, 3.8523> }
				triangle { <7.7584, 5.8062, 3.7212>, <8.05733, 5.5274, 3.5679>, <7.8207, 5.7963, 3.8523> }
				triangle { <8.05733, 5.5274, 3.5679>, <7.843, 5.7892, 3.933>, <7.8207, 5.7963, 3.8523> }
				triangle { <7.8207, 5.7963, 3.8523>, <7.843, 5.7892, 3.933>, <6.7681, 5.6118, 4.2399> }
				triangle { <6.7681, 5.6118, 4.2399>, <7.843, 5.7892, 3.933>, <6.8277, 5.611, 4.3983> }
				triangle { <6.8277, 5.611, 4.3983>, <5.2382, 4.6314, 4.6328>, <6.7681, 5.6118, 4.2399> }
				triangle { <5.2382, 4.6314, 4.6328>, <6.8277, 5.611, 4.3983>, <5.712, 4.949, 4.6945> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <5.1882, 4.5973, 4.6272>, <5.4344, 4.677, 4.7898>, 0.05093 }
				cylinder { <5.4344, 4.677, 4.7898>, <5.6806, 4.7568, 4.9524>, 0.05093 }
				cylinder { <5.6806, 4.7568, 4.9524>, <5.9268, 4.8365, 5.115>, 0.05093 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <5.9268, 4.8365, 5.115>, <5.9415, 4.8381, 5.1296>, 0.001037 }
				cylinder { <5.9415, 4.8381, 5.1296>, <5.9531, 4.8357, 5.1466>, 0.001037 }
				cylinder { <5.9531, 4.8357, 5.1466>, <5.9607, 4.8296, 5.1649>, 0.001037 }
				texture {fol5}}
			mesh { // leaf
				triangle { <6.3255, 4.6254, 5.5908>, <6.7873, 4.05817, 6.6406>, <5.9607, 4.8296, 5.1649> }
				triangle { <6.3255, 4.6254, 5.5908>, <6.9438, 4.1195, 6.5954>, <6.7873, 4.05817, 6.6406> }
				triangle { <6.9438, 4.1195, 6.5954>, <7.5492, 3.3995, 7.1635>, <6.7873, 4.05817, 6.6406> }
				triangle { <6.7873, 4.05817, 6.6406>, <7.5492, 3.3995, 7.1635>, <7.4375, 3.3164, 7.2056> }
				triangle { <7.5492, 3.3995, 7.1635>, <7.7541, 3.0395, 7.02594>, <7.4375, 3.3164, 7.2056> }
				triangle { <7.7541, 3.0395, 7.02594>, <7.3647, 3.2785, 7.2235>, <7.4375, 3.3164, 7.2056> }
				triangle { <7.4375, 3.3164, 7.2056>, <7.3647, 3.2785, 7.2235>, <6.7873, 4.05817, 6.6406> }
				triangle { <6.7873, 4.05817, 6.6406>, <7.3647, 3.2785, 7.2235>, <6.6492, 3.9763, 6.6943> }
				triangle { <6.6492, 3.9763, 6.6943>, <5.9607, 4.8296, 5.1649>, <6.7873, 4.05817, 6.6406> }
				triangle { <5.9607, 4.8296, 5.1649>, <6.6492, 3.9763, 6.6943>, <6.04056, 4.5623, 5.6663> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <5.9268, 4.8365, 5.115>, <6.1729, 4.9163, 5.2776>, 0.05093 }
				cylinder { <6.1729, 4.9163, 5.2776>, <6.4191, 4.996, 5.4402>, 0.05093 }
				cylinder { <6.4191, 4.996, 5.4402>, <6.6653, 5.07581, 5.6028>, 0.05093 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <6.6653, 5.07581, 5.6028>, <6.6828, 5.08466, 5.6095>, 0.001037 }
				cylinder { <6.6828, 5.08466, 5.6095>, <6.6999, 5.09631, 5.6114>, 0.001037 }
				cylinder { <6.6999, 5.09631, 5.6114>, <6.7152, 5.1099, 5.6084>, 0.001037 }
				texture {fol5}}
			mesh { // leaf
				triangle { <7.1726, 5.4098, 5.3695>, <8.2451, 6.09034, 5.2155>, <6.7152, 5.1099, 5.6084> }
				triangle { <7.1726, 5.4098, 5.3695>, <8.2115, 6.09009, 5.04474>, <8.2451, 6.09034, 5.2155> }
				triangle { <8.2115, 6.09009, 5.04474>, <9.2355, 6.2846, 4.6968>, <8.2451, 6.09034, 5.2155> }
				triangle { <8.2451, 6.09034, 5.2155>, <9.2355, 6.2846, 4.6968>, <9.2977, 6.2748, 4.8279> }
				triangle { <9.2355, 6.2846, 4.6968>, <9.5343, 6.005889, 4.5435>, <9.2977, 6.2748, 4.8279> }
				triangle { <9.5343, 6.005889, 4.5435>, <9.32, 6.2677, 4.9086>, <9.2977, 6.2748, 4.8279> }
				triangle { <9.2977, 6.2748, 4.8279>, <9.32, 6.2677, 4.9086>, <8.2451, 6.09034, 5.2155> }
				triangle { <8.2451, 6.09034, 5.2155>, <9.32, 6.2677, 4.9086>, <8.3048, 6.08952, 5.3739> }
				triangle { <8.3048, 6.08952, 5.3739>, <6.7152, 5.1099, 5.6084>, <8.2451, 6.09034, 5.2155> }
				triangle { <6.7152, 5.1099, 5.6084>, <8.3048, 6.08952, 5.3739>, <7.1891, 5.4275, 5.6701> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <6.6653, 5.07581, 5.6028>, <6.9114, 5.1555, 5.7654>, 0.05093 }
				cylinder { <6.9114, 5.1555, 5.7654>, <7.1576, 5.2353, 5.928>, 0.05093 }
				cylinder { <7.1576, 5.2353, 5.928>, <7.4038, 5.315, 6.09064>, 0.05093 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <7.4038, 5.315, 6.09064>, <7.4185, 5.3166, 6.1052>, 0.001037 }
				cylinder { <7.4185, 5.3166, 6.1052>, <7.4301, 5.3142, 6.1222>, 0.001037 }
				cylinder { <7.4301, 5.3142, 6.1222>, <7.4378, 5.3081, 6.1405>, 0.001037 }
				texture {fol5}}
			mesh { // leaf
				triangle { <7.8026, 5.1039, 6.5664>, <8.2644, 4.5366, 7.6162>, <7.4378, 5.3081, 6.1405> }
				triangle { <7.8026, 5.1039, 6.5664>, <8.4209, 4.598, 7.571>, <8.2644, 4.5366, 7.6162> }
				triangle { <8.4209, 4.598, 7.571>, <9.02628, 3.878, 8.1391>, <8.2644, 4.5366, 7.6162> }
				triangle { <8.2644, 4.5366, 7.6162>, <9.02628, 3.878, 8.1391>, <8.9145, 3.7948, 8.1812> }
				triangle { <9.02628, 3.878, 8.1391>, <9.2311, 3.5179, 8.001518>, <8.9145, 3.7948, 8.1812> }
				triangle { <9.2311, 3.5179, 8.001518>, <8.8417, 3.7569, 8.1991>, <8.9145, 3.7948, 8.1812> }
				triangle { <8.9145, 3.7948, 8.1812>, <8.8417, 3.7569, 8.1991>, <8.2644, 4.5366, 7.6162> }
				triangle { <8.2644, 4.5366, 7.6162>, <8.8417, 3.7569, 8.1991>, <8.1263, 4.4548, 7.6699> }
				triangle { <8.1263, 4.4548, 7.6699>, <7.4378, 5.3081, 6.1405>, <8.2644, 4.5366, 7.6162> }
				triangle { <7.4378, 5.3081, 6.1405>, <8.1263, 4.4548, 7.6699>, <7.5175, 5.04088, 6.6419> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <7.4038, 5.315, 6.09064>, <7.4205, 5.3204, 6.1016>, 0.001037 }
				cylinder { <7.4205, 5.3204, 6.1016>, <7.4372, 5.3258, 6.1127>, 0.001037 }
				cylinder { <7.4372, 5.3258, 6.1127>, <7.4539, 5.3313, 6.1237>, 0.001037 }
				texture {fol5}}
			mesh { // leaf
				triangle { <8.0158, 5.4461, 6.289>, <9.08916, 5.5801, 6.9725>, <7.4539, 5.3313, 6.1237> }
				triangle { <8.0158, 5.4461, 6.289>, <9.1635, 5.6439, 6.8286>, <9.08916, 5.5801, 6.9725> }
				triangle { <9.1635, 5.6439, 6.8286>, <10.2077, 5.4447, 7.1069>, <9.08916, 5.5801, 6.9725> }
				triangle { <9.08916, 5.5801, 6.9725>, <10.2077, 5.4447, 7.1069>, <10.1767, 5.3707, 7.2284> }
				triangle { <10.2077, 5.4447, 7.1069>, <10.47, 5.1177, 6.985>, <10.1767, 5.3707, 7.2284> }
				triangle { <10.47, 5.1177, 6.985>, <10.145, 5.3316, 7.2956>, <10.1767, 5.3707, 7.2284> }
				triangle { <10.1767, 5.3707, 7.2284>, <10.145, 5.3316, 7.2956>, <9.08916, 5.5801, 6.9725> }
				triangle { <9.08916, 5.5801, 6.9725>, <10.145, 5.3316, 7.2956>, <9.04209, 5.5072, 7.1178> }
				triangle { <9.04209, 5.5072, 7.1178>, <7.4539, 5.3313, 6.1237>, <9.08916, 5.5801, 6.9725> }
				triangle { <7.4539, 5.3313, 6.1237>, <9.04209, 5.5072, 7.1178>, <7.8554, 5.3678, 6.532> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <0.0, 1.2533, 0.0>, <0.0, 1.5801, 0.0>, 0.2451 }
		cylinder { <0.0, 1.5801, 0.0>, <0.0, 1.907, 0.0>, 0.2451 }
		cylinder { <0.0, 1.907, 0.0>, <0.0, 2.2338, 0.0>, 0.2451 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 2.2338, 0.0>, <0.2639, 11.1306, -1.521>, 0.4514 }
			cylinder { <0.2639, 11.1306, -1.521>, <0.7839, 19.6326, -4.5182>, 0.4514 }
			cylinder { <0.7839, 19.6326, -4.5182>, <1.5449, 27.4893, -8.9035>, 0.4514 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <1.5449, 27.4893, -8.9035>, <1.7731, 29.8463, -10.219>, 0.4514 }
				cylinder { <1.7731, 29.8463, -10.219>, <2.001454, 32.2033, -11.5346>, 0.4514 }
				cylinder { <2.001454, 32.2033, -11.5346>, <2.2297, 34.5603, -12.8502>, 0.4514 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <2.2297, 34.5603, -12.8502>, <1.9336, 35.9278, -13.6878>, 0.08153 }
				cylinder { <1.9336, 35.9278, -13.6878>, <1.2254, 37.1448, -14.5104>, 0.08153 }
				cylinder { <1.2254, 37.1448, -14.5104>, <0.1565, 38.1232, -15.2584>, 0.08153 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-3.6385, 39.9649, -18.4505>, <-9.9606, 46.6533, -25.07835>, <0.1565, 38.1232, -15.2584> }
				triangle { <-3.6385, 39.9649, -18.4505>, <-10.9498, 45.4758, -25.2049>, <-9.9606, 46.6533, -25.07835> }
				triangle { <-10.9498, 45.4758, -25.2049>, <-15.2418, 48.3089, -33.4771>, <-9.9606, 46.6533, -25.07835> }
				triangle { <-9.9606, 46.6533, -25.07835>, <-15.2418, 48.3089, -33.4771>, <-14.451, 49.3029, -33.7007> }
				triangle { <-15.2418, 48.3089, -33.4771>, <-14.6316, 47.106, -37.1035>, <-14.451, 49.3029, -33.7007> }
				triangle { <-14.6316, 47.106, -37.1035>, <-13.943, 49.8471, -33.7148>, <-14.451, 49.3029, -33.7007> }
				triangle { <-14.451, 49.3029, -33.7007>, <-13.943, 49.8471, -33.7148>, <-9.9606, 46.6533, -25.07835> }
				triangle { <-9.9606, 46.6533, -25.07835>, <-13.943, 49.8471, -33.7148>, <-9.06304, 47.8501, -25.1893> }
				triangle { <-9.06304, 47.8501, -25.1893>, <0.1565, 38.1232, -15.2584>, <-9.9606, 46.6533, -25.07835> }
				triangle { <0.1565, 38.1232, -15.2584>, <-9.06304, 47.8501, -25.1893>, <-1.9698, 41.9591, -17.8329> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <2.2297, 34.5603, -12.8502>, <2.458, 36.9173, -14.1658>, 0.4514 }
				cylinder { <2.458, 36.9173, -14.1658>, <2.6862, 39.2743, -15.4813>, 0.4514 }
				cylinder { <2.6862, 39.2743, -15.4813>, <2.9145, 41.6313, -16.7969>, 0.4514 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <2.9145, 41.6313, -16.7969>, <3.4755, 42.9988, -17.4858>, 0.08153 }
				cylinder { <3.4755, 42.9988, -17.4858>, <4.4194, 44.2158, -18.02181>, 0.08153 }
				cylinder { <4.4194, 44.2158, -18.02181>, <5.6778, 45.1942, -18.3659>, 0.08153 }
				texture {fol5}}
			mesh { // leaf
				triangle { <9.2097, 48.1739, -20.9409>, <18.7352, 53.4967, -24.03382>, <5.6778, 45.1942, -18.3659> }
				triangle { <9.2097, 48.1739, -20.9409>, <17.9224, 54.1401, -25.1767>, <18.7352, 53.4967, -24.03382> }
				triangle { <17.9224, 54.1401, -25.1767>, <25.4203, 56.2904, -31.01059>, <18.7352, 53.4967, -24.03382> }
				triangle { <18.7352, 53.4967, -24.03382>, <25.4203, 56.2904, -31.01059>, <26.3145, 55.6911, -30.3002> }
				triangle { <25.4203, 56.2904, -31.01059>, <26.7376, 54.4047, -34.1217>, <26.3145, 55.6911, -30.3002> }
				triangle { <26.7376, 54.4047, -34.1217>, <26.7344, 55.3249, -29.8061>, <26.3145, 55.6911, -30.3002> }
				triangle { <26.3145, 55.6911, -30.3002>, <26.7344, 55.3249, -29.8061>, <18.7352, 53.4967, -24.03382> }
				triangle { <18.7352, 53.4967, -24.03382>, <26.7344, 55.3249, -29.8061>, <19.7142, 52.8726, -23.08381> }
				triangle { <19.7142, 52.8726, -23.08381>, <5.6778, 45.1942, -18.3659>, <18.7352, 53.4967, -24.03382> }
				triangle { <5.6778, 45.1942, -18.3659>, <19.7142, 52.8726, -23.08381>, <10.334, 47.2092, -18.7166> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <2.9145, 41.6313, -16.7969>, <3.1428, 43.9883, -18.1125>, 0.4514 }
				cylinder { <3.1428, 43.9883, -18.1125>, <3.371, 46.3453, -19.428>, 0.4514 }
				cylinder { <3.371, 46.3453, -19.428>, <3.5993, 48.7024, -20.7436>, 0.4514 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <3.5993, 48.7024, -20.7436>, <3.3032, 50.06989, -21.5812>, 0.08153 }
				cylinder { <3.3032, 50.06989, -21.5812>, <2.5951, 51.2869, -22.4038>, 0.08153 }
				cylinder { <2.5951, 51.2869, -22.4038>, <1.5261, 52.2652, -23.1519>, 0.08153 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-2.2688, 54.1069, -26.3439>, <-8.591, 60.7953, -32.9717>, <1.5261, 52.2652, -23.1519> }
				triangle { <-2.2688, 54.1069, -26.3439>, <-9.5801, 59.6179, -33.09839>, <-8.591, 60.7953, -32.9717> }
				triangle { <-9.5801, 59.6179, -33.09839>, <-13.8721, 62.451, -41.3705>, <-8.591, 60.7953, -32.9717> }
				triangle { <-8.591, 60.7953, -32.9717>, <-13.8721, 62.451, -41.3705>, <-13.08138, 63.4449, -41.5942> }
				triangle { <-13.8721, 62.451, -41.3705>, <-13.262, 61.2481, -44.997>, <-13.08138, 63.4449, -41.5942> }
				triangle { <-13.262, 61.2481, -44.997>, <-12.5733, 63.9892, -41.6083>, <-13.08138, 63.4449, -41.5942> }
				triangle { <-13.08138, 63.4449, -41.5942>, <-12.5733, 63.9892, -41.6083>, <-8.591, 60.7953, -32.9717> }
				triangle { <-8.591, 60.7953, -32.9717>, <-12.5733, 63.9892, -41.6083>, <-7.6934, 61.9921, -33.08281> }
				triangle { <-7.6934, 61.9921, -33.08281>, <1.5261, 52.2652, -23.1519>, <-8.591, 60.7953, -32.9717> }
				triangle { <1.5261, 52.2652, -23.1519>, <-7.6934, 61.9921, -33.08281>, <-0.6002, 56.1011, -25.7263> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <3.5993, 48.7024, -20.7436>, <3.8276, 51.05941, -22.05923>, 0.4514 }
				cylinder { <3.8276, 51.05941, -22.05923>, <4.05591, 53.4164, -23.3748>, 0.4514 }
				cylinder { <4.05591, 53.4164, -23.3748>, <4.2841, 55.7734, -24.6903>, 0.4514 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <4.2841, 55.7734, -24.6903>, <4.8451, 57.1409, -25.3792>, 0.08153 }
				cylinder { <4.8451, 57.1409, -25.3792>, <5.789, 58.3579, -25.9152>, 0.08153 }
				cylinder { <5.789, 58.3579, -25.9152>, <7.04748, 59.3363, -26.2594>, 0.08153 }
				texture {fol5}}
			mesh { // leaf
				triangle { <10.5793, 62.316, -28.8344>, <20.1048, 67.6388, -31.9272>, <7.04748, 59.3363, -26.2594> }
				triangle { <10.5793, 62.316, -28.8344>, <19.292, 68.2821, -33.07018>, <20.1048, 67.6388, -31.9272> }
				triangle { <19.292, 68.2821, -33.07018>, <26.79, 70.4324, -38.904>, <20.1048, 67.6388, -31.9272> }
				triangle { <20.1048, 67.6388, -31.9272>, <26.79, 70.4324, -38.904>, <27.6842, 69.8332, -38.1936> }
				triangle { <26.79, 70.4324, -38.904>, <28.1072, 68.5467, -42.01516>, <27.6842, 69.8332, -38.1936> }
				triangle { <28.1072, 68.5467, -42.01516>, <28.104, 69.467, -37.6995>, <27.6842, 69.8332, -38.1936> }
				triangle { <27.6842, 69.8332, -38.1936>, <28.104, 69.467, -37.6995>, <20.1048, 67.6388, -31.9272> }
				triangle { <20.1048, 67.6388, -31.9272>, <28.104, 69.467, -37.6995>, <21.08388, 67.01476, -30.9772> }
				triangle { <21.08388, 67.01476, -30.9772>, <7.04748, 59.3363, -26.2594>, <20.1048, 67.6388, -31.9272> }
				triangle { <7.04748, 59.3363, -26.2594>, <21.08388, 67.01476, -30.9772>, <11.7036, 61.3513, -26.61> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <4.2841, 55.7734, -24.6903>, <4.5124, 58.1304, -26.00594>, 0.4514 }
				cylinder { <4.5124, 58.1304, -26.00594>, <4.7407, 60.4874, -27.3215>, 0.4514 }
				cylinder { <4.7407, 60.4874, -27.3215>, <4.969, 62.8444, -28.637>, 0.4514 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <4.969, 62.8444, -28.637>, <4.6729, 64.2119, -29.4747>, 0.08153 }
				cylinder { <4.6729, 64.2119, -29.4747>, <3.9647, 65.4289, -30.2973>, 0.08153 }
				cylinder { <3.9647, 65.4289, -30.2973>, <2.8958, 66.4073, -31.04532>, 0.08153 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-0.8992, 68.249, -34.2373>, <-7.2213, 74.9374, -40.8652>, <2.8958, 66.4073, -31.04532> }
				triangle { <-0.8992, 68.249, -34.2373>, <-8.2105, 73.7599, -40.9918>, <-7.2213, 74.9374, -40.8652> }
				triangle { <-8.2105, 73.7599, -40.9918>, <-12.5025, 76.593, -49.2639>, <-7.2213, 74.9374, -40.8652> }
				triangle { <-7.2213, 74.9374, -40.8652>, <-12.5025, 76.593, -49.2639>, <-11.7117, 77.587, -49.4876> }
				triangle { <-12.5025, 76.593, -49.2639>, <-11.8923, 75.3902, -52.8904>, <-11.7117, 77.587, -49.4876> }
				triangle { <-11.8923, 75.3902, -52.8904>, <-11.2037, 78.1312, -49.5017>, <-11.7117, 77.587, -49.4876> }
				triangle { <-11.7117, 77.587, -49.4876>, <-11.2037, 78.1312, -49.5017>, <-7.2213, 74.9374, -40.8652> }
				triangle { <-7.2213, 74.9374, -40.8652>, <-11.2037, 78.1312, -49.5017>, <-6.3237, 76.1342, -40.9762> }
				triangle { <-6.3237, 76.1342, -40.9762>, <2.8958, 66.4073, -31.04532>, <-7.2213, 74.9374, -40.8652> }
				triangle { <2.8958, 66.4073, -31.04532>, <-6.3237, 76.1342, -40.9762>, <0.7693, 70.2432, -33.6197> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <4.969, 62.8444, -28.637>, <5.1972, 65.2014, -29.9526>, 0.4514 }
				cylinder { <5.1972, 65.2014, -29.9526>, <5.4255, 67.5584, -31.2682>, 0.4514 }
				cylinder { <5.4255, 67.5584, -31.2682>, <5.6538, 69.9154, -32.5838>, 0.4514 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <5.6538, 69.9154, -32.5838>, <6.2148, 71.2829, -33.2727>, 0.08153 }
				cylinder { <6.2148, 71.2829, -33.2727>, <7.1586, 72.4999, -33.8086>, 0.08153 }
				cylinder { <7.1586, 72.4999, -33.8086>, <8.4171, 73.4783, -34.1528>, 0.08153 }
				texture {fol5}}
			mesh { // leaf
				triangle { <11.9489, 76.458, -36.7278>, <21.4745, 81.7808, -39.8206>, <8.4171, 73.4783, -34.1528> }
				triangle { <11.9489, 76.458, -36.7278>, <20.6617, 82.4242, -40.9636>, <21.4745, 81.7808, -39.8206> }
				triangle { <20.6617, 82.4242, -40.9636>, <28.1596, 84.5745, -46.7974>, <21.4745, 81.7808, -39.8206> }
				triangle { <21.4745, 81.7808, -39.8206>, <28.1596, 84.5745, -46.7974>, <29.05386, 83.9752, -46.08706> }
				triangle { <28.1596, 84.5745, -46.7974>, <29.4769, 82.6888, -49.9085>, <29.05386, 83.9752, -46.08706> }
				triangle { <29.4769, 82.6888, -49.9085>, <29.4736, 83.609, -45.593>, <29.05386, 83.9752, -46.08706> }
				triangle { <29.05386, 83.9752, -46.08706>, <29.4736, 83.609, -45.593>, <21.4745, 81.7808, -39.8206> }
				triangle { <21.4745, 81.7808, -39.8206>, <29.4736, 83.609, -45.593>, <22.4535, 81.1568, -38.8706> }
				triangle { <22.4535, 81.1568, -38.8706>, <8.4171, 73.4783, -34.1528>, <21.4745, 81.7808, -39.8206> }
				triangle { <8.4171, 73.4783, -34.1528>, <22.4535, 81.1568, -38.8706>, <13.07333, 75.4933, -34.5034> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <5.6538, 69.9154, -32.5838>, <5.7912, 71.3343, -33.3757>, 0.08153 }
				cylinder { <5.7912, 71.3343, -33.3757>, <5.9286, 72.7532, -34.1677>, 0.08153 }
				cylinder { <5.9286, 72.7532, -34.1677>, <6.06608, 74.1721, -34.9596>, 0.08153 }
				texture {fol5}}
			mesh { // leaf
				triangle { <5.7905, 77.9487, -38.6535>, <8.01661, 86.9789, -45.1445>, <6.06608, 74.1721, -34.9596> }
				triangle { <5.7905, 77.9487, -38.6535>, <6.6737, 86.7119, -45.8559>, <8.01661, 86.9789, -45.1445> }
				triangle { <6.6737, 86.7119, -45.8559>, <8.6597, 91.4476, -54.1327>, <8.01661, 86.9789, -45.1445> }
				triangle { <8.01661, 86.9789, -45.1445>, <8.6597, 91.4476, -54.1327>, <9.8936, 91.6938, -53.8495> }
				triangle { <8.6597, 91.4476, -54.1327>, <9.8033, 90.04974, -57.5544>, <9.8936, 91.6938, -53.8495> }
				triangle { <9.8033, 90.04974, -57.5544>, <10.5785, 91.7828, -53.5711>, <9.8936, 91.6938, -53.8495> }
				triangle { <9.8936, 91.6938, -53.8495>, <10.5785, 91.7828, -53.5711>, <8.01661, 86.9789, -45.1445> }
				triangle { <8.01661, 86.9789, -45.1445>, <10.5785, 91.7828, -53.5711>, <9.4016, 87.3141, -44.6755> }
				triangle { <9.4016, 87.3141, -44.6755>, <6.06608, 74.1721, -34.9596>, <8.01661, 86.9789, -45.1445> }
				triangle { <6.06608, 74.1721, -34.9596>, <9.4016, 87.3141, -44.6755>, <7.9004, 78.4147, -37.08069> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <0.0, 2.2338, 0.0>, <0.003763, 2.3004, -0.02169>, 0.05263 }
		cylinder { <0.003763, 2.3004, -0.02169>, <0.01091, 2.3568, -0.06288>, 0.05263 }
		cylinder { <0.01091, 2.3568, -0.06288>, <0.02072, 2.3972, -0.1194>, 0.05263 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.02072, 2.3972, -0.1194>, <0.2277, 2.9699, -1.3124>, 0.06697 }
			cylinder { <0.2277, 2.9699, -1.3124>, <0.4484, 3.3272, -2.5844>, 0.06697 }
			cylinder { <0.4484, 3.3272, -2.5844>, <0.6763, 3.4585, -3.8979>, 0.06697 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.6763, 3.4585, -3.8979>, <0.7447, 3.4979, -4.2919>, 0.06697 }
				cylinder { <0.7447, 3.4979, -4.2919>, <0.813, 3.5373, -4.6859>, 0.06697 }
				cylinder { <0.813, 3.5373, -4.6859>, <0.8814, 3.5766, -5.07999>, 0.06697 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.8814, 3.5766, -5.07999>, <0.8779, 3.58, -5.1155>, 0.001794 }
				cylinder { <0.8779, 3.58, -5.1155>, <0.8649, 3.583, -5.1488>, 0.001794 }
				cylinder { <0.8649, 3.583, -5.1488>, <0.8435, 3.5855, -5.1775>, 0.001794 }
				texture {fol5}}
			mesh { // leaf
				triangle { <0.2919, 3.44, -5.7164>, <-0.5658, 3.3504, -7.1609>, <0.8435, 3.5855, -5.1775> }
				triangle { <0.2919, 3.44, -5.7164>, <-0.7365, 3.2552, -7.04182>, <-0.5658, 3.3504, -7.1609> }
				triangle { <-0.7365, 3.2552, -7.04182>, <-1.3942, 2.5977, -8.1476>, <-0.5658, 3.3504, -7.1609> }
				triangle { <-0.5658, 3.3504, -7.1609>, <-1.3942, 2.5977, -8.1476>, <-1.2601, 2.6395, -8.2775> }
				triangle { <-1.3942, 2.5977, -8.1476>, <-1.3682, 2.049, -8.3138>, <-1.2601, 2.6395, -8.2775> }
				triangle { <-1.3682, 2.049, -8.3138>, <-1.1746, 2.6738, -8.3384>, <-1.2601, 2.6395, -8.2775> }
				triangle { <-1.2601, 2.6395, -8.2775>, <-1.1746, 2.6738, -8.3384>, <-0.5658, 3.3504, -7.1609> }
				triangle { <-0.5658, 3.3504, -7.1609>, <-1.1746, 2.6738, -8.3384>, <-0.4107, 3.4208, -7.3041> }
				triangle { <-0.4107, 3.4208, -7.3041>, <0.8435, 3.5855, -5.1775>, <-0.5658, 3.3504, -7.1609> }
				triangle { <0.8435, 3.5855, -5.1775>, <-0.4107, 3.4208, -7.3041>, <0.5842, 3.6496, -5.8831> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <0.8814, 3.5766, -5.07999>, <0.9498, 3.616, -5.474>, 0.06697 }
				cylinder { <0.9498, 3.616, -5.474>, <1.0182, 3.6554, -5.868>, 0.06697 }
				cylinder { <1.0182, 3.6554, -5.868>, <1.08657, 3.6948, -6.262>, 0.06697 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.08657, 3.6948, -6.262>, <1.1018, 3.6982, -6.2943>, 0.001794 }
				cylinder { <1.1018, 3.6982, -6.2943>, <1.1253, 3.7012, -6.3213>, 0.001794 }
				cylinder { <1.1253, 3.7012, -6.3213>, <1.1551, 3.7036, -6.3412>, 0.001794 }
				texture {fol5}}
			mesh { // leaf
				triangle { <1.707, 3.5772, -6.8845>, <3.1801, 3.4648, -7.6894>, <1.1551, 3.7036, -6.3412> }
				triangle { <1.707, 3.5772, -6.8845>, <3.0623, 3.4, -7.8747>, <3.1801, 3.4648, -7.6894> }
				triangle { <3.0623, 3.4, -7.8747>, <4.1435, 2.7311, -8.5612>, <3.1801, 3.4648, -7.6894> }
				triangle { <3.1801, 3.4648, -7.6894>, <4.1435, 2.7311, -8.5612>, <4.2696, 2.7462, -8.4181> }
				triangle { <4.1435, 2.7311, -8.5612>, <4.2644, 2.1709, -8.5933>, <4.2696, 2.7462, -8.4181> }
				triangle { <4.2644, 2.1709, -8.5933>, <4.3287, 2.7653, -8.3268>, <4.2696, 2.7462, -8.4181> }
				triangle { <4.2696, 2.7462, -8.4181>, <4.3287, 2.7653, -8.3268>, <3.1801, 3.4648, -7.6894> }
				triangle { <3.1801, 3.4648, -7.6894>, <4.3287, 2.7653, -8.3268>, <3.3207, 3.5047, -7.5216> }
				triangle { <3.3207, 3.5047, -7.5216>, <1.1551, 3.7036, -6.3412>, <3.1801, 3.4648, -7.6894> }
				triangle { <1.1551, 3.7036, -6.3412>, <3.3207, 3.5047, -7.5216>, <1.8753, 3.7373, -6.5632> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <1.08657, 3.6948, -6.262>, <1.1549, 3.7342, -6.6561>, 0.06697 }
				cylinder { <1.1549, 3.7342, -6.6561>, <1.2233, 3.7736, -7.05013>, 0.06697 }
				cylinder { <1.2233, 3.7736, -7.05013>, <1.2916, 3.813, -7.4441>, 0.06697 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.2916, 3.813, -7.4441>, <1.2881, 3.8164, -7.4797>, 0.001794 }
				cylinder { <1.2881, 3.8164, -7.4797>, <1.2752, 3.8194, -7.513>, 0.001794 }
				cylinder { <1.2752, 3.8194, -7.513>, <1.2538, 3.8218, -7.5417>, 0.001794 }
				texture {fol5}}
			mesh { // leaf
				triangle { <0.7021, 3.6764, -8.08058>, <-0.1556, 3.5867, -9.5251>, <1.2538, 3.8218, -7.5417> }
				triangle { <0.7021, 3.6764, -8.08058>, <-0.3262, 3.4915, -9.4059>, <-0.1556, 3.5867, -9.5251> }
				triangle { <-0.3262, 3.4915, -9.4059>, <-0.984, 2.834, -10.5118>, <-0.1556, 3.5867, -9.5251> }
				triangle { <-0.1556, 3.5867, -9.5251>, <-0.984, 2.834, -10.5118>, <-0.8499, 2.8758, -10.6417> }
				triangle { <-0.984, 2.834, -10.5118>, <-0.958, 2.2853, -10.678>, <-0.8499, 2.8758, -10.6417> }
				triangle { <-0.958, 2.2853, -10.678>, <-0.7643, 2.9101, -10.7026>, <-0.8499, 2.8758, -10.6417> }
				triangle { <-0.8499, 2.8758, -10.6417>, <-0.7643, 2.9101, -10.7026>, <-0.1556, 3.5867, -9.5251> }
				triangle { <-0.1556, 3.5867, -9.5251>, <-0.7643, 2.9101, -10.7026>, <-0.0004841, 3.6571, -9.6683> }
				triangle { <-0.0004841, 3.6571, -9.6683>, <1.2538, 3.8218, -7.5417>, <-0.1556, 3.5867, -9.5251> }
				triangle { <1.2538, 3.8218, -7.5417>, <-0.0004841, 3.6571, -9.6683>, <0.9945, 3.8859, -8.2473> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <1.2916, 3.813, -7.4441>, <1.36, 3.8524, -7.8381>, 0.06697 }
				cylinder { <1.36, 3.8524, -7.8381>, <1.4284, 3.8917, -8.2322>, 0.06697 }
				cylinder { <1.4284, 3.8917, -8.2322>, <1.4967, 3.9311, -8.6262>, 0.06697 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.4967, 3.9311, -8.6262>, <1.5121, 3.9345, -8.6585>, 0.001794 }
				cylinder { <1.5121, 3.9345, -8.6585>, <1.5355, 3.9375, -8.6855>, 0.001794 }
				cylinder { <1.5355, 3.9375, -8.6855>, <1.5653, 3.94, -8.7053>, 0.001794 }
				texture {fol5}}
			mesh { // leaf
				triangle { <2.1172, 3.8135, -9.2486>, <3.5903, 3.7011, -10.05366>, <1.5653, 3.94, -8.7053> }
				triangle { <2.1172, 3.8135, -9.2486>, <3.4725, 3.6363, -10.2388>, <3.5903, 3.7011, -10.05366> }
				triangle { <3.4725, 3.6363, -10.2388>, <4.5537, 2.9674, -10.9254>, <3.5903, 3.7011, -10.05366> }
				triangle { <3.5903, 3.7011, -10.05366>, <4.5537, 2.9674, -10.9254>, <4.6798, 2.9826, -10.7823> }
				triangle { <4.5537, 2.9674, -10.9254>, <4.6746, 2.4073, -10.9575>, <4.6798, 2.9826, -10.7823> }
				triangle { <4.6746, 2.4073, -10.9575>, <4.739, 3.001675, -10.691>, <4.6798, 2.9826, -10.7823> }
				triangle { <4.6798, 2.9826, -10.7823>, <4.739, 3.001675, -10.691>, <3.5903, 3.7011, -10.05366> }
				triangle { <3.5903, 3.7011, -10.05366>, <4.739, 3.001675, -10.691>, <3.7309, 3.741, -9.8858> }
				triangle { <3.7309, 3.741, -9.8858>, <1.5653, 3.94, -8.7053>, <3.5903, 3.7011, -10.05366> }
				triangle { <1.5653, 3.94, -8.7053>, <3.7309, 3.741, -9.8858>, <2.2855, 3.9736, -8.9274> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <1.4967, 3.9311, -8.6262>, <1.5651, 3.9705, -9.02028>, 0.06697 }
				cylinder { <1.5651, 3.9705, -9.02028>, <1.6335, 4.009962, -9.4143>, 0.06697 }
				cylinder { <1.6335, 4.009962, -9.4143>, <1.7019, 4.04935, -9.8083>, 0.06697 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.7019, 4.04935, -9.8083>, <1.6983, 4.05274, -9.8438>, 0.001794 }
				cylinder { <1.6983, 4.05274, -9.8438>, <1.6854, 4.05575, -9.8772>, 0.001794 }
				cylinder { <1.6854, 4.05575, -9.8772>, <1.664, 4.05818, -9.9059>, 0.001794 }
				texture {fol5}}
			mesh { // leaf
				triangle { <1.1123, 3.9127, -10.4447>, <0.2545, 3.8231, -11.8893>, <1.664, 4.05818, -9.9059> }
				triangle { <1.1123, 3.9127, -10.4447>, <0.08392, 3.7279, -11.7701>, <0.2545, 3.8231, -11.8893> }
				triangle { <0.08392, 3.7279, -11.7701>, <-0.5738, 3.07041, -12.876>, <0.2545, 3.8231, -11.8893> }
				triangle { <0.2545, 3.8231, -11.8893>, <-0.5738, 3.07041, -12.876>, <-0.4397, 3.1121, -13.00593> }
				triangle { <-0.5738, 3.07041, -12.876>, <-0.5477, 2.5216, -13.04224>, <-0.4397, 3.1121, -13.00593> }
				triangle { <-0.5477, 2.5216, -13.04224>, <-0.3541, 3.1464, -13.06681>, <-0.4397, 3.1121, -13.00593> }
				triangle { <-0.4397, 3.1121, -13.00593>, <-0.3541, 3.1464, -13.06681>, <0.2545, 3.8231, -11.8893> }
				triangle { <0.2545, 3.8231, -11.8893>, <-0.3541, 3.1464, -13.06681>, <0.4097, 3.8934, -12.03254> }
				triangle { <0.4097, 3.8934, -12.03254>, <1.664, 4.05818, -9.9059>, <0.2545, 3.8231, -11.8893> }
				triangle { <1.664, 4.05818, -9.9059>, <0.4097, 3.8934, -12.03254>, <1.4047, 4.1222, -10.6114> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <1.7019, 4.04935, -9.8083>, <1.7702, 4.08873, -10.2023>, 0.06697 }
				cylinder { <1.7702, 4.08873, -10.2023>, <1.8386, 4.1281, -10.5964>, 0.06697 }
				cylinder { <1.8386, 4.1281, -10.5964>, <1.907, 4.1675, -10.9904>, 0.06697 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.907, 4.1675, -10.9904>, <1.9223, 4.1709, -11.02271>, 0.001794 }
				cylinder { <1.9223, 4.1709, -11.02271>, <1.9457, 4.1739, -11.04974>, 0.001794 }
				cylinder { <1.9457, 4.1739, -11.04974>, <1.9755, 4.1763, -11.06956>, 0.001794 }
				texture {fol5}}
			mesh { // leaf
				triangle { <2.5274, 4.04992, -11.6128>, <4.0006, 3.9374, -12.4178>, <1.9755, 4.1763, -11.06956> }
				triangle { <2.5274, 4.04992, -11.6128>, <3.8827, 3.8727, -12.603>, <4.0006, 3.9374, -12.4178> }
				triangle { <3.8827, 3.8727, -12.603>, <4.9639, 3.2037, -13.2895>, <4.0006, 3.9374, -12.4178> }
				triangle { <4.0006, 3.9374, -12.4178>, <4.9639, 3.2037, -13.2895>, <5.09008, 3.2189, -13.1465> }
				triangle { <4.9639, 3.2037, -13.2895>, <5.08488, 2.6436, -13.3217>, <5.09008, 3.2189, -13.1465> }
				triangle { <5.08488, 2.6436, -13.3217>, <5.1492, 3.238, -13.05519>, <5.09008, 3.2189, -13.1465> }
				triangle { <5.09008, 3.2189, -13.1465>, <5.1492, 3.238, -13.05519>, <4.0006, 3.9374, -12.4178> }
				triangle { <4.0006, 3.9374, -12.4178>, <5.1492, 3.238, -13.05519>, <4.1411, 3.9774, -12.25> }
				triangle { <4.1411, 3.9774, -12.25>, <1.9755, 4.1763, -11.06956>, <4.0006, 3.9374, -12.4178> }
				triangle { <1.9755, 4.1763, -11.06956>, <4.1411, 3.9774, -12.25>, <2.6957, 4.21, -11.2915> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.907, 4.1675, -10.9904>, <1.9131, 4.171, -11.02562>, 0.001794 }
				cylinder { <1.9131, 4.171, -11.02562>, <1.9192, 4.1745, -11.06081>, 0.001794 }
				cylinder { <1.9192, 4.1745, -11.06081>, <1.9253, 4.178, -11.096>, 0.001794 }
				texture {fol5}}
			mesh { // leaf
				triangle { <1.9241, 4.06496, -11.8725>, <2.3686, 4.01448, -13.4944>, <1.9253, 4.178, -11.096> }
				triangle { <1.9241, 4.06496, -11.8725>, <2.1588, 3.9344, -13.5388>, <2.3686, 4.01448, -13.4944> }
				triangle { <2.1588, 3.9344, -13.5388>, <2.4602, 3.3087, -14.8058>, <2.3686, 4.01448, -13.4944> }
				triangle { <2.3686, 4.01448, -13.4944>, <2.4602, 3.3087, -14.8058>, <2.6491, 3.338, -14.7974> }
				triangle { <2.4602, 3.3087, -14.8058>, <2.5625, 2.7567, -14.9252>, <2.6491, 3.338, -14.7974> }
				triangle { <2.5625, 2.7567, -14.9252>, <2.7543, 3.3647, -14.7765>, <2.6491, 3.338, -14.7974> }
				triangle { <2.6491, 3.338, -14.7974>, <2.7543, 3.3647, -14.7765>, <2.3686, 4.01448, -13.4944> }
				triangle { <2.3686, 4.01448, -13.4944>, <2.7543, 3.3647, -14.7765>, <2.5835, 4.07042, -13.4788> }
				triangle { <2.5835, 4.07042, -13.4788>, <1.9253, 4.178, -11.096>, <2.3686, 4.01448, -13.4944> }
				triangle { <1.9253, 4.178, -11.096>, <2.5835, 4.07042, -13.4788>, <2.2595, 4.2489, -11.7686> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <0.02072, 2.3972, -0.1194>, <0.0247, 2.4136, -0.1423>, 0.02135 }
		cylinder { <0.0247, 2.4136, -0.1423>, <0.02867, 2.43, -0.1652>, 0.02135 }
		cylinder { <0.02867, 2.43, -0.1652>, <0.03265, 2.4464, -0.1882>, 0.02135 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.03265, 2.4464, -0.1882>, <0.03991, 2.8479, -0.6319>, 0.02992 }
			cylinder { <0.03991, 2.8479, -0.6319>, <-0.02943, 3.2946, -1.02434>, 0.02992 }
			cylinder { <-0.02943, 3.2946, -1.02434>, <-0.1733, 3.7732, -1.3537>, 0.02992 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.1733, 3.7732, -1.3537>, <-0.2165, 3.9167, -1.4525>, 0.02992 }
				cylinder { <-0.2165, 3.9167, -1.4525>, <-0.2597, 4.06034, -1.5513>, 0.02992 }
				cylinder { <-0.2597, 4.06034, -1.5513>, <-0.3029, 4.2039, -1.6501>, 0.02992 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-0.3029, 4.2039, -1.6501>, <-0.3032, 4.2104, -1.6529>, 0.0003582 }
				cylinder { <-0.3032, 4.2104, -1.6529>, <-0.3023, 4.2174, -1.6544>, 0.0003582 }
				cylinder { <-0.3023, 4.2174, -1.6544>, <-0.3, 4.2242, -1.6545>, 0.0003582 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-0.2159, 4.5506, -1.5581>, <-0.09537, 5.2927, -1.5571>, <-0.3, 4.2242, -1.6545> }
				triangle { <-0.2159, 4.5506, -1.5581>, <-0.06027, 5.2822, -1.4616>, <-0.09537, 5.2927, -1.5571> }
				triangle { <-0.06027, 5.2822, -1.4616>, <-0.1468, 5.8935, -1.2728>, <-0.09537, 5.2927, -1.5571> }
				triangle { <-0.09537, 5.2927, -1.5571>, <-0.1468, 5.8935, -1.2728>, <-0.1875, 5.9188, -1.3436> }
				triangle { <-0.1468, 5.8935, -1.2728>, <-0.3362, 5.9959, -1.1335>, <-0.1875, 5.9188, -1.3436> }
				triangle { <-0.3362, 5.9959, -1.1335>, <-0.2093, 5.9255, -1.3874>, <-0.1875, 5.9188, -1.3436> }
				triangle { <-0.1875, 5.9188, -1.3436>, <-0.2093, 5.9255, -1.3874>, <-0.09537, 5.2927, -1.5571> }
				triangle { <-0.09537, 5.2927, -1.5571>, <-0.2093, 5.9255, -1.3874>, <-0.1351, 5.3174, -1.6448> }
				triangle { <-0.1351, 5.3174, -1.6448>, <-0.3, 4.2242, -1.6545>, <-0.09537, 5.2927, -1.5571> }
				triangle { <-0.3, 4.2242, -1.6545>, <-0.1351, 5.3174, -1.6448>, <-0.2587, 4.5501, -1.73> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-0.3029, 4.2039, -1.6501>, <-0.346, 4.3474, -1.7489>, 0.02992 }
				cylinder { <-0.346, 4.3474, -1.7489>, <-0.3892, 4.491, -1.8477>, 0.02992 }
				cylinder { <-0.3892, 4.491, -1.8477>, <-0.4324, 4.6346, -1.9465>, 0.02992 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-0.4324, 4.6346, -1.9465>, <-0.4353, 4.6391, -1.9513>, 0.0003582 }
				cylinder { <-0.4353, 4.6391, -1.9513>, <-0.4392, 4.642, -1.9565>, 0.0003582 }
				cylinder { <-0.4392, 4.642, -1.9565>, <-0.4439, 4.6431, -1.9619>, 0.0003582 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-0.703, 4.7723, -2.1597>, <-1.2711, 4.8409, -2.6472>, <-0.4439, 4.6431, -1.9619> }
				triangle { <-0.703, 4.7723, -2.1597>, <-1.2694, 4.9413, -2.628>, <-1.2711, 4.8409, -2.6472> }
				triangle { <-1.2694, 4.9413, -2.628>, <-1.873, 5.07315, -2.8155>, <-1.2711, 4.8409, -2.6472> }
				triangle { <-1.2711, 4.8409, -2.6472>, <-1.873, 5.07315, -2.8155>, <-1.896, 4.9918, -2.8283> }
				triangle { <-1.873, 5.07315, -2.8155>, <-2.08441, 5.1054, -2.6739>, <-1.896, 4.9918, -2.8283> }
				triangle { <-2.08441, 5.1054, -2.6739>, <-1.9011, 4.943, -2.8339>, <-1.896, 4.9918, -2.8283> }
				triangle { <-1.896, 4.9918, -2.8283>, <-1.9011, 4.943, -2.8339>, <-1.2711, 4.8409, -2.6472> }
				triangle { <-1.2711, 4.8409, -2.6472>, <-1.9011, 4.943, -2.8339>, <-1.289, 4.7452, -2.6674> }
				triangle { <-1.289, 4.7452, -2.6674>, <-0.4439, 4.6431, -1.9619>, <-1.2711, 4.8409, -2.6472> }
				triangle { <-0.4439, 4.6431, -1.9619>, <-1.289, 4.7452, -2.6674>, <-0.68, 4.601, -2.1987> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-0.4324, 4.6346, -1.9465>, <-0.4756, 4.7782, -2.04537>, 0.02992 }
				cylinder { <-0.4756, 4.7782, -2.04537>, <-0.5187, 4.9217, -2.1441>, 0.02992 }
				cylinder { <-0.5187, 4.9217, -2.1441>, <-0.5619, 5.06536, -2.2429>, 0.02992 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-0.5619, 5.06536, -2.2429>, <-0.5623, 5.07193, -2.2458>, 0.0003582 }
				cylinder { <-0.5623, 5.07193, -2.2458>, <-0.5613, 5.07887, -2.2473>, 0.0003582 }
				cylinder { <-0.5613, 5.07887, -2.2473>, <-0.5591, 5.08567, -2.2474>, 0.0003582 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-0.475, 5.4121, -2.151>, <-0.3544, 6.1541, -2.15>, <-0.5591, 5.08567, -2.2474> }
				triangle { <-0.475, 5.4121, -2.151>, <-0.3193, 6.1436, -2.05452>, <-0.3544, 6.1541, -2.15> }
				triangle { <-0.3193, 6.1436, -2.05452>, <-0.4059, 6.755, -1.8656>, <-0.3544, 6.1541, -2.15> }
				triangle { <-0.3544, 6.1541, -2.15>, <-0.4059, 6.755, -1.8656>, <-0.4466, 6.7802, -1.9365> }
				triangle { <-0.4059, 6.755, -1.8656>, <-0.5952, 6.8574, -1.7263>, <-0.4466, 6.7802, -1.9365> }
				triangle { <-0.5952, 6.8574, -1.7263>, <-0.4683, 6.7869, -1.9802>, <-0.4466, 6.7802, -1.9365> }
				triangle { <-0.4466, 6.7802, -1.9365>, <-0.4683, 6.7869, -1.9802>, <-0.3544, 6.1541, -2.15> }
				triangle { <-0.3544, 6.1541, -2.15>, <-0.4683, 6.7869, -1.9802>, <-0.3942, 6.1789, -2.2377> }
				triangle { <-0.3942, 6.1789, -2.2377>, <-0.5591, 5.08567, -2.2474>, <-0.3544, 6.1541, -2.15> }
				triangle { <-0.5591, 5.08567, -2.2474>, <-0.3942, 6.1789, -2.2377>, <-0.5178, 5.4115, -2.3229> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-0.5619, 5.06536, -2.2429>, <-0.6051, 5.2089, -2.3417>, 0.02992 }
				cylinder { <-0.6051, 5.2089, -2.3417>, <-0.6483, 5.3525, -2.4406>, 0.02992 }
				cylinder { <-0.6483, 5.3525, -2.4406>, <-0.6915, 5.496, -2.5394>, 0.02992 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-0.6915, 5.496, -2.5394>, <-0.6944, 5.5005, -2.5441>, 0.0003582 }
				cylinder { <-0.6944, 5.5005, -2.5441>, <-0.6983, 5.5034, -2.5494>, 0.0003582 }
				cylinder { <-0.6983, 5.5034, -2.5494>, <-0.7029, 5.5045, -2.5547>, 0.0003582 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-0.962, 5.6337, -2.7525>, <-1.5302, 5.7023, -3.24>, <-0.7029, 5.5045, -2.5547> }
				triangle { <-0.962, 5.6337, -2.7525>, <-1.5284, 5.8028, -3.2209>, <-1.5302, 5.7023, -3.24> }
				triangle { <-1.5284, 5.8028, -3.2209>, <-2.132, 5.9345, -3.4083>, <-1.5302, 5.7023, -3.24> }
				triangle { <-1.5302, 5.7023, -3.24>, <-2.132, 5.9345, -3.4083>, <-2.1551, 5.8532, -3.4212> }
				triangle { <-2.132, 5.9345, -3.4083>, <-2.3434, 5.9668, -3.2668>, <-2.1551, 5.8532, -3.4212> }
				triangle { <-2.3434, 5.9668, -3.2668>, <-2.1602, 5.8045, -3.4268>, <-2.1551, 5.8532, -3.4212> }
				triangle { <-2.1551, 5.8532, -3.4212>, <-2.1602, 5.8045, -3.4268>, <-1.5302, 5.7023, -3.24> }
				triangle { <-1.5302, 5.7023, -3.24>, <-2.1602, 5.8045, -3.4268>, <-1.5481, 5.6066, -3.2602> }
				triangle { <-1.5481, 5.6066, -3.2602>, <-0.7029, 5.5045, -2.5547>, <-1.5302, 5.7023, -3.24> }
				triangle { <-0.7029, 5.5045, -2.5547>, <-1.5481, 5.6066, -3.2602>, <-0.9391, 5.4625, -2.7916> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-0.6915, 5.496, -2.5394>, <-0.7346, 5.6396, -2.6382>, 0.02992 }
				cylinder { <-0.7346, 5.6396, -2.6382>, <-0.7778, 5.7832, -2.737>, 0.02992 }
				cylinder { <-0.7778, 5.7832, -2.737>, <-0.821, 5.9268, -2.8358>, 0.02992 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-0.821, 5.9268, -2.8358>, <-0.8214, 5.9333, -2.8386>, 0.0003582 }
				cylinder { <-0.8214, 5.9333, -2.8386>, <-0.8204, 5.9403, -2.8401>, 0.0003582 }
				cylinder { <-0.8204, 5.9403, -2.8401>, <-0.8182, 5.9471, -2.8402>, 0.0003582 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-0.7341, 6.2735, -2.7438>, <-0.6135, 7.0156, -2.7428>, <-0.8182, 5.9471, -2.8402> }
				triangle { <-0.7341, 6.2735, -2.7438>, <-0.5784, 7.005142, -2.6473>, <-0.6135, 7.0156, -2.7428> }
				triangle { <-0.5784, 7.005142, -2.6473>, <-0.6649, 7.6164, -2.4585>, <-0.6135, 7.0156, -2.7428> }
				triangle { <-0.6135, 7.0156, -2.7428>, <-0.6649, 7.6164, -2.4585>, <-0.7056, 7.6416, -2.5293> }
				triangle { <-0.6649, 7.6164, -2.4585>, <-0.8543, 7.7188, -2.3192>, <-0.7056, 7.6416, -2.5293> }
				triangle { <-0.8543, 7.7188, -2.3192>, <-0.7274, 7.6483, -2.5731>, <-0.7056, 7.6416, -2.5293> }
				triangle { <-0.7056, 7.6416, -2.5293>, <-0.7274, 7.6483, -2.5731>, <-0.6135, 7.0156, -2.7428> }
				triangle { <-0.6135, 7.0156, -2.7428>, <-0.7274, 7.6483, -2.5731>, <-0.6533, 7.04034, -2.8305> }
				triangle { <-0.6533, 7.04034, -2.8305>, <-0.8182, 5.9471, -2.8402>, <-0.6135, 7.0156, -2.7428> }
				triangle { <-0.8182, 5.9471, -2.8402>, <-0.6533, 7.04034, -2.8305>, <-0.7769, 6.273, -2.9157> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-0.821, 5.9268, -2.8358>, <-0.8642, 6.07038, -2.9346>, 0.02992 }
				cylinder { <-0.8642, 6.07038, -2.9346>, <-0.9074, 6.2139, -3.03346>, 0.02992 }
				cylinder { <-0.9074, 6.2139, -3.03346>, <-0.9505, 6.3575, -3.1322>, 0.02992 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-0.9505, 6.3575, -3.1322>, <-0.9535, 6.362, -3.137>, 0.0003582 }
				cylinder { <-0.9535, 6.362, -3.137>, <-0.9574, 6.3648, -3.1422>, 0.0003582 }
				cylinder { <-0.9574, 6.3648, -3.1422>, <-0.962, 6.3659, -3.1476>, 0.0003582 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-1.2211, 6.4952, -3.3454>, <-1.7892, 6.5638, -3.8329>, <-0.962, 6.3659, -3.1476> }
				triangle { <-1.2211, 6.4952, -3.3454>, <-1.7875, 6.6642, -3.8137>, <-1.7892, 6.5638, -3.8329> }
				triangle { <-1.7875, 6.6642, -3.8137>, <-2.3911, 6.796, -4.001253>, <-1.7892, 6.5638, -3.8329> }
				triangle { <-1.7892, 6.5638, -3.8329>, <-2.3911, 6.796, -4.001253>, <-2.4141, 6.7147, -4.01407> }
				triangle { <-2.3911, 6.796, -4.001253>, <-2.6025, 6.8283, -3.8596>, <-2.4141, 6.7147, -4.01407> }
				triangle { <-2.6025, 6.8283, -3.8596>, <-2.4192, 6.6659, -4.01968>, <-2.4141, 6.7147, -4.01407> }
				triangle { <-2.4141, 6.7147, -4.01407>, <-2.4192, 6.6659, -4.01968>, <-1.7892, 6.5638, -3.8329> }
				triangle { <-1.7892, 6.5638, -3.8329>, <-2.4192, 6.6659, -4.01968>, <-1.8072, 6.4681, -3.8531> }
				triangle { <-1.8072, 6.4681, -3.8531>, <-0.962, 6.3659, -3.1476>, <-1.7892, 6.5638, -3.8329> }
				triangle { <-0.962, 6.3659, -3.1476>, <-1.8072, 6.4681, -3.8531>, <-1.1982, 6.3239, -3.3844> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-0.9505, 6.3575, -3.1322>, <-0.9523, 6.3632, -3.1362>, 0.0003582 }
				cylinder { <-0.9523, 6.3632, -3.1362>, <-0.954, 6.3689, -3.1401>, 0.0003582 }
				cylinder { <-0.954, 6.3689, -3.1401>, <-0.9557, 6.3747, -3.144>, 0.0003582 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-1.05594, 6.6959, -3.2426>, <-1.3499, 7.2732, -3.6239>, <-0.9557, 6.3747, -3.144> }
				triangle { <-1.05594, 6.6959, -3.2426>, <-1.3117, 7.3345, -3.5515>, <-1.3499, 7.2732, -3.6239> }
				triangle { <-1.3117, 7.3345, -3.5515>, <-1.7053, 7.8367, -3.6506>, <-1.3499, 7.2732, -3.6239> }
				triangle { <-1.3499, 7.2732, -3.6239>, <-1.7053, 7.8367, -3.6506>, <-1.7553, 7.7973, -3.7076> }
				triangle { <-1.7053, 7.8367, -3.6506>, <-1.9158, 7.9068, -3.5219>, <-1.7553, 7.7973, -3.7076> }
				triangle { <-1.9158, 7.9068, -3.5219>, <-1.7786, 7.7681, -3.7399>, <-1.7553, 7.7973, -3.7076> }
				triangle { <-1.7553, 7.7973, -3.7076>, <-1.7786, 7.7681, -3.7399>, <-1.3499, 7.2732, -3.6239> }
				triangle { <-1.3499, 7.2732, -3.6239>, <-1.7786, 7.7681, -3.7399>, <-1.3994, 7.2244, -3.695> }
				triangle { <-1.3994, 7.2244, -3.695>, <-0.9557, 6.3747, -3.144>, <-1.3499, 7.2732, -3.6239> }
				triangle { <-0.9557, 6.3747, -3.144>, <-1.3994, 7.2244, -3.695>, <-1.09705, 6.5805, -3.3705> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <0.0, 2.2338, 0.0>, <0.0, 2.5671, 0.0>, 0.25 }
		cylinder { <0.0, 2.5671, 0.0>, <0.0, 2.9004, 0.0>, 0.25 }
		cylinder { <0.0, 2.9004, 0.0>, <0.0, 3.2338, 0.0>, 0.25 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 3.2338, 0.0>, <-1.3403, 13.0321, 1.04599>, 0.4972 }
			cylinder { <-1.3403, 13.0321, 1.04599>, <-3.9814, 22.3954, 3.1071>, 0.4972 }
			cylinder { <-3.9814, 22.3954, 3.1071>, <-7.8457, 31.04819, 6.1228>, 0.4972 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-7.8457, 31.04819, 6.1228>, <-9.005008, 33.644, 7.02757>, 0.4972 }
				cylinder { <-9.005008, 33.644, 7.02757>, <-10.1642, 36.2398, 7.9322>, 0.4972 }
				cylinder { <-10.1642, 36.2398, 7.9322>, <-11.3235, 38.8356, 8.8369>, 0.4972 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-11.3235, 38.8356, 8.8369>, <-11.7397, 40.4942, 9.8309>, 0.09889 }
				cylinder { <-11.7397, 40.4942, 9.8309>, <-11.7733, 41.9704, 11.147>, 0.09889 }
				cylinder { <-11.7733, 41.9704, 11.147>, <-11.4219, 43.157, 12.6899>, 0.09889 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-10.6859, 45.1853, 18.1015>, <-10.4288, 52.5514, 28.1859>, <-11.4219, 43.157, 12.6899> }
				triangle { <-10.6859, 45.1853, 18.1015>, <-9.7153, 51.2546, 29.02082>, <-10.4288, 52.5514, 28.1859> }
				triangle { <-9.7153, 51.2546, 29.02082>, <-12.3311, 54.3748, 38.9454>, <-10.4288, 52.5514, 28.1859> }
				triangle { <-10.4288, 52.5514, 28.1859>, <-12.3311, 54.3748, 38.9454>, <-13.1418, 55.4695, 38.5431> }
				triangle { <-12.3311, 54.3748, 38.9454>, <-15.5111, 53.05009, 41.4534>, <-13.1418, 55.4695, 38.5431> }
				triangle { <-15.5111, 53.05009, 41.4534>, <-13.5667, 56.06889, 38.1788>, <-13.1418, 55.4695, 38.5431> }
				triangle { <-13.1418, 55.4695, 38.5431>, <-13.5667, 56.06889, 38.1788>, <-10.4288, 52.5514, 28.1859> }
				triangle { <-10.4288, 52.5514, 28.1859>, <-13.5667, 56.06889, 38.1788>, <-11.2434, 53.8695, 27.6126> }
				triangle { <-11.2434, 53.8695, 27.6126>, <-11.4219, 43.157, 12.6899>, <-10.4288, 52.5514, 28.1859> }
				triangle { <-11.4219, 43.157, 12.6899>, <-11.2434, 53.8695, 27.6126>, <-11.5908, 47.3816, 16.3634> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-11.3235, 38.8356, 8.8369>, <-12.4828, 41.4314, 9.7416>, 0.4972 }
				cylinder { <-12.4828, 41.4314, 9.7416>, <-13.6421, 44.02729, 10.6464>, 0.4972 }
				cylinder { <-13.6421, 44.02729, 10.6464>, <-14.8013, 46.6231, 11.5511>, 0.4972 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-14.8013, 46.6231, 11.5511>, <-15.8666, 48.2817, 11.7133>, 0.09889 }
				cylinder { <-15.8666, 48.2817, 11.7133>, <-17.1515, 49.7578, 11.4261>, 0.09889 }
				cylinder { <-17.1515, 49.7578, 11.4261>, <-18.5628, 50.9445, 10.7104>, 0.09889 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-23.3493, 54.2261, 10.1994>, <-33.4098, 60.08825, 5.6782>, <-18.5628, 50.9445, 10.7104> }
				triangle { <-23.3493, 54.2261, 10.1994>, <-33.5919, 60.7968, 7.212>, <-33.4098, 60.08825, 5.6782> }
				triangle { <-33.5919, 60.7968, 7.212>, <-44.02515, 63.1649, 6.4271>, <-33.4098, 60.08825, 5.6782> }
				triangle { <-33.4098, 60.08825, 5.6782>, <-44.02515, 63.1649, 6.4271>, <-44.2294, 62.5049, 5.186> }
				triangle { <-44.02515, 63.1649, 6.4271>, <-47.401, 61.08822, 7.9916>, <-44.2294, 62.5049, 5.186> }
				triangle { <-47.401, 61.08822, 7.9916>, <-44.2066, 62.1016, 4.4723>, <-44.2294, 62.5049, 5.186> }
				triangle { <-44.2294, 62.5049, 5.186>, <-44.2066, 62.1016, 4.4723>, <-33.4098, 60.08825, 5.6782> }
				triangle { <-33.4098, 60.08825, 5.6782>, <-44.2066, 62.1016, 4.4723>, <-33.5061, 59.4009, 4.1789> }
				triangle { <-33.5061, 59.4009, 4.1789>, <-18.5628, 50.9445, 10.7104>, <-33.4098, 60.08825, 5.6782> }
				triangle { <-18.5628, 50.9445, 10.7104>, <-33.5061, 59.4009, 4.1789>, <-22.6217, 53.1637, 7.5527> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-14.8013, 46.6231, 11.5511>, <-15.9606, 49.2189, 12.4558>, 0.4972 }
				cylinder { <-15.9606, 49.2189, 12.4558>, <-17.1199, 51.8147, 13.3605>, 0.4972 }
				cylinder { <-17.1199, 51.8147, 13.3605>, <-18.2792, 54.4105, 14.2652>, 0.4972 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-18.2792, 54.4105, 14.2652>, <-18.6953, 56.06921, 15.2591>, 0.09889 }
				cylinder { <-18.6953, 56.06921, 15.2591>, <-18.729, 57.5453, 16.5752>, 0.09889 }
				cylinder { <-18.729, 57.5453, 16.5752>, <-18.3776, 58.732, 18.1182>, 0.09889 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-17.6415, 60.7603, 23.5298>, <-17.3845, 68.1263, 33.6141>, <-18.3776, 58.732, 18.1182> }
				triangle { <-17.6415, 60.7603, 23.5298>, <-16.671, 66.8296, 34.449>, <-17.3845, 68.1263, 33.6141> }
				triangle { <-16.671, 66.8296, 34.449>, <-19.2867, 69.9497, 44.3737>, <-17.3845, 68.1263, 33.6141> }
				triangle { <-17.3845, 68.1263, 33.6141>, <-19.2867, 69.9497, 44.3737>, <-20.09745, 71.04445, 43.9713> }
				triangle { <-19.2867, 69.9497, 44.3737>, <-22.4667, 68.625, 46.8816>, <-20.09745, 71.04445, 43.9713> }
				triangle { <-22.4667, 68.625, 46.8816>, <-20.5224, 71.6438, 43.6071>, <-20.09745, 71.04445, 43.9713> }
				triangle { <-20.09745, 71.04445, 43.9713>, <-20.5224, 71.6438, 43.6071>, <-17.3845, 68.1263, 33.6141> }
				triangle { <-17.3845, 68.1263, 33.6141>, <-20.5224, 71.6438, 43.6071>, <-18.1991, 69.4444, 33.04089> }
				triangle { <-18.1991, 69.4444, 33.04089>, <-18.3776, 58.732, 18.1182>, <-17.3845, 68.1263, 33.6141> }
				triangle { <-18.3776, 58.732, 18.1182>, <-18.1991, 69.4444, 33.04089>, <-18.5464, 62.9565, 21.7917> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-18.2792, 54.4105, 14.2652>, <-19.4384, 57.0064, 15.1699>, 0.4972 }
				cylinder { <-19.4384, 57.0064, 15.1699>, <-20.5977, 59.6022, 16.07464>, 0.4972 }
				cylinder { <-20.5977, 59.6022, 16.07464>, <-21.757, 62.198, 16.9793>, 0.4972 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-21.757, 62.198, 16.9793>, <-22.8223, 63.8566, 17.1415>, 0.09889 }
				cylinder { <-22.8223, 63.8566, 17.1415>, <-24.1071, 65.3328, 16.8543>, 0.09889 }
				cylinder { <-24.1071, 65.3328, 16.8543>, <-25.5184, 66.5194, 16.1386>, 0.09889 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-30.305, 69.8011, 15.6277>, <-40.3655, 75.6631, 11.1064>, <-25.5184, 66.5194, 16.1386> }
				triangle { <-30.305, 69.8011, 15.6277>, <-40.5475, 76.3717, 12.6402>, <-40.3655, 75.6631, 11.1064> }
				triangle { <-40.5475, 76.3717, 12.6402>, <-50.9807, 78.7398, 11.8553>, <-40.3655, 75.6631, 11.1064> }
				triangle { <-40.3655, 75.6631, 11.1064>, <-50.9807, 78.7398, 11.8553>, <-51.1851, 78.07992, 10.6143> }
				triangle { <-50.9807, 78.7398, 11.8553>, <-54.3567, 76.6631, 13.4198>, <-51.1851, 78.07992, 10.6143> }
				triangle { <-54.3567, 76.6631, 13.4198>, <-51.1622, 77.6766, 9.9006>, <-51.1851, 78.07992, 10.6143> }
				triangle { <-51.1851, 78.07992, 10.6143>, <-51.1622, 77.6766, 9.9006>, <-40.3655, 75.6631, 11.1064> }
				triangle { <-40.3655, 75.6631, 11.1064>, <-51.1622, 77.6766, 9.9006>, <-40.4618, 74.9759, 9.6071> }
				triangle { <-40.4618, 74.9759, 9.6071>, <-25.5184, 66.5194, 16.1386>, <-40.3655, 75.6631, 11.1064> }
				triangle { <-25.5184, 66.5194, 16.1386>, <-40.4618, 74.9759, 9.6071>, <-29.5773, 68.7386, 12.981> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-21.757, 62.198, 16.9793>, <-22.9163, 64.7938, 17.884>, 0.4972 }
				cylinder { <-22.9163, 64.7938, 17.884>, <-24.07558, 67.3896, 18.7887>, 0.4972 }
				cylinder { <-24.07558, 67.3896, 18.7887>, <-25.2348, 69.9855, 19.6934>, 0.4972 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-25.2348, 69.9855, 19.6934>, <-25.651, 71.6441, 20.6874>, 0.09889 }
				cylinder { <-25.651, 71.6441, 20.6874>, <-25.6846, 73.1202, 22.00353>, 0.09889 }
				cylinder { <-25.6846, 73.1202, 22.00353>, <-25.3332, 74.3069, 23.5464>, 0.09889 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-24.5972, 76.3352, 28.958>, <-24.3401, 83.7013, 39.0424>, <-25.3332, 74.3069, 23.5464> }
				triangle { <-24.5972, 76.3352, 28.958>, <-23.6266, 82.4045, 39.8773>, <-24.3401, 83.7013, 39.0424> }
				triangle { <-23.6266, 82.4045, 39.8773>, <-26.2424, 85.5246, 49.8019>, <-24.3401, 83.7013, 39.0424> }
				triangle { <-24.3401, 83.7013, 39.0424>, <-26.2424, 85.5246, 49.8019>, <-27.0531, 86.6193, 49.3995> }
				triangle { <-26.2424, 85.5246, 49.8019>, <-29.4224, 84.1999, 52.3099>, <-27.0531, 86.6193, 49.3995> }
				triangle { <-29.4224, 84.1999, 52.3099>, <-27.478, 87.2187, 49.03537>, <-27.0531, 86.6193, 49.3995> }
				triangle { <-27.0531, 86.6193, 49.3995>, <-27.478, 87.2187, 49.03537>, <-24.3401, 83.7013, 39.0424> }
				triangle { <-24.3401, 83.7013, 39.0424>, <-27.478, 87.2187, 49.03537>, <-25.1547, 85.01937, 38.4691> }
				triangle { <-25.1547, 85.01937, 38.4691>, <-25.3332, 74.3069, 23.5464>, <-24.3401, 83.7013, 39.0424> }
				triangle { <-25.3332, 74.3069, 23.5464>, <-25.1547, 85.01937, 38.4691>, <-25.5021, 78.5314, 27.2199> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-25.2348, 69.9855, 19.6934>, <-26.3941, 72.5813, 20.5981>, 0.4972 }
				cylinder { <-26.3941, 72.5813, 20.5981>, <-27.5534, 75.1771, 21.5028>, 0.4972 }
				cylinder { <-27.5534, 75.1771, 21.5028>, <-28.7126, 77.7729, 22.4075>, 0.4972 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-28.7126, 77.7729, 22.4075>, <-29.7779, 79.4315, 22.5697>, 0.09889 }
				cylinder { <-29.7779, 79.4315, 22.5697>, <-31.06281, 80.9077, 22.2826>, 0.09889 }
				cylinder { <-31.06281, 80.9077, 22.2826>, <-32.4741, 82.09439, 21.5668>, 0.09889 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-37.2606, 85.376, 21.05597>, <-47.3211, 91.238, 16.5347>, <-32.4741, 82.09439, 21.5668> }
				triangle { <-37.2606, 85.376, 21.05597>, <-47.5032, 91.9466, 18.06853>, <-47.3211, 91.238, 16.5347> }
				triangle { <-47.5032, 91.9466, 18.06853>, <-57.9364, 94.3147, 17.2835>, <-47.3211, 91.238, 16.5347> }
				triangle { <-47.3211, 91.238, 16.5347>, <-57.9364, 94.3147, 17.2835>, <-58.1407, 93.6548, 16.04255> }
				triangle { <-57.9364, 94.3147, 17.2835>, <-61.3123, 92.238, 18.8481>, <-58.1407, 93.6548, 16.04255> }
				triangle { <-61.3123, 92.238, 18.8481>, <-58.1179, 93.2515, 15.3288>, <-58.1407, 93.6548, 16.04255> }
				triangle { <-58.1407, 93.6548, 16.04255>, <-58.1179, 93.2515, 15.3288>, <-47.3211, 91.238, 16.5347> }
				triangle { <-47.3211, 91.238, 16.5347>, <-58.1179, 93.2515, 15.3288>, <-47.4174, 90.5508, 15.03541> }
				triangle { <-47.4174, 90.5508, 15.03541>, <-32.4741, 82.09439, 21.5668>, <-47.3211, 91.238, 16.5347> }
				triangle { <-32.4741, 82.09439, 21.5668>, <-47.4174, 90.5508, 15.03541>, <-36.533, 84.3135, 18.4092> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-28.7126, 77.7729, 22.4075>, <-29.4812, 79.4939, 23.00739>, 0.09889 }
				cylinder { <-29.4812, 79.4939, 23.00739>, <-30.2498, 81.2148, 23.6072>, 0.09889 }
				cylinder { <-30.2498, 81.2148, 23.6072>, <-31.0184, 82.9358, 24.207>, 0.09889 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-33.5255, 87.09515, 27.425>, <-40.1428, 97.04027, 31.07547>, <-31.0184, 82.9358, 24.207> }
				triangle { <-33.5255, 87.09515, 27.425>, <-39.5731, 96.7461, 32.6492>, <-40.1428, 97.04027, 31.07547> }
				triangle { <-39.5731, 96.7461, 32.6492>, <-47.3153, 101.9617, 37.9344>, <-40.1428, 97.04027, 31.07547> }
				triangle { <-40.1428, 97.04027, 31.07547>, <-47.3153, 101.9617, 37.9344>, <-48.1127, 102.2328, 36.7906> }
				triangle { <-47.3153, 101.9617, 37.9344>, <-50.7792, 100.4222, 39.8808>, <-48.1127, 102.2328, 36.7906> }
				triangle { <-50.7792, 100.4222, 39.8808>, <-48.4658, 102.3308, 36.05703>, <-48.1127, 102.2328, 36.7906> }
				triangle { <-48.1127, 102.2328, 36.7906>, <-48.4658, 102.3308, 36.05703>, <-40.1428, 97.04027, 31.07547> }
				triangle { <-40.1428, 97.04027, 31.07547>, <-48.4658, 102.3308, 36.05703>, <-40.9261, 97.4093, 29.6684> }
				triangle { <-40.9261, 97.4093, 29.6684>, <-31.0184, 82.9358, 24.207>, <-40.1428, 97.04027, 31.07547> }
				triangle { <-31.0184, 82.9358, 24.207>, <-40.9261, 97.4093, 29.6684>, <-34.08402, 87.6083, 24.581> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <0.0, 3.2338, 0.0>, <-0.07412, 3.5184, 0.05784>, 0.2247 }
		cylinder { <-0.07412, 3.5184, 0.05784>, <-0.2148, 3.7591, 0.1676>, 0.2247 }
		cylinder { <-0.2148, 3.7591, 0.1676>, <-0.408, 3.9317, 0.3184>, 0.2247 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.408, 3.9317, 0.3184>, <-4.3009, 6.2673, 3.3565>, 0.2731 }
			cylinder { <-4.3009, 6.2673, 3.3565>, <-8.4513, 7.7242, 6.5955>, 0.2731 }
			cylinder { <-8.4513, 7.7242, 6.5955>, <-12.737, 8.2596, 9.94>, 0.2731 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-12.737, 8.2596, 9.94>, <-14.02273, 8.4202, 10.9434>, 0.2731 }
				cylinder { <-14.02273, 8.4202, 10.9434>, <-15.3084, 8.5809, 11.9468>, 0.2731 }
				cylinder { <-15.3084, 8.5809, 11.9468>, <-16.5941, 8.7415, 12.9501>, 0.2731 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-16.5941, 8.7415, 12.9501>, <-16.9474, 8.7979, 13.4278>, 0.02983 }
				cylinder { <-16.9474, 8.7979, 13.4278>, <-17.1602, 8.848, 13.9831>, 0.02983 }
				cylinder { <-17.1602, 8.848, 13.9831>, <-17.2172, 8.8884, 14.5758>, 0.02983 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-17.02602, 8.2953, 17.7146>, <-18.3903, 7.9298, 24.4288>, <-17.2172, 8.8884, 14.5758> }
				triangle { <-17.02602, 8.2953, 17.7146>, <-17.5482, 7.5416, 24.5361>, <-18.3903, 7.9298, 24.4288> }
				triangle { <-17.5482, 7.5416, 24.5361>, <-18.5893, 4.8602, 29.6788>, <-18.3903, 7.9298, 24.4288> }
				triangle { <-18.3903, 7.9298, 24.4288>, <-18.5893, 4.8602, 29.6788>, <-19.3502, 5.03067, 29.7041> }
				triangle { <-18.5893, 4.8602, 29.6788>, <-19.1231, 2.6224, 30.1099>, <-19.3502, 5.03067, 29.7041> }
				triangle { <-19.1231, 2.6224, 30.1099>, <-19.7755, 5.1704, 29.6538>, <-19.3502, 5.03067, 29.7041> }
				triangle { <-19.3502, 5.03067, 29.7041>, <-19.7755, 5.1704, 29.6538>, <-18.3903, 7.9298, 24.4288> }
				triangle { <-18.3903, 7.9298, 24.4288>, <-19.7755, 5.1704, 29.6538>, <-19.2512, 8.2167, 24.4366> }
				triangle { <-19.2512, 8.2167, 24.4366>, <-17.2172, 8.8884, 14.5758>, <-18.3903, 7.9298, 24.4288> }
				triangle { <-17.2172, 8.8884, 14.5758>, <-19.2512, 8.2167, 24.4366>, <-18.366, 9.1498, 17.4178> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-16.5941, 8.7415, 12.9501>, <-17.8798, 8.9021, 13.9535>, 0.2731 }
				cylinder { <-17.8798, 8.9021, 13.9535>, <-19.1655, 9.0628, 14.9569>, 0.2731 }
				cylinder { <-19.1655, 9.0628, 14.9569>, <-20.4512, 9.2234, 15.9602>, 0.2731 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-20.4512, 9.2234, 15.9602>, <-21.00038, 9.2798, 16.1869>, 0.02983 }
				cylinder { <-21.00038, 9.2798, 16.1869>, <-21.5907, 9.3299, 16.2584>, 0.02983 }
				cylinder { <-21.5907, 9.3299, 16.2584>, <-22.1795, 9.3703, 16.1697>, 0.02983 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-25.3351, 8.8547, 16.2998>, <-31.9908, 8.3962, 14.6978>, <-22.1795, 9.3703, 16.1697> }
				triangle { <-25.3351, 8.8547, 16.2998>, <-32.142, 8.1321, 15.5803>, <-31.9908, 8.3962, 14.6978> }
				triangle { <-32.142, 8.1321, 15.5803>, <-37.2892, 5.4041, 14.6936>, <-31.9908, 8.3962, 14.6978> }
				triangle { <-31.9908, 8.3962, 14.6978>, <-37.2892, 5.4041, 14.6936>, <-37.2784, 5.466, 13.9159> }
				triangle { <-37.2892, 5.4041, 14.6936>, <-37.7426, 3.1198, 14.4596>, <-37.2784, 5.466, 13.9159> }
				triangle { <-37.7426, 3.1198, 14.4596>, <-37.207, 5.5437, 13.4779>, <-37.2784, 5.466, 13.9159> }
				triangle { <-37.2784, 5.466, 13.9159>, <-37.207, 5.5437, 13.4779>, <-31.9908, 8.3962, 14.6978> }
				triangle { <-31.9908, 8.3962, 14.6978>, <-37.207, 5.5437, 13.4779>, <-31.9559, 8.559, 13.8057> }
				triangle { <-31.9559, 8.559, 13.8057>, <-22.1795, 9.3703, 16.1697>, <-31.9908, 8.3962, 14.6978> }
				triangle { <-22.1795, 9.3703, 16.1697>, <-31.9559, 8.559, 13.8057>, <-24.9638, 9.5076, 14.8681> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-20.4512, 9.2234, 15.9602>, <-21.7369, 9.384, 16.9636>, 0.2731 }
				cylinder { <-21.7369, 9.384, 16.9636>, <-23.02259, 9.5446, 17.967>, 0.2731 }
				cylinder { <-23.02259, 9.5446, 17.967>, <-24.3082, 9.7053, 18.9703>, 0.2731 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-24.3082, 9.7053, 18.9703>, <-24.6616, 9.7616, 19.448>, 0.02983 }
				cylinder { <-24.6616, 9.7616, 19.448>, <-24.8744, 9.8118, 20.0033>, 0.02983 }
				cylinder { <-24.8744, 9.8118, 20.0033>, <-24.9313, 9.8521, 20.5959>, 0.02983 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-24.7401, 9.259, 23.7348>, <-26.1044, 8.8936, 30.449>, <-24.9313, 9.8521, 20.5959> }
				triangle { <-24.7401, 9.259, 23.7348>, <-25.2623, 8.5054, 30.5563>, <-26.1044, 8.8936, 30.449> }
				triangle { <-25.2623, 8.5054, 30.5563>, <-26.3034, 5.824, 35.699>, <-26.1044, 8.8936, 30.449> }
				triangle { <-26.1044, 8.8936, 30.449>, <-26.3034, 5.824, 35.699>, <-27.06443, 5.9944, 35.7243> }
				triangle { <-26.3034, 5.824, 35.699>, <-26.8373, 3.5862, 36.1301>, <-27.06443, 5.9944, 35.7243> }
				triangle { <-26.8373, 3.5862, 36.1301>, <-27.4896, 6.1341, 35.674>, <-27.06443, 5.9944, 35.7243> }
				triangle { <-27.06443, 5.9944, 35.7243>, <-27.4896, 6.1341, 35.674>, <-26.1044, 8.8936, 30.449> }
				triangle { <-26.1044, 8.8936, 30.449>, <-27.4896, 6.1341, 35.674>, <-26.9654, 9.1805, 30.4568> }
				triangle { <-26.9654, 9.1805, 30.4568>, <-24.9313, 9.8521, 20.5959>, <-26.1044, 8.8936, 30.449> }
				triangle { <-24.9313, 9.8521, 20.5959>, <-26.9654, 9.1805, 30.4568>, <-26.08019, 10.1136, 23.438> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-24.3082, 9.7053, 18.9703>, <-25.5939, 9.8659, 19.9737>, 0.2731 }
				cylinder { <-25.5939, 9.8659, 19.9737>, <-26.8796, 10.02657, 20.9771>, 0.2731 }
				cylinder { <-26.8796, 10.02657, 20.9771>, <-28.1653, 10.1871, 21.9804>, 0.2731 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-28.1653, 10.1871, 21.9804>, <-28.7145, 10.2435, 22.2071>, 0.02983 }
				cylinder { <-28.7145, 10.2435, 22.2071>, <-29.3049, 10.2937, 22.2786>, 0.02983 }
				cylinder { <-29.3049, 10.2937, 22.2786>, <-29.8936, 10.334, 22.1899>, 0.02983 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-33.04933, 9.8185, 22.32>, <-39.705, 9.36, 20.718>, <-29.8936, 10.334, 22.1899> }
				triangle { <-33.04933, 9.8185, 22.32>, <-39.8561, 9.09587, 21.6005>, <-39.705, 9.36, 20.718> }
				triangle { <-39.8561, 9.09587, 21.6005>, <-45.00336, 6.3679, 20.7137>, <-39.705, 9.36, 20.718> }
				triangle { <-39.705, 9.36, 20.718>, <-45.00336, 6.3679, 20.7137>, <-44.9926, 6.4297, 19.9361> }
				triangle { <-45.00336, 6.3679, 20.7137>, <-45.4568, 4.08362, 20.4798>, <-44.9926, 6.4297, 19.9361> }
				triangle { <-45.4568, 4.08362, 20.4798>, <-44.9212, 6.5074, 19.4981>, <-44.9926, 6.4297, 19.9361> }
				triangle { <-44.9926, 6.4297, 19.9361>, <-44.9212, 6.5074, 19.4981>, <-39.705, 9.36, 20.718> }
				triangle { <-39.705, 9.36, 20.718>, <-44.9212, 6.5074, 19.4981>, <-39.67, 9.5227, 19.8259> }
				triangle { <-39.67, 9.5227, 19.8259>, <-29.8936, 10.334, 22.1899>, <-39.705, 9.36, 20.718> }
				triangle { <-29.8936, 10.334, 22.1899>, <-39.67, 9.5227, 19.8259>, <-32.6779, 10.4714, 20.8883> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-28.1653, 10.1871, 21.9804>, <-29.451, 10.3478, 22.9838>, 0.2731 }
				cylinder { <-29.451, 10.3478, 22.9838>, <-30.7367, 10.5084, 23.9872>, 0.2731 }
				cylinder { <-30.7367, 10.5084, 23.9872>, <-32.02245, 10.669, 24.9905>, 0.2731 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-32.02245, 10.669, 24.9905>, <-32.3757, 10.7254, 25.4682>, 0.02983 }
				cylinder { <-32.3757, 10.7254, 25.4682>, <-32.5886, 10.7756, 26.0235>, 0.02983 }
				cylinder { <-32.5886, 10.7756, 26.0235>, <-32.6455, 10.8159, 26.6161>, 0.02983 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-32.4543, 10.2228, 29.755>, <-33.8186, 9.8573, 36.4692>, <-32.6455, 10.8159, 26.6161> }
				triangle { <-32.4543, 10.2228, 29.755>, <-32.9765, 9.4691, 36.5765>, <-33.8186, 9.8573, 36.4692> }
				triangle { <-32.9765, 9.4691, 36.5765>, <-34.01764, 6.7878, 41.7192>, <-33.8186, 9.8573, 36.4692> }
				triangle { <-33.8186, 9.8573, 36.4692>, <-34.01764, 6.7878, 41.7192>, <-34.7785, 6.9581, 41.7445> }
				triangle { <-34.01764, 6.7878, 41.7192>, <-34.5514, 4.5499, 42.1503>, <-34.7785, 6.9581, 41.7445> }
				triangle { <-34.5514, 4.5499, 42.1503>, <-35.2038, 7.09794, 41.6942>, <-34.7785, 6.9581, 41.7445> }
				triangle { <-34.7785, 6.9581, 41.7445>, <-35.2038, 7.09794, 41.6942>, <-33.8186, 9.8573, 36.4692> }
				triangle { <-33.8186, 9.8573, 36.4692>, <-35.2038, 7.09794, 41.6942>, <-34.6795, 10.1442, 36.477> }
				triangle { <-34.6795, 10.1442, 36.477>, <-32.6455, 10.8159, 26.6161>, <-33.8186, 9.8573, 36.4692> }
				triangle { <-32.6455, 10.8159, 26.6161>, <-34.6795, 10.1442, 36.477>, <-33.7943, 11.07737, 29.4582> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-32.02245, 10.669, 24.9905>, <-33.3081, 10.8297, 25.9939>, 0.2731 }
				cylinder { <-33.3081, 10.8297, 25.9939>, <-34.5938, 10.9903, 26.9973>, 0.2731 }
				cylinder { <-34.5938, 10.9903, 26.9973>, <-35.8795, 11.1509, 28.00067>, 0.2731 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-35.8795, 11.1509, 28.00067>, <-36.4287, 11.2073, 28.2273>, 0.02983 }
				cylinder { <-36.4287, 11.2073, 28.2273>, <-37.01907, 11.2575, 28.2988>, 0.02983 }
				cylinder { <-37.01907, 11.2575, 28.2988>, <-37.6078, 11.2978, 28.2101>, 0.02983 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-40.7635, 10.7822, 28.3402>, <-47.4191, 10.3237, 26.7382>, <-37.6078, 11.2978, 28.2101> }
				triangle { <-40.7635, 10.7822, 28.3402>, <-47.5703, 10.05963, 27.6207>, <-47.4191, 10.3237, 26.7382> }
				triangle { <-47.5703, 10.05963, 27.6207>, <-52.7175, 7.3317, 26.7339>, <-47.4191, 10.3237, 26.7382> }
				triangle { <-47.4191, 10.3237, 26.7382>, <-52.7175, 7.3317, 26.7339>, <-52.7067, 7.3935, 25.9563> }
				triangle { <-52.7175, 7.3317, 26.7339>, <-53.1709, 5.04738, 26.5>, <-52.7067, 7.3935, 25.9563> }
				triangle { <-53.1709, 5.04738, 26.5>, <-52.6354, 7.4712, 25.5183>, <-52.7067, 7.3935, 25.9563> }
				triangle { <-52.7067, 7.3935, 25.9563>, <-52.6354, 7.4712, 25.5183>, <-47.4191, 10.3237, 26.7382> }
				triangle { <-47.4191, 10.3237, 26.7382>, <-52.6354, 7.4712, 25.5183>, <-47.3842, 10.4865, 25.8461> }
				triangle { <-47.3842, 10.4865, 25.8461>, <-37.6078, 11.2978, 28.2101>, <-47.4191, 10.3237, 26.7382> }
				triangle { <-37.6078, 11.2978, 28.2101>, <-47.3842, 10.4865, 25.8461>, <-40.3921, 11.4351, 26.9085> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-35.8795, 11.1509, 28.00067>, <-36.3477, 11.2094, 28.366>, 0.02983 }
				cylinder { <-36.3477, 11.2094, 28.366>, <-36.8159, 11.2679, 28.7314>, 0.02983 }
				cylinder { <-36.8159, 11.2679, 28.7314>, <-37.2841, 11.3264, 29.09686>, 0.02983 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-39.4071, 10.8652, 31.4465>, <-45.1921, 10.6593, 35.1297>, <-37.2841, 11.3264, 29.09686> }
				triangle { <-39.4071, 10.8652, 31.4465>, <-44.6797, 10.3331, 35.8385>, <-45.1921, 10.6593, 35.1297> }
				triangle { <-44.6797, 10.3331, 35.8385>, <-49.06061, 7.7814, 38.8416>, <-45.1921, 10.6593, 35.1297> }
				triangle { <-45.1921, 10.6593, 35.1297>, <-49.06061, 7.7814, 38.8416>, <-49.6083, 7.9008, 38.299> }
				triangle { <-49.06061, 7.7814, 38.8416>, <-49.6966, 5.5303, 38.9222>, <-49.6083, 7.9008, 38.299> }
				triangle { <-49.6966, 5.5303, 38.9222>, <-49.8688, 8.009604, 37.9479>, <-49.6083, 7.9008, 38.299> }
				triangle { <-49.6083, 7.9008, 38.299>, <-49.8688, 8.009604, 37.9479>, <-45.1921, 10.6593, 35.1297> }
				triangle { <-45.1921, 10.6593, 35.1297>, <-49.8688, 8.009604, 37.9479>, <-45.7987, 10.8874, 34.4944> }
				triangle { <-45.7987, 10.8874, 34.4944>, <-37.2841, 11.3264, 29.09686>, <-45.1921, 10.6593, 35.1297> }
				triangle { <-37.2841, 11.3264, 29.09686>, <-45.7987, 10.8874, 34.4944>, <-40.1361, 11.6155, 30.2139> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <-0.408, 3.9317, 0.3184>, <-0.5051, 4.01853, 0.3942>, 0.113 }
		cylinder { <-0.5051, 4.01853, 0.3942>, <-0.6023, 4.1053, 0.47>, 0.113 }
		cylinder { <-0.6023, 4.1053, 0.47>, <-0.6994, 4.192, 0.5458>, 0.113 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.6994, 4.192, 0.5458>, <-2.09945, 6.04498, 2.04065>, 0.138 }
			cylinder { <-2.09945, 6.04498, 2.04065>, <-3.07814, 8.1059, 3.597>, 0.138 }
			cylinder { <-3.07814, 8.1059, 3.597>, <-3.6066, 10.3143, 5.1691>, 0.138 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-3.6066, 10.3143, 5.1691>, <-3.7652, 10.9768, 5.6407>, 0.138 }
				cylinder { <-3.7652, 10.9768, 5.6407>, <-3.9238, 11.6393, 6.1124>, 0.138 }
				cylinder { <-3.9238, 11.6393, 6.1124>, <-4.08238, 12.3018, 6.584>, 0.138 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-4.08238, 12.3018, 6.584>, <-4.1166, 12.4417, 6.6343>, 0.007627 }
				cylinder { <-4.1166, 12.4417, 6.6343>, <-4.1535, 12.5894, 6.6443>, 0.007627 }
				cylinder { <-4.1535, 12.5894, 6.6443>, <-4.1903, 12.7342, 6.6133>, 0.007627 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-4.1791, 14.2406, 6.02318>, <-4.5884, 17.6646, 5.646>, <-4.1903, 12.7342, 6.6133> }
				triangle { <-4.1791, 14.2406, 6.02318>, <-4.4125, 17.6164, 5.2108>, <-4.5884, 17.6646, 5.646> }
				triangle { <-4.4125, 17.6164, 5.2108>, <-3.5314, 20.4372, 4.8334>, <-4.5884, 17.6646, 5.646> }
				triangle { <-4.5884, 17.6646, 5.646>, <-3.5314, 20.4372, 4.8334>, <-3.6116, 20.5537, 5.2016> }
				triangle { <-3.5314, 20.4372, 4.8334>, <-2.4521, 20.9099, 4.9438>, <-3.6116, 20.5537, 5.2016> }
				triangle { <-2.4521, 20.9099, 4.9438>, <-3.6728, 20.5845, 5.4188>, <-3.6116, 20.5537, 5.2016> }
				triangle { <-3.6116, 20.5537, 5.2016>, <-3.6728, 20.5845, 5.4188>, <-4.5884, 17.6646, 5.646> }
				triangle { <-4.5884, 17.6646, 5.646>, <-3.6728, 20.5845, 5.4188>, <-4.7241, 17.7788, 6.06924> }
				triangle { <-4.7241, 17.7788, 6.06924>, <-4.1903, 12.7342, 6.6133>, <-4.5884, 17.6646, 5.646> }
				triangle { <-4.1903, 12.7342, 6.6133>, <-4.7241, 17.7788, 6.06924>, <-4.5655, 14.2381, 6.7435> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-4.08238, 12.3018, 6.584>, <-4.2409, 12.9643, 7.0557>, 0.138 }
				cylinder { <-4.2409, 12.9643, 7.0557>, <-4.3995, 13.6268, 7.5273>, 0.138 }
				cylinder { <-4.3995, 13.6268, 7.5273>, <-4.558, 14.2893, 7.9989>, 0.138 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-4.558, 14.2893, 7.9989>, <-4.58, 14.3846, 8.1161>, 0.007627 }
				cylinder { <-4.58, 14.3846, 8.1161>, <-4.5932, 14.4461, 8.255>, 0.007627 }
				cylinder { <-4.5932, 14.4461, 8.255>, <-4.5967, 14.4696, 8.4057>, 0.007627 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-4.3237, 15.06591, 9.8848>, <-3.892, 15.3823, 13.3123>, <-4.5967, 14.4696, 8.4057> }
				triangle { <-4.3237, 15.06591, 9.8848>, <-3.8386, 15.8459, 13.2414>, <-3.892, 15.3823, 13.3123> }
				triangle { <-3.8386, 15.8459, 13.2414>, <-2.3558, 16.454, 15.7528>, <-3.892, 15.3823, 13.3123> }
				triangle { <-3.892, 15.3823, 13.3123>, <-2.3558, 16.454, 15.7528>, <-2.3167, 16.07875, 15.868> }
				triangle { <-2.3558, 16.454, 15.7528>, <-1.1943, 16.6029, 15.9239>, <-2.3167, 16.07875, 15.868> }
				triangle { <-1.1943, 16.6029, 15.9239>, <-2.3167, 15.8537, 15.903>, <-2.3167, 16.07875, 15.868> }
				triangle { <-2.3167, 16.07875, 15.868>, <-2.3167, 15.8537, 15.903>, <-3.892, 15.3823, 13.3123> }
				triangle { <-3.892, 15.3823, 13.3123>, <-2.3167, 15.8537, 15.903>, <-3.8931, 14.9408, 13.4369> }
				triangle { <-3.8931, 14.9408, 13.4369>, <-4.5967, 14.4696, 8.4057>, <-3.892, 15.3823, 13.3123> }
				triangle { <-4.5967, 14.4696, 8.4057>, <-3.8931, 14.9408, 13.4369>, <-4.5231, 14.2756, 9.9473> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-4.558, 14.2893, 7.9989>, <-4.7166, 14.9518, 8.4706>, 0.138 }
				cylinder { <-4.7166, 14.9518, 8.4706>, <-4.8752, 15.6144, 8.9422>, 0.138 }
				cylinder { <-4.8752, 15.6144, 8.9422>, <-5.03377, 16.2769, 9.4138>, 0.138 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-5.03377, 16.2769, 9.4138>, <-5.06805, 16.4168, 9.4641>, 0.007627 }
				cylinder { <-5.06805, 16.4168, 9.4641>, <-5.1049, 16.5645, 9.4741>, 0.007627 }
				cylinder { <-5.1049, 16.5645, 9.4741>, <-5.1417, 16.7092, 9.4432>, 0.007627 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-5.1304, 18.2157, 8.853>, <-5.5398, 21.6397, 8.4758>, <-5.1417, 16.7092, 9.4432> }
				triangle { <-5.1304, 18.2157, 8.853>, <-5.3638, 21.5914, 8.04063>, <-5.5398, 21.6397, 8.4758> }
				triangle { <-5.3638, 21.5914, 8.04063>, <-4.4828, 24.4122, 7.6632>, <-5.5398, 21.6397, 8.4758> }
				triangle { <-5.5398, 21.6397, 8.4758>, <-4.4828, 24.4122, 7.6632>, <-4.563, 24.5287, 8.03146> }
				triangle { <-4.4828, 24.4122, 7.6632>, <-3.4035, 24.8849, 7.7736>, <-4.563, 24.5287, 8.03146> }
				triangle { <-3.4035, 24.8849, 7.7736>, <-4.6242, 24.5596, 8.2486>, <-4.563, 24.5287, 8.03146> }
				triangle { <-4.563, 24.5287, 8.03146>, <-4.6242, 24.5596, 8.2486>, <-5.5398, 21.6397, 8.4758> }
				triangle { <-5.5398, 21.6397, 8.4758>, <-4.6242, 24.5596, 8.2486>, <-5.6755, 21.7538, 8.899> }
				triangle { <-5.6755, 21.7538, 8.899>, <-5.1417, 16.7092, 9.4432>, <-5.5398, 21.6397, 8.4758> }
				triangle { <-5.1417, 16.7092, 9.4432>, <-5.6755, 21.7538, 8.899>, <-5.5169, 18.2132, 9.5733> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-5.03377, 16.2769, 9.4138>, <-5.1923, 16.9394, 9.8855>, 0.138 }
				cylinder { <-5.1923, 16.9394, 9.8855>, <-5.3509, 17.6019, 10.3571>, 0.138 }
				cylinder { <-5.3509, 17.6019, 10.3571>, <-5.5094, 18.2644, 10.8288>, 0.138 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-5.5094, 18.2644, 10.8288>, <-5.5314, 18.3596, 10.9459>, 0.007627 }
				cylinder { <-5.5314, 18.3596, 10.9459>, <-5.5446, 18.4212, 11.0849>, 0.007627 }
				cylinder { <-5.5446, 18.4212, 11.0849>, <-5.5481, 18.4446, 11.2356>, 0.007627 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-5.275, 19.04096, 12.7147>, <-4.8434, 19.3574, 16.1421>, <-5.5481, 18.4446, 11.2356> }
				triangle { <-5.275, 19.04096, 12.7147>, <-4.7899, 19.8209, 16.07123>, <-4.8434, 19.3574, 16.1421> }
				triangle { <-4.7899, 19.8209, 16.07123>, <-3.3071, 20.429, 18.5826>, <-4.8434, 19.3574, 16.1421> }
				triangle { <-4.8434, 19.3574, 16.1421>, <-3.3071, 20.429, 18.5826>, <-3.2681, 20.0538, 18.6978> }
				triangle { <-3.3071, 20.429, 18.5826>, <-2.1457, 20.578, 18.7537>, <-3.2681, 20.0538, 18.6978> }
				triangle { <-2.1457, 20.578, 18.7537>, <-3.2681, 19.8287, 18.7328>, <-3.2681, 20.0538, 18.6978> }
				triangle { <-3.2681, 20.0538, 18.6978>, <-3.2681, 19.8287, 18.7328>, <-4.8434, 19.3574, 16.1421> }
				triangle { <-4.8434, 19.3574, 16.1421>, <-3.2681, 19.8287, 18.7328>, <-4.8445, 18.9158, 16.2667> }
				triangle { <-4.8445, 18.9158, 16.2667>, <-5.5481, 18.4446, 11.2356>, <-4.8434, 19.3574, 16.1421> }
				triangle { <-5.5481, 18.4446, 11.2356>, <-4.8445, 18.9158, 16.2667>, <-5.4745, 18.2507, 12.7771> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-5.5094, 18.2644, 10.8288>, <-5.668, 18.9269, 11.3004>, 0.138 }
				cylinder { <-5.668, 18.9269, 11.3004>, <-5.8265, 19.5894, 11.772>, 0.138 }
				cylinder { <-5.8265, 19.5894, 11.772>, <-5.9851, 20.2519, 12.2437>, 0.138 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-5.9851, 20.2519, 12.2437>, <-6.01943, 20.3918, 12.2939>, 0.007627 }
				cylinder { <-6.01943, 20.3918, 12.2939>, <-6.05632, 20.5395, 12.3039>, 0.007627 }
				cylinder { <-6.05632, 20.5395, 12.3039>, <-6.09314, 20.6843, 12.273>, 0.007627 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-6.08187, 22.1907, 11.6828>, <-6.4912, 25.6147, 11.3057>, <-6.09314, 20.6843, 12.273> }
				triangle { <-6.08187, 22.1907, 11.6828>, <-6.3152, 25.5665, 10.8704>, <-6.4912, 25.6147, 11.3057> }
				triangle { <-6.3152, 25.5665, 10.8704>, <-5.4342, 28.3873, 10.493>, <-6.4912, 25.6147, 11.3057> }
				triangle { <-6.4912, 25.6147, 11.3057>, <-5.4342, 28.3873, 10.493>, <-5.5144, 28.5038, 10.8612> }
				triangle { <-5.4342, 28.3873, 10.493>, <-4.3549, 28.86, 10.6035>, <-5.5144, 28.5038, 10.8612> }
				triangle { <-4.3549, 28.86, 10.6035>, <-5.5756, 28.5346, 11.07848>, <-5.5144, 28.5038, 10.8612> }
				triangle { <-5.5144, 28.5038, 10.8612>, <-5.5756, 28.5346, 11.07848>, <-6.4912, 25.6147, 11.3057> }
				triangle { <-6.4912, 25.6147, 11.3057>, <-5.5756, 28.5346, 11.07848>, <-6.6269, 25.7289, 11.7288> }
				triangle { <-6.6269, 25.7289, 11.7288>, <-6.09314, 20.6843, 12.273>, <-6.4912, 25.6147, 11.3057> }
				triangle { <-6.09314, 20.6843, 12.273>, <-6.6269, 25.7289, 11.7288>, <-6.4682, 22.1882, 12.4031> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-5.9851, 20.2519, 12.2437>, <-6.1437, 20.9144, 12.7153>, 0.138 }
				cylinder { <-6.1437, 20.9144, 12.7153>, <-6.3022, 21.5769, 13.1869>, 0.138 }
				cylinder { <-6.3022, 21.5769, 13.1869>, <-6.4608, 22.2394, 13.6586>, 0.138 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-6.4608, 22.2394, 13.6586>, <-6.4828, 22.3347, 13.7757>, 0.007627 }
				cylinder { <-6.4828, 22.3347, 13.7757>, <-6.496, 22.3962, 13.9147>, 0.007627 }
				cylinder { <-6.496, 22.3962, 13.9147>, <-6.4994, 22.4197, 14.06542>, 0.007627 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-6.2264, 23.01601, 15.5445>, <-5.7948, 23.3324, 18.9719>, <-6.4994, 22.4197, 14.06542> }
				triangle { <-6.2264, 23.01601, 15.5445>, <-5.7413, 23.796, 18.901>, <-5.7948, 23.3324, 18.9719> }
				triangle { <-5.7413, 23.796, 18.901>, <-4.2585, 24.4041, 21.4124>, <-5.7948, 23.3324, 18.9719> }
				triangle { <-5.7948, 23.3324, 18.9719>, <-4.2585, 24.4041, 21.4124>, <-4.2195, 24.02885, 21.5276> }
				triangle { <-4.2585, 24.4041, 21.4124>, <-3.09712, 24.553, 21.5836>, <-4.2195, 24.02885, 21.5276> }
				triangle { <-3.09712, 24.553, 21.5836>, <-4.2194, 23.8038, 21.5626>, <-4.2195, 24.02885, 21.5276> }
				triangle { <-4.2195, 24.02885, 21.5276>, <-4.2194, 23.8038, 21.5626>, <-5.7948, 23.3324, 18.9719> }
				triangle { <-5.7948, 23.3324, 18.9719>, <-4.2194, 23.8038, 21.5626>, <-5.7959, 22.8909, 19.09654> }
				triangle { <-5.7959, 22.8909, 19.09654>, <-6.4994, 22.4197, 14.06542>, <-5.7948, 23.3324, 18.9719> }
				triangle { <-6.4994, 22.4197, 14.06542>, <-5.7959, 22.8909, 19.09654>, <-6.4259, 22.2257, 15.607> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-6.4608, 22.2394, 13.6586>, <-6.49, 22.3614, 13.7454>, 0.007627 }
				cylinder { <-6.49, 22.3614, 13.7454>, <-6.5192, 22.4834, 13.8323>, 0.007627 }
				cylinder { <-6.5192, 22.4834, 13.8323>, <-6.5484, 22.6054, 13.9191>, 0.007627 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-6.5111, 24.08782, 14.5664>, <-6.6879, 26.7517, 16.7813>, <-6.5484, 22.6054, 13.9191> }
				triangle { <-6.5111, 24.08782, 14.5664>, <-6.5939, 27.03466, 16.4155>, <-6.6879, 26.7517, 16.7813> }
				triangle { <-6.5939, 27.03466, 16.4155>, <-5.5552, 29.3516, 17.9738>, <-6.6879, 26.7517, 16.7813> }
				triangle { <-6.6879, 26.7517, 16.7813>, <-5.5552, 29.3516, 17.9738>, <-5.5609, 29.17, 18.324> }
				triangle { <-5.5552, 29.3516, 17.9738>, <-4.4369, 29.6753, 18.1862>, <-5.5609, 29.17, 18.324> }
				triangle { <-4.4369, 29.6753, 18.1862>, <-5.5811, 29.03531, 18.5065>, <-5.5609, 29.17, 18.324> }
				triangle { <-5.5609, 29.17, 18.324>, <-5.5811, 29.03531, 18.5065>, <-6.6879, 26.7517, 16.7813> }
				triangle { <-6.6879, 26.7517, 16.7813>, <-5.5811, 29.03531, 18.5065>, <-6.7389, 26.5263, 17.1778> }
				triangle { <-6.7389, 26.5263, 17.1778>, <-6.5484, 22.6054, 13.9191>, <-6.6879, 26.7517, 16.7813> }
				triangle { <-6.5484, 22.6054, 13.9191>, <-6.7389, 26.5263, 17.1778>, <-6.7671, 23.5553, 15.1313> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <-0.6994, 4.192, 0.5458>, <-0.7395, 4.2278, 0.5771>, 0.04662 }
		cylinder { <-0.7395, 4.2278, 0.5771>, <-0.7795, 4.2636, 0.6083>, 0.04662 }
		cylinder { <-0.7795, 4.2636, 0.6083>, <-0.8196, 4.2994, 0.6396>, 0.04662 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.8196, 4.2994, 0.6396>, <-1.7025, 4.9534, 1.0737>, 0.05906 }
			cylinder { <-1.7025, 4.9534, 1.0737>, <-2.6808, 5.562, 1.3347>, 0.05906 }
			cylinder { <-2.6808, 5.562, 1.3347>, <-3.7257, 6.1072, 1.4151>, 0.05906 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-3.7257, 6.1072, 1.4151>, <-4.03923, 6.2708, 1.4393>, 0.05906 }
				cylinder { <-4.03923, 6.2708, 1.4393>, <-4.3527, 6.4343, 1.4634>, 0.05906 }
				cylinder { <-4.3527, 6.4343, 1.4634>, <-4.6661, 6.5979, 1.4875>, 0.05906 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-4.6661, 6.5979, 1.4875>, <-4.6929, 6.6043, 1.4925>, 0.001395 }
				cylinder { <-4.6929, 6.6043, 1.4925>, <-4.7196, 6.6036, 1.5003>, 0.001395 }
				cylinder { <-4.7196, 6.6036, 1.5003>, <-4.7446, 6.5961, 1.5103>, 0.001395 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-5.3338, 6.2525, 1.6276>, <-6.7431, 5.9155, 1.9472>, <-4.7446, 6.5961, 1.5103> }
				triangle { <-5.3338, 6.2525, 1.6276>, <-6.691, 5.7213, 1.9301>, <-6.7431, 5.9155, 1.9472> }
				triangle { <-6.691, 5.7213, 1.9301>, <-7.8561, 5.2562, 1.7063>, <-6.7431, 5.9155, 1.9472> }
				triangle { <-6.7431, 5.9155, 1.9472>, <-7.8561, 5.2562, 1.7063>, <-7.9326, 5.4062, 1.6951> }
				triangle { <-7.8561, 5.2562, 1.7063>, <-8.07169, 5.1251, 1.2674>, <-7.9326, 5.4062, 1.6951> }
				triangle { <-8.07169, 5.1251, 1.2674>, <-7.9616, 5.4992, 1.693>, <-7.9326, 5.4062, 1.6951> }
				triangle { <-7.9326, 5.4062, 1.6951>, <-7.9616, 5.4992, 1.693>, <-6.7431, 5.9155, 1.9472> }
				triangle { <-6.7431, 5.9155, 1.9472>, <-7.9616, 5.4992, 1.693>, <-6.8223, 6.09511, 1.9515> }
				triangle { <-6.8223, 6.09511, 1.9515>, <-4.7446, 6.5961, 1.5103>, <-6.7431, 5.9155, 1.9472> }
				triangle { <-4.7446, 6.5961, 1.5103>, <-6.8223, 6.09511, 1.9515>, <-5.3846, 6.5924, 1.6922> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-4.6661, 6.5979, 1.4875>, <-4.9796, 6.7615, 1.5116>, 0.05906 }
				cylinder { <-4.9796, 6.7615, 1.5116>, <-5.2931, 6.925, 1.5358>, 0.05906 }
				cylinder { <-5.2931, 6.925, 1.5358>, <-5.6066, 7.08862, 1.5599>, 0.05906 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-5.6066, 7.08862, 1.5599>, <-5.6275, 7.1071, 1.5585>, 0.001395 }
				cylinder { <-5.6275, 7.1071, 1.5585>, <-5.643, 7.1298, 1.554>, 0.001395 }
				cylinder { <-5.643, 7.1298, 1.554>, <-5.6521, 7.1551, 1.5466>, 0.001395 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-6.01765, 7.6702, 1.2636>, <-6.4146, 8.9649, 0.6572>, <-5.6521, 7.1551, 1.5466> }
				triangle { <-6.01765, 7.6702, 1.2636>, <-6.6047, 8.897, 0.6587>, <-6.4146, 8.9649, 0.6572> }
				triangle { <-6.6047, 8.897, 0.6587>, <-7.06287, 9.6655, -0.2486>, <-6.4146, 8.9649, 0.6572> }
				triangle { <-6.4146, 8.9649, 0.6572>, <-7.06287, 9.6655, -0.2486>, <-6.9139, 9.7328, -0.2908> }
				triangle { <-7.06287, 9.6655, -0.2486>, <-7.1473, 9.5705, -0.7386>, <-6.9139, 9.7328, -0.2908> }
				triangle { <-7.1473, 9.5705, -0.7386>, <-6.8219, 9.7626, -0.3022>, <-6.9139, 9.7328, -0.2908> }
				triangle { <-6.9139, 9.7328, -0.2908>, <-6.8219, 9.7626, -0.3022>, <-6.4146, 8.9649, 0.6572> }
				triangle { <-6.4146, 8.9649, 0.6572>, <-6.8219, 9.7626, -0.3022>, <-6.2383, 9.04598, 0.6282> }
				triangle { <-6.2383, 9.04598, 0.6282>, <-5.6521, 7.1551, 1.5466>, <-6.4146, 8.9649, 0.6572> }
				triangle { <-5.6521, 7.1551, 1.5466>, <-6.2383, 9.04598, 0.6282>, <-5.6883, 7.7769, 1.3126> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-5.6066, 7.08862, 1.5599>, <-5.9201, 7.2521, 1.584>, 0.05906 }
				cylinder { <-5.9201, 7.2521, 1.584>, <-6.2335, 7.4157, 1.6081>, 0.05906 }
				cylinder { <-6.2335, 7.4157, 1.6081>, <-6.547, 7.5793, 1.6323>, 0.05906 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-6.547, 7.5793, 1.6323>, <-6.5737, 7.5856, 1.6373>, 0.001395 }
				cylinder { <-6.5737, 7.5856, 1.6373>, <-6.6005, 7.585, 1.6451>, 0.001395 }
				cylinder { <-6.6005, 7.585, 1.6451>, <-6.6255, 7.5774, 1.6551>, 0.001395 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-7.2147, 7.2339, 1.7724>, <-8.624, 6.8969, 2.09196>, <-6.6255, 7.5774, 1.6551> }
				triangle { <-7.2147, 7.2339, 1.7724>, <-8.5719, 6.7026, 2.07484>, <-8.624, 6.8969, 2.09196> }
				triangle { <-8.5719, 6.7026, 2.07484>, <-9.737, 6.2376, 1.851>, <-8.624, 6.8969, 2.09196> }
				triangle { <-8.624, 6.8969, 2.09196>, <-9.737, 6.2376, 1.851>, <-9.8134, 6.3876, 1.8399> }
				triangle { <-9.737, 6.2376, 1.851>, <-9.9525, 6.1064, 1.4122>, <-9.8134, 6.3876, 1.8399> }
				triangle { <-9.9525, 6.1064, 1.4122>, <-9.8425, 6.4806, 1.8378>, <-9.8134, 6.3876, 1.8399> }
				triangle { <-9.8134, 6.3876, 1.8399>, <-9.8425, 6.4806, 1.8378>, <-8.624, 6.8969, 2.09196> }
				triangle { <-8.624, 6.8969, 2.09196>, <-9.8425, 6.4806, 1.8378>, <-8.7031, 7.07647, 2.09626> }
				triangle { <-8.7031, 7.07647, 2.09626>, <-6.6255, 7.5774, 1.6551>, <-8.624, 6.8969, 2.09196> }
				triangle { <-6.6255, 7.5774, 1.6551>, <-8.7031, 7.07647, 2.09626>, <-7.2655, 7.5737, 1.8369> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-6.547, 7.5793, 1.6323>, <-6.8605, 7.7428, 1.6564>, 0.05906 }
				cylinder { <-6.8605, 7.7428, 1.6564>, <-7.174, 7.9064, 1.6805>, 0.05906 }
				cylinder { <-7.174, 7.9064, 1.6805>, <-7.4875, 8.06998, 1.7046>, 0.05906 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-7.4875, 8.06998, 1.7046>, <-7.5083, 8.08845, 1.7033>, 0.001395 }
				cylinder { <-7.5083, 8.08845, 1.7033>, <-7.5239, 8.1111, 1.6987>, 0.001395 }
				cylinder { <-7.5239, 8.1111, 1.6987>, <-7.533, 8.1365, 1.6913>, 0.001395 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-7.8985, 8.6516, 1.4084>, <-8.2955, 9.9463, 0.8019>, <-7.533, 8.1365, 1.6913> }
				triangle { <-7.8985, 8.6516, 1.4084>, <-8.4856, 9.8784, 0.8035>, <-8.2955, 9.9463, 0.8019> }
				triangle { <-8.4856, 9.8784, 0.8035>, <-8.9437, 10.6469, -0.1039>, <-8.2955, 9.9463, 0.8019> }
				triangle { <-8.2955, 9.9463, 0.8019>, <-8.9437, 10.6469, -0.1039>, <-8.7948, 10.7142, -0.146> }
				triangle { <-8.9437, 10.6469, -0.1039>, <-9.02824, 10.5518, -0.5939>, <-8.7948, 10.7142, -0.146> }
				triangle { <-9.02824, 10.5518, -0.5939>, <-8.7028, 10.744, -0.1574>, <-8.7948, 10.7142, -0.146> }
				triangle { <-8.7948, 10.7142, -0.146>, <-8.7028, 10.744, -0.1574>, <-8.2955, 9.9463, 0.8019> }
				triangle { <-8.2955, 9.9463, 0.8019>, <-8.7028, 10.744, -0.1574>, <-8.1191, 10.02735, 0.7729> }
				triangle { <-8.1191, 10.02735, 0.7729>, <-7.533, 8.1365, 1.6913>, <-8.2955, 9.9463, 0.8019> }
				triangle { <-7.533, 8.1365, 1.6913>, <-8.1191, 10.02735, 0.7729>, <-7.5691, 8.7583, 1.4574> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-7.4875, 8.06998, 1.7046>, <-7.8009, 8.2335, 1.7287>, 0.05906 }
				cylinder { <-7.8009, 8.2335, 1.7287>, <-8.1144, 8.3971, 1.7529>, 0.05906 }
				cylinder { <-8.1144, 8.3971, 1.7529>, <-8.4279, 8.5606, 1.777>, 0.05906 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-8.4279, 8.5606, 1.777>, <-8.4546, 8.567, 1.782>, 0.001395 }
				cylinder { <-8.4546, 8.567, 1.782>, <-8.4814, 8.5663, 1.7898>, 0.001395 }
				cylinder { <-8.4814, 8.5663, 1.7898>, <-8.5063, 8.5588, 1.7998>, 0.001395 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-9.09561, 8.2152, 1.9171>, <-10.5048, 7.8783, 2.2367>, <-8.5063, 8.5588, 1.7998> }
				triangle { <-9.09561, 8.2152, 1.9171>, <-10.4528, 7.684, 2.2195>, <-10.5048, 7.8783, 2.2367> }
				triangle { <-10.4528, 7.684, 2.2195>, <-11.6179, 7.2189, 1.9957>, <-10.5048, 7.8783, 2.2367> }
				triangle { <-10.5048, 7.8783, 2.2367>, <-11.6179, 7.2189, 1.9957>, <-11.6943, 7.369, 1.9846> }
				triangle { <-11.6179, 7.2189, 1.9957>, <-11.8334, 7.08782, 1.5569>, <-11.6943, 7.369, 1.9846> }
				triangle { <-11.8334, 7.08782, 1.5569>, <-11.7234, 7.4619, 1.9825>, <-11.6943, 7.369, 1.9846> }
				triangle { <-11.6943, 7.369, 1.9846>, <-11.7234, 7.4619, 1.9825>, <-10.5048, 7.8783, 2.2367> }
				triangle { <-10.5048, 7.8783, 2.2367>, <-11.7234, 7.4619, 1.9825>, <-10.584, 8.05782, 2.241> }
				triangle { <-10.584, 8.05782, 2.241>, <-8.5063, 8.5588, 1.7998>, <-10.5048, 7.8783, 2.2367> }
				triangle { <-8.5063, 8.5588, 1.7998>, <-10.584, 8.05782, 2.241>, <-9.1464, 8.5551, 1.9816> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-8.4279, 8.5606, 1.777>, <-8.7414, 8.7242, 1.8011>, 0.05906 }
				cylinder { <-8.7414, 8.7242, 1.8011>, <-9.05491, 8.8877, 1.8252>, 0.05906 }
				cylinder { <-9.05491, 8.8877, 1.8252>, <-9.3683, 9.05134, 1.8494>, 0.05906 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-9.3683, 9.05134, 1.8494>, <-9.3892, 9.06981, 1.848>, 0.001395 }
				cylinder { <-9.3892, 9.06981, 1.848>, <-9.4048, 9.09254, 1.8435>, 0.001395 }
				cylinder { <-9.4048, 9.09254, 1.8435>, <-9.4139, 9.1178, 1.8361>, 0.001395 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-9.7794, 9.6329, 1.5531>, <-10.1764, 10.9276, 0.9467>, <-9.4139, 9.1178, 1.8361> }
				triangle { <-9.7794, 9.6329, 1.5531>, <-10.3665, 10.8597, 0.9482>, <-10.1764, 10.9276, 0.9467> }
				triangle { <-10.3665, 10.8597, 0.9482>, <-10.8246, 11.6282, 0.0408>, <-10.1764, 10.9276, 0.9467> }
				triangle { <-10.1764, 10.9276, 0.9467>, <-10.8246, 11.6282, 0.0408>, <-10.6757, 11.6955, -0.001343> }
				triangle { <-10.8246, 11.6282, 0.0408>, <-10.9091, 11.5332, -0.4491>, <-10.6757, 11.6955, -0.001343> }
				triangle { <-10.9091, 11.5332, -0.4491>, <-10.5837, 11.7253, -0.01274>, <-10.6757, 11.6955, -0.001343> }
				triangle { <-10.6757, 11.6955, -0.001343>, <-10.5837, 11.7253, -0.01274>, <-10.1764, 10.9276, 0.9467> }
				triangle { <-10.1764, 10.9276, 0.9467>, <-10.5837, 11.7253, -0.01274>, <-10.00007, 11.00871, 0.9176> }
				triangle { <-10.00007, 11.00871, 0.9176>, <-9.4139, 9.1178, 1.8361>, <-10.1764, 10.9276, 0.9467> }
				triangle { <-9.4139, 9.1178, 1.8361>, <-10.00007, 11.00871, 0.9176>, <-9.45, 9.7396, 1.6021> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-9.3683, 9.05134, 1.8494>, <-9.393, 9.06422, 1.8513>, 0.001395 }
				cylinder { <-9.393, 9.06422, 1.8513>, <-9.4177, 9.0771, 1.8532>, 0.001395 }
				cylinder { <-9.4177, 9.0771, 1.8532>, <-9.4424, 9.08998, 1.8551>, 0.001395 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-10.1158, 9.2407, 1.802>, <-11.404, 9.9652, 1.6706>, <-9.4424, 9.08998, 1.8551> }
				triangle { <-10.1158, 9.2407, 1.802>, <-11.496, 9.7864, 1.688>, <-11.404, 9.9652, 1.6706> }
				triangle { <-11.496, 9.7864, 1.688>, <-12.5974, 10.1117, 1.1359>, <-11.404, 9.9652, 1.6706> }
				triangle { <-11.404, 9.9652, 1.6706>, <-12.5974, 10.1117, 1.1359>, <-12.5476, 10.2656, 1.08772> }
				triangle { <-12.5974, 10.1117, 1.1359>, <-12.7583, 10.02676, 0.6635>, <-12.5476, 10.2656, 1.08772> }
				triangle { <-12.7583, 10.02676, 0.6635>, <-12.5046, 10.3508, 1.06837>, <-12.5476, 10.2656, 1.08772> }
				triangle { <-12.5476, 10.2656, 1.08772>, <-12.5046, 10.3508, 1.06837>, <-11.404, 9.9652, 1.6706> }
				triangle { <-11.404, 9.9652, 1.6706>, <-12.5046, 10.3508, 1.06837>, <-11.3389, 10.1466, 1.6335> }
				triangle { <-11.3389, 10.1466, 1.6335>, <-9.4424, 9.08998, 1.8551>, <-11.404, 9.9652, 1.6706> }
				triangle { <-9.4424, 9.08998, 1.8551>, <-11.3389, 10.1466, 1.6335>, <-9.9327, 9.5381, 1.8172> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <-0.8196, 4.2994, 0.6396>, <-0.8358, 4.3139, 0.6523>, 0.01885 }
		cylinder { <-0.8358, 4.3139, 0.6523>, <-0.852, 4.3284, 0.6649>, 0.01885 }
		cylinder { <-0.852, 4.3284, 0.6649>, <-0.8682, 4.3428, 0.6776>, 0.01885 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.8682, 4.3428, 0.6776>, <-1.1858, 4.6005, 1.01816>, 0.0266 }
			cylinder { <-1.1858, 4.6005, 1.01816>, <-1.4687, 4.8017, 1.4215>, 0.0266 }
			cylinder { <-1.4687, 4.8017, 1.4215>, <-1.7084, 4.9405, 1.8759>, 0.0266 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-1.7084, 4.9405, 1.8759>, <-1.7804, 4.9822, 2.01225>, 0.0266 }
				cylinder { <-1.7804, 4.9822, 2.01225>, <-1.8523, 5.0239, 2.1485>, 0.0266 }
				cylinder { <-1.8523, 5.0239, 2.1485>, <-1.9242, 5.06556, 2.2848>, 0.0266 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-1.9242, 5.06556, 2.2848>, <-1.9256, 5.06798, 2.2898>, 0.0002832 }
				cylinder { <-1.9256, 5.06798, 2.2898>, <-1.9256, 5.07116, 2.2945>, 0.0002832 }
				cylinder { <-1.9256, 5.07116, 2.2945>, <-1.9244, 5.07487, 2.2985>, 0.0002832 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-1.7768, 5.2315, 2.5241>, <-1.6418, 5.587, 3.07386>, <-1.9244, 5.07487, 2.2985> }
				triangle { <-1.7768, 5.2315, 2.5241>, <-1.5547, 5.5869, 3.04762>, <-1.6418, 5.587, 3.07386> }
				triangle { <-1.5547, 5.5869, 3.04762>, <-1.3214, 5.6885, 3.5621>, <-1.6418, 5.587, 3.07386> }
				triangle { <-1.6418, 5.587, 3.07386>, <-1.3214, 5.6885, 3.5621>, <-1.3864, 5.6834, 3.6012> }
				triangle { <-1.3214, 5.6885, 3.5621>, <-1.2264, 5.5429, 3.7097>, <-1.3864, 5.6834, 3.6012> }
				triangle { <-1.2264, 5.5429, 3.7097>, <-1.4272, 5.6797, 3.6169>, <-1.3864, 5.6834, 3.6012> }
				triangle { <-1.3864, 5.6834, 3.6012>, <-1.4272, 5.6797, 3.6169>, <-1.6418, 5.587, 3.07386> }
				triangle { <-1.6418, 5.587, 3.07386>, <-1.4272, 5.6797, 3.6169>, <-1.7211, 5.5866, 3.1129> }
				triangle { <-1.7211, 5.5866, 3.1129>, <-1.9244, 5.07487, 2.2985>, <-1.6418, 5.587, 3.07386> }
				triangle { <-1.9244, 5.07487, 2.2985>, <-1.7211, 5.5866, 3.1129>, <-1.9322, 5.2408, 2.548> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-1.9242, 5.06556, 2.2848>, <-1.9962, 5.1072, 2.4211>, 0.0266 }
				cylinder { <-1.9962, 5.1072, 2.4211>, <-2.06812, 5.1488, 2.5574>, 0.0266 }
				cylinder { <-2.06812, 5.1488, 2.5574>, <-2.14, 5.1905, 2.6938>, 0.0266 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-2.14, 5.1905, 2.6938>, <-2.1436, 5.1909, 2.6981>, 0.0002832 }
				cylinder { <-2.1436, 5.1909, 2.6981>, <-2.1479, 5.1903, 2.7017>, 0.0002832 }
				cylinder { <-2.1479, 5.1903, 2.7017>, <-2.1526, 5.1886, 2.7043>, 0.0002832 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-2.3554, 5.08198, 2.9158>, <-2.8775, 4.7856, 3.2096>, <-2.1526, 5.1886, 2.7043> }
				triangle { <-2.3554, 5.08198, 2.9158>, <-2.846, 4.8176, 3.2887>, <-2.8775, 4.7856, 3.2096> }
				triangle { <-2.846, 4.8176, 3.2887>, <-3.1104, 4.4415, 3.6325>, <-2.8775, 4.7856, 3.2096> }
				triangle { <-2.8775, 4.7856, 3.2096>, <-3.1104, 4.4415, 3.6325>, <-3.138, 4.3981, 3.5766> }
				triangle { <-3.1104, 4.4415, 3.6325>, <-3.02839, 4.2534, 3.732>, <-3.138, 4.3981, 3.5766> }
				triangle { <-3.02839, 4.2534, 3.732>, <-3.151, 4.3783, 3.5396>, <-3.138, 4.3981, 3.5766> }
				triangle { <-3.138, 4.3981, 3.5766>, <-3.151, 4.3783, 3.5396>, <-2.8775, 4.7856, 3.2096> }
				triangle { <-2.8775, 4.7856, 3.2096>, <-3.151, 4.3783, 3.5396>, <-2.9125, 4.7428, 3.1406> }
				triangle { <-2.9125, 4.7428, 3.1406>, <-2.1526, 5.1886, 2.7043>, <-2.8775, 4.7856, 3.2096> }
				triangle { <-2.1526, 5.1886, 2.7043>, <-2.9125, 4.7428, 3.1406>, <-2.4092, 5.04904, 2.7715> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-2.14, 5.1905, 2.6938>, <-2.2119, 5.2322, 2.8301>, 0.0266 }
				cylinder { <-2.2119, 5.2322, 2.8301>, <-2.2839, 5.2738, 2.9664>, 0.0266 }
				cylinder { <-2.2839, 5.2738, 2.9664>, <-2.3558, 5.3155, 3.1027>, 0.0266 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-2.3558, 5.3155, 3.1027>, <-2.3571, 5.3179, 3.1076>, 0.0002832 }
				cylinder { <-2.3571, 5.3179, 3.1076>, <-2.3572, 5.3211, 3.1123>, 0.0002832 }
				cylinder { <-2.3572, 5.3211, 3.1123>, <-2.356, 5.3248, 3.1164>, 0.0002832 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-2.2084, 5.4815, 3.342>, <-2.07341, 5.837, 3.8917>, <-2.356, 5.3248, 3.1164> }
				triangle { <-2.2084, 5.4815, 3.342>, <-1.9863, 5.8369, 3.8654>, <-2.07341, 5.837, 3.8917> }
				triangle { <-1.9863, 5.8369, 3.8654>, <-1.753, 5.9385, 4.38>, <-2.07341, 5.837, 3.8917> }
				triangle { <-2.07341, 5.837, 3.8917>, <-1.753, 5.9385, 4.38>, <-1.818, 5.9334, 4.4191> }
				triangle { <-1.753, 5.9385, 4.38>, <-1.658, 5.7929, 4.5275>, <-1.818, 5.9334, 4.4191> }
				triangle { <-1.658, 5.7929, 4.5275>, <-1.8588, 5.9297, 4.4348>, <-1.818, 5.9334, 4.4191> }
				triangle { <-1.818, 5.9334, 4.4191>, <-1.8588, 5.9297, 4.4348>, <-2.07341, 5.837, 3.8917> }
				triangle { <-2.07341, 5.837, 3.8917>, <-1.8588, 5.9297, 4.4348>, <-2.1527, 5.8366, 3.9308> }
				triangle { <-2.1527, 5.8366, 3.9308>, <-2.356, 5.3248, 3.1164>, <-2.07341, 5.837, 3.8917> }
				triangle { <-2.356, 5.3248, 3.1164>, <-2.1527, 5.8366, 3.9308>, <-2.3638, 5.4907, 3.3659> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-2.3558, 5.3155, 3.1027>, <-2.4277, 5.3571, 3.239>, 0.0266 }
				cylinder { <-2.4277, 5.3571, 3.239>, <-2.4996, 5.3988, 3.3753>, 0.0266 }
				cylinder { <-2.4996, 5.3988, 3.3753>, <-2.5716, 5.4405, 3.5116>, 0.0266 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-2.5716, 5.4405, 3.5116>, <-2.5751, 5.4409, 3.516>, 0.0002832 }
				cylinder { <-2.5751, 5.4409, 3.516>, <-2.5795, 5.4403, 3.5196>, 0.0002832 }
				cylinder { <-2.5795, 5.4403, 3.5196>, <-2.5842, 5.4386, 3.5222>, 0.0002832 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-2.787, 5.3319, 3.7337>, <-3.3091, 5.03559, 4.02754>, <-2.5842, 5.4386, 3.5222> }
				triangle { <-2.787, 5.3319, 3.7337>, <-3.2776, 5.06764, 4.1066>, <-3.3091, 5.03559, 4.02754> }
				triangle { <-3.2776, 5.06764, 4.1066>, <-3.5419, 4.6915, 4.4504>, <-3.3091, 5.03559, 4.02754> }
				triangle { <-3.3091, 5.03559, 4.02754>, <-3.5419, 4.6915, 4.4504>, <-3.5696, 4.648, 4.3945> }
				triangle { <-3.5419, 4.6915, 4.4504>, <-3.4599, 4.5034, 4.5498>, <-3.5696, 4.648, 4.3945> }
				triangle { <-3.4599, 4.5034, 4.5498>, <-3.5826, 4.6282, 4.3575>, <-3.5696, 4.648, 4.3945> }
				triangle { <-3.5696, 4.648, 4.3945>, <-3.5826, 4.6282, 4.3575>, <-3.3091, 5.03559, 4.02754> }
				triangle { <-3.3091, 5.03559, 4.02754>, <-3.5826, 4.6282, 4.3575>, <-3.3441, 4.9928, 3.9585> }
				triangle { <-3.3441, 4.9928, 3.9585>, <-2.5842, 5.4386, 3.5222>, <-3.3091, 5.03559, 4.02754> }
				triangle { <-2.5842, 5.4386, 3.5222>, <-3.3441, 4.9928, 3.9585>, <-2.8408, 5.299, 3.5893> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-2.5716, 5.4405, 3.5116>, <-2.6435, 5.4821, 3.6479>, 0.0266 }
				cylinder { <-2.6435, 5.4821, 3.6479>, <-2.7154, 5.5238, 3.7842>, 0.0266 }
				cylinder { <-2.7154, 5.5238, 3.7842>, <-2.7874, 5.5655, 3.9206>, 0.0266 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-2.7874, 5.5655, 3.9206>, <-2.7887, 5.5679, 3.9255>, 0.0002832 }
				cylinder { <-2.7887, 5.5679, 3.9255>, <-2.7888, 5.571, 3.9302>, 0.0002832 }
				cylinder { <-2.7888, 5.571, 3.9302>, <-2.7875, 5.5748, 3.9343>, 0.0002832 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-2.6399, 5.7314, 4.1598>, <-2.5049, 6.08699, 4.7096>, <-2.7875, 5.5748, 3.9343> }
				triangle { <-2.6399, 5.7314, 4.1598>, <-2.4179, 6.08686, 4.6833>, <-2.5049, 6.08699, 4.7096> }
				triangle { <-2.4179, 6.08686, 4.6833>, <-2.1845, 6.1885, 5.1979>, <-2.5049, 6.08699, 4.7096> }
				triangle { <-2.5049, 6.08699, 4.7096>, <-2.1845, 6.1885, 5.1979>, <-2.2495, 6.1833, 5.2369> }
				triangle { <-2.1845, 6.1885, 5.1979>, <-2.08958, 6.04287, 5.3454>, <-2.2495, 6.1833, 5.2369> }
				triangle { <-2.08958, 6.04287, 5.3454>, <-2.2903, 6.1796, 5.2527>, <-2.2495, 6.1833, 5.2369> }
				triangle { <-2.2495, 6.1833, 5.2369>, <-2.2903, 6.1796, 5.2527>, <-2.5049, 6.08699, 4.7096> }
				triangle { <-2.5049, 6.08699, 4.7096>, <-2.2903, 6.1796, 5.2527>, <-2.5842, 6.08657, 4.7487> }
				triangle { <-2.5842, 6.08657, 4.7487>, <-2.7875, 5.5748, 3.9343>, <-2.5049, 6.08699, 4.7096> }
				triangle { <-2.7875, 5.5748, 3.9343>, <-2.5842, 6.08657, 4.7487>, <-2.7954, 5.7407, 4.1838> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-2.7874, 5.5655, 3.9206>, <-2.8593, 5.6071, 4.05691>, 0.0266 }
				cylinder { <-2.8593, 5.6071, 4.05691>, <-2.9312, 5.6488, 4.1932>, 0.0266 }
				cylinder { <-2.9312, 5.6488, 4.1932>, <-3.003195, 5.6904, 4.3295>, 0.0266 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-3.003195, 5.6904, 4.3295>, <-3.006759, 5.6909, 4.3339>, 0.0002832 }
				cylinder { <-3.006759, 5.6909, 4.3339>, <-3.01107, 5.6902, 4.3375>, 0.0002832 }
				cylinder { <-3.01107, 5.6902, 4.3375>, <-3.01583, 5.6885, 4.3401>, 0.0002832 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-3.2185, 5.5819, 4.5515>, <-3.7407, 5.2855, 4.8454>, <-3.01583, 5.6885, 4.3401> }
				triangle { <-3.2185, 5.5819, 4.5515>, <-3.7092, 5.3176, 4.9244>, <-3.7407, 5.2855, 4.8454> }
				triangle { <-3.7092, 5.3176, 4.9244>, <-3.9735, 4.9414, 5.2682>, <-3.7407, 5.2855, 4.8454> }
				triangle { <-3.7407, 5.2855, 4.8454>, <-3.9735, 4.9414, 5.2682>, <-4.001201, 4.898, 5.2123> }
				triangle { <-3.9735, 4.9414, 5.2682>, <-3.8915, 4.7533, 5.3677>, <-4.001201, 4.898, 5.2123> }
				triangle { <-3.8915, 4.7533, 5.3677>, <-4.01422, 4.8782, 5.1754>, <-4.001201, 4.898, 5.2123> }
				triangle { <-4.001201, 4.898, 5.2123>, <-4.01422, 4.8782, 5.1754>, <-3.7407, 5.2855, 4.8454> }
				triangle { <-3.7407, 5.2855, 4.8454>, <-4.01422, 4.8782, 5.1754>, <-3.7757, 5.2428, 4.7763> }
				triangle { <-3.7757, 5.2428, 4.7763>, <-3.01583, 5.6885, 4.3401>, <-3.7407, 5.2855, 4.8454> }
				triangle { <-3.01583, 5.6885, 4.3401>, <-3.7757, 5.2428, 4.7763>, <-3.2724, 5.5489, 4.4072> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-3.003195, 5.6904, 4.3295>, <-3.005747, 5.6919, 4.3343>, 0.0002832 }
				cylinder { <-3.005747, 5.6919, 4.3343>, <-3.008299, 5.6934, 4.3392>, 0.0002832 }
				cylinder { <-3.008299, 5.6934, 4.3392>, <-3.01085, 5.6949, 4.344>, 0.0002832 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-3.06803, 5.7549, 4.6446>, <-3.3683, 5.8249, 5.2376>, <-3.01085, 5.6949, 4.344> }
				triangle { <-3.06803, 5.7549, 4.6446>, <-3.2897, 5.8582, 5.2689>, <-3.3683, 5.8249, 5.2376> }
				triangle { <-3.2897, 5.8582, 5.2689>, <-3.381, 5.7541, 5.826>, <-3.3683, 5.8249, 5.2376> }
				triangle { <-3.3683, 5.8249, 5.2376>, <-3.381, 5.7541, 5.826>, <-3.4457, 5.7155, 5.8161> }
				triangle { <-3.381, 5.7541, 5.826>, <-3.3042, 5.5833, 5.9561>, <-3.4457, 5.7155, 5.8161> }
				triangle { <-3.3042, 5.5833, 5.9561>, <-3.4823, 5.6951, 5.8031>, <-3.4457, 5.7155, 5.8161> }
				triangle { <-3.4457, 5.7155, 5.8161>, <-3.4823, 5.6951, 5.8031>, <-3.3683, 5.8249, 5.2376> }
				triangle { <-3.3683, 5.8249, 5.2376>, <-3.4823, 5.6951, 5.8031>, <-3.4463, 5.7868, 5.2206> }
				triangle { <-3.4463, 5.7868, 5.2206>, <-3.01085, 5.6949, 4.344>, <-3.3683, 5.8249, 5.2376> }
				triangle { <-3.01085, 5.6949, 4.344>, <-3.4463, 5.7868, 5.2206>, <-3.2025, 5.7139, 4.5736> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <0.0, 3.2338, 0.0>, <0.0, 3.5671, 0.0>, 0.25 }
		cylinder { <0.0, 3.5671, 0.0>, <0.0, 3.9004, 0.0>, 0.25 }
		cylinder { <0.0, 3.9004, 0.0>, <0.0, 4.2338, 0.0>, 0.25 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 4.2338, 0.0>, <1.6944, 14.02557, 0.1249>, 0.4969 }
			cylinder { <1.6944, 14.02557, 0.1249>, <5.03338, 23.3826, 0.3712>, 0.4969 }
			cylinder { <5.03338, 23.3826, 0.3712>, <9.9185, 32.02964, 0.7316>, 0.4969 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <9.9185, 32.02964, 0.7316>, <11.3841, 34.6237, 0.8397>, 0.4969 }
				cylinder { <11.3841, 34.6237, 0.8397>, <12.8496, 37.2178, 0.9478>, 0.4969 }
				cylinder { <12.8496, 37.2178, 0.9478>, <14.3152, 39.8119, 1.05595>, 0.4969 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <14.3152, 39.8119, 1.05595>, <15.2897, 41.4683, 0.5995>, 0.09876 }
				cylinder { <15.2897, 41.4683, 0.5995>, <16.1973, 42.9424, -0.3517>, 0.09876 }
				cylinder { <16.1973, 42.9424, -0.3517>, <16.9721, 44.1275, -1.729>, 0.09876 }
				texture {fol5}}
			mesh { // leaf
				triangle { <20.05888, 46.1545, -6.2301>, <26.6362, 53.5156, -13.8696>, <16.9721, 44.1275, -1.729> }
				triangle { <20.05888, 46.1545, -6.2301>, <26.6682, 52.2197, -14.9667>, <26.6362, 53.5156, -13.8696> }
				triangle { <26.6682, 52.2197, -14.9667>, <35.2656, 55.3378, -20.56>, <26.6362, 53.5156, -13.8696> }
				triangle { <26.6362, 53.5156, -13.8696>, <35.2656, 55.3378, -20.56>, <35.5958, 56.4318, -19.718> }
				triangle { <35.2656, 55.3378, -20.56>, <39.3034, 54.01399, -20.2829>, <35.5958, 56.4318, -19.718> }
				triangle { <39.3034, 54.01399, -20.2829>, <35.6661, 57.03078, -19.1631>, <35.5958, 56.4318, -19.718> }
				triangle { <35.5958, 56.4318, -19.718>, <35.6661, 57.03078, -19.1631>, <26.6362, 53.5156, -13.8696> }
				triangle { <26.6362, 53.5156, -13.8696>, <35.6661, 57.03078, -19.1631>, <26.8547, 54.8328, -12.8984> }
				triangle { <26.8547, 54.8328, -12.8984>, <16.9721, 44.1275, -1.729>, <26.6362, 53.5156, -13.8696> }
				triangle { <16.9721, 44.1275, -1.729>, <26.8547, 54.8328, -12.8984>, <19.5624, 48.3493, -4.3358> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <14.3152, 39.8119, 1.05595>, <15.7807, 42.406, 1.164>, 0.4969 }
				cylinder { <15.7807, 42.406, 1.164>, <17.2463, 45.00009, 1.2721>, 0.4969 }
				cylinder { <17.2463, 45.00009, 1.2721>, <18.7118, 47.5941, 1.3802>, 0.4969 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <18.7118, 47.5941, 1.3802>, <19.6089, 49.2506, 1.9747>, 0.09876 }
				cylinder { <19.6089, 49.2506, 1.9747>, <20.367, 50.7247, 3.04889>, 0.09876 }
				cylinder { <20.367, 50.7247, 3.04889>, <20.9313, 51.9098, 4.525>, 0.09876 }
				texture {fol5}}
			mesh { // leaf
				triangle { <24.1327, 55.1893, 8.1156>, <28.5478, 61.04746, 18.2151>, <20.9313, 51.9098, 4.525> }
				triangle { <24.1327, 55.1893, 8.1156>, <29.7119, 61.7555, 17.2016>, <28.5478, 61.04746, 18.2151> }
				triangle { <29.7119, 61.7555, 17.2016>, <36.9105, 64.1221, 24.7846>, <28.5478, 61.04746, 18.2151> }
				triangle { <28.5478, 61.04746, 18.2151>, <36.9105, 64.1221, 24.7846>, <36.2289, 63.4625, 25.8407> }
				triangle { <36.9105, 64.1221, 24.7846>, <40.4602, 62.04676, 25.8918>, <36.2289, 63.4625, 25.8407> }
				triangle { <40.4602, 62.04676, 25.8918>, <35.7331, 63.05954, 26.3538>, <36.2289, 63.4625, 25.8407> }
				triangle { <36.2289, 63.4625, 25.8407>, <35.7331, 63.05954, 26.3538>, <28.5478, 61.04746, 18.2151> }
				triangle { <28.5478, 61.04746, 18.2151>, <35.7331, 63.05954, 26.3538>, <27.6129, 60.3606, 19.3899> }
				triangle { <27.6129, 60.3606, 19.3899>, <20.9313, 51.9098, 4.525>, <28.5478, 61.04746, 18.2151> }
				triangle { <20.9313, 51.9098, 4.525>, <27.6129, 60.3606, 19.3899>, <21.8176, 54.1275, 9.587> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <18.7118, 47.5941, 1.3802>, <20.1774, 50.1882, 1.4883>, 0.4969 }
				cylinder { <20.1774, 50.1882, 1.4883>, <21.6429, 52.7823, 1.5964>, 0.4969 }
				cylinder { <21.6429, 52.7823, 1.5964>, <23.1085, 55.3764, 1.7045>, 0.4969 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <23.1085, 55.3764, 1.7045>, <24.08309, 57.03287, 1.2482>, 0.09876 }
				cylinder { <24.08309, 57.03287, 1.2482>, <24.9906, 58.507, 0.2968>, 0.09876 }
				cylinder { <24.9906, 58.507, 0.2968>, <25.7654, 59.6921, -1.08045>, 0.09876 }
				texture {fol5}}
			mesh { // leaf
				triangle { <28.8521, 61.719, -5.5814>, <35.4295, 69.08023, -13.221>, <25.7654, 59.6921, -1.08045> }
				triangle { <28.8521, 61.719, -5.5814>, <35.4615, 67.7843, -14.318>, <35.4295, 69.08023, -13.221> }
				triangle { <35.4615, 67.7843, -14.318>, <44.05894, 70.9023, -19.9114>, <35.4295, 69.08023, -13.221> }
				triangle { <35.4295, 69.08023, -13.221>, <44.05894, 70.9023, -19.9114>, <44.3891, 71.9963, -19.06941> }
				triangle { <44.05894, 70.9023, -19.9114>, <48.09675, 69.5785, -19.6343>, <44.3891, 71.9963, -19.06941> }
				triangle { <48.09675, 69.5785, -19.6343>, <44.4594, 72.5953, -18.5145>, <44.3891, 71.9963, -19.06941> }
				triangle { <44.3891, 71.9963, -19.06941>, <44.4594, 72.5953, -18.5145>, <35.4295, 69.08023, -13.221> }
				triangle { <35.4295, 69.08023, -13.221>, <44.4594, 72.5953, -18.5145>, <35.648, 70.3974, -12.2498> }
				triangle { <35.648, 70.3974, -12.2498>, <25.7654, 59.6921, -1.08045>, <35.4295, 69.08023, -13.221> }
				triangle { <25.7654, 59.6921, -1.08045>, <35.648, 70.3974, -12.2498>, <28.3557, 63.9138, -3.6872> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <23.1085, 55.3764, 1.7045>, <24.574, 57.9705, 1.8126>, 0.4969 }
				cylinder { <24.574, 57.9705, 1.8126>, <26.03963, 60.5646, 1.9207>, 0.4969 }
				cylinder { <26.03963, 60.5646, 1.9207>, <27.5051, 63.1587, 2.0289>, 0.4969 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <27.5051, 63.1587, 2.0289>, <28.4022, 64.8151, 2.6233>, 0.09876 }
				cylinder { <28.4022, 64.8151, 2.6233>, <29.1603, 66.2893, 3.6975>, 0.09876 }
				cylinder { <29.1603, 66.2893, 3.6975>, <29.7246, 67.4744, 5.1736>, 0.09876 }
				texture {fol5}}
			mesh { // leaf
				triangle { <32.926, 70.7538, 8.7642>, <37.3411, 76.6119, 18.8637>, <29.7246, 67.4744, 5.1736> }
				triangle { <32.926, 70.7538, 8.7642>, <38.5053, 77.32, 17.8502>, <37.3411, 76.6119, 18.8637> }
				triangle { <38.5053, 77.32, 17.8502>, <45.7038, 79.6866, 25.4333>, <37.3411, 76.6119, 18.8637> }
				triangle { <37.3411, 76.6119, 18.8637>, <45.7038, 79.6866, 25.4333>, <45.02227, 79.02711, 26.4893> }
				triangle { <45.7038, 79.6866, 25.4333>, <49.2535, 77.6113, 26.5404>, <45.02227, 79.02711, 26.4893> }
				triangle { <49.2535, 77.6113, 26.5404>, <44.5264, 78.624, 27.00249>, <45.02227, 79.02711, 26.4893> }
				triangle { <45.02227, 79.02711, 26.4893>, <44.5264, 78.624, 27.00249>, <37.3411, 76.6119, 18.8637> }
				triangle { <37.3411, 76.6119, 18.8637>, <44.5264, 78.624, 27.00249>, <36.4062, 75.9251, 20.03857> }
				triangle { <36.4062, 75.9251, 20.03857>, <29.7246, 67.4744, 5.1736>, <37.3411, 76.6119, 18.8637> }
				triangle { <29.7246, 67.4744, 5.1736>, <36.4062, 75.9251, 20.03857>, <30.6109, 69.6921, 10.2357> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <27.5051, 63.1587, 2.0289>, <28.9707, 65.7528, 2.137>, 0.4969 }
				cylinder { <28.9707, 65.7528, 2.137>, <30.4362, 68.3469, 2.2451>, 0.4969 }
				cylinder { <30.4362, 68.3469, 2.2451>, <31.9018, 70.9409, 2.3532>, 0.4969 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <31.9018, 70.9409, 2.3532>, <32.8764, 72.5974, 1.8968>, 0.09876 }
				cylinder { <32.8764, 72.5974, 1.8968>, <33.7839, 74.07158, 0.9455>, 0.09876 }
				cylinder { <33.7839, 74.07158, 0.9455>, <34.5587, 75.2566, -0.4318>, 0.09876 }
				texture {fol5}}
			mesh { // leaf
				triangle { <37.6455, 77.2836, -4.9328>, <44.2228, 84.6447, -12.5724>, <34.5587, 75.2566, -0.4318> }
				triangle { <37.6455, 77.2836, -4.9328>, <44.2548, 83.3488, -13.6694>, <44.2228, 84.6447, -12.5724> }
				triangle { <44.2548, 83.3488, -13.6694>, <52.8522, 86.4669, -19.2627>, <44.2228, 84.6447, -12.5724> }
				triangle { <44.2228, 84.6447, -12.5724>, <52.8522, 86.4669, -19.2627>, <53.1825, 87.5609, -18.4207> }
				triangle { <52.8522, 86.4669, -19.2627>, <56.89, 85.143, -18.9856>, <53.1825, 87.5609, -18.4207> }
				triangle { <56.89, 85.143, -18.9856>, <53.2527, 88.1598, -17.8658>, <53.1825, 87.5609, -18.4207> }
				triangle { <53.1825, 87.5609, -18.4207>, <53.2527, 88.1598, -17.8658>, <44.2228, 84.6447, -12.5724> }
				triangle { <44.2228, 84.6447, -12.5724>, <53.2527, 88.1598, -17.8658>, <44.4413, 85.9619, -11.6012> }
				triangle { <44.4413, 85.9619, -11.6012>, <34.5587, 75.2566, -0.4318>, <44.2228, 84.6447, -12.5724> }
				triangle { <34.5587, 75.2566, -0.4318>, <44.4413, 85.9619, -11.6012>, <37.149, 79.4783, -3.03859> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <31.9018, 70.9409, 2.3532>, <33.3673, 73.535, 2.4613>, 0.4969 }
				cylinder { <33.3673, 73.535, 2.4613>, <34.8329, 76.1291, 2.5694>, 0.4969 }
				cylinder { <34.8329, 76.1291, 2.5694>, <36.2984, 78.7232, 2.6775>, 0.4969 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <36.2984, 78.7232, 2.6775>, <37.1955, 80.3797, 3.2719>, 0.09876 }
				cylinder { <37.1955, 80.3797, 3.2719>, <37.9536, 81.8538, 4.3461>, 0.09876 }
				cylinder { <37.9536, 81.8538, 4.3461>, <38.5179, 83.03896, 5.8222>, 0.09876 }
				texture {fol5}}
			mesh { // leaf
				triangle { <41.7193, 86.3183, 9.4129>, <46.1344, 92.1765, 19.5124>, <38.5179, 83.03896, 5.8222> }
				triangle { <41.7193, 86.3183, 9.4129>, <47.2986, 92.8846, 18.4988>, <46.1344, 92.1765, 19.5124> }
				triangle { <47.2986, 92.8846, 18.4988>, <54.4971, 95.2512, 26.08194>, <46.1344, 92.1765, 19.5124> }
				triangle { <46.1344, 92.1765, 19.5124>, <54.4971, 95.2512, 26.08194>, <53.8155, 94.5916, 27.1379> }
				triangle { <54.4971, 95.2512, 26.08194>, <58.04687, 93.1758, 27.189>, <53.8155, 94.5916, 27.1379> }
				triangle { <58.04687, 93.1758, 27.189>, <53.3197, 94.1886, 27.6511>, <53.8155, 94.5916, 27.1379> }
				triangle { <53.8155, 94.5916, 27.1379>, <53.3197, 94.1886, 27.6511>, <46.1344, 92.1765, 19.5124> }
				triangle { <46.1344, 92.1765, 19.5124>, <53.3197, 94.1886, 27.6511>, <45.1995, 91.4897, 20.6872> }
				triangle { <45.1995, 91.4897, 20.6872>, <38.5179, 83.03896, 5.8222>, <46.1344, 92.1765, 19.5124> }
				triangle { <38.5179, 83.03896, 5.8222>, <45.1995, 91.4897, 20.6872>, <39.4042, 85.2566, 10.8843> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <36.2984, 78.7232, 2.6775>, <37.2694, 80.4419, 2.7491>, 0.09876 }
				cylinder { <37.2694, 80.4419, 2.7491>, <38.2404, 82.1606, 2.8207>, 0.09876 }
				cylinder { <38.2404, 82.1606, 2.8207>, <39.2114, 83.8793, 2.8924>, 0.09876 }
				texture {fol5}}
			mesh { // leaf
				triangle { <43.2275, 88.03584, 2.1921>, <50.5771, 97.9743, 3.9301>, <39.2114, 83.8793, 2.8924> }
				triangle { <43.2275, 88.03584, 2.1921>, <51.2115, 97.6804, 2.3824>, <50.5771, 97.9743, 3.9301> }
				triangle { <51.2115, 97.6804, 2.3824>, <60.4912, 102.8925, 3.6649>, <50.5771, 97.9743, 3.9301> }
				triangle { <50.5771, 97.9743, 3.9301>, <60.4912, 102.8925, 3.6649>, <60.3141, 103.1634, 5.04694> }
				triangle { <60.4912, 102.8925, 3.6649>, <64.3623, 101.354, 4.5483>, <60.3141, 103.1634, 5.04694> }
				triangle { <64.3623, 101.354, 4.5483>, <60.08317, 103.2614, 5.8271>, <60.3141, 103.1634, 5.04694> }
				triangle { <60.3141, 103.1634, 5.04694>, <60.08317, 103.2614, 5.8271>, <50.5771, 97.9743, 3.9301> }
				triangle { <50.5771, 97.9743, 3.9301>, <60.08317, 103.2614, 5.8271>, <50.2129, 98.3432, 5.4976> }
				triangle { <50.2129, 98.3432, 5.4976>, <39.2114, 83.8793, 2.8924>, <50.5771, 97.9743, 3.9301> }
				triangle { <39.2114, 83.8793, 2.8924>, <50.2129, 98.3432, 5.4976>, <41.7324, 88.5486, 4.6727> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <0.0, 4.2338, 0.0>, <0.05853, 4.4115, 0.004318>, 0.1403 }
		cylinder { <0.05853, 4.4115, 0.004318>, <0.1697, 4.5618, 0.01251>, 0.1403 }
		cylinder { <0.1697, 4.5618, 0.01251>, <0.3222, 4.6695, 0.02377>, 0.1403 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.3222, 4.6695, 0.02377>, <3.4076, 6.1327, 0.2513>, 0.1711 }
			cylinder { <3.4076, 6.1327, 0.2513>, <6.6969, 7.04554, 0.494>, 0.1711 }
			cylinder { <6.6969, 7.04554, 0.494>, <10.09357, 7.3809, 0.7445>, 0.1711 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <10.09357, 7.3809, 0.7445>, <11.1125, 7.4816, 0.8197>, 0.1711 }
				cylinder { <11.1125, 7.4816, 0.8197>, <12.1315, 7.5822, 0.8948>, 0.1711 }
				cylinder { <12.1315, 7.5822, 0.8948>, <13.1505, 7.6828, 0.97>, 0.1711 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <13.1505, 7.6828, 0.97>, <13.3791, 7.705, 0.9242>, 0.01171 }
				cylinder { <13.3791, 7.705, 0.9242>, <13.5874, 7.7247, 0.8188>, 0.01171 }
				cylinder { <13.5874, 7.7247, 0.8188>, <13.7602, 7.7405, 0.6615>, 0.01171 }
				texture {fol5}}
			mesh { // leaf
				triangle { <14.992, 7.3689, -0.876>, <18.4502, 7.1399, -3.4187>, <13.7602, 7.7405, 0.6615> }
				triangle { <14.992, 7.3689, -0.876>, <18.1044, 6.8967, -3.8228>, <18.4502, 7.1399, -3.4187> }
				triangle { <18.1044, 6.8967, -3.8228>, <20.7514, 5.2168, -5.7721>, <18.4502, 7.1399, -3.4187> }
				triangle { <18.4502, 7.1399, -3.4187>, <20.7514, 5.2168, -5.7721>, <21.1153, 5.3236, -5.4637> }
				triangle { <20.7514, 5.2168, -5.7721>, <21.1806, 3.8149, -5.7476>, <21.1153, 5.3236, -5.4637> }
				triangle { <21.1806, 3.8149, -5.7476>, <21.2915, 5.4111, -5.2614>, <21.1153, 5.3236, -5.4637> }
				triangle { <21.1153, 5.3236, -5.4637>, <21.2915, 5.4111, -5.2614>, <18.4502, 7.1399, -3.4187> }
				triangle { <18.4502, 7.1399, -3.4187>, <21.2915, 5.4111, -5.2614>, <18.8531, 7.3197, -3.06016> }
				triangle { <18.8531, 7.3197, -3.06016>, <13.7602, 7.7405, 0.6615>, <18.4502, 7.1399, -3.4187> }
				triangle { <13.7602, 7.7405, 0.6615>, <18.8531, 7.3197, -3.06016>, <15.4892, 7.9043, -0.1744> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <13.1505, 7.6828, 0.97>, <14.1694, 7.7835, 1.0452>, 0.1711 }
				cylinder { <14.1694, 7.7835, 1.0452>, <15.1884, 7.8841, 1.1203>, 0.1711 }
				cylinder { <15.1884, 7.8841, 1.1203>, <16.2074, 7.9847, 1.1955>, 0.1711 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <16.2074, 7.9847, 1.1955>, <16.4268, 8.006907, 1.2743>, 0.01171 }
				cylinder { <16.4268, 8.006907, 1.2743>, <16.6174, 8.0266, 1.4091>, 0.01171 }
				cylinder { <16.6174, 8.0266, 1.4091>, <16.7652, 8.04243, 1.5901>, 0.01171 }
				texture {fol5}}
			mesh { // leaf
				triangle { <18.2849, 7.7194, 2.8574>, <20.7004, 7.4321, 6.4013>, <16.7652, 8.04243, 1.5901> }
				triangle { <18.2849, 7.7194, 2.8574>, <21.1419, 7.2666, 6.05532>, <20.7004, 7.4321, 6.4013> }
				triangle { <21.1419, 7.2666, 6.05532>, <23.1582, 5.5576, 8.6325>, <20.7004, 7.4321, 6.4013> }
				triangle { <20.7004, 7.4321, 6.4013>, <23.1582, 5.5576, 8.6325>, <22.826, 5.5963, 8.9889> }
				triangle { <23.1582, 5.5576, 8.6325>, <23.2702, 4.1265, 8.9318>, <22.826, 5.5963, 8.9889> }
				triangle { <23.2702, 4.1265, 8.9318>, <22.6086, 5.645, 9.1622>, <22.826, 5.5963, 8.9889> }
				triangle { <22.826, 5.5963, 8.9889>, <22.6086, 5.645, 9.1622>, <20.7004, 7.4321, 6.4013> }
				triangle { <20.7004, 7.4321, 6.4013>, <22.6086, 5.645, 9.1622>, <20.3089, 7.5341, 6.8007> }
				triangle { <20.3089, 7.5341, 6.8007>, <16.7652, 8.04243, 1.5901>, <20.7004, 7.4321, 6.4013> }
				triangle { <16.7652, 8.04243, 1.5901>, <20.3089, 7.5341, 6.8007>, <17.5101, 8.1284, 3.3657> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <16.2074, 7.9847, 1.1955>, <17.2263, 8.08541, 1.2706>, 0.1711 }
				cylinder { <17.2263, 8.08541, 1.2706>, <18.2453, 8.186, 1.3458>, 0.1711 }
				cylinder { <18.2453, 8.186, 1.3458>, <19.2643, 8.2866, 1.421>, 0.1711 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <19.2643, 8.2866, 1.421>, <19.493, 8.3088, 1.3752>, 0.01171 }
				cylinder { <19.493, 8.3088, 1.3752>, <19.7012, 8.3284, 1.2698>, 0.01171 }
				cylinder { <19.7012, 8.3284, 1.2698>, <19.874, 8.3443, 1.1124>, 0.01171 }
				texture {fol5}}
			mesh { // leaf
				triangle { <21.1059, 7.9727, -0.425>, <24.564, 7.7437, -2.9677>, <19.874, 8.3443, 1.1124> }
				triangle { <21.1059, 7.9727, -0.425>, <24.2183, 7.5005, -3.3718>, <24.564, 7.7437, -2.9677> }
				triangle { <24.2183, 7.5005, -3.3718>, <26.8653, 5.8206, -5.3211>, <24.564, 7.7437, -2.9677> }
				triangle { <24.564, 7.7437, -2.9677>, <26.8653, 5.8206, -5.3211>, <27.2292, 5.9274, -5.01275> }
				triangle { <26.8653, 5.8206, -5.3211>, <27.2944, 4.4187, -5.2966>, <27.2292, 5.9274, -5.01275> }
				triangle { <27.2944, 4.4187, -5.2966>, <27.4054, 6.01499, -4.8104>, <27.2292, 5.9274, -5.01275> }
				triangle { <27.2292, 5.9274, -5.01275>, <27.4054, 6.01499, -4.8104>, <24.564, 7.7437, -2.9677> }
				triangle { <24.564, 7.7437, -2.9677>, <27.4054, 6.01499, -4.8104>, <24.967, 7.9235, -2.6091> }
				triangle { <24.967, 7.9235, -2.6091>, <19.874, 8.3443, 1.1124>, <24.564, 7.7437, -2.9677> }
				triangle { <19.874, 8.3443, 1.1124>, <24.967, 7.9235, -2.6091>, <21.603, 8.5081, 0.2765> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <19.2643, 8.2866, 1.421>, <20.2833, 8.3873, 1.4961>, 0.1711 }
				cylinder { <20.2833, 8.3873, 1.4961>, <21.3022, 8.4879, 1.5713>, 0.1711 }
				cylinder { <21.3022, 8.4879, 1.5713>, <22.3212, 8.5885, 1.6465>, 0.1711 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <22.3212, 8.5885, 1.6465>, <22.5407, 8.6107, 1.7253>, 0.01171 }
				cylinder { <22.5407, 8.6107, 1.7253>, <22.7312, 8.6303, 1.8601>, 0.01171 }
				cylinder { <22.7312, 8.6303, 1.8601>, <22.8791, 8.6462, 2.04117>, 0.01171 }
				texture {fol5}}
			mesh { // leaf
				triangle { <24.3987, 8.3232, 3.3084>, <26.8143, 8.03596, 6.8523>, <22.8791, 8.6462, 2.04117> }
				triangle { <24.3987, 8.3232, 3.3084>, <27.2557, 7.8704, 6.5063>, <26.8143, 8.03596, 6.8523> }
				triangle { <27.2557, 7.8704, 6.5063>, <29.272, 6.1614, 9.0835>, <26.8143, 8.03596, 6.8523> }
				triangle { <26.8143, 8.03596, 6.8523>, <29.272, 6.1614, 9.0835>, <28.9398, 6.2001, 9.4399> }
				triangle { <29.272, 6.1614, 9.0835>, <29.3841, 4.7303, 9.3828>, <28.9398, 6.2001, 9.4399> }
				triangle { <29.3841, 4.7303, 9.3828>, <28.7224, 6.2488, 9.6132>, <28.9398, 6.2001, 9.4399> }
				triangle { <28.9398, 6.2001, 9.4399>, <28.7224, 6.2488, 9.6132>, <26.8143, 8.03596, 6.8523> }
				triangle { <26.8143, 8.03596, 6.8523>, <28.7224, 6.2488, 9.6132>, <26.4227, 8.1379, 7.2517> }
				triangle { <26.4227, 8.1379, 7.2517>, <22.8791, 8.6462, 2.04117>, <26.8143, 8.03596, 6.8523> }
				triangle { <22.8791, 8.6462, 2.04117>, <26.4227, 8.1379, 7.2517>, <23.6239, 8.7322, 3.8167> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <22.3212, 8.5885, 1.6465>, <23.3402, 8.6892, 1.7216>, 0.1711 }
				cylinder { <23.3402, 8.6892, 1.7216>, <24.3592, 8.7898, 1.7968>, 0.1711 }
				cylinder { <24.3592, 8.7898, 1.7968>, <25.3781, 8.8904, 1.872>, 0.1711 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <25.3781, 8.8904, 1.872>, <25.6068, 8.9126, 1.8262>, 0.01171 }
				cylinder { <25.6068, 8.9126, 1.8262>, <25.8151, 8.9322, 1.7208>, 0.01171 }
				cylinder { <25.8151, 8.9322, 1.7208>, <25.9879, 8.9481, 1.5634>, 0.01171 }
				texture {fol5}}
			mesh { // leaf
				triangle { <27.2197, 8.5765, 0.02594>, <30.6779, 8.3475, -2.5168>, <25.9879, 8.9481, 1.5634> }
				triangle { <27.2197, 8.5765, 0.02594>, <30.3321, 8.1043, -2.9209>, <30.6779, 8.3475, -2.5168> }
				triangle { <30.3321, 8.1043, -2.9209>, <32.9791, 6.4244, -4.8701>, <30.6779, 8.3475, -2.5168> }
				triangle { <30.6779, 8.3475, -2.5168>, <32.9791, 6.4244, -4.8701>, <33.343, 6.5312, -4.5617> }
				triangle { <32.9791, 6.4244, -4.8701>, <33.4083, 5.0225, -4.8456>, <33.343, 6.5312, -4.5617> }
				triangle { <33.4083, 5.0225, -4.8456>, <33.5192, 6.6187, -4.3594>, <33.343, 6.5312, -4.5617> }
				triangle { <33.343, 6.5312, -4.5617>, <33.5192, 6.6187, -4.3594>, <30.6779, 8.3475, -2.5168> }
				triangle { <30.6779, 8.3475, -2.5168>, <33.5192, 6.6187, -4.3594>, <31.08086, 8.5273, -2.1581> }
				triangle { <31.08086, 8.5273, -2.1581>, <25.9879, 8.9481, 1.5634>, <30.6779, 8.3475, -2.5168> }
				triangle { <25.9879, 8.9481, 1.5634>, <31.08086, 8.5273, -2.1581>, <27.7169, 9.1118, 0.7275> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <25.3781, 8.8904, 1.872>, <26.3971, 8.9911, 1.9471>, 0.1711 }
				cylinder { <26.3971, 8.9911, 1.9471>, <27.4161, 9.09173, 2.02233>, 0.1711 }
				cylinder { <27.4161, 9.09173, 2.02233>, <28.4351, 9.1923, 2.0975>, 0.1711 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <28.4351, 9.1923, 2.0975>, <28.6545, 9.2144, 2.1763>, 0.01171 }
				cylinder { <28.6545, 9.2144, 2.1763>, <28.8451, 9.2341, 2.3111>, 0.01171 }
				cylinder { <28.8451, 9.2341, 2.3111>, <28.9929, 9.25, 2.4921>, 0.01171 }
				texture {fol5}}
			mesh { // leaf
				triangle { <30.5126, 8.927, 3.7594>, <32.9281, 8.6397, 7.3033>, <28.9929, 9.25, 2.4921> }
				triangle { <30.5126, 8.927, 3.7594>, <33.3696, 8.4742, 6.9572>, <32.9281, 8.6397, 7.3033> }
				triangle { <33.3696, 8.4742, 6.9572>, <35.3859, 6.7652, 9.5344>, <32.9281, 8.6397, 7.3033> }
				triangle { <32.9281, 8.6397, 7.3033>, <35.3859, 6.7652, 9.5344>, <35.05371, 6.8039, 9.8909> }
				triangle { <35.3859, 6.7652, 9.5344>, <35.4979, 5.3341, 9.8338>, <35.05371, 6.8039, 9.8909> }
				triangle { <35.4979, 5.3341, 9.8338>, <34.8363, 6.8526, 10.06423>, <35.05371, 6.8039, 9.8909> }
				triangle { <35.05371, 6.8039, 9.8909>, <34.8363, 6.8526, 10.06423>, <32.9281, 8.6397, 7.3033> }
				triangle { <32.9281, 8.6397, 7.3033>, <34.8363, 6.8526, 10.06423>, <32.5366, 8.7417, 7.7027> }
				triangle { <32.5366, 8.7417, 7.7027>, <28.9929, 9.25, 2.4921>, <32.9281, 8.6397, 7.3033> }
				triangle { <28.9929, 9.25, 2.4921>, <32.5366, 8.7417, 7.7027>, <29.7378, 9.336, 4.2677> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <28.4351, 9.1923, 2.0975>, <28.6675, 9.2153, 2.1146>, 0.01171 }
				cylinder { <28.6675, 9.2153, 2.1146>, <28.9, 9.2382, 2.1317>, 0.01171 }
				cylinder { <28.9, 9.2382, 2.1317>, <29.1325, 9.2612, 2.1489>, 0.01171 }
				texture {fol5}}
			mesh { // leaf
				triangle { <31.1066, 8.9722, 1.9514>, <35.3417, 8.8433, 2.6755>, <29.1325, 9.2612, 2.1489> }
				triangle { <31.1066, 8.9722, 1.9514>, <35.402, 8.6389, 2.1309>, <35.3417, 8.8433, 2.6755> }
				triangle { <35.402, 8.6389, 2.1309>, <38.6991, 7.0403, 2.58>, <35.3417, 8.8433, 2.6755> }
				triangle { <35.3417, 8.8433, 2.6755>, <38.6991, 7.0403, 2.58>, <38.7251, 7.1151, 3.06243> }
				triangle { <38.6991, 7.0403, 2.58>, <39.02836, 5.6299, 2.8102>, <38.7251, 7.1151, 3.06243> }
				triangle { <39.02836, 5.6299, 2.8102>, <38.6983, 7.1832, 3.3349>, <38.7251, 7.1151, 3.06243> }
				triangle { <38.7251, 7.1151, 3.06243>, <38.6983, 7.1832, 3.3349>, <35.3417, 8.8433, 2.6755> }
				triangle { <35.3417, 8.8433, 2.6755>, <38.6983, 7.1832, 3.3349>, <35.356, 8.9862, 3.2257> }
				triangle { <35.356, 8.9862, 3.2257>, <29.1325, 9.2612, 2.1489>, <35.3417, 8.8433, 2.6755> }
				triangle { <29.1325, 9.2612, 2.1489>, <35.356, 8.9862, 3.2257>, <30.9264, 9.4423, 2.8303> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <0.3222, 4.6695, 0.02377>, <0.3807, 4.7108, 0.02808>, 0.05377 }
		cylinder { <0.3807, 4.7108, 0.02808>, <0.4392, 4.7521, 0.03239>, 0.05377 }
		cylinder { <0.4392, 4.7521, 0.03239>, <0.4976, 4.7934, 0.03671>, 0.05377 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.4976, 4.7934, 0.03671>, <1.4807, 5.6858, -0.0439>, 0.0665 }
			cylinder { <1.4807, 5.6858, -0.0439>, <2.3333, 6.6784, -0.2827>, 0.0665 }
			cylinder { <2.3333, 6.6784, -0.2827>, <3.03045, 7.7419, -0.6728>, 0.0665 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <3.03045, 7.7419, -0.6728>, <3.2395, 8.06104, -0.7898>, 0.0665 }
				cylinder { <3.2395, 8.06104, -0.7898>, <3.4487, 8.3801, -0.9068>, 0.0665 }
				cylinder { <3.4487, 8.3801, -0.9068>, <3.6578, 8.6991, -1.02388>, 0.0665 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <3.6578, 8.6991, -1.02388>, <3.6715, 8.7316, -1.02718>, 0.001769 }
				cylinder { <3.6715, 8.7316, -1.02718>, <3.6794, 8.7659, -1.02315>, 0.001769 }
				cylinder { <3.6794, 8.7659, -1.02315>, <3.6809, 8.7994, -1.0121>, 0.001769 }
				texture {fol5}}
			mesh { // leaf
				triangle { <3.486, 9.525, -0.8051>, <3.5101, 11.174, -0.5381>, <3.6809, 8.7994, -1.0121> }
				triangle { <3.486, 9.525, -0.8051>, <3.3065, 11.1508, -0.4397>, <3.5101, 11.174, -0.5381> }
				triangle { <3.3065, 11.1508, -0.4397>, <2.8701, 12.5093, -0.59>, <3.5101, 11.174, -0.5381> }
				triangle { <3.5101, 11.174, -0.5381>, <2.8701, 12.5093, -0.59>, <3.01784, 12.5654, -0.6954> }
				triangle { <2.8701, 12.5093, -0.59>, <2.5206, 12.7369, -0.9785>, <3.01784, 12.5654, -0.6954> }
				triangle { <2.5206, 12.7369, -0.9785>, <3.1099, 12.5803, -0.7532>, <3.01784, 12.5654, -0.6954> }
				triangle { <3.01784, 12.5654, -0.6954>, <3.1099, 12.5803, -0.7532>, <3.5101, 11.174, -0.5381> }
				triangle { <3.5101, 11.174, -0.5381>, <3.1099, 12.5803, -0.7532>, <3.6954, 11.229, -0.6452> }
				triangle { <3.6954, 11.229, -0.6452>, <3.6809, 8.7994, -1.0121>, <3.5101, 11.174, -0.5381> }
				triangle { <3.6809, 8.7994, -1.0121>, <3.6954, 11.229, -0.6452>, <3.8569, 9.5238, -0.9372> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <3.6578, 8.6991, -1.02388>, <3.8669, 9.01826, -1.1409>, 0.0665 }
				cylinder { <3.8669, 9.01826, -1.1409>, <4.07608, 9.3373, -1.2579>, 0.0665 }
				cylinder { <4.07608, 9.3373, -1.2579>, <4.2852, 9.6564, -1.3749>, 0.0665 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <4.2852, 9.6564, -1.3749>, <4.3072, 9.6785, -1.3916>, 0.001769 }
				cylinder { <4.3072, 9.6785, -1.3916>, <4.3311, 9.6927, -1.4134>, 0.001769 }
				cylinder { <4.3311, 9.6927, -1.4134>, <4.3552, 9.6982, -1.4388>, 0.001769 }
				texture {fol5}}
			mesh { // leaf
				triangle { <4.7361, 9.9853, -2.05496>, <5.6906, 10.1378, -3.4176>, <4.3552, 9.6982, -1.4388> }
				triangle { <4.7361, 9.9853, -2.05496>, <5.6486, 10.361, -3.4096>, <5.6906, 10.1378, -3.4176> }
				triangle { <5.6486, 10.361, -3.4096>, <5.9318, 10.6539, -4.7854>, <5.6906, 10.1378, -3.4176> }
				triangle { <5.6906, 10.1378, -3.4176>, <5.9318, 10.6539, -4.7854>, <5.9551, 10.4732, -4.8391> }
				triangle { <5.9318, 10.6539, -4.7854>, <5.5726, 10.7256, -5.2221>, <5.9551, 10.4732, -4.8391> }
				triangle { <5.5726, 10.7256, -5.2221>, <5.9664, 10.3648, -4.8516>, <5.9551, 10.4732, -4.8391> }
				triangle { <5.9551, 10.4732, -4.8391>, <5.9664, 10.3648, -4.8516>, <5.6906, 10.1378, -3.4176> }
				triangle { <5.6906, 10.1378, -3.4176>, <5.9664, 10.3648, -4.8516>, <5.7313, 9.9251, -3.4617> }
				triangle { <5.7313, 9.9251, -3.4617>, <4.3552, 9.6982, -1.4388>, <5.6906, 10.1378, -3.4176> }
				triangle { <4.3552, 9.6982, -1.4388>, <5.7313, 9.9251, -3.4617>, <4.8275, 9.6047, -2.01275> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <4.2852, 9.6564, -1.3749>, <4.4943, 9.9754, -1.4919>, 0.0665 }
				cylinder { <4.4943, 9.9754, -1.4919>, <4.7034, 10.2945, -1.6089>, 0.0665 }
				cylinder { <4.7034, 10.2945, -1.6089>, <4.9125, 10.6136, -1.726>, 0.0665 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <4.9125, 10.6136, -1.726>, <4.9263, 10.646, -1.7293>, 0.001769 }
				cylinder { <4.9263, 10.646, -1.7293>, <4.9342, 10.6803, -1.7252>, 0.001769 }
				cylinder { <4.9342, 10.6803, -1.7252>, <4.9357, 10.7139, -1.7142>, 0.001769 }
				texture {fol5}}
			mesh { // leaf
				triangle { <4.7408, 11.4394, -1.5072>, <4.7649, 13.0885, -1.2402>, <4.9357, 10.7139, -1.7142> }
				triangle { <4.7408, 11.4394, -1.5072>, <4.5613, 13.06524, -1.1418>, <4.7649, 13.0885, -1.2402> }
				triangle { <4.5613, 13.06524, -1.1418>, <4.1248, 14.4237, -1.2921>, <4.7649, 13.0885, -1.2402> }
				triangle { <4.7649, 13.0885, -1.2402>, <4.1248, 14.4237, -1.2921>, <4.2726, 14.4798, -1.3976> }
				triangle { <4.1248, 14.4237, -1.2921>, <3.7754, 14.6514, -1.6806>, <4.2726, 14.4798, -1.3976> }
				triangle { <3.7754, 14.6514, -1.6806>, <4.3646, 14.4947, -1.4553>, <4.2726, 14.4798, -1.3976> }
				triangle { <4.2726, 14.4798, -1.3976>, <4.3646, 14.4947, -1.4553>, <4.7649, 13.0885, -1.2402> }
				triangle { <4.7649, 13.0885, -1.2402>, <4.3646, 14.4947, -1.4553>, <4.9502, 13.1434, -1.3474> }
				triangle { <4.9502, 13.1434, -1.3474>, <4.9357, 10.7139, -1.7142>, <4.7649, 13.0885, -1.2402> }
				triangle { <4.9357, 10.7139, -1.7142>, <4.9502, 13.1434, -1.3474>, <5.1116, 11.4382, -1.6393> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <4.9125, 10.6136, -1.726>, <5.1217, 10.9327, -1.843>, 0.0665 }
				cylinder { <5.1217, 10.9327, -1.843>, <5.3308, 11.2517, -1.96>, 0.0665 }
				cylinder { <5.3308, 11.2517, -1.96>, <5.5399, 11.5708, -2.07706>, 0.0665 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <5.5399, 11.5708, -2.07706>, <5.5619, 11.5929, -2.09377>, 0.001769 }
				cylinder { <5.5619, 11.5929, -2.09377>, <5.5859, 11.6072, -2.1156>, 0.001769 }
				cylinder { <5.5859, 11.6072, -2.1156>, <5.6099, 11.6126, -2.1409>, 0.001769 }
				texture {fol5}}
			mesh { // leaf
				triangle { <5.9909, 11.8998, -2.757>, <6.9454, 12.05226, -4.1197>, <5.6099, 11.6126, -2.1409> }
				triangle { <5.9909, 11.8998, -2.757>, <6.9034, 12.2754, -4.1117>, <6.9454, 12.05226, -4.1197> }
				triangle { <6.9034, 12.2754, -4.1117>, <7.1865, 12.5683, -5.4875>, <6.9454, 12.05226, -4.1197> }
				triangle { <6.9454, 12.05226, -4.1197>, <7.1865, 12.5683, -5.4875>, <7.2099, 12.3876, -5.5412> }
				triangle { <7.1865, 12.5683, -5.4875>, <6.8274, 12.6401, -5.9242>, <7.2099, 12.3876, -5.5412> }
				triangle { <6.8274, 12.6401, -5.9242>, <7.2212, 12.2792, -5.5537>, <7.2099, 12.3876, -5.5412> }
				triangle { <7.2099, 12.3876, -5.5412>, <7.2212, 12.2792, -5.5537>, <6.9454, 12.05226, -4.1197> }
				triangle { <6.9454, 12.05226, -4.1197>, <7.2212, 12.2792, -5.5537>, <6.9861, 11.8395, -4.1638> }
				triangle { <6.9861, 11.8395, -4.1638>, <5.6099, 11.6126, -2.1409>, <6.9454, 12.05226, -4.1197> }
				triangle { <5.6099, 11.6126, -2.1409>, <6.9861, 11.8395, -4.1638>, <6.08232, 11.5192, -2.7148> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <5.5399, 11.5708, -2.07706>, <5.749, 11.8899, -2.194>, 0.0665 }
				cylinder { <5.749, 11.8899, -2.194>, <5.9582, 12.2089, -2.3111>, 0.0665 }
				cylinder { <5.9582, 12.2089, -2.3111>, <6.1673, 12.528, -2.4281>, 0.0665 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <6.1673, 12.528, -2.4281>, <6.181, 12.5605, -2.4314>, 0.001769 }
				cylinder { <6.181, 12.5605, -2.4314>, <6.1889, 12.5947, -2.4273>, 0.001769 }
				cylinder { <6.1889, 12.5947, -2.4273>, <6.1904, 12.6283, -2.4163>, 0.001769 }
				texture {fol5}}
			mesh { // leaf
				triangle { <5.9955, 13.3538, -2.2093>, <6.01967, 15.00293, -1.9424>, <6.1904, 12.6283, -2.4163> }
				triangle { <5.9955, 13.3538, -2.2093>, <5.8161, 14.9796, -1.8439>, <6.01967, 15.00293, -1.9424> }
				triangle { <5.8161, 14.9796, -1.8439>, <5.3796, 16.3382, -1.9942>, <6.01967, 15.00293, -1.9424> }
				triangle { <6.01967, 15.00293, -1.9424>, <5.3796, 16.3382, -1.9942>, <5.5273, 16.3943, -2.09973> }
				triangle { <5.3796, 16.3382, -1.9942>, <5.03021, 16.5658, -2.3827>, <5.5273, 16.3943, -2.09973> }
				triangle { <5.03021, 16.5658, -2.3827>, <5.6194, 16.4091, -2.1574>, <5.5273, 16.3943, -2.09973> }
				triangle { <5.5273, 16.3943, -2.09973>, <5.6194, 16.4091, -2.1574>, <6.01967, 15.00293, -1.9424> }
				triangle { <6.01967, 15.00293, -1.9424>, <5.6194, 16.4091, -2.1574>, <6.2049, 15.05791, -2.04952> }
				triangle { <6.2049, 15.05791, -2.04952>, <6.1904, 12.6283, -2.4163>, <6.01967, 15.00293, -1.9424> }
				triangle { <6.1904, 12.6283, -2.4163>, <6.2049, 15.05791, -2.04952>, <6.3664, 13.3526, -2.3414> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <6.1673, 12.528, -2.4281>, <6.3764, 12.8471, -2.5451>, 0.0665 }
				cylinder { <6.3764, 12.8471, -2.5451>, <6.5856, 13.1662, -2.6621>, 0.0665 }
				cylinder { <6.5856, 13.1662, -2.6621>, <6.7947, 13.4852, -2.7791>, 0.0665 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <6.7947, 13.4852, -2.7791>, <6.8167, 13.5073, -2.7958>, 0.001769 }
				cylinder { <6.8167, 13.5073, -2.7958>, <6.8406, 13.5216, -2.8177>, 0.001769 }
				cylinder { <6.8406, 13.5216, -2.8177>, <6.8647, 13.527, -2.843>, 0.001769 }
				texture {fol5}}
			mesh { // leaf
				triangle { <7.2457, 13.8142, -3.4592>, <8.2002, 13.9666, -4.8218>, <6.8647, 13.527, -2.843> }
				triangle { <7.2457, 13.8142, -3.4592>, <8.1581, 14.1899, -4.8138>, <8.2002, 13.9666, -4.8218> }
				triangle { <8.1581, 14.1899, -4.8138>, <8.4413, 14.4828, -6.1896>, <8.2002, 13.9666, -4.8218> }
				triangle { <8.2002, 13.9666, -4.8218>, <8.4413, 14.4828, -6.1896>, <8.4646, 14.302, -6.2434> }
				triangle { <8.4413, 14.4828, -6.1896>, <8.08221, 14.5545, -6.6263>, <8.4646, 14.302, -6.2434> }
				triangle { <8.08221, 14.5545, -6.6263>, <8.4759, 14.1936, -6.2559>, <8.4646, 14.302, -6.2434> }
				triangle { <8.4646, 14.302, -6.2434>, <8.4759, 14.1936, -6.2559>, <8.2002, 13.9666, -4.8218> }
				triangle { <8.2002, 13.9666, -4.8218>, <8.4759, 14.1936, -6.2559>, <8.2409, 13.754, -4.8659> }
				triangle { <8.2409, 13.754, -4.8659>, <6.8647, 13.527, -2.843>, <8.2002, 13.9666, -4.8218> }
				triangle { <6.8647, 13.527, -2.843>, <8.2409, 13.754, -4.8659>, <7.337, 13.4336, -3.4169> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <6.7947, 13.4852, -2.7791>, <6.8132, 13.5135, -2.7895>, 0.001769 }
				cylinder { <6.8132, 13.5135, -2.7895>, <6.8318, 13.5418, -2.7999>, 0.001769 }
				cylinder { <6.8318, 13.5418, -2.7999>, <6.8503, 13.5701, -2.8103>, 0.001769 }
				texture {fol5}}
			mesh { // leaf
				triangle { <7.04641, 14.2841, -3.05337>, <7.8258, 15.567, -3.7866>, <6.8503, 13.5701, -2.8103> }
				triangle { <7.04641, 14.2841, -3.05337>, <7.674, 15.7033, -3.6864>, <7.8258, 15.567, -3.7866> }
				triangle { <7.674, 15.7033, -3.6864>, <7.8073, 16.8192, -4.5784>, <7.8258, 15.567, -3.7866> }
				triangle { <7.8258, 15.567, -3.7866>, <7.8073, 16.8192, -4.5784>, <7.9226, 16.7317, -4.7015> }
				triangle { <7.8073, 16.8192, -4.5784>, <7.4769, 16.9751, -5.01597>, <7.9226, 16.7317, -4.7015> }
				triangle { <7.4769, 16.9751, -5.01597>, <7.9888, 16.6668, -4.7601>, <7.9226, 16.7317, -4.7015> }
				triangle { <7.9226, 16.7317, -4.7015>, <7.9888, 16.6668, -4.7601>, <7.8258, 15.567, -3.7866> }
				triangle { <7.8258, 15.567, -3.7866>, <7.9888, 16.6668, -4.7601>, <7.9722, 15.4585, -3.9115> }
				triangle { <7.9722, 15.4585, -3.9115>, <6.8503, 13.5701, -2.8103>, <7.8258, 15.567, -3.7866> }
				triangle { <6.8503, 13.5701, -2.8103>, <7.9722, 15.4585, -3.9115>, <7.3204, 14.02765, -3.1721> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <0.4976, 4.7934, 0.03671>, <0.524, 4.812, 0.03865>, 0.02427 }
		cylinder { <0.524, 4.812, 0.03865>, <0.5504, 4.8306, 0.0406>, 0.02427 }
		cylinder { <0.5504, 4.8306, 0.0406>, <0.5768, 4.8493, 0.04255>, 0.02427 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.5768, 4.8493, 0.04255>, <1.07692, 5.1951, 0.186>, 0.03123 }
			cylinder { <1.07692, 5.1951, 0.186>, <1.5529, 5.517, 0.4311>, 0.03123 }
			cylinder { <1.5529, 5.517, 0.4311>, <1.9909, 5.8053, 0.7707>, 0.03123 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <1.9909, 5.8053, 0.7707>, <2.1223, 5.8918, 0.8726>, 0.03123 }
				cylinder { <2.1223, 5.8918, 0.8726>, <2.2537, 5.9783, 0.9744>, 0.03123 }
				cylinder { <2.2537, 5.9783, 0.9744>, <2.3851, 6.06481, 1.07635>, 0.03123 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <2.3851, 6.06481, 1.07635>, <2.3916, 6.06659, 1.08032>, 0.0003902 }
				cylinder { <2.3916, 6.06659, 1.08032>, <2.3986, 6.06641, 1.08374>, 0.0003902 }
				cylinder { <2.3986, 6.06641, 1.08374>, <2.4056, 6.0643, 1.08635>, 0.0003902 }
				texture {fol5}}
			mesh { // leaf
				triangle { <2.6782, 5.8826, 1.2496>, <3.3438, 5.7044, 1.6249>, <2.4056, 6.0643, 1.08635> }
				triangle { <2.6782, 5.8826, 1.2496>, <3.3174, 5.6016, 1.6131>, <3.3438, 5.7044, 1.6249> }
				triangle { <3.3174, 5.6016, 1.6131>, <3.6944, 5.3557, 2.1146>, <3.3438, 5.7044, 1.6249> }
				triangle { <3.3438, 5.7044, 1.6249>, <3.6944, 5.3557, 2.1146>, <3.7204, 5.4351, 2.1461> }
				triangle { <3.6944, 5.3557, 2.1146>, <3.623, 5.2864, 2.363>, <3.7204, 5.4351, 2.1461> }
				triangle { <3.623, 5.2864, 2.363>, <3.731, 5.4842, 2.1572>, <3.7204, 5.4351, 2.1461> }
				triangle { <3.7204, 5.4351, 2.1461>, <3.731, 5.4842, 2.1572>, <3.3438, 5.7044, 1.6249> }
				triangle { <3.3438, 5.7044, 1.6249>, <3.731, 5.4842, 2.1572>, <3.3764, 5.7993, 1.6513> }
				triangle { <3.3764, 5.7993, 1.6513>, <2.4056, 6.0643, 1.08635>, <3.3438, 5.7044, 1.6249> }
				triangle { <2.4056, 6.0643, 1.08635>, <3.3764, 5.7993, 1.6513>, <2.721, 6.06234, 1.2423> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <2.3851, 6.06481, 1.07635>, <2.5165, 6.1513, 1.1782>, 0.03123 }
				cylinder { <2.5165, 6.1513, 1.1782>, <2.6479, 6.2378, 1.2801>, 0.03123 }
				cylinder { <2.6479, 6.2378, 1.2801>, <2.7793, 6.3242, 1.3819>, 0.03123 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <2.7793, 6.3242, 1.3819>, <2.7834, 6.3294, 1.3861>, 0.0003902 }
				cylinder { <2.7834, 6.3294, 1.3861>, <2.7857, 6.3358, 1.39>, 0.0003902 }
				cylinder { <2.7857, 6.3358, 1.39>, <2.7862, 6.3428, 1.3932>, 0.0003902 }
				texture {fol5}}
			mesh { // leaf
				triangle { <2.829, 6.6152, 1.6339>, <2.7692, 7.2999, 2.01256>, <2.7862, 6.3428, 1.3932> }
				triangle { <2.829, 6.6152, 1.6339>, <2.8442, 7.264, 2.07948>, <2.7692, 7.2999, 2.01256> }
				triangle { <2.8442, 7.264, 2.07948>, <2.7014, 7.6704, 2.5977>, <2.7692, 7.2999, 2.01256> }
				triangle { <2.7692, 7.2999, 2.01256>, <2.7014, 7.6704, 2.5977>, <2.6281, 7.706, 2.5613> }
				triangle { <2.7014, 7.6704, 2.5977>, <2.5605, 7.6201, 2.8197>, <2.6281, 7.706, 2.5613> }
				triangle { <2.5605, 7.6201, 2.8197>, <2.588, 7.7217, 2.5331>, <2.6281, 7.706, 2.5613> }
				triangle { <2.6281, 7.706, 2.5613>, <2.588, 7.7217, 2.5331>, <2.7692, 7.2999, 2.01256> }
				triangle { <2.7692, 7.2999, 2.01256>, <2.588, 7.7217, 2.5331>, <2.6897, 7.3428, 1.9613> }
				triangle { <2.6897, 7.3428, 1.9613>, <2.7862, 6.3428, 1.3932>, <2.7692, 7.2999, 2.01256> }
				triangle { <2.7862, 6.3428, 1.3932>, <2.6897, 7.3428, 1.9613>, <2.7173, 6.6717, 1.4977> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <2.7793, 6.3242, 1.3819>, <2.9107, 6.4107, 1.4838>, 0.03123 }
				cylinder { <2.9107, 6.4107, 1.4838>, <3.04214, 6.4972, 1.5857>, 0.03123 }
				cylinder { <3.04214, 6.4972, 1.5857>, <3.1735, 6.5837, 1.6876>, 0.03123 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <3.1735, 6.5837, 1.6876>, <3.18, 6.5855, 1.6915>, 0.0003902 }
				cylinder { <3.18, 6.5855, 1.6915>, <3.187, 6.5853, 1.6949>, 0.0003902 }
				cylinder { <3.187, 6.5853, 1.6949>, <3.194, 6.5832, 1.6976>, 0.0003902 }
				texture {fol5}}
			mesh { // leaf
				triangle { <3.4665, 6.4015, 1.8609>, <4.1322, 6.2233, 2.2361>, <3.194, 6.5832, 1.6976> }
				triangle { <3.4665, 6.4015, 1.8609>, <4.1057, 6.1206, 2.2243>, <4.1322, 6.2233, 2.2361> }
				triangle { <4.1057, 6.1206, 2.2243>, <4.4828, 5.8747, 2.7258>, <4.1322, 6.2233, 2.2361> }
				triangle { <4.1322, 6.2233, 2.2361>, <4.4828, 5.8747, 2.7258>, <4.5088, 5.954, 2.7573> }
				triangle { <4.4828, 5.8747, 2.7258>, <4.4114, 5.8053, 2.9743>, <4.5088, 5.954, 2.7573> }
				triangle { <4.4114, 5.8053, 2.9743>, <4.5194, 6.003227, 2.7684>, <4.5088, 5.954, 2.7573> }
				triangle { <4.5088, 5.954, 2.7573>, <4.5194, 6.003227, 2.7684>, <4.1322, 6.2233, 2.2361> }
				triangle { <4.1322, 6.2233, 2.2361>, <4.5194, 6.003227, 2.7684>, <4.1648, 6.3183, 2.2626> }
				triangle { <4.1648, 6.3183, 2.2626>, <3.194, 6.5832, 1.6976>, <4.1322, 6.2233, 2.2361> }
				triangle { <3.194, 6.5832, 1.6976>, <4.1648, 6.3183, 2.2626>, <3.5094, 6.5813, 1.8536> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <3.1735, 6.5837, 1.6876>, <3.3049, 6.6702, 1.7894>, 0.03123 }
				cylinder { <3.3049, 6.6702, 1.7894>, <3.4363, 6.7567, 1.8913>, 0.03123 }
				cylinder { <3.4363, 6.7567, 1.8913>, <3.5677, 6.8432, 1.9932>, 0.03123 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <3.5677, 6.8432, 1.9932>, <3.5718, 6.8484, 1.9974>, 0.0003902 }
				cylinder { <3.5718, 6.8484, 1.9974>, <3.5741, 6.8547, 2.001293>, 0.0003902 }
				cylinder { <3.5741, 6.8547, 2.001293>, <3.5746, 6.8618, 2.004533>, 0.0003902 }
				texture {fol5}}
			mesh { // leaf
				triangle { <3.6173, 7.1342, 2.2451>, <3.5575, 7.8189, 2.6238>, <3.5746, 6.8618, 2.004533> }
				triangle { <3.6173, 7.1342, 2.2451>, <3.6326, 7.783, 2.6907>, <3.5575, 7.8189, 2.6238> }
				triangle { <3.6326, 7.783, 2.6907>, <3.4898, 8.1894, 3.2089>, <3.5575, 7.8189, 2.6238> }
				triangle { <3.5575, 7.8189, 2.6238>, <3.4898, 8.1894, 3.2089>, <3.4165, 8.2249, 3.1726> }
				triangle { <3.4898, 8.1894, 3.2089>, <3.3489, 8.1391, 3.4309>, <3.4165, 8.2249, 3.1726> }
				triangle { <3.3489, 8.1391, 3.4309>, <3.3764, 8.2407, 3.1443>, <3.4165, 8.2249, 3.1726> }
				triangle { <3.4165, 8.2249, 3.1726>, <3.3764, 8.2407, 3.1443>, <3.5575, 7.8189, 2.6238> }
				triangle { <3.5575, 7.8189, 2.6238>, <3.3764, 8.2407, 3.1443>, <3.4781, 7.8617, 2.5725> }
				triangle { <3.4781, 7.8617, 2.5725>, <3.5746, 6.8618, 2.004533>, <3.5575, 7.8189, 2.6238> }
				triangle { <3.5746, 6.8618, 2.004533>, <3.4781, 7.8617, 2.5725>, <3.5057, 7.1906, 2.109> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <3.5677, 6.8432, 1.9932>, <3.6991, 6.9297, 2.0951>, 0.03123 }
				cylinder { <3.6991, 6.9297, 2.0951>, <3.8305, 7.01624, 2.1969>, 0.03123 }
				cylinder { <3.8305, 7.01624, 2.1969>, <3.9619, 7.1027, 2.2988>, 0.03123 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <3.9619, 7.1027, 2.2988>, <3.9684, 7.1045, 2.3028>, 0.0003902 }
				cylinder { <3.9684, 7.1045, 2.3028>, <3.9754, 7.1043, 2.3062>, 0.0003902 }
				cylinder { <3.9754, 7.1043, 2.3062>, <3.9824, 7.1022, 2.3088>, 0.0003902 }
				texture {fol5}}
			mesh { // leaf
				triangle { <4.2549, 6.9205, 2.4721>, <4.9206, 6.7423, 2.8474>, <3.9824, 7.1022, 2.3088> }
				triangle { <4.2549, 6.9205, 2.4721>, <4.8941, 6.6396, 2.8356>, <4.9206, 6.7423, 2.8474> }
				triangle { <4.8941, 6.6396, 2.8356>, <5.2712, 6.3936, 3.337>, <4.9206, 6.7423, 2.8474> }
				triangle { <4.9206, 6.7423, 2.8474>, <5.2712, 6.3936, 3.337>, <5.2972, 6.473, 3.3686> }
				triangle { <5.2712, 6.3936, 3.337>, <5.1998, 6.3243, 3.5855>, <5.2972, 6.473, 3.3686> }
				triangle { <5.1998, 6.3243, 3.5855>, <5.3078, 6.5221, 3.3797>, <5.2972, 6.473, 3.3686> }
				triangle { <5.2972, 6.473, 3.3686>, <5.3078, 6.5221, 3.3797>, <4.9206, 6.7423, 2.8474> }
				triangle { <4.9206, 6.7423, 2.8474>, <5.3078, 6.5221, 3.3797>, <4.9532, 6.8372, 2.8738> }
				triangle { <4.9532, 6.8372, 2.8738>, <3.9824, 7.1022, 2.3088>, <4.9206, 6.7423, 2.8474> }
				triangle { <3.9824, 7.1022, 2.3088>, <4.9532, 6.8372, 2.8738>, <4.2978, 7.1002, 2.4648> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <3.9619, 7.1027, 2.2988>, <4.09332, 7.1892, 2.4007>, 0.03123 }
				cylinder { <4.09332, 7.1892, 2.4007>, <4.2247, 7.2757, 2.5025>, 0.03123 }
				cylinder { <4.2247, 7.2757, 2.5025>, <4.3561, 7.3622, 2.6044>, 0.03123 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <4.3561, 7.3622, 2.6044>, <4.3601, 7.3673, 2.6086>, 0.0003902 }
				cylinder { <4.3601, 7.3673, 2.6086>, <4.3625, 7.3737, 2.6125>, 0.0003902 }
				cylinder { <4.3625, 7.3737, 2.6125>, <4.363, 7.3808, 2.6157>, 0.0003902 }
				texture {fol5}}
			mesh { // leaf
				triangle { <4.4057, 7.6532, 2.8564>, <4.3459, 8.3378, 3.235>, <4.363, 7.3808, 2.6157> }
				triangle { <4.4057, 7.6532, 2.8564>, <4.4209, 8.3019, 3.3019>, <4.3459, 8.3378, 3.235> }
				triangle { <4.4209, 8.3019, 3.3019>, <4.2782, 8.7083, 3.8202>, <4.3459, 8.3378, 3.235> }
				triangle { <4.3459, 8.3378, 3.235>, <4.2782, 8.7083, 3.8202>, <4.2049, 8.7439, 3.7838> }
				triangle { <4.2782, 8.7083, 3.8202>, <4.1373, 8.6581, 4.04221>, <4.2049, 8.7439, 3.7838> }
				triangle { <4.1373, 8.6581, 4.04221>, <4.1648, 8.7597, 3.7556>, <4.2049, 8.7439, 3.7838> }
				triangle { <4.2049, 8.7439, 3.7838>, <4.1648, 8.7597, 3.7556>, <4.3459, 8.3378, 3.235> }
				triangle { <4.3459, 8.3378, 3.235>, <4.1648, 8.7597, 3.7556>, <4.2665, 8.3807, 3.1838> }
				triangle { <4.2665, 8.3807, 3.1838>, <4.363, 7.3808, 2.6157>, <4.3459, 8.3378, 3.235> }
				triangle { <4.363, 7.3808, 2.6157>, <4.2665, 8.3807, 3.1838>, <4.2941, 7.7096, 2.7202> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <4.3561, 7.3622, 2.6044>, <4.3615, 7.3658, 2.6087>, 0.0003902 }
				cylinder { <4.3615, 7.3658, 2.6087>, <4.367, 7.3694, 2.6129>, 0.0003902 }
				cylinder { <4.367, 7.3694, 2.6129>, <4.3725, 7.373, 2.6172>, 0.0003902 }
				texture {fol5}}
			mesh { // leaf
				triangle { <4.6175, 7.4527, 2.8771>, <5.0756, 7.8358, 3.3861>, <4.3725, 7.373, 2.6172> }
				triangle { <4.6175, 7.4527, 2.8771>, <5.1178, 7.7413, 3.4119>, <5.0756, 7.8358, 3.3861> }
				triangle { <5.1178, 7.7413, 3.4119>, <5.3533, 7.9133, 4.01944>, <5.0756, 7.8358, 3.3861> }
				triangle { <5.0756, 7.8358, 3.3861>, <5.3533, 7.9133, 4.01944>, <5.3166, 7.9947, 4.02063> }
				triangle { <5.3533, 7.9133, 4.01944>, <5.2486, 7.8684, 4.2616>, <5.3166, 7.9947, 4.02063> }
				triangle { <5.2486, 7.8684, 4.2616>, <5.2929, 8.03979, 4.01294>, <5.3166, 7.9947, 4.02063> }
				triangle { <5.3166, 7.9947, 4.02063>, <5.2929, 8.03979, 4.01294>, <5.0756, 7.8358, 3.3861> }
				triangle { <5.0756, 7.8358, 3.3861>, <5.2929, 8.03979, 4.01294>, <5.03693, 7.9318, 3.3775> }
				triangle { <5.03693, 7.9318, 3.3775>, <4.3725, 7.373, 2.6172>, <5.0756, 7.8358, 3.3861> }
				triangle { <4.3725, 7.373, 2.6172>, <5.03693, 7.9318, 3.3775>, <4.5512, 7.61, 2.8061> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <0.0, 4.2338, 0.0>, <0.0, 4.5671, 0.0>, 0.25 }
		cylinder { <0.0, 4.5671, 0.0>, <-0.0, 4.9004, 0.0>, 0.25 }
		cylinder { <-0.0, 4.9004, 0.0>, <-0.0, 5.2338, 0.0>, 0.25 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0, 5.2338, 0.0>, <-1.1298, 14.6774, -1.1867>, 0.4792 }
			cylinder { <-1.1298, 14.6774, -1.1867>, <-3.3564, 23.7019, -3.5253>, 0.4792 }
			cylinder { <-3.3564, 23.7019, -3.5253>, <-6.614, 32.04148, -6.9469>, 0.4792 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-6.614, 32.04148, -6.9469>, <-7.5913, 34.5433, -7.9733>, 0.4792 }
				cylinder { <-7.5913, 34.5433, -7.9733>, <-8.5685, 37.04522, -8.9998>, 0.4792 }
				cylinder { <-8.5685, 37.04522, -8.9998>, <-9.5458, 39.547, -10.02633>, 0.4792 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-9.5458, 39.547, -10.02633>, <-10.5026, 41.08783, -10.3205>, 0.09186 }
				cylinder { <-10.5026, 41.08783, -10.3205>, <-11.7223, 42.459, -10.2318>, 0.09186 }
				cylinder { <-11.7223, 42.459, -10.2318>, <-13.1167, 43.5613, -9.7665>, 0.09186 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-18.2378, 45.5162, -8.5492>, <-27.886, 52.6157, -7.35>, <-13.1167, 43.5613, -9.7665> }
				triangle { <-18.2378, 45.5162, -8.5492>, <-28.6194, 51.3658, -6.5868>, <-27.886, 52.6157, -7.35> }
				triangle { <-28.6194, 51.3658, -6.5868>, <-38.3859, 54.373, -8.1581>, <-27.886, 52.6157, -7.35> }
				triangle { <-27.886, 52.6157, -7.35>, <-38.3859, 54.373, -8.1581>, <-38.0766, 55.4281, -8.9737> }
				triangle { <-38.3859, 54.373, -8.1581>, <-41.09194, 53.0963, -10.9714>, <-38.0766, 55.4281, -8.9737> }
				triangle { <-41.09194, 53.0963, -10.9714>, <-37.7674, 56.00584, -9.4157>, <-38.0766, 55.4281, -8.9737> }
				triangle { <-38.0766, 55.4281, -8.9737>, <-37.7674, 56.00584, -9.4157>, <-27.886, 52.6157, -7.35> }
				triangle { <-27.886, 52.6157, -7.35>, <-37.7674, 56.00584, -9.4157>, <-27.4131, 53.886, -8.1855> }
				triangle { <-27.4131, 53.886, -8.1855>, <-13.1167, 43.5613, -9.7665>, <-27.886, 52.6157, -7.35> }
				triangle { <-13.1167, 43.5613, -9.7665>, <-27.4131, 53.886, -8.1855>, <-16.6561, 47.633, -9.5814> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-9.5458, 39.547, -10.02633>, <-10.5231, 42.04896, -11.0528>, 0.4792 }
				cylinder { <-10.5231, 42.04896, -11.0528>, <-11.5004, 44.5508, -12.07927>, 0.4792 }
				cylinder { <-11.5004, 44.5508, -12.07927>, <-12.4777, 47.0527, -13.1057>, 0.4792 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-12.4777, 47.0527, -13.1057>, <-12.7246, 48.5934, -14.07578>, 0.09186 }
				cylinder { <-12.7246, 48.5934, -14.07578>, <-12.5761, 49.9646, -15.2896>, 0.09186 }
				cylinder { <-12.5761, 49.9646, -15.2896>, <-12.04298, 51.06698, -16.6595>, 0.09186 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-12.00513, 54.2298, -21.2989>, <-8.6189, 59.8797, -31.3757>, <-12.04298, 51.06698, -16.6595> }
				triangle { <-12.00513, 54.2298, -21.2989>, <-10.1072, 60.5626, -31.4054>, <-8.6189, 59.8797, -31.3757> }
				triangle { <-10.1072, 60.5626, -31.4054>, <-10.34, 62.845, -41.4867>, <-8.6189, 59.8797, -31.3757> }
				triangle { <-8.6189, 59.8797, -31.3757>, <-10.34, 62.845, -41.4867>, <-9.1689, 62.2089, -41.7999> }
				triangle { <-10.34, 62.845, -41.4867>, <-12.1595, 60.8435, -44.577>, <-9.1689, 62.2089, -41.7999> }
				triangle { <-12.1595, 60.8435, -44.577>, <-8.4822, 61.8202, -41.8455>, <-9.1689, 62.2089, -41.7999> }
				triangle { <-9.1689, 62.2089, -41.7999>, <-8.4822, 61.8202, -41.8455>, <-8.6189, 59.8797, -31.3757> }
				triangle { <-8.6189, 59.8797, -31.3757>, <-8.4822, 61.8202, -41.8455>, <-7.1899, 59.2173, -31.6097> }
				triangle { <-7.1899, 59.2173, -31.6097>, <-12.04298, 51.06698, -16.6595>, <-8.6189, 59.8797, -31.3757> }
				triangle { <-12.04298, 51.06698, -16.6595>, <-7.1899, 59.2173, -31.6097>, <-9.3977, 53.2058, -20.8509> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-12.4777, 47.0527, -13.1057>, <-13.4549, 49.5545, -14.1322>, 0.4792 }
				cylinder { <-13.4549, 49.5545, -14.1322>, <-14.4322, 52.05643, -15.1586>, 0.4792 }
				cylinder { <-14.4322, 52.05643, -15.1586>, <-15.4095, 54.5583, -16.1851>, 0.4792 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-15.4095, 54.5583, -16.1851>, <-16.3663, 56.09904, -16.4793>, 0.09186 }
				cylinder { <-16.3663, 56.09904, -16.4793>, <-17.586, 57.4702, -16.3906>, 0.09186 }
				cylinder { <-17.586, 57.4702, -16.3906>, <-18.9803, 58.5725, -15.9253>, 0.09186 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-24.1014, 60.5274, -14.7081>, <-33.7497, 67.6269, -13.5088>, <-18.9803, 58.5725, -15.9253> }
				triangle { <-24.1014, 60.5274, -14.7081>, <-34.4831, 66.377, -12.7456>, <-33.7497, 67.6269, -13.5088> }
				triangle { <-34.4831, 66.377, -12.7456>, <-44.2496, 69.3843, -14.3169>, <-33.7497, 67.6269, -13.5088> }
				triangle { <-33.7497, 67.6269, -13.5088>, <-44.2496, 69.3843, -14.3169>, <-43.9402, 70.4393, -15.1325> }
				triangle { <-44.2496, 69.3843, -14.3169>, <-46.9556, 68.1075, -17.1302>, <-43.9402, 70.4393, -15.1325> }
				triangle { <-46.9556, 68.1075, -17.1302>, <-43.631, 71.01706, -15.5746>, <-43.9402, 70.4393, -15.1325> }
				triangle { <-43.9402, 70.4393, -15.1325>, <-43.631, 71.01706, -15.5746>, <-33.7497, 67.6269, -13.5088> }
				triangle { <-33.7497, 67.6269, -13.5088>, <-43.631, 71.01706, -15.5746>, <-33.2768, 68.8972, -14.3443> }
				triangle { <-33.2768, 68.8972, -14.3443>, <-18.9803, 58.5725, -15.9253>, <-33.7497, 67.6269, -13.5088> }
				triangle { <-18.9803, 58.5725, -15.9253>, <-33.2768, 68.8972, -14.3443>, <-22.5198, 62.6442, -15.7402> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-15.4095, 54.5583, -16.1851>, <-16.3868, 57.06017, -17.2116>, 0.4792 }
				cylinder { <-16.3868, 57.06017, -17.2116>, <-17.3641, 59.562, -18.238>, 0.4792 }
				cylinder { <-17.3641, 59.562, -18.238>, <-18.3413, 62.06391, -19.2645>, 0.4792 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-18.3413, 62.06391, -19.2645>, <-18.5883, 63.6046, -20.2345>, 0.09186 }
				cylinder { <-18.5883, 63.6046, -20.2345>, <-18.4398, 64.9758, -21.4485>, 0.09186 }
				cylinder { <-18.4398, 64.9758, -21.4485>, <-17.9066, 66.07819, -22.8183>, 0.09186 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-17.8688, 69.241, -27.4577>, <-14.4825, 74.8909, -37.5345>, <-17.9066, 66.07819, -22.8183> }
				triangle { <-17.8688, 69.241, -27.4577>, <-15.9709, 75.5738, -37.5642>, <-14.4825, 74.8909, -37.5345> }
				triangle { <-15.9709, 75.5738, -37.5642>, <-16.2036, 77.8562, -47.6455>, <-14.4825, 74.8909, -37.5345> }
				triangle { <-14.4825, 74.8909, -37.5345>, <-16.2036, 77.8562, -47.6455>, <-15.03263, 77.2202, -47.9587> }
				triangle { <-16.2036, 77.8562, -47.6455>, <-18.02325, 75.8547, -50.7358>, <-15.03263, 77.2202, -47.9587> }
				triangle { <-18.02325, 75.8547, -50.7358>, <-14.3459, 76.8314, -48.00431>, <-15.03263, 77.2202, -47.9587> }
				triangle { <-15.03263, 77.2202, -47.9587>, <-14.3459, 76.8314, -48.00431>, <-14.4825, 74.8909, -37.5345> }
				triangle { <-14.4825, 74.8909, -37.5345>, <-14.3459, 76.8314, -48.00431>, <-13.0536, 74.2285, -37.7685> }
				triangle { <-13.0536, 74.2285, -37.7685>, <-17.9066, 66.07819, -22.8183>, <-14.4825, 74.8909, -37.5345> }
				triangle { <-17.9066, 66.07819, -22.8183>, <-13.0536, 74.2285, -37.7685>, <-15.2614, 68.217, -27.00979> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-18.3413, 62.06391, -19.2645>, <-19.3186, 64.5657, -20.291>, 0.4792 }
				cylinder { <-19.3186, 64.5657, -20.291>, <-20.2959, 67.06765, -21.3174>, 0.4792 }
				cylinder { <-20.2959, 67.06765, -21.3174>, <-21.2732, 69.5695, -22.3439>, 0.4792 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-21.2732, 69.5695, -22.3439>, <-22.2299, 71.1102, -22.6381>, 0.09186 }
				cylinder { <-22.2299, 71.1102, -22.6381>, <-23.4497, 72.4814, -22.5494>, 0.09186 }
				cylinder { <-23.4497, 72.4814, -22.5494>, <-24.844, 73.5838, -22.08414>, 0.09186 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-29.9651, 75.5386, -20.8669>, <-39.6134, 82.6381, -19.6676>, <-24.844, 73.5838, -22.08414> }
				triangle { <-29.9651, 75.5386, -20.8669>, <-40.3468, 81.3883, -18.9044>, <-39.6134, 82.6381, -19.6676> }
				triangle { <-40.3468, 81.3883, -18.9044>, <-50.1133, 84.3955, -20.4757>, <-39.6134, 82.6381, -19.6676> }
				triangle { <-39.6134, 82.6381, -19.6676>, <-50.1133, 84.3955, -20.4757>, <-49.8039, 85.4505, -21.2913> }
				triangle { <-50.1133, 84.3955, -20.4757>, <-52.8192, 83.1187, -23.289>, <-49.8039, 85.4505, -21.2913> }
				triangle { <-52.8192, 83.1187, -23.289>, <-49.4947, 86.02827, -21.7334>, <-49.8039, 85.4505, -21.2913> }
				triangle { <-49.8039, 85.4505, -21.2913>, <-49.4947, 86.02827, -21.7334>, <-39.6134, 82.6381, -19.6676> }
				triangle { <-39.6134, 82.6381, -19.6676>, <-49.4947, 86.02827, -21.7334>, <-39.1405, 83.9085, -20.5031> }
				triangle { <-39.1405, 83.9085, -20.5031>, <-24.844, 73.5838, -22.08414>, <-39.6134, 82.6381, -19.6676> }
				triangle { <-24.844, 73.5838, -22.08414>, <-39.1405, 83.9085, -20.5031>, <-28.3835, 77.6554, -21.899> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-21.2732, 69.5695, -22.3439>, <-22.2505, 72.07139, -23.3704>, 0.4792 }
				cylinder { <-22.2505, 72.07139, -23.3704>, <-23.2277, 74.5732, -24.3968>, 0.4792 }
				cylinder { <-23.2277, 74.5732, -24.3968>, <-24.205, 77.07513, -25.4233>, 0.4792 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-24.205, 77.07513, -25.4233>, <-24.4519, 78.6158, -26.3934>, 0.09186 }
				cylinder { <-24.4519, 78.6158, -26.3934>, <-24.3035, 79.987, -27.6073>, 0.09186 }
				cylinder { <-24.3035, 79.987, -27.6073>, <-23.7703, 81.08941, -28.9771>, 0.09186 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-23.7324, 84.2522, -33.6165>, <-20.3462, 89.9021, -43.6933>, <-23.7703, 81.08941, -28.9771> }
				triangle { <-23.7324, 84.2522, -33.6165>, <-21.8346, 90.585, -43.723>, <-20.3462, 89.9021, -43.6933> }
				triangle { <-21.8346, 90.585, -43.723>, <-22.06737, 92.8675, -53.8043>, <-20.3462, 89.9021, -43.6933> }
				triangle { <-20.3462, 89.9021, -43.6933>, <-22.06737, 92.8675, -53.8043>, <-20.8963, 92.2314, -54.1175> }
				triangle { <-22.06737, 92.8675, -53.8043>, <-23.8869, 90.8659, -56.8946>, <-20.8963, 92.2314, -54.1175> }
				triangle { <-23.8869, 90.8659, -56.8946>, <-20.2096, 91.8427, -54.1631>, <-20.8963, 92.2314, -54.1175> }
				triangle { <-20.8963, 92.2314, -54.1175>, <-20.2096, 91.8427, -54.1631>, <-20.3462, 89.9021, -43.6933> }
				triangle { <-20.3462, 89.9021, -43.6933>, <-20.2096, 91.8427, -54.1631>, <-18.9172, 89.2397, -43.9273> }
				triangle { <-18.9172, 89.2397, -43.9273>, <-23.7703, 81.08941, -28.9771>, <-20.3462, 89.9021, -43.6933> }
				triangle { <-23.7703, 81.08941, -28.9771>, <-18.9172, 89.2397, -43.9273>, <-21.1251, 83.2282, -33.1686> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-24.205, 77.07513, -25.4233>, <-24.8295, 78.6737, -26.07926>, 0.09186 }
				cylinder { <-24.8295, 78.6737, -26.07926>, <-25.4539, 80.2724, -26.7351>, 0.09186 }
				cylinder { <-25.4539, 80.2724, -26.7351>, <-26.07845, 81.871, -27.391>, 0.09186 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-29.4019, 85.8798, -29.4918>, <-33.5284, 95.4649, -35.494>, <-26.07845, 81.871, -27.391> }
				triangle { <-29.4019, 85.8798, -29.4918>, <-34.9841, 95.1815, -34.7989>, <-33.5284, 95.4649, -35.494> }
				triangle { <-34.9841, 95.1815, -34.7989>, <-40.7848, 100.2083, -41.7256>, <-33.5284, 95.4649, -35.494> }
				triangle { <-33.5284, 95.4649, -35.494>, <-40.7848, 100.2083, -41.7256>, <-39.7631, 100.4696, -42.5985> }
				triangle { <-40.7848, 100.2083, -41.7256>, <-42.979, 98.7244, -44.8642>, <-39.7631, 100.4696, -42.5985> }
				triangle { <-42.979, 98.7244, -44.8642>, <-39.09283, 100.5641, -43.00651>, <-39.7631, 100.4696, -42.5985> }
				triangle { <-39.7631, 100.4696, -42.5985>, <-39.09283, 100.5641, -43.00651>, <-33.5284, 95.4649, -35.494> }
				triangle { <-33.5284, 95.4649, -35.494>, <-39.09283, 100.5641, -43.00651>, <-32.2528, 95.8207, -36.3783> }
				triangle { <-32.2528, 95.8207, -36.3783>, <-26.07845, 81.871, -27.391>, <-33.5284, 95.4649, -35.494> }
				triangle { <-26.07845, 81.871, -27.391>, <-32.2528, 95.8207, -36.3783>, <-26.7268, 86.3744, -30.2961> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <-0.0, 5.2338, 0.0>, <-0.01875, 5.3161, -0.01969>, 0.06502 }
		cylinder { <-0.01875, 5.3161, -0.01969>, <-0.05436, 5.3857, -0.05709>, 0.06502 }
		cylinder { <-0.05436, 5.3857, -0.05709>, <-0.1032, 5.4356, -0.1084>, 0.06502 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1032, 5.4356, -0.1084>, <-1.1131, 6.1283, -1.1691>, 0.081 }
			cylinder { <-1.1131, 6.1283, -1.1691>, <-2.1897, 6.5604, -2.2999>, 0.081 }
			cylinder { <-2.1897, 6.5604, -2.2999>, <-3.3015, 6.7192, -3.4677>, 0.081 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-3.3015, 6.7192, -3.4677>, <-3.635, 6.7669, -3.818>, 0.081 }
				cylinder { <-3.635, 6.7669, -3.818>, <-3.9685, 6.8145, -4.1683>, 0.081 }
				cylinder { <-3.9685, 6.8145, -4.1683>, <-4.3021, 6.8622, -4.5186>, 0.081 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-4.3021, 6.8622, -4.5186>, <-4.3469, 6.8671, -4.5454>, 0.002624 }
				cylinder { <-4.3469, 6.8671, -4.5454>, <-4.3974, 6.8715, -4.5593>, 0.002624 }
				cylinder { <-4.3974, 6.8715, -4.5593>, <-4.4497, 6.8751, -4.5591>, 0.002624 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-5.3706, 6.6992, -4.4114>, <-7.392, 6.5908, -4.6189>, <-4.4497, 6.8751, -4.5591> }
				triangle { <-5.3706, 6.6992, -4.4114>, <-7.3992, 6.4756, -4.3673>, <-7.392, 6.5908, -4.6189> }
				triangle { <-7.3992, 6.4756, -4.3673>, <-8.9474, 5.6804, -4.5251>, <-7.392, 6.5908, -4.6189> }
				triangle { <-7.392, 6.5908, -4.6189>, <-8.9474, 5.6804, -4.5251>, <-8.977, 5.7309, -4.7489> }
				triangle { <-8.9474, 5.6804, -4.5251>, <-9.09018, 5.01673, -4.6701>, <-8.977, 5.7309, -4.7489> }
				triangle { <-9.09018, 5.01673, -4.6701>, <-8.9745, 5.7724, -4.8759>, <-8.977, 5.7309, -4.7489> }
				triangle { <-8.977, 5.7309, -4.7489>, <-8.9745, 5.7724, -4.8759>, <-7.392, 6.5908, -4.6189> }
				triangle { <-7.392, 6.5908, -4.6189>, <-8.9745, 5.7724, -4.8759>, <-7.4194, 6.6759, -4.8728> }
				triangle { <-7.4194, 6.6759, -4.8728>, <-4.4497, 6.8751, -4.5591>, <-7.392, 6.5908, -4.6189> }
				triangle { <-4.4497, 6.8751, -4.5591>, <-7.4194, 6.6759, -4.8728>, <-5.322, 6.9526, -4.8156> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-4.3021, 6.8622, -4.5186>, <-4.6356, 6.9098, -4.8689>, 0.081 }
				cylinder { <-4.6356, 6.9098, -4.8689>, <-4.9691, 6.9574, -5.2192>, 0.081 }
				cylinder { <-4.9691, 6.9574, -5.2192>, <-5.3026, 7.005126, -5.5695>, 0.081 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-5.3026, 7.005126, -5.5695>, <-5.3272, 7.01008, -5.6157>, 0.002624 }
				cylinder { <-5.3272, 7.01008, -5.6157>, <-5.3386, 7.01449, -5.6667>, 0.002624 }
				cylinder { <-5.3386, 7.01449, -5.6667>, <-5.3359, 7.01804, -5.719>, 0.002624 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-5.466, 6.8651, -6.6467>, <-5.1867, 6.7291, -8.6577>, <-5.3359, 7.01804, -5.719> }
				triangle { <-5.466, 6.8651, -6.6467>, <-5.4515, 6.6508, -8.6767>, <-5.1867, 6.7291, -8.6577> }
				triangle { <-5.4515, 6.6508, -8.6767>, <-5.3394, 5.8417, -10.2217>, <-5.1867, 6.7291, -8.6577> }
				triangle { <-5.1867, 6.7291, -8.6577>, <-5.3394, 5.8417, -10.2217>, <-5.1096, 5.86, -10.2411> }
				triangle { <-5.3394, 5.8417, -10.2217>, <-5.2836, 5.1642, -10.3623>, <-5.1096, 5.86, -10.2411> }
				triangle { <-5.2836, 5.1642, -10.3623>, <-4.9783, 5.8831, -10.2328>, <-5.1096, 5.86, -10.2411> }
				triangle { <-5.1096, 5.86, -10.2411>, <-4.9783, 5.8831, -10.2328>, <-5.1867, 6.7291, -8.6577> }
				triangle { <-5.1867, 6.7291, -8.6577>, <-4.9783, 5.8831, -10.2328>, <-4.9223, 6.7774, -8.6733> }
				triangle { <-4.9223, 6.7774, -8.6733>, <-5.3359, 7.01804, -5.719>, <-5.1867, 6.7291, -8.6577> }
				triangle { <-5.3359, 7.01804, -5.719>, <-4.9223, 6.7774, -8.6733>, <-5.0327, 7.05877, -6.5787> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-5.3026, 7.005126, -5.5695>, <-5.6362, 7.05276, -5.9198>, 0.081 }
				cylinder { <-5.6362, 7.05276, -5.9198>, <-5.9697, 7.1004, -6.2702>, 0.081 }
				cylinder { <-5.9697, 7.1004, -6.2702>, <-6.3032, 7.148, -6.6205>, 0.081 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-6.3032, 7.148, -6.6205>, <-6.3481, 7.153, -6.6473>, 0.002624 }
				cylinder { <-6.3481, 7.153, -6.6473>, <-6.3985, 7.1574, -6.6611>, 0.002624 }
				cylinder { <-6.3985, 7.1574, -6.6611>, <-6.4509, 7.1609, -6.661>, 0.002624 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-7.3718, 6.985, -6.5133>, <-9.3932, 6.8766, -6.7208>, <-6.4509, 7.1609, -6.661> }
				triangle { <-7.3718, 6.985, -6.5133>, <-9.4004, 6.7615, -6.4692>, <-9.3932, 6.8766, -6.7208> }
				triangle { <-9.4004, 6.7615, -6.4692>, <-10.9486, 5.9662, -6.6269>, <-9.3932, 6.8766, -6.7208> }
				triangle { <-9.3932, 6.8766, -6.7208>, <-10.9486, 5.9662, -6.6269>, <-10.9782, 6.01681, -6.8508> }
				triangle { <-10.9486, 5.9662, -6.6269>, <-11.09135, 5.3025, -6.772>, <-10.9782, 6.01681, -6.8508> }
				triangle { <-11.09135, 5.3025, -6.772>, <-10.9757, 6.05825, -6.9778>, <-10.9782, 6.01681, -6.8508> }
				triangle { <-10.9782, 6.01681, -6.8508>, <-10.9757, 6.05825, -6.9778>, <-9.3932, 6.8766, -6.7208> }
				triangle { <-9.3932, 6.8766, -6.7208>, <-10.9757, 6.05825, -6.9778>, <-9.4205, 6.9617, -6.9747> }
				triangle { <-9.4205, 6.9617, -6.9747>, <-6.4509, 7.1609, -6.661>, <-9.3932, 6.8766, -6.7208> }
				triangle { <-6.4509, 7.1609, -6.661>, <-9.4205, 6.9617, -6.9747>, <-7.3231, 7.2384, -6.9175> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-6.3032, 7.148, -6.6205>, <-6.6367, 7.1956, -6.9708>, 0.081 }
				cylinder { <-6.6367, 7.1956, -6.9708>, <-6.9703, 7.2433, -7.3211>, 0.081 }
				cylinder { <-6.9703, 7.2433, -7.3211>, <-7.3038, 7.2909, -7.6714>, 0.081 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-7.3038, 7.2909, -7.6714>, <-7.3284, 7.2959, -7.7175>, 0.002624 }
				cylinder { <-7.3284, 7.2959, -7.7175>, <-7.3397, 7.3003, -7.7686>, 0.002624 }
				cylinder { <-7.3397, 7.3003, -7.7686>, <-7.337, 7.3038, -7.8209>, 0.002624 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-7.4672, 7.1509, -8.7485>, <-7.1878, 7.01498, -10.7596>, <-7.337, 7.3038, -7.8209> }
				triangle { <-7.4672, 7.1509, -8.7485>, <-7.4527, 6.9366, -10.7785>, <-7.1878, 7.01498, -10.7596> }
				triangle { <-7.4527, 6.9366, -10.7785>, <-7.3406, 6.1275, -12.3235>, <-7.1878, 7.01498, -10.7596> }
				triangle { <-7.1878, 7.01498, -10.7596>, <-7.3406, 6.1275, -12.3235>, <-7.1107, 6.1459, -12.343> }
				triangle { <-7.3406, 6.1275, -12.3235>, <-7.2847, 5.45, -12.4642>, <-7.1107, 6.1459, -12.343> }
				triangle { <-7.2847, 5.45, -12.4642>, <-6.9794, 6.1689, -12.3346>, <-7.1107, 6.1459, -12.343> }
				triangle { <-7.1107, 6.1459, -12.343>, <-6.9794, 6.1689, -12.3346>, <-7.1878, 7.01498, -10.7596> }
				triangle { <-7.1878, 7.01498, -10.7596>, <-6.9794, 6.1689, -12.3346>, <-6.9235, 7.06326, -10.7752> }
				triangle { <-6.9235, 7.06326, -10.7752>, <-7.337, 7.3038, -7.8209>, <-7.1878, 7.01498, -10.7596> }
				triangle { <-7.337, 7.3038, -7.8209>, <-6.9235, 7.06326, -10.7752>, <-7.03386, 7.3446, -8.6805> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-7.3038, 7.2909, -7.6714>, <-7.6373, 7.3386, -8.02177>, 0.081 }
				cylinder { <-7.6373, 7.3386, -8.02177>, <-7.9708, 7.3862, -8.372>, 0.081 }
				cylinder { <-7.9708, 7.3862, -8.372>, <-8.3044, 7.4338, -8.7224>, 0.081 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-8.3044, 7.4338, -8.7224>, <-8.3492, 7.4388, -8.7492>, 0.002624 }
				cylinder { <-8.3492, 7.4388, -8.7492>, <-8.3997, 7.4432, -8.763>, 0.002624 }
				cylinder { <-8.3997, 7.4432, -8.763>, <-8.4521, 7.4468, -8.7629>, 0.002624 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-9.373, 7.2708, -8.6152>, <-11.3944, 7.1625, -8.8227>, <-8.4521, 7.4468, -8.7629> }
				triangle { <-9.373, 7.2708, -8.6152>, <-11.4015, 7.04736, -8.571>, <-11.3944, 7.1625, -8.8227> }
				triangle { <-11.4015, 7.04736, -8.571>, <-12.9497, 6.2521, -8.7288>, <-11.3944, 7.1625, -8.8227> }
				triangle { <-11.3944, 7.1625, -8.8227>, <-12.9497, 6.2521, -8.7288>, <-12.9793, 6.3026, -8.9527> }
				triangle { <-12.9497, 6.2521, -8.7288>, <-13.0925, 5.5884, -8.8738>, <-12.9793, 6.3026, -8.9527> }
				triangle { <-13.0925, 5.5884, -8.8738>, <-12.9768, 6.344, -9.07971>, <-12.9793, 6.3026, -8.9527> }
				triangle { <-12.9793, 6.3026, -8.9527>, <-12.9768, 6.344, -9.07971>, <-11.3944, 7.1625, -8.8227> }
				triangle { <-11.3944, 7.1625, -8.8227>, <-12.9768, 6.344, -9.07971>, <-11.4217, 7.2475, -9.07663> }
				triangle { <-11.4217, 7.2475, -9.07663>, <-8.4521, 7.4468, -8.7629>, <-11.3944, 7.1625, -8.8227> }
				triangle { <-8.4521, 7.4468, -8.7629>, <-11.4217, 7.2475, -9.07663>, <-9.3243, 7.5243, -9.01939> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-8.3044, 7.4338, -8.7224>, <-8.6379, 7.4815, -9.07271>, 0.081 }
				cylinder { <-8.6379, 7.4815, -9.07271>, <-8.9714, 7.5291, -9.423>, 0.081 }
				cylinder { <-8.9714, 7.5291, -9.423>, <-9.3049, 7.5767, -9.7733>, 0.081 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-9.3049, 7.5767, -9.7733>, <-9.3295, 7.5817, -9.8194>, 0.002624 }
				cylinder { <-9.3295, 7.5817, -9.8194>, <-9.3409, 7.5861, -9.8705>, 0.002624 }
				cylinder { <-9.3409, 7.5861, -9.8705>, <-9.3382, 7.5897, -9.9228>, 0.002624 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-9.4683, 7.4368, -10.8504>, <-9.189, 7.3008, -12.8615>, <-9.3382, 7.5897, -9.9228> }
				triangle { <-9.4683, 7.4368, -10.8504>, <-9.4538, 7.2224, -12.8804>, <-9.189, 7.3008, -12.8615> }
				triangle { <-9.4538, 7.2224, -12.8804>, <-9.3417, 6.4134, -14.4254>, <-9.189, 7.3008, -12.8615> }
				triangle { <-9.189, 7.3008, -12.8615>, <-9.3417, 6.4134, -14.4254>, <-9.1119, 6.4317, -14.4449> }
				triangle { <-9.3417, 6.4134, -14.4254>, <-9.2859, 5.7359, -14.5661>, <-9.1119, 6.4317, -14.4449> }
				triangle { <-9.2859, 5.7359, -14.5661>, <-8.9806, 6.4548, -14.4365>, <-9.1119, 6.4317, -14.4449> }
				triangle { <-9.1119, 6.4317, -14.4449>, <-8.9806, 6.4548, -14.4365>, <-9.189, 7.3008, -12.8615> }
				triangle { <-9.189, 7.3008, -12.8615>, <-8.9806, 6.4548, -14.4365>, <-8.9247, 7.3491, -12.8771> }
				triangle { <-8.9247, 7.3491, -12.8771>, <-9.3382, 7.5897, -9.9228>, <-9.189, 7.3008, -12.8615> }
				triangle { <-9.3382, 7.5897, -9.9228>, <-8.9247, 7.3491, -12.8771>, <-9.03502, 7.6304, -10.7824> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-9.3049, 7.5767, -9.7733>, <-9.341, 7.5819, -9.8111>, 0.002624 }
				cylinder { <-9.341, 7.5819, -9.8111>, <-9.377, 7.587, -9.849>, 0.002624 }
				cylinder { <-9.377, 7.587, -9.849>, <-9.413, 7.5922, -9.8868>, 0.002624 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-10.1683, 7.4554, -10.4451>, <-11.4236, 7.3943, -12.04558>, <-9.413, 7.5922, -9.8868> }
				triangle { <-10.1683, 7.4554, -10.4451>, <-11.6179, 7.2976, -11.8737>, <-11.4236, 7.3943, -12.04558> }
				triangle { <-11.6179, 7.2976, -11.8737>, <-12.6316, 6.5408, -13.07947>, <-11.4236, 7.3943, -12.04558> }
				triangle { <-11.4236, 7.3943, -12.04558>, <-12.6316, 6.5408, -13.07947>, <-12.4874, 6.5762, -13.2569> }
				triangle { <-12.6316, 6.5408, -13.07947>, <-12.6739, 5.8731, -13.2648>, <-12.4874, 6.5762, -13.2569> }
				triangle { <-12.6739, 5.8731, -13.2648>, <-12.3913, 6.6085, -13.3439>, <-12.4874, 6.5762, -13.2569> }
				triangle { <-12.4874, 6.5762, -13.2569>, <-12.3913, 6.6085, -13.3439>, <-11.4236, 7.3943, -12.04558> }
				triangle { <-11.4236, 7.3943, -12.04558>, <-12.3913, 6.6085, -13.3439>, <-11.2537, 7.462, -12.243> }
				triangle { <-11.2537, 7.462, -12.243>, <-9.413, 7.5922, -9.8868>, <-11.4236, 7.3943, -12.04558> }
				triangle { <-9.413, 7.5922, -9.8868>, <-11.2537, 7.462, -12.243>, <-9.8256, 7.6779, -10.6961> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <-0.1032, 5.4356, -0.1084>, <-0.1238, 5.4567, -0.13>, 0.02737 }
		cylinder { <-0.1238, 5.4567, -0.13>, <-0.1443, 5.4777, -0.1516>, 0.02737 }
		cylinder { <-0.1443, 5.4777, -0.1516>, <-0.1649, 5.4987, -0.1732>, 0.02737 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1649, 5.4987, -0.1732>, <-0.5787, 5.9705, -0.4907>, 0.03516 }
			cylinder { <-0.5787, 5.9705, -0.4907>, <-0.9975, 6.4954, -0.6999>, 0.03516 }
			cylinder { <-0.9975, 6.4954, -0.6999>, <-1.4091, 7.05777, -0.7946>, 0.03516 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-1.4091, 7.05777, -0.7946>, <-1.5326, 7.2264, -0.823>, 0.03516 }
				cylinder { <-1.5326, 7.2264, -0.823>, <-1.6561, 7.3951, -0.8514>, 0.03516 }
				cylinder { <-1.6561, 7.3951, -0.8514>, <-1.7796, 7.5638, -0.8798>, 0.03516 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-1.7796, 7.5638, -0.8798>, <-1.783, 7.5729, -0.8817>, 0.0004946 }
				cylinder { <-1.783, 7.5729, -0.8817>, <-1.7839, 7.5825, -0.884>, 0.0004946 }
				cylinder { <-1.7839, 7.5825, -0.884>, <-1.7821, 7.5919, -0.8866>, 0.0004946 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-1.6323, 7.9755, -0.8985>, <-1.5469, 8.8474, -1.01167>, <-1.7821, 7.5919, -0.8866> }
				triangle { <-1.6323, 7.9755, -0.8985>, <-1.4323, 8.8351, -0.9779>, <-1.5469, 8.8474, -1.01167> }
				triangle { <-1.4323, 8.8351, -0.9779>, <-1.3146, 9.5534, -0.764>, <-1.5469, 8.8474, -1.01167> }
				triangle { <-1.5469, 8.8474, -1.01167>, <-1.3146, 9.5534, -0.764>, <-1.4099, 9.5831, -0.7752> }
				triangle { <-1.3146, 9.5534, -0.764>, <-1.3157, 9.6738, -0.4878>, <-1.4099, 9.5831, -0.7752> }
				triangle { <-1.3157, 9.6738, -0.4878>, <-1.4665, 9.591, -0.7853>, <-1.4099, 9.5831, -0.7752> }
				triangle { <-1.4099, 9.5831, -0.7752>, <-1.4665, 9.591, -0.7853>, <-1.5469, 8.8474, -1.01167> }
				triangle { <-1.5469, 8.8474, -1.01167>, <-1.4665, 9.591, -0.7853>, <-1.6576, 8.8765, -1.0355> }
				triangle { <-1.6576, 8.8765, -1.0355>, <-1.7821, 7.5919, -0.8866>, <-1.5469, 8.8474, -1.01167> }
				triangle { <-1.7821, 7.5919, -0.8866>, <-1.6576, 8.8765, -1.0355>, <-1.8245, 7.9749, -0.9784> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-1.7796, 7.5638, -0.8798>, <-1.9031, 7.7325, -0.9082>, 0.03516 }
				cylinder { <-1.9031, 7.7325, -0.9082>, <-2.02658, 7.9013, -0.9366>, 0.03516 }
				cylinder { <-2.02658, 7.9013, -0.9366>, <-2.15, 8.07001, -0.9651>, 0.03516 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-2.15, 8.07001, -0.9651>, <-2.1577, 8.07618, -0.9657>, 0.0004946 }
				cylinder { <-2.1577, 8.07618, -0.9657>, <-2.1668, 8.08017, -0.9657>, 0.0004946 }
				cylinder { <-2.1668, 8.08017, -0.9657>, <-2.1765, 8.08169, -0.965>, 0.0004946 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-2.5445, 8.2335, -0.8589>, <-3.4023, 8.3141, -0.6639>, <-2.1765, 8.08169, -0.965> }
				triangle { <-2.5445, 8.2335, -0.8589>, <-3.383, 8.4321, -0.6521>, <-3.4023, 8.3141, -0.6639> }
				triangle { <-3.383, 8.4321, -0.6521>, <-3.9825, 8.587, -0.2137>, <-3.4023, 8.3141, -0.6639> }
				triangle { <-3.4023, 8.3141, -0.6639>, <-3.9825, 8.587, -0.2137>, <-4.01075, 8.4914, -0.2009> }
				triangle { <-3.9825, 8.587, -0.2137>, <-3.9969, 8.6249, 0.08487>, <-4.01075, 8.4914, -0.2009> }
				triangle { <-3.9969, 8.6249, 0.08487>, <-4.01962, 8.4341, -0.2>, <-4.01075, 8.4914, -0.2009> }
				triangle { <-4.01075, 8.4914, -0.2009>, <-4.01962, 8.4341, -0.2>, <-3.4023, 8.3141, -0.6639> }
				triangle { <-3.4023, 8.3141, -0.6639>, <-4.01962, 8.4341, -0.2>, <-3.4339, 8.2016, -0.6611> }
				triangle { <-3.4339, 8.2016, -0.6611>, <-2.1765, 8.08169, -0.965>, <-3.4023, 8.3141, -0.6639> }
				triangle { <-2.1765, 8.08169, -0.965>, <-3.4339, 8.2016, -0.6611>, <-2.5653, 8.0323, -0.9078> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-2.15, 8.07001, -0.9651>, <-2.2735, 8.2387, -0.9935>, 0.03516 }
				cylinder { <-2.2735, 8.2387, -0.9935>, <-2.397, 8.4074, -1.02192>, 0.03516 }
				cylinder { <-2.397, 8.4074, -1.02192>, <-2.5205, 8.5761, -1.05033>, 0.03516 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-2.5205, 8.5761, -1.05033>, <-2.5239, 8.5852, -1.05222>, 0.0004946 }
				cylinder { <-2.5239, 8.5852, -1.05222>, <-2.5248, 8.5947, -1.05454>, 0.0004946 }
				cylinder { <-2.5248, 8.5947, -1.05454>, <-2.523, 8.6041, -1.05711>, 0.0004946 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-2.3732, 8.9877, -1.06899>, <-2.2878, 9.8597, -1.1821>, <-2.523, 8.6041, -1.05711> }
				triangle { <-2.3732, 8.9877, -1.06899>, <-2.1731, 9.8474, -1.1484>, <-2.2878, 9.8597, -1.1821> }
				triangle { <-2.1731, 9.8474, -1.1484>, <-2.05555, 10.5657, -0.9345>, <-2.2878, 9.8597, -1.1821> }
				triangle { <-2.2878, 9.8597, -1.1821>, <-2.05555, 10.5657, -0.9345>, <-2.1508, 10.5953, -0.9456> }
				triangle { <-2.05555, 10.5657, -0.9345>, <-2.0566, 10.686, -0.6582>, <-2.1508, 10.5953, -0.9456> }
				triangle { <-2.0566, 10.686, -0.6582>, <-2.2074, 10.6032, -0.9557>, <-2.1508, 10.5953, -0.9456> }
				triangle { <-2.1508, 10.5953, -0.9456>, <-2.2074, 10.6032, -0.9557>, <-2.2878, 9.8597, -1.1821> }
				triangle { <-2.2878, 9.8597, -1.1821>, <-2.2074, 10.6032, -0.9557>, <-2.3985, 9.8887, -1.2059> }
				triangle { <-2.3985, 9.8887, -1.2059>, <-2.523, 8.6041, -1.05711>, <-2.2878, 9.8597, -1.1821> }
				triangle { <-2.523, 8.6041, -1.05711>, <-2.3985, 9.8887, -1.2059>, <-2.5654, 8.9871, -1.1489> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-2.5205, 8.5761, -1.05033>, <-2.6439, 8.7448, -1.07874>, 0.03516 }
				cylinder { <-2.6439, 8.7448, -1.07874>, <-2.7674, 8.9135, -1.1071>, 0.03516 }
				cylinder { <-2.7674, 8.9135, -1.1071>, <-2.8909, 9.08225, -1.1355>, 0.03516 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-2.8909, 9.08225, -1.1355>, <-2.8986, 9.08842, -1.1362>, 0.0004946 }
				cylinder { <-2.8986, 9.08842, -1.1362>, <-2.9077, 9.09242, -1.1362>, 0.0004946 }
				cylinder { <-2.9077, 9.09242, -1.1362>, <-2.9174, 9.09394, -1.1354>, 0.0004946 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-3.2854, 9.2457, -1.02937>, <-4.1432, 9.3263, -0.8344>, <-2.9174, 9.09394, -1.1354> }
				triangle { <-3.2854, 9.2457, -1.02937>, <-4.1239, 9.4444, -0.8226>, <-4.1432, 9.3263, -0.8344> }
				triangle { <-4.1239, 9.4444, -0.8226>, <-4.7234, 9.5992, -0.3842>, <-4.1432, 9.3263, -0.8344> }
				triangle { <-4.1432, 9.3263, -0.8344>, <-4.7234, 9.5992, -0.3842>, <-4.7516, 9.5037, -0.3714> }
				triangle { <-4.7234, 9.5992, -0.3842>, <-4.7377, 9.6371, -0.08559>, <-4.7516, 9.5037, -0.3714> }
				triangle { <-4.7377, 9.6371, -0.08559>, <-4.7605, 9.4463, -0.3705>, <-4.7516, 9.5037, -0.3714> }
				triangle { <-4.7516, 9.5037, -0.3714>, <-4.7605, 9.4463, -0.3705>, <-4.1432, 9.3263, -0.8344> }
				triangle { <-4.1432, 9.3263, -0.8344>, <-4.7605, 9.4463, -0.3705>, <-4.1748, 9.2139, -0.8316> }
				triangle { <-4.1748, 9.2139, -0.8316>, <-2.9174, 9.09394, -1.1354>, <-4.1432, 9.3263, -0.8344> }
				triangle { <-2.9174, 9.09394, -1.1354>, <-4.1748, 9.2139, -0.8316>, <-3.3062, 9.04454, -1.07835> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-2.8909, 9.08225, -1.1355>, <-3.01443, 9.2509, -1.1639>, 0.03516 }
				cylinder { <-3.01443, 9.2509, -1.1639>, <-3.1379, 9.4196, -1.1923>, 0.03516 }
				cylinder { <-3.1379, 9.4196, -1.1923>, <-3.2613, 9.5883, -1.2208>, 0.03516 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-3.2613, 9.5883, -1.2208>, <-3.2648, 9.5974, -1.2226>, 0.0004946 }
				cylinder { <-3.2648, 9.5974, -1.2226>, <-3.2657, 9.607, -1.225>, 0.0004946 }
				cylinder { <-3.2657, 9.607, -1.225>, <-3.2639, 9.6164, -1.2275>, 0.0004946 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-3.1141, 10.00003, -1.2394>, <-3.02876, 10.8719, -1.3526>, <-3.2639, 9.6164, -1.2275> }
				triangle { <-3.1141, 10.00003, -1.2394>, <-2.914, 10.8596, -1.3188>, <-3.02876, 10.8719, -1.3526> }
				triangle { <-2.914, 10.8596, -1.3188>, <-2.7964, 11.5779, -1.105>, <-3.02876, 10.8719, -1.3526> }
				triangle { <-3.02876, 10.8719, -1.3526>, <-2.7964, 11.5779, -1.105>, <-2.8917, 11.6076, -1.1161> }
				triangle { <-2.7964, 11.5779, -1.105>, <-2.7974, 11.6983, -0.8287>, <-2.8917, 11.6076, -1.1161> }
				triangle { <-2.7974, 11.6983, -0.8287>, <-2.9483, 11.6154, -1.1262>, <-2.8917, 11.6076, -1.1161> }
				triangle { <-2.8917, 11.6076, -1.1161>, <-2.9483, 11.6154, -1.1262>, <-3.02876, 10.8719, -1.3526> }
				triangle { <-3.02876, 10.8719, -1.3526>, <-2.9483, 11.6154, -1.1262>, <-3.1393, 10.901, -1.3764> }
				triangle { <-3.1393, 10.901, -1.3764>, <-3.2639, 9.6164, -1.2275>, <-3.02876, 10.8719, -1.3526> }
				triangle { <-3.2639, 9.6164, -1.2275>, <-3.1393, 10.901, -1.3764>, <-3.3063, 9.9993, -1.3194> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-3.2613, 9.5883, -1.2208>, <-3.3848, 9.757, -1.2492>, 0.03516 }
				cylinder { <-3.3848, 9.757, -1.2492>, <-3.5083, 9.9257, -1.2776>, 0.03516 }
				cylinder { <-3.5083, 9.9257, -1.2776>, <-3.6318, 10.09449, -1.306>, 0.03516 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-3.6318, 10.09449, -1.306>, <-3.6395, 10.1006, -1.3067>, 0.0004946 }
				cylinder { <-3.6395, 10.1006, -1.3067>, <-3.6485, 10.1046, -1.3066>, 0.0004946 }
				cylinder { <-3.6485, 10.1046, -1.3066>, <-3.6583, 10.1061, -1.3059>, 0.0004946 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-4.02635, 10.258, -1.1998>, <-4.8841, 10.3386, -1.004906>, <-3.6583, 10.1061, -1.3059> }
				triangle { <-4.02635, 10.258, -1.1998>, <-4.8648, 10.4566, -0.9931>, <-4.8841, 10.3386, -1.004906> }
				triangle { <-4.8648, 10.4566, -0.9931>, <-5.4643, 10.6115, -0.5546>, <-4.8841, 10.3386, -1.004906> }
				triangle { <-4.8841, 10.3386, -1.004906>, <-5.4643, 10.6115, -0.5546>, <-5.4925, 10.5159, -0.5419> }
				triangle { <-5.4643, 10.6115, -0.5546>, <-5.4786, 10.6494, -0.256>, <-5.4925, 10.5159, -0.5419> }
				triangle { <-5.4786, 10.6494, -0.256>, <-5.5013, 10.4586, -0.541>, <-5.4925, 10.5159, -0.5419> }
				triangle { <-5.4925, 10.5159, -0.5419>, <-5.5013, 10.4586, -0.541>, <-4.8841, 10.3386, -1.004906> }
				triangle { <-4.8841, 10.3386, -1.004906>, <-5.5013, 10.4586, -0.541>, <-4.9157, 10.2261, -1.002082> }
				triangle { <-4.9157, 10.2261, -1.002082>, <-3.6583, 10.1061, -1.3059>, <-4.8841, 10.3386, -1.004906> }
				triangle { <-3.6583, 10.1061, -1.3059>, <-4.9157, 10.2261, -1.002082>, <-4.04717, 10.05679, -1.2488> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-3.6318, 10.09449, -1.306>, <-3.6376, 10.1024, -1.3073>, 0.0004946 }
				cylinder { <-3.6376, 10.1024, -1.3073>, <-3.6434, 10.1103, -1.3087>, 0.0004946 }
				cylinder { <-3.6434, 10.1103, -1.3087>, <-3.6492, 10.1182, -1.31>, 0.0004946 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-3.8123, 10.4957, -1.2844>, <-4.378, 11.174, -1.2739>, <-3.6492, 10.1182, -1.31> }
				triangle { <-3.8123, 10.4957, -1.2844>, <-4.2829, 11.2461, -1.2592>, <-4.378, 11.174, -1.2739> }
				triangle { <-4.2829, 11.2461, -1.2592>, <-4.6519, 11.8361, -0.9571>, <-4.378, 11.174, -1.2739> }
				triangle { <-4.378, 11.174, -1.2739>, <-4.6519, 11.8361, -0.9571>, <-4.7408, 11.7899, -0.9498> }
				triangle { <-4.6519, 11.8361, -0.9571>, <-4.6778, 11.9185, -0.6684>, <-4.7408, 11.7899, -0.9498> }
				triangle { <-4.6778, 11.9185, -0.6684>, <-4.7876, 11.7555, -0.9504>, <-4.7408, 11.7899, -0.9498> }
				triangle { <-4.7408, 11.7899, -0.9498>, <-4.7876, 11.7555, -0.9504>, <-4.378, 11.174, -1.2739> }
				triangle { <-4.378, 11.174, -1.2739>, <-4.7876, 11.7555, -0.9504>, <-4.4797, 11.1166, -1.2769> }
				triangle { <-4.4797, 11.1166, -1.2769>, <-3.6492, 10.1182, -1.31>, <-4.378, 11.174, -1.2739> }
				triangle { <-3.6492, 10.1182, -1.31>, <-4.4797, 11.1166, -1.2769>, <-3.9618, 10.3601, -1.3352> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <-0.0, 5.2338, 0.0>, <-0.0, 5.5631, 0.0>, 0.247 }
		cylinder { <-0.0, 5.5631, 0.0>, <-0.0, 5.8925, 0.0>, 0.247 }
		cylinder { <-0.0, 5.8925, 0.0>, <-0.0, 6.2219, 0.0>, 0.247 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0, 6.2219, 0.0>, <0.03517, 14.4814, 1.4327>, 0.4191 }
			cylinder { <0.03517, 14.4814, 1.4327>, <0.1044, 22.3742, 4.2559>, 0.4191 }
			cylinder { <0.1044, 22.3742, 4.2559>, <0.2058, 29.668, 8.3866>, 0.4191 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.2058, 29.668, 8.3866>, <0.2363, 31.8562, 9.6258>, 0.4191 }
				cylinder { <0.2363, 31.8562, 9.6258>, <0.2667, 34.04438, 10.865>, 0.4191 }
				cylinder { <0.2667, 34.04438, 10.865>, <0.2971, 36.2325, 12.1042>, 0.4191 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.2971, 36.2325, 12.1042>, <0.6882, 37.4111, 12.7624>, 0.07027 }
				cylinder { <0.6882, 37.4111, 12.7624>, <1.4251, 38.4599, 13.3387>, 0.07027 }
				cylinder { <1.4251, 38.4599, 13.3387>, <2.4544, 39.3032, 13.7913>, 0.07027 }
				texture {fol5}}
			mesh { // leaf
				triangle { <6.4881, 41.01294, 16.01038>, <13.4449, 47.2221, 20.9001>, <2.4544, 39.3032, 13.7913> }
				triangle { <6.4881, 41.01294, 16.01038>, <14.3685, 46.129, 20.8362>, <13.4449, 47.2221, 20.9001> }
				triangle { <14.3685, 46.129, 20.8362>, <19.7746, 48.7591, 27.5909>, <13.4449, 47.2221, 20.9001> }
				triangle { <13.4449, 47.2221, 20.9001>, <19.7746, 48.7591, 27.5909>, <19.09514, 49.6819, 27.9377> }
				triangle { <19.7746, 48.7591, 27.5909>, <19.8758, 47.6425, 31.00338>, <19.09514, 49.6819, 27.9377> }
				triangle { <19.8758, 47.6425, 31.00338>, <18.6351, 50.1872, 28.04261>, <19.09514, 49.6819, 27.9377> }
				triangle { <19.09514, 49.6819, 27.9377>, <18.6351, 50.1872, 28.04261>, <13.4449, 47.2221, 20.9001> }
				triangle { <13.4449, 47.2221, 20.9001>, <18.6351, 50.1872, 28.04261>, <12.6477, 48.3332, 21.1638> }
				triangle { <12.6477, 48.3332, 21.1638>, <2.4544, 39.3032, 13.7913>, <13.4449, 47.2221, 20.9001> }
				triangle { <2.4544, 39.3032, 13.7913>, <12.6477, 48.3332, 21.1638>, <4.8569, 42.8642, 15.7502> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <0.2971, 36.2325, 12.1042>, <0.3275, 38.4206, 13.3434>, 0.4191 }
				cylinder { <0.3275, 38.4206, 13.3434>, <0.3579, 40.6088, 14.5826>, 0.4191 }
				cylinder { <0.3579, 40.6088, 14.5826>, <0.3884, 42.7969, 15.8218>, 0.4191 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.3884, 42.7969, 15.8218>, <0.03004, 43.9755, 16.4984>, 0.07027 }
				cylinder { <0.03004, 43.9755, 16.4984>, <-0.6776, 45.02443, 17.1102>, 0.07027 }
				cylinder { <-0.6776, 45.02443, 17.1102>, <-1.6835, 45.8676, 17.6127>, 0.07027 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-4.433, 48.6338, 20.5969>, <-12.546, 53.5753, 25.1382>, <-1.6835, 45.8676, 17.6127> }
				triangle { <-4.433, 48.6338, 20.5969>, <-11.5989, 54.1726, 26.03174>, <-12.546, 53.5753, 25.1382> }
				triangle { <-11.5989, 54.1726, 26.03174>, <-17.3694, 56.1688, 32.7015>, <-12.546, 53.5753, 25.1382> }
				triangle { <-12.546, 53.5753, 25.1382>, <-17.3694, 56.1688, 32.7015>, <-18.3122, 55.6125, 32.2166> }
				triangle { <-17.3694, 56.1688, 32.7015>, <-18.00534, 54.4182, 35.7728>, <-18.3122, 55.6125, 32.2166> }
				triangle { <-18.00534, 54.4182, 35.7728>, <-18.784, 55.2725, 31.8428>, <-18.3122, 55.6125, 32.2166> }
				triangle { <-18.3122, 55.6125, 32.2166>, <-18.784, 55.2725, 31.8428>, <-12.546, 53.5753, 25.1382> }
				triangle { <-12.546, 53.5753, 25.1382>, <-18.784, 55.2725, 31.8428>, <-13.6095, 52.9959, 24.4505> }
				triangle { <-13.6095, 52.9959, 24.4505>, <-1.6835, 45.8676, 17.6127>, <-12.546, 53.5753, 25.1382> }
				triangle { <-1.6835, 45.8676, 17.6127>, <-13.6095, 52.9959, 24.4505>, <-5.8596, 47.7383, 18.7752> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <0.3884, 42.7969, 15.8218>, <0.4188, 44.9851, 17.06102>, 0.4191 }
				cylinder { <0.4188, 44.9851, 17.06102>, <0.4492, 47.1732, 18.3002>, 0.4191 }
				cylinder { <0.4492, 47.1732, 18.3002>, <0.4796, 49.3614, 19.5394>, 0.4191 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.4796, 49.3614, 19.5394>, <0.8707, 50.5399, 20.1976>, 0.07027 }
				cylinder { <0.8707, 50.5399, 20.1976>, <1.6076, 51.5888, 20.7739>, 0.07027 }
				cylinder { <1.6076, 51.5888, 20.7739>, <2.637, 52.432, 21.2265>, 0.07027 }
				texture {fol5}}
			mesh { // leaf
				triangle { <6.6706, 54.1418, 23.4455>, <13.6274, 60.351, 28.3353>, <2.637, 52.432, 21.2265> }
				triangle { <6.6706, 54.1418, 23.4455>, <14.551, 59.2579, 28.2714>, <13.6274, 60.351, 28.3353> }
				triangle { <14.551, 59.2579, 28.2714>, <19.9571, 61.888, 35.02612>, <13.6274, 60.351, 28.3353> }
				triangle { <13.6274, 60.351, 28.3353>, <19.9571, 61.888, 35.02612>, <19.2776, 62.8108, 35.3729> }
				triangle { <19.9571, 61.888, 35.02612>, <20.05841, 60.7714, 38.4385>, <19.2776, 62.8108, 35.3729> }
				triangle { <20.05841, 60.7714, 38.4385>, <18.8176, 63.3161, 35.4778>, <19.2776, 62.8108, 35.3729> }
				triangle { <19.2776, 62.8108, 35.3729>, <18.8176, 63.3161, 35.4778>, <13.6274, 60.351, 28.3353> }
				triangle { <13.6274, 60.351, 28.3353>, <18.8176, 63.3161, 35.4778>, <12.8302, 61.4621, 28.599> }
				triangle { <12.8302, 61.4621, 28.599>, <2.637, 52.432, 21.2265>, <13.6274, 60.351, 28.3353> }
				triangle { <2.637, 52.432, 21.2265>, <12.8302, 61.4621, 28.599>, <5.03944, 55.9931, 23.1854> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <0.4796, 49.3614, 19.5394>, <0.51, 51.5495, 20.7786>, 0.4191 }
				cylinder { <0.51, 51.5495, 20.7786>, <0.5405, 53.7377, 22.01782>, 0.4191 }
				cylinder { <0.5405, 53.7377, 22.01782>, <0.5709, 55.9258, 23.257>, 0.4191 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.5709, 55.9258, 23.257>, <0.2125, 57.1044, 23.9336>, 0.07027 }
				cylinder { <0.2125, 57.1044, 23.9336>, <-0.4951, 58.1533, 24.5454>, 0.07027 }
				cylinder { <-0.4951, 58.1533, 24.5454>, <-1.501, 58.9965, 25.04792>, 0.07027 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-4.2505, 61.7627, 28.03218>, <-12.3635, 66.7042, 32.5734>, <-1.501, 58.9965, 25.04792> }
				triangle { <-4.2505, 61.7627, 28.03218>, <-11.4164, 67.3015, 33.4669>, <-12.3635, 66.7042, 32.5734> }
				triangle { <-11.4164, 67.3015, 33.4669>, <-17.1869, 69.2977, 40.1367>, <-12.3635, 66.7042, 32.5734> }
				triangle { <-12.3635, 66.7042, 32.5734>, <-17.1869, 69.2977, 40.1367>, <-18.1297, 68.7414, 39.6518> }
				triangle { <-17.1869, 69.2977, 40.1367>, <-17.8228, 67.5471, 43.208>, <-18.1297, 68.7414, 39.6518> }
				triangle { <-17.8228, 67.5471, 43.208>, <-18.6015, 68.4014, 39.278>, <-18.1297, 68.7414, 39.6518> }
				triangle { <-18.1297, 68.7414, 39.6518>, <-18.6015, 68.4014, 39.278>, <-12.3635, 66.7042, 32.5734> }
				triangle { <-12.3635, 66.7042, 32.5734>, <-18.6015, 68.4014, 39.278>, <-13.427, 66.1248, 31.8857> }
				triangle { <-13.427, 66.1248, 31.8857>, <-1.501, 58.9965, 25.04792>, <-12.3635, 66.7042, 32.5734> }
				triangle { <-1.501, 58.9965, 25.04792>, <-13.427, 66.1248, 31.8857>, <-5.6771, 60.8672, 26.2104> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <0.5709, 55.9258, 23.257>, <0.6013, 58.114, 24.4962>, 0.4191 }
				cylinder { <0.6013, 58.114, 24.4962>, <0.6317, 60.3021, 25.7354>, 0.4191 }
				cylinder { <0.6317, 60.3021, 25.7354>, <0.6621, 62.4903, 26.9746>, 0.4191 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.6621, 62.4903, 26.9746>, <1.05331, 63.6688, 27.6328>, 0.07027 }
				cylinder { <1.05331, 63.6688, 27.6328>, <1.7902, 64.7177, 28.2091>, 0.07027 }
				cylinder { <1.7902, 64.7177, 28.2091>, <2.8195, 65.5609, 28.6616>, 0.07027 }
				texture {fol5}}
			mesh { // leaf
				triangle { <6.8531, 67.2707, 30.8807>, <13.8099, 73.4799, 35.7705>, <2.8195, 65.5609, 28.6616> }
				triangle { <6.8531, 67.2707, 30.8807>, <14.7335, 72.3868, 35.7066>, <13.8099, 73.4799, 35.7705> }
				triangle { <14.7335, 72.3868, 35.7066>, <20.1397, 75.01698, 42.4613>, <13.8099, 73.4799, 35.7705> }
				triangle { <13.8099, 73.4799, 35.7705>, <20.1397, 75.01698, 42.4613>, <19.4601, 75.9397, 42.8081> }
				triangle { <20.1397, 75.01698, 42.4613>, <20.2409, 73.9002, 45.8737>, <19.4601, 75.9397, 42.8081> }
				triangle { <20.2409, 73.9002, 45.8737>, <19.00019, 76.4449, 42.9129>, <19.4601, 75.9397, 42.8081> }
				triangle { <19.4601, 75.9397, 42.8081>, <19.00019, 76.4449, 42.9129>, <13.8099, 73.4799, 35.7705> }
				triangle { <13.8099, 73.4799, 35.7705>, <19.00019, 76.4449, 42.9129>, <13.01279, 74.591, 36.03419> }
				triangle { <13.01279, 74.591, 36.03419>, <2.8195, 65.5609, 28.6616>, <13.8099, 73.4799, 35.7705> }
				triangle { <2.8195, 65.5609, 28.6616>, <13.01279, 74.591, 36.03419>, <5.2219, 69.122, 30.6206> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <0.6621, 62.4903, 26.9746>, <0.6926, 64.6784, 28.2138>, 0.4191 }
				cylinder { <0.6926, 64.6784, 28.2138>, <0.723, 66.8666, 29.453>, 0.4191 }
				cylinder { <0.723, 66.8666, 29.453>, <0.7534, 69.05476, 30.6922>, 0.4191 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.7534, 69.05476, 30.6922>, <0.395, 70.2333, 31.3688>, 0.07027 }
				cylinder { <0.395, 70.2333, 31.3688>, <-0.3126, 71.2822, 31.9806>, 0.07027 }
				cylinder { <-0.3126, 71.2822, 31.9806>, <-1.3185, 72.1254, 32.4831>, 0.07027 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-4.06798, 74.8916, 35.4673>, <-12.181, 79.8331, 40.00866>, <-1.3185, 72.1254, 32.4831> }
				triangle { <-4.06798, 74.8916, 35.4673>, <-11.2339, 80.4304, 40.9021>, <-12.181, 79.8331, 40.00866> }
				triangle { <-11.2339, 80.4304, 40.9021>, <-17.00438, 82.4266, 47.5719>, <-12.181, 79.8331, 40.00866> }
				triangle { <-12.181, 79.8331, 40.00866>, <-17.00438, 82.4266, 47.5719>, <-17.9472, 81.8702, 47.08707> }
				triangle { <-17.00438, 82.4266, 47.5719>, <-17.6403, 80.676, 50.6432>, <-17.9472, 81.8702, 47.08707> }
				triangle { <-17.6403, 80.676, 50.6432>, <-18.4189, 81.5303, 46.7132>, <-17.9472, 81.8702, 47.08707> }
				triangle { <-17.9472, 81.8702, 47.08707>, <-18.4189, 81.5303, 46.7132>, <-12.181, 79.8331, 40.00866> }
				triangle { <-12.181, 79.8331, 40.00866>, <-18.4189, 81.5303, 46.7132>, <-13.2444, 79.2537, 39.3209> }
				triangle { <-13.2444, 79.2537, 39.3209>, <-1.3185, 72.1254, 32.4831>, <-12.181, 79.8331, 40.00866> }
				triangle { <-1.3185, 72.1254, 32.4831>, <-13.2444, 79.2537, 39.3209>, <-5.4945, 73.996, 33.6456> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.7534, 69.05476, 30.6922>, <0.7704, 70.2776, 31.3847>, 0.07027 }
				cylinder { <0.7704, 70.2776, 31.3847>, <0.7874, 71.5004, 32.07728>, 0.07027 }
				cylinder { <0.7874, 71.5004, 32.07728>, <0.8044, 72.7233, 32.7698>, 0.07027 }
				texture {fol5}}
			mesh { // leaf
				triangle { <1.7243, 76.2294, 36.08324>, <0.873, 84.6126, 42.3966>, <0.8044, 72.7233, 32.7698> }
				triangle { <1.7243, 76.2294, 36.08324>, <2.2246, 84.3647, 42.8011>, <0.873, 84.6126, 42.3966> }
				triangle { <2.2246, 84.3647, 42.8011>, <1.9153, 88.7612, 50.697>, <0.873, 84.6126, 42.3966> }
				triangle { <0.873, 84.6126, 42.3966>, <1.9153, 88.7612, 50.697>, <0.7405, 88.9897, 50.6626> }
				triangle { <1.9153, 88.7612, 50.697>, <1.4938, 87.4634, 54.01973>, <0.7405, 88.9897, 50.6626> }
				triangle { <1.4938, 87.4634, 54.01973>, <0.06656, 89.07236, 50.5332>, <0.7405, 88.9897, 50.6626> }
				triangle { <0.7405, 88.9897, 50.6626>, <0.06656, 89.07236, 50.5332>, <0.873, 84.6126, 42.3966> }
				triangle { <0.873, 84.6126, 42.3966>, <0.06656, 89.07236, 50.5332>, <-0.4729, 84.9238, 42.2204> }
				triangle { <-0.4729, 84.9238, 42.2204>, <0.8044, 72.7233, 32.7698>, <0.873, 84.6126, 42.3966> }
				triangle { <0.8044, 72.7233, 32.7698>, <-0.4729, 84.9238, 42.2204>, <-0.4816, 76.662, 35.03329> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <-0.0, 6.2219, 0.0>, <0.0002809, 6.2565, 0.01144>, 0.02737 }
		cylinder { <0.0002809, 6.2565, 0.01144>, <0.0008145, 6.2859, 0.03317>, 0.02737 }
		cylinder { <0.0008145, 6.2859, 0.03317>, <0.001546, 6.3069, 0.06301>, 0.02737 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.001546, 6.3069, 0.06301>, <0.01714, 6.6076, 0.6985>, 0.03516 }
			cylinder { <0.01714, 6.6076, 0.6985>, <0.03378, 6.7952, 1.3762>, 0.03516 }
			cylinder { <0.03378, 6.7952, 1.3762>, <0.05096, 6.8641, 2.07591>, 0.03516 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.05096, 6.8641, 2.07591>, <0.05611, 6.8848, 2.2858>, 0.03516 }
				cylinder { <0.05611, 6.8848, 2.2858>, <0.06126, 6.9054, 2.4957>, 0.03516 }
				cylinder { <0.06126, 6.9054, 2.4957>, <0.06641, 6.9261, 2.7056>, 0.03516 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.06641, 6.9261, 2.7056>, <0.06929, 6.9271, 2.715>, 0.0004946 }
				cylinder { <0.06929, 6.9271, 2.715>, <0.07458, 6.9279, 2.7233>, 0.0004946 }
				cylinder { <0.07458, 6.9279, 2.7233>, <0.08191, 6.9286, 2.7299>, 0.0004946 }
				texture {fol5}}
			mesh { // leaf
				triangle { <0.4211, 6.8522, 2.9509>, <1.01086, 6.8052, 3.6069>, <0.08191, 6.9286, 2.7299> }
				triangle { <0.4211, 6.8522, 2.9509>, <1.08654, 6.7552, 3.5281>, <1.01086, 6.8052, 3.6069> }
				triangle { <1.08654, 6.7552, 3.5281>, <1.5385, 6.4099, 4.03023>, <1.01086, 6.8052, 3.6069> }
				triangle { <1.01086, 6.8052, 3.6069>, <1.5385, 6.4099, 4.03023>, <1.4827, 6.4319, 4.1108> }
				triangle { <1.5385, 6.4099, 4.03023>, <1.5421, 6.1218, 4.1184>, <1.4827, 6.4319, 4.1108> }
				triangle { <1.5421, 6.1218, 4.1184>, <1.4449, 6.4499, 4.1509>, <1.4827, 6.4319, 4.1108> }
				triangle { <1.4827, 6.4319, 4.1108>, <1.4449, 6.4499, 4.1509>, <1.01086, 6.8052, 3.6069> }
				triangle { <1.01086, 6.8052, 3.6069>, <1.4449, 6.4499, 4.1509>, <0.9456, 6.8421, 3.6966> }
				triangle { <0.9456, 6.8421, 3.6966>, <0.08191, 6.9286, 2.7299>, <1.01086, 6.8052, 3.6069> }
				triangle { <0.08191, 6.9286, 2.7299>, <0.9456, 6.8421, 3.6966>, <0.2877, 6.9622, 3.06677> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <0.06641, 6.9261, 2.7056>, <0.07157, 6.9468, 2.9155>, 0.03516 }
				cylinder { <0.07157, 6.9468, 2.9155>, <0.07672, 6.9675, 3.1254>, 0.03516 }
				cylinder { <0.07672, 6.9675, 3.1254>, <0.08187, 6.9882, 3.3353>, 0.03516 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.08187, 6.9882, 3.3353>, <0.07947, 6.9891, 3.3449>, 0.0004946 }
				cylinder { <0.07947, 6.9891, 3.3449>, <0.07459, 6.9899, 3.3535>, 0.0004946 }
				cylinder { <0.07459, 6.9899, 3.3535>, <0.0676, 6.9906, 3.3604>, 0.0004946 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-0.1609, 6.9242, 3.6967>, <-0.837, 6.8652, 4.2621>, <0.0676, 6.9906, 3.3604> }
				triangle { <-0.1609, 6.9242, 3.6967>, <-0.7574, 6.8312, 4.3455>, <-0.837, 6.8652, 4.2621> }
				triangle { <-0.7574, 6.8312, 4.3455>, <-1.2438, 6.48, 4.8097>, <-0.837, 6.8652, 4.2621> }
				triangle { <-0.837, 6.8652, 4.2621>, <-1.2438, 6.48, 4.8097>, <-1.3234, 6.4879, 4.749> }
				triangle { <-1.2438, 6.48, 4.8097>, <-1.3028, 6.1859, 4.8387>, <-1.3234, 6.4879, 4.749> }
				triangle { <-1.3028, 6.1859, 4.8387>, <-1.3633, 6.4979, 4.708>, <-1.3234, 6.4879, 4.749> }
				triangle { <-1.3234, 6.4879, 4.749>, <-1.3633, 6.4979, 4.708>, <-0.837, 6.8652, 4.2621> }
				triangle { <-0.837, 6.8652, 4.2621>, <-1.3633, 6.4979, 4.708>, <-0.9266, 6.8862, 4.1901> }
				triangle { <-0.9266, 6.8862, 4.1901>, <0.0676, 6.9906, 3.3604>, <-0.837, 6.8652, 4.2621> }
				triangle { <0.0676, 6.9906, 3.3604>, <-0.9266, 6.8862, 4.1901>, <-0.2805, 7.008336, 3.5485> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <0.08187, 6.9882, 3.3353>, <0.08703, 7.008902, 3.5452>, 0.03516 }
				cylinder { <0.08703, 7.008902, 3.5452>, <0.09218, 7.02958, 3.7552>, 0.03516 }
				cylinder { <0.09218, 7.02958, 3.7552>, <0.09733, 7.05026, 3.9651>, 0.03516 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.09733, 7.05026, 3.9651>, <0.1002, 7.05119, 3.9745>, 0.0004946 }
				cylinder { <0.1002, 7.05119, 3.9745>, <0.1054, 7.05202, 3.9828>, 0.0004946 }
				cylinder { <0.1054, 7.05202, 3.9828>, <0.1128, 7.05269, 3.9894>, 0.0004946 }
				texture {fol5}}
			mesh { // leaf
				triangle { <0.452, 6.9763, 4.2104>, <1.04178, 6.9292, 4.8664>, <0.1128, 7.05269, 3.9894> }
				triangle { <0.452, 6.9763, 4.2104>, <1.1174, 6.8792, 4.7876>, <1.04178, 6.9292, 4.8664> }
				triangle { <1.1174, 6.8792, 4.7876>, <1.5694, 6.534, 5.2897>, <1.04178, 6.9292, 4.8664> }
				triangle { <1.04178, 6.9292, 4.8664>, <1.5694, 6.534, 5.2897>, <1.5136, 6.556, 5.3703> }
				triangle { <1.5694, 6.534, 5.2897>, <1.573, 6.2459, 5.3779>, <1.5136, 6.556, 5.3703> }
				triangle { <1.573, 6.2459, 5.3779>, <1.4758, 6.574, 5.4104>, <1.5136, 6.556, 5.3703> }
				triangle { <1.5136, 6.556, 5.3703>, <1.4758, 6.574, 5.4104>, <1.04178, 6.9292, 4.8664> }
				triangle { <1.04178, 6.9292, 4.8664>, <1.4758, 6.574, 5.4104>, <0.9765, 6.9662, 4.956> }
				triangle { <0.9765, 6.9662, 4.956>, <0.1128, 7.05269, 3.9894>, <1.04178, 6.9292, 4.8664> }
				triangle { <0.1128, 7.05269, 3.9894>, <0.9765, 6.9662, 4.956>, <0.3186, 7.08635, 4.3262> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <0.09733, 7.05026, 3.9651>, <0.1024, 7.07094, 4.175>, 0.03516 }
				cylinder { <0.1024, 7.07094, 4.175>, <0.1076, 7.09162, 4.3849>, 0.03516 }
				cylinder { <0.1076, 7.09162, 4.3849>, <0.1127, 7.1123, 4.5948>, 0.03516 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.1127, 7.1123, 4.5948>, <0.1103, 7.1132, 4.6043>, 0.0004946 }
				cylinder { <0.1103, 7.1132, 4.6043>, <0.1055, 7.114, 4.6129>, 0.0004946 }
				cylinder { <0.1055, 7.114, 4.6129>, <0.09851, 7.1147, 4.6199>, 0.0004946 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-0.13, 7.04836, 4.9562>, <-0.8061, 6.9893, 5.5216>, <0.09851, 7.1147, 4.6199> }
				triangle { <-0.13, 7.04836, 4.9562>, <-0.7265, 6.9553, 5.6049>, <-0.8061, 6.9893, 5.5216> }
				triangle { <-0.7265, 6.9553, 5.6049>, <-1.2129, 6.6041, 6.06924>, <-0.8061, 6.9893, 5.5216> }
				triangle { <-0.8061, 6.9893, 5.5216>, <-1.2129, 6.6041, 6.06924>, <-1.2925, 6.612, 6.008487> }
				triangle { <-1.2129, 6.6041, 6.06924>, <-1.2719, 6.3099, 6.09819>, <-1.2925, 6.612, 6.008487> }
				triangle { <-1.2719, 6.3099, 6.09819>, <-1.3323, 6.622, 5.9675>, <-1.2925, 6.612, 6.008487> }
				triangle { <-1.2925, 6.612, 6.008487>, <-1.3323, 6.622, 5.9675>, <-0.8061, 6.9893, 5.5216> }
				triangle { <-0.8061, 6.9893, 5.5216>, <-1.3323, 6.622, 5.9675>, <-0.8957, 7.01028, 5.4496> }
				triangle { <-0.8957, 7.01028, 5.4496>, <0.09851, 7.1147, 4.6199>, <-0.8061, 6.9893, 5.5216> }
				triangle { <0.09851, 7.1147, 4.6199>, <-0.8957, 7.01028, 5.4496>, <-0.2496, 7.1324, 4.808> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <0.1127, 7.1123, 4.5948>, <0.1179, 7.1329, 4.8047>, 0.03516 }
				cylinder { <0.1179, 7.1329, 4.8047>, <0.1231, 7.1536, 5.01466>, 0.03516 }
				cylinder { <0.1231, 7.1536, 5.01466>, <0.1282, 7.1743, 5.2245>, 0.03516 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.1282, 7.1743, 5.2245>, <0.1311, 7.1752, 5.234>, 0.0004946 }
				cylinder { <0.1311, 7.1752, 5.234>, <0.1364, 7.1761, 5.2423>, 0.0004946 }
				cylinder { <0.1364, 7.1761, 5.2423>, <0.1437, 7.1767, 5.2489>, 0.0004946 }
				texture {fol5}}
			mesh { // leaf
				triangle { <0.483, 7.1004, 5.4698>, <1.0727, 7.05336, 6.1259>, <0.1437, 7.1767, 5.2489> }
				triangle { <0.483, 7.1004, 5.4698>, <1.1483, 7.003382, 6.04707>, <1.0727, 7.05336, 6.1259> }
				triangle { <1.1483, 7.003382, 6.04707>, <1.6003, 6.6581, 6.5491>, <1.0727, 7.05336, 6.1259> }
				triangle { <1.0727, 7.05336, 6.1259>, <1.6003, 6.6581, 6.5491>, <1.5446, 6.68, 6.6297> }
				triangle { <1.6003, 6.6581, 6.5491>, <1.6039, 6.37, 6.6374>, <1.5446, 6.68, 6.6297> }
				triangle { <1.6039, 6.37, 6.6374>, <1.5067, 6.698, 6.6699>, <1.5446, 6.68, 6.6297> }
				triangle { <1.5446, 6.68, 6.6297>, <1.5067, 6.698, 6.6699>, <1.0727, 7.05336, 6.1259> }
				triangle { <1.0727, 7.05336, 6.1259>, <1.5067, 6.698, 6.6699>, <1.007478, 7.0903, 6.2155> }
				triangle { <1.007478, 7.0903, 6.2155>, <0.1437, 7.1767, 5.2489>, <1.0727, 7.05336, 6.1259> }
				triangle { <0.1437, 7.1767, 5.2489>, <1.007478, 7.0903, 6.2155>, <0.3495, 7.2104, 5.5857> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <0.1282, 7.1743, 5.2245>, <0.1334, 7.195, 5.4344>, 0.03516 }
				cylinder { <0.1334, 7.195, 5.4344>, <0.1385, 7.2157, 5.6444>, 0.03516 }
				cylinder { <0.1385, 7.2157, 5.6444>, <0.1437, 7.2363, 5.8543>, 0.03516 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.1437, 7.2363, 5.8543>, <0.1413, 7.2373, 5.8638>, 0.0004946 }
				cylinder { <0.1413, 7.2373, 5.8638>, <0.1364, 7.2381, 5.8724>, 0.0004946 }
				cylinder { <0.1364, 7.2381, 5.8724>, <0.1294, 7.2388, 5.8793>, 0.0004946 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-0.09912, 7.1724, 6.2157>, <-0.7752, 7.1134, 6.7811>, <0.1294, 7.2388, 5.8793> }
				triangle { <-0.09912, 7.1724, 6.2157>, <-0.6955, 7.0794, 6.8644>, <-0.7752, 7.1134, 6.7811> }
				triangle { <-0.6955, 7.0794, 6.8644>, <-1.182, 6.7281, 7.3287>, <-0.7752, 7.1134, 6.7811> }
				triangle { <-0.7752, 7.1134, 6.7811>, <-1.182, 6.7281, 7.3287>, <-1.2616, 6.7361, 7.2679> }
				triangle { <-1.182, 6.7281, 7.3287>, <-1.241, 6.434, 7.3576>, <-1.2616, 6.7361, 7.2679> }
				triangle { <-1.241, 6.434, 7.3576>, <-1.3014, 6.7461, 7.2269>, <-1.2616, 6.7361, 7.2679> }
				triangle { <-1.2616, 6.7361, 7.2679>, <-1.3014, 6.7461, 7.2269>, <-0.7752, 7.1134, 6.7811> }
				triangle { <-0.7752, 7.1134, 6.7811>, <-1.3014, 6.7461, 7.2269>, <-0.8648, 7.1343, 6.709> }
				triangle { <-0.8648, 7.1343, 6.709>, <0.1294, 7.2388, 5.8793>, <-0.7752, 7.1134, 6.7811> }
				triangle { <0.1294, 7.2388, 5.8793>, <-0.8648, 7.1343, 6.709>, <-0.2187, 7.2565, 6.0675> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <0.1437, 7.2363, 5.8543>, <0.1439, 7.2373, 5.8641>, 0.0004946 }
				cylinder { <0.1439, 7.2373, 5.8641>, <0.1441, 7.2383, 5.8739>, 0.0004946 }
				cylinder { <0.1441, 7.2383, 5.8739>, <0.1444, 7.2392, 5.8838>, 0.0004946 }
				texture {fol5}}
			mesh { // leaf
				triangle { <0.2246, 7.1799, 6.2835>, <0.1618, 7.1534, 7.1643>, <0.1444, 7.2392, 5.8838> }
				triangle { <0.2246, 7.1799, 6.2835>, <0.2743, 7.1114, 7.1656>, <0.1618, 7.1534, 7.1643> }
				triangle { <0.2743, 7.1114, 7.1656>, <0.2489, 6.7828, 7.849>, <0.1618, 7.1534, 7.1643> }
				triangle { <0.1618, 7.1534, 7.1643>, <0.2489, 6.7828, 7.849>, <0.1508, 6.7982, 7.864> }
				triangle { <0.2489, 6.7828, 7.849>, <0.2085, 6.493, 7.921>, <0.1508, 6.7982, 7.864> }
				triangle { <0.2085, 6.493, 7.921>, <0.09455, 6.8122, 7.864>, <0.1508, 6.7982, 7.864> }
				triangle { <0.1508, 6.7982, 7.864>, <0.09455, 6.8122, 7.864>, <0.1618, 7.1534, 7.1643> }
				triangle { <0.1618, 7.1534, 7.1643>, <0.09455, 6.8122, 7.864>, <0.04958, 7.1827, 7.1783> }
				triangle { <0.04958, 7.1827, 7.1783>, <0.1444, 7.2392, 5.8838>, <0.1618, 7.1534, 7.1643> }
				triangle { <0.1444, 7.2392, 5.8838>, <0.04958, 7.1827, 7.1783>, <0.04122, 7.2765, 6.2644> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <-0.0, 6.2219, 0.0>, <-0.0, 6.4754, 0.0>, 0.1901 }
		cylinder { <-0.0, 6.4754, 0.0>, <-0.0, 6.729, 0.0>, 0.1901 }
		cylinder { <-0.0, 6.729, 0.0>, <-0.0, 6.9825, 0.0>, 0.1901 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0, 6.9825, 0.0>, <0.4753, 11.1763, -0.551>, 0.2128 }
			cylinder { <0.4753, 11.1763, -0.551>, <1.4119, 15.1838, -1.6367>, 0.2128 }
			cylinder { <1.4119, 15.1838, -1.6367>, <2.7822, 18.8873, -3.2253>, 0.2128 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.7822, 18.8873, -3.2253>, <3.1933, 19.9983, -3.7019>, 0.2128 }
				cylinder { <3.1933, 19.9983, -3.7019>, <3.6044, 21.1093, -4.1785>, 0.2128 }
				cylinder { <3.6044, 21.1093, -4.1785>, <4.01555, 22.2204, -4.6551>, 0.2128 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <4.01555, 22.2204, -4.6551>, <4.0548, 22.5242, -4.8486>, 0.01811 }
				cylinder { <4.0548, 22.5242, -4.8486>, <4.01381, 22.7946, -5.08626>, 0.01811 }
				cylinder { <4.01381, 22.7946, -5.08626>, <3.8955, 23.01207, -5.3509>, 0.01811 }
				texture {fol5}}
			mesh { // leaf
				triangle { <3.1346, 23.8801, -7.5611>, <2.1847, 27.03293, -11.7729>, <3.8955, 23.01207, -5.3509> }
				triangle { <3.1346, 23.8801, -7.5611>, <1.8154, 26.4779, -12.06385>, <2.1847, 27.03293, -11.7729> }
				triangle { <1.8154, 26.4779, -12.06385>, <2.08483, 27.8133, -16.4484>, <2.1847, 27.03293, -11.7729> }
				triangle { <2.1847, 27.03293, -11.7729>, <2.08483, 27.8133, -16.4484>, <2.4587, 28.2818, -16.3472> }
				triangle { <2.08483, 27.8133, -16.4484>, <3.2103, 27.2463, -17.7668>, <2.4587, 28.2818, -16.3472> }
				triangle { <3.2103, 27.2463, -17.7668>, <2.6675, 28.5384, -16.2298>, <2.4587, 28.2818, -16.3472> }
				triangle { <2.4587, 28.2818, -16.3472>, <2.6675, 28.5384, -16.2298>, <2.1847, 27.03293, -11.7729> }
				triangle { <2.1847, 27.03293, -11.7729>, <2.6675, 28.5384, -16.2298>, <2.5745, 27.597, -11.6003> }
				triangle { <2.5745, 27.597, -11.6003>, <3.8955, 23.01207, -5.3509>, <2.1847, 27.03293, -11.7729> }
				triangle { <3.8955, 23.01207, -5.3509>, <2.5745, 27.597, -11.6003>, <3.6596, 24.8202, -6.9071> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <4.01555, 22.2204, -4.6551>, <4.4266, 23.3314, -5.1317>, 0.2128 }
				cylinder { <4.4266, 23.3314, -5.1317>, <4.8377, 24.4424, -5.6083>, 0.2128 }
				cylinder { <4.8377, 24.4424, -5.6083>, <5.2488, 25.5535, -6.08488>, 0.2128 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <5.2488, 25.5535, -6.08488>, <5.4344, 25.8573, -6.152>, 0.01811 }
				cylinder { <5.4344, 25.8573, -6.152>, <5.6755, 26.1277, -6.1464>, 0.01811 }
				cylinder { <5.6755, 26.1277, -6.1464>, <5.9547, 26.3451, -6.06826>, 0.01811 }
				texture {fol5}}
			mesh { // leaf
				triangle { <8.006703, 27.7497, -6.2534>, <12.6074, 30.2587, -5.1955>, <5.9547, 26.3451, -6.06826> }
				triangle { <8.006703, 27.7497, -6.2534>, <12.5558, 30.562, -5.8546>, <12.6074, 30.2587, -5.1955> }
				triangle { <12.5558, 30.562, -5.8546>, <17.00105, 31.5755, -6.3963>, <12.6074, 30.2587, -5.1955> }
				triangle { <12.6074, 30.2587, -5.1955>, <17.00105, 31.5755, -6.3963>, <17.1904, 31.2931, -5.8924> }
				triangle { <17.00105, 31.5755, -6.3963>, <18.2875, 30.6867, -7.3349>, <17.1904, 31.2931, -5.8924> }
				triangle { <18.2875, 30.6867, -7.3349>, <17.2404, 31.1204, -5.5909>, <17.1904, 31.2931, -5.8924> }
				triangle { <17.1904, 31.2931, -5.8924>, <17.2404, 31.1204, -5.5909>, <12.6074, 30.2587, -5.1955> }
				triangle { <12.6074, 30.2587, -5.1955>, <17.2404, 31.1204, -5.5909>, <12.773, 29.9645, -4.5742> }
				triangle { <12.773, 29.9645, -4.5742>, <5.9547, 26.3451, -6.06826>, <12.6074, 30.2587, -5.1955> }
				triangle { <5.9547, 26.3451, -6.06826>, <12.773, 29.9645, -4.5742>, <7.9222, 27.2949, -5.08166> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <5.2488, 25.5535, -6.08488>, <5.6599, 26.6645, -6.5614>, 0.2128 }
				cylinder { <5.6599, 26.6645, -6.5614>, <6.07106, 27.7755, -7.03804>, 0.2128 }
				cylinder { <6.07106, 27.7755, -7.03804>, <6.4821, 28.8866, -7.5146>, 0.2128 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <6.4821, 28.8866, -7.5146>, <6.5214, 29.1904, -7.708>, 0.01811 }
				cylinder { <6.5214, 29.1904, -7.708>, <6.4804, 29.4608, -7.9457>, 0.01811 }
				cylinder { <6.4804, 29.4608, -7.9457>, <6.3621, 29.6782, -8.2104>, 0.01811 }
				texture {fol5}}
			mesh { // leaf
				triangle { <5.6012, 30.5463, -10.4206>, <4.6513, 33.6991, -14.6324>, <6.3621, 29.6782, -8.2104> }
				triangle { <5.6012, 30.5463, -10.4206>, <4.2821, 33.144, -14.9233>, <4.6513, 33.6991, -14.6324> }
				triangle { <4.2821, 33.144, -14.9233>, <4.5514, 34.4795, -19.3079>, <4.6513, 33.6991, -14.6324> }
				triangle { <4.6513, 33.6991, -14.6324>, <4.5514, 34.4795, -19.3079>, <4.9253, 34.948, -19.2067> }
				triangle { <4.5514, 34.4795, -19.3079>, <5.6769, 33.9125, -20.6263>, <4.9253, 34.948, -19.2067> }
				triangle { <5.6769, 33.9125, -20.6263>, <5.1341, 35.2046, -19.08933>, <4.9253, 34.948, -19.2067> }
				triangle { <4.9253, 34.948, -19.2067>, <5.1341, 35.2046, -19.08933>, <4.6513, 33.6991, -14.6324> }
				triangle { <4.6513, 33.6991, -14.6324>, <5.1341, 35.2046, -19.08933>, <5.04117, 34.2632, -14.4598> }
				triangle { <5.04117, 34.2632, -14.4598>, <6.3621, 29.6782, -8.2104>, <4.6513, 33.6991, -14.6324> }
				triangle { <6.3621, 29.6782, -8.2104>, <5.04117, 34.2632, -14.4598>, <6.1262, 31.4863, -9.7665> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <6.4821, 28.8866, -7.5146>, <6.8932, 29.9976, -7.9912>, 0.2128 }
				cylinder { <6.8932, 29.9976, -7.9912>, <7.3043, 31.1086, -8.4677>, 0.2128 }
				cylinder { <7.3043, 31.1086, -8.4677>, <7.7154, 32.2197, -8.9443>, 0.2128 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <7.7154, 32.2197, -8.9443>, <7.901, 32.5235, -9.01158>, 0.01811 }
				cylinder { <7.901, 32.5235, -9.01158>, <8.1421, 32.7939, -9.005902>, 0.01811 }
				cylinder { <8.1421, 32.7939, -9.005902>, <8.4213, 33.01134, -8.9277>, 0.01811 }
				texture {fol5}}
			mesh { // leaf
				triangle { <10.4733, 34.4159, -9.1129>, <15.07407, 36.9249, -8.05505>, <8.4213, 33.01134, -8.9277> }
				triangle { <10.4733, 34.4159, -9.1129>, <15.02242, 37.2281, -8.7141>, <15.07407, 36.9249, -8.05505> }
				triangle { <15.02242, 37.2281, -8.7141>, <19.4676, 38.2417, -9.2557>, <15.07407, 36.9249, -8.05505> }
				triangle { <15.07407, 36.9249, -8.05505>, <19.4676, 38.2417, -9.2557>, <19.657, 37.9592, -8.7518> }
				triangle { <19.4676, 38.2417, -9.2557>, <20.7541, 37.3529, -10.1944>, <19.657, 37.9592, -8.7518> }
				triangle { <20.7541, 37.3529, -10.1944>, <19.707, 37.7866, -8.4503>, <19.657, 37.9592, -8.7518> }
				triangle { <19.657, 37.9592, -8.7518>, <19.707, 37.7866, -8.4503>, <15.07407, 36.9249, -8.05505> }
				triangle { <15.07407, 36.9249, -8.05505>, <19.707, 37.7866, -8.4503>, <15.2396, 36.6307, -7.4337> }
				triangle { <15.2396, 36.6307, -7.4337>, <8.4213, 33.01134, -8.9277>, <15.07407, 36.9249, -8.05505> }
				triangle { <8.4213, 33.01134, -8.9277>, <15.2396, 36.6307, -7.4337>, <10.3888, 33.9611, -7.9411> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <7.7154, 32.2197, -8.9443>, <8.1265, 33.3307, -9.4209>, 0.2128 }
				cylinder { <8.1265, 33.3307, -9.4209>, <8.5376, 34.4417, -9.8975>, 0.2128 }
				cylinder { <8.5376, 34.4417, -9.8975>, <8.9487, 35.5527, -10.3741>, 0.2128 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <8.9487, 35.5527, -10.3741>, <8.988, 35.8566, -10.5675>, 0.01811 }
				cylinder { <8.988, 35.8566, -10.5675>, <8.947, 36.127, -10.8052>, 0.01811 }
				cylinder { <8.947, 36.127, -10.8052>, <8.8287, 36.3444, -11.06989>, 0.01811 }
				texture {fol5}}
			mesh { // leaf
				triangle { <8.0679, 37.2125, -13.2801>, <7.1179, 40.3652, -17.4919>, <8.8287, 36.3444, -11.06989> }
				triangle { <8.0679, 37.2125, -13.2801>, <6.7487, 39.8102, -17.7828>, <7.1179, 40.3652, -17.4919> }
				triangle { <6.7487, 39.8102, -17.7828>, <7.01805, 41.1457, -22.1674>, <7.1179, 40.3652, -17.4919> }
				triangle { <7.1179, 40.3652, -17.4919>, <7.01805, 41.1457, -22.1674>, <7.3919, 41.6142, -22.06622> }
				triangle { <7.01805, 41.1457, -22.1674>, <8.1435, 40.5787, -23.4857>, <7.3919, 41.6142, -22.06622> }
				triangle { <8.1435, 40.5787, -23.4857>, <7.6007, 41.8707, -21.9488>, <7.3919, 41.6142, -22.06622> }
				triangle { <7.3919, 41.6142, -22.06622>, <7.6007, 41.8707, -21.9488>, <7.1179, 40.3652, -17.4919> }
				triangle { <7.1179, 40.3652, -17.4919>, <7.6007, 41.8707, -21.9488>, <7.5077, 40.9294, -17.3192> }
				triangle { <7.5077, 40.9294, -17.3192>, <8.8287, 36.3444, -11.06989>, <7.1179, 40.3652, -17.4919> }
				triangle { <8.8287, 36.3444, -11.06989>, <7.5077, 40.9294, -17.3192>, <8.5928, 38.1525, -12.626> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <8.9487, 35.5527, -10.3741>, <9.3598, 36.6638, -10.8506>, 0.2128 }
				cylinder { <9.3598, 36.6638, -10.8506>, <9.7709, 37.7748, -11.3272>, 0.2128 }
				cylinder { <9.7709, 37.7748, -11.3272>, <10.182, 38.8858, -11.8038>, 0.2128 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <10.182, 38.8858, -11.8038>, <10.3676, 39.1897, -11.871>, 0.01811 }
				cylinder { <10.3676, 39.1897, -11.871>, <10.6087, 39.4601, -11.8653>, 0.01811 }
				cylinder { <10.6087, 39.4601, -11.8653>, <10.8879, 39.6775, -11.7872>, 0.01811 }
				texture {fol5}}
			mesh { // leaf
				triangle { <12.9399, 41.08208, -11.9724>, <17.5406, 43.591, -10.9145>, <10.8879, 39.6775, -11.7872> }
				triangle { <12.9399, 41.08208, -11.9724>, <17.489, 43.8943, -11.5736>, <17.5406, 43.591, -10.9145> }
				triangle { <17.489, 43.8943, -11.5736>, <21.9342, 44.9079, -12.1152>, <17.5406, 43.591, -10.9145> }
				triangle { <17.5406, 43.591, -10.9145>, <21.9342, 44.9079, -12.1152>, <22.1236, 44.6254, -11.6113> }
				triangle { <21.9342, 44.9079, -12.1152>, <23.2207, 44.01909, -13.05393>, <22.1236, 44.6254, -11.6113> }
				triangle { <23.2207, 44.01909, -13.05393>, <22.1736, 44.4528, -11.3098>, <22.1236, 44.6254, -11.6113> }
				triangle { <22.1236, 44.6254, -11.6113>, <22.1736, 44.4528, -11.3098>, <17.5406, 43.591, -10.9145> }
				triangle { <17.5406, 43.591, -10.9145>, <22.1736, 44.4528, -11.3098>, <17.7062, 43.2969, -10.2932> }
				triangle { <17.7062, 43.2969, -10.2932>, <10.8879, 39.6775, -11.7872>, <17.5406, 43.591, -10.9145> }
				triangle { <10.8879, 39.6775, -11.7872>, <17.7062, 43.2969, -10.2932>, <12.8554, 40.6273, -10.8006> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <10.182, 38.8858, -11.8038>, <10.2987, 39.2011, -11.939>, 0.01811 }
				cylinder { <10.2987, 39.2011, -11.939>, <10.4153, 39.5164, -12.07432>, 0.01811 }
				cylinder { <10.4153, 39.5164, -12.07432>, <10.532, 39.8316, -12.2095>, 0.01811 }
				texture {fol5}}
			mesh { // leaf
				triangle { <11.3157, 41.6118, -13.7697>, <13.7888, 45.8684, -15.8547>, <10.532, 39.8316, -12.2095> }
				triangle { <11.3157, 41.6118, -13.7697>, <13.4182, 45.7425, -16.4678>, <13.7888, 45.8684, -15.8547> }
				triangle { <13.4182, 45.7425, -16.4678>, <16.2269, 47.9748, -19.3329>, <13.7888, 45.8684, -15.8547> }
				triangle { <13.7888, 45.8684, -15.8547>, <16.2269, 47.9748, -19.3329>, <16.6572, 48.09092, -18.9193> }
				triangle { <16.2269, 47.9748, -19.3329>, <17.5185, 47.3159, -20.4392>, <16.6572, 48.09092, -18.9193> }
				triangle { <17.5185, 47.3159, -20.4392>, <16.8666, 48.1328, -18.6408>, <16.6572, 48.09092, -18.9193> }
				triangle { <16.6572, 48.09092, -18.9193>, <16.8666, 48.1328, -18.6408>, <13.7888, 45.8684, -15.8547> }
				triangle { <13.7888, 45.8684, -15.8547>, <16.8666, 48.1328, -18.6408>, <14.2351, 46.02646, -15.3294> }
				triangle { <14.2351, 46.02646, -15.3294>, <10.532, 39.8316, -12.2095>, <13.7888, 45.8684, -15.8547> }
				triangle { <10.532, 39.8316, -12.2095>, <14.2351, 46.02646, -15.3294>, <11.7877, 41.8315, -12.6225> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <-0.0, 6.9825, 0.0>, <-0.0, 7.09145, 0.0>, 0.08166 }
		cylinder { <-0.0, 7.09145, 0.0>, <-0.0, 7.2003, 0.0>, 0.08166 }
		cylinder { <-0.0, 7.2003, 0.0>, <-0.0, 7.3092, 0.0>, 0.08166 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0, 7.3092, 0.0>, <-0.3329, 9.2425, 0.04106>, 0.09811 }
			cylinder { <-0.3329, 9.2425, 0.04106>, <-0.989, 11.09012, 0.1219>, 0.09811 }
			cylinder { <-0.989, 11.09012, 0.1219>, <-1.9489, 12.7974, 0.2403>, 0.09811 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-1.9489, 12.7974, 0.2403>, <-2.2369, 13.3096, 0.2758>, 0.09811 }
				cylinder { <-2.2369, 13.3096, 0.2758>, <-2.5249, 13.8218, 0.3114>, 0.09811 }
				cylinder { <-2.5249, 13.8218, 0.3114>, <-2.8128, 14.334, 0.3469>, 0.09811 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-2.8128, 14.334, 0.3469>, <-2.8466, 14.3986, 0.3717>, 0.00385 }
				cylinder { <-2.8466, 14.3986, 0.3717>, <-2.8741, 14.456, 0.415>, 0.00385 }
				cylinder { <-2.8741, 14.456, 0.415>, <-2.8932, 14.5022, 0.4736>, 0.00385 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-3.3176, 14.9025, 1.4641>, <-4.2971, 16.3559, 3.1969>, <-2.8932, 14.5022, 0.4736> }
				triangle { <-3.3176, 14.9025, 1.4641>, <-4.261, 16.1, 3.4106>, <-4.2971, 16.3559, 3.1969> }
				triangle { <-4.261, 16.1, 3.4106>, <-5.7105, 16.7157, 4.8249>, <-4.2971, 16.3559, 3.1969> }
				triangle { <-4.2971, 16.3559, 3.1969>, <-5.7105, 16.7157, 4.8249>, <-5.8069, 16.9317, 4.6746> }
				triangle { <-5.7105, 16.7157, 4.8249>, <-6.5031, 16.4543, 4.9268>, <-5.8069, 16.9317, 4.6746> }
				triangle { <-6.5031, 16.4543, 4.9268>, <-5.8418, 17.05, 4.5699>, <-5.8069, 16.9317, 4.6746> }
				triangle { <-5.8069, 16.9317, 4.6746>, <-5.8418, 17.05, 4.5699>, <-4.2971, 16.3559, 3.1969> }
				triangle { <-4.2971, 16.3559, 3.1969>, <-5.8418, 17.05, 4.5699>, <-4.3768, 16.616, 3.01731> }
				triangle { <-4.3768, 16.616, 3.01731>, <-2.8932, 14.5022, 0.4736>, <-4.2971, 16.3559, 3.1969> }
				triangle { <-2.8932, 14.5022, 0.4736>, <-4.3768, 16.616, 3.01731>, <-3.2945, 15.3358, 1.07822> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-2.8128, 14.334, 0.3469>, <-3.1008, 14.8462, 0.3824>, 0.09811 }
				cylinder { <-3.1008, 14.8462, 0.3824>, <-3.3888, 15.3584, 0.4179>, 0.09811 }
				cylinder { <-3.3888, 15.3584, 0.4179>, <-3.6767, 15.8706, 0.4534>, 0.09811 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-3.6767, 15.8706, 0.4534>, <-3.7156, 15.9352, 0.4375>, 0.00385 }
				cylinder { <-3.7156, 15.9352, 0.4375>, <-3.7527, 15.9926, 0.4022>, 0.00385 }
				cylinder { <-3.7527, 15.9926, 0.4022>, <-3.7855, 16.03889, 0.3501>, 0.00385 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-4.5438, 16.6864, -0.2218>, <-5.7878, 17.843, -2.007637>, <-3.7855, 16.03889, 0.3501> }
				triangle { <-4.5438, 16.6864, -0.2218>, <-5.9742, 17.9829, -1.7665>, <-5.7878, 17.843, -2.007637> }
				triangle { <-5.9742, 17.9829, -1.7665>, <-7.6604, 18.4501, -2.9577>, <-5.7878, 17.843, -2.007637> }
				triangle { <-5.7878, 17.843, -2.007637>, <-7.6604, 18.4501, -2.9577>, <-7.5691, 18.3199, -3.1884> }
				triangle { <-7.6604, 18.4501, -2.9577>, <-8.3904, 18.0404, -3.03538>, <-7.5691, 18.3199, -3.1884> }
				triangle { <-8.3904, 18.0404, -3.03538>, <-7.4928, 18.2403, -3.3069>, <-7.5691, 18.3199, -3.1884> }
				triangle { <-7.5691, 18.3199, -3.1884>, <-7.4928, 18.2403, -3.3069>, <-5.7878, 17.843, -2.007637> }
				triangle { <-5.7878, 17.843, -2.007637>, <-7.4928, 18.2403, -3.3069>, <-5.652, 17.7074, -2.2711> }
				triangle { <-5.652, 17.7074, -2.2711>, <-3.7855, 16.03889, 0.3501>, <-5.7878, 17.843, -2.007637> }
				triangle { <-3.7855, 16.03889, 0.3501>, <-5.652, 17.7074, -2.2711>, <-4.1522, 16.4767, -0.596> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-3.6767, 15.8706, 0.4534>, <-3.9647, 16.3828, 0.489>, 0.09811 }
				cylinder { <-3.9647, 16.3828, 0.489>, <-4.2527, 16.895, 0.5245>, 0.09811 }
				cylinder { <-4.2527, 16.895, 0.5245>, <-4.5407, 17.4072, 0.56>, 0.09811 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-4.5407, 17.4072, 0.56>, <-4.5745, 17.4718, 0.5849>, 0.00385 }
				cylinder { <-4.5745, 17.4718, 0.5849>, <-4.6019, 17.5292, 0.6281>, 0.00385 }
				cylinder { <-4.6019, 17.5292, 0.6281>, <-4.6211, 17.5754, 0.6867>, 0.00385 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-5.04551, 17.9756, 1.6772>, <-6.02497, 19.4291, 3.41>, <-4.6211, 17.5754, 0.6867> }
				triangle { <-5.04551, 17.9756, 1.6772>, <-5.9889, 19.1732, 3.6237>, <-6.02497, 19.4291, 3.41> }
				triangle { <-5.9889, 19.1732, 3.6237>, <-7.4383, 19.7889, 5.0381>, <-6.02497, 19.4291, 3.41> }
				triangle { <-6.02497, 19.4291, 3.41>, <-7.4383, 19.7889, 5.0381>, <-7.5347, 20.00492, 4.8877> }
				triangle { <-7.4383, 19.7889, 5.0381>, <-8.2309, 19.5275, 5.1399>, <-7.5347, 20.00492, 4.8877> }
				triangle { <-8.2309, 19.5275, 5.1399>, <-7.5697, 20.1231, 4.783>, <-7.5347, 20.00492, 4.8877> }
				triangle { <-7.5347, 20.00492, 4.8877>, <-7.5697, 20.1231, 4.783>, <-6.02497, 19.4291, 3.41> }
				triangle { <-6.02497, 19.4291, 3.41>, <-7.5697, 20.1231, 4.783>, <-6.1046, 19.6892, 3.2304> }
				triangle { <-6.1046, 19.6892, 3.2304>, <-4.6211, 17.5754, 0.6867>, <-6.02497, 19.4291, 3.41> }
				triangle { <-4.6211, 17.5754, 0.6867>, <-6.1046, 19.6892, 3.2304>, <-5.02234, 18.409, 1.2913> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-4.5407, 17.4072, 0.56>, <-4.8286, 17.9194, 0.5955>, 0.09811 }
				cylinder { <-4.8286, 17.9194, 0.5955>, <-5.1166, 18.4316, 0.631>, 0.09811 }
				cylinder { <-5.1166, 18.4316, 0.631>, <-5.4046, 18.9438, 0.6665>, 0.09811 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-5.4046, 18.9438, 0.6665>, <-5.4434, 19.0084, 0.6506>, 0.00385 }
				cylinder { <-5.4434, 19.0084, 0.6506>, <-5.4806, 19.06587, 0.6153>, 0.00385 }
				cylinder { <-5.4806, 19.06587, 0.6153>, <-5.5134, 19.112, 0.5632>, 0.00385 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-6.2716, 19.7595, -0.008786>, <-7.5157, 20.9162, -1.7945>, <-5.5134, 19.112, 0.5632> }
				triangle { <-6.2716, 19.7595, -0.008786>, <-7.7021, 21.05608, -1.5534>, <-7.5157, 20.9162, -1.7945> }
				triangle { <-7.7021, 21.05608, -1.5534>, <-9.3882, 21.5233, -2.7446>, <-7.5157, 20.9162, -1.7945> }
				triangle { <-7.5157, 20.9162, -1.7945>, <-9.3882, 21.5233, -2.7446>, <-9.2969, 21.3931, -2.9753> }
				triangle { <-9.3882, 21.5233, -2.7446>, <-10.1183, 21.1135, -2.8222>, <-9.2969, 21.3931, -2.9753> }
				triangle { <-10.1183, 21.1135, -2.8222>, <-9.2207, 21.3135, -3.09384>, <-9.2969, 21.3931, -2.9753> }
				triangle { <-9.2969, 21.3931, -2.9753>, <-9.2207, 21.3135, -3.09384>, <-7.5157, 20.9162, -1.7945> }
				triangle { <-7.5157, 20.9162, -1.7945>, <-9.2207, 21.3135, -3.09384>, <-7.3799, 20.7806, -2.05804> }
				triangle { <-7.3799, 20.7806, -2.05804>, <-5.5134, 19.112, 0.5632>, <-7.5157, 20.9162, -1.7945> }
				triangle { <-5.5134, 19.112, 0.5632>, <-7.3799, 20.7806, -2.05804>, <-5.88, 19.5499, -0.3829> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-5.4046, 18.9438, 0.6665>, <-5.6926, 19.456, 0.7021>, 0.09811 }
				cylinder { <-5.6926, 19.456, 0.7021>, <-5.9805, 19.9682, 0.7376>, 0.09811 }
				cylinder { <-5.9805, 19.9682, 0.7376>, <-6.2685, 20.4804, 0.7731>, 0.09811 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-6.2685, 20.4804, 0.7731>, <-6.3023, 20.5449, 0.798>, 0.00385 }
				cylinder { <-6.3023, 20.5449, 0.798>, <-6.3298, 20.6024, 0.8412>, 0.00385 }
				cylinder { <-6.3298, 20.6024, 0.8412>, <-6.3489, 20.6486, 0.8998>, 0.00385 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-6.7733, 21.04888, 1.8904>, <-7.7528, 22.5023, 3.6231>, <-6.3489, 20.6486, 0.8998> }
				triangle { <-6.7733, 21.04888, 1.8904>, <-7.7167, 22.2464, 3.8368>, <-7.7528, 22.5023, 3.6231> }
				triangle { <-7.7167, 22.2464, 3.8368>, <-9.1662, 22.8621, 5.2512>, <-7.7528, 22.5023, 3.6231> }
				triangle { <-7.7528, 22.5023, 3.6231>, <-9.1662, 22.8621, 5.2512>, <-9.2626, 23.07811, 5.1008> }
				triangle { <-9.1662, 22.8621, 5.2512>, <-9.9588, 22.6007, 5.353>, <-9.2626, 23.07811, 5.1008> }
				triangle { <-9.9588, 22.6007, 5.353>, <-9.2975, 23.1963, 4.9961>, <-9.2626, 23.07811, 5.1008> }
				triangle { <-9.2626, 23.07811, 5.1008>, <-9.2975, 23.1963, 4.9961>, <-7.7528, 22.5023, 3.6231> }
				triangle { <-7.7528, 22.5023, 3.6231>, <-9.2975, 23.1963, 4.9961>, <-7.8325, 22.7624, 3.4435> }
				triangle { <-7.8325, 22.7624, 3.4435>, <-6.3489, 20.6486, 0.8998>, <-7.7528, 22.5023, 3.6231> }
				triangle { <-6.3489, 20.6486, 0.8998>, <-7.8325, 22.7624, 3.4435>, <-6.7501, 21.4822, 1.5044> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <-6.2685, 20.4804, 0.7731>, <-6.5565, 20.9926, 0.8086>, 0.09811 }
				cylinder { <-6.5565, 20.9926, 0.8086>, <-6.8445, 21.5048, 0.8441>, 0.09811 }
				cylinder { <-6.8445, 21.5048, 0.8441>, <-7.1324, 22.01701, 0.8797>, 0.09811 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-7.1324, 22.01701, 0.8797>, <-7.1713, 22.08158, 0.8638>, 0.00385 }
				cylinder { <-7.1713, 22.08158, 0.8638>, <-7.2084, 22.139, 0.8284>, 0.00385 }
				cylinder { <-7.2084, 22.139, 0.8284>, <-7.2412, 22.1852, 0.7763>, 0.00385 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-7.9995, 22.8327, 0.2043>, <-9.2435, 23.9894, -1.5814>, <-7.2412, 22.1852, 0.7763> }
				triangle { <-7.9995, 22.8327, 0.2043>, <-9.4299, 24.1292, -1.3402>, <-9.2435, 23.9894, -1.5814> }
				triangle { <-9.4299, 24.1292, -1.3402>, <-11.1161, 24.5965, -2.5315>, <-9.2435, 23.9894, -1.5814> }
				triangle { <-9.2435, 23.9894, -1.5814>, <-11.1161, 24.5965, -2.5315>, <-11.0248, 24.4663, -2.7622> }
				triangle { <-11.1161, 24.5965, -2.5315>, <-11.8461, 24.1867, -2.6091>, <-11.0248, 24.4663, -2.7622> }
				triangle { <-11.8461, 24.1867, -2.6091>, <-10.9485, 24.3867, -2.8807>, <-11.0248, 24.4663, -2.7622> }
				triangle { <-11.0248, 24.4663, -2.7622>, <-10.9485, 24.3867, -2.8807>, <-9.2435, 23.9894, -1.5814> }
				triangle { <-9.2435, 23.9894, -1.5814>, <-10.9485, 24.3867, -2.8807>, <-9.1077, 23.8538, -1.8449> }
				triangle { <-9.1077, 23.8538, -1.8449>, <-7.2412, 22.1852, 0.7763>, <-9.2435, 23.9894, -1.5814> }
				triangle { <-7.2412, 22.1852, 0.7763>, <-9.1077, 23.8538, -1.8449>, <-7.6079, 22.6231, -0.1698> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <-7.1324, 22.01701, 0.8797>, <-7.1701, 22.08401, 0.8843>, 0.00385 }
				cylinder { <-7.1701, 22.08401, 0.8843>, <-7.2078, 22.151, 0.889>, 0.00385 }
				cylinder { <-7.2078, 22.151, 0.889>, <-7.2455, 22.218, 0.8936>, 0.00385 }
				texture {fol5}}
			mesh { // leaf
				triangle { <-7.9962, 23.03871, 1.1839>, <-9.4865, 25.00105, 1.1305>, <-7.2455, 22.218, 0.8936> }
				triangle { <-7.9962, 23.03871, 1.1839>, <-9.5497, 24.943, 1.4546>, <-9.4865, 25.00105, 1.1305> }
				triangle { <-9.5497, 24.943, 1.4546>, <-11.3961, 25.9721, 1.5637>, <-9.4865, 25.00105, 1.1305> }
				triangle { <-9.4865, 25.00105, 1.1305>, <-11.3961, 25.9721, 1.5637>, <-11.4151, 26.02562, 1.2892> }
				triangle { <-11.3961, 25.9721, 1.5637>, <-12.1798, 25.6683, 1.5417>, <-11.4151, 26.02562, 1.2892> }
				triangle { <-12.1798, 25.6683, 1.5417>, <-11.4004, 26.04496, 1.1293>, <-11.4151, 26.02562, 1.2892> }
				triangle { <-11.4151, 26.02562, 1.2892>, <-11.4004, 26.04496, 1.1293>, <-9.4865, 25.00105, 1.1305> }
				triangle { <-9.4865, 25.00105, 1.1305>, <-11.4004, 26.04496, 1.1293>, <-9.4763, 25.07388, 0.8129> }
				triangle { <-9.4763, 25.07388, 0.8129>, <-7.2455, 22.218, 0.8936>, <-9.4865, 25.00105, 1.1305> }
				triangle { <-7.2455, 22.218, 0.8936>, <-9.4763, 25.07388, 0.8129>, <-7.8022, 23.1399, 0.6459> }
				texture {fol5}}
			}
		}
	union { // internode
		cylinder { <-0.0, 7.3092, 0.0>, <-0.0, 7.3608, 0.0>, 0.03869 }
		cylinder { <-0.0, 7.3608, 0.0>, <-0.0, 7.4124, 0.0>, 0.03869 }
		cylinder { <-0.0, 7.4124, 0.0>, <-0.0, 7.464, 0.0>, 0.03869 }
		texture {fol5}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0, 7.464, 0.0>, <0.1423, 8.4677, 0.1002>, 0.05093 }
			cylinder { <0.1423, 8.4677, 0.1002>, <0.4229, 9.4268, 0.2978>, 0.05093 }
			cylinder { <0.4229, 9.4268, 0.2978>, <0.8334, 10.3132, 0.587>, 0.05093 }
			texture {fol5}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.8334, 10.3132, 0.587>, <0.9566, 10.5791, 0.6737>, 0.05093 }
				cylinder { <0.9566, 10.5791, 0.6737>, <1.07981, 10.845, 0.7604>, 0.05093 }
				cylinder { <1.07981, 10.845, 0.7604>, <1.2029, 11.1109, 0.8472>, 0.05093 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.2029, 11.1109, 0.8472>, <1.2142, 11.1283, 0.8483>, 0.001037 }
				cylinder { <1.2142, 11.1283, 0.8483>, <1.2275, 11.1438, 0.8447>, 0.001037 }
				cylinder { <1.2275, 11.1438, 0.8447>, <1.2419, 11.1562, 0.8364>, 0.001037 }
				texture {fol5}}
			mesh { // leaf
				triangle { <1.7505, 11.364, 0.6034>, <2.7314, 12.1186, 0.2783>, <1.2419, 11.1562, 0.8364> }
				triangle { <1.7505, 11.364, 0.6034>, <2.792, 11.9857, 0.1835>, <2.7314, 12.1186, 0.2783> }
				triangle { <2.792, 11.9857, 0.1835>, <3.8427, 12.3054, 0.1448>, <2.7314, 12.1186, 0.2783> }
				triangle { <2.7314, 12.1186, 0.2783>, <3.8427, 12.3054, 0.1448>, <3.8273, 12.4175, 0.2363> }
				triangle { <3.8427, 12.3054, 0.1448>, <4.1831, 12.1696, 0.382>, <3.8273, 12.4175, 0.2363> }
				triangle { <4.1831, 12.1696, 0.382>, <3.8043, 12.4789, 0.2887>, <3.8273, 12.4175, 0.2363> }
				triangle { <3.8273, 12.4175, 0.2363>, <3.8043, 12.4789, 0.2887>, <2.7314, 12.1186, 0.2783> }
				triangle { <2.7314, 12.1186, 0.2783>, <3.8043, 12.4789, 0.2887>, <2.6994, 12.2536, 0.3752> }
				triangle { <2.6994, 12.2536, 0.3752>, <1.2419, 11.1562, 0.8364>, <2.7314, 12.1186, 0.2783> }
				triangle { <1.2419, 11.1562, 0.8364>, <2.6994, 12.2536, 0.3752>, <1.607, 11.589, 0.7437> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <1.2029, 11.1109, 0.8472>, <1.3261, 11.3768, 0.9339>, 0.05093 }
				cylinder { <1.3261, 11.3768, 0.9339>, <1.4492, 11.6427, 1.02069>, 0.05093 }
				cylinder { <1.4492, 11.6427, 1.02069>, <1.5724, 11.9086, 1.1074>, 0.05093 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.5724, 11.9086, 1.1074>, <1.5773, 11.926, 1.1176>, 0.001037 }
				cylinder { <1.5773, 11.926, 1.1176>, <1.5783, 11.9415, 1.1314>, 0.001037 }
				cylinder { <1.5783, 11.9415, 1.1314>, <1.5754, 11.954, 1.1477>, 0.001037 }
				texture {fol5}}
			mesh { // leaf
				triangle { <1.6677, 12.2901, 1.6321>, <1.5236, 12.8906, 2.7527>, <1.5754, 11.954, 1.1477> }
				triangle { <1.6677, 12.2901, 1.6321>, <1.6794, 12.9632, 2.725>, <1.5236, 12.8906, 2.7527> }
				triangle { <1.6794, 12.9632, 2.725>, <1.9127, 13.2058, 3.7711>, <1.5236, 12.8906, 2.7527> }
				triangle { <1.5236, 12.8906, 2.7527>, <1.9127, 13.2058, 3.7711>, <1.7971, 13.1382, 3.828> }
				triangle { <1.9127, 13.2058, 3.7711>, <2.1664, 12.993, 4.0555>, <1.7971, 13.1382, 3.828> }
				triangle { <2.1664, 12.993, 4.0555>, <1.7265, 13.09691, 3.847>, <1.7971, 13.1382, 3.828> }
				triangle { <1.7971, 13.1382, 3.828>, <1.7265, 13.09691, 3.847>, <1.5236, 12.8906, 2.7527> }
				triangle { <1.5236, 12.8906, 2.7527>, <1.7265, 13.09691, 3.847>, <1.3795, 12.8202, 2.8068> }
				triangle { <1.3795, 12.8202, 2.8068>, <1.5754, 11.954, 1.1477>, <1.5236, 12.8906, 2.7527> }
				triangle { <1.5754, 11.954, 1.1477>, <1.3795, 12.8202, 2.8068>, <1.3866, 12.1813, 1.6395> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <1.5724, 11.9086, 1.1074>, <1.6955, 12.1745, 1.1941>, 0.05093 }
				cylinder { <1.6955, 12.1745, 1.1941>, <1.8187, 12.4404, 1.2809>, 0.05093 }
				cylinder { <1.8187, 12.4404, 1.2809>, <1.9419, 12.7063, 1.3676>, 0.05093 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <1.9419, 12.7063, 1.3676>, <1.9531, 12.7237, 1.3687>, 0.001037 }
				cylinder { <1.9531, 12.7237, 1.3687>, <1.9664, 12.7392, 1.3651>, 0.001037 }
				cylinder { <1.9664, 12.7392, 1.3651>, <1.9808, 12.7517, 1.3568>, 0.001037 }
				texture {fol5}}
			mesh { // leaf
				triangle { <2.4894, 12.9595, 1.1238>, <3.4703, 13.714, 0.7987>, <1.9808, 12.7517, 1.3568> }
				triangle { <2.4894, 12.9595, 1.1238>, <3.5309, 13.5812, 0.7039>, <3.4703, 13.714, 0.7987> }
				triangle { <3.5309, 13.5812, 0.7039>, <4.5816, 13.9008, 0.6652>, <3.4703, 13.714, 0.7987> }
				triangle { <3.4703, 13.714, 0.7987>, <4.5816, 13.9008, 0.6652>, <4.5663, 14.01298, 0.7567> }
				triangle { <4.5816, 13.9008, 0.6652>, <4.922, 13.7651, 0.9024>, <4.5663, 14.01298, 0.7567> }
				triangle { <4.922, 13.7651, 0.9024>, <4.5432, 14.07437, 0.8092>, <4.5663, 14.01298, 0.7567> }
				triangle { <4.5663, 14.01298, 0.7567>, <4.5432, 14.07437, 0.8092>, <3.4703, 13.714, 0.7987> }
				triangle { <3.4703, 13.714, 0.7987>, <4.5432, 14.07437, 0.8092>, <3.4383, 13.849, 0.8956> }
				triangle { <3.4383, 13.849, 0.8956>, <1.9808, 12.7517, 1.3568>, <3.4703, 13.714, 0.7987> }
				triangle { <1.9808, 12.7517, 1.3568>, <3.4383, 13.849, 0.8956>, <2.346, 13.1844, 1.2642> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <1.9419, 12.7063, 1.3676>, <2.06506, 12.9722, 1.4543>, 0.05093 }
				cylinder { <2.06506, 12.9722, 1.4543>, <2.1882, 13.2382, 1.5411>, 0.05093 }
				cylinder { <2.1882, 13.2382, 1.5411>, <2.3113, 13.5041, 1.6278>, 0.05093 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <2.3113, 13.5041, 1.6278>, <2.3162, 13.5215, 1.638>, 0.001037 }
				cylinder { <2.3162, 13.5215, 1.638>, <2.3172, 13.537, 1.6518>, 0.001037 }
				cylinder { <2.3172, 13.537, 1.6518>, <2.3143, 13.5494, 1.6681>, 0.001037 }
				texture {fol5}}
			mesh { // leaf
				triangle { <2.4066, 13.8856, 2.1525>, <2.2626, 14.4861, 3.2732>, <2.3143, 13.5494, 1.6681> }
				triangle { <2.4066, 13.8856, 2.1525>, <2.4183, 14.5586, 3.2454>, <2.2626, 14.4861, 3.2732> }
				triangle { <2.4183, 14.5586, 3.2454>, <2.6516, 14.8012, 4.2915>, <2.2626, 14.4861, 3.2732> }
				triangle { <2.2626, 14.4861, 3.2732>, <2.6516, 14.8012, 4.2915>, <2.536, 14.7336, 4.3484> }
				triangle { <2.6516, 14.8012, 4.2915>, <2.9054, 14.5885, 4.5759>, <2.536, 14.7336, 4.3484> }
				triangle { <2.9054, 14.5885, 4.5759>, <2.4654, 14.6923, 4.3674>, <2.536, 14.7336, 4.3484> }
				triangle { <2.536, 14.7336, 4.3484>, <2.4654, 14.6923, 4.3674>, <2.2626, 14.4861, 3.2732> }
				triangle { <2.2626, 14.4861, 3.2732>, <2.4654, 14.6923, 4.3674>, <2.1184, 14.4157, 3.3272> }
				triangle { <2.1184, 14.4157, 3.3272>, <2.3143, 13.5494, 1.6681>, <2.2626, 14.4861, 3.2732> }
				triangle { <2.3143, 13.5494, 1.6681>, <2.1184, 14.4157, 3.3272>, <2.1255, 13.7767, 2.1599> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <2.3113, 13.5041, 1.6278>, <2.4345, 13.77, 1.7145>, 0.05093 }
				cylinder { <2.4345, 13.77, 1.7145>, <2.5576, 14.03592, 1.8013>, 0.05093 }
				cylinder { <2.5576, 14.03592, 1.8013>, <2.6808, 14.3018, 1.888>, 0.05093 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <2.6808, 14.3018, 1.888>, <2.692, 14.3192, 1.8892>, 0.001037 }
				cylinder { <2.692, 14.3192, 1.8892>, <2.7054, 14.3347, 1.8855>, 0.001037 }
				cylinder { <2.7054, 14.3347, 1.8855>, <2.7198, 14.3471, 1.8773>, 0.001037 }
				texture {fol5}}
			mesh { // leaf
				triangle { <3.2284, 14.5549, 1.6442>, <4.2093, 15.3095, 1.3191>, <2.7198, 14.3471, 1.8773> }
				triangle { <3.2284, 14.5549, 1.6442>, <4.2699, 15.1766, 1.2244>, <4.2093, 15.3095, 1.3191> }
				triangle { <4.2699, 15.1766, 1.2244>, <5.3205, 15.4962, 1.1857>, <4.2093, 15.3095, 1.3191> }
				triangle { <4.2093, 15.3095, 1.3191>, <5.3205, 15.4962, 1.1857>, <5.3052, 15.6084, 1.2771> }
				triangle { <5.3205, 15.4962, 1.1857>, <5.6609, 15.3605, 1.4228>, <5.3052, 15.6084, 1.2771> }
				triangle { <5.6609, 15.3605, 1.4228>, <5.2821, 15.6698, 1.3296>, <5.3052, 15.6084, 1.2771> }
				triangle { <5.3052, 15.6084, 1.2771>, <5.2821, 15.6698, 1.3296>, <4.2093, 15.3095, 1.3191> }
				triangle { <4.2093, 15.3095, 1.3191>, <5.2821, 15.6698, 1.3296>, <4.1773, 15.4445, 1.416> }
				triangle { <4.1773, 15.4445, 1.416>, <2.7198, 14.3471, 1.8773>, <4.2093, 15.3095, 1.3191> }
				triangle { <2.7198, 14.3471, 1.8773>, <4.1773, 15.4445, 1.416>, <3.08495, 14.7799, 1.7846> }
				texture {fol5}}
			union { // compound leaf internode
				cylinder { <2.6808, 14.3018, 1.888>, <2.804, 14.5677, 1.9748>, 0.05093 }
				cylinder { <2.804, 14.5677, 1.9748>, <2.9271, 14.8336, 2.06154>, 0.05093 }
				cylinder { <2.9271, 14.8336, 2.06154>, <3.05031, 15.09955, 2.1482>, 0.05093 }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <3.05031, 15.09955, 2.1482>, <3.05519, 15.1169, 2.1584>, 0.001037 }
				cylinder { <3.05519, 15.1169, 2.1584>, <3.05622, 15.1324, 2.1722>, 0.001037 }
				cylinder { <3.05622, 15.1324, 2.1722>, <3.05333, 15.1449, 2.1886>, 0.001037 }
				texture {fol5}}
			mesh { // leaf
				triangle { <3.1455, 15.481, 2.673>, <3.001541, 16.08155, 3.7936>, <3.05333, 15.1449, 2.1886> }
				triangle { <3.1455, 15.481, 2.673>, <3.1573, 16.1541, 3.7658>, <3.001541, 16.08155, 3.7936> }
				triangle { <3.1573, 16.1541, 3.7658>, <3.3906, 16.3967, 4.8119>, <3.001541, 16.08155, 3.7936> }
				triangle { <3.001541, 16.08155, 3.7936>, <3.3906, 16.3967, 4.8119>, <3.275, 16.3291, 4.8688> }
				triangle { <3.3906, 16.3967, 4.8119>, <3.6443, 16.1839, 5.09634>, <3.275, 16.3291, 4.8688> }
				triangle { <3.6443, 16.1839, 5.09634>, <3.2043, 16.2878, 4.8878>, <3.275, 16.3291, 4.8688> }
				triangle { <3.275, 16.3291, 4.8688>, <3.2043, 16.2878, 4.8878>, <3.001541, 16.08155, 3.7936> }
				triangle { <3.001541, 16.08155, 3.7936>, <3.2043, 16.2878, 4.8878>, <2.8574, 16.01114, 3.8476> }
				triangle { <2.8574, 16.01114, 3.8476>, <3.05333, 15.1449, 2.1886>, <3.001541, 16.08155, 3.7936> }
				triangle { <3.05333, 15.1449, 2.1886>, <2.8574, 16.01114, 3.8476>, <2.8644, 15.3722, 2.6803> }
				texture {fol5}}
			union { // compound leaf petiolet
				cylinder { <3.05031, 15.09955, 2.1482>, <3.05868, 15.1176, 2.1541>, 0.001037 }
				cylinder { <3.05868, 15.1176, 2.1541>, <3.06704, 15.1356, 2.16>, 0.001037 }
				cylinder { <3.06704, 15.1356, 2.16>, <3.0754, 15.1537, 2.1659>, 0.001037 }
				texture {fol5}}
			mesh { // leaf
				triangle { <3.4654, 15.5797, 2.316>, <4.02001, 16.5985, 2.8561>, <3.0754, 15.1537, 2.1659> }
				triangle { <3.4654, 15.5797, 2.316>, <4.1573, 16.5684, 2.7535>, <4.02001, 16.5985, 2.8561> }
				triangle { <4.1573, 16.5684, 2.7535>, <4.9056, 17.1026, 3.3552>, <4.02001, 16.5985, 2.8561> }
				triangle { <4.02001, 16.5985, 2.8561>, <4.9056, 17.1026, 3.3552>, <4.8172, 17.1304, 3.4674> }
				triangle { <4.9056, 17.1026, 3.3552>, <5.1994, 16.9449, 3.6369>, <4.8172, 17.1304, 3.4674> }
				triangle { <5.1994, 16.9449, 3.6369>, <4.7558, 17.1404, 3.5238>, <4.8172, 17.1304, 3.4674> }
				triangle { <4.8172, 17.1304, 3.4674>, <4.7558, 17.1404, 3.5238>, <4.02001, 16.5985, 2.8561> }
				triangle { <4.02001, 16.5985, 2.8561>, <4.7558, 17.1404, 3.5238>, <3.9053, 16.6363, 2.9747> }
				triangle { <3.9053, 16.6363, 2.9747>, <3.0754, 15.1537, 2.1659>, <4.02001, 16.5985, 2.8561> }
				triangle { <3.0754, 15.1537, 2.1659>, <3.9053, 16.6363, 2.9747>, <3.2032, 15.6323, 2.4553> }
				texture {fol5}}
			}
		}
} // end New_plant_6

