// Persistence of Vision Ray Tracer Scene Description File
// File: mg_fte.pov
// Vers: 3.1g
// Desc: A spanish fortress in Guayana 
// Date: February 22, 2000
// Auth: Marjorie DIez de Graterol


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "texturas.inc"
global_settings{assumed_gamma 2.2 }
global_settings { ambient_light color rgb <0.839,0.820,0.843>}

//comentado -commented
//
 /*
media{
    emission 0.10
    scattering {1, 0.85}
    density { spherical
    turbulence 0.2
      color_map{
        [0.0 rgb <0,0,0,>]//<0,0,0.5>]
        [0.01 rgb <0.816,0.553,0.259>]
        [1.0 rgb  <0.902,0.573,0.455>]
      }

    }
  }
 */
camera
{
  location  <0.5 , 3.5 ,-6> //<0.5 , 3.5 ,-6> 
  look_at   <-0.5 , 2.05 , 2.5> // <-0.5 , 2.05 , 2.5>
  angle 35
}


sky_sphere{Oriente2}

    
  fog {
    fog_type 1 // 1=constant, 2=ground_fog
    distance 400//10
    color rgbft <1.000,0.906,0.976,0.2,0.8> 
    turbulence 0.4
    turb_depth 0.5
    fog_offset 0.2
    fog_alt 0.3
    //media_attenuation on

  }

 

//LUCES-LIGHTS

union{

light_source
{
  0*x 
  color rgb <0.537,0.314,0.204>
  translate <-20, 40, 10> 
  media_attenuation on
}
 
light_source
{
  0*x 
  color rgbft <0.976,0.843,0.369,0.2,08>
  translate <15, 60, 50>
  //media_attenuation on
} 
                                      

light_source
{
  0*x 
  color rgb <1.000,0.906,0.976>
  translate <0, 100, 100>
  //media_attenuation on
}

//garitas 

//compuesta

light_source
{
  0*x                     
  color Feldspar      
  spotlight               
  translate <10, 80, -40> 
  point_at <-1.60,1.70,-3.98>      
  radius 40               
  tightness 10           
  falloff 80
  fade_distance 150
  fade_power 100
  media_attenuation on

               
}

light_source
{
  0*x                     
  color MandarinOrange       
  spotlight               
  translate <40, 80, -40> 
  point_at <-1.60,1.70,-3.98>      
  radius 40                
  tightness 10          
  falloff 80
  fade_distance 150
  fade_power 100
  media_attenuation on

               
}


light_source
{
  0*x                     
  color VeryDarkBrown       
  spotlight               
  translate <5, 1, -20> 
  point_at <1,1,-2>      
  radius 20                
  tightness 10           
  falloff 80
  fade_distance 150
  fade_power 100
  media_attenuation on

               
}   
//caon

light_source
{
  0*x                     
  color rgb <0.816,0.706,0.592>
  spotlight               
  translate <60, 80, -40> 
  point_at <1.20,2.25,5.75>      
  radius 10                
  tightness 70           
  falloff 20
  fade_distance 85
  fade_power 75
  media_attenuation on
}

}

//agua-water
plane
{
  y, 
  -4.0 
  hollow on 
  interior{ior 1.33} 
  texture{rio}
  texture{rio2 translate -3.998}
}


//plano debajo del agua-underwater  //verde azulado
plane {   
    y,   
    -4.5   
    hollow on   
    pigment{color rgb <0.145,0.494,0.467>}
    finish {ambient 0.3}
} 

//DESDE AQUI EL FUERTE
 


#include "fuertesp.inc"

union{
object {fuerte  scale 2 rotate 180*y translate <2,0,0>}     
object {fuerte  scale 2 rotate 180*y translate <2,-0.01,0>}

////////////////

    #include "plates.inc"
    #declare T_Brick= 
    texture { pigment 
            { bozo 
            colour_map {    [0 rgb <0.871,0.792,0.518>]   // amarillo calido obscuro
                        [1.0 rgb <0.459,0.376,0.298>] }   // sepia
                        scale 50 } 
            normal { granite 0.1 scale 0.01 }}


    #declare T_Mortar   = texture { pigment { colour rgb <0.459,0.376,0.298> } normal { granite 0.05 scale 0.005 }}

    #declare T_CylBrick = MakeCylindricalPlates( 0.8, 0.4, 0.2, 0.03, T_Brick, T_Mortar )
    #declare T_SphBrick = MakeSphericalPlates( 0.8, 0.4, 0.2, 0.03, T_Brick, T_Mortar )

//Garita
    #declare garita=
        difference{
            union {
                cylinder { <0,0,0>, <0,4,0>, 1 texture { T_CylBrick scale <1,10/9,1> }}
                sphere { <0,4,0>, 1 texture { T_SphBrick translate y*5 }}
                translate <0,0,-9>
                  }


            union{
                union{ 

                cylinder { <0,-1,0>, <0,4,0>, 0.85 pigment {Black}}
                sphere { <0,4,0>, 0.85 pigment {Black}}
                translate <0,0,-9>//translate x*-5
                    }
            box  
                {
                <.5, -1.50, -1>  
                < 1.50,  2.25,  0.5>  
                pigment {Black}
                translate <-1,1,-9>
                }             

            box 
                {
                <.8, 1.0, 0.5>  
                < 1.20,  3,  2.5>  
                pigment {Black}
                translate <-1,1,-10>
                }      

            }

    }

 
//#include "texturas.inc"

#declare garita2=
    difference{
        union {
            cylinder { <0,0,0>, <0,4,0>, 1 }
            sphere { <0,4,0>, 1 }
            translate <0,0,-9>
            }
        union{
            union{ 

                cylinder { <0,-1,0>, <0,4,0>, 0.85 }
                sphere { <0,4,0>, 0.85 }
                translate <0,0,-9>//translate x*-5
                }
            box   
            {
            <.5, -1.50, -1>  
            < 1.50,  2.25,  0.5>  
            translate <-1,1,-9>
            }             

            box 
            {
            <.8, 1.0, 0.5>  
            < 1.20,  3,  2.5>  
            
            translate <-1,1,-10>
            }      

        } 


    
     texture {textura2}

    }

//alero
#declare garita_final=
    union{
        object{garita}
        object{garita2 scale 1.005}
        torus
        {
        0.95,
        0.2
        texture{textura2}
        scale<1,0.5,1>
        translate <0,4,-9>
        }
        translate <0,0,0>    
    
    }


//ojo estas son las garitas
object{garita_final  scale 0.50 rotate -5*y translate <-1,1.70,10.5>} 

//centro izquierda desde el frente

object{garita_final  scale 0.50 rotate 190*y translate <-1.60,1.70,-3.98>}
object{garita2 scale 0.499 rotate 190*y translate <-1.60,1.70,-3.98>}




//HASTA AQUI EL FUERTE



//caonera

#include "porta_c.inc"

object {porta_c scale 0.30 rotate 65*y translate <1.3,1.95,5.5>} 

//can
#include "canon1.inc"

object{canon1 texture {Oldcan} scale 0.70 rotate 65*y translate <1.10,2.20,6>} 


//balas de caon
sphere{<0,0,0>,0.15 texture{textura7}translate <0.85,1.90,4.25>}  
sphere{<0,0,0>,0.15 texture{textura7} rotate 90*y translate <1,1.90,3.5>}  

//HASTA AQUI CAON Y BALAS 




//paisaje del frente /right-front view 

 
height_field
{
  tga               
  "terreno3.tga"     
  smooth        
  water_level 0.45 
  
  texture{ textura4 scale 2 rotate -45*y  }
scale <60,20,60>
rotate 60*y
translate <-1,-17.5,200> 

} 

///islote del frente- front view 

height_field
{
  tga               
  "avila6_b.tga"     
  smooth        
  water_level 0.015
 texture{ textura4a  rotate -45*y}  
 scale <600,240,400>
rotate 110*y
translate <-150,-19,1200>

} 



//casero -left front



#local caserio=
height_field
{
  tga "orien1.tga"
  texture
  {
    pigment
    {
      image_map { tga "orien2.tga" map_type 0 interpolate 2 once }
      rotate x*90 
    }finish {phong 0.5}
  }  
}



object {caserio scale <75,80,75> translate <-120,-10,150.5>}



#local arena=
height_field
{
  tga               
  "montana.tga"     

pigment{color rgb <0.914,0.757,0.475>}
normal{ bozo 0.39999 frequency 0.005 }
finish{phong 0.3}

}


object {arena scale <110,90,110> rotate 15*y translate <-110,-9.5,180.5>}
//frente
object {arena scale <110,90,110> rotate 15*y translate <-110,-10,135.5>}
//hacia la izquierda
object {arena scale <110,90,110> rotate 15*y translate <-140,-10,125.5>}

//arco (inferior-izquierdo) 
 #include "arcos.inc"
 object{arco 
 scale  0.45 rotate 45*y 
 translate <-3.5,-0.5,7>} 
 
 
//anexo izquierda


#include "otropiso.inc" 
object{inferior 
    texture{ textura3 scale 6}
    texture{textura5 scale 6 translate 0.00005*y } 
    texture {fantasma translate 0.0001*y}

rotate -30*y translate <-6,-0.5,13.5>}//translate <-6,-2,15.5> -0.5y //} 






//weeds-vegetacion

#include "follaje5.inc" 

object{follaje5 scale <0.006,0.010,0.006> translate <0,1.90,3.95>}
object{follaje5 scale <0.006,0.010,0.006> translate <0,30.90,3.95>}  
object{follaje5 scale <0.004,0.008,0.004> translate <0.75,1.68,-0.8>} 

//reja- fence
#include "rejarui.inc"

object{rejarui scale <0.35,0.15,0.25> translate <-2.0,1.2,1>}


}

