// Sample scene file for plates.inc

#include "plates.inc"

#declare BaseColour        = <0.65,0.70,0.80>;
#declare RustMod           = <1.09,0.977,0.882>;
#declare P_D7_Dark         = pigment { colour rgb BaseColour*0.6 }
#declare P_D7_Base         = pigment { bozo colour_map {[0.0 colour rgb BaseColour*0.977][0.5 colour rgb BaseColour*1.022][1.0 colour rgb BaseColour*0.977]}}
#declare P_D7_Streaky      = pigment { bozo pigment_map {[0.400 P_D7_Base][0.800 colour rgb BaseColour*0.93 ]} turbulence <0,0.5,0> scale <0.4,5,0.4>}
#declare P_D7_Streaky_Dark = pigment { average pigment_map {[1.0 P_D7_Streaky][0.5 P_D7_Dark]}}
#declare P_D7_Rust         = pigment { bozo colour_map {[0.0 rgb BaseColour][1.0 rgb BaseColour*RustMod]}}
#declare T_D7_Rust1        = texture { pigment { average pigment_map {[0.25 P_D7_Rust scale 0.1][1.00 P_D7_Streaky]}} finish { specular 0.5 roughness 0.010 metallic brilliance 1.75 }}
#declare T_D7_Plates1      = texture { pigment { P_D7_Streaky } finish { specular 1.0 roughness 0.005 metallic brilliance 2.00 } }
#declare T_D7_Plates2      = texture { pigment { P_D7_Streaky_Dark } finish { specular 0.5 roughness 0.010 metallic brilliance 1.75 } }
#declare T_D7_PlatesA      = texture { bozo texture_map {[0.0 T_D7_Plates1 scale 0.01][1.0 T_D7_Plates2 scale 0.01]}}
#declare T_MetalPlates     = texture { bozo texture_map { [0.0 T_D7_PlatesA][1.0 T_D7_Rust1] } scale <0.03,1,0.03>*15 }
#declare T_PlateJoins      = texture { pigment { colour rgb <0.25,0.25,0.25> }}
#declare T_Brick           = texture { pigment { bozo colour_map { [0 rgb <0.40,0,0>][1.0 rgb <0.65,0.2,0>] } scale 50 } normal { granite 0.1 scale 0.01 }}
#declare T_Mortar          = texture { pigment { colour rgb <1,1,1> } normal { granite 0.05 scale 0.005 }}

#declare T_CylBrick        = MakeCylindricalPlates( 4, 0.6, 0.3, 0.05, T_Brick, T_Mortar )
#declare T_SphBrick        = MakeSphericalPlates( 4, 0.6, 0.3, 0.05, T_Brick, T_Mortar )
#declare T_CylMetal        = MakeCylindricalPlates( 4, 0.75, 0.5, 0.015, T_MetalPlates, T_PlateJoins )
#declare T_SphMetal        = MakeSphericalPlates( 4, 0.75, 0.5, 0.015, T_MetalPlates, T_PlateJoins )

union {
  cylinder { <0,0,0>, <0,5,0>, 4 texture { T_CylBrick scale <1,10/9,1> }}
  sphere { <0,5,0>, 4 texture { T_SphBrick translate y*5 }}
  translate x*-5
}

union {
  cylinder { <0,0,0>, <0,5,0>, 4 texture { T_CylMetal }}
  sphere { <0,5,0>, 4 texture { T_SphMetal translate y*5 }}
  translate x*5
}

plane { y, 0 pigment { colour rgb <1,1,1> } }
camera { location <0,23,-23> look_at <0,3,0> angle 37.5 }
light_source { <-1000,1000,-1000> colour rgb 1 }
light_source { <1000,1000,1000> colour rgb 0.5 shadowless }
