// CITY GENERATOR: ARCTIC VILLAGE SCENE
// This scene shows how custom city generation macros can be defined
// and used to create all manner of objects arranged in city formation.

// CAMERA AND LIGHTING
   camera {location <-10, 30, -100> look_at <0, 0, 0>}
   light_source {<-400, 200, 400> rgb 1
      area_light x * 50, y * 50, 5, 5 adaptive 0}
   light_source {<200, 100, -500> rgb <.1, .2, .3> shadowless}
   fog {fog_type 1 color rgb <.8, .9, 1> distance 500}

// CITY TEXTURES, OBJECTS, AND MACROS
   #declare R1 = seed(0);
   #declare BrickSlope = slope_map {[0 <0, 1>] [.05 <1, 0>] [.95 <1, 0>] [1 <0, -1>]}
   #declare Mortar1 = normal {gradient y bump_size 1 slope_map {BrickSlope} scale .5}
   #declare Mortar2 = normal {radial bump_size 1 slope_map {BrickSlope} frequency 15}
   #declare IceBricks = texture {
      pigment {wrinkles color_map {
         [0 rgb 1] [1 rgb <.9, .95, 1>]}}
      normal {gradient y normal_map {
        [.05 Mortar1] [.1 Mortar2] [.4 Mortar2] [.45 Mortar1] [.55 Mortar1]
        [.6 Mortar2 rotate y*12] [.9 Mortar2 rotate y*12] [.95 Mortar1]}}
      finish {phong .1 phong_size 5 ambient <.4, .5, .6> diffuse .5}
      scale 2.5}

   #declare Igloo = union {
      sphere {0, 10 texture {IceBricks}}
      difference {cylinder {0, x * 15, 6} cylinder {0, x * 16, 4}
         texture {IceBricks rotate z * 90}}
      clipped_by {box {<-10.1, 0, -10.1>, <15.1, 10.1, 10.1>}}}

   #macro city_base (C1, C2)
      plane {y, 0
         pigment {rgb 1}
         normal {wrinkles .5 scale 100}
         finish {phong .1 phong_size 5 ambient <.4, .5, .6> diffuse .5}}
   #end

   #macro city_building (C1, C2, D)
      object {Igloo
         scale (1 + (rand(R1)-.5) * .2) * building_width * .35 / 10 
         rotate y * rand(R1) * 360
         translate (C1+C2)/2 + (<rand(R1), .5, rand(R1)>-.5) * building_width * .3}
   #end

   #include "CITY"
