// CITY GENERATOR: CITY SCAPE USING FILECITY.MCR
// This scene shows how you can use the FileCity.mcr file to speed
// up multiple renderings of a city.
//
// This scene should be rendered as a four-frame, non-cyclic animation.
// The MyCity.inc file can be deleted when the rendering is finished.

// ENVIRONMENT
   light_source {<-300, 1000, -700> rgb 1}
   light_source {<200, 4000, 100> rgb .5 shadowless}
   default {finish {ambient .3 diffuse .5}}

   background {rgb <.4, .6, .8>}
   fog {fog_type 2 color rgb <.7, .8, .9> distance 300 fog_alt 50}

// SEPARATE CAMERAS FOR EACH FRAME
   #switch (int(clock*3))
   #case (0) camera {location <40, 350, -200> look_at <0, 0, 0>} #break
   #case (1) camera {fisheye location <-2, 1, -2> look_at <5, 20, 7> angle 140} #break
   #case (2) camera {location <-200, 40, -150> look_at <-50, 0, 0>} #break
   #case (3) camera {location <-185, 3, 5> look_at <0, 2, 0>} #end

// CREATE CITY AND SAVE TO FILE
   #declare debug_progress = true;
   #declare city_block_count = 4;
   #declare traffic_spacing = 0;
   #declare city_macro_file = "FILECITY.MCR"
   #declare city_output_file = "MYCITY.INC"

   #if (file_exists ("MYCITY.INC"))
      #include "MYCITY.INC"
   #else
      #include "CITY.INC"
   #end
