// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio

#declare Weed = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <0.0, 0.7113, 0.0>, 0.2845 }
		cylinder { <0.0, 0.7113, 0.0>, <0.0, 1.4227, 0.0>, 0.2845 }
		cylinder { <0.0, 1.4227, 0.0>, <0.0, 2.134, 0.0>, 0.2845 }
		  }
	union { // internode
		cylinder { <0.0, 2.134, 0.0>, <0.0, 3.1895, 0.0>, 0.4221 }
		cylinder { <0.0, 3.1895, 0.0>, <0.0, 4.245, 0.0>, 0.4221 }
		cylinder { <0.0, 4.245, 0.0>, <-0.0, 5.3005, 0.0>, 0.4221 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0, 5.3005, 0.0>, <0.004164, 5.4031, -0.02807>, 0.1596 }
			cylinder { <0.004164, 5.4031, -0.02807>, <0.01219, 5.4944, -0.08219>, 0.1596 }
			cylinder { <0.01219, 5.4944, -0.08219>, <0.0235, 5.5678, -0.1584>, 0.1596 }
			  }
		mesh { // leaf
			triangle { <0.0235, 5.5678, -0.1584>, <-0.4522, 6.4776, -0.8372>, <0.1579, 6.2686, -0.9077> }
			triangle { <0.1579, 6.2686, -0.9077>, <-0.4522, 6.4776, -0.8372>, <-0.4813, 7.2101, -1.6204> }
			triangle { <0.1579, 6.2686, -0.9077>, <-0.4813, 7.2101, -1.6204>, <0.2547, 6.9589, -1.753> }
			triangle { <-0.4813, 7.2101, -1.6204>, <0.2057, 7.5143, -2.6294>, <0.2547, 6.9589, -1.753> }
			triangle { <0.1579, 6.2686, -0.9077>, <0.6038, 5.9445, -1.1936>, <0.0235, 5.5678, -0.1584> }
			triangle { <0.6038, 5.9445, -1.1936>, <0.1579, 6.2686, -0.9077>, <0.2547, 6.9589, -1.753> }
			triangle { <0.7175, 6.5568, -2.0714>, <0.6038, 5.9445, -1.1936>, <0.2547, 6.9589, -1.753> }
			triangle { <0.7175, 6.5568, -2.0714>, <0.2547, 6.9589, -1.753>, <0.2057, 7.5143, -2.6294> }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0, 5.3005, 0.0>, <-0.004164, 5.4031, 0.02807>, 0.1596 }
			cylinder { <-0.004164, 5.4031, 0.02807>, <-0.01219, 5.4944, 0.08219>, 0.1596 }
			cylinder { <-0.01219, 5.4944, 0.08219>, <-0.0235, 5.5678, 0.1584>, 0.1596 }
			  }
		mesh { // leaf
			triangle { <-0.0235, 5.5678, 0.1584>, <0.4522, 6.4776, 0.8372>, <-0.1579, 6.2686, 0.9077> }
			triangle { <-0.1579, 6.2686, 0.9077>, <0.4522, 6.4776, 0.8372>, <0.4813, 7.2101, 1.6204> }
			triangle { <-0.1579, 6.2686, 0.9077>, <0.4813, 7.2101, 1.6204>, <-0.2547, 6.9589, 1.753> }
			triangle { <0.4813, 7.2101, 1.6204>, <-0.2057, 7.5143, 2.6294>, <-0.2547, 6.9589, 1.753> }
			triangle { <-0.1579, 6.2686, 0.9077>, <-0.6038, 5.9445, 1.1936>, <-0.0235, 5.5678, 0.1584> }
			triangle { <-0.6038, 5.9445, 1.1936>, <-0.1579, 6.2686, 0.9077>, <-0.2547, 6.9589, 1.753> }
			triangle { <-0.7175, 6.5568, 2.0714>, <-0.6038, 5.9445, 1.1936>, <-0.2547, 6.9589, 1.753> }
			triangle { <-0.7175, 6.5568, 2.0714>, <-0.2547, 6.9589, 1.753>, <-0.2057, 7.5143, 2.6294> }
			  }
		}
	union { // internode
		cylinder { <-0.0, 5.3005, 0.0>, <0.01796, 6.006308, -0.1211>, 0.2865 }
		cylinder { <0.01796, 6.006308, -0.1211>, <0.05337, 6.6807, -0.3598>, 0.2865 }
		cylinder { <0.05337, 6.6807, -0.3598>, <0.1051, 7.3039, -0.709>, 0.2865 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.1051, 7.3039, -0.709>, <0.113, 7.3576, -0.7621>, 0.1139 }
			cylinder { <0.113, 7.3576, -0.7621>, <0.1227, 7.395, -0.8275>, 0.1139 }
			cylinder { <0.1227, 7.395, -0.8275>, <0.1335, 7.4135, -0.9004>, 0.1139 }
			  }
		mesh { // leaf
			triangle { <0.1335, 7.4135, -0.9004>, <-0.1673, 7.7669, -1.6465>, <0.2554, 7.5811, -1.6095> }
			triangle { <0.2554, 7.5811, -1.6095>, <-0.1673, 7.7669, -1.6465>, <-0.1607, 7.9508, -2.39> }
			triangle { <0.2554, 7.5811, -1.6095>, <-0.1607, 7.9508, -2.39>, <0.3485, 7.7107, -2.3753> }
			triangle { <-0.1607, 7.9508, -2.39>, <0.3305, 7.7531, -3.1154>, <0.3485, 7.7107, -2.3753> }
			triangle { <0.2554, 7.5811, -1.6095>, <0.5522, 7.2572, -1.6689>, <0.1335, 7.4135, -0.9004> }
			triangle { <0.5522, 7.2572, -1.6689>, <0.2554, 7.5811, -1.6095>, <0.3485, 7.7107, -2.3753> }
			triangle { <0.6529, 7.3262, -2.4275>, <0.5522, 7.2572, -1.6689>, <0.3485, 7.7107, -2.3753> }
			triangle { <0.6529, 7.3262, -2.4275>, <0.3485, 7.7107, -2.3753>, <0.3305, 7.7531, -3.1154> }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.1051, 7.3039, -0.709>, <0.1078, 7.3776, -0.7273>, 0.1139 }
			cylinder { <0.1078, 7.3776, -0.7273>, <0.1076, 7.4535, -0.7254>, 0.1139 }
			cylinder { <0.1076, 7.4535, -0.7254>, <0.1043, 7.5262, -0.7036>, 0.1139 }
			  }
		mesh { // leaf
			triangle { <0.1043, 7.5262, -0.7036>, <0.4992, 8.3031, -0.5909>, <0.0549, 8.2293, -0.4824> }
			triangle { <0.0549, 8.2293, -0.4824>, <0.4992, 8.3031, -0.5909>, <0.5682, 9.02928, -0.3573> }
			triangle { <0.0549, 8.2293, -0.4824>, <0.5682, 9.02928, -0.3573>, <0.03301, 8.9574, -0.1973> }
			triangle { <0.5682, 9.02928, -0.3573>, <0.1084, 9.6049, 0.1561>, <0.03301, 8.9574, -0.1973> }
			triangle { <0.0549, 8.2293, -0.4824>, <-0.2753, 8.1506, -0.1974>, <0.1043, 7.5262, -0.7036> }
			triangle { <-0.2753, 8.1506, -0.1974>, <0.0549, 8.2293, -0.4824>, <0.03301, 8.9574, -0.1973> }
			triangle { <-0.3128, 8.8423, 0.1348>, <-0.2753, 8.1506, -0.1974>, <0.03301, 8.9574, -0.1973> }
			triangle { <-0.3128, 8.8423, 0.1348>, <0.03301, 8.9574, -0.1973>, <0.1084, 9.6049, 0.1561> }
			  }
		}
	union { // internode
		cylinder { <0.1051, 7.3039, -0.709>, <0.1248, 7.5407, -0.8417>, 0.1088 }
		cylinder { <0.1248, 7.5407, -0.8417>, <0.1445, 7.7775, -0.9744>, 0.1088 }
		cylinder { <0.1445, 7.7775, -0.9744>, <0.1642, 8.01435, -1.1071>, 0.1088 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.1642, 8.01435, -1.1071>, <0.1606, 8.03984, -1.116>, 0.04085 }
			cylinder { <0.1606, 8.03984, -1.116>, <0.1516, 8.06528, -1.1198>, 0.04085 }
			cylinder { <0.1516, 8.06528, -1.1198>, <0.138, 8.08882, -1.1183>, 0.04085 }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.1642, 8.01435, -1.1071>, <0.1716, 8.03454, -1.1238>, 0.04085 }
			cylinder { <0.1716, 8.03454, -1.1238>, <0.1839, 8.04975, -1.1427>, 0.04085 }
			cylinder { <0.1839, 8.04975, -1.1427>, <0.2002, 8.05888, -1.1625>, 0.04085 }
			  }
		}
	union { // internode
		cylinder { <-0.0, 5.3005, 0.0>, <-0.0129, 5.8072, 0.08696>, 0.2057 }
		cylinder { <-0.0129, 5.8072, 0.08696>, <-0.03832, 6.2914, 0.2583>, 0.2057 }
		cylinder { <-0.03832, 6.2914, 0.2583>, <-0.07551, 6.7389, 0.509>, 0.2057 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.07551, 6.7389, 0.509>, <-0.08131, 6.7784, 0.5482>, 0.08389 }
			cylinder { <-0.08131, 6.7784, 0.5482>, <-0.08845, 6.806, 0.5963>, 0.08389 }
			cylinder { <-0.08845, 6.806, 0.5963>, <-0.09641, 6.8196, 0.65>, 0.08389 }
			  }
		mesh { // leaf
			triangle { <-0.09641, 6.8196, 0.65>, <0.125, 7.07983, 1.1992>, <-0.1861, 6.943, 1.172> }
			triangle { <-0.1861, 6.943, 1.172>, <0.125, 7.07983, 1.1992>, <0.1202, 7.2151, 1.7465> }
			triangle { <-0.1861, 6.943, 1.172>, <0.1202, 7.2151, 1.7465>, <-0.2547, 7.03842, 1.7357> }
			triangle { <0.1202, 7.2151, 1.7465>, <-0.2414, 7.06968, 2.2805>, <-0.2547, 7.03842, 1.7357> }
			triangle { <-0.1861, 6.943, 1.172>, <-0.4046, 6.7046, 1.2157>, <-0.09641, 6.8196, 0.65> }
			triangle { <-0.4046, 6.7046, 1.2157>, <-0.1861, 6.943, 1.172>, <-0.2547, 7.03842, 1.7357> }
			triangle { <-0.4787, 6.7553, 1.7741>, <-0.4046, 6.7046, 1.2157>, <-0.2547, 7.03842, 1.7357> }
			triangle { <-0.4787, 6.7553, 1.7741>, <-0.2547, 7.03842, 1.7357>, <-0.2414, 7.06968, 2.2805> }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.07551, 6.7389, 0.509>, <-0.0775, 6.7932, 0.5225>, 0.08389 }
			cylinder { <-0.0775, 6.7932, 0.5225>, <-0.0773, 6.8491, 0.5211>, 0.08389 }
			cylinder { <-0.0773, 6.8491, 0.5211>, <-0.07492, 6.9026, 0.5051>, 0.08389 }
			  }
		mesh { // leaf
			triangle { <-0.07492, 6.9026, 0.5051>, <-0.3655, 7.4745, 0.4221>, <-0.0385, 7.4202, 0.3422> }
			triangle { <-0.0385, 7.4202, 0.3422>, <-0.3655, 7.4745, 0.4221>, <-0.4164, 8.009089, 0.2502> }
			triangle { <-0.0385, 7.4202, 0.3422>, <-0.4164, 8.009089, 0.2502>, <-0.02239, 7.9561, 0.1323> }
			triangle { <-0.4164, 8.009089, 0.2502>, <-0.07789, 8.4328, -0.1278>, <-0.02239, 7.9561, 0.1323> }
			triangle { <-0.0385, 7.4202, 0.3422>, <0.2046, 7.3622, 0.1324>, <-0.07492, 6.9026, 0.5051> }
			triangle { <0.2046, 7.3622, 0.1324>, <-0.0385, 7.4202, 0.3422>, <-0.02239, 7.9561, 0.1323> }
			triangle { <0.2322, 7.8714, -0.1121>, <0.2046, 7.3622, 0.1324>, <-0.02239, 7.9561, 0.1323> }
			triangle { <0.2322, 7.8714, -0.1121>, <-0.02239, 7.9561, 0.1323>, <-0.07789, 8.4328, -0.1278> }
			  }
		}
	union { // internode
		cylinder { <-0.07551, 6.7389, 0.509>, <-0.08826, 6.8923, 0.595>, 0.0705 }
		cylinder { <-0.08826, 6.8923, 0.595>, <-0.101, 7.04566, 0.6809>, 0.0705 }
		cylinder { <-0.101, 7.04566, 0.6809>, <-0.1137, 7.199, 0.7668>, 0.0705 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1137, 7.199, 0.7668>, <-0.111, 7.2181, 0.7735>, 0.0307 }
			cylinder { <-0.111, 7.2181, 0.7735>, <-0.1043, 7.2372, 0.7764>, 0.0307 }
			cylinder { <-0.1043, 7.2372, 0.7764>, <-0.09409, 7.2549, 0.7753>, 0.0307 }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1137, 7.199, 0.7668>, <-0.1193, 7.2141, 0.7794>, 0.0307 }
			cylinder { <-0.1193, 7.2141, 0.7794>, <-0.1285, 7.2256, 0.7936>, 0.0307 }
			cylinder { <-0.1285, 7.2256, 0.7936>, <-0.1408, 7.2324, 0.8085>, 0.0307 }
			  }
		}
	union { // internode
		cylinder { <-0.0, 5.3005, 0.0>, <-0.0, 7.03564, 0.0>, 0.694 }
		cylinder { <-0.0, 7.03564, 0.0>, <-0.0, 8.7707, 0.0>, 0.694 }
		cylinder { <-0.0, 8.7707, 0.0>, <-0.0, 10.5057, 0.0>, 0.694 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0, 10.5057, 0.0>, <-0.043, 10.7067, 0.03529>, 0.3128 }
			cylinder { <-0.043, 10.7067, 0.03529>, <-0.1258, 10.8856, 0.1033>, 0.3128 }
			cylinder { <-0.1258, 10.8856, 0.1033>, <-0.2426, 11.0295, 0.1991>, 0.3128 }
			  }
		mesh { // leaf
			triangle { <-0.2426, 11.0295, 0.1991>, <-0.4452, 12.8126, 1.8111>, <-1.4242, 12.4031, 1.1103> }
			triangle { <-1.4242, 12.4031, 1.1103>, <-0.4452, 12.8126, 1.8111>, <-1.4339, 14.2483, 2.9868> }
			triangle { <-1.4242, 12.4031, 1.1103>, <-1.4339, 14.2483, 2.9868>, <-2.6773, 13.7561, 2.2103> }
			triangle { <-1.4339, 14.2483, 2.9868>, <-3.7596, 14.8446, 3.5477>, <-2.6773, 13.7561, 2.2103> }
			triangle { <-1.4242, 12.4031, 1.1103>, <-2.4479, 11.7679, 0.9386>, <-0.2426, 11.0295, 0.1991> }
			triangle { <-2.4479, 11.7679, 0.9386>, <-1.4242, 12.4031, 1.1103>, <-2.6773, 13.7561, 2.2103> }
			triangle { <-3.7683, 12.968, 2.06373>, <-2.4479, 11.7679, 0.9386>, <-2.6773, 13.7561, 2.2103> }
			triangle { <-3.7683, 12.968, 2.06373>, <-2.6773, 13.7561, 2.2103>, <-3.7596, 14.8446, 3.5477> }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0, 10.5057, 0.0>, <0.043, 10.7067, -0.03529>, 0.3128 }
			cylinder { <0.043, 10.7067, -0.03529>, <0.1258, 10.8856, -0.1033>, 0.3128 }
			cylinder { <0.1258, 10.8856, -0.1033>, <0.2426, 11.0295, -0.1991>, 0.3128 }
			  }
		mesh { // leaf
			triangle { <0.2426, 11.0295, -0.1991>, <0.4452, 12.8126, -1.8111>, <1.4242, 12.4031, -1.1103> }
			triangle { <1.4242, 12.4031, -1.1103>, <0.4452, 12.8126, -1.8111>, <1.4339, 14.2483, -2.9868> }
			triangle { <1.4242, 12.4031, -1.1103>, <1.4339, 14.2483, -2.9868>, <2.6773, 13.7561, -2.2103> }
			triangle { <1.4339, 14.2483, -2.9868>, <3.7596, 14.8446, -3.5477>, <2.6773, 13.7561, -2.2103> }
			triangle { <1.4242, 12.4031, -1.1103>, <2.4479, 11.7679, -0.9386>, <0.2426, 11.0295, -0.1991> }
			triangle { <2.4479, 11.7679, -0.9386>, <1.4242, 12.4031, -1.1103>, <2.6773, 13.7561, -2.2103> }
			triangle { <3.7683, 12.968, -2.06373>, <2.4479, 11.7679, -0.9386>, <2.6773, 13.7561, -2.2103> }
			triangle { <3.7683, 12.968, -2.06373>, <2.6773, 13.7561, -2.2103>, <3.7596, 14.8446, -3.5477> }
			  }
		}
	union { // internode
		cylinder { <-0.0, 10.5057, 0.0>, <-0.1546, 11.6587, 0.1269>, 0.468 }
		cylinder { <-0.1546, 11.6587, 0.1269>, <-0.4593, 12.7605, 0.377>, 0.468 }
		cylinder { <-0.4593, 12.7605, 0.377>, <-0.9052, 13.7787, 0.7429>, 0.468 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.9052, 13.7787, 0.7429>, <-0.9667, 13.8583, 0.7934>, 0.1688 }
			cylinder { <-0.9667, 13.8583, 0.7934>, <-1.04249, 13.9137, 0.8555>, 0.1688 }
			cylinder { <-1.04249, 13.9137, 0.8555>, <-1.1268, 13.9411, 0.9248>, 0.1688 }
			  }
		mesh { // leaf
			triangle { <-1.1268, 13.9411, 0.9248>, <-1.5389, 14.4647, 2.04327>, <-1.9661, 14.1894, 1.582> }
			triangle { <-1.9661, 14.1894, 1.582>, <-1.5389, 14.4647, 2.04327>, <-2.2859, 14.7372, 2.8528> }
			triangle { <-1.9661, 14.1894, 1.582>, <-2.2859, 14.7372, 2.8528>, <-2.8303, 14.3814, 2.3299> }
			triangle { <-2.2859, 14.7372, 2.8528>, <-3.547, 14.4443, 3.1604>, <-2.8303, 14.3814, 2.3299> }
			triangle { <-1.9661, 14.1894, 1.582>, <-2.3511, 13.7096, 1.3518>, <-1.1268, 13.9411, 0.9248> }
			triangle { <-2.3511, 13.7096, 1.3518>, <-1.9661, 14.1894, 1.582>, <-2.8303, 14.3814, 2.3299> }
			triangle { <-3.2164, 13.8117, 2.08441>, <-2.3511, 13.7096, 1.3518>, <-2.8303, 14.3814, 2.3299> }
			triangle { <-3.2164, 13.8117, 2.08441>, <-2.8303, 14.3814, 2.3299>, <-3.547, 14.4443, 3.1604> }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.9052, 13.7787, 0.7429>, <-0.9263, 13.8879, 0.7602>, 0.1688 }
			cylinder { <-0.9263, 13.8879, 0.7602>, <-0.9242, 14.00043, 0.7585>, 0.1688 }
			cylinder { <-0.9242, 14.00043, 0.7585>, <-0.899, 14.1081, 0.7377>, 0.1688 }
			  }
		mesh { // leaf
			triangle { <-0.899, 14.1081, 0.7377>, <-1.2202, 15.2591, 0.2211>, <-0.6246, 15.1498, 0.5441> }
			triangle { <-0.6246, 15.1498, 0.5441>, <-1.2202, 15.2591, 0.2211>, <-1.06372, 16.335, -0.1038> }
			triangle { <-0.6246, 15.1498, 0.5441>, <-1.06372, 16.335, -0.1038>, <-0.3168, 16.2285, 0.2529> }
			triangle { <-1.06372, 16.335, -0.1038>, <-0.0479, 17.1879, -0.2101>, <-0.3168, 16.2285, 0.2529> }
			triangle { <-0.6246, 15.1498, 0.5441>, <0.02151, 15.03318, 0.5599>, <-0.899, 14.1081, 0.7377> }
			triangle { <0.02151, 15.03318, 0.5599>, <-0.6246, 15.1498, 0.5441>, <-0.3168, 16.2285, 0.2529> }
			triangle { <0.3933, 16.05806, 0.2324>, <0.02151, 15.03318, 0.5599>, <-0.3168, 16.2285, 0.2529> }
			triangle { <0.3933, 16.05806, 0.2324>, <-0.3168, 16.2285, 0.2529>, <-0.0479, 17.1879, -0.2101> }
			  }
		}
	union { // internode
		cylinder { <-0.9052, 13.7787, 0.7429>, <-1.06472, 14.1428, 0.8737>, 0.1674 }
		cylinder { <-1.06472, 14.1428, 0.8737>, <-1.2241, 14.507, 1.004669>, 0.1674 }
		cylinder { <-1.2241, 14.507, 1.004669>, <-1.3836, 14.8712, 1.1355>, 0.1674 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.3836, 14.8712, 1.1355>, <-1.3891, 14.9136, 1.1505>, 0.06796 }
			cylinder { <-1.3891, 14.9136, 1.1505>, <-1.3824, 14.9559, 1.1652>, 0.06796 }
			cylinder { <-1.3824, 14.9559, 1.1652>, <-1.3639, 14.9951, 1.1786>, 0.06796 }
			  }
		mesh { // leaf
			triangle { <-1.3639, 14.9951, 1.1786>, <-1.2792, 15.506, 1.09891>, <-1.178, 15.3697, 1.3168> }
			triangle { <-1.178, 15.3697, 1.3168>, <-1.2792, 15.506, 1.09891>, <-1.09594, 15.9174, 1.1748> }
			triangle { <-1.178, 15.3697, 1.3168>, <-1.09594, 15.9174, 1.1748>, <-0.9555, 15.7617, 1.4373> }
			triangle { <-1.09594, 15.9174, 1.1748>, <-0.7086, 16.1261, 1.4804>, <-0.9555, 15.7617, 1.4373> }
			triangle { <-1.178, 15.3697, 1.3168>, <-0.9852, 15.2476, 1.4503>, <-1.3639, 14.9951, 1.1786> }
			triangle { <-0.9852, 15.2476, 1.4503>, <-1.178, 15.3697, 1.3168>, <-0.9555, 15.7617, 1.4373> }
			triangle { <-0.7364, 15.6143, 1.5668>, <-0.9852, 15.2476, 1.4503>, <-0.9555, 15.7617, 1.4373> }
			triangle { <-0.7364, 15.6143, 1.5668>, <-0.9555, 15.7617, 1.4373>, <-0.7086, 16.1261, 1.4804> }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.3836, 14.8712, 1.1355>, <-1.4114, 14.9047, 1.1478>, 0.06796 }
			cylinder { <-1.4114, 14.9047, 1.1478>, <-1.4478, 14.93, 1.1574>, 0.06796 }
			cylinder { <-1.4478, 14.93, 1.1574>, <-1.49, 14.9452, 1.1636>, 0.06796 }
			  }
		mesh { // leaf
			triangle { <-1.49, 14.9452, 1.1636>, <-1.8699, 15.1084, 1.4855>, <-1.9033, 15.08984, 1.2119> }
			triangle { <-1.9033, 15.08984, 1.2119>, <-1.8699, 15.1084, 1.4855>, <-2.2909, 15.2397, 1.6046> }
			triangle { <-1.9033, 15.08984, 1.2119>, <-2.2909, 15.2397, 1.6046>, <-2.3498, 15.2093, 1.2753> }
			triangle { <-2.2909, 15.2397, 1.6046>, <-2.7768, 15.2564, 1.3801>, <-2.3498, 15.2093, 1.2753> }
			triangle { <-1.9033, 15.08984, 1.2119>, <-1.9909, 14.9718, 0.9921>, <-1.49, 14.9452, 1.1636> }
			triangle { <-1.9909, 14.9718, 0.9921>, <-1.9033, 15.08984, 1.2119>, <-2.3498, 15.2093, 1.2753> }
			triangle { <-2.4384, 15.0588, 1.03877>, <-1.9909, 14.9718, 0.9921>, <-2.3498, 15.2093, 1.2753> }
			triangle { <-2.4384, 15.0588, 1.03877>, <-2.3498, 15.2093, 1.2753>, <-2.7768, 15.2564, 1.3801> }
			  }
		}
	union { // internode
		cylinder { <-1.3836, 14.8712, 1.1355>, <-1.4452, 15.01175, 1.186>, 0.06461 }
		cylinder { <-1.4452, 15.01175, 1.186>, <-1.5067, 15.1523, 1.2365>, 0.06461 }
		cylinder { <-1.5067, 15.1523, 1.2365>, <-1.5683, 15.2928, 1.287>, 0.06461 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.5683, 15.2928, 1.287>, <-1.5789, 15.3087, 1.2892>, 0.02889 }
			cylinder { <-1.5789, 15.3087, 1.2892>, <-1.5921, 15.3226, 1.2872>, 0.02889 }
			cylinder { <-1.5921, 15.3226, 1.2872>, <-1.6069, 15.3335, 1.2814>, 0.02889 }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.5683, 15.2928, 1.287>, <-1.5717, 15.3092, 1.2965>, 0.02889 }
			cylinder { <-1.5717, 15.3092, 1.2965>, <-1.5711, 15.3241, 1.3088>, 0.02889 }
			cylinder { <-1.5711, 15.3241, 1.3088>, <-1.5665, 15.3363, 1.3229>, 0.02889 }
			  }
		}
	union { // internode
		cylinder { <-0.0, 10.5057, 0.0>, <0.2212, 12.1551, -0.1815>, 0.6696 }
		cylinder { <0.2212, 12.1551, -0.1815>, <0.6571, 13.7313, -0.5393>, 0.6696 }
		cylinder { <0.6571, 13.7313, -0.5393>, <1.295, 15.1879, -1.06281>, 0.6696 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.295, 15.1879, -1.06281>, <1.3784, 15.2958, -1.1312>, 0.2289 }
			cylinder { <1.3784, 15.2958, -1.1312>, <1.4811, 15.3711, -1.2155>, 0.2289 }
			cylinder { <1.4811, 15.3711, -1.2155>, <1.5955, 15.4082, -1.3094>, 0.2289 }
			  }
		mesh { // leaf
			triangle { <1.5955, 15.4082, -1.3094>, <2.1542, 16.1181, -2.8258>, <2.7335, 15.7448, -2.2005> }
			triangle { <2.7335, 15.7448, -2.2005>, <2.1542, 16.1181, -2.8258>, <3.167, 16.4875, -3.9235> }
			triangle { <2.7335, 15.7448, -2.2005>, <3.167, 16.4875, -3.9235>, <3.9052, 16.00518, -3.2145> }
			triangle { <3.167, 16.4875, -3.9235>, <4.8768, 16.09048, -4.3405>, <3.9052, 16.00518, -3.2145> }
			triangle { <2.7335, 15.7448, -2.2005>, <3.2553, 15.09429, -1.8884>, <1.5955, 15.4082, -1.3094> }
			triangle { <3.2553, 15.09429, -1.8884>, <2.7335, 15.7448, -2.2005>, <3.9052, 16.00518, -3.2145> }
			triangle { <4.4286, 15.2327, -2.8816>, <3.2553, 15.09429, -1.8884>, <3.9052, 16.00518, -3.2145> }
			triangle { <4.4286, 15.2327, -2.8816>, <3.9052, 16.00518, -3.2145>, <4.8768, 16.09048, -4.3405> }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.295, 15.1879, -1.06281>, <1.3237, 15.336, -1.08633>, 0.2289 }
			cylinder { <1.3237, 15.336, -1.08633>, <1.3208, 15.4885, -1.08396>, 0.2289 }
			cylinder { <1.3208, 15.4885, -1.08396>, <1.2865, 15.6346, -1.05585>, 0.2289 }
			  }
		mesh { // leaf
			triangle { <1.2865, 15.6346, -1.05585>, <1.7221, 17.1952, -0.3554>, <0.9145, 17.04708, -0.7933> }
			triangle { <0.9145, 17.04708, -0.7933>, <1.7221, 17.1952, -0.3554>, <1.5099, 18.6539, 0.0853> }
			triangle { <0.9145, 17.04708, -0.7933>, <1.5099, 18.6539, 0.0853>, <0.4972, 18.5095, -0.3984> }
			triangle { <1.5099, 18.6539, 0.0853>, <0.1326, 19.8103, 0.2294>, <0.4972, 18.5095, -0.3984> }
			triangle { <0.9145, 17.04708, -0.7933>, <0.03847, 16.8888, -0.8147>, <1.2865, 15.6346, -1.05585> }
			triangle { <0.03847, 16.8888, -0.8147>, <0.9145, 17.04708, -0.7933>, <0.4972, 18.5095, -0.3984> }
			triangle { <-0.4656, 18.2784, -0.3707>, <0.03847, 16.8888, -0.8147>, <0.4972, 18.5095, -0.3984> }
			triangle { <-0.4656, 18.2784, -0.3707>, <0.4972, 18.5095, -0.3984>, <0.1326, 19.8103, 0.2294> }
			  }
		}
	union { // internode
		cylinder { <1.295, 15.1879, -1.06281>, <1.543, 15.7543, -1.2663>, 0.2603 }
		cylinder { <1.543, 15.7543, -1.2663>, <1.791, 16.3206, -1.4698>, 0.2603 }
		cylinder { <1.791, 16.3206, -1.4698>, <2.03905, 16.887, -1.6734>, 0.2603 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.03905, 16.887, -1.6734>, <2.04724, 16.9505, -1.6958>, 0.1017 }
			cylinder { <2.04724, 16.9505, -1.6958>, <2.03717, 17.01387, -1.7178>, 0.1017 }
			cylinder { <2.03717, 17.01387, -1.7178>, <2.009583, 17.07251, -1.7379>, 0.1017 }
			  }
		mesh { // leaf
			triangle { <2.009583, 17.07251, -1.7379>, <1.8826, 17.8375, -1.6185>, <1.7311, 17.6335, -1.9449> }
			triangle { <1.7311, 17.6335, -1.9449>, <1.8826, 17.8375, -1.6185>, <1.6082, 18.4534, -1.7322> }
			triangle { <1.7311, 17.6335, -1.9449>, <1.6082, 18.4534, -1.7322>, <1.398, 18.2203, -2.1252> }
			triangle { <1.6082, 18.4534, -1.7322>, <1.02845, 18.7658, -2.1897>, <1.398, 18.2203, -2.1252> }
			triangle { <1.7311, 17.6335, -1.9449>, <1.4425, 17.4506, -2.1447>, <2.009583, 17.07251, -1.7379> }
			triangle { <1.4425, 17.4506, -2.1447>, <1.7311, 17.6335, -1.9449>, <1.398, 18.2203, -2.1252> }
			triangle { <1.07002, 17.9997, -2.3191>, <1.4425, 17.4506, -2.1447>, <1.398, 18.2203, -2.1252> }
			triangle { <1.07002, 17.9997, -2.3191>, <1.398, 18.2203, -2.1252>, <1.02845, 18.7658, -2.1897> }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.03905, 16.887, -1.6734>, <2.08069, 16.9372, -1.6918>, 0.1017 }
			cylinder { <2.08069, 16.9372, -1.6918>, <2.1351, 16.9751, -1.7062>, 0.1017 }
			cylinder { <2.1351, 16.9751, -1.7062>, <2.1983, 16.9979, -1.7154>, 0.1017 }
			  }
		mesh { // leaf
			triangle { <2.1983, 16.9979, -1.7154>, <2.7671, 17.2421, -2.1974>, <2.8172, 17.2143, -1.7878> }
			triangle { <2.8172, 17.2143, -1.7878>, <2.7671, 17.2421, -2.1974>, <3.3974, 17.4387, -2.3757> }
			triangle { <2.8172, 17.2143, -1.7878>, <3.3974, 17.4387, -2.3757>, <3.4855, 17.3933, -1.8827> }
			triangle { <3.3974, 17.4387, -2.3757>, <4.125, 17.4638, -2.0396>, <3.4855, 17.3933, -1.8827> }
			triangle { <2.8172, 17.2143, -1.7878>, <2.9483, 17.03776, -1.4587>, <2.1983, 16.9979, -1.7154> }
			triangle { <2.9483, 17.03776, -1.4587>, <2.8172, 17.2143, -1.7878>, <3.4855, 17.3933, -1.8827> }
			triangle { <3.6183, 17.1679, -1.5285>, <2.9483, 17.03776, -1.4587>, <3.4855, 17.3933, -1.8827> }
			triangle { <3.6183, 17.1679, -1.5285>, <3.4855, 17.3933, -1.8827>, <4.125, 17.4638, -2.0396> }
			  }
		}
	union { // internode
		cylinder { <2.03905, 16.887, -1.6734>, <2.1427, 17.1238, -1.7585>, 0.1088 }
		cylinder { <2.1427, 17.1238, -1.7585>, <2.2464, 17.3606, -1.8436>, 0.1088 }
		cylinder { <2.2464, 17.3606, -1.8436>, <2.3501, 17.5974, -1.9287>, 0.1088 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.3501, 17.5974, -1.9287>, <2.3652, 17.6199, -1.9317>, 0.04085 }
			cylinder { <2.3652, 17.6199, -1.9317>, <2.3838, 17.6395, -1.929>, 0.04085 }
			cylinder { <2.3838, 17.6395, -1.929>, <2.4047, 17.6549, -1.9207>, 0.04085 }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.3501, 17.5974, -1.9287>, <2.355, 17.6206, -1.9421>, 0.04085 }
			cylinder { <2.355, 17.6206, -1.9421>, <2.3542, 17.6416, -1.9594>, 0.04085 }
			cylinder { <2.3542, 17.6416, -1.9594>, <2.3476, 17.6589, -1.9794>, 0.04085 }
			  }
		}
	union { // internode
		cylinder { <-0.0, 10.5057, 0.0>, <-0.0, 12.5024, 0.0>, 0.7986 }
		cylinder { <-0.0, 12.5024, 0.0>, <-0.0, 14.499, 0.0>, 0.7986 }
		cylinder { <-0.0, 14.499, 0.0>, <-0.0, 16.4956, 0.0>, 0.7986 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0, 16.4956, 0.0>, <0.08624, 16.8076, 0.004237>, 0.4856 }
			cylinder { <0.08624, 16.8076, 0.004237>, <0.2524, 17.08538, 0.0124>, 0.4856 }
			cylinder { <0.2524, 17.08538, 0.0124>, <0.4866, 17.3086, 0.0239>, 0.4856 }
			  }
		mesh { // leaf
			triangle { <0.4866, 17.3086, 0.0239>, <2.4, 20.07656, -1.6189>, <2.7955, 19.4408, 0.2076> }
			triangle { <2.7955, 19.4408, 0.2076>, <2.4, 20.07656, -1.6189>, <4.7627, 22.305, -1.9405> }
			triangle { <2.7955, 19.4408, 0.2076>, <4.7627, 22.305, -1.9405>, <5.3835, 21.541, 0.2486> }
			triangle { <4.7627, 22.305, -1.9405>, <8.02246, 23.2307, -0.1612>, <5.3835, 21.541, 0.2486> }
			triangle { <2.7955, 19.4408, 0.2076>, <3.794, 18.4548, 1.4722>, <0.4866, 17.3086, 0.0239> }
			triangle { <3.794, 18.4548, 1.4722>, <2.7955, 19.4408, 0.2076>, <5.3835, 21.541, 0.2486> }
			triangle { <6.4855, 20.3176, 1.5546>, <3.794, 18.4548, 1.4722>, <5.3835, 21.541, 0.2486> }
			triangle { <6.4855, 20.3176, 1.5546>, <5.3835, 21.541, 0.2486>, <8.02246, 23.2307, -0.1612> }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0, 16.4956, 0.0>, <-0.08624, 16.8076, -0.004237>, 0.4856 }
			cylinder { <-0.08624, 16.8076, -0.004237>, <-0.2524, 17.08538, -0.0124>, 0.4856 }
			cylinder { <-0.2524, 17.08538, -0.0124>, <-0.4866, 17.3086, -0.0239>, 0.4856 }
			  }
		mesh { // leaf
			triangle { <-0.4866, 17.3086, -0.0239>, <-2.4, 20.07656, 1.6189>, <-2.7955, 19.4408, -0.2076> }
			triangle { <-2.7955, 19.4408, -0.2076>, <-2.4, 20.07656, 1.6189>, <-4.7627, 22.305, 1.9405> }
			triangle { <-2.7955, 19.4408, -0.2076>, <-4.7627, 22.305, 1.9405>, <-5.3835, 21.541, -0.2486> }
			triangle { <-4.7627, 22.305, 1.9405>, <-8.02246, 23.2307, 0.1612>, <-5.3835, 21.541, -0.2486> }
			triangle { <-2.7955, 19.4408, -0.2076>, <-3.794, 18.4548, -1.4722>, <-0.4866, 17.3086, -0.0239> }
			triangle { <-3.794, 18.4548, -1.4722>, <-2.7955, 19.4408, -0.2076>, <-5.3835, 21.541, -0.2486> }
			triangle { <-6.4855, 20.3176, -1.5546>, <-3.794, 18.4548, -1.4722>, <-5.3835, 21.541, -0.2486> }
			triangle { <-6.4855, 20.3176, -1.5546>, <-5.3835, 21.541, -0.2486>, <-8.02246, 23.2307, 0.1612> }
			  }
		}
	union { // internode
		cylinder { <-0.0, 16.4956, 0.0>, <0.1657, 17.4521, 0.008143>, 0.3882 }
		cylinder { <0.1657, 17.4521, 0.008143>, <0.4923, 18.366, 0.02418>, 0.3882 }
		cylinder { <0.4923, 18.366, 0.02418>, <0.9702, 19.2106, 0.04766>, 0.3882 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.9702, 19.2106, 0.04766>, <1.03954, 19.28, 0.05106>, 0.147 }
			cylinder { <1.03954, 19.28, 0.05106>, <1.1247, 19.3283, 0.05525>, 0.147 }
			cylinder { <1.1247, 19.3283, 0.05525>, <1.2197, 19.3522, 0.05992>, 0.147 }
			  }
		mesh { // leaf
			triangle { <1.2197, 19.3522, 0.05992>, <2.1401, 19.8083, -0.4209>, <2.146, 19.5685, 0.1267> }
			triangle { <2.146, 19.5685, 0.1267>, <2.1401, 19.8083, -0.4209>, <3.09596, 20.04574, -0.5065> }
			triangle { <2.146, 19.5685, 0.1267>, <3.09596, 20.04574, -0.5065>, <3.1414, 19.7357, 0.1495> }
			triangle { <3.09596, 20.04574, -0.5065>, <4.08994, 19.7905, 0.03272>, <3.1414, 19.7357, 0.1495> }
			triangle { <2.146, 19.5685, 0.1267>, <2.2598, 19.1504, 0.5004>, <1.2197, 19.3522, 0.05992> }
			triangle { <2.2598, 19.1504, 0.5004>, <2.146, 19.5685, 0.1267>, <3.1414, 19.7357, 0.1495> }
			triangle { <3.247, 19.2394, 0.5339>, <2.2598, 19.1504, 0.5004>, <3.1414, 19.7357, 0.1495> }
			triangle { <3.247, 19.2394, 0.5339>, <3.1414, 19.7357, 0.1495>, <4.08994, 19.7905, 0.03272> }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.9702, 19.2106, 0.04766>, <0.994, 19.3058, 0.04883>, 0.147 }
			cylinder { <0.994, 19.3058, 0.04883>, <0.9916, 19.4038, 0.04871>, 0.147 }
			cylinder { <0.9916, 19.4038, 0.04871>, <0.9632, 19.4976, 0.04732>, 0.147 }
			  }
		mesh { // leaf
			triangle { <0.9632, 19.4976, 0.04732>, <0.8683, 20.5004, 0.5687>, <0.6728, 20.4052, 0.01176> }
			triangle { <0.6728, 20.4052, 0.01176>, <0.8683, 20.5004, 0.5687>, <0.5771, 21.4377, 0.6869> }
			triangle { <0.6728, 20.4052, 0.01176>, <0.5771, 21.4377, 0.6869>, <0.3038, 21.3449, 0.01971> }
			triangle { <0.5771, 21.4377, 0.6869>, <-0.1407, 22.1807, 0.1612>, <0.3038, 21.3449, 0.01971> }
			triangle { <0.6728, 20.4052, 0.01176>, <0.265, 20.3035, -0.3764>, <0.9632, 19.4976, 0.04732> }
			triangle { <0.265, 20.3035, -0.3764>, <0.6728, 20.4052, 0.01176>, <0.3038, 21.3449, 0.01971> }
			triangle { <-0.1666, 21.1964, -0.3825>, <0.265, 20.3035, -0.3764>, <0.3038, 21.3449, 0.01971> }
			triangle { <-0.1666, 21.1964, -0.3825>, <0.3038, 21.3449, 0.01971>, <-0.1407, 22.1807, 0.1612> }
			  }
		}
	union { // internode
		cylinder { <0.9702, 19.2106, 0.04766>, <1.1484, 19.5255, 0.05641>, 0.1447 }
		cylinder { <1.1484, 19.5255, 0.05641>, <1.3265, 19.8404, 0.06517>, 0.1447 }
		cylinder { <1.3265, 19.8404, 0.06517>, <1.5047, 20.1552, 0.07392>, 0.1447 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.5047, 20.1552, 0.07392>, <1.5172, 20.1927, 0.06735>, 0.06008 }
			cylinder { <1.5172, 20.1927, 0.06735>, <1.5215, 20.2302, 0.05371>, 0.06008 }
			cylinder { <1.5215, 20.2302, 0.05371>, <1.5174, 20.2648, 0.034>, 0.06008 }
			  }
		mesh { // leaf
			triangle { <1.5174, 20.2648, 0.034>, <1.4145, 20.7165, 0.0359>, <1.4776, 20.5961, -0.1669> }
			triangle { <1.4776, 20.5961, -0.1669>, <1.4145, 20.7165, 0.0359>, <1.3396, 21.08031, -0.1226> }
			triangle { <1.4776, 20.5961, -0.1669>, <1.3396, 21.08031, -0.1226>, <1.4034, 20.9426, -0.3779> }
			triangle { <1.3396, 21.08031, -0.1226>, <1.2673, 21.2648, -0.5527>, <1.4034, 20.9426, -0.3779> }
			triangle { <1.4776, 20.5961, -0.1669>, <1.4306, 20.4881, -0.3688>, <1.5174, 20.2648, 0.034> }
			triangle { <1.4306, 20.4881, -0.3688>, <1.4776, 20.5961, -0.1669>, <1.4034, 20.9426, -0.3779> }
			triangle { <1.3368, 20.8123, -0.5928>, <1.4306, 20.4881, -0.3688>, <1.4034, 20.9426, -0.3779> }
			triangle { <1.3368, 20.8123, -0.5928>, <1.4034, 20.9426, -0.3779>, <1.2673, 21.2648, -0.5527> }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.5047, 20.1552, 0.07392>, <1.5302, 20.1849, 0.08236>, 0.06008 }
			cylinder { <1.5302, 20.1849, 0.08236>, <1.5597, 20.2073, 0.09765>, 0.06008 }
			cylinder { <1.5597, 20.2073, 0.09765>, <1.5911, 20.2207, 0.1187>, 0.06008 }
			  }
		mesh { // leaf
			triangle { <1.5911, 20.2207, 0.1187>, <2.03115, 20.365, 0.1333>, <1.8905, 20.3486, 0.3324> }
			triangle { <1.8905, 20.3486, 0.3324>, <2.03115, 20.365, 0.1333>, <2.3776, 20.481, 0.3052> }
			triangle { <1.8905, 20.3486, 0.3324>, <2.3776, 20.481, 0.3052>, <2.2206, 20.4542, 0.5559> }
			triangle { <2.3776, 20.481, 0.3052>, <2.5626, 20.4959, 0.7409>, <2.2206, 20.4542, 0.5559> }
			triangle { <1.8905, 20.3486, 0.3324>, <1.8174, 20.2443, 0.5284>, <1.5911, 20.2207, 0.1187> }
			triangle { <1.8174, 20.2443, 0.5284>, <1.8905, 20.3486, 0.3324>, <2.2206, 20.4542, 0.5559> }
			triangle { <2.1382, 20.3211, 0.7636>, <1.8174, 20.2443, 0.5284>, <2.2206, 20.4542, 0.5559> }
			triangle { <2.1382, 20.3211, 0.7636>, <2.2206, 20.4542, 0.5559>, <2.5626, 20.4959, 0.7409> }
			  }
		}
	union { // internode
		cylinder { <1.5047, 20.1552, 0.07392>, <1.5668, 20.2649, 0.07697>, 0.05042 }
		cylinder { <1.5668, 20.2649, 0.07697>, <1.6288, 20.3746, 0.08002>, 0.05042 }
		cylinder { <1.6288, 20.3746, 0.08002>, <1.6909, 20.4843, 0.08306>, 0.05042 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.6909, 20.4843, 0.08306>, <1.6981, 20.4965, 0.08736>, 0.02226 }
			cylinder { <1.6981, 20.4965, 0.08736>, <1.7046, 20.5072, 0.09529>, 0.02226 }
			cylinder { <1.7046, 20.5072, 0.09529>, <1.71, 20.5156, 0.1062>, 0.02226 }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.6909, 20.4843, 0.08306>, <1.6978, 20.4969, 0.07946>, 0.02226 }
			cylinder { <1.6978, 20.4969, 0.07946>, <1.7038, 20.5084, 0.07215>, 0.02226 }
			cylinder { <1.7038, 20.5084, 0.07215>, <1.7084, 20.5178, 0.06166>, 0.02226 }
			  }
		}
	union { // internode
		cylinder { <-0.0, 16.4956, 0.0>, <-0.03913, 16.7215, -0.001922>, 0.09168 }
		cylinder { <-0.03913, 16.7215, -0.001922>, <-0.1162, 16.9373, -0.005711>, 0.09168 }
		cylinder { <-0.1162, 16.9373, -0.005711>, <-0.2291, 17.1367, -0.01125>, 0.09168 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.2291, 17.1367, -0.01125>, <-0.2455, 17.1532, -0.01206>, 0.03493 }
			cylinder { <-0.2455, 17.1532, -0.01206>, <-0.2657, 17.1646, -0.01305>, 0.03493 }
			cylinder { <-0.2657, 17.1646, -0.01305>, <-0.2883, 17.1703, -0.01416>, 0.03493 }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.2291, 17.1367, -0.01125>, <-0.2347, 17.1593, -0.01153>, 0.03493 }
			cylinder { <-0.2347, 17.1593, -0.01153>, <-0.2341, 17.1826, -0.0115>, 0.03493 }
			cylinder { <-0.2341, 17.1826, -0.0115>, <-0.2274, 17.2049, -0.01117>, 0.03493 }
			  }
		}
	union { // internode
		cylinder { <-0.0, 16.4956, 0.0>, <-0.0, 18.4885, 0.0>, 0.7971 }
		cylinder { <-0.0, 18.4885, 0.0>, <-0.0, 20.4814, 0.0>, 0.7971 }
		cylinder { <-0.0, 20.4814, 0.0>, <-0.0, 22.4743, 0.0>, 0.7971 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0, 22.4743, 0.0>, <-0.05617, 22.7614, -0.05617>, 0.4467 }
			cylinder { <-0.05617, 22.7614, -0.05617>, <-0.1644, 23.01695, -0.1644>, 0.4467 }
			cylinder { <-0.1644, 23.01695, -0.1644>, <-0.3169, 23.2223, -0.3169>, 0.4467 }
			  }
		mesh { // leaf
			triangle { <-0.3169, 23.2223, -0.3169>, <-2.6364, 25.7688, -0.3792>, <-1.7773, 25.184, -1.8687> }
			triangle { <-1.7773, 25.184, -1.8687>, <-2.6364, 25.7688, -0.3792>, <-4.4456, 27.8191, -1.6198> }
			triangle { <-1.7773, 25.184, -1.8687>, <-4.4456, 27.8191, -1.6198>, <-3.5162, 27.1162, -3.4957> }
			triangle { <-4.4456, 27.8191, -1.6198>, <-5.5684, 28.6708, -4.8467>, <-3.5162, 27.1162, -3.4957> }
			triangle { <-1.7773, 25.184, -1.8687>, <-1.6767, 24.2769, -3.3477>, <-0.3169, 23.2223, -0.3169> }
			triangle { <-1.6767, 24.2769, -3.3477>, <-1.7773, 25.184, -1.8687>, <-3.5162, 27.1162, -3.4957> }
			triangle { <-3.4605, 25.9907, -5.06685>, <-1.6767, 24.2769, -3.3477>, <-3.5162, 27.1162, -3.4957> }
			triangle { <-3.4605, 25.9907, -5.06685>, <-3.5162, 27.1162, -3.4957>, <-5.5684, 28.6708, -4.8467> }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0, 22.4743, 0.0>, <0.05617, 22.7614, 0.05617>, 0.4467 }
			cylinder { <0.05617, 22.7614, 0.05617>, <0.1644, 23.01695, 0.1644>, 0.4467 }
			cylinder { <0.1644, 23.01695, 0.1644>, <0.3169, 23.2223, 0.3169>, 0.4467 }
			  }
		mesh { // leaf
			triangle { <0.3169, 23.2223, 0.3169>, <2.6364, 25.7688, 0.3792>, <1.7773, 25.184, 1.8687> }
			triangle { <1.7773, 25.184, 1.8687>, <2.6364, 25.7688, 0.3792>, <4.4456, 27.8191, 1.6198> }
			triangle { <1.7773, 25.184, 1.8687>, <4.4456, 27.8191, 1.6198>, <3.5162, 27.1162, 3.4957> }
			triangle { <4.4456, 27.8191, 1.6198>, <5.5684, 28.6708, 4.8467>, <3.5162, 27.1162, 3.4957> }
			triangle { <1.7773, 25.184, 1.8687>, <1.6767, 24.2769, 3.3477>, <0.3169, 23.2223, 0.3169> }
			triangle { <1.6767, 24.2769, 3.3477>, <1.7773, 25.184, 1.8687>, <3.5162, 27.1162, 3.4957> }
			triangle { <3.4605, 25.9907, 5.06685>, <1.6767, 24.2769, 3.3477>, <3.5162, 27.1162, 3.4957> }
			triangle { <3.4605, 25.9907, 5.06685>, <3.5162, 27.1162, 3.4957>, <5.5684, 28.6708, 4.8467> }
			  }
		}
	union { // internode
		cylinder { <-0.0, 22.4743, 0.0>, <-0.02438, 22.6731, -0.02438>, 0.08067 }
		cylinder { <-0.02438, 22.6731, -0.02438>, <-0.07242, 22.863, -0.07242>, 0.08067 }
		cylinder { <-0.07242, 22.863, -0.07242>, <-0.1427, 23.0385, -0.1427>, 0.08067 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1427, 23.0385, -0.1427>, <-0.1535, 23.05388, -0.1535>, 0.03262 }
			cylinder { <-0.1535, 23.05388, -0.1535>, <-0.1669, 23.0646, -0.1669>, 0.03262 }
			cylinder { <-0.1669, 23.0646, -0.1669>, <-0.1818, 23.06989, -0.1818>, 0.03262 }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1427, 23.0385, -0.1427>, <-0.1464, 23.0596, -0.1464>, 0.03262 }
			cylinder { <-0.1464, 23.0596, -0.1464>, <-0.146, 23.08134, -0.146>, 0.03262 }
			cylinder { <-0.146, 23.08134, -0.146>, <-0.1416, 23.1021, -0.1416>, 0.03262 }
			  }
		}
	union { // internode
		cylinder { <-0.0, 22.4743, 0.0>, <0.01952, 22.6335, 0.01952>, 0.06461 }
		cylinder { <0.01952, 22.6335, 0.01952>, <0.058, 22.7856, 0.058>, 0.06461 }
		cylinder { <0.058, 22.7856, 0.058>, <0.1143, 22.9262, 0.1143>, 0.06461 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.1143, 22.9262, 0.1143>, <0.1239, 22.9398, 0.1239>, 0.02889 }
			cylinder { <0.1239, 22.9398, 0.1239>, <0.1357, 22.9493, 0.1357>, 0.02889 }
			cylinder { <0.1357, 22.9493, 0.1357>, <0.149, 22.9539, 0.149>, 0.02889 }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.1143, 22.9262, 0.1143>, <0.1176, 22.9448, 0.1176>, 0.02889 }
			cylinder { <0.1176, 22.9448, 0.1176>, <0.1172, 22.9641, 0.1172>, 0.02889 }
			cylinder { <0.1172, 22.9641, 0.1172>, <0.1133, 22.9825, 0.1133>, 0.02889 }
			  }
		}
	union { // internode
		cylinder { <-0.0, 22.4743, 0.0>, <-0.0, 24.03916, 0.0>, 0.6259 }
		cylinder { <-0.0, 24.03916, 0.0>, <-0.00000001, 25.6039, 0.0>, 0.6259 }
		cylinder { <-0.00000001, 25.6039, 0.0>, <-0.00000001, 27.1687, 0.0>, 0.6259 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.00000001, 27.1687, 0.0>, <0.001805, 27.3016, 0.03675>, 0.2069 }
			cylinder { <0.001805, 27.3016, 0.03675>, <0.005285, 27.4199, 0.1075>, 0.2069 }
			cylinder { <0.005285, 27.4199, 0.1075>, <0.01018, 27.5151, 0.2073>, 0.2069 }
			  }
		mesh { // leaf
			triangle { <0.01018, 27.5151, 0.2073>, <0.7867, 28.6945, 0.9501>, <0.0287, 28.4236, 1.1941> }
			triangle { <0.0287, 28.4236, 1.1941>, <0.7867, 28.6945, 0.9501>, <1.02181, 29.6441, 1.9386> }
			triangle { <0.0287, 28.4236, 1.1941>, <1.02181, 29.6441, 1.9386>, <0.1194, 29.3186, 2.2933> }
			triangle { <1.02181, 29.6441, 1.9386>, <0.4034, 30.0386, 3.3952>, <0.1194, 29.3186, 2.2933> }
			triangle { <0.0287, 28.4236, 1.1941>, <-0.4658, 28.00355, 1.6703>, <0.01018, 27.5151, 0.2073> }
			triangle { <-0.4658, 28.00355, 1.6703>, <0.0287, 28.4236, 1.1941>, <0.1194, 29.3186, 2.2933> }
			triangle { <-0.3883, 28.7973, 2.8151>, <-0.4658, 28.00355, 1.6703>, <0.1194, 29.3186, 2.2933> }
			triangle { <-0.3883, 28.7973, 2.8151>, <0.1194, 29.3186, 2.2933>, <0.4034, 30.0386, 3.3952> }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.00000001, 27.1687, 0.0>, <-0.001805, 27.3016, -0.03675>, 0.2069 }
			cylinder { <-0.001805, 27.3016, -0.03675>, <-0.005285, 27.4199, -0.1075>, 0.2069 }
			cylinder { <-0.005285, 27.4199, -0.1075>, <-0.01018, 27.5151, -0.2073>, 0.2069 }
			  }
		mesh { // leaf
			triangle { <-0.01018, 27.5151, -0.2073>, <-0.7867, 28.6945, -0.9501>, <-0.0287, 28.4236, -1.1941> }
			triangle { <-0.0287, 28.4236, -1.1941>, <-0.7867, 28.6945, -0.9501>, <-1.02181, 29.6441, -1.9386> }
			triangle { <-0.0287, 28.4236, -1.1941>, <-1.02181, 29.6441, -1.9386>, <-0.1194, 29.3186, -2.2933> }
			triangle { <-1.02181, 29.6441, -1.9386>, <-0.4034, 30.0386, -3.3952>, <-0.1194, 29.3186, -2.2933> }
			triangle { <-0.0287, 28.4236, -1.1941>, <0.4658, 28.00355, -1.6703>, <-0.01018, 27.5151, -0.2073> }
			triangle { <0.4658, 28.00355, -1.6703>, <-0.0287, 28.4236, -1.1941>, <-0.1194, 29.3186, -2.2933> }
			triangle { <0.3883, 28.7973, -2.8151>, <0.4658, 28.00355, -1.6703>, <-0.1194, 29.3186, -2.2933> }
			triangle { <0.3883, 28.7973, -2.8151>, <-0.1194, 29.3186, -2.2933>, <-0.4034, 30.0386, -3.3952> }
			  }
		}
	union { // internode
		cylinder { <-0.00000001, 27.1687, 0.0>, <0.001478, 27.3423, 0.03009>, 0.0705 }
		cylinder { <0.001478, 27.3423, 0.03009>, <0.004392, 27.5083, 0.0894>, 0.0705 }
		cylinder { <0.004392, 27.5083, 0.0894>, <0.008654, 27.6616, 0.1761>, 0.0705 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.008654, 27.6616, 0.1761>, <0.009364, 27.6761, 0.1906>, 0.0307 }
			cylinder { <0.009364, 27.6761, 0.1906>, <0.01023, 27.6862, 0.2084>, 0.0307 }
			cylinder { <0.01023, 27.6862, 0.2084>, <0.01121, 27.6912, 0.2282>, 0.0307 }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.008654, 27.6616, 0.1761>, <0.008898, 27.6815, 0.1811>, 0.0307 }
			cylinder { <0.008898, 27.6815, 0.1811>, <0.008874, 27.7019, 0.1806>, 0.0307 }
			cylinder { <0.008874, 27.7019, 0.1806>, <0.008582, 27.7215, 0.1747>, 0.0307 }
			  }
		}
	union { // internode
		cylinder { <-0.00000001, 27.1687, 0.0>, <-0.001057, 27.2929, -0.02152>, 0.05042 }
		cylinder { <-0.001057, 27.2929, -0.02152>, <-0.003141, 27.4115, -0.06393>, 0.05042 }
		cylinder { <-0.003141, 27.4115, -0.06393>, <-0.006189, 27.5212, -0.1259>, 0.05042 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.006189, 27.5212, -0.1259>, <-0.006704, 27.5317, -0.1364>, 0.02226 }
			cylinder { <-0.006704, 27.5317, -0.1364>, <-0.007338, 27.539, -0.1493>, 0.02226 }
			cylinder { <-0.007338, 27.539, -0.1493>, <-0.008045, 27.5426, -0.1637>, 0.02226 }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.006189, 27.5212, -0.1259>, <-0.006366, 27.5356, -0.1295>, 0.02226 }
			cylinder { <-0.006366, 27.5356, -0.1295>, <-0.006348, 27.5505, -0.1292>, 0.02226 }
			cylinder { <-0.006348, 27.5505, -0.1292>, <-0.006137, 27.5647, -0.1249>, 0.02226 }
			  }
		}
	union { // internode
		cylinder { <-0.00000001, 27.1687, 0.0>, <-0.00000001, 27.7489, 0.0>, 0.232 }
		cylinder { <-0.00000001, 27.7489, 0.0>, <-0.00000001, 28.3291, 0.0>, 0.232 }
		cylinder { <-0.00000001, 28.3291, 0.0>, <-0.00000001, 28.9094, 0.0>, 0.232 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.00000001, 28.9094, 0.0>, <0.01028, 28.968, -0.01253>, 0.0912 }
			cylinder { <0.01028, 28.968, -0.01253>, <0.03011, 29.02015, -0.0367>, 0.0912 }
			cylinder { <0.03011, 29.02015, -0.0367>, <0.05805, 29.06208, -0.07074>, 0.0912 }
			  }
		mesh { // leaf
			triangle { <0.05805, 29.06208, -0.07074>, <0.02429, 29.5819, -0.5431>, <0.344, 29.4625, -0.3984> }
			triangle { <0.344, 29.4625, -0.3984>, <0.02429, 29.5819, -0.5431>, <0.2401, 30.00047, -0.9355> }
			triangle { <0.344, 29.4625, -0.3984>, <0.2401, 30.00047, -0.9355>, <0.6398, 29.8569, -0.7842> }
			triangle { <0.2401, 30.00047, -0.9355>, <0.8732, 30.1743, -1.2282>, <0.6398, 29.8569, -0.7842> }
			triangle { <0.344, 29.4625, -0.3984>, <0.6465, 29.2773, -0.4076>, <0.05805, 29.06208, -0.07074> }
			triangle { <0.6465, 29.2773, -0.4076>, <0.344, 29.4625, -0.3984>, <0.6398, 29.8569, -0.7842> }
			triangle { <0.9601, 29.6272, -0.8044>, <0.6465, 29.2773, -0.4076>, <0.6398, 29.8569, -0.7842> }
			triangle { <0.9601, 29.6272, -0.8044>, <0.6398, 29.8569, -0.7842>, <0.8732, 30.1743, -1.2282> }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.00000001, 28.9094, 0.0>, <-0.01028, 28.968, 0.01253>, 0.0912 }
			cylinder { <-0.01028, 28.968, 0.01253>, <-0.03011, 29.02015, 0.0367>, 0.0912 }
			cylinder { <-0.03011, 29.02015, 0.0367>, <-0.05805, 29.06208, 0.07074>, 0.0912 }
			  }
		mesh { // leaf
			triangle { <-0.05805, 29.06208, 0.07074>, <-0.02429, 29.5819, 0.5431>, <-0.344, 29.4625, 0.3984> }
			triangle { <-0.344, 29.4625, 0.3984>, <-0.02429, 29.5819, 0.5431>, <-0.2401, 30.00047, 0.9355> }
			triangle { <-0.344, 29.4625, 0.3984>, <-0.2401, 30.00047, 0.9355>, <-0.6398, 29.8569, 0.7842> }
			triangle { <-0.2401, 30.00047, 0.9355>, <-0.8732, 30.1743, 1.2282>, <-0.6398, 29.8569, 0.7842> }
			triangle { <-0.344, 29.4625, 0.3984>, <-0.6465, 29.2773, 0.4076>, <-0.05805, 29.06208, 0.07074> }
			triangle { <-0.6465, 29.2773, 0.4076>, <-0.344, 29.4625, 0.3984>, <-0.6398, 29.8569, 0.7842> }
			triangle { <-0.9601, 29.6272, 0.8044>, <-0.6465, 29.2773, 0.4076>, <-0.6398, 29.8569, 0.7842> }
			triangle { <-0.9601, 29.6272, 0.8044>, <-0.6398, 29.8569, 0.7842>, <-0.8732, 30.1743, 1.2282> }
			  }
		}
	union { // internode
		cylinder { <-0.00000001, 28.9094, 0.0>, <-0.00000001, 29.1386, 0.0>, 0.09168 }
		cylinder { <-0.00000001, 29.1386, 0.0>, <-0.00000001, 29.3678, 0.0>, 0.09168 }
		cylinder { <-0.00000001, 29.3678, 0.0>, <-0.00000001, 29.597, 0.0>, 0.09168 }
		  }
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.00000001, 29.597, 0.0>, <-0.006144, 29.6194, 0.0009114>, 0.03493 }
			cylinder { <-0.006144, 29.6194, 0.0009114>, <-0.01798, 29.6394, 0.002668>, 0.03493 }
			cylinder { <-0.01798, 29.6394, 0.002668>, <-0.03467, 29.6555, 0.005143>, 0.03493 }
			  }
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.00000001, 29.597, 0.0>, <0.006144, 29.6194, -0.0009114>, 0.03493 }
			cylinder { <0.006144, 29.6194, -0.0009114>, <0.01798, 29.6394, -0.002668>, 0.03493 }
			cylinder { <0.01798, 29.6394, -0.002668>, <0.03467, 29.6555, -0.005143>, 0.03493 }
			  }
		}
} // end Weed

