default {
  texture {
    pigment { rgb <1,0,0> }
  }
}


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.01, 0.0, 0.09> }

fog {
  fog_type 1    // Constant
  distance     270.0
  color <1.0,0.921569,0.72549,0.0,0.498039>
  turbulence   <0.5,0.5,0.5>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 0.5
}

   #declare camera_location = <0, 0, 40>;
   #declare camera_look_at = <0, 0, 0>;
   #declare effect_scale = .75;

camera {  //  Camera StdCam
  location  camera_location
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   camera_look_at
}                   

#declare glow_type = 2;
#declare effect_location = <2.7, 7, -17>;
#include "lens\LNSEFCTS.INC"

#declare effect_intensity = 3;
#declare effect_rotate = -95;
#declare effect_scale = .2;
#declare spots_type = 8;
#declare spots_to_centre = false; 
#declare spots_spacing = 0.12;
#declare spots_colour =  <1,1,1>;
#declare spots_frequency = .5;
#declare spots_scale = .5;
#include "lens\LNSEFCTS.INC"

//
// *******  L I G H T S *******
//

light_source { // Arealight001
  0.6*<8.000, 20.000, -110.610>
  color rgb <0.957, 0.857, 0.629>
  area_light <0.400, 0.000, 0.000>, <0.000, 0.400, 0.000>, 3, 3
  adaptive 1
  jitter
}

#declare ultrabianco = 
   material  // ultrabianco
   {   
      texture
      {      
         pigment
         {
            color rgb <1.0, 1.0, 1.0>
         }      
         finish
         {
            ambient 1.0
            brilliance 1.203
         }
      }
   }

// distribuisce sferette
#declare SferaBase = sphere {0,1 material{ultrabianco} scale .0065 no_shadow}
#declare N = 200;
#declare I = 0;
#declare tmp = seed(0);
#while (I<N)
        object {
                SferaBase 
                scale 0.88 + 0.22*rand(tmp)
                translate <4-8*rand(tmp),-1.3,30+5*rand(tmp)>
               }
       #declare I = I+1;
#end


//
// ********  MATERIALS  *******
//

#include "materials.inc"


//
// ********  OBJECTS  *******
//

plane { // Cielo
  z,0
  material {
    CieloMaterial
  }
  hollow
  rotate -100.0*x
  translate  50.0*y
}


// Include contains 'Rocciasx6'
#include "roccia2.in1"

#declare Rocciasx6 = object {
  Rocciasx6_Raw
  material {
    T_Stone38
    translate <-5,7,3>
  }
  rotate <0.0, -90.0, 0.0>
  translate  <-12.265461, -1.367366, -14.442223>
}
// Include contains 'Roccia5_trave1'
#include "roccia2.in2"

#declare Roccia5_trave1 = object {
  Roccia5_trave1_Raw
  material {
    T_Stone38
    translate <-3,77,33>
  }
  scale <1.0, 1.0, 1.8>
  translate  <-13.43493, 1.562463, -14.536129>
}
#declare Roccia_tarveSx = union {
  object { Rocciasx6 }
  object { Roccia5_trave1 }
}
// Include contains 'Roccia5_trave'
#include "roccia2.in3"

#declare Roccia5_trave = object {
  Roccia5_trave_Raw
  material {
    T_Stone38
  }
  scale <1.0, 1.0, 1.8>
  translate  <7.846762, 1.562463, -7.913456>
}
// Include contains 'roccia4'
#include "roccia2.in4"

#declare roccia4 = object {
  roccia4_Raw
  material {
    T_Stone38
    translate <2,0,-100>
  }
  rotate 88.597076*y
  translate  <8.009685, -1.412435, -5.932548>
}
#declare RocciaDx = union {
  object { Roccia5_trave }
  object { roccia4 }
  rotate -11.972686*y
  translate  <-0.108562, 0.0, -1.352593>
}
// Include contains 'Roccia1'
#include "roccia2.in5"

#declare Roccia1 = object {
  Roccia1_Raw
  material {
    T_Stone38          
    translate <0,-8,5>
  }
  rotate 15.992484*y
  translate  <2.183391, -1.367366, -1.38085>
}
// Include contains 'Combo1'
#include "roccia2.in6"

#declare Combo1 = object {
  Combo1_Raw
  material {
    T_Stone38        
    translate <-20,-20,15>
  }
  scale <1.0, 0.344947, 1.0>
  rotate <-0.0, -7.247388, -0.0>
  translate  <-1.503237, 1.612188, -1.410728>
}
// Include contains 'Roccia2_Centro'
#include "roccia2.in7"

#declare Roccia2_Centro = object {
  Roccia2_Centro_Raw
  material {
    T_Stone38            
    translate <10,-10,0>
  }
  translate  <-1.536775, -1.393603, -1.24934>
}
// Include contains 'roccia3'
#include "roccia2.in8"

#declare roccia3 = object {
  roccia3_Raw
  material {
    T_Stone38          
    translate <5,-2,-9>
  }
  rotate 37.23407*y
  translate  <5.734872, -1.412435, -2.737179>
}
// Include contains 'TraveCurva'
#include "roccia2.in9"

#declare TraveCurva = object {
  TraveCurva_Raw
  material {
    T_Stone38
    translate <5,0,-3>
  }
  scale <1.0, 1.0, 0.5>
  rotate <-90.0, 66.171661, -180.0>
  translate  <-0.142987, 2.122006, -0.436429>
}
// Include contains 'roccia5'
#include "roccia2.i10"

#declare roccia5 = object {
  roccia5_Raw
  material {
    T_Stone38 
    translate <15,70,-2>
  }
  rotate <180.0, 25.554489, 180.0>
  translate  <9.014639, -1.412435, -14.888864>
}
// Include contains 'Rocciasx2'
#include "roccia2.i11"

#declare Rocciasx2 = object {
  Rocciasx2_Raw
  material {
    T_Stone38
    translate <6,-3,-1>
  }
  rotate -21.334152*y
  translate  <-5.467504, -1.367366, -2.628278>
}
// Include contains 'Rocciasx3'
#include "roccia2.i12"

#declare Rocciasx3 = object {
  Rocciasx3_Raw
  material {
    T_Stone38
    translate <7,-14,-88>
  }
  rotate -49.15955*y
  translate  <-8.378171, -1.367366, -5.039973>
}
// Include contains 'Rocciasx4'
#include "roccia2.i13"

#declare Rocciasx4 = object {
  Rocciasx4_Raw
  material {
    T_Stone38
    translate <0,-16,-13.3>
  }
  rotate <0.0, -58.361057, -0.0>
  translate  <-10.124544, -1.367366, -7.53411>
}
// Include contains 'Rocciasx5'
#include "roccia2.i14"

#declare Rocciasx5 = object {
  Rocciasx5_Raw
  material {
    T_Stone38
    translate <-8,-6,-5>
  }
  rotate <0.0, -72.026772, -0.0>
  translate  <-11.359816, -1.367366, -10.717696>
}
// Include contains 'Altare'
#include "roccia2.i15"

#declare Altare = object {
  Altare_Raw
  material {
    T_Stone38
    translate <0,0.7,1.2>
  }
  translate  <-3.745206, -1.562834, -9.959721>
}

union { // Stones
  object { Roccia_tarveSx }
  object { RocciaDx }
  object { Roccia1 }
  object { Combo1 }
  object { Roccia2_Centro }
  object { roccia3 }
  object { TraveCurva }
  object { roccia5 }
  object { Rocciasx2 }
  object { Rocciasx3 }
  object { Rocciasx4 }
  object { Rocciasx5 }
  object { Altare }
  scale <1.0, 1.2, 1.0>
  translate  <0.380949, 0.280052, 0.101781>
}


plane { // Terreno
  z,0
  material {
    NeveTerreno
  }
  hollow
  scale -10.856307
  rotate -90.0*x
  translate  <-5.47511, -1.3, 35.60096>
}

