// Persistence of Vision Raytracer Version 3.1
//
// file: village.pov      author: -- jd --      version: 240200
// The flooded ruins of a drowned village

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "woods.inc"

camera
{
    location  <13, 18, 13>
    direction <0, 0, 1>
    up        <0, 1, 0>
    right     <4/3, 0, 0>
    look_at   <0, 17, 1>
 // ultra_wide_angle
 // angle 240
}

// sphere {  <13, 17, 13>, 2 pigment { color Red } }

light_source
{
    0*x color Gray95
    area_light <10, 0, 0>, <0, 0, 10>, 5, 5
    adaptive 1
    jitter

    translate <50, 125, 150>
    // media_attenuation on
}


#declare Sky = sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.2  color Gray95]
      [1.0  color Gray70]
    }
    scale 2
    translate <-1, -1, -1>
  }
  pigment {
    bozo
    turbulence 0.6
    octaves 7
    omega .49976
    lambda 2.5432
    color_map {
      [0.0 color rgbf<.75, .75, .75, 0.1>]
      [0.6 color rgbf<.9, .9, .9, .95>]
      [0.9 color rgbf<1.0, 1.0, 1.0, 1>]
    }
    scale 4/10
    scale <1, 0.3, 0.3>
  }
  pigment {
    bozo
    turbulence 0.6
    octaves 8
    omega .5113
    lambda 2.56578
    color_map {
      [0.0 color rgbf<.5, .5, .5, 0.2>]
      [0.5 color rgbf<.6, .6, .6, .9>]
      [0.7 color rgbf<.7, .7, .7, 1>]
    }
    scale 4/10
    scale <1, 0.3, 0.3>
  }
}

sky_sphere { Sky rotate -75 }

fog { distance 1000.0 color rgbt<0.9, 0.9, 0.9, 0.5> }
fog { distance 2000.0 fog_type 2 fog_offset 5 fog_alt 10 color rgb<0.75, 0.75, 0.75> }

plane
{   y, 0
    translate y*6
    pigment { color rgbt <0.6, 0.61, 0.7, 0.4> }
    normal { ripples 0.5 scale 1.8 }
    finish { ambient .1 diffuse .2 reflection .2 }
}
plane
{   y, 0
    translate y*-3
    pigment { color rgb <0.2, 0.21, 0.3> }
    normal { ripples 0.9 scale 2 translate z*100 }
    finish { ambient .3 diffuse .4 }
}

height_field {
    png "village.png"
    smooth
    pigment
    {
        bozo
        colour_map
         {
         [.250 colour rgb <.1, .2, .1>    ]
         [.251 colour rgb <.4, .1, .1>    ]
         [.252 colour rgb <.1, .3, .1>    ]
         [.5   colour rgb <.2, .3, .2>    ]
         [.6   colour rgb <0, .35, 0>     ]
         [.8   colour rgb <.3, .45, .0>   ]
         [1.01 colour rgb <.43, .11, .11> ]
         }

        turbulence .7
        scale 0.1
    }
    normal { bumps 0.7 scale 2 }
    finish { diffuse .4 }

    scale <800, 50, 800>
    translate <-500, -10, -500>
}

#include "tree1.pov"
#include "tree2.pov"
#include "tree3.pov"
#include "tree4.pov"

object { Tree1 rotate y*-45 translate z*5 translate x*-14 translate y*8
 // sphere { <-14, 15, 5>, 4
    pigment { Orange }
    texture { T_Wood33 }
    normal { bumps 0.7 scale 0.2 }
}
object { Tree2 translate z*-40 translate x*-10 translate y*6
 // sphere { <-10, 15, -40>, 4
    pigment { Blue }
    texture { T_Wood31 }
    normal { bumps 0.7 scale 0.2 }
}
object { Tree3 translate z*-115 translate x*-25 translate y*2
 // sphere { <-25, 15, -115>, 4
    pigment { Violet }
    texture { T_Wood31 }
    normal { bumps 0.7 scale 0.2 }
}
object { Tree4 translate x*-110 translate z*-50
 // sphere { <-110, 15, -50>, 4
    pigment { Yellow }
    texture { T_Wood33 }
    normal { bumps 0.7 scale 0.2 }
}
object { Tree1 rotate y*90 translate x*-158 translate z*-165 translate y*6 
 // sphere { <-158, 15, -165>, 4
    pigment { Green }
    texture { T_Wood31 }
    normal { bumps 0.7 scale 0.2 }
}
object { Tree4 rotate y*170 translate x*-175 translate z*-160 translate y*16.5
 // sphere { <-175, 17, -160>, 4
    pigment { Sienna }
    texture { T_Wood3 }
    normal { bumps 0.7 scale 0.2 }
}
object { Tree2 rotate y*-155 translate x*-150 translate z*-120 translate y*13 
 // sphere { <-150, 17, -120>, 4
    pigment { Coral }
    texture { T_Wood3 }
    normal { bumps 0.7 scale 0.2 }
}
object { Tree3 rotate y*-33 translate z*-30 translate x*-15 translate y*5.75
 // sphere { <-15, 15, -30>, 4
    pigment { SkyBlue }
    texture { T_Wood31 }
    normal { bumps 0.7 scale 0.2 }
}

// a tree that becomes weeds
object { tree3 rotate y*45 rotate z*15 scale <1.25,2,1.5> translate <-0,-5,-0>
 // sphere { <-0, 15, -0>, 4
    pigment { LimeGreen }
    texture { T_Wood3 }
    normal { dents 0.4 scale 0.2 }
}
// another tree that becomes weeds
object { tree4 rotate y*90 rotate z*15 scale <1,2,1.75> translate <0,-5.25,-20>
 // sphere { < 0, 15, -20>, 4
    pigment { Plum }
    texture { T_Wood3 }
    normal { dents 0.4 scale 0.2 }
}

union
{   // church
difference
{   // main church part
    box { <-60, -3, -40>, <-45, 5.95, -30> }
    box { <-59.5, -3, -39.5>, <-45.5, 6.5, -30.5> }
    box { <-60.1, 5.85, -31.5>, <-58.5, 6.5, -29.9> }
    box { <-60.1, 5.80, -31.25>, <-58.0, 6.5, -29.9> }
    box { <-61, -3, -34.4>, <-59, -1, -35.6> }
    cylinder { <-61, -1, -35>, <-59, -1, -35>, 0.6 }
    // window breakthroughs
    box { <-55.5, 0, -41>, <-57.5, 4, -29> }
    cylinder { <-56.5, 4, -41>, <-56.5, 4, -29>, 1 }
    box { <-51.5, 0, -41>, <-53.5, 4, -29> }
    cylinder { <-52.5, 4, -41>, <-52.5, 4, -29>, 1 }
    box { <-47.5, 0, -41>, <-49.5, 4, -29> }
    cylinder { <-48.5, 4, -41>, <-48.5, 4, -29>, 1 }
    box { <-61, 2.4, -33.4>, <-59, 4.4, -34.6> }
    cylinder { <-61, 4.4, -34>, <-59, 4.4, -34>, 0.6 }
    box { <-61, 2.4, -35.4>, <-59, 4.4, -36.6> }
    cylinder { <-61, 4.4, -36>, <-59, 4.4, -36>, 0.6 }
    
    pigment { Gray60 }
    normal { bumps 0.2 scale 0.7 }
    finish  { ambient 0.05 }
}
difference
{   // church tower
    box { <-40, -3, -32.5>, <-45, 12, -37.5> }
    box { <-40.5, -3, -33>, <-44.5, 12.5, -37> }
    box { <-40.6, 8.5, -34.4>, <-39.6, 10.5, -35.6> }
    cylinder { <-40.6, 10.5, -35>, <-39.6, 10.5, -35>, 0.6 }
    box { <-45.6, -3, -34.4>, <-39.6, -1, -35.6> }
    cylinder { <-45.6, -1, -35>, <-39.6, -1, -35>, 0.6 }
    cylinder { <-42.5, 9.5, -32.6>, < -42.5 ,9.5, -32.49>, 1.25 }
    cylinder { <-42.5, 9.5, -37.4>, < -42.5 ,9.5, -37.51>, 1.25 }
    box { <-42.25, 8.0, -32.4>, <-42.75, 6.5, -37.6> }
    box { <-42.00, 8.0, -32.4>, <-41.50, 6.5, -37.6> }
    box { <-43.00, 8.0, -32.4>, <-43.50, 6.5, -37.6> }
    pigment { Gray65 }
    normal { bumps 0.2 scale 0.7 }
    finish  { ambient 0.05 }
}
cylinder
{   
    <-42.5, 9.5, -32.6>, < -42.5 ,9.5, -32.55>, 1.25
    pigment { White }
    finish  { ambient 0.3 }
    normal { bumps 0.7 scale 0.8 }
}
difference
{   
    cylinder { <-42.5, 9.5, -32.55>, < -42.5 ,9.5, -32.545>, 1 }
    cylinder { <-42.5, 9.5, -32.65>, < -42.5 ,9.5, -32.525>, 0.95 }
    pigment { Gray40 }
}
cylinder
{   
    <-42.5, 9.5, -32.55>, < -42.5 ,9.5, -32.52>, 0.075
    pigment { Gray10 }
}
union 
{   // dial marker
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*30 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*60 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*90 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*120 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*150 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*180 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*210 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*240 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*270 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*300 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*330 }
    translate <-42.5, 9.5, -32.55> pigment  { Gray10  }
}
cylinder
{  
    <-42.5, 9.5, -37.4>, < -42.5 ,9.5, -37.45>, 1.25
    pigment  { White }
    finish  { ambient 0.3 }
    normal { bumps 0.7 scale 0.8 }
}
difference
{   cylinder {  <-42.5, 9.5, -37.45>, < -42.5 ,9.5, -37.455>, 1 }
    cylinder {  <-42.5, 9.5, -37.35>, < -42.5 ,9.5, -37.475>, 0.95 }
    pigment  { Gray30  }
}
cylinder
{  
    <-42.5, 9.5, -37.45>, < -42.5 ,9.5, -37.48>, 0.075
    pigment  { Gray10  }
}
union 
{   // dial marker
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*30 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*60 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*90 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*120 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*150 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*180 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*210 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*240 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*270 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*300 }
    box { <-0.02, 1.0, -0.02>, <0.02, 1.15, 0.02> rotate z*330 }
    translate <-42.5, 9.5, -37.45> pigment { Gray10 }
}

    translate y*2
}


#declare house =
union
{   // house
    difference
    { 
        box { <-2.5, -3, -3.5>, <2.5,  0, 3.5> }
        box { <-2.3, -3, -3.3>, <2.3,  1, 3.3> }
        box { <-0.5, -3, -3.6>, <-0.5, -1, -3.2> } // door
        box { <-1.0, -2, -3.6>, <-2.0, -0.5, -3.2> }
        box { <-2.6, -2, -3.0>, < 2.6, -0.5,-2.0> }
        box { <-2.6, -2,  3.0>, < 2.6, -0.5, 2.0> }
        box { <-2.6, -2, -1.333>, < 2.6, -0.5, -0.333> }
        box { <-2.6, -2, 1.333>, < 2.6, -0.5, 0.333> }
    }
    difference
    { 
        box { <-2.5, -3, -3.5>, <2.5,  0, 3.5> }
        box { <-2.3, -3, -3.3>, <2.3,  1, 3.3> }
        box { <-0.0, -5, -3.6>, <  5,  1, 3.6> rotate z*45 }
        box { <-5  , -5, -3.6>, <0.0,  1, 3.6> rotate z*-45 }

        translate y*3
    }
    difference
    { 
        box { <-0.3, -3,  2.7>, <0.3,  3.125, 3.3> }
        box { <-0.1, -3,  2.9>, <0.1,  4, 3.1> }
    }
}

object
{   house // tree plaza 1
    scale 0.9 
    rotate y*45
    translate x*-40 translate y*5 translate z*-60
    pigment { Gray25 }
    normal { bumps 0.4 scale 0.45 }
    finish  { ambient 0.1 }
}

object
{   house // high ave 1
    scale 0.9
    rotate y*90
    translate x*-140 translate y*4.75 translate z*-35
    pigment { Gray65 }
    normal { bumps 0.3 scale 0.5 }
    finish  { ambient 0.1 }
}

object
{   house // high ave 3
    scale 0.9
    rotate y*90
    translate x*-140 translate y*4.75 translate z*-25
    pigment { Gray65 }
    normal { bumps 0.3 scale 0.5 }
    finish  { ambient 0.1 }
}

object
{   house // high ave 5
    scale 0.9 
    rotate y*90
    translate x*-140 translate y*4.5 translate z*-15
    pigment { Gray55 }
    normal { bumps 0.3 scale 0.5 }
    finish  { ambient 0.1 }
}

object
{   house // high ave 2
    scale 0.9 
    rotate y*-90
    translate x*-120 translate y*4.75 translate z*-20
    pigment { Gray80 }
    normal { bumps 0.2 scale 0.5 }
    finish  { ambient 0.1 }
}

object
{   house // high ave 4
    scale 0.9
    rotate y*-90
    translate x*-120 translate y*5 translate z*-10
    pigment { Gray65 }
    normal { bumps 0.2 scale 0.5 }
    finish  { ambient 0.1 }
}

object
{   house // church lane 1
    translate x*-20 translate y*5 translate z*-45
    pigment { Gray45 }
    normal { bumps 0.3 scale 0.4 }
    finish  { ambient 0.05 }
}

object
{   house // post st. 1
    rotate y*45
    translate x*-55 translate z*-10 translate y*5.5
    pigment { Gray40 }
    normal { bumps 0.4 scale 0.45 }
    finish  { ambient 0.1 }
}

