/*******************************************************
Scene Description:
This is a scene at the beach.
The children are playing on the beach and they have 
built a sandcastle. Feeling proud with thier work, 
they go into the water to have a swim. But when they
arrive back, they find that the only thing left is the
ruins that are left by the waves as they rushed over
thier wonderful sandcastle.

Files used:

Ruins.pov       (This file)
Ruins.inc       (Includes all the objects and textures for the scene)
Hf_01.tga       (For the sandy ground)

********************************************************/
/*******************************************
        Trace Control:
*******************************************/        

/*      If you turn some of these things off, POV-Ray will skip the
        source code, making it parse faster.
        
        To make a real 3D Picture (Like the magic eye's):
                1. Render with ThreeDeeCam as 1 and place on left side of picture.
                2. Render with ThreeDeeCam as 2 and place on right side of picture.
                3. To see it, go cross-eyed and just focus on the center picture.
*/

                                //1 for 1st stage of 3D camera (Left)
#declare ThreeDeeCam=3;         //2 for 2nd stage of 3D camera (Right)
                                //3 for 2D camera (3D off & Single Picture).

#declare Trace_Spade=           on;
#declare Trace_Bucket=          on;
#declare Trace_Ocean=           on;
#declare Trace_Sun=             on;
#declare Trace_Ground=          on;
#declare Trace_Sky=             on;
#declare Trace_Sand_Castle=     on;
#declare Trace_Fill_Light=      off;
/******************************************/

#debug "\n Let The Parsing Begin! \n"

 #include "mine\Ruins.inc"   //textures and objects defined by me.

/*******************************************
        OBJECTS:
*******************************************/        
#if (Trace_Ocean=on)
object{Ocean translate 0.5*y}
#end

#if (Trace_Bucket=on)
object{Bucket rotate <90,-45,0> translate <5,0.75,0>}
#end

#if (Trace_Spade=on)
object{Spade rotate -60*x translate <3,-0.5,0>}
#end

#if (Trace_Ground=on)
object{Sandy_Ground rotate 10*x}
#end

#if (Trace_Sky=on)
sky_sphere{Sky}
#end

#if (Trace_Sand_Castle=on)
object{Sand_Castle 
rotate -10*y
rotate 15*x
translate<0,0,-4>
}
#end

/*******************************************
        Lights, Camera, ACTION!
*******************************************/        
/*          Camera Stuff:
includes the positions for real 3D rendering (controlled by the switch at the top)
*/

#declare CamPos3DLeft=<-1.5,5,10>;
#declare CamPos3DRight=<-1,5,10>;
#declare ThreeDLookAt=<-0.35,1.5,-2>;

#declare TD_CamL=
camera{location CamPos3DLeft look_at ThreeDLookAt}
#declare TD_CamR=
camera{location CamPos3DRight look_at ThreeDLookAt}

#declare Normal_Cam=camera{location Cam_Pos look_at Look_At}

#if (ThreeDeeCam=1)
   camera{TD_CamL}
#else
   #if (ThreeDeeCam=2)
      camera{TD_CamR}
   #else
      #if (ThreeDeeCam=3)
         camera{Normal_Cam}
      #end
   #end
#end
/*************************************/
#if (Trace_Sun=on) 
 object{Sun_Source}
#end

#if (Trace_Fill_Light=on)
 light_source{<0,20,10>color rgb 1}//fill light
#end

#debug "\n Now that everything's been parsed, we can start the rendering!\n"